/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.EntityBean;
import oracle.oc4j.admin.deploy.model.xml.MessageDrivenBean;
import oracle.oc4j.admin.deploy.model.xml.SessionBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EnterpriseBeansBean
extends BeanNode {
    public EnterpriseBeansBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "enterprise-beans" + ">");
        EnterpriseBeansBean.writeAll(this.getChildBean("session"), out, indentation + "\t");
        EnterpriseBeansBean.writeAll(this.getChildBean("entity"), out, indentation + "\t");
        EnterpriseBeansBean.writeAll(this.getChildBean("message-driven"), out, indentation + "\t");
        out.println(indentation + "</" + "enterprise-beans" + ">");
    }

    private void init(Node rootNode) {
        this.setXpath("enterprise-beans");
        Vector<SessionBean> sessions = new Vector<SessionBean>();
        Vector<SessionBean> entities = new Vector<SessionBean>();
        Vector<SessionBean> messageDrivens = new Vector<SessionBean>();
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            BeanNode bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("session")) {
                bean = new SessionBean(node, this);
                sessions.add((SessionBean)bean);
            }
            if (name.equals("entity")) {
                bean = new EntityBean(node, this);
                entities.add((SessionBean)bean);
            }
            if (!name.equals("message-driven")) continue;
            bean = new MessageDrivenBean(node, this);
            messageDrivens.add((SessionBean)bean);
        }
        this.recordXpathForBeans("session", sessions);
        this.recordXpathForBeans("entity", entities);
        this.recordXpathForBeans("message-driven", messageDrivens);
    }
}

