/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EjbRefBean
extends BeanNode {
    public EjbRefBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getDescription() {
        return this.nodeValue("description");
    }

    public String getEjbRefName() {
        return this.nodeValue("ejb-ref-name");
    }

    public String getEjbRefType() {
        return this.nodeValue("ejb-ref-type");
    }

    public String getHome() {
        return this.nodeValue("home");
    }

    public String getRemote() {
        return this.nodeValue("remote");
    }

    public String getEjbLink() {
        return this.nodeValue("ejb-link");
    }

    public String jtreeToolTip() {
        return "EJB Reference";
    }

    public String toString() {
        String val = this.getEjbLink();
        if (val == null || val.equals("")) {
            val = this.getEjbRefName();
        }
        return val;
    }

    protected boolean leaf() {
        return true;
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "ejb-ref" + ">");
        EjbRefBean.writeAll(this.getChildBean("description"), out, indentation + "\t");
        EjbRefBean.writeAll(this.getChildBean("ejb-ref-name"), out, indentation + "\t");
        EjbRefBean.writeAll(this.getChildBean("ejb-ref-type"), out, indentation + "\t");
        EjbRefBean.writeAll(this.getChildBean("home"), out, indentation + "\t");
        EjbRefBean.writeAll(this.getChildBean("remote"), out, indentation + "\t");
        EjbRefBean.writeAll(this.getChildBean("ejb-link"), out, indentation + "\t");
        out.println(indentation + "</" + "ejb-ref" + ">");
    }

    private void init(Node rootNode) {
        this.setXpath("ejb-ref");
        Vector<StringBean> description = new Vector<StringBean>(1);
        Vector<StringBean> ejbRefName = new Vector<StringBean>(1);
        Vector<StringBean> ejbRefType = new Vector<StringBean>(1);
        Vector<StringBean> home = new Vector<StringBean>(1);
        Vector<StringBean> remote = new Vector<StringBean>(1);
        Vector<StringBean> ejbLink = new Vector<StringBean>(1);
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            StringBean bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("description")) {
                bean = new StringBean(node, this, "description");
                description.add(bean);
            }
            if (name.equals("ejb-ref-name")) {
                bean = new StringBean(node, this, "ejb-ref-name");
                ejbRefName.add(bean);
            }
            if (name.equals("ejb-ref-type")) {
                bean = new StringBean(node, this, "ejb-ref-type");
                ejbRefType.add(bean);
            }
            if (name.equals("home")) {
                bean = new StringBean(node, this, "home");
                home.add(bean);
            }
            if (name.equals("remote")) {
                bean = new StringBean(node, this, "remote");
                remote.add(bean);
            }
            if (!name.equals("ejb-link")) continue;
            bean = new StringBean(node, this, "ejb-link");
            ejbLink.add(bean);
        }
        this.recordXpathForBeans("description", description);
        this.recordXpathForBeans("ejb-ref-name", ejbRefName);
        this.recordXpathForBeans("ejb-ref-type", ejbRefType);
        this.recordXpathForBeans("home", home);
        this.recordXpathForBeans("remote", remote);
        this.recordXpathForBeans("ejb-link", ejbLink);
    }
}

