/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.file;

import java.io.File;
import java.io.InputStream;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.model.XpathListener;
import javax.enterprise.deploy.shared.ModuleType;
import oracle.oc4j.admin.deploy.model.file.EarFile;
import oracle.oc4j.admin.deploy.model.file.J2eeFile;
import oracle.oc4j.admin.deploy.model.xml.BeanRootNode;
import oracle.oc4j.admin.deploy.model.xml.EjbStdXml;
import oracle.oc4j.admin.deploy.model.xml.WSStdXml;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;
import oracle.xml.parser.v2.XMLDocument;

public class EjbFile
extends J2eeFile
implements DeployableObject {
    public EjbFile(File ejbfile) throws ExtendedRuntimeException {
        this(ejbfile, null, null, false);
    }

    public EjbFile(File ejbfile, boolean dtdValidation) throws ExtendedRuntimeException {
        this(ejbfile, null, null, dtdValidation);
    }

    public EjbFile(File ejbfile, String jarEntry, EarFile parent, boolean dtdValidation) throws ExtendedRuntimeException {
        this(ejbfile, null, jarEntry, parent, dtdValidation);
    }

    public EjbFile(String altDD, String jarEntry, EarFile parent, boolean dtdValidation) throws ExtendedRuntimeException {
        this(null, altDD, jarEntry, parent, dtdValidation);
    }

    public EjbFile(File ejbfile, String altDD, String jarEntry, EarFile parent, boolean dtdValidation) throws ExtendedRuntimeException {
        super(ejbfile, jarEntry, parent, dtdValidation);
        this.init(altDD);
    }

    public ModuleType getType() {
        return ModuleType.EJB;
    }

    public void addXpathListener(ModuleType type, String xpath, XpathListener xpl) {
    }

    public void removeXpathListener(ModuleType type, String xpath, XpathListener xpl) {
    }

    public boolean checkStdXml(BeanRootNode stdXml) {
        return this.checkParam(stdXml, "oracle.oc4j.admin.deploy.model.xml.EjbStdXml");
    }

    public String getStdXmlEntry() {
        return "META-INF/ejb-jar.xml";
    }

    public static EjbFile copy(InputStream inStrm) throws ExtendedRuntimeException {
        try {
            File tmpEjb = File.createTempFile("dep", ".ejb");
            EjbFile.copyStreamToFile(inStrm, tmpEjb);
            EjbFile ret = new EjbFile(tmpEjb);
            ret._tmpFile = true;
            return ret;
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    private void init(String altDD) throws ExtendedRuntimeException {
        try {
            File ejbFile = this.getFile();
            XMLDocument doc = null;
            doc = altDD == null ? (ejbFile != null ? this.getXmlDocument(this.getStdXmlEntry()) : this.getXmlDocument(this.getURI(), this.getStdXmlEntry())) : this.getParent().getXmlDocument(altDD);
            if (doc == null) {
                doc = EjbStdXml.createMinimumStdXml();
            }
            if (doc == null) {
                if (altDD == null) {
                    if (ejbFile == null) {
                        throw new ExtendedRuntimeException(FormattingResourceBundle.DeploymentMessages.getString("missingStdDesc", new String[]{this._entryName, this.getStdXmlEntry()}));
                    }
                    throw new ExtendedRuntimeException(FormattingResourceBundle.DeploymentMessages.getString("missingStdDesc", new String[]{ejbFile.getAbsolutePath(), this.getStdXmlEntry()}));
                }
                throw new ExtendedRuntimeException(FormattingResourceBundle.DeploymentMessages.getString("missingStdDesc", new String[]{this.getParent().getFile().getAbsolutePath(), altDD}));
            }
            this.setStdXml(new EjbStdXml(doc, this));
            doc = ejbFile != null ? this.getXmlDocument(this.getWSStdXmlEntry()) : this.getXmlDocument(this.getURI(), this.getWSStdXmlEntry());
            if (doc != null) {
                this.setWSStdXml(new WSStdXml(doc, this));
            }
        }
        catch (ExtendedRuntimeException ExT) {
            this.close();
            throw ExT;
        }
        catch (Throwable t) {
            this.close();
            throw new ExtendedRuntimeException(t);
        }
    }
}

