/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Hashtable;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import oracle.oc4j.admin.deploy.gui.CreationException;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.gui.GuiUtil;
import oracle.oc4j.admin.deploy.gui.ViewableJTree;
import oracle.oc4j.admin.deploy.gui.ViewableJTreeNode;

public class TreeViewPane
extends JPanel
implements TreeSelectionListener {
    protected ViewableJTree _tree = null;
    protected JScrollPane _treePanel;
    protected JScrollPane _viewPanel;
    protected Hashtable _nodeViews = new Hashtable();

    public TreeViewPane(int treeWidth, int viewWidth, int height) {
        this.setLayout(new BorderLayout());
        this._treePanel = new JScrollPane();
        this._treePanel.setPreferredSize(new Dimension(treeWidth, height));
        this._treePanel.getViewport().setBackground(Deployer.TreeBackgroundColor);
        this._viewPanel = new JScrollPane();
        this._viewPanel.setPreferredSize(new Dimension(viewWidth, height));
        this._viewPanel.getViewport().setBackground(Deployer.ViewBackgroundColor);
        JSplitPane splitPane = new JSplitPane(1, this._treePanel, this._viewPanel);
        splitPane.setContinuousLayout(true);
        splitPane.setResizeWeight((float)treeWidth / (float)(treeWidth + viewWidth));
        splitPane.setDividerSize(5);
        this.add((Component)splitPane, "Center");
    }

    public void setTree(ViewableJTree tree) {
        if (tree == null) {
            this.clear();
        } else {
            this._tree = tree;
            this._tree.setBackground(Deployer.TreeBackgroundColor);
            this._tree.addTreeSelectionListener(this);
            this._treePanel.setViewportView(this._tree);
            ViewableJTreeNode node = this._tree.getRootNode();
            if (!this._tree.isRootVisible() && node.getChildCount() > 0) {
                node = (ViewableJTreeNode)node.getChildAt(0);
            }
            try {
                this._viewPanel.setViewportView(node.viewComponent());
            }
            catch (CreationException ce) {
                GuiUtil.errDialog("Error creating view for node " + node);
                ce.printStackTrace();
                this._viewPanel.setViewportView(new JPanel());
            }
        }
    }

    protected void clear() {
        if (this._tree == null) {
            return;
        }
        this._tree = null;
        this._nodeViews.clear();
        this._treePanel.setViewportView(null);
        this._viewPanel.setViewportView(null);
    }

    public void valueChanged(TreeSelectionEvent e) {
        if (this._tree.getLastSelectedPathComponent() != null) {
            ViewableJTreeNode node = (ViewableJTreeNode)this._tree.getLastSelectedPathComponent();
            try {
                this._viewPanel.setViewportView(node.viewComponent());
            }
            catch (CreationException ce) {
                GuiUtil.errDialog("Error creating view for node " + node);
                ce.printStackTrace();
                this._viewPanel.setViewportView(new JPanel());
            }
        }
    }
}

