/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.management.ObjectName;
import javax.management.j2ee.Management;
import oracle.oc4j.admin.deploy.gui.AppDataSourceRootNode;
import oracle.oc4j.admin.deploy.gui.DescriptorNode;
import oracle.oc4j.admin.deploy.gui.EJBModuleRootNode;
import oracle.oc4j.admin.deploy.gui.JavaMailRootNode;
import oracle.oc4j.admin.deploy.gui.SecurityNode;
import oracle.oc4j.admin.deploy.gui.WebModuleRootNode;
import oracle.oc4j.admin.deploy.spi.ProprietaryTargetModuleID;

public class TargetModuleNode
extends DescriptorNode {
    protected TargetModuleID _moduleID;
    protected Management _mejb;
    protected String _targetName;
    protected String _standardDescriptor;
    protected String _oracleDescriptor;
    protected String _standardWSDescriptor;
    protected String _oracleWSDescriptor;
    protected String _parentIdString;
    protected String _idString;
    protected boolean _isLeaf;
    protected String _name;
    protected String _viewHeader;
    protected ModuleType _moduleType;

    public TargetModuleNode(TargetModuleID id) {
        this(null, id);
    }

    public TargetModuleNode(Management mejb, TargetModuleID id) {
        this._moduleID = id;
        this._mejb = mejb;
        this._idString = this._moduleID.getModuleID();
        this._parentIdString = this._moduleID.getParentTargetModuleID() == null ? null : this._moduleID.getParentTargetModuleID().getModuleID();
        this._targetName = this._moduleID.getTarget().getName();
        this._isLeaf = this._moduleID.getChildTargetModuleID() == null;
        ProprietaryTargetModuleID pid = (ProprietaryTargetModuleID)this._moduleID;
        this._name = pid.getObjectName().getKeyProperty("name");
        this._idString = pid.getObjectName().getKeyProperty("j2eeType");
        if (this._idString.equals("EJBModule")) {
            this._viewHeader = this.getName() + "   (EJB Module)";
            this._moduleType = ModuleType.EJB;
            this._standardWSDescriptor = pid.getStandardWSDeploymentDescriptor();
            this._oracleWSDescriptor = pid.getProprietaryWSDeploymentDescriptor();
        } else if (this._idString.equals("AppClientModule")) {
            this._viewHeader = this.getName() + "   (Client Module)";
            this._moduleType = ModuleType.CAR;
        } else if (this._idString.equals("ResourceAdapterModule")) {
            this._viewHeader = this.getName() + "   (Resource Module)";
            this._moduleType = ModuleType.RAR;
        } else if (this._idString.equals("WebModule")) {
            this._viewHeader = this.getName() + "   (Web Module)";
            this._moduleType = ModuleType.WAR;
            this._standardWSDescriptor = pid.getStandardWSDeploymentDescriptor();
            this._oracleWSDescriptor = pid.getProprietaryWSDeploymentDescriptor();
        } else {
            this._viewHeader = this.getName() + "   (Application Module)";
            this._moduleType = ModuleType.EAR;
        }
        this._standardDescriptor = pid.getStandardDeploymentDescriptor();
        this._oracleDescriptor = pid.getProprietaryDeploymentDescriptor();
    }

    protected boolean isRootNode() {
        return this._parentIdString == null;
    }

    public String getModuleID() {
        return this._idString;
    }

    public String getTarget() {
        return this._targetName;
    }

    public String viewHeaderString() {
        return this._viewHeader;
    }

    public ModuleType retrieveModuleType() {
        return this._moduleType;
    }

    public void buildChildJTree() {
        this.addJTreeChild(new WebModuleRootNode(this._moduleID, this._name));
        this.addJTreeChild(new EJBModuleRootNode(this._moduleID, this._name));
        this.addJTreeChild(new AppDataSourceRootNode(this._moduleID, this._name));
        this.addJTreeChild(new JavaMailRootNode(this._moduleID, this._name));
        this.addJTreeChild(new SecurityNode(this._moduleID, this._name));
        TargetModuleID[] kids = this._moduleID.getChildTargetModuleID();
        if (kids == null) {
            return;
        }
        for (int k = 0; k < kids.length; ++k) {
            if (kids[k].getModuleID().indexOf("WebModule") >= 0 || kids[k].getModuleID().indexOf("EJBModule") >= 0) continue;
            this.addJTreeChild(new TargetModuleNode(this._mejb, kids[k]));
        }
    }

    public String retrieveStandardDescriptor() {
        return this._standardDescriptor;
    }

    public String retrieveOracleDescriptor() {
        return this._oracleDescriptor;
    }

    public String retrieveStandardWSDescriptor() {
        return this._standardWSDescriptor;
    }

    public String retrieveOracleWSDescriptor() {
        return this._oracleWSDescriptor;
    }

    protected TargetModuleID getTargetModuleID() {
        return this._moduleID;
    }

    protected String getName() {
        return this._name;
    }

    protected String getParentID() {
        return this._parentIdString;
    }

    protected boolean leaf() {
        return this._isLeaf;
    }

    public String toString() {
        return this._name;
    }

    public TargetModuleID[] getAllTargetModuleIDs() {
        return new TargetModuleID[]{this._moduleID};
    }

    public boolean containsTargetModuleID(TargetModuleID id) {
        TargetModuleID[] ids = this.getAllTargetModuleIDs();
        for (int i = 0; i < ids.length; ++i) {
            if (!ids[i].equals(id)) continue;
            return true;
        }
        return false;
    }

    public boolean containsApplication(String appName) {
        TargetModuleID[] ids = this.getAllTargetModuleIDs();
        for (int i = 0; i < ids.length; ++i) {
            ObjectName on = ((ProprietaryTargetModuleID)ids[i]).getObjectName();
            if (!on.getKeyProperty("name").equals(appName)) continue;
            return true;
        }
        return false;
    }
}

