/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.gui.GuiUtil;
import oracle.oc4j.admin.deploy.gui.WebSiteNode;

public class DeployOptionsDialog
extends JDialog
implements ActionListener {
    protected static final String OK_STRING = "OK";
    protected static final String CANCEL_STRING = "Cancel";
    protected JTextField _appNameField = null;
    protected JTextField _contextRootField = null;
    protected JComboBox _appsComboBox = null;
    protected JComboBox _webSitesComboBox = null;
    protected String _appName;
    protected String _contextRoot;
    protected String _idNode;
    protected WebSiteNode _webSiteNode = null;
    protected boolean _response;
    protected static final int DEPLOY = 1;
    protected static final int REDEPLOY = 2;
    protected static final int FETCH = 3;
    protected int height;

    public DeployOptionsDialog(JFrame parent, String[] apps, WebSiteNode[] webSites, int purpose, boolean webapp) {
        this(parent, apps, webSites, purpose, webapp, "");
    }

    public DeployOptionsDialog(JFrame parent, String[] apps, WebSiteNode[] webSites, int purpose, boolean webapp, String appName) {
        super((Frame)parent, purpose == 1 ? "Deploy" : (purpose == 2 ? "Redeploy" : (purpose == 3 ? "Fetch" : "")));
        String labelString = null;
        if (purpose == 2) {
            labelString = "Choose the currently deployed app to redeploy";
            this.height = 150;
        } else if (purpose == 3) {
            labelString = "Choose a currently deployed app";
            this.height = 150;
        } else if (purpose == 1) {
            labelString = "Enter a name for the deployed application:";
            this._appNameField = new JTextField(appName);
            this.height = webapp ? 300 : 220;
        }
        this._appsComboBox = new JComboBox<String>(apps);
        this._appsComboBox.setBackground(Color.white);
        if (webSites != null) {
            this._webSitesComboBox = new JComboBox<WebSiteNode>(webSites);
            this._webSitesComboBox.setBackground(Color.white);
            this.height += 80;
        }
        this.setSize(new Dimension(350, this.height));
        this.setModal(true);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setBackground(Deployer.TreeBackgroundColor);
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.setBorder(BorderFactory.createEmptyBorder(20, 15, 15, 15));
        JLabel titleLabel = new JLabel(labelString, 0);
        JPanel labelPane1 = new JPanel();
        labelPane1.setOpaque(false);
        labelPane1.setLayout(new BorderLayout());
        labelPane1.add((Component)titleLabel, "Center");
        contentPane.add(labelPane1);
        contentPane.add(Box.createRigidArea(new Dimension(0, 10)));
        if (purpose == 2 || purpose == 3) {
            contentPane.add(this._appsComboBox);
            contentPane.add(Box.createRigidArea(new Dimension(0, 10)));
        } else if (purpose == 1) {
            contentPane.add(this._appNameField);
            contentPane.add(Box.createRigidArea(new Dimension(0, 10)));
            if (webapp) {
                JLabel contextRootLabel = new JLabel("Specify a context root", 0);
                contextRootLabel.setBackground(Deployer.TreeBackgroundColor);
                JPanel labelPane2 = new JPanel();
                labelPane2.setOpaque(false);
                labelPane2.setLayout(new BorderLayout());
                labelPane2.add((Component)contextRootLabel, "Center");
                contentPane.add(labelPane2);
                contentPane.add(Box.createRigidArea(new Dimension(0, 10)));
                this._contextRootField = new JTextField();
                contentPane.add(this._contextRootField);
                contentPane.add(Box.createRigidArea(new Dimension(0, 10)));
            }
            JLabel parentAppLabel = new JLabel("Optionally choose a parent app", 0);
            parentAppLabel.setBackground(Deployer.TreeBackgroundColor);
            JPanel labelPane3 = new JPanel();
            labelPane3.setOpaque(false);
            labelPane3.setLayout(new BorderLayout());
            labelPane3.add((Component)parentAppLabel, "Center");
            contentPane.add(labelPane3);
            contentPane.add(Box.createRigidArea(new Dimension(0, 10)));
            this._appsComboBox.insertItemAt(new String(""), 0);
            this._appsComboBox.setSelectedIndex(0);
            contentPane.add(this._appsComboBox);
            contentPane.add(Box.createRigidArea(new Dimension(0, 10)));
        }
        if (this._webSitesComboBox != null) {
            JLabel webSiteLabel = new JLabel("Choose a web site", 0);
            webSiteLabel.setBackground(Deployer.TreeBackgroundColor);
            JPanel labelPane4 = new JPanel();
            labelPane4.setOpaque(false);
            labelPane4.setLayout(new BorderLayout());
            labelPane4.add((Component)webSiteLabel, "Center");
            contentPane.add(labelPane4);
            contentPane.add(Box.createRigidArea(new Dimension(0, 10)));
            contentPane.add(this._webSitesComboBox);
            contentPane.add(Box.createRigidArea(new Dimension(0, 10)));
        }
        JPanel buttonPane = new JPanel();
        buttonPane.setOpaque(false);
        JButton okButton = new JButton(OK_STRING);
        okButton.setActionCommand(OK_STRING);
        okButton.addActionListener(this);
        JButton cancelButton = new JButton(CANCEL_STRING);
        cancelButton.setActionCommand(CANCEL_STRING);
        cancelButton.addActionListener(this);
        buttonPane.add(okButton);
        buttonPane.add(cancelButton);
        contentPane.add(buttonPane);
        this.getRootPane().setDefaultButton(okButton);
        this.setLocationRelativeTo(parent);
    }

    public void setDefaultAppsComboItem(Object item) {
        this._appsComboBox.setSelectedItem(item);
    }

    public void setDefaultWebSitesComboItem(Object item) {
        this._webSitesComboBox.setSelectedItem(item);
    }

    public boolean showDialog() {
        this.show();
        return this._response;
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals(CANCEL_STRING)) {
            this._response = false;
            this.dispose();
        } else {
            String selString;
            if (this._appNameField != null) {
                this._appName = this._appNameField.getText().trim();
                if (this._appName == null || this._appName.equals("")) {
                    GuiUtil.errDialog("You must enter an application name.");
                    return;
                }
            }
            if (this._contextRootField != null) {
                this._contextRoot = this._contextRootField.getText().trim();
                if (this._contextRoot == null || this._contextRoot.equals("")) {
                    GuiUtil.errDialog("You must enter a context root.");
                    return;
                }
                if (this._contextRoot.charAt(0) != '/') {
                    GuiUtil.errDialog("Context root must begin with a '/'.");
                    return;
                }
            }
            if ((selString = (String)this._appsComboBox.getSelectedItem()).length() != 0) {
                this._idNode = (String)this._appsComboBox.getSelectedItem();
            }
            if (this._webSitesComboBox != null && !(this._webSitesComboBox.getSelectedItem() instanceof String)) {
                this._webSiteNode = (WebSiteNode)this._webSitesComboBox.getSelectedItem();
            }
            this._response = true;
            this.dispose();
        }
    }

    public String getAppName() {
        return this._appName;
    }

    public String getContextRoot() {
        return this._contextRoot;
    }

    protected String getApplication() {
        return this._idNode;
    }

    protected WebSiteNode getWebSite() {
        return this._webSiteNode;
    }

    protected void setContextRoot(String contextRoot) {
        this._contextRootField.setText(contextRoot);
    }
}

