/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import javax.swing.JLabel;
import oracle.oc4j.admin.deploy.gui.DataElement;
import oracle.oc4j.admin.deploy.gui.Deployer;

public abstract class DataElementBase
implements DataElement {
    protected String _name;
    protected Object _value;
    protected boolean _optional;
    protected boolean _readOnly;
    protected JLabel _valueLabel;
    protected String _doc;

    public DataElementBase(DataElement elem) {
        this._name = elem.getName();
        this._value = elem.getValue();
        this._optional = elem.isOptional();
    }

    public DataElementBase(String name, boolean optional) {
        this(name, null, optional);
    }

    public DataElementBase(String name, Object value, boolean optional) {
        this._name = name;
        this._value = value;
        this._optional = optional;
    }

    public String getName() {
        return this._name;
    }

    public void setReadOnly(boolean readOnly) {
        this._readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this._readOnly;
    }

    public boolean isOptional() {
        return this._optional;
    }

    public Object getValue() {
        return this._value;
    }

    public String getValueAsString() {
        return this._value == null ? null : this._value.toString();
    }

    public void setValue(Object value) {
        this._value = value;
        if (this._valueLabel != null) {
            this._valueLabel.setText(this.getValueAsString());
            this._valueLabel.setForeground(Deployer.ValueForegroundColor);
        }
    }

    protected JLabel createValueLabel() {
        JLabel label = new JLabel(this.getValueAsString());
        label.setForeground(Deployer.ValueForegroundColor);
        return label;
    }

    public JLabel getValueLabel() {
        if (this._valueLabel == null) {
            this._valueLabel = this.createValueLabel();
        }
        return this._valueLabel;
    }

    public void setDoc(String doc) {
        this._doc = doc;
    }

    public String getDoc() {
        return this._doc;
    }
}

