/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import oracle.oc4j.admin.deploy.gui.CodeSourceRootNode;
import oracle.oc4j.admin.deploy.gui.GuiUtil;
import oracle.oc4j.admin.deploy.gui.RemoveableNode;
import oracle.oc4j.admin.deploy.gui.SharedLibraryNode;
import oracle.oc4j.admin.deploy.gui.ViewableJTreeNodeSupport;
import oracle.oc4j.admin.deploy.spi.ProprietaryConnectedDeploymentManager;
import oracle.oc4j.admin.management.shared.CodeSource;

public class CodeSourceNode
extends ViewableJTreeNodeSupport
implements RemoveableNode {
    protected CodeSource _codeSource;
    protected DeploymentManager _manager;

    public CodeSourceNode(CodeSource codeSource, DeploymentManager manager) {
        this._codeSource = codeSource;
        this._manager = manager;
    }

    public String getPath() {
        return this._codeSource.getPath();
    }

    public boolean removeNode() {
        String title = "Confirm Remove Code Source";
        String message = "Remove Code Source '" + this.getPath() + "'?";
        if (GuiUtil.showYesNoDialog(title, message) != 0) {
            return false;
        }
        try {
            CodeSourceRootNode parent = (CodeSourceRootNode)this.getParent();
            SharedLibraryNode parentLib = (SharedLibraryNode)parent.getParent();
            ProprietaryConnectedDeploymentManager mgr = (ProprietaryConnectedDeploymentManager)this._manager;
            mgr.modifySharedLibrary(new Target[]{parentLib.getTarget()}, parentLib.getName(), parentLib.getVersion(), null, null, null, new String[]{this.getPath()}, null, null);
        }
        catch (Exception ex) {
            GuiUtil.errDialog("Exception removing code source: " + ex.getMessage());
            ex.printStackTrace();
            return false;
        }
        ((ViewableJTreeNodeSupport)this.getParent()).removeJTreeChild(this);
        return true;
    }

    public String jtreeToolTip() {
        return this.viewHeaderString();
    }

    public String viewHeaderString() {
        return this.getPath() + "   (Code Source)";
    }

    public String toString() {
        return this.getPath();
    }

    public void buildChildJTree() {
    }

    public boolean leaf() {
        return true;
    }
}

