/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.util.List;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public class RemoveDataSourceConnectionPoolCommand
extends AdminCommandBase {
    static final String COMMANDNAME = "-removeDataSourceConnectionPool";
    static final String APPNAME = "-applicationName";
    static final String NAME = "-name";
    static final String COMMANDMENU = "-removeDataSourceConnectionPool -name <name>";
    static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -removeDataSourceConnectionPool\n   - Remove a JDBC Connection Pool.\n\nValid switches are: \n   -name <name>                                        - Required  The connection pool name.\n   -applicationName <applicationName>                  - Optional  The name of the application to deploy to.\n\n";
    String _applicationName;
    String _name;

    public RemoveDataSourceConnectionPoolCommand(List args) throws AdminCommandException {
        super(args);
        while (!this.isArgsEmpty()) {
            String command = this.getNextArgument("removeDataSourceConnectionPool subcommand");
            if (command.equalsIgnoreCase(APPNAME)) {
                this._applicationName = this.getNextArgument("-applicationName ");
                continue;
            }
            if (command.equalsIgnoreCase(NAME)) {
                this._name = this.getNextArgument("-name ");
                continue;
            }
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("unknown_removeDataSourceConnectionPool_switch", new String[]{command}), COMMANDNAME);
        }
        this.checkArgIsNull(this._name, NAME);
    }

    protected void doExecute() throws AdminCommandException {
        try {
            this._j2eeDeplMgr.removeDataSourceConnectionPool(this._applicationName, this._name);
        }
        catch (Exception e) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("removeDataSourceConnectionPool_error", new String[]{e.getMessage()}), e);
        }
    }
}

