/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public class CreateNativeDataSourceCommand
extends AdminCommandBase {
    static final String COMMANDNAME = "-addNativeDataSource";
    static final String APPNAME = "-applicationName";
    static final String DATASOURCENAME = "-name";
    static final String USER = "-dbUser";
    static final String PASSWORD = "-dbPassword";
    static final String JNDILOCATION = "-jndiLocation";
    static final String LOGINTIMEOUT = "-loginTimeout";
    static final String DATASOURCECLASS = "-dataSourceClass";
    static final String URL = "-url";
    static final String PROPERTIES = "-properties";
    static final String COMMANDMENU = "-addNativeDataSource -name <name>  -dbUser <user> -dbPassword <password> \n                         -jndiLocation <jndiLocation> -loginTimeout <loginTimeout> \n                         -dataSourceClass <dataSourceClass> -url <url> [options]";
    static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -addNativeDataSource\n   - Add a new Native Data Source.\n\nValid switches are: \n   -name <name>                                        - Required  The name of the new data source.\n   -dbUser <dbUser>                                    - Required  The default user for the new data source.\n   -dbPassword <dbPassword>                            - Required  The default password for the new data source.\n   -jndiLocation <jndiLocation>                        - Required  The location to use to bind the new data source into JNDI.\n   -loginTimeout <loginTimeout>                        - Required  The login timeout for the new data source.\n   -dataSourceClass <dataSourceClass>                  - Required  The fully-pathed class of the new data source.\n   -url <url>                                          - Required  The url used by the new data source to connect to the database.\n   -applicationName <applicationName>                  - Optional  The name of the application.\n   -properties <name1> <value1> <name2> <value2> [...] - Optional  The properties for the new data source.\n\n";
    String _applicationName;
    String _dataSourceName;
    String _user;
    String _password;
    String _jndiLocation;
    String _loginTimeout;
    String _dataSourceClass;
    String _url;
    Map _properties = new HashMap();

    public CreateNativeDataSourceCommand(List args) throws AdminCommandException {
        super(args);
        while (!this.isArgsEmpty()) {
            String command = this.getNextArgument("addNativeDataSource subcommand");
            String nextArg = null;
            if (command.equalsIgnoreCase(APPNAME)) {
                this._applicationName = this.getNextArgument("-applicationName ");
                continue;
            }
            if (command.equalsIgnoreCase(DATASOURCENAME)) {
                this._dataSourceName = this.getNextArgument("-name ");
                continue;
            }
            if (command.equalsIgnoreCase(USER)) {
                this._user = this.getNextArgument("-dbUser ");
                continue;
            }
            if (command.equalsIgnoreCase(PASSWORD)) {
                this._password = this.getNextArgument("-dbPassword ");
                continue;
            }
            if (command.equalsIgnoreCase(JNDILOCATION)) {
                this._jndiLocation = this.getNextArgument("-jndiLocation ");
                continue;
            }
            if (command.equalsIgnoreCase(LOGINTIMEOUT)) {
                this._loginTimeout = this.getNextArgument("-loginTimeout ");
                continue;
            }
            if (command.equalsIgnoreCase(DATASOURCECLASS)) {
                this._dataSourceClass = this.getNextArgument("-dataSourceClass ");
                continue;
            }
            if (command.equalsIgnoreCase(URL)) {
                this._url = this.getNextArgument("-url ");
                continue;
            }
            if (command.equalsIgnoreCase(PROPERTIES)) {
                while ((nextArg = this.readNextArgument()) != null && !nextArg.startsWith("-")) {
                    this._properties.put(this.getNextArgument("property name "), this.getNextArgument("property value "));
                }
                continue;
            }
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("unknown_createNativeDataSource_switch", new String[]{command}), COMMANDNAME);
        }
        this.checkArgIsNull(this._dataSourceName, DATASOURCENAME);
        this.checkArgIsNull(this._user, USER);
        this.checkArgIsNull(this._password, PASSWORD);
        this.checkArgIsNull(this._jndiLocation, JNDILOCATION);
        this.checkArgIsNull(this._loginTimeout, LOGINTIMEOUT);
        this.checkArgIsNull(this._dataSourceClass, DATASOURCECLASS);
        this.checkArgIsNull(this._url, URL);
    }

    protected void doExecute() throws AdminCommandException {
        try {
            this._j2eeDeplMgr.createNativeDataSource(this._applicationName, this._dataSourceName, this._user, this._password, this._jndiLocation, new Integer(this._loginTimeout), this._dataSourceClass, this._url, this._properties);
        }
        catch (Exception e) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("createNativeDataSource_error", new String[]{e.getMessage()}), e);
        }
    }
}

