/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.util.List;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public class AddImportSharedLibraryCommand
extends AdminCommandBase {
    public static final String COMMANDNAME = "-addImportSharedLibrary";
    public static final String COMMANDMENU = "-addImportSharedLibrary -appName <app> -name <name> [options]";
    public static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -addImportSharedLibrary [<switch>]\n   - Adds an existing shared library import to an application.\n\nValid switches are: \n   -appName <app>       - Required  The application's name.\n   -name <name>         - Required  The name of the shared library.\n   -minVer <minVersion> - Optional  Minimum version number required by an application.\n   -maxVer <maxVersion> - Optional  Maximum version number required by an application.\n\n";
    private String _appName;
    private String _name;
    private String _minVersion;
    private String _maxVersion;

    public AddImportSharedLibraryCommand(List args) throws AdminCommandException {
        super(args);
        while (!this.isArgsEmpty()) {
            String command = this.getNextArgument("addImportSharedLibrary subcommand");
            if (command.equalsIgnoreCase("-appName")) {
                this._appName = this.getNextArgument("deployment name");
                continue;
            }
            if (command.equalsIgnoreCase("-name")) {
                this._name = this.getNextArgument("shared library name");
                continue;
            }
            if (command.equalsIgnoreCase("-minVersion")) {
                this._minVersion = this.getNextArgument("minimum library version");
                continue;
            }
            if (command.equalsIgnoreCase("-maxVersion")) {
                this._maxVersion = this.getNextArgument("maximum library version");
                continue;
            }
            String msg = FormattingResourceBundle.DeploymentMessages.getString("unknown_addimportsharedlibrary_switch", new String[]{command});
            throw new AdminCommandUsageException(msg, COMMANDNAME);
        }
        this.checkArgIsNull(this._appName, "-appName");
        this.checkArgIsNull(this._name, "-name");
    }

    protected void doExecute() throws AdminCommandException {
        try {
            this._j2eeDeplMgr.addImportSharedLibrary(this._appName, this._name, this._minVersion, this._maxVersion);
        }
        catch (Exception e) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("addimportsharedlibrary_error", new String[]{e.getMessage()});
            throw new AdminCommandException(msg, e);
        }
        System.out.println("");
        System.out.println(FormattingResourceBundle.DeploymentMessages.getString("command_successful_app_needs_restart", new String[]{"addImportSharedLibrary"}));
        System.out.println("");
    }
}

