/* THIS FILE CONTAINS STORED PROCEDURES FOR SYBASE SERVER MONITORING */

/*sp_egmonitor:start*/

create procedure sp_egmonitor 
@interval int,
@flags varchar(15) = ''
as
begin
	declare @sample_interval int
	declare @network char(1)
	declare @lock char(1)
	declare @dataCache char(1)
	declare @procCache char(1)
	declare @device char(1)
	declare @trans char(1)
	declare @transLog char(1)
	declare @tasks char(1)
	declare @tmp real
	declare @tmp1 real
	declare @tmp2 real
	declare @total_searches real
	declare @CacheName varchar(50)
	declare @CacheID smallint
	declare @group_name varchar(30)
	declare @dev_name varchar(50)
	declare @grp smallint
	declare @m1 real
	declare @m2 real
	declare @m3 real
	declare @m4 real
	declare @m5 real
	declare @m6 real
	declare @m7 real
	declare @m8 real
	declare @sep char(1)
	declare @output varchar(255) /* type should be changed to nvarchar */
	declare @errMsg varchar(255)
	declare @tempExists smallint
	declare @latchsum int
	select @network = '1'
	select @lock = '1'
	select @dataCache = '1'
	select @procCache = '1'
	select @device = '1'
	select @trans = '1'
	select @transLog = '1'
	select @tasks = '1'
	select @tempExists = 0
	if(char_length(@flags) = 15)
	begin
		select @network = substring(@flags,1,1)
		select @lock = substring(@flags,3,1)
		select @dataCache = substring(@flags,5,1)
		select @procCache = substring(@flags,7,1)
		select @device = substring(@flags,9,1)
		select @trans = substring(@flags,11,1)
		select @transLog = substring(@flags,13,1)
		select @tasks = substring(@flags,15,1)
	end
	if (@interval <= 0)
		return 0
	select @sep = ','
	/* check if the user has sa_role */
	if proc_role('sa_role') < 1
	  begin
		raiserror 18127 @errMsg, 'sp_egmonitor'  /* raise sa_role error */
		return 1
	  end
	/* check if this procedure is invoked within a transaction */
	if @@trancount > 0
	  begin
		raiserror 17260 @errMsg, 'sp_egmonitor'
		return 1
	  end
	else
	set chained off
	set transaction isolation level 1
	/* collect measures for this sample interval */
	dbcc monitor('clear','all','on')	/* turn on monitoring & clear all the counters */
	dbcc monitor('clear', 'spinlock_s', 'on')
	
	if(@interval = 30)
	begin
		waitfor delay '00:00:15'
		select @sample_interval = 15
	end	
	else if(@interval = 60)
	begin
		waitfor delay '00:00:45'
		select @sample_interval = 45
	end	
	else if(@interval = 180)
	begin
		waitfor delay '00:02:40'
		select @sample_interval = 160
	end	
	else if(@interval = 300)
	begin
		waitfor delay '00:04:40'
		select @sample_interval = 280
	end	
	else if(@interval = 600)
	begin
		waitfor delay '00:09:30'
		select @sample_interval = 570
	end	
	else if(@interval = 900)
	begin
		waitfor delay '00:14:25'
		select @sample_interval = 865
	end	
	else if(@interval = 1800)
	begin
		waitfor delay '00:29:00'
		select @sample_interval = 1740
	end	
	else if(@interval = 3600)
	begin
		waitfor delay '00:58:00'
		select @sample_interval = 3480
	end	
	else if(@interval = 7200)
	begin
		waitfor delay '01:57:00'
		select @sample_interval = 7020
	end	
	else if(@interval = 14400)
	begin
		waitfor delay '03:56:00'
		select @sample_interval = 14160
	end	
	else if(@interval = 21600)
	begin
		waitfor delay '05:55:00'
		select @sample_interval = 21300
	end	
	else if(@interval = 43200)
	begin
		waitfor delay '11:50:00'
		select @sample_interval = 42600
	end	
	else if(@interval = 86400)
	begin
		waitfor delay '23:50:00'
		select @sample_interval = 85800
	end
	else
		return 0
	
	dbcc  monitor('sample','spinlock_s','off') /* turn off monitoring & update counters into master.dbo.sysmonitors table  */
	dbcc  monitor('sample','all','off')
	dbcc  monitor('select','spinlock_s','on') /* enable the counters to be displayed */
	dbcc  monitor('select','all','on')
	
	if(exists(select id from tempdb.dbo.sysobjects where name='egtempmonitor'))
	begin
		truncate table tempdb.dbo.egtempmonitor
		select @tempExists = 1
	end
	/* -------------- SybNetworkTest --------------------------- */
	if(@network = '1')
	begin
			/* Io_requests (Packets/Sec) */
		select @tmp = value from master.dbo.sysmonitors 
			where group_name = 'kernel' and	field_name = 'ksalloc_calls'
		select @m1 = @tmp / @sample_interval

			/* Percent_io_delay (%) */
		select @tmp1 = value from master.dbo.sysmonitors 
			where group_name = 'kernel' and	field_name = 'ksalloc_sleeps'
		if(@tmp=0)
			select @m2 = 0
		else
			select @m2 = 100 * @tmp1 / @tmp

			/* Data_recvd_rate (Kbytes/Sec) */
		select @tmp1 = SUM(value) from master.dbo.sysmonitors 
			where group_name like 'engine_%' and field_name = 'no_bytes_received'
		select @m3 = (@tmp1 / @sample_interval)/1024 

			/* Data_sent_rate (Kbytes/Sec) */
		select @tmp1 = SUM(value) from master.dbo.sysmonitors 
			where group_name like 'engine_%' and field_name = 'no_bytes_sent'
		select @m4 = (@tmp1 / @sample_interval)/1024

			/* Avg_packet_size (Bytes) */
		select @tmp2 = SUM(value) from master.dbo.sysmonitors 
			where group_name like 'engine_%' and field_name = 'no_packets_sent'
		if(@tmp2 = 0)
			select @m5 = 0
		else
			select @m5 = @tmp1 / @tmp2

		select @output = 'network=' + ltrim(str(@m1,10,3)) + @sep +
					      ltrim(str(@m2,10,3)) + @sep +
					      ltrim(str(@m3,10,3)) + @sep +
					      ltrim(str(@m4,10,3)) + @sep +
					      ltrim(str(@m5,10,3))
		print @output 
	end

	/* ----------------------- SybLockTest ------------------------ */

	if(@lock = '1')
	begin
		/* DD */
		if(@tempExists=1)
		begin
			insert into tempdb.dbo.egtempmonitor select field_name,group_name,value from master.dbo.sysmonitors
			where group_name='lock'
		end	

			/* Lock_requests (Locks/Sec) */
		select @tmp = SUM(value) from master.dbo.sysmonitors
			where group_name = 'lock' and (field_name like 'granted%' or field_name like 'waited%')
		select @m1 = @tmp / @sample_interval

			/* Lock_waits (Waits/Sec) */
		select @tmp1 = SUM(value) from master.dbo.sysmonitors
		       where group_name = 'lock' and field_name like 'waited%'
		select @m2 = @tmp1 / @sample_interval

			/* Avg_lock_wait_time (Secs) */
		select @tmp1 = sum(value) from master.dbo.sysmonitors
			where group_name = 'lock' and field_name like 'lkwaittime%'
		if(@tmp1>=0)
			select @m3 = (@tmp1 / @sample_interval) / 1000
		else	
			select @m3 = -3
			
			/* Lock_timeouts (Timeouts/Sec) */
		select @tmp1 = sum(value) from master.dbo.sysmonitors
			where group_name = 'lock' and field_name like 'timedout%'
		
		if(@tmp1>=0)
			select @m4 = @tmp1 / @sample_interval
		else
			select @m4 = -3

			/* Dead_locks(Deadlocks/Sec) */
		select @tmp1= value from master.dbo.sysmonitors
			  where group_name = 'lock' and	field_name = 'deadlocks'
		select @m5 = @tmp1 / @sample_interval

		select @output = 'lock=' + ltrim(str(@m1,10,3)) + @sep +
				      ltrim(str(@m2,10,3)) + @sep +
				      ltrim(str(@m3,10,3)) + @sep +
				      ltrim(str(@m4,10,3)) + @sep +
				      ltrim(str(@m5,10,3))

		print @output
	end

	/* -------------------- SybDataCacheTest ------------------------- */

	if(@dataCache = '1')
	begin
		/* DD */
		if(@tempExists=1)
		begin
			insert into tempdb.dbo.egtempmonitor select field_name,group_name,value from master.dbo.sysmonitors
			where group_name like 'buffer_%'
		end	
		select @total_searches = SUM(value) from master.dbo.sysmonitors
			where group_name like 'buffer_%' and field_name = 'bufsearch_calls'
		declare cache_info cursor for 
			select convert(varchar(50), name) from master.dbo.sysconfigures where parent=19 and config=19
		open cache_info
		fetch cache_info into @CacheName
		while @@sqlstatus = 0
		begin
			select @CacheID = config_admin(15,0,0,0,NULL,@CacheName)
			select @group_name = 'buffer_' + convert(varchar(3), @CacheID)
			select  @tmp=P.value, /* grabs */
				@tmp1=W.value, /* waits */
				@tmp2=S.value  /* spins */
			from master.dbo.sysmonitors P, master.dbo.sysmonitors W, master.dbo.sysmonitors S
			where
				    P.group_name = 'spinlock_p_0'
				and W.group_name = 'spinlock_w_0'
				and S.group_name = 'spinlock_s_0'
				and P.field_id = W.field_id
				and P.field_id = S.field_id
				and P.field_name=@CacheName
			if(@tmp = 0)
				select @m1 = 0
			else
				select @m1 = 100 * @tmp1 / @tmp

				/* Utilization (%) */
			select @tmp = value from master.dbo.sysmonitors
				where group_name = @group_name and field_name = 'bufsearch_calls'
			if(@total_searches = 0)
				select @m2 = 0
			else
				select @m2 = 100 * @tmp / @total_searches

				/* Cache_hit_ratio (%) */
			select @tmp1 = value from master.dbo.sysmonitors
			  where group_name = @group_name and field_name = 'bufsearch_finds'
			if(@tmp = 0)
				select @m3 = 100
			else
				select @m3 = 100 * @tmp1 / @tmp

				/* Buffers_grabbed (Buffers/Sec) */
			select @tmp = SUM(value) from master.dbo.sysmonitors
				  where group_name = @group_name and field_name like 'bufgrab_%k'
			select @m4 = @tmp / @sample_interval

				/* Buffers_grabbed_dirty (Buffers/Sec) */
			select @tmp1 = SUM(value) from master.dbo.sysmonitors
			  where group_name = @group_name and field_name like 'bufgrab_dirty_%k'
			select @m5 = @tmp1 / @sample_interval

				/* Pct_large_io_denied (%) */
			select @tmp1 = value from master.dbo.sysmonitors
			  where group_name = @group_name and field_name = 'prefetch_req'

			select @tmp2 = SUM(value) from master.dbo.sysmonitors
				  where group_name = @group_name and field_name IN ('prefetch_as_requested', 'prefetch_page_realigned')

			if(@tmp1 = 0)
				select @m6 = 0
			else
				select @m6 = 100 * (@tmp1 - @tmp2) / @tmp1

				/* Large_io_effectiveness (%)  */
			select @tmp1 = sum(value) from master.dbo.sysmonitors
				where group_name = @group_name and field_name like 'bufgrab_ref_%K'
			if(@tmp = 0)
				select @m7 = 100
			else
				select @m7 = 100 * @tmp1 / @tmp

			select @output = 'data_cache=' + @CacheName + ':' + 
							ltrim(str(@m2,10,3)) + @sep +
							ltrim(str(@m3,10,3)) + @sep +
							ltrim(str(@m1,10,3)) + @sep +
							ltrim(str(@m4,10,3)) + @sep +
							ltrim(str(@m5,10,3)) + @sep +
							ltrim(str(@m6,10,3)) + @sep +
							ltrim(str(@m7,10,3))
			print @output
			fetch cache_info into @CacheName
		end
		close cache_info
		deallocate cursor cache_info
	end
	/* ------------------- SybProcedureCacheTest -------------------------*/
	if(@procCache = '1')
	begin
			 /* Proc_execution_rate (Execs/Sec) */
		select @tmp = value from master.dbo.sysmonitors
		   where group_name = 'procmgr' and field_name = 'procedure_requests'
		select @m1 = @tmp / @sample_interval

			/* Reads_from_disk (Reads/Sec) */
		select @tmp1 = value from master.dbo.sysmonitors
		  where group_name = 'procmgr' and field_name = 'procedure_reads'
		select @m2 = @tmp1 / @sample_interval

			/* Cache_hit_ratio (%) */
		if(@tmp = 0)
			select @m3 = 100
		else
			select @m3 = 100 * (@tmp - @tmp1) / @tmp

			/* Procedures_created (Writes/Sec) */
		select @tmp1 = value from master.dbo.sysmonitors
			  where group_name = 'procmgr' and field_name = 'procedure_writes'
		select @m4 = @tmp1 / @sample_interval

			/* Procedures_aged_out (Removals/Sec) */
		select @tmp1 = value from master.dbo.sysmonitors
			  where group_name = 'procmgr' and field_name = 'procedure_removes'
		select @m5 = @tmp1 / @sample_interval

		select @output = 'procedure_cache=' + ltrim(str(@m1,10,3)) + @sep +
						ltrim(str(@m2,10,3)) + @sep +
						ltrim(str(@m3,10,3)) + @sep +
						ltrim(str(@m4,10,3)) + @sep +
						ltrim(str(@m5,10,3))
		print @output
	end
	/* -------------------------- SybDeviceTest -----------------------------*/
	if(@device = '1')
	begin
		declare device_info cursor for
			select name,((low&-16777216)/16777216 &255) 
			from master.dbo.sysdevices where (status & 16) != 16
		open device_info
		fetch device_info into @dev_name,@grp
		while @@sqlstatus = 0
		begin
			select @group_name = 'disk_'+convert(char(3),@grp)

				/* Phy_read_rate (Reads/Sec) */
			select @tmp1 = value from master.dbo.sysmonitors
			  where group_name = @group_name and field_name = 'total_reads'

				/* Phy_write_rate (Writes/Sec) */
			select @tmp2 = value from master.dbo.sysmonitors
			  where group_name = @group_name and field_name = 'total_writes'
			select @tmp = @tmp1 + @tmp2
			select @m1 = @tmp / @sample_interval
			select @m2 = @tmp1 / @sample_interval
			select @m3 = @tmp2 / @sample_interval

				/* IO errors */
			select @tmp1 = value from master.dbo.sysmonitors
				  where group_name = @group_name and field_name = 'IO_errors' 

				/*  IO waits */
			select @tmp2 = value from master.dbo.sysmonitors
				  where group_name = @group_name and field_name = 'p_misses'
			if(@tmp = 0)
			begin
				select @m4 = 0
				select @m5 = 0
			end
			else
			begin
				select @m4 = 100 * @tmp1 / @tmp
				select @m5 = 100 * @tmp2 / @tmp
			end

			select @output = 'device=' + @dev_name + ':' +
						ltrim(str(@m1,10,3)) + @sep +
						ltrim(str(@m2,10,3)) + @sep +
						ltrim(str(@m3,10,3)) + @sep +
						ltrim(str(@m4,10,3)) + @sep +
						ltrim(str(@m5,10,3))
			fetch device_info into @dev_name,@grp	
			print @output
		end	
		close device_info
		deallocate cursor device_info
	end
	/* ------------------- SybTransactionTest ---------------------------- */
	if(@trans = '1')
	begin
			/* Committed_Xacts (Xacts/Sec)  */
		select @tmp1 = value from master.dbo.sysmonitors
			  where group_name = 'access' and field_name = 'xacts'
		select @m1 = @tmp1 / @sample_interval

			/*  Rollback_Xacts (Xacts/Sec) */
		select @tmp1 = value from master.dbo.sysmonitors
			  where group_name = 'access' and field_name = 'rollbacks'
		select @m2 = @tmp1 / @sample_interval

			/*  Inserts (Inserts/Sec) */
		select @tmp1 = SUM(value) from master.dbo.sysmonitors
			  where (group_name = 'access' and field_name IN ('ncinsert', 'cinsert'))
			     or (group_name = 'dolaccess' and field_name = 'dolinsert')
		select @m3 = @tmp1/ @sample_interval

			/*  Updates (Updates/Sec)  */
		select @tmp1= SUM(value) from master.dbo.sysmonitors
		  where (group_name = 'access' and field_name IN 
			('deferred_update','direct_inplace_update',
			 'direct_notinplace_update','direct_expensive_update'))
		     OR (group_name = 'dolaccess' and field_name = 'dolupdates')
		select @m4 = @tmp1 / @sample_interval

			/* Deletes (Deletes/Sec)  */
		select @tmp1 = SUM(value) from master.dbo.sysmonitors
		  where (group_name = 'access' and field_name = 'delete')
		     or (group_name = 'dolaccess' and field_name = 'doldelete_total')
		select @m5 = @tmp1 / @sample_interval

		select @output = 'transaction=' + ltrim(str(@m1,10,3)) + @sep +
					     ltrim(str(@m2,10,3)) + @sep +
					     ltrim(str(@m3,10,3)) + @sep +
					     ltrim(str(@m4,10,3)) + @sep +
					     ltrim(str(@m5,10,3))
		print @output
	end
	/* ----------------------- SybTransactionLogTest -------------------------------- */
	if(@transLog = '1')
	begin
		/* DD */
		if(@tempExists=1)
		begin
			insert into tempdb.dbo.egtempmonitor select field_name,group_name,value from master.dbo.sysmonitors
			where group_name='xls'
		end	
			/* Ulc_log_write_rate (Records/Sec)  */
		select @tmp1 = value  from master.dbo.sysmonitors
		  where group_name = 'xls' and	field_name = 'plc_logrecs'
		select @m1 = @tmp1 / @sample_interval

			/*  Ulc_log_write_waits (Waits/Sec)  */
		select @tmp1 = value from master.dbo.sysmonitors
		  where group_name = 'xls' and field_name = 'plc_lock_waits'
		select @m2 = @tmp1 / @sample_interval

			/*  Ulc_flush_rate (Flushes/Sec)  */
		select @tmp1 = SUM(value) from master.dbo.sysmonitors
			  where group_name = 'xls' and field_name like 'plc_flush_%'
		select @m3 = @tmp1 / @sample_interval

			/*  Ulc_flush_waits (Waits/Sec)  */
		select @tmp1 = value from master.dbo.sysmonitors
			  where group_name = 'xls' and field_name = 'log_lock_waited'
		select @m4 = @tmp1 / @sample_interval

			/*  Max_ulc_size (KB)  */
		select @tmp1 = value from master.dbo.sysmonitors
			  where group_name = 'xls' and	field_name = 'plc_maxused'
		select @m5 = @tmp1 / @sample_interval

			/*  Transaction_log_allocations (Allocations/Sec)  */
		select @tmp = value from master.dbo.sysmonitors
		  where group_name = 'access' and field_name = 'log_page_allocations'         
		select @m6 = @tmp / @sample_interval

			/*  Transaction_log_writes (Writes/Sec)  */
		select @tmp1 = SUM(value) from master.dbo.sysmonitors
			  where group_name like 'buffer_%' and field_name = 'log_page_writes'
		select @m7 = @tmp1 / @sample_interval

			/*  Avg_writes_per_logpage (Number)  */
		if(@tmp = 0)
			select @m8 = 0
		else
			select @m8 = @tmp1 / @tmp

		select @output = 'transaction_log=' + ltrim(str(@m1,10,3)) + @sep +
						ltrim(str(@m2,10,3)) + @sep +
						ltrim(str(@m3,10,3)) + @sep +
						ltrim(str(@m4,10,3)) + @sep +
						ltrim(str(@m5,10,3)) + @sep +
						ltrim(str(@m6,10,3)) + @sep +
						ltrim(str(@m7,10,3)) + @sep +
						ltrim(str(@m8,10,3))
		print @output
	end
	/* ----------------------- SybTasksTest ---------------------------------*/
	if(@tasks = '1')
	begin
		/*insert into tempdb.dbo.egtempmonitor select * from master.dbo.sysmonitors */
		
			/* Connections_opened (Conns/Sec)  */
		select @tmp1 = value from master.dbo.sysmonitors
			where group_name = 'kernel' and  field_name = 'processes_created'
		select @m1 = @tmp1 / @sample_interval

			/* Task_switch_rate (Switches/Sec)  */
		select @tmp1 = SUM(value) from master.dbo.sysmonitors
			  where group_name like 'engine_%' and field_name = 'context_switches'
		select @m2 = @tmp1 / @sample_interval

		select @output = 'tasks=' + ltrim(str(@m1,10,3)) + @sep + ltrim(str(@m2,10,3))
		print @output
		/* DD */
		if(@tempExists=1)
		begin
			insert into tempdb.dbo.egtempmonitor select 'context_switches','tasks',sum(value) from master.dbo.sysmonitors
			  where group_name like 'engine_%' and field_name = 'context_switches'
			insert into tempdb.dbo.egtempmonitor select field_name,group_name,value from master.dbo.sysmonitors
			  where group_name = 'kernel' and field_name = 'yields'
			insert into tempdb.dbo.egtempmonitor select 'device_contention','tasks',sum(value) from master.dbo.sysmonitors
			  where group_name like 'disk_%' and field_name = 'p_misses'
			insert into tempdb.dbo.egtempmonitor select field_name,group_name,value from master.dbo.sysmonitors
				where group_name = 'network' and field_name = 'total_packets_received'
			insert into tempdb.dbo.egtempmonitor select field_name,group_name,value from master.dbo.sysmonitors
				where group_name = 'network' and field_name = 'total_packets_sent'
			select @latchsum=sum(value) from master.dbo.sysmonitors where group_name = 'latch' and field_name like 'waited_%_LATCH'
			if(@latchsum>=0)
				insert into tempdb.dbo.egtempmonitor select 'latch_contention','tasks',@latchsum
		end		
	end
end
/*sp_egmonitor:end*/

/*sp_eglockdetails:start*/
create procedure sp_eglockdetails 
@lockType varchar(25),
@details varchar(100) output
as
begin
	declare @m1 real
	declare @m2 real
	declare @m3 real
	declare @m4 real
	declare @m5 real
	declare @sep char(1)
	select @sep = ','
	select @m1 = SUM(value) from tempdb.dbo.egtempmonitor
	  where group_name = 'lock' and field_name like 'granted_%'+@lockType
	select @m2 = SUM(value) from tempdb.dbo.egtempmonitor
	  where group_name = 'lock' and field_name like 'waited_%'+@lockType
	select @m3 = value from tempdb.dbo.egtempmonitor
	  where group_name = 'lock' and field_name='lkwaittime_'+@lockType
	select @m4 = value from tempdb.dbo.egtempmonitor
	  where group_name = 'lock' and field_name='timedout_'+@lockType
	select @m5 = value from tempdb.dbo.egtempmonitor
	  where group_name = 'lock' and field_name='deadlock_'+@lockType
	select @details =ltrim(str(@m1,20)) + @sep +
			 ltrim(str(@m2,20)) + @sep +
			 ltrim(str(@m3,20)) + @sep +
			 ltrim(str(@m4,20)) + @sep +
			 ltrim(str(@m5,20))
end
/*sp_eglockdetails:end*/

/*sp_egmonitor_dd:start*/

create procedure sp_egmonitor_dd 
@testIndex smallint,
@info varchar(50)='',
@pgsize int=2048
as
begin
	declare @temp varchar(100)
	declare @output varchar(255)
	declare @errMsg varchar(255)
	declare @m1 real
	declare @total real
	declare @tmp varchar(50)
	declare @sep char(1)
	
	select @sep = ','
	/* check if the user has sa_role */
	if proc_role('sa_role') < 1
	  begin
		raiserror 18127 @errMsg, 'sp_egmonitor'  /* raise sa_role error */
		return 1
	  end
	/* check if this procedure is invoked within a transaction */
	if @@trancount > 0
	  begin
		raiserror 17260 @errMsg, 'sp_egmonitor'
		return 1
	  end
	else
	set chained off
	set transaction isolation level 1
	
	if (not exists (select id from tempdb.dbo.sysobjects where name='egtempmonitor'))
		return 0
	/* create this table from SybCollectorThread class  */	
	/* ----------------------- SybLockTest ------------------------ */
	if(@testIndex = 1)
	begin
		declare @mEX_TAB varchar(70)
		declare @mSH_TAB varchar(70)
		declare @mEX_INT varchar(70)
		declare @mSH_INT varchar(70)
		declare @mEX_PAGE varchar(70)
		declare @mUP_PAGE varchar(70)
		declare @mSH_PAGE varchar(70)
		declare @mEX_ROW varchar(70)
		declare @mUP_ROW varchar(70)
		declare @mSH_ROW varchar(70)
		declare @mSH_NKL varchar(70)
		declare @mEX_ADDR varchar(70)
		declare @mSH_ADDR varchar(70)

		exec sp_eglockdetails 'EX_TAB',@temp output
		select @mEX_TAB = @temp		
		exec sp_eglockdetails 'SH_TAB',@temp output
		select @mSH_TAB = @temp		
		exec sp_eglockdetails 'EX_INT',@temp output
		select @mEX_INT = @temp		
		exec sp_eglockdetails 'SH_INT',@temp output
		select @mSH_INT = @temp		
		exec sp_eglockdetails 'EX_PAGE',@temp output
		select @mEX_PAGE = @temp		
		exec sp_eglockdetails 'UP_PAGE',@temp output
		select @mUP_PAGE = @temp		
		exec sp_eglockdetails 'SH_PAGE',@temp output
		select @mSH_PAGE = @temp		
		exec sp_eglockdetails 'EX_ROW',@temp output
		select @mEX_ROW = @temp		
		exec sp_eglockdetails 'UP_ROW',@temp output
		select @mUP_ROW = @temp		
		exec sp_eglockdetails 'SH_ROW',@temp output
		select @mSH_ROW = @temp		
		exec sp_eglockdetails 'SH_NKL',@temp output
		select @mSH_NKL = @temp		
		exec sp_eglockdetails 'EX_ADDR',@temp output
		select @mEX_ADDR = @temp		
		exec sp_eglockdetails 'SH_ADDR',@temp output
		select @mSH_ADDR = @temp
		select  @mEX_TAB,@mSH_TAB,@mEX_INT,@mSH_INT,@mEX_PAGE,
			@mUP_PAGE,@mSH_PAGE,@mEX_ROW,@mUP_ROW,@mSH_ROW,
			@mSH_NKL,@mEX_ADDR,@mSH_ADDR

	end
	/* -------------------- SybDataCacheTest ------------------------- */
	if(@testIndex = 2)
	begin
		declare @KBperpage int
		declare @CacheID smallint
		declare @group_name varchar(50)
		declare @n int
		declare @buff_grabbed real
		declare @buff_grabbed_dirty real

		select @KBperpage = @pgsize/1024
		select @CacheID = config_admin(15,0,0,0,NULL,@info)
		select @group_name = 'buffer_' + convert(varchar(3), @CacheID)

		select @n = @KBperpage
		while (@n <= 8*@KBperpage)
		begin	
			select @tmp = 'bufgrab_' + rtrim(convert(varchar(3), @n)) + 'k'
			select @buff_grabbed = value from tempdb.dbo.egtempmonitor
					  where group_name = @group_name and field_name = @tmp
			select @tmp = 'bufgrab_dirty_' + convert(varchar(3), @n) + 'k'
			select @buff_grabbed_dirty = value from tempdb.dbo.egtempmonitor
					  where group_name = @group_name and field_name = @tmp
			select @output = @output + ltrim(str(@n,10)) + @sep + 
					ltrim(str(@buff_grabbed,20)) + @sep + 
					ltrim(str(@buff_grabbed_dirty,20))
			select @n = @n * 2
			if(@n <= 8*@KBperpage)
				select @output = @output + '|'
		end
		select @output as lock_details
	end
	/* ----------------------- SybTransactionLogTest -------------------------------- */
	if(@testIndex = 6)
	begin
		select @total = SUM(value) from tempdb.dbo.egtempmonitor
		  where group_name = 'xls' and field_name like 'plc_flush_%'
		if(@total = 0)
		begin
			select @output = '0,0,0,0,0'		
		end
		else
		begin
			/* By Full ULC (%) */
			select @m1 = value from tempdb.dbo.egtempmonitor
			  where group_name = 'xls' and field_name = 'plc_flush_full'
			select @m1 = 100 * @m1 / @total
			select @output = ltrim(str(@m1,10,3))

			/* By End Transaction (%)  */
			select @m1 = value from tempdb.dbo.egtempmonitor
			  where group_name = 'xls' and field_name = 'plc_flush_endxact'
			select @m1 = 100 * @m1 / @total
			select @output = @output + @sep + ltrim(str(@m1,10,3))

			/* By Change of Database (%) */
			select @m1 = value from tempdb.dbo.egtempmonitor
			  where group_name = 'xls' and field_name = 'plc_flush_xdeschange'
			select @m1 = 100 * @m1 / @total
			select @output = @output + @sep + ltrim(str(@m1,10,3))

			/* By System Log Record (%) */
			select @m1 = value from tempdb.dbo.egtempmonitor
				  where group_name = 'xls' and field_name = 'plc_flush_slr_xact'
			select @m1 = 100 * @m1 / @total
			select @output = @output + @sep + ltrim(str(@m1,10,3))

			/* By other (%) */
			select @m1 = SUM(value) from tempdb.dbo.egtempmonitor
			  where group_name = 'xls' and field_name IN 
				('plc_flush_unpin','plc_flush_discard','plc_flush_pmscan')
			select @m1 = 100 * @m1 / @total
			select @output = @output + @sep + ltrim(str(@m1,10,3))
		end	
		select @output
	end
	/* ----------------------- SybTasksTest -------------------------------- */
	if(@testIndex = 7)
	begin
		declare @context_switches real	/* Total context switches */
		declare @known_reasons real	/* counter for known reasons */
		declare @task1 real	/* Voluntary Yields */
		declare @task2 real	/* Cache search misses */
		declare @task3 real	/* System Disk Writes */
		declare @task4 real	/* I/O Pacing	*/
		declare @task5 real	/* Logical Lock Contention */
		declare @task6 real	/* Address Lock Contention */
		declare @task7 real	/* Latch Contention */
		declare @task8 real	/* Log Semaphore Contention */
		declare @task9 real	/* PLC Lock Contention */
		declare @task10 real	/* Group Commit Sleeps */
		declare @task11 real	/* Last Log Page Writes */
		declare @task12 real	/* Modify Conflicts */
		declare @task13 real	/* I/O Device Contention */
		declare @task14 real	/* Network Packet Received */
		declare @task15 real	/* Network Packet Sent */
		declare @task16 real	/* Other causes */

		select @context_switches=value from tempdb.dbo.egtempmonitor 
			where group_name = 'tasks' and	field_name = 'context_switches'
		if(@context_switches=0)
		begin
			select 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		end
		else
		begin
			select @task1=value from tempdb.dbo.egtempmonitor 
				where group_name = 'kernel' and	field_name = 'yields'
			select @known_reasons = @task1
			select @task1 = 100 * @task1 / @context_switches

			select @task2=sum(value) from tempdb.dbo.egtempmonitor 
				  where group_name like 'buffer_%' and field_name='bufread_read_waits'
			select @known_reasons = @known_reasons + @task2
			select @task2 = 100 * @task2 / @context_switches

			select @task3=sum(value) from tempdb.dbo.egtempmonitor 
				  where group_name like 'buffer_%' and
				  field_name in ('write_waits', 'hk_write_waits', 'restart_io_waits')
			select @known_reasons = @known_reasons + @task3
			select @task3 = 100 * @task3 / @context_switches

			select @task4=sum(value) from tempdb.dbo.egtempmonitor 
				  where group_name like 'buffer_%' and
				field_name in ('my_start_waits_log','my_start_waits_non-log','my_other_waits_non-log')
			select @known_reasons = @known_reasons + @task4
			select @task4 = 100 * @task4 / @context_switches

			select @task5=sum(value) from tempdb.dbo.egtempmonitor 
				  where group_name = 'lock' and
				field_name like 'waited_%' and field_name not like 'waited_%_ADDR'
			select @known_reasons = @known_reasons + @task5
			select @task5 = 100 * @task5 / @context_switches

			select @task6=sum(value) from tempdb.dbo.egtempmonitor 
				  where group_name = 'lock' and	field_name like 'waited_%_ADDR'
			select @known_reasons = @known_reasons + @task6
			select @task6 = 100 * @task6 / @context_switches

			select @task7=value from tempdb.dbo.egtempmonitor 
				  where group_name = 'tasks' and field_name='latch_contention'
			select @known_reasons = @known_reasons + @task7
			select @task7 = 100 * @task7 / @context_switches

			select @task8=value from tempdb.dbo.egtempmonitor 
				where group_name = 'xls' and field_name = 'log_lock_waited'
			select @known_reasons = @known_reasons + @task8
			select @task8 = 100 * @task8 / @context_switches

			select @task9=value from tempdb.dbo.egtempmonitor 
				where group_name = 'xls' and field_name = 'plc_lock_waits'
			select @known_reasons = @known_reasons + @task9
			select @task9 = 100 * @task9 / @context_switches

			select @task10=value from tempdb.dbo.egtempmonitor 
				  where group_name like 'buffer_%' and
				field_name IN ('my_other_waits_log', 'log_lastpage_pending_io_sleeps')
			select @known_reasons = @known_reasons + @task10
			select @task10 = 100 * @task10 / @context_switches

			select @task11=value from tempdb.dbo.egtempmonitor 
				  where group_name like 'buffer_%' and field_name = 'last_log_page_writes'
			select @known_reasons = @known_reasons + @task11
			select @task11 = 100 * @task11 / @context_switches

			select @task12=value from tempdb.dbo.egtempmonitor 
			  where group_name like 'buffer_%' and field_name in 
				  ('changing_state_waits', 'bufwrite_changing_waits', 
				   'bufpredirty_write_waits', 'bufpredirty_changing_waits', 
				   'bufnewpage_changing_waits', 'ind_bufguess_changing_waits',
				   'ind_bufguess_writing_waits')
			select @known_reasons = @known_reasons + @task12
			select @task12 = 100 * @task12 / @context_switches

			select @task13=value from tempdb.dbo.egtempmonitor 
				where group_name='tasks' and field_name='device_contention'
			select @known_reasons = @known_reasons + @task13
			select @task13 = 100 * @task13 / @context_switches

			select @task14=value from tempdb.dbo.egtempmonitor 
				where group_name = 'network' and field_name = 'total_packets_received'
			select @known_reasons = @known_reasons + @task14
			select @task14 = 100 * @task14 / @context_switches

			select @task15=value from tempdb.dbo.egtempmonitor 
				  where group_name = 'network' and field_name = 'total_packets_sent'
			select @known_reasons = @known_reasons + @task15
			select @task15 = 100 * @task15 / @context_switches

			select @task16 = @context_switches - @known_reasons
			select @task16 = 100 * @task16 / @context_switches
			
			select ltrim(str(@task1,7,3)),ltrim(str(@task2,7,3)),
			       ltrim(str(@task3,7,3)),ltrim(str(@task4,7,3)),
			       ltrim(str(@task5,7,3)),ltrim(str(@task6,7,3)),
			       ltrim(str(@task7,7,3)),ltrim(str(@task8,7,3)),
			       ltrim(str(@task9,7,3)),ltrim(str(@task10,7,3)),
			       ltrim(str(@task11,7,3)),ltrim(str(@task12,7,3)),
			       ltrim(str(@task13,7,3)),ltrim(str(@task14,7,3)),
			       ltrim(str(@task15,7,3)),ltrim(str(@task16,7,3))
		end
	end

end
/*sp_egmonitor_dd:end*/
