<!DOCTYPE html>

<%
/*******************************************************************************
*	File name			:	ErVDIAssessmentPrint.jsp
*	Purpose				:	Print Page For Virtual Desktop Insight - VDI Assessment
*	Author				:	A.MuraliKanth
*	Creation Date		:	27/11/2012 - (dd/mm/yyyy)
********************************************************************************/
%>
<%@ include file = "ErTracker.jsp" %>
<%@ page import="com.eg.EgDbInfo" %>
<%@ page import = "com.eg.EgReportInfo"%>
<%@ page import = "com.egurkha.util.DateUtil" %>
<%@ page import = "com.egurkha.util.EgSorter" %>
<%@ page import = "egurkha.reporter.ErUtils" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="com.egurkha.util.StringUtils"%>

<%
String titleToDisplay=request.getParameter("er_RmDispName");					
	String subjectForChart = "Desktop_Insight_Resource_Usage_Chart_Details";
	String subjectForConfig = "Desktop_Insight_Resource_Usage";
	String subjectForApp = "Desktop_Insight_Application_Activity";

	EgReportInfo reportInfo = new EgReportInfo("manager");
	ErUtils erUtils = new ErUtils();
	EgDbInfo dbInfo=new EgDbInfo("manager");

	HashMap chartAttributeMaps=null;
	HashMap MeasureGroupWithUnit=null;	
	HashMap unitForMeasure=null;	
	HashMap HighRangeDesktopCountMap=null;
	ArrayList overAllData=null;
	ArrayList DataAvailableMeasureGroup=null;
	ArrayList MeasureGrup=null;

	String hasShowAllDesktops=reportInfo.getValue(subjectForConfig,"ShowAllDesktopData");
	String measurGroupForSortingFromIni=reportInfo.getValue(subjectForApp,"sortOnTheBasisOf");
	String doubleByteEnabled=new Boolean(dbInfo.doubleByteEnabled).toString();
	String fontStyleDblSingl = "";
	String reporttype=request.getParameter("reporttype");
	String subtype=request.getParameter("subtype");
	String selectedCompType=request.getParameter("er_componentType");
	String selectedGroup=request.getParameter("er_group");
	String analysis_data=request.getParameter("analyseDataBy");
	String er_mode=request.getParameter("er_mode");
	String s_st_time=request.getParameter("startdate");
	String s_en_time=request.getParameter("enddate");
	String s_st_hr=request.getParameter("starthr");
	String s_en_hr=request.getParameter("endhr");
	String strmin=request.getParameter("startmin");
	String enmin=request.getParameter("endmin");
	String Hourfrom = request.getParameter("timefrom");
	String Minfrom = request.getParameter("minfrom");
	String Hourto = request.getParameter("timeto");
	String Minto = request.getParameter("minto");
	String pdfSave = request.getParameter("pdfSave");
	String dispStartDate=s_st_time+" "+s_st_hr+" Hrs "+strmin+" Mins ";
	String dispEndDate=s_en_time+" "+s_en_hr+" Hrs "+enmin+" Mins ";
	String timfrom=Hourfrom+":"+Minfrom;
	String timto=Hourto+":"+Minto;
	String measurGroupForSorting="";
	Float minusFive = new Float(-5.0f);
	/** result data getting starts **/
	if(reporttype!=null && reporttype.equalsIgnoreCase("vdi_insight"))
	{
		if(subtype!=null && subtype.equalsIgnoreCase("resource_usage"))
		{
			chartAttributeMaps=(HashMap)session.getAttribute("chartMaps");
			MeasureGroupWithUnit=(HashMap)session.getAttribute("MeasureGroupWithUnit");
			HighRangeDesktopCountMap=(HashMap)session.getAttribute("HighRangeDesktopCountMap");
			overAllData=(ArrayList)session.getAttribute("overAllDataByDesktop");
			DataAvailableMeasureGroup=(ArrayList)session.getAttribute("DataAvailableMeasureGroup");
			if(HighRangeDesktopCountMap!=null && !HighRangeDesktopCountMap.isEmpty())
			{
				ArrayList max_values=new ArrayList(HighRangeDesktopCountMap.values());
				Integer maxObj=(Integer)Collections.max(max_values);
				Iterator highRangeMapItr=HighRangeDesktopCountMap.keySet().iterator();
				while(highRangeMapItr.hasNext())
				{
					String msureGroup=(String)highRangeMapItr.next();
					Integer highrangeInt=(Integer)HighRangeDesktopCountMap.get(msureGroup);
					if(highrangeInt.equals(maxObj))
					{
						measurGroupForSorting=msureGroup;
						continue;
					}
				}
				int noOfColumn=DataAvailableMeasureGroup.size();
				int columnId=0;
				if(measurGroupForSorting!=null)
				{
					columnId=DataAvailableMeasureGroup.indexOf(measurGroupForSorting);
				}
				if(columnId==-1)
					columnId=0;
				EgSorter sortObj = new EgSorter(overAllData,noOfColumn);
				columnId+=2;
				overAllData=(ArrayList)sortObj.sort(columnId,"Float","desc");
			}
		}
		else if(subtype!=null && subtype.equalsIgnoreCase("application_activity"))
		{
			unitForMeasure = (HashMap)session.getAttribute("unitForMeasure");
			overAllData=(ArrayList)session.getAttribute("overallDataByAppln");
			DataAvailableMeasureGroup=(ArrayList)session.getAttribute("DataAvailableMeasureGroups");
			MeasureGrup =(ArrayList)session.getAttribute("MeasureGrup");
			if(overAllData!=null && overAllData.size()>0)
			{
				//sorting starts
				int noOfColumn=DataAvailableMeasureGroup.size();
				int columnId=0;
				if(measurGroupForSortingFromIni!=null && DataAvailableMeasureGroup!=null && DataAvailableMeasureGroup.size()>0)
				{
					columnId=DataAvailableMeasureGroup.indexOf(measurGroupForSortingFromIni);
				}
				if(columnId==-1)
					columnId=0;
				EgSorter sortObj = new EgSorter(overAllData,noOfColumn);
				columnId+=2;
				overAllData=(ArrayList)sortObj.sort(columnId,"Float","desc");
			}
			//sorting ends
		}
	}
	/**ends**/
	if((dbInfo.doubleByteEnabled || !thisuser.getLanguage().equals("en_US")) && !(pdfSave !=null && pdfSave.equalsIgnoreCase("yes")))
	{
		fontStyleDblSingl = "multi_font";
	}
	else
	{
		fontStyleDblSingl = "";
	}

		if(throughSchedule!=null && throughSchedule.equalsIgnoreCase("true"))
		{			 
			s_st_time = DateUtil.changeDateFormat(s_st_time.trim(),"dd-MM-yyyy",strUserDateFormat);
			s_en_time = DateUtil.changeDateFormat(s_en_time.trim(),"dd-MM-yyyy",strUserDateFormat);
		}
	EgTimeZoneConverter converterStart =new   EgTimeZoneConverter(s_st_time+" "+s_st_hr+":"+strmin,thisuser);
	String st_dateTime = converterStart.getDateTime()+" "+"hrs ";
	EgTimeZoneConverter converterEnd = new EgTimeZoneConverter(s_en_time+" "+s_en_hr+":"+enmin,thisuser);
	String en_dateTime = converterEnd.getDateTime()+" "+"hrs ";

%>
<html>
	<head>
		<title>&nbsp; <egui:intnl text="reporter.common.Reporter"/> &nbsp; &nbsp;</title>

<meta name="Author" content="">
<meta  charset="UTF-8">

<link rel="stylesheet" type="text/css" href="/final/reporter/styles/printpagestyle.css" />
<link rel="stylesheet" type="text/css" href="/final/styles/eGLightThemeIcons.css" />
<style>

@media print {body {-webkit-print-color-adjust: exact;}}



body{font-family:'LucidaGrandeRegular';font-size:11px;line-height:1.5em;color:#2a292a;}
header{font-family:'LucidaGrandeRegular';font-size:15px;}
.formLabel {font-family:'LucidaGrandeRegular';font-size:12px;line-height:14px;}
.formValue {font-family:'LucidaGrandeBold';font-size:12px;line-height:14px;}
b{font-family:'LucidaGrandeBold';font-size:11px;}
table tr td{font-family:'LucidaGrandeRegular';font-size:11px;padding:4px;}

.printTable{border: 1px solid #c3c3c3; border-collapse: collapse;}
.printTable tr .tdClass{border: 1px solid #c3c3c3;}

.printTableHeader{font-family:'LucidaGrandeBold';border: 1px solid #c3c3c3;text-align:center;background-color:#cdcdcd;padding:4px;}
.printTableHeader2{font-family:'LucidaGrandeBold';border: 1px solid #c3c3c3;text-align:center;background-color:#dcdcdc;padding:4px;}

</style>


<style type="text/css" media="print">
#printbt{ display:none}
</style>

<style>
@page {size : landscape; margin : 0in }
@page :footer {content: none, "Macro Home" decimal(pageno), none;}
</style>
		<!--<egui:skin ui="reporter"/>-->
</head>

<body  style="padding:10px;background-color:#ffffff">
<table border="0" cellspacing="0" cellpadding="0" width="100%" style="table-layout:fixed;">
	<tr>
		<td width="100%" align="center" valign="top">

<%
		if((pdfSave!=null && pdfSave.equalsIgnoreCase("yes")) ||( throughSchedule!=null && throughSchedule.equalsIgnoreCase("true")))
		{
%>
			<table cellpadding="0" cellspacing="2" border="0" width="100%" align="center">
				<tr>
					<td class="cellbgwhite"><img src="<%=imageName%>" border="0" /></td>
				</tr>
			</table>
<%
		}
%>
			<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center"  style="border-bottom:1px solid #999;">
				<tr>
					<td style="padding:2px" align="left">

<%
		if (!StringUtils.isNull(titleToDisplay))
		{
%>
						<div style="float:left;" > <header><%=titleToDisplay%></header></div>
<%
		}
		else
		{
%>

						<div style="float:left;" > <header><egui:intnl text="reporter.common.Virtual Desktop Insight"/> - 
<%
			if(subtype!=null && subtype.equalsIgnoreCase("resource_usage"))
			{
%>
								<egui:intnl text="reporter.common.Resource Usage" />
<%
			}
			else if(subtype!=null && subtype.equalsIgnoreCase("application_activity"))
			{
%>
								<egui:intnl text="reporter.common.Application Activity" />
<%
			}
%>
						</header></div>
<%
		}
%>





<%
		if((pdfSave!=null && pdfSave.equalsIgnoreCase("yes")) ||( throughSchedule!=null && throughSchedule.equalsIgnoreCase("true")))
		{
%>
						<!--nothing going here-->
<%
		}
		else
		{
%>
						<div style="float:right"><img class="iconPrinter mouse"  id="printbt" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" border="0" onClick="window.print()" alt='<egui:intnl text="reporter.common.PRINT"/>' title='<egui:intnl text="reporter.common.PRINT"/>'/></div>
<%
		}
%>
					</td>
				</tr>
			</table>

			<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center" style="border-bottom:1px solid #ccc;">
				<tr>
					<td align="left" valign="top" width="50%">
						<div style="float:left;padding:4px;">
							<div style="float:left" class="formLabel"><egui:intnl text="reporter.common.Component Type"/></div>
							<div style="float:left;width:10px" align="center" >:</div>
							<div style="float:left;" class="formValue"><egui:intnl type="<%=selectedCompType%>"/></div>
						</div>

						<div style="float:left;clear:both;padding:4px;">
							<div style="float:left" class="formLabel"><egui:intnl text="reporter.common.Analysis By"/></div>
							<div style="float:left;width:10px" align="center" >:</div>
							<div style="float:left;" class="formValue"><egui:intnl text='<%="reporter.common."+selectedGroup%>'/></div>
						</div>
<%
		if(subtype!=null && subtype.equalsIgnoreCase("resource_usage"))
		{
%>
						<div style="float:left;clear:both;padding:4px;">
							<div style="float:left" class="formLabel"><egui:intnl text="reporter.common.Analysis Data By"/></div>
							<div style="float:left;width:10px" align="center" >:</div>
<%
			if(analysis_data!=null && analysis_data.equalsIgnoreCase("user"))
			{
%>
							<div style="float:left;" class="formValue"><egui:intnl text="reporter.common.User"/></div>
<%
			}
			else
			{
%>
							<div style="float:left;" class="formValue"><egui:intnl text="reporter.common.Desktop"/></div>
<%
			}
%>
						</div>
<%
		}
%>

<%
		if(subtype!=null && subtype.equalsIgnoreCase("application_activity") && DataAvailableMeasureGroup.contains(measurGroupForSortingFromIni))
		{
%>
						<div style="float:left;clear:both;padding:4px;">
							<div style="float:left" class="formLabel"><egui:intnl text="reporter.common.Data Sorted By"/></div>
							<div style="float:left;width:10px" align="center" >:</div>
							<div style="float:left;" class="formValue"><egui:intnl text='<%="reporter.common."+measurGroupForSortingFromIni%>'/></div>
						</div>
<%
		}
		if(subtype!=null && subtype.equalsIgnoreCase("resource_usage"))
		{
			String tmp_sort=reportInfo.getValue(subjectForChart,measurGroupForSorting);
%>
						<div style="float:left;clear:both;padding:4px;">
							<div style="float:left" class="formLabel"><egui:intnl text="reporter.common.Data Sorted By"/></div>
							<div style="float:left;width:10px" align="center" >:</div>
							<div style="float:left;" class="formValue"><%=tmp_sort.substring(tmp_sort.indexOf(" on ")+4)%></div>
						</div>
			<%
		}
			%>
					</td>
					<td align="right" valign="top">
						<div style="float:right;padding:4px;">
							<div style="float:left" class="formLabel"><egui:intnl text="reporter.common.StartDate"/></div>
							<div style="float:left;width:10px" align="center" >:</div>
							<div style="float:left;" class="formValue"><%=st_dateTime%></div>
						</div>
						<div style="clear:both;float:right;padding:4px;">
							<div style="float:left" class="formLabel"><egui:intnl text="reporter.common.EndDate"/></div>
							<div style="float:left;width:10px" align="center">:</div>
							<div style="float:left;" class="formValue"><%=en_dateTime%></div>
						</div>
						<div style="clear:both;float:right;padding:4px;">
							<div style="float:left" class="formLabel"><egui:intnl text="reporter.common.Time Period"/></div>
							<div style="float:left;width:10px" align="center">:</div>
							<div style="float:left;" class="formValue"><%=timfrom%>&nbsp;<egui:intnl text="reporter.common.to"/>&nbsp;<%=timto%></div>
						</div>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table><br/>

<%
		if(subtype!=null && subtype.equalsIgnoreCase("resource_usage"))
		{
			//String tmp_sort=reportInfo.getValue(subjectForChart,measurGroupForSorting);
			if(DataAvailableMeasureGroup!=null && !DataAvailableMeasureGroup.isEmpty())
			{
%>
<table align="center" width="100%" cellspacing="0" cellpadding="0"  border="0" >
<%
				if(DataAvailableMeasureGroup.size()>1)
				{
%>
	<col width="50%"><col width="50%">
<%
				}
				int noOfCharts=DataAvailableMeasureGroup.size();
				int chartCount=0;
				for(int i=0;DataAvailableMeasureGroup.size()>i;i++)
				{
					String queryStrPie="/final/servlet/com.eg.ErVDIAssessmentController;jsessionid=" + session.getId() +"?&er_view=IMAGE&reporttype="+reporttype+"&subtype="+subtype+"&doubleByteEnabled="+doubleByteEnabled+"&er_mode="+er_mode;
					String measureGroup=(String)DataAvailableMeasureGroup.get(i);
					HashMap chartAttributes=(HashMap)chartAttributeMaps.get(measureGroup);
					ArrayList sampleLabels=(ArrayList)chartAttributes.get("sampleLabels");
					ArrayList DataSet=(ArrayList)chartAttributes.get("sampleValues");
					ArrayList colorList=(ArrayList)chartAttributes.get("sampleColors");
					String chartTitle=(String)chartAttributes.get("chartTitle");
					String dynamicDivName="chart"+chartCount+"div";
					queryStrPie+="&measureGroup="+measureGroup;
					if(chartCount%2==0)
					{
%>
	<tr>
<%
					}
					String custom_chartType = reportInfo.getValue("Desktop_Insight_Resource_Usage","chartType");
					String er_width = "200";
					String er_height = "200";
					if(custom_chartType!=null && custom_chartType.equalsIgnoreCase("bar"))
					{
						er_width = "400";
						er_height = "300";
					}
%>
		<td>
			<table  align="center" width="100%" cellspacing="0" cellpadding="0" style="table-layout:fixed" class="printTable">
				<tr>
					<td align="center" class="printTableHeader2"><b><%=chartTitle%></b></td>
				</tr>
				<tr>
					<td>
						<div style="width:100%;border : 0px solid red" id="<%=dynamicDivName%>" align="center" >
							<img src="<%=queryStrPie%>&er_width=<%=er_width%>&er_height=<%=er_height%>&chartFor=distribution"scrolling="no" align="center" frameborder="0"></img> 
						</div>
					</td>
				</tr>
<%
				if(custom_chartType==null || !custom_chartType.equalsIgnoreCase("bar"))
				{
%>
				<tr>
					<td align="center" width="100%">
						<table cellpadding="0" cellspacing="0" border="0">
							<tr>
								<td>
									<div style="display:inline-block;margin:auto;border:0px solid red">
<%
					for(int jk=0;sampleLabels.size()>jk;jk++)
					{
						String manualLabel=(String)sampleLabels.get(jk);
						String colorForLegend=(String)colorList.get(jk);
						Integer vmCount=(Integer)DataSet.get(jk);
						if(vmCount.intValue()!=0)
						{
%>
										<div style="float:left;padding:4px;border :0px solid red">
											<div style="float:left;width:8px;height:8px;background-color:<%=colorForLegend%>;margin:2px" class="blankspace"></div>
											<div style="float:left;text-align:left;"><%=manualLabel%></div>
											<div style="float:left;width:5px;">&nbsp;</div>
										</div>
<%
						}
					}
%>
									</div>
								</td>
							</tr>
						</table>
					</td>
				</tr>
<%
				}
%>
			</table>
		</td>
<%
					if(noOfCharts%2>0 && noOfCharts==chartCount+1)
					{
%>
		<td align="center" >&nbsp;</td>
<%
					}
%>
<%
					if(chartCount!=0 && chartCount%2>0)
					{
%>
	</tr>
<%					}
					chartCount++;
				}
%>
</table><br/>
<%
				if(DataAvailableMeasureGroup!=null)
				{
%>
<table align="center" width="100%" cellspacing="0" cellpadding="0"  border="0" class="printTable">
	<tr align="center">
		<td align ="center" style="width:150px" class="printTableHeader2"><egui:intnl text="reporter.common.Desktop"/></td>
<%
					for(int i=0;DataAvailableMeasureGroup.size()>i;i++)
					{
							String measures=(String)DataAvailableMeasureGroup.get(i);
							String tmp=reportInfo.getValue(subjectForChart,measures);
							String MappedMeasure=tmp.substring(tmp.indexOf(" on ")+4);
%>
		<td align="center" class="printTableHeader2"> <egui:intnl text='<%="reporter.common."+MappedMeasure%>'/>
<%
						if(measurGroupForSorting!=null && measurGroupForSorting.equals(measures))
						{
%>
										<!--<img src="/final/reporter/images/Light/gcircle.gif" align="center"/>-->
<%
						}
%>
		</td>
<%
					}
%>
	</tr>
<%
			//	} dataavailablemeasuregroup if loop ends
					if(MeasureGroupWithUnit!=null && DataAvailableMeasureGroup!=null)
					{
%>
	<tr>
		<td align ="center" class="tdClass">&nbsp;</td>

<%
						for(int i=0;DataAvailableMeasureGroup.size()>i;i++)
						{
							String measures=(String)DataAvailableMeasureGroup.get(i);
							String unit=(String)MeasureGroupWithUnit.get(measures);
%>
		<td align="center" class="tdClass"> <%=unit%> </td>
<%
						}
%>
	</tr>
<%
					}
				}
				if(overAllData!=null && !overAllData.isEmpty())
				{
					int noOfRows=overAllData.size();
					if(hasShowAllDesktops!=null && hasShowAllDesktops.equalsIgnoreCase("No"))
					{
						int maxDesktop=Integer.parseInt(reportInfo.getValue(subjectForConfig,"MaximumDesktops"));
						int noOfRowsToDisplay=Integer.parseInt(reportInfo.getValue(subjectForConfig,"noOfDesktopToDisplay"));
						if(noOfRows>maxDesktop && maxDesktop>noOfRowsToDisplay)
							noOfRows=noOfRowsToDisplay;
					}
					for(int i=0;noOfRows>i;i++)
					{
						ArrayList dataList=(ArrayList)overAllData.get(i);
						String s_desktop=(String)dataList.get(0);
						
%>
	<tr>
		<td align="center"  class="tdClass"><div style="width:150px;word-wrap: break-word; overflow-x:auto;"><%=s_desktop%></div></td>
<%
						if(dataList!=null)
						{
							for(int j=1;dataList.size()>j;j++)
							{
								Float data=(Float)dataList.get(j);

								if(data.compareTo(minusFive)>0)
								{
									float f_data=data.floatValue();
%>
		<td align="center"  class="tdClass"><%=erUtils.round(f_data,4)%></td>
<%
								}
								else
								{
%>
		<td align="center"  class="tdClass">-</td>
<%
								}
							}
						}
%>
	</tr>
<%
					}
				}
			}
			else
			{
%>
	<tr>
		<td height="20" >&nbsp;</td>
	</tr>
	<tr>
		<td height="26" align="center" ><egui:intnl text="reporter.common.No measures available for the current selection"/> </td>
	</tr>
	<tr>
		<td height="20">&nbsp;</td>
	</tr>
<%
			}
%>
</table>
<%
		}
		else if(subtype!=null && subtype.equalsIgnoreCase("application_activity"))
		{
%>


<%
			if(MeasureGrup!=null && !MeasureGrup.isEmpty())
			{
%>
<table align="center" width="100%" cellspacing="0" cellpadding="0" style="table-layout:auto" >
<%
				if(MeasureGrup.size()>1)
				{
					System.out.println("coming--->");
%>
	<col width="50%"><col width="50%">
<%
				}
				int noOfCharts=MeasureGrup.size();
				int chartCount=0;
				String title = "";
				for(int i=0;MeasureGrup.size()>i;i++)
				{
					String queryStrBar="/final/servlet/com.eg.ErVDIAssessmentController;jsessionid=" + session.getId() +"?&er_view=IMAGE&reporttype="+reporttype+"&subtype="+subtype+"&doubleByteEnabled="+doubleByteEnabled+"&er_mode="+er_mode;
					String measureGroup=(String)MeasureGrup.get(i);
					title =reportInfo.getValue(subjectForApp,measureGroup);
					String dynamicDivName="chart"+chartCount+"div";
					queryStrBar+="&measureGroup="+measureGroup;
					if(chartCount%2==0)
					{
%>
	<tr>
<%
					}
%>
		<td align="center" >
			<table class="printTable" align="center" width="100%" cellspacing="0" cellpadding="2" style="table-layout:fixed">
				<tr>
					<td class="printTableHeader" align="center" width="100%" NOWRAP align="left"><%=title%></td>
				</tr>
				<tr>
					<td>
						<div style="width:100%;border : 0px solid red" id="<%=dynamicDivName%>" align="center" >
<%
					if(DataAvailableMeasureGroup!=null && DataAvailableMeasureGroup.contains(measureGroup))
					{
%>
							<img src="<%=queryStrBar%>&er_width=350&er_height=400&chartFor=distribution"scrolling="no" align="center" frameborder="0"></img> 
<%
					}
					else
					{
%>
							<img src='/final/images/Light/nomeasures_custom.png' width="100%"><!--BLANK CELL OR NO GRAPH-->&nbsp;
<%
					}
%>
						</div>
					</td>
				</tr>
			</table>
		</td>
<%
					if(noOfCharts%2>0 && noOfCharts==chartCount+1)
					{
%>
		<td align="center" >&nbsp;</td>
<%
					}
					if(chartCount!=0 && chartCount%2>0)
					{
%>
	</tr>
<%
					}
					chartCount++;
				}
%>
</table>
<%
			}
			else
			{
%>
<table align="center" width="100%" cellspacing="0" cellpadding="0" style="table-layout:fixed">
	<tr>
		<td align="center" ><egui:intnl text="reporter.common.No measures available for the current selection"/></td>
	</tr>
</table>
<%
			}
%>
<%//data for application activity starts
			if(DataAvailableMeasureGroup!=null && overAllData!=null && overAllData.size()>0)
			{
%>
<table align="center" width="100%" cellspacing="0" cellpadding="0" class="printTable" border="0" >
	<tr align="center">
		<td align ="center" class="printTableHeader2" ><egui:intnl text="reporter.common.Application"/></td>
<%
				for(int i=0;DataAvailableMeasureGroup.size()>i;i++)
				{
					String measures=(String)DataAvailableMeasureGroup.get(i);
%>
		<td align="center" class="printTableHeader2"><egui:intnl text='<%="reporter.common."+measures%>'/></td>
<%
				}
%>
	</tr>
<%
				if(unitForMeasure!=null)
				{
%>
	<tr>
		<td align ="center" class="tdClass">&nbsp;</td>
<%
					for(int i=0;DataAvailableMeasureGroup.size()>i;i++)
					{
						String measures=(String)DataAvailableMeasureGroup.get(i);
						String unit=(String)unitForMeasure.get(measures);
%>
		<td align="center" class="tdClass">(<%=unit%>)</td>
<%
					}
%>
	</tr>
<%
				}
				if(overAllData!=null && !overAllData.isEmpty())
				{
					for(int i=0;overAllData.size()>i;i++)
					{
						ArrayList dataList=(ArrayList)overAllData.get(i);
						String s_appln=(String)dataList.get(0);
%>
	<tr>
		<td align="left" class="tdClass"><div style="width:100px;word-wrap: break-word; overflow-x:auto;"><%=s_appln%></div></td>
<%
						if(dataList!=null)
						{
							for(int j=1;dataList.size()>j;j++)
							{
								String highlightClass="";
							/*	if(sortbyColumnhighlight==j)
								{
									highlightClass="tdborder2";
								}*/
								Float data=(Float)dataList.get(j);
								if(data.compareTo(minusFive)>0)
								{
									float f_data=data.floatValue();
%>
		<td align="center" class="tdClass" ><%=erUtils.round(f_data,4)%></td>
<%
								}
								else
								{
%>
		<td align="center" class="tdClass" >-</td>
<%
								}
							}
						}
%>
	</tr>
<%
					}
				}
%>
</table><br/>
<%
			}//data for application activity ends
		}
%>
</body>
</html>
<%@ include file="ErRemoveUser.jsp"%>


<%
			if(titleToDisplay!=null && !titleToDisplay.isEmpty())
	{
	//For Setting the PDf File Name
	String reportFileName=customReplaceAll(titleToDisplay," ","_");
	HashMap paramVal =new HashMap();
	paramVal.put("fileName",reportFileName);
	session.setAttribute("parameters", paramVal);
	}

%>
<%!
	// karthikeyan 
    public  String customReplaceAll(String source,String toReplace,String replacement) {
        int idx = source.lastIndexOf(toReplace);
        if (idx != -1) {
            StringBuffer ret = new StringBuffer(source);
            ret.replace(idx, idx + toReplace.length(), replacement);
            while ((idx = source.lastIndexOf(toReplace, idx - 1)) != -1) {
                ret.replace(idx, idx + toReplace.length(), replacement);
            }
            source = ret.toString();
        }
        return source;
    }
    //

%>

