<!DOCTYPE html>

<%
/*******************************************************************************
*	File name			:	ErVDIAssessmentDrillDown.jsp
*	Purpose				:	DrillDown Page For Virtual Desktop Insight - VDI Assessment
*	Author				:	A.MuraliKanth
*	Creation Date		:	27/11/2012 - (dd/mm/yyyy)
********************************************************************************/
%>
<%@ include file="ErTracker.jsp" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page import = "com.egurkha.util.EgSorter" %>
<%@ page import = "com.eg.EgReportInfo"%>
<%@ page import = "egurkha.reporter.ErUtils" %>
<%@ page import = "com.eg.EgMappingInfo" %>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%
	try
	{
		IniUI ui = IniUI.getInstance();
		UserRegistry tregistry = UserRegistry.getInstance();
		User tuser = tregistry.getUser(session.getId());
		String thisLanguage = ui.getDefaultLanguage();
		MappingNameSorter sorter = new MappingNameSorter(thisLanguage);
		if (tuser!=null)
		{
			String userLang = tuser.getLanguage();
			if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
			{
				thisLanguage=userLang;
			}
		}
		EgMappingInfo intlmap = new EgMappingInfo(thisuser.getLanguage());

		String subjectForChart ="";

		EgReportInfo reportInfo = new EgReportInfo("manager");
		ErUtils erUtils = new ErUtils();

		HashMap MeasureGroupWithUnit=null;
		HashMap unitForMeasure=null;
		ArrayList overAllData=null;
		ArrayList DataAvailableMeasureGroup=null;

		String reportType=request.getParameter("reporttype");
		String subType=request.getParameter("subtype");
		String measureGroup=request.getParameter("measureGroup");
		String analyseDataBy=request.getParameter("analyseDataBy");

		if(reportType!=null && reportType.equalsIgnoreCase("vdi_insight"))
		{
			if(subType!=null && subType.equalsIgnoreCase("resource_usage"))
			{
				subjectForChart = "Desktop_Insight_Resource_Usage_Chart_Details";
				MeasureGroupWithUnit=(HashMap)session.getAttribute("MeasureGroupWithUnit");
				overAllData=(ArrayList)session.getAttribute("overAllDataByDesktop");
				DataAvailableMeasureGroup=(ArrayList)session.getAttribute("DataAvailableMeasureGroup");
			}
			else if(subType!=null && subType.equalsIgnoreCase("application_activity"))
			{
				subjectForChart = "Desktop_Insight_Application_Activity";
				overAllData=(ArrayList)session.getAttribute("overallDataByAppln");
				unitForMeasure = (HashMap)session.getAttribute("unitForMeasure");
				DataAvailableMeasureGroup=(ArrayList)session.getAttribute("DataAvailableMeasureGroups");
			}
		}
		Float minusFive = new Float(-5.0f);
		int noOfColumn=DataAvailableMeasureGroup.size();
		int columnId=0;
		int sortbyColumnhighlight=0;
		if(measureGroup!=null)
		{
			columnId=DataAvailableMeasureGroup.indexOf(measureGroup);
			sortbyColumnhighlight=columnId+1;
		}
		if(columnId==-1)
			columnId=0;
		EgSorter sortObj = new EgSorter(overAllData,noOfColumn);
		columnId+=2;
		overAllData=(ArrayList)sortObj.sort(columnId,"Float","desc");
%>
<html>
<head>

<meta name="Author" content="">
<meta  charset="UTF-8">

<link rel="stylesheet" type="text/css" href="/final/styles/eGLightTheme.css" />
<link rel="stylesheet" type="text/css" href="/final/styles/eGLightThemeIcons.css" />
<style>

@media print {body {-webkit-print-color-adjust: exact;}}

@font-face{font-family:'LucidaGrandeRegular';src:url('../../fonts/6216/6216.woff') format('woff')}
@font-face{font-family:'LucidaGrandeBold';src:url('../../fonts/6215/6215.woff') format('woff')}

body{font-family:'LucidaGrandeRegular';font-size:11px;line-height:1.5em;color:#2a292a;}
header{font-family:'LucidaGrandeRegular';font-size:15px;}
.formLabel {font-family:'LucidaGrandeRegular';font-size:12px;line-height:14px;}
.formValue {font-family:'LucidaGrandeBold';font-size:12px;line-height:14px;}
b{font-family:'LucidaGrandeBold';font-size:11px;}
table tr td{font-family:'LucidaGrandeRegular';font-size:11px;padding:4px;}

.printTable{border: 1px solid #c3c3c3; border-collapse: collapse;}
.printTable tr td{border: 1px solid #c3c3c3;}

.printTableHeader{font-family:'LucidaGrandeBold';border: 1px solid #c3c3c3;text-align:center;background-color:#cdcdcd;padding:4px;}
.printTableHeader2{font-family:'LucidaGrandeBold';border: 1px solid #c3c3c3;text-align:center;background-color:#dcdcdc;padding:4px;}

</style>


<style type="text/css" media="print">
#printbt, #csvbt, #savebt{ display:none}
</style>

<style>
@page {size : landscape; margin : 0in }
@page :footer {content: none, "Macro Home" decimal(pageno), none;}
</style>

</head>
<body  style="padding:10px;background-color:#ffffff">

<%
		if(reportType!=null && reportType.equalsIgnoreCase("vdi_insight"))
		{
			if(subType!=null && subType.equalsIgnoreCase("resource_usage"))
			{
%>

<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center"  style="border-bottom:1px solid #999;">
	<tr>
		<td style="padding:2px">
			<div style="float:left" > <header><%=intlmap.getTextDescription("reporter.common.DESKTOPS RESOURCE USAGE DETAILS")%></header></div>

			<div style="float:right;padding-left:5px"><img class="iconPrinter mouse"  src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" border="0" onClick="javascript:window.print()" alt='<egui:intnl text="reporter.common.PRINT"/>' title='<egui:intnl text="reporter.common.PRINT"/>'/></div>
		<td>
	</tr>
</table>
<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center" style="border-bottom:1px solid #ccc;">
	<tr>
		<td align="left" valign="top">
			<div style="clear:both;float:left;padding:4px;">
				<div style="float:left" class="formLabel"><%=intlmap.getTextDescription("reporter.common.Data Sorted By")%><%String tmp_sort=reportInfo.getValue(subjectForChart,measureGroup);%></div>
				<div style="float:left;width:10px" align="center" >:</div>
				<div style="float:left;" class="formValue"><%=tmp_sort.substring(tmp_sort.indexOf(" on ")+4)%></div>
			</div>
		</td>
	</tr>
</table><br/>

<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="printTable">
	<tr>
					
<%					if(DataAvailableMeasureGroup!=null)
					{
						//Add column headers
%>
		<td  width="30%" class="printTableHeader2" align="center">
						
<%						if(analyseDataBy!=null && analyseDataBy.equals("user"))
						{
%>
			<%=intlmap.getTextDescription("reporter.common.User")%>
<%						}
						else
						{
%>
			<%=intlmap.getTextDescription("reporter.common.Desktop")%>
<%
						}
%>
		</td>
						
<%
				for(int i=0;DataAvailableMeasureGroup.size()>i;i++)
						{
								String measures=(String)DataAvailableMeasureGroup.get(i);
								String tmp=reportInfo.getValue(subjectForChart,measures);
								String MappedMeasure=tmp.substring(tmp.indexOf(" on ")+4);
								String titlehighlight="x-grid-cell x-grid-cell-first";
								String divhighlight="x-grid-cell-inner";
								
								if(sortbyColumnhighlight==(i+1))
								{
									//titlehighlight ="odd-col";
									//divhighlight="odd-col";
								}
								
%>

		<td class="printTableHeader2" width="75px"  align="center" > <%=intlmap.getTextDescription("reporter.common."+MappedMeasure)%></td>

<%
						}
					}
%>
	</tr>
	<tr>
		<td class="printTableHeader2">&nbsp;</td>
<%
					if(MeasureGroupWithUnit!=null && DataAvailableMeasureGroup!=null)
					{
%>
						
<%						//Add units for columns
						for(int i=0;DataAvailableMeasureGroup.size()>i;i++)
						{
							String measures=(String)DataAvailableMeasureGroup.get(i);
							String unit=(String)MeasureGroupWithUnit.get(measures);
							String titlehighlight="x-grid-cell x-grid-cell-first";
							String divhighlight="x-grid-cell-inner";
							if(sortbyColumnhighlight==(i+1))
							{
								//titlehighlight ="odd-col";
								//divhighlight="odd-col";
							}
							
%>
		<td class="printTableHeader2" width="75px" align="center"> <%=unit%> </td>
	
<%
						}
					}
%>
	</tr>

<%
					if(overAllData!=null && !overAllData.isEmpty())
					{
						//Row data
						for(int i=0;overAllData.size()>i;i++)
						{
							ArrayList dataList=(ArrayList)overAllData.get(i);
							String s_desktop=(String)dataList.get(0);
%>
	<tr>
		<td><b><%=s_desktop%></b></td>
<%
								if(dataList!=null)
								{
									for(int j=1;dataList.size()>j;j++)
									{
										String highlightClass="x-grid-cell x-grid-cell-first";
										String divClass="x-grid-cell-inner";
										if(sortbyColumnhighlight==j)
										{
											highlightClass="odd-col";
											divClass="odd-col";
										}
										Float data=(Float)dataList.get(j);
										if(data.compareTo(minusFive)>0)
										{
											float f_data=data.floatValue();
%>
		<td align="center"><%=erUtils.round(f_data,4)%></td>
<%										}
										else
										{
%>
		<td align="center">-</td>
<%										}
									}
								}
%>
	</tr>
<%
						}
					}
%>
</table>
<%
		}
		else if(subType!=null && subType.equalsIgnoreCase("application_activity"))
		{

%>
<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center"  style="border-bottom:1px solid #999;">
	<tr>
		<td style="padding:2px">
			<div style="float:left" > <header><%=intlmap.getTextDescription("reporter.common.VDI APPLICATION ACTIVITY DETAILS")%></header></div>

			<div style="float:right;padding-left:5px"><img class="iconPrinter mouse"  id="printbt" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" border="0" onClick="javascript:window.print()" alt='<egui:intnl text="reporter.common.PRINT"/>' title='<egui:intnl text="reporter.common.PRINT"/>'/></div>
		<td>
	</tr>
</table>

<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center" style="border-bottom:1px solid #ccc;">
	<tr>
		<td align="left" valign="top">
			<div style="clear:both;float:left;padding:4px;">
				<div style="float:left" class="formLabel"><%=intlmap.getTextDescription("reporter.common.Top Applications - Sorted by ")%></div>
				<div style="float:left;width:10px" align="center" >:</div>
				<div style="float:left;" class="formValue"><%=measureGroup.toUpperCase()%></div>
			</div>
		</td>
	</tr>
</table><br/>

<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="printTable">
	<tr>
<%
							if(DataAvailableMeasureGroup!=null)
							{
%>
		<td class="printTableHeader2" width="20%" align="center"><%=intlmap.getTextDescription("reporter.common.APPLICATION")%></td>

<%
								for(int i=0;DataAvailableMeasureGroup.size()>i;i++)
								{
									//String titleclass="";
									String measures=(String)DataAvailableMeasureGroup.get(i);
								
									//String tmp=reportInfo.getValue(subjectForChart,measures);
									//String MappedMeasure=tmp.substring(tmp.indexOf(" on ")+4);
									String unit=(String)unitForMeasure.get(measures);
									//titleclass="tdborder";

									String titlehighlight="x-grid-cell x-grid-cell-first";
									String divhighlight="x-grid-cell-inner";

									measures = measures.toUpperCase();

%>
		<td class="printTableHeader2" width="75px" align="center" > <%=intlmap.getTextDescription("reporter.common."+measures)%> (<%=intlmap.getTextDescription("reporter.common."+unit)%>)
		</td>

<%
								}
							}
%>

	</tr>
<%
							if(overAllData!=null && !overAllData.isEmpty())
							{
								for(int i=0;overAllData.size()>i;i++)
								{
									ArrayList dataList=(ArrayList)overAllData.get(i);
									String s_appln=(String)dataList.get(0);
%>
	<tr>
		<td ><b><%=s_appln%></b></td>
<%
									if(dataList!=null)
									{
										for(int j=1;dataList.size()>j;j++)
										{
											String highlightClass="x-grid-cell x-grid-cell-first";
											String divClass="x-grid-cell-inner";
											if(sortbyColumnhighlight==j)
											{
											highlightClass="odd-col";
											divClass="odd-col";
											}
											Float data=(Float)dataList.get(j);
										if(data.compareTo(minusFive)>0)
											{
												float f_data=data.floatValue();

%>
		<td align="center"><%=erUtils.round(f_data,4)%></td>

<%
											}
											else
											{
%>
		<td align="center">-</td>
<%
											}
										}
									}
%>
	</tr>
<%
								}
							}
%>
</table>
<%
			}
		}
%>
</body>
</html>
	<%	}
		catch(Exception e)
		{
			e.printStackTrace();
		}
%>
