<%
/*
*	File		: ErShowBookletPDFListJSON.jsp
*	Purpose		: To get the Bookletlist
*	Author		: B.Balamurugan
*/
%>


<%@ include file = "ErReporterTracker.jsp" %>
<%@ page import="net.sf.json.*" %>
<%@ page import="com.eg.EgMappingInfo" %>
<%@ page import="com.eg.*" %>
<%@ page import="com.egurkha.util.*" %>
<%@ page import="java.io.*" %>
<%@ page import="java.util.*" %>
<%@ page import="java.text.SimpleDateFormat" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>


<%
	try
	{
		String userIDBooklet = ((ErUserData) session.getAttribute("UBean")).getUserId();
		ErBookletGroupInfoBean gPDFbean = new ErBookletGroupInfoBean();
		List bookletList =  gPDFbean.getBookletNamesAndIDs(userIDBooklet,true,true);
		List reportList=null;
		
		JSONArray bookletArr = null;
		JSONObject groupBooklet  = new JSONObject();
		if(bookletList!=null)
		{
			JSONObject bookletObj = null;
			JSONObject reportObj = null;
			bookletArr = new JSONArray();
			int bookletSize = bookletList.size();
			for(int ib=0;ib<bookletSize;ib++)
			{
				ErBookletGroupInfoBean booklet =(ErBookletGroupInfoBean)bookletList.get(ib);

				bookletObj = new JSONObject();
				reportObj  = new JSONObject();
				bookletObj.put("bookletID", booklet.getBookletID());
				bookletObj.put("bookletname", booklet.getBookletName());
				if(booklet.getStatus().equalsIgnoreCase("NotGen"))
					bookletObj.put("status","Not Generated");
				else if(booklet.getStatus().equalsIgnoreCase("Completed"))
					bookletObj.put("status","Generated");
				else
					bookletObj.put("status",booklet.getStatus());
				
				bookletObj.put("description",booklet.getDescription());
				bookletObj.put("createdOn",booklet.getCreatedOn());
				bookletObj.put("view","test");
				  
				reportList = booklet.getBookletReportInfo();
				JSONArray reportArray = new JSONArray();
				
				String pdfLocation = EgInstallInfo.getInstallDir()+"/manager/binder/"+booklet.getBookletID()+"/";
				for(int jk=0;jk<reportList.size();jk++)
				{
					ErBookletReportInfoBean rBean=(ErBookletReportInfoBean)reportList.get(jk);
					File file  = new File(pdfLocation+rBean.getReportID()+".pdf");
					String lastModified ="";
					double kilobytes=0.0;
					if(file.exists())
					{
						double bytes = file.length();
						kilobytes = (bytes / 1024);
						if((kilobytes+"").indexOf(".")>-1)
						{
							kilobytes = (Math.round(kilobytes*100))/100;
						}
						SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
						lastModified = sdf.format(file.lastModified());
						lastModified = DateUtil.changeDateFormat(lastModified,"MM/dd/yyyy HH:mm:ss",thisuser.getUserDateFormat()+" HH:mm:ss");
					}
					JSONObject rDetail = new JSONObject();
					Map paramMap = rBean.getParameters();
					String isAnyTimeline = null;
					Object isAnyTimelineObj = paramMap.get("er_timeline");
					if(isAnyTimelineObj instanceof String[])
					{
						String[] isAnyTimeline1=(String[])isAnyTimelineObj;
						isAnyTimeline  = isAnyTimeline1[0];
					}
					else
					{
						isAnyTimeline=(String)(paramMap).get("er_timeline");
					}

					if(isAnyTimeline==null || isAnyTimeline.equalsIgnoreCase("null")|| isAnyTimeline.equalsIgnoreCase("Any")){
						isAnyTimeline = "Any";
					}else if (isAnyTimeline.endsWith("last")){
						String lastCount = isAnyTimeline.substring(0, isAnyTimeline.indexOf(DateTimeTokenizer.BLANK_SPACE));
						String lastTime = isAnyTimeline.substring(isAnyTimeline.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, isAnyTimeline.length());
						String tmpStr = lastTime.substring(0, isAnyTimeline.lastIndexOf("_")-2);
						if(lastCount.equals("1")){
							isAnyTimeline = "Last " + tmpStr ;
						}else{
							isAnyTimeline = "Last " + lastCount + " " + tmpStr;
						}		
					}
						
				
					rDetail.put("reportID",rBean.getReportID());
					rDetail.put("reportNames",rBean.getReportName());
					rDetail.put("isAnyTimeline",isAnyTimeline);
					rDetail.put("pageRange","All pages");
					rDetail.put("fileSize",kilobytes+" KB");
					rDetail.put("modifiedDate",lastModified);
					reportArray.add(rDetail);
				}

				bookletObj.put("reports",reportArray);
				bookletObj.put("bookletItems",reportArray.size()+"");
				bookletObj.put("rOrder",booklet.getReportOrder());
				bookletArr.add(bookletObj);
			}
			groupBooklet.put("bookletArr",bookletArr);
			out.println(groupBooklet.toString());
		}	
	}
	catch(Exception e)
	{
		System.err.println("Exception occur at ErShowBookletPDFListJSON");
		e.printStackTrace();
	}


%>

