<%
/****************************************************************************************
** File					:ErSavedScheduleReports.jsp
** Creation Date		:22/12/2011
** Purpose				:to display the Schedule reports list generated for particular user in date wise view
** Author				:Srinivasulu P
****************************************************************************************/
%>
<%@ page import="com.eg.EgDateInfo" %>
<%@ page import ="com.eg.EgMappingInfo" %>
<%@ page import = "com.egurkha.util.DateUtil" %>
<%@ page import ="java.util.Date" %>
<%@ page import ="com.egurkha.util.StringUtils" %>
<%@include file = "ErReporterTracker.jsp" %>
<%@ page import = "net.sf.json.*" %>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%
try
{
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	String skinColor="";
	skinColor = thisuser.getReporterSkin();
	User this_user = UserRegistry.getInstance().getUser(session.getId());
	String language=this_user.getLanguage();
	String loginid = this_user.getLoginID();
	String user_Role = this_user.getLoginType();
	EgMappingInfo mappingInfo=new EgMappingInfo(language);
	ErSavedScheduleReportBean saveSchBean = new ErSavedScheduleReportBean();
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	String er_reportDate = request.getParameter("er_reportDate");
	String er_search = request.getParameter("er_search");
	String er_reportType = request.getParameter("er_reportType");
	if(er_search==null || er_search.equalsIgnoreCase("null"))
	{
		er_search = "";
	}

	Vector a_list = new Vector();
	ArrayList listReportDates = (ArrayList)request.getAttribute("listReportDates");
	Comparator comparator = Collections.reverseOrder();
	Collections.sort(listReportDates,comparator);
	HashMap listReportDatesDisplay = new HashMap();
	if(listReportDates!=null && listReportDates.size()>0)
	{
		for (int j = 0;j < listReportDates.size();j++)
		{
			String str_date = (String)listReportDates.get(j);
			String str_date_display = DateUtil.changeDateFormat(str_date,"yyyy/MM/dd",currentDateFormat);
			listReportDatesDisplay.put(str_date,str_date_display);
		}
	}
	HashMap listScheduleReports = (HashMap)request.getAttribute("listScheduleReports");
	HashMap schDetails = (HashMap)request.getAttribute("schDetails");
	ArrayList listReportTypes = (ArrayList)request.getAttribute("listReportTypes");
	Collections.sort(listReportTypes);
	if(er_reportDate!=null && listReportDates !=null && listReportDates.size() >0 && listScheduleReports!=null && listScheduleReports.size()>0 )
	{
		for (int j = 0;j < listReportDates.size();j++)
		{
			String str_date = (String)listReportDates.get(j);
			List sch_list = (List)listScheduleReports.get(str_date);
			if(sch_list!=null && sch_list.size()>0)
			{
				for(int ll=0;ll<sch_list.size();ll++)
				{
					String str_sch = (String)sch_list.get(ll);
					String reportType = (String)schDetails.get(str_sch+"_reportType");
					String creationTime = (String)schDetails.get(str_sch+"_creationTime");
					String schedule_Format = (String)schDetails.get(str_sch+"_scheduleFormat");
					if(schedule_Format == null || schedule_Format.length() ==0)
						schedule_Format = "PDF";
	

					if(creationTime!=null && !creationTime.equals(""))
					{
						if(saveSchBean.getTimeValidity(str_date,DateUtil.changeDateFormat(creationTime,"MM/dd/yyyy HH:mm:ss","yyyy/MM/dd")))
						{
							creationTime = DateUtil.changeDateFormat(creationTime,"MM/dd/yyyy HH:mm:ss",currentDateFormat+" HH:mm:ss");
						}
						else
						{
							creationTime = "Not Available";
							reportType = "Not Available";
						}
					}
					else
					{
						creationTime = "Not Available";
					}
					if(reportType==null || reportType.equals(""))
					{
						reportType = "Not Available";
					}
					if(er_reportType==null || (er_reportType!=null && er_reportType.equalsIgnoreCase("All")))
					{
						a_list.add(str_date);
						a_list.add(str_sch);
						a_list.add(reportType);
						a_list.add(creationTime);
						a_list.add(schedule_Format);
						
					}
					else
					{
						if(er_reportType.equalsIgnoreCase(reportType))
						{
							a_list.add(str_date);
							a_list.add(str_sch);
							a_list.add(reportType);
							a_list.add(creationTime);
							a_list.add(schedule_Format);
						}
					}
				}
			}
		}
	}

	int pagelimit=15;
	int maxPage=10,totalNoOfRecPerPage=pagelimit;
	int pageNo = 1 ;
	int total_num_page=1,start_index_page=0,end_index_page=0;
	int startPage=1, endpage =maxPage;
	String strPageNo = request.getParameter("pageno");
	if(strPageNo!=null && !strPageNo.equals("") && !strPageNo.equalsIgnoreCase("null"))
	{
		try
		{
			pageNo = Integer.parseInt(strPageNo);
		}
		catch(Exception e)
		{
			pageNo = 1;
		}
	}

	int tableforDisp=5,colspan;
	if(er_reportDate!=null && er_reportDate.equalsIgnoreCase("All"))
	{
		colspan=tableforDisp+2;
	}
	else
	{
		colspan=tableforDisp+1;
	}
	if(a_list!=null && a_list.size()>0)
	{
		int totalRecord = a_list.size()/tableforDisp;
		total_num_page = (totalRecord/totalNoOfRecPerPage);
		if((totalRecord%totalNoOfRecPerPage)>0)
			total_num_page = total_num_page+1;
	}
	if(pageNo>total_num_page)
		pageNo = total_num_page;
	else if(pageNo<=0)
		pageNo = 1;
	int interIndex = maxPage/2;
	if(pageNo>1)
	{
		int temp = pageNo+1;
		for(int kk=0;kk<=interIndex;kk++) --temp;
		if(temp>0)
			startPage = temp;
		else
			startPage = 1;

		if(pageNo>interIndex)
			endpage = pageNo+ (maxPage - (pageNo+1 - startPage));
		else
			endpage = pageNo+(maxPage-pageNo);
		if(endpage >total_num_page)
			endpage = total_num_page;

		if((endpage-startPage)!=(maxPage-1))
		{
			startPage = total_num_page-(maxPage-1) ;
		}
	}
	JSONObject json = new JSONObject();
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	JSONObject hiddenParams = new JSONObject();
	JSONObject pageParams = new JSONObject();

	screenLabels.put("reporter.consolidated.SCHEDULE GENERATED AND SAVED",mappingInfo.getTextDescription("reporter.consolidated.SCHEDULE GENERATED AND SAVED"));
	screenLabels.put("Display Reports for",mappingInfo.getTextDescription("reporter.common.Display Reports for"));
	screenLabels.put("Search",mappingInfo.getTextDescription("reporter.common.Search"));
	screenLabels.put("Report Type",mappingInfo.getTextDescription("reporter.common.Report Type"));
	screenLabels.put("reporter.common.GENERATION DATE",mappingInfo.getTextDescription("reporter.common.GENERATION DATE"));
	screenLabels.put("reporter.common.SCHEDULE NAME",mappingInfo.getTextDescription("reporter.common.SCHEDULE NAME"));
	screenLabels.put("reporter.common.REPORT NAME",mappingInfo.getTextDescription("reporter.common.REPORT NAME"));
	screenLabels.put("reporter.common.VIEW",mappingInfo.getTextDescription("reporter.common.VIEW"));
	screenLabels.put("reporter.common.ACTION",mappingInfo.getTextDescription("reporter.common.ACTION"));
	screenLabels.put("reporter.common.Submit",mappingInfo.getTextDescription("reporter.common.Submit"));

	hiddenParams.put("forwardto","ErSavedScheduleReports");
	hiddenParams.put("userID",urs);
	//er_reportDate

	JSONArray dateListJson = new JSONArray();
	if(listReportDates !=null && listReportDates.size() >0)
	{
		for (int j = 0;j < listReportDates.size();j++)
		{
			String str_date = (String)listReportDates.get(j);
			String str_date_display = (String)listReportDatesDisplay.get(str_date);
			JSONObject jObj = new JSONObject();
			jObj.put("displayField",mappingInfo.getTextDescription("reporter.consolidated."+str_date_display));
			jObj.put("valueField",str_date);
			dateListJson.add(jObj);
		}
		if(!StringUtils.isNull(er_reportDate))
		{
			pageParams.put("selectedDate",er_reportDate);
		}
		else
		{
			String str_date = (String)listReportDates.get(0);
			pageParams.put("selectedDate",str_date);
		}
	}
	else
	{
		JSONObject jObj = new JSONObject();
		jObj.put("displayField",mappingInfo.getTextDescription("reporter.bgreport.Not Applicable"));
		jObj.put("valueField","Not Applicable");
		dateListJson.add(jObj);
		pageParams.put("selectedDate","Not Applicable");
	}

	rootJson.put("dateListJson",dateListJson);
	JSONArray reportTypesJson = new JSONArray();

	if(listReportTypes !=null && listReportTypes.size() >0)
	{
		for (int j = 0;j < listReportTypes.size();j++)
		{
			String str_type = (String)listReportTypes.get(j);
			JSONObject jObj = new JSONObject();
			jObj.put("displayField",mappingInfo.getTextDescription("reporter.consolidated."+str_type));
			jObj.put("valueField",str_type);
			reportTypesJson.add(jObj);
		}
		if(!StringUtils.isNull(er_reportType))
		{
			pageParams.put("selectedReport",er_reportType);
		}
		else
		{
			String str_type = (String)listReportTypes.get(0);
			pageParams.put("selectedReport",str_type);
		}
	}
	else
	{
		JSONObject jObj = new JSONObject();
		jObj.put("displayField",mappingInfo.getTextDescription("reporter.bgreport.Not Applicable"));
		jObj.put("valueField","Not Available");
		reportTypesJson.add(jObj);
		pageParams.put("selectedReport","Not Available");
	}

	rootJson.put("reportTypesJson",reportTypesJson);

	if(er_reportDate!=null && listReportDates !=null && listReportDates.size() >0 )
	{
		if(a_list!=null && a_list.size()>0)
		{
			int tableSize =  a_list.size();
			rootJson.put("recordsPerPage",String.valueOf(totalNoOfRecPerPage));
			JSONArray gridData = new JSONArray();
			if(er_reportDate!=null && er_reportDate.equalsIgnoreCase("All"))
			{
				pageParams.put("showGenerationDate","true");
			}
			else
			{
				pageParams.put("showGenerationDate","false");
			}
			for(int a=0;a<tableSize;a+=tableforDisp)
			{
				String str_date = (String)a_list.get(a);
				String str_date_display = (String)listReportDatesDisplay.get(str_date);
				String str_sch = (String)a_list.get(a+1);
				String str_reportType = (String)a_list.get(a+2);
				String str_creationTime = (String)a_list.get(a+3);
				String schedule_Format = (String)a_list.get(a+4);
				if(schedule_Format == null || schedule_Format.length()==0 || schedule_Format.equalsIgnoreCase("NULL"))
					schedule_Format = "pdf";
				str_date = DateUtil.changeDateFormat(str_date,"yyyy/MM/dd","MM/dd/yyyy");
				String fileId = str_date.replace("/","")+"$"+str_sch+"$"+schedule_Format;
				String str_sch_disp = "";
				if(str_sch.length()>150)
				{
					str_sch_disp = str_sch.substring(0,50)+"<br>"+str_sch.substring(50,100)+"<br>"+str_sch.substring(100,150)+"<br>"+str_sch.substring(150);
				}
				else if(str_sch.length()>100)
				{
					str_sch_disp = str_sch.substring(0,50)+"<br>"+str_sch.substring(50,100)+"<br>"+str_sch.substring(100);
				}
				else if(str_sch.length()>50)
				{
					str_sch_disp = str_sch.substring(0,50)+"<br>"+str_sch.substring(50);
				}
				else
				{
					str_sch_disp = str_sch;
				}

				JSONObject jObj = new JSONObject();
				jObj.put("sch_id",fileId);

				if(er_reportDate!=null && er_reportDate.equalsIgnoreCase("All"))
				{
					jObj.put("generationDate",str_date_display);
				}
				jObj.put("scheduleName",str_sch);
				jObj.put("reportName",str_reportType);
				gridData.add(jObj);
			
		}
			rootJson.put("gridData",gridData);
		}
		else
		{
			String info_data = "No saved Schedule reports Available for user:"+urs;
			if(er_search!=null && !er_search.equals(""))
			{
				info_data = info_data+" for search:"+er_search;
			}
			if(!er_reportDate.equalsIgnoreCase("All"))
			{
				info_data = info_data+" <br>on date:"+(String)listReportDatesDisplay.get(er_reportDate);
			}
			if(er_reportType!=null && !er_reportType.equalsIgnoreCase("All"))
			{
				info_data = info_data+" By the Report Type:"+er_reportType;
			}

			screenLabels.put("gridErrorMsg",mappingInfo.getTextDescription("reporter.common."+info_data));
		}
	}
	else
	{
		screenLabels.put("gridErrorMsg",mappingInfo.getTextDescription("reporter.common.No Saved Scheduled Reports are available."));
	}

	rootJson.put("screenLabels",screenLabels);
	rootJson.put("pageParams",pageParams);
	rootJson.put("hiddenParams",hiddenParams);

	json.put("rootJson",rootJson);

	response.setContentType("application/json;charset=UTF-8");
	response.getWriter().write(json.toString());
}
catch(Exception e)
{
	e.printStackTrace();
}
%>