<%
/**************************************************************************************************
* File          : ErCtxUserGraph.jsp
* Purpose       : UI for Citrix farm user report
* Creation Date : 05/08/2004
* Author        : S.Solomon.
* Last Modified : 7/12/05 Sri Devi G - Citrix Reports changes - 
*                 Displays the usage details for a paritcular user
*
***************************************************************************************************/
%>
 <%@ page import="java.text.*" %>
<%@ include file="ErReporterTracker.jsp" %>
<%@ page import = "java.util.*" %>
<%@ page import = "java.net.*" %>
<%@ page import = "java.util.Date" %>
<%@ page import = "java.text.SimpleDateFormat" %>
<%@ page import = "java.text.ParseException" %>
<%@ page import = "com.egurkha.util.DateUtil" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgDbInfo" %>
<%@ page import = "com.eg.EgDateInfo" %>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.EgGroupInfo" %>
<%@ page import = "com.eg.EgReportInfo"%>
<%@ page import = "com.eg.ErDbServer"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "egurkha.*" %>
<%@ page import = "com.egurkha.ini.*" %>
<%@ page import = "egurkha.reporter.*" %>
<%@ page import="net.sf.json.*"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "com.eg.EgExternalInfo" %>
<%@ page import = "com.eg.EgFormatInfo" %>

<%

try
{
	ErInfo erInfo = new ErInfo();
	ErUtils erUtils = new ErUtils();
	EgDateInfo egDate = new EgDateInfo();
	EgGroupInfo gpinfo = new EgGroupInfo();
	EgDbInfo dbInfo=new EgDbInfo("manager");
	EgReportInfo reportInfo = new EgReportInfo("manager");
	ErReqData erd = new ErReqData(request);

	com.egurkha.ini.IniUI ui = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	UserRegistry mregistry = UserRegistry.getInstance();
	User muser = mregistry.getUser(session.getId());
	String thisLanguage = ui.getDefaultLanguage();
	if (muser!=null)
	{
		String userLang = muser.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}

	String chartType= null;
	EgMappingInfo mappingInfo=new EgMappingInfo(thisLanguage);
	JSONObject json = new JSONObject();
	JSONObject pageParams = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	JSONObject screenData = new JSONObject();
	JSONObject hiddenParams = new JSONObject();
			JSONArray graphModeArr = new JSONArray();

		JSONObject graphDObj = new JSONObject();
		graphDObj.put("displayField",mappingInfo.getTextDescription("reporter.common.2D"));
		graphDObj.put("valueField","2D");
		graphModeArr.add(graphDObj);
		graphDObj = new JSONObject();
		graphDObj.put("displayField",mappingInfo.getTextDescription("reporter.common.3D"));
		graphDObj.put("valueField","3D");
		graphModeArr.add(graphDObj);

		json.put("graphModeOptions",graphModeArr);
	String mode = request.getParameter("er_mode");
	boolean use3DGraphs = ui.use3DGraphs(IniUI.REPORTER);
	String selectedGraphMode="";
	if(mode!=null&&!mode.equals(""))
	{
		if(mode.equals("2D"))
			selectedGraphMode="2D";
		if(mode.equals("3D"))
			selectedGraphMode="3D";
	}
	else
	{
		if(use3DGraphs)
			selectedGraphMode="3D";
		else
			selectedGraphMode="2D";
	}
	pageParams.put("selectedGraphMode",selectedGraphMode);



	String showAllUsers = null;
	String sSearch = null;
	String tmpComponent="";
	boolean getMoreUsers = false;
	Vector v_u = new Vector();
	Vector v_temp = new Vector();
	ArrayList a_compsForFarm = new ArrayList();
	Vector v_compsForFarm = new Vector();
	ArrayList aListSupportComponentType = new ArrayList();
	long msecsPerHour = (long) 1000 * 60 * 60;

	String s_user = "";
	String reqFromSchedule = request.getParameter("fromSchedule");
	String status = (String)request.getAttribute("status");
	String dispDate = null;
	String comFormat = null;
	String s_st_time= request.getParameter("startdate");
	String s_en_time= request.getParameter("enddate");
	String s_st_hr = request.getParameter("starthr");
	String s_en_hr = request.getParameter("endhr");
	String s_st_min = request.getParameter("startmin");
	String s_en_min = request.getParameter("endmin");
	String opt=request.getParameter("er_trenddata");
	String strGraph = request.getParameter("er_graph");
	String duration = request.getParameter("er_duration");
        String dpSh = request.getParameter("dpSh");
        String dpEh = request.getParameter("dpEh");
	String erOption = request.getParameter("er_option");


	String disable="";
	s_user = request.getParameter("er_user");
	String searchUser = request.getParameter("er_tuser");

	int countForUser = reportInfo.getMoreUsers("CITRIX_USER_REPORT");
	aListSupportComponentType = reportInfo.getComponentsList("CITRIX_USER_REPORT",false);
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	com.eg.IniFile egUI = new com.eg.IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat =strUserDateFormat; //egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	if(s_user == null)
	{
		if(searchUser!=null && !searchUser.equals(""))
		{
			s_user = request.getParameter("er_tuser");
		}
	}
	if(s_user == null)
		s_user = "";

	String queryString = ErUtils.prepareQueryString(request.getParameterMap());
	Map temp_paramMap = ErUtils.parseQueryString(queryString);
	String userName = (String)temp_paramMap.get("er_user");
	temp_paramMap.put("er_user",EgURLEncoder.encode(userName,"UTF-8"));
	if(urs!=null)
	{
		temp_paramMap.put("uid",EgURLEncoder.encode(urs,"UTF-8"));
		temp_paramMap.put("us_id",EgURLEncoder.encode(urs,"UTF-8"));
		temp_paramMap.put("userID",EgURLEncoder.encode(urs,"UTF-8"));
	}
	queryString = ErUtils.prepareQueryString(temp_paramMap);
	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");
	
	String starthour = request.getParameter("starthr");
	String endhour = request.getParameter("endhr");
	String startmin = request.getParameter("startmin");
	String endmin = request.getParameter("endmin");
	String er_timeline=request.getParameter("er_timeline");
	String s_application=request.getParameter("er_application");
	String s_perserver=request.getParameter("er_perserver");
	String s_test=request.getParameter("er_test");
	String s_measure=request.getParameter("er_measure");

	String chartFor=request.getParameter("chartFor");
		
	Vector v_qryStr = (Vector)request.getAttribute("appChartData");
	Vector v_pdf_qryStr = (Vector)request.getAttribute("appPdfData");

	int chartCount = -1;
	if (v_qryStr != null) chartCount = v_qryStr.size() / 2;

	if (startmin!=null )
	{
		if (startmin.length()==1)
			startmin="0"+startmin;
	}
	if (endmin!=null)
	{
		if (endmin.length()==1)
			endmin="0"+endmin;
	}
		String[] options=null;
	if(opt!=null && opt.equals("No"))
	{
		 options = new String[]{"Any","1 hour", "3 hours", "6 hours", "9 hours", "12 hours", "15 hours", "18 hours", "21 hours","1 day", "2 days", "3 days", "4 days", "5 days", "6 days","1 week","2 weeks","3 weeks","4 weeks","1 month"};
	}
	else 
	{
		if(er_timeline!=null && !er_timeline.equals("Any"))
		{
			String tmp=er_timeline.substring(er_timeline.indexOf(" ")+1,er_timeline.length());
			
			if(tmp.startsWith("h"))
			{
				er_timeline="1 day";
			}

		}
		options =new String[]{"Any","1 day", "2 days", "3 days", "4 days", "5 days", "6 days","1 week","2 weeks","3 weeks","4 weeks","1 month"};
	}
	ErReportHelper er_rpthelper = new ErReportHelper();
	List alist = Arrays.asList(options);
	String loginName = muser.getLoginID();
	String strUsrTimeline = er_rpthelper.getUserTimeline(loginName);
	int len;
	if(strUsrTimeline == null || strUsrTimeline.length()==0)
		strUsrTimeline = "-1";
	if(strUsrTimeline != null && !strUsrTimeline.equals("") && !strUsrTimeline.equalsIgnoreCase("-1"))
	{
		len = alist.indexOf(strUsrTimeline)+1;
	}
	else
	{
		len = options.length;
	}
	JSONArray timelineJSONArray =  new JSONArray();

	for(int e_ctr=0; e_ctr < len;e_ctr++)
	{
		JSONObject jObj = new JSONObject();
		jObj.put("displayField",mappingInfo.getTextDescription("reporter.measure."+options[e_ctr]));
		jObj.put("valueField",String.valueOf(options[e_ctr]));
		timelineJSONArray.add(jObj);
	}
	String fontStyleDbl = "";
	String fontStyleDblSingl = "";
	if(dbInfo.doubleByteEnabled || !thisuser.getLanguage().equals("en_US"))
	{
		fontStyleDbl = " multi_font";
		fontStyleDblSingl = "multi_font";
	}
	else
	{
		fontStyleDbl = "";
		fontStyleDblSingl = "";
	}

	pageParams.put("fontStyle",fontStyleDblSingl);
	String s_qryString = "../servlet/com.eg.ErCtxServerReportC?"+queryString+"&option=Graph&printGraph=yes";
	pageParams.put("printPageUrl",s_qryString+"&pdfPrint=yes");
	pageParams.put("pdfUrl",s_qryString);



	String s_farmserver = request.getParameter("select_farm");
	String s_comp = request.getParameter("er_component");

	Vector v_comp=UBean.getAllUserComponents(3);
	String zones[] = gpinfo.getZoneNames();
	//This block is not need here at all.
	if(zones!=null && zones.length > 0)
	{
		for(int z=0; z < zones.length; z++)
		{
			String zone = zones[z];
			ArrayList al = gpinfo.getAllComponentsUnderZone(zone);
			for(int m=0;m<al.size();m++)
			{
				String comp = (String)al.get(m);
				StringTokenizer token1 = new StringTokenizer(comp,":");
				String comptype = "";
				String component = "";
				String port = "";
				String sid = "";
				if (token1.hasMoreTokens())
				{
					comptype=token1.nextToken();
					component = token1.nextToken();
					port =token1.nextToken();
					if(token1.hasMoreTokens())
						sid = token1.nextToken();
				}
				if(sid!=null && !sid.equals(""))
					tmpComponent=component+":"+port+":"+comptype + ":" + sid;
				else
					tmpComponent=component+":"+port+":"+comptype;
				if(v_comp.contains(tmpComponent) && !v_temp.contains(zone))
					v_temp.add(zone);
			}
		}
		if(v_temp!=null && v_temp.size() >0)
			Collections.sort(v_temp);
	}

	if(s_farmserver!=null && !(s_farmserver.equals("-1")))
	{
		ArrayList al = gpinfo.getAllComponentsUnderZone(s_farmserver);//zone comps
		if(al!=null && al.size() > 0)
		{
			for(int a=0; a < al.size(); a++)
			{
				String comp = (String)al.get(a);
				StringTokenizer st_c = new StringTokenizer(comp,":");
				String compName = "";
				String portNo = "";
				String compType = "";
				String sid="";
				String startdate="";
				if(st_c.hasMoreTokens())
				{
					compType = (String)st_c.nextToken();
					compName = (String)st_c.nextToken();
					portNo = (String)st_c.nextToken();
					if (st_c.hasMoreTokens())
						sid=st_c.nextToken();
				}
				tmpComponent = compName + ":" + portNo + ":" + compType;

				if(v_comp.contains(tmpComponent) && (tmpComponent.endsWith(":Citrix_MF_XP")|| tmpComponent.endsWith(":Citrix_server")||tmpComponent.endsWith(":Terminal_server") || tmpComponent.endsWith(":Vmware_vdi_server") || tmpComponent.endsWith(":VmVdi_i_server") || aListSupportComponentType.contains(compType)))
				{
					if(!a_compsForFarm.contains(comp))
						a_compsForFarm.add(comp);
					if(!v_compsForFarm.contains(tmpComponent))
						v_compsForFarm.add(tmpComponent.substring(0,tmpComponent.lastIndexOf(":")));
				}
			}
			if(a_compsForFarm!=null && a_compsForFarm.size() > 0)
			{
				String strCompTypeValue = request.getParameter("er_compType");
				if(s_comp!=null && !(s_comp.equals("-1")))
					if(request.getParameter("er_compType")!=null&&request.getParameter("er_compType").equalsIgnoreCase("Terminal_server"))
					{
						v_u = erInfo.getUsersInFarm("NULL","TermLoginTest_DDD",a_compsForFarm);
					}
					else if(request.getParameter("er_compType")!=null && request.getParameter("er_compType").equalsIgnoreCase("Vmware_vdi_server"))
					{
						v_u = erInfo.getUsersInFarm("NULL","VmLoginTest_DDD",a_compsForFarm);
					}
					else if(request.getParameter("er_compType")!=null && request.getParameter("er_compType").equalsIgnoreCase("VmVdi_i_server"))
					{
						v_u = erInfo.getUsersInFarm("NULL","EsxLoginTest_DDD",a_compsForFarm);
					}
					else if(strCompTypeValue!=null && aListSupportComponentType.contains(strCompTypeValue))
					{
						String dddTest = reportInfo.getTestName("CITRIX_USER_REPORT",strCompTypeValue,true);
						v_u = erInfo.getUsersInFarm("NULL",dddTest,a_compsForFarm);
					}
					else
						v_u = erInfo.getUsersInFarm("NULL","CtxLoginTest_DDD",a_compsForFarm);
			}
		}
		if(v_compsForFarm!=null && v_compsForFarm.size() > 0)
			Collections.sort(v_compsForFarm);
	}

	sSearch = request.getParameter("showSearch");
	int cntUserForFarm = 0;
	if(v_u!=null)
		cntUserForFarm = v_u.size();
	if(cntUserForFarm > countForUser)
		getMoreUsers = true;
	if(sSearch == null || sSearch.equals(""))
		sSearch = String.valueOf(getMoreUsers);
	if(sSearch.equals("false"))
	{
		if(getMoreUsers)
			sSearch = "true";
	}
	if(s_user!=null && s_user.equals("-1"))
		s_user = "";
	if(v_u!=null && v_u.size() > 0)
	{
		Collections.sort(v_u);
	}

	String dispComp = s_comp;
	if(s_comp!=null && s_comp.endsWith(":NULL"))
	{
		dispComp = s_comp.substring(0,s_comp.indexOf(":"));
	}
	

	// for redirecting same page in reporter Starts
	String query_String=(String)ErUtils.prepareQueryString(request.getParameterMap());
	String q_String="";
	String q_StringBackUrl = "";
	if(query_String!=null)
	{
		StringTokenizer str_tok = new StringTokenizer(query_String,"&");
		while(str_tok.hasMoreTokens())
		{
			String para_meter = str_tok.nextToken();
			int ind = para_meter.indexOf("=");
			if (ind < 0)
				continue;
			String req_param =para_meter.substring(0,ind);
			String value = para_meter.substring(ind+1);
			if(req_param!=null) {
				 if(req_param.equals("starttime") || req_param.equals("endtime") || req_param.equals("startHr") || req_param.equals("endHr") || req_param.equals("startmin") || req_param.equals("endmin") || req_param.equals("inidate"))
				{
					continue;
				} 
				q_String += req_param+"="+value+"&";
			}
		}
	}
	String excludeweekend=request.getParameter("er_excwe");
	if (excludeweekend==null ||	excludeweekend.equals(""))
		excludeweekend="No";

	 v_qryStr = (Vector)request.getAttribute("appChartData");
	 v_pdf_qryStr = (Vector)request.getAttribute("appPdfData");
	 chartCount = -1;
	if (v_qryStr != null) chartCount = v_qryStr.size() / 2;

	String userTBound = request.getParameter("userTBound");
	String userStartDate = request.getParameter("userStartDate");
	String userEndDate = request.getParameter("userEndDate");
	String userStHr = request.getParameter("userStHr");
	String userEndHr = request.getParameter("userEndHr");
	String select_server = request.getParameter("select_server1");
	String userTimeline = request.getParameter("userTimeline");
	String userCurrTime = request.getParameter("userCurrTime");
	String timeTo = request.getParameter("timeto");
	String timeFrom = request.getParameter("timefrom");
	String exc = request.getParameter("er_excwe");
	showAllUsers = request.getParameter("showAll");
	if(showAllUsers == null)
		showAllUsers = "false";
	if(exc == null)
		exc = "No";

	String t_showAllUsers = showAllUsers;
	String minFrom = request.getParameter("minfrom");
	String minTo = request.getParameter("minto");
	String gType = request.getParameter("er_gtype");
	String rType = request.getParameter("er_rtype");
	String tType = request.getParameter("er_trgttype");
	String t_auser = request.getParameter("t_user");
	String compType = request.getParameter("er_compType");
	String period = request.getParameter("er_period");
	String ertuser = request.getParameter("er_tuser");
	if(ertuser == null)
	{
		ertuser = s_user;
	}

	String t_ertuser = ertuser;
	if(compType == null)
		compType = "Citrix_MF_XP";
	String t_tauser = t_auser;
	if((timeTo!=null && timeTo.equals("")) && (timeFrom!=null && timeFrom.equals("")) && (minFrom!=null && minFrom.equals("")) && (minTo!=null && minTo.equals("")))
	{
		String fromTime = reportInfo.getTimeFrame("CITRIX_USER_REPORT","FROM");
		timeFrom = fromTime.substring(0,fromTime.indexOf(":"));
		minFrom = fromTime.substring(fromTime.indexOf(":")+1);
		String toTime = reportInfo.getTimeFrame("CITRIX_USER_REPORT","TO");
		timeTo = toTime.substring(0,toTime.indexOf(":"));
		minTo = toTime.substring(toTime.indexOf(":")+1);
	}
	String temp_user = null;

	StringBuffer sbHiddenQStr = new StringBuffer();
	sbHiddenQStr.append("&er_rtype="+rType);
	sbHiddenQStr.append("&er_trgttype="+tType);
	sbHiddenQStr.append("&er_gtype="+gType);
	sbHiddenQStr.append("&er_period="+period);
	sbHiddenQStr.append("&showAll="+showAllUsers);

	sbHiddenQStr.append("&forGraphPopUp=true");
	sbHiddenQStr.append("&er_comptype="+compType);
	sbHiddenQStr.append("&er_compType="+compType);
	sbHiddenQStr.append("&er_application="+s_application);
	sbHiddenQStr.append("&er_perserver="+s_perserver);
	sbHiddenQStr.append("&chartFor="+chartFor);


	sbHiddenQStr.append("&timefrom="+timeFrom);
	sbHiddenQStr.append("&timeto="+timeTo);
	sbHiddenQStr.append("&minfrom="+minFrom);
	sbHiddenQStr.append("&minto="+minTo);
//	sbHiddenQStr.append("&showSearch="+getMoreUsers);
	sbHiddenQStr.append("&er_muser="+t_ertuser);
	sbHiddenQStr.append("&inidate="+currentDateFormat);
	sbHiddenQStr.append("&startmin="+startmin);
	sbHiddenQStr.append("&endmin="+endmin);
	sbHiddenQStr.append("&er_secs="+request.getParameter("er_secs"));
	sbHiddenQStr.append("&getMaxDaysInMonth="+ErUtils.getMaxDaysInMonth());

	sbHiddenQStr.append("&er_test="+s_test);
	sbHiddenQStr.append("&er_measure="+s_measure);
	sbHiddenQStr.append("&select_testmes="+request.getParameter("select_testmes"));

	sbHiddenQStr.append("&er_user="+request.getParameter("er_user"));
	sbHiddenQStr.append("&er_server="+request.getParameter("er_server"));

	sbHiddenQStr.append("&userStartDate="+userStartDate);
	sbHiddenQStr.append("&userEndDate="+userEndDate);
	sbHiddenQStr.append("&userCurrTime="+userCurrTime);
	sbHiddenQStr.append("&userStHr="+userStHr);
	sbHiddenQStr.append("&userEndHr="+userEndHr);
	sbHiddenQStr.append("&userTBound="+userTBound);

	sbHiddenQStr.append("&responseType=json");
	sbHiddenQStr.append("&er_sortby=-1");
	sbHiddenQStr.append("&er_tbound=Any");
	sbHiddenQStr.append("&uid="+EgURLEncoder.encode(urs,"UTF-8"));
	sbHiddenQStr.append("&us_id="+EgURLEncoder.encode(urs,"UTF-8"));
	sbHiddenQStr.append("&userID="+EgURLEncoder.encode(urs,"UTF-8"));

	sbHiddenQStr.append("&er_type="+request.getParameter("er_type"));
	sbHiddenQStr.append("&er_reportgenration="+request.getParameter("er_reportgenration"));
	sbHiddenQStr.append("&er_excwe=No");
	sbHiddenQStr.append("&servletName=com.eg.ErCtxServerReportC");
    sbHiddenQStr.append("&er_option="+erOption);
	sbHiddenQStr.append("&userTimeline="+userTimeline);
	sbHiddenQStr.append("&select_farm="+s_farmserver);

	hiddenParams.put("er_usertimeline",strUsrTimeline);
	String hiddenQStr ="";
	if(sbHiddenQStr!=null)
	{
		hiddenQStr = sbHiddenQStr.toString();
	}
	json.put("hiddenQStr",hiddenQStr);

	if (chartCount == 1)
	{
			String Qstring1="";
			String tmpQS1=(String)v_qryStr.get(1);
			if(tmpQS1!=null)
			{
				StringTokenizer strtok = new StringTokenizer(tmpQS1,"&");
				while(strtok.hasMoreTokens())
				{
					String param = strtok.nextToken();
					if(param!=null && param.indexOf("?")>0)
					{
						if((param.substring(param.indexOf("?")+1)).indexOf("=")>0)
						{
							Qstring1 += param.substring(0,param.indexOf("?")+1);
							param = param.substring(param.indexOf("?")+1);
						}
					}
					String reqparam =param.substring(0,param.indexOf("="));
					String value = param.substring(param.indexOf("=")+1,param.length());
					if(reqparam!=null && reqparam.equalsIgnoreCase("option"))
						continue;
					if(reqparam.equals("er_component"))
					{
						value=EgURLEncoder.encode(value,"UTF-8") ;
					}
					if(reqparam.equals("uid") || reqparam.equals("us_id") || reqparam.equals("userID")) {
						if(value!=null)
							value = EgURLEncoder.encode(value,"UTF-8");
					}
					Qstring1=Qstring1+reqparam+"="+value+"&";
				}
			}
			pageParams.put("dataPageUrl",Qstring1+"&option=data");
	}
	screenLabels.put("Zone",mappingInfo.getTextDescription("reporter.common.Zone"));
	screenLabels.put("Component",mappingInfo.getTextDescription("reporter.common.Component"));
	screenLabels.put("User",mappingInfo.getTextDescription("reporter.common.User"));

	screenData.put("Zone",s_farmserver);
	screenData.put("Component",dispComp);
	screenData.put("User",s_user);

	if(er_timeline!=null)
		pageParams.put("er_timeline",er_timeline);

	if(er_timeline!=null&&!er_timeline.equals("Any"))
	{
		if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
		{
			comFormat = "MM/dd/yyyy";
		}
		else
		{
			comFormat = currentDateFormat;
		}
		dispDate = DateUtil.changeDateFormat(s_st_time,comFormat,currentDateFormat);
	}
	else
	{
		dispDate = s_st_time;
	}
	if(dispDate!=null)
		pageParams.put("selectedStDate",dispDate);

	if(er_timeline!=null&&!er_timeline.equals("Any"))
	{
		if(DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
		{
			comFormat = "MM/dd/yyyy";
		}
		else
		{
			comFormat = currentDateFormat;
		}
		dispDate = DateUtil.changeDateFormat(s_en_time,comFormat,currentDateFormat);
	}
	else
	{
		dispDate = s_en_time;
	}
	if(dispDate!=null)
		pageParams.put("selectedEndDate",dispDate);
	if(s_st_hr!=null)
		pageParams.put("selectedStarthour",s_st_hr);
	if(startmin!=null)
		pageParams.put("selectedStartMins",startmin);
	if(s_en_hr!=null)
		pageParams.put("selectedEndhour",s_en_hr);
	if(endmin!=null)
		pageParams.put("selectedEndMins",endmin);
  
	if (dpSh!=null) 
		pageParams.put("dpSh",dpSh);
    if (dpEh!=null)
		pageParams.put("dpEh",dpEh);
	if(chartCount > 0)
	{
		String t_gtype = "Citrix";
		String t_trgttype = "User Report";
		String backQuery="../servlet/com.eg.ErCtxServerReportC?select_farm="+ s_farmserver + "&er_timeline=" + userTimeline + "&currTime=" + userCurrTime + "&er_excwe=" + exc + "&minfrom=" + minFrom + "&minto=" + minTo + "&er_gtype=Citrix&er_trgttype=User Report&er_rtype=User&er_tbound=" + userTBound + "&timefrom=" + timeFrom + "&timeto=" + timeTo + "&er_view=&startdate=" + userStartDate + "&enddate=" + userEndDate + "&starthr=" + userStHr + "&endhr=" + userEndHr + "&er_compType=" + compType;

		if(select_server!=null && !select_server.equals(""))
			backQuery+= "&select_server1=" + select_server;
		if((t_showAllUsers!=null || !t_showAllUsers.equals("")) && t_showAllUsers.equalsIgnoreCase("true"))
		{
			backQuery+="&er_user=-- All --" + "&t_user=" + t_tauser;
		}
		else if(sSearch.equalsIgnoreCase("true"))
		{
			backQuery+="&showSearch=" + sSearch + "&er_tuser=" + t_ertuser;
		}
		else
			backQuery+="&er_user=" + s_user;
	}
	if(chartCount > 0)
	{
		if(chartCount == 1)
		{
			String s_title=(String)v_qryStr.get(0);
			if(s_title.indexOf("/")>-1)
			{
				String strDispTitle = "";
				strDispTitle = mappingInfo.getTestDescription(s_title.substring(0,s_title.indexOf("/")));
				strDispTitle += "/";
				strDispTitle += mappingInfo.getMeasureDescription(s_title.substring(0,s_title.indexOf("/")),s_title.substring(s_title.indexOf("/")+1));
				pageParams.put("imgTitle",strDispTitle);
			}
			else
			{
				pageParams.put("imgTitle",mappingInfo.getTextDescription("reporter.common."+s_title));
			}
			String Qstring1="";
			String tmpQS1=(String)v_qryStr.get(1);
			if(tmpQS1!=null)
			{
				StringTokenizer strtok = new StringTokenizer(tmpQS1,"&");
				while(strtok.hasMoreTokens())
				{
					String param = strtok.nextToken();
					if(param!=null && param.indexOf("?")>0)
					{
						if((param.substring(param.indexOf("?")+1)).indexOf("=")>0)
						{
							Qstring1 += param.substring(0,param.indexOf("?")+1);
							param = param.substring(param.indexOf("?")+1);
						}
					}
					String reqparam =param.substring(0,param.indexOf("="));
					String value = param.substring(param.indexOf("=")+1,param.length());
					if(reqparam.equals("er_component"))
					{
						value=EgURLEncoder.encode(value,"UTF-8") ;
					}
					if(reqparam.equals("uid") || reqparam.equals("us_id") || reqparam.equals("userID")) {
						if(value!=null)
							value = EgURLEncoder.encode(value,"UTF-8");
					}
					Qstring1=Qstring1+reqparam+"="+value+"&";
				}
			}
				pageParams.put("imgUrl",Qstring1+"&er_width=970&er_height=300&option=graph");
				pageParams.put("imgWidth","970");
				pageParams.put("imgHeight","400");
				pageParams.put("imgToolTip",v_qryStr.get(0));
		}
		else
		{
			for(int i=0;i<chartCount;i++)
			{
				String s_title =(String)v_qryStr.get(i*2);
				pageParams.put("imgTitle",mappingInfo.getTextDescription(s_title));
				String Qstring="";
				String tmpQS=(String)v_qryStr.get(i*2+1);
				if(tmpQS!=null)
				{
						StringTokenizer strtok = new StringTokenizer(tmpQS,"&");
						while(strtok.hasMoreTokens())
						{
							String param = strtok.nextToken();
							String reqparam =param.substring(0,param.indexOf("="));
							String value = param.substring(param.indexOf("=")+1,param.length());
							if(reqparam.equals("er_component"))
							{
								value=EgURLEncoder.encode(value,"UTF-8") ;
							}
							Qstring=Qstring+reqparam+"="+value+"&";
					}
				}
				pageParams.put("imgUrl",Qstring+"&er_width=670&er_height=400&option=graph");
				pageParams.put("imgWidth","670");
				pageParams.put("imgHeight","400");
				pageParams.put("imgToolTip",v_qryStr.get(i));
			}
		}

		HashMap param = new HashMap();
		HashMap m=ErUtils.parseQueryString(ErUtils.prepareQueryString(request.getParameterMap()));
		m.put("er_timeline",URLEncoder.encode((String)m.get("er_timeline")));
		userName=(String)m.get("er_user");
		m.put("er_user",EgURLEncoder.encode(userName,"UTF-8"));
		param.put("REPORT_PARAM",m);

		Vector v_newPdf_qry=new Vector();
		if(v_pdf_qryStr!=null)
		{
			for(int v=0;v<v_pdf_qryStr.size();v=v+2)
			{
				v_newPdf_qry.add((String)v_pdf_qryStr.get(v));
				String  s_qry=(String)v_pdf_qryStr.get(v+1);
				String SQstring="";
				if(s_qry!=null)
				{
					StringTokenizer strtok = new StringTokenizer(s_qry,"&");
					String surl=s_qry.substring(0,s_qry.indexOf("&"));
					while(strtok.hasMoreTokens())
					{
						String param1 = strtok.nextToken();
						if(param1!=null && param1.indexOf("?")>0)
						{
							if((param1.substring(param1.indexOf("?")+1)).indexOf("=")>0)
							{
								SQstring += param1.substring(0,param1.indexOf("?")+1);
								param1 = param1.substring(param1.indexOf("?")+1);
							}
						}
						if(param1.indexOf("=")>-1)
						{
							String reqparam =param1.substring(0,param1.indexOf("="));
							String stdate_param=param1.substring(param1.indexOf("?")+1,param1.indexOf("="));
							String value=param1.substring(param1.indexOf("=")+1,param1.length());
							if(reqparam.equals("er_component") || reqparam.equals("er_info_list") || reqparam.equals("er_selection"))
							{
								if(value!=null && value.equals("-1"))
									value="";
								if(value!=null  && !value.equals(""))
									value=EgURLEncoder.encode(URLDecoder.decode(value),"UTF-8");
							}
							//if((reqparam.equals("enddate")|| stdate_param.equals("startdate")|| reqparam.equals("inidate"))&& value.indexOf(" ")>-1)
								//value=URLEncoder.encode(value);
							if(reqparam.equals("uid") || reqparam.equals("us_id") || reqparam.equals("userID")) {
								if(value!=null)
									value = EgURLEncoder.encode(value,"UTF-8");
							}
							SQstring=SQstring+reqparam+"="+value+"&";
						}
					}
					if(SQstring.endsWith("&"))
						SQstring=SQstring.substring(0,SQstring.lastIndexOf("&"));
					v_newPdf_qry.add(SQstring);
				}
			}
		}
		param.put("REPORT_DATA",v_newPdf_qry);
		param.put("fileName","User-Report");
		session.setAttribute("parameters", param);
	}

	String mailQstring = "";
	//String qStr = ErUtils.prepareQueryString(request.getParameterMap());
	if(queryString!=null)
	{
		StringTokenizer strtok = new StringTokenizer(queryString,"&");
		while(strtok.hasMoreTokens())
		{
			String parameter = strtok.nextToken();
			int ind = parameter.indexOf("=");
			if (ind < 0)
				continue;
			String reqparam =parameter.substring(0,ind);

			String value = parameter.substring(ind+1);

			if(reqparam!=null && reqparam.startsWith(" "))
			{
				reqparam = reqparam.substring(1,reqparam.length());
			}
			if(reqparam!=null&&reqparam.equals("startdate"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null && reqparam.equals("enddate"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("inidate"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("userEndDate"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("er_stdate"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("er_enddate"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("userStartDate"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("userCurrTime"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("er_timeline"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("er_component"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("select_farm"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("t_user"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			if(reqparam.equals("uid") || reqparam.equals("us_id") || reqparam.equals("userID")) {
				if(value!=null)
					value = EgURLEncoder.encode(value,"UTF-8");
			}
			mailQstring += reqparam.trim()+"="+value.trim()+"&";
		}
	}



	String cType=request.getParameter("er_comptype");
	String erTest= request.getParameter("ertest");
	if(erTest == null || erTest.length()>0)
		erTest= request.getParameter("er_test");
	String user_name= request.getParameter("user_name");
	if(user_name==null)
		user_name=request.getParameter("er_application");
	EgExternalInfo externalInfo = new EgExternalInfo("manager");
	String componentName=request.getParameter("componentNamee"),portNo=request.getParameter("portt");
	String uid=request.getParameter("uid");
		String testmes = request.getParameter("select_testmes");
		String strMeas = request.getParameter("er_measure");

	if(strMeas==null && testmes!=null && testmes.indexOf("/") >-1)
	{
		strMeas = testmes.substring(testmes.indexOf("/")+1);
	}
		List mHostList = externalInfo.getAgentsForHost(componentName);
	EgFormatInfo formatInfo = new EgFormatInfo("manager");

	boolean ddenable = formatInfo.isDdEnabled(erTest,strMeas);

	System.out.println("strMeas A___________ "+strMeas);

	/*String ddMeasure="No_of_sessions";
		if(cType!=null && (cType.equalsIgnoreCase("Vmware_vdi_server") || cType.equals("VmVdi_i_server")))
			ddMeasure="Current_sessions";
		else
			ddMeasure = reportInfo.getCtxUserDDMeasure("CITRIX_USER_REPORT",cType);*/

String ddUrl="/final/monitor/componentMeasureTabSet.jsp?";
Vector vec_infos= null;
String strVmComp = reportInfo.getValue("MISC","VMWareComponent");
ArrayList aListVmComponentType = new ArrayList();
if(strVmComp!=null && strVmComp.length()>0)
{
	StringTokenizer stToken = new StringTokenizer(strVmComp,",");
	while (stToken.hasMoreTokens())
	{
		String str = stToken.nextToken();
		str = str.trim();
		//str = str.toUpperCase();
		aListVmComponentType.add(str);
	}
}
	if(aListVmComponentType!=null && aListVmComponentType.contains(cType))
	{
		vec_infos=erInfo.getInfosForUser(erTest);
	}

if(user_name!=null && user_name.length()>0)
{
	String encuser_dd=user_name;
	String strinfo_DD=encuser_dd;//com.egurkha.util.StringUtils.replace(encuser_dd,"\\", "\\\\");;
	if(vec_infos!=null && vec_infos.size()>0)
	{
		for(int ddi=0;ddi<vec_infos.size();ddi++)
		{
			String strInfo = (String) vec_infos.get(ddi);
			if(strInfo!=null && (strInfo.toLowerCase().startsWith(("+"+encuser_dd.toLowerCase())) || strInfo.toLowerCase().startsWith(encuser_dd.toLowerCase())))
			{
				strinfo_DD = strInfo;
				break;
			}
		}
	}
	//formatInfo.isDdEnabled(erTest,strMeas);
	String strMhost= "";
	if(mHostList!=null && mHostList.size()>0)
		strMhost = (String)mHostList.get(0);
	if(strinfo_DD!=null && strinfo_DD.startsWith("+"))
		strinfo_DD = strinfo_DD.substring(1);
	strinfo_DD = com.egurkha.util.StringUtils.replace(strinfo_DD,"\\\\", "\\");

	String link="&type="+cType
	    +"&site=NULL"
	    +"&host="+componentName
	    +"&port="+portNo
		+"&info=*"+com.eg.EgURLEncoder.encode(strinfo_DD, "UTF-8")
	    +"&state="
		//+"&messy=No_of_sessions"
		+"&messy="+strMeas
		
	   +"&msmt_host="+strMhost
	   +"&userID="+uid
	   +"&test="+erTest
	   +"&comptype="+cType
	  // +"&measureDisp=No_of_sessions"
	    +"&measureDisp="+strMeas
		+"&starttime="+request.getParameter("startdate")+"&endtime="+request.getParameter("enddate")+"&starthr="+s_st_hr+"&endhr="+s_en_hr+"&startmin="+request.getParameter("startmin")+"&endmin="+request.getParameter("endmin")
	   + "&from=measurespage"
	   +"&dd=yes"
	   +"&clicked=dd"
	   +"&newWindow=true"
	   +"&fromReporterHis=true"
	   +"&popup=true"
	   +"&fromPage=eveHist"
	   +"&er_RmDispName=testing";
ddUrl+=link;
pageParams.put("ddUrl",ddUrl);


	if(ddenable)
	pageParams.put("isddEnabled","true");
	else
	pageParams.put("isddEnabled","false");
}




	session.setAttribute("DrillDownPage","yes");
//	queryString

	String dataProcess =  	mngrIProc+"/final/servlet/com.eg.ErCtxServerReportC;jsessionid="+session.getId()+"?"+mailQstring+"&print=yes&sample=yes&drillSes=yes&printGraph=yes";
	session.setAttribute("DRILLDOWN_MAIL_URL",dataProcess);
	session.setAttribute("DRILLDOWN_PDF_URL",mngrIProc+"/final/servlet/com.eg.ErCtxServerReportC");

	json.put("timelineJSONArray",timelineJSONArray);

	json.put("hiddenQStr",hiddenQStr);
	json.put("pageParams",pageParams);
	json.put("hiddenParams",hiddenParams);
	json.put("screenLabels",screenLabels);
	json.put("selectionDetails",screenData);
	json.put("userID",urs);
	response.setContentType("application/json;charset=UTF-8");
	response.getWriter().write(json.toString());
	}
	catch(Exception e)
	{
		System.out.println(e);
		e.printStackTrace();
	}
%>

