<!DOCTYPE html>
<%
/**************************************************************************************************
* File name			: ErAlarmHistoryPrint.jsp
* Purpose			: Genarates History of Alarms Print Report
* Version			: 1.0
* Creation			: 9th June 2011
* Last Modified 	:
* Author			: Sathya Kala Veeraraj
**************************************************************************************************/
%>

<%@ page import="com.eg.EgDbInfo"%>
<%@ page import="com.eg.EgServicesInfo"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.eg.EgURLDecoder" %>
<%@ page import="com.egurkha.util.StringUtils"%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>

<%
	try
	{
//Request Parameter Map
		HashMap param = new HashMap();
		ErAlarmHistoryHelper helper1      = new ErAlarmHistoryHelper();
		param = ErUtils.parseQueryString(ErUtils.prepareQueryString(request.getParameterMap()));

		
//Request Parameter
		String event                 = request.getParameter("v_event");
		String sub_event             = request.getParameter("subevent");
		if(sub_event!=null)
			sub_event = com.eg.EgURLDecoder.decode(sub_event,"UTF-8");
		String compTypeList             = request.getParameter("compTypeList");
		String pdfPrint              = request.getParameter("pdfPrint");
		String user_id               = request.getParameter("er_userid");
		String unknownStatePrint               = request.getParameter("unknownState");
		String reporterSkin          = "";
		String s_startTime           = request.getParameter("startdate")+" "+ request.getParameter("starthr")+":"+ request.getParameter("startmin");
		String s_endTime             = request.getParameter("enddate")+" "+ request.getParameter("endhr")+":"+ request.getParameter("endmin");
		String fontStyleDbl          = "";
		String fontStyleDblSingl     = "";
		String sHideView             = event;
		String logoImage             = "";

//Class Initialization

		com.egurkha.ini.IniUI ui = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
		User user = UserRegistry.getInstance().getUser(request.getSession().getId());
		EgDbInfo dbInfo = new EgDbInfo("manager");

//User Language

		String thisLanguage = ui.getDefaultLanguage();
		if(user_id!=null)
		{
			ErUserData erUserData = new ErUserData(user_id,false);
			user = erUserData.getUser(user_id);
		}
		if (user!=null)
		{
			String userLang = user.getLanguage();
			if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
			{
				thisLanguage = userLang;
			}
		}

		EgMappingInfo mappinginfo = new EgMappingInfo(thisLanguage);
		compTypeList = (String)mappinginfo.getComponentTypeDescription(compTypeList);
//UI Skin

		if(user!=null)
			reporterSkin = user.getReporterSkin();

//DoubleByte - Other Language Support

		if((dbInfo.doubleByteEnabled || !thisLanguage.equals("en_US")) && !(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes")))
			fontStyleDblSingl = "multi_font";
		else
			fontStyleDblSingl = "";

//Include ErTracker.jsp only when No Measures are available.
//This is because skin is not set in Background & Schedule.

		if(pdfPrint == null || !pdfPrint.equalsIgnoreCase("yes"))
		{
			if(session.getAttribute("NO_OF_ALARMS")==null || session.getAttribute("NO_OF_ALARMS").equals(""))
			{
%>
				<%@ include file = "ErTracker.jsp" %>
<%
			}
		}
		EgTimeZoneConverter ConverterStart = new EgTimeZoneConverter(s_startTime,user);
		EgTimeZoneConverter ConverterEnd = new EgTimeZoneConverter(s_endTime,user);
		String st_dateTime = ConverterStart.getDateTime();
		String en_dateTime = ConverterEnd.getDateTime();
		String er_RmDispName =request.getParameter("er_RmDispName");
%>
<html>
	<head>
		<title> &nbsp; eG Manager </title>

<meta name="Author" content="">
<meta  charset="UTF-8">

<link rel="stylesheet" type="text/css" href="/final/reporter/styles/printpagestyle.css" />
<link rel="stylesheet" type="text/css" href="/final/styles/eGLightThemeIcons.css" />
<style>

@media print {body {-webkit-print-color-adjust: exact;}}



body{font-family:'LucidaGrandeRegular';font-size:11px;line-height:1.5em;color:#2a292a;}
header{font-family:'LucidaGrandeRegular';font-size:15px;}
.formLabel {font-family:'LucidaGrandeRegular';font-size:12px;line-height:14px;}
.formValue {font-family:'LucidaGrandeBold';font-size:12px;line-height:14px;}
b{font-family:'LucidaGrandeBold';font-size:11px;}
table tr td{font-family:'LucidaGrandeRegular';font-size:11px;padding:4px;}

.printTable{border: 1px solid #c3c3c3; border-collapse: collapse;}
.printTable tr td{border: 1px solid #c3c3c3;}

.printTableHeader{font-family:'LucidaGrandeBold';border: 1px solid #c3c3c3;text-align:center;background-color:#cdcdcd;padding:4px;}
.printTableHeader2{font-family:'LucidaGrandeBold';border: 1px solid #c3c3c3;text-align:center;background-color:#dcdcdc;padding:4px;}
#newimg{page-break-inside:avoid}.newimg{page-break-inside:avoid}

</style>


<style type="text/css" media="print">
#printbt{ display:none}
</style>

<style>
@page {size : landscape; margin : 0in }
@page :footer {content: none, "Macro Home" decimal(pageno), none;}
</style>
</head>

<body  style="padding:10px;background-color:#ffffff">

<form name="AlarmHistoryPrint" method="post" onSubmit="return false;" style="margin:0px; padding:0px">
<table border="0" cellspacing="0" cellpadding="0" width="100%" style="table-layout:fixed;">
	<tr>
		<td width="100%" align="center" height="100%" valign="top">
			<table cellpadding="0" cellspacing="0" border="0" width="100%" align="center">
				<tr>
<%
				logoImage = ui.getReporterHomeLogo();
				if(user!=null)
				{
					ui.set_userLogo(user.getUserLogo());
					ui.set_loginID(user.getLoginID());
					logoImage = ui.getReporterHomeLogo();
				}
				if(ui.isHKTThemeEnabled())
					logoImage = ui.getHKTReporterLogo();
				if(pdfPrint == null || !pdfPrint.equalsIgnoreCase("yes"))
				{
%>
					<td style="padding:5px 10px 10px 10px"><img src='<%=logoImage%>' border="0" /></td>
<%
				}
%>
				</tr>
			</table>
			<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center"  style="border-bottom:1px solid #999;">
				<tr>
					<td style="padding:2px">
<%
	if (!StringUtils.isNull(er_RmDispName))
	{
%>
						<div style="float:left" > <header><%= er_RmDispName %></header></div>
<%
	}
	else
	{
		if(unknownStatePrint !=null && unknownStatePrint.equals("UNKNOWN"))
		{
%>
						<div style="float:left" > <header><egui:intnl text="reporter.common.Operation Reports"/> - <egui:intnl text="reporter.alarmHistory.History of Unknowns Report"/></header></div>
<%
		}
		else
		{
%>
						<div style="float:left" > <header><egui:intnl text="reporter.common.Operation Reports"/> - <egui:intnl text="reporter.alarmHistory.History of Alarms Report"/></header></div>
<%
		}
	}
// Print Image only for Print Page
	if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
	{
%>
						<div style="float:right"><img class="iconPrinter mouse" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" border="0" onClick="javascript:print()" alt='<egui:intnl text="reporter.common.PRINT"/>' title='<egui:intnl text="reporter.common.PRINT"/>'/></div>
<%
	}
%>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>

<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center" style="border-bottom:1px solid #ccc;">
	<tr>
		<td align="left" valign="top" width="50%">
			<div style="clear:both;float:left;padding:4px;">
<%
		if(unknownStatePrint !=null && unknownStatePrint.equals("UNKNOWN"))
		{
%>
			<div style="float:left" class="formValue"> <egui:intnl text="reporter.alarmHistory.History of Unknowns Report"/></div>
<%
		}
		else
		{
%>
			<div style="float:left" class="formValue"> <egui:intnl text="reporter.alarmHistory.History of Alarms Report"/></div>
<%
		}
%>
			</div>
		<!-- analysis by & ComponentType -->
<%
		if(event!=null && event.equalsIgnoreCase("Component"))
		{
%>
			<div style="clear:both;float:left;padding:4px;">
				<div style="float:left" class="formLabel"><egui:intnl text="reporter.common.Analysis by" /></div>
				<div style="float:left;width:10px" align="center" >:</div>
				<div style="float:left;" class="formValue"><%=event%></div>
			</div>

			<div style="clear:both;float:left;padding:4px;">
				<div style="float:left" class="formLabel"><egui:intnl text="reporter.common.Component Type" /></div>
				<div style="float:left;width:10px" align="center" >:</div>
				<div style="float:left;" class="formValue"><%=compTypeList%></div>
			</div>
<%
		}
		else
		{
%>
			<div style="float:left;padding:4px;">
				<div style="float:left" class="formLabel"><egui:intnl text="reporter.common.Analysis by" /></div>
				<div style="float:left;width:10px" align="center" >:</div>
				<div style="float:left;" class="formValue"><%=event%></div>
			</div>

			<div style="clear:both;float:left;padding:4px;">
				<div style="float:left" class="formLabel"><egui:intnl text="<%="reporter.history."+event%>"/></div>
				<div style="float:left;width:10px" align="center" >:</div>
				<div style="float:left;" class="formValue"><%=sub_event%></div>
			</div>

			<div style="clear:both;float:left;padding:4px;">
				<div style="float:left" class="formLabel"><egui:intnl text="reporter.common.Component Type" /></div>
				<div style="float:left;width:10px" align="center" >:</div>
				<div style="float:left;" class="formValue"><%=compTypeList%></div>
			</div>
<%
		}
%>
		</td>
		<td align="right" valign="top">
			<div style="float:right;padding:4px;">
				<div style="float:left" class="formLabel"><egui:intnl text="reporter.common.Start Date" /></div>
				<div style="float:left;width:10px" align="center" >:</div>
				<div style="float:left;" class="formValue"><%=st_dateTime%>&nbsp;<egui:intnl text="reporter.common.hrs" /></div>
			</div>
			<div style="clear:both;float:right;padding:4px;">
				<div style="float:left" class="formLabel"><egui:intnl text="reporter.common.End Date" /></div>
				<div style="float:left;width:10px" align="center">:</div>
				<div style="float:left;" class="formValue"><%=en_dateTime%>&nbsp;<egui:intnl text="reporter.common.hrs" /></div>
			</div>
		</td>
	</tr>
</table><br/>
<%
		if(session.getAttribute("NO_OF_ALARMS")!=null && !session.getAttribute("NO_OF_ALARMS").equals(""))
		{
%>
			<%@ include file ="ErAlarmHistoryResults.jsp"%>
<%
				  LinkedList lst = new LinkedList();
					if(session.getAttribute("NO_OF_ALARMS")!=null && !session.getAttribute("NO_OF_ALARMS").equals(""))
						lst = helper1.getCsv((List)session.getAttribute("NO_OF_ALARMS"), session);
					if(lst!=null && lst.size()>0)
						session.setAttribute("ScheduleCSVData",lst);
					
		}
		else
		{
%>

<table width="100%" height="100%">
	<tr>
		<td align="center" valign="middle">
			<img src="/images/Light/nomeasures_custom.png" />
		</td>
	</tr>
</table>
<%
		}
%>
</form>

<!-- Print Window -->
</body>
</html>
<%
	if (!StringUtils.isNull(er_RmDispName)){
		//For Setting the PDf File Name
		er_RmDispName = er_RmDispName.replace(" ","_");
		HashMap paramVal =new HashMap();
		paramVal.put("fileName",er_RmDispName);
		session.setAttribute("parameters", paramVal);
	}
	}
	catch(Throwable aa)
	{
		System.out.println("------------- Error in Alarm Print JSP -- "+aa);
		aa.printStackTrace();

	}
%>