<%
/**************************************************************************************************
* File name			: ErAlarmHistoryJSON.jsp
* Purpose			: Genarates History of Alarm Reports
* Version			: 1.0
* Creation			: 9th June 2011
* Last Modified 	:
* Author			: Sathya Kala Veeraraj
**************************************************************************************************/
%>
<%@ page import = "java.util.LinkedHashMap" %>
<%@ page import = "net.sf.json.*" %>
<%@ page import="com.eg.EgGroupInfo" %>
<%@ page import="java.util.*"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%@ include file="ErReporterTracker.jsp" %>
<%@ include file="ErAlarmHistoryJavaCode.jsp" %>

<%! 
	String[] choices = {"All Events", "Component Name", "Component Type"};
	String[] timeOptions = {"seconds", "minutes", "hours", "days"};
	String[] showState = {"All","Critical & Major","Critical","Major","Minor"};
	String[] stateValues={"","HIGHINTERMEDIATE","HIGH","INTERMEDIATE","LOW"};
	String[] ackState={"All","Acknowledged","Unacknowledged","Yet to be acknowledged"};
	String[] ackStateValues={"all","ack","unAck","notAck"};
	String ack_arr[] = {"Yes","No"};
	String ack_arr_disp[] = {"All","Latest"};
	//String dispDate = null;
%>
<%
	Vector y_component = new Vector();
	String MainTitle = "";
	String SubTitle = "";
	String subReportType = "";
	String dispDate1 = null;

try
{
	response.setContentType("application/json");
	JSONObject rootJSON = new JSONObject();
	JSONObject screenLableJSON = new JSONObject();
	JSONObject hiddenfieldsJSON=new JSONObject();
	JSONObject loopJsonObj = new JSONObject();
	if(favorite_id==null)
	{
		String favorite_id1 =request.getParameter("FavoriteId");///(String) session.getAttribute("FavoriteId");//
		favorite_id=favorite_id1;
	}
	hiddenfieldsJSON.put("v_event",s_event);
	hiddenfieldsJSON.put("hasVMs",String.valueOf(hasVMs));
	hiddenfieldsJSON.put("subevent",sub_event);
	hiddenfieldsJSON.put("includesubzone",includesubzone);
	hiddenfieldsJSON.put("urole",user_Role);
	hiddenfieldsJSON.put("uid",loginid);
	hiddenfieldsJSON.put("userID",loginid);
	hiddenfieldsJSON.put("inidate",strUserDateFormat);
	hiddenfieldsJSON.put("getMaxDaysInMonth",String.valueOf(ErUtils.getMaxDaysInMonth()));
	hiddenfieldsJSON.put("forwardto","ErAlarmHistoryJSON");
	hiddenfieldsJSON.put("bgenabled",strbgrepportName);
	hiddenfieldsJSON.put("limitforbg",limitforbg);
	hiddenfieldsJSON.put("savereport","save");
	hiddenfieldsJSON.put("servletName","com.eg.ErAlarmHistoryC");
	hiddenfieldsJSON.put("reporttype","Operation");
	hiddenfieldsJSON.put("er_reporttype","Operation");
	hiddenfieldsJSON.put("fromSchedule",reqFromSchedule);
	if(fromScheduleModify!=null)
		hiddenfieldsJSON.put("fromScheduleModify",fromScheduleModify);
	else
		hiddenfieldsJSON.put("fromScheduleModify","null");
	if(fromFavoriteModify!=null)
		hiddenfieldsJSON.put("fromFavoriteModify",fromFavoriteModify);
	else
		hiddenfieldsJSON.put("fromFavoriteModify","null");

	if(unknownState !=null && unknownState.equalsIgnoreCase("ACKNOWLEDGEMENT"))
	{
		int pageWidthProces = 1250;
		if(hasAllComponentAccess && showUsers!=null && (showUsers.equalsIgnoreCase("true") || showUsers.equalsIgnoreCase("yes")))
		{
			pageWidthProces = 1300;
		}
		hiddenfieldsJSON.put("pageWidthProces",pageWidthProces);
	}
	hiddenfieldsJSON.put("schedule_id",schedule_id);
	hiddenfieldsJSON.put("favorite_id", favorite_id);
	hiddenfieldsJSON.put("er_favorite", er_favorite);
	hiddenfieldsJSON.put("divStatus",divStatus);
	hiddenfieldsJSON.put("unknownState",unknownState);
	rootJSON.put("showAlarms",showAlarms);

	String isSubmitted = request.getParameter("isSubmit");
	String fromFavSch = request.getParameter("fromFavSch");
	boolean isCompsAvail = true;

	rootJSON.put("isSubmit",isSubmitted);
	rootJSON.put("fromFavSch",fromFavSch);
%>
<%
	session.setAttribute("reporttype","Operation");
	if(unknownState!=null && unknownState.equals("UNKNOWN"))
	{
		subReportType = "UnknownHistory";
		session.setAttribute("subReportType",subReportType);
		hiddenfieldsJSON.put("er_bgreportfrom","Operation_Unknown_History");
		hiddenfieldsJSON.put("er_rtype","UnknownHistory");
		hiddenfieldsJSON.put("er_trgttype","Unknown History Report");
%>
<%
	}
	else
	{
		subReportType = "AlarmHistory";
		session.setAttribute("subReportType",subReportType);
		hiddenfieldsJSON.put("er_bgreportfrom","Operation_Alarm_History");
		hiddenfieldsJSON.put("er_rtype","AlarmHistory");
		hiddenfieldsJSON.put("er_trgttype","Alarm History Report");
	}

	String strwidth = "90%";
	if(backreqMap == null || backreqMap != null && backreqMap.size() == 0)
		strwidth="100%";

	String er_RmDispName = request.getParameter("er_RmDispName");
	if(er_RmDispName!=null && er_RmDispName.length()>0){
		MainTitle = er_RmDispName.trim();
	}
	else
	{
		MainTitle = (String)mappingInfo.getTextDescription("reporter.alarmHistory.OPERATION REPORTS")+" - "+(String)mappingInfo.getTextDescription(th_alarm);
		session.setAttribute("MainTitle",MainTitle);
	}
	rootJSON.put("reportTitle",MainTitle);

	if(backreqMap != null && backreqMap.size() > 0 &&  enableBack && request.getParameter("enableBack")!=null && request.getParameter("enableBack").equalsIgnoreCase("true") && (fromFavSch!=null && fromFavSch.equalsIgnoreCase("true")))
	{
		rootJSON.put("ID","backQnumber="+erhelputils.getBackID()+"&"+erhelputils.getQueryString());

	}
	else if(fromFavSch!=null && fromFavSch.equalsIgnoreCase("true"))
	{
		rootJSON.put("ID","backQnumber="+erhelputils.getBackID()+"&"+erhelputils.getQueryString());
	}
%>
<%
	if(showAlarms!=null  && showAlarms.equalsIgnoreCase("Yes"))
	{
%>
<%
		String tmp = "/final/servlet/com.eg.ErAlarmHistoryC?"+Qstring;
		rootJSON.put("csvURL",tmp+"&option=csv");
%>
<%
	}
%>
<%
	screenLableJSON.put("reporter.common.Analysis by", mappingInfo.getTextDescription("reporter.common.Analyze by"));
%>
<%
	JSONArray analysisComboArray = new JSONArray();
		JSONArray componentJSONAray = new JSONArray();
	for(int g=0;g<event_for.size();g++)
	{
		loopJsonObj = new JSONObject();
		String select_event = (String)event_for.get(g);
		loopJsonObj.put("displayField",mappingInfo.getTextDescription("reporter.history."+select_event));
		loopJsonObj.put("valueField", select_event);
		analysisComboArray.add(loopJsonObj);
		// by karthikeyan 
		if(datafrom!=null && datafrom.equals("Zone"))
		{
			EgGroupInfo gpinfo = new EgGroupInfo();
			List tempComponent = gpinfo.getAllComponentsUnderZone(request.getParameter("select_farm"),true);
			y_component = new Vector();
			String compType=request.getParameter("compTypeList");
			componentJSONAray = new JSONArray();
				for (int j = 0; j < tempComponent.size(); j++)
				{
					String tempStr = (String) tempComponent.get(j);
					tempStr = tempStr.substring(tempStr.indexOf(":") + 1)+ ":"+ tempStr.substring(0, tempStr.indexOf(":"));
					String 	sstr=tempStr.substring(tempStr.lastIndexOf(":")+1,tempStr.length());
					if(sstr.equalsIgnoreCase(compType))
					{
						tempStr=tempStr.substring(0,tempStr.lastIndexOf(":"));
						y_component.add(tempStr);

						loopJsonObj = new JSONObject();
						loopJsonObj.put("displayField",tempStr);
						loopJsonObj.put("valueField", tempStr);
						componentJSONAray.add(loopJsonObj);
					}
				}
			rootJSON.put("selectedAnalysis","Zone");
			rootJSON.put("selectedElement",request.getParameter("select_farm"));

			List zoneList=new ArrayList();
			zoneList.addAll(user.getZones());
			JSONArray zoneComboArray = new JSONArray();
			for(int m=0;m<zoneList.size();m++)
			{
				String str = (String)zoneList.get(m);
				loopJsonObj = new JSONObject();
				loopJsonObj.put("displayField",str);
				loopJsonObj.put("valueField",str);
				zoneComboArray.add(loopJsonObj);
			}
			rootJSON.put("elementsCombo",zoneComboArray);
		}
		else if(datafrom!=null)
		{
			rootJSON.put("selectedAnalysis",datafrom);
			
		}
		else if(select_event!=null && select_event.trim().length()>0 && select_event.equals(s_event))
		{
			rootJSON.put("selectedAnalysis",select_event);
%>
<%
		}
%>
<%
	}
	if(datafrom!=null && datafrom.equals("Zone"))
	{
		rootJSON.put("componentsCombo",componentJSONAray);
	}
	rootJSON.put("analysisCombo",analysisComboArray);
	screenLableJSON.put("reporter.history.Include Subzones", mappingInfo.getTextDescription("reporter.history.Include Subzones"));

	Vector v_include=new Vector();
	v_include.add("Yes");
	v_include.add("No");
	JSONArray subZoneComboArray = new JSONArray();
	Iterator subZone_itr = v_include.iterator();
	while ( subZone_itr.hasNext() )
	{
		loopJsonObj = new JSONObject();
		String option = (String) subZone_itr.next();
		loopJsonObj.put("displayField", option);
		loopJsonObj.put("valueField", option);
		subZoneComboArray.add( loopJsonObj );
	}
	rootJSON.put("subZoneCombo", subZoneComboArray);
	if(includesubzone!=null && includesubzone.trim().length()>0 && includesubzone.equalsIgnoreCase("yes"))
	{
		rootJSON.put("subzone","Yes");
	}
	else
	{
		rootJSON.put("subzone","No");
	}
	if(treeParam!=null && treeParam.length() > 0)
	{
		sub_event = treeParam;
	}
	if(s_event!=null && s_event.length()>0 && (s_event.equals("Zone") || s_event.equals("Segment") || s_event.equals("Service")))
	{
		screenLableJSON.put("reporter.history."+s_event, mappingInfo.getTextDescription("reporter.history."+s_event));
%>
<%
		JSONArray elementsArray = new JSONArray();
		if(v_all!=null && !v_all.isEmpty())
		{
			loopJsonObj = new JSONObject();
			loopJsonObj.put("displayField",mappingInfo.getTextDescription("reporter.history.Please choose a "+s_event));
			loopJsonObj.put("valueField", "-1");
			elementsArray.add(loopJsonObj);
%>
<%
			for(int m=0;m<v_all.size();m++)
			{
				String str = (String)v_all.get(m);
				loopJsonObj = new JSONObject();
				loopJsonObj.put("displayField",str);
				loopJsonObj.put("valueField",str);
				elementsArray.add(loopJsonObj);
				
				if(str!=null && str.trim().length()>0 && str.equals(sub_event))
				{
					rootJSON.put("selectedElement",str);
%>
<%
				}
%>
<%
			}
		}
		else
		{
			loopJsonObj = new JSONObject();
			loopJsonObj.put("displayField",mappingInfo.getTextDescription("reporter.common.Not Applicable")+"!");
			loopJsonObj.put("valueField", "notapplicable");
			elementsArray.add(loopJsonObj);
		}
		rootJSON.put("elementsCombo",elementsArray);
%>
<%
	}
%>
<%
	MappingNameSorter sorter = new MappingNameSorter(language);
	ArrayList serverList = new ArrayList();
%>
<%
	screenLableJSON.put("reporter.common.Component Type", mappingInfo.getTextDescription("reporter.common.Component Type"));
	JSONArray compTypeJSONArray = new JSONArray();

	if(s_event!=null && s_event.trim().length()>0 && (s_event.equals("Component") || s_event.equals("Service") || s_event.equals("Segment") || s_event.equals("Zone")))
	{
		if(s_event.equals("Component"))
			sub_event = "Component";

		Map someMap = new LinkedHashMap();
		if(((common_list!=null && common_list.size()>0) || hasVMs) && sub_event!=null  && sub_event.trim().length()>0)
		{
			loopJsonObj = new JSONObject();
			loopJsonObj.put("displayField",mappingInfo.getTextDescription("reporter.common.All"));
			loopJsonObj.put("valueField", "All");
			compTypeJSONArray.add(loopJsonObj);
			
			rootJSON.put("selectedCompType","All");
			if(hasVMs)
				someMap.put(vmType,vmType);
			for(int i=0;i<common_list.size();i++)
			{
				String compTypes = (String)common_list.get(i);
				String comp_type=null;
				if(compTypes!=null && compTypes.trim().length()>0)
				{
					comp_type = compTypes.substring(0,compTypes.indexOf(":"));
					if(!someMap.containsKey(comp_type))
					{
						String tmp = (String)mappingInfo.getComponentTypeDescription(comp_type);
						someMap.put(comp_type,tmp.toUpperCase());
					}
				}
			}
			//Sorting Map
			someMap = (HashMap)helper.sortHashMap(someMap);
			Set s = someMap.entrySet();
			Iterator i = s.iterator();
			while (i.hasNext())
			{
				String tmp = (i.next()).toString();
				String key = tmp.substring(0,tmp.indexOf("="));
				String value = tmp.substring(tmp.indexOf("=")+1);
				if(key!=null && key.trim().length()>0)
				{
					loopJsonObj = new JSONObject();
					loopJsonObj.put("displayField",mappingInfo.getComponentTypeDescription(key));
					loopJsonObj.put("valueField", key);
					compTypeJSONArray.add(loopJsonObj);
					if(selectedCompType!=null && selectedCompType.equals(key))
					{
						rootJSON.put("selectedCompType",key);
%>
<%
					}
%>
<%
				}
			}
		}
		else
		{
			loopJsonObj = new JSONObject();
			loopJsonObj.put("displayField",mappingInfo.getTextDescription("reporter.common.Not Applicable")+"!");
			loopJsonObj.put("valueField", "-1");
			compTypeJSONArray.add(loopJsonObj);
%>
<%
		}
		rootJSON.put("compTypeCombo",compTypeJSONArray);
	}
%>
<%
	screenLableJSON.put("componentSearch", mappingInfo.getTextDescription("reporter.common.Component")+" "+mappingInfo.getTextDescription("reporter.common.Search"));
%>
<%
	String[] arr_compNameList = null;
	List tmp_complist = null;
	arr_compNameList = request.getParameterValues("compNameList");
	//replacing special character
	if(arr_compNameList!=null)
	{
	for(int n=0;arr_compNameList.length>n;n++)
	{
	String tmpcomp=arr_compNameList[n];
	if(tmpcomp.indexOf("|plus|")>-1)
	{
	tmpcomp=StringUtils.replace(tmpcomp,"|plus|+","");
	}
	if(tmpcomp.indexOf("|amp|")>-1)
	{
		tmpcomp=StringUtils.replace(tmpcomp,"|amp|","&");
	}
	if (tmpcomp.indexOf("|pct|")>-1)
	{
		tmpcomp=StringUtils.replace(tmpcomp,"|pct|","%");
	}
	if (tmpcomp.indexOf("|hash|")>-1)
	{
		tmpcomp=StringUtils.replace(tmpcomp,"|hash|","#");
	}
	arr_compNameList[n]=tmpcomp;
	}
	}
	if(arr_compNameList!=null)
	{
		tmp_complist = Arrays.asList(arr_compNameList);
		Collections.sort(tmp_complist);
	}
%>
<%
	Vector v_comp_popup = new Vector();
	Vector v_comp_popup_disp = new Vector();
	screenLableJSON.put("reporter.common.Component", mappingInfo.getTextDescription("reporter.common.Components"));
	JSONArray componentJSONArray = new JSONArray();
	JSONArray selectedComponents = new JSONArray();

	if(serverNames!=null && (s_event!=null && s_event.trim().length()>0 && (s_event.equals("Component") || s_event.equals("Service") || s_event.equals("Segment") || s_event.equals("Zone"))))
	{
		if(s_event.equals("Component"))
			sub_event = "Component";
		if(sub_event!=null && sub_event.trim().length()>0)
		{
			Collections.sort(serverNames,String.CASE_INSENSITIVE_ORDER);
			Object[] names = serverNames.toArray();
			String searchByComp = request.getParameter("compsearch");
			StringBuffer tmp = new StringBuffer();

			if (StringUtils.isNull(selectedCompType) && names.length>0)
			{
				selectedCompType = "All";
			}
			if(searchByComp!=null && !searchByComp.trim().equals(""))
			{
				selectedComponents.add("All Components");
				for(int i=0;i<names.length;i++)
				{
					String comp = (String)names[i];
					if((comp.toUpperCase()).indexOf(searchByComp.toUpperCase()) > -1 )
					{
						loopJsonObj = new JSONObject();
						loopJsonObj.put("displayField",names[i]);
						loopJsonObj.put("valueField", names[i]);
						if(datafrom!=null && datafrom.equals("Zone"))
						{
							if(y_component.contains(names[i]))
								componentJSONArray.add(loopJsonObj);
						}
						else
						{
							componentJSONArray.add(loopJsonObj);
						}
						if(tmp_complist!=null && !tmp_complist.contains(names[i]))
						{
							
							v_comp_popup.add(names[i]);
							v_comp_popup_disp.add(names[i]);
%>
<%
						}
						else
						{
							v_comp_popup.add(names[i]);
							v_comp_popup_disp.add(names[i]);
%>
<%
						}
					}
				}
			}
			else if(names.length>0)
			{
				if(selectedCompType!=null && !selectedCompType.equals("") && (selectedCompName==null || selectedCompName.equals("null") || selectedCompName.equals("")))
				{
					selectedComponents.add("All Components");
					for(int i=0;i<names.length;i++)
					{
						loopJsonObj = new JSONObject();
						loopJsonObj.put("displayField",names[i]);
						loopJsonObj.put("valueField", names[i]);
						if(datafrom!=null && datafrom.equals("Zone"))
						{
							if(y_component.contains(names[i]))
								componentJSONArray.add(loopJsonObj);
						}
						else
						{
							componentJSONArray.add(loopJsonObj);
						}
						if(tmp_complist!=null && !tmp_complist.contains(names[i]))
						{
							v_comp_popup.add(names[i]);
							v_comp_popup_disp.add(names[i]);
%>
<%
						}
						else
						{
							v_comp_popup.add(names[i]);
							v_comp_popup_disp.add(names[i]);
%>
<%
						}
					}
				}
				else
				{
					for(int i=0;i<names.length;i++)
					{
						loopJsonObj = new JSONObject();
						loopJsonObj.put("displayField",names[i]);
						loopJsonObj.put("valueField", names[i]);
						if(datafrom!=null && datafrom.equals("Zone"))
						{
							if(y_component.contains(names[i]))
								componentJSONArray.add(loopJsonObj);
						}
						else
						{
							componentJSONArray.add(loopJsonObj);
						}
					}
					for(int kk=0;kk<selectNames.length;kk++)
					{
						selectedComponents.add(selectNames[kk]);
					}
						v_comp_popup.addAll(serverNames);
						v_comp_popup_disp.addAll(serverNames);
				}
			}
			else if(names.length<=0)
			{
				loopJsonObj = new JSONObject();
				loopJsonObj.put("displayField",mappingInfo.getTextDescription("reporter.history.Component name (Optional)"));
				loopJsonObj.put("valueField", "-1");
				componentJSONArray.add(loopJsonObj);

				v_comp_popup.add("-1");
				v_comp_popup_disp.add("Component name (Optional)");
				selectedComponents.add("-1");
%>
<%
			}
		}
		else 
		{
			loopJsonObj = new JSONObject();
			loopJsonObj.put("displayField",mappingInfo.getTextDescription("reporter.history.Component name (Optional)"));
			loopJsonObj.put("valueField", "-1");
			componentJSONArray.add(loopJsonObj);
			selectedComponents.add("-1");

			v_comp_popup.add("-1");
			v_comp_popup_disp.add("Component name (Optional)");
			isCompsAvail = false;
%>
<%
		}
	}
	else
	{
		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",mappingInfo.getTextDescription("reporter.common.Not Applicable")+"!");
		loopJsonObj.put("valueField", "-1");
		componentJSONArray.add(loopJsonObj);
		selectedComponents.add("-1");

		v_comp_popup.add("-1");
		v_comp_popup_disp.add("Not Applicable!");
		isCompsAvail = false;
%> 
<%
	}
	if(datafrom ==null || !datafrom.equals("Zone"))
	{ 
		if(isCompsAvail){
			loopJsonObj = new JSONObject();
			loopJsonObj.put("displayField","--All Components--");
			loopJsonObj.put("valueField", "All Components");
			componentJSONArray.add(0,loopJsonObj);
		}
		rootJSON.put("componentsCombo",componentJSONArray);
	}
	rootJSON.put("selectedComponents",selectedComponents);
%>
	<%@ include file ="ErTimeFormatJSON.jsp"%>
<%
	hiddenfieldsJSON.put("userTimeline",strUsrTimeline);
	screenLableJSON.put("reporter.common.Timeline", mappingInfo.getTextDescription("reporter.common.Timeline"));
	screenLableJSON.put("reporter.common.From", mappingInfo.getTextDescription("reporter.common.From"));
	screenLableJSON.put("reporter.common.To", mappingInfo.getTextDescription("reporter.common.To"));
	screenLableJSON.put("reporter.common.Hr", mappingInfo.getTextDescription("reporter.common.Hr"));

	rootJSON.put("timelineCombo",timelineComboArray);
	rootJSON.put("selectedTimeline",er_timeline);
	rootJSON.put("startDate",startDateJSON);
	rootJSON.put("endDate",endDateJSON);
	rootJSON.put("startHour",startHourJSON);
	rootJSON.put("endHour",endHourJSON);
	rootJSON.put("startmin",startMin);
	rootJSON.put("endmin",endMin);
	rootJSON.put("selectedGraphMode",selectedGraphMode);

	//User TimeZone changes
	rootJSON.put("startDateForDisplay",startDateForDisplay);
	rootJSON.put("startHourForDisplay",startHourForDisplay);
	rootJSON.put("startMinForDisplay",startMinForDisplay);
	rootJSON.put("endDateForDisplay",endDateForDisplay);
	rootJSON.put("endHourForDisplay",endHourForDisplay);
	rootJSON.put("endMinForDisplay",endMinForDisplay);
%>
<%
	String sdate = request.getParameter("startdate");
	String edate = request.getParameter("enddate");
	String shr = request.getParameter("starthr");
	String ehr = request.getParameter("endhr");
	String smin = request.getParameter("startmin");
	String emin = request.getParameter("endmin");

	SubTitle = "Start Date : "+sdate+" "+shr+":"+smin+" "+"Hrs "+"   End Date : "+edate+" "+ehr+":"+emin+" Hrs ";
	session.setAttribute("SubTitle",SubTitle);
%>
<%
		String priority_unknown="";
		String priority_alarm="";
 		if(unknownState !=null && unknownState.equals("UNKNOWN"))
		{
			priority_unknown="selected";
			priority_alarm="";
			rootJSON.put("alarmType","UNKNOWN");
			hiddenfieldsJSON.put("alarmType","UNKNOWN");
  		}
		else if(unknownState !=null && unknownState.equalsIgnoreCase("ACKNOWLEDGEMENT"))
		{
			priority_unknown="";
			priority_alarm="selected";
			rootJSON.put("alarmType","ACKNOWLEDGEMENT");
			hiddenfieldsJSON.put("alarmType","ACKNOWLEDGEMENT");
 		}
		else
		{
			priority_unknown="";
			priority_alarm="selected";
			rootJSON.put("alarmType","KNOWN");
			hiddenfieldsJSON.put("alarmType","KNOWN");
 		}
%>
<%
 		if(priority_alarm.equals("selected"))
		{
			screenLableJSON.put("reporter.alarmHistory.Priority", mappingInfo.getTextDescription("reporter.alarmHistory.Priority"));
%>
<%
			String s_state = request.getParameter("state");
			if (s_state==null) s_state="";
%>
<%
			JSONArray showStateArray=new JSONArray();
			rootJSON.put("selectedState","All");
			for(int i=0;i<showState.length;i++)
			{
				loopJsonObj = new JSONObject();
				loopJsonObj.put("valueField", stateValues[i]);
				if(s_state.equalsIgnoreCase(stateValues[i]))
					rootJSON.put("selectedState",s_state);
%>
<%
				if(i==0)
				{
					loopJsonObj.put("displayField",mappingInfo.getTextDescription("reporter.history."+showState[i]));
%>
<%
				}
				else if(i==1)
				{
					if(showState[i].indexOf("&")>-1)
					{
						if((showState[i].substring(0,showState[i].indexOf("&")).trim()).equals("Critical"))
						{
							String tmpval=mappingInfo.getLabelDescription("HIGH") + " &  " + mappingInfo.getLabelDescription("INTERMEDIATE");
							loopJsonObj.put("displayField",tmpval);
						}
					}
				}
				else
				{
					loopJsonObj.put("displayField",mappingInfo.getLabelDescription(stateValues[i]));
				}
				showStateArray.add(loopJsonObj);
%>
<%
			}
			rootJSON.put("stateCombo",showStateArray);
%>
<%
		}
		rootJSON.put("AllUser","true");
		if(hasAllComponentAccess && showUsers!=null && (showUsers.equalsIgnoreCase("true") || showUsers.equalsIgnoreCase("yes")))
		{
			rootJSON.put("enableUserCombo","yes");
			hiddenfieldsJSON.put("enableUserCombo","yes");

			screenLableJSON.put("reporter.common.User",	mappingInfo.getTextDescription("reporter.common.User")+mappingInfo.getTextDescription("reporter.common.(s)"));
%>
<%
				ArrayList users          = new ArrayList();
				Hashtable usersWithTypes = (Hashtable)ecumb.getUsers();
				Enumeration keys         = usersWithTypes.keys();
				while(keys.hasMoreElements())
				{
					String user_Name     = keys.nextElement().toString();
					String userType     = usersWithTypes.get(user_Name).toString();
					EgUserRole userRole = EgUserRole.getRoleObject(userType);
					if(userRole!=null && !userRole.hasAllComponentAccess())
						users.add(user_Name);
				}
				JSONArray usersArray=new JSONArray();
				if(users!=null && users.size()>0)
				{
					loopJsonObj = new JSONObject();
					loopJsonObj.put("displayField", mappingInfo.getTextDescription("reporter.userview.All"));
					loopJsonObj.put("valueField", "-1");
					usersArray.add( loopJsonObj );
					rootJSON.put("selectedUser","-1");
%>
<%
					for(int i=0;i<users.size();i++)
					{
						String strUserForDisplay = (String)users.get(i);
						if (strUserForDisplay.indexOf("/Grp/") != -1)
						{
							String grpDelimiter = "/Grp/";
							int idx = strUserForDisplay.indexOf(grpDelimiter);
							String str_uname_A = strUserForDisplay.substring(0,idx);
							int nextIdx = idx + grpDelimiter.length();
							String str_uname_B = strUserForDisplay.substring(nextIdx);
							strUserForDisplay = str_uname_A + "/" + str_uname_B + " (Group)";
						}

						loopJsonObj = new JSONObject();
						loopJsonObj.put("displayField", strUserForDisplay);
						loopJsonObj.put("valueField",users.get(i));
						usersArray.add( loopJsonObj );
						if(users.get(i).equals(showUserValue))
							rootJSON.put("selectedUser",users.get(i));

						if(showUserValue != "" &&! showUserValue.equals("-1")){
							rootJSON.put("AllUser","false");
						}
	%>
	<%
					}
				}
				else
				{
					loopJsonObj = new JSONObject();
					loopJsonObj.put("displayField",mappingInfo.getTextDescription("reporter.userview.No Users"));
					loopJsonObj.put("valueField","-1");
					usersArray.add( loopJsonObj );
					rootJSON.put("selectedUser","-1");
%>
<%
				}
				rootJSON.put("usersCombo",usersArray);
%>
<%
			}
			else
			{
				rootJSON.put("enableUserCombo","no");
				hiddenfieldsJSON.put("enableUserCombo","no");
			}
%>
<%
	screenLableJSON.put("reporter.common.Duration",mappingInfo.getTextDescription("reporter.common.Duration"));
	JSONArray durationArray = new JSONArray();
	rootJSON.put("duration",String.valueOf(Math.abs(minDuration)));
%>
<%
	loopJsonObj = new JSONObject();
	loopJsonObj.put("valueField",">");
	loopJsonObj.put("displayField",mappingInfo.getTextDescription("reporter.history.Greater than"));
	durationArray.add( loopJsonObj );
	loopJsonObj = new JSONObject();
	loopJsonObj.put("valueField","<");
	loopJsonObj.put("displayField",mappingInfo.getTextDescription("reporter.history.Lesser than"));
	durationArray.add( loopJsonObj );
	rootJSON.put("durationCombo",durationArray);
	rootJSON.put("selectedDuration",""+condition);


	screenLableJSON.put("reporter.common.Response Time",mappingInfo.getTextDescription("reporter.common.Response Time"));
	JSONArray ack_durationArray = new JSONArray();
	rootJSON.put("ack_duration",String.valueOf(Math.abs(ack_minDuration)));

	loopJsonObj = new JSONObject();
	loopJsonObj.put("valueField","gt");
	loopJsonObj.put("displayField",mappingInfo.getTextDescription("reporter.history.Greater than"));
	ack_durationArray.add( loopJsonObj);
	loopJsonObj = new JSONObject();
	loopJsonObj.put("valueField","le");
	loopJsonObj.put("displayField",mappingInfo.getTextDescription("reporter.history.Lesser than"));
	ack_durationArray.add( loopJsonObj );
	loopJsonObj = new JSONObject();
	loopJsonObj.put("valueField","none");
	loopJsonObj.put("displayField",mappingInfo.getTextDescription("reporter.history.None"));
	ack_durationArray.add( loopJsonObj );
	rootJSON.put("ack_durationCombo",ack_durationArray);
	rootJSON.put("selectedAckDuration",""+ack_condition);


%>
<%
	JSONArray timeOptionArray =  new JSONArray();
	for(int i=0;i<timeOptions.length;i++)
	{
		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",mappingInfo.getTextDescription("reporter.history."+timeOptions[i]));
		loopJsonObj.put("valueField",timeOptions[i]);
		timeOptionArray.add( loopJsonObj );
		
		if(durationType!=null && durationType.equals(timeOptions[i]))
		{
			rootJSON.put("selectedTimeOption",durationType);
		}
		if(ack_durationType!=null && ack_durationType.equals(timeOptions[i]))
		{
			rootJSON.put("selectedAckTimeOption",ack_durationType);
		}
%>
<%
	}
	rootJSON.put("timeOptionCombo",timeOptionArray);
	rootJSON.put("ack_timeOptionCombo",timeOptionArray);
	JSONArray ackStateArray =  new JSONArray();
	for(int i=0;i<ackStateValues.length;i++)
	{
		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",mappingInfo.getTextDescription("reporter.history."+ackState[i]));
		loopJsonObj.put("valueField",ackStateValues[i]);
		ackStateArray.add( loopJsonObj );
	}
	if(ack_state==null || ack_state.length()==0)
		ack_state = ackStateValues[0];
	rootJSON.put("selectedAckState",ack_state);
	rootJSON.put("ack_stateCombo",ackStateArray);
	screenLableJSON.put("reporter.alarmHistory.Status", mappingInfo.getTextDescription("reporter.alarmHistory.Status"));

	JSONArray showAllRecordArray =  new JSONArray();
	for(int i=0;i<ack_arr.length;i++)
	{
		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",mappingInfo.getTextDescription("reporter.history."+ack_arr_disp[i]));
		loopJsonObj.put("valueField",ack_arr[i]);
		showAllRecordArray.add( loopJsonObj );
	}
	if(showAllRecord==null || showAllRecord.length()==0)
		showAllRecord = ack_arr[1]; // only for customer not for product
	rootJSON.put("selectedShowAllRecord",showAllRecord);
	rootJSON.put("showAllRecordCombo",showAllRecordArray);
	screenLableJSON.put("reporter.alarmHistory.Show Acknowledgement", mappingInfo.getTextDescription("reporter.alarmHistory.Show Acknowledgement"));
%>
<%
	screenLableJSON.put("reporter.common.Search by",mappingInfo.getTextDescription("reporter.common.Search by"));
	JSONArray searchOptionArray = new JSONArray();
	for( int kk=0;arr_optionsArrangeValueForUnknown.length>kk;kk++)
	{
		if(arr_optionsArrangeValueForUnknown[kk].equals(searchBy))
			rootJSON.put("selectedSearchOption",searchBy);
		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",arr_optionsArrangeDispForUnknown[kk]);
		loopJsonObj.put("valueField",arr_optionsArrangeValueForUnknown[kk]);
		searchOptionArray.add( loopJsonObj );
	}
	rootJSON.put("searchCombo",searchOptionArray);
%>
<%
	rootJSON.put("searchByUser",searchByUser);
%>
<%
	screenLableJSON.put("reporter.common.Sort by",mappingInfo.getTextDescription("reporter.common.Sort by"));
	JSONArray sortOptionArray = new JSONArray();
	for( int kk=0;arr_optionsArrangeValue.length>kk;kk++)
	{
		if(arr_optionsArrangeValue[kk].equals(selectedArrangeOption))
			rootJSON.put("selectedSortOption",selectedArrangeOption);
		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",arr_optionsArrangeDisp[kk]);
		loopJsonObj.put("valueField",arr_optionsArrangeValue[kk]);
		sortOptionArray.add( loopJsonObj );
	}
	rootJSON.put("sortCombo",sortOptionArray);
%>
<%
	String rowCount = request.getParameter("eventsPerPage");
	if(rowCount == null || rowCount.equals("null"))
		rowCount = rowsPerPage[0];
	screenLableJSON.put("reporter.alarmHistory.Events per page",mappingInfo.getTextDescription("reporter.alarmHistory.Events per page"));
	JSONArray eventPerpageArray = new JSONArray();

	for(int i=0;i<rowsPerPage.length;i++)
	{
		if(rowsPerPage[i].equals(rowCount))
			rootJSON.put("selectedEvntPerPage",rowCount);
		loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",rowsPerPage[i]);
		loopJsonObj.put("valueField",rowsPerPage[i]);
		eventPerpageArray.add( loopJsonObj );
%>
<%
	}
	rootJSON.put("eventPerPageCombo",eventPerpageArray);
%>
<%
	screenLableJSON.put("reporter.common.Report Generation", mappingInfo.getTextDescription("reporter.common.Report Generation"));
	screenLableJSON.put("reporter.consolidated.Report Name", mappingInfo.getTextDescription("reporter.consolidated.Report Name"));
	screenLableJSON.put("reporter.common.SAVE", mappingInfo.getTextDescription("reporter.common.SAVE"));
	screenLableJSON.put("reporter.common.SUBMIT", mappingInfo.getTextDescription("reporter.common.SUBMIT"));

	JSONArray reportGenerationComboArray =  new JSONArray();
	JSONObject tmpobj=new JSONObject();
	tmpobj.put("displayField", strbackground);
	tmpobj.put("valueField", "background");
	reportGenerationComboArray.add(tmpobj);

	tmpobj=new JSONObject();
	tmpobj.put("displayField","Background Save - CSV");
	tmpobj.put("valueField","background-csv");
	reportGenerationComboArray.add(tmpobj);

	tmpobj=new JSONObject();
	tmpobj.put("displayField", strforeground);
	tmpobj.put("valueField", "foreground");
	reportGenerationComboArray.add(tmpobj);

	rootJSON.put("reportGenerationCombo",reportGenerationComboArray);
	rootJSON.put("backgroundReportStatus",status);
%>
<%
	if(strbgrepportName != null && strbgrepportName.equalsIgnoreCase("Yes"))
	{
%>
<%
		if (er_reportgenration != null && er_reportgenration.equals("background"))
		{
			rootJSON.put("reportGeneration","background");
%>
<%
		}
		else if(er_reportgenration != null && er_reportgenration.equals("background-csv"))
		{
			rootJSON.put("reportGeneration","background-csv");
		}
		else
		{
			rootJSON.put("reportGeneration","foreground");
%>
<%
		}
%>
<%
	}
%>
<%
		// dislpay data loading option when data loading in jsp.
		// jsp take more time to load data in clinet side,so avoid page display blank.
		// Up-Down Arrow Heading Calculation

	String sHideView = s_event;
	if (s_event == null || s_event.equals("null")) {
		sHideView = "Components";
	}
	if (sub_event == null || sub_event.equals("null")) {
		sub_event = null;
	}
	else if(sub_event != null && sub_event.equalsIgnoreCase("Component"))
	{
		sHideView = sub_event+"s";
	}
	if (sub_event != null) {
		if(sub_event.equalsIgnoreCase("Component"))
			sHideView = sub_event+"s";
		else
			sHideView += " : " + sub_event;
	}
%>
<%
	if(isSubmit!=null && isSubmit.equalsIgnoreCase("true"))
	{
		JSONObject selectionDetails=new JSONObject();
		if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
		{
			comFormat = "MM/dd/yyyy";
		}
		else
		{
			comFormat = currentDateFormat;
		}
		dispDate1 = DateUtil.changeDateFormat(s_st_time,comFormat,currentDateFormat);
		if(DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
		{
			comFormat = "MM/dd/yyyy";
		}
		else
		{
			comFormat = currentDateFormat;
		}
		dispDate = DateUtil.changeDateFormat(s_en_time,comFormat,currentDateFormat);
		String comptype = request.getParameter("compTypeList");
		comptype = mappingInfo.getComponentTypeDescription(comptype);
		if(comptype!=null && comptype.equalsIgnoreCase("-1"))
			comptype = "All";
		selectionDetails.put((String)mappingInfo.getTextDescription("reporter.operation.Component Type"),comptype);
		
		String priority_state = request.getParameter("state");
		if(unknownState!=null && unknownState.equals("UNKNOWN"))
			priority_state = "Unknown";
		else if(priority_state.equalsIgnoreCase(""))
			priority_state = "All";
		else if(priority_state.equalsIgnoreCase("HIGHINTERMEDIATE"))
			priority_state = "Critical & Major";
		else if(priority_state.equalsIgnoreCase("HIGH"))
			priority_state = "Critical";
		else if(priority_state.equalsIgnoreCase("INTERMEDIATE"))
			priority_state = "Major";
		else if(priority_state.equalsIgnoreCase("LOW"))
			priority_state = "Minor";
		selectionDetails.put((String)mappingInfo.getTextDescription("reporter.operation.Priority"),priority_state);

		String pdfStartDate = startDateForDisplay+" "+startHourForDisplay+":"+startMinForDisplay;
		String pdfEndDate = endDateForDisplay+" "+endHourForDisplay+":"+endMinForDisplay;

		selectionDetails.put((String)mappingInfo.getTextDescription("reporter.common.Timeline"),
		"<span class='font_bold'> </span> "+" "+pdfStartDate+" "
		+" "+mappingInfo.getTextDescription("reporter.common.hrs")+" "+"<span class='font_bold'>  "+mappingInfo.getTextDescription("reporter.common.to")+"  </span>"+" "+pdfEndDate+" "+" "+mappingInfo.getTextDescription("reporter.common.hrs"));

		rootJSON.put("selectionDetails",selectionDetails);
		rootJSON.put("selectionDetailtitle",mappingInfo.getTextDescription("reporter.common.Selection Details for")+" "+sHideView);

		//BackGround Process
		if(bggroundStr != null && !bggroundStr.equals(""))
		{
			String strreportName ="Operation_Alarm_History";
			if(unknownState !=null && unknownState.equals("UNKNOWN"))
				strreportName ="Operation_Unknown_History";
			
			if((status != null && (status.equalsIgnoreCase("duplicate")) || (bggroundStr!=null && bggroundStr.equalsIgnoreCase("User background report generationlimit is finished"))))
			{
				strreportName ="All Report Types";
			}
			String bgroundResponseTxt=erbgreport.getlangsupportedString(bggroundStr,bgString,urs);
			rootJSON.put("bgroundResponseTxt",bgroundResponseTxt);
			rootJSON.put("bgroundReportsURL","/final/servlet/com.eg.ErStartBackGroundReportC?back=true&er_bgreportfrom="+strreportName+"&userID="+com.eg.EgURLEncoder.encode(urs, "UTF-8")+"&savereport=search&er_filterby=Report_Name&forwardto=ErBackGoundProcess");
			rootJSON.put("backgroundAnchor", mappingInfo.getTextDescription("reporter.common.Click here to see a list of generated and processing reports"));
		}
		else if(showAlarms!=null  && showAlarms.equalsIgnoreCase("Yes"))
		{
			//Setting Mail session attribute
			String dataProcess = mngrIProc+"/final/servlet/com.eg.ErAlarmHistoryC;jsessionid="+ session.getId()+"?"+QstringForMail+"&option=Graph&printGraph=yes&er_view=PRINT";
			session.setAttribute("MAIL_URL",dataProcess);

			//For Setting the PDf File Name
			HashMap pdfFileName =new HashMap();
			pdfFileName.put("fileName","Operation_History_Of_Alarms");
			session.setAttribute("parameters", pdfFileName);
			rootJSON.put("alarmResultQueryString",Qstring+"heading="+EgURLEncoder.encode(sHideView,"UTF-8"));
		}
		else
		{
			//No Measures. All Session attribute to NULL
			session.setAttribute("NO_OF_ALARMS","");
			session.setAttribute("ShowAlarms","No");
			session.setAttribute("component",null);
			session.setAttribute("MAIL_URL","");
			session.setAttribute("PDF_URL","");
			session.setAttribute("tmp_map",null);
			session.setAttribute("list",null);
%>
<%
		}
%>
<%
	}
	else
	{
		//No Measures. All Session attribute to NULL
		session.setAttribute("NO_OF_ALARMS","");
		session.setAttribute("ShowAlarms","No");
		session.setAttribute("component",null);
		session.setAttribute("MAIL_URL","");
		session.setAttribute("PDF_URL","");
		session.setAttribute("tmp_map",null);
		session.setAttribute("list",null);
	}
%>
<%
	//Tab session & Back Button attributes
	ArrayList listbackvar = new  ArrayList();
	if(isSubmit!=null)
	{
		session.setAttribute("reportLastAccessedURL","/final/reporter/ErAlarmHistory.jsp?enableBack=false&"+reportLastAccessedURL);
		listbackvar.add("ErAlarmHistory.jsp");
		listbackvar.add("status="+status+"&bggroundStr="+bggroundStr+"&"+QueryString);
		session.setAttribute("favSchBackDisplay","Yes");
	}
	else
	{
		session.setAttribute("reportLastAccessedURL","/final/reporter/ErAlarmHistory.jsp?"+reportLastAccessedURL);
		listbackvar.add("ErAlarmHistory.jsp");
		listbackvar.add(QueryString);
		session.setAttribute("favSchBackDisplay","Yes");
	}
	String backadded = erhelputils.getBackID();
	backreqMap = erhelputils.setBackQueryMap(backreqMap,backadded,listbackvar);
	session.setAttribute("backQuery",backreqMap);
	listbackvar = new  ArrayList();
	backreqMap = new HashMap();
%>
<%
	rootJSON.put("saveQstring",Qstring);
	rootJSON.put("hiddenfields",hiddenfieldsJSON);
	rootJSON.put("screenLabels",screenLableJSON);
	out.println(rootJSON.toString());
}
catch(Throwable eee)
{
	System.out.println("Check check Exception in History of Alarms. Exception : "+eee);
	eee.printStackTrace();
}
%>
