
<%
/********************************************************************************************************
*	Name			:	zones.jsp
*	Purpose			:	This jsp is used to display All the Zones and its associated components in 	Zone Dashboard
*	Version			:	5.6
*	CreationDate	:	Feb 20, 2012
*	Author			:	S.Saravanan
*******************************************************************************************************/
%>
<%@ include file = "EgMonitorTracker.jsp" %>
<%@ page import = "com.egurkha.*" %>
<%@ page import = "com.eg.*" %>
<%@ page import = "com.egurkha.monitor.*" %>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import = "java.util.*" %>
<%@ page import = "com.egurkha.ini.*" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.EgTopoInfo"%>
<%@ page import = "com.eg.EgStateZone"%>
<%@ page import="com.eg.IniFile"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgTopoInfo"%>
<%@ page import="com.eg.EgAggregateInfo" %>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import = "com.eg.EgMaintenanceInfo"%>
<%@ page import="com.egurkha.util.*"%>
<%@ page import="com.egurkha.admin.EgMaintenanceUtility"%>
<%@ page import="net.sf.json.*"%>
<%@ page import="java.sql.*"%>
<%@ page import = "egurkha.*" %>
<%
try
{
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");
	session.removeAttribute("layer");
	session.removeAttribute("test");
	CompositeComparator compobj = new CompositeComparator();
	compobj.add(new StateComparatorDes());
	compobj.add(new NameComparatorAsc());
	ZoneListData d = (ZoneListData) request.getAttribute("data");
	ZoneListResult r = (ZoneListResult) request.getAttribute("result");
	EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager");
	if(session.getAttribute("ZoneListData")!=null && session.getAttribute("ZoneListResult")!=null)
	{
		d=(ZoneListData)session.getAttribute("ZoneListData");
		r=(ZoneListResult)session.getAttribute("ZoneListResult");
	}
	int normalZoneCount=0;
	int abnormalZoneCount=(r==null?0:r.zoneList.size());
	int totalZones = (r==null?0:r.zoneList.size());
	boolean ifshowImage=(r==null?false:r.showImage);
	String treeFlag=request.getParameter("treeFlag");
	String zone_image = "";
	IniUI iniUI = IniUI.getInstance();
	UserRegistry userReg = UserRegistry.getInstance();
	User user = userReg.getUser(session.getId());
	String thisLanguage = iniUI.getDefaultLanguage();
	if (user!=null)
	{
		String userLang = user.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}
	boolean isUserLanguageEnglish=true;
	if(thisLanguage!=null && !thisLanguage.equals("en_US"))
	{
		isUserLanguageEnglish=false;
	}
	//EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	EgDateInfo dateInfo=new EgDateInfo();
	EgMaintenanceInfo egM=new EgMaintenanceInfo("manager");
	EgMaintenanceUtility maintenanceUtil=new EgMaintenanceUtility();
	EgTopoInfo topoInfo=new EgTopoInfo("manager");
	IniFile uiIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini");
	String fromHomepage = request.getParameter("fromHomepage");
	fromHomepage = (fromHomepage!=null && !fromHomepage.equalsIgnoreCase("") && !fromHomepage.equalsIgnoreCase("null") && !fromHomepage.equalsIgnoreCase("undefined"))?fromHomepage:"";

	int compNameLength = 18;
	int compHeadLength = 16;
	if(!isUserLanguageEnglish)
	{
		compNameLength = 14;
		compHeadLength = 14;
	}
	
	JSONObject json  = new JSONObject();
	JSONArray  zonesJsonArray = new JSONArray();
	JSONObject labelJson = new JSONObject();
	
	labelJson.put("ListTitle",mappingInfo.getTextDescription("monitor.zoneDashboard.ZONES"));
	labelJson.put("backButtonText",mappingInfo.getTextDescription("monitor.common.Back"));
	labelJson.put("searchResultText",mappingInfo.getTextDescription("monitor.global.Search Results For "));
	
	//if (d!=null)
	//{
	if((totalZones!=0)||(d!=null&&d.searchString!=null&&totalZones==0))
	{
		if(totalZones!=0)
		{
			labelJson.put("ListName",mappingInfo.getTextDescription("monitor.zones.Zone Name"));
			labelJson.put("AssociatedElements",mappingInfo.getTextDescription("monitor.zones.Associated Elements"));
		}
		boolean showAssociations = false;
		if(r.showAssociations&&totalZones!=0)
		{
			showAssociations = true;
			labelJson.put("Associations",mappingInfo.getTextDescription("monitor.zones.Associations"));
		}
		json.put("showAssociations",String.valueOf(showAssociations));
		if(r.showSearch)
		{
			labelJson.put("searchText",d.searchString);
			labelJson.put("searchDefaultText", "Search");
		}

		if (totalZones==0)
		{
			json.put("SearchNoListFound","true");
			json.put("SearchNoListFoundText",mappingInfo.getTextDescription("monitor.zoneDashboard.No zones found for the current search"));
		}
		if(abnormalZoneCount!=0)
		{

			if(d.action.equalsIgnoreCase("zoneState"))
			{
				json.put("listStateHiddenField",d.state);
				
				labelJson.put("ZonesIn",mappingInfo.getTextDescription("monitor.zones.Zones in"));
				json.put("ListIn_value",mappingInfo.getTextDescription("monitor.zones."+d.state.getDisplayName()));
				labelJson.put("State",mappingInfo.getTextDescription("monitor.zones.State"));
				if(d.from.equalsIgnoreCase("ZoneDashboard"))
				{
					json.put("ForTheList",mappingInfo.getTextDescription("monitor.zones.for the Zone"));
					json.put("ForTheList_value", d.zoneName);
				}
				if(d.userName!=null)
				{
					json.put("ForTheList",mappingInfo.getTextDescription("monitor.zones.For the User"));
					json.put("ForTheList_value", d.userName);
				}
			}
			else
			{
				if(d.userName!=null)
				{
					json.put("ListForTheUser",mappingInfo.getTextDescription("monitor.servers.zones for the User "));
					json.put("ListForTheUser_value", d.userName);
				}
				if(d.from!=null && d.from.equals("ZoneDashboard") && d.action.equals("zone"))
				{
					json.put("ListForTheUser",mappingInfo.getTextDescription("monitor.servers.Zones For the Zone "));
					json.put("ListForTheUser_value", d.zoneName);
				}
			}

			int i = 0;
			int j = 0;
			EgZone zone = null;
			
			json.put("AbnormalListCountHiddenField",String.valueOf(r.zoneList.size()));
			for(i = 0; i < r.zoneList.size(); i++)//zone loop start here
			{
				zone = (EgZone) r.zoneList.get(i);
				
				JSONObject zone_json_object = new JSONObject();

				request.setAttribute("jsonObject",zone_json_object);
				request.setAttribute("category","zone");
				request.setAttribute("itemName",zone.getName());

				%>
					<%@ include file="aggregateTabHandler.jsp" %>
				<%

				if(ifshowImage)
				{
					zone_image=(String)uiIni.getValue("ZONE_DISPLAY_IMAGE",zone.getName());
					if(zone_image.indexOf("Small")!=-1)
					{
						zone_image=zone_image.replace("Small","48");
						if(zone_image.equals("serviceOthers48"))
						{
							zone_image="zone_GRAY";
						}
						zone_json_object.put("ZoneImage",zone_image);
						zone_json_object.put("StateName", zone.getState().getName());
					}
				}

				zone_json_object.put("NameText", zone.getName());
				zone_json_object.put("URL", "/final/monitor/zoneDash.jsp?treeFlag="+treeFlag+"&outsideZone=true&titleText=zone&selectNode=Zone^"+EgURLEncoder.encode(zone.getName(),"UTF-8")+"&selectedParam="+EgURLEncoder.encode(zone.getName(),"UTF-8")+"&zoneName="+EgURLEncoder.encode(zone.getName(),"UTF-8")+"&zoneFromZone="+EgURLEncoder.encode(zone.getName(),"UTF-8")+"&fromHomepage="+fromHomepage);
				zone_json_object.put("Tooltip", zone.getName());
				JSONArray inner_items_json = new JSONArray();

				EgList zoneList = zone.getZoneList();
				int normalZones=0;
				int abnormalZones=zoneList.size();//sarav subZone start here 
				if(zoneList != null&&zoneList.size()>0&&abnormalZones>0)
				{
					JSONObject inner_zone_json_object = new JSONObject();
					inner_zone_json_object.put("NameText",mappingInfo.getTextDescription("monitor.common.Zones"));
					if(zoneList!=null)
					{
						int count = zoneList.size();
						int compSize = count;
						int goodCount = zoneList.getCount(State.getState("Good"));
						
						JSONArray innerZonesJsonArray = new JSONArray();
						
						for(j = 0; (j < compSize && j < r.dispCompCount); j++)
						{
							
							JSONObject innerZoneJsonObject = new JSONObject();
							
							EgZone zones = null;
							if (j <compSize)
							{
								zones = (EgZone) zoneList.get(j);
								
								ArrayList aggregateArrayZone = aggregateInfo.getAggregateComponentsOfElement("zone",zones.getName());

								boolean aggregateTab =false;
								if(aggregateArrayZone != null && aggregateArrayZone.size() > 0)
									aggregateTab = true;
								
								innerZoneJsonObject.put("StateName","state_"+zones.getState().getName());
								String href = "/final/monitor/zoneDash.jsp?from=ZoneDashboard&selectNode=Zone^"+EgURLEncoder.encode(zones.getName(),"UTF-8")+"&selectedParam="+EgURLEncoder.encode(zones.getName(),"UTF-8")+"&currentTab=details&monCmd=zoneDashboard&zoneName="+EgURLEncoder.encode(zones.getName(),"UTF-8")+"&treeOpen=false&fromHomepage="+fromHomepage+"&aggregateTab="+aggregateTab+"&parentZone="+zone.getName();
								
								innerZoneJsonObject.put("URL",href);

								innerZoneJsonObject.put("Tooltip",zones.getName());
								innerZoneJsonObject.put("NameText",zones.getName());
							}
							innerZonesJsonArray.add(innerZoneJsonObject);
						}
						inner_zone_json_object.put("InnerItems",innerZonesJsonArray);
						
						inner_items_json.add(inner_zone_json_object);
					}
				}
				EgList serviceList = zone.getServiceList();
				int normalServices=0;
				int abnormalServices=serviceList.size();
				if(serviceList != null && serviceList.size()>0 && abnormalServices>0)
				{
					JSONObject inner_service_json_object = new JSONObject();
					
					inner_service_json_object.put("NameText",mappingInfo.getTextDescription("monitor.common.Services"));
					int count = serviceList.size();
					int goodCount = serviceList.getCount(State.getState("Good"));
					//count = count - goodCount;
					int compSize = count;
					
					JSONArray innerServiceJsonArray = new JSONArray();
					
					for(j = 0; (j < compSize) && j < count; j++)
					{
						JSONObject innerServiceJsonObject = new JSONObject();
						EgService service = null;
						if ( j <compSize)
						{
							service = (EgService) serviceList.get(j);
							innerServiceJsonObject.put("StateName","state_"+service.getState().getName());
							//EgTopoInfo topoInfo=new EgTopoInfo("manager");

							// <! Starts  end here -------Kaliraj--------- !>

							EgAggregateInfo aggregate1 = new EgAggregateInfo("manager");
							Vector compVec = topoInfo.getAssociatesForSite(service.getName());
							String hrefForSite=service.getName();
							boolean isSite=false;
							boolean isEmulTrans = false;
							LinkedList siteServers = (LinkedList)d.user.getSites();
							for(int p = 0;p<siteServers.size();p++)
							{
								if(service.getName().equals(siteServers.get(p))){
									isSite = true;
									break;
								}
							}
							for(int k=0; k<compVec.size(); k++)
							{
								String comp =(String) compVec.get(k);
								if(comp!=null && comp.indexOf("Emulated")>-1)
								{
									isEmulTrans = true;
								}
							}
							ArrayList aggregateArray1 = aggregate1.getAggregateComponentsOfElement("service",hrefForSite);

							boolean aggregateTab =false;
							if(aggregateArray1 != null && aggregateArray1.size() > 0)
								aggregateTab = true;

							EgList transactionList = new EgList();
							if(isSite)
							{
								EgDbAdapterUI egDb;
								egDb=EgDbAdapterTypeUI.getObject();
								String s_conn = null;
								ResultSet rs=null;
							
								try
								{
									s_conn = egDb.setConnection();
									rs = egDb.SelectEgAddMonTrans(hrefForSite.trim());

									while(rs.next())
									{
										transactionList.add(rs.getString("trans_name") +"~~#~~"+ rs.getString("user_id"));
									}

									rs.close();
								}
								catch(Exception e)
								{
									System.out.println("Exception while adding TransactionList to EgService object : "+e);
								}
								finally
								{
									if(rs!=null)
									{
										rs.close();
										rs=null;
									}
									egDb.releaseConnection(false);
									EgDbAdapterTypeUI.releaseObject(egDb);
								}
							}

							boolean hasTransactions = false;
							boolean hasEmulatedTransactions = false;

							if(transactionList != null && transactionList.size() > 0)
							{
								hasTransactions = true;
							}
							
							String currentTab = "";
							if(isSite && hasTransactions)
								currentTab = "transactions";
							else
								currentTab = "topology";

							//String href =	"/final/monitor/serviceDashboard.jsp?action=service&treeFlag=treeFlag&treeTitle=services&outsideService=true&selectNode=Service^&selectedParam="+hrefForSite+"&topoSegment="+hrefForSite+"&currentTab="+currentTab+"&isSite="+isSite+"&aggregateTab="+aggregateTab+"&hasTransactions="+hasTransactions+"&hasEmulatedTransactions="+isEmulTrans+"&treeOpen=false&openNode=Services&fromPage=serviceTree&fromHomepage=true";
										
							//innerServiceJsonObject.put("URL", "/final/monitor/serviceDashboard.jsp?outsideService=true&titleText=Services&selectNode=Service^"+EgURLEncoder.encode(service.getName(),"UTF-8") + ((isSite)?"(Site)":"") +"&serviceFromZone="+EgURLEncoder.encode(service.getName(),"UTF-8")+"&isEmulTrans="+isEmulTrans);
							String url="/final/monitor/serviceDashboard.jsp?action=service&treeFlag=treeFlag&treeTitle=services&outsideService=true&selectNode=Service^&selectedParam="+EgURLEncoder.encode(hrefForSite,"UTF-8")+"&topoSegment="+EgURLEncoder.encode(hrefForSite,"UTF-8")+"&currentTab="+currentTab+"&isSite="+isSite+"&aggregateTab="+aggregateTab+"&hasTransactions="+hasTransactions+"&isEmulTrans="+isEmulTrans+"&treeOpen=false&openNode=Services&fromPage=serviceTree&isFromZone=true";
							if(!fromHomepage.equalsIgnoreCase("") && fromHomepage!=null && !fromHomepage.equalsIgnoreCase("null") && !fromHomepage.equalsIgnoreCase("undefined"))
								url = url + "&fromHomepage="+fromHomepage;

							// <! Changes end here -------Kaliraj--------- !>


							innerServiceJsonObject.put("URL",url);							
							innerServiceJsonObject.put("Tooltip",(isSite?service.getName()+"(Site)":service.getName()));
							innerServiceJsonObject.put("NameText",(isSite?service.getName()+"(Site)":service.getName()));
						}
						innerServiceJsonArray.add(innerServiceJsonObject);
					}
					inner_service_json_object.put("InnerItems",innerServiceJsonArray);
					
					inner_items_json.add(inner_service_json_object);
				}
				EgList segmentList = zone.getSegmentList();
				int normalSegments=0;
				int abnormalSegments=segmentList.size();
				if(segmentList != null&&segmentList.size()>0&&abnormalSegments>0)
				{
					JSONObject inner_segment_json_object = new JSONObject();
					
					inner_segment_json_object.put("NameText",mappingInfo.getTextDescription("monitor.common.Segments"));
					int count = segmentList.size();
					int goodCount = segmentList.getCount(State.getState("Good"));
					//count = count - goodCount;
					int compSize = count;
					
					JSONArray innerSegmentJsonArray = new JSONArray();
					
					for(j = 0; (j < compSize) && j < count; j++)
					{
						JSONObject innerSegmentJsonObject = new JSONObject();
						
						EgSegment segment = null;
						if ( j <compSize)
						{
							segment = (EgSegment) segmentList.get(j);
							innerSegmentJsonObject.put("StateName","state_"+segment.getState().getName());
							innerSegmentJsonObject.put("URL", "/final/monitor/segmentDashboard.jsp?outsideSegment=true&titleText=segment&selectNode=Segment^"+EgURLEncoder.encode(segment.getName(),"UTF-8")+"&selectedParam="+EgURLEncoder.encode(segment.getName(),"UTF-8")+"&segment="+EgURLEncoder.encode(segment.getName(),"UTF-8")+"&currentTab=topology&segmentFromZone="+EgURLEncoder.encode(segment.getName(),"UTF-8")+"&isFromZone=true&fromHomepage="+fromHomepage);
							innerSegmentJsonObject.put("Tooltip", segment.getName());
							if (segment.getName().length() > compNameLength)
							{
								innerSegmentJsonObject.put("NameText",segment.getName());
							}
							else
							{
								innerSegmentJsonObject.put("NameText",segment.getName());
							}
						}
						innerSegmentJsonArray.add(innerSegmentJsonObject);
					}
					inner_segment_json_object.put("InnerItems",innerSegmentJsonArray);
					
					inner_items_json.add(inner_segment_json_object);
				}

				EgComponentList aggregateList=zone.getAggregateList();
				int normalAggregates=0;
				int abnormalAggregates=aggregateList.size();
				if(aggregateList != null&& aggregateList.size()>0&&abnormalAggregates>0)
				{
					JSONObject inner_aggregate_json_object = new JSONObject();
					
					inner_aggregate_json_object.put("NameText",mappingInfo.getTextDescription("monitor.common.Aggregates"));
					int count = aggregateList.size();
					int compSize = count;
					EgComponent component = null;
					int goodCount = aggregateList.getCount(State.getState("Good"));
					boolean isLayerModel=true;
					if(aggregateInfo.getView().equalsIgnoreCase("dashboard") && EgInstallInfo.isAggregationSupported())
					{
						isLayerModel=false;
					}
					
					JSONArray innerAggregateJsonArray = new JSONArray();
					
					for(int k = 0; (k < compSize && k < r.dispCompCount) && k < count; k++)
					{
						JSONObject innerAggregateJsonObject = new JSONObject();
						if(k < compSize)
						{
							component = (EgComponent) aggregateList.get(k);
						}

						if ( k <compSize)
						{
						//this block for maintanence image
							String serverName = component.getName();
							
							String sid = "";
							String sname = "";
							String portno = "";
							if ( serverName != null && !serverName.equals(""))
							{
								StringTokenizer  tok=new StringTokenizer(serverName,":");    
								int tokens = tok.countTokens();
								sname = tok.nextToken();
								portno = tok.nextToken();
								if ( tokens == 3 )
									sid = tok.nextToken();
							}
							String currdate = dateInfo.egetDate(false);
							boolean  isHostMaintenance=egM.isItMaintenanceTime(currdate,sname,"","",true);
							boolean  isComponentMaintenance=egM.isItMaintenanceTime(currdate,sname,portno,sid,true);
							List  maintenaceTimePeriod=new ArrayList();
							List temp=null;
							if(isHostMaintenance)
							{
								temp=egM.getMaintenancePeriods(sname,"","",true);
								if(temp!=null && temp.size()>0)
									maintenaceTimePeriod.addAll(temp);
								temp=egM.getUnplannedMaintenancePeriods(sname,"","",true);
								if(temp!=null && temp.size()>0)
									maintenaceTimePeriod.addAll(temp);
							}
							if(isComponentMaintenance)
							{
								temp=egM.getMaintenancePeriods(sname,portno,sid,true);
								if(temp!=null && temp.size()>0)
								{
									maintenaceTimePeriod.addAll(temp);
								}
								temp=egM.getUnplannedMaintenancePeriods(sname,portno,sid,true);
								if(temp!=null && temp.size()>0)
									maintenaceTimePeriod.addAll(temp);
							}
							int noOfLines=maintenaceTimePeriod.size();
							String maintenaceTimePeriodStr=maintenanceUtil.convertMaintenacevectorToString(maintenaceTimePeriod,user);
						//maintanence block end here
							if(r.displayCompType)
							{
								innerAggregateJsonObject.put("StateName","state_"+component.getState().getName());
								String displayComponentType = mappingInfo.getComponentTypeDescription(component.getType());
								innerAggregateJsonObject.put("URL", "/final/servlet/com.eg.EgMonitorController?monCmd=componentList&from=TreeMenu&menuName=agg&searchIndComps=true&action=componentType&componentType="+EgURLEncoder.encode(component.getType(),"UTF-8"));
								innerAggregateJsonObject.put("Tooltip", displayComponentType);
								innerAggregateJsonObject.put("NameText",displayComponentType);
							}
							else
							{
								String site="Null";
								
								innerAggregateJsonObject.put("StateName","state_"+component.getState().getName());
								
								if(!isLayerModel)
								{		
									innerAggregateJsonObject.put("URL","../servlet/com.eg.EgDashboardController?from=list&site="+EgURLEncoder.encode(site,"UTF-8")+"&qctr=0&comptype="+EgURLEncoder.encode(component.getType(),"UTF-8")+"&host="+EgURLEncoder.encode(component.getName(),"UTF-8")+"&tab=LayerModel&toDashBoardLayer=true&treeFlag="+treeFlag+"&action=zone");
									innerAggregateJsonObject.put("NameText",component.getDisplayName());
									innerAggregateJsonObject.put("Tooltip",component.getDisplayName());
									if(isHostMaintenance || isComponentMaintenance)
									{
										innerAggregateJsonObject.put("AlertMaintenanceTime",maintenaceTimePeriodStr);
										innerAggregateJsonObject.put("AlertNoOfLines",String.valueOf(noOfLines));
									}
								}
								else
								{
									innerAggregateJsonObject.put("URL","/final/servlet/com.eg.EgDashboardController?from=list&site=NULL&qctr=0&comptype="+EgURLEncoder.encode(component.getType(),"UTF-8")+"&host="+EgURLEncoder.encode(component.getName(),"UTF-8")+"&showDashBoardLink=true&action=zone");
									innerAggregateJsonObject.put("NameText",component.getDisplayName());
									innerAggregateJsonObject.put("Tooltip",component.getDisplayName());
									if(isHostMaintenance || isComponentMaintenance)
									{
										innerAggregateJsonObject.put("AlertMaintenanceTime",maintenaceTimePeriodStr);
										innerAggregateJsonObject.put("AlertNoOfLines",String.valueOf(noOfLines));
									}
								}
							}
						}
						innerAggregateJsonArray.add(innerAggregateJsonObject);
					}
					inner_aggregate_json_object.put("InnerItems",innerAggregateJsonArray);
					
					inner_items_json.add(inner_aggregate_json_object);
				}

					EgComponentList componentList = zone.getComponentList();
					EgComponent component = null;
					int count = componentList.size();
					if(componentList != null && count>0)
					{
						int goodCount = componentList.getCount(State.getState("Good"));
						//count = count - goodCount;
						int compSize = count;
						
						JSONObject inner_component_json_object = new JSONObject();
						inner_component_json_object.put("NameText",mappingInfo.getTextDescription("monitor.common.Components"));

						if(componentList != null)
						{
							JSONArray innerComponentJsonArray = new JSONArray();
							
							for(j = 0; (j < compSize && j < r.dispCompCount); j++)
							{
								JSONObject innerComponentJsonObject = new JSONObject();
								
								EgZone seg = null;
								if ( j <compSize)
								{
									component = (EgComponent) componentList.get(j);
									String site = "NULL";
									//boolean isSite = false;
									//this block for maintanence image
										String serverName = component.getName();
										
										String sid = "";
										String sname = "";
										String portno = "";
										if ( serverName != null && !serverName.equals(""))
										{
											StringTokenizer  tok=new StringTokenizer(serverName,":");    
											int tokens = tok.countTokens();
											sname = tok.nextToken();
											portno = tok.nextToken();
											if ( tokens == 3 )
												sid = tok.nextToken();
										}
										String currdate = dateInfo.egetDate(false);
										boolean  isHostMaintenance=egM.isItMaintenanceTime(currdate,sname,"","",true);
										boolean  isComponentMaintenance=egM.isItMaintenanceTime(currdate,sname,portno,sid,true);
										List  maintenaceTimePeriod=new ArrayList();
										List temp=null;
										if(isHostMaintenance)
										{
											temp=egM.getMaintenancePeriods(sname,"","",true);
											if(temp!=null && temp.size()>0)
												maintenaceTimePeriod.addAll(temp);
											temp=egM.getUnplannedMaintenancePeriods(sname,"","",true);
											if(temp!=null && temp.size()>0)
												maintenaceTimePeriod.addAll(temp);
										}
										if(isComponentMaintenance)
										{
											temp=egM.getMaintenancePeriods(sname,portno,sid,true);
											if(temp!=null && temp.size()>0)
											{
												maintenaceTimePeriod.addAll(temp);
											}
											temp=egM.getUnplannedMaintenancePeriods(sname,portno,sid,true);
											if(temp!=null && temp.size()>0)
												maintenaceTimePeriod.addAll(temp);
										}
										int noOfLines=maintenaceTimePeriod.size();
										String maintenaceTimePeriodStr=maintenanceUtil.convertMaintenacevectorToString(maintenaceTimePeriod,user);
									//maintanence block end here
									if(r.displayCompType)
									{
										innerComponentJsonObject.put("StateName","state_"+component.getState().getName());
										String displayComponentType = mappingInfo.getComponentTypeDescription(component.getType());
										innerComponentJsonObject.put("URL","../servlet/com.eg.EgMonitorController?site="+EgURLEncoder.encode(site,"UTF-8")+"&monCmd=componentList&from=ZoneDashboard&action=componentType&componentType="+EgURLEncoder.encode(component.getType(),"UTF-8")+"&searchIndComps=true&zoneName="+EgURLEncoder.encode(zone.getName(),"UTF-8"));
										innerComponentJsonObject.put("Tooltip",displayComponentType);
										innerComponentJsonObject.put("NameText",displayComponentType);
									}
									else
									{
										innerComponentJsonObject.put("StateName","state_"+component.getState().getName());
										innerComponentJsonObject.put("URL","../servlet/com.eg.EgDashboardController?from=list&site="+EgURLEncoder.encode(site,"UTF-8")+"&qctr=0&comptype="+EgURLEncoder.encode(component.getType(),"UTF-8")+"&host="+EgURLEncoder.encode(component.getName(),"UTF-8")+"&tab=LayerModel&toDashBoardLayer=true&treeFlag="+treeFlag+"&action=zone");
										innerComponentJsonObject.put("Tooltip",component.getDisplayName());
										//innerComponentJsonObject.put("NameText",StringUtils.egSubString(component.getDisplayName(),isUserLanguageEnglish,compNameLength,13));
										innerComponentJsonObject.put("NameText",component.getDisplayName());
										if(isHostMaintenance || isComponentMaintenance)
										{
											innerComponentJsonObject.put("MaintenanceTime",maintenaceTimePeriodStr);
											innerComponentJsonObject.put("NoOfLines",String.valueOf(noOfLines));
										}
									}
								}
								innerComponentJsonArray.add(innerComponentJsonObject);
							}
							inner_component_json_object.put("InnerItems",innerComponentJsonArray);
							
							inner_items_json.add(inner_component_json_object);
						}
					}
					zone_json_object.put("InnerItems", inner_items_json);
						
				zonesJsonArray.add(zone_json_object);
			}
			json.put("RootItem",zonesJsonArray);
		}
		if(normalZoneCount!=0)
		{
			JSONArray zonesNormalJsonArray = new JSONArray();
			
			if(!(d.action.equalsIgnoreCase("zoneState") && !d.state.equals(State.GOOD)))
			{
				json.put("NormalZones",mappingInfo.getTextDescription("monitor.zones.Normal Zones"));
				if (normalZoneCount!=0)
				{
					r.zoneList = r.zoneList.search(State.GOOD);
					int count = r.zoneList.size();

					if (count <= 9)
					{
						count = 9;
					}
					else  if(count % 3 > 0)
					{
						count = count + 3 - count % 3;
					}
					json.put("ShowServiceGood","true");
					int i = 0;
					EgZone zone = null;
					
					for(i = 0; i < r.zoneList.size() || i < count; i++)
					{
						JSONObject zoneNormalJsonObject = new JSONObject();
						
						boolean isSite = false;
						if(i < r.zoneList.size())
						{
							zone = (EgZone) r.zoneList.get(i);
						}
						if ( i <r.zoneList.size())
						{
							if (zone.getName().length() > compNameLength)
							{
								//Onclick handling is to be done on client side 
								zoneNormalJsonObject.put("zoneURL","/final/monitor/EgSiteInfraView.jsp?site="+EgURLEncoder.encode(zone.getName(),"UTF-8")+"&isSite="+isSite+"&service="+EgURLEncoder.encode(zone.getName(),"UTF-8")+"&target=main&fromHomepage="+fromHomepage);
								zoneNormalJsonObject.put("zoneTooltip",zone.getName());
								zoneNormalJsonObject.put("zoneNameText",zone.getName());
							}
							else
							{
								//Onclick handling is to be done on client side
								zoneNormalJsonObject.put("zoneURL","/final/monitor/EgSiteInfraView.jsp?site="+EgURLEncoder.encode(zone.getName(),"UTF-8")+"&service="+EgURLEncoder.encode(zone.getName(),"UTF-8")+"&target=main&fromHomepage="+fromHomepage);
								zoneNormalJsonObject.put("zoneTooltip",zone.getName());
								zoneNormalJsonObject.put("zoneNameText",zone.getName());
							}
						}
						zonesNormalJsonArray.add(zoneNormalJsonObject);
					}
				}
			}
			json.put("normalZonesArray",zonesNormalJsonArray);
		}
	}
	//}
	else
	{
		json.put("NoListFound","true");
		json.put("NoListFoundText",mappingInfo.getTextDescription("monitor.zones.No zones found"));
	}
	json.put("screenLabels",labelJson);
	if ((d!=null) && (!d.equals("")))
	{
	if( d.action!=null && d.action.equalsIgnoreCase("globalsearch") || d.action.equalsIgnoreCase("globalsearchallzone"))
	{
      /*if(request.getQueryString()!=null)
	   {
		  session.setAttribute("globalSearchLastSessionURL","/final/monitor/zoneDash.jsp?"+request.getQueryString());
	   }
	   else
	   {
		 session.setAttribute("globalSearchLastSessionURL","/final/monitor/zoneDash.jsp");
	   }*/
	   if(d.searchString!=null && d.searchString.length()>0)
		{
			session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgMonitorController?monCmd=zoneList&from=zoneList&action=globalsearch&searchString="+d.searchString+"&treeOpen=false&isFromMenu=false&refresh=true");
			
		}
		else
		{
			session.setAttribute("globalSearchLastSessionURL","/final/monitor/zoneDash.jsp");
		}

	}
        else
	{
          if(request.getQueryString()!=null)
	  {
		session.setAttribute("monitorLastSession","/final/monitor/zoneDash.jsp?"+request.getQueryString());
	  }
	  else
	  {
		session.setAttribute("monitorLastSession","/final/monitor/zoneDash.jsp");
	  }
	}
	}
	response.getWriter().write(json.toString());
}
catch(Exception e)
{
	System.out.println("Exception is ZoneDashboard page "+e);
	e.printStackTrace();
}

%>
