<%
/**************************************************************************************************
*	Name			:	zoneMapCoordinate.jsp
*	Purpose			:	Returns the state information of the zones to the map.
*	Version			:	eG 4.0
*	Author			:	N.Gokulanand
*	Creation Date	:	April-17-2007
*	Last Modified	:	July-23-2007		N.Gokulanand	For zone map changes.
***************************************************************************************************/
%>
<%@ include file = "EgMonitorTracker.jsp" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgGroupInfo" %>
<%@ page import = "com.eg.EgStateZone" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.egurkha.ini.IniUI" %>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "com.egurkha.monitor.EgGeoCoordinate" %>
<%@ page import = "com.egurkha.monitor.GeoCoordinateGenerator" %>
<%@ page import = "java.util.ArrayList" %>
<%@ page import = "java.util.StringTokenizer" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="net.sf.json.*"%>

<%
	/** Getting the refresh time for the IniUI file */
	response.setContentType("application/json");
	IniUI ui = (IniUI)com.egurkha.ini.IniUI.getInstance();
	String refreshTime = ui.getRefreshTime("EgDashboard");

	String parentZone = null;
	
	String sessionId = session.getId();
	double minLat = 90;
	double minLng = 180;
	double maxLat = -90;
	double maxLng = -180;
	parentZone = request.getParameter("Zone");
	String allcase = request.getParameter("all");
	IniFile groupIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini");
	String showAllSub = groupIni.getValue("ShowSubZone","ShowSubZoneMap");
	boolean allFlag = false;
	if(allcase != null && allcase.trim().length() > 0 && allcase.equalsIgnoreCase("true"))
		allFlag=true;
	else if((allcase == null || allcase.trim().length()==0) && (showAllSub != null && (showAllSub.equalsIgnoreCase("true") || showAllSub.equalsIgnoreCase("yes"))))
		allFlag=true;
	boolean isSelectedZone = false;
	if(parentZone!=null && !parentZone.equalsIgnoreCase("NULL") && parentZone.trim().length()>0)
		isSelectedZone = true;
	GeoCoordinateGenerator geoCode;
	EgGroupInfo groupInfo = new EgGroupInfo();
	JSONObject json  = new JSONObject();
	List mainZoneList = new LinkedList();
	mainZoneList = u_ser.getZones();

	if(mainZoneList!=null && mainZoneList.size()>0)
	{
		ArrayList tempZones=new ArrayList(mainZoneList);
		for(int i=0;i<tempZones.size();i++)
		{
			String tempZone =(String)tempZones.get(i);
			if(tempZone!=null && tempZone.trim().length()>0)
			{
				ArrayList subZones=(ArrayList)groupInfo.getSubZoneList(tempZone,false);

				if(subZones!=null && subZones.size()>0)
				{
					mainZoneList.addAll(subZones);
				}
			}
		}
		mainZoneList=ListUtils.removeDuplicates(mainZoneList);
	}
	/** To consider only the subzones under the zone */
	if(parentZone != null && !parentZone.equals(""))
	{
		geoCode = new GeoCoordinateGenerator(sessionId, parentZone);
%>

<%
	}
	else
	{
		/** To consider all zones under a User */
		geoCode = new GeoCoordinateGenerator(sessionId);
	}
	
	//IniFile groupIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini");
	ArrayList zoneDetails = geoCode.getZoneDetails();
	String[] noSubZone = groupIni.getVariables("LIST_OF_ZONES");
	ArrayList zonelist = new ArrayList();
	if(noSubZone!=null && noSubZone.length>0)
	{
		for(int p=0;p<noSubZone.length;p++)
		{
			if(noSubZone[p]!=null && noSubZone[p].trim().length()>0 && mainZoneList.contains(noSubZone[p]))
			{
				zonelist.add(noSubZone[p]);
			}
		}
	}

	ArrayList latitudeArray = new ArrayList();
	ArrayList longitudeArray = new ArrayList();
	
	JSONArray  zoneArray = new JSONArray();
	JSONArray  stateArray = new JSONArray();
	JSONArray  jsonLatitudeArray = new JSONArray();
	JSONArray  jsonLongitudeArray = new JSONArray();
	JSONArray  subZoneMapCount = new JSONArray();
	JSONArray  subZoneListCount = new JSONArray();
	JSONArray  southWestGeoCode = new JSONArray();
	JSONArray  northEastGeoCode = new JSONArray();
	JSONArray  centerGeoCode = new JSONArray();
		
	for(int i=0;i<zoneDetails.size();i++)
	{
		EgGeoCoordinate res = (EgGeoCoordinate) zoneDetails.get(i);
		zonelist.remove(res.zoneName);
		ArrayList subZoneList =groupInfo.getDirectSubZoneList(res.zoneName, false);
		int numberOfSubZones = 0;
		if(subZoneList != null && subZoneList.size() > 0)
		{
			for(int k=0;k<subZoneList.size();k++)
			{
				StringTokenizer st = new StringTokenizer(groupIni.getValue("ZONE_LOCATION", (String)subZoneList.get(k)), "|");
				int switchCount = 0;
				boolean latitudeExsist = false;
				boolean longitudeExsist = false;

				/** To collect the zone Coordinates (latitude, longitude) */
				while (st.hasMoreTokens())
				{
					String currentToken = st.nextToken();
					switch(switchCount)
					{
						case 0:
							if(!currentToken.equals("null"))
							{
								latitudeExsist = true;
							}
						break;
						case 1:
							if(!currentToken.equals("null"))
							{
								longitudeExsist = true;
							}
						break;
					}
					if(latitudeExsist && longitudeExsist)
					{
						numberOfSubZones++;
					}
					switchCount++;
				}
			}
		}
		String state = EgStateZone.getState("Zone:"+res.zoneName+":NULL");
		latitudeArray.add(String.valueOf(res.latitude));
		longitudeArray.add(String.valueOf(res.longitude));
		
		zoneArray.add(res.zoneName);
		stateArray.add(state);
		jsonLatitudeArray.add(res.latitude);
		jsonLongitudeArray.add(res.longitude);
		subZoneMapCount.add(numberOfSubZones);
		subZoneListCount.add(subZoneList.size());
%>

<%
	}
	if(zonelist != null && zonelist.size() > 0 && allFlag && !isSelectedZone){
		for(int p=0;p<zonelist.size();p++){
			String zZoneName = (String)zonelist.get(p);
			if(zZoneName == null || zZoneName.trim().length() == 0)
				continue;

			ArrayList subZoneList =groupInfo.getDirectSubZoneList(zZoneName, false);
			int numberOfSubZones = 0;
			if(subZoneList != null && subZoneList.size() > 0)
			{
				for(int k=0;k<subZoneList.size();k++)
				{
					StringTokenizer st = new StringTokenizer(groupIni.getValue("ZONE_LOCATION", (String)subZoneList.get(k)), "|");
					int switchCount = 0;
					boolean latitudeExsist = false;
					boolean longitudeExsist = false;

					/** To collect the zone Coordinates (latitude, longitude) */
					while (st.hasMoreTokens())
					{
						String currentToken = st.nextToken();
						switch(switchCount)
						{
							case 0:
								if(!currentToken.equals("null"))
								{
									latitudeExsist = true;
								}
							break;
							case 1:
								if(!currentToken.equals("null"))
								{
									longitudeExsist = true;
								}
							break;
						}
						if(latitudeExsist && longitudeExsist )
						{
							numberOfSubZones++;
						}
						switchCount++;
					}
				}
			}

			String state = EgStateZone.getState("Zone:"+zZoneName+":NULL");
			String zoneLatlang = groupIni.getValue("ZONE_LOCATION",zZoneName);
			String lat="";
			String lang="";
			
			if( zoneLatlang.trim().equalsIgnoreCase("null|null") )
				continue;

			if(zoneLatlang != null && zoneLatlang.indexOf("|") != -1){
				lat = zoneLatlang.substring(0,zoneLatlang.indexOf("|"));
				lang = zoneLatlang.substring(zoneLatlang.indexOf("|")+1);
				latitudeArray.add(String.valueOf(lat.trim()));
				longitudeArray.add(String.valueOf(lang.trim()));
			}

			zoneArray.add(zZoneName);
			stateArray.add(state);
			jsonLatitudeArray.add(lat);
			jsonLongitudeArray.add(lang);
			subZoneMapCount.add(0);
			subZoneListCount.add(0);
		}
	}
	json.put("zoneArray",zoneArray);
	json.put("stateArray",stateArray);
	json.put("latitudeArray",jsonLatitudeArray);
	json.put("longitudeArray",jsonLongitudeArray);
	json.put("subZoneMapCount",subZoneMapCount);
	json.put("subZoneListCount",subZoneListCount);

	/** To calculate minimun and maximum coordinate of tha map area to be displayed */
	if(latitudeArray.size() != 0 && longitudeArray.size() != 0)
	{
		for (int i=0;i<latitudeArray.size();i++)
		{
			double miniLat = Double.parseDouble((String)latitudeArray.get(i));
			if(miniLat < minLat)
			{				
				minLat = miniLat;
			}
			double maxiLat = Double.parseDouble((String)latitudeArray.get(i));
			if(maxiLat > maxLat)
			{				
				maxLat = maxiLat;
			}		
		}
		for (int i=0;i<longitudeArray.size();i++)
		{
			double miniLng = Double.parseDouble((String)longitudeArray.get(i));
			if(miniLng < minLng)
			{				
				minLng = miniLng;
			}
			double maxiLng = Double.parseDouble((String)longitudeArray.get(i));
			if(maxiLng > maxLng)
			{
				maxLng = maxiLng;
			}
		}
		minLat = (minLat-1);
		minLng = (minLng-1);
		maxLat = (maxLat+1);
		maxLng = (maxLng+1);

		/** To calculate the Center coordinate of tha map area to be displayed */
		double avgLat = (((maxLat-minLat)/2)+minLat);
		double avgLng = (((maxLng-minLng)/2)+minLng);
		
		southWestGeoCode.add(minLat);
		southWestGeoCode.add(minLng);
		northEastGeoCode.add(maxLat);
		northEastGeoCode.add(maxLng);
		centerGeoCode.add(avgLat);
		centerGeoCode.add(avgLng);
		
		json.put("southWestGeoCode",southWestGeoCode);
		json.put("northEastGeoCode",northEastGeoCode);
		json.put("centerGeoCode",centerGeoCode);
	}
	try{
		response.getWriter().write(json.toString());
	}
	catch(Exception zoneMapException)
	{
		System.out.println("Exception in zoneMap..");
		zoneMapException.printStackTrace();
	}

%>
