<!DOCTYPE html>
<%
/***************************************************************************************************
*	Name			:	zoneMap.jsp
*	Purpose			:	To Display the Zones in the Map
*	Version			:	eG 4.0
*	Author			:	N.Gokulanand
*	Creation Date	:	April-17-2007
*	Last Modified	:	July-13-2007		N.Gokulanand.
***************************************************************************************************/
%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ include file="EgLoginTracker.jsp"%>
<%@ page
	errorPage="EgMonitorMapError.jsp?s_message=Sorry could not connect map"%>
<%@ page import="com.eg.IniFile"%>
<%@ page import="com.eg.EgGroupInfo"%>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import="com.eg.EgManagersIniForManager"%>
<%@ page import="com.egurkha.monitor.*"%>
<%@ page import="com.egurkha.UserRegistry"%>
<%@ page import="com.egurkha.User"%>
<%@ page import="java.util.*"%>
<%@ page import="com.egurkha.ini.IniUI"%>

<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	boolean zonesAvailable = false;
	boolean coordinateAvailable = false;
	//modified on  13/11/07stalin 
	String mapLiceLink = null;
	
	//added for zone mapping 7/6/2009
	IniUI ui = (IniUI)com.egurkha.ini.IniUI.getInstance();
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	String thisLanguage = ui.getDefaultLanguage();
	if (user!=null)
	{
		String userLang = user.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}
	String uiFile = "eg_ui.ini";
	String ui_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile uiIniFile = new IniFile(ui_iniFile_dir + uiFile);
	String thisMapLanguage=uiIniFile.getValue("Map_Country_Code",thisLanguage);
	EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	String subZone = request.getParameter("Zone");
	subZone=(subZone==null) ?"noParam":subZone;
	String treeOpen=request.getParameter("treeOpen");
	String selectedTreeNode = request.getParameter("selected");
	String refresh=request.getParameter("refresh");
	boolean isFromMenu = "true".equals(request.getParameter("isFromMenu"))?true:false;
	
	if(thisMapLanguage==null)
		thisMapLanguage="en";
	
	String loginType = user.getLoginType();
	String backButtonText=mappingInfo.getTextDescription("monitor.zoneDashboard.Back");
	String treeSession=(String)session.getAttribute("monitorLastSession");
	String refFrequency = u_ser.getRefreshFrequency();
	long refreshFrequency=60000L;
	if(refFrequency!=null && refFrequency.length()>0)
	{
		refreshFrequency =  Long.valueOf(refFrequency).longValue() * 1000L;
	}
	
	/** Getting the User Zones */
	List mainZoneList = new LinkedList();
	mainZoneList = user.getZones();

	IniFile topoIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini");
	String showSubZone = topoIni.getValue("ShowSubZone","ShowSubZoneMap");
	boolean showSubZoneFlag = false;
	if(showSubZone != null && (showSubZone.equalsIgnoreCase("true") || showSubZone.equalsIgnoreCase("yes")))
		showSubZoneFlag = true;

	/** Checks for the Location Coordinate Availablity */
	if(mainZoneList.size() > 0)
	{
		zonesAvailable = true;
		for(int i=0;i<mainZoneList.size();i++)
		{
			StringTokenizer st = new StringTokenizer(topoIni.getValue("ZONE_LOCATION", (String)mainZoneList.get(i)), "|");
			int switchCount = 0;
			boolean latitudeExsist = false;
			boolean longitudeExsist = false;
			while (st.hasMoreTokens())
			{

				/** To select the zone coordinates */
				String currentToken = st.nextToken();
				switch(switchCount)
				{
					case 0:
						if(!currentToken.equals("null"))
						{
							latitudeExsist = true;
						}
					break;
					case 1:
						if(!currentToken.equals("null"))
						{
							longitudeExsist = true;
						}
					break;
				}
				switchCount++;
			}
			if(latitudeExsist && longitudeExsist)
			{
				coordinateAvailable = true;
			}
		}
	}
	else
	{
		zonesAvailable = false;
		coordinateAvailable = false;
	}
	
	%>
	<script> 
	var InvalidMapKeyErorMessage = null;
	var titleParentZone = "";
	var showSubZone = <%=showSubZoneFlag%>;
	
	var requestParams=new Object();
	var hideBackButton = "";
	var params = "";
	var refreshFrequency = "";
	var NoData = "";
	</script>
	<%
	if(coordinateAvailable)
	{
		try
		{
			/** Getting the Google Maps API Key registered for this site or domain */
			IniFile iniUiObj = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
			String myServerName = request.getScheme() + "://" +request.getServerName();
			String myPort = ""+request.getServerPort();
			String myScheme = request.getScheme();
			if (myScheme.equals("http") && !myPort.equals("80"))
				myServerName += ":"+myPort;
			else if (myScheme.equals("https") && !myPort.equals("443"))
				myServerName += ":"+myPort;
			String google_map_key = iniUiObj.getValue("ZONE_MAP",myServerName);
			if(google_map_key == null || google_map_key.equals("") || google_map_key.equalsIgnoreCase("None"))
			{
				myServerName = myServerName+ "/";
				google_map_key = iniUiObj.getValue("ZONE_MAP",myServerName);
				if(google_map_key == null || google_map_key.equals("") || google_map_key.equalsIgnoreCase("None"))
				{
						google_map_key = iniUiObj.getValue("ZONE_MAP","google_map_key");
				}
			}
			if(google_map_key==null || google_map_key.equals("") || google_map_key.equalsIgnoreCase("None"))
			{
%>

<script>
			var user = '<%=loginType%>';
			 InvalidMapKeyErorMessage="EgMonitorMapError.jsp?s_message=Map key invalid (or) not found&signup=true&user="+user;
</script>
<%
			}
			else
			{
				google_map_key = google_map_key.trim();
%>
<%
			}
			String parentZone = request.getParameter("Zone");

			/** Getting the subzones for given zone*/
			EgGroupInfo  groupInfo = new EgGroupInfo();
			ArrayList ZoneList =groupInfo.getDirectSubZoneList(parentZone, true);
			
%>
<script type="text/javascript" src="/final/monitor/eg_scripts/dtree.js"></script>
<script type="text/javascript">
var map = null;
var icon = null;
var baseIcon = null;
var subZones = "SubZone List";
var subZonesmap ="SubZone Map";
var errorMsg = "noError";
var sw;
var ne;
var bounds;
var maxZoom = 11;
var zoomLevel;
var zoomEnd = 0;
var move = 0;
var zoom = 0;
var divHeight;
var divWidth;
var lat =0;
var lng =0;
var popupDivId = "zoneId";

var offsetfromcursorX=12 //Customize x offset of tooltip
var offsetfromcursorY=10 //Customize y offset of tooltip

var offsetdivfrompointerX=10 //Customize x offset of tooltip DIV relative to pointer image
var offsetdivfrompointerY=14 //Customize y offset of tooltip DIV relative to pointer image. Tip: Set it to

document.write('<div id="dhtmltooltip" style="font-size:10pt; font-weight:bold"></div>');
document.write('<img id="dhtmlpointer" src="/final/monitor/eg_images/arrow_forward_black.gif" width="0" height="0" visible="false">') //write out pointer image

var ie=document.all;
var ns6=document.getElementById && !document.all;
var enabletip=false;

var tipobj=document.all? document.all["dhtmltooltip"] : document.getElementById? document.getElementById("dhtmltooltip") : "" ;
var pointerobj=document.all? document.all["dhtmlpointer"] : document.getElementById? document.getElementById("dhtmlpointer") : "";


requestParams.selectedTreeNode="<%=selectedTreeNode%>";
requestParams.treeOpen="<%=treeOpen%>";
if("<%=refresh%>"=="true"){
	requestParams.refresh=true;
}
else{
	requestParams.refresh=false;
}
		
function ietruebody()
{
	return (document.compatMode && document.compatMode!="BackCompat") ? document.documentElement : document.body;
}

var parentZone = null;

if('<%=parentZone%>' != 'null' && '<%=parentZone%>' != null && '<%=parentZone%>' != 'undefined' && '<%=parentZone%>' != undefined && '<%=parentZone%>' != '')
	parentZone = '<%=parentZone%>';


refreshFrequency=<%=refreshFrequency%>;
requestParams.backButtonText="<%=backButtonText%>";
requestParams.treeSession="<%=treeSession%>";
params ='<%=subZone%>';
var treeOpen="<%=treeOpen%>";
hideBackButton = <%=isFromMenu%>;
var subMapCheckHide=false;
if(hideBackButton == true || hideBackButton == 'true')
	subMapCheckHide = false;
else
	subMapCheckHide = true;

if(parentZone != "null" && parentZone != null){
	 titleParentZone = " : "+ parentZone;
}

function loadPopup(qUrl)
{	
	if(!Ext.isEmpty(qUrl))
	{
		var tmpUrl = qUrl.substring(qUrl.indexOf("?")+1);
		tmpUrl = "componentMeasureTabSet.jsp?"+tmpUrl;
		//window.open(tmpUrl,'GRAPHS','toolbar=no,menubar=no,location=no,status=no,width=1014,height=603,left=0,top=80,screenx=0,screeny=0,resizable=yes,scrollbars=yes');
		parent.openWindow(tmpUrl,'GRAPHS','toolbar=no,menubar=no,location=no,status=no,width=1014,height=603,left=0,top=80,screenx=0,screeny=0,resizable=yes,scrollbars=yes');
	}
}

</script>
<html class="content-frame">
<head>
<meta charset="utf-8" http-equiv="X-UA-Compatible" content="IE=8,9,10" >
<egui:skin ui="monitor"/>

<egui:loadApp baseDir="/final/monitor/eg_scripts" appName="zonesMap" appFile="zonesMap.js"/>

<link rel="stylesheet" type="text/css" href="../styles/jscrollpane/jquery.jscrollpane.css" media="all"/>

<script language="JavaScript1.2" src="/final/jquery/jquery.min.js"></script>
<script type="text/javascript" src="../styles/jscrollpane/jquery.mousewheel.js"></script>
<script type="text/javascript" src="../styles/jscrollpane/mwheelIntent.js"></script>
<script type="text/javascript" src="../styles/jscrollpane/jquery.jscrollpane.js"></script>
<script	src="//maps.google.com/maps?file=api&amp;v=2&amp;hl=<%=thisMapLanguage%>&amp;key=<%=google_map_key%>"	type="text/javascript"></script>

<!-- 

<script src="../scripts/utilities/ScrollableUtils.js"></script>
<script src="../scripts/utilities/ScrollPanel.js"></script>
<script src="../scripts/utilities/ScrollableTreePanel.js"></script>
<script src="../scripts/utilities/CustomGrid.js"></script>
<script src="../scripts/utilities/StatefulTreePanel.js"></script>

<script src="/final/scripts/utilities/OuterPanel.js"></script>
<script src="/final/scripts/utilities/CustomGrid.js"></script>
<script src="/final/scripts/utilities/EmptyPanel.js"></script>


 		<script src="../scripts/utilities/ErrorPanel.js"></script>
		<script src="/final/scripts/utilities/OuterPanel.js"></script>
		<script src="../scripts/utilities/CustomGrid.js"></script>
-->

<script language="JavaScript1.2">
function parseScript(_source)
{
	var source = _source;
	var scripts = new Array();
	
	// Strip out tags
	while(source.indexOf("<script") > -1 || source.indexOf("</script") > -1) {

		var s = source.indexOf("<script");
		var s_e = source.indexOf(">", s);
		var e = source.indexOf("</script", s);
		var e_e = source.indexOf(">", e);			
		// Add to scripts array
		scripts.push(source.substring(s_e+1, e));
		// Strip from source
		source = source.substring(0, s) + source.substring(e_e+1);
	}
	// Loop through every script collected and eval it
	for(var i=0; i<scripts.length; i++) {
		try {
			eval(scripts[i]);
		}
		catch(ex) {
			return;
		}
	}
	// Return the cleaned source
	return source;
}
Ext.onReady(function(){
	 Ext.Ajax.on('requestexception', function (conn, response, options) {
		var errorStr = response.responseText;
		parseScript(errorStr);
		if (errorStr != undefined && errorStr != 'undefined' && errorStr.indexOf("customerror") != -1)
		{
			if (errorStr.indexOf("user-session-invalid") != -1)
			{
				callWindow(1);
			}
			else if (errorStr.indexOf("user-deleted") != -1)
			{
				callWindow(2);
			}
			else if (errorStr.indexOf("user-timedout") != -1)
			{
				callWindow(3);
			}
		}
	});
	initLdgMask = new Ext.LoadMask(Ext.getBody(),{msg : "Loading ..."});
});
</script>

</head>
<body class="">
<div id ="zonemap" style="position:absolute;top:0px;height: 100%; width: 100%;">
<div class="maskLoader" style="font-weight: bold; font-size: 16px; top: 47.2%; left: 45.8%;">
<!-- <div class="maskText">Loading...</div> -->
</div>
</div>
</body>
</html>
<%
	//checking zone tree
	String treeOnload = iniUiObj.getValue("ZONE_MAP","zoneMapTree");
	String appendOnload = "";
	//String display = "none";
	if(treeOnload != null && !treeOnload.equalsIgnoreCase("yes"))
	{
		//display = "block";
		appendOnload = ",closeTree()";
	}
%>
<%
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}
	else
	{
	%>
		<script>
		var errUrl = "";
		NoData = "NoData";
		refreshFrequency=<%=refreshFrequency%>;
		</script>
	<%
		if(zonesAvailable)//modified on 14/11/07 stalin
		{
			String errUrl = "EgMonitorMapError.jsp?s_message=Zones are not configured with location details.&mapLiceLink="+mapLiceLink;
	%>
	<script>
	 errUrl = '<%=errUrl%>';
	</script>
	<%
		}
		else
		{
	%>
		<script>
		errUrl = "EgMonitorMapError.jsp?s_message=No zones found";
		</script>
<%
	}
%>
		<html xmlns="http://www.w3.org/1999/xhtml" >
		<head>
		<meta http-equiv="content-type" content="text/html; charset=utf-8" />
		<egui:skin ui="monitor"/>
		<!-- ** EXTJS ** -->
		<egui:loadApp baseDir="/final/monitor/eg_scripts" appName="zonesMap" appFile="zonesMap.js"/>
		<script src="../extjs/ext-all.js"></script>
		
		<link rel="stylesheet" type="text/css" href="../styles/jscrollpane/jquery.jscrollpane.css" media="all"/>
		<link rel="stylesheet" type="text/css" href="../monitor/eg_styles/zonesMap.css" />


		<!-- <link rel="stylesheet" type="text/css" href="../extjs/css/ext-all.css" />
		<link rel="stylesheet" type="text/css" href="../monitor/eg_styles/common.css" />
		<link rel="stylesheet" type="text/css" href="../monitor/eg_styles/zones.css" />
		<script src="../scripts/utilities/ZonesMapError.js"></script> -->

		</head>
		</html>

<%
	}
	if(request.getQueryString()!=null)
	{
		session.setAttribute("monitorLastSession","/final/monitor/zoneMap.jsp?"+request.getQueryString());
	}
	else{
		session.setAttribute("monitorLastSession","/final/monitor/zoneMap.jsp");
	}
%>
