<%@ include file = "EgMonitorTracker.jsp" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %> 
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="java.util.*"%>
<%@ page import="com.egurkha.*"%>
<%@ page import="com.egurkha.ini.*" %>
<%@ page import="com.egurkha.util.*" %>
<%@ page import="com.egurkha.monitor.ZoneDashboardData"%>
<%@ page import="com.egurkha.monitor.ZoneDashboardResult"%>
<%@ page import="net.sf.json.*"%>
<%@ page import = "com.eg.EgMappingInfo"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

	ZoneDashboardData d = (ZoneDashboardData) session.getAttribute("zoneDashboardData");
	ZoneDashboardResult r = (ZoneDashboardResult) session.getAttribute("zoneDashboardResult");
	
	IniUI ui = (IniUI)IniUI.getInstance();
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	
	String thisLanguage = ui.getDefaultLanguage();
	if (user!=null)
	{
		String userLang = user.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}
	
	//EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	
	JSONObject json  = new JSONObject();
	JSONArray  summaryArray = new JSONArray();

	request.setAttribute("jsonObject",json);
	request.setAttribute("category","zone");
	request.setAttribute("itemName",d.zoneName);

	%>
		<%@ include file="aggregateTabHandler.jsp" %>
	<%
	
	JSONObject  summaryObj = new JSONObject();
	summaryObj.put("text",mappingInfo.getTextDescription("monitor.zonehome.Total Measurements"));
	summaryObj.put("value",String.valueOf(r.measureCount));
	summaryObj.put("iconCss","summaryTotalMeasurements");
	summaryArray.add(summaryObj);
	
	summaryObj = new JSONObject();
	summaryObj.put("text",mappingInfo.getTextDescription("monitor.zonehome.Total Components"));
	summaryObj.put("value",String.valueOf(r.totalComponents));
	summaryObj.put("iconCss","summaryTotalComponents");
	summaryArray.add(summaryObj);
	
	summaryObj = new JSONObject();
	summaryObj.put("text",mappingInfo.getTextDescription("monitor.zonehome.Open Problems"));
	summaryObj.put("value",String.valueOf(r.alarmCount));
	summaryObj.put("iconCss","summaryOpenProblems");
	summaryObj.put("alarmsLink","/final/monitor/EgAlarms.jsp?fromPage=zoneDashboard&zoneName="+r.zoneName);
	summaryArray.add(summaryObj);
	
if((r.maximumDuration != null && r.maximumDuration.length() >0) && (r.averageDuration != null && r.averageDuration.length()>0))
{
	summaryObj = new JSONObject();
	summaryObj.put("text",mappingInfo.getTextDescription("monitor.zonehome.Average Duration"));
	summaryObj.put("value",r.averageDuration);
	summaryObj.put("iconCss","summaryAverageDuration");
	summaryArray.add(summaryObj);
	
	summaryObj = new JSONObject();
	summaryObj.put("text",mappingInfo.getTextDescription("monitor.zonehome.Maximum Duration"));
	summaryObj.put("value",r.maximumDuration);
	summaryObj.put("iconCss","summaryMaximumDuration");
	summaryObj.put("alarmsLink","/final/monitor/EgAlarms.jsp?alarmType=longestAlarms&fromPage=zoneDashboard&zoneName="+r.zoneName+"&maxDurationAlarmIds="+r.maxDurationAlarmIDs);
	summaryArray.add(summaryObj);
}
else
{
	summaryObj = new JSONObject();
	summaryObj.put("text",mappingInfo.getTextDescription("monitor.zonehome.Average Duration"));
	summaryObj.put("value","0");
	summaryObj.put("iconCss","summaryAverageDuration");
	summaryArray.add(summaryObj);
	
	summaryObj = new JSONObject();
	summaryObj.put("text",mappingInfo.getTextDescription("monitor.zonehome.Maximum Duration"));
	summaryObj.put("value","0");
	summaryObj.put("iconCss","summaryMaximumDuration");
	summaryObj.put("alarmsLink","/final/monitor/EgAlarms.jsp?alarmType=longestAlarms&fromPage=zoneDashboard&maxDurationAlarmIds=&zoneName="+r.zoneName);
	summaryArray.add(summaryObj);
} 

	json.put("summaryArray",summaryArray);
	
	response.getWriter().write(json.toString());
%>