<%
/********************************************************************************************************
*	Name			:	transactions.jsp
*	Purpose			:	This is used to display website Transactions and emulated transactions
*	Version			:	5.4
*	CreationDate	:	nov 29 2011
*******************************************************************************************************/
%>
<%@ include file = "EgMonitorTracker.jsp" %>
		
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.egurkha.util.DateUtil" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import = "com.eg.*" %>
<%@ page import = "egurkha.EgDbAdapterUI"%>
<%@ page import = "java.sql.*" %>
<%@ page import = "com.eg.EgDbAdapterTypeUI"%>
<%@ page import = "com.egurkha.monitor.alarms.AlarmPriorities" %>
<%@ page import = "com.eg.EgTopoInfo"%>
<%@ page import = "java.util.*" %>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "com.egurkha.ini.*" %>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.EgGroupInfo" %>
<%@ page errorPage = "EgProbsM.jsp"%>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import = "java.text.SimpleDateFormat"%>
<%@ page import = "com.egurkha.util.EgSorter"%>
<%@ page import ="com.eg.EgTablesInfo" %>
<%@ page import ="com.eg.EgDiscInfo" %>
<%@ page import = "com.egurkha.util.StringUtils"%>

<%@ page import="net.sf.json.*"%>
<%@ page import = "com.egurkha.User"%>
<%@ page import="egurkha.reporter.ErUtils"%>
<%@ page import="com.egurkha.*" %>
<%@ page import="com.egurkha.EgTimeZoneConverter" %>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "com.eg.supermanager.*"%>


<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");
	request.setCharacterEncoding("UTF-8");
try
{
	if(com.eg.EgInstallInfo.isSuperManager)
	{
		String currentSession = session.getId();
		String service = request.getParameter("service");
		//System.out.println("egDashboardDispCompMeasures.jsp hostname " + hostname);
		if(service != null && (service=service.trim()).length()>0)
		{
			//System.out.println("egDashboardDispCompMeasures.jsp host " + hostname);
			ArrayList managerIds = EgElementInfo.getInstance().getManagerIDs("service",service);
			//System.out.println("egDashboardDispCompMeasures.jsp managerIds " + managerIds);
			if(managerIds != null && !managerIds.isEmpty())
			{
				SmSessionData smsData = new SmSessionData(currentSession,managerIds);
				EgThreadLocal egtl = new EgThreadLocal();
				egtl.set(smsData);
			}
		}
	}

	AlarmPriorities ap = AlarmPriorities.getInstance();
	EgTopoInfo topoinfo = new EgTopoInfo("manager");	//removal of physical topology
	EgDbInfo dbInfo = new EgDbInfo("manager");
	EgConfigInfo configInfo = new EgConfigInfo(EgConstants.MANAGER);
	EgTablesInfo tablesInfo = new EgTablesInfo("manager");
	EgDiscInfo discInfo = new EgDiscInfo("manager");
	EgExternalInfo externalInfo=new EgExternalInfo("manager");
	IniUI ui = (IniUI)com.egurkha.ini.IniUI.getInstance();
	String ua = request.getHeader( "User-Agent" );
	boolean isFirefox3 = ( ua != null && ua.indexOf( "Firefox/3" ) != -1 );
	boolean isFirefox2 = ( ua != null && ua.indexOf( "Firefox/2" ) != -1 );
	
	UserRegistry ur = UserRegistry.getInstance();
	String sessionID = session.getId();
	//User u_ser = ur.getUser(sessionID);
	User user = u_ser;
	String loginid = user.getLoginID();
	boolean isUserLanguageEnglish=true;
	String thisLanguage = ui.getDefaultLanguage();
	if (user!=null)
	{
		String userLang = user.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
		if(thisLanguage!=null && !thisLanguage.equals("en_US"))
		{
			isUserLanguageEnglish=false;
		}
	}

	EgGroupInfo groupinfo = new EgGroupInfo();

	String refFreq = u_ser.getRefreshFrequency();
	//String monitor_Skin  = u_ser.getMonitorSkin();
	long refreshFrequency = 1L;
	if(refFreq!=null && refFreq.length()>0)
	{
		refreshFrequency =  Long.valueOf(refFreq).longValue() * 1000L;
	}

	String siteName = request.getParameter("site");
	String siteName1 = request.getParameter("site");

	String Refreshing = request.getParameter("Refreshing");
	String innerActiveTab = request.getParameter("innerActiveTab");
	boolean isWebTrans = false;
	boolean isEmulTrans = false;
	boolean isLogonSimul = false;
	Vector componentList = topoinfo.getAssociatesForSite(siteName);
	Vector logonComponents = new Vector();
	ArrayList siteServers = discInfo.getSiteServers();
	if(componentList != null && componentList.size() > 0)
	{
		for(int i=0;i<componentList.size();i++){
			String val = (String) componentList.get(i);
			if(val!=null && val.length() > 0)
			{
				if(val.indexOf("Citrix_XcLogon_Emulation") > -1){
					logonComponents.add(val.substring(val.indexOf(":")+1,val.length()));
					isLogonSimul = true;
				}
				else if(val.indexOf("Emulated") > -1){
					isEmulTrans = true;
				}
				else{
					String ctype = val.substring(0,val.indexOf(":"));
					if(siteServers != null && siteServers.size() > 0 && ctype!=null && siteServers.contains(ctype))
						isWebTrans = true;
				}
			}
		}
	}

	boolean isFromLogonTab = false;
	String fromLogonTab = request.getParameter("fromLogonTab");
	if(fromLogonTab != null && fromLogonTab.trim().length() > 0 && (fromLogonTab.equalsIgnoreCase("true") || fromLogonTab.equalsIgnoreCase("yes")))
		isFromLogonTab = true;

	
	String serviceRefSortByLogon=request.getParameter("serviceRefSortByLogon");
	serviceRefSortByLogon=(serviceRefSortByLogon==null || serviceRefSortByLogon.trim().length()==0)?"":serviceRefSortByLogon;

	String serviceRefSortByLogonType=request.getParameter("serviceRefSortByLogonType");
	serviceRefSortByLogonType=(serviceRefSortByLogonType==null || serviceRefSortByLogonType.trim().length()==0)?"":serviceRefSortByLogonType;

	String serviceRefSortByLogonId=request.getParameter("serviceRefSortByLogonId");
	serviceRefSortByLogonId=(serviceRefSortByLogonId==null || serviceRefSortByLogonId.trim().length()==0)?"":serviceRefSortByLogonId;


	JSONObject json = new JSONObject();
	JSONObject hiddenFields = new JSONObject();
	JSONObject screenLabels = new JSONObject();

	JSONObject graphLabels = new JSONObject();
	graphLabels.put("GraphHeader",mappingInfo.getTextDescription("monitor.Common.Graphs"));

	hiddenFields.put("isLogonSimul",String.valueOf(isLogonSimul));
	if(Refreshing != null && Refreshing.trim().length() > 0)
	{
		hiddenFields.put("Refreshing",Refreshing);
		hiddenFields.put("innerActiveTab",innerActiveTab);
	}

	hiddenFields.put("serviceRefSortByLogon",serviceRefSortByLogon);
	hiddenFields.put("serviceRefSortByLogonType",serviceRefSortByLogonType);
	hiddenFields.put("serviceRefSortByLogonId",serviceRefSortByLogonId);

	if((isFromLogonTab && isLogonSimul) || isLogonSimul)
	{
		com.eg.IniFile externalIni = new com.eg.IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_external.ini", false);
		String externalAgents[]=externalIni.getVariables("Emulation_by_external_agents");
		ArrayList userViseExtAgent = new ArrayList();

		List usr_server=user.getServers(false);
		if(usr_server != null && usr_server.size() > 0){
			for(int p=0;p<usr_server.size();p++){
				String el = (String)usr_server.get(p);
				StringTokenizer st_server = new StringTokenizer(el,":");
				String type = "";
				String comp = "";
				String port = "";
				String sid = "";
				String toAdd = "";
				int cntTokens = st_server.countTokens();
				if(st_server.hasMoreTokens())
				{
					type = st_server.nextToken();
					comp = st_server.nextToken();
					port = st_server.nextToken();
					if(cntTokens == 4)
						sid = st_server.nextToken();

					if(type != null && type.equalsIgnoreCase("Citrix_XcLogon_Emulation")){
						String extUser = externalIni.getValue("Test_Mapping_Section",comp);
						ArrayList al_cols_extAgent = com.egurkha.util.StringUtils.egTokenizer(extUser, ",",true,false,true);//3-->includeEmpty,4-->unique,5-->trim
						if(al_cols_extAgent != null && al_cols_extAgent.size() > 0)
						{
							for(int h=0;h<al_cols_extAgent.size();h++)
								userViseExtAgent.add((String)al_cols_extAgent.get(h));
						}
						
					}
				}
			}
		}

		JSONObject agentObj = new JSONObject();
		JSONObject extAgentOptions = new JSONObject();
		JSONObject externalAgentObj  = new JSONObject();
		JSONArray  externalAgentArr = new JSONArray();
		List externalAgentsList = null;
		//String externalAgent = request.getParameter("externalAgent");
		String externalAgent = "";
		if(externalAgents != null && externalAgents.length > 0){
			List externalAgentsListAll = Arrays.asList(externalAgents);
			Collections.sort(externalAgentsListAll);

			externalAgentsList = new ArrayList();
			for(int p=0;p<externalAgentsListAll.size();p++){
				String agentInfo =  (String) externalAgentsListAll.get(p);
				if(!userViseExtAgent.contains(agentInfo))
					continue;
				externalAgentsList.add(agentInfo);
			}

			agentObj.put("label",mappingInfo.getTextDescription("monitor.services.External Agents"));
		}

		String selectedLogonComp = (String) session.getAttribute("selectedLogonComponent");
		String selectedExternalAgent = (String) session.getAttribute("selectedExternalAgent");
		if(logonComponents!=null && logonComponents.size()>0)
		{
			JSONObject component_object = new JSONObject();
			String logonComponent = "";
			if(selectedLogonComp != null && selectedLogonComp.trim().length() > 0 && logonComponents.contains(selectedLogonComp))
				logonComponent = selectedLogonComp;
			else
				logonComponent = request.getParameter("componentNameSearch");

			component_object.put("label",mappingInfo.getTextDescription("monitor.services.Simulations"));
			if(logonComponent != null && logonComponent.trim().length() > 0)
			{
				//component_object.put("selectedValue",logonComponent);
				String orgComp = logonComponent;
				if (logonComponent.endsWith(EgConstants.NULL_PORT) && (logonComponent.indexOf(EgConstants.NULL_PORT) > -1))
				{
					logonComponent  = Server.getServerNameWithoutPort(logonComponent, false);
				}
				component_object.put("selectedValue",logonComponent);
				component_object.put("selectedOrgValue",orgComp);

				/*List agents=externalInfo.getAgentsFor("CtxXcXALogonSimTest","Citrix_XcLogon_Emulation",logonComponent);
				if(agents != null && agents.size() > 0 && (externalAgent == null || externalAgent.trim().length() == 0))
				{
					externalAgentObj.put("selectedValue",(String) agents.get(0));
					extAgentOptions.put("value",(String) agents.get(0));
					extAgentOptions.put("name",(String) agents.get(0));
					externalAgentArr.add(extAgentOptions);
					component_object.put("selectedMHostValue",(String) agents.get(0));

					System.out.println("agents.size()---------->"+agents.size());
					if(agents.size() > 1)
					{
						for(int kk=1;kk<agents.size();kk++)
						{
							extAgentOptions  = new JSONObject();
							extAgentOptions.put("value",(String) agents.get(kk));
							extAgentOptions.put("name",(String) agents.get(kk));
							externalAgentArr.add(extAgentOptions);
						}
					}
				}
				else if(externalAgent != null && externalAgent.trim().length() > 0)
				{
					externalAgentObj.put("selectedValue",externalAgent);
					extAgentOptions.put("value",externalAgent);
					extAgentOptions.put("name",externalAgent);
					externalAgentArr.add(extAgentOptions);
					component_object.put("selectedMHostValue",externalAgent);
				}
				else if(externalAgentsList != null && externalAgentsList.size() > 0)
				{
					externalAgentObj.put("selectedValue",(String) externalAgentsList.get(0));
					extAgentOptions.put("value",(String) externalAgentsList.get(0));
					extAgentOptions.put("name",(String) externalAgentsList.get(0));
					externalAgentArr.add(extAgentOptions);
					component_object.put("selectedMHostValue",(String) externalAgentsList.get(0));
					//externalAgent = (String) externalAgentsList.get(0);
				}
				externalAgentObj.put("options",externalAgentArr);
				agentObj.put(logonComponent,externalAgentObj);*/
			}

			JSONArray options_array = new JSONArray(); 
			for(int k=0;k<logonComponents.size();k++)
			{
				JSONObject option_object = new JSONObject();
				String logon_comp=(String)logonComponents.get(k);
				if(logon_comp != null && logon_comp.trim().length() > 0)
				{
					externalAgentObj  = new JSONObject();
					externalAgentArr = new JSONArray();
					String orgComp = logon_comp;
					if (logon_comp.endsWith(EgConstants.NULL_PORT) && (logon_comp.indexOf(EgConstants.NULL_PORT) > -1))
					{
						logon_comp  = Server.getServerNameWithoutPort(logon_comp, false);
					}
					if(logonComponent == null || logonComponent.trim().length() == 0)
					{
						logonComponent = logon_comp;
						component_object.put("selectedValue",logon_comp);
						component_object.put("selectedOrgValue",orgComp);
					}

					List agents=externalInfo.getAgentsFor("CtxXcXALogonSimTest","Citrix_XcLogon_Emulation",logon_comp);
					if(agents != null && agents.size() > 0)
					{
						if(selectedExternalAgent != null && selectedExternalAgent.trim().length() > 0 && agents.contains(selectedExternalAgent))
							externalAgent = selectedExternalAgent;
						else
							externalAgent = request.getParameter("externalAgent");

						if(externalAgent == null || externalAgent.trim().length() == 0)
						{
							externalAgentObj.put("selectedValue",(String) agents.get(0));
						}
						else if(externalAgent != null && externalAgent.trim().length() > 0)
						{
							externalAgentObj.put("selectedValue",externalAgent);
						}


						for(int kk=0;kk<agents.size();kk++)
						{
							extAgentOptions  = new JSONObject();
							extAgentOptions.put("value",(String) agents.get(kk));
							extAgentOptions.put("name",(String) agents.get(kk));
							externalAgentArr.add(extAgentOptions);
						}
					}
					else if(externalAgentsList != null && externalAgentsList.size() > 0)
					{
						externalAgentObj.put("selectedValue",(String) externalAgentsList.get(0));
						//component_object.put("MHostValue",(String) externalAgentsList.get(0));
						//externalAgent = (String) externalAgentsList.get(0);

						for(int p=0;p<externalAgentsList.size();p++){
							extAgentOptions  = new JSONObject();
							extAgentOptions.put("value",(String) externalAgentsList.get(p));
							extAgentOptions.put("name",(String) externalAgentsList.get(p));
							externalAgentArr.add(extAgentOptions);
						}
					}
					externalAgentObj.put("options",externalAgentArr);
					agentObj.put(logon_comp,externalAgentObj);

					option_object.put("name",logon_comp);
					option_object.put("value",orgComp);
					option_object.put("comptype","Citrix_XcLogon_Emulation");
					options_array.add(option_object);
				}
			}
			component_object.put("options",options_array);
			json.put("logonComponentList",component_object);
		}
		json.put("externalAgents",agentObj);
	}

	String checkTransComp = request.getParameter("checkTransComp");
	if(checkTransComp != null && checkTransComp.trim().length() > 0 && (checkTransComp.equalsIgnoreCase("true") || checkTransComp.equalsIgnoreCase("yes")))
	{
		//JSONObject json = new JSONObject();
		json.put("isEmulTrans",String.valueOf(isEmulTrans));
		json.put("isWebTrans",String.valueOf(isWebTrans));
		json.put("isLogonSimul",String.valueOf(isLogonSimul));
		json.put("isLogonSimul",String.valueOf(isLogonSimul));

		response.getWriter().write(json.toString());
		return;
	}

	String siteState = EgStateZone.getState("Service:"+siteName+":NULL");

	String title =""+siteName;

	String uiFile = "eg_ui.ini";
	String iniFileDir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(iniFileDir + uiFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	String tracker_currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	if( user != null ) {
		String tracker_userDateFormat = (String)user.getUserDateFormat();
		if ( tracker_userDateFormat != null && !tracker_userDateFormat.equalsIgnoreCase("Default"))
		{
			tracker_currentDateFormat = tracker_userDateFormat;
		}
	}

	String timeline=request.getParameter("time_line");
	String s_st_time = request.getParameter("starttime");
	String s_en_time = request.getParameter("endtime");
	String s_st_hr = request.getParameter("starthr");
	String s_en_hr = request.getParameter("endhr");
	String s_st_min = request.getParameter("startmin");
	String s_en_min = request.getParameter("endmin");
	String tmode = request.getParameter("mode");

	if((isFromLogonTab && isLogonSimul) || isLogonSimul)
	{
		JSONObject jsonObj = new JSONObject();
		jsonObj.put("time_line",timeline);
		jsonObj.put("starttime",s_st_time);
		jsonObj.put("endtime",s_en_time);
		jsonObj.put("starthr",s_st_hr);
		jsonObj.put("endhr",s_en_hr);
		jsonObj.put("startmin",s_st_min);
		jsonObj.put("endmin",s_en_min);
		jsonObj.put("mode",tmode);
		hiddenFields.put("timelineParam",jsonObj);
	}

	EgDateInfo edi = new EgDateInfo();
	String disabled ="";
	String StrDate="";
	String comFormat="";
	String dispDate = null;
	String iniIdentity = "monitor.transaction.";
	String[] options = {"Any","1 hour","3 hours","6 hours","9 hours","12 hours","15 hours","18 hours","21 hours","24 hours","2 days","3 days","4 days","5 days","6 days","1 week","2 weeks","3 weeks","4 weeks","1 month","2 months"};

	if(timeline==null)
	{
		timeline="1 hour";
	}
	String graphUrl=response.encodeURL("../servlet/com.egurkha.TransactionMeasuresDisplay?");

	String startDateTime="";
	String endDateTime="";
	if(timeline!=null && !timeline.equals("Any"))
	{
		int blankSpaceIndex = timeline.indexOf(DateTimeTokenizer.BLANK_SPACE);
		if (blankSpaceIndex > 0)
		{
			SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm");
			java.util.Date today = edi.egetRealDate();
			endDateTime = sdf.format(today);
			int value = Integer.parseInt(timeline.substring(0, blankSpaceIndex));
			String unit = timeline.substring(blankSpaceIndex+1).toLowerCase();
			long longValue=0;
			if (unit.startsWith("h"))
			{//hours
				longValue=(long)value * 3600;
			}
			else if (unit.startsWith("d"))
			{//days
				longValue=(long)value*(24 * 3600);
			}
			else if (unit.startsWith("w"))
			{//weeks
				longValue=(long)value* (7 * 24 * 3600);
			}
			else if (unit.startsWith("mo"))
			{//months
				//value *= (30 * 24 * 3600);
				longValue=(long)value*(24*(ErUtils.getMaxDaysInMonth()) * 3600);
			}
			//longValue=value;
			java.util.Date start = edi.egetRealDate();
			start.setTime(today.getTime() - (longValue * 1000));
			startDateTime = sdf.format(start);
		}
		if ((startDateTime != null) && (endDateTime != null))
		{

			int shr = Integer.parseInt(startDateTime.substring(startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, startDateTime.indexOf(":")));  
			int smin=Integer.parseInt(startDateTime.substring(startDateTime.indexOf(":")+1));
			int en_hr = Integer.parseInt(endDateTime.substring(endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, endDateTime.indexOf(":")));
			int emin=Integer.parseInt(endDateTime.substring(endDateTime.indexOf(":")+1));


			s_en_time=endDateTime.substring(0, endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
			s_st_time=startDateTime.substring(0, startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
			s_st_hr = String.valueOf(shr);
			s_en_hr = String.valueOf(en_hr);
			s_st_min = String.valueOf(smin);
			s_en_min = String.valueOf(emin);
		}
	}
	String disable="";
	if(timeline!=null&&!timeline.equals("Any"))
	{
		disable ="disabled";
	}
	if(timeline!=null && timeline.equals("Any"))
	{
		StrDate="";
		try
		{
			java.text.SimpleDateFormat df=new java.text.SimpleDateFormat("MM/dd/yyyy k 'at' hh:mm");
			StrDate =df.format(edi.egetRealDate());
		}
		catch(Exception ee)
		{
			System.out.println("Exception is------>"+ee);
		}
		String SDate =StrDate.substring(0,StrDate.indexOf(" "));
		String shour =StrDate.substring(StrDate.indexOf(" "),StrDate.lastIndexOf(""));
		shour = shour.substring(0,3);

		String smin = StrDate.substring(StrDate.indexOf(":")+1);
		String emin=smin;
		if(s_st_time==null)
		{
			s_st_time=SDate;
		}
		if(s_en_time==null)
		{
			s_en_time=SDate;
		}
		if(s_st_hr==null)
		{
			shour =shour.trim();
			int starthr = Integer.parseInt(shour);
			starthr = starthr-1;
			s_st_hr=String.valueOf(starthr);
		}
		if(s_en_hr==null)
		{
			shour =shour.trim();
			s_en_hr =shour;
		}

		if(s_st_min==null)
		{
			smin =smin.trim();
			int startmin = Integer.parseInt(smin);
			
			s_st_min=String.valueOf(startmin);
		}
		if(s_en_min==null)
		{
			emin =emin.trim();
			int endmin = Integer.parseInt(emin);
			
			s_en_min=String.valueOf(endmin);
		}
	



	}
	
	if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
	{
		comFormat = "MM/dd/yyyy";
	}
	else
	{
		comFormat = currentDateFormat;
	}
	s_st_time = DateUtil.changeDateFormat(s_st_time,comFormat,"MM/dd/yyyy");
	if(DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
	{
		comFormat = "MM/dd/yyyy";
	}
	else
	{
		comFormat = currentDateFormat;
	}
	s_en_time = DateUtil.changeDateFormat(s_en_time,comFormat,"MM/dd/yyyy");

	if((isWebTrans || isEmulTrans))
	{
		String defaultTab=request.getParameter("selectedTab");
		defaultTab=(defaultTab==null)?"Transactions":defaultTab;
		String trans_present=request.getParameter("hasTransactions");
		String emul_trans_present=request.getParameter("hasEmulatedTransactions");
		String transComp=request.getParameter("transComp");
		String from=request.getParameter("from");
		from=(from==null)?"":from;

		if(defaultTab!=null && (defaultTab.equalsIgnoreCase("Transactions") || defaultTab.equalsIgnoreCase("EmulatedClients")))
		{
			options = new String[]{"Any","1 hour","3 hours","6 hours","9 hours","12 hours","15 hours","18 hours","21 hours","24 hours","2 days","3 days","4 days","5 days","6 days","1 week","2 weeks","3 weeks","4 weeks","1 month","2 months"};
		}

		if(trans_present!=null && trans_present.equalsIgnoreCase("true") && !from.equals("emulated"))
		{
			defaultTab="Transactions";
		}
		else if(emul_trans_present!=null && emul_trans_present.equalsIgnoreCase("true"))
		{
			defaultTab="EmulatedClients";
		}
		else if((trans_present==null && emul_trans_present==null) || (trans_present.equalsIgnoreCase("null") && emul_trans_present.equalsIgnoreCase("null")) || (trans_present.trim().length()==0 && emul_trans_present.trim().length()==0))
		{
			defaultTab="Transactions";
		}

		EgDbAdapterUI egDb = null;
		String connectionStatus = null;
		String compName = "";
		String[] str_field_list = null;
		boolean status = false;
		ResultSet transRS = null;
		ResultSet transRSTwo = null;
		ResultSet transCompSet=null;
		boolean	b_status = false;
		boolean	b_status_state = false;
		boolean b_recordspresent = false;
		Vector v_store= new Vector();
		Vector v_trans= new Vector();
		Vector v_checktrans= new Vector();
		Vector v_tmp = new Vector();
		Vector CompList=new Vector();
		Hashtable hash_v_store= new Hashtable();
		int temp_h=0;
		int i_no_measures=0;
		String test  = null;
		String	str_layer="",
				str_info,
				str_info_list,
				str_time,
				str_test_table="";
		ArrayList cname, ctype, site, layer, infos, tests, mh;
		cname = new ArrayList();
		ctype = new ArrayList();
		site = new ArrayList();
		layer = new ArrayList();
		infos = new ArrayList();
		tests = new ArrayList();
		mh = new ArrayList();

		String	s_qstr = null;
		String	str_conn="";
		String	sql_query="";
		String	sql_query_check="";
		String	s_qstr_state = null;
		String	str_trans_name="";
		String	str_trans_state="";
		String	str_trans_image="";
		String	str_info_display="";
		String measure_list="";

		String  query=request.getQueryString();
		String  Qstring="";
		if(query!=null)
		{
			StringTokenizer strtok = new StringTokenizer(query,"&");
			while(strtok.hasMoreTokens())
			{
				String param = strtok.nextToken();
				String reqparam =param.substring(0,param.indexOf("="));
				String value = request.getParameter(reqparam);
				Qstring=Qstring+reqparam+"="+EgURLEncoder.encode(value,"UTF-8")+"&";
			}
		}

		Vector components = topoinfo.getComponentsForSite(siteName);
		String segment = topoinfo.getValue("WEB_SITE_SEGMENTS","Web_site:" + siteName);

		if(segment!=null && !segment.equals(""))
		{
			if(segment.indexOf(",")>-1)
				segment =  segment.substring(0,segment.indexOf(","));
		}

		egDb=EgDbAdapterTypeUI.getObject();

		List tran_HIGH_list=new LinkedList();
		List tran_INTER_list=new LinkedList();
		List tran_LOW_list=new LinkedList();
		List tran_UNKNOWN_list=new LinkedList();
		List tran_GOOD_list=new LinkedList();

		String layerName = "";
		String temp_siteName = null;

		String displayTabs ="";
		ArrayList tabList = new ArrayList();
		String tabStr = new String();
		String testForTab = "WebSiteTransactionTest";

		if(defaultTab!=null)
		{
			if(defaultTab.equalsIgnoreCase("EmulatedClients") || defaultTab.equalsIgnoreCase("Availability") || defaultTab.equalsIgnoreCase("Response_time"))
			{
				layerName ="CLIENT_SERVICE";
				temp_siteName = "NULL";
				displayTabs ="EmulatedClients,Availability,Response_time";
				testForTab="CitraTest";
			}
			else
			{
				layerName ="WEB_TRANSACTIONS";
				temp_siteName =siteName;
				//displayTabs ="Transactions,Request_rate,Pct_errors,Pct_aborts,Data_xmit_rate,Avg_response_time,Num_current_requests";
				displayTabs ="Transactions,Request_rate,Pct_errors,Pct_aborts,Data_xmit_rate,Avg_response_time";
				testForTab="WebSiteTransactionTest";
			}
		}
		
		
		tabList = StringUtils.egTokenizer(displayTabs,",");
		int totTabs = tabList.size();
		try
		{
			String emulatedComp = null;
			String layerWithComp =  layerName;
			if(defaultTab.equalsIgnoreCase("EmulatedClients") || defaultTab.equalsIgnoreCase("Availability") || defaultTab.equalsIgnoreCase("Response_time"))
			{
				for(int x=0;x<components.size();x++)
				{
					String compwithType =(String)components.get(x);
					String compPort = compwithType.substring(0,compwithType.lastIndexOf(":"));
					if (compwithType.endsWith(":Emulated_client"))
					{
						emulatedComp=compPort;
					}
				}
			}
			if(emulatedComp!=null)
				layerWithComp=layerName+"@"+emulatedComp;
			connectionStatus = egDb.setConnection();
			//transRS=egDb.SelectDispTransState_1(siteName);
			
			if(siteName!=null)
			{
				if(EgInstallInfo.isSuperManager)
				{
					ArrayList managerIds = EgElementInfo.getInstance().getManagerIDs("service",siteName);
					if(managerIds != null && !managerIds.isEmpty())
					{
						SmSessionData smsData = new SmSessionData(session.getId(),managerIds);
						EgThreadLocal egtl = new EgThreadLocal();
						egtl.set(smsData);
						new SMDateTimeConverter(managerIds);
					}
				}
				transCompSet=egDb.SelectDispComp(siteName);//sarav getting comp List for site
				if(transCompSet!=null)
				{
					while(transCompSet.next())
					{
						String host=transCompSet.getString("TRGT_HOST");
						String port=transCompSet.getString("PORT_NO");
						String tem=host+":"+port;
						CompList.add(tem);
					}
				}
			}
			
			// Fix to assign transComp if Webtransation test is not running - menaka
			if( transComp==null || transComp.length()<=0 )
			{
				if(CompList!=null && CompList.size()>0)
					transComp=(String)CompList.get(0);
				else
				{
					if(components != null && components.size() > 0)
					{
						if(siteServers != null && siteServers.size() > 0)
						{
							for(int kk=0;kk<components.size();kk++)
							{
								String comp1 = (String)components.get(kk);
								String compType = comp1.substring(comp1.lastIndexOf(":")+1);
								if(compType != null && compType.length() > 0 && siteServers.contains(compType))
								{
									transComp=comp1.substring(0,comp1.lastIndexOf(":"));
									break;
								}
							}
						}
					}
				}
			}
			//end
			boolean res_part_one=false;
			boolean res_part_two=false;
			if(EgDbInfo.doubleByteEnabled && EgDbInfo.isOraAdapter)
			{
				if(layerName!=null&&layerName.equals("WEB_TRANSACTIONS"))
				{
					//SelectDispTransState_1(site_name,partOne,partTwo)
					transRS=egDb.SelectDispTransState_1(siteName,true,false);
					if(transRS!=null && transRS.isBeforeFirst())
						res_part_one=true;
					
					// may be the secound resultset empty then all resultset will may close, thats why the if block
					if(!res_part_one)
					{
						transRSTwo=egDb.SelectDispTransState_1(siteName,false,true);
						if(transRSTwo!=null && transRSTwo.isBeforeFirst())
							res_part_two=true;
					}
				}
				else
				{
					transRS=egDb.SelectDispTransState_1(siteName,layerWithComp,transComp);
					if(transRS!=null && transRS.isBeforeFirst())
						res_part_one=true;

				}
			}
			else
			{
				transRS=egDb.SelectDispTransState_1(siteName,layerWithComp,transComp);
				if(transRS!=null && transRS.isBeforeFirst())
					res_part_one=true;
			}
			
			status=egDb.getState();
			if(status)
			{
				if(res_part_one)
				{
					while(transRS.next())
					{
						b_recordspresent=true;
						String state = "";
						String transaction = "";
						String info = "";
						state = transRS.getString("state");
						if(defaultTab!=null)
						{
							if(defaultTab.equalsIgnoreCase("EmulatedClients") || defaultTab.equalsIgnoreCase("Availability") || defaultTab.equalsIgnoreCase("Response_time"))
							{
								info = transRS.getString("info");
								if(info!=null & info.startsWith("+"))
									info = info.substring(1);
								
								int index = v_trans.indexOf(info);
								if (index == -1 || index%3!=1)
								{	
									v_trans.addElement(state);
									v_trans.addElement(info);
								}
								else
								{
									String old_state=(String)v_trans.get(index-1);
									String higher_state=(String)ap.getHigherState(state, old_state);
									v_trans.set(index-1,higher_state);
								}
							}
							else
							{
								transaction = transRS.getString("trans_name");

								int index = v_trans.indexOf(transaction);
								if (index == -1 || index%3!=1)
								{	//Transaction is not present in the vector.
									//So add the state, transaction and the image
									String image_name=transRS.getString("img");
									v_trans.addElement(state);
									v_trans.addElement(transaction);
									v_trans.addElement(image_name);
								}
								else
								{
									//This transaction is already present in the vector.
									//So update the state
									String old_state=(String)v_trans.get(index-1);
									String higher_state=(String)ap.getHigherState(state, old_state);
									//v_trans.set(index-1, ap.getHigherState(state, old_state));
									v_trans.set(index-1,higher_state);
								}
							}
						}
					}
				}
				if(transRS!=null)
					transRS.close();
				transRS=null;
				
				if(EgDbInfo.doubleByteEnabled && EgDbInfo.isOraAdapter && res_part_one)
				{
					transRSTwo=egDb.SelectDispTransState_1(siteName,false,true);
					if(transRSTwo!=null && transRSTwo.isBeforeFirst())
						res_part_two=true;
				}

				if(EgDbInfo.doubleByteEnabled && EgDbInfo.isOraAdapter && res_part_two)
				{
					while(transRSTwo.next())
					{
						b_recordspresent=true;
						String state = transRSTwo.getString("state");
						String transaction = transRSTwo.getString("trans_name");

						int index = v_trans.indexOf(transaction);
						if (index == -1 || index%3!=1)
						{	//Transaction is not present in the vector.
							//So add the state, transaction and the image
							String image_name=transRSTwo.getString("img");
							v_trans.addElement(state);
							v_trans.addElement(transaction);
							v_trans.addElement(image_name);
						}
						else
						{
							//This transaction is already present in the vector.
							//So update the state
							String old_state=(String)v_trans.get(index-1);
							String higher_state=(String)ap.getHigherState(state, old_state);
							//v_trans.set(index-1, ap.getHigherState(state, old_state));
							v_trans.set(index-1,higher_state);
						}
					}
				}

				if(transRSTwo!=null)
					transRSTwo.close();
				transRSTwo=null;

				transRS=null;
				transRS=egDb.SelectDispTransState_2(temp_siteName,layerWithComp);
				
				if(layerName!=null&&layerName.equals("CLIENT_SERVICE"))
				{
					while(transRS.next())
					{
						String s_tmp_state = transRS.getString("state");
						String inf = transRS.getString("info");
						compName = transRS.getString("comp_name");
						int pos = 2;
						if(inf.equals("+"))
						{
							for(int v_ctrr=0; v_ctrr < v_trans.size(); v_ctrr=v_ctrr + pos)
							{
								v_trans.set(v_ctrr,s_tmp_state);
							}
						}
						else
						{
							String infoName = inf.substring(1);
							for(int v_ctrr=0; v_ctrr < v_trans.size(); v_ctrr=v_ctrr + pos)
							{
								String emulTransname =(String)v_trans.get(v_ctrr+1);
								String emulTransState =(String)v_trans.get(v_ctrr);
								if(emulTransname.equals(infoName))
								{
									v_trans.set(v_ctrr,s_tmp_state);
									break;
								}
							}
						}
					}
				}
				else
				{
					//if(transRS.next())
					while(transRS.next())
					{
						String tempCompName = transRS.getString("comp_name");
						if(transComp!=null && transComp.equals(tempCompName))
						{
							String s_tmp_state = transRS.getString("state");
							String inf = transRS.getString("info");
							compName=transRS.getString("comp_name");
							int pos = 3;
							if(inf.equals("+"))
							{
								for(int v_ctrr=0; v_ctrr < v_trans.size(); v_ctrr=v_ctrr + pos)
								{
									v_trans.set(v_ctrr,s_tmp_state);
								}
							}
						}
					}
				}
				transRS.close();
			}
			compName=(compName==null)?"":compName;
			String Comptype = null;
			String portOfComponent=null;
			String comp_name_only=null;
			for(int x=0;x<components.size();x++)
			{
				String comp =(String)components.get(x);
				String compWithPort = comp.substring(0,comp.lastIndexOf(":"));
				if(compWithPort.equals(compName))
				{
					Comptype = comp.substring(comp.lastIndexOf(":")+1);
					comp_name_only=compWithPort.substring(0,compWithPort.lastIndexOf(":"));
					portOfComponent=compWithPort.substring(compWithPort.lastIndexOf(":")+1);
				}else
				{
					if(defaultTab.equalsIgnoreCase("EmulatedClients") || defaultTab.equalsIgnoreCase("Availability") || defaultTab.equalsIgnoreCase("Response_time"))
					{
						if (comp.endsWith(":Emulated_client"))
						{
							Comptype = comp.substring(comp.lastIndexOf(":")+1);
							comp_name_only=compWithPort.substring(0,compWithPort.lastIndexOf(":"));
							portOfComponent=compWithPort.substring(compWithPort.lastIndexOf(":")+1);
							compName=comp_name_only+":"+portOfComponent;
							
						}
					}
				}
			}
		
			cname.add(compName);
			ctype.add(Comptype);
			site.add(siteName);

			if(defaultTab.equalsIgnoreCase("EmulatedClients") || defaultTab.equalsIgnoreCase("Availability") || defaultTab.equalsIgnoreCase("Response_time"))
			{
				layer.add("CLIENT_SERVICE");
				tests.add("CitraTest");
			}
			else
			{
				layer.add("WEB_TRANSACTIONS");
				tests.add("WebSiteTransactionTest");
			}

			String faultyServer = null;
			if (!StringUtils.isNull(compName))
			{
				faultyServer = "(" + compName + ")";
			}
			else
			{
				faultyServer = EgConstants.BLANK_SPACE;
			}
			boolean isok = false;
			test="";
			String hostWithMeas = "";
			String portOfComp = "";
			String measHost = "";
			int h=0,i_tmp=0,kk=1,s=1;
			
			if(v_trans.size() > 0)
			{
				int loop_limit = 0;
				//Constructing the Query
				if(defaultTab!=null && (defaultTab.equalsIgnoreCase("EmulatedClients") || defaultTab.equalsIgnoreCase("Availability") || defaultTab.equalsIgnoreCase("Response_time")))
				{
					str_layer="CLIENT_SERVICE";
					test="CitraTest";
					loop_limit = 2;
				}
				else
				{
					str_layer="WEB_TRANSACTIONS";
					test="WebSiteTransactionTest";
					loop_limit = 3;
				} 
				//str_layer = "WEB_TRANSACTIONS";
				str_info_list = "(";
				for(int i_p=1;i_p< v_trans.size();i_p=i_p+loop_limit)
				{
					String temp = (String) v_trans.elementAt(i_p);
					if(temp.startsWith("+"))
						str_info_list = str_info_list + "'" + temp + "',";
					else
						str_info_list = str_info_list + "'+" + temp + "',";
				}

				str_info_list = str_info_list.substring(0,str_info_list.length()-1)  + ")";
				str_info = "+" + v_trans.elementAt(1);
				str_time=" ";
				str_test_table = dbInfo.getTableForTest(test);
				str_field_list = dbInfo.getColumnNamesForTest(str_test_table,str_layer);
				if (str_field_list != null && str_field_list.length > 0)
					isok = true;

				//query string for the test table
				i_no_measures=0;
				
				i_no_measures = str_field_list.length / 2;

				if((compName==null || compName.equals("") ) && transComp!=null)
				{
					compName=transComp;
				}
				if (isok)
				{
					//Retrieving the records
					
					if(defaultTab!=null && (defaultTab.equalsIgnoreCase("EmulatedClients") || defaultTab.equalsIgnoreCase("Availability") || defaultTab.equalsIgnoreCase("Response_time")))
					{
						transRS = egDb.SelectDispTransState_3(str_field_list,str_test_table,compName,str_info_list);
					}
					else
					{
						transRS = egDb.SelectDispTransState_3(str_field_list,str_test_table,compName,siteName,str_info_list);
					}
					b_status = egDb.getState();
					ResultSetMetaData rsmd  = transRS.getMetaData();
					String s_kk = "";
					while(transRS.next())
					{
						measHost =transRS.getString(rsmd.getColumnCount());
						portOfComp =transRS.getString(rsmd.getColumnCount()-1);
						hostWithMeas =transRS.getString(rsmd.getColumnCount()-2);
						s_kk = (String)transRS.getString(rsmd.getColumnCount()-3);
						str_time = transRS.getString(rsmd.getColumnCount()-4);

						if(!v_tmp.contains(s_kk))
						{
							v_tmp.addElement(str_time);
							v_tmp.addElement(s_kk);
							ArrayList temp=new ArrayList();
							for(int j=1;j<=rsmd.getColumnCount()-5;j=j+2)//get rs_trans into a vector
							{
								String temp_column=rsmd.getColumnName(j);
								v_store.addElement(temp_column);
								String temp_meas=transRS.getString(j);
								v_store.addElement(temp_meas);
								String s_tmpstate = transRS.getString(j+1);
								if(s_tmpstate.equals("NONE"))
								{
									s_tmpstate = "GOOD";
								}
								v_store.addElement(s_tmpstate);
								temp.add(temp_column);
								temp.add(temp_meas);
								temp.add(s_tmpstate);
							}//end of for
							hash_v_store.put(s_kk.toLowerCase(),(ArrayList)temp);
						}
					}
					transRS.close();
				}
			}
			if(hostWithMeas!=null&&!hostWithMeas.equals(""))
				compName = hostWithMeas+":"+portOfComp;
			String mHost = measHost;
			 if(faultyServer!=null&&!faultyServer.equals("")&&compName!=null&&!compName.equals(""))
				faultyServer = "("+compName+")";
			 
			if(defaultTab!=null && (defaultTab.equalsIgnoreCase("EmulatedClients") || defaultTab.equalsIgnoreCase("Availability") || defaultTab.equalsIgnoreCase("Response_time")))
			{
				test="CitraTest";
				siteName1 ="NULL";
			}
			else
			{
				test="WebSiteTransactionTest_last";
				siteName1=siteName;
			}
			/*transRS = egDb.getSiteDetails(test,siteName1,compName);
			while(transRS.next())
			{
				mHost = transRS.getString(1);
			}
			if(transRS!=null)
			{
				transRS.close();
				transRS=null;
			}*/
			String displayTitle="";
			String all_trans_names="";

			int loop_limit = 0;
			if(defaultTab!=null && (defaultTab.equalsIgnoreCase("EmulatedClients") || defaultTab.equalsIgnoreCase("Availability") || defaultTab.equalsIgnoreCase("Response_time")))
			{
				loop_limit = 2;
			}
			else
			{
				loop_limit = 3;
			}
			for( h=0,i_tmp=0,kk=1,s=1;s < v_trans.size();kk=kk+loop_limit,i_tmp=i_tmp+2,s=s+loop_limit)
			{
				temp_h=kk-1;
				try
				{
					str_info_display=(String) v_tmp.elementAt(i_tmp+1);
					str_info_display = str_info_display.substring(1,str_info_display.length());
				}
				catch(Exception expt)
				{
					str_info_display = "";
				}

				String st_trans = (String)v_trans.elementAt(s);
				if(st_trans!=null && st_trans.trim().length()>0)
					all_trans_names=all_trans_names+","+st_trans;
				if(isok && st_trans.equalsIgnoreCase(str_info_display.trim()) && v_tmp.size() > 0)
				{
					displayTitle=(String)v_tmp.elementAt(i_tmp);
				}
			}
			
			// for getting Last Measurement Time when it empty before
			if(displayTitle!=null && displayTitle.trim().length()<=0 && v_tmp!=null && v_tmp.size()>0)
			{
				for(i_tmp=0,s=1;s < v_tmp.size();i_tmp=i_tmp+2,s=s+loop_limit)
				{
					try
					{
						str_info_display=(String) v_tmp.elementAt(i_tmp+1);
						str_info_display = str_info_display.substring(1,str_info_display.length());
					}
					catch(Exception expt)
					{
						str_info_display = "";
					}

					if(str_info_display!=null && str_info_display.trim().length()>0 && v_trans.contains(str_info_display) && isok)
					{
						displayTitle=(String)v_tmp.elementAt(i_tmp);
						break;
					}
				}
			}

			if(all_trans_names!=null && all_trans_names.trim().length()>0 && all_trans_names.startsWith(","))
			{
				all_trans_names=all_trans_names.substring(1);
			}

			int loopValue = 0;
			if(defaultTab!=null && (defaultTab.equalsIgnoreCase("EmulatedClients") || defaultTab.equalsIgnoreCase("Availability") || defaultTab.equalsIgnoreCase("Response_time")))
			{
				loopValue = 2;
			}
			else
			{
				loopValue = 3;
			}
			if(v_trans!=null && v_trans.size()>0)
			{
				for(h=1;h< v_trans.size();h=h+loopValue)
				{
					String st_trans_state = "";
					String st_trans_name = "";
					String st_trans_img = "";
					if(defaultTab!=null && (defaultTab.equalsIgnoreCase("EmulatedClients") || defaultTab.equalsIgnoreCase("Availability") || defaultTab.equalsIgnoreCase("Response_time")))
					{
						st_trans_state = (String)v_trans.elementAt(h-1);
						st_trans_name = (String)v_trans.elementAt(h);
						/*if (configInfo.isBad(st_trans_state))
						{
							String stateFromAlarmTable = com.eg.EgAlarmTable.getTestPriority(compName,Comptype,str_layer,"+"+st_trans_name,test,mHost,"","yes");
							if(stateFromAlarmTable!=null && stateFromAlarmTable.trim().length()>0)
							{
								v_trans.set(h-1,stateFromAlarmTable);
							}
						}*/
					}
					else
					{
						st_trans_state = (String)v_trans.elementAt(h-1);
						st_trans_name = (String)v_trans.elementAt(h);
						st_trans_img = (String)v_trans.elementAt(h+1);
						/*if (configInfo.isBad(st_trans_state))
						{
							String stateFromAlarmTable = com.eg.EgAlarmTable.getTestPriority(compName,Comptype,str_layer,"+"+st_trans_name,test,mHost,"","yes");
							if(stateFromAlarmTable!=null && stateFromAlarmTable.trim().length()>0)
							{
								v_trans.set(h-1,stateFromAlarmTable);
							}
						}*/
					}
				}
				for(h=1;h< v_trans.size();h=h+loopValue)
				{
					String transaction = (String)v_trans.elementAt(h);
					String state = (String)v_trans.elementAt(h-1);
					if(!(defaultTab.equalsIgnoreCase("EmulatedClients") || defaultTab.equalsIgnoreCase("Availability") || defaultTab.equalsIgnoreCase("Response_time")))
					{
						if (configInfo.isBad(state))
						{
							//Get the priority
							//state = ap.getTransactionPriority(compName, siteName, transaction);
							state = com.eg.EgAlarmTable.getTestPriority(compName,Comptype,str_layer,"+"+transaction,"WebSiteTransactionTest",mHost,"","yes");
							if (!configInfo.isBad(state))
								state = ap.getTransactionPriority(compName, siteName, transaction);
						}
					}
					else
					{
						if(configInfo.isBad(state))
						{
							state = com.eg.EgAlarmTable.getTestPriority(compName,Comptype,str_layer,"+"+transaction,test,mHost,"","yes");
						}
					}
					if(state!=null && state.equalsIgnoreCase("HIGH"))
					{
						tran_HIGH_list.add(transaction);
					}
					else if(state!=null && state.equalsIgnoreCase("INTERMEDIATE"))
					{
						tran_INTER_list.add(transaction);
					}
					else if(state!=null && state.equalsIgnoreCase("LOW"))
					{
						tran_LOW_list.add(transaction);
					}
					else if(state!=null && state.equalsIgnoreCase("UNKNOWN"))
					{
						tran_UNKNOWN_list.add(transaction);
					}
					else if(state!=null && state.equalsIgnoreCase("GOOD"))
					{
						tran_GOOD_list.add(transaction);
					}
				}
			}
			List resultList =new LinkedList();
			if(tran_HIGH_list!=null && tran_HIGH_list.size()>0)
			{
				EgSorter esort=new EgSorter(tran_HIGH_list,1);
				tran_HIGH_list=esort.sort(1,"String","asc");
				resultList.addAll(tran_HIGH_list);
			}
			if(tran_INTER_list!=null && tran_INTER_list.size()>0)
			{
				EgSorter esort=new EgSorter(tran_INTER_list,1);
				tran_INTER_list=esort.sort(1,"String","asc");
				resultList.addAll(tran_INTER_list);
			}
			if(tran_LOW_list!=null && tran_LOW_list.size()>0)
			{
				EgSorter esort=new EgSorter(tran_LOW_list,1);
				tran_LOW_list=esort.sort(1,"String","asc");
				resultList.addAll(tran_LOW_list);
			}
			if(tran_UNKNOWN_list!=null && tran_UNKNOWN_list.size()>0)
			{
				EgSorter esort=new EgSorter(tran_UNKNOWN_list,1);
				tran_UNKNOWN_list=esort.sort(1,"String","asc");
				resultList.addAll(tran_UNKNOWN_list);
			}
			if(tran_GOOD_list!=null && tran_GOOD_list.size()>0)
			{
				EgSorter esort=new EgSorter(tran_GOOD_list,1);
				tran_GOOD_list=esort.sort(1,"String","asc");
				resultList.addAll(tran_GOOD_list);
			}
			Vector v_trans_order=new Vector();
			Vector v_tmp_order = new Vector();
			Vector v_store_order = new Vector();
			for(s=0;s < resultList.size();s++)
			{
				String trans_name=(String) resultList.get(s);
				if(v_trans!=null && v_trans.size()>0)
				{
					for(h=1;h< v_trans.size();h=h+loopValue)
					{
						String st_trans_state = "";
						String st_trans_name = "";
						String st_trans_img = "";
						if(defaultTab!=null && (defaultTab.equalsIgnoreCase("EmulatedClients") || defaultTab.equalsIgnoreCase("Availability") || defaultTab.equalsIgnoreCase("Response_time")))
						{
							st_trans_state = (String)v_trans.elementAt(h-1);
							st_trans_name = (String)v_trans.elementAt(h);
							if(trans_name!=null && trans_name.equals(st_trans_name))
							{
								v_trans_order.addElement(st_trans_state);
								v_trans_order.addElement(st_trans_name);
								break;
							}
						}
						else
						{
							st_trans_state = (String)v_trans.elementAt(h-1);
							st_trans_name = (String)v_trans.elementAt(h);
							st_trans_img = (String)v_trans.elementAt(h+1);
							if(trans_name!=null && trans_name.equals(st_trans_name))
							{
								v_trans_order.addElement(st_trans_state);
								v_trans_order.addElement(st_trans_name);
								v_trans_order.addElement(st_trans_img);
								break;
							}
						}
					}
				}
			}
			if(v_trans_order!=null && v_trans_order.size()>0)
			{
				v_trans.clear();
				v_trans=v_trans_order;
				all_trans_names="";
				for(s=1;s < v_trans.size();s=s+loopValue)
				{
					String st_trans = (String)v_trans.elementAt(s);
					try
					{
					if(st_trans!=null && st_trans.trim().length()>0)
						all_trans_names=all_trans_names+","+st_trans;
					for(i_tmp=0;i_tmp < v_tmp.size();i_tmp=i_tmp+2)
					{
						String info_display="";
						String info_time="";
						try
						{
							info_time=(String) v_tmp.elementAt(i_tmp);
							info_display=(String) v_tmp.elementAt(i_tmp+1);
							info_display = info_display.substring(1,info_display.length());
						}
						catch(Exception expt)
						{
							info_display = "";
							System.out.println("errooorrrrrr...");
							expt.printStackTrace();
						}
						if(st_trans.equalsIgnoreCase(info_display))
						{
							v_tmp_order.addElement(info_time);
							v_tmp_order.addElement((String) v_tmp.elementAt(i_tmp+1));
							break;
						}
					}
					if(st_trans!=null)
					{
						ArrayList temp=(ArrayList)hash_v_store.get("+"+(st_trans.toLowerCase()));
						if(temp!=null)
							v_store_order.addAll(temp);
					}
					}
					catch(Exception e)
					{
						e.printStackTrace();
					}
				}
				if(v_tmp_order!=null && v_tmp_order.size()>0)
				{
					v_tmp.clear();
					v_tmp=v_tmp_order;
				}
				if(all_trans_names!=null && all_trans_names.trim().length()>0 && all_trans_names.startsWith(","))
				{
					all_trans_names=all_trans_names.substring(1);
				}
				if(v_store_order!=null && v_store_order.size()>0)
				{
					v_store.clear();
					v_store=v_store_order;
				}
			}

		JSONArray graphFilters = new JSONArray();
		JSONObject timelineSelect = new JSONObject();
		timelineSelect.put("type","combo");
		timelineSelect.put("combo","timeline");
		timelineSelect.put("label",mappingInfo.getTextDescription(iniIdentity+"Timeline"));		
		
		JSONArray timelineOptionsArray = new JSONArray();
		for(int e_ctr=0; e_ctr < options.length;e_ctr++)
		{
			JSONObject timelineOptions = new JSONObject();
			if(timeline!=null&&timeline.equals((String)options[e_ctr]))
			{
				String tempOptions="";
				String tempOptions2="";
				if(timeline.indexOf(" ")>-1)
				{
					tempOptions2=timeline.substring(0,timeline.indexOf(" "))+" ";
					tempOptions=timeline.substring(timeline.indexOf(" ")+1);	
				}
				else
				{
					tempOptions=timeline;
				}
				
				timelineOptions.put("value",timeline);
				timelineSelect.put("selectedValue",timeline);
				hiddenFields.put("timeline",timeline);
				timelineOptions.put("name",tempOptions2+mappingInfo.getTextDescription("monitor.common."+tempOptions));
			}
			else
			{
				String tempOptions="";
				String tempOptions2="";
				if(options[e_ctr].indexOf(" ")>-1)
				{
					tempOptions2=options[e_ctr].substring(0,options[e_ctr].indexOf(" "))+" "; tempOptions=options[e_ctr].substring(options[e_ctr].indexOf(" ")+1);	
				}
				else
				{
					tempOptions=options[e_ctr];
				}
				timelineOptions.put("value",options[e_ctr]);				
				timelineOptions.put("name",tempOptions2+mappingInfo.getTextDescription("monitor.common."+tempOptions));

			}
			timelineOptionsArray.add(timelineOptions);
		}
		timelineSelect.put("options",timelineOptionsArray);
		graphFilters.add(timelineSelect);
		JSONObject fromField = new JSONObject();
		fromField.put("type","date");
		fromField.put("field","from");
		fromField.put("label",mappingInfo.getTextDescription("monitor.common.From"));
		fromField.put("dateError",mappingInfo.getTextDescription("monitor.layermodel.Start date should be lesser than end date"));
		String loginUserStartDateTime = "";

		if(s_st_time!=null && !s_st_time.equals(""))
		{
			if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
			{
				comFormat = "MM/dd/yyyy";
				//fromField.put("dateFormat","MM/dd/yyyy");
				fromField.put("dateFormat",dateFormatForDatePicker);
			}
			else
			{
				comFormat = currentDateFormat;
				fromField.put("dateFormat",dateFormatForDatePicker);
			}
			dispDate = DateUtil.changeDateFormat(s_st_time,comFormat,currentDateFormat);
			
			String userDateFormat = dispDate+" "+s_st_hr+":"+s_st_min+":00";

			EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(userDateFormat,user);
			loginUserStartDateTime = (String)timeZoneConverter.getDate(false);
			s_st_hr = (String)timeZoneConverter.getHour();
			s_st_min = (String)timeZoneConverter.getMinute();
		}
		else
		{
			dispDate = "";
		}
		//fromField.put("value",dispDate);
		fromField.put("value",loginUserStartDateTime);
		hiddenFields.put("starttime",s_st_time);
		fromField.put("hidden",s_st_time);
		graphFilters.add(fromField);
		
		JSONObject fromHrsField = new JSONObject();
		fromHrsField.put("type","combo");
		fromHrsField.put("combo","fromhr");
		fromHrsField.put("label",mappingInfo.getTextDescription("monitor.common.Hr"));		
		
		 JSONArray fromHrsOptionsArray = new JSONArray();		
		
		for (int s_ctr = 0; s_ctr < 24; s_ctr++)
		{
			JSONObject fromOption = new JSONObject();
			if (s_ctr == Integer.parseInt(s_st_hr))
			{
				fromOption.put("name",s_st_hr);
				fromOption.put("value",s_st_hr);
				fromHrsField.put("selectedValue",s_st_hr);
				hiddenFields.put("startHr",s_ctr);
			}
			else
			{
				fromOption.put("name",s_ctr);
				fromOption.put("value",s_ctr);				
			}
			fromHrsOptionsArray.add(fromOption);
		}
			fromHrsField.put("options",fromHrsOptionsArray);
			graphFilters.add(fromHrsField);

		JSONObject fromMinField = new JSONObject();
		fromMinField.put("type","combo");
		fromMinField.put("combo","frommin");
		fromMinField.put("label",mappingInfo.getTextDescription("monitor.common.Min"));	
		JSONArray fromMinOptionsArray = new JSONArray();		
		
		for (int s_ctr = 0; s_ctr < 60; s_ctr++)
		{
			JSONObject fromMinOption = new JSONObject();
			if (s_ctr == Integer.parseInt(s_st_min))
			{
				fromMinOption.put("name",s_st_min);
				fromMinOption.put("value",s_st_min);
				fromMinField.put("selectedValue",s_st_min);
				hiddenFields.put("startMin",s_ctr);
			}
			else
			{
				fromMinOption.put("name",s_ctr);
				fromMinOption.put("value",s_ctr);				
			}
			fromHrsOptionsArray.add(fromMinOption);
		}
			fromMinField.put("options",fromMinOptionsArray);
			graphFilters.add(fromMinField);

		JSONObject toField = new JSONObject();
		toField.put("type","date");
		toField.put("field","to");
		toField.put("label",mappingInfo.getTextDescription("monitor.common.To"));		
		toField.put("dateError",mappingInfo.getTextDescription("monitor.layermodel.From and To date should be lesser than current date"));
		
		if(s_en_time!=null && !s_en_time.equals(""))
		{
			if(DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
			{
				comFormat = "MM/dd/yyyy";
				//toField.put("dateFormat","MM/dd/yyyy");
				toField.put("dateFormat",dateFormatForDatePicker);
			}
			else
			{
				comFormat = currentDateFormat;
				//toField.put("dateFormat",dateFormatForDatePicker);
				toField.put("dateFormat",dateFormatForDatePicker);
			}
			dispDate = DateUtil.changeDateFormat(s_en_time,comFormat,currentDateFormat);
			String userDateFormat = dispDate+" "+s_en_hr+":"+s_en_min+":00";

			EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(userDateFormat,user);
			loginUserStartDateTime = (String)timeZoneConverter.getDate(false);
			s_en_hr = (String)timeZoneConverter.getHour();
			s_en_min = (String)timeZoneConverter.getMinute();
		}
		else
		{
			dispDate = "";
		}
		toField.put("value",loginUserStartDateTime);
		hiddenFields.put("endtime",s_en_time);
		toField.put("hidden",s_en_time);
		graphFilters.add(toField);

		JSONObject toHrsField = new JSONObject();
		toHrsField.put("type","combo");
		toHrsField.put("combo","tohr");
		toHrsField.put("label",mappingInfo.getTextDescription("monitor.common.Hr"));					
		
		JSONArray toHrsOptionsArray = new JSONArray();		
		 for (int e_ctr = 0; e_ctr < 24; e_ctr++)
		{
			JSONObject toOption = new JSONObject();
			if (e_ctr == Integer.parseInt(s_en_hr))
			{
				toOption.put("name",s_en_hr);
				toOption.put("value",s_en_hr);
				toHrsField.put("selectedValue",s_en_hr);	
				hiddenFields.put("endHr",e_ctr);
			}
			else
			{
				toOption.put("name",e_ctr);
				toOption.put("value",e_ctr);				
			}
			toHrsOptionsArray.add(toOption);
		} 
			toHrsField.put("options",toHrsOptionsArray);
			graphFilters.add(toHrsField);
		
		JSONObject toMinField = new JSONObject();
		toMinField.put("type","combo");
		toMinField.put("combo","tomin");
		toMinField.put("label",mappingInfo.getTextDescription("monitor.common.Min"));					
		
		JSONArray toMinOptionsArray = new JSONArray();		
		 for (int e_ctr = 0; e_ctr < 60; e_ctr++)
		{
			JSONObject toMinOption = new JSONObject();
			if (e_ctr == Integer.parseInt(s_en_min))
			{
				toMinOption.put("name",s_en_min);
				toMinOption.put("value",s_en_min);
				toMinField.put("selectedValue",s_en_min);	
				hiddenFields.put("endMin",e_ctr);
			}
			else
			{
				toMinOption.put("name",e_ctr);
				toMinOption.put("value",e_ctr);				
			}
			toMinOptionsArray.add(toMinOption);
		} 
			toMinField.put("options",toMinOptionsArray);
			graphFilters.add(toMinField);

		//

		JSONObject modeFilter = new JSONObject();
		modeFilter.put("type","combo");
		modeFilter.put("label",mappingInfo.getTextDescription("monitor.common.Mode"));
		
		
		String 	mode = request.getParameter("mode");
		if(mode!=null && mode.equalsIgnoreCase("add"))
		{
			mode="";
		}
		String select2d="";
		String select3d="";
		boolean use3DGraphs = com.egurkha.ini.IniUI.getInstance().use3DGraphs(com.egurkha.ini.IniUI.MONITOR);
		

		if(mode!=null&&!mode.equals(""))
		{
			if(mode.equals("2D"))
				select2d="selected";
			
			if(mode.equals("3D"))
				select3d="selected";
		}
		else
		{
			if(use3DGraphs)
				select3d="selected";
			else
				select2d="selected";
		}
			JSONArray modeOptions = new JSONArray();	
			JSONObject modeoption2d = new JSONObject();
			modeoption2d.put("value","2D");
			modeoption2d.put("name",mappingInfo.getTextDescription("monitor.common.2D"));
			
			modeOptions.add(modeoption2d);
			
			JSONObject modeoption3d = new JSONObject();
			modeoption3d.put("value","3D");
			modeoption3d.put("name",mappingInfo.getTextDescription("monitor.common.3D"));
			
			modeOptions.add(modeoption3d);
			
			modeFilter.put("options",modeOptions);
			
			String selectedValue="3D";
			if(select2d.equals("selected")){
				selectedValue="2D";
			}
			modeFilter.put("selectedValue",selectedValue);
			hiddenFields.put("mode",selectedValue);
			modeFilter.put("combo","mode");
			graphFilters.add(modeFilter);
		
		JSONObject graphBtn = new JSONObject();
		graphBtn.put("type","button");
		graphBtn.put("label",mappingInfo.getTextDescription("monitor.common.Graph"));
		graphFilters.add(graphBtn);
		
		json.put("graphFilters",graphFilters);
		String test_name = "";
		String layer_name = "";
		dbInfo.checkForUpdate();
		if(defaultTab!=null && (defaultTab.equalsIgnoreCase("EmulatedClients") || defaultTab.equalsIgnoreCase("Availability") || defaultTab.equalsIgnoreCase("Response_time")))
		{
			test_name = dbInfo.getTableForTest("CitraTest");
			layer_name = dbInfo.getTableForTest("CLIENT_SERVICE");
		}
		else
		{
			test_name = dbInfo.getTableForTest("WebSiteTransactionTest");
			layer_name = dbInfo.getTableForTest("WEB_TRANSACTIONS");
		}

		String[] measure_name_list = dbInfo.getColumnNamesForTest(test_name,layer_name);
		
		if(measure_name_list!=null && measure_name_list.length>0)
		{
			for(int x=0;x<measure_name_list.length;x++)
			{
				String temp_measure_name=measure_name_list[x];
				if(!temp_measure_name.endsWith("_ST"))
				{
					temp_measure_name = dbInfo.getMeasureForColumn(test_name, temp_measure_name,false);
					if(temp_measure_name != null && temp_measure_name.length() > 0 && !temp_measure_name.equalsIgnoreCase("Num_current_requests"))
					{
						measure_list=measure_list+","+temp_measure_name;
					}
				}
			}
			if(measure_list!=null && measure_list.trim().length()>0 && measure_list.startsWith(","))
			{
				measure_list=measure_list.substring(1);
			}
		}

		request.setAttribute("jsonObject",json);
		request.setAttribute("category","service");
		request.setAttribute("itemName",siteName);

		%>
			<%@ include file="aggregateTabHandler.jsp" %>
		<%
		hiddenFields.put("selectedTab",defaultTab);
		hiddenFields.put("testForTab",testForTab);
		hiddenFields.put("all_trans_names",all_trans_names);
		hiddenFields.put("sitename",EgURLEncoder.encode(siteName,"UTF-8"));
		screenLabels.put("Title",title);
		screenLabels.put("siteState",siteState);


	// confusion in title			<div style="padding:6px;float:left;width:300px" title="=title">=StringUtils.egSubString(title,isUserLanguageEnglish,35,15)

			String select_trans_tab_url="/final/monitor/transactions.jsp?site="+EgURLEncoder.encode(siteName,"UTF-8")+"&selectedTab=Transactions&hasTransactions="+trans_present+"&hasEmulatedTransactions="+emul_trans_present;
			String select_emul_tab_url="/final/monitor/transactions.jsp?site="+EgURLEncoder.encode(siteName,"UTF-8")+"&selectedTab=EmulatedClients&hasTransactions="+trans_present+"&hasEmulatedTransactions="+emul_trans_present+"&from=emulated";

			if((trans_present!=null && trans_present.equalsIgnoreCase("true")) && (emul_trans_present!=null && emul_trans_present.equalsIgnoreCase("true")))
			{
				if(defaultTab!=null && defaultTab.equalsIgnoreCase("Transactions"))
				{

					screenLabels.put("webBtnLabel",mappingInfo.getTextDescription("monitor.services.Web Transactions"));
					screenLabels.put("webBtnURL",select_trans_tab_url);
					screenLabels.put("emulBtnLabel",mappingInfo.getTextDescription("monitor.services.Emulated Transactions"));
					screenLabels.put("emulBtnURL",select_emul_tab_url);
				}
				else
				{
					screenLabels.put("webBtnLabel",mappingInfo.getTextDescription("monitor.services.Web Transactions"));
					screenLabels.put("webBtnURL",select_trans_tab_url);
					screenLabels.put("emulBtnLabel",mappingInfo.getTextDescription("monitor.services.Emulated Transactions"));
					screenLabels.put("emulBtnURL",select_emul_tab_url);
				}
			}
			else if(emul_trans_present!=null && emul_trans_present.equalsIgnoreCase("true"))
			{
				screenLabels.put("emulBtnLabel",mappingInfo.getTextDescription("monitor.services.Emulated Transactions"));
				screenLabels.put("emulBtnURL",select_emul_tab_url);
			}
			else if(trans_present!=null && trans_present.equalsIgnoreCase("true"))
			{
				screenLabels.put("webBtnLabel",mappingInfo.getTextDescription("monitor.services.Web Transactions"));
				screenLabels.put("webBtnURL",select_trans_tab_url);

			}
			if(CompList!=null && CompList.size()>0)
			{
				JSONObject component_object = new JSONObject();
				component_object.put("label",mappingInfo.getTextDescription("monitor.services.Components"));
				JSONArray options_array = new JSONArray(); 

				for(int k=0;k<CompList.size();k++)
				{
					JSONObject option_object = new JSONObject();
					String tem=(String)CompList.get(k);
					String compType = discInfo.getServerTypesForComponentNamePort(tem);
					//tem=tem.substring(0,tem.lastIndexOf(":"));
					if(transComp!=null && tem.equals(transComp))
					{
						option_object.put("name",tem);
						option_object.put("value",tem);
						option_object.put("comptype",compType);
						component_object.put("selectedValue",tem);
					}
					else
					{
						option_object.put("name",tem);
						option_object.put("value",tem);					
						option_object.put("comptype",compType);
					}
					options_array.add(option_object);
				}
				component_object.put("options",options_array);
				json.put("ComponentList",component_object);
			}

			int colsSpan=7;
			if(!(defaultTab.equalsIgnoreCase("EmulatedClients") || defaultTab.equalsIgnoreCase("Availability") || defaultTab.equalsIgnoreCase("Response_time")))
			{
				colsSpan=7;
				JSONObject transScreenHeaders = new JSONObject();
				JSONArray transHeaderArray = new JSONArray();
				for(int in=0;in<totTabs;in++)
				{
					String str =(String)tabList.get(in);
					String unitForTab = tablesInfo.getUnitForMeasure(testForTab, str);
					if(str.equalsIgnoreCase("Transactions"))
					{
						transScreenHeaders.put("Header",mappingInfo.getTextDescription("monitor.transactions."+str));
					}
					else
					{
						transScreenHeaders.put("Header",mappingInfo.getMeasureDescription(testForTab,str));
						transScreenHeaders.put("UnitForHeader",unitForTab);
					}
					transHeaderArray.add(transScreenHeaders);
				}
				screenLabels.put("TransactionHeaders",transHeaderArray);
			}
			else
			{
				JSONObject transScreenHeaders = new JSONObject();
				JSONArray transHeaderArray = new JSONArray();
				colsSpan=4;
				for(int in=0;in<totTabs;in++)
				{
					String str =(String)tabList.get(in);
					String unitForTab = tablesInfo.getUnitForMeasure(testForTab, str);
					
					if(str.equalsIgnoreCase("EmulatedClients"))
					{
						str = "Transactions";

						transScreenHeaders.put("Header",mappingInfo.getTextDescription("monitor.clients."+str));
					}
					else
					{
						transScreenHeaders.put("Header",mappingInfo.getMeasureDescription(testForTab,str));
						transScreenHeaders.put("UnitForHeader",unitForTab);
					}
					transHeaderArray.add(transScreenHeaders);
				}
				screenLabels.put("TransactionHeaders",transHeaderArray);
			}
			//For Web Transactions
			if(!(defaultTab.equalsIgnoreCase("EmulatedClients") || defaultTab.equalsIgnoreCase("Availability") || defaultTab.equalsIgnoreCase("Response_time")))
			{
				if(displayTitle!=null && displayTitle.length()>0)
				{
					int cols=7;
					String measureDate  = displayTitle.substring(0,displayTitle.indexOf(" "));
					//measureDate = DateUtil.changeDateFormat(measureDate,"MM/dd/yyyy",currentDateFormat);
					measureDate = DateUtil.changeDateFormat(measureDate,"MM/dd/yyyy",dateFormatForDatePicker);
					String measuretime  = displayTitle.substring(displayTitle.indexOf(" ")+1);
					displayTitle = measureDate.trim()+" "+measuretime.trim();
					screenLabels.put("lastMeasurementTime_Text",mappingInfo.getTextDescription("monitor.transaction.Last Measurement Time"));
					screenLabels.put("lastMeasurementTime",displayTitle);
					screenLabels.put("faultyServer",faultyServer);

					if(EgInstallInfo.isClusterSupported)
					{
						json.put("isClusterSupported",true);

					}
					else
					{
						//onClick to be handled on UI
						screenLabels.put("configureTransBtnLabel",mappingInfo.getTextDescription("monitor.transaction.Configure Transactions"));
					}
				}
				else
				{
					screenLabels.put("faultyServer",faultyServer);

					if(EgInstallInfo.isClusterSupported)
					{
						json.put("isClusterSupported",true);

					}
					else
					{
						//onClick to be handled on UI
						screenLabels.put("configureTransBtnLabel",mappingInfo.getTextDescription("monitor.transaction.Configure Transactions"));
					}
				}
			}
			else // For Emulated Transactions
			{
				if(displayTitle!=null && displayTitle.length()>0)
				{
					int cols=7;
					String measureDate  = displayTitle.substring(0,displayTitle.indexOf(" "));
					//measureDate = DateUtil.changeDateFormat(measureDate,"MM/dd/yyyy",currentDateFormat);
					measureDate = DateUtil.changeDateFormat(measureDate,"MM/dd/yyyy",dateFormatForDatePicker);
					String measuretime  = displayTitle.substring(displayTitle.indexOf(" ")+1);
					displayTitle = measureDate+" "+measuretime;
					screenLabels.put("lastMeasurementTime_Text",mappingInfo.getTextDescription("monitor.transaction.Last Measurement Time"));
					screenLabels.put("lastMeasurementTime",displayTitle.trim());
					screenLabels.put("faultyServer",faultyServer);

					if(EgInstallInfo.isClusterSupported)
					{
						json.put("isClusterSupported",true);

					}
					else
					{
						if(!defaultTab.equalsIgnoreCase("EmulatedClients"))
						{
							//onClick to be handled on UI
							screenLabels.put("configureTransBtnLabel",mappingInfo.getTextDescription("monitor.transaction.Configure Transactions"));
						}
					}
				}
				else
				{
					screenLabels.put("faultyServer",faultyServer);

					if(EgInstallInfo.isClusterSupported)
					{
						json.put("isClusterSupported",true);

					}
					else
					{
						if(!defaultTab.equalsIgnoreCase("EmulatedClients"))
						{
							//onClick to be handled on UI
							screenLabels.put("configureTransBtnLabel",mappingInfo.getTextDescription("monitor.transaction.Configure Transactions"));
						}
					}
				}
			}

			int n=0;
			int v_ctr=0;
			int loopCount = 0;
			int j=0;
			int k=0;
						
			if(defaultTab.equalsIgnoreCase("EmulatedClients") || defaultTab.equalsIgnoreCase("Availability") || defaultTab.equalsIgnoreCase("Response_time"))
			{
				loopCount = 2;
			}
			else
			{
				loopCount = 3;
			}
			
			JSONArray transactionsInfoArray = new JSONArray();
			
			
			
			for( v_ctr=0,i_tmp=0,s=1; v_ctr < v_trans.size(); v_ctr=v_ctr + loopCount,i_tmp=i_tmp+2,s=s+loopCount)
			{
				
				JSONObject transInfo = new JSONObject();
				
				
				
				
				
				infos=new ArrayList();
				if(defaultTab.equalsIgnoreCase("EmulatedClients") || defaultTab.equalsIgnoreCase("Availability") || defaultTab.equalsIgnoreCase("Response_time"))
				{
					h=n*6;
				}
				else
				{
					h=n*18;
				}
				str_trans_state = (String)v_trans.elementAt(v_ctr);
				str_trans_name = (String)v_trans.elementAt(v_ctr + 1);

				if(!(defaultTab.equalsIgnoreCase("EmulatedClients") || defaultTab.equalsIgnoreCase("Availability") || defaultTab.equalsIgnoreCase("Response_time")))
				//Check state here and show transaction priority if state is BAD
				//if (str_trans_state.equals(AlarmPriorities.BAD_STATE))
				//if (configInfo.isBad(str_trans_state))
				{
					str_trans_image = (String)v_trans.elementAt(v_ctr + 2);

					if (configInfo.isBad(str_trans_state))
					{
						//Get the priority
						//str_trans_state = ap.getTransactionPriority(compName, siteName, str_trans_name);
						str_trans_state = com.eg.EgAlarmTable.getTestPriority(compName,Comptype,str_layer,"+"+str_trans_name,"WebSiteTransactionTest",mHost,"","yes");
						if(!configInfo.isBad(str_trans_state))
							str_trans_state = ap.getTransactionPriority(compName, siteName, str_trans_name);


					}
				}
				else
				{
								
					if (configInfo.isBad(str_trans_state))
					{
						str_trans_state = com.eg.EgAlarmTable.getTestPriority(compName,Comptype,str_layer,"+"+str_trans_name,test,mHost,"","yes");
					}
				}
				//Dont ask me why there is an empty print here... it didnt work for some sites
				// when i didnt give it :-((
				String alt1 = iniIdentity+str_trans_state;
				String display_str_trans_name=str_trans_name;
				
				if(display_str_trans_name!=null && display_str_trans_name.trim().length()>30)
				{
					display_str_trans_name=display_str_trans_name.substring(0,25)+"..";
				}
				if(!(defaultTab.equalsIgnoreCase("EmulatedClients") || defaultTab.equalsIgnoreCase("Availability") || defaultTab.equalsIgnoreCase("Response_time")))
				{

					transInfo.put("Counter",v_ctr);

					String service=request.getParameter("service");
					if(service!=null && !service.equals(""))
					{
						transInfo.put("SegmentInfo",segment);
					}
					else
					{
						transInfo.put("SegmentInfo",segment);
					}
					transInfo.put("transactionStateClass","state_"+str_trans_state);
					transInfo.put("transactionStateTitle",mappingInfo.getLabelDescription(str_trans_state));

					if(service!=null && !service.equals(""))
					{
						transInfo.put("SegmentInfo",segment);
						transInfo.put("transactionLinkTitle",str_trans_name);					
					}
					else
					{
						transInfo.put("SegmentInfo",segment);
						transInfo.put("transactionLinkTitle",str_trans_name);
						
					}
					transInfo.put("transactionName",display_str_trans_name);
					
					if(!(defaultTab.equalsIgnoreCase("EmulatedClients") || defaultTab.equalsIgnoreCase("Availability") || defaultTab.equalsIgnoreCase("Response_time")))
					{
						transInfo.put("SegmentInfo",segment);
						transInfo.put("transImage","/final/monitor/eg_images/"+monitor_Skin+"/trans_"+str_trans_image+"_small.gif");
						transInfo.put("transImageTitle",mappingInfo.getLabelDescription(iniIdentity+str_trans_image));
					}
				}
				else // For Emulated Transactions
				{
					transInfo.put("Counter",v_ctr);
					transInfo.put("SegmentInfo",segment);
					transInfo.put("transactionStateClass","state_"+str_trans_state);
					transInfo.put("transactionStateTitle",mappingInfo.getLabelDescription(str_trans_state));
					transInfo.put("transactionName",display_str_trans_name);								

					if(!(defaultTab.equalsIgnoreCase("EmulatedClients") || defaultTab.equalsIgnoreCase("Availability") || defaultTab.equalsIgnoreCase("Response_time")))
					{
						transInfo.put("transImage","/final/monitor/eg_images/"+monitor_Skin+"/trans_"+str_trans_image+"_small.gif");
						transInfo.put("transImageTitle",mappingInfo.getLabelDescription(iniIdentity+str_trans_image));
					}
				} // end of else
				int q = 0;
				ArrayList rptState = null;
				ArrayList measuresForAlarms  = new ArrayList();
				String st_trans = (String)v_trans.elementAt(s);
				String infoForDb=null;
				n++;
				try
				{
					str_info_display=(String) v_tmp.elementAt(i_tmp+1);
					infoForDb=str_info_display;
					str_info_display = str_info_display.substring(1,str_info_display.length());
				}
				catch(Exception expt)
				{
					str_info_display = "";
				}
				//str_layer = "WEB_TRANSACTIONS";
				if(defaultTab!=null && (defaultTab.equalsIgnoreCase("EmulatedClients") || defaultTab.equalsIgnoreCase("Availability") || defaultTab.equalsIgnoreCase("Response_time")))
				{
					str_layer="CLIENT_SERVICE";
				}
				else
				{
					str_layer="WEB_TRANSACTIONS";
				}
				if(mHost!=null)
					mh.add(mHost);
				infos.add("+"+str_trans_name);

				
				if(isok && st_trans.equalsIgnoreCase(str_info_display.trim()) && v_tmp.size() > 0)
				{
					int loopVal  = 0;
					if(defaultTab!=null && (defaultTab.equalsIgnoreCase("EmulatedClients") || defaultTab.equalsIgnoreCase("Availability") || defaultTab.equalsIgnoreCase("Response_time")))
					{
						loopVal = 2;
					}
					else
					{
						loopVal = 3;
					}
					dbInfo.checkForUpdate();
					int measureCnt=0;
					for(j=h;q<i_no_measures;j=j+3,h=h+3,q++)
					{
						String mesState = "";
						String mesName = "";
						try
						{
							rptState= new ArrayList();
							measuresForAlarms = new ArrayList();
							mesState = (String)v_store.elementAt(j+2);
							mesName = (String)v_store.elementAt(j);
						}
						catch(Exception e)
						{
							System.out.println("Sample error...");
							e.printStackTrace();
						}

						if(defaultTab.equalsIgnoreCase("EmulatedClients") || defaultTab.equalsIgnoreCase("Availability") || defaultTab.equalsIgnoreCase("Response_time"))
						{
							test = "CitraTest";
						}
						else
						{
							test = "WebSiteTransactionTest";
						}
						if (!tests.contains(test))
							tests.add(test);
						if(siteName!=null && siteName.trim().length()>0 && comp_name_only!=null && comp_name_only.trim().length()>0 && portOfComponent!=null && portOfComponent.trim().length()>0)
						{
							ResultSet resSet = egDb.SelectDispMeasure_2(siteName, comp_name_only, portOfComponent, infoForDb, "+", "", str_layer, test, mHost);
							if(resSet!=null)
							{
								while(resSet.next())
								{
									String measure = resSet.getString(1).trim();
									String mcol = dbInfo.getColumnForMeasure(test,measure,false);
									if(mesName.equals(mcol))
									{
										mesState=resSet.getString(2);
										break;
									}
								}
								if (resSet != null)
									resSet.close();
								resSet = null;
							}
						}
						rptState.add(mesState);
						String dbMesName = mesName;
						mesName = dbInfo.getMeasureForColumn(test, mesName,false);
						measuresForAlarms.add(mesName);
						ArrayList states = new ArrayList();
						String checkForUnknown = "GOOD";
						if(rptState!=null&&rptState.size()>0)
						{
						 checkForUnknown = (String)rptState.get(0);
						}
						if(checkForUnknown!=null&&!checkForUnknown.equals("UNKNOWN"))
						{
							try
							{
								states = com.eg.EgAlarmTable.getPriorities(cname,ctype,site,layer,infos,tests,measuresForAlarms,mh,rptState,true);
							}
							catch(Exception e)
							{
								System.out.println("Exception in state... ");
								e.printStackTrace();
							}
						}
						else
						{
							states.add(checkForUnknown);
						}
						String s_mes_val = (String)v_store.elementAt(j+1);
						if(s_mes_val.startsWith("-"))
						{
							int dotIdx = s_mes_val.indexOf('.');
							if(dotIdx != -1 )s_mes_val =s_mes_val.substring(0,dotIdx);
							String s_iniValue = ui.getMeasureLookup(s_mes_val);
							s_mes_val = (s_iniValue!=null && !s_iniValue.equals(""))?s_iniValue:s_mes_val;
						} //0 There are no measurements 
						
						if (s_mes_val.startsWith("-1"))
						{
							s_mes_val = "Unknown";
						}
						else if (s_mes_val.startsWith("-2"))
						{
							s_mes_val = "Unlimited";
						}
						else if (s_mes_val.startsWith("-5"))
						{
							s_mes_val = "Not Available";
						}
						else
							s_mes_val = EgDbInfo.formatValue(s_mes_val);
						// For Web Transactions data display
						
						
						
						
						if(!(defaultTab.equalsIgnoreCase("EmulatedClients") || defaultTab.equalsIgnoreCase("Availability") || defaultTab.equalsIgnoreCase("Response_time")))
						{   
							transInfo.put(measureCnt+"MeasureValueId",mesName+v_ctr);
							if(states!=null && states.size()>0)
							{
								//transInfo.put(measureCnt+"MeasureValueImg","/final/monitor/eg_images/eg_layout/Tests"+states.get(0)+".gif");
								transInfo.put(measureCnt+"MeasureValueImg","stateSymbol_"+states.get(0));
								transInfo.put(measureCnt+"MeasureValueImgTitle",mappingInfo.getLabelDescription((String)states.get(0)));
								
							
							
							
							
							
							}
							else
							{
								transInfo.put(measureCnt+"MeasureValueImg","stateSymbol_"+mesState);
								transInfo.put(measureCnt+"MeasureValueImgTitle",mappingInfo.getLabelDescription(mesState));
								
							}

							transInfo.put("SegmentInfo",segment);
							transInfo.put(measureCnt+"MeasureValue",s_mes_val);
							
						} // closing if
						else //// For Emulated Transactions data display
						{
							transInfo.put(measureCnt+"MeasureValueId",mesName+v_ctr);
							
							if(states!=null && states.size()>0)
							{
								transInfo.put(measureCnt+"MeasureValueImg","stateSymbol_"+states.get(0));
								transInfo.put(measureCnt+"MeasureValueImgTitle",mappingInfo.getLabelDescription((String)states.get(0)));
								
							}
							else
							{
								transInfo.put(measureCnt+"MeasureValueImg","stateSymbol_"+mesState);
								transInfo.put(measureCnt+"MeasureValueImgTitle",mappingInfo.getLabelDescription(mesState));
								
							}
							transInfo.put("SegmentInfo",segment);
							transInfo.put(measureCnt+"MeasureValue",s_mes_val);
						} // closing else
						measureCnt++;
					}//inner for ends here
					
				}
				else
				{
					 
					if(!(defaultTab.equalsIgnoreCase("EmulatedClients") || defaultTab.equalsIgnoreCase("Availability") || defaultTab.equalsIgnoreCase("Response_time")))
					{
						transInfo.put("Message",mappingInfo.getTextDescription("monitor.transaction.There are no measurements!"));
					}
					else
					{
						transInfo.put("Message",mappingInfo.getTextDescription("monitor.transaction.There are no measurements!"));

					} 
					i_tmp = i_tmp -2;
					n=n-1;			
					
				}
				transactionsInfoArray.add(transInfo);
				
				
			}//upper for ebds here
			hiddenFields.put("transSize",v_trans.size());
			json.put("TransactionsIfo",transactionsInfoArray);

			if((compName == null || compName.trim().length() == 0 || Comptype == null || Comptype.trim().length() ==0) && siteName != null){
				ArrayList secs = topoinfo.getAllElementsUnderService(siteName);
				ArrayList siteServers1 = discInfo.getSiteServers();
				if(secs != null && secs.size() > 0){
					for(int i=0;i<secs.size();i++){
						String val = (String) secs.get(i);
						String c_type=null;
						if(val!=null)
							c_type=val.substring(0,val.indexOf(":"));
						//if(val.indexOf("IIS_web_server") != -1 || val.indexOf("Ssl_web_server") != -1 )
						if(siteServers1 != null && siteServers1.size() > 0 && c_type!=null && siteServers1.contains(c_type))
						{
							String tmp_Comptype = val.substring(0,val.indexOf(":"));
							String tmp_compName = val.substring(val.indexOf(":")+1);

							if(Comptype==null || Comptype.trim().length()==0)
							{
								Comptype = tmp_Comptype;
							}

							if(compName==null || compName.trim().length()==0)
							{
								compName = tmp_compName;
							}
						}
					}
				}
			}
			hiddenFields.put("compName",compName);
			hiddenFields.put("compType",Comptype);
			hiddenFields.put("siteName",siteName);
			hiddenFields.put("mHost",mHost);
			hiddenFields.put("measurelst",measure_list);
			hiddenFields.put("remoteURL",response.encodeURL("../servlet/com.eg.EgMonRemoteScriptingServlet"));
			hiddenFields.put("emul_trans_present",emul_trans_present);
			hiddenFields.put("trans_present",trans_present);
			hiddenFields.put("monitorSkin",monitor_Skin);
			hiddenFields.put("currentDateFormat",currentDateFormat);
			// Timeline end here  

			egDb.releaseConnection(false);
			EgDbAdapterTypeUI.releaseObject(egDb);
			
			json.put("HiddenFields",hiddenFields);
			json.put("GridScreenLabels",screenLabels);
			json.put("GraphScreenLabels",graphLabels);		
			response.getWriter().write(json.toString());
		}
		catch(Exception ef)
		{
			ef.printStackTrace();
			String errMsg = "";
			if(!connectionStatus.equals("CONNECTED"))
			{
				errMsg = "Could not establish connection";
			}
			else if(!b_status)
			{
				errMsg = "An unknown error occured while fetching records";
			}
			else if(!b_status_state)
			{
				errMsg = "An unknown error occured while fetching records from report";
			}
			else
			{
				errMsg = ef.toString();
			}
			if (transRS != null)
			{
				try 
				{
					transRS.close();
				}
				catch (Exception bug123) {}
			}
			try{
				egDb.releaseConnection(true);
				EgDbAdapterTypeUI.releaseObject(egDb);
			}
			catch(Exception el)
			{}
			System.out.println("errMsg---->"+errMsg);
			return;
		}
	}
	else if(isLogonSimul)
	{
		screenLabels.put("Title",title);
		screenLabels.put("siteState",siteState);

		String compName = "", Comptype = "";
		if((compName == null || compName.trim().length() == 0 || Comptype == null || Comptype.trim().length() ==0) && siteName != null){
			if(componentList != null && componentList.size() > 0){
				for(int i=0;i<componentList.size();i++){
					String val = (String) componentList.get(i);
					if(val.indexOf("Citrix_XcLogon_Emulation") != -1){
						String tmp_Comptype = val.substring(0,val.indexOf(":"));
						String tmp_compName = val.substring(val.indexOf(":")+1);

						if(Comptype==null || Comptype.trim().length()==0)
						{
							Comptype = tmp_Comptype;
						}

						if(compName==null || compName.trim().length()==0)
						{
							compName = tmp_compName;
						}
					}
				}
			}
		}

		hiddenFields.put("siteName",siteName);
		hiddenFields.put("compName",compName);
		hiddenFields.put("compType",Comptype);

		json.put("HiddenFields",hiddenFields);
		json.put("GridScreenLabels",screenLabels);
		json.put("GraphScreenLabels",graphLabels);

		response.getWriter().write(json.toString());
	}

	if(!isFromLogonTab)
	{
		if(request.getQueryString()!=null)
		{	
			//session.setAttribute("monitorLastSession",session.getAttribute("monitorLastSession"));
			session.setAttribute("monitorLastSession","/final/monitor/serviceDashboard.jsp?"+request.getQueryString()+"&refresh=true");
		}
		else
		{
			session.setAttribute("monitorLastSession","/final/monitor/serviceDashboard.jsp");
		}
	}
}//this try block starts at line 43
catch(Throwable e)
{
	System.out.println("EgDispTransState Error.. ");
	e.printStackTrace();
}
%>
   