<%
/*******************************************************************************
*	File name		: sqlProcess.jsp
*	Purpose			: To show the MS-SQL & Sybase sys processes along with its details
*	Version			: eG 5.3.
*	Creation Date	: 15/03/2011
*	Modifed			: 15/07/2011	- Modified to Support Sybase sysprocess
*	Modifed			: 10/08/2011	- To Provide Support for Oracle Sessions & Oracle User connections
******************************************************************************/
%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ include file = "EgLoginTracker.jsp" %>
<%@ page errorPage = "EgProbsM.jsp" %>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.egurkha.util.DateUtil"%>
<%@ page import="java.sql.*"%>
<%@ page import="com.eg.EgDbInfo"%>
<%@ page import="egurkha.EgDbAdapterUI"%>
<%@ page import="com.eg.EgDbAdapterTypeUI"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<jsp:useBean id="trans" scope="page" class="egurkha.TransactionBean" />
<egui:skin ui="monitor"/>
<style>
select {
    padding:3px;
    margin: 0;
    -webkit-border-radius:0px;
    -moz-border-radius:0px;
    border-radius:0px;
    /*-webkit-box-shadow: 0 3px 0 #ccc, 0 -1px #fff inset;
    -moz-box-shadow: 0 3px 0 #ccc, 0 -1px #fff inset;
    box-shadow: 0 3px 0 #ccc, 0 -1px #fff inset;*/
    background: #fff;
	background:url("../images/Light/form_input_buttons.png") no-repeat scroll 165px 1px #fff;
    color:#000;
    border-color:#abb2bd;
	border-style:solid;
	border-width:1px 1px 1px 1px;
    display: inline-block;
    -webkit-appearance:none;
    -moz-appearance:none;
    appearance:none;
    cursor:pointer;
	position: relative; 

	&:focus {
    z-index: 3;
    width: 100%;
    color: red;
    outline: 2px solid #49aff2;
    outline: 2px solid -webkit-focus-ring-color;
    outline-offset: -2px;
  }
	> option {
    margin: 3px;
    padding: 6px 8px;
    text-shadow: none;
    background: red;
    border-radius: 3px;
    cursor: pointer;
  }
}

/* Targetting Webkit browsers only. FF will show the dropdown arrow with so much padding. */
@media screen and (-webkit-min-device-pixel-ratio:0) {
    select {padding-right:18px}
}

label {position:relative;padding:2px}
label:after {
    content:'<>';
    font:11px "LucidaGrandeRegular";
    color:#aaa;
    -webkit-transform:rotate(90deg);
    -moz-transform:rotate(90deg);
    -ms-transform:rotate(90deg);
    transform:rotate(90deg);
    right:8px; top:2px;
    padding:0 0 2px;
    border-bottom:1px solid #ddd;
    position:absolute;
    pointer-events:none;
}
label:before {
    content:'';
    right:6px; top:0px;
    width:20px; height:20px;
    background:#f8f8f8;
	padding:2px 0 0,
    position:absolute;
    pointer-events:none;
    display:block;
}
select::-ms-expand {
    display: none; /* hide default arrow in IE10 */
}

.option{

	padding:2px;
	height:20px;
	background:green

}
option[selected="selected"] {
    /*css style here*/
	padding:2px;
	height:20px;
	background:red
}
</style>
<script type="text/javascript">
	function showThreadDetails(param1, param2, param3,param4)
	{
		parent.showThreadDetails(param1,param2,param3,param4);
	}
</script>

<%
	String ua = request.getHeader( "User-Agent" );
	boolean isFirefox = ( ua != null && ua.indexOf( "Firefox/" ) != -1 );
	String data = request.getParameter("details");
	String measureTime = request.getParameter("time"); 
	String measure = request.getParameter("measure"); 
	String testname = request.getParameter("test"); 
	String measureName = null;
	String isTable="";
	isTable = isFirefox ? "Auto" : "Fixed";
	if(data.equals("None"))
	{
%>
		<table height="100%" width="100%" border="0" class="white_bg" style="table-layout:<%=isTable%>;">
			<tr>
				<td align="center" valign="middle" class="commonErrorMsgText"> 
					<img src="/final/images/clear.png" class="iconExclamation" align="center" border="0" /><br>
					<egui:intnl text='monitor.layermodel.No details for this measure !! '/>
				</td>
			</tr>
		</table>
<%
	}
	else if(measure!=null && measure.length() > 0)
	{
		ArrayList displayList = StringUtils.egTokenizer(data,"#~#");
		boolean isMsSqlSysTest = false;
		boolean isMsSqlConnTest = false;
		boolean isSybSysTest = false;
		boolean isOraSessionTest = false;
		boolean isOraConnectionsTest = false;
		int dispSize = displayList.size();
		if(testname!=null && testname.length() > 0)
		{
			if(testname.equals("MsSqlSysProcsTest"))
				isMsSqlSysTest = true;
			else if(testname.equals("MsSqlConnsTest"))
				isMsSqlConnTest = true; 
			else if(testname.equals("SybSysProcessTest"))
				isSybSysTest = true;
			else if(testname.equals("OraSessionTest"))
				isOraSessionTest = true;
			else if(testname.equals("OraConnectionsTest"))
				isOraConnectionsTest = true;
		}

		int index = 0;
		String Spid = null;
		String User = null;
		String DB = null;
		String Host = null;
		String Program = null;
		String Login = null;
		String LastBatch = null;
		String Waittime= null;
		String Waittype = null;
		String SpidBlocking = null;
		String Trans = null;
		String Phy = null;
		String Mem = null;
		String Idletime = null;
		String LastCmd = null;
		String status = null;
		String cpu =  null;
		String blockedTime = null;
		String Serial = null;
		String OsUser = null;
		String Terminal = null;
		String Module = null;
		String LastCall = null;

		if(isMsSqlSysTest || isMsSqlConnTest)
		{
			Spid = (String)displayList.get(index++);
			if(isMsSqlSysTest){
				User = (String)displayList.get(index++);
			}
			DB = (String)displayList.get(index++);
			Host = (String)displayList.get(index++);
			Program = (String)displayList.get(index++);
			Login = (String)displayList.get(index++);
			LastBatch = (String)displayList.get(index++);
			Waittime= (String)displayList.get(index++);
			Waittype = (String)displayList.get(index++);
			SpidBlocking = (String)displayList.get(index++);
			Trans = (String)displayList.get(index++);
			Phy = (String)displayList.get(index++);
			Mem = (String)displayList.get(index++);
			Idletime = (String)displayList.get(index++);
			LastCmd = (String)displayList.get(index++);
		}
		else if(isSybSysTest)
		{
			Spid = (String)displayList.get(index++);
			status = (String)displayList.get(index++);
			User = (String)displayList.get(index++);
			DB = (String)displayList.get(index++);
			Host = (String)displayList.get(index++);
			Program = (String)displayList.get(index++);
			SpidBlocking = (String)displayList.get(index++);
			blockedTime = (String)displayList.get(index++);
			cpu	= (String)displayList.get(index++);
			Phy = (String)displayList.get(index++);
			Mem = (String)displayList.get(index++);
			LastCmd = (String)displayList.get(index++);
		}
		else if(isOraSessionTest || isOraConnectionsTest)
		{
			Spid = (String)displayList.get(index++);
			Serial = (String)displayList.get(index++);
			if(isOraSessionTest)
				User = (String)displayList.get(index++);
			OsUser = (String)displayList.get(index++);
			Host = (String)displayList.get(index++);
			Terminal = (String)displayList.get(index++);
			Program = (String)displayList.get(index++);
			Module = (String)displayList.get(index++);
			LastCall = (String)displayList.get(index++);
			SpidBlocking = (String)displayList.get(index++);
			LastCmd = (String)displayList.get(index++);
		}

		boolean isLink = false;
		StringBuffer resultBuffer = new StringBuffer();
		//out.println("measure :"+ measure);
		int blockingValue = 0;
		if(SpidBlocking!=null && SpidBlocking.length() > 0)
		{
			try
			{
				blockingValue = Integer.parseInt(SpidBlocking);
			}
			catch(Exception e)
			{
				blockingValue = 0;
			}
		}

		if(blockingValue > 0)
		{
			isLink = true;
		}

		if(isLink)
		{
			IniFile UIni =  new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini", false);
			String currentDateFormat = UIni.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
			String date = measureTime.substring(0,measureTime.indexOf(" "));
			date = DateUtil.changeDateFormat(date,currentDateFormat,"MM/dd/yyyy");
			String time = measureTime.substring(measureTime.indexOf(" ")+1);
			if(time!=null && time.endsWith(".0"))
				time = time.substring(0,time.lastIndexOf("."));
			String dbMeasureTime = date+" "+time;

			StringBuffer sb = new StringBuffer();
			StringBuffer adapterTypeBuffer = new StringBuffer();

			if(EgDbInfo.checkDBType().equals("EgMsSqlAdapter"))
			{
				adapterTypeBuffer.append(" where MSMT_TIME = CONVERT (datetime, '");
				adapterTypeBuffer.append(dbMeasureTime);
				adapterTypeBuffer.append("', 103)"); 
			}
			else
			{
				adapterTypeBuffer.append(" where MSMT_TIME = TO_DATE('");
				adapterTypeBuffer.append(dbMeasureTime);
				adapterTypeBuffer.append("','MM/DD/YYYY HH24:MI:SS')");
			}

			if(isMsSqlSysTest || isMsSqlConnTest)
			{
				sb.append("select SEQ_NO, MSMT_TIME, MEASURE,SPID,");
				if(isMsSqlSysTest){
					sb.append("USER_NAME,");
				}
				sb.append(" DB_NAME, HOST_NAME, PROGRAM_NAME, LOGIN_TIME, LAST_EXE_TIME, WAIT_TIME, WAIT_TYPE, BLOCKING_SPID, OPEN_TRANS,PHYSICAL_IO,MEM_USAGE,IDLE_TIME,COMMAND from ");
				if(isMsSqlConnTest)
					sb.append(" MsSqlConnsTest_DDD");
				else
					sb.append(" MsSqlSysProcsTest_DDD");
				sb.append(adapterTypeBuffer.toString());
				sb.append(" and spid = '"+SpidBlocking+"'");
				sb.append(" ORDER BY SEQ_NO ASC");
			}
			else if(isSybSysTest)
			{
				sb.append("select SEQ_NO, MSMT_TIME, MEASURE,SPID,STATUS,USER_NAME,DB_NAME,HOST_NAME,PROGRAM_NAME,BLOCKING_SPID,TIME_BLOCKED,CPU,PHYSICAL_IO,MEM_USAGE,COMMAND from ");
				sb.append(" SybSysProcessTest_DDD ");
				sb.append(adapterTypeBuffer.toString());
				sb.append(" and spid = '"+SpidBlocking+"'");
				sb.append(" ORDER BY SEQ_NO ASC");
			}
			else if(isOraSessionTest || isOraConnectionsTest)
			{
				sb.append("SELECT SEQ_NO, MSMT_TIME, MEASURE , SID ,SERIAL ,");
				if(isOraSessionTest)
					sb.append(" USER_NAME, ");
				sb.append("OS_USER, MACHINE_NAME , TERMINAL_NAME, PROGRAM_NAME , MODULE , LAST_CALL, BLOCKING_SPID , COMMAND FROM ");
				if(isOraSessionTest)
					sb.append(" OraSessionTest_DDD ");
				else
					sb.append(" OraConnectionsTest_DDD ");
				sb.append(adapterTypeBuffer.toString());
				sb.append(" and SID = '"+SpidBlocking+"'");
				sb.append(" ORDER BY SEQ_NO ASC");
			}
			String query = sb.toString();
			//System.out.println("query (Sql Process):"+query);

			EgDbAdapterUI egDb = EgDbAdapterTypeUI.getObject();
			try
			{
				String s_status = egDb.setConnection();
				if(s_status.equals("CONNECTED"))
				{
					ResultSet rs = egDb.dbselect(query);
					ResultSetMetaData md = rs.getMetaData();
					int columns = md.getColumnCount();

					int segNo = -1;
					boolean isEnd = false;
					//if(isMsSqlSysTest || isMsSqlConnTest || isSybSysTest )
					//{
						while(rs.next())
						{
							int row = rs.getRow();
							if(row == 1)
							{
								for(int i=1;i<=columns;i++)
								{
									String colName = md.getColumnName(i);
									if(colName.equalsIgnoreCase("SEQ_NO"))
									{
										segNo= rs.getInt(colName);
									}
									else if(colName.equalsIgnoreCase("Measure"))
									{
										measureName = (String)rs.getObject(colName);
									}
									else if(colName.equalsIgnoreCase("command"))
									{
										String command = (String)rs.getObject(colName);
										if(command!=null && command.endsWith("~#~"))
										{
											command = command.substring(0,command.lastIndexOf("~#~"));
											resultBuffer.append(command);
										}
										else
										{
											resultBuffer.append(command);
											isEnd = true;
										}
									}
									else if(i>3)
									{
										String resultData = rs.getObject(colName).toString();
										resultBuffer.append(resultData);
										resultBuffer.append("#~#");
									}
								}
							}
							else
							{
								int nextSegNo = rs.getInt("SEQ_NO");
								String nextMeasure  = (String)rs.getObject("Measure");
								if(nextSegNo == (segNo+1) && nextMeasure.equals(measureName))
								{
									String command = (String)rs.getObject("command");
									if(command!=null && command.endsWith("~#~"))
									{
										command = command.substring(0,command.lastIndexOf("~#~"));
										resultBuffer.append(command);
										segNo = nextSegNo;
									}
									else
									{
										resultBuffer.append(command);
										isEnd = true;
									}
								}
								else
								{
									isEnd = true;
								}
							}
							if(isEnd)
								break;
						}
					//}
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception Occured.......in SqlProcess.jsp :"+e.getMessage());
				//e.printStackTrace();
				resultBuffer = new StringBuffer();
			}
			finally
			{
				egDb.releaseConnection(false);
				EgDbAdapterTypeUI.releaseObject(egDb);
			}
		}
		String headStr = "monitor.layermodel.Spid";
		if(isOraSessionTest || isOraConnectionsTest)
			headStr = "monitor.layermodel.SID";
%>
		<div style="float:left; border:0px solid red;width:100%">
		<table align="left" cellspacing="0" cellpadding="4" border="0" class="jtm_table jtm_DatapanelBody" width="100%"  style="table-layout:auto"> <col width="140"><col width="400">
			<tr class="jtm_bottomBorder">
				<td class="jtm_InnerHeader" align="Left" valign="top"><egui:intnl text='<%=headStr%>'/></td>
				<td valign="top"> 
					<table align="left" cellspacing="0" cellpadding="0" border="0">
						<tr>
							<td valign="top"><%=Spid%>&nbsp;</td>
<%
					if(isLink && resultBuffer.length() > 0)
					{
						String resultStr = forHTML(resultBuffer.toString());
						if(measureName==null) measureName = "Blocked_processes";
%>
							<td align="Left" valign="top">
								<a href="javascript:void(0);" class="qin_link" style="text-decoration:underline" onclick="javascript:showThreadDetails('<%=resultStr%>','<%=measureTime%>','<%=measureName%>','<%=testname%>');"><egui:intnl text='monitor.layermodel.blocked by '/><%=SpidBlocking%></a>
							</td>
<%
					}
					else if(isLink)
					{
%>
							<td valign="top"><egui:intnl text='monitor.layermodel.blocked by '/><%=SpidBlocking%> </td>
<%
					}
%>
						</tr>
					</table>
				</td>
			</tr>
<%
		Hashtable result = new Hashtable();
		ArrayList headingList = new ArrayList();
		if(isMsSqlSysTest || isMsSqlConnTest )
		{
			if(isMsSqlSysTest)
			{
				headingList.add("User"); result.put("User",User);
			}
			headingList.add("DB");					result.put("DB",DB);
			headingList.add("Host");				result.put("Host",Host);
			headingList.add("Program Name");		result.put("Program Name",Program);
			headingList.add("Login time");			result.put("Login time",Login);
			headingList.add("Last Execution time");	result.put("Last Execution time",LastBatch);
			headingList.add("Waittime(msecs)");		result.put("Waittime(msecs)",Waittime);
			headingList.add("Waittype");			result.put("Waittype",Waittype);
			headingList.add("Trans nesting level");	result.put("Trans nesting level",Trans);
			headingList.add("Physical io");			result.put("Physical io",Phy);
			headingList.add("Mem usage(pages)");	result.put("Mem usage(pages)",Mem);
			headingList.add("Idle time(min)");		result.put("Idle time(min)",Idletime);
		}
		else if(isSybSysTest)
		{
			headingList.add("Status");			result.put("Status",status);
			headingList.add("User");			result.put("User",User);
			headingList.add("DB");				result.put("DB",DB);
			headingList.add("Host");			result.put("Host",Host);
			headingList.add("Program Name");	result.put("Program Name",Program);
			if(!blockedTime.equals("-"))
			{
				headingList.add("Blocked time");	result.put("Blocked time",blockedTime);
			}
			headingList.add("Cpu(ticks)");		result.put("Cpu(ticks)",cpu);
			headingList.add("Physical io");		result.put("Physical io",Phy);
			headingList.add("Mem usage(pages)");result.put("Mem usage(pages)",Mem);
		}
		else if(isOraSessionTest || isOraConnectionsTest)
		{
			headingList.add("Serial#");			result.put("Serial#",Serial);
			if(isOraSessionTest){
				headingList.add("User");		result.put("User",User);
			}
			headingList.add("OS User");			result.put("OS User",OsUser);
			headingList.add("Host");			result.put("Host",Host);
			headingList.add("Terminal Name");	result.put("Terminal Name",Terminal);
			headingList.add("Program");			result.put("Program",Program);
			headingList.add("Module");			result.put("Module",Module);
			headingList.add("Last call(Sec)");		result.put("Last call(Sec)",LastCall);
		}

		for(int k=0;k<headingList.size();k++)
		{
			String headString = (String) headingList.get(k);
			String displayString = (String)result.get(headString);
			headString = "monitor.layermodel."+headString;
%>
			<tr class="jtm_bottomBorder">
				<td class="jtm_InnerHeader" align="Left" valign="top"><egui:intnl text='<%=headString%>'/></td>
				<td valign="top"><%=displayString%></td>
			</tr>
<%
		}
%>
		</table>
		</div>

		<div style="float:left;width:100%;margin-top:8px" class="jtm_DatapanelBody">
		<table align="left" cellspacing="0" cellpadding="4" border="0" class="jtm_table" width="100%"  style="table-layout:fixed">
			<tr>
				<td class="jtm_InnerHeader" align="Left" valign="top"><egui:intnl text='monitor.layermodel.LastCommand'/></td>
			</tr>
			<tr>
				<td class="tdborder_jvm padding2" valign="top" style="word-wrap: break-word;line-height:15px"><%=LastCmd%></td>
			</tr>
		</table>
		<div style="clear:both"></div>
		</div>
<%
	}
%>

<%!
	public String forHTML(String resultStr)
	{
		while(resultStr.indexOf(">")  > 0){
			resultStr = resultStr.replace(">","&gt;");
		}
		while(resultStr.indexOf("\"") > 0){
			resultStr = resultStr.replace("\"","&quot;");
		}
		while(resultStr.indexOf("<")  > 0){
			resultStr = resultStr.replace("<","&lt;");
		}
		return resultStr;
	}
%>
