<%
/********************************************************************************************************
*	Name			:	simulationGraph.jsp
*	Purpose			:	This is used to display Graph for Logon Simulator
*	Version			:	6.2.1
*	CreationDate	:	oct 27 2016
*******************************************************************************************************/
%>
<%@ include file = "EgMonitorTracker.jsp" %>
		
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.egurkha.util.DateUtil" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import = "com.eg.*" %>
<%@ page import = "egurkha.EgDbAdapterUI"%>
<%@ page import = "java.sql.*" %>
<%@ page import = "com.eg.EgDbAdapterTypeUI"%>
<%@ page import = "com.egurkha.monitor.alarms.AlarmPriorities" %>
<%@ page import = "com.eg.EgTopoInfo"%>
<%@ page import = "java.util.*" %>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "com.egurkha.ini.*" %>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.EgGroupInfo" %>
<%@ page errorPage = "EgProbsM.jsp"%>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import = "java.text.SimpleDateFormat"%>
<%@ page import = "com.egurkha.util.EgSorter"%>
<%@ page import ="com.eg.EgTablesInfo" %>
<%@ page import ="com.eg.EgDiscInfo" %>
<%@ page import = "com.egurkha.util.StringUtils"%>

<%@ page import="net.sf.json.*"%>
<%@ page import = "com.egurkha.User"%>
<%@ page import="egurkha.reporter.ErUtils"%>
<%@ page import="com.egurkha.*" %>
<%@ page import="com.egurkha.EgTimeZoneConverter" %>
<%@ page import = "com.egurkha.UserRegistry"%>


<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");
	request.setCharacterEncoding("UTF-8");
try
{
	EgTopoInfo topoinfo = new EgTopoInfo("manager");
	EgDbInfo dbInfo = new EgDbInfo("manager");

	String siteName = request.getParameter("site");
	String timeline=request.getParameter("time_line");
	String s_st_time = request.getParameter("starttime");
	String s_en_time = request.getParameter("endtime");
	String s_st_hr = request.getParameter("starthr");
	String s_en_hr = request.getParameter("endhr");
	String s_st_min = request.getParameter("startmin");
	String s_en_min = request.getParameter("endmin");
	String mHost = request.getParameter("mHost");
	if(mHost == null || mHost.trim().length() == 0)
		mHost = "";
	String comFormat="";
	String dispDate = null;
	String StrDate="";
	User user = u_ser;
	EgDateInfo edi = new EgDateInfo();

	String uiFile = "eg_ui.ini";
	String iniFileDir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(iniFileDir + uiFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	com.eg.IniFile egDashConfig = new com.eg.IniFile(iniFileDir+"eg_dashboardConfig.ini");
	String exclude_infos="";
	String exclude_info_str=egDashConfig.getValue("TREE_SYSTEM_SETTINGS","EXCLUDED_DESCRIPTORS");
	if(exclude_info_str!=null && exclude_info_str.length()>0)
	{
		StringTokenizer tokenizer1 = new StringTokenizer(exclude_info_str,",");
		while(tokenizer1.hasMoreTokens())
		{
			String descriptors = tokenizer1.nextToken();
			if(descriptors!=null && descriptors.trim().length()>0)
			{
				descriptors = descriptors.trim();
				if(descriptors.startsWith("+"))
				{
					exclude_infos += ",'"+descriptors+"'";
				}
				else
				{
					exclude_infos += ",'+"+descriptors+"'";
				}
			}
		}
	}

	if(exclude_infos!=null && exclude_infos.trim().length()>0 && exclude_infos.startsWith(","))
	{
		exclude_infos=exclude_infos.substring(1);
	}

	if(exclude_infos==null || exclude_infos.trim().length()==0)
		exclude_infos="'+_Total','+Summary','+Total','+_BACKGROUND','+All'";
	
	String testForTab = "CtxXcXALogonSimTest";

	String[] options = {"Any","1 hour","3 hours","6 hours","9 hours","12 hours","15 hours","18 hours","21 hours","24 hours","2 days","3 days","4 days","5 days","6 days","1 week","2 weeks","3 weeks","4 weeks","1 month","2 months"};


	if(timeline==null)
	{
		timeline="1 hour";
	}

	String startDateTime="";
	String endDateTime="";
	if(timeline!=null && !timeline.equals("Any"))
	{
		int blankSpaceIndex = timeline.indexOf(DateTimeTokenizer.BLANK_SPACE);
		if (blankSpaceIndex > 0)
		{
			SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm");
			java.util.Date today = edi.egetRealDate();
			endDateTime = sdf.format(today);
			int value = Integer.parseInt(timeline.substring(0, blankSpaceIndex));
			String unit = timeline.substring(blankSpaceIndex+1).toLowerCase();
			long longValue=0;
			if (unit.startsWith("h"))
			{//hours
				longValue=(long)value * 3600;
			}
			else if (unit.startsWith("d"))
			{//days
				longValue=(long)value*(24 * 3600);
			}
			else if (unit.startsWith("w"))
			{//weeks
				longValue=(long)value* (7 * 24 * 3600);
			}
			else if (unit.startsWith("mo"))
			{//months
				//value *= (30 * 24 * 3600);
				longValue=(long)value*(24*(ErUtils.getMaxDaysInMonth()) * 3600);
			}
			//longValue=value;
			java.util.Date start = edi.egetRealDate();
			start.setTime(today.getTime() - (longValue * 1000));
			startDateTime = sdf.format(start);
		}
		if ((startDateTime != null) && (endDateTime != null))
		{

			int shr = Integer.parseInt(startDateTime.substring(startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, startDateTime.indexOf(":")));  
			int smin=Integer.parseInt(startDateTime.substring(startDateTime.indexOf(":")+1));
			int en_hr = Integer.parseInt(endDateTime.substring(endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, endDateTime.indexOf(":")));
			int emin=Integer.parseInt(endDateTime.substring(endDateTime.indexOf(":")+1));


			s_en_time=endDateTime.substring(0, endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
			s_st_time=startDateTime.substring(0, startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
			s_st_hr = String.valueOf(shr);
			s_en_hr = String.valueOf(en_hr);
			s_st_min = String.valueOf(smin);
			s_en_min = String.valueOf(emin);
		}
	}
	String disable="";
	if(timeline!=null&&!timeline.equals("Any"))
	{
		disable ="disabled";
	}
	if(timeline!=null && timeline.equals("Any"))
	{
		StrDate="";
		try
		{
			java.text.SimpleDateFormat df=new java.text.SimpleDateFormat("MM/dd/yyyy k 'at' hh:mm");
			StrDate =df.format(edi.egetRealDate());
		}
		catch(Exception ee)
		{
			System.out.println("Exception is------>"+ee);
		}
		String SDate =StrDate.substring(0,StrDate.indexOf(" "));
		String shour =StrDate.substring(StrDate.indexOf(" "),StrDate.lastIndexOf(""));
		shour = shour.substring(0,3);

		String smin = StrDate.substring(StrDate.indexOf(":")+1);
		String emin=smin;
		if(s_st_time==null)
		{
			s_st_time=SDate;
		}
		if(s_en_time==null)
		{
			s_en_time=SDate;
		}
		if(s_st_hr==null)
		{
			shour =shour.trim();
			int starthr = Integer.parseInt(shour);
			starthr = starthr-1;
			s_st_hr=String.valueOf(starthr);
		}
		if(s_en_hr==null)
		{
			shour =shour.trim();
			s_en_hr =shour;
		}

		if(s_st_min==null)
		{
			smin =smin.trim();
			int startmin = Integer.parseInt(smin);
			
			s_st_min=String.valueOf(startmin);
		}
		if(s_en_min==null)
		{
			emin =emin.trim();
			int endmin = Integer.parseInt(emin);
			
			s_en_min=String.valueOf(endmin);
		}
	}
	
	if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
	{
		comFormat = "MM/dd/yyyy";
	}
	else
	{
		comFormat = currentDateFormat;
	}
	s_st_time = DateUtil.changeDateFormat(s_st_time,comFormat,"MM/dd/yyyy");
	if(DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
	{
		comFormat = "MM/dd/yyyy";
	}
	else
	{
		comFormat = currentDateFormat;
	}
	s_en_time = DateUtil.changeDateFormat(s_en_time,comFormat,"MM/dd/yyyy");

	JSONObject json = new JSONObject();
	JSONObject hiddenFields = new JSONObject();
	//hiddenFields.put("selectedTab",defaultTab);
	hiddenFields.put("testForTab",testForTab);
	hiddenFields.put("sitename",EgURLEncoder.encode(siteName,"UTF-8"));

	String all_trans_names="";
	String connectionStatus = null;

	String compName = request.getParameter("componentNameSearch");
	//String compName = "";
	String Comptype = "Citrix_XcLogon_Emulation";
	if((compName == null || compName.trim().length() == 0) && siteName != null){
		Vector secs = topoinfo.getAssociatesForSite(siteName);
		if(secs != null && secs.size() > 0){
			for(int i=0;i<secs.size();i++){
				String val = (String) secs.get(i);
				if(val.indexOf("Citrix_XcLogon_Emulation") != -1){
					String tmp_Comptype = val.substring(0,val.indexOf(":"));
					String tmp_compName = val.substring(val.indexOf(":")+1);

					if(Comptype==null || Comptype.trim().length()==0)
					{
						Comptype = tmp_Comptype;
					}

					if(compName==null || compName.trim().length()==0)
					{
						compName = tmp_compName;
					}
				}
			}
		}
	}
	String tmpCompName = "";
	if(compName !=null && compName.trim().length() > 0 && compName.indexOf(":") > 0)
		tmpCompName = compName.substring(0,compName.indexOf(":"));

	EgDbAdapterUI egDb = EgDbAdapterTypeUI.getObject();
	connectionStatus = egDb.setConnection();
	ResultSet rs = egDb.getInfoForSimulation(testForTab,tmpCompName,exclude_infos,mHost);
	if(rs!=null)
	{
		while(rs.next())
		{
			String info = rs.getString("Info");
			if(info != null && info.length() > 0)
				all_trans_names += ","+info;
		}
	}

	if(rs!=null)
	{
		try 
			{
				rs.close();
			}
			catch (Exception bug123) {}
	}

	if(all_trans_names != null && all_trans_names.length() > 0)
		all_trans_names = all_trans_names.substring(1);


	hiddenFields.put("all_trans_names",all_trans_names);
	//hiddenFields.put("transSize",v_trans.size());

	JSONObject graphLabels = new JSONObject();
	graphLabels.put("GraphHeader",mappingInfo.getTextDescription("monitor.Common.Graphs"));
	JSONArray graphFilters = new JSONArray();
		
	String iniIdentity = "monitor.transaction.";
	JSONObject timelineSelect = new JSONObject();
	timelineSelect.put("type","combo");
	timelineSelect.put("combo","timeline");
	timelineSelect.put("label",mappingInfo.getTextDescription(iniIdentity+"Timeline"));		
	
	JSONArray timelineOptionsArray = new JSONArray();
	for(int e_ctr=0; e_ctr < options.length;e_ctr++)
	{
		JSONObject timelineOptions = new JSONObject();
		if(timeline!=null&&timeline.equals((String)options[e_ctr]))
		{
			String tempOptions="";
			String tempOptions2="";
			if(timeline.indexOf(" ")>-1)
			{
				tempOptions2=timeline.substring(0,timeline.indexOf(" "))+" ";
				tempOptions=timeline.substring(timeline.indexOf(" ")+1);	
			}
			else
			{
				tempOptions=timeline;
			}
			
			timelineOptions.put("value",timeline);
			timelineSelect.put("selectedValue",timeline);
			hiddenFields.put("timeline",timeline);
			timelineOptions.put("name",tempOptions2+mappingInfo.getTextDescription("monitor.common."+tempOptions));
		}
		else
		{
			String tempOptions="";
			String tempOptions2="";
			if(options[e_ctr].indexOf(" ")>-1)
			{
				tempOptions2=options[e_ctr].substring(0,options[e_ctr].indexOf(" "))+" "; tempOptions=options[e_ctr].substring(options[e_ctr].indexOf(" ")+1);	
			}
			else
			{
				tempOptions=options[e_ctr];
			}
			timelineOptions.put("value",options[e_ctr]);				
			timelineOptions.put("name",tempOptions2+mappingInfo.getTextDescription("monitor.common."+tempOptions));
		}
		timelineOptionsArray.add(timelineOptions);
	}
	timelineSelect.put("options",timelineOptionsArray);
	graphFilters.add(timelineSelect);
	JSONObject fromField = new JSONObject();
	fromField.put("type","date");
	fromField.put("field","from");
	fromField.put("label",mappingInfo.getTextDescription("monitor.common.From"));
	fromField.put("dateError",mappingInfo.getTextDescription("monitor.layermodel.Start date should be lesser than end date"));
	String loginUserStartDateTime = "";

	if(s_st_time!=null && !s_st_time.equals(""))
	{
		if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
		{
			comFormat = "MM/dd/yyyy";
			//fromField.put("dateFormat","MM/dd/yyyy");
			fromField.put("dateFormat",dateFormatForDatePicker);
		}
		else
		{
			comFormat = currentDateFormat;
			fromField.put("dateFormat",dateFormatForDatePicker);
		}
		dispDate = DateUtil.changeDateFormat(s_st_time,comFormat,currentDateFormat);
		
		String userDateFormat = dispDate+" "+s_st_hr+":"+s_st_min+":00";

		EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(userDateFormat,user);
		loginUserStartDateTime = (String)timeZoneConverter.getDate(false);
		s_st_hr = (String)timeZoneConverter.getHour();
		s_st_min = (String)timeZoneConverter.getMinute();
	}
	else
	{
		dispDate = "";
	}
	fromField.put("value",loginUserStartDateTime);
	hiddenFields.put("starttime",s_st_time);
	fromField.put("hidden",s_st_time);
	graphFilters.add(fromField);
	
	JSONObject fromHrsField = new JSONObject();
	fromHrsField.put("type","combo");
	fromHrsField.put("combo","fromhr");
	fromHrsField.put("label",mappingInfo.getTextDescription("monitor.common.Hr"));		
	
	JSONArray fromHrsOptionsArray = new JSONArray();	
	for (int s_ctr = 0; s_ctr < 24; s_ctr++)
	{
		JSONObject fromOption = new JSONObject();
		if (s_ctr == Integer.parseInt(s_st_hr))
		{
			fromOption.put("name",s_st_hr);
			fromOption.put("value",s_st_hr);
			fromHrsField.put("selectedValue",s_st_hr);
			hiddenFields.put("startHr",s_ctr);
		}
		else
		{
			fromOption.put("name",s_ctr);
			fromOption.put("value",s_ctr);				
		}
		fromHrsOptionsArray.add(fromOption);
	}
	fromHrsField.put("options",fromHrsOptionsArray);
	graphFilters.add(fromHrsField);

	JSONObject fromMinField = new JSONObject();
	fromMinField.put("type","combo");
	fromMinField.put("combo","frommin");
	fromMinField.put("label",mappingInfo.getTextDescription("monitor.common.Min"));	
	JSONArray fromMinOptionsArray = new JSONArray();		
	
	for (int s_ctr = 0; s_ctr < 60; s_ctr++)
	{
		JSONObject fromMinOption = new JSONObject();
		if (s_ctr == Integer.parseInt(s_st_min))
		{
			fromMinOption.put("name",s_st_min);
			fromMinOption.put("value",s_st_min);
			fromMinField.put("selectedValue",s_st_min);
			hiddenFields.put("startMin",s_ctr);
		}
		else
		{
			fromMinOption.put("name",s_ctr);
			fromMinOption.put("value",s_ctr);				
		}
		fromHrsOptionsArray.add(fromMinOption);
	}
		fromMinField.put("options",fromMinOptionsArray);
		graphFilters.add(fromMinField);

	JSONObject toField = new JSONObject();
	toField.put("type","date");
	toField.put("field","to");
	toField.put("label",mappingInfo.getTextDescription("monitor.common.To"));		
	toField.put("dateError",mappingInfo.getTextDescription("monitor.layermodel.From and To date should be lesser than current date"));
	
	if(s_en_time!=null && !s_en_time.equals(""))
	{
		if(DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
		{
			comFormat = "MM/dd/yyyy";
			toField.put("dateFormat",dateFormatForDatePicker);
		}
		else
		{
			comFormat = currentDateFormat;
			toField.put("dateFormat",dateFormatForDatePicker);
		}
		dispDate = DateUtil.changeDateFormat(s_en_time,comFormat,currentDateFormat);
		String userDateFormat = dispDate+" "+s_en_hr+":"+s_en_min+":00";

		EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(userDateFormat,user);
		loginUserStartDateTime = (String)timeZoneConverter.getDate(false);
		s_en_hr = (String)timeZoneConverter.getHour();
		s_en_min = (String)timeZoneConverter.getMinute();
	}
	else
	{
		dispDate = "";
	}
	toField.put("value",loginUserStartDateTime);
	hiddenFields.put("endtime",s_en_time);
	toField.put("hidden",s_en_time);
	graphFilters.add(toField);

	JSONObject toHrsField = new JSONObject();
	toHrsField.put("type","combo");
	toHrsField.put("combo","tohr");
	toHrsField.put("label",mappingInfo.getTextDescription("monitor.common.Hr"));					
	
	JSONArray toHrsOptionsArray = new JSONArray();		
	for (int e_ctr = 0; e_ctr < 24; e_ctr++)
	{
		JSONObject toOption = new JSONObject();
		if (e_ctr == Integer.parseInt(s_en_hr))
		{
			toOption.put("name",s_en_hr);
			toOption.put("value",s_en_hr);
			toHrsField.put("selectedValue",s_en_hr);	
			hiddenFields.put("endHr",e_ctr);
		}
		else
		{
			toOption.put("name",e_ctr);
			toOption.put("value",e_ctr);				
		}
		toHrsOptionsArray.add(toOption);
	} 
	toHrsField.put("options",toHrsOptionsArray);
	graphFilters.add(toHrsField);

	JSONObject toMinField = new JSONObject();
	toMinField.put("type","combo");
	toMinField.put("combo","tomin");
	toMinField.put("label",mappingInfo.getTextDescription("monitor.common.Min"));					
	
	JSONArray toMinOptionsArray = new JSONArray();		
	 for (int e_ctr = 0; e_ctr < 60; e_ctr++)
	{
		JSONObject toMinOption = new JSONObject();
		if (e_ctr == Integer.parseInt(s_en_min))
		{
			toMinOption.put("name",s_en_min);
			toMinOption.put("value",s_en_min);
			toMinField.put("selectedValue",s_en_min);	
			hiddenFields.put("endMin",e_ctr);
		}
		else
		{
			toMinOption.put("name",e_ctr);
			toMinOption.put("value",e_ctr);				
		}
		toMinOptionsArray.add(toMinOption);
	} 
	toMinField.put("options",toMinOptionsArray);
	graphFilters.add(toMinField);

	JSONObject modeFilter = new JSONObject();
	modeFilter.put("type","combo");
	modeFilter.put("label",mappingInfo.getTextDescription("monitor.common.Mode"));
	
	String mode = request.getParameter("mode");
	if(mode!=null && mode.equalsIgnoreCase("add"))
	{
		mode="";
	}
	String select2d="";
	String select3d="";
	boolean use3DGraphs = com.egurkha.ini.IniUI.getInstance().use3DGraphs(com.egurkha.ini.IniUI.MONITOR);
	

	if(mode!=null&&!mode.equals(""))
	{
		if(mode.equals("2D"))
			select2d="selected";
		
		if(mode.equals("3D"))
			select3d="selected";
	}
	else
	{
		if(use3DGraphs)
			select3d="selected";
		else
			select2d="selected";
	}
		JSONArray modeOptions = new JSONArray();	
		JSONObject modeoption2d = new JSONObject();
		modeoption2d.put("value","2D");
		modeoption2d.put("name",mappingInfo.getTextDescription("monitor.common.2D"));
		
		modeOptions.add(modeoption2d);
		
		JSONObject modeoption3d = new JSONObject();
		modeoption3d.put("value","3D");
		modeoption3d.put("name",mappingInfo.getTextDescription("monitor.common.3D"));
		
		modeOptions.add(modeoption3d);
		
		modeFilter.put("options",modeOptions);
		
		String selectedValue="3D";
		if(select2d.equals("selected")){
			selectedValue="2D";
		}
		modeFilter.put("selectedValue",selectedValue);
		hiddenFields.put("mode",selectedValue);
		modeFilter.put("combo","mode");
		graphFilters.add(modeFilter);
	
	JSONObject graphBtn = new JSONObject();
	graphBtn.put("type","button");
	graphBtn.put("label",mappingInfo.getTextDescription("monitor.common.Graph"));
	graphFilters.add(graphBtn);
	
	json.put("graphFilters",graphFilters);
	String test_name = "";
	String layer_name = "";
	String measure_list="";
	dbInfo.checkForUpdate();

	test_name = dbInfo.getTableForTest("CtxXcXALogonSimTest");
	layer_name = dbInfo.getTableForTest("CITRIX_SERVICES");

	String[] measure_name_list = dbInfo.getColumnNamesForTest(test_name,layer_name);
	
	if(measure_name_list!=null && measure_name_list.length>0)
	{
		for(int x=0;x<measure_name_list.length;x++)
		{
			String temp_measure_name=measure_name_list[x];
			if(!temp_measure_name.endsWith("_ST"))
			{
				temp_measure_name = dbInfo.getMeasureForColumn(test_name, temp_measure_name,false);
				if(temp_measure_name != null && temp_measure_name.length() > 0 && (!temp_measure_name.equalsIgnoreCase("Logoff_duration") && !temp_measure_name.equalsIgnoreCase("Total_duration")))
				{
					measure_list=measure_list+","+temp_measure_name;
				}
			}
		}
		if(measure_list!=null && measure_list.trim().length()>0 && measure_list.startsWith(","))
		{
			measure_list=measure_list.substring(1);
		}
	}

	hiddenFields.put("compName",compName);
	hiddenFields.put("compType",Comptype);
	hiddenFields.put("siteName",siteName);
	hiddenFields.put("mHost",mHost);
	hiddenFields.put("measurelst",measure_list);
	hiddenFields.put("monitorSkin",monitor_Skin);
	hiddenFields.put("currentDateFormat",currentDateFormat);
	hiddenFields.put("remoteURL",response.encodeURL("../servlet/com.eg.EgMonRemoteScriptingServlet"));
	

	try{
		egDb.releaseConnection(false);
		EgDbAdapterTypeUI.releaseObject(egDb);
	}
	catch(Exception el)
	{}

	json.put("HiddenFields",hiddenFields);
	json.put("GraphScreenLabels",graphLabels);
	response.getWriter().write(json.toString());
}
catch(Throwable e)
{
	System.out.println("EgDispTransState Error.. ");
	e.printStackTrace();
}
%>