<!DOCTYPE html>

<%
/********************************************************************************************************
*	Name			:	segmentDashboard.jsp
*	Purpose			:	This is the main jsp which includes different tabs used in the segment Dashboard and relevant scripts
*	Version			:	5.6
*	CreationDate	:	Feb 20,2012
*	Author			:	S.Saravanan
	Session remove	:	by Saravanan.A on 11/Apr/2012.
*******************************************************************************************************/
%>
<%@ include file = "EgLoginTracker.jsp"%>
<%@ page import = "com.egurkha.monitor.*"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import="com.eg.EgTopoInfo" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "com.egurkha.User"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page autoFlush="true" buffer="1094kb"%>
<%@ page import = "com.eg.supermanager.*" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import="com.eg.EgManagersIniForManager"%>

<%
	if(EgInstallInfo.isSuperManager)
	{
		String currentSession = session.getId();
		String select_Node=request.getParameter("selectNode");
		if(select_Node != null && select_Node.indexOf("^")>0)
		{
			if (select_Node.indexOf("^")>0)
			{
				select_Node = select_Node.substring(select_Node.indexOf("^")+1);
			}
			String current_thread_name = Thread.currentThread().getName();
			ArrayList managerIDs = EgElementInfo.getInstance().getManagerIDs("segment",select_Node);
			if(managerIDs != null && !managerIDs.isEmpty())
			{
				SmSessionData smsData = new SmSessionData(currentSession,managerIDs);
				EgThreadLocal egtl = new EgThreadLocal();
				egtl.set(smsData);
				new SMDateTimeConverter(managerIDs);				
			}
		}
	}

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
	request.setCharacterEncoding("UTF-8");

	SegmentListData segmentdata = (SegmentListData) request.getAttribute("data");
	SegmentListResult segmentresult = (SegmentListResult) request.getAttribute("result");
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	String optionalListPage = egUI.getValue("OptionalList_Pages","segmentList");
	boolean isFromMenu = "true".equals(request.getParameter("isFromMenu"))?true:false;

	if(segmentresult!=null && segmentresult.segmentList!=null)
	{
		session.setAttribute("SegmentListData",segmentdata);
		session.setAttribute("SegmentListResult",segmentresult);
	}
	
	if(segmentresult==null || segmentdata==null)
	{
		segmentdata  = (SegmentListData)session.getAttribute("SegmentListData");
		segmentresult=(SegmentListResult)session.getAttribute("SegmentListResult");
	}
	
	String outsideSegment=request.getParameter("outsideSegment");
	String isfromTopology=request.getParameter("isfromTopology");
	isfromTopology=(isfromTopology==null)?"false":isfromTopology;
	String segmentFromZone=request.getParameter("segmentFromZone");
	segmentFromZone=(segmentFromZone==null)?"":segmentFromZone;

	String fromHomepage = request.getParameter("fromHomepage");
	fromHomepage = (fromHomepage!=null && !fromHomepage.equalsIgnoreCase("") && !fromHomepage.equalsIgnoreCase("null") && !fromHomepage.equalsIgnoreCase("undefined"))?fromHomepage:"";
	String from = request.getParameter("from");
	String strFromService = request.getParameter("isFromService");
	strFromService=(strFromService==null || strFromService.trim().length()==0)?"false":strFromService;
	boolean isFromService=false;
	if(strFromService!=null && (strFromService.equalsIgnoreCase("true") || strFromService.equalsIgnoreCase("yes")))
	{
		isFromService=true;
	}
	String compName = (String) request.getParameter("hostName");
	String refFrequency = u_ser.getRefreshFrequency();
	long refreshFrequency=60000L;
	if(refFrequency!=null && refFrequency.length()>0)
	{
		refreshFrequency =  Long.valueOf(refFrequency).longValue() * 1000L;
	}
	IniUI ui = (IniUI)com.egurkha.ini.IniUI.getInstance();
	String thisLanguage = ui.getDefaultLanguage();
	if (u_ser!=null)
	{
		String userLang = u_ser.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}

	String sessionID = session.getId();
	UserRegistry ur = UserRegistry.getInstance();
	User user = ur.getUser(sessionID);
	EgUserRole userRole = user.getUserRole();

	boolean isAllComponentAccess = false;
	if(EgInstallInfo.isClusterSupported)
	{
		EgManagersIniForManager mi = EgManagersIniForManager.getInstance();
		if(mi.isPrimaryManager() && userRole.hasAllComponentAccess())
		{
			isAllComponentAccess = true;
		}
	}
	else if(userRole.hasAllComponentAccess())
	{
		isAllComponentAccess = true;
	}

	boolean isAdminUser = userRole.hasAnyAdminRole(EgUserPermission.ADMIN);
	EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	String titleText = mappingInfo.getTextDescription("monitor.segmentDashboard.segment");
	String selectNode = request.getParameter("selectNode");
	selectNode = (selectNode==null)?"Segment":selectNode;
	String treeFlagg = request.getParameter("treeFlag");
	treeFlagg = (treeFlagg==null)?"false":treeFlagg;
	String openNode = request.getParameter("openNode");
	String column = request.getParameter("column");
	String sortOrder = request.getParameter("sortOrder");
	String imageId = request.getParameter("imgId");
	String appcolumn = request.getParameter("appcolumn");
	String appsortOrder = request.getParameter("appsortOrder");
	String appimageId = request.getParameter("appimgId");
	String setAssociate = request.getParameter("setAssociate");
	String titleTextFrom = request.getParameter("titleText");
	//String limit=request.getParameter("limit");
	String appCurrentHost = request.getParameter("appCurrentHost");
	String aggregateComp = request.getParameter("aggregateComp");
	String currentTab = request.getParameter("currentTab");
	String topoSegment = request.getParameter("segment");
	String refresh = request.getParameter("refresh");
	String showDashboard = request.getParameter("showDashboard");
	String aggregateTab = request.getParameter("aggregateTab");
	//global search
   	String searchString=request.getParameter("searchString");
	String action = request.getParameter("action"); 
	String parentZone=request.getParameter("parentZone");
	String isFromZone = request.getParameter("isFromZone"); 
	String iszoneName = request.getParameter("iszoneName")!=null?request.getParameter("iszoneName"):""; 
        if(action != null &&  (action.equalsIgnoreCase("globalsearch") || action.equalsIgnoreCase("globalsearchallsegment")))
	{
            if(searchString!=null)
	    {
	       session.setAttribute("globalSearchLastSessionval","segment "+searchString);
	    } 
	   else
           { 
             session.setAttribute("globalSearchLastSessionval","segment *");
	   }
      }  
	//String QueryString=request.getQueryString();
	//for timeline in transaction page
	/*
	if(limit==null || limit.length()<0)
	{
		limit=egUI.getValue("TREE_SYSTEM_SETTINGS","Default");
	}
	*/
	if(setAssociate==null)
	{
		setAssociate="";
	}

	String selectedParam = request.getParameter("selectedParam");
	String treeOpen = request.getParameter("treeOpen");
	String tabText = "monitor.segmentDashboard."+ currentTab;
	String segmentTitle = "";

	if(compName !=null && compName.trim().length() > 0)
	{
		String isGroup = "Component";
		if(compName.startsWith("Group:"))
		{
			compName = compName.substring(compName.indexOf(":")+1);
			isGroup = "Group";
		}
		segmentTitle = mappingInfo.getTextDescription("monitor.serviceDashboard.Segments with which ") + compName + " " + mappingInfo.getTextDescription("monitor.serviceDashboard.is Associated");
	}
	else
	{
		segmentTitle = mappingInfo.getTextDescription("monitor.serviceDashboard.SEGMENT LIST");
	}
%>
<%
try
{
	action=(action==null)?"":action;
	 if(action!=null && action.equalsIgnoreCase("globalsearch")|| action.equalsIgnoreCase("globalsearchallsegment"))
	 {
		if(request.getQueryString()!=null)
		{
			
			session.setAttribute("globalSearchLastSessionURL","/final/monitor/segmentDashboard.jsp?"+request.getQueryString());
			
		}
		else
		{
			session.setAttribute("globalSearchLastSessionURL","/final/monitor/segmentDashboard.jsp");
		}
	}
	else
	{ 
	if(request.getQueryString()!=null)
	{
		session.setAttribute("monitorLastSession","/final/monitor/segmentDashboard.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("monitorLastSession","/final/monitor/segmentDashboard.jsp");
	}
	}
}
catch(Exception e)
{
	System.out.println("Exception in segmentDashboard..");
	e.printStackTrace();
}

String treeSession=(String)session.getAttribute("monitorLastSession");
String thisPageSession=(String)session.getAttribute("thisPageSession");
String fromPage=request.getParameter("fromPage");
String myDashboardBackUrl="";
 if(fromPage!=null && fromPage.equalsIgnoreCase("myDashboard"))
{
	String myDashboardUrlParams=request.getParameter("backBtnUrl");
	myDashboardBackUrl="/final/monitor/MyDashboard.jsp?comesFrom=myDashboard&action=showMyDashboard"+myDashboardUrlParams;
}
%>
<html class="content-frame">
	<head>
	<meta charset="utf-8" http-equiv="X-UA-Compatible" content="IE=8,9,10" >

	<script>
		var treePanelTitle="";
		var hideBackButton = null;
		var compSelectedValue=null;
		var isFromZone = '<%=isFromZone%>';
		var iszoneName = '<%=iszoneName%>';
		var parentZone = '<%=parentZone%>';
		var fromPage='<%=fromPage%>';
		var myDashboardBackUrl = '<%=myDashboardBackUrl%>';
	</script>
	<egui:skin ui="monitor"/>
	<egui:loadApp baseDir="/final/monitor/eg_scripts" appName="segments" appFile="segments.js"/>
	

	<link rel="stylesheet" type="text/css" href="../styles/jscrollpane/jquery.jscrollpane.css" media="all"/>
	<style>
		span.decimal-align{float: left; text-align: right; width:50%}
		span.decimal-align2{float: right; text-align: left; width:50%}
	</style>
	<!-- <script language="JavaScript1.2" src="/final/jquery/jquery.min.js"></script> -->
	<script src="/final/scripts/jquery-1.8.2.min.js"></script>
	<script type="text/javascript" src="../styles/jscrollpane/jquery.mousewheel.js"></script>
	<script type="text/javascript" src="../styles/jscrollpane/mwheelIntent.js"></script>
	<script type="text/javascript" src="../styles/jscrollpane/jquery.jscrollpane.js"></script>

	<script src="../scripts/utilities/ScrollPanel.js"></script>
	<script src="../scripts/utilities/ScrollableTreePanel.js"></script>
	<script src="../scripts/utilities/CustomGrid.js"></script>
	<script src="../scripts/utilities/ErrorPanel.js"></script>
	<script src="../scripts/utilities/StatefulTreePanel.js"></script>
	<script src="../monitor/eg_scripts/dashboards/DashboardGeneralMeasuresGridPanel.js"></script>
	<script src="../monitor/eg_scripts/dashboards/DashboardGeneralMeasuresAggregatePanel.js"></script>
	<script src="../monitor/eg_scripts/dashboards/DashboardGeneralMeasuresGrid.js"></script>

	<script src="/final/scripts/utilities/OuterPanel.js"></script>
	<script src="/final/scripts/utilities/CustomGrid.js"></script>
	<script src="/final/scripts/utilities/EmptyPanel.js"></script>

	<script>
		hideBackButton = <%=isFromMenu%>
		function parseScript(_source)
		{
			var source = _source;
			var scripts = new Array();
			
			// Strip out tags
			while(source.indexOf("<script") > -1 || source.indexOf("</script") > -1) {

				var s = source.indexOf("<script");
				var s_e = source.indexOf(">", s);
				var e = source.indexOf("</script", s);
				var e_e = source.indexOf(">", e);
				// Add to scripts array
				scripts.push(source.substring(s_e+1, e));
				// Strip from source
				source = source.substring(0, s) + source.substring(e_e+1);
			}
			// Loop through every script collected and eval it
			for(var i=0; i<scripts.length; i++) {
				try {
					eval(scripts[i]);
				}
				catch(ex) {
					return;
				}
			}
			// Return the cleaned source
			return source;
		}
		Ext.onReady(function(){
			 Ext.Ajax.on('requestexception', function (conn, response, options) {
				var errorStr = response.responseText;
				parseScript(errorStr);
				if (errorStr != undefined && errorStr != 'undefined' && errorStr.indexOf("customerror") != -1)
				{
					if (errorStr.indexOf("user-session-invalid") != -1)
					{
						callWindow(1);
					}
					else if (errorStr.indexOf("user-deleted") != -1)
					{
						callWindow(2);
					}
					else if (errorStr.indexOf("user-timedout") != -1)
					{
						callWindow(3);
					}
				}
			});
			initLdgMask = new Ext.LoadMask(Ext.getBody(),{msg : "Loading ..."});
		});
		var user = '';
		var requestParams = new Object();
		var refreshFrequency = '<%=refreshFrequency%>';
		var showDashboard = false;
		treePanelTitle="Segments";
		var refresh = '';
		if('<%=refresh%>' == 'true'){
			requestParams.refresh = 'true';
		}
		else{
			requestParams.refresh = 'false';
		}

			requestParams.treeSession='<%=treeSession%>';
<%
			if(treeSession!=null && treeSession.indexOf("zoneDash.jsp")>-1)
			{
				session.setAttribute("thisPageSession",treeSession);
			}
			else if(thisPageSession!=null && thisPageSession.indexOf("zoneDash.jsp")>-1)
			{
				session.removeAttribute("thisPageSession");
%>
				requestParams.treeSession='<%=thisPageSession%>';
<%
			}
%>
			requestParams.backButtonText='';
			requestParams.isSite='';

		if('<%=openNode%>' != 'null' && '<%=openNode%>' != null && '<%=openNode%>' != 'undefined' && '<%=openNode%>' != undefined && '<%=openNode%>' != '')
			requestParams.selectedTreeNode = '<%=openNode%>';

		if('<%=treeOpen%>' == 'true')
			requestParams.treeOpen = 'true';
		else
			requestParams.treeOpen = 'false';

		requestParams.action='';
		if('<%=topoSegment%>' != 'null' && '<%=topoSegment%>' != null && '<%=topoSegment%>' != 'undefined' && '<%=topoSegment%>' != undefined && '<%=topoSegment%>' != '')
			requestParams.topoSegment = encodeURI('<%=topoSegment%>');
		else if('<%=selectedParam%>' != 'null' && '<%=selectedParam%>' != null && '<%=selectedParam%>' != 'undefined' && '<%=selectedParam%>' != undefined && '<%=selectedParam%>' != '')
			requestParams.topoSegment = encodeURI('<%=selectedParam%>');

		if('<%=currentTab%>' != 'null' && '<%=currentTab%>' != null && '<%=currentTab%>' != 'undefined' && '<%=currentTab%>' != undefined && '<%=currentTab%>' != '')
		{
			requestParams.selectedTab = '<%=currentTab%>';
			showDashboard = true;
		}

		if('<%=appCurrentHost%>' != 'null' && '<%=appCurrentHost%>' != null && '<%=appCurrentHost%>' != 'undefined' && '<%=appCurrentHost%>' != undefined && '<%=appCurrentHost%>' != '')
			requestParams.appCurrentHost = '<%=appCurrentHost%>';

		if('<%=aggregateComp%>' != 'null' && '<%=aggregateComp%>' != null && '<%=aggregateComp%>' != 'undefined' && '<%=aggregateComp%>' != undefined && '<%=aggregateComp%>' != '')
			requestParams.aggregateComp = '<%=aggregateComp%>';

		if('<%=aggregateTab%>' != 'null' && '<%=aggregateTab%>' != null && '<%=aggregateTab%>' != 'undefined' && '<%=aggregateTab%>' != undefined && '<%=aggregateTab%>' != '')
			requestParams.aggregateTab = '<%=aggregateTab%>';

		if('<%=fromHomepage%>'!='null' && '<%=fromHomepage%>'!=null && '<%=fromHomepage%>'!='undefined' && '<%=fromHomepage%>'!=undefined && '<%=fromHomepage%>'!='')
			requestParams.fromHomepage = '<%=fromHomepage%>';

		if('<%=from%>'!='null' && '<%=from%>'!=null && '<%=from%>'!='undefined' && '<%=from%>'!=undefined && '<%=from%>'!='')
			requestParams.from = '<%=from%>';
		
		if('<%=titleTextFrom%>'!='null' && '<%=titleTextFrom%>'!=null && '<%=titleTextFrom%>'!='undefined' && '<%=titleTextFrom%>'!=undefined && '<%=titleTextFrom%>'!='')
			requestParams.titleTextFrom = '<%=titleTextFrom%>';

		requestParams.time_line='';
		requestParams.mode='';
		requestParams.starttime='';
		requestParams.endtime='';
		requestParams.starthr='';
		requestParams.endhr='';
		var isAllComponentAccess = <%=isAllComponentAccess%>;
		requestParams.aggError = '<%=mappingInfo.getTextDescription("monitor.common.No metrics running")%>';

		// The following part decides the type of view that is choosen to display the Segment list
		var optionalListFlag = false;
		if("<%=optionalListPage%>"=="true" || "<%=optionalListPage%>"=="True" || "<%=optionalListPage%>"=="TRUE" || "<%=optionalListPage%>"=="yes" || "<%=optionalListPage%>"=="Yes" || "<%=optionalListPage%>"=="YES"){
			 optionalListFlag=true;
		}
		var isFromServc = <%=isFromService%>;
		</script>
	</head>
	<body class="content-frame">
	</body>
</html>