<%@ include file="EgTrackerJSON.jsp" %>
<%@ page import = "com.egurkha.User" %>
<%@ page import = "com.egurkha.UserRegistry" %>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import = "java.util.*" %>
<%@ page import = "net.sf.json.*" %>
<%@ page import = "egurkha.reporter.*" %>
<%@page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.monitor.EgQInsightView" %>
<%@ page import = "com.eg.EgMappingInfo" %>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.eg.EgName"%>
<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>
<%
	JSONObject rootJSON = new JSONObject();
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	String s_insightName  = request.getParameter("view_name");
	if(s_insightName != null){
		s_insightName=com.egurkha.util.StringUtils.replace(s_insightName,"~#~","'");
		s_insightName=com.egurkha.util.StringUtils.replace(s_insightName,"|amp|","&");
	}
	rootJSON.put("view_name",s_insightName);
	if(s_insightName != null)
	{
		s_insightName=com.egurkha.util.StringUtils.replace(s_insightName,"'","~#~");
		s_insightName=com.egurkha.util.StringUtils.replace(s_insightName,"&","|amp|");
	}
	String sessionID = session.getId();
	UserRegistry registry = UserRegistry.getInstance();
	User this_user = registry.getUser(sessionID);
	String userID = this_user.getLoginID();

	com.egurkha.ini.IniUI uiObj = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	String thisLanguage = uiObj.getDefaultLanguage();	
	
	String language = this_user.getLanguage();
	language = (language==null || language.length()==0)?thisLanguage:language;//"en_US"
	MappingNameSorter sorter = new MappingNameSorter(language);		

	if (this_user!=null)
	{
		String userLang = this_user.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	EgQInsightView ins_view = this_user.getQInsightView(s_insightName);
	int num_tiers = ins_view.getNoOfTiers();
	int num_servers = ins_view.getNoOfServersPerTier();
	int num_metrics = ins_view.getNoOfMetricsPerServer();
	int refresh_rate = ins_view.getRefreshRate();
	List all_servers = this_user.getServers(false);
	String monHomePage=this_user.getMonitorHomePage();
	if(num_tiers == 0 || num_servers==0 || num_metrics==0)
	{
	}
	String currentLiveGraph = s_insightName;
	currentLiveGraph = currentLiveGraph +"$"+userID;
	String sharePref = ErUserReport.getUsersAccessType(userID,currentLiveGraph,"quick_insight");
	if(sharePref==null || sharePref.length()==0)
	{
		sharePref="Private";
	}
	rootJSON.put("tiers",num_tiers);
	rootJSON.put("servers_per_tier",num_servers);
	rootJSON.put("metrics_per_server",num_metrics);
	rootJSON.put("refresh_rate",refresh_rate);
	rootJSON.put("SharedUsers",sharePref);
	ErRemoteScriptingBean remoteScriptingBean = new ErRemoteScriptingBean(userID);
	if ( sharePref.equalsIgnoreCase("share"))
	{
		String selectedUsers =remoteScriptingBean.getGraphsExistingUsers(currentLiveGraph,sharePref,"quick_insight");
		StringTokenizer tokens = new StringTokenizer(selectedUsers);
		JSONArray selectedUsersArray = new JSONArray();
		String strToken = "";
		while (tokens.hasMoreTokens())
		{
			strToken += tokens.nextToken()+",";	
		}
		strToken = strToken.substring(0,strToken.lastIndexOf(","));
		rootJSON.put("selectedSharedUsers",strToken);	
	}
	int tierHeight =20;
	int tierWidth = 230;
	int serverHeight=16;
	int metricHeight=18;
	int serverWidth = 240;
	
	for(int t_pos=0; t_pos< num_tiers; t_pos++)
	{
		for(int s_pos=0;s_pos<num_servers;s_pos++)
		{
			boolean isServerUsed = ins_view.isServerUsed(t_pos,s_pos);
			if( isServerUsed)
			{							
				String [] server_info= ins_view.getServerInfo(t_pos,s_pos);
				String saved_comp = server_info[EgQInsightView.SERVER_COMP_IDX].trim();
				String saved_comp_type = saved_comp.substring(saved_comp.lastIndexOf(":")+1);
				String saved_server_name =( ins_view.getServerName(t_pos,s_pos)).trim();
				String sid="";
				StringTokenizer stk = new StringTokenizer(saved_comp,":");
				int len =stk.countTokens();
				String nick = stk.nextToken();
				String port ="";
				if(stk.hasMoreTokens())
				{
				 port = stk.nextToken();
				}
				if(len==4 && stk.hasMoreTokens())
					sid = ":"+stk.nextToken();

				String comp_t="";
				if(stk.hasMoreTokens())
					comp_t= stk.nextToken();

				String comp_new = comp_t+":"+nick+":"+port+sid;
				if(!all_servers.contains(comp_new))
				{
					ins_view.removeServer(t_pos,s_pos);
				}
			}
		}
	}

	JSONObject tierData = new JSONObject();

	for(int t_pos=0; t_pos< num_tiers; t_pos++)
	{
		JSONArray tierArray = new JSONArray();
		
		boolean isTierUsed = ins_view.isTierUsed(t_pos);
		String t_name = ins_view.getTierName(t_pos);
		
		if(isTierUsed)
		{
		    t_name=com.egurkha.util.StringUtils.replace(t_name,"~#~","'"); 
			tierArray.add(t_name);
		}
		else
		{
			tierArray.add("");
		}	
		JSONObject serversDataObj = new JSONObject();
		
		for(int s_pos=0;s_pos<num_servers;s_pos++)
		{
			boolean isServerUsed = ins_view.isServerUsed(t_pos,s_pos);
			String s_name =ins_view.getServerName(t_pos,s_pos); 
			String arr_serverInfo[] = ins_view.getServerInfo(t_pos,s_pos);			
			String s_compName = arr_serverInfo[ins_view.SERVER_COMP_IDX];
			boolean last = false;
			int x= num_servers-1;
			if(s_pos==x)
				last=true;

			JSONArray serverDataArr = new JSONArray();
			
			if(isTierUsed)
			{		
				if(isServerUsed)
				{
		            s_name=com.egurkha.util.StringUtils.replace(s_name,"~#~","'");	 				
					serverDataArr.add(s_name);
					serverDataArr.add(s_compName);
				}
				else
				{
					serverDataArr.add("");
				}
				
			}
			else
			{
				serverDataArr.add("");
			}

			String s_compType = "all";
			Vector v_compTypes = new Vector(this_user.getServerTypes());
			v_compTypes.remove("Host_system");
			Collections.sort(v_compTypes);
			v_compTypes.insertElementAt("ALL",0);
			String firstChoice = "";
			ArrayList serverList = new ArrayList();
			String compType = "";
			for(int i=0;i<v_compTypes.size();i++)
			{
				compType = (String)v_compTypes.get(i);
				if(compType.equalsIgnoreCase("ALL"))
				{
					firstChoice = compType;
				}
				else
				{
					serverList.add(compType);
				}
			}
			if(serverList!=null && serverList.size()>1)
			{
				if(s_compType.equalsIgnoreCase("ALL"))
				{
					serverDataArr.add(mappingInfo.getTextDescription("monitor.quickinsight.ALL"));
				}
			}
			else if(serverList!=null && serverList.size() == 1)
			{
				serverDataArr.add((String)serverList.get(0));
			}
			serverList = sorter.getSortedCompTypeList(serverList);
			String tempVal = "";			
			EgName nameObject = null;
			for(int y=0; y<serverList.size(); y++)
			{
				nameObject = (EgName)serverList.get(y);
				if (tempVal.equals(s_compType))
					serverDataArr.add(tempVal);				
			}

			JSONObject metricDataObj = new JSONObject();
			
			for(int m_pos=0;m_pos<num_metrics;m_pos++)
			{
				String modify = "false";
				String m_name = ins_view.getMetricName(t_pos,s_pos,m_pos);
				String arr_metricInfo[] = ins_view.getMetricInfo(t_pos,s_pos,m_pos);
				String s_site = arr_metricInfo[ins_view.METRIC_SITE_IDX];
				String s_test = arr_metricInfo[ins_view.METRIC_TEST_IDX];
				String s_info = arr_metricInfo[ins_view.METRIC_INFO_IDX];
				String s_measure = arr_metricInfo[ins_view.METRIC_MEASURE_IDX];
				String s_metric = arr_metricInfo[ins_view.METRIC_NAME_IDX];
				
				if(m_name!=null)
					modify = "true";
				if(isServerUsed)
				{
					if(m_name!=null)
					{	
		                m_name=com.egurkha.util.StringUtils.replace(m_name,"~#~","'");					
						metricDataObj.put("MetricPos_"+(m_pos+1),m_name);
						metricDataObj.put("Site_"+(m_pos+1),s_site);
						metricDataObj.put("Test_"+(m_pos+1),s_test);
						metricDataObj.put("Info_"+(m_pos+1),s_info);
						metricDataObj.put("Measure_"+(m_pos+1),s_measure);						
					}
					else
					{
						metricDataObj.put("MetricPos_"+(m_pos+1),"");
					}
								
				}
				else
				{
					metricDataObj.put("MetricPos_"+(m_pos+1),"");
				}
			}
			serverDataArr.add(metricDataObj);
			serversDataObj.put("ServerPos_"+(s_pos+1),serverDataArr);
		}
		tierArray.add(serversDataObj);
		tierData.put("tierPos_"+(t_pos+1),tierArray);
	}
	rootJSON.put("tierData",tierData);
	
	out.println(rootJSON.toString());	
%>
<%
	if(s_insightName != null){
		s_insightName=com.egurkha.util.StringUtils.replace(s_insightName,"~#~","'");
		s_insightName=com.egurkha.util.StringUtils.replace(s_insightName,"|amp|","&");
	}
	if(monHomePage!=null && monHomePage.trim().length()>0 && monHomePage.equals("Quick Insight"))
	{		
		if(request.getQueryString()!=null)
		{
			session.setAttribute("monitorLastSession","/final/monitor/qinsight/EgQInsightHome.jsp?currentLoadingPage=EgQInsightDesignView&view_name="+s_insightName+"&"+request.getQueryString());
		}
		else
		{
			session.setAttribute("monitorLastSession","/final/monitor/qinsight/EgQInsightHome.jsp?currentLoadingPage=EgQInsightDesignView&view_name="+s_insightName);
		}
	}
%>