
<!--
***************************************************************************************
*	File name		: endUserDashboardMain.jsp
*	Purpose			: This is the main page for End User Dashboard
*	Version			: eG 6.0.1 and Above
*	Creation Date	: 04/12/2014
*	Authtor			: Saravanan . A
*	Design			: Jaiwin
******************************************************************************************/
-->
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page errorPage = "EgProbsM.jsp"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import = "com.egurkha.monitor.*" %>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "java.util.*" %>
<%@ page import = "com.egurkha.*"%>
<%@ page import = "egurkha.reporter.ErUtils"%>
<%@ page import = "com.eg.*"%>
<%@ page import = "egurkha.reporter.ErUserData"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.monitor.VmDashboardHelper"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "java.text.*" %>
<%@ page import = "java.math.*" %>
<%@ page import="net.sf.json.*"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page autoFlush="true" buffer="1094kb"%>
<script language="JavaScript1.2" type="text/JavaScript"> 
	var vdComboArray = new Array();
</script>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
	request.setCharacterEncoding("UTF-8");
%>

<%

	UserRegistry registry = UserRegistry.getInstance();
	User user = null; //registry.getUser(session.getId());

	String fromMenuStr = request.getParameter("fromMenu");
	boolean isFromMenu=false;
	if(fromMenuStr!=null && (fromMenuStr.equalsIgnoreCase("true") || fromMenuStr.equalsIgnoreCase("yes")))
	{
		isFromMenu=true;
	}

	if(isFromMenu)
	{
		user = registry.getUser(session.getId(),true);
	}
	else
	{
		user = registry.getUser(session.getId());
	}

	EgUserRole userRole = null;
	boolean isAllCompAccess=false;
	boolean isManagerLogin=false;
	String userName = "admin";
	String desktopName = request.getParameter("username");
	desktopName=(desktopName==null)?"":desktopName;

	String installdir = EgInstallInfo.getInstallDir();
	IniFile in = new IniFile(installdir+"/manager/config/eg_endUserDetails.ini");

	String strEGManagerUser=in.getValue("END_USER_DASHBOARD_SETTINGS","eGManagerUser");
	strEGManagerUser=(strEGManagerUser==null || strEGManagerUser.trim().length()==0)?"false":strEGManagerUser;
	boolean isEGManagerUser = strEGManagerUser.equalsIgnoreCase("true")?true:false;

	

	if(user==null && (!isFromMenu))
	{
		String login_user = "";
		if(isEGManagerUser)
			login_user = request.getParameter("user");

		userName=(login_user==null || login_user.trim().length()==0)?"admin":login_user;
		ErUserData userData = new ErUserData(userName,false);
		if(userData==null)
		{
			userName="admin";
			userData = new ErUserData(userName,false);
			user = userData.usr;
		}
		else if(userData!=null)
		{
			user = userData.usr;
		}

		if(user!=null)
		{
			userRole = user.getUserRole();
			isAllCompAccess = userRole.hasAllComponentAccess();
		}
	}
	else if(user!=null)
	{
		userName = user.getLoginID();
		userRole = user.getUserRole();
		isAllCompAccess = userRole.hasAllComponentAccess();
		isManagerLogin = true;
	}

	IniUI iniUI = IniUI.getInstance();
	String thisLanguage = iniUI.getDefaultLanguage();
	if (user!=null)
	{
		user.setUserLanguageAndSkins();
		String userLang = user.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}
	String userType = request.getParameter("userType");
	if(userType==null || userType.trim().length()==0)
		userType = request.getParameter("usertype");
	userType = (userType==null || userType.equalsIgnoreCase(""))?"VDI":userType;

	ArrayList enableadList = new ArrayList();
	String enablead = in.getValue("END_USER_DASHBOARD_SETTINGS","EnableADGroup");

	if(enablead != null && enablead.trim().length() > 0){
		enableadList = com.egurkha.util.StringUtils.egTokenizer(enablead, ",", true,false,true);
	}
	boolean enableAd = false;
	if(userType != null && enableadList.contains(userType))
		enableAd = true;

	ArrayList enableFilterList = new ArrayList();
	String enableFilter = in.getValue("END_USER_DASHBOARD_SETTINGS","EnableFilter");
	String defaultFilter = in.getValue("END_USER_DASHBOARD_SETTINGS","defaultFilter");
	if(defaultFilter == null && defaultFilter.trim().length() == 0)
		defaultFilter="Vendor";
	
	if(enableFilter != null && enableFilter.trim().length() > 0){
		enableFilterList = com.egurkha.util.StringUtils.egTokenizer(enableFilter, ",", true,false,true);
	}

	boolean enableFilt = false;
	if(userType != null && enableFilterList.contains(userType))
		enableFilt = true;

	

	ErUtils erUtils = new ErUtils();
	String monitor_Skin = user.getMonitorSkin();
	String  script_src="script_item_"+thisLanguage+".js";
	EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	String title = mappingInfo.getTextDescription("monitor.endUserDashboard.END USER DASHBOARD");
	String strVdiHostCombo=in.getValue("END_USER_DASHBOARD_SETTINGS","showVdiHostCombo");
	strVdiHostCombo=(strVdiHostCombo==null || strVdiHostCombo.trim().length()==0)?"false":strVdiHostCombo;
	boolean showVdiHostCombo = strVdiHostCombo.equalsIgnoreCase("true")?true:false;
	String default_vdi_type=in.getValue("END_USER_DASHBOARD_SETTINGS","Default_VdiType");
	default_vdi_type=(default_vdi_type==null || default_vdi_type.trim().length()==0)?"":default_vdi_type;

	String vdiReq = request.getParameter("vdiType");
	if(vdiReq!=null && vdiReq.length()>0)
		default_vdi_type = vdiReq;

	String searchStringReq = request.getParameter("searchString");
	searchStringReq=(searchStringReq==null || searchStringReq.trim().length()==0)?"":searchStringReq;
	
	String pageNo = request.getParameter("pageNo");

	String refreshFreq=in.getValue("END_USER_DASHBOARD_SETTINGS","Refresh frequency");
	long refFrequency = 60 * 1000L;
	if(refreshFreq!=null && refreshFreq.length()>0)
	{
		refFrequency =  Long.valueOf(refreshFreq).longValue() * 1000L;
	}
	
	String s_default_priority=in.getValue("END_USER_DASHBOARD_SETTINGS","Default");
	String s_default_limit=s_default_priority;
	String limitReq = request.getParameter("priority");
	if(limitReq!=null && limitReq.length()>0)
		s_default_priority = limitReq;

	if((s_default_limit==null || s_default_limit.trim().length()==0) && limitReq!=null && limitReq.length()>0)
	{
		s_default_limit=limitReq;
	}
	String searchEmptyText = "";
	if(searchStringReq==null || searchStringReq.trim().length()==0||searchStringReq.equalsIgnoreCase("null"))
		searchEmptyText = "Search Users";
	String userExpDashTitle = mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience Overview for")+" "+userType;
	boolean endUserOverviewFlag = false;
	String endUserDashOverview = request.getParameter("endUserDashOverview");
	endUserDashOverview = (endUserDashOverview==null || endUserDashOverview.trim().length()==0)?"":endUserDashOverview;
	String endUserOverviewParams = "";
	if(endUserDashOverview!=null && endUserDashOverview.trim().length()>0 && (endUserDashOverview.equalsIgnoreCase("yes")||endUserDashOverview.equalsIgnoreCase("true")))
	{
		endUserOverviewFlag =  true;
		String groupByStr = in.getValue("LOC_USER_DESKTOP_METRICS","Header:"+userType);
		if(groupByStr!=null && groupByStr.trim().length()>0 && !groupByStr.equalsIgnoreCase("null"))
		{
			if(groupByStr.indexOf(":")>-1 && groupByStr.indexOf(",")>-1)
				groupByStr = groupByStr.substring(groupByStr.indexOf(":")+1,groupByStr.indexOf(","));
			if(groupByStr!=null && groupByStr.trim().length()>0)
				searchEmptyText = "Search "+groupByStr;
		}
		if(userType!=null && userType.trim().length()>0 && (userType.equalsIgnoreCase("XenApp") || userType.equalsIgnoreCase("XenApp7")))
			userExpDashTitle = mappingInfo.getTextDescription("monitor.endUserDashboard.Citrix User Experience By Location for")+" "+userType;
		else
			userExpDashTitle = mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience By Location for")+" "+userType;
	}

	String enableBackButton = request.getParameter("enableBackButton");
	enableBackButton=(enableBackButton==null || enableBackButton.trim().length()==0)?"false":enableBackButton;
	String overviewSearchStr = request.getParameter("overviewsearchstr");
	overviewSearchStr = (overviewSearchStr==null || overviewSearchStr.trim().length()==0)?"":overviewSearchStr;
	String isFromUEDOverview = request.getParameter("isfromuedoverview");
	isFromUEDOverview = (isFromUEDOverview==null || isFromUEDOverview.trim().length()==0)?"":isFromUEDOverview;
	boolean isFromUEDSort = false;
	String fromuedsort = request.getParameter("isfromuedsort");
	fromuedsort = (fromuedsort==null || fromuedsort.trim().length()==0)?"":fromuedsort;
	if(fromuedsort!=null && fromuedsort.trim().length()>0 && (fromuedsort.equalsIgnoreCase("true")||fromuedsort.equalsIgnoreCase("yes")))
		isFromUEDSort = true;
	String Limits_to=in.getValue("END_USER_DASHBOARD_SETTINGS","Limits to");
	VmDashboardHelper vmDashHelper=new VmDashboardHelper(user);
	List types =vmDashHelper.getUserTypeComponentsComboData(userType);
	int size = (types!=null && types.size()>0)?types.size():0;
	String access = request.getParameter("access");
	if(access==null)
		access = request.getParameter("Access");
	access=(access==null || access.trim().length()==0)?"":access;

	if(desktopName!=null && desktopName.trim().length()>0 && (access==null || access.trim().length()==0))
		access="allusers";

	ArrayList uedMenuList=new ArrayList();
	List serverTypeList = user.getServerTypes();
	Object [] ued_vars = in.getVariables("USER_TYPE_COMPONENTS");
	if (ued_vars!=null)
	{
		for (int i=0;i<ued_vars.length ;i++ )
		{
			String thisVar = (String)ued_vars[i];
			String comptypesIni = in.getValue("USER_TYPE_COMPONENTS",thisVar);
			StringTokenizer st = new StringTokenizer(comptypesIni,",");
			while(st.hasMoreTokens())
			{
				String type = st.nextToken();
				if(type!=null)
				{
					type = type.trim();
					if(serverTypeList!=null && serverTypeList.contains(type))
					{
						uedMenuList.add(thisVar);
						break;
					}
				}
			}
		}
	}

	List new_types = new LinkedList();
	String new_selection="";
	if(types!=null && uedMenuList!=null && uedMenuList.contains("XenApp") && uedMenuList.contains("XenApp7"))
	{
		if(userType!=null && userType.equalsIgnoreCase("XenApp"))
		{
			new_types.addAll(vmDashHelper.getUserTypeComponentsComboData("XenApp7"));
		}
		else if(userType!=null && userType.equalsIgnoreCase("XenApp7"))
		{
			new_types.addAll(vmDashHelper.getUserTypeComponentsComboData("XenApp"));
		}

		if(new_types!=null && new_types.size()>0)
		{
			types.addAll(new_types);
			showVdiHostCombo = true;
			size = (types!=null && types.size()>0)?types.size():0;
		}
	}

	String currOrderBy =request.getParameter("orderBy");
	currOrderBy=(currOrderBy==null || currOrderBy.trim().length()==0)?"":currOrderBy;

	String currOrderByColumn = request.getParameter("orderByColumn");
	currOrderByColumn=(currOrderByColumn==null || currOrderByColumn.trim().length()==0)?"":currOrderByColumn;
	String currColType = request.getParameter("columnType");
	currColType = (currColType==null || currColType.trim().length()==0)?"":currColType;
	String currColdispName = request.getParameter("columnDispName");
	currColdispName = (currColdispName==null || currColdispName.trim().length()==0)?"":currColdispName;
	String fromMetricView = request.getParameter("fromMetricView");
	fromMetricView = (fromMetricView==null || fromMetricView.trim().length()==0)?"":fromMetricView;

	String aduserFilter = request.getParameter("aduserFilter");
	aduserFilter = (aduserFilter==null || aduserFilter.trim().length()==0)?"":aduserFilter;
	aduserFilter=  com.egurkha.util.StringUtils.replace(aduserFilter,"|eq|","=");

	String filterParam="";

	String filterFlag = request.getParameter("filterFlag");
	String filterBy = request.getParameter("filterBy");
	String searchFilter = request.getParameter("searchFilter");
	String nextSearch = request.getParameter("nextSearch");
	String priorityFilter = request.getParameter("priorityFilter");
	if(filterFlag != null && filterFlag.equalsIgnoreCase("true")){
		filterParam ="&filterFlag=true";
		filterParam+="&filterBy="+filterBy;
		filterParam+="&searchFilter="+searchFilter;
		filterParam+="&nextSearch="+nextSearch;
		filterParam+="&priorityFilter="+priorityFilter;
	}
	
	String showUserLocations = in.getValue("GEO_LOCATION_SETTINGS",userType+":ShowUserLocations");
	showUserLocations = (showUserLocations==null || showUserLocations.trim().length()==0)?"":showUserLocations;
	boolean isShowUserLocation = false;
	if(showUserLocations!=null && showUserLocations.trim().length()>0 && (showUserLocations.equalsIgnoreCase("true") || showUserLocations.equalsIgnoreCase("yes")))
	{
		isShowUserLocation = true;
	}
	String showSeparateFilters = in.getValue("LOC_USER_DESKTOP_METRICS",userType+":showSeparateFilters");
	boolean isShowSeparateFilters = (isShowUserLocation && showSeparateFilters!=null && showSeparateFilters.equalsIgnoreCase("true"))?true:false; 
	String cityFilter = "";
	String vendorFilter = "";
	String filterNames = new String();
	if(isShowSeparateFilters)
	{
		String metrics = in.getValue("USER_DESKTOP_METRICS",userName+":"+userType);
		if(metrics == null || metrics.trim().length() == 0)
		metrics = in.getValue("USER_DESKTOP_METRICS",userType);
		
		if(metrics != null && metrics.trim().length()>0){
			ArrayList metricsList = com.egurkha.util.StringUtils.egTokenizer(metrics, ",", true,false,true);
			if(metricsList != null && metricsList.size()>0){
				int val_count = 0;
				for(int i=0;i<metricsList.size();i++){
					String met = (String)metricsList.get(i);
					if(met == null || met.trim().length() == 0)
						continue;
					ArrayList check = com.egurkha.util.StringUtils.egTokenizer(met, ":", true,false,true);
					
					if(check != null && check.size() ==2){
						String geoCheck = (String)check.get(0);
						String geoCheckValue = (String)check.get(1);
						if(geoCheck != null && geoCheck.trim().length()>0)
						{
							if(geoCheck!=null && geoCheck.equalsIgnoreCase("GeoDetails"))
							{
								if(val_count<2)
								{
									filterNames = filterNames +","+geoCheckValue;
									val_count++;
								}
							}
						}
					}
				}
			}
		}
		if(filterNames!=null && filterNames.trim().length()>0 && filterNames.startsWith(","))
			filterNames = filterNames.substring(1);
	}

%>
<html>
<head>
		<script language="JavaScript1.2" type="text/JavaScript"> 
			var fromMetricView="<%=fromMetricView%>";
			var enableAd="<%=enableAd%>";
			var enableFilt="<%=enableFilt%>";
			var filterParam="<%=filterParam%>";

			var filterByGl="<%=filterBy%>";
			var searchFilterGl="<%=searchFilter%>";
			var nextSearchGl="<%=nextSearch%>";
			var priorityFilterGl="<%=priorityFilter%>";
			var defaultFilter="<%=defaultFilter%>";

			var showFilter = true;
			if(enableFilt == true || enableFilt == 'true')
				showFilter = false;

			var showgroupInfo = true;
			if(enableAd == true || enableAd == 'true')
				showgroupInfo = false;
			
			var panelADFilter=false;
			if(showFilter && showgroupInfo )
				panelADFilter = true;

			var aduserFilter="<%=aduserFilter%>";
			var advalue='user';
			if(aduserFilter != null && aduserFilter != undefined && aduserFilter !="")
				advalue='ad_group';

			var monSkin='<%=monitor_Skin%>';

			var groupInfo = new Array();
			groupInfo.push({
					name:'User',
					value:'user'
				});

				groupInfo.push({
					name:'AD Group',
					value:'ad_group'
				});

			var vdiComboListJSON = new Array();
<%
			for(int i=0;i<size;i++)
			{
				String type = (String)types.get(i);
				String selected = "";
				if((default_vdi_type == null || default_vdi_type.trim().length() == 0) && (userType!=null && userType.equalsIgnoreCase("XenApp7") && type.trim().equals("Citrix_XcXenApp_server")))
					default_vdi_type = type;
				else if((default_vdi_type == null || default_vdi_type.trim().length() == 0) && (userType!=null && userType.equalsIgnoreCase("XenApp") && type.trim().equals("Citrix_server")))
					default_vdi_type = type;

				if(default_vdi_type!=null && default_vdi_type.trim().length()>0 && type.equalsIgnoreCase(default_vdi_type))
					selected = "true";

				String newUserType = userType;
				if(types!=null && uedMenuList!=null && uedMenuList.contains("XenApp") && uedMenuList.contains("XenApp7"))
				{
					if(userType!=null && userType.equalsIgnoreCase("XenApp"))
					{
						new_selection=mappingInfo.getComponentTypeDescription("Citrix_server");
						if(new_types!=null && new_types.contains(type))
						{
							newUserType="XenApp7";
						}
					}
					else if(userType!=null && userType.equalsIgnoreCase("XenApp7"))
					{
						new_selection=mappingInfo.getComponentTypeDescription("Citrix_XcXenApp_server");
						if(new_types!=null && new_types.contains(type))
						{
							newUserType="XenApp";
						}
					}
				}

%>
				vdiComboListJSON.push({
					name:'<%=mappingInfo.getComponentTypeDescription(type)%>',
					value:'<%=type%>',
					selected:'<%=selected%>',
					usertype:'<%=newUserType%>'
				});
<%
			}
%>
			var limtsComboJson = new Array();
<%
			if(Limits_to.indexOf(",")>-1){
				String[] limitsArray = Limits_to.split(",");
				for(int k=0;k<limitsArray.length;k++){
					String limit = limitsArray[k];
%>
					limtsComboJson.push({
						name:'<%=limit%>',
						value:'<%=limit%>'	
					});
<%				}
			}
%>
			var filterNames = new Array();
<%
			if(filterNames.indexOf(",")>-1){
				String[] filterArray = filterNames.split(",");
				for(int k=0;k<filterArray.length;k++){
					String fil_name = filterArray[k];
					if(fil_name!=null && fil_name.indexOf("~$~")>-1)
					{
						String fil_key = fil_name.substring(0,fil_name.indexOf("~$~"));
						String fil_val = fil_name.substring(fil_name.indexOf("~$~")+3);
%>
						filterNames.push({
							name:'<%=fil_key%>',
							value:'<%=fil_val%>'
						});
<%					}
				}
			}
%>		
			var searchString='<%=searchStringReq%>';
			var searchEmptyText = '<%=searchEmptyText%>';
			var userExpDashTitle = '<%=userExpDashTitle%>';
			var endUserDashOverview = '<%=endUserDashOverview%>';
			var enableBackButton = '<%=enableBackButton%>';
			var overviewSearchStr = '<%=overviewSearchStr%>';
			var isFromUEDOverview = '<%=isFromUEDOverview%>';
			var endUserOverviewParams = '';
			var endUserOverviewFlag = <%=endUserOverviewFlag%>;
			var isfromuedsort = <%=isFromUEDSort%>;
			var pageNo='<%=pageNo%>';
			var userType='<%=userType%>';
			var refFreq = '<%=refFrequency%>';
			var refreshFreq = '<%=refreshFreq%>';
			var defaultLimit = '<%=s_default_limit%>';
			var defaultDispLimit = '<%=s_default_priority%>';
			var defaultVdiType = '<%=default_vdi_type%>';
			var showVdiHostCombo = <%=!showVdiHostCombo%>;
			var user = '<%=EgURLEncoder.encode(userName,"UTF-8")%>';
			var userName = '<%=EgURLEncoder.encode(desktopName,"UTF-8")%>';
			var desktopName = '<%=EgURLEncoder.encode(desktopName,"UTF-8")%>';
			var orderByColumn = '<%=request.getParameter("orderByColumn")%>';
			var orderBy = '<%=request.getParameter("orderBy")%>';
			var freqError = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Refresh Frequency must be valid positive Integer and greater than 0")%>';
			var measureError = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Please Select Measure")%>';
			var displayNameError = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Please Enter Display Name")%>';
			var vdiComboLabel = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Type")%>';

			var currOrderByColumn="<%=currOrderByColumn%>";
			var currOrderBy="<%=currOrderBy%>";
			var currColumnType="<%=currColType%>";
			var currColumndispName="<%=currColdispName%>";
			var tipSpe='<egui:intnl text="monitor.services.Special characters are not allowed"/>';
			var isFromMenu=<%=isFromMenu%>;
			var isDataAva = true;
			var noDataMsg = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.No Records Found")%>';
<%
			if(new_types!=null && new_types.size()>0)
			{
%>
			var vdiComboEmptyText = '<%=new_selection%>';
<%
			}
			else
			{
%>
			var vdiComboEmptyText = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Select a Type")%>';
<%
			}
%>
			var searchLabel = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Search")%>';
			var limitComboLabel = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Limits")%>';
			var limitComboEmptyText = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Select a Limit")%>';
			var defaultSettings = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Default Settings")%>';
			var refFrequency = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Refresh Frequency")%>';
			var addOrDelete = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Add/Delete")%>';
			var addLabel = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Add")%>';
			var deleteLabel = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Delete")%>';
			var TestLabel = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Test")%>';
			var MeasureLabel = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Measure")%>';
			var DisplayLabel = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Display Name")%>';
			var UpdateLabel = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Update")%>';
			var UpdateError = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Already Exists")%>';
			var optionsLabel = '<egui:intnl text="monitor.endUserDashboard.What would you like to do?"/>';
			var desktopNameHideFlag=false;
			if(userName!=null && userName!= undefined && userName!="")
			{
				desktopNameHideFlag=true;
			}
			//var headerPadding ='0 0 0 10';
			//if(endUserOverviewFlag)
			var headerPadding = '10 0 0 0'; 
			var isShowSeparateFilters=<%=isShowSeparateFilters%>;
		</script>
<%
	if((access!=null && access.equalsIgnoreCase("allusers")) || (desktopName!=null && desktopName.trim().length()>0))
	{
%>
		<egui:loadApp baseDir="/final/monitor/eg_scripts" appName="endUserDashboard" appFile="app.js"/>
		<link rel="stylesheet" href="/final/resources/css/ext-eg.css" />
		<egui:skin ui="monitor"/>
		<script language = "JavaScript1.2" src = "/final/scripts/<%=script_src%>"></script>
		<script src="/final/scripts/jquery-1.8.2.min.js"></script>
		<script language = "JavaScript1.2" src = "/final/monitor/eg_scripts/dashboardutils.js"></script>
		<!--<link rel="stylesheet" href="/final/styles/ext-custom-com-uxdashboard.css" />-->
		<!-- Grid ster ----------->
		<link rel="stylesheet" type="text/css" href="/final/styles/gridster/css/jquery.gridster.css"><!-- Added -->
		<link rel="stylesheet" type="text/css" href="/final/styles/gridster/css/demo.css"><!-- Added -->
		<link rel="stylesheet" type="text/css" href="/final/styles/gridster/css/digitalfont/stylesheet.css"><!-- Added -->
		<script type="text/javascript" src="/final/scripts/jquery.scrollTo.js"></script> <!--Added -->
		<script type="text/javascript" src="/final/scripts/jquery.gridster.js"></script><!-- Added -->

	</head>
	<body class="content-frame">
<%
	}
	else
	{
%>
		<link rel="stylesheet" href="/final/resources/css/ext-eg.css" />
		<egui:skin ui="monitor"/>

		<!--<link rel="stylesheet" type="text/css" href="/final/styles/eGDarkTheme.css" />
		<link rel="stylesheet" type="text/css" href="/final/styles/eGDarkThemeIcons.css" />
		<link rel="stylesheet" href="/final/styles/ext-custom-com-uxdashboard.css" />-->
		<script language = "JavaScript1.2" src = "/final/scripts/<%=script_src%>"></script>
		<script src="/final/scripts/jquery-1.8.2.min.js"></script>
		<script language = "JavaScript1.2" src = "/final/monitor/eg_scripts/dashboardutils.js"></script>
		<!-- Grid ster ----------->
		<link rel="stylesheet" type="text/css" href="/final/styles/gridster/css/jquery.gridster.css"><!-- Added -->
		<link rel="stylesheet" type="text/css" href="/final/styles/gridster/css/demo.css"><!-- Added -->
		<link rel="stylesheet" type="text/css" href="/final/styles/gridster/css/digitalfont/stylesheet.css"><!-- Added -->
		<script type="text/javascript" src="/final/scripts/jquery.scrollTo.js"></script> <!--Added -->
		<script type="text/javascript" src="/final/scripts/jquery.gridster.js"></script><!-- Added -->

	</head>
	<body class="content-frame"><div class="content-frame" style="border:0px solid red;" id="endUserDashboardDiv">
		<table border="0" width="100%" height="100%" bordercolor="green">
			<tr>
				<td align="center" class="commonErrorMsgText" width="100%" height="100%">
					<img src = "/final/images/spacer.gif" class="iconExclamation" align = "center" border = "0"  vspace = "10"/>
					<br><egui:intnl text='monitor.endUserDashboard.UnAuthorised Access'/>&nbsp;!
				</td>
			</tr>
		</table>
	</div>
<%
	}
%>
	
</body>
</html>