<%
/********************************************************************************************************
*	Name			:	endUserDashboardDataPrint.jsp
*	Purpose			:	To Save End User Dashboard Data as PDF
*	Version			:	eG 6.1.2 and Above
*	Creation Date		:	27/03/2016
*	Authtor			:	K N Raju and Saravanan.A
*	Design			:	Vijay 
*******************************************************************************************************/
%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page errorPage = "EgProbsM.jsp" %>
<%@ page import = "java.util.*"%>
<%@ page import = "java.util.Map.Entry"%>
<%@ page import = "java.io.*"%>
<%@ page import = "com.egurkha.*"%>
<%@ page import = "com.egurkha.monitor.EgServerDashboardModel"%>
<%@ page import = "com.egurkha.monitor.EgDashBoardModel"%>
<%@ page import = "com.egurkha.util.*"%>
<%@ page import = "com.eg.*"%>
<%@ page import = "com.egurkha.monitor.VmDashboardHelper"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "egurkha.reporter.ErUserData"%>
<%@ page import="com.eg.EgExternalInfo"%>
<%@ page import="com.egurkha.ini.*"%>
<%@ page import = "net.sf.json.*"%>
<%@ page import = "java.text.*" %>
<%@ page import = "java.math.*" %>
 
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
	request.setCharacterEncoding("UTF-8");
%>

<%
try
{
	UserRegistry registry = UserRegistry.getInstance();
	User user = null; //registry.getUser(session.getId());
	String fromMenuStr = request.getParameter("fromMenu");
	boolean isFromMenu=false;
	if(fromMenuStr!=null && (fromMenuStr.equalsIgnoreCase("true") || fromMenuStr.equalsIgnoreCase("yes")))
	{
		isFromMenu=true;
	}
	if(isFromMenu)
	{
		user = registry.getUser(session.getId(),true);
	}
	else
	{
		user = registry.getUser(session.getId());
	}

	JSONObject jsonRoot = new JSONObject();
	EgUserRole userRole = null;
	boolean isAllCompAccess=false;
	boolean isDataManagerLogin=false;
	String userName = "admin";

	String file = "eg_endUserDetails.ini";
	String dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile ini = new IniFile(dir + file);
	IniFile uiIni = new IniFile(dir + "eg_ui.ini");

	boolean isDebugEnabled = false;
	int logFileSize = 30;

	String userExpLogging = ini.getValue("Logging","enableLogging");
	if(userExpLogging!=null && (userExpLogging.equalsIgnoreCase("true") || userExpLogging.equalsIgnoreCase("yes")))
		isDebugEnabled = true;

	if(isDebugEnabled){
		String fileSize = ini.getValue("Logging","fileSize");
		try{
			if(fileSize != null && fileSize.trim().length() > 0)
				logFileSize = Integer.parseInt(fileSize);

		}catch(Exception e){
			logFileSize = 30;
		}
	}
	String strEGManagerUser=ini.getValue("END_USER_DASHBOARD_SETTINGS","eGManagerUser");
	strEGManagerUser=(strEGManagerUser==null || strEGManagerUser.trim().length()==0)?"false":strEGManagerUser;
	boolean isEGManagerUser = strEGManagerUser.equalsIgnoreCase("true")?true:false;

	String userType = request.getParameter("userType");
	if(user==null && (!isFromMenu))
	{
		String login_user ="";
		if(isEGManagerUser)
			login_user = request.getParameter("user");

		userName=(login_user==null || login_user.trim().length()==0)?"admin":login_user;
		ErUserData userData = new ErUserData(userName,false);
		if(userData==null)
		{
			userName="admin";
			userData = new ErUserData(userName,false);
			user = userData.usr;
		}
		else if(userData!=null)
		{
			user = userData.usr;
		}

		if(user!=null)
		{
			userRole = user.getUserRole();
			isAllCompAccess = userRole.hasAllComponentAccess();
		}
	}
	else if(user!=null)
	{
		userName = user.getLoginID();
		userRole = user.getUserRole();
		isAllCompAccess = userRole.hasAllComponentAccess();
		isDataManagerLogin = true;
	}

	writeLog(" userName  "+userName,isDebugEnabled,logFileSize);
	StringBuffer buf = new StringBuffer();
	IniUI ui = IniUI.getInstance();
	IniFile egEx = new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_external.ini");
	EgTablesInfo tablesInfo = new EgTablesInfo("manager");
	EgDbInfo Dbdata = new EgDbInfo("manager");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgExternalInfo egExternalInfo=new EgExternalInfo("manager");
	EgGroupInfo groupInfo = new EgGroupInfo();
	EgServerDashboardModel dashboardModel = new EgServerDashboardModel();
	EgDashBoardModel egDashboard=new  EgDashBoardModel();
	String thisLanguage = ui.getDefaultLanguage();
	if(user!=null)
	{
		user.setUserLanguageAndSkins();
		String userLang = user.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	String monitor_Skin = user.getMonitorSkin();
	VmDashboardHelper vmDashHelper=new VmDashboardHelper(user);
	List VmsList = new ArrayList();
	EgList egList=new EgList();
	String noOfInfoToDisplay = ""+10;
	EgList vdiDesktopsList= new EgList();
	int vdiDesktopsListTotalCount=0;
	int groupByUserCount = 0;
	Hashtable finalDesktopVmsHash=new Hashtable();
	Hashtable infosCompHash=new Hashtable();
	ArrayList infolist = new ArrayList();
	ArrayList dbinfolist = new ArrayList();

	List resTypeList = new LinkedList();
	List resCnameList = new LinkedList();
	List resCompsList = new LinkedList();
	List resNickList = new LinkedList();
	List resPortList = new LinkedList();

	Hashtable typeCompInfoHash=new Hashtable();
	Hashtable componentsInfo = new Hashtable();
	Hashtable measuresInfo = new Hashtable();
	Hashtable measureValues = new Hashtable();
	Hashtable user_count_hash = new Hashtable();
	ArrayList groupByUserKeys = new ArrayList();
	Hashtable finalGroupByUserTab = new Hashtable();
	Hashtable groupByUser = new Hashtable();
	String maxUser="";
	List componentTypeList=new ArrayList();
	List measureList = new ArrayList();
	String desktopUserName = request.getParameter("username");
	
	String searchString = (desktopUserName!=null && !desktopUserName.equalsIgnoreCase("") && desktopUserName.length()>0)?desktopUserName:request.getParameter("searchString");
	searchString=(searchString==null || searchString.trim().length()==0)?"":searchString;

	String priority = request.getParameter("priority");
	priority=(priority==null || priority.trim().length()==0)?"ALL":priority;
	String tmp_priority=priority;

	String vdiType = request.getParameter("vdiType");
	vdiType=(vdiType==null || vdiType.trim().length()==0)?"":vdiType;

	String orderBy =request.getParameter("orderBy");
	orderBy=(orderBy==null || orderBy.trim().length()==0)?"desc":orderBy;
	if(orderBy==null || orderBy.trim().length()==0 || orderBy.equalsIgnoreCase("null"))
	{
		orderBy="desc";
	}

	String enableBackButton = request.getParameter("enableBackButton");
	enableBackButton=(enableBackButton==null || enableBackButton.trim().length()==0)?"false":enableBackButton;

	String orderByColumnName = request.getParameter("orderByColumn");
	String columnDispName = request.getParameter("columnDispName");
	String pageNoReq = request.getParameter("pageNo");
	if(pageNoReq==null || pageNoReq.trim().length()==0)
		pageNoReq = "0";

	int pageNo = Integer.parseInt(pageNoReq);

	userType = request.getParameter("userType");
	String searchFrom = request.getParameter("searchFrom");
	if(userType==null || userType.trim().length()==0)
		userType = request.getParameter("usertype");
	userType=(userType==null || userType.trim().length()==0)?"VDI":userType;
	
	boolean isEndUserOverview = false;
	String endUserDashOverview = request.getParameter("endUserDashOverview");
	endUserDashOverview = (endUserDashOverview==null || endUserDashOverview.trim().length()==0)?"":endUserDashOverview;
	if(endUserDashOverview!=null && endUserDashOverview.trim().length()>0 && (endUserDashOverview.equalsIgnoreCase("true")||endUserDashOverview.equalsIgnoreCase("yes")))
		isEndUserOverview = true;
	boolean isFromUEDSort = false;
	String fromuedsort = request.getParameter("isfromuedsort");
	fromuedsort = (fromuedsort==null || fromuedsort.trim().length()==0)?"":fromuedsort;
	if(fromuedsort!=null && fromuedsort.trim().length()>0 && (fromuedsort.equalsIgnoreCase("true")||fromuedsort.equalsIgnoreCase("yes")))
		isFromUEDSort = true;
	String overviewSearchStr = request.getParameter("overviewsearchstr");
	overviewSearchStr = (overviewSearchStr==null || overviewSearchStr.trim().length()==0)?"":overviewSearchStr;
	String isFromUEDOverview = request.getParameter("isfromuedoverview");
	isFromUEDOverview = (isFromUEDOverview==null || isFromUEDOverview.trim().length()==0)?"":isFromUEDOverview;
	
	String aduserFilter = request.getParameter("aduserFilter");
	if(aduserFilter != null)
		aduserFilter=  com.egurkha.util.StringUtils.replace(aduserFilter,"|eq|","=");

	boolean defaultAdCase = false;
	if(aduserFilter != null && aduserFilter.equalsIgnoreCase("default")){
		aduserFilter ="All";
		defaultAdCase = true;
	}

	String showUserLocations = ini.getValue("GEO_LOCATION_SETTINGS",userType+":ShowUserLocations");
	String strSeparator = ini.getValue("GEO_LOCATION_SETTINGS",userType+":Separator");
	String strReplaceSep = ini.getValue("GEO_LOCATION_SETTINGS",userType+":ReplaceSeparatorTo");
	showUserLocations = (showUserLocations==null || showUserLocations.trim().length()==0)?"":showUserLocations;
	boolean isShowUserLocation = false;
	if(showUserLocations!=null && showUserLocations.trim().length()>0 && (showUserLocations.equalsIgnoreCase("true") || showUserLocations.equalsIgnoreCase("yes")))
	{
		isShowUserLocation = true;
	}
	String showSeparateFilters = ini.getValue("LOC_USER_DESKTOP_METRICS",userType+":showSeparateFilters");
	boolean isShowSeparateFilters = (isShowUserLocation && showSeparateFilters!=null && showSeparateFilters.equalsIgnoreCase("true"))?true:false;

	String col_Type = request.getParameter("columnType");
	String strUDSortByAllValue=ini.getValue("END_USER_DASHBOARD_SETTINGS","SortByAllMeasureValue");
	strUDSortByAllValue=(strUDSortByAllValue==null || strUDSortByAllValue.trim().length()==0)?"false":strUDSortByAllValue;
	boolean isUDSortByAllValue = (strUDSortByAllValue.equalsIgnoreCase("true") || strUDSortByAllValue.equalsIgnoreCase("yes"))?true:false;

	String strMValueOrder=ini.getValue("END_USER_DASHBOARD_SETTINGS","SortByAllMeasureValueOrder");
	strMValueOrder=(strMValueOrder==null || strMValueOrder.trim().length()==0)?"asc":strMValueOrder;
	
	String decimalFormatMeasure = ini.getValue("USER_DESKTOP_METRICS_DECIMAL_FORMAT_MEASURES",userType);
	ArrayList decimalFormatTestMeasureList = new ArrayList();
	if(decimalFormatMeasure!=null && decimalFormatMeasure.length()>0)
	{
		decimalFormatTestMeasureList = StringUtils.egTokenizer(decimalFormatMeasure,",",false,true,true);//param 3-->includeEmpty,4-->unique,5-->trim
	}

	String convertToDaysMeasure = ini.getValue("USER_DESKTOP_METRICS_CONVERT_TO_DAYS_MEASURES",userType);
	ArrayList convertToDaysTestMeasureList = new ArrayList();
	if(convertToDaysMeasure!=null && convertToDaysMeasure.trim().length()>0)
	{
		convertToDaysTestMeasureList = StringUtils.egTokenizer(convertToDaysMeasure,",",false,true,true);//param 3-->includeEmpty,4-->unique,5-->trim
	}
	Hashtable finalEndUserDatas = (Hashtable)vmDashHelper.getEndUserDatas(userType);
	Hashtable infoResHash = new Hashtable();
	Hashtable dataResHash = new Hashtable();
	Hashtable fullInfoHash = new Hashtable();
	boolean orderByCol_flag=false;
	boolean isDataAvailable = false;

	List listData = new LinkedList();
	int measuresCount = 0;
	if(finalEndUserDatas!=null && finalEndUserDatas.size()>0)
	{
		infoResHash = (Hashtable)finalEndUserDatas.get("users");
		dataResHash = (Hashtable)finalEndUserDatas.get("usersDetails");
	}

	if(orderByColumnName!=null && orderByColumnName.trim().length()>0 && !orderByColumnName.equalsIgnoreCase("null"))
	{
		tmp_priority="ALL";
		orderByCol_flag=true;
	}
	else if(isUDSortByAllValue)
	{
		tmp_priority="ALL";
	}
	String showFilterNames = ""; 
	if(isShowSeparateFilters)
	{
		IniFile filter_ini = new IniFile(dir + file,true);
		String metrics = ini.getValue("USER_DESKTOP_METRICS",userName+":"+userType);
		if(metrics == null || metrics.trim().length() == 0)
			metrics = ini.getValue("USER_DESKTOP_METRICS","DEFAULT_"+userType);
		ArrayList metricsList = new ArrayList();
		if(metrics != null && metrics.trim().length()>0){
			metricsList = com.egurkha.util.StringUtils.egTokenizer(metrics, ",", true,false,true);
		}
		String comboNames = new String();
		if(metricsList != null && metricsList.size()>0){
			int val_count = 0;
			for(int i=0;i<metricsList.size();i++){
				String met = (String)metricsList.get(i);
				if(met == null || met.trim().length() == 0)
					continue;
				ArrayList check = com.egurkha.util.StringUtils.egTokenizer(met, ":", true,false,true);
				if(check != null && check.size() ==2){
					String geoCheck = (String)check.get(0);
					String geoCheckValue = (String)check.get(1);
					if(geoCheck != null && geoCheck.trim().length()>0)
					{
						if(geoCheck.equalsIgnoreCase("GeoDetails"))
						{
							ArrayList valList = com.egurkha.util.StringUtils.egTokenizer(geoCheckValue, "~$~", true,false,true);
							if((valList != null && valList.size() ==2) && val_count<2){
								val_count++; 
								comboNames = comboNames + (String)valList.get(0)+",";
							}
						}
					}
				}
			}
			if(comboNames!=null && comboNames.trim().length()>0 && comboNames.lastIndexOf(",")>-1)
				comboNames = comboNames.substring(0,comboNames.lastIndexOf(","));
			showFilterNames = comboNames;
		}
	}
	String groupByStr = ini.getValue("LOC_USER_DESKTOP_METRICS",userType+":GroupBy");
	ArrayList groupByList = new ArrayList();
	if(groupByStr!=null && groupByStr.trim().length()>0)
	{
		groupByList = StringUtils.egTokenizer(groupByStr,",",false,true,true);		//param 3-->includeEmpty,4-->unique,5-->trim
	}
	String filterFlag = request.getParameter("filterFlag");
	ArrayList filterInfo = null;
	Hashtable filterInfoHash = null;

	String filterBy = "";
	String searchFilter = "";
	String nextSearch = "";
	String priorityFilter = request.getParameter("priorityFilter");
	priorityFilter = (priorityFilter==null || priorityFilter.trim().length()==0||priorityFilter.equalsIgnoreCase("NULL"))?"All":priorityFilter;
	String searchFilDispTxt = request.getParameter("searchFilDispTxt");
	String nextSearchFilDispTxt = request.getParameter("nextSearchFilDispTxt");
	Hashtable statesList = null;
	if(filterFlag != null && filterFlag.equalsIgnoreCase("true")){
		filterInfo = new ArrayList();
		filterInfoHash =  new Hashtable();
		
		filterBy = request.getParameter("filterBy");
		searchFilter = request.getParameter("searchFilter");
		nextSearch = request.getParameter("nextSearch");
		
		Hashtable InfoSession = (Hashtable)session.getAttribute("InfoSession");
		Hashtable InfoFilterSession = (Hashtable)session.getAttribute("InfoFilterSession");
		Hashtable geoLocMapInfos = (Hashtable)session.getAttribute("geoLocMapInfos");
		filterInfoHash.put("filterBy",filterBy);
		filterInfoHash.put("searchFilter",searchFilter);
		filterInfoHash.put("nextSearch",nextSearch);
		filterInfoHash.put("priorityFilter",priorityFilter);
		if(InfoSession == null)
			InfoSession = new Hashtable();
		filterInfoHash.put("InfoSession",InfoSession);
		if(InfoFilterSession == null)
			InfoFilterSession = new Hashtable();
		filterInfoHash.put("InfoFilterSession",InfoFilterSession);
		if(geoLocMapInfos == null)
			geoLocMapInfos = new Hashtable();
		filterInfoHash.put("geoLocMapInfos",geoLocMapInfos);

		List temp_listZone = user.getZones();
		ArrayList notZoneList = new ArrayList();
		if(temp_listZone != null && temp_listZone.size() > 0){
			for(int l=0;l<temp_listZone.size();l++){
				String zone1 = (String) temp_listZone.get(l);
				List temp_zoneComps = groupInfo.getAllComponentsUnderZone(zone1,true);
				if(temp_zoneComps != null && temp_zoneComps.size() > 0){
					for(int p=0;p<temp_zoneComps.size();p++){
						String compType = (String)temp_zoneComps.get(p);
						notZoneList.add(compType);
					}
				}
			}
		}
		filterInfoHash.put("notZoneList",notZoneList);
	}
	if(searchFrom!=null && !searchFrom.equals("") && searchFrom.equalsIgnoreCase("InsideEndUserDashboard"))
	{
		String searchStringData = request.getParameter("searchStringData");
		desktopUserName = searchStringData;
		searchString = searchStringData;
		if(infoResHash!=null && infoResHash.size()>0)
		{
			writeLog(" vmDashHelper {getAllUsersDesktopsForUED} Method call in ",isDebugEnabled,logFileSize);
			finalDesktopVmsHash = (Hashtable)vmDashHelper.getAllUsersDesktopsForUED(searchString,tmp_priority,userType,vdiType,pageNo,infoResHash,searchFrom,aduserFilter,filterInfoHash);
			writeLog(" vmDashHelper {getAllUsersDesktopsForUED} Method call out ",isDebugEnabled,logFileSize);
		}
		else
		{
			writeLog(" vmDashHelper {getVmDesktopsForTheComponentForGenericEUD} Method call in ",isDebugEnabled,logFileSize);
			finalDesktopVmsHash = (Hashtable)vmDashHelper.getVmDesktopsForTheComponentForGenericEUD(searchStringData,tmp_priority,userType,vdiType,pageNo,searchFrom,aduserFilter,filterInfoHash);
			writeLog(" vmDashHelper {getVmDesktopsForTheComponentForGenericEUD} Method call out ",isDebugEnabled,logFileSize);
		}
	}
	else
	{
		if(infoResHash!=null && infoResHash.size()>0)
		{
			writeLog(" vmDashHelper {getAllUsersDesktopsForUED} Method call in ",isDebugEnabled,logFileSize);
			finalDesktopVmsHash = (Hashtable)vmDashHelper.getAllUsersDesktopsForUED(searchString,tmp_priority,userType,vdiType,pageNo,infoResHash,null,aduserFilter,filterInfoHash);
			writeLog(" vmDashHelper {getAllUsersDesktopsForUED} Method call out ",isDebugEnabled,logFileSize);
		}
		else if(isEndUserOverview||isFromUEDSort)
		{
			writeLog(" vmDashHelper {getVmDesktopsForTheComponentForGenericEUD} Method call in ",isDebugEnabled,logFileSize);
			finalDesktopVmsHash = (Hashtable)vmDashHelper.getVmDesktopsForTheComponentForGenericEUD(null,tmp_priority,userType,vdiType,pageNo,aduserFilter,filterInfoHash);
			writeLog(" vmDashHelper {getVmDesktopsForTheComponentForGenericEUD} Method call out ",isDebugEnabled,logFileSize);
		}
		else
		{
			writeLog(" vmDashHelper {getVmDesktopsForTheComponentForGenericEUD} Method call in ",isDebugEnabled,logFileSize);
			finalDesktopVmsHash = (Hashtable)vmDashHelper.getVmDesktopsForTheComponentForGenericEUD(searchString,tmp_priority,userType,vdiType,pageNo,aduserFilter,filterInfoHash);
			writeLog(" vmDashHelper {getVmDesktopsForTheComponentForGenericEUD} Method call out ",isDebugEnabled,logFileSize);
		}
	}

	String adFilter = "";
	ArrayList adFilterKeys = new ArrayList();
	Hashtable userRelatedAd = new Hashtable();

	if(finalDesktopVmsHash!=null && finalDesktopVmsHash.size()>0)
	{
		vdiDesktopsList = (EgList)finalDesktopVmsHash.get("EgList");
		vdiDesktopsListTotalCount = (Integer)finalDesktopVmsHash.get("EgListCount");
		statesList = (Hashtable)finalDesktopVmsHash.get("statesList");
		infosCompHash = (Hashtable)finalDesktopVmsHash.get("INFOS_COMP");
		Hashtable tmp_CTHash = (Hashtable)finalDesktopVmsHash.get("TYPE_COMP_INFO");
		typeCompInfoHash = tmp_CTHash;
		infolist = (ArrayList)finalDesktopVmsHash.get("INFOS");
		dbinfolist = (ArrayList)finalDesktopVmsHash.get("DBINFOS");

		resTypeList = (List)finalDesktopVmsHash.get("CTYPE");
		componentTypeList = resTypeList;
		resCnameList = (List)finalDesktopVmsHash.get("CNAME");
		resCompsList = (List)finalDesktopVmsHash.get("COMPS");
		resNickList = (List)finalDesktopVmsHash.get("NICKS");
		resPortList = (List)finalDesktopVmsHash.get("PORTS");

		fullInfoHash = (Hashtable)finalDesktopVmsHash.get("FULLINFOS");
		maxUser = (String)finalDesktopVmsHash.get("MAX_USER");
		user_count_hash = (Hashtable)finalDesktopVmsHash.get("MAX_USER_HASH");

		if(finalDesktopVmsHash.containsKey("adFilter"))
			adFilter = (String)finalDesktopVmsHash.get("adFilter");
		if(finalDesktopVmsHash.containsKey("adFilterKeys"))
			adFilterKeys = (ArrayList)finalDesktopVmsHash.get("adFilterKeys");
		if(finalDesktopVmsHash.containsKey("userRelatedAd"))
			userRelatedAd = (Hashtable)finalDesktopVmsHash.get("userRelatedAd");
		if(finalDesktopVmsHash.containsKey("groupByUserKeys"))
		groupByUserKeys = (ArrayList)finalDesktopVmsHash.get("groupByUserKeys");
		if(groupByUserKeys==null||groupByUserKeys.size()==0)
			isEndUserOverview = false;
	}
	
	String inner_header="";
	String header_display="";
	String header_display_icon="";
	String is_Header_DispName=ini.getValue("END_USER_DASHBOARD_SETTINGS","ShowUserCountInUI");
	String skipDesktopsForVDI = ini.getValue("END_USER_DASHBOARD_SETTINGS","SkipDesktopsForVDI");
	boolean check_Header_DispName=false;
	if(is_Header_DispName!=null && (is_Header_DispName.equalsIgnoreCase("true") || is_Header_DispName.equalsIgnoreCase("yes")))
	{
		check_Header_DispName = true;
		if(!isEndUserOverview && vdiDesktopsListTotalCount>0)
		{
			if(userType!=null && userType.equalsIgnoreCase("ESX"))
			{
				header_display=mappingInfo.getTextDescription("monitor.endUserDashboard.Performance Metrics for VMs (Total VMs : "+vdiDesktopsListTotalCount+")");
			}
			else if(userType!=null && userType.equalsIgnoreCase("VDI"))
			{
				String countHeader = (skipDesktopsForVDI!=null && skipDesktopsForVDI.equalsIgnoreCase("true"))?"Unique Users":"Unique Users/Desktops";
				header_display=mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience Overview for "+userType+" ("+countHeader+": "+vdiDesktopsListTotalCount+")");
			}
			else
			{
				String countHeader = "Unique Users";
				header_display=mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience Overview for "+userType+" ("+countHeader+": "+vdiDesktopsListTotalCount+")");
			}
			jsonRoot.put("header_display",header_display);

			if(priorityFilter==null || priorityFilter.trim().length()==0 || priorityFilter.equalsIgnoreCase("NULL"))
			{
				jsonRoot.put("isShowLocColumn",isShowUserLocation);
			}
		}
		else if(isEndUserOverview)
		{
			header_display=mappingInfo.getTextDescription("monitor.endUserDashboard.Citrix User Experience By Location for")+" "+userType;
			jsonRoot.put("header_display",header_display);
		}
	}
	else
	{
		if(!isEndUserOverview)
		{
			if(userType!=null && userType.equalsIgnoreCase("ESX"))
			{
				header_display=mappingInfo.getTextDescription("monitor.endUserDashboard.Performance Metrics for VMs ");
			}
			else
			{
				header_display=mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience Overview for "+userType);
			}
			jsonRoot.put("header_display",header_display);

			if(vdiDesktopsListTotalCount==0 || priorityFilter==null || priorityFilter.trim().length()==0 || priorityFilter.equalsIgnoreCase("NULL"))
			{
				jsonRoot.put("isShowLocColumn",isShowUserLocation);
			}
		}
		else if(isEndUserOverview)
		{
			header_display=mappingInfo.getTextDescription("monitor.endUserDashboard.Citrix User Experience By Location for")+" "+userType;
			jsonRoot.put("header_display",header_display);
		}
	}
	Hashtable TotalMeasureInfo = new Hashtable();
	session.removeAttribute("InfoSession");
	session.removeAttribute("InfoFilterSession");
	JSONArray fil = new JSONArray();
	if(searchFrom==null || searchFrom.trim().length()==0)
	{
		if(dataResHash!=null && dataResHash.size()>0 && ((vdiDesktopsList!=null && vdiDesktopsList.size()>0 && vdiDesktopsListTotalCount>0)||(groupByUserKeys!=null && groupByUserKeys.size()>0)))
		{
			TotalMeasureInfo=(Hashtable)dataResHash.clone();
		}
		else if((vdiDesktopsList!=null && vdiDesktopsList.size()>0 && vdiDesktopsListTotalCount>0)||(groupByUserKeys!=null && groupByUserKeys.size()>0))
		{
			//TotalMeasureInfo = vmDashHelper.getAllDesktopVmsMeasureDataForGenericEUD(finalDesktopVmsHash,userType);
			TotalMeasureInfo = vmDashHelper.getAllDesktopVmsMeasureDataForGenericEUD(finalDesktopVmsHash,userType,userName);
		}
		
		if(TotalMeasureInfo != null && TotalMeasureInfo.containsKey("InfoSession") && TotalMeasureInfo.containsKey("InfoFilterSession")){
			Hashtable geoMapInfo = (Hashtable)TotalMeasureInfo.get("InfoSession");
			Hashtable InfoFilterSession = (Hashtable)TotalMeasureInfo.get("InfoFilterSession");
			Hashtable geoLocMapInfos = (Hashtable)TotalMeasureInfo.get("geoLocMapInfos");

			TotalMeasureInfo.remove("InfoSession");
			TotalMeasureInfo.remove("InfoFilterSession");
			TotalMeasureInfo.remove("geoLocMapInfos");

			if(geoMapInfo != null && geoMapInfo.size() > 0)
			{
				Iterator it = geoMapInfo.entrySet().iterator();
				while(it.hasNext()){
					Entry en = (Entry)it.next();
					Set set = (HashSet)en.getValue();
					ArrayList list = new ArrayList(set);
					if(list != null && list.size() > 0)
						fil.add((String)en.getKey());
				}
				session.setAttribute("InfoSession",geoMapInfo);
				session.setAttribute("tmpInfoSession",geoMapInfo);
				session.setAttribute("geoLocMapInfos",geoLocMapInfos);
				session.setAttribute("statesList",statesList);
			}
			if(InfoFilterSession != null && InfoFilterSession.size() > 0)
				session.setAttribute("InfoFilterSession",InfoFilterSession);
		}
		if(TotalMeasureInfo!=null && TotalMeasureInfo.containsKey("finalGroupByUserTab"))
		{
			finalGroupByUserTab = (Hashtable) TotalMeasureInfo.get("finalGroupByUserTab");
		}

		if(orderByColumnName!=null && orderByColumnName.trim().length()>0 && !orderByColumnName.equalsIgnoreCase("null"))
		{
			if(col_Type!=null && col_Type.trim().length()>0 && (!col_Type.equalsIgnoreCase("NULL")))
			{
				if(isFromUEDSort)
				{
					groupByUserKeys = (ArrayList)vmDashHelper.getSortedListForUEDOverview(groupByUserKeys,TotalMeasureInfo,"enduseroverview",orderByColumnName,orderBy,col_Type);
				}
				else
				{
					vdiDesktopsList=vmDashHelper.getSortedList(vdiDesktopsList,TotalMeasureInfo,"virtual",orderByColumnName,orderBy,col_Type);
				}
			}
			else
			{
				if(orderByColumnName.equalsIgnoreCase("HOST"))
				{
					columnDispName="Host";
					vdiDesktopsList=vmDashHelper.getSortedList(vdiDesktopsList,orderByColumnName,null,orderBy);
				}
				else
				{
					vdiDesktopsList=vmDashHelper.getSortedList(vdiDesktopsList,TotalMeasureInfo,"virtual",orderByColumnName,orderBy);
				}
			}
			if(priority!=null && !priority.equalsIgnoreCase("ALL"))
			{
				vdiDesktopsList = vmDashHelper.getSubList(vdiDesktopsList,priority,pageNo);
			}
		}
		else if(isUDSortByAllValue)
		{
			vdiDesktopsList=vmDashHelper.getAllMeasureValueBasedSortedList(vdiDesktopsList,TotalMeasureInfo,userType,strMValueOrder);
			if(priority!=null && !priority.equalsIgnoreCase("ALL"))
			{
				vdiDesktopsList = vmDashHelper.getSubList(vdiDesktopsList,priority,pageNo);
			}
		}
	}
	if(groupByUserKeys!=null && groupByUserKeys.size()>0)
		groupByUserCount = groupByUserKeys.size();
	if(desktopUserName!=null && !desktopUserName.equalsIgnoreCase("") && desktopUserName.length()>0 && vdiDesktopsList.size()>0)
	{
		EgService tempServ = (EgService)vdiDesktopsList.get(0);
		String tempDesktopComponent = tempServ.getName();
		String tempDesktopState = tempServ.getState().getName();
		String tempDesktopName = "";
		String tempComp = "";
		String tempCompValue = "";
		String tempCompName = "";
		String tempCompNameWithOutPort = "";

		if(tempDesktopComponent!=null && tempDesktopComponent.indexOf("^")>-1){
			tempDesktopName = tempDesktopComponent.substring(0,tempDesktopComponent.indexOf("^"));
			tempComp = tempDesktopComponent.substring(tempDesktopComponent.indexOf("^")+1);
		}

		if(tempComp!=null && tempComp.indexOf(":")>-1){
			tempCompValue = tempComp.substring(0,tempComp.indexOf(":"));
			tempCompName = tempComp.substring(tempComp.indexOf(":")+1);
		}

		if(tempCompName!=null && tempCompName.indexOf(":")>-1){
			tempCompNameWithOutPort = tempCompName.substring(0,tempCompName.indexOf(":"));
		}

		String tempMsmtHost = "";
		String ctype_layer=ini.getValue("USER_DESKTOP_LAYERS",tempCompValue);
		ctype_layer=(ctype_layer==null || ctype_layer.trim().length()==0)?"VIRTUAL_DESKTOP":ctype_layer;
		ArrayList arr = tablesInfo.getTestsForLayer(ctype_layer);
		if(arr!=null && arr.size()>0)
		{
			boolean flag=true;
			for (int t=0;t<arr.size();t++)
			{
				String insideviewTest=(String) arr.get(t);
				if(insideviewTest!=null && insideviewTest.trim().length()>0)
				{
					List tempAgents=egExternalInfo.getAgentsFor(insideviewTest.trim(),tempCompValue,tempCompNameWithOutPort);

					if(tempAgents!=null && tempAgents.size()>0)
					{
						tempMsmtHost=(String)tempAgents.get(0);
						flag=false;
						break;
					}
				}
			}
			if(flag)
				tempMsmtHost=tempCompNameWithOutPort;
		}
		else
			tempMsmtHost=tempCompNameWithOutPort;

		String temp_url_desktopName=com.egurkha.util.StringUtils.replace(tempDesktopName, "\\", "\\");

		String url = "/final/monitor/endUserDashboardDetailsData.jsp?comp="+tempCompName+"&comptype="+tempCompValue+"&info=*"+temp_url_desktopName+"&compName="+tempCompName+":"+tempCompValue+"&componentName="+tempCompNameWithOutPort+"&msmt_host="+tempMsmtHost+"&user="+userName+"&searchString="+searchString+"&priority="+priority+"&vdiType="+vdiType+"&userType="+userType+"&enableBackButton="+enableBackButton+"&directEndDetail=true";

		if(fromMenuStr!=null && fromMenuStr.trim().length()>0)
		{
			url=url+"&fromMenu="+fromMenuStr;
		}
		if(priorityFilter!=null && priorityFilter.trim().length()>0 && !priorityFilter.equalsIgnoreCase("NULL"))
		{
			url=url+"&priorityFilter="+priorityFilter;
		}
		//jsonRoot.put("REDIRECT",true);
		//jsonRoot.put("REDIRECT_URL",url);
	}
	else if(desktopUserName!=null && desktopUserName.trim().length()>0 && (vdiDesktopsList==null || vdiDesktopsList.size()==0))
	{
		String url = "/final/monitor/endUserDashboardDetailsData.jsp?comp=&comptype=&info=*"+desktopUserName+"&compName=&componentName=&msmt_host=&user="+userName+"&searchString="+searchString+"&priority="+priority+"&vdiType="+vdiType+"&userType="+userType+"&enableBackButton="+enableBackButton+"&directEndDetail=true";

		if(fromMenuStr!=null && fromMenuStr.trim().length()>0)
		{
			url=url+"&fromMenu="+fromMenuStr;
		}
		//jsonRoot.put("REDIRECT",true);
		//jsonRoot.put("REDIRECT_URL",url);
	}
	else if(TotalMeasureInfo!=null && TotalMeasureInfo.size()>0)
	{
		if(adFilter != null && aduserFilter != null)
		{
			buf.append("<link rel='stylesheet' type='text/css' href='/final/styles/eGLightThemeIcons.css' />");
			buf.append("<style>@media print {body {-webkit-print-color-adjust: exact;}}");
			buf.append("@font-face{font-family:'LucidaGrandeRegular';src:url('../../fonts/6216/6216.woff') format('woff')}");
			buf.append("@font-face{font-family:'LucidaGrandeBold';src:url('../../fonts/6215/6215.woff') format('woff')}");
			buf.append("body{font-family:'LucidaGrandeRegular';font-size:11px;line-height:1.5em;color:#2a292a;}");
			buf.append("header{font-family:'LucidaGrandeRegular';font-size:15px;}");
			buf.append(".formLabel {font-family:'LucidaGrandeRegular';font-size:12px;line-height:14px;}");
			buf.append(".formValue {font-family:'LucidaGrandeBold';font-size:12px;line-height:14px;} b{font-family:'LucidaGrandeBold';font-size:11px;}");
			buf.append("table tr td{font-family:'LucidaGrandeRegular';font-size:11px;padding:4px;}");
			buf.append(".printTable{border: 1px solid #c3c3c3; border-collapse:collapse;word-break:break-all;}");
			buf.append(".printTableHeader{font-family:'LucidaGrandeBold';border: 1px solid #c3c3c3;text-align:center;background-color:#cdcdcd;padding:4px;}");
			buf.append(".printTable tr td{border: 1px solid #c3c3c3;}");
			buf.append(".printTable tbody tr td{border: 1px solid #c3c3c3;}");
			buf.append(".printTable tbody tr td table tr td{border: 0px solid #c3c3c3 !important;}");
			buf.append(".printTable div{word-break:break-all;	}");
			buf.append(".printTable thead{font-family:'LucidaGrandeBold';border: 1px solid #c3c3c3;text-align:center;background-color:#cdcdcd;padding:4px;}");
			buf.append(".printTableHeader2{font-family:'LucidaGrandeBold';border: 1px solid #c3c3c3;text-align:center;background-color:#dcdcdc;padding:4px;}</style>");
			
			IniUI img1=IniUI.getInstance();
			String logo=img1.getMonitorHomeLogo();
			if(img1.isHKTThemeEnabled())
			{
				logo = img1.getHKTReporterLogo();
			}
			String mainTitle=mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience Overview for "+userType);
			if(check_Header_DispName && vdiDesktopsListTotalCount>0)
			{
				if(userType!=null && userType.equalsIgnoreCase("ESX"))
				{
					mainTitle=mappingInfo.getTextDescription("monitor.endUserDashboard.Performance Metrics for VMs (Total VMs : "+vdiDesktopsListTotalCount+")");
				}
				else if(userType!=null && userType.equalsIgnoreCase("VDI"))
				{
					String countHeader = (skipDesktopsForVDI!=null && skipDesktopsForVDI.equalsIgnoreCase("true"))?"Unique Users":"Unique Users/Desktops";
					mainTitle=mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience Overview for "+userType+" ("+countHeader+": "+vdiDesktopsListTotalCount+")");
				}
				else if(userType!=null && (userType.equalsIgnoreCase("XenApp") || userType.equalsIgnoreCase("XenApp7")))
				{
					String countHeader = "Unique Users";
					mainTitle=mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience Overview for "+userType+" ("+countHeader+": "+vdiDesktopsListTotalCount+")");
				}
				else
				{
					mainTitle=mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience Overview for "+userType+" (Total users: "+vdiDesktopsListTotalCount+")");
				}
			}
			else
			{
				if(userType!=null && userType.equalsIgnoreCase("ESX"))
				{
					mainTitle=mappingInfo.getTextDescription("monitor.endUserDashboard.Performance Metrics for VMs (Total VMs : "+vdiDesktopsListTotalCount+")");
				}
				else 
				{
					mainTitle=mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience Overview for "+userType);
				}
			}
			listData.add(mainTitle);

			listData.add("");
			buf.append("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" style=\"table-layout:fixed;\"><tr><td>");
			buf.append("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" style=\"table-layout:fixed;\">");
			buf.append("<tr><td width=\"100%\" align=\"center\" height=\"100%\" valign=\"top\">");
			if(logo!=null && logo.trim().length()>0)
			{
				buf.append("<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\" align=\"center\">");
				buf.append("<tr><td style=\"padding:5px 10px 10px 10px\">");
				buf.append("<img src="+logo+" border=\"0\" /></td></tr></table>");
			}
			buf.append("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\"  style=\"border-bottom:1px solid #999;\">");
			buf.append("<tr><td style=\"padding:2px\"><div style=\"float:left\" ><header>"+mainTitle+"</header></div></td></tr></table>");
			buf.append("</td></tr></table>");
			
			buf.append("<table width=\"50%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"left\" >");
			
			if(searchString!=null && !searchString.equalsIgnoreCase("NULL") && searchString.trim().length()>0)
			{
				String key = mappingInfo.getTextDescription("monitor.endUserDashboard.Search By ");
				buf.append("<tr><td>");
				buf.append("<span style=\"float:left\" class=\"formLabel\">"+key+"</span> ");
				buf.append("<span style=\"float:left;width:10px\" align=\"center\" >:</span> ");
				buf.append("<span style=\"float:left;\" class=\"formValue\">"+searchString+"</span></td></tr>");

				listData.add(key+"="+searchString);
			}

			String currOrderByColumnName = request.getParameter("currOrderByColumn");
			String currOrderByName = request.getParameter("currOrderBy");
			if(currOrderByColumnName!=null && !currOrderByColumnName.equalsIgnoreCase("NULL") && currOrderByColumnName.trim().length()>0)
			{
				if(columnDispName!=null && columnDispName.trim().length()>0)
				{
					String orderByColText = mappingInfo.getTextDescription("monitor.endUserDashboard.Sort By");
					buf.append("<tr><td><span style=\"float:left\" class=\"formLabel\">"+orderByColText+"</span> ");
					buf.append("<span style=\"float:left;width:10px\" align=\"center\" >:</span> ");
					buf.append("<span style=\"float:left;\" class=\"formValue\">"+columnDispName+"</span></td>");

					listData.add(orderByColText+"="+columnDispName);
					if(currOrderByName!=null && !currOrderByName.equalsIgnoreCase("NULL") && currOrderByName.trim().length()>0)
					{
						String orderByText = mappingInfo.getTextDescription("monitor.endUserDashboard.Order By");
						if(currOrderByName!=null && currOrderByName.trim().length()>0 && currOrderByName.equalsIgnoreCase("desc"))
						{
							currOrderByName = mappingInfo.getTextDescription("monitor.endUserDashboard.Descending");
						}
						else if(currOrderByName!=null && currOrderByName.trim().length()>0 && currOrderByName.equalsIgnoreCase("asc"))
						{
							currOrderByName = mappingInfo.getTextDescription("monitor.endUserDashboard.Ascending");
						}
						buf.append("<td><span style=\"float:left\" class=\"formLabel\">"+orderByText+"</span> ");
						buf.append("<span style=\"float:left;width:10px\" align=\"center\" >:</span> ");
						buf.append("<span style=\"float:left;\" class=\"formValue\">"+currOrderByName+"</span></td>");
						listData.add(orderByText+"="+currOrderByName);
					}
					buf.append("</tr>");
				}
				else
				{
					String sortByDispCol = ini.getValue("USER_DESKTOP_METRICS",userType);
					ArrayList sortByDispColList =  new ArrayList();
					if(sortByDispCol!=null && sortByDispCol.trim().length()>0)
					{
						sortByDispColList = com.egurkha.util.StringUtils.egTokenizer(sortByDispCol,",",false,false,true);//param 3-->includeEmpty,4-->unique,5-->trim
					}
					if(sortByDispColList!=null && sortByDispColList.size()>0)
					{
						String sortByColDispName = "";
						for(int s = 0;s<sortByDispColList.size();s++)
						{
							String colName = (String)sortByDispColList.get(s);
							String tmpTest = colName.substring(0,colName.indexOf(":"));
							String tmpMeasure = "";
							tmpMeasure = colName.substring(colName.indexOf(":")+1);
							if(tmpMeasure!=null && tmpMeasure.trim().length()>0 && tmpMeasure.indexOf(":")>-1)
								tmpMeasure=tmpMeasure.substring(0,tmpMeasure.indexOf(":"));
							String tmpOrderByColName = Dbdata.getColumnForMeasure(tmpTest,tmpMeasure);
							if(tmpOrderByColName!=null && tmpOrderByColName.trim().length()>0 && tmpOrderByColName.equals(currOrderByColumnName))
								sortByColDispName = colName.substring(colName.lastIndexOf(":")+1);
						}
						if(sortByColDispName!=null && !sortByColDispName.equalsIgnoreCase("NULL") && sortByColDispName.trim().length()>0)
						{
							String orderByColText = mappingInfo.getTextDescription("monitor.endUserDashboard.Sort By");
							buf.append("<tr><td><span style=\"float:left\" class=\"formLabel\">"+orderByColText+"</span> ");
							buf.append("<span style=\"float:left;width:10px\" align=\"center\" >:</span> ");
							buf.append("<span style=\"float:left;\" class=\"formValue\">"+sortByColDispName+"</span></td>");

							listData.add(orderByColText+"="+sortByColDispName);

							if(currOrderByName!=null && !currOrderByName.equalsIgnoreCase("NULL") && currOrderByName.trim().length()>0)
							{
								String orderByText = mappingInfo.getTextDescription("monitor.endUserDashboard.Order By");
								if(currOrderByName!=null && currOrderByName.trim().length()>0 && currOrderByName.equalsIgnoreCase("desc"))
								{
									currOrderByName = mappingInfo.getTextDescription("monitor.endUserDashboard.Descending");
								}
								else if(currOrderByName!=null && currOrderByName.trim().length()>0 && currOrderByName.equalsIgnoreCase("asc"))
								{
									currOrderByName = mappingInfo.getTextDescription("monitor.endUserDashboard.Ascending");
								}
								buf.append("<td><span style=\"float:left\" class=\"formLabel\">"+orderByText+"</span> ");
								buf.append("<span style=\"float:left;width:10px\" align=\"center\" >:</span> ");
								buf.append("<span style=\"float:left;\" class=\"formValue\">"+currOrderByName+"</span></td>");

								listData.add(orderByText+"="+currOrderByName);
							}
							buf.append("</tr>");
						}
					}
				}
			}
			
			if((filterBy != null && filterBy.trim().length() > 0) || (searchFilter != null && searchFilter.trim().length() > 0) || (nextSearch != null && nextSearch.trim().length() > 0 && !nextSearch.trim().equals("-1"))){
				buf.append("<tr>");
				if(filterBy != null && filterBy.trim().length() > 0){
					String zoneName = mappingInfo.getTextDescription("monitor.endUserDashboard.Zone");
					buf.append("<td><span style=\"float:left\" class=\"formLabel\">"+zoneName+"</span> ");
					buf.append("<span style=\"float:left;width:10px\" align=\"center\" >:</span> ");
					buf.append("<span style=\"float:left;\" class=\"formValue\">"+filterBy+"</span></td>");

					listData.add(zoneName+"="+filterBy);
				}
				String filterByStr = mappingInfo.getTextDescription("monitor.endUserDashboard.Filter By");
				if(isShowSeparateFilters && searchFilDispTxt!=null && searchFilDispTxt.trim().length()>0 && !searchFilDispTxt.equalsIgnoreCase("NULL"))
					filterByStr = mappingInfo.getTextDescription("monitor.endUserDashboard."+searchFilDispTxt);

				if((isShowUserLocation) && searchFilter != null && searchFilter.trim().length() > 0 && !searchFilter.equalsIgnoreCase("NULL")){
					buf.append("<td><span style=\"float:left\" class=\"formLabel\">"+filterByStr+"</span> ");
					buf.append("<span style=\"float:left;width:10px\" align=\"center\" >:</span> ");
					buf.append("<span style=\"float:left;\" class=\"formValue\">"+searchFilter+"</span></td>");

					listData.add(filterByStr+"="+searchFilter);
				}
				String searchFilterStr = mappingInfo.getTextDescription("monitor.endUserDashboard."+searchFilter);
				if(isShowSeparateFilters && nextSearchFilDispTxt!=null && nextSearchFilDispTxt.trim().length()>0 && !nextSearchFilDispTxt.equalsIgnoreCase("NULL"))
					searchFilterStr = mappingInfo.getTextDescription("monitor.endUserDashboard."+nextSearchFilDispTxt);

				if((isShowUserLocation) && nextSearch != null && nextSearch.trim().length() > 0 && !nextSearch.trim().equals("-1") && !nextSearch.equalsIgnoreCase("NULL")){
					buf.append("<td><span style=\"float:left\" class=\"formLabel\">"+searchFilterStr+"</span> ");
					buf.append("<span style=\"float:left;width:10px\" align=\"left\" >:</span> ");
					buf.append("<span style=\"float:left;\" class=\"formValue\">"+nextSearch+"</span></td>");

					listData.add(searchFilterStr+"="+nextSearch);
				}
				buf.append("</tr>");
			}

			if(aduserFilter != null ){
				String adName = mappingInfo.getTextDescription("monitor.endUserDashboard.AD Group");
				buf.append("<tr><td><span style=\"float:left\" class=\"formLabel\">"+adName+"</span> ");
				buf.append("<span style=\"float:left;width:10px\" align=\"center\" >:</span> ");
				buf.append("<span style=\"float:left;\" class=\"formValue\">"+aduserFilter+"</span></td></tr>");

				listData.add(adName+"="+aduserFilter);
			}
			if(priorityFilter != null && priorityFilter.trim().length()>0 && !priorityFilter.equalsIgnoreCase("NULL")){
				String filterByLoc = mappingInfo.getTextDescription("monitor.endUserDashboard.Priority");
				buf.append("<tr><td><span style=\"float:left\" class=\"formLabel\">"+filterByLoc+"</span> ");
				buf.append("<span style=\"float:left;width:10px\" align=\"center\" >:</span> ");
				buf.append("<span style=\"float:left;\" class=\"formValue\">"+mappingInfo.getLabelDescription(priorityFilter)+"</span></td></tr>");

				listData.add(filterByLoc+"="+mappingInfo.getLabelDescription(priorityFilter));
			}
			buf.append("</table>");
			buf.append("</td></tr>");
			buf.append("<tr><td>");
			listData.add("");
			listData.add("");
			Vector headerVect = new Vector();
			buf.append("<table  border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"  height=\"auto\">");
				buf.append("<tr>");
					buf.append("<td width=\"100%\" valign=\"top\" height=\"100%\">");
						buf.append("<div>");
							buf.append("<table class=\"printTable\" border=\"0\"  style=\"width:100%;table-layout:auto !important\"  cellspacing=\"0\" cellpadding=\"0\"  valign=\"top\" >");
								buf.append("<thead>");
									buf.append("<tr >");
									if(!orderByCol_flag)
									{
										buf.append("<td class=\"printTableHeader\" align=\"center\" wrap >"+mappingInfo.getTextDescription("monitor.VirtualDashboard.Users/Desktops")+"</td>");
									}
									else
									{
										buf.append("<td class=\"printTableHeader\" align=\"center\"  wrap >"+mappingInfo.getTextDescription("monitor.VirtualDashboard.Users/Desktops")+ "</td>");
									}
									headerVect.add("");
									headerVect.add("Priority");
									headerVect.add(mappingInfo.getTextDescription("monitor.VirtualDashboard.Users/Desktops"));
									if(orderByColumnName!=null && orderByColumnName.equalsIgnoreCase("Host"))
									{
										buf.append("<td class=\"printTableHeader\" align=\"center\"  wrap >"+mappingInfo.getTextDescription("monitor.VirtualDashboard.Host")+"</td>");
									}
									else
									{
										buf.append("<td class=\"printTableHeader\" align=\"center\"  wrap >"+mappingInfo.getTextDescription("monitor.VirtualDashboard.Host")+ "</td>");
									}

									headerVect.add(mappingInfo.getTextDescription("monitor.VirtualDashboard.Host"));
			String widthOfTheHead="";
			String strVdiHostCombo=ini.getValue("END_USER_DASHBOARD_SETTINGS","showVdiHostCombo");
			strVdiHostCombo=(strVdiHostCombo==null || strVdiHostCombo.trim().length()==0)?"false":strVdiHostCombo;
			String strVdiDefaultHost=ini.getValue("END_USER_DASHBOARD_SETTINGS","Default_VdiType");
			strVdiDefaultHost=(strVdiDefaultHost==null || strVdiDefaultHost.trim().length()==0)?"":strVdiDefaultHost;
			boolean showVdiHostCombo = "true".equalsIgnoreCase(strVdiHostCombo)?true:false;
			boolean isSkipVal = false;
			ArrayList skippedColumns = new ArrayList();
			if(showVdiHostCombo && vdiType!=null && vdiType.trim().length()>0)
			{
				strVdiDefaultHost = vdiType;
			}
		
			String measures=null;
			String measuresD=null;
			String measuresT=null;
			if(userName!=null && userName.trim().length()>0)
			{
				measures = ini.getValue("USER_DESKTOP_METRICS",userName+":"+userType);
			}
		
			if(measures==null || measures.trim().length()==0)
			{
				measuresD = ini.getValue("USER_DESKTOP_METRICS","DEFAULT_"+userType);
				measuresT = ini.getValue("USER_DESKTOP_METRICS",userType);
				if(measuresD != null && measuresD.trim().length() > 0)
				{
					measures = measuresD;
				}
				else
				{
					measures = measuresT;
				}
			}
			String[] measureArray = measures.split(",");
			ArrayList displayColsList = new ArrayList();
			ArrayList validColsList = new ArrayList();
			Hashtable sameLabelHash = new Hashtable();
			measuresCount = measureArray.length;
			for(int x=0;x<measureArray.length;x++)
			{
				String tempValue = measureArray[x];
				String tempTest = "";
				String tempMeasure = "";
				String tempDispName = "";
				String locKeyName = "";
				String colName = "";
				ArrayList locColumnsList = null;
				StringTokenizer valTokens = new StringTokenizer(tempValue,":");
				int count = valTokens.countTokens();
				boolean isDDDColumn = false;
				boolean isLocColumn = false;
				boolean isTestColumn = false;
				String meas ="";
				if (valTokens.hasMoreTokens())
				{
					if(count==3)
					{
						tempTest = valTokens.nextToken();
						tempMeasure = valTokens.nextToken();
						tempDispName = valTokens.nextToken();
						isTestColumn=true;
					}
					else if(count==2)
					{
						if(isShowUserLocation)
						{
							tempTest = valTokens.nextToken();
							tempMeasure = valTokens.nextToken();
							//tempDispName = mappingInfo.getMeasureDescription(tempTest,tempMeasure);
							isLocColumn = true;
							meas = "NONE";

							ArrayList tmpMeasureList = new ArrayList();
							tmpMeasureList = StringUtils.egTokenizer(tempMeasure,"~$~",true,false,true);//param 3-->includeEmpty,4-->unique,5-->trim
							if(tmpMeasureList!=null && tmpMeasureList.size()>0)
							{
								int meaListSize=tmpMeasureList.size();
								if(meaListSize==1)
								{
									tempDispName = tempMeasure;
								}
								else if(meaListSize>1)
								{
									tempDispName = (String)tmpMeasureList.get(1);
								}
							}
						}
					}
					else if(count==5)
					{
						tempTest = valTokens.nextToken();
						tempMeasure = valTokens.nextToken();
						colName = valTokens.nextToken();
						meas = valTokens.nextToken();
						tempDispName = valTokens.nextToken();
						isDDDColumn = true;
						//mappingInfo.getMeasureDescription(tempTest+"_DDD",tempMeasure);
					}
				}

				if(isTestColumn || isDDDColumn || isLocColumn)
				{
					boolean isTestRelevantForServer = true;
					if(showVdiHostCombo && strVdiDefaultHost!=null && strVdiDefaultHost.trim().length()>0)
					{
						isTestRelevantForServer = specsInfo.isTestRelevantForServer(strVdiDefaultHost,tempTest);
					}
					if(!isTestRelevantForServer)
					{
						continue;
					}
					if(displayColsList!=null && displayColsList.contains(tempDispName))
					{
						if(sameLabelHash!=null && sameLabelHash.containsKey(tempDispName))
						{
							ArrayList tmp_list=(ArrayList)sameLabelHash.get(tempDispName);
							tmp_list.add(tempValue);
							sameLabelHash.put(tempDispName,(ArrayList)tmp_list);
						}
						else
						{
							ArrayList tmp_list=new ArrayList();
							tmp_list.add(tempValue);
							sameLabelHash.put(tempDispName,(ArrayList)tmp_list);
						}

						continue;
					}

					String unitForMeasure="";
					if(isDDDColumn && meas!=null && meas.trim().length()>0 &&(!meas.equalsIgnoreCase("NONE")&&!meas.equalsIgnoreCase("DATE")))
					{
						unitForMeasure = "("+meas+")";
					}
					else if(!isDDDColumn && !isLocColumn)
					{
						//unitForMeasure="&nbsp;("+tablesInfo.getUnitForMeasure(tempTest,tempMeasure.trim())+")";
						String unitVal=tablesInfo.getUnitForMeasure(tempTest,tempMeasure.trim());

						if(unitVal!=null && unitVal.trim().length()>0)
						{
							unitForMeasure="&nbsp;("+unitVal+")";
						}
					}
					if(unitForMeasure!=null && unitForMeasure.indexOf("MB")>-1)
						unitForMeasure ="&nbsp;(GB)";

					if(tempDispName!=null && tempDispName.equalsIgnoreCase("Status")){
						unitForMeasure="";
					}
					else if(tempDispName!=null && (tempDispName.equalsIgnoreCase("Disk Used") || tempDispName.equalsIgnoreCase("Used Space"))){
						unitForMeasure="("+mappingInfo.getTextDescription("monitor.VirtualDashboard.GB")+")";
					}
					String orderByColumn = "";
					if(isLocColumn)
					{
						orderByColumn = tempDispName;
						//orderByColumnName = tempDispName;
					}
					else if (isDDDColumn)
					{
						orderByColumn = Dbdata.getColumnForMeasure(tempTest+"_DDD",colName);
						//col_name = dbInfo.getColumnForMeasure(test+"_DDD",tmp_col_name);
						//orderByColumnName = Dbdata.getColumnForMeasure(tempTest,tempMeasure);
					}
					else
					{
						orderByColumn = Dbdata.getColumnForMeasure(tempTest,tempMeasure); 
					}
					if(orderByColumn!=null && orderByColumn.trim().length()>0 && orderByColumnName!=null && orderByColumnName.trim().length()>0 && orderByColumnName.equalsIgnoreCase(orderByColumn))
					{
						String nextOrderBy="desc";
						//String sortImgurl="/final/monitor/eg_images/arrow_down_black_small.gif";
						String sortImgurl="/final/images/Dark/grid_sort_top.png";
					
						if(orderBy!=null && orderBy.equals("desc"))
						{
							nextOrderBy="asc";
							//sortImgurl="/final/monitor/eg_images/arrow_down_black_small.gif";
							sortImgurl="/final/images/Dark/grid_sort_down.png";
						}
						else if(orderBy!=null && orderBy.equals("asc"))
						{
							nextOrderBy="desc";
							sortImgurl="/final/images/Dark/grid_sort_top.png";
						}

						if(isDDDColumn || (isShowUserLocation && isLocColumn))
						{
							if((unitForMeasure==null || unitForMeasure.equals(""))&& (meas!=null && !meas.equalsIgnoreCase("DATE")))
							{
								//buf.append("<td class=\"printTableHeader\" align=\"center\" wrap >"+tempDispName+"</br>"+unitForMeasure+" <div style=\"float:right;padding:3px\"><img id=\"sortImg\" src=\""+sortImgurl+"\"/> </td>");
								buf.append("<td class=\"printTableHeader\" align=\"center\" wrap >"+tempDispName+"</br>"+unitForMeasure+" <div style=\"float:right;padding:3px\"></td>");
							}
							else
							{
								buf.append("<td class=\"printTableHeader\" align=\"center\" wrap >"+tempDispName+"</br>"+unitForMeasure+" <div style=\"float:right;padding:3px\"></td>");
							}

							headerVect.add(tempDispName+unitForMeasure);
						}
						else
						{
							if(unitForMeasure==null || unitForMeasure.equals(""))
							{
								buf.append("<td class=\"printTableHeader\" align=\"center\" wrap  >"+tempDispName+"<div style=\"float:right;padding:3px\"></td>");
								headerVect.add(tempDispName);
							}
							else
							{
								buf.append("<td class=\"printTableHeader\" align=\"center\" wrap  >"+tempDispName+"</br>"+unitForMeasure+" <div style=\"float:right;padding:3px\"></td>");
								headerVect.add(tempDispName+unitForMeasure);
							}
						}
					}
					else
					{
						if(isDDDColumn || (isShowUserLocation && isLocColumn))
						{
							if((unitForMeasure==null || unitForMeasure.equals("")) && (meas!=null && !meas.equalsIgnoreCase("DATE")))
							{
								buf.append("<td class=\"printTableHeader\" align=\"center\" wrap >"+tempDispName+" </td>");
								headerVect.add(tempDispName);
							}
							else
							{
								buf.append("<td class=\"printTableHeader\" align=\"center\" wrap > "+tempDispName+"</br>"+unitForMeasure+" </td>");
								headerVect.add(tempDispName+unitForMeasure);
							}
						}
						else
						{
							if(unitForMeasure==null || unitForMeasure.equals(""))
							{
								buf.append("<td class=\"printTableHeader\" align=\"center\" wrap > "+tempDispName+" </td>");
								headerVect.add(tempDispName);
							}
							else
							{
								buf.append("<td class=\"printTableHeader\" align=\"center\" wrap > "+tempDispName+"</br>"+unitForMeasure+" </td>");
								headerVect.add(tempDispName+unitForMeasure);
							}
						}
					}
					if(displayColsList!=null && tempDispName!=null && !displayColsList.contains(tempDispName))
					{
						displayColsList.add(tempDispName);
						if(sameLabelHash!=null && sameLabelHash.containsKey(tempDispName))
						{
							ArrayList tmp_list=(ArrayList)sameLabelHash.get(tempDispName);
							tmp_list.add(tempValue);
							sameLabelHash.put(tempDispName,(ArrayList)tmp_list);
						}
						else
						{
							ArrayList tmp_list=new ArrayList();
							tmp_list.add(tempValue);
							sameLabelHash.put(tempDispName,(ArrayList)tmp_list);
						}
					}

					if(validColsList!=null && tempValue!=null && !validColsList.contains(tempValue)) 
						validColsList.add(tempValue);
				}
			}
			if(validColsList!=null && validColsList.size()>0)
			{
				measureArray = new String[validColsList.size()];
				int yy=0;
				for(int y=0;y<validColsList.size();y++)
				{
					String tempValue1 = (String)validColsList.get(y);
					if(tempValue1!=null && tempValue1.trim().length()>0)
					{
						measureArray[yy++]=tempValue1;
					}
				}
			}

				buf.append("</tr>");
				buf.append("</thead>");
				buf.append("<tbody>");
				listData.add(headerVect);
			EgService serv = null;
			int desktopsSize = (vdiDesktopsList!=null && vdiDesktopsList.size()>0)?vdiDesktopsList.size():0;
			Hashtable desktopHtml = new Hashtable();
			Hashtable desktopCSV = new Hashtable();
			ArrayList deskTopList = new ArrayList();
			
			for(int i=0;i<desktopsSize;i++)
			{
				StringBuffer bufRow = new StringBuffer();
				Vector dataVect = new Vector();
				serv = (EgService)vdiDesktopsList.get(i);
				String trBackground = "eg_lightlight";
				if(i%2==0)
					trBackground = "eg_whitebg";

				String desktopComponent = serv.getName();
				String desktopState = serv.getState().getName();
				String desktopName = "";
				String comp = "";
				String compValue = "";
				String compName = "";
				String compNameWithOutPort = "";

				if(desktopComponent!=null && desktopComponent.indexOf("^")>-1)
				{
					desktopName = desktopComponent.substring(0,desktopComponent.indexOf("^"));
					comp = desktopComponent.substring(desktopComponent.indexOf("^")+1);
				}

				deskTopList.add(desktopName);

				if(comp!=null && comp.indexOf(":")>-1)
				{
					compValue = comp.substring(0,comp.indexOf(":"));
					compName = comp.substring(comp.indexOf(":")+1);
				}
				if(compName!=null && compName.indexOf(":")>-1)
				{
					compNameWithOutPort = compName.substring(0,compName.indexOf(":"));
				}
				measureValues = (Hashtable)TotalMeasureInfo.get(comp);
				String msmtHost = "";
				String ctype_layer=ini.getValue("USER_DESKTOP_LAYERS",compValue);
				ctype_layer=(ctype_layer==null || ctype_layer.trim().length()==0)?"VIRTUAL_DESKTOP":ctype_layer;
				ArrayList arr = tablesInfo.getTestsForLayer(ctype_layer);
				if(arr!=null && arr.size()>0)
				{
					boolean flag=true;
					for (int t=0;t<arr.size();t++)
					{
						String insideviewTest=(String) arr.get(t);
						if(insideviewTest!=null && insideviewTest.trim().length()>0)
						{
							List agents=egExternalInfo.getAgentsFor(insideviewTest.trim(),compValue,compNameWithOutPort);

							if(agents!=null && agents.size()>0)
							{
								msmtHost=(String)agents.get(0);
								flag=false;
								break;
							}
						}
					}

					if(flag)
						msmtHost=compNameWithOutPort;
				}
				else
					msmtHost=compNameWithOutPort;

				String tempHostType = compValue;
				String url_desktopName=com.egurkha.util.StringUtils.replace(desktopName, "\\", "\\");
				String url = "/final/monitor/endUserDashboardDetailsData.jsp?comp="+EgURLEncoder.encode(compName,"UTF-8")+"&comptype="+compValue+"&info=*"+EgURLEncoder.encode(url_desktopName,"UTF-8")+"&compName="+EgURLEncoder.encode(compName+":"+compValue,"UTF-8")+"&componentName="+EgURLEncoder.encode(compNameWithOutPort,"UTF-8")+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&user="+EgURLEncoder.encode(userName,"UTF-8")+"&searchString="+EgURLEncoder.encode(searchString,"UTF-8")+"&priority="+priority+"&vdiType="+vdiType+"&userType="+userType;

				if(fromMenuStr!=null && fromMenuStr.trim().length()>0)
				{
					url=url+"&fromMenu="+fromMenuStr;
				}
				String link ="";
				if(fromMenuStr!=null && !fromMenuStr.equalsIgnoreCase("null") && fromMenuStr.trim().length()>0)
				{
					link = "/final/servlet/com.eg.EgDashboardController?site=NULL"+"&from=list&comptype="+EgURLEncoder.encode(compValue,"UTF-8")+"&host="+EgURLEncoder.encode(compName,"UTF-8")+"&tab=LayerModel";
				}
				else
				{
					link = "/final/monitor/endUserDashboardDetailsData.jsp?comp="+EgURLEncoder.encode(compName,"UTF-8")+"&comptype="+compValue+"&info=*"+EgURLEncoder.encode(url_desktopName,"UTF-8")+"&compName="+EgURLEncoder.encode(compName+":"+compValue,"UTF-8")+"&componentName="+EgURLEncoder.encode(compNameWithOutPort,"UTF-8")+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&user="+EgURLEncoder.encode(userName,"UTF-8")+"&searchString="+EgURLEncoder.encode(searchString,"UTF-8")+"&priority="+priority+"&vdiType="+vdiType+"&userType="+userType;
				}
				String disp_desktopName=desktopName;
				//if(disp_desktopName!=null && disp_desktopName.length()>30)
					//disp_desktopName=disp_desktopName.substring(0,30)+"..";

				String strName = compName;
				if (strName.endsWith(EgConstants.NULL_PORT) && (strName.indexOf(EgConstants.NULL_PORT) > -1))
				{
					strName = Server.getServerNameWithoutPort(strName, false);
				}

				String disp_StrName = strName;
				if(disp_StrName!=null && disp_StrName.length()>22)
					disp_StrName=disp_StrName.substring(0,22)+"..";

									bufRow.append("<tr class=\"x-grid-row  x-grid-row-alt\" style=\"background:none\">");
										bufRow.append("<td >");
											bufRow.append("<table cellspacing=\"0\" cellpadding=\"2\" border=\"0\">");
												bufRow.append("<tr style=\"background:none !important\">");
													bufRow.append("<td style=\"border:none;\">");

				/*if(desktopName.endsWith("[Template]") || desktopName.endsWith("[template]"))
				{
						bufRow.append("<div style=\"text-align:center;padding:2px 6px 5px 5px\"><img src=\"/final/monitor/eg_images/template_vm_"+desktopState+".gif\"></div>");
				}
				else if(desktopName.endsWith("[Orphaned]") || desktopName.endsWith("[orphaned]"))
				{
						bufRow.append("<div style=\"text-align:center;padding:2px 6px 5px 5px\"><img src=\"/final/monitor/eg_images/orphan_vm_"+desktopState+".gif\"></div>");
				}
				else
				{
					if(desktopName!=null && desktopName.toLowerCase().indexOf("vio")>-1)
					{
								bufRow.append("<div style=\"text-align:center;padding:2px 6px 5px 5px\"><img src=\"/final/monitor/eg_images/vio_"+desktopState+".gif\"></div>");
					}
					else
					{*/
								bufRow.append("<div style=\"text-align:center;padding:2px 6px 5px 5px\"><img src=\"/final/images/Dark/eud_"+desktopState+".png\"/></div>");
					//}
				//}
								
													bufRow.append("</td>");
													bufRow.append("<td style=\"border:none;word-break: break-all;\" >");
														bufRow.append(disp_desktopName);
													bufRow.append("</td>");
												bufRow.append("</tr>");
											bufRow.append("</table>");
										bufRow.append("</td>");
										bufRow.append("<td>");
											bufRow.append("<div style=\"font-size:12px;float:left;position:relative;visibility:visible;text-align:left;\"><div style=\"padding-top:4px;\">"+disp_StrName+"</div></div>");
											dataVect.add("");
											String labeldeskState = mappingInfo.getLabelDescription(desktopState);
											dataVect.add(labeldeskState);
											dataVect.add(disp_desktopName);
											dataVect.add(disp_StrName);
										bufRow.append("</td>");

				measureList = Arrays.asList(measureArray);
				if(measureValues!=null && measureValues.size()>0)
				{
					String ctype_out_layer=ui.getValue("Layer_for_ComponentType",compValue);
					ctype_out_layer=(ctype_out_layer==null || ctype_out_layer.trim().length()==0)?"VIRTUAL_GUESTS":ctype_out_layer;
					ArrayList listOfTest=(ArrayList)tablesInfo.getTestsForLayer(ctype_out_layer,compValue);

					int p=0;
					String info_to_lower=desktopName;
					while(p<measureList.size())
					{
						String keyForList = (String)measureList.get(p);
						String keyMeasure = "";
						String keyOrgMeasure = "";
						String keyTest = "";
						String keydisplayMeasure = "";
						StringTokenizer valTokens = new StringTokenizer(keyForList,":");
						int tokCount = valTokens.countTokens();
						boolean isDDDTestColumn = false;
						boolean isLocationColumn = false;
						if(tokCount==5)
							isDDDTestColumn = true;
						else if(tokCount==2)
							isLocationColumn = true;
						String orgColName = "";
						String funcName = "";
						String dispName = "";
						
						String tempDispName = "";
						String locKeyName = "";
						String Value="";
						String units="";
						
						ArrayList keyMeasureList = null; 
						ArrayList locMeasuresList = new ArrayList(); 
						if(isDDDTestColumn)
						{
							if(keyForList!=null && keyForList.indexOf(":")>-1)
							{
								keyTest=keyForList.substring(0,keyForList.indexOf(":"));
								keyMeasure=keyForList.substring(keyForList.indexOf(":")+1);
								if(keyMeasure!=null && keyMeasure.indexOf(":")>-1)
								{
									orgColName=keyMeasure.substring(keyMeasure.indexOf(":")+1);
									keyMeasure = keyMeasure.substring(0,keyMeasure.indexOf(":"));
									if(orgColName!=null && orgColName.indexOf(":")>-1)
									{
										funcName=orgColName.substring(orgColName.indexOf(":")+1);
										orgColName = orgColName.substring(0,orgColName.indexOf(":"));
									}
									if(funcName!=null && funcName.indexOf(":")>-1)
									{
										dispName = funcName.substring(funcName.indexOf(":")+1);
										funcName = funcName.substring(0,funcName.indexOf(":"));
									}
								}
							}

							if(keyTest!=null && keyTest.trim().length()>0 && listOfTest!=null && !listOfTest.contains(keyTest) && dispName!=null)
							{
								ArrayList tmpArry=(ArrayList)sameLabelHash.get(dispName);
								if(tmpArry!=null && tmpArry.size()>0)
								{
									for(int kk=0;kk<tmpArry.size();kk++)
									{
										keyForList =(String)tmpArry.get(kk);

										if(keyForList!=null && keyForList.indexOf(":")>-1)
										{
											keyTest=keyForList.substring(0,keyForList.indexOf(":"));
											keyMeasure=keyForList.substring(keyForList.indexOf(":")+1);
											if(keyMeasure!=null && keyMeasure.indexOf(":")>-1)
											{
												orgColName=keyMeasure.substring(keyMeasure.indexOf(":")+1);
												keyMeasure = keyMeasure.substring(0,keyMeasure.indexOf(":"));
												if(orgColName!=null && orgColName.indexOf(":")>-1)
												{
													funcName=orgColName.substring(orgColName.indexOf(":")+1);
													orgColName = orgColName.substring(0,orgColName.indexOf(":"));

													if(funcName!=null && funcName.indexOf(":")>-1)
													{
														dispName=funcName.substring(funcName.indexOf(":")+1);
														funcName = funcName.substring(0,funcName.indexOf(":"));
													}
												}
											}
										}

										if(keyTest!=null && keyTest.trim().length()>0 && listOfTest!=null && listOfTest.contains(keyTest))
										{
											break;
										}
									}
								}
							}

							String colKeyName = Dbdata.getColumnForMeasure(keyTest+"_DDD",orgColName);
							String tmpK = colKeyName+"^"+info_to_lower.toLowerCase()+"^"+compNameWithOutPort;
							Value=(String)measureValues.get(colKeyName+"^"+info_to_lower+"^"+compNameWithOutPort);
							if(Value==null){
								Value=(String)measureValues.get(colKeyName+"^"+info_to_lower.toLowerCase()+"^"+compNameWithOutPort);
							}
						}
						else if(isShowUserLocation && isLocationColumn)
						{
							if(keyForList!=null && keyForList.indexOf(":")>-1)
							{
								keyTest=keyForList.substring(0,keyForList.indexOf(":"));
								keyMeasure=keyForList.substring(keyForList.indexOf(":")+1);
							}

							funcName ="NONE";

							if(keyMeasure!=null && keyMeasure.trim().length()>0)
							{
								keyMeasureList = StringUtils.egTokenizer(keyMeasure,"~$~",true,false,true);//param 3-->includeEmpty,4-->unique,5-->trim
								if(keyMeasureList!=null && keyMeasureList.size()>0)
								{
									int meaListSize=keyMeasureList.size();
									if(meaListSize==1)
									{
										locKeyName = (String)keyMeasureList.get(0);
									}
									else if(meaListSize>1)
									{
										locKeyName = (String)keyMeasureList.get(0);
									}

									Value=(String)measureValues.get(locKeyName+"^"+info_to_lower+"^"+compNameWithOutPort);

									if(Value==null)
									{
										Value=(String)measureValues.get(locKeyName+"^"+info_to_lower.toLowerCase()+"^"+compNameWithOutPort);
									}

									if(meaListSize==1 && strSeparator!=null && strSeparator.trim().length()>0 && strReplaceSep!=null && strReplaceSep.trim().length()>0 && Value!=null && !Value.equals("-"))
									{
										Value = com.egurkha.util.StringUtils.replace(Value,strSeparator,strReplaceSep);
									}
								}
							}
						}
						else
						{
							if(keyForList!=null && keyForList.indexOf(":")>-1)
							{
								keyTest=keyForList.substring(0,keyForList.indexOf(":"));
								keyMeasure=keyForList.substring(keyForList.indexOf(":")+1);
								if(keyMeasure!=null && keyMeasure.indexOf(":")>-1)
								{
									keydisplayMeasure=keyMeasure.substring(keyMeasure.indexOf(":")+1);
									keyMeasure=keyMeasure.substring(0,keyMeasure.indexOf(":"));
								}
							}
							units=tablesInfo.getUnitForMeasure(keyTest,keyMeasure);
							keyOrgMeasure = keyMeasure;
							keyMeasure = Dbdata.getColumnForMeasure(keyTest,keyMeasure);
							if(specsInfo.isTestRelevantForServer(compValue,keyTest))
							{
								Value=(String)measureValues.get(keyMeasure+"^"+info_to_lower+"^"+compNameWithOutPort);
								if(Value==null){
									Value=(String)measureValues.get(keyMeasure+"^"+info_to_lower.toLowerCase()+"^"+compNameWithOutPort);
								}
							}
						}
						
						//if((Value==null || Value.trim().length()==0) && compValue!=null && compValue.equals("Xen_desktop_server"))
						if(Value==null || Value.trim().length()==0)
						{
							if(info_to_lower!=null && (info_to_lower.indexOf(" ")>-1 && info_to_lower.indexOf("on")>-1))
							{
								ArrayList tokenList =  com.egurkha.util.StringUtils.egTokenizer(info_to_lower, " on ",false,false,true);//param 3-->includeEmpty,4-->unique,5-->trim
								if(tokenList!=null && tokenList.size()==2)
								{
									info_to_lower=(String)tokenList.get(0)+"_on_"+(String)tokenList.get(1);
								}
							}
							Value=(String)measureValues.get(keyMeasure+"^"+info_to_lower+"^"+compNameWithOutPort);
							if(Value==null)
							{
								Value=(String)measureValues.get(keyMeasure+"^"+info_to_lower.toLowerCase()+"^"+compNameWithOutPort);
							}
						}
						String mes_state="";
						String mes_name="";
						String total_spc="0";

						if(Value!=null && Value.indexOf("^")>-1)
						{
							mes_state=Value.substring(Value.indexOf("^")+1);
							if(mes_state!=null && mes_state.indexOf("^")>-1)
							{
								mes_name=mes_state.substring(mes_state.indexOf("^")+1);
								mes_state=mes_state.substring(0,mes_state.indexOf("^"));
								if(mes_name!=null && mes_name.indexOf("^")>-1)
								{
									total_spc=mes_name.substring(mes_name.indexOf("^")+1);
									mes_name=mes_name.substring(0,mes_name.indexOf("^"));
								}
							}
							Value=Value.substring(0,Value.indexOf("^"));
						}
						else if(Value==null)
						{
							Value="-";
							mes_name=keyMeasure;
							mes_state="GOOD";
						}

						boolean sameLabelFlag=false;
						if(sameLabelHash!=null && sameLabelHash.size()>0 && keydisplayMeasure!=null && sameLabelHash.containsKey(keydisplayMeasure))
						{
							ArrayList tmpArry=(ArrayList)sameLabelHash.get(keydisplayMeasure);
							if(tmpArry!=null && tmpArry.size()>0 && keyForList!=null && tmpArry.contains(keyForList))
								tmpArry.remove(keyForList);

							if(tmpArry!=null && tmpArry.size()>0)
							{
								sameLabelFlag=true;
								if(!dashboardModel.isTestActive(compValue, compName, keyTest, "custom"))
									Value="-";
							}
						}

						if((Value==null || Value.equals("-")) && sameLabelFlag && (sameLabelHash!=null && sameLabelHash.size()>0 && sameLabelHash.containsKey(keydisplayMeasure)))
						{
							ArrayList tmpArry=(ArrayList)sameLabelHash.get(keydisplayMeasure);
							if(tmpArry!=null && tmpArry.size()>0)
							{
								if(tmpArry.contains(keyForList))
									tmpArry.remove(keyForList);

								for(int kk=0;kk<tmpArry.size();kk++)
								{
									keyForList =(String)tmpArry.get(kk);
									String tmp_keyTest=null;
									String tmp_keyMeasure=null;
									String tmp_keydisplayMeasure=null;
									if(keyForList!=null && keyForList.indexOf(":")>-1)
									{
										tmp_keyTest=keyForList.substring(0,keyForList.indexOf(":"));
										tmp_keyMeasure=keyForList.substring(keyForList.indexOf(":")+1);
										if(tmp_keyMeasure!=null && tmp_keyMeasure.indexOf(":")>-1)
										{
											tmp_keydisplayMeasure=tmp_keyMeasure.substring(tmp_keyMeasure.indexOf(":")+1);
											tmp_keyMeasure=tmp_keyMeasure.substring(0,tmp_keyMeasure.indexOf(":"));
										}
									}
									
									String tmp_units=tablesInfo.getUnitForMeasure(tmp_keyTest,tmp_keyMeasure);
									String tmp_keyOrgMeasure = tmp_keyMeasure;
									tmp_keyMeasure = Dbdata.getColumnForMeasure(tmp_keyTest,tmp_keyMeasure);
									String tmp_Value=null;
									if(specsInfo.isTestRelevantForServer(compValue,tmp_keyTest))
									{
										//System.out.println("tmp_keyMeasure--->"+tmp_keyMeasure);
										tmp_Value=(String)measureValues.get(tmp_keyMeasure+"^"+info_to_lower+"^"+compNameWithOutPort);
										if(tmp_Value==null){
											tmp_Value=(String)measureValues.get(tmp_keyMeasure+"^"+info_to_lower.toLowerCase()+"^"+compNameWithOutPort);
										}
									}

									if(tmp_Value==null || tmp_Value.trim().length()==0)
									{
										if(info_to_lower!=null && (info_to_lower.indexOf(" ")>-1 && info_to_lower.indexOf("on")>-1))
										{
											ArrayList tokenList =  com.egurkha.util.StringUtils.egTokenizer(info_to_lower, " on ",false,false,true);//param 3-->includeEmpty,4-->unique,5-->trim
											if(tokenList!=null && tokenList.size()==2)
											{
												info_to_lower=(String)tokenList.get(0)+"_on_"+(String)tokenList.get(1);
											}
										}
										tmp_Value=(String)measureValues.get(tmp_keyMeasure+"^"+info_to_lower+"^"+compNameWithOutPort);
										if(tmp_Value==null)
										{
											tmp_Value=(String)measureValues.get(tmp_keyMeasure+"^"+info_to_lower.toLowerCase()+"^"+compNameWithOutPort);
										}
									}

									if(tmp_Value!=null && tmp_Value.indexOf("^")>-1)
									{
										String tmp_mes_state=tmp_Value.substring(tmp_Value.indexOf("^")+1);
										String tmp_total_spc=null;
										String tmp_mes_name=null;
										if(tmp_mes_state!=null && tmp_mes_state.indexOf("^")>-1)
										{
											tmp_mes_name=tmp_mes_state.substring(tmp_mes_state.indexOf("^")+1);
											tmp_mes_state=tmp_mes_state.substring(0,tmp_mes_state.indexOf("^"));
											if(tmp_mes_name!=null && tmp_mes_name.indexOf("^")>-1)
											{
												total_spc=tmp_mes_name.substring(tmp_mes_name.indexOf("^")+1);
												tmp_mes_name=tmp_mes_name.substring(0,tmp_mes_name.indexOf("^"));
											}
										}
										tmp_Value=tmp_Value.substring(0,tmp_Value.indexOf("^"));

										if(tmp_Value!=null && !tmp_Value.trim().equals("-"))
										{
											keyTest=tmp_keyTest;
											keyMeasure=tmp_keyMeasure;
											Value=tmp_Value;
											total_spc= tmp_total_spc;
											mes_name=tmp_mes_name;
											mes_state=tmp_mes_state;
											break;
										}
									}
								}
							}
						}

						widthOfTheHead="60";
						if(units!=null && units.equals("%")) 
							widthOfTheHead="150";
						
						String orgValue="0.0";
						try
						{
							if(Value!=null && Value.trim().length()>0 && Value.indexOf(".")>-1 && Double.parseDouble(Value)>0)
							{
								orgValue=Value;
								//Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
								if(decimalFormatTestMeasureList!=null && decimalFormatTestMeasureList.size()>0 && decimalFormatTestMeasureList.contains(keyTest+":"+keyOrgMeasure))
								{
									Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),4));
								}
								else if(convertToDaysTestMeasureList!=null && convertToDaysTestMeasureList.size()>0 && convertToDaysTestMeasureList.contains(keyTest+":"+keyOrgMeasure))
								{
									Value = getConvertDays(Value,egDashboard);
								}
								else
								{
									Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
								}
								Value=String.valueOf(Value);
							}
							else if(Value!=null && Value.trim().length()>0  && Double.parseDouble(Value)>0)
							{
								orgValue=Value;
								//Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
								if(decimalFormatTestMeasureList!=null && decimalFormatTestMeasureList.size()>0 && decimalFormatTestMeasureList.contains(keyTest+":"+keyOrgMeasure))
								{
									Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),4));
								}
								else if(convertToDaysTestMeasureList!=null && convertToDaysTestMeasureList.size()>0 && convertToDaysTestMeasureList.contains(keyTest+":"+keyOrgMeasure))
								{
									Value = getConvertDays(Value,egDashboard);
								}
								else
								{
									Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
								}
								Value=String.valueOf(Value);
							}
						}
						catch(Exception ee)
						{
							Value=Value;
							orgValue=Value;
						}
						if(mes_state!=null && mes_state.length()>0 && mes_state.equalsIgnoreCase("NONE"))
						{
							mes_state="GOOD";
						}
						else if(mes_state!=null && mes_state.trim().length()==0)
						{
							mes_state="GOOD";
						}
						if(Value.equalsIgnoreCase("on"))
						{
							bufRow.append("<td align=\"center\" ><img  src=\"/final/monitor/eg_images/yes2.gif\"></td>"); 
						}
						else if(Value.equalsIgnoreCase("off"))
						{
							bufRow.append("<td align=\"center\" ><img  src=\"/final/monitor/eg_images/no2.gif\"></td>");
						}
						else
						{
							String measuresLink = "";
							if(fromMenuStr!=null && !fromMenuStr.equalsIgnoreCase("null") && fromMenuStr.trim().length()>0 && fromMenuStr.equalsIgnoreCase("true"))
							{
								String layerName = tablesInfo.getRelevantLayer(compValue,keyTest,keyOrgMeasure);
								layerName=(layerName==null || layerName.trim().length()==0)?ctype_layer:layerName;
								
								String infoKey = compValue+":"+compName+":"+keyTest+":"+info_to_lower;
								HashSet infosSet = null;
								if(fullInfoHash!=null && fullInfoHash.size()>0)
									infosSet = (HashSet)fullInfoHash.get(infoKey);
								ArrayList infosList = null;
								if(infosSet!=null && infosSet.size()>0)
									infosList = new ArrayList(infosSet);
								String info_name = "";
								if(infosList!=null && infosList.size()>1)
								{
									for(int is=0;is<infosList.size();is++)
									{
										String tmpInfo = (String)infosList.get(is);
										if(tmpInfo!=null && (tmpInfo.endsWith(":Summary") || tmpInfo.endsWith(":Total")))
										{
											info_name = tmpInfo;
											break;
										}
									}
									if(info_name==null || info_name.equalsIgnoreCase("null") || info_name.trim().length()==0)
									{
										info_name = (String)infosList.get(0);
									}
								}
								else if(infosList!=null && infosList.size()==1)
								{
									info_name = (String)infosList.get(0);
								}
								if(info_name==null || info_name.equalsIgnoreCase("null") || info_name.trim().length()==0)
								{
									info_name = "+" + info_to_lower;
								}
								measuresLink = "/final/monitor/EgSiteInfraView.jsp?qctr=2"+"&site=NULL"+"&fromalarm=0"+"&newWindow=false"+"&host="+EgURLEncoder.encode(compName,"UTF-8")+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&comptype="+compValue+"&layer="+layerName+"&test="+keyTest+"-"+EgURLEncoder.encode(info_name,"UTF-8")+"&tstate="+mes_state+"&toDashBoardLayer=true";
							}

							if(mes_name!=null)
							{
								if(Value!=null && !Value.equals("-"))
								{
									try
									{
										double fillColorValue=Double.parseDouble(orgValue);
										if(units!=null && units.equals("MB"))
										{
											//units = "GB";
											fillColorValue=fillColorValue/1024.0;
										}
										Value=String.valueOf(fillColorValue);
										//Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
										if(Value!=null && Value.trim().length()>0 && Value.indexOf(".")>-1 && Double.parseDouble(Value)>0)
										{
											if(decimalFormatTestMeasureList!=null && decimalFormatTestMeasureList.size()>0 && decimalFormatTestMeasureList.contains(keyTest+":"+keyOrgMeasure))
											{
												Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),4));
											}
											else if(convertToDaysTestMeasureList!=null && convertToDaysTestMeasureList.size()>0 && convertToDaysTestMeasureList.contains(keyTest+":"+keyOrgMeasure))
											{
												Value = getConvertDays(Value,egDashboard);
											}
											else
											{
												Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
											}

										}
										else
										{
											Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
										}
									}
									catch(Exception ee)
									{
										Value=String.valueOf(orgValue);
									}

									if(isDDDTestColumn || isLocationColumn)
									{
										bufRow.append("<td  align=\"left\"  >");
										bufRow.append("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"left\">");
									}
									else
									{
										bufRow.append("<td  align=\"center\" >");
										bufRow.append("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"right\">");
									}
									bufRow.append("<tr style=\"background:none !important\">");
									if(fromMenuStr!=null && !fromMenuStr.equalsIgnoreCase("null") && fromMenuStr.trim().length()>0 && fromMenuStr.equalsIgnoreCase("true"))
									{
										if(isDDDTestColumn || isLocationColumn)
										{
											bufRow.append("<td class=\"mouse\" align=\"left\" style=\"text-align:left;\" \"data-qtip=\""+Value+"\" data-qclass=\"yellowTip\" >");
											
										}
										else
										{
											bufRow.append("<td class=\"mouse\" align=\"right\" >");
										}
									}
									else
									{
										if(isDDDTestColumn || isLocationColumn)
										{
											bufRow.append("<td style=\"white-space:pre-wrap;border:none;\" align=\"left\">");
										}
										else
										{
											bufRow.append("<td style=\"white-space:pre-wrap;border:none;\" align=\"left\">");
										}
									}
								}
								else
								{
									if(isDDDTestColumn || isLocationColumn)
									{
										bufRow.append("<td  style=\"text-align:left;\" align=\"left\" >");
											bufRow.append("<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" borderColor=\"red\"  style=\"table-layout:auto;\" align=\"left\">");
									}
									else
									{
										bufRow.append("<td align=\"center\" >");
											bufRow.append("<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" borderColor=\"green\"  style=\"table-layout:auto;\" align=\"right\">");
									}
									bufRow.append("<tr style=\"background:none !important\">");
									if(fromMenuStr!=null && !fromMenuStr.equalsIgnoreCase("null") && fromMenuStr.trim().length()>0 && fromMenuStr.equalsIgnoreCase("true"))
									{
										if(isDDDTestColumn||isLocationColumn)
										{
											bufRow.append("<td align=\"left\" style=\"border:none;padding-right:10px;text-align:left;\" >");
										}
										else
										{
											bufRow.append("<td class=\"mouse\" align=\"left\" style=\"border:none;padding-right:10px\" >");
										}
									}
									else
									{
										bufRow.append("<td align=\"left\" style=\"border:none;padding-right:10px\">");
									}
								}
							}
							else
							{
								bufRow.append("<td  style=\"padding-top:4px;\" align=\"center\"  >");
									bufRow.append("<table cellspacing=\"0\" cellpadding=\"0\" style=\"table-layout:auto;border:0px solid red;border:none;\" align=\"right\">");
										bufRow.append("<tr style=\"background:none !important\">");
											if(fromMenuStr!=null && !fromMenuStr.equalsIgnoreCase("null") && fromMenuStr.trim().length()>0 && fromMenuStr.equalsIgnoreCase("true"))
											{
												if(isDDDTestColumn||isLocationColumn)
												{
													bufRow.append("<td align=\"right\" style=\"font-size:11px;text-align:right;width:20px;padding-right:10px\" >");
												}
												else
												{
													bufRow.append("<td class=\"mouse\" align=\"right\" style=\"font-size:11px;text-align:right;width:20px;padding-right:10px\" onClick=\"javascript:goToDetails('"+measuresLink+"');\" >");
												}
											}
											else
											{
												bufRow.append("<td align=\"right\" style=\"font-size:11px;text-align:right;width:20px;padding-right:10px\">");
											}
							}

							Value = formatDbValue(Value);
							
							if(Value!=null && !Value.equals("-"))
							{
								boolean usage =true;
								if(mes_name!=null && mes_name.equalsIgnoreCase("Cpu_used"))
								{
									usage = false;
									int columnWidth = 100;
									Long temp_measure_value=new Long(Math.round(Double.parseDouble(Value)));
									long fillColorValue=temp_measure_value.longValue();
									long value1 = (fillColorValue*100)/columnWidth;
									String mes_state_GOOD="";
									if (mes_state.equals("GOOD"))
									{
										mes_state_GOOD="#3baeda";
									}

									String mes_state_code="#3baeda";
									try
									{
										mes_state_code=ui.getValue("STATE_COLORS",mes_state);
										mes_state_code="#"+mes_state_code;
									}
									catch(Exception eee)
									{
										mes_state_code="#3baeda";
									}
														bufRow.append("<div style=\"width:80px;padding:0px;margin:0px;background:#e1e1e1;\">");
														//bufRow.append("<tr`>");
															//bufRow.append("<td align=\"left\" width=\"100%\" height=\"6\" //class=\"prog_line\">");
																//bufRow.append("<div style=\"width:"+value1+"% !important;display:inline-block;z-index:25000;height:6px;background:"+mes_state_GOOD+"\" height=\"6\">");
																bufRow.append("<div style=\"width:"+value1+"% !important;display:inline-block;z-index:25000;height:6px;background:"+mes_state_code+"\" height=\"6\">");
																		//bufRow.append("<div width=\"100%\" style=\"border:0px solid yellow;display:block;z-index:25000;height:6px\"></div>");
																bufRow.append("</div>");
															//bufRow.append("</td>");
														//bufRow.append("</tr>");
													bufRow.append("</div>");
								}
								else if(units!=null && units.equals("%") && !mes_name.equalsIgnoreCase("Ready") && usage)
								{
									int columnWidth = 100;
									Long temp_measure_value=new Long(Math.round(Double.parseDouble(Value)));
									long fillColorValue=temp_measure_value.longValue();
									long value2 = (fillColorValue*100)/columnWidth;
									String mes_state_GOOD="";
									if (mes_state.equals("GOOD"))
									{
										mes_state_GOOD="#3baeda";
									}

									String mes_state_code="#3baeda";
									try
									{
										mes_state_code=ui.getValue("STATE_COLORS",mes_state);
										mes_state_code="#"+mes_state_code;
									}
									catch(Exception eee)
									{
										mes_state_code="#3baeda";
									}
													bufRow.append("<div style=\"width:80px;padding:0px;margin:0px;background:#e1e1e1;\">");
														//bufRow.append("<tr`>");
															//bufRow.append("<td align=\"left\" width=\"100%\" height=\"6\" //class=\"prog_line\">");
																//bufRow.append("<div style=\"width:"+value2+"% !important;display:inline-block;z-index:25000;height:6px;background:"+mes_state_GOOD+"\" height=\"6\">");
																bufRow.append("<div style=\"width:"+value2+"% !important;display:inline-block;z-index:25000;height:6px;background:"+mes_state_code+"\" height=\"6\">");
																		//bufRow.append("<div width=\"100%\" style=\"border:0px solid yellow;display:block;z-index:25000;height:6px\"></div>");
																bufRow.append("</div>");
															//bufRow.append("</td>");
														//bufRow.append("</tr>");
													bufRow.append("</div>");
								}
							}
							bufRow.append("</td>");
							String meaStateLabel = mappingInfo.getLabelDescription(mes_state);
							if(Value!=null && !Value.equals("-"))
							{
								boolean usage =true;
								if(isDDDTestColumn || isLocationColumn)
								{
									dataVect.add(Value);
									if(mes_name!=null && mes_name.equalsIgnoreCase("Cpu_used"))
									{
										usage =false;
										bufRow.append("<td style=\"border:none;text-align:left;padding-left:3px;width:42px;white-space:nowrap\">"+Value+"</td>");
									}
									else if(units!=null && units.equals("%") && !mes_name.equalsIgnoreCase("Ready") && usage)
									{
										bufRow.append("<td style=\"border:none;text-align:left;padding-left:3px;width:42px;white-space:nowrap\">"+Value+"</td>");
									}
									else
									{
										if(funcName!=null && (funcName.equalsIgnoreCase("NONE") || funcName.equalsIgnoreCase("DATE")))
										{
											bufRow.append("<td style=\"border:none;text-align:left;padding-left:3px;width:42px;white-space:nowrap\">"+Value+"</td>");
										}
										else
										{
											bufRow.append("<td style=\"border:none;text-align:right;padding-left:3px;width:42px;white-space:nowrap\">"+Value+"</td>");
										}
									}
								}
								else
								{
									dataVect.add("("+meaStateLabel+")"+Value);

									if(mes_name!=null && mes_name.equalsIgnoreCase("Cpu_used"))
									{
										usage =false;
										bufRow.append("<td style=\"border:none;text-align:left;padding-left:3px;width:42px;white-space:nowrap\">"+Value+"</td>");
									}
									else if(units!=null && units.equals("%") && !mes_name.equalsIgnoreCase("Ready") && usage)
									{
										bufRow.append("<td style=\"border:none;text-align:left;padding-left:3px;width:42px;white-space:nowrap\">"+Value+"</td>");
									}
									else
									{
										if(funcName!=null && (funcName.equalsIgnoreCase("NONE") || funcName.equalsIgnoreCase("DATE")))
										{
											//bufRow.append("<td style=\"border:none;text-align:left;padding-left:3px;width:42px;white-space:nowrap\"><table border='0'><tr style='background:none !important'><td><img src=\"/final/images/Dark/stateTick_"+mes_state+".png\"/></td><td>"+Value+"</td></tr></table></td>");

											//bufRow.append("<td style=\"border:none;text-align:left;padding-left:3px;width:42px;white-space:nowrap\"><div class='stateSymbol_"+mes_state+"' style='margin:auto;float:left;display:table-cell'></div>"+Value+"</td>");

											bufRow.append("<td style=\"border:none;text-align:left;padding-left:3px;width:42px;white-space:nowrap\"><table border='0'><tr style='background:none !important'><td><div class='stateSymbol_"+mes_state+"' style='margin:auto;float:left;display:table-cell'></div></td><td>"+Value+"</td></tr></table></td>");
										}
										else
										{
											//bufRow.append("<td style=\"border:none;text-align:right;padding-left:3px;width:42px;white-space:nowrap\"><table border='0'><tr style='background:none !important'><td><img src=\"/final/images/Dark/stateTick_"+mes_state+".png\"/></td><td>"+Value+"</td></tr></table></td>");

											//bufRow.append("<td style=\"border:none;text-align:right;padding-left:3px;width:42px;white-space:nowrap\"><div class='stateSymbol_"+mes_state+"' style='margin:auto;float:left;display:table-cell'></div>"+Value+"</td>");

											bufRow.append("<td style=\"border:none;text-align:right;padding-left:3px;width:42px;white-space:nowrap\"><table border='0'><tr style='background:none !important'><td><div class='stateSymbol_"+mes_state+"' style='margin:auto;float:left;display:table-cell'></div></td><td>"+Value+"</td></tr></table></td>");
										}
									}
								}
							}
							else
							{
								dataVect.add(Value);
								if(isDDDTestColumn || isLocationColumn)
								{
									bufRow.append("<td style=\"border:none;text-align:right;padding-left:3px;padding-right:30px;width:42px;white-space:nowrap\">"+Value+"</td>");
								}
								else
								{
									boolean usage =true;
									if(mes_name!=null && mes_name.equalsIgnoreCase("Cpu_used"))
									{
										bufRow.append("<td style=\"border:none;text-align:center;padding-left:3px;padding-right:30px;width:42px;white-space:nowrap\">"+Value+"</td>");
									}
									else if(units!=null && units.equals("%") && !mes_name.equalsIgnoreCase("Ready") && usage)
									{
										bufRow.append("<td style=\"border:none;text-align:center;padding-left:3px;padding-right:30px;width:42px;white-space:nowrap\">"+Value+"</td>");
									}
									else
									{
										bufRow.append("<td style=\"border:none;text-align:right;padding-left:3px;width:42px;white-space:nowrap\">"+Value+"</td>");
									}
								}
							}
										bufRow.append("</tr>");
									bufRow.append("</table>");
								bufRow.append("</td>");
						}
						p++;
					}
				}
				else
				{
					int p=0;
					while(p<measureList.size())
					{
									//bufRow.append("<td style=\"font-size:11px;text-align:right;width:20px;padding-right:10px;!important\" align=\"right\" class=\"x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first\">-</td>"); 
									bufRow.append("<td  style=\"padding-top:4px;\" align=\"center\" >");
										bufRow.append("<table cellspacing=\"0\" cellpadding=\"0\" style=\"table-layout:auto;border:0px solid red\" align=\"left\">");
											bufRow.append("<tr style=\"background:none !important\">");
												//bufRow.append("<td align=\"right\" style=\"font-size:11px;text-align:right;width:20px;padding-right:10px\">");
												//bufRow.append("</td>");
												bufRow.append("<td style=\"text-align:left;border:none;\">");
												bufRow.append("-</td>");
											bufRow.append("</tr>");
										bufRow.append("</table>");
									bufRow.append("</td>");
									dataVect.add("-");
						p++;
					}
				}

				bufRow.append("</tr>");
				desktopHtml.put(desktopName,bufRow.toString());
				desktopCSV.put(desktopName,dataVect);
			}

			Hashtable formation = new Hashtable();
			ArrayList defaultList = new ArrayList();
			for(int p=0;p<deskTopList.size();p++){
				String deskName = (String)deskTopList.get(p);
				if(userRelatedAd != null && userRelatedAd.containsKey("+"+deskName)){
					ArrayList adList = (ArrayList)userRelatedAd.get("+"+deskName);
					for(int m=0;m<adList.size();m++){
						String adName = (String)adList.get(m);

						if(formation.containsKey(adName)){
							ArrayList userList = (ArrayList)formation.get(adName);
							userList.add(deskName);
							formation.put(adName,userList);
						}else{
							ArrayList userL = new ArrayList();
							userL.add(deskName);
							formation.put(adName,userL);
						}
					}
				}
				else if(userRelatedAd != null && userRelatedAd.containsKey(deskName)){
					ArrayList adList = (ArrayList)userRelatedAd.get(deskName);
					for(int m=0;m<adList.size();m++){
						String adName = (String)adList.get(m);

						if(formation.containsKey(adName)){
							ArrayList userList = (ArrayList)formation.get(adName);
							userList.add(deskName);
							formation.put(adName,userList);
						}else{
							ArrayList userL = new ArrayList();
							userL.add(deskName);
							formation.put(adName,userL);
						}
					}
				}
				else{
					defaultList.add(deskName);
				}
			}
			
			boolean checkCase=false;

			if(formation != null && formation.size() > 0 && !defaultAdCase ){
				Iterator it = formation.entrySet().iterator();
				if(aduserFilter == null || aduserFilter.trim().length() == 0)
					aduserFilter="All";
				while(it.hasNext()){
					Entry entry = (Entry)it.next();
					String key = (String)entry.getKey();
					ArrayList value = (ArrayList)entry.getValue();

					if(!aduserFilter.equalsIgnoreCase("All") ){
						if(!aduserFilter.equals(key))
							continue;
					}
					if(value != null && value.size() > 0){
						checkCase = true;
						buf.append("<tr class='x-grid-row  x-grid-row-alt' style='background:none'><td colspan='"+measuresCount+"' ><span style=\"float:left;\"><img style=\"margin-top:2px;margin-right:3px\" src=\"/final/images/Light/ux_adgroup_user.png\"/></span>"+key+"("+value.size()+")"+"</td></tr>");
						key="\""+key+"("+value.size()+")"+"\""; 
						listData.add(key);
						for(int q=0;q<value.size();q++){
							String usName = (String)value.get(q);
							if(desktopHtml != null && desktopHtml.containsKey(usName)){
								String html = (String)desktopHtml.get(usName);
								Vector dataVect = (Vector)desktopCSV.get(usName);
								listData.add(dataVect);
								buf.append(html);
							}
						}
					}

				}
			}

			if(aduserFilter.equalsIgnoreCase("All") ){
				if(defaultList != null && defaultList.size() > 0){
					checkCase = true;
					//buf.append("<tr class='x-grid-row  x-grid-row-alt' style='background:none;' ><td colspan='"+measuresCount+"'> <span style=\"float:left;margin-right:3px\"><img src=\"/final/images/Light/ux_default_user.png\"></span> Default  ("+defaultList.size()+")"+"</td></tr>");
					buf.append("<tr class='x-grid-row  x-grid-row-alt' style='background:none;' ><td colspan='"+measuresCount+"' style=\"padding-left:19px\">Default  ("+defaultList.size()+")"+"</td></tr>");

					
					listData.add("Default ("+defaultList.size()+")");
					for(int i=0;i<defaultList.size();i++){
						String defaultdesName = (String)defaultList.get(i);
						if(desktopHtml != null && desktopHtml.containsKey(defaultdesName)){
							String html = (String)desktopHtml.get(defaultdesName);
							Vector dataVect = (Vector)desktopCSV.get(defaultdesName);
							listData.add(dataVect);
							buf.append(html);
						}
					}
				}
			}

								buf.append("</tbody>");	
							buf.append("</table>");
						buf.append("</div>");
					buf.append("</td>");
				buf.append("</tr>");
			buf.append("</table>");
			isDataAvailable = true;
			if(!checkCase){
				buf.delete(0, buf.length());

				buf.append("<table border=\"0\" width=\"100%\" height=\"100%\" bordercolor=\"green\">");
					buf.append("<tr style=\"background:none\">");
						buf.append("<td align=\"center\" width=\"100%\"  height=\"100%\" class=\"commonErrorMsgText\" >");
							buf.append("<img src = \"/final/images/spacer.gif\" class=\"iconExclamation\" lign = \"center\" border = \"0\"  vspace = \"10\"/>");
							buf.append("<br>"+mappingInfo.getTextDescription("monitor.endUserDashboard.No Records Found"));
						buf.append("</td>");
					buf.append("</tr>");
				buf.append("</table>");
				isDataAvailable = false;
			}
			buf.append("</td></tr></table>");
		}
		else if(isEndUserOverview || isFromUEDSort)
		{
			boolean isPriority = false;
			boolean isAllRow = false;
			int locCount = 0;

			String statenames[] = {"HIGH","INTERMEDIATE","LOW","UNKNOWN","GOOD"};
			ArrayList searchUserKeys = new ArrayList();
			if(priority!=null && !priority.equalsIgnoreCase("ALL"))
			{
				groupByUserKeys = (ArrayList)vmDashHelper.getUEDSubList(groupByUserKeys,priority,pageNo);
				isPriority = true;
			}
			if((!isFromUEDSort) && vmDashHelper!=null && TotalMeasureInfo!=null)
				groupByUserKeys = (ArrayList)vmDashHelper.getSortedListForUEDOverview(groupByUserKeys,TotalMeasureInfo,"enduseroverview","Health",orderBy,"Health");
			if(searchString!=null && searchString.trim().length()>0 && !searchString.equalsIgnoreCase("null") && !searchString.equalsIgnoreCase("all"))
			{
				if(groupByUserKeys!=null && groupByUserKeys.size()>0)
				{
					int groupByUserKeysSize = groupByUserKeys.size();
					for(int s=0;s<groupByUserKeysSize;s++)
					{
						String search_key = (String)groupByUserKeys.get(s);
						String search_str = "";
						if(search_key!=null && search_key.trim().length()>0 && !search_key.equalsIgnoreCase("null") && search_key.indexOf("~$~")>-1)
						{
							search_str = search_key.substring(0,search_key.indexOf("~$~"));
						}
						else
						{
							search_str = search_key;
						}
						if(search_str!=null && search_str.trim().length()>0 && !search_str.equalsIgnoreCase("null") && (search_str.trim().toLowerCase().indexOf(searchString.trim().toLowerCase())>-1) && !searchUserKeys.contains(search_key))
							searchUserKeys.add(search_key); 
					}
					groupByUserKeys = searchUserKeys;
				}
			}
			else if(searchString!=null && searchString.trim().length()>0 && searchString.equalsIgnoreCase("all"))
			{
				searchUserKeys.add("All"); 
				groupByUserKeys = searchUserKeys;
			}
			else
			{
				groupByUserKeys.add(0,"All");
				isAllRow = true;
			}
			if(groupByUserKeys!=null && groupByUserKeys.size()>0)
			{
				locCount = groupByUserKeys.size();
				if(isAllRow)
					locCount = locCount - 1;
			}
			buf.append("<link rel='stylesheet' type='text/css' href='/final/styles/eGLightThemeIcons.css' />");
			buf.append("<style>@media print {body {-webkit-print-color-adjust: exact;}}");
			buf.append("@font-face{font-family:'LucidaGrandeRegular';src:url('../../fonts/6216/6216.woff') format('woff')}");
			buf.append("@font-face{font-family:'LucidaGrandeBold';src:url('../../fonts/6215/6215.woff') format('woff')}");
			buf.append("body{font-family:'LucidaGrandeRegular';font-size:11px;line-height:1.5em;color:#2a292a;}");
			buf.append("header{font-family:'LucidaGrandeRegular';font-size:15px;}");
			buf.append(".formLabel {font-family:'LucidaGrandeRegular';font-size:12px;line-height:14px;}");
			buf.append(".formValue {font-family:'LucidaGrandeBold';font-size:12px;line-height:14px;} b{font-family:'LucidaGrandeBold';font-size:11px;}");
			buf.append("table tr td{font-family:'LucidaGrandeRegular';font-size:11px;padding:4px;}");
			buf.append(".printTable{border: 1px solid #c3c3c3; border-collapse:collapse;word-break:break-all;}");
			buf.append(".printTableHeader{font-family:'LucidaGrandeBold';border: 1px solid #c3c3c3;text-align:center;background-color:#cdcdcd;padding:4px;}");
			buf.append(".printTable tr td{border: 1px solid #c3c3c3;}");
			buf.append(".printTable tbody tr td{border: 1px solid #c3c3c3;}");
			buf.append(".printTable tbody tr td table tr td{border: 0px solid #c3c3c3 !important;}");
			buf.append(".printTable div{word-break:break-all;	}");
			buf.append(".printTable thead{font-family:'LucidaGrandeBold';border: 1px solid #c3c3c3;text-align:center;background-color:#cdcdcd;padding:4px;}");
			buf.append(".printTableHeader2{font-family:'LucidaGrandeBold';border: 1px solid #c3c3c3;text-align:center;background-color:#dcdcdc;padding:4px;}</style>");
			
			IniUI img1=IniUI.getInstance();
			String logo=img1.getMonitorHomeLogo();
			if(img1.isHKTThemeEnabled())
			{
				logo = img1.getHKTReporterLogo();
			}
			String grpByStr = ini.getValue("LOC_USER_DESKTOP_METRICS","Header:"+userType);
			if(grpByStr!=null && grpByStr.trim().length()>0 && !grpByStr.equalsIgnoreCase("null"))
			{
				if(grpByStr.indexOf(":")>-1 && grpByStr.indexOf(",")>-1)
					grpByStr = grpByStr.substring(grpByStr.indexOf(":")+1,grpByStr.indexOf(","));
			}
			String mainTitle = ""; //mappingInfo.getTextDescription("monitor.endUserDashboard.Users By Location for")+" "+userType;
			if(locCount>0 && (searchString!=null && !searchString.equalsIgnoreCase("all")))
			{
				String tmpGrpByStr = "";
				if(grpByStr!=null && grpByStr.trim().length()>0 && grpByStr.equalsIgnoreCase("City"))
					tmpGrpByStr = "Cities";
				else if(grpByStr!=null && grpByStr.trim().length()>0 && grpByStr.equalsIgnoreCase("Country"))
					tmpGrpByStr = "Countries";
				else
					tmpGrpByStr = grpByStr;

				if(userType!=null && userType.trim().length()>0 && (userType.equalsIgnoreCase("XenApp") || userType.equalsIgnoreCase("XenApp7")))
				{
					mainTitle = mappingInfo.getTextDescription("monitor.endUserDashboard.Citrix User Experience By "+grpByStr+" for"+" "+userType+" (Total "+tmpGrpByStr+": "+locCount+")");
					listData.add(mappingInfo.getTextDescription("monitor.endUserDashboard.Citrix User Experience By "+grpByStr+" for"+" "+userType+" (Total "+tmpGrpByStr+": "+locCount+")"));
				}
				else
				{
					mainTitle = mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience By "+grpByStr+" for"+" "+userType+" (Total "+tmpGrpByStr+": "+locCount+")");
					listData.add(mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience By "+grpByStr+" for"+" "+userType+" (Total "+tmpGrpByStr+": "+locCount+")"));
				}
			}
			else
			{
				if(userType!=null && userType.trim().length()>0 && (userType.equalsIgnoreCase("XenApp") || userType.equalsIgnoreCase("XenApp7")))
				{
					mainTitle = mappingInfo.getTextDescription("monitor.endUserDashboard.Citrix User Experience By "+grpByStr+" for"+" "+userType);
					listData.add(mappingInfo.getTextDescription("monitor.endUserDashboard.Citrix User Experience By "+grpByStr+" for"+" "+userType));
				}
				else
				{
					mainTitle = mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience By "+grpByStr+" for"+" "+userType);
					listData.add(mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience By "+grpByStr+" for"+" "+userType));
				}
			}
			listData.add("");
			buf.append("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" style=\"table-layout:fixed;\">");
			buf.append("<tr><td width=\"100%\" align=\"center\" height=\"100%\" valign=\"top\">");
			if(logo!=null && logo.trim().length()>0)
			{
				buf.append("<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\" align=\"center\">");
				buf.append("<tr><td style=\"padding:5px 10px 10px 10px\">");
				buf.append("<img src="+logo+" border=\"0\" /></td></tr></table>");
			}
			buf.append("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\"  style=\"border-bottom:1px solid #999;\">");
			buf.append("<tr><td style=\"padding:2px\"><div style=\"float:left\" ><header>"+mainTitle+"</header></div></td></tr></table>");
			buf.append("</td></tr></table>");
			
			buf.append("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"left\" style=\"table-layout:fixed;\">");
			if(groupByUserKeys!=null && groupByUserKeys.size()>0 &&  finalGroupByUserTab!=null && finalGroupByUserTab.size()>0)
			{
				if(searchString!=null && !searchString.equalsIgnoreCase("NULL") && searchString.trim().length()>0)
				{
					String key = mappingInfo.getTextDescription("monitor.endUserDashboard.Search By ");
					buf.append("<tr><td>");
					buf.append("<span style=\"float:left\" class=\"formLabel\">"+key+"</span> ");
					buf.append("<span style=\"float:left;width:10px\" align=\"center\" >:</span> ");
					buf.append("<span style=\"float:left;\" class=\"formValue\">"+searchString+"</span></td>");
					listData.add(key+"="+searchString);
				}

				String currOrderByColumnName = request.getParameter("currOrderByColumn");
				String currOrderByName = request.getParameter("currOrderBy");
				
				if(isFromUEDSort && currOrderByColumnName!=null && !currOrderByColumnName.equalsIgnoreCase("NULL") && currOrderByColumnName.trim().length()>0)
				{
					if(columnDispName!=null && columnDispName.trim().length()>0)
					{
						String orderByColText = mappingInfo.getTextDescription("monitor.endUserDashboard.Sort By");
						buf.append("<tr><td><table><tr><td><span style=\"float:left\" class=\"formLabel\">"+orderByColText+"</span> ");
						buf.append("<span style=\"float:left;width:10px\" align=\"center\" >:</span> ");
						buf.append("<span style=\"float:left;\" class=\"formValue\">"+columnDispName+"</span></td>");
						listData.add(orderByColText+"="+columnDispName);

						if(currOrderByName!=null && !currOrderByName.equalsIgnoreCase("NULL") && currOrderByName.trim().length()>0)
						{
							String orderByText = mappingInfo.getTextDescription("monitor.endUserDashboard.Order By");
							if(currOrderByName!=null && currOrderByName.trim().length()>0 && currOrderByName.equalsIgnoreCase("desc"))
							{
								currOrderByName = mappingInfo.getTextDescription("monitor.endUserDashboard.Descending");
							}
							else if(currOrderByName!=null && currOrderByName.trim().length()>0 && currOrderByName.equalsIgnoreCase("asc"))
							{
								currOrderByName = mappingInfo.getTextDescription("monitor.endUserDashboard.Ascending");
							}
							buf.append("<td style=\"padding-left:20px\"><span style=\"float:left\" class=\"formLabel\">"+orderByText+"</span> ");
							buf.append("<span style=\"float:left;width:10px\" align=\"center\" >:</span> ");
							buf.append("<span style=\"float:left;\" class=\"formValue\">"+currOrderByName+"</span></td></tr></table></td>");
							listData.add(orderByText+"="+currOrderByName);
						}
						buf.append("</tr>");
					}
					else
					{
						String sortByDispCol = ini.getValue("USER_DESKTOP_METRICS",userType);
						ArrayList sortByDispColList =  new ArrayList();
						if(sortByDispCol!=null && sortByDispCol.trim().length()>0)
						{
							sortByDispColList = com.egurkha.util.StringUtils.egTokenizer(sortByDispCol,",",false,false,true);//param 3-->includeEmpty,4-->unique,5-->trim
						}
						if(sortByDispColList!=null && sortByDispColList.size()>0)
						{
							String sortByColDispName = "";
							for(int s = 0;s<sortByDispColList.size();s++)
							{
								String colName = (String)sortByDispColList.get(s);
								String tmpTest = colName.substring(0,colName.indexOf(":"));
								String tmpMeasure = "";
								tmpMeasure = colName.substring(colName.indexOf(":")+1);
								if(tmpMeasure!=null && tmpMeasure.trim().length()>0 && tmpMeasure.indexOf(":")>-1)
									tmpMeasure=tmpMeasure.substring(0,tmpMeasure.indexOf(":"));
								String tmpOrderByColName = Dbdata.getColumnForMeasure(tmpTest,tmpMeasure);
								if(tmpOrderByColName!=null && tmpOrderByColName.trim().length()>0 && tmpOrderByColName.equals(currOrderByColumnName))
									sortByColDispName = colName.substring(colName.lastIndexOf(":")+1);
							}
							if(sortByColDispName!=null && !sortByColDispName.equalsIgnoreCase("NULL") && sortByColDispName.trim().length()>0)
							{
								String orderByColText = mappingInfo.getTextDescription("monitor.endUserDashboard.Sort By");
								buf.append("<tr><td><span style=\"float:left\" class=\"formLabel\">"+orderByColText+"</span> ");
								buf.append("<span style=\"float:left;width:10px\" align=\"center\" >:</span> ");
								buf.append("<span style=\"float:left;\" class=\"formValue\">"+sortByColDispName+"</span></td>");

								listData.add(orderByColText+"="+sortByColDispName);

								if(currOrderByName!=null && !currOrderByName.equalsIgnoreCase("NULL") && currOrderByName.trim().length()>0)
								{
									String orderByText = mappingInfo.getTextDescription("monitor.endUserDashboard.Order By");
									if(currOrderByName!=null && currOrderByName.trim().length()>0 && currOrderByName.equalsIgnoreCase("desc"))
									{
										currOrderByName = mappingInfo.getTextDescription("monitor.endUserDashboard.Descending");
									}
									else if(currOrderByName!=null && currOrderByName.trim().length()>0 && currOrderByName.equalsIgnoreCase("asc"))
									{
										currOrderByName = mappingInfo.getTextDescription("monitor.endUserDashboard.Ascending");
									}
									buf.append("<td><span style=\"float:left\" class=\"formLabel\">"+orderByText+"</span> ");
									buf.append("<span style=\"float:left;width:10px\" align=\"center\" >:</span> ");
									buf.append("<span style=\"float:left;\" class=\"formValue\">"+currOrderByName+"</span></td>");
									listData.add(orderByText+"="+currOrderByName);
								}
								buf.append("</tr>");
							}
						}
					}
				}
				listData.add("");
				listData.add("");
				Vector headerVect = new Vector();
				//buf.append("</table>");
				//buf.append("<table  border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"  height=\"auto\">");
					buf.append("<tr>");
						buf.append("<td colspan=\"3\" width=\"100%\" valign=\"top\" height=\"100%\">");
							buf.append("<div>");
								buf.append("<table style=\"table-layout:fixed\" width=\"100%\" class=\"printTable\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"  valign=\"top\" >");
									buf.append("<thead>");
										buf.append("<tr >");

				String measures=null;
				if(userName!=null && userName.trim().length()>0)
				{
					measures = ini.getValue("LOC_USER_DESKTOP_METRICS","Header:"+userType);
				}

				String[] measureArray = measures.split(",");
				measuresCount = measureArray.length;
				int colCount = measuresCount+1;

				for(int x=0;x<measureArray.length;x++)
				{
					String tempValue = measureArray[x];
					String tempTest = "";
					String tempMeasure = "";
					String tempLocColName = "";
					String tempDispName = "";
					String locKeyName = "";
					String colName = "";
					ArrayList locColumnsList = null;
					StringTokenizer valTokens = new StringTokenizer(tempValue,":");
					int count = valTokens.countTokens();
					boolean isDDDColumn = false;
					boolean isLocColumn = false;
					boolean isTestColumn = false;
					String meas ="";
					if(valTokens.hasMoreTokens())
					{
						if(count==2)
						{
							tempLocColName = valTokens.nextToken();
							tempDispName = valTokens.nextToken();
							isLocColumn = true;
							meas = "NONE";
						}
						else if(count==4)
						{
							tempTest = valTokens.nextToken();
							tempMeasure = valTokens.nextToken();
							tempDispName = valTokens.nextToken();
							meas = valTokens.nextToken();
							isDDDColumn = true;
						}
					}

					if(isDDDColumn || isLocColumn)
					{
						String unitForMeasure="";
						String meaUnit="";
						if(isDDDColumn && meas!=null && meas.trim().length()>0)
						{
							unitForMeasure = "("+meas+")";
						}
						
						String orderByColumn = "";
						if(isLocColumn)
						{
							orderByColumn = tempDispName;
						}
						else if (isDDDColumn)
						{
							orderByColumn = Dbdata.getColumnForMeasure(tempTest,tempMeasure);
						}
						else
						{
							orderByColumn = Dbdata.getColumnForMeasure(tempTest,tempMeasure); 
						}
						if(isFromUEDSort && (orderByColumn!=null && orderByColumn.trim().length()>0 && orderByColumnName!=null && orderByColumnName.trim().length()>0 && orderByColumnName.equalsIgnoreCase(orderByColumn)))
						{
							String nextOrderBy="desc";
							String sortImgurl="/final/images/Dark/grid_sort_top.png";
						
							if(orderBy!=null && orderBy.equals("desc"))
							{
								nextOrderBy="asc";
								sortImgurl="/final/images/Dark/grid_sort_down.png";
							}
							else if(orderBy!=null && orderBy.equals("asc"))
							{
								nextOrderBy="desc";
								sortImgurl="/final/images/Dark/grid_sort_top.png";
							}

							if(isLocColumn)
							{
								if(tempDispName!=null && tempDispName.trim().length()>0 && tempDispName.equals("Health"))
								{
									buf.append("<td class=\"printTableHeader\" align=\"center\" wrap >"+tempDispName+"</td>");
									headerVect.add(tempDispName);
								}
								else if(tempLocColName!=null && tempLocColName.trim().length()>0 && tempLocColName.equalsIgnoreCase("Total_Users"))
								{
									buf.append("<td class=\"printTableHeader\" align=\"center\" wrap style=\"float:right;padding:3px;\">"+tempDispName+"</td>");
									headerVect.add(tempDispName);
								}
								else
								{
									buf.append("<td class=\"printTableHeader\" align=\"center\" wrap style=\"float:right;padding:3px;\">"+tempDispName+"</td>");
									headerVect.add(tempDispName);
								}
							}
							else
							{
								if(unitForMeasure==null || unitForMeasure.equals(""))
								{
									buf.append("<td class=\"printTableHeader\" align=\"center\" wrap style=\"float:right;padding:3px;\">"+tempDispName+"</td>");
									headerVect.add(tempDispName);
								}
								else
								{
									buf.append("<td class=\"printTableHeader\" align=\"center\" wrap style=\"float:right;padding:3px;\">"+tempDispName+"</br> "+unitForMeasure+" </td>");
									headerVect.add(tempDispName+unitForMeasure);
								}
							}
						}
						else
						{
							if(isLocColumn)
							{
								if(tempDispName!=null && tempDispName.trim().length()>0 && tempDispName.equals("Health"))
								{
									buf.append("<td class=\"printTableHeader\" align=\"center\" wrap >"+tempDispName+" </td>");
									headerVect.add(tempDispName);
								}
								else if(tempLocColName!=null && tempLocColName.trim().length()>0 && tempLocColName.equalsIgnoreCase("Total_Users"))
								{
									buf.append("<td class=\"printTableHeader\" align=\"center\" wrap >"+tempDispName+" </td>");
									headerVect.add(tempDispName);
								}
								else
								{
									buf.append("<td class=\"printTableHeader\" align=\"center\" wrap > "+tempDispName+"</td>");
									headerVect.add(tempDispName);
								}
							}
							else
							{
								if(unitForMeasure==null || unitForMeasure.equals(""))
								{
									buf.append("<td class=\"printTableHeader\" align=\"center\" wrap > "+tempDispName+" </td>");
									headerVect.add(tempDispName);
								}
								else
								{
									buf.append("<td class=\"printTableHeader\" align=\"center\" wrap > "+tempDispName+"</br> "+unitForMeasure+"</td>");
									headerVect.add(tempDispName+unitForMeasure);
								}
							}
						}
					}
				}
					listData.add(headerVect);
					buf.append("</tr>");
					buf.append("</thead>");
					buf.append("<tbody>");
					
					measureList = Arrays.asList(measureArray);
					int groupByUserKeysSize = groupByUserKeys.size();
					int measureListSize = 0;
					for(int k=0;k<groupByUserKeysSize;k++)
					{
						String usrMeasKey = (String)groupByUserKeys.get(k);
						Vector dataVector = new Vector();
						if(measureList!=null && measureList.size()>0)
						{
							buf.append("<tr style=\"background:none !important\">");
							measureListSize = measureList.size();
							for(int m=0;m<measureListSize;m++)
							{
								String header_str = (String)measureList.get(m);
								String searchFilterVal = (String)measureList.get(0);
								if(searchFilterVal!=null && searchFilterVal.trim().length()>0 && searchFilterVal.indexOf(":")>-1)
								searchFilterVal = searchFilterVal.substring(0,searchFilterVal.indexOf(":"));
								String header_key = "";
								String header_disp = "";
								if(header_str!=null && header_str.trim().length()>0 && header_str.indexOf(":")>-1)
								{
									StringTokenizer hTok = new StringTokenizer(header_str.trim(),":");
									if(hTok.countTokens()==4)
									{
										String h_test = hTok.nextToken();
										String h_meas = hTok.nextToken();
										String h_disp = hTok.nextToken();
										String h_fun = hTok.nextToken();
										header_key = Dbdata.getColumnForMeasure(h_test,h_meas);
									}
									else
									{
										header_key = header_str.substring(0,header_str.indexOf(":"));
									}
								}
								String Value = "";
								String nextSearchVal = "";
								if(finalGroupByUserTab!=null && finalGroupByUserTab.size()>0 && finalGroupByUserTab.containsKey(usrMeasKey+"_"+header_key))
								{
									String measure_val = ""; 
									HashMap state_map = new HashMap();
									if(header_key!=null && header_key.trim().length()>0 && header_key.equals("Health"))
									{
										state_map = (HashMap)finalGroupByUserTab.get(usrMeasKey+"_"+header_key);
										
										if(usrMeasKey!=null && usrMeasKey.trim().length()>0 && searchFilterVal!=null && finalGroupByUserTab.containsKey(usrMeasKey+"_"+searchFilterVal))
										{
											nextSearchVal = (String)finalGroupByUserTab.get(usrMeasKey+"_"+searchFilterVal);
										}
										if(isShowSeparateFilters)
										{
											if(usrMeasKey!=null && usrMeasKey.indexOf("~$~")>-1)
											{
												String groupKey1 = "";
												if(groupByList!=null && groupByList.size()>0)
													groupKey1 = (String)groupByList.get(0);
												String filName1 =  "";
															
												if(showFilterNames!=null && showFilterNames.indexOf(",")>-1)
												{
													filName1 = showFilterNames.substring(0,showFilterNames.indexOf(","));
													if(filName1!=null && groupKey1!=null && filName1.equalsIgnoreCase(groupKey1))
													{
														searchFilterVal = usrMeasKey.substring(0,usrMeasKey.indexOf("~$~"));
														String tmpNextSearchVal = usrMeasKey.substring(usrMeasKey.indexOf("~$~")+3);
															if(tmpNextSearchVal!=null && tmpNextSearchVal.indexOf("~$~")==-1)
																nextSearchVal = tmpNextSearchVal;
															else
																nextSearchVal = tmpNextSearchVal.substring(tmpNextSearchVal.indexOf("~$~")+3);
													}
													else
													{
														nextSearchVal = usrMeasKey.substring(0,usrMeasKey.indexOf("~$~"));
														String tmpSearchFilterVal = usrMeasKey.substring(usrMeasKey.indexOf("~$~")+3);
															if(tmpSearchFilterVal!=null && tmpSearchFilterVal.indexOf("~$~")==-1)
																searchFilterVal = tmpSearchFilterVal;
															else
																searchFilterVal = tmpSearchFilterVal.substring(tmpSearchFilterVal.indexOf("~$~")+3);
													}
												}
												/*if(usrMeasKey!=null && usrMeasKey.indexOf("~$~")>-1)
												{
													searchFilterVal = usrMeasKey.substring(0,usrMeasKey.indexOf("~$~"));
													nextSearchVal = usrMeasKey.substring(usrMeasKey.indexOf("~$~")+3);
												}
												else if(usrMeasKey!=null && usrMeasKey.equalsIgnoreCase("All"))
												{
													searchFilterVal = usrMeasKey;
													nextSearchVal = usrMeasKey;
												}*/
											}
											else if(usrMeasKey!=null && (usrMeasKey.equalsIgnoreCase("All")||usrMeasKey.indexOf("~$~")==-1))
											{
												searchFilterVal = usrMeasKey;
												nextSearchVal = usrMeasKey;
											}
										}
										StringBuffer htmlStr = new StringBuffer();
										StringBuffer stateStr = new StringBuffer();
										htmlStr.append("<div class=\"healthviewgridbar\" style=\"margin-top:0px;\"><div style=\"margin-top:0px;width:100%;margin-bottom:3px\" class=\"outer12\">");
										//htmlStr.append("<div class=\"healthviewgridbar\" style=\"margin-top:-2px\"><div style=\"margin-top:-2px;width:100%;\" class=\"outer12\">");
										if(state_map!=null && state_map.size()>0 && statenames!=null && statenames.length>0)
										{
											for(int n=0;n<statenames.length;n++)
											{
												String state_key = statenames[n];
												if(state_key!=null && state_key.trim().length()>0 && !state_key.equalsIgnoreCase("null"))
												{
													if(state_map.containsKey(state_key))
													{
														String state_val = (String)state_map.get(state_key);
														String state_color = (String)uiIni.getValue("STATE_COLORS",state_key);
														state_color = (state_color==null||state_color.trim().length()==0||state_color.equalsIgnoreCase("null"))?"0c9a12":state_color;
														
														if(state_val!=null && state_val.trim().length()>0 && state_val.indexOf("^|^")>-1)
														{
															String user_per = state_val.substring(0,state_val.indexOf("^|^"));
															String cnt = state_val.substring(state_val.indexOf("^|^")+3);
															user_per = (user_per==null||user_per.trim().length()==0||user_per.equalsIgnoreCase("null"))?"0":user_per;
															cnt = (cnt==null||cnt.trim().length()==0||cnt.equalsIgnoreCase("null"))?"0":cnt;
															
															htmlStr.append("<div style=\"color:#fff;background:#"+state_color+";text-align:center;width:"+user_per+"%;height:14px;padding-top:2px;float:left;\" class=\"innerLeftRight12\">"+cnt+"</div>");
															stateStr.append(mappingInfo.getLabelDescription(state_key)+"="+cnt+",");
														}
													}
												}
											}
										}
										htmlStr.append("</div><div style=\"clear:both\"></div></div>"); 
										if(htmlStr!=null)
											buf.append("<td style=\"text-align:right;padding:4px 4px 1px 4px;white-space:nowrap;width:400px\">"+htmlStr.toString()+"</td>");
										
										String tmpValStr = "";
										if(stateStr!=null)
										{
											tmpValStr = stateStr.toString();
											if(tmpValStr!=null && tmpValStr.lastIndexOf(",")>-1)
												tmpValStr = tmpValStr.substring(0,tmpValStr.lastIndexOf(","));
											Value = tmpValStr;
										}
										dataVector.add(Value);
									}
									else
									{
										if(groupByList!=null && groupByList.size()>0 && groupByList.contains(header_key))
										{
											Value = (String)finalGroupByUserTab.get(usrMeasKey+"_"+header_key);

											if(Value==null||Value.trim().length()==0||Value.equals("-5.0000")||Value.equalsIgnoreCase("null"))
												Value = "-";
											if(isShowSeparateFilters)
											{
												/*if(usrMeasKey!=null && usrMeasKey.indexOf("~$~")>-1)
												{
													searchFilterVal = usrMeasKey.substring(0,usrMeasKey.indexOf("~$~"));
													nextSearchVal = usrMeasKey.substring(usrMeasKey.indexOf("~$~")+3);
												}
												else if(usrMeasKey!=null && (usrMeasKey.equalsIgnoreCase("All")||usrMeasKey.indexOf("~$~")==-1))
												{
													searchFilterVal = usrMeasKey;
													nextSearchVal = usrMeasKey;
												}*/
												String groupKey1 = "";
												if(groupByList!=null && groupByList.size()>0)
													groupKey1 = (String)groupByList.get(0);
												String filName1 =  "";
												if(usrMeasKey!=null && usrMeasKey.indexOf("~$~")>-1)
												{
													if(showFilterNames!=null && showFilterNames.indexOf(",")>-1)
													{
														filName1 = showFilterNames.substring(0,showFilterNames.indexOf(","));
														if(filName1!=null && groupKey1!=null && filName1.equalsIgnoreCase(groupKey1))
														{
															searchFilterVal = usrMeasKey.substring(0,usrMeasKey.indexOf("~$~"));
															String tmpNextSearchVal = usrMeasKey.substring(usrMeasKey.indexOf("~$~")+3);
															if(tmpNextSearchVal!=null && tmpNextSearchVal.indexOf("~$~")==-1)
																nextSearchVal = tmpNextSearchVal;
															else
																nextSearchVal = tmpNextSearchVal.substring(tmpNextSearchVal.indexOf("~$~")+3);
														}
														else
														{
															nextSearchVal = usrMeasKey.substring(0,usrMeasKey.indexOf("~$~"));
																		
															String tmpSearchFilterVal = usrMeasKey.substring(usrMeasKey.indexOf("~$~")+3);
															if(tmpSearchFilterVal!=null && tmpSearchFilterVal.indexOf("~$~")==-1)
																searchFilterVal = tmpSearchFilterVal;
															else
																searchFilterVal = tmpSearchFilterVal.substring(tmpSearchFilterVal.indexOf("~$~")+3);
														}
													}
												}
												else if(usrMeasKey!=null && (usrMeasKey.equalsIgnoreCase("All")||usrMeasKey.indexOf("~$~")==-1))
												{
													searchFilterVal = usrMeasKey;
													nextSearchVal = usrMeasKey;
												}
											}
											else
											{
												searchFilterVal = header_key;
												nextSearchVal = Value;
											}
											String drillDownLink = "/final/monitor/endUserDashboard.jsp?access=allusers&user="+userName+"&userType="+userType+"&priority="+priority+"&filterFlag=true&filterBy=All&searchFilter="+header_key+"&nextSearch="+Value+"&fromMenu=true"+"&vdiType="+vdiType+"&enableBackButton=true"+"&overviewsearchstr="+EgURLEncoder.encode(searchString,"UTF-8");

											buf.append("<td class=\"mouse\" align=\"left\" style=\"font-size:11px;text-align:left;padding:4px 0 1px 6px;\" onClick=\"javascript:goToDrillDown('"+drillDownLink+"');\" ><div style=\"cursor:pointer;width:120px;text-align:left;padding-left:5px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap\">"+Value+"</div></td>");
										}
										else
										{
											Value = (String)finalGroupByUserTab.get(usrMeasKey+"_"+header_key);
											if(Value==null||Value.trim().length()==0||Value.equals("-5.0000")||Value.equalsIgnoreCase("null"))
												Value = "-";
											buf.append("<td style=\"text-align:center;padding-left:3px;padding-right:10px;padding:4px 0 1px 6px;white-space:nowrap\">"+Value+"</td>");
										}
										dataVector.add(Value);
									}
								}
								else 
								{
									if(Value==null||Value.trim().length()==0||Value.equals("-5.0000")||Value.equalsIgnoreCase("null"))
										Value = "-";
									buf.append("<td style=\"text-align:center;padding-left:3px;padding-right:10px;padding:4px 0 1px 6px;white-space:nowrap\">"+Value+"</td>");
									dataVector.add(Value);
								}
							}
						}
						else
						{
							int p=0;
							int measureListSize1 = 0;
							if(measureList!=null)
								measureListSize1 = measureList.size();
							while(p<measureListSize1)
							{
								buf.append("<td  style=\"padding-top:4px;\" align=\"center\" >");
									buf.append("<table cellspacing=\"0\" cellpadding=\"0\" style=\"table-layout:auto;border:0px solid red\" align=\"left\">");
										buf.append("<tr style=\"background:none !important\">");
											buf.append("<td style=\"text-align:left;border:none;\">");
											buf.append("-</td>");
										buf.append("</tr>");
									buf.append("</table>");
								buf.append("</td>");
								p++;
								dataVector.add("-");
							}
						}
						buf.append("</tr>");
						listData.add(dataVector);
					}
									buf.append("</tbody>");
								buf.append("</table>");
							buf.append("</div>");
						buf.append("</td>");
					buf.append("</tr>");
				buf.append("</table>");
			}
			else
			{
				int col_span=measureList.size();
				buf.append("<table border=\"0\" width=\"100%\" height=\"100%\" bordercolor=\"green\">");
					buf.append("<tr style=\"background:none\">");
						buf.append("<td align=\"center\" width=\"100%\" colspan=\""+col_span+"\" height=\"100%\" class=\"commonErrorMsgText\" >");
							buf.append("<img src = \"/final/images/spacer.gif\" class=\"iconExclamation\" lign = \"center\" border = \"0\"  vspace = \"10\"/>");
							buf.append("<br>"+mappingInfo.getTextDescription("monitor.endUserDashboard.No Records Found"));
						buf.append("</td>");
					buf.append("</tr>");
				buf.append("</table>");
			}
		}
		else if((!isEndUserOverview) && (!isFromUEDSort))
		{
			buf.append("<link rel='stylesheet' type='text/css' href='/final/styles/eGLightThemeIcons.css' />");
			buf.append("<style>@media print {body {-webkit-print-color-adjust: exact;}}");
			buf.append("@font-face{font-family:'LucidaGrandeRegular';src:url('../../fonts/6216/6216.woff') format('woff')}");
			buf.append("@font-face{font-family:'LucidaGrandeBold';src:url('../../fonts/6215/6215.woff') format('woff')}");
			buf.append("body{font-family:'LucidaGrandeRegular';font-size:11px;line-height:1.5em;color:#2a292a;}");
			buf.append("header{font-family:'LucidaGrandeRegular';font-size:15px;}");
			buf.append(".formLabel {font-family:'LucidaGrandeRegular';font-size:12px;line-height:14px;}");
			buf.append(".formValue {font-family:'LucidaGrandeBold';font-size:12px;line-height:14px;} b{font-family:'LucidaGrandeBold';font-size:11px;}");
			buf.append("table tr td{font-family:'LucidaGrandeRegular';font-size:11px;padding:4px;}");
			buf.append(".printTable{border: 1px solid #c3c3c3; border-collapse:collapse;word-break:break-all;}");
			buf.append(".printTableHeader{font-family:'LucidaGrandeBold';border: 1px solid #c3c3c3;text-align:center;background-color:#cdcdcd;padding:4px;}");
			buf.append(".printTable tr td{border: 1px solid #c3c3c3;}");
			buf.append(".printTable tbody tr td{border: 1px solid #c3c3c3;}");
			buf.append(".printTable tbody tr td table tr td{border: 0px solid #c3c3c3 !important;}");
			buf.append(".printTable div{word-break:break-all;	}");
			buf.append(".printTable thead{font-family:'LucidaGrandeBold';border: 1px solid #c3c3c3;text-align:center;background-color:#cdcdcd;padding:4px;}");
			buf.append(".printTableHeader2{font-family:'LucidaGrandeBold';border: 1px solid #c3c3c3;text-align:center;background-color:#dcdcdc;padding:4px;}</style>");
			
			IniUI img1=IniUI.getInstance();
			String logo=img1.getMonitorHomeLogo();
			if(img1.isHKTThemeEnabled())
			{
				logo = img1.getHKTReporterLogo();
			}
			String mainTitle = mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience Overview for "+userType);
			if(check_Header_DispName && vdiDesktopsListTotalCount>0)
			{
				//mainTitle=mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience Overview for "+userType+" (Total users: "+vdiDesktopsListTotalCount+")");
				if(userType!=null && userType.equalsIgnoreCase("ESX"))
				{
					mainTitle=mappingInfo.getTextDescription("monitor.endUserDashboard.Performance Metrics for VMs (Total VMs : "+vdiDesktopsListTotalCount+")");
				}
				else if(userType!=null && userType.equalsIgnoreCase("VDI"))
				{
					String countHeader = (skipDesktopsForVDI!=null && skipDesktopsForVDI.equalsIgnoreCase("true"))?"Unique Users":"Unique Users/Desktops";
					mainTitle=mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience Overview for "+userType+" ("+countHeader+": "+vdiDesktopsListTotalCount+")");
				}
				else if(userType!=null && (userType.equalsIgnoreCase("XenApp") || userType.equalsIgnoreCase("XenApp7")))
				{
					String countHeader = "Unique Users";
					mainTitle=mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience Overview for "+userType+" ("+countHeader+": "+vdiDesktopsListTotalCount+")");
				}
				else
				{
					mainTitle=mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience Overview for "+userType+" (Total users: "+vdiDesktopsListTotalCount+")");
				}
			}
			else
			{
				if(userType!=null && userType.equalsIgnoreCase("ESX"))
				{
					mainTitle=mappingInfo.getTextDescription("monitor.endUserDashboard.Performance Metrics for VMs (Total VMs : "+vdiDesktopsListTotalCount+")");
				}
				else 
				{
					mainTitle=mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience Overview for "+userType);
				}
			}
			listData.add(mainTitle);

			listData.add("");

			buf.append("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" style=\"table-layout:fixed;\">");
			buf.append("<tr><td width=\"100%\" align=\"center\" height=\"100%\" valign=\"top\">");
			if(logo!=null && logo.trim().length()>0)
			{
				buf.append("<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\" align=\"center\">");
				buf.append("<tr><td style=\"padding:5px 10px 10px 10px\">");
				buf.append("<img src="+logo+" border=\"0\" /></td></tr></table>");
			}
			buf.append("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\"  style=\"border-bottom:1px solid #999;\">");
			buf.append("<tr><td style=\"padding:2px\"><div style=\"float:left\" ><header>"+mainTitle+"</header></div></td></tr></table>");
			buf.append("</td></tr></table>");
			buf.append("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"left\" style=\"table-layout:fixed;\">");
			
			if(searchString!=null && !searchString.equalsIgnoreCase("NULL") && searchString.trim().length()>0)
			{
				String key = mappingInfo.getTextDescription("monitor.endUserDashboard.Search By ");
				buf.append("<tr><td>");
				buf.append("<span style=\"float:left\" class=\"formLabel\">"+key+"</span> ");
				buf.append("<span style=\"float:left;width:10px\" align=\"center\" >:</span> ");
				buf.append("<span style=\"float:left;\" class=\"formValue\">"+searchString+"</span></td></tr>");
				listData.add(key+"="+searchString);
			}

			String currOrderByColumnName = request.getParameter("currOrderByColumn");
			String currOrderByName = request.getParameter("currOrderBy");
			if(currOrderByColumnName!=null && !currOrderByColumnName.equalsIgnoreCase("NULL") && currOrderByColumnName.trim().length()>0)
			{
				if(columnDispName!=null && columnDispName.trim().length()>0)
				{
					String orderByColText = mappingInfo.getTextDescription("monitor.endUserDashboard.Sort By");
					buf.append("<tr><td><span style=\"float:left\" class=\"formLabel\">"+orderByColText+"</span> ");
					buf.append("<span style=\"float:left;width:10px\" align=\"center\" >:</span> ");
					buf.append("<span style=\"float:left;\" class=\"formValue\">"+columnDispName+"</span></td>");
					listData.add(orderByColText+"="+columnDispName);

					if(currOrderByName!=null && !currOrderByName.equalsIgnoreCase("NULL") && currOrderByName.trim().length()>0)
					{
						String orderByText = mappingInfo.getTextDescription("monitor.endUserDashboard.Order By");
						if(currOrderByName!=null && currOrderByName.trim().length()>0 && currOrderByName.equalsIgnoreCase("desc"))
						{
							currOrderByName = mappingInfo.getTextDescription("monitor.endUserDashboard.Descending");
						}
						else if(currOrderByName!=null && currOrderByName.trim().length()>0 && currOrderByName.equalsIgnoreCase("asc"))
						{
							currOrderByName = mappingInfo.getTextDescription("monitor.endUserDashboard.Ascending");
						}
						buf.append("<td><span style=\"float:left\" class=\"formLabel\">"+orderByText+"</span> ");
						buf.append("<span style=\"float:left;width:10px\" align=\"center\" >:</span> ");
						buf.append("<span style=\"float:left;\" class=\"formValue\">"+currOrderByName+"</span></td>");
						listData.add(orderByText+"="+currOrderByName);

					}
					buf.append("</tr>");
				}
				else
				{
					String sortByDispCol = ini.getValue("USER_DESKTOP_METRICS",userType);
					ArrayList sortByDispColList =  new ArrayList();
					if(sortByDispCol!=null && sortByDispCol.trim().length()>0)
					{
						sortByDispColList = com.egurkha.util.StringUtils.egTokenizer(sortByDispCol,",",false,false,true);//param 3-->includeEmpty,4-->unique,5-->trim
					}
					if(sortByDispColList!=null && sortByDispColList.size()>0)
					{
						String sortByColDispName = "";
						for(int s = 0;s<sortByDispColList.size();s++)
						{
							String colName = (String)sortByDispColList.get(s);
							String tmpTest = colName.substring(0,colName.indexOf(":"));
							String tmpMeasure = "";
							tmpMeasure = colName.substring(colName.indexOf(":")+1);
							if(tmpMeasure!=null && tmpMeasure.trim().length()>0 && tmpMeasure.indexOf(":")>-1)
								tmpMeasure=tmpMeasure.substring(0,tmpMeasure.indexOf(":"));
							String tmpOrderByColName = Dbdata.getColumnForMeasure(tmpTest,tmpMeasure);
							if(tmpOrderByColName!=null && tmpOrderByColName.trim().length()>0 && tmpOrderByColName.equals(currOrderByColumnName))
								sortByColDispName = colName.substring(colName.lastIndexOf(":")+1);
						}
						if(sortByColDispName!=null && !sortByColDispName.equalsIgnoreCase("NULL") && sortByColDispName.trim().length()>0)
						{
							String orderByColText = mappingInfo.getTextDescription("monitor.endUserDashboard.Sort By");
							buf.append("<tr><td><span style=\"float:left\" class=\"formLabel\">"+orderByColText+"</span> ");
							buf.append("<span style=\"float:left;width:10px\" align=\"center\" >:</span> ");
							buf.append("<span style=\"float:left;\" class=\"formValue\">"+sortByColDispName+"</span></td>");

							listData.add(orderByColText+"="+sortByColDispName);

							if(currOrderByName!=null && !currOrderByName.equalsIgnoreCase("NULL") && currOrderByName.trim().length()>0)
							{
								String orderByText = mappingInfo.getTextDescription("monitor.endUserDashboard.Order By");
								if(currOrderByName!=null && currOrderByName.trim().length()>0 && currOrderByName.equalsIgnoreCase("desc"))
								{
									currOrderByName = mappingInfo.getTextDescription("monitor.endUserDashboard.Descending");
								}
								else if(currOrderByName!=null && currOrderByName.trim().length()>0 && currOrderByName.equalsIgnoreCase("asc"))
								{
									currOrderByName = mappingInfo.getTextDescription("monitor.endUserDashboard.Ascending");
								}
								buf.append("<td><span style=\"float:left\" class=\"formLabel\">"+orderByText+"</span> ");
								buf.append("<span style=\"float:left;width:10px\" align=\"center\" >:</span> ");
								buf.append("<span style=\"float:left;\" class=\"formValue\">"+currOrderByName+"</span></td>");
								listData.add(orderByText+"="+currOrderByName);
							}
							buf.append("</tr>");
						}
					}
				}
			}
			
			if((filterBy != null && filterBy.trim().length() > 0) || (searchFilter != null && searchFilter.trim().length() > 0) || (nextSearch != null && nextSearch.trim().length() > 0 && !nextSearch.trim().equals("-1"))){
				buf.append("<tr>");
				if(filterBy != null && filterBy.trim().length() > 0){
					String zoneName = mappingInfo.getTextDescription("monitor.endUserDashboard.Zone");
					buf.append("<td><span style=\"float:left\" class=\"formLabel\">"+zoneName+"</span> ");
					buf.append("<span style=\"float:left;width:10px\" align=\"center\" >:</span> ");
					buf.append("<span style=\"float:left;\" class=\"formValue\">"+filterBy+"</span></td>");

					listData.add(zoneName+"="+filterBy);
				}
				String filterByStr = mappingInfo.getTextDescription("monitor.endUserDashboard.Filter By");
				if(isShowSeparateFilters && searchFilDispTxt!=null && searchFilDispTxt.trim().length()>0 && !searchFilDispTxt.equalsIgnoreCase("NULL"))
					filterByStr = mappingInfo.getTextDescription("monitor.endUserDashboard."+searchFilDispTxt);
				if((isShowUserLocation) && searchFilter != null && searchFilter.trim().length() > 0 && !searchFilter.equalsIgnoreCase("NULL")){
					//String filterByLoc = mappingInfo.getTextDescription("monitor.endUserDashboard.Filter By");
					buf.append("<td><span style=\"float:left\" class=\"formLabel\">"+filterByStr+"</span> ");
					buf.append("<span style=\"float:left;width:10px\" align=\"center\" >:</span> ");
					buf.append("<span style=\"float:left;\" class=\"formValue\">"+searchFilter+"</span></td>");

					listData.add(filterByStr+"="+searchFilter);
				}
				String searchFilterStr = mappingInfo.getTextDescription("monitor.endUserDashboard."+searchFilter);
				if(isShowSeparateFilters && nextSearchFilDispTxt!=null && nextSearchFilDispTxt.trim().length()>0 && !nextSearchFilDispTxt.equalsIgnoreCase("NULL"))
					searchFilterStr = mappingInfo.getTextDescription("monitor.endUserDashboard."+nextSearchFilDispTxt);

				if((isShowUserLocation) && nextSearch != null && nextSearch.trim().length() > 0 && !nextSearch.trim().equals("-1") && !nextSearch.equalsIgnoreCase("NULL")){
					//String filterByLoc = mappingInfo.getTextDescription("monitor.endUserDashboard."+searchFilter);
					buf.append("<td><span style=\"float:left\" class=\"formLabel\">"+searchFilterStr+"</span> ");
					buf.append("<span style=\"float:left;width:10px\" align=\"left\" >:</span> ");
					buf.append("<span style=\"float:left;\" class=\"formValue\">"+nextSearch+"</span></td>");

					listData.add(searchFilterStr+"="+nextSearch);
				}

				if(priorityFilter != null && priorityFilter.trim().length() > 0 && !priorityFilter.trim().equals("-1") && !priorityFilter.trim().equals("NULL")){
					String filterByLoc = mappingInfo.getTextDescription("monitor.endUserDashboard.Priority");
					buf.append("<td><span style=\"float:left\" class=\"formLabel\">"+filterByLoc+"</span> ");
					buf.append("<span style=\"float:left;width:10px\" align=\"left\" >:</span> ");
					buf.append("<span style=\"float:left;\" class=\"formValue\">"+mappingInfo.getLabelDescription(priorityFilter)+"</span></td>");
					
					listData.add(filterByLoc+"="+mappingInfo.getLabelDescription(priorityFilter));
				}
				buf.append("</tr>");
			}

			listData.add("");
			listData.add("");
			Vector headerVect = new Vector();
			buf.append("</table>");
			buf.append("<table  border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"  height=\"auto\">");
				buf.append("<tr>");
					buf.append("<td width=\"100%\" valign=\"top\" height=\"100%\">");
						buf.append("<div>");
							buf.append("<table class=\"printTable\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"  valign=\"top\" >");
								buf.append("<thead>");
									buf.append("<tr >");
									if(!orderByCol_flag)
									{
										buf.append("<td class=\"printTableHeader\" align=\"center\" wrap >"+mappingInfo.getTextDescription("monitor.VirtualDashboard.Users/Desktops")+"</td>");
									}
									else
									{
										buf.append("<td class=\"printTableHeader\" align=\"center\"  wrap >"+mappingInfo.getTextDescription("monitor.VirtualDashboard.Users/Desktops")+ "</td>");
									} 
									headerVect.add("");
									headerVect.add("Priority");
									headerVect.add(mappingInfo.getTextDescription("monitor.VirtualDashboard.Users/Desktops"));
									if(orderByColumnName!=null && orderByColumnName.equalsIgnoreCase("Host"))
									{
										buf.append("<td class=\"printTableHeader\" align=\"center\"  wrap >"+mappingInfo.getTextDescription("monitor.VirtualDashboard.Host")+"</td>");
									}
									else
									{
										buf.append("<td class=\"printTableHeader\" align=\"center\"  wrap >"+mappingInfo.getTextDescription("monitor.VirtualDashboard.Host")+ "</td>");
									}
									headerVect.add(mappingInfo.getTextDescription("monitor.VirtualDashboard.Host"));
			String widthOfTheHead="";
			String strVdiHostCombo=ini.getValue("END_USER_DASHBOARD_SETTINGS","showVdiHostCombo");
			strVdiHostCombo=(strVdiHostCombo==null || strVdiHostCombo.trim().length()==0)?"false":strVdiHostCombo;
			String strVdiDefaultHost=ini.getValue("END_USER_DASHBOARD_SETTINGS","Default_VdiType");
			strVdiDefaultHost=(strVdiDefaultHost==null || strVdiDefaultHost.trim().length()==0)?"":strVdiDefaultHost;
			boolean showVdiHostCombo = "true".equalsIgnoreCase(strVdiHostCombo)?true:false;
			boolean isSkipVal = false;
			ArrayList skippedColumns = new ArrayList();
			if(showVdiHostCombo && vdiType!=null && vdiType.trim().length()>0)
			{
				strVdiDefaultHost = vdiType;
			}

			//String measures = ini.getValue("USER_DESKTOP_METRICS",userType);
			String measures=null;
			String measuresD=null;
			String measuresT=null;
			if(userName!=null && userName.trim().length()>0)
			{
				measures = ini.getValue("USER_DESKTOP_METRICS",userName+":"+userType);
			}
		
			if(measures==null || measures.trim().length()==0)
			{
				measuresD = ini.getValue("USER_DESKTOP_METRICS","DEFAULT_"+userType);
				measuresT = ini.getValue("USER_DESKTOP_METRICS",userType);
				if(measuresD != null && measuresD.trim().length() > 0)
				{
					measures = measuresD;
				}
				else
				{
					measures = measuresT;
				}
			}

			String[] measureArray = measures.split(",");
			ArrayList displayColsList = new ArrayList();
			ArrayList validColsList = new ArrayList();
			Hashtable sameLabelHash = new Hashtable();
			measuresCount = measureArray.length;
			for(int x=0;x<measureArray.length;x++)
			{
				String tempValue = measureArray[x];
				String tempTest = "";
				String tempMeasure = "";
				String tempDispName = "";
				String locKeyName = "";
				String colName = "";
				ArrayList locColumnsList = null;
				StringTokenizer valTokens = new StringTokenizer(tempValue,":");
				int count = valTokens.countTokens();
				boolean isDDDColumn = false;
				boolean isLocColumn = false;
				boolean isTestColumn = false;
				String meas ="";
				if (valTokens.hasMoreTokens())
				{
					if(count==3)
					{
						tempTest = valTokens.nextToken();
						tempMeasure = valTokens.nextToken();
						tempDispName = valTokens.nextToken();
						isTestColumn=true;
					}
					else if(count==2)
					{
						if(isShowUserLocation)
						{
							tempTest = valTokens.nextToken();
							tempMeasure = valTokens.nextToken();
							//tempDispName = mappingInfo.getMeasureDescription(tempTest,tempMeasure);
							isLocColumn = true;
							meas = "NONE";

							ArrayList tmpMeasureList = new ArrayList();
							tmpMeasureList = StringUtils.egTokenizer(tempMeasure,"~$~",true,false,true);//param 3-->includeEmpty,4-->unique,5-->trim
							if(tmpMeasureList!=null && tmpMeasureList.size()>0)
							{
								int meaListSize=tmpMeasureList.size();
								if(meaListSize==1)
								{
									tempDispName = tempMeasure;
								}
								else if(meaListSize>1)
								{
									tempDispName = (String)tmpMeasureList.get(1);
								}
							}
						}
					}
					else if(count==5)
					{
						tempTest = valTokens.nextToken();
						tempMeasure = valTokens.nextToken();
						colName = valTokens.nextToken();
						meas = valTokens.nextToken();
						tempDispName = valTokens.nextToken();
						isDDDColumn = true;
						//mappingInfo.getMeasureDescription(tempTest+"_DDD",tempMeasure);
					}
				}

				if(isTestColumn || isDDDColumn || isLocColumn)
				{
					boolean isTestRelevantForServer = true;
					if(showVdiHostCombo && strVdiDefaultHost!=null && strVdiDefaultHost.trim().length()>0)
					{
						isTestRelevantForServer = specsInfo.isTestRelevantForServer(strVdiDefaultHost,tempTest);
					}
					if(!isTestRelevantForServer)
					{
						continue;
					}
					if(displayColsList!=null && displayColsList.contains(tempDispName))
					{
						if(sameLabelHash!=null && sameLabelHash.containsKey(tempDispName))
						{
							ArrayList tmp_list=(ArrayList)sameLabelHash.get(tempDispName);
							tmp_list.add(tempValue);
							sameLabelHash.put(tempDispName,(ArrayList)tmp_list);
						}
						else
						{
							ArrayList tmp_list=new ArrayList();
							tmp_list.add(tempValue);
							sameLabelHash.put(tempDispName,(ArrayList)tmp_list);
						}
						continue;
					}

					String unitForMeasure="";
					if(isDDDColumn && meas!=null && meas.trim().length()>0 &&(!meas.equalsIgnoreCase("NONE")&&!meas.equalsIgnoreCase("DATE")))
					{
						unitForMeasure = "("+meas+")";
					}
					else if(!isDDDColumn && !isLocColumn)
					{
						//unitForMeasure="&nbsp;("+tablesInfo.getUnitForMeasure(tempTest,tempMeasure.trim())+")";
						String unitVal=tablesInfo.getUnitForMeasure(tempTest,tempMeasure.trim());

						if(unitVal!=null && unitVal.trim().length()>0)
						{
							unitForMeasure="&nbsp;("+unitVal+")";
						}
					}
					if(unitForMeasure!=null && unitForMeasure.indexOf("MB")>-1)
						unitForMeasure ="&nbsp;(GB)";

					if(tempDispName!=null && tempDispName.equalsIgnoreCase("Status")){
						unitForMeasure="";
					}
					else if(tempDispName!=null && (tempDispName.equalsIgnoreCase("Disk Used") || tempDispName.equalsIgnoreCase("Used Space"))){
						unitForMeasure="("+mappingInfo.getTextDescription("monitor.VirtualDashboard.GB")+")";
					}
					String orderByColumn = "";
					if(isLocColumn)
					{
						orderByColumn = tempDispName;
						//orderByColumnName = tempDispName;
					}
					else if (isDDDColumn)
					{
						orderByColumn = Dbdata.getColumnForMeasure(tempTest+"_DDD",colName);
						//col_name = dbInfo.getColumnForMeasure(test+"_DDD",tmp_col_name);
						//orderByColumnName = Dbdata.getColumnForMeasure(tempTest,tempMeasure);
					}
					else
					{
						orderByColumn = Dbdata.getColumnForMeasure(tempTest,tempMeasure); 
					}
					if(orderByColumn!=null && orderByColumn.trim().length()>0 && orderByColumnName!=null && orderByColumnName.trim().length()>0 && orderByColumnName.equalsIgnoreCase(orderByColumn))
					{
						String nextOrderBy="desc";
						//String sortImgurl="/final/monitor/eg_images/arrow_down_black_small.gif";
						String sortImgurl="/final/images/Dark/grid_sort_top.png";
					
						if(orderBy!=null && orderBy.equals("desc"))
						{
							nextOrderBy="asc";
							//sortImgurl="/final/monitor/eg_images/arrow_down_black_small.gif";
							sortImgurl="/final/images/Dark/grid_sort_down.png";
						}
						else if(orderBy!=null && orderBy.equals("asc"))
						{
							nextOrderBy="desc";
							sortImgurl="/final/images/Dark/grid_sort_top.png";
						}

						if(isDDDColumn || (isShowUserLocation && isLocColumn))
						{
							if((unitForMeasure==null || unitForMeasure.equals(""))&& (meas!=null && !meas.equalsIgnoreCase("DATE")))
							{
								//buf.append("<td class=\"printTableHeader\" align=\"center\" wrap >"+tempDispName+"</br>"+unitForMeasure+" <div style=\"float:right;padding:3px\"><img id=\"sortImg\" src=\""+sortImgurl+"\"/> </td>");
								buf.append("<td class=\"printTableHeader\" align=\"center\" wrap >"+tempDispName+"</br>"+unitForMeasure+" <div style=\"float:right;padding:3px\"></td>");
							}
							else
							{
								buf.append("<td class=\"printTableHeader\" align=\"center\" wrap >"+tempDispName+"</br>"+unitForMeasure+" <div style=\"float:right;padding:3px\"></td>");
							}
							headerVect.add(tempDispName+unitForMeasure);
						}
						else
						{
							if(unitForMeasure==null || unitForMeasure.equals(""))
							{
								buf.append("<td class=\"printTableHeader\" align=\"center\" wrap  >"+tempDispName+"<div style=\"float:right;padding:3px\"></td>");
								headerVect.add(tempDispName);
							}
							else
							{
								buf.append("<td class=\"printTableHeader\" align=\"center\" wrap  >"+tempDispName+"</br>"+unitForMeasure+" <div style=\"float:right;padding:3px\"></td>");
								headerVect.add(tempDispName+unitForMeasure);
							}
						}
					}
					else
					{
						if(isDDDColumn || (isShowUserLocation && isLocColumn))
						{
							if((unitForMeasure==null || unitForMeasure.equals("")) && (meas!=null && !meas.equalsIgnoreCase("DATE")))
							{
								buf.append("<td class=\"printTableHeader\" align=\"center\" wrap >"+tempDispName+" </td>");
								headerVect.add(tempDispName);
							}
							else
							{
								buf.append("<td class=\"printTableHeader\" align=\"center\" wrap > "+tempDispName+"</br>"+unitForMeasure+" </td>");
								headerVect.add(tempDispName+unitForMeasure);
							}
						}
						else
						{
							if(unitForMeasure==null || unitForMeasure.equals(""))
							{
								buf.append("<td class=\"printTableHeader\" align=\"center\" wrap > "+tempDispName+" </td>");
								headerVect.add(tempDispName);
							}
							else
							{
								buf.append("<td class=\"printTableHeader\" align=\"center\" wrap > "+tempDispName+"</br>"+unitForMeasure+" </td>");
								headerVect.add(tempDispName+unitForMeasure);
							}
						}
					}
					if(displayColsList!=null && tempDispName!=null && !displayColsList.contains(tempDispName))
					{
						displayColsList.add(tempDispName);
						if(sameLabelHash!=null && sameLabelHash.containsKey(tempDispName))
						{
							ArrayList tmp_list=(ArrayList)sameLabelHash.get(tempDispName);
							tmp_list.add(tempValue);
							sameLabelHash.put(tempDispName,(ArrayList)tmp_list);
						}
						else
						{
							ArrayList tmp_list=new ArrayList();
							tmp_list.add(tempValue);
							sameLabelHash.put(tempDispName,(ArrayList)tmp_list);
						}
					}
					if(validColsList!=null && tempValue!=null && !validColsList.contains(tempValue)) 
						validColsList.add(tempValue);
				}
			}
			if(validColsList!=null && validColsList.size()>0)
			{
				measureArray = new String[validColsList.size()];
				int yy=0;
				for(int y=0;y<validColsList.size();y++)
				{
					String tempValue1 = (String)validColsList.get(y);
					if(tempValue1!=null && tempValue1.trim().length()>0)
					{
						measureArray[yy++]=tempValue1;
					}
				}
			}
			listData.add(headerVect);
			buf.append("</tr>");
			buf.append("</thead>");
			buf.append("<tbody>");
			EgService serv = null;
			int desktopsSize = (vdiDesktopsList!=null && vdiDesktopsList.size()>0)?vdiDesktopsList.size():0;
			int continueCount = 0 ;
			for(int i=0;i<desktopsSize;i++)
			{
				serv = (EgService)vdiDesktopsList.get(i);
				Vector dataVector = new Vector();
				
				String trBackground = "eg_lightlight";
				if(i%2==0)
					trBackground = "eg_whitebg";

				String desktopComponent = serv.getName();
				String desktopState = serv.getState().getName();
				String desktopName = "";
				String comp = "";
				String compValue = "";
				String compName = "";
				String compNameWithOutPort = "";

				if(desktopComponent!=null && desktopComponent.indexOf("^")>-1)
				{
					desktopName = desktopComponent.substring(0,desktopComponent.indexOf("^"));
					comp = desktopComponent.substring(desktopComponent.indexOf("^")+1);
				}
				if(comp!=null && comp.indexOf(":")>-1)
				{
					compValue = comp.substring(0,comp.indexOf(":"));
					compName = comp.substring(comp.indexOf(":")+1);
				}
				if(compName!=null && compName.indexOf(":")>-1)
				{
					compNameWithOutPort = compName.substring(0,compName.indexOf(":"));
				}
				measureValues = (Hashtable)TotalMeasureInfo.get(comp);
				String msmtHost = "";
				String ctype_layer=ini.getValue("USER_DESKTOP_LAYERS",compValue);
				ctype_layer=(ctype_layer==null || ctype_layer.trim().length()==0)?"VIRTUAL_DESKTOP":ctype_layer;
				ArrayList arr = tablesInfo.getTestsForLayer(ctype_layer);
				if(arr!=null && arr.size()>0)
				{
					boolean flag=true;
					for (int t=0;t<arr.size();t++)
					{
						String insideviewTest=(String) arr.get(t);
						if(insideviewTest!=null && insideviewTest.trim().length()>0)
						{
							List agents=egExternalInfo.getAgentsFor(insideviewTest.trim(),compValue,compNameWithOutPort);

							if(agents!=null && agents.size()>0)
							{
								msmtHost=(String)agents.get(0);
								flag=false;
								break;
							}
						}
					}

					if(flag)
						msmtHost=compNameWithOutPort;
				}
				else
					msmtHost=compNameWithOutPort;

				String tempHostType = compValue;
				String url_desktopName=com.egurkha.util.StringUtils.replace(desktopName, "\\", "\\");
				String url = "/final/monitor/endUserDashboardDetailsData.jsp?comp="+EgURLEncoder.encode(compName,"UTF-8")+"&comptype="+compValue+"&info=*"+EgURLEncoder.encode(url_desktopName,"UTF-8")+"&compName="+EgURLEncoder.encode(compName+":"+compValue,"UTF-8")+"&componentName="+EgURLEncoder.encode(compNameWithOutPort,"UTF-8")+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&user="+EgURLEncoder.encode(userName,"UTF-8")+"&searchString="+EgURLEncoder.encode(searchString,"UTF-8")+"&priority="+priority+"&vdiType="+vdiType+"&userType="+userType;

				if(fromMenuStr!=null && fromMenuStr.trim().length()>0)
				{
					url=url+"&fromMenu="+fromMenuStr;
				}
				String link ="";
				if(fromMenuStr!=null && !fromMenuStr.equalsIgnoreCase("null") && fromMenuStr.trim().length()>0)
				{
					link = "/final/servlet/com.eg.EgDashboardController?site=NULL"+"&from=list&comptype="+EgURLEncoder.encode(compValue,"UTF-8")+"&host="+EgURLEncoder.encode(compName,"UTF-8")+"&tab=LayerModel";
				}
				else
				{
					link = "/final/monitor/endUserDashboardDetailsData.jsp?comp="+EgURLEncoder.encode(compName,"UTF-8")+"&comptype="+compValue+"&info=*"+EgURLEncoder.encode(url_desktopName,"UTF-8")+"&compName="+EgURLEncoder.encode(compName+":"+compValue,"UTF-8")+"&componentName="+EgURLEncoder.encode(compNameWithOutPort,"UTF-8")+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&user="+EgURLEncoder.encode(userName,"UTF-8")+"&searchString="+EgURLEncoder.encode(searchString,"UTF-8")+"&priority="+priority+"&vdiType="+vdiType+"&userType="+userType;
				}
				String disp_desktopName=desktopName;
				//if(disp_desktopName!=null && disp_desktopName.length()>30)
					//disp_desktopName=disp_desktopName.substring(0,30)+"..";

				String strName = compName;
				if (strName.endsWith(EgConstants.NULL_PORT) && (strName.indexOf(EgConstants.NULL_PORT) > -1))
				{
					strName = Server.getServerNameWithoutPort(strName, false);
				}

				String disp_StrName = strName;
				if(disp_StrName!=null && disp_StrName.length()>22)
					disp_StrName=disp_StrName.substring(0,22)+"..";

									buf.append("<tr class=\"x-grid-row  x-grid-row-alt\" style=\"background:none\">");
										buf.append("<td >");
											buf.append("<table cellspacing=\"0\" cellpadding=\"2\" border=\"0\">");
												buf.append("<tr style=\"background:none !important\">");
													buf.append("<td style=\"border:none;\">");

				/*if(desktopName.endsWith("[Template]") || desktopName.endsWith("[template]"))
				{
						buf.append("<div style=\"text-align:center;padding:2px 6px 5px 5px\"><img src=\"/final/monitor/eg_images/template_vm_"+desktopState+".gif\"></div>");
				}
				else if(desktopName.endsWith("[Orphaned]") || desktopName.endsWith("[orphaned]"))
				{
						buf.append("<div style=\"text-align:center;padding:2px 6px 5px 5px\"><img src=\"/final/monitor/eg_images/orphan_vm_"+desktopState+".gif\"></div>");
				}
				else
				{
					if(desktopName!=null && desktopName.toLowerCase().indexOf("vio")>-1)
					{
								buf.append("<div style=\"text-align:center;padding:2px 6px 5px 5px\"><img src=\"/final/monitor/eg_images/vio_"+desktopState+".gif\"></div>");
					}
					else
					{*/
								buf.append("<div style=\"text-align:center;padding:2px 6px 5px 5px\"><img src=\"/final/images/Dark/eud_"+desktopState+".png\"/></div>");
					//}
				//}
								
													buf.append("</td>");
													buf.append("<td style=\"border:none;word-break: break-all;\" >");
														buf.append(disp_desktopName);
													buf.append("</td>");
												buf.append("</tr>");
											buf.append("</table>");
										buf.append("</td>");
										buf.append("<td>");
											buf.append("<div style=\"font-size:12px;float:left;position:relative;visibility:visible;text-align:left;\"><div style=\"padding-top:4px;\">"+disp_StrName+"</div></div>");

											dataVector.add("");
											String labeldeskState = mappingInfo.getLabelDescription(desktopState);
											dataVector.add(labeldeskState);
											dataVector.add(disp_desktopName);
											dataVector.add(disp_StrName);
										buf.append("</td>");

				measureList = Arrays.asList(measureArray);
				if(measureValues!=null && measureValues.size()>0)
				{
					String ctype_out_layer=ui.getValue("Layer_for_ComponentType",compValue);
					ctype_out_layer=(ctype_out_layer==null || ctype_out_layer.trim().length()==0)?"VIRTUAL_GUESTS":ctype_out_layer;
					ArrayList listOfTest=(ArrayList)tablesInfo.getTestsForLayer(ctype_out_layer,compValue);

					int p=0;
					String info_to_lower=desktopName;
					while(p<measureList.size())
					{
						String keyForList = (String)measureList.get(p);
						String keyMeasure = "";
						String keyOrgMeasure = "";
						String keyTest = "";
						String keydisplayMeasure = "";
						StringTokenizer valTokens = new StringTokenizer(keyForList,":");
						int tokCount = valTokens.countTokens();
						boolean isDDDTestColumn = false;
						boolean isLocationColumn = false;
						if(tokCount==5)
							isDDDTestColumn = true;
						else if(tokCount==2)
							isLocationColumn = true;
						String orgColName = "";
						String funcName = "";
						String dispName = "";
						
						String tempDispName = "";
						String locKeyName = "";
						String Value="";
						String units="";
						
						ArrayList keyMeasureList = null; 
						ArrayList locMeasuresList = new ArrayList(); 
						if(isDDDTestColumn)
						{
							if(keyForList!=null && keyForList.indexOf(":")>-1)
							{
								keyTest=keyForList.substring(0,keyForList.indexOf(":"));
								keyMeasure=keyForList.substring(keyForList.indexOf(":")+1);
								if(keyMeasure!=null && keyMeasure.indexOf(":")>-1)
								{
									orgColName=keyMeasure.substring(keyMeasure.indexOf(":")+1);
									keyMeasure = keyMeasure.substring(0,keyMeasure.indexOf(":"));
									if(orgColName!=null && orgColName.indexOf(":")>-1)
									{
										funcName=orgColName.substring(orgColName.indexOf(":")+1);
										orgColName = orgColName.substring(0,orgColName.indexOf(":"));
									}
									if(funcName!=null && funcName.indexOf(":")>-1)
									{
										dispName = funcName.substring(funcName.indexOf(":")+1);
										funcName = funcName.substring(0,funcName.indexOf(":"));
									}
								}
							}

							if(keyTest!=null && keyTest.trim().length()>0 && listOfTest!=null && !listOfTest.contains(keyTest) && dispName!=null)
							{
								ArrayList tmpArry=(ArrayList)sameLabelHash.get(dispName);
								if(tmpArry!=null && tmpArry.size()>0)
								{
									for(int kk=0;kk<tmpArry.size();kk++)
									{
										keyForList =(String)tmpArry.get(kk);

										if(keyForList!=null && keyForList.indexOf(":")>-1)
										{
											keyTest=keyForList.substring(0,keyForList.indexOf(":"));
											keyMeasure=keyForList.substring(keyForList.indexOf(":")+1);
											if(keyMeasure!=null && keyMeasure.indexOf(":")>-1)
											{
												orgColName=keyMeasure.substring(keyMeasure.indexOf(":")+1);
												keyMeasure = keyMeasure.substring(0,keyMeasure.indexOf(":"));
												if(orgColName!=null && orgColName.indexOf(":")>-1)
												{
													funcName=orgColName.substring(orgColName.indexOf(":")+1);
													orgColName = orgColName.substring(0,orgColName.indexOf(":"));

													if(funcName!=null && funcName.indexOf(":")>-1)
													{
														dispName=funcName.substring(funcName.indexOf(":")+1);
														funcName = funcName.substring(0,funcName.indexOf(":"));
													}
												}
											}
										}

										if(keyTest!=null && keyTest.trim().length()>0 && listOfTest!=null && listOfTest.contains(keyTest))
										{
											break;
										}
									}
								}
							}

							String colKeyName = Dbdata.getColumnForMeasure(keyTest+"_DDD",orgColName);
							String tmpK = colKeyName+"^"+info_to_lower.toLowerCase()+"^"+compNameWithOutPort;
							Value=(String)measureValues.get(colKeyName+"^"+info_to_lower+"^"+compNameWithOutPort);
							if(Value==null){
								Value=(String)measureValues.get(colKeyName+"^"+info_to_lower.toLowerCase()+"^"+compNameWithOutPort);
							}
						}
						else if(isShowUserLocation && isLocationColumn)
						{
							if(keyForList!=null && keyForList.indexOf(":")>-1)
							{
								keyTest=keyForList.substring(0,keyForList.indexOf(":"));
								keyMeasure=keyForList.substring(keyForList.indexOf(":")+1);
							}

							funcName ="NONE";

							if(keyMeasure!=null && keyMeasure.trim().length()>0)
							{
								keyMeasureList = StringUtils.egTokenizer(keyMeasure,"~$~",true,false,true);//param 3-->includeEmpty,4-->unique,5-->trim
								if(keyMeasureList!=null && keyMeasureList.size()>0)
								{
									int meaListSize=keyMeasureList.size();
									if(meaListSize==1)
									{
										locKeyName = (String)keyMeasureList.get(0);
									}
									else if(meaListSize>1)
									{
										locKeyName = (String)keyMeasureList.get(0);
									}

									Value=(String)measureValues.get(locKeyName+"^"+info_to_lower+"^"+compNameWithOutPort);

									if(Value==null)
									{
										Value=(String)measureValues.get(locKeyName+"^"+info_to_lower.toLowerCase()+"^"+compNameWithOutPort);
									}

									if(meaListSize==1 && strSeparator!=null && strSeparator.trim().length()>0 && strReplaceSep!=null && strReplaceSep.trim().length()>0 && Value!=null && !Value.equals("-"))
									{
										Value = com.egurkha.util.StringUtils.replace(Value,strSeparator,strReplaceSep);
									}
								}
							}
						}
						else
						{
							if(keyForList!=null && keyForList.indexOf(":")>-1)
							{
								keyTest=keyForList.substring(0,keyForList.indexOf(":"));
								keyMeasure=keyForList.substring(keyForList.indexOf(":")+1);
								if(keyMeasure!=null && keyMeasure.indexOf(":")>-1)
								{
									keydisplayMeasure=keyMeasure.substring(keyMeasure.indexOf(":")+1);
									keyMeasure=keyMeasure.substring(0,keyMeasure.indexOf(":"));
								}
							}
							units=tablesInfo.getUnitForMeasure(keyTest,keyMeasure);
							keyOrgMeasure = keyMeasure;
							keyMeasure = Dbdata.getColumnForMeasure(keyTest,keyMeasure);
							if(specsInfo.isTestRelevantForServer(compValue,keyTest))
							{
								Value=(String)measureValues.get(keyMeasure+"^"+info_to_lower+"^"+compNameWithOutPort);
								if(Value==null){
									Value=(String)measureValues.get(keyMeasure+"^"+info_to_lower.toLowerCase()+"^"+compNameWithOutPort);
								}
							}
						}
						
						//if((Value==null || Value.trim().length()==0) && compValue!=null && compValue.equals("Xen_desktop_server"))
						if(Value==null || Value.trim().length()==0)
						{
							if(info_to_lower!=null && (info_to_lower.indexOf(" ")>-1 && info_to_lower.indexOf("on")>-1))
							{
								ArrayList tokenList =  com.egurkha.util.StringUtils.egTokenizer(info_to_lower, " on ",false,false,true);//param 3-->includeEmpty,4-->unique,5-->trim
								if(tokenList!=null && tokenList.size()==2)
								{
									info_to_lower=(String)tokenList.get(0)+"_on_"+(String)tokenList.get(1);
								}
							}
							Value=(String)measureValues.get(keyMeasure+"^"+info_to_lower+"^"+compNameWithOutPort);
							if(Value==null)
							{
								Value=(String)measureValues.get(keyMeasure+"^"+info_to_lower.toLowerCase()+"^"+compNameWithOutPort);
							}
						}
						String mes_state="";
						String mes_name="";
						String total_spc="0";

						if(Value!=null && Value.indexOf("^")>-1)
						{
							mes_state=Value.substring(Value.indexOf("^")+1);
							if(mes_state!=null && mes_state.indexOf("^")>-1)
							{
								mes_name=mes_state.substring(mes_state.indexOf("^")+1);
								mes_state=mes_state.substring(0,mes_state.indexOf("^"));
								if(mes_name!=null && mes_name.indexOf("^")>-1)
								{
									total_spc=mes_name.substring(mes_name.indexOf("^")+1);
									mes_name=mes_name.substring(0,mes_name.indexOf("^"));
								}
							}
							Value=Value.substring(0,Value.indexOf("^"));
						}
						else if(Value==null)
						{
							Value="-";
							mes_name=keyMeasure;
							mes_state="GOOD";
						}

						boolean sameLabelFlag=false;
						if(sameLabelHash!=null && sameLabelHash.size()>0 && keydisplayMeasure!=null && sameLabelHash.containsKey(keydisplayMeasure))
						{
							ArrayList tmpArry=(ArrayList)sameLabelHash.get(keydisplayMeasure);

							if(tmpArry!=null && tmpArry.size()>0 && keyForList!=null && tmpArry.contains(keyForList))
								tmpArry.remove(keyForList);

							if(tmpArry!=null && tmpArry.size()>0)
							{
								sameLabelFlag=true;
								if(!dashboardModel.isTestActive(compValue, compName, keyTest, "custom"))
									Value="-";
							}
						}

						if((Value==null || Value.equals("-")) && sameLabelFlag && (sameLabelHash!=null && sameLabelHash.size()>0 && sameLabelHash.containsKey(keydisplayMeasure)))
						{
							ArrayList tmpArry=(ArrayList)sameLabelHash.get(keydisplayMeasure);
							if(tmpArry!=null && tmpArry.size()>0)
							{
								if(tmpArry.contains(keyForList))
									tmpArry.remove(keyForList);

								for(int kk=0;kk<tmpArry.size();kk++)
								{
									keyForList =(String)tmpArry.get(kk);
									String tmp_keyTest=null;
									String tmp_keyMeasure=null;
									String tmp_keydisplayMeasure=null;
									if(keyForList!=null && keyForList.indexOf(":")>-1)
									{
										tmp_keyTest=keyForList.substring(0,keyForList.indexOf(":"));
										tmp_keyMeasure=keyForList.substring(keyForList.indexOf(":")+1);
										if(tmp_keyMeasure!=null && tmp_keyMeasure.indexOf(":")>-1)
										{
											tmp_keydisplayMeasure=tmp_keyMeasure.substring(tmp_keyMeasure.indexOf(":")+1);
											tmp_keyMeasure=tmp_keyMeasure.substring(0,tmp_keyMeasure.indexOf(":"));
										}
									}
									
									String tmp_units=tablesInfo.getUnitForMeasure(tmp_keyTest,tmp_keyMeasure);
									String tmp_keyOrgMeasure = tmp_keyMeasure;
									tmp_keyMeasure = Dbdata.getColumnForMeasure(tmp_keyTest,tmp_keyMeasure);
									String tmp_Value=null;
									if(specsInfo.isTestRelevantForServer(compValue,tmp_keyTest))
									{
										tmp_Value=(String)measureValues.get(tmp_keyMeasure+"^"+info_to_lower+"^"+compNameWithOutPort);
										if(tmp_Value==null){
											tmp_Value=(String)measureValues.get(tmp_keyMeasure+"^"+info_to_lower.toLowerCase()+"^"+compNameWithOutPort);
										}
									}

									if(tmp_Value==null || tmp_Value.trim().length()==0)
									{
										if(info_to_lower!=null && (info_to_lower.indexOf(" ")>-1 && info_to_lower.indexOf("on")>-1))
										{
											ArrayList tokenList =  com.egurkha.util.StringUtils.egTokenizer(info_to_lower, " on ",false,false,true);//param 3-->includeEmpty,4-->unique,5-->trim
											if(tokenList!=null && tokenList.size()==2)
											{
												info_to_lower=(String)tokenList.get(0)+"_on_"+(String)tokenList.get(1);
											}
										}
										tmp_Value=(String)measureValues.get(tmp_keyMeasure+"^"+info_to_lower+"^"+compNameWithOutPort);
										if(tmp_Value==null)
										{
											tmp_Value=(String)measureValues.get(tmp_keyMeasure+"^"+info_to_lower.toLowerCase()+"^"+compNameWithOutPort);
										}
									}

									if(tmp_Value!=null && tmp_Value.indexOf("^")>-1)
									{
										String tmp_mes_state=tmp_Value.substring(tmp_Value.indexOf("^")+1);
										String tmp_total_spc=null;
										String tmp_mes_name=null;
										if(tmp_mes_state!=null && tmp_mes_state.indexOf("^")>-1)
										{
											tmp_mes_name=tmp_mes_state.substring(tmp_mes_state.indexOf("^")+1);
											tmp_mes_state=tmp_mes_state.substring(0,tmp_mes_state.indexOf("^"));
											if(tmp_mes_name!=null && tmp_mes_name.indexOf("^")>-1)
											{
												total_spc=tmp_mes_name.substring(tmp_mes_name.indexOf("^")+1);
												tmp_mes_name=tmp_mes_name.substring(0,tmp_mes_name.indexOf("^"));
											}
										}
										tmp_Value=tmp_Value.substring(0,tmp_Value.indexOf("^"));

										if(tmp_Value!=null && !tmp_Value.trim().equals("-"))
										{
											keyTest=tmp_keyTest;
											keyMeasure=tmp_keyMeasure;
											Value=tmp_Value;
											total_spc= tmp_total_spc;
											mes_name=tmp_mes_name;
											mes_state=tmp_mes_state;
											break;
										}
									}
								}
							}
						}


						widthOfTheHead="60";
						if(units!=null && units.equals("%")) 
							widthOfTheHead="150";
						
						String orgValue="0.0";
						try
						{
							if(Value!=null && Value.trim().length()>0 && Value.indexOf(".")>-1 && Double.parseDouble(Value)>0)
							{
								orgValue=Value;
								//Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
								if(decimalFormatTestMeasureList!=null && decimalFormatTestMeasureList.size()>0 && decimalFormatTestMeasureList.contains(keyTest+":"+keyOrgMeasure))
								{
									Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),4));
								}
								else if(convertToDaysTestMeasureList!=null && convertToDaysTestMeasureList.size()>0 && convertToDaysTestMeasureList.contains(keyTest+":"+keyOrgMeasure))
								{
									Value = getConvertDays(Value,egDashboard);
								}
								else
								{
									Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
								}

								Value=String.valueOf(Value);
							}
							else if(Value!=null && Value.trim().length()>0  && Double.parseDouble(Value)>0)
							{
								orgValue=Value;
								//Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
								if(decimalFormatTestMeasureList!=null && decimalFormatTestMeasureList.size()>0 && decimalFormatTestMeasureList.contains(keyTest+":"+keyOrgMeasure))
								{
									Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),4));
								}
								else if(convertToDaysTestMeasureList!=null && convertToDaysTestMeasureList.size()>0 && convertToDaysTestMeasureList.contains(keyTest+":"+keyOrgMeasure))
								{
									Value = getConvertDays(Value,egDashboard);
								}
								else
								{
									Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
								}

								Value=String.valueOf(Value);
							}
						}
						catch(Exception ee)
						{
							Value=Value;
							orgValue=Value;
						}
						if(mes_state!=null && mes_state.length()>0 && mes_state.equalsIgnoreCase("NONE"))
						{
							mes_state="GOOD";
						}
						else if(mes_state!=null && mes_state.trim().length()==0)
						{
							mes_state="GOOD";
						}
						if(Value.equalsIgnoreCase("on"))
						{
							buf.append("<td align=\"center\" ><img  src=\"/final/monitor/eg_images/yes2.gif\"></td>"); 
						}
						else if(Value.equalsIgnoreCase("off"))
						{
							buf.append("<td align=\"center\" ><img  src=\"/final/monitor/eg_images/no2.gif\"></td>");
						}
						else
						{
							String measuresLink = "";
							if(fromMenuStr!=null && !fromMenuStr.equalsIgnoreCase("null") && fromMenuStr.trim().length()>0 && fromMenuStr.equalsIgnoreCase("true"))
							{
								String layerName = tablesInfo.getRelevantLayer(compValue,keyTest,keyOrgMeasure);
								layerName=(layerName==null || layerName.trim().length()==0)?ctype_layer:layerName;
								
								String infoKey = compValue+":"+compName+":"+keyTest+":"+info_to_lower;
								HashSet infosSet = null;
								if(fullInfoHash!=null && fullInfoHash.size()>0)
									infosSet = (HashSet)fullInfoHash.get(infoKey);
								ArrayList infosList = null;
								if(infosSet!=null && infosSet.size()>0)
									infosList = new ArrayList(infosSet);
								String info_name = "";
								if(infosList!=null && infosList.size()>1)
								{
									for(int is=0;is<infosList.size();is++)
									{
										String tmpInfo = (String)infosList.get(is);
										if(tmpInfo!=null && (tmpInfo.endsWith(":Summary") || tmpInfo.endsWith(":Total")))
										{
											info_name = tmpInfo;
											break;
										}
									}
									if(info_name==null || info_name.equalsIgnoreCase("null") || info_name.trim().length()==0)
									{
										info_name = (String)infosList.get(0);
									}
								}
								else if(infosList!=null && infosList.size()==1)
								{
									info_name = (String)infosList.get(0);
								}
								if(info_name==null || info_name.equalsIgnoreCase("null") || info_name.trim().length()==0)
								{
									info_name = "+" + info_to_lower;
								}
								measuresLink = "/final/monitor/EgSiteInfraView.jsp?qctr=2"+"&site=NULL"+"&fromalarm=0"+"&newWindow=false"+"&host="+EgURLEncoder.encode(compName,"UTF-8")+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&comptype="+compValue+"&layer="+layerName+"&test="+keyTest+"-"+EgURLEncoder.encode(info_name,"UTF-8")+"&tstate="+mes_state+"&toDashBoardLayer=true";
							}

							if(mes_name!=null)
							{
								if(Value!=null && !Value.equals("-"))
								{
									try
									{
										double fillColorValue=Double.parseDouble(orgValue);
										if(units!=null && units.equals("MB"))
										{
											//units = "GB";
											fillColorValue=fillColorValue/1024.0;
										}
										Value=String.valueOf(fillColorValue);
										//Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
										if(Value!=null && Value.trim().length()>0 && Value.indexOf(".")>-1 && Double.parseDouble(Value)>0)
										{
											if(decimalFormatTestMeasureList!=null && decimalFormatTestMeasureList.size()>0 && decimalFormatTestMeasureList.contains(keyTest+":"+keyOrgMeasure))
											{
												Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),4));
											}
											else if(convertToDaysTestMeasureList!=null && convertToDaysTestMeasureList.size()>0 && convertToDaysTestMeasureList.contains(keyTest+":"+keyOrgMeasure))
											{
												Value = getConvertDays(Value,egDashboard);
											}
											else
											{
												Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
											}
										}
										else
										{
											Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
										}
									}
									catch(Exception ee)
									{
										Value=String.valueOf(orgValue);
									}

									if(isDDDTestColumn || isLocationColumn)
									{
										buf.append("<td  align=\"left\"  >");
										buf.append("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"left\">");
									}
									else
									{
										buf.append("<td  align=\"center\" >");
										buf.append("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"right\">");
									}
									buf.append("<tr style=\"background:none !important\">");
									if(fromMenuStr!=null && !fromMenuStr.equalsIgnoreCase("null") && fromMenuStr.trim().length()>0 && fromMenuStr.equalsIgnoreCase("true"))
									{
										if(isDDDTestColumn || isLocationColumn)
										{
											buf.append("<td class=\"mouse\" align=\"left\" style=\"text-align:left;\" \"data-qtip=\""+Value+"\" data-qclass=\"yellowTip\" >");
											
										}
										else
										{
											buf.append("<td class=\"mouse\" align=\"right\" >");
										}
									}
									else
									{
										if(isDDDTestColumn || isLocationColumn)
										{
											buf.append("<td style=\"white-space:pre-wrap;border:none;\" align=\"left\">");
										}
										else
										{
											buf.append("<td style=\"white-space:pre-wrap;border:none;\" align=\"left\">");
										}
									}
								}
								else
								{
									if(isDDDTestColumn || isLocationColumn)
									{
										buf.append("<td  style=\"text-align:left;\" align=\"left\" >");
											buf.append("<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" borderColor=\"red\"  style=\"table-layout:auto;\" align=\"left\">");
									}
									else
									{
										buf.append("<td align=\"center\" >");
											buf.append("<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" borderColor=\"green\"  style=\"table-layout:auto;\" align=\"right\">");
									}
									buf.append("<tr style=\"background:none !important\">");
									if(fromMenuStr!=null && !fromMenuStr.equalsIgnoreCase("null") && fromMenuStr.trim().length()>0 && fromMenuStr.equalsIgnoreCase("true"))
									{
										if(isDDDTestColumn||isLocationColumn)
										{
											buf.append("<td align=\"left\" style=\"border:none;padding-right:10px;text-align:left;\" >");
										}
										else
										{
											buf.append("<td class=\"mouse\" align=\"left\" style=\"border:none;padding-right:10px\" >");
										}
									}
									else
									{
										buf.append("<td align=\"left\" style=\"border:none;padding-right:10px\">");
									}
								}
							}
							else
							{
								buf.append("<td  style=\"padding-top:4px;\" align=\"center\"  >");
									buf.append("<table cellspacing=\"0\" cellpadding=\"0\" style=\"table-layout:auto;border:0px solid red;border:none;\" align=\"right\">");
										buf.append("<tr style=\"background:none !important\">");
											if(fromMenuStr!=null && !fromMenuStr.equalsIgnoreCase("null") && fromMenuStr.trim().length()>0 && fromMenuStr.equalsIgnoreCase("true"))
											{
												if(isDDDTestColumn||isLocationColumn)
												{
													buf.append("<td align=\"right\" style=\"font-size:11px;text-align:right;width:20px;padding-right:10px\" >");
												}
												else
												{
													buf.append("<td class=\"mouse\" align=\"right\" style=\"font-size:11px;text-align:right;width:20px;padding-right:10px\" onClick=\"javascript:goToDetails('"+measuresLink+"');\" >");
												}
											}
											else
											{
												buf.append("<td align=\"right\" style=\"font-size:11px;text-align:right;width:20px;padding-right:10px\">");
											}
							}

							Value = formatDbValue(Value);
							String meaStateLabel = mappingInfo.getLabelDescription(mes_state);
							//dataVector.add("("+meaStateLabel+") "+Value);
							//dataVector.add(Value);
							if(Value!=null && !Value.equals("-"))
							{
								boolean usage =true;
								if(mes_name!=null && mes_name.equalsIgnoreCase("Cpu_used"))
								{
									usage = false;
									int columnWidth = 100;
									Long temp_measure_value=new Long(Math.round(Double.parseDouble(Value)));
									long fillColorValue=temp_measure_value.longValue();
									long value1 = (fillColorValue*100)/columnWidth;
									String mes_state_GOOD="";
									if (mes_state.equals("GOOD"))
									{
										mes_state_GOOD="#3baeda";
									}

									String mes_state_code="#3baeda";
									try
									{
										mes_state_code=ui.getValue("STATE_COLORS",mes_state);
										mes_state_code="#"+mes_state_code;
									}
									catch(Exception eee)
									{
										mes_state_code="#3baeda";
									}
														buf.append("<div style=\"width:80px;padding:0px;margin:0px;background:#e1e1e1;\">");
														//buf.append("<tr`>");
															//buf.append("<td align=\"left\" width=\"100%\" height=\"6\" //class=\"prog_line\">");
																//buf.append("<div style=\"width:"+value1+"% !important;display:inline-block;z-index:25000;height:6px;background:"+mes_state_GOOD+"\" height=\"6\">");
																buf.append("<div style=\"width:"+value1+"% !important;display:inline-block;z-index:25000;height:6px;background:"+mes_state_code+"\" height=\"6\">");
																		//buf.append("<div width=\"100%\" style=\"border:0px solid yellow;display:block;z-index:25000;height:6px\"></div>");
																buf.append("</div>");
															//buf.append("</td>");
														//buf.append("</tr>");
													buf.append("</div>");
								}
								else if(units!=null && units.equals("%") && !mes_name.equalsIgnoreCase("Ready") && usage)
								{
									int columnWidth = 100;
									Long temp_measure_value=new Long(Math.round(Double.parseDouble(Value)));
									long fillColorValue=temp_measure_value.longValue();
									long value2 = (fillColorValue*100)/columnWidth;
									String mes_state_GOOD="";
									if (mes_state.equals("GOOD"))
									{
										mes_state_GOOD="#3baeda";
									}

									String mes_state_code="#3baeda";
									try
									{
										mes_state_code=ui.getValue("STATE_COLORS",mes_state);
										mes_state_code="#"+mes_state_code;
									}
									catch(Exception eee)
									{
										mes_state_code="#3baeda";
									}
													buf.append("<div style=\"width:80px;padding:0px;margin:0px;background:#e1e1e1;\">");
														//buf.append("<tr`>");
															//buf.append("<td align=\"left\" width=\"100%\" height=\"6\" //class=\"prog_line\">");
																//buf.append("<div style=\"width:"+value2+"% !important;display:inline-block;z-index:25000;height:6px;background:"+mes_state_GOOD+"\" height=\"6\">");
																buf.append("<div style=\"width:"+value2+"% !important;display:inline-block;z-index:25000;height:6px;background:"+mes_state_code+"\" height=\"6\">");
																		//buf.append("<div width=\"100%\" style=\"border:0px solid yellow;display:block;z-index:25000;height:6px\"></div>");
																buf.append("</div>");
															//buf.append("</td>");
														//buf.append("</tr>");
													buf.append("</div>");
								}
							}
							buf.append("</td>");

							if(Value!=null && !Value.equals("-"))
							{
								boolean usage =true;
								if(isDDDTestColumn || isLocationColumn)
								{
									dataVector.add(Value);
									if(mes_name!=null && mes_name.equalsIgnoreCase("Cpu_used"))
									{
										usage =false;
										buf.append("<td style=\"border:none;text-align:left;padding-left:3px;width:42px;white-space:nowrap\">"+Value+"</td>");
									}
									else if(units!=null && units.equals("%") && !mes_name.equalsIgnoreCase("Ready") && usage)
									{
										buf.append("<td style=\"border:none;text-align:left;padding-left:3px;width:42px;white-space:nowrap\">"+Value+"</td>");
									}
									else
									{
										if(funcName!=null && (funcName.equalsIgnoreCase("NONE") || funcName.equalsIgnoreCase("DATE")))
										{
											buf.append("<td style=\"border:none;text-align:left;padding-left:3px;width:42px;white-space:nowrap\">"+Value+"</td>");
										}
										else
										{
											buf.append("<td style=\"border:none;text-align:right;padding-left:3px;width:42px;white-space:nowrap\">"+Value+"</td>");
										}
									}
								}
								else
								{
									dataVector.add("("+meaStateLabel+") "+Value);
									if(mes_name!=null && mes_name.equalsIgnoreCase("Cpu_used"))
									{
										usage =false;
										buf.append("<td style=\"border:none;text-align:left;padding-left:3px;width:42px;white-space:nowrap\">"+Value+"</td>");
									}
									else if(units!=null && units.equals("%") && !mes_name.equalsIgnoreCase("Ready") && usage)
									{
										buf.append("<td style=\"border:none;text-align:left;padding-left:3px;width:42px;white-space:nowrap\">"+Value+"</td>");
									}
									else
									{
										if(funcName!=null && (funcName.equalsIgnoreCase("NONE") || funcName.equalsIgnoreCase("DATE")))
										{
											//buf.append("<td style=\"border:none;text-align:left;padding-left:3px;width:42px;white-space:nowrap\"><table border='0'><tr style='background:none !important'><td><img src=\"/final/images/Dark/stateTick_"+mes_state+".png\"/></td><td>"+Value+"</td></tr></table></td>");

											//buf.append("<td style=\"border:none;text-align:left;padding-left:3px;width:42px;white-space:nowrap\"><div class='stateSymbol_"+mes_state+"' style='margin:auto;float:left;display:table-cell'></div>"+Value+"</td>");

											buf.append("<td style=\"border:none;text-align:left;padding-left:3px;width:42px;white-space:nowrap\"><table border='0'><tr style='background:none !important'><td><div class='stateSymbol_"+mes_state+"' style='margin:auto;float:left;display:table-cell'></div></td><td>"+Value+"</td></tr></table></td>");
										}
										else
										{
											//buf.append("<td style=\"border:none;text-align:right;padding-left:3px;width:42px;white-space:nowrap\"><table border='0'><tr style='background:none !important'><td><img src=\"/final/images/Dark/stateTick_"+mes_state+".png\"/></td><td>"+Value+"</td></tr></table></td>");

											//buf.append("<td style=\"border:none;text-align:right;padding-left:3px;width:42px;white-space:nowrap\"><div class='stateSymbol_"+mes_state+"' style='margin:auto;float:left;display:table-cell'></div>"+Value+"</td>");

											buf.append("<td style=\"border:none;text-align:right;padding-left:3px;width:42px;white-space:nowrap\"><table border='0'><tr style='background:none !important'><td><div class='stateSymbol_"+mes_state+"' style='margin:auto;float:left;display:table-cell'></div></td><td>"+Value+"</td></tr></table></td>");
										}
									}
								}
							}
							else
							{
								dataVector.add(Value);
								if(isDDDTestColumn || isLocationColumn)
								{
									buf.append("<td style=\"border:none;text-align:right;padding-left:3px;padding-right:30px;width:42px;white-space:nowrap\">"+Value+"</td>");
								}
								else
								{
									boolean usage =true;
									if(mes_name!=null && mes_name.equalsIgnoreCase("Cpu_used"))
									{
										buf.append("<td style=\"border:none;text-align:center;padding-left:3px;padding-right:30px;width:42px;white-space:nowrap\">"+Value+"</td>");
									}
									else if(units!=null && units.equals("%") && !mes_name.equalsIgnoreCase("Ready") && usage)
									{
										buf.append("<td style=\"border:none;text-align:center;padding-left:3px;padding-right:30px;width:42px;white-space:nowrap\">"+Value+"</td>");
									}
									else
									{
										buf.append("<td style=\"border:none;text-align:right;padding-left:3px;width:42px;white-space:nowrap\">"+Value+"</td>");
									}
								}
							}
										buf.append("</tr>");
									buf.append("</table>");
								buf.append("</td>");
						}
						p++;
					}
				}
				else
				{
					int p=0;
					while(p<measureList.size())
					{
									//buf.append("<td style=\"font-size:11px;text-align:right;width:20px;padding-right:10px;!important\" align=\"right\" class=\"x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first\">-</td>"); 
									buf.append("<td  style=\"padding-top:4px;\" align=\"center\" >");
										buf.append("<table cellspacing=\"0\" cellpadding=\"0\" style=\"table-layout:auto;border:0px solid red\" align=\"left\">");
											buf.append("<tr style=\"background:none !important\">");
												//buf.append("<td align=\"right\" style=\"font-size:11px;text-align:right;width:20px;padding-right:10px\">");
												//buf.append("</td>");
												buf.append("<td style=\"text-align:left;border:none;\">");
												buf.append("-</td>");
											buf.append("</tr>");
										buf.append("</table>");
									buf.append("</td>");
						p++;
						dataVector.add("-");
					}
				}

									buf.append("</tr>");

				listData.add(dataVector);
			}
								buf.append("</tbody>");	
							buf.append("</table>");
						buf.append("</div>");
					buf.append("</td>");
				buf.append("</tr>");
			buf.append("</table>");
		}
		
	}
	else
	{
		int col_span=measureList.size();
		buf.append("<table border=\"0\" width=\"100%\" height=\"100%\" bordercolor=\"green\">");
			buf.append("<tr style=\"background:none\">");
				buf.append("<td align=\"center\" width=\"100%\" colspan=\""+col_span+"\" height=\"100%\" class=\"commonErrorMsgText\" >");
					buf.append("<img src = \"/final/images/spacer.gif\" class=\"iconExclamation\" lign = \"center\" border = \"0\"  vspace = \"10\"/>");
					buf.append("<br>"+mappingInfo.getTextDescription("monitor.endUserDashboard.No Records Found"));
				buf.append("</td>");
			buf.append("</tr>");
		buf.append("</table>");
	}
	session.setAttribute("endusercsvlist",listData);

	if(isDataManagerLogin)
	{
		if(request.getQueryString()!=null)
		{
			String qry=request.getQueryString();
			qry=com.egurkha.util.StringUtils.replace(qry, "\\", "\\\\");
			session.setAttribute("monitorLastSession","/final/monitor/endUserDashboard.jsp?access=allusers&"+qry);
		}
		else
			session.setAttribute("monitorLastSession","/final/monitor/endUserDashboard.jsp?access=allusers");
	}
	response.getWriter().write(buf.toString());
}
catch(Throwable th)
{
	th.printStackTrace();
}
%>

<%!
	private static DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance();
	static{
		DecimalFormatSymbols dfs = new DecimalFormatSymbols();
		dfs.setDecimalSeparator('.');

		df.applyPattern("#.##");
		df.setDecimalFormatSymbols(dfs);
		df.setGroupingSize(0);
	}

	private static DecimalFormat df2 = (DecimalFormat)NumberFormat.getNumberInstance();
	static{
		DecimalFormatSymbols dfs2 = new DecimalFormatSymbols();
		dfs2.setDecimalSeparator('.');

		df2.applyPattern("#.####");
		df2.setDecimalFormatSymbols(dfs2);
		df2.setGroupingSize(0);
	}

	private static DecimalFormat df3 = (DecimalFormat)NumberFormat.getNumberInstance();
	static{
		DecimalFormatSymbols dfs3 = new DecimalFormatSymbols();
		dfs3.setDecimalSeparator('.');

		df3.applyPattern("#");
		df3.setDecimalFormatSymbols(dfs3);
		df3.setGroupingSize(0);
	}

	public static String formatDbValue(String measure)
	{
		String value="";
		try
		{
			/*
				* Check the indexOf "e", For avoid Exponent or Scientific Notation in a String, 
				Because of Address and other String field changed like double data type value
				when we use Double.parseDouble, Its wrong, So put this fix.

				* The real double value not affected because of this change. its shown as per db..

				* changed by Saravanan.A on 31-1-2012.
			*/

			/*
				* Double parsing have problem when double value range exceed, So used BigDecimal instead of Double parsing.

				* changed by Saravanan.A on 15-2-2012.
			*/

			String measure_lower=null;
			if(measure!=null && measure.length()>0)
				measure_lower=measure.toLowerCase().trim();
			
			if(measure_lower!=null && measure_lower.indexOf("e")>-1)
			{
				try
				{
					BigDecimal bigDecRef = new BigDecimal(measure);
					value=df2.format(bigDecRef);
				}
				catch(Exception eee)
				{
					value=measure;
				}
			}
			else
			{
				//double val=Double.parseDouble(measure);
				//value = df.format(val);

				BigDecimal bigDecRef = new BigDecimal(measure);
				value = df.format(bigDecRef);
				double xxx=bigDecRef.doubleValue();
				if(xxx>=100.0)
				{
					value = df3.format(bigDecRef);
				}
				else if(xxx>=1 && xxx<100)
				{
					value = df.format(bigDecRef);
				}
				else
				{
					value=df2.format(bigDecRef);
				}

			}
		}catch(Exception e)
		{
			value=measure;
		}
		return value;
	}

%>
<%!
	public void writeLog(String content,boolean isDebugEnabledField,int logFileSizeField)
	{
		if(isDebugEnabledField)
		{
			boolean append = true;
				try
				{
					String path = EgInstallInfo.getInstallDir()+ "/manager/logs/userExpDashBoard.txt";
					File f = new File(path); 
					if(f.exists())
					{
						int size = new FileInputStream(f).available();
						if(size>(1024*1024*logFileSizeField))
						{
							append = false;
							content = "";
						}
					}
					PrintWriter pw = new PrintWriter(new FileWriter(path,append));
					pw.write(new java.util.Date()+" endUserDashboardData.jsp "+content);
					pw.write("\n");
					pw.flush();
					pw.close();
				}
				catch (Exception e)
				{
					e.printStackTrace();
				}
		}
	}

	public static String getConvertDays(String Value,EgDashBoardModel egDashboard)
	{
		String dateDiff="";
		String currentValue=Value;
		try
		{
			if(currentValue!=null && !currentValue.trim().equals(""))
			{
				long minutes=0;
				int seconds=0;
				if(currentValue!=null && currentValue.indexOf(".")>0)
				{
					minutes=Long.parseLong(currentValue.substring(0,currentValue.indexOf(".")));
					if(currentValue.substring(currentValue.indexOf(".")+1).length()>2)
					{
						seconds=Integer.parseInt(currentValue.substring(currentValue.indexOf(".")+1,currentValue.indexOf(".")+3));
					}
					else
					{
						seconds=Integer.parseInt(currentValue.substring(currentValue.indexOf(".")+1));
					}
				}
				else
				{
					minutes=Long.parseLong(currentValue);
				}
				long valueInSecond=(minutes*60)+seconds;
				dateDiff=egDashboard.getDateDifferenceStringforUptime(valueInSecond);
			}
			else
			{
				dateDiff=currentValue;
			}
		}
		catch(Exception eeew)
		{
			dateDiff=currentValue;
		}

		return dateDiff;
	}
%>

