<%
/********************************************************************************
FileName	:egUptimeSummary.jsp
Purpose		:This is created for Uptime Summary for Systems/Network Devices
Created by	:Rajesh.P
Created on	:09/07/2009
**********************************************************************************/
%>
<%@ include file = "EgServerDashboardTracker.jsp"%>
<%@ page errorPage = "EgProbsM.jsp"%>
<%@ page import="egurkha.reporter.uptime.*" %>
<%@ page import="java.util.*"%>
<%@ page import="java.text.*"%>
<%@ page import = "egurkha.reporter.ErUtils"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.eg.IniFile"%>
<%@ page import = "com.egurkha.util.DateTimeTokenizer"%>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import="net.sf.json.*"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page language="java" contentType="application/json;charset=UTF-8" pageEncoding="UTF-8"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	
	JSONObject rootJson = new JSONObject();
	JSONObject uptimeObj = new JSONObject();
	JSONObject rebootObj = new JSONObject();
	JSONArray uptimeArr = new JSONArray();

	EgMappingInfo mappingInfo=new EgMappingInfo(trackerLanguage);
	String hostName=request.getParameter("hostName");
	String upTimeType=request.getParameter("upTimeType");
	String s_iniFile_dir=EgInstallInfo.getInstallDir()+"/manager/config/";


	String compType=request.getParameter("compType");

	String dashboardIni = "eg_serverdashboard.ini";
	if(compType!=null && compType.startsWith("Agg_"))
	{
		dashboardIni = "eg_aggregateserverdashboard.ini";
	}

	IniFile iniObj=new IniFile(s_iniFile_dir+dashboardIni);

	java.util.Date endDate=new java.util.Date();
	java.util.Date uptimeStartDate=new java.util.Date(endDate.getTime()-(24*60*60*1000));

	String timeline=iniObj.getValue("Default_UpTimeSummary_Duration","duration");
	if(timeline==null && timeline.equals(""))
	{
		timeline="24 hours";
	}
	int value=0;
	int timeValue=0;

	String unit="";

	String uptimeStartTime=request.getParameter("uptimeStartTime");
	String uptimeEndTime=request.getParameter("uptimeEndTime");

	if(timeline!=null && !timeline.equals("") && !timeline.equalsIgnoreCase("any"))
	{
		timeline=timeline.trim();
		int blankSpaceIndex = timeline.indexOf(DateTimeTokenizer.BLANK_SPACE);
		
		EgDateInfo edi = new EgDateInfo();
		Date today = edi.egetRealDate();
		Date start = edi.egetRealDate();

		if (blankSpaceIndex > 0)
		{
			SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
			SimpleDateFormat dateFormat=new SimpleDateFormat("MM/dd/yyyy");
			value = Integer.parseInt(timeline.substring(0, blankSpaceIndex));
			timeValue=Integer.parseInt(timeline.substring(0, blankSpaceIndex));
			unit = timeline.substring(blankSpaceIndex+1).toLowerCase();
			if (unit.startsWith("h"))
			{//hours
				value *= 3600;
			}
			else if (unit.startsWith("d"))
			{//days
				value *= (24 * 3600);
			}
			else if (unit.startsWith("w"))
			{//weeks
				value *= (7 * 24 * 3600);
			}
			else if (unit.startsWith("mo"))
			{//months
				value *= (30 * 24 * 3600);
			}
			long longValue=value;

			start.setTime(today.getTime() - (longValue * 1000));

			uptimeEndTime=sdf.format(today);
			uptimeStartTime=sdf.format(start);
		}
	}

	String componentlist[]={hostName};
	String shr="00";
	String enhr="24";
	String stmin="00";
	String enmin="00";
	ErUptimeReportBean repoterBean=new ErUptimeReportBean();
	ErUptimeDowntimeBean uptimeBean = repoterBean.getUptimeDownDetails(componentlist,uptimeStartTime,uptimeEndTime,shr,enhr,stmin,enmin,upTimeType);
	String totalUptime=uptimeBean.getUpTime();
	if(totalUptime!=null && !totalUptime.equals("") && !totalUptime.equalsIgnoreCase("null"))
	{
	/*	totalUptime=com.egurkha.util.StringUtils.replace(totalUptime," s "," Seconds(s) ");
		totalUptime=com.egurkha.util.StringUtils.replace(totalUptime," h "," Hour(s) ");
		totalUptime=com.egurkha.util.StringUtils.replace(totalUptime," d "," Day(s) ");
		totalUptime=com.egurkha.util.StringUtils.replace(totalUptime," M "," Month(s) ");
		totalUptime=com.egurkha.util.StringUtils.replace(totalUptime," m "," Min(s) ");*/
	}
	else
	{
		totalUptime="-";

	}
	String upTimePercent=uptimeBean.getPerUpTime();
	if(upTimePercent==null || (upTimePercent!=null && (upTimePercent.equals("") || upTimePercent.equalsIgnoreCase("null"))))
	{
		upTimePercent="-";
	}
	String downTime=uptimeBean.getDownTime();
	if(downTime!=null && !downTime.equals("") && !downTime.equalsIgnoreCase("null"))
	{
	/*	downTime=com.egurkha.util.StringUtils.replace(downTime,"s","Seconds(s)");
		downTime=com.egurkha.util.StringUtils.replace(downTime,"h","Hour(s)");
		if(downTime!=null && downTime.indexOf("d")>0)
		{
			downTime=com.egurkha.util.StringUtils.replace(downTime,"d","Day(s)");
		}
		else if(downTime!=null && downTime.indexOf("D")>0)
		{
			downTime=com.egurkha.util.StringUtils.replace(downTime,"D","Day(s)");
		}
		downTime=com.egurkha.util.StringUtils.replace(downTime,"M","Month(s)");
		downTime=com.egurkha.util.StringUtils.replace(downTime,"m","Min(s)");*/
		
	}
	else
	{
		downTime="-";
	}
	String downTimePercent=uptimeBean.getPerDownTime();
	if(downTimePercent==null || (downTimePercent!=null && (downTimePercent.equals("") || downTimePercent.equalsIgnoreCase("null"))))
	{
		downTimePercent="-";
	}
	int noOfReboots=uptimeBean.getNoOfReboots();
	boolean isShowDetails=uptimeBean.isShowDetails();
	List uptimeData = uptimeBean.getRebootHistoryForMonitor();
	ErUptimeData data = null;
	boolean compFound = false;
	for(int i=0; i<uptimeData.size(); i++) {
		data = (ErUptimeData)uptimeData.get(i);
		if(data.getTrgtHost().equals(hostName)) {
			compFound = true;
			break;
		}
	}
	List shutdownList = new ArrayList();
	List rebootList = new ArrayList();
	List durationList = new ArrayList();
	if(compFound) {
		rebootList = data.getFilteredReboot();
		shutdownList = data.getFilteredShutdown();
		durationList = data.getFilteredDuration();
	}
	uptimeObj.put("tableTitle",mappingInfo.getTextDescription("monitor.dashboard.Uptime")+"/"+mappingInfo.getTextDescription("monitor.dashboard.Downtime Summary")+"-"+mappingInfo.getTextDescription("monitor.dashboard.Last")+timeline);

	uptimeObj.put("COLUMN_0",mappingInfo.getTextDescription("monitor.dashboard.Total Uptime"));
	uptimeObj.put("COLUMN_0_val",totalUptime);
	uptimeObj.put("COLUMN_1",mappingInfo.getTextDescription("monitor.dashboard.Total Uptime")+"(%)");
	uptimeObj.put("COLUMN_1_val",upTimePercent);
	uptimeObj.put("COLUMN_2",mappingInfo.getTextDescription("monitor.dashboard.Total Downtime"));
	uptimeObj.put("COLUMN_2_val",downTime);
	uptimeObj.put("COLUMN_3",mappingInfo.getTextDescription("monitor.dashboard.Total Downtime")+"(%)");
	uptimeObj.put("COLUMN_3_val",downTimePercent);
	uptimeObj.put("COLUMN_4",mappingInfo.getTextDescription("monitor.dashboard.No Of Reboots"));
	uptimeObj.put("COLUMN_4_val",noOfReboots);

	uptimeArr.add(uptimeObj);


	rebootObj.put("RebootTitle",mappingInfo.getTextDescription("monitor.dashboard.Reboot Summary")+"-"+mappingInfo.getTextDescription("monitor.dashboard.Last")+timeline);

	if(isShowDetails)
	{
		rebootObj.put("Msg","false");
		rebootObj.put("COLUMN_0",mappingInfo.getTextDescription("monitor.dashboard.Shutdowned At"));
		rebootObj.put("COLUMN_1",mappingInfo.getTextDescription("monitor.dashboard.Rebooted At"));
		rebootObj.put("COLUMN_2",mappingInfo.getTextDescription("monitor.dashboard.Duration"));

		String uiFile = "eg_ui.ini";
		com.eg.IniFile egUI = new com.eg.IniFile(s_iniFile_dir + uiFile);
		String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
		SimpleDateFormat rsdf = new SimpleDateFormat(currentDateFormat+" HH:mm:ss");

		for(int i=0; i<shutdownList.size(); i++) 
		{
			String shutTime = rsdf.format(((Calendar)shutdownList.get(i)).getTime());
			String rebootTime = rsdf.format(((Calendar)rebootList.get(i)).getTime());
			rebootObj.put("COLUMN_0_val",shutTime);
			rebootObj.put("COLUMN_1_val",rebootTime);
			rebootObj.put("COLUMN_2_val",durationList.get(i)+" Mins");
		}
	}
	else
	{
		rebootObj.put("Msg","true");
		rebootObj.put("EmptyMsg",mappingInfo.getTextDescription("monitor.common.No Reboots Done"));
	}
	uptimeArr.add(rebootObj);
	rootJson.put("uptimeArr",uptimeArr);
	System.out.println("rootJson uptimesummary------->"+rootJson);
	out.println(rootJson.toString());
%>