<%
/********************************************************************************
FileName	:egSystemAnalysis.jsp
Purpose		:This is created for System Analysis page in Dashboard
Created by	:Saravanan.A
Created on	:10/06/2009
**********************************************************************************/
%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file = "EgMonitorTracker.jsp"%>
<%@ page errorPage = "EgProbsM.jsp"%>
<%@ page import="java.util.*"%>
<%@ page import="java.text.*"%> 
<%@ page import="java.sql.*"%>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import="egurkha.*"%>
<%@ page import="com.eg.IniFile"%>
<%@ page import="com.eg.EgExternalInfo"%>
<%@ page import="com.eg.EgURLEncoder"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.eg.EgSpecsInfo"%>
<%@ page import="com.eg.EgDbInfo"%>
<%@ page import="com.eg.EgTablesInfo"%>
<%@ page import="com.eg.EgMemInfo"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.egurkha.util.DateUtil"%>
<%@ page import="com.egurkha.monitor.*"%>
<%@ page import="com.objectplanet.chart.*"%>
<%@ page import="egurkha.reporter.ErUtils"%>
<%@ page import="com.eg.EgTesterInfo" %>
<%@ page import="com.eg.EgAgentInfo"%>
<%@ page import="com.egurkha.util.EgSorter"%>
<%@ page import="com.eg.*"%>
<%@ page import="com.egurkha.*" %>
<%@ page import="com.egurkha.ini.IniUI" %>
<%@ page import="com.egurkha.util.MathUtils"%>
<%@ page import="net.sf.json.*"%>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "com.eg.supermanager.*"%>
<jsp:useBean id="trans" scope="page" class="egurkha.TransactionBean"/>
<jsp:useBean id="trans_services_ini" scope="page" class="egurkha.TransactionBean" />
<jsp:useBean id="dd" scope="page" class="com.egurkha.monitor.EgDiagnosisBean" />

<%
	response.setContentType("application/json");
	request.setCharacterEncoding("UTF-8");
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>
<%
try
{
	ErUtils  erutils=new  ErUtils();
	IniUI ui = IniUI.getInstance();
	String s_iniFile_dir=EgInstallInfo.getInstallDir()+"/manager/config/";
	IniFile iniObj=new IniFile(s_iniFile_dir+"eg_dashboard.ini");
	IniFile egUi = new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_ui.ini");
	
	//com.egurkha.ini.IniUI trackerUI = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	//String trackerLanguage = trackerUI.getDefaultLanguage();
	
	
	IniFile iniObjForServer=new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_serverdashboard.ini");
	EgTablesInfo tablesInfo=new EgTablesInfo("manager");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	//EgMappingInfo mappingInfo=new EgMappingInfo(trackerLanguage);
	EgDashBoardModel egDashboard=new  EgDashBoardModel();
	EgFusionChartUtil fusionChartUtil=new EgFusionChartUtil();
	String subject="System_Dashboard_Metrics";
	String VM_subject="Display_Analysis";
	String analysis_Subject="";
	String DialChartNeed=iniObjForServer.getValue("Dashboard_Settings","UseDial");
	
	String chartOption = egUi.getValue("CHART_TYPE","ChartOption");
	String chartTimeline = egUi.getValue("CHART_TYPE","Timeline");
	chartTimeline = (chartTimeline != null && !chartTimeline.equals(""))?chartTimeline:"1 hour";

	String currentDateFormat = egUi.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	
	/*String monitor_Skin = null;
	User u_ser = null;
	boolean from_sm = false;
	String currentuser=null;
	String sess_userid=null;
	if(session.getAttribute("sessionId_SM") != null)
	{
		from_sm = true;
		currentuser = (String)session.getAttribute("sess_userid");
	}
	if(session!=null)
	{
		if(from_sm)
		{
			u_ser = UserRegistry.getInstance().getUser(sess_userid,true);
		}
		else
		{
			u_ser = UserRegistry.getInstance().getUser(session.getId(),true);
		}
	}
	if (u_ser!=null)
	{
			u_ser.setUserLanguageAndSkins();
			monitor_Skin  = u_ser.getMonitorSkin();
	}*/

	
	long time_diff_in_ms = 0;
	if(com.eg.EgInstallInfo.isSuperManager)
	{
		String currentSession = session.getId();
		String hostname = request.getParameter("hostName");
		//System.out.println("egSystemAnalysis.jsp hostname " + hostname);
		if(hostname != null)
		{
			if(hostname.indexOf(":")>-1)
			{
				hostname = hostname.substring(0,hostname.indexOf(":"));
			}
			//System.out.println("egSystemAnalysis.jsp host " + hostname);
			ArrayList managerIds = EgElementInfo.getInstance().getManagerIDs("component",hostname);
			//System.out.println("egSystemAnalysis.jsp managerIds " + managerIds);
			if(managerIds != null && !managerIds.isEmpty())
			{
				String s_mgrid = (String)managerIds.get(0);
				String ms = EgSmSuperInfo.getInstance().getValue(s_mgrid,"TIME_DIFF");
				try
				{
					if(ms != null && ms.trim().length()>0)
					{
						time_diff_in_ms = Long.parseLong(ms);
					}
				}
				catch(Exception e)
				{
					e.printStackTrace();
				}
				SmSessionData smsData = new SmSessionData(currentSession,managerIds);
				EgThreadLocal egtl = new EgThreadLocal();
				egtl.set(smsData);
			}
		}
	}
	
	
	
	if(DialChartNeed==null || DialChartNeed.equals(""))
		DialChartNeed="Yes";
	boolean ddEnabled = EgMemInfo.ddEnabled;
	boolean noGraphsFound=true;
	boolean isMoreInfosView=false;

	String showLegStr = request.getParameter("showLegend");
	String compName=request.getParameter("hostName");
	String compType=request.getParameter("compType");
	String siteName=request.getParameter("site");
	siteName=(siteName==null)?"NULL":siteName;
	String componentState=egDashboard.getServerState(compName,compType,siteName);

	egDashboard.setSubject(compType);

	String tab=request.getParameter("tab");
	String subsystem=request.getParameter("subsystem");
	if(subsystem==null || (subsystem!=null && subsystem.equalsIgnoreCase("Overview")))
		subsystem="Analysis";
	if(compType!=null && compType.equals("Solaris_virtual_server"))
	{
		subsystem="InsideView";
	}
	String graphType=request.getParameter("graphType");
	String BarOrMeasureView = request.getParameter("BarOrMeasureView");
	boolean isBarOrMeasureView=false;
	if(BarOrMeasureView!=null && BarOrMeasureView.equalsIgnoreCase("true"))
	{
		isBarOrMeasureView=true;
	}
	
	String screenWidth=request.getParameter("screenWidth");
	String screenHeight=request.getParameter("screenHeight");
	
	double screenWidthInDouble=1024.0;
	double screenHeightInDouble=768.0;
	if(screenWidth!=null && !screenWidth.equals(""))
	{
		screenWidthInDouble=Double.parseDouble(screenWidth);
	}

	if(screenHeight!=null && !screenHeight.equals(""))
	{
		screenHeightInDouble=Double.parseDouble(screenHeight);
	}

	String ddGraphWidth="232";
	String ddGraphHeight="156";
	String barGraphWidth="90";
	String barGraphHeight="100";

	double defaultDDGraphWidth=300;
	double defaultDDGraphHeight=156;

	double defaultbarGraphWidth=90;
	double defaultbarGraphHeight=100;

	double ddgraphWidthTo1024Px=defaultDDGraphWidth/1024;
	double ddGraphWidthInDouble=screenWidthInDouble*ddgraphWidthTo1024Px;
	ddGraphWidth=erutils.round(ddGraphWidthInDouble,0);

	double ddgraphHeightToDefaultDDHeightInPercent=defaultDDGraphHeight/defaultDDGraphWidth;
	double ddGraphHeightInDouble=ddGraphWidthInDouble*ddgraphHeightToDefaultDDHeightInPercent;
	ddGraphHeight=erutils.round(ddGraphHeightInDouble,0);

	//for cylinder graphs
	double bargraphWidthTo1024Px=defaultbarGraphWidth/1024;
	double barGraphWidthInDouble=screenWidthInDouble*bargraphWidthTo1024Px;
	barGraphWidth=erutils.round(barGraphWidthInDouble,0);

	double bargraphHeightToDefaultbarHeightInPercent=defaultbarGraphHeight/defaultbarGraphWidth;
	double barGraphHeightInDouble=barGraphWidthInDouble*bargraphHeightToDefaultbarHeightInPercent;
	barGraphHeight=erutils.round(barGraphHeightInDouble,0);
	String[] supported_types=iniObj.getVariables("Supported_Types");
	List supported_types_list=null;
	
	JSONObject json = new JSONObject();
	JSONObject hiddenFields = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	String custom_select_subsystem = null ;
	
	hiddenFields.put("hostName",compName);
	hiddenFields.put("compType",compType);
	
	if(supported_types!=null && supported_types.length>0)
	{
		supported_types_list=Arrays.asList(supported_types);
	}

	if(graphType==null || graphType.equals(""))
	{
		if(supported_types_list!=null && supported_types_list.contains(compType) && subsystem!=null && subsystem.equalsIgnoreCase("Analysis"))
		{
			graphType="CPU";
		}
		else if(supported_types_list!=null && supported_types_list.contains(compType) && subsystem!=null && (subsystem.equalsIgnoreCase("OutsideView") || subsystem.equalsIgnoreCase("InsideView")))
		{
			graphType="";
		}
		else if(supported_types_list!=null && supported_types_list.contains(compType) && subsystem!=null)
		{
			graphType="CPU";
		}
	}
	hiddenFields.put("graphType",graphType);

	if(subsystem!=null && subsystem.equalsIgnoreCase("Analysis") && graphType.equalsIgnoreCase("CPU"))
		analysis_Subject="CPUAnalysis";
	else if(subsystem!=null && subsystem.equalsIgnoreCase("Analysis") && graphType.equalsIgnoreCase("Memory"))
		analysis_Subject="MemoryAnalysis";
	else if(subsystem!=null && subsystem.equalsIgnoreCase("Analysis") && graphType.equalsIgnoreCase("Disk"))
		analysis_Subject="DiskAnalysis";
	else if(subsystem!=null && subsystem.equalsIgnoreCase("OutsideView"))
		analysis_Subject="OutsideViewAnalysis";
	else if(subsystem!=null && subsystem.equalsIgnoreCase("InsideView"))
		analysis_Subject="InsideViewAnalysis";
	
	SimpleDateFormat sf=new SimpleDateFormat("MM/dd/yyyy");
	SimpleDateFormat sf1=new SimpleDateFormat("dd/MM/yyyy");
	java.util.Date endDate=new java.util.Date();
	java.util.Date startDate=new java.util.Date(endDate.getTime()-(60*60*1000));
	EgExternalInfo egExternalInfo=new EgExternalInfo("manager");
	EgDbInfo dbInfo=new EgDbInfo("manager");
	ErUtils erUtils= new ErUtils();
	EgDashboardMGraphModel measureGraph=new EgDashboardMGraphModel();

	String hostName="";
	String portNo="";
	String startTime="";
	String endTime="";
	String startHour="";
	String endHour="";

	String test="";
	String measure="";
	String info="";
	String state="";
	String sid="";

	if(compName!=null && !compName.equals(""))
	{
		StringTokenizer st=new StringTokenizer(compName,":");
		if(st.hasMoreTokens())
			hostName=st.nextToken();

		if(st.hasMoreTokens())
			portNo=st.nextToken();

		if(st.hasMoreTokens())
			sid=st.nextToken();
	}
	
	String comp=compName+":"+compType;

	try
	{
		startTime=sf.format(startDate);
		endTime=sf.format(endDate);
	}
	catch(Exception ex)
	{
		System.out.println("Exception...."+ex);
	}

	String dashboard_exclude_server=iniObj.getValue("Dashboard_Excluded_servers",compType);
	if(dashboard_exclude_server!=null && dashboard_exclude_server.equalsIgnoreCase("No"))
	{
		subject=compType;
	}

	boolean isSubjectFound=false;
	List subjects=Arrays.asList(iniObj.getSubjects());
	
	if(subjects.contains(subject))
		isSubjectFound=true;
	
	Vector measures = new Vector();
	trans.createFile("eg_format.ini");
	trans_services_ini.createFile("eg_services.ini");
	String strVarArr[] = trans.getVariables("FORMAT");
	String dummyTestArr[] = trans.getVariables("COMMON_DD_MAPPING");
	Hashtable allInfoForAllTest=new Hashtable();
	Hashtable measureLastTimeForAllTest=new Hashtable();
	if(isSubjectFound || (subsystem!=null && subsystem.equalsIgnoreCase("InsideView")))
	{
		MonitorDAOFactory monitorDaoFactory = MonitorDAOFactory.getInstance();
		EgDashBoardDAO dashboardDAO=monitorDaoFactory.getDashBoardDAO();
		MeasuresDAO MeasuresDao = monitorDaoFactory.getMeasuresDAO();
		EgServerDashBoardDAO dashboardDA=monitorDaoFactory.getServerDashBoardDAO();//sarav 3

		String systemAnalysisValues="";
		systemAnalysisValues=iniObj.getValue(analysis_Subject,compType);

		Vector systemAnalysisTests=new Vector();
		Vector systemAnalysisMeasure=new Vector();
		Vector systemAnalysisDisplayName=new Vector();

		// ------getting values from DB.-------------------------------------------------------
		// get all infos for all test
		allInfoForAllTest=measureGraph.getAllInfoForAllTest(compType,compName);
		// get all measureLastTime for all test
		measureLastTimeForAllTest=measureGraph.getMeasureLastRunTimeForAllTest("'"+hostName+"'");
		//----end--------------------------------------------------------------------------------
		if(systemAnalysisValues!=null && !systemAnalysisValues.trim().equals(""))
		{
			StringTokenizer testDetails=new StringTokenizer(systemAnalysisValues,",");
			while(testDetails.hasMoreTokens())
			{
				String token=testDetails.nextToken();
				if(token!=null && token.indexOf(":")!=-1)
				{
					String test_only=token.substring(0,token.indexOf(":"));
					String measure_with_dname=token.substring(token.indexOf(":")+1);
					String measure_only=measure_with_dname;
					String dname_only="";
					if(measure_with_dname!=null && measure_with_dname.indexOf(":")!=-1)
					{
						measure_only=measure_with_dname.substring(0,measure_with_dname.indexOf(":"));
						dname_only=measure_with_dname.substring(measure_with_dname.indexOf(":")+1);
					}
					systemAnalysisTests.add(test_only);
					systemAnalysisMeasure.add(measure_only);
					systemAnalysisDisplayName.add(dname_only);
				}
			}
		}
		state=egDashboard.getServerState(hostName,compType,siteName);
		
		String gauge_Chart=iniObj.getValue(analysis_Subject,compType+"_GAUGE");
		String pie_Chart=iniObj.getValue(analysis_Subject,compType+"_PIE");
		String bar_Chart=iniObj.getValue(analysis_Subject,compType+"_BAR");
		String data_store=iniObj.getValue(analysis_Subject,compType+"_DATASTORE");
		String showTop=iniObj.getValue("Display_Analysis","show_top");
		String applyFusion=iniObj.getValue("Display_Analysis","applyFusion");
		applyFusion=(applyFusion==null)?"false":applyFusion;
		boolean isApplyFusion=applyFusion!=null && applyFusion.equalsIgnoreCase("true");

		String ua = request.getHeader( "User-Agent" );
		boolean isFirefox = ( ua != null && ua.indexOf( "Firefox/" ) != -1 );
		boolean isFirefox2 = ( ua != null && ua.indexOf( "Firefox/2" ) != -1 );
		boolean isFirefox3 = ( ua != null && ua.indexOf( "Firefox/3" ) != -1 );
		boolean isMSIE = ( ua != null && ua.indexOf( "MSIE" ) != -1 );
		boolean isChrome = ( ua != null && ua.indexOf( "Chrome/" ) != -1 );

		String trBlock="block";
		if(isFirefox)
			trBlock="table-row";

		boolean isBarChart=false;
		String barChartEnabled=request.getParameter("barChart");
		if(barChartEnabled!=null && barChartEnabled.equalsIgnoreCase("true"))
		{
			isBarChart=true;
		}

		boolean is_convert_MB_to_GB=false;
		String str_convert_MB_to_GB=iniObj.getValue("Display_Analysis","convert_MB_to_GB");
		if(str_convert_MB_to_GB!=null && str_convert_MB_to_GB.equalsIgnoreCase("yes"))
		{
			is_convert_MB_to_GB=true;
		}

		String isThresholdNeed=iniObjForServer.getValue("Dashboard_Settings","ApplyThreshold");

		String s_info=request.getParameter("graphType");

		String outsideview_layer=iniObj.getValue("OutsideView_Layer",compType);
		outsideview_layer=(outsideview_layer==null)?"":outsideview_layer;

		String insideview_layer=iniObj.getValue("InsideView_Layer",compType);
		insideview_layer=(insideview_layer==null)?"":insideview_layer;

		String isSortByMeasure=request.getParameter("sortbyMeasure");
		if(isSortByMeasure==null || isSortByMeasure.trim().length()==0)
		{
			Vector aList_info=new Vector();
			if(!isBarOrMeasureView)
			{
				JSONObject chartInfo = new JSONObject();
				chartInfo.put("ComponentState",componentState);
				hiddenFields.put("insideViewLayer",insideview_layer);
				
				
				screenLabels.put("SubsystemComboTitle",mappingInfo.getTextDescription("monitor.dashboard.Subsystem"));
				
				
				if(tab!=null && tab.equalsIgnoreCase("Virtual"))
				{
					String systemSubsystems=iniObj.getValue(VM_subject,"VM_subsystems");
					if(compType!=null && compType.equals("Solaris_virtual_server"))
					{
						systemSubsystems="InsideView";
					}

					StringTokenizer subsystemTokens=new StringTokenizer(systemSubsystems,":");
					String token_display="";
					JSONArray subsystemArray = new JSONArray();
					JSONObject upperCombo = new JSONObject();
					while(subsystemTokens.hasMoreTokens())
					{
						
						JSONObject subSystemCombo = new JSONObject();
						String token=subsystemTokens.nextToken();
						if(token!=null && token.equalsIgnoreCase("Analysis"))
							token_display="Physical Server Analysis";
						else if(token!=null && token.equalsIgnoreCase("OutsideView"))
							token_display="Outside View of VMs";
						else if(token!=null && token.equalsIgnoreCase("InsideView"))
							token_display="Inside View of VMs";

						if(subsystem!=null && token!=null && subsystem.equalsIgnoreCase(token))
						{
							subSystemCombo.put("value",token);
							subSystemCombo.put("valueText",mappingInfo.getTextDescription("monitor.dashboard."+token_display));
							upperCombo.put("selected",token);
							custom_select_subsystem= new String(token);
						}
						else
						{
							subSystemCombo.put("value",token);
							subSystemCombo.put("valueText",mappingInfo.getTextDescription("monitor.dashboard."+token_display));
							
	
						}
						subsystemArray.add(subSystemCombo);
					}
					json.put("subSystemComboValues",subsystemArray);
					json.put("selectedSubsystem",upperCombo);
				}


				String for_cpu="";
				String for_memory="";
				String for_disk="";
				VMDesktopBean desktopObj = null;
				Hashtable info_hash=new Hashtable();
				hiddenFields.put("subsystem",subsystem);
				hiddenFields.put("tab",tab);
				if(subsystem!=null && subsystem.equalsIgnoreCase("Analysis"))
				{
					if(graphType.equalsIgnoreCase("CPU"))
					{
						for_cpu="selected";
						json.put("viewComboSelected","CPU");
					}
					if(graphType.equalsIgnoreCase("Memory"))
					{
						for_memory="selected";
						json.put("viewComboSelected","Memory");
					}
					if(graphType.equalsIgnoreCase("Disk"))
					{
						for_disk="selected";
						json.put("viewComboSelected","Disk");
					}
					
				}
				else if(subsystem!=null && subsystem.equalsIgnoreCase("InsideView"))
				{
					Hashtable ht_infosearch=new Hashtable();
					aList_info=new Vector();
					VMDesktopBean vm=new VMDesktopBean(compType,compName,insideview_layer);
					
					if(vm!=null)
						ht_infosearch=vm.getInfoForTest();

					List info_All_list=new LinkedList();

					if(ht_infosearch!=null && ht_infosearch.size()>0)
					{
						Iterator itr=ht_infosearch.keySet().iterator();
						while(itr!=null && itr.hasNext())
						{
							String hash_info = (String)itr.next();
							if(hash_info!=null && !aList_info.contains(hash_info))
							{
								String state_value=(String)ht_infosearch.get(hash_info);

								info_All_list.add(hash_info);
							}
						}

						if(info_All_list!=null && info_All_list.size()>0)
						{
							EgSorter esort=new EgSorter(info_All_list,1);
							info_All_list=esort.sort(1,"String","asc");
							aList_info.addAll(info_All_list);
						}
					}
				}
				else if(subsystem!=null && subsystem.equalsIgnoreCase("OutsideView"))
				{
					aList_info=new Vector();
					desktopObj = new VMDesktopBean(compType,compName,outsideview_layer);
					if(desktopObj!=null)
						info_hash=desktopObj.getAllVmInfos();

					List info_All_list=new LinkedList();
					if(info_hash!=null && info_hash.size()>0)
					{
						Enumeration keys=info_hash.keys();
						while(keys.hasMoreElements())
						{
							String hash_info = (String)keys.nextElement();
							if(hash_info!=null && !aList_info.contains(hash_info))
							{
								String state_value=(String)info_hash.get(hash_info);
								info_All_list.add(hash_info);
							}
						}

						if(info_All_list!=null && info_All_list.size()>0)
						{
							EgSorter esort=new EgSorter(info_All_list,1);
							info_All_list=esort.sort(1,"String","asc");
							aList_info.addAll(info_All_list);
						}
					}
				}

				if(s_info==null || s_info.trim().length()==0)
				{
					if(aList_info!=null && aList_info.size()>0)
					{
						s_info=(String)aList_info.get(0);
					}
				}

				if(s_info!=null && s_info.trim().length()>0)
				{
					s_info=com.egurkha.util.StringUtils.replace(s_info,"|plus|","+");
					s_info=com.egurkha.util.StringUtils.replace(s_info,"|amp|","&");
					s_info=com.egurkha.util.StringUtils.replace(s_info,"|pct|","%");
				}

				if(subsystem!=null && subsystem.equalsIgnoreCase("Analysis"))
				{
					screenLabels.put("ViewComboTitle",mappingInfo.getTextDescription("monitor.dashboard.View"));

				}
				else if(subsystem!=null && (subsystem.equalsIgnoreCase("OutsideView") || subsystem.equalsIgnoreCase("InsideView")))
				{
					screenLabels.put("ViewComboTitle",mappingInfo.getTextDescription("monitor.dashboard.VM"));

				}
				JSONArray viewOptionsArray = new JSONArray();
				JSONObject viewOptions = new JSONObject();
				
				if(subsystem!=null && subsystem.equalsIgnoreCase("Analysis"))
				{
					
					viewOptions.put("value","CPU");
					viewOptions.put("valueText",mappingInfo.getTextDescription("monitor.dashboard.CPU"));
					viewOptionsArray.add(viewOptions);
					viewOptions.put("value","Memory");
					viewOptions.put("valueText",mappingInfo.getTextDescription("monitor.dashboard.Memory"));
					viewOptionsArray.add(viewOptions);
					viewOptions.put("value","Disk");
					viewOptions.put("valueText",mappingInfo.getTextDescription("monitor.dashboard.Disk"));
					viewOptionsArray.add(viewOptions);
					

				}
				else if(subsystem!=null && (subsystem.equalsIgnoreCase("OutsideView") || subsystem.equalsIgnoreCase("InsideView")))
				{
					if(aList_info!=null && aList_info.size()>0)
					{
						JSONObject comboOptionsInf = erUtils.createOptions(aList_info,aList_info,"",s_info);
						JSONArray comboOptions=(JSONArray) comboOptionsInf.get("options");
						viewOptionsArray.addAll(comboOptions);
						json.put("viewComboSelected",comboOptionsInf.get("selectedValue"));
						//out.println(erUtils.fillSelectBox(aList_info,aList_info,"",s_info));
					}
					else
					{
						viewOptions.put("value","-1");
						viewOptions.put("name",mappingInfo.getTextDescription("monitor.common.Not Applicable"));
						viewOptionsArray.add(viewOptions);
						json.put("viewComboSelected","-1");

					}
				}
				
				json.put("viewComboOptions",viewOptionsArray);

				String url="";
				boolean pie_chart_displayed=false;
				if(pie_Chart!=null && pie_Chart.trim().length()>0)
				{
					StringTokenizer pie_Details=new StringTokenizer(pie_Chart,",");
					String vars=iniObj.getValue("Dashboard_Graph_colors","PieGraph");
					int noOfGraph=pie_Details.countTokens();
					String[] chart_colors=new String[noOfGraph];
					StringTokenizer ctr=new StringTokenizer(vars,",");
					int cnt=0;
					do
					{
						ctr=new StringTokenizer(vars,",");
						while(ctr.hasMoreTokens())
						{
							if((chart_colors.length-1)<cnt)
								break;
							String tmpColor=(String)ctr.nextToken();
							chart_colors[cnt]=tmpColor;
							cnt++;
						}
					}
					while(chart_colors.length!=cnt);
					int j=0;
					StringBuffer legends=new StringBuffer();
					StringBuffer legends_for_no_data=new StringBuffer();
					StringBuffer legendsValues=new StringBuffer();
					StringBuffer samples=new StringBuffer();
					StringBuffer colors=new StringBuffer();
					Hashtable analysis_Pie_hash=new Hashtable();
					int h=0;
					while(pie_Details.hasMoreTokens())
					{
						String token=pie_Details.nextToken();
						String test_only="";
						String measure_only="";
						String display_name="";
						String unit="";
						if(token!=null && token.indexOf(":")!=-1)
						{
							test_only=token.substring(0,token.indexOf(":"));
							measure_only=token.substring(token.indexOf(":")+1);
							if(measure_only!=null && measure_only.indexOf(":")>-1)
							{
								display_name=measure_only.substring(measure_only.indexOf(":")+1);
								measure_only=measure_only.substring(0,measure_only.indexOf(":"));
							}
						}
						if(display_name==null || display_name.trim().length()==0)
							display_name=mappingInfo.getMeasureDescription(test_only,measure_only);
						unit=tablesInfo.getUnitForMeasure(test_only,measure_only);

						legends_for_no_data.append(display_name +" ("+unit+")");
						legends_for_no_data.append(",");
						String measureForDB=dbInfo.getColumnForMeasure(test_only,measure_only);
						String msmtHost="";

						boolean portReleventForTest = false;
						boolean siteReleventForTest = false;
						boolean infoReleventForTest = false;
						boolean isTestRelevantForServer = false;
						
						if(test_only!=null)
						{
							portReleventForTest = specsInfo.isPortRelevantForTest(test_only);
							isTestRelevantForServer = specsInfo.isTestRelevantForServer(compType,test_only);
						}

						if(!portReleventForTest)
						{
							portNo="NULL";
						}
						List agents=egExternalInfo.getAgentsFor(test_only,compType,hostName);
						if(agents!=null && agents.size()>0)
							msmtHost=(String)agents.get(0);
						else
							msmtHost=hostName;
						
						Vector allInfos=new Vector();
						if(allInfoForAllTest!=null && allInfoForAllTest.size()>0)
							allInfos=(Vector)allInfoForAllTest.get(test_only);
						String info_for_timeout="";
						StringBuffer temp_bef=new StringBuffer();
						if(allInfos!=null && allInfos.size()>0)
						{
							if(allInfos.size()==1)
							{
								String infoFormeasure=(String)allInfos.get(0);
								if(infoFormeasure!=null && infoFormeasure.trim().length()>0)
								{
									temp_bef.append(",");
									temp_bef.append(infoFormeasure);
									temp_bef.append("");
								}
							}
							else
							{
								for(int infoCount=0;infoCount<allInfos.size();infoCount++)
								{
									String infoFormeasure=(String)allInfos.get(infoCount);
									if(infoFormeasure!=null && infoFormeasure.trim().length()>0)
									{
										temp_bef.append(",'");
										temp_bef.append(infoFormeasure);
										temp_bef.append("'");
									}
								}
							}
						}
						info_for_timeout=temp_bef.toString();

						if(info_for_timeout!=null && info_for_timeout.startsWith(","))
						{
							info_for_timeout=info_for_timeout.substring(1);
						}

						if(sid!=null && !sid.equals(""))
						{
							info_for_timeout=com.egurkha.util.StringUtils.replace(info_for_timeout,"+","");
							info_for_timeout=sid+"*"+info_for_timeout;
						}
						else
							info_for_timeout=com.egurkha.util.StringUtils.replace(info_for_timeout,"+","|plus|");
						
						String lastRuntime=null;
						if(measureLastTimeForAllTest!=null && measureLastTimeForAllTest.size()>0)
							lastRuntime=(String)measureLastTimeForAllTest.get(test_only+"^"+hostName);
						boolean isTimeout=false;
						//Added by Chandrasekhar toget Cut of Factor value from eg_services.ini...
						String cut_off_factor_value = null;
						
						if(test_only!=null)
							cut_off_factor_value = trans_services_ini.getStrValue("CUT_OFF_FACTOR", test_only);
						if(cut_off_factor_value==null ||cut_off_factor_value.trim().length()==0)
						{
							cut_off_factor_value = trans_services_ini.getStrValue("CUT_OFF_FACTOR", "Default");
						}
						//ended here..
						//System.out.println("lastRuntime====================>"+lastRuntime);
						if(cut_off_factor_value!=null && !cut_off_factor_value.trim().equals("-1") && lastRuntime!=null && lastRuntime.trim().length()>0 && 
						cut_off_factor_value.trim().length()>0)
						{
							String compName_for_timeout=compName;
							if(!portReleventForTest)
							{
								if (compName!=null && compName.indexOf(":")>-1)
								{
									compName_for_timeout=compName.substring(0,compName.indexOf(":"));
								}
							}
							isTimeout=MeasuresDao.isTimeOut(lastRuntime,test_only+"#"+msmtHost,compName_for_timeout,compType);
						}

						Hashtable analysis_Pie_chart=new Hashtable();
						if(isTestRelevantForServer && !isTimeout)
						{
							analysis_Pie_chart=dashboardDAO.getCurrentAnalysisStatus (compName,compType,portNo,null,test_only,measureForDB,msmtHost,null,null,null,null,null,null,null,true);
						}

						String current_mes_value=null;
						
						if(analysis_Pie_chart!=null && analysis_Pie_chart.size()>0)
						{
							Enumeration keys=analysis_Pie_chart.keys();
							while(keys.hasMoreElements())
							{
								String db_info = (String)keys.nextElement();
								try
								{
									current_mes_value=(String)analysis_Pie_chart.get(db_info);

									if(current_mes_value!=null && Double.parseDouble(current_mes_value)>0.0)
									{
										if(analysis_Pie_hash.size()==0)
										{
											analysis_Pie_hash.put(token,new Double(current_mes_value));
										}
										else
										{
											if(analysis_Pie_hash.containsKey(token))
											{
												if(unit!=null && unit.equals("%"))
												{
													Double temp_value=(Double)analysis_Pie_hash.get(token);
													double temp_measure=temp_value.doubleValue();
													if(temp_measure>0.0 && Double.parseDouble(current_mes_value)>0.0)
													{
														temp_measure=temp_measure+Double.parseDouble(current_mes_value);
														temp_measure=temp_measure/2;
													}
													else if(temp_measure==0.0 && Double.parseDouble(current_mes_value)>0.0)
													{
														temp_measure=Double.parseDouble(current_mes_value);
													}
													else if(Double.parseDouble(current_mes_value)==0.0 && temp_measure>0.0)
													{
														temp_measure=temp_measure;
													}
													analysis_Pie_hash.put(token,new Double(temp_measure));
												}
												else
												{
													Double temp_value=(Double)analysis_Pie_hash.get(token);
													double temp_measure=temp_value.doubleValue();
													temp_measure=temp_measure+Double.parseDouble(current_mes_value);
													analysis_Pie_hash.put(token,new Double(temp_measure));
												}
											}
											else
											{
												analysis_Pie_hash.put(token,new Double(current_mes_value));
											}
										}
									}
								}
								catch(Exception ee)
								{
									current_mes_value="-";
								}
							}
						}
					}

					if(analysis_Pie_hash!=null && analysis_Pie_hash.size()>0)
					{
						Enumeration keys=analysis_Pie_hash.keys();
						while(keys.hasMoreElements())
						{
							String token = (String)keys.nextElement();
							try
							{
								String test_only="";
								String measure_only="";
								String display_name="";
								String unit="";
								if(token!=null && token.indexOf(":")!=-1)
								{
									test_only=token.substring(0,token.indexOf(":"));
									measure_only=token.substring(token.indexOf(":")+1);
									if(measure_only!=null && measure_only.indexOf(":")>-1)
									{
										display_name=measure_only.substring(measure_only.indexOf(":")+1);
										measure_only=measure_only.substring(0,measure_only.indexOf(":"));
									}
								}
								if(display_name==null || display_name.trim().length()==0)
									display_name=mappingInfo.getMeasureDescription(test_only,measure_only);
								unit=tablesInfo.getUnitForMeasure(test_only,measure_only);

								Double temp_value=(Double)analysis_Pie_hash.get(token);
								double temp_measure=temp_value.doubleValue();
								String current_mes_value=String.valueOf(temp_measure);
								if(current_mes_value!=null && !current_mes_value.equalsIgnoreCase("-"))
								{
									try
									{
										if(unit!=null && unit.equals("MB") && is_convert_MB_to_GB)
										{
											double fillColorValue=temp_measure;
											fillColorValue=fillColorValue/1024.0;
											current_mes_value=String.valueOf(fillColorValue);
											unit="GB";
										}
									}
									catch(Exception e)
									{
										current_mes_value=current_mes_value;
										unit="MB";
									}

									try
									{
										current_mes_value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(current_mes_value),2));
										temp_measure=Double.parseDouble(current_mes_value);
									}
									catch(Exception ee)
									{
										temp_measure=Double.parseDouble(current_mes_value);
									}
								}

								if(temp_measure>0.0)
								{
									legends.append(display_name +" ("+unit+")");
									legends.append(",");
									legendsValues.append(temp_measure +"("+unit+")");
									legendsValues.append(",");
									samples.append(temp_measure);
									samples.append(",");
									colors.append(chart_colors[j]);
									colors.append(",");
									j++;
								}
							}
							catch(Exception ee)
							{
								out.println("---ee--->"+ee);
							}
						}
					}
					//saravanan.s change in pie chart width
					double defaultPieGraphWidth=240; // default pie graph width for calculation
					double defaultPieGraphHeight=150;  // default pie graph height for calculation
					double defaultPieRadius=50;  // default pie graph radius for calculation

					double pieGraphWidth=240;
					double pieGraphHeight=150;

					String pieRadius="40"; //default radius for 240 width

					double pieGraphWidthTo1024PxInPercent=defaultPieGraphWidth/1024;
					pieGraphWidth=screenWidthInDouble*pieGraphWidthTo1024PxInPercent;
					pieGraphWidth=MathUtils.round(pieGraphWidth,0);

					double pieGraphHeightToDefaultWidthInPercent=defaultPieGraphHeight/defaultPieGraphWidth;

					pieGraphHeight=pieGraphWidth*pieGraphHeightToDefaultWidthInPercent;
					pieGraphHeight=MathUtils.round(pieGraphHeight,0);

					double pieRadiusToDefaultWidthInPercent=defaultPieRadius/defaultPieGraphWidth;
					double pieRadiusInDouble=pieGraphWidth*pieRadiusToDefaultWidthInPercent;
					pieRadius=erutils.round(pieRadiusInDouble,0);

					String CurrentStatusPieChartURL="";
					JSONObject piechartInfo = new JSONObject();
					if(samples!=null && samples.toString().length()>0)
					{
						if(isApplyFusion)
						{
							String legends_labels=legends.toString();
							if(legends_labels!=null && legends_labels.endsWith(","))
								legends_labels=legends_labels.substring(0,legends_labels.length()-1);
							String legends_value=legendsValues.toString();
							if(legends_value!=null && legends_value.endsWith(","))
								legends_value=legends_value.substring(0,legends_value.length()-1);
							CurrentStatusPieChartURL="../servlet/com.egurkha.monitor.DDTopview?chart=pie&width=260&height=100&pieGraphWidth="+pieGraphWidth+"&pieGraphHeight="+pieGraphHeight+"&pieRadius="+pieRadius+"&sampleValues="+samples.toString()+"&sampleColors="+EgURLEncoder.encode(colors.toString(),"UTF-8")+"&legendLabels="+legends_labels+"&isFromAnalysisPie=true&applyFusion=true&legendValues="+legends_value+"&fit=true";
						}
						else
						{
							CurrentStatusPieChartURL="../servlet/com.objectplanet.chart.ChartServlet?chart=pie&width=180&height=90&pieGraphWidth="+pieGraphWidth+"&pieGraphHeight="+pieGraphHeight+"&pieRadius="+pieRadius+"&sampleValues="+samples.toString()+"&sampleColors="+EgURLEncoder.encode(colors.toString(),"UTF-8")+"&selectionStyle=detached&multiColorOn=true&pieRotationOn=true&background=white&depth=0.15&angle=45&valueLabelsOn=true&valueLabelStyle=inside&3dModeOn=true&sampleDecimalCount=2&legendOn=true&legendLabels="+legends.toString()+"&legendPosition=top&gradientSamplesOn=true&seriesLabels="+legends.toString()+"&seriesLabelsOn=false&seriesLabelStyle=inside"+"&fit=true";
						}

						pie_chart_displayed=true;

						if(isApplyFusion)
						{
							piechartInfo.put("URL",CurrentStatusPieChartURL);
							piechartInfo.put("counter",h++);

						}
						else
						{
							piechartInfo.put("URL",CurrentStatusPieChartURL);
							piechartInfo.put("counter",h++);

						}
					}
					else
					{
						String legends_labels="&nbsp;";
						if(legends_for_no_data!=null)
							legends_labels=legends_for_no_data.toString();
						if(legends_labels!=null && legends_labels.endsWith(","))
							legends_labels=legends_labels.substring(0,legends_labels.length()-1);
						CurrentStatusPieChartURL="../monitor/eg_images/"+monitor_Skin+"/icon_exclamation.png";
						pie_chart_displayed=true;
						piechartInfo.put("legendLabel",legends_labels);
						piechartInfo.put("count",h++);
						piechartInfo.put("URL",CurrentStatusPieChartURL);
						piechartInfo.put("Message",mappingInfo.getTextDescription("monitor.VirtualDashboard.No measures available"));
					}
					json.put("pieChartInfo",piechartInfo);
				}
				if(gauge_Chart!=null && gauge_Chart.trim().length()>0)
				{
					StringTokenizer gauge_Details=new StringTokenizer(gauge_Chart,",");
					int noOfGraph=gauge_Details.countTokens();
					String imgWidth="";
					String imgHeight="";
					String chartWidth="";
					String chartHeight="";
					int h=0;
					int gaughChartCount=0;
					if(noOfGraph>=3)
					{
						imgWidth="200";
						imgHeight="110";
						chartWidth="200";
						chartHeight="110";
					}
					else if(noOfGraph==2)
					{
						imgWidth="200";
						imgHeight="110";
						chartWidth="200";
						chartHeight="110";
					}
					else if(noOfGraph==1)
					{
						imgWidth="200";
						imgHeight="110";
						chartWidth="200";
						chartHeight="110";
					}
					
					if(!pie_chart_displayed)
					{

					}
					
					JSONArray gaugeChartArray = new JSONArray();
					while(gauge_Details.hasMoreTokens())
					{
						JSONObject gaugeChartInfo = new JSONObject();
						String token=gauge_Details.nextToken();
						if(token!=null && token.indexOf(":")!=-1)
						{
							test=token.substring(0,token.indexOf(":"));
							String measure_with_dname=token.substring(token.indexOf(":")+1);
							measure=measure_with_dname;
							String dname_only="";
							if(measure_with_dname!=null && measure_with_dname.indexOf(":")!=-1)
							{
								measure=measure_with_dname.substring(0,measure_with_dname.indexOf(":"));
								dname_only=measure_with_dname.substring(measure_with_dname.indexOf(":")+1);
							}
							// saravanan.s --start-- to give support to view Dial charts for all Descriptors
							isMoreInfosView=false;
							Hashtable allTestInfos=dashboardDA.getDescriptorsForAllTest(compName,compType,tab);
							if(allTestInfos!=null && allTestInfos.size()>0)
							{
								Vector infos=(Vector)allTestInfos.get(test);
								if(infos!=null && !infos.isEmpty() && infos.size()>1)
								{
									isMoreInfosView=true;
								}
							}
							//saravanan.s --end--
							Vector allInfos=new Vector();
							if(allInfoForAllTest!=null && allInfoForAllTest.size()>0)
								allInfos=(Vector)allInfoForAllTest.get(test);

							String host_name_only="";
							String port_only="";
							String sid_only="";
							if(compName!=null && compName.trim().length()>0)
							{
								StringTokenizer st=new StringTokenizer(compName,":");
								if(st.hasMoreTokens())
									host_name_only=st.nextToken();
								if(st.hasMoreTokens())
									port_only=st.nextToken();
								if(st.hasMoreTokens())
									sid_only=st.nextToken();
							}

							String msmtHost="";
							String info_for_timeout="";
							StringBuffer temp_bef=new StringBuffer();
							if(allInfos!=null && allInfos.size()>0)
							{
								if(allInfos.size()==1)
								{
									String infoFormeasure=(String)allInfos.get(0);
									if(infoFormeasure!=null && infoFormeasure.trim().length()>0)
									{
										temp_bef.append(",");
										temp_bef.append(infoFormeasure);
										temp_bef.append("");
									}
								}
								else
								{
									for(int infoCount=0;infoCount<allInfos.size();infoCount++)
									{
										String infoFormeasure=(String)allInfos.get(infoCount);
										if(infoFormeasure!=null && infoFormeasure.trim().length()>0)
										{
											temp_bef.append(",'");
											temp_bef.append(infoFormeasure);
											temp_bef.append("'");
										}
									}
								}
							}
							info_for_timeout=temp_bef.toString();

							if(info_for_timeout!=null && info_for_timeout.startsWith(","))
							{
								info_for_timeout=info_for_timeout.substring(1);
							}
							boolean portReleventForTest = false;
							boolean siteReleventForTest = false;
							boolean infoReleventForTest = false;
							boolean isTestRelevantForServer = false;

							if(test!=null)
							{
								portReleventForTest = specsInfo.isPortRelevantForTest(test);
								siteReleventForTest = specsInfo.isSiteRelevantForTest(test);
								infoReleventForTest = specsInfo.isInfoRelevantForTest(test,compType);
								isTestRelevantForServer = specsInfo.isTestRelevantForServer(compType,test);
							}

							if(!portReleventForTest)
							{
								portNo="NULL";
							}
							String Layer_name_str=tablesInfo.getLayerForTest(test);
							StringTokenizer tokenLayer=new StringTokenizer(Layer_name_str,",");
							String layerName="HOST";
							if(tokenLayer!=null)
							{
								while(tokenLayer.hasMoreTokens())
								{
									String l_name=(String)tokenLayer.nextToken();
									if(l_name!=null)
									{
										if(tablesInfo.isMeasureInLayer(test,measure,l_name))
										{
											layerName=l_name;
											break;
										}
									}
								}
							}
							
							List agents=egExternalInfo.getAgentsFor(test,compType,hostName);
							if(agents!=null && agents.size()>0)
								msmtHost=(String)agents.get(0);
							else
								msmtHost=hostName;

							String info_temp=fusionChartUtil.getInfoForVirtualDashboardDial(test,measure,compType,host_name_only,port_only,msmtHost,"NULL",sid_only,isThresholdNeed);

							if(info_temp!=null && info_temp.trim().length()>0)
							{
								allInfos=new Vector();
								allInfos.add(info_temp);
							}
							
							String info_to_url="";
							String info_to_layermodel="";
							String gauge_graph_split_infos=iniObj.getValue("Display_Analysis","gauge_graph_split_infos");
							boolean gg_split_infos_flage=false;
							if(gauge_graph_split_infos!=null && gauge_graph_split_infos.equalsIgnoreCase("yes"))
							{
								gg_split_infos_flage=true;
							}

							if(gg_split_infos_flage)
							{
								//split infos
							}
							else
							{
								if(allInfos!=null && allInfos.size()>0)
								{
									for(int infoCount=0;infoCount<allInfos.size();infoCount++)
									{
										String infoFormeasure=(String)allInfos.get(infoCount);
										if(infoFormeasure!=null && (infoFormeasure.equalsIgnoreCase("+Summary") || infoFormeasure.equalsIgnoreCase("+Total") || infoFormeasure.toLowerCase().endsWith(":summary") || infoFormeasure.toLowerCase().endsWith(":total")))
										{
											allInfos=new Vector();
											info_to_url=infoFormeasure;
											if(info_to_url!=null && info_to_url.startsWith("+"))
												info_to_url=info_to_url.substring(1);
											break;
										}
										else if(infoFormeasure!=null && infoFormeasure.trim().length()>0)
										{
											info_to_layermodel=infoFormeasure;
											if(info_to_layermodel!=null && info_to_layermodel.startsWith("+"))
												info_to_layermodel=info_to_layermodel.substring(1);
											break;
										}
									}

									if(info_to_url!=null && info_to_url.trim().length()==0 && allInfos.size()==1)
									{
										info_to_url=(String)allInfos.get(0);
										allInfos=new Vector();
										if(info_to_url!=null && info_to_url.startsWith("+"))
											info_to_url=info_to_url.substring(1);
									}
								}
							}
							
							if(subsystem!=null && subsystem.equalsIgnoreCase("OutsideView"))
							{
								info_for_timeout="+"+s_info;
							}
							
							if(sid!=null && !sid.equals(""))
							{
								info_for_timeout=com.egurkha.util.StringUtils.replace(info_for_timeout,"+","");
								info_for_timeout=sid+"*"+info_for_timeout;
							}
							else
								info_for_timeout=com.egurkha.util.StringUtils.replace(info_for_timeout,"+","|plus|");
							
							String lastRuntime=null;
							if(measureLastTimeForAllTest!=null && measureLastTimeForAllTest.size()>0)
								lastRuntime=(String)measureLastTimeForAllTest.get(test+"^"+hostName);
							boolean isTimeout=false;
							//Added by Chandrasekhar toget Cut of Factor value from eg_services.ini...
							String cut_off_factor_value = null;

							if(test!=null)
								cut_off_factor_value = trans_services_ini.getStrValue("CUT_OFF_FACTOR", test);
							if(cut_off_factor_value==null || cut_off_factor_value.trim().length()==0)
							{
								cut_off_factor_value = trans_services_ini.getStrValue("CUT_OFF_FACTOR", "Default");
							}
							//ended here..
							System.out.println("lastRuntime====================>"+lastRuntime);
							if(cut_off_factor_value!=null && !cut_off_factor_value.trim().equals("-1") && lastRuntime!=null && lastRuntime.trim().length()>0 && 
							cut_off_factor_value.trim().length()>0)
							{
								String compName_for_timeout=compName;
								if(!portReleventForTest)
								{
									if (compName!=null && compName.indexOf(":")>-1)
									{
										compName_for_timeout=compName.substring(0,compName.indexOf(":"));
									}
								}
								isTimeout=MeasuresDao.isTimeOut(lastRuntime,test+"#"+msmtHost,compName_for_timeout,compType);
							}

							if(isTestRelevantForServer && !isTimeout)
							{
								isTimeout=false;
							}
							else isTimeout=true;

							if(subsystem!=null && subsystem.equalsIgnoreCase("OutsideView"))
							{
								info_to_url=s_info;
							}
							String measureForDB=dbInfo.getColumnForMeasure(test,measure);

							if(info_to_url!=null && info_to_url.trim().length()>0)
							{
								info_to_url=com.egurkha.util.StringUtils.replace(info_to_url,"+","|plus|");
								info_to_url=com.egurkha.util.StringUtils.replace(info_to_url,"&","|amp|");
								info_to_url=com.egurkha.util.StringUtils.replace(info_to_url,"%","|pct|");
								info_to_url = com.egurkha.util.StringUtils.replace(info_to_url, "\\", "\\\\");

								info_to_layermodel=com.egurkha.util.StringUtils.replace(info_to_layermodel,"+","|plus|");
								info_to_layermodel=com.egurkha.util.StringUtils.replace(info_to_layermodel,"&","|amp|");
								info_to_layermodel=com.egurkha.util.StringUtils.replace(info_to_layermodel,"%","|pct|");
								// this is handled in the layermodel page.so commented the below line
								//info_to_layermodel = com.egurkha.util.StringUtils.replace(info_to_layermodel, "\\", "\\\\");
								//---end---
							}
							url="../servlet/com.egurkha.monitor.DDTopview?host="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&test="+test+"&measure="+measureForDB+"&real_measure="+measure+"&module=System&width="+chartWidth+"&height="+chartHeight+"&monitorSkin="+monitor_Skin+"&mode=3D&graphdisplay=defaultView&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&port="+portNo+"&isFromAnalysis=true&layer="+layerName+"&isAnalysisGauge=true&info="+EgURLEncoder.encode(info_to_url,"UTF-8")+"&imgwidth="+imgWidth+"&imgheight="+imgHeight+"&isTimeout="+isTimeout+"&displayName="+EgURLEncoder.encode(dname_only,"UTF-8")+"&applyFusion="+isApplyFusion+"&gaughChartCount="+gaughChartCount+"&isThresholdNeed="+isThresholdNeed+"&tab="+tab+"&isMoreInfosView="+isMoreInfosView+"&screenWidth="+ screenWidth+"&screenHeight="+screenHeight+"&DialChartNeed="+DialChartNeed+"&showTitle=true";

							String info_to_param=info_to_url;
							if(info_to_url==null || info_to_url.trim().length()==0)
								info_to_param="+";
							if(subsystem!=null && subsystem.equalsIgnoreCase("OutsideView"))
							{
								url=url+"&isInfoSelected=true";
							}

							String state_of_comp="GOOD";

							if(info_to_url!=null && info_to_url.trim().length()>0 && info_to_layermodel!=null && info_to_layermodel.trim().length()==0)
								info_to_layermodel=info_to_url;

							//String layerPageUrl=response.encodeURL("/final/monitor/egDashBoardLayers.jsp?")+"qctr=2&fromPage=componentList&host="+EgURLEncoder.encode(compName,"UTF-8")+"&comptype="+compType+"&layer="+layerName+"&site=NULL&test="+test+"-"+EgURLEncoder.encode(info_to_layermodel,"UTF-8")+"&tstate="+state_of_comp+"&msmt_host="+(isFirefox?msmtHost:EgURLEncoder.encode(msmtHost,"UTF-8"));

							//String layerPageUrl=response.encodeURL("/final/monitor/egMonDashboard.jsp?")+"qctr=2&fromPage=componentList&host="+compName+"&comptype="+compType+"&layer="+layerName+"&site=NULL&test="+EgURLEncoder.encode(test+"-"+info_to_layermodel,"UTF-8")+"&tstate="+state_of_comp+"&msmt_host="+(isFirefox?msmtHost:EgURLEncoder.encode(msmtHost,"UTF-8"))+"&tab=layermodel&toDashBoardLayer=true";
							String layerPageUrl="";
							
							if(tab!=null && tab.equalsIgnoreCase("Virtual")){
								layerPageUrl=response.encodeURL("/final/monitor/egMonDashboard.jsp?")+"qctr=2&from=list&host="+EgURLEncoder.encode(compName,"UTF-8")+"&comptype="+compType+"&layer="+layerName+"&site=NULL&test="+EgURLEncoder.encode(test+"-"+info_to_layermodel,"UTF-8")+"&tstate="+state_of_comp+"&gauageClick=true&msmt_host="+(isFirefox?msmtHost:EgURLEncoder.encode(msmtHost,"UTF-8"))+"&tab=LayerModel&toDashBoardLayer=true&showDashBoardLink=true";
							}else{
								layerPageUrl=response.encodeURL("/final/monitor/egMonDashboard.jsp?")+"qctr=2&fromPage=componentList&host="+EgURLEncoder.encode(compName,"UTF-8")+"&comptype="+compType+"&layer="+layerName+"&site=NULL&test="+EgURLEncoder.encode(test+"-"+info_to_layermodel,"UTF-8")+"&tstate="+state_of_comp+"&msmt_host="+(isFirefox?msmtHost:EgURLEncoder.encode(msmtHost,"UTF-8"))+"&tab=LayerModel&toDashBoardLayer=true&showDashBoardLink=true";
							}
							
							int hCount=h++;
							if(isApplyFusion)
							{
								String imgHeightIframe=String.valueOf(Integer.parseInt(imgHeight)+10);
								gaugeChartInfo.put("URL",url);
								gaugeChartInfo.put("height",imgHeightIframe);
								gaugeChartInfo.put("ifmId","gaughUrl"+String.valueOf(hCount));
								
								gaugeChartInfo.put("count",hCount);
								gaugeChartInfo.put("layerUrl",layerPageUrl);
							}
							else
							{
								gaugeChartInfo.put("URL",url);
								gaugeChartInfo.put("count",hCount);
							}
							gaugeChartInfo.put("gaugeChartCountHidden",gaughChartCount);
							gaugeChartInfo.put("URLhidden",layerPageUrl);

							gaughChartCount++;
						}//if
						gaugeChartArray.add(gaugeChartInfo);
					}//while
						json.put("upperGaugeChartData",gaugeChartArray);
				}
				else
				{
					if(pie_chart_displayed)
					{

					}

					if(subsystem!=null && (subsystem.equalsIgnoreCase("OutsideView") || subsystem.equalsIgnoreCase("InsideView")))
					{
						desktopObj = new VMDesktopBean(request);
						Vector vmDetails=null;
						if(desktopObj!=null && s_info!=null && s_info.trim().length()>0 && !s_info.equals("-1"))
							vmDetails=(Vector)desktopObj.getVmDetails(compType+":"+compName);
						if(vmDetails!=null && vmDetails.size()>0 && s_info!=null && s_info.trim().length()>0 && !s_info.equals("-1"))
						{
							JSONObject upperGridInfo = new JSONObject();
							upperGridInfo.put("title",mappingInfo.getTextDescription("monitor.dashboard.VM Details"));

							String div_height="70px";
							//if(isFirefox)
								//div_height="85px";
							boolean inside_row=false;
							String s_info_split=s_info;
							if(s_info_split!=null && s_info_split.trim().length()>0 && s_info_split.indexOf("_on_")>-1)
							{
								s_info_split=s_info_split.substring(s_info_split.indexOf("_on_")+4);
							}
							JSONArray insideVmdetailsArray = new JSONArray();
							JSONArray outsideVmdetailsArray = new JSONArray();
							for(int i=0;i<vmDetails.size();i++)
							{
								JSONObject insideVmdetails = new JSONObject();
								Vector row=(Vector)vmDetails.get(i);
								if(row!=null && row.size()>0 && row.size()>=3)
								{
									String vm=(String)row.get(0);
									if(vm!=null && vm.equalsIgnoreCase(s_info_split))
									{
										String ip=(String)row.get(1);
										String os=(String)row.get(2);
										insideVmdetails.put("measure",mappingInfo.getTextDescription("monitor.dashboard.IP Address"));
										insideVmdetails.put("value",ip);
										insideVmdetailsArray.add(insideVmdetails);
										outsideVmdetailsArray.add(insideVmdetails);
										insideVmdetails.put("measure",mappingInfo.getTextDescription("monitor.dashboard.OS"));
										insideVmdetails.put("value",os);
										insideVmdetailsArray.add(insideVmdetails);
										outsideVmdetailsArray.add(insideVmdetails);
										div_height="70px";
										inside_row=true;
										//upperGridInfo.put(i+"value",insideVmdetailsArray);
										//json.put("test for inside",upperGridInfo);
										break;
									}
								}
								//upperGridInfo.put("upperGrid",insideVmdetails);
								//insideVmdetailsArray.add(insideVmdetails);
							}
							upperGridInfo.put("upperGridInfo",insideVmdetailsArray);
							//json.put("insideViewUpperGrid",upperGridInfo);
							
							if(!inside_row)
							{
								JSONObject insideVmdetails = new JSONObject();
								insideVmdetails.put("measure",mappingInfo.getTextDescription("monitor.dashboard.IP Address"));
								insideVmdetails.put("value",mappingInfo.getTextDescription("monitor.dashboard.N/A"));
								outsideVmdetailsArray.add(insideVmdetails);
								insideVmdetails.put("measure",mappingInfo.getTextDescription("monitor.dashboard.OS"));
								insideVmdetails.put("value",mappingInfo.getTextDescription("monitor.dashboard.N/A"));
								outsideVmdetailsArray.add(insideVmdetails);
/* 								upperGridInfo.put("upperOutsideGrid",outsideVmdetailsArray);
								json.put("upperOutsideGrid",upperGridInfo); */

							}

							if(subsystem.equalsIgnoreCase("OutsideView")&& (compType.equals("VmEsx_i_server") || compType.equals("VmVdi_i_server")))
							{
								JSONObject outsidedetails =new JSONObject();
								
								outsidedetails.put("measure",mappingInfo.getTextDescription("monitor.dashboard.Datastores")+"&"+mappingInfo.getTextDescription("monitor.dashboard.Availability"));

								if(data_store!=null && data_store.trim().length()>0)
								{
									StringTokenizer test_with_measure=new StringTokenizer(data_store,",");
									int total_count=test_with_measure.countTokens();
									JSONArray outer_dataStoreArray = new JSONArray();
									while(test_with_measure.hasMoreTokens())
									{
										JSONObject outer_datastoreObj = new JSONObject();
										String token=test_with_measure.nextToken();
										String test_only="";
										String measure_only="";
										String display_name="";
										if(token!=null && token.indexOf(":")!=-1)
										{
											test_only=token.substring(0,token.indexOf(":"));
											measure_only=token.substring(token.indexOf(":")+1);
											if(measure_only!=null && measure_only.indexOf(":")>-1)
											{
												display_name=measure_only.substring(measure_only.indexOf(":")+1);
												measure_only=measure_only.substring(0,measure_only.indexOf(":"));
											}
											else
											{
												display_name=mappingInfo.getMeasureDescription(test_only,measure_only);
											}
										}
				
										String measureForDB=dbInfo.getColumnForMeasure(test_only,measure_only);
										String unit=tablesInfo.getUnitForMeasure(test_only,measure_only);
										String msmtHost="";

										boolean portReleventForTest = false;
										boolean siteReleventForTest = false;
										boolean infoReleventForTest = false;
										boolean isTestRelevantForServer = false;
										
										if(test_only!=null)
										{
											portReleventForTest = specsInfo.isPortRelevantForTest(test_only);
											isTestRelevantForServer = specsInfo.isTestRelevantForServer(compType,test_only);
										}

										if(!portReleventForTest)
										{
											portNo="NULL";
										}
										List agents=egExternalInfo.getAgentsFor(test_only,compType,hostName);
										if(agents!=null && agents.size()>0)
											msmtHost=(String)agents.get(0);
										else
											msmtHost=hostName;
										
										Vector allInfos=new Vector();
										if(allInfoForAllTest!=null && allInfoForAllTest.size()>0)
											allInfos=(Vector)allInfoForAllTest.get(test_only);
										String info_for_timeout="";
										StringBuffer temp_bef=new StringBuffer();
										if(allInfos!=null && allInfos.size()>0)
										{
											if(allInfos.size()==1)
											{
												String infoFormeasure=(String)allInfos.get(0);
												if(infoFormeasure!=null && infoFormeasure.trim().length()>0 && infoFormeasure.toLowerCase().startsWith("+"+s_info.toLowerCase()))
												{
													temp_bef.append(",");
													temp_bef.append(infoFormeasure);
													temp_bef.append("");
												}
											}
											else
											{
												for(int infoCount=0;infoCount<allInfos.size();infoCount++)
												{
													String infoFormeasure=(String)allInfos.get(infoCount);
													if(infoFormeasure!=null && infoFormeasure.trim().length()>0 && infoFormeasure.toLowerCase().startsWith("+"+s_info.toLowerCase()))
													{
														temp_bef.append(",");
														temp_bef.append(infoFormeasure);
														temp_bef.append("");
														break;
													}
												}
											}
										}

										info_for_timeout=temp_bef.toString();
									
										if(info_for_timeout!=null && info_for_timeout.startsWith(","))
										{
											info_for_timeout=info_for_timeout.substring(1);
										}

										if(sid!=null && !sid.equals(""))
										{
											info_for_timeout=com.egurkha.util.StringUtils.replace(info_for_timeout,"+","");
											info_for_timeout=sid+"*"+info_for_timeout;
										}
										else
											info_for_timeout=com.egurkha.util.StringUtils.replace(info_for_timeout,"+","|plus|");

										String lastRuntime=null;
										if(measureLastTimeForAllTest!=null && measureLastTimeForAllTest.size()>0)
											lastRuntime=(String)measureLastTimeForAllTest.get(test_only+"^"+hostName);
										boolean isTimeout=false;
										//Added by Chandrasekhar toget Cut of Factor value from eg_services.ini...
										String cut_off_factor_value = null;
										if(test_only!=null)
											cut_off_factor_value = trans_services_ini.getStrValue("CUT_OFF_FACTOR", test_only);
										if(cut_off_factor_value==null || cut_off_factor_value.trim().length()==0)
										{
											cut_off_factor_value = trans_services_ini.getStrValue("CUT_OFF_FACTOR", "Default");
										}
										//ended here..
										System.out.println("lastRuntime====================>"+lastRuntime);
										if(cut_off_factor_value!=null && !cut_off_factor_value.trim().equals("-1") && lastRuntime!=null && lastRuntime.trim().length()>0 && cut_off_factor_value.trim().length()>0)
										{
											String compName_for_timeout=compName;
											if(!portReleventForTest)
											{
												if (compName!=null && compName.indexOf(":")>-1)
												{
													compName_for_timeout=compName.substring(0,compName.indexOf(":"));
												}
											}
											isTimeout=MeasuresDao.isTimeOut(lastRuntime,test_only+"#"+msmtHost,compName_for_timeout,compType);
										}
										Hashtable analysis_Single_Data=new Hashtable();
										ArrayList all_info_list=new ArrayList();
										if(isTestRelevantForServer && !isTimeout)
										{
											analysis_Single_Data=dashboardDAO.getCurrentAnalysisStatus (compName,compType,portNo,null,test_only,measureForDB,msmtHost,null,null,null,null,null,null,null,true,s_info);

											if(analysis_Single_Data!=null && analysis_Single_Data.size()>0)
											{
												Hashtable result_hash=new Hashtable();
												Enumeration keys=analysis_Single_Data.keys();
												while(keys.hasMoreElements())
												{
													String db_info = (String)keys.nextElement();
													String sInfo = "";
													if(s_info!=null)
													{
														if(measureForDB!=null && measureForDB.equalsIgnoreCase("AVAILABILITY"))
														{
															if(s_info.indexOf("_on_")>-1)
																sInfo = s_info.substring(s_info.indexOf("_on_") + 4);
															else
																sInfo = s_info;
														}
														else
															sInfo = s_info;
													}
													if(db_info!=null && db_info.indexOf(":")>-1)
													{
														String info_substring=db_info.substring(0,db_info.indexOf(":"));
														
														if(info_substring!=null && sInfo!=null && sInfo.equalsIgnoreCase(info_substring))
														{
															String current_mes_value=(String)analysis_Single_Data.get(db_info);
															result_hash.put(db_info,current_mes_value);
														}
													}
													else
													{
														if(db_info!=null && sInfo!=null && sInfo.equalsIgnoreCase(db_info))
														{
															String current_mes_value=(String)analysis_Single_Data.get(db_info);
															result_hash.put(db_info,current_mes_value);
														}
													}
												}

												if(result_hash!=null && result_hash.size()>0)
												{
													analysis_Single_Data=new Hashtable();
													analysis_Single_Data.putAll(result_hash);
												}
												else
												{
													analysis_Single_Data=new Hashtable();
												}
											}
										}
										JSONArray dataStoreArray = new JSONArray();
										if(analysis_Single_Data!=null && analysis_Single_Data.size()>0)
										{

											Enumeration keys=analysis_Single_Data.keys();
											int dataStoreCount_i =0;
											while(keys.hasMoreElements())
											{
												JSONObject datastoreObj = new JSONObject();
												String db_info = (String)keys.nextElement();
												String display_info=db_info;
												if(db_info!=null && db_info.indexOf(":")>-1)
													display_info=db_info.substring(db_info.indexOf(":")+1);
												String meas_value="";
												try
												{
													meas_value=(String)analysis_Single_Data.get(db_info);
												}
												catch(Exception ee)
												{
													meas_value="-";
												}
												
												String real_db_info="";
												if(meas_value!=null && meas_value.indexOf("^")>-1)
												{
													real_db_info=meas_value.substring(0,meas_value.lastIndexOf("^"));
													meas_value=meas_value.substring(meas_value.lastIndexOf("^")+1);
												}
												
												if(meas_value!=null && !meas_value.equalsIgnoreCase("Not Available")&&  !meas_value.equalsIgnoreCase("Unknown") && !meas_value.equalsIgnoreCase("UnLimited") && !meas_value.equalsIgnoreCase("Not Applicable") && !meas_value.equalsIgnoreCase("-"))
												{
													int round=4;
													if (meas_value.indexOf(".")==6)
														round=3;
													else if (meas_value.indexOf(".")==7)
														round=2;
													else if (meas_value.indexOf(".")==8)
														round=1;
													else if (meas_value.indexOf(".")>8 || meas_value.indexOf(".")==-1)
														round=0;
													meas_value=erUtils.round(Float.parseFloat(meas_value),round);
												}
												if(meas_value!=null && (meas_value.equalsIgnoreCase("Not Available") || meas_value.equalsIgnoreCase("Not Applicable")))
												{
													meas_value="-";
												}
												if(meas_value==null || meas_value.trim().length()<=0 || meas_value.trim().equalsIgnoreCase("null"))
													meas_value="-";

												datastoreObj.put(dataStoreCount_i+"diplayInfo",display_info);
												int width_for_td=35;
												if(unit!=null && unit.equals("%"))
												{
													if(meas_value!=null && meas_value.trim().length()>0 && !meas_value.equals("-"))
													{
														int columnWidth = 100;
														Long temp_measure_value=new Long(Math.round(Double.parseDouble(meas_value)));
														long fillColorValue=temp_measure_value.longValue();
														long value1 = (fillColorValue*100)/columnWidth;
														width_for_td=15;
														datastoreObj.put(dataStoreCount_i+"someValue",value1);

													}
													datastoreObj.put(dataStoreCount_i+"widthForTd",width_for_td);

													if(!meas_value.equalsIgnoreCase("-"))
													{
														datastoreObj.put(dataStoreCount_i+"measValue",dbInfo.formatValue(meas_value) +" ("+unit+")");									
														//out.println(dbInfo.formatValue(meas_value) +" ("+unit+")");
													}
													else
													{
														datastoreObj.put(dataStoreCount_i+"measValue",meas_value);		
														//out.println(meas_value);
													}

												}
												else
												{
													if(meas_value!=null && !meas_value.equalsIgnoreCase("-"))
													{
														try
														{
															if(unit!=null && unit.equals("MB") && is_convert_MB_to_GB)
															{
																double fillColorValue=Double.parseDouble(meas_value);
																fillColorValue=fillColorValue/1024.0;
																meas_value=String.valueOf(fillColorValue);
															}
														}
														catch(Exception e)
														{
															meas_value=meas_value;
														}

														try
														{
															meas_value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(meas_value),2));
														}
														catch(Exception ee)
														{
															meas_value=meas_value;
														}
													}
													datastoreObj.put(dataStoreCount_i+"widthForTd",width_for_td);
													//datastoreObj.put(dataStoreCount_i+"measValue",meas_value);
												}
												//dataStoreArray.add(datastoreObj);
												//outsidedetails.put(dataStoreCount_i+"value",datastoreObj);
												outsidedetails.put("value",meas_value);
												dataStoreCount_i++;
											}//inner while
											//outer_datastoreObj.put("UnitDetails",dataStoreArray);
										}
										else
										{
											outsidedetails.put("value",mappingInfo.getTextDescription("monitor.dashboard.N/A"));

										}
										//outer_dataStoreArray.add(outer_datastoreObj);
									}//while outer
									//outsidedetails.put("dataStoreValues",outer_dataStoreArray);
								}
								else
								{
									outsidedetails.put("divHeight",div_height);
									outsidedetails.put("datastoreValue",mappingInfo.getTextDescription("monitor.dashboard.N/A"));

								}
								outsideVmdetailsArray.add(outsidedetails);
								upperGridInfo.put("upperGridInfo",outsideVmdetailsArray);
								
								//json.put("outsideViewDetails",outsidedetails);
							}// if("outside")
							json.put("upperGrid",upperGridInfo);
						}		//if (-1) 
						else
						{
							JSONObject upperGridInfo = new JSONObject();
							
							JSONArray upperGridArray = new JSONArray();
							JSONObject outsidedetails = new JSONObject();
							String div_height="70px";
							
							upperGridInfo.put("title",mappingInfo.getTextDescription("monitor.dashboard.VM Details"));
							outsidedetails.put("measure",mappingInfo.getTextDescription("monitor.dashboard.IP Address"));
							outsidedetails.put("value",mappingInfo.getTextDescription("monitor.dashboard.N/A"));
							upperGridArray.add(outsidedetails);
							outsidedetails.put("measure",mappingInfo.getTextDescription("monitor.dashboard.OS"));
							outsidedetails.put("value",mappingInfo.getTextDescription("monitor.dashboard.N/A"));
							upperGridArray.add(outsidedetails);
							/* outsidedetails.put("text",mappingInfo.getTextDescription("monitor.dashboard.Datastores")+"&"+mappingInfo.getTextDescription("monitor.dashboard.Availability"));
							outsidedetails.put("value",mappingInfo.getTextDescription("monitor.dashboard.N/A")); 
							upperGridArray.add(outsidedetails);*/
							//if(isFirefox)
								//div_height="85px";

							if(subsystem.equalsIgnoreCase("OutsideView")&& (compType.equals("VmEsx_i_server") || compType.equals("VmVdi_i_server")))
							{
								outsidedetails.put("measure",mappingInfo.getTextDescription("monitor.dashboard.Datastores")+"&"+mappingInfo.getTextDescription("monitor.dashboard.Availability"));
								outsidedetails.put("value",mappingInfo.getTextDescription("monitor.dashboard.N/A"));
								upperGridArray.add(outsidedetails);
							}
							upperGridInfo.put("upperGridInfo",upperGridArray);
							json.put("upperGrid",upperGridInfo);
						}
					}	//if upper
					else
					{
						url="egSummaryView.jsp?hostName="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&subsystem="+subsystem;
						
	%>
						<jsp:include page="<%=url%>"/>
	
	<%
						if(request.getAttribute("ExtraGraphs")!="undefined" && request.getAttribute("ExtraGraphs")!="null" && request.getAttribute("ExtraGraphs")!=""){
							json.put("OtherData",request.getAttribute("ExtraGraphs"));
						 request.removeAttribute("ExtraGraphs");
						}
//						<jsp:include page="<%=url % >"/>

					}
				}//top most 
				
				
				/* JSONObject imagePath = new JSONObject();
				imagePath.put("spacerURL","/final/monitor/eg_images/spacer.gif"); */

				String border_div="";
				String linetop_td="linetop";
				if(subsystem!=null && subsystem.equalsIgnoreCase("Analysis"))
				{
					JSONObject analysisGraphScreenLabels = new JSONObject();
					
					analysisGraphScreenLabels.put("ChartHeader",mappingInfo.getTextDescription("monitor.dashboard.Key Performance Metrics of the Server"));

					if(isBarChart)
					{
						analysisGraphScreenLabels.put("measuresViewImage","/final/monitor/eg_images/"+monitor_Skin+"/icon_measuregraph.png");
						analysisGraphScreenLabels.put("measuresViewTooltip",mappingInfo.getTextDescription("monitor.dashboard.Measure view"));

					}
					else
					{
						analysisGraphScreenLabels.put("barViewImage","/final/monitor/eg_images/"+monitor_Skin+"/icon_sidebargraph.png");
						analysisGraphScreenLabels.put("barViewTooltip",mappingInfo.getTextDescription("monitor.dashboard.Bar view"));

					}
					hiddenFields.put("barchartStatus",isBarChart);
					screenLabels.put("AnalysisGraphLabels",analysisGraphScreenLabels);
				}
				else if(subsystem!=null && subsystem.equalsIgnoreCase("OutsideView"))
				{
					JSONObject outsideGraphScreenLabels = new JSONObject();
					
					if(s_info==null)
						s_info="";
					
					
					//outsideGraphScreenLabels.put("ChartHeader",mappingInfo.getTextDescription("monitor.dashboard.Details of VM")+"&nbsp;{"+s_info+"}&nbsp;"+mappingInfo.getTextDescription("monitor.dashboard.currently on Physical Server"));
					outsideGraphScreenLabels.put("ChartHeader",mappingInfo.getTextDescription("monitor.dashboard.Details of VM")+"&nbsp;{"+s_info+"}&nbsp;");
					outsideGraphScreenLabels.put("LowerPanelHeader",mappingInfo.getTextDescription("monitor.dashboard.Key Performance Metrics of VM"));
					screenLabels.put("OutsidechartLabels",outsideGraphScreenLabels);

				}
				else if(subsystem.equalsIgnoreCase("InsideView"))
				{
					border_div="vmborder";
					linetop_td="";
					JSONObject insideScreenLabels = new JSONObject();
					JSONArray tabsInfo = new JSONArray();
					insideScreenLabels.put("tab",mappingInfo.getTextDescription("monitor.dashboard.Measures"));
					tabsInfo.add(insideScreenLabels);
					insideScreenLabels.put("tab",mappingInfo.getTextDescription("monitor.dashboard.System"));
					tabsInfo.add(insideScreenLabels);
					insideScreenLabels.put("tab",mappingInfo.getTextDescription("monitor.dashboard.Network"));
					tabsInfo.add(insideScreenLabels);
					screenLabels.put("InsideviewLabels",tabsInfo);

				}

			}//starts at 388

			int numMeasureGraph=0;
			int totalGraph=0;
			StringTokenizer st=null;
			if(systemAnalysisTests!=null && systemAnalysisTests.size()>0)
			{
				numMeasureGraph=systemAnalysisTests.size();
			}
			totalGraph=numMeasureGraph;
			int numColums=0;
			Vector runingTestList=new Vector();
			runingTestList=egDashboard.getRunningTest(compName,compType);
			for(int i=0;i<totalGraph;i++)
			{
				if(i<numMeasureGraph)
				{
					test=(String)systemAnalysisTests.get(i);

					if(runingTestList!=null && runingTestList.size()>0 && runingTestList.contains(test))
					{
						noGraphsFound=false;
						break;
					}
				}
				else
				{
					if(st!=null && st.hasMoreTokens())
					{
						String token=st.nextToken();
						String testName=token.substring(0,token.indexOf(":"));

						if(runingTestList!=null && runingTestList.size()>0 && runingTestList.contains(testName))
						{
							noGraphsFound=false;
							break;
						}
					}
				}
			}
			String analysisSingleData=iniObj.getValue(analysis_Subject,compType+"_Memory_DATA");
			boolean analysisSingleDataFlg=false;
			if(analysisSingleData!=null && analysisSingleData.trim().length()>0)
			{
				st=new StringTokenizer(analysisSingleData,",");
				while(st!=null && st.hasMoreTokens())
				{
					String token=st.nextToken();
					if(token!=null && token.indexOf(":")!=-1)
					{
						String test_only=token.substring(0,token.indexOf(":"));
						if(test_only!=null && runingTestList!=null && runingTestList.size()>0 && runingTestList.contains(test_only))
						{
							analysisSingleDataFlg=true;
							noGraphsFound=false;
							if(totalGraph==0)
							{
								totalGraph=1;
							}
							break;
						}
					}
				}
			}

			if(subsystem!=null && subsystem.equalsIgnoreCase("Analysis"))
			{
				if(!isBarChart)
				{
					analysisSingleData=iniObj.getValue(analysis_Subject,compType+"_Memory_DATA");
					if(analysisSingleData!=null && analysisSingleData.trim().length()>0)
					{
						st=new StringTokenizer(analysisSingleData,",");
						totalGraph=totalGraph+st.countTokens();
						numMeasureGraph=totalGraph;
						while(st!=null && st.hasMoreTokens())
						{
							analysisSingleDataFlg=false;
							String token=st.nextToken();
							if(token!=null && token.indexOf(":")!=-1)
							{
								String test_only=token.substring(0,token.indexOf(":"));
								String measure_with_dname=token.substring(token.indexOf(":")+1);
								String measure_only=measure_with_dname;
								String dname_only="";
								if(measure_with_dname!=null && measure_with_dname.indexOf(":")!=-1)
								{
									measure_only=measure_with_dname.substring(0,measure_with_dname.indexOf(":"));
									dname_only=measure_with_dname.substring(measure_with_dname.indexOf(":")+1);
								}

								if(runingTestList!=null && runingTestList.size()>0 && runingTestList.contains(test_only))
								{
									noGraphsFound=false;
								}

								if(dname_only==null || dname_only.trim().length()==0)
								{
									dname_only=mappingInfo.getMeasureDescription(test_only,measure_only);
								}

								systemAnalysisTests.add(test_only);
								systemAnalysisMeasure.add(measure_only);
								systemAnalysisDisplayName.add(dname_only);
							}
						}
					}
				}
			}

			boolean analysisBarFlg=false;
			boolean analysisBarFlg2=false;
			if(bar_Chart!=null && bar_Chart.trim().length()>0)
			{
				st=new StringTokenizer(bar_Chart,",");
				if(st!=null && st.countTokens()>=1)
				{
					analysisBarFlg=true;
					analysisBarFlg2=true;
					noGraphsFound=false;
					if(totalGraph==0)
					{
						totalGraph=2;
					}
				}
			}

			if(subsystem!=null && (subsystem.equalsIgnoreCase("OutsideView") || subsystem.equalsIgnoreCase("InsideView")) && aList_info!=null && aList_info.size()<=0)
			{
				noGraphsFound=true;
			}

			String data_summary_or_total_info_only=iniObj.getValue("Display_Analysis","data_summary_or_total_info_only");
			boolean data_summary_or_total_infos_flage=false;
			if(data_summary_or_total_info_only!=null && data_summary_or_total_info_only.equalsIgnoreCase("yes"))
			{
				data_summary_or_total_infos_flage=true;
			}

			Hashtable measure_name_hash=new Hashtable();

			if(!noGraphsFound)
			{

				JSONArray allGraphdataArray = new JSONArray();
				for(int i=0;i<totalGraph;i++)
				{
					boolean showMultipleInfo=false;

					if(graphType !=null && subsystem!=null && subsystem.equalsIgnoreCase("Analysis") && (graphType.equalsIgnoreCase("CPU") || graphType.equalsIgnoreCase("Memory") || graphType.equalsIgnoreCase("Disk")))
						showMultipleInfo=true;
					else if(subsystem!=null && (subsystem.equalsIgnoreCase("OutsideView") || subsystem.equalsIgnoreCase("InsideView")))
					{
						showMultipleInfo=true;
					}

					String dispInfo="";
					if(i==0 && analysisBarFlg)
					{
						if(bar_Chart!=null && bar_Chart.trim().length()>0)
						{
							StringTokenizer test_with_measure=new StringTokenizer(bar_Chart,",");
							int total_count=test_with_measure.countTokens();
							test_with_measure=new StringTokenizer(bar_Chart,",");
							total_count=test_with_measure.countTokens();
							String lineBarGraphColor=iniObj.getValue("Display_Analysis","LineBarGraphColor");
							String showValue_in_LineGraph=iniObj.getValue("Display_Analysis","showValue_in_LineGraph");
							Hashtable test_hash=new Hashtable();
							while(test_with_measure.hasMoreTokens())
							{
								String token=test_with_measure.nextToken();
								String test_only="";
								String measure_only="";
								String display_name="";
								if(token!=null && token.indexOf(":")!=-1)
								{
									test_only=token.substring(0,token.indexOf(":"));
									measure_only=token.substring(token.indexOf(":")+1);
									if(measure_only!=null && measure_only.indexOf(":")>-1)
									{
										display_name=measure_only.substring(measure_only.indexOf(":")+1);
										measure_only=measure_only.substring(0,measure_only.indexOf(":"));
									}

									if(measure_only!=null && measure_only.indexOf(":")>-1)
									{
										display_name=measure_only.substring(measure_only.indexOf(":")+1);
										measure_only=measure_only.substring(0,measure_only.indexOf(":"));
									}
									else
									{
										display_name=mappingInfo.getMeasureDescription(test_only,measure_only);
									}

									String label=display_name;
									if(label!=null && label.indexOf("-")!=-1)
										label=label.substring(0,label.indexOf("-"));
									String unit=tablesInfo.getUnitForMeasure(test_only,measure_only);
									if(test_only!=null && test_only.trim().length()>0 && measure_only!=null && measure_only.trim().length()>0)
									{
										if(test_hash.size()==0)
										{
											ArrayList temp=new ArrayList();
											temp.add(measure_only);
											test_hash.put(test_only,(ArrayList)temp);
										}
										else
										{
											if(test_hash.containsKey(test_only))
											{
												ArrayList temp=(ArrayList)test_hash.get(new String(test_only));
												temp.add(measure_only);
												test_hash.put(test_only,(ArrayList)temp);
											}
											else
											{
												ArrayList temp=new ArrayList();
												temp.add(measure_only);
												test_hash.put(test_only,temp);
											}
										}
									}
								}
							}

							Hashtable getCurAnaStaHash= new Hashtable();
							if(test_hash!=null && test_hash.size()>0)
							{
								Enumeration keys=test_hash.keys();
								while(keys.hasMoreElements())
								{
									String test_name = (String)keys.nextElement();
									ArrayList measure_list=(ArrayList)test_hash.get(test_name);
									if((!specsInfo.isPortRelevantForTest(test_name)))
									{
										portNo="NULL";
									}
									String msmtHost="";
									List agents=egExternalInfo.getAgentsFor(test_name,compType,hostName);
									if(agents!=null && agents.size()>0)
										msmtHost=(String)agents.get(0);
									else
										msmtHost=hostName;

									Hashtable temp_hash=(Hashtable)dashboardDAO.getCurrentAnalysisStatus(compName,compType,portNo,test_name,measure_list,msmtHost,true,s_info);
									if(temp_hash!=null && temp_hash.size()>0)
									{
										getCurAnaStaHash.putAll(temp_hash);
									}
								}
							}

							test_with_measure=new StringTokenizer(bar_Chart,",");
							total_count=test_with_measure.countTokens();
							JSONArray analysisBarGraphArray = new JSONArray();
							while(test_with_measure.hasMoreTokens())
							{
								double scrWidth=Double.parseDouble(barGraphWidth)+32;
								double scrHeight=Double.parseDouble(barGraphHeight)+60;
								//String barDivHeight=barGraphHeight;

								String token=test_with_measure.nextToken();
								String test_only="";
								String measure_only="";
								String display_name="";
								if(token!=null && token.indexOf(":")!=-1)
								{
									test_only=token.substring(0,token.indexOf(":"));
									measure_only=token.substring(token.indexOf(":")+1);
									if(measure_only!=null && measure_only.indexOf(":")>-1)
									{
										display_name=measure_only.substring(measure_only.indexOf(":")+1);
										measure_only=measure_only.substring(0,measure_only.indexOf(":"));
									}

									if(measure_only!=null && measure_only.indexOf(":")>-1)
									{
										display_name=measure_only.substring(measure_only.indexOf(":")+1);
										measure_only=measure_only.substring(0,measure_only.indexOf(":"));
									}
									else
									{
										display_name=mappingInfo.getMeasureDescription(test_only,measure_only);
									}
								}
								JSONObject analysisBargraphInfo = new JSONObject();

								String label=display_name;
								if(label!=null && label.indexOf("-")!=-1)
									label=label.substring(0,label.indexOf("-"));

								
								analysisBargraphInfo.put("LabelForGraph",mappingInfo.getTextDescription("monitor.dashboard."+label));

	
								String measureForDB=dbInfo.getColumnForMeasure(test_only,measure_only);
								String unit=tablesInfo.getUnitForMeasure(test_only,measure_only);
								String msmtHost="";

								boolean portReleventForTest = false;
								boolean siteReleventForTest = false;
								boolean infoReleventForTest = false;
								boolean isTestRelevantForServer = false;
								
								if(test_only!=null)
								{
									portReleventForTest = specsInfo.isPortRelevantForTest(test_only);
									isTestRelevantForServer = specsInfo.isTestRelevantForServer(compType,test_only);
								}

								if(!portReleventForTest)
								{
									portNo="NULL";
								}
								List agents=egExternalInfo.getAgentsFor(test_only,compType,hostName);
								if(agents!=null && agents.size()>0)
									msmtHost=(String)agents.get(0);
								else
									msmtHost=hostName;
								
								Vector allInfos=new Vector();
								if(allInfoForAllTest!=null && allInfoForAllTest.size()>0)
									allInfos=(Vector)allInfoForAllTest.get(test_only);
								String info_for_timeout="";
								StringBuffer temp_bef=new StringBuffer();
								if(allInfos!=null && allInfos.size()>0)
								{
									if(allInfos.size()==1)
									{
										String infoFormeasure=(String)allInfos.get(0);
										if(infoFormeasure!=null && infoFormeasure.trim().length()>0)
										{
											temp_bef.append(",");
											temp_bef.append(infoFormeasure);
											temp_bef.append("");
										}
									}
									else
									{
										for(int infoCount=0;infoCount<allInfos.size();infoCount++)
										{
											String infoFormeasure=(String)allInfos.get(infoCount);
											if(infoFormeasure!=null && infoFormeasure.trim().length()>0)
											{
												temp_bef.append(",'");
												temp_bef.append(infoFormeasure);
												temp_bef.append("'");
											}
										}
									}
								}
								info_for_timeout=temp_bef.toString();

								if(subsystem!=null && subsystem.equalsIgnoreCase("OutsideView"))
								{
									info_for_timeout="+"+s_info;
								}
							
								if(info_for_timeout!=null && info_for_timeout.startsWith(","))
								{
									info_for_timeout=info_for_timeout.substring(1);
								}
								if(sid!=null && !sid.equals(""))
								{
									info_for_timeout=com.egurkha.util.StringUtils.replace(info_for_timeout,"+","");
									info_for_timeout=sid+"*"+info_for_timeout;
								}
								else
									info_for_timeout=com.egurkha.util.StringUtils.replace(info_for_timeout,"+","|plus|");
								
								String lastRuntime=null;
								if(measureLastTimeForAllTest!=null && measureLastTimeForAllTest.size()>0)
									lastRuntime=(String)measureLastTimeForAllTest.get(test_only+"^"+hostName);
								boolean isTimeout=false;
								//Added by Chandrasekhar toget Cut of Factor value from eg_services.ini...
								String cut_off_factor_value = null;

								if(test_only!=null)
									cut_off_factor_value = trans_services_ini.getStrValue("CUT_OFF_FACTOR", test_only);
								if(cut_off_factor_value==null || cut_off_factor_value.trim().length()==0)
								{
									cut_off_factor_value = trans_services_ini.getStrValue("CUT_OFF_FACTOR", "Default");
								}
								//ended here...
								//System.out.println("lastRuntime====================>"+lastRuntime);
								if(cut_off_factor_value!=null && !cut_off_factor_value.trim().equals("-1") && lastRuntime!=null && lastRuntime.trim().length()>0 && cut_off_factor_value.trim().length()>0)
								{
									String compName_for_timeout=compName;
									if(!portReleventForTest)
									{
										if (compName!=null && compName.indexOf(":")>-1)
										{
											compName_for_timeout=compName.substring(0,compName.indexOf(":"));
										}
									}
									isTimeout=MeasuresDao.isTimeOut(lastRuntime,test_only+"#"+msmtHost,compName_for_timeout,compType);
								}
								Hashtable analysis_Single_Data=new Hashtable();
								ArrayList all_info_list=new ArrayList();
								String current_mes_value="-5";
								if(isTestRelevantForServer && !isTimeout)
								{
									if(subsystem!=null && subsystem.equalsIgnoreCase("OutsideView"))
									{
										current_mes_value=(String)getCurAnaStaHash.get(test_only+"^"+measure_only+"^+"+s_info);
										if(current_mes_value==null || current_mes_value.trim().length()==0)
											current_mes_value="-5";
									}
									else
									{
										analysis_Single_Data=dashboardDAO.getCurrentAnalysisStatus (compName,compType,portNo,null,test_only,measureForDB,msmtHost,null,null,null,null,null,null,null,true);
									}
								}
								//String current_mes_value=null;
								if(subsystem!=null && !subsystem.equalsIgnoreCase("OutsideView"))
								{
									if(analysis_Single_Data!=null && analysis_Single_Data.size()==1)
									{
										Enumeration keys=analysis_Single_Data.keys();
										if(keys.hasMoreElements())
										{
											String db_info = (String)keys.nextElement();
											try
											{
												current_mes_value=(String)analysis_Single_Data.get(db_info);
											}
											catch(Exception ee)
											{
												current_mes_value="-5";
											}
										}
									}
									else current_mes_value="-5";
								}
								
								if(current_mes_value!=null && !current_mes_value.equalsIgnoreCase("-5"))
								{
									try
									{
										if(unit!=null && unit.equals("MB") && is_convert_MB_to_GB)
										{
											double fillColorValue=Double.parseDouble(current_mes_value);
											fillColorValue=fillColorValue/1024.0;
											current_mes_value=String.valueOf(fillColorValue);
											unit="GB";
										}
									}
									catch(Exception e)
									{
										current_mes_value=current_mes_value;
										unit="MB";
									}
									
									try
									{
										current_mes_value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(current_mes_value),2));
									}
									catch(Exception ee)
									{
										current_mes_value=current_mes_value;
									}
								}
								String display_mes_value=current_mes_value;
								if(display_mes_value!=null && display_mes_value.equalsIgnoreCase("-5"))
								{
									display_mes_value="-";
								}

								if(isApplyFusion)
								{
									String URL = "/final/servlet/com.egurkha.monitor.EgBarGraph?width="+barGraphWidth+"&height="+barGraphHeight+"&graphValue="+current_mes_value+"&LineBarGraphColor="+lineBarGraphColor+"&showValueInLineGraph="+showValue_in_LineGraph+"&applyFusion="+isApplyFusion+"&monitorSkin="+monitor_Skin;
									analysisBargraphInfo.put("graphURL",URL);

								}
								else
								{
									String URL = "/final/servlet/com.egurkha.monitor.EgBarGraph?width=30&height=100&graphValue="+current_mes_value+"&LineBarGraphColor="+lineBarGraphColor+"&showValueInLineGraph="+showValue_in_LineGraph+"&monitorSkin="+monitor_Skin;
									analysisBargraphInfo.put("graphURL",URL);
									analysisBargraphInfo.put("Title",display_name);
									analysisBargraphInfo.put("mesValue",display_mes_value);

								}
								analysisBarGraphArray.add(analysisBargraphInfo);
							}//while
							numColums=2;
							json.put("OutsideGraphInfoRoot",analysisBarGraphArray);
							//allGraphdataArray.add(analysisBarGraphArray);
						}
						analysisBarFlg=false;
						i=-1;
					}//starts at 1891
					else if(i==0 && analysisSingleDataFlg)
					{
						if(analysisSingleData!=null && analysisSingleData.trim().length()>0)
						{
							boolean flage_for_state=true;
							StringTokenizer test_with_measure=new StringTokenizer(analysisSingleData,",");
							int total_count=test_with_measure.countTokens();
							int colspan_value=0;
							String table_width="305px";
							String div_height="174px";
							if(subsystem!=null && subsystem.equalsIgnoreCase("OutsideView"))
							{
								colspan_value=3;
								table_width="";
								div_height="";
							}
							int count_token=0;
							boolean end_loop=false;
							Hashtable analysis_Single_State=new Hashtable();
							Hashtable test_hash=new Hashtable();
							while(test_with_measure.hasMoreTokens())
							{
								String token=test_with_measure.nextToken();
								String test_only="";
								String measure_only="";
								String display_name="";
								if(token!=null && token.indexOf(":")!=-1)
								{
									test_only=token.substring(0,token.indexOf(":"));
									measure_only=token.substring(token.indexOf(":")+1);
									if(measure_only!=null && measure_only.indexOf(":")>-1)
									{
										display_name=measure_only.substring(measure_only.indexOf(":")+1);
										measure_only=measure_only.substring(0,measure_only.indexOf(":"));
									}
									
									if(test_only!=null && test_only.trim().length()>0 && measure_only!=null && measure_only.trim().length()>0)
									{
										if(test_hash.size()==0)
										{
											ArrayList temp=new ArrayList();
											temp.add(measure_only);
											test_hash.put(test_only,(ArrayList)temp);
										}
										else
										{
											if(test_hash.containsKey(test_only))
											{
												ArrayList temp=(ArrayList)test_hash.get(new String(test_only));
												temp.add(measure_only);
												test_hash.put(test_only,(ArrayList)temp);
											}
											else
											{
												ArrayList temp=new ArrayList();
												temp.add(measure_only);
												test_hash.put(test_only,temp);
											}
										}
									}
								}
							}

							Hashtable getCurAnaStaHash= new Hashtable();
							if(test_hash!=null && test_hash.size()>0)
							{
								Enumeration keys=test_hash.keys();
								while(keys.hasMoreElements())
								{
									String test_name = (String)keys.nextElement();
									ArrayList measure_list=(ArrayList)test_hash.get(test_name);
									if((!specsInfo.isPortRelevantForTest(test_name)))
									{
										portNo="NULL";
									}
									String msmtHost="";
									List agents=egExternalInfo.getAgentsFor(test_name,compType,hostName);
									if(agents!=null && agents.size()>0)
										msmtHost=(String)agents.get(0);
									else
										msmtHost=hostName;

									Hashtable temp_hash=(Hashtable)dashboardDAO.getCurrentAnalysisStatus(compName,compType,portNo,test_name,measure_list,msmtHost,true,s_info);
									if(temp_hash!=null && temp_hash.size()>0)
									{
										getCurAnaStaHash.putAll(temp_hash);
									}
								}
							}
							test_with_measure=new StringTokenizer(analysisSingleData,",");
							total_count=test_with_measure.countTokens();
							
							JSONArray layerInfoArray = new JSONArray();
							while(test_with_measure.hasMoreTokens())
							{
								String token=test_with_measure.nextToken();
								String test_only="";
								String measure_only="";
								if(token!=null && token.indexOf(":")!=-1)
								{
									test_only=token.substring(0,token.indexOf(":"));
									measure_only=token.substring(token.indexOf(":")+1);
								}
		
								String measureForDB=dbInfo.getColumnForMeasure(test_only,measure_only);
								String unit=tablesInfo.getUnitForMeasure(test_only,measure_only);
								String msmtHost="";

								boolean portReleventForTest = false;
								boolean siteReleventForTest = false;
								boolean infoReleventForTest = false;
								boolean isTestRelevantForServer = false;
								
								if(test_only!=null)
								{
									portReleventForTest = specsInfo.isPortRelevantForTest(test_only);
									isTestRelevantForServer = specsInfo.isTestRelevantForServer(compType,test_only);
								}

								if(!portReleventForTest)
								{
									portNo="NULL";
								}
								List agents=egExternalInfo.getAgentsFor(test_only,compType,hostName);
								if(agents!=null && agents.size()>0)
									msmtHost=(String)agents.get(0);
								else
									msmtHost=hostName;

								String Layer_name_str=tablesInfo.getLayerForTest(test_only);
								StringTokenizer tokenLayer=new StringTokenizer(Layer_name_str,",");
								String layerName="HOST";
								if(tokenLayer!=null)
								{
									while(tokenLayer.hasMoreTokens())
									{
										String l_name=(String)tokenLayer.nextToken();
										if(l_name!=null)
										{
											if(tablesInfo.isMeasureInLayer(test_only,measure_only,l_name))
											{
												layerName=l_name;
												break;
											}
										}
									}
								}
								
								Vector allInfos=new Vector();
								if(allInfoForAllTest!=null && allInfoForAllTest.size()>0)
									allInfos=(Vector)allInfoForAllTest.get(test_only);
								String info_for_timeout="";
								StringBuffer temp_bef=new StringBuffer();
								if(allInfos!=null && allInfos.size()>0)
								{
									if(allInfos.size()==1)
									{
										String infoFormeasure=(String)allInfos.get(0);
										if(infoFormeasure!=null && infoFormeasure.trim().length()>0)
										{
											temp_bef.append(",");
											temp_bef.append(infoFormeasure);
											temp_bef.append("");
										}
									}
									else
									{
										for(int infoCount=0;infoCount<allInfos.size();infoCount++)
										{
											String infoFormeasure=(String)allInfos.get(infoCount);
											if(infoFormeasure!=null && infoFormeasure.trim().length()>0)
											{
												temp_bef.append(",'");
												temp_bef.append(infoFormeasure);
												temp_bef.append("'");
											}
										}
									}
								}
								info_for_timeout=temp_bef.toString();

								if(subsystem!=null && subsystem.equalsIgnoreCase("OutsideView"))
								{
									info_for_timeout="+"+s_info;
								}
							
								if(info_for_timeout!=null && info_for_timeout.startsWith(","))
								{
									info_for_timeout=info_for_timeout.substring(1);
								}
								if(sid!=null && !sid.equals(""))
								{
									info_for_timeout=com.egurkha.util.StringUtils.replace(info_for_timeout,"+","");
									info_for_timeout=sid+"*"+info_for_timeout;
								}
								else
									info_for_timeout=com.egurkha.util.StringUtils.replace(info_for_timeout,"+","|plus|");

								String lastRuntime=null;
								if(measureLastTimeForAllTest!=null && measureLastTimeForAllTest.size()>0)
									lastRuntime=(String)measureLastTimeForAllTest.get(test_only+"^"+hostName);
								boolean isTimeout=false;
								//Added by Chandrasekhar toget Cut of Factor value from eg_services.ini...
								String cut_off_factor_value = null;

								if(test_only!=null)
									cut_off_factor_value = trans_services_ini.getStrValue("CUT_OFF_FACTOR", test_only);
								if(cut_off_factor_value==null || cut_off_factor_value.trim().length()==0)
								{
									cut_off_factor_value = trans_services_ini.getStrValue("CUT_OFF_FACTOR", "Default");
								}
								//ended here..
								System.out.println("lastRuntime====================>"+lastRuntime);
								if(cut_off_factor_value!=null && !cut_off_factor_value.trim().equals("-1") && lastRuntime!=null && lastRuntime.trim().length()>0 &&  cut_off_factor_value.trim().length()>0)
								{
									String compName_for_timeout=compName;
									if(!portReleventForTest)
									{
										if (compName!=null && compName.indexOf(":")>-1)
										{
											compName_for_timeout=compName.substring(0,compName.indexOf(":"));
										}
									}
									isTimeout=MeasuresDao.isTimeOut(lastRuntime,test_only+"#"+msmtHost,compName_for_timeout,compType);
								}
								Hashtable analysis_Single_Data=new Hashtable();
								ArrayList all_info_list=new ArrayList();
								String current_mes_value="-";
								if(isTestRelevantForServer && !isTimeout)
								{
									if(flage_for_state)
									{
										analysis_Single_State=measureGraph.getStateForMeasures(analysisSingleData,compName,compType,layerName,portNo,"NULL",com.egurkha.util.StringUtils.replace(info_for_timeout,"|plus|","+"),msmtHost);
										flage_for_state=false;
									}
									if(subsystem!=null && subsystem.equalsIgnoreCase("OutsideView"))
									{
										current_mes_value=(String)getCurAnaStaHash.get(test_only+"^"+measure_only+"^+"+s_info);
									}
									else
									{
										analysis_Single_Data=dashboardDAO.getCurrentAnalysisStatus (compName,compType,portNo,null,test_only,measureForDB,msmtHost,null,null,null,null,null,null,null,true);
									}
								}
								//String current_mes_value=null;
								if(subsystem!=null && !subsystem.equalsIgnoreCase("OutsideView"))
								{
									if(analysis_Single_Data!=null && analysis_Single_Data.size()==1)
									{
										Enumeration keys=analysis_Single_Data.keys();
										if(keys.hasMoreElements())
										{
											String db_info = (String)keys.nextElement();
											try
											{
												current_mes_value=(String)analysis_Single_Data.get(db_info);
												if(current_mes_value!=null && (current_mes_value.equals("-5") || current_mes_value.equals("-5.0000")))
												{
													current_mes_value="-";
												}
											}
											catch(Exception ee)
											{
												current_mes_value="-";
											}
										}
									}
									else current_mes_value="-";
								}

								if(current_mes_value==null || current_mes_value.trim().equals(""))
									current_mes_value="-";

								if(current_mes_value!=null && !current_mes_value.equalsIgnoreCase("-"))
								{
									String iniVar=null;
									try
									{
										current_mes_value=dbInfo.formatValue(current_mes_value);
										iniVar=test_only+":"+measure_only+":"+Math.round(Float.parseFloat(current_mes_value));
									}
									catch(Exception ee)
									{
										iniVar=test_only+":"+measure_only+":"+current_mes_value;
									}

									String iniValue=egUi.getValue("Measure_value_display",iniVar);
									if(iniValue!=null && iniValue.length() > 0)
									{
										current_mes_value=iniValue;
										unit="";
									}
									else
									{
										try
										{
											if(unit!=null && unit.equals("MB") && is_convert_MB_to_GB)
											{
												double fillColorValue=Double.parseDouble(current_mes_value);
												fillColorValue=fillColorValue/1024.0;
												current_mes_value=String.valueOf(fillColorValue);
												unit="GB";
											}
										}
										catch(Exception e)
										{
											current_mes_value=current_mes_value;
											unit="MB";
										}
										
										try
										{
											if(current_mes_value!=null && current_mes_value.indexOf(".")>-1)
											{
												current_mes_value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(current_mes_value),2));
											}
										}
										catch(Exception ee)
										{
											current_mes_value=current_mes_value;
										}
									}
								}

								String state_value="GOOD";
								if(analysis_Single_State!=null && analysis_Single_State.size()>0)
								{
									try
									{
										state_value=(String)analysis_Single_State.get(token);
									}
									catch(Exception e)
									{
										state_value="GOOD";
									}
								}

								if(subsystem!=null && subsystem.equalsIgnoreCase("OutsideView") && (count_token%3)==0)
								{
									if(count_token!=0)
									{

									}
								}
								else if(subsystem!=null && !subsystem.equalsIgnoreCase("OutsideView"))
								{
									if(count_token!=0)
									{
	
									}

								}

								if(state_value==null || state_value.trim().length()==0 || state_value.equalsIgnoreCase("null"))
									state_value="GOOD";

								
								String info_for_url=com.egurkha.util.StringUtils.replace(info_for_timeout,"|plus|","");
								info_for_url=com.egurkha.util.StringUtils.replace(info_for_url,"+","|plus|");
								info_for_url=com.egurkha.util.StringUtils.replace(info_for_url,"&","|amp|");
								info_for_url=com.egurkha.util.StringUtils.replace(info_for_url,"%","|pct|");
								info_for_url=com.egurkha.util.StringUtils.replace(info_for_url,"//","////");
								
								JSONObject layerInfo = new JSONObject();
								

								//String layerModelURL=response.encodeURL("/final/monitor/egMonDashboard.jsp?")+"qctr=2&fromPage=componentList&host="+compName+"&comptype="+compType+"&layer="+layerName+"&site=NULL&test="+EgURLEncoder.encode(test_only+"-"+info_for_url,"UTF-8")+"&tstate="+state_value+"&msmt_host="+(isFirefox?msmtHost:EgURLEncoder.encode(msmtHost,"UTF-8"));

								String layerModelURL = response.encodeURL("/final/monitor/EgSiteInfraView.jsp?")+"qctr=2&fromalarm=&host="+compName+"&layer="+layerName+"&site=NULL&msmt_host="+(isFirefox?msmtHost:EgURLEncoder.encode(msmtHost,"UTF-8"))+"&test="+EgURLEncoder.encode(test_only+"-"+info_for_url,"UTF-8")+"&comptype="+compType+"&tstate="+state_value+"&newWindow=false&prevPage=MainDashBoard&gauageClick=true";

								layerInfo.put("title",mappingInfo.getLabelDescription(state_value));
								layerInfo.put("stateValue",state_value);
								layerInfo.put("link",layerModelURL);
								layerInfo.put("currentMesValue",current_mes_value);
								
								String measuretest = test_only+":"+measure_only;
								layerInfo.put("measure",mappingInfo.getMeasureDescription(test_only,measure_only));
								
								String customUnit;
								if(unit!=null && unit.trim().length()>0)
									customUnit = "("+unit+")";
								else
									customUnit ="";
								layerInfo.put("unit",customUnit);

								
								if((count_token+1)>=total_count)
								{
									if(((count_token+1)%3)==2 && subsystem!=null && subsystem.equalsIgnoreCase("OutsideView"))
									{

									}
									else if(((count_token+1)%3)==1 && subsystem!=null && subsystem.equalsIgnoreCase("OutsideView"))
									{

									}

								}
								count_token++;
								layerInfoArray.add(layerInfo);
							}//while

							if(subsystem!=null && subsystem.equalsIgnoreCase("OutsideView"))
							{
								numColums=numColums+2;

							}
							if(custom_select_subsystem.equalsIgnoreCase("OutsideView"))
							{
							json.put("outsideBottomGridArray",layerInfoArray);
							}
							else
							{
								allGraphdataArray.add(layerInfoArray);
							}
							//allGraphdataArray.add(layerInfoArray);
						}
						analysisSingleDataFlg=false;
						i=-1;
					}//starts at 2223
					else if(i<numMeasureGraph)
					{
						test=(String)systemAnalysisTests.get(i);
						if(test==null) continue;
						if(runingTestList!=null && runingTestList.size()>0 && !runingTestList.contains(test))
							continue;
						measure=(String)systemAnalysisMeasure.get(i);
						String display_name=(String)systemAnalysisDisplayName.get(i);
						Vector allInfos=new Vector();
						//allInfos=measureGraph.getAllInfoForTest(compType,compName,test);
						if(allInfoForAllTest!=null && allInfoForAllTest.size()>0)
							allInfos=(Vector)allInfoForAllTest.get(test);
						String measureForDB=dbInfo.getColumnForMeasure(test,measure);
						String msmtHost="";

						boolean portReleventForTest = false;
						boolean siteReleventForTest = false;
						boolean infoReleventForTest = false;
						boolean isTestRelevantForServer = false;
						
						if(test!=null)
						{
							portReleventForTest = specsInfo.isPortRelevantForTest(test);
							siteReleventForTest = specsInfo.isSiteRelevantForTest(test);
							infoReleventForTest = specsInfo.isInfoRelevantForTest(test,compType);
							isTestRelevantForServer = specsInfo.isTestRelevantForServer(compType,test);
						}

						if(!portReleventForTest)
						{
							portNo="NULL";
						}
						String Layer_name_str=tablesInfo.getLayerForTest(test);
						StringTokenizer tokenLayer=new StringTokenizer(Layer_name_str,",");
						String layerName="HOST";
						if(tokenLayer!=null)
						{
							while(tokenLayer.hasMoreTokens())
							{
								String l_name=(String)tokenLayer.nextToken();
								if(l_name!=null)
								{
									if(tablesInfo.isMeasureInLayer(test,measure,l_name))
									{
										layerName=l_name;
										break;
									}
								}
							}
						}
						
						List agents=egExternalInfo.getAgentsFor(test,compType,hostName);
						if(agents!=null && agents.size()>0)
							msmtHost=(String)agents.get(0);
						else
							msmtHost=hostName;
						
						Hashtable temp_measure_hash=new Hashtable();
						if(measure_name_hash!=null && measure_name_hash.size()>0)
						{
							if(measure_name_hash.containsKey(test))
							{
								temp_measure_hash=(Hashtable)measure_name_hash.get(test);
							}
							else
							{
								temp_measure_hash=(Hashtable)measureGraph.getMeasureNamesForAllInfo(hostName,test,layerName);
								measure_name_hash.put(test,(Hashtable)temp_measure_hash);
							}
						}
						else
						{
							temp_measure_hash=(Hashtable)measureGraph.getMeasureNamesForAllInfo(hostName,test,layerName);
							measure_name_hash.put(test,(Hashtable)temp_measure_hash);
						}

						String info_for_timeout="";
						StringBuffer temp_bef=new StringBuffer();
						if(allInfos!=null && allInfos.size()>0)
						{
							if(allInfos.size()==1)
							{
								String infoFormeasure=(String)allInfos.get(0);
								if(infoFormeasure!=null && infoFormeasure.trim().length()>0)
								{
									temp_bef.append(",");
									temp_bef.append(infoFormeasure);
									temp_bef.append("");
								}
							}
							else
							{
								for(int infoCount=0;infoCount<allInfos.size();infoCount++)
								{
									String infoFormeasure=(String)allInfos.get(infoCount);
									if(infoFormeasure!=null && infoFormeasure.trim().length()>0)
									{
										temp_bef.append(",'");
										temp_bef.append(infoFormeasure);
										temp_bef.append("'");
									}
								}
							}
						}
						info_for_timeout=temp_bef.toString();
						if(info_for_timeout!=null && info_for_timeout.startsWith(","))
						{
							info_for_timeout=info_for_timeout.substring(1);
						}

						Vector tempInfo=new Vector();
						for(int infoCount=0;infoCount<allInfos.size();infoCount++)
						{
							String infoFormeasure=(String)allInfos.get(infoCount);
							//Vector measureNames=egDashboard.getMeasurenamesFromInfo(hostName,portNo,siteName,layerName,test,infoFormeasure,msmtHost);
							Vector measureNames=new Vector();
							if(temp_measure_hash!=null && temp_measure_hash.size()>0)
								measureNames=(Vector)temp_measure_hash.get(infoFormeasure);

							if(measureNames!=null && measureNames.contains(measureForDB))
								tempInfo.add(infoFormeasure);
						}
						allInfos=tempInfo;
						//info=measureGraph.getInfoforTest(compType,compName,test);
						
						boolean hasSummary=false;
						boolean isFirst=true;
						String firstInfo="";
						if(allInfos!=null && allInfos.size()>0)
						{
							for(int infoCount=0;infoCount<allInfos.size();infoCount++)
							{
								info=(String)allInfos.get(infoCount);
								if(isFirst)
								{
									firstInfo=info;
									isFirst=false;
								}
								if(info!=null && info.equalsIgnoreCase("+Summary"))
								{
									hasSummary=true;
									break;
								}
							}

							if(!hasSummary)
							{
								info=firstInfo;
							}
						}
						
						if(info!=null && !info.equals("+") && !info.equals(""))
						{
							String tmpInfo=info.substring(1,info.length());
							dispInfo=tmpInfo;
						}
						if(subsystem!=null && subsystem.equalsIgnoreCase("OutsideView"))
						{
							info="+"+s_info;
						}
						JSONObject measureGraphobj = new JSONObject();
						
						

						if(display_name!=null && display_name.trim().length()>0)
						{
							measureGraphobj.put("measuresGraphDisplayName",mappingInfo.getTextDescription("monitor.dashboard."+display_name));
																	//out.println(mappingInfo.getTextDescription("monitor.dashboard."+display_name));
						}
						else
						{
							String measureTest = test+":"+measure ; 
							measureGraphobj.put("measuresGraphDisplayName",mappingInfo.getMeasureDescription(test,measure));

						}

						String unit_for_measure=tablesInfo.getUnitForMeasure(test,measure);
						if(unit_for_measure!=null && unit_for_measure.equals("MB") && is_convert_MB_to_GB && isBarChart)
						{
							unit_for_measure="GB";
						}
						measureGraphobj.put("unitForMeasure",unit_for_measure);

						if(sid!=null && !sid.equals(""))
						{
							info=com.egurkha.util.StringUtils.replace(info,"+","");
							info=sid+"*"+info;
						}
						else
							info=com.egurkha.util.StringUtils.replace(info,"+","|plus|");

						//String lastRuntime=measureGraph.getMeasureLastRunTime(test,hostName,portNo,"NULL",com.egurkha.util.StringUtils.replace(info_for_timeout,"|plus|","+"),msmtHost,true);
						String lastRuntime=null;
						if(measureLastTimeForAllTest!=null && measureLastTimeForAllTest.size()>0)
							lastRuntime=(String)measureLastTimeForAllTest.get(test+"^"+hostName);
						boolean isTimeout=false;
						//Added by Chandrasekhar toget Cut of Factor value from eg_services.ini...
						String cut_off_factor_value = null;
						
						if(test!=null)
							cut_off_factor_value = trans_services_ini.getStrValue("CUT_OFF_FACTOR", test);
						
						if(cut_off_factor_value == null || cut_off_factor_value.trim().length() == 0)
						{
							cut_off_factor_value = trans_services_ini.getStrValue("CUT_OFF_FACTOR", "Default");
						}
						//ended here...
						System.out.println("lastRuntime====================>"+lastRuntime);
						if(cut_off_factor_value!=null &&  !cut_off_factor_value.trim().equals("-1") && lastRuntime!=null && lastRuntime.trim().length()>0 && cut_off_factor_value.trim().length()>0)
						{
							String compName_for_timeout=compName;
							if(!portReleventForTest)
							{
								if (compName!=null && compName.indexOf(":")>-1)
								{
									compName_for_timeout=compName.substring(0,compName.indexOf(":"));
								}
							}
							isTimeout=MeasuresDao.isTimeOut(lastRuntime,test+"#"+msmtHost,compName_for_timeout,compType);
						}
						if(isTestRelevantForServer && !isTimeout)
						{
							isTimeout=false;
						}
						else
						{
							isTimeout=true;
						}
						Vector times=egDashboard.getStartEndDateTimeForCurrent();
						if(times!=null && times.size()>=4)
						{
							startTime=(String)times.get(0);
							endTime=(String)times.get(1);
							startHour=(String)times.get(2);
							endHour=(String)times.get(3);
						}

						String infoForDiskbased="";

						for(int infocount=0;infocount<allInfos.size();infocount++)
						{
							String infoFromVector=(String)allInfos.get(infocount);
							infoFromVector=com.egurkha.util.StringUtils.replace(infoFromVector,"+","*");
							infoFromVector=com.egurkha.util.StringUtils.replace(infoFromVector,"|plus|","*");
							infoForDiskbased+=infoFromVector;
							if(infocount<allInfos.size()-1)
								infoForDiskbased+=",";
						}
						if(showMultipleInfo)
						{
							info=infoForDiskbased;
						}

						times=egDashboard.getStartEndDateTimeForMeasure();
						if(times!=null && times.size()>=4)
						{
							startTime=(String)times.get(0);
							endTime=(String)times.get(1);
							startHour=(String)times.get(2);
							endHour=(String)times.get(3);
						}

						int measureGraphWidth=232;
						int measureGraphHeight=156;
						
						String measureGraphUrl=null;
						if(isBarChart)
						{
							measureGraphUrl="/final/servlet/com.egurkha.monitor.DDTopview?host="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&test="+test+"&measure="+measureForDB+"&real_measure="+measure+"&module=System&width="+ddGraphWidth+"&height="+ddGraphHeight+"&monitorSkin="+monitor_Skin+"&mode=3D&graphdisplay=defaultView&msmt_host="+msmtHost+"&port="+portNo+"&isFromAnalysis=true&layer="+layerName+"&noOfInfosToDisplay="+showTop+"&isTimeout="+isTimeout+"&graphIndex="+i+"&applyFusion="+isApplyFusion+"&fit=true";

							if(subsystem!=null && subsystem.equalsIgnoreCase("OutsideView"))
							{
								measureGraphUrl=measureGraphUrl+"&info="+s_info+"&isInfoSelected=true";
							}
						}
						else
						{
							measureGraphUrl="/final/servlet/com.egurkha.monitor.DashboardTimelineMeasures?measure="+measureForDB+"&real_measure="+measure+"&state="+state+"&starttime="+startTime+"&port="+portNo+"&comptype="+compType+"&mode=2D&site=NULL&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&monitorSkin="+monitor_Skin+"&msmt_host="+msmtHost+"&gtype=1&starthr="+startHour+"&test="+test+"&info="+EgURLEncoder.encode(info,"UTF-8")+"&layer="+layerName+"&endtime="+endTime+"&endhr="+endHour+"&showRange=Range&gformat=graph&width="+ddGraphWidth+"&height="+ddGraphHeight+"&threshold=no"+"&noOfInfosToDisplay="+showTop;
							
							if(showMultipleInfo)
							{
								measureGraphUrl="/final/servlet/com.egurkha.monitor.DashboardTimelineMeasur	es?endtime="+endTime+"&port=NULL&site=NULL&sid=&starttime="+startTime+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&measure="+measureForDB+"&real_measure="+measure+"&newWindow=true&test="+test+"&layer="+layerName+"&comptype="+compType+"&from=MonitorDashboard&endhr="+endHour+"&gtype=1&mode=2D&starthr="+startHour+"&msmt_host="+msmtHost+"&gformat=graph&monitorSkin="+monitor_Skin+"&width="+ddGraphWidth+"&height="+ddGraphHeight+"&legends=true&title=false&priority=TOP+-+3&info="+EgURLEncoder.encode(info,"UTF-8")+"&threshold=no"+"&noOfInfosToDisplay="+showTop;
							}
						}
						
						java.util.Date startDateForFullview=new java.util.Date();
						startDateForFullview.setDate(new java.util.Date().getDate()-1);

						String startTimeForFullView="";
						try
						{
							startTimeForFullView=sf.format(startDateForFullview);
							endTime=sf.format(endDate);
						}
						catch(Exception ex)
						{
							System.out.println("Exception...."+ex);
						}

						int numberOfInfo=0;

						if(info!=null)
						{
							StringTokenizer infoTokens=new StringTokenizer(info,",");
							numberOfInfo=infoTokens.countTokens();
						}
						
						String urlForMaximize="";
						if(isBarChart)
						{
							urlForMaximize="/final/servlet/com.egurkha.monitor.DDTopview?host="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&test="+test+"&measure="+measureForDB+"&real_measure="+measure+"&module=System&width=880&height=320&from=fullview&mode=3D&graphdisplay=defaultView&fullview=true&monitorSkin="+monitor_Skin+"&msmt_host="+msmtHost+"&port="+portNo+"&isFromAnalysis=true&layer="+layerName+"&starttime="+startTime+"&starthr="+startHour+"&endtime="+endTime+"&endhr="+endHour+"&time_line=1+hour&displayName="+display_name+"&isTimeout="+isTimeout+"&priority=ALL&display=false"+"&applyFusion="+isApplyFusion;
							if(subsystem!=null && subsystem.equalsIgnoreCase("OutsideView"))
							{
								urlForMaximize=urlForMaximize+"&info="+s_info+"&isInfoSelected=true";
							}
						}
						else
						{
							urlForMaximize="/final/servlet/com.egurkha.monitor.DashboardTimelineMeasures?measure="+measureForDB+"&real_measure="+measure+"&state="+state+"&starttime="+startTime+"&port="+portNo+"&comptype="+compType+"&mode=3D&site=NULL&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&monitorSkin="+monitor_Skin+"&msmt_host="+msmtHost+"&gtype=1&starthr="+startHour+"&test="+test+"&info="+EgURLEncoder.encode(info,"UTF-8")+"&layer="+layerName+"&endtime="+endTime+"&endhr="+endHour+"&showRange=Range&gformat=graph&fromDashboard=true&timeLine=1+hour&width=880&height=320&priority=ALL&threshold=no&title=true&minmaxavgRequired=true&display=true&time_line=1+hour";

							if(showMultipleInfo)
							{
								urlForMaximize="/final/servlet/com.egurkha.monitor.DashboardTimelineMeasures?endtime="+endTime+"&port=NULL&site=NULL&sid=&starttime="+startTime+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&measure="+measureForDB+"&real_measure="+measure+"&newWindow=true&test="+test+"&layer="+layerName+"&comptype="+compType+"&from=MonitorDashboard&endhr="+endHour+"&gtype=1&mode=3D&starthr="+startHour+"&msmt_host="+msmtHost+"&gformat=graph&monitorSkin="+monitor_Skin+"&width=880&height=320&legends=true&fromDashboard=true&title=true&priority=ALL&threshold=no&minmaxavgRequired=true&info="+EgURLEncoder.encode(info,"UTF-8")+"&display=true&time_line=1+hour";
							}
						}


						if(subsystem!=null && (subsystem.equalsIgnoreCase("Analysis") && (graphType.equalsIgnoreCase("CPU") || graphType.equalsIgnoreCase("Memory") || graphType.equalsIgnoreCase("Disk"))) || (subsystem.equalsIgnoreCase("OutsideView")))
						{
							if(isBarChart)
							{
								if(isApplyFusion)
								{
									measureGraphobj.put("measuregraphURL",measureGraphUrl);
									measureGraphobj.put("measureGraphMaximizeURL",urlForMaximize);
									measureGraphobj.put("grpId","graphImg"+i);
									hiddenFields.put("measureGraphMaximizeURL",urlForMaximize);
								}
								else
								{
									
									String tline = "1 hour";
									String ctline = chartTimeline;
									String tmp_start_time = startTime+" "+startHour+":00:00";
									String tmp_end_time =  endTime+" "+endHour+":00:00";
									chartOption = HighChartTimeline.getChartOption(tline,currentDateFormat,tmp_start_time,tmp_end_time);

									measureGraphobj.put("measuregraphURL",measureGraphUrl);
									measureGraphobj.put("grpId","graphImg"+i);
									measureGraphobj.put("chartOption",chartOption);
									measureGraphobj.put("measureGraphMaximizeURL",urlForMaximize);
								}
							}
							else
							{
								
								String tline = "1 hour";
								String ctline = chartTimeline;
								String tmp_start_time = startTime+" "+startHour+":00:00";
								String tmp_end_time =  endTime+" "+endHour+":00:00";
								chartOption = HighChartTimeline.getChartOption(tline,currentDateFormat,tmp_start_time,tmp_end_time);

								measureGraphobj.put("measuregraphURL",measureGraphUrl);
								measureGraphobj.put("grpId","graphImg"+i);
								measureGraphobj.put("chartOption",chartOption);
								measureGraphobj.put("measureGraphMaximizeURL",urlForMaximize);
							}
						}
						allGraphdataArray.add(measureGraphobj);

					} //starts at 2631
					boolean flage=true;
					if(numColums%3==2)
					{
						JSONObject virtualMiddlePanel = new JSONObject();
						flage=false;
						if((i+1==totalGraph))
						{
							String analysisData=iniObj.getValue(analysis_Subject,compType+"_DATA");
							EgTesterInfo tt = new EgTesterInfo("manager");
							EgAgentInfo agentInfo = new EgAgentInfo("manager");
							ArrayList DDEnabledList=tt.DefaultDDEnabledTypes();
							ArrayList DDEnabledTestList=tt.DefaultDDEnabledTests();
							boolean isAgentlessServer=agentInfo.isAgentlessServer(hostName,compType);
							
							Hashtable analysis_data_hash=new Hashtable();
							int hash_count=0;
							int count=0;
							Vector sortedkeys=new Vector();
							String sortByMeasure=request.getParameter("sortbyMeasure");
							sortByMeasure=(sortByMeasure==null)?"":sortByMeasure;
							int sortByMeasure_width=0;
							if(analysisData!=null && analysisData.trim().length()>0)
							{
								StringTokenizer test_with_measure=new StringTokenizer(analysisData,",");
								int total_count=test_with_measure.countTokens();

								ArrayList all_info_list=new ArrayList();
								Hashtable for_port=new Hashtable();
								Hashtable for_msmtHost=new Hashtable();
								while(test_with_measure.hasMoreTokens())
								{
									String token=test_with_measure.nextToken();
									if(token!=null && token.indexOf(":")!=-1)
									{
										if(sortByMeasure!=null && sortByMeasure.trim().length()==0)
										{
											sortByMeasure=token;
										}
										String test_only=token.substring(0,token.indexOf(":"));
										String measure_only=token.substring(token.indexOf(":")+1);
										String measureForDB=dbInfo.getColumnForMeasure(test_only,measure_only);
										String msmtHost="";

										String display_name_for_length=mappingInfo.getMeasureDescription(test_only,measure_only);
										int temp_length=0;
										if(display_name_for_length!=null)
											temp_length=display_name_for_length.trim().length();
										if(sortByMeasure_width==0)
											sortByMeasure_width=temp_length;
										else
										{
											if(display_name_for_length!=null && temp_length>0 && sortByMeasure_width<temp_length)
											{
												sortByMeasure_width=temp_length;
											}
										}

										boolean portReleventForTest = false;
										boolean siteReleventForTest = false;
										boolean infoReleventForTest = false;
										boolean isTestRelevantForServer = false;
										
										if(test_only!=null)
										{
											portReleventForTest = specsInfo.isPortRelevantForTest(test_only);
											isTestRelevantForServer = specsInfo.isTestRelevantForServer(compType,test_only);
										}

										if(!portReleventForTest)
										{
											portNo="NULL";
										}
										List agents=egExternalInfo.getAgentsFor(test_only,compType,hostName);
										if(agents!=null && agents.size()>0)
											msmtHost=(String)agents.get(0);
										else
											msmtHost=hostName;
										
										for_port.put(token,portNo);
										for_msmtHost.put(token,msmtHost);
										
										Vector allInfos=new Vector();
										if(allInfoForAllTest!=null && allInfoForAllTest.size()>0)
											allInfos=(Vector)allInfoForAllTest.get(test_only);
										String info_for_timeout="";
										StringBuffer temp_bef=new StringBuffer();
										if(allInfos!=null && allInfos.size()>0)
										{
											if(allInfos.size()==1)
											{
												String infoFormeasure=(String)allInfos.get(0);
												if(infoFormeasure!=null && infoFormeasure.trim().length()>0)
												{
													temp_bef.append(",");
													temp_bef.append(infoFormeasure);
													temp_bef.append("");
												}
											}
											else
											{
												for(int infoCount=0;infoCount<allInfos.size();infoCount++)
												{
													String infoFormeasure=(String)allInfos.get(infoCount);
													if(infoFormeasure!=null && infoFormeasure.trim().length()>0)
													{
														temp_bef.append(",'");
														temp_bef.append(infoFormeasure);
														temp_bef.append("'");
													}
												}
											}
										}
										info_for_timeout=temp_bef.toString();

										if(info_for_timeout!=null && info_for_timeout.startsWith(","))
										{
											info_for_timeout=info_for_timeout.substring(1);
										}

										if(subsystem!=null && subsystem.equalsIgnoreCase("OutsideView"))
										{
											info_for_timeout="+"+s_info;
										}

										if(sid!=null && !sid.equals(""))
										{
											info_for_timeout=com.egurkha.util.StringUtils.replace(info_for_timeout,"+","");
											info_for_timeout=sid+"*"+info_for_timeout;
										}
										else
											info_for_timeout=com.egurkha.util.StringUtils.replace(info_for_timeout,"+","|plus|");

										String lastRuntime=null;
										if(measureLastTimeForAllTest!=null && measureLastTimeForAllTest.size()>0)
											lastRuntime=(String)measureLastTimeForAllTest.get(test_only+"^"+hostName);
										boolean isTimeout=false;
										//Added by Chandrasekhar toget Cut of Factor value from eg_services.ini...
										String cut_off_factor_value = null;
										
										if(test_only!=null)
											cut_off_factor_value = trans_services_ini.getStrValue("CUT_OFF_FACTOR", test_only);
										if(cut_off_factor_value==null || cut_off_factor_value.trim().length()==0)
										{
											cut_off_factor_value = trans_services_ini.getStrValue("CUT_OFF_FACTOR", "Default");
										}
										//ended here.....
										System.out.println("lastRuntime====================>"+lastRuntime);
										if(cut_off_factor_value!=null && !cut_off_factor_value.trim().equals("-1") && lastRuntime!=null && lastRuntime.trim().length()>0 &&  cut_off_factor_value.trim().length()>0)
										{
											String compName_for_timeout=compName;
											if(!portReleventForTest)
											{
												if (compName!=null && compName.indexOf(":")>-1)
												{
													compName_for_timeout=compName.substring(0,compName.indexOf(":"));
												}
											}
											isTimeout=MeasuresDao.isTimeOut(lastRuntime,test_only+"#"+msmtHost,compName_for_timeout,compType);
										}
										Hashtable analysis_data_1=new Hashtable();
										if(isTestRelevantForServer && !isTimeout)
										{
											if(subsystem!=null && subsystem.equalsIgnoreCase("OutsideView"))
											{
												analysis_data_1=dashboardDAO.getCurrentAnalysisStatus (compName,compType,portNo,null,test_only,measureForDB,msmtHost,null,null,null,null,null,null,null,true,s_info);
											}
											else
											{
												analysis_data_1=dashboardDAO.getCurrentAnalysisStatus (compName,compType,portNo,null,test_only,measureForDB,msmtHost,null,null,null,null,null,null,null,true);
											}
										}
										
										if(analysis_data_1!=null && analysis_data_1.size()>0)
										{
											if(sortByMeasure!=null && sortByMeasure.equalsIgnoreCase(token))
											{
												EgDashBoardModel dashboardsort=new EgDashBoardModel();
												sortedkeys=dashboardsort.getSortedKeys(analysis_data_1);
											}

											analysis_data_hash.put(test_only+":"+measure_only,analysis_data_1);
											Set temp_set=analysis_data_1.keySet();
											Iterator temp=temp_set.iterator();
											while(temp.hasNext())
											{
												String info_value=(String)temp.next();

												if(data_summary_or_total_infos_flage)
												{
													if(info_value!=null && (info_value.equalsIgnoreCase("+Summary") || info_value.equalsIgnoreCase("+Total") || info_value.toLowerCase().endsWith(":summary") || info_value.toLowerCase().endsWith(":total")))
													{
														if(!all_info_list.contains(info_value))
														{
															all_info_list.add(info_value);
														}
													}
												}
												else
												{
													if(!all_info_list.contains(info_value))
													{
														all_info_list.add(info_value);
													}
												}
											}
										}
										else
										{
											analysis_data_hash.put(test_only+":"+measure_only,new Hashtable());
										}
									}
								}//while

								if(subsystem!=null && subsystem.equalsIgnoreCase("OutsideView") && all_info_list!=null && all_info_list.size()>0)
								{
									ArrayList remove_list=new ArrayList();
									for(int k=0;k<all_info_list.size();k++)
									{
										String db_info=(String)all_info_list.get(k);
										if(db_info!=null && db_info.indexOf(":")>-1)
										{
											String info_substring=db_info.substring(0,db_info.indexOf(":"));

											if(info_substring!=null && s_info!=null && !s_info.equalsIgnoreCase(info_substring))
											{
												remove_list.add(db_info);
											}
										}
										else
										{
											if(db_info!=null && s_info!=null && !s_info.equalsIgnoreCase(db_info))
											{
												remove_list.add(db_info);
											}
										}
									}

									if(remove_list!=null && remove_list.size()>0)
									{
										all_info_list.removeAll(remove_list);
										sortedkeys.removeAll(remove_list);
									}
								}
								JSONObject vmdetailsTable = new JSONObject();
								vmdetailsTable.put("Title",mappingInfo.getTextDescription("monitor.dashboard.Details of VMs"));

								if(all_info_list!=null && all_info_list.size()>0)
								{
									ArrayList all_info_list_temp=new ArrayList();
									if(analysis_data_hash!=null && analysis_data_hash.size()>0)
									{
										if(sortedkeys!=null && sortedkeys.size()>0)
										{
											all_info_list_temp.addAll(sortedkeys);
										}

										for(int k=0;k<all_info_list.size();k++)
										{
											String db_info=(String)all_info_list.get(k);
											if(!all_info_list_temp.contains(db_info))
												all_info_list_temp.add(db_info);
										}
									}
									if(all_info_list_temp!=null && all_info_list_temp.size()>0)
									{
										all_info_list=new ArrayList();
										all_info_list.addAll(all_info_list_temp);
									}
									JSONObject firstColumn = new JSONObject();
									firstColumn.put("measure",mappingInfo.getTextDescription("monitor.dashboard.Virtual Machines"));
									firstColumn.put("dataIndex","info");

									test_with_measure=new StringTokenizer(analysisData,",");
									total_count=test_with_measure.countTokens();
									JSONArray vmtableArray = new JSONArray();
									vmtableArray.add(firstColumn);
									int columncustom_i=0;
									while(test_with_measure.hasMoreTokens())
									{
										JSONObject vmtablecolumns = new JSONObject();
										String token=test_with_measure.nextToken();
										String test_only="";
										String measure_only="";
										if(token!=null && token.indexOf(":")!=-1)
										{
											test_only=token.substring(0,token.indexOf(":"));
											measure_only=token.substring(token.indexOf(":")+1);
										}
										
										String unit_for_measure=tablesInfo.getUnitForMeasure(test_only,measure_only);
										if(unit_for_measure!=null && unit_for_measure.equals("MB") && is_convert_MB_to_GB)
										{
											unit_for_measure="GB";
										}

										if(sortByMeasure!=null && sortByMeasure.equalsIgnoreCase(test_only+":"+measure_only))
										{
											String imgurl="/final/monitor/eg_images/arrow_down_black_small.gif";
											String measuretest= test_only+":"+measure_only;
											
											vmtablecolumns.put("subsystem",subsystem);
											vmtablecolumns.put("tab",tab);
											vmtablecolumns.put("measure",mappingInfo.getMeasureDescription(test_only,measure_only));
											vmtablecolumns.put("unitForMeasure",unit_for_measure);
											vmtablecolumns.put("imageURL",imgurl);
											vmtablecolumns.put("dataIndex",columncustom_i+"measValue");

										}
										else
										{
											String measuretest= test_only+":"+measure_only;
											vmtablecolumns.put("subsystem",subsystem);
											vmtablecolumns.put("tab",tab);
											vmtablecolumns.put("measure",mappingInfo.getMeasureDescription(test_only,measure_only));
											vmtablecolumns.put("unitForMeasure",unit_for_measure);
											vmtablecolumns.put("dataIndex",columncustom_i+"measValue");

										}
										vmtableArray.add(vmtablecolumns);
										columncustom_i++;
									}
									vmdetailsTable.put("tableColumns",vmtableArray);
									if(all_info_list!=null && all_info_list.size()>0)
									{
										JSONArray DbInfoArray = new JSONArray();
										
										for(int k=0;k<all_info_list.size();k++)
										{
											String db_info=(String)all_info_list.get(k);
											String temp_str[]=null;
											if(analysis_data_hash!=null && analysis_data_hash.size()>0)
											{
												temp_str=new String[analysis_data_hash.size()];
												Enumeration keys=analysis_data_hash.keys();
												test_with_measure=new StringTokenizer(analysisData,",");
												int cnt=0;
												//while(keys.hasMoreElements())
												while(test_with_measure.hasMoreTokens())
												{
													//String test_with_measure2 = (String)keys.nextElement();
													String test_with_measure2 = test_with_measure.nextToken();
													try
													{
														Hashtable temp_hash=(Hashtable)analysis_data_hash.get(test_with_measure2);
														String info_value=(String)temp_hash.get(db_info);
														if(info_value!=null && info_value.trim().length()>0)
															temp_str[cnt]=info_value;
														else temp_str[cnt]="-";
													}
													catch(Exception e)
													{
														temp_str[cnt]="-";
													}
													finally
													{
														cnt++;
													}
												}
											}

											String comp_name=compName+":"+compType;
											String url_db_info=db_info;
											if(db_info!=null && db_info.indexOf(":")>-1)
											{
												url_db_info=db_info.substring(0,db_info.indexOf(":"));
											}

											JSONObject dbinfoObject = new JSONObject();
											String insideViewURL=response.encodeURL("../monitor/egInsideviewDashboard.jsp?")+"getFor=measure&comp="+EgURLEncoder.encode(compName,"UTF-8")+"&comptype="+compType+"&Layer="+insideview_layer+"&info="+EgURLEncoder.encode(url_db_info,"UTF-8")+"&compName="+EgURLEncoder.encode(comp_name,"UTF-8");
											
											dbinfoObject.put("info",db_info);
											

											if(analysis_data_hash!=null && analysis_data_hash.size()>0)
											{
												Enumeration keys=analysis_data_hash.keys();
												test_with_measure=new StringTokenizer(analysisData,",");
												int j=0;
												//while(keys.hasMoreElements())
												//JSONArray innerdbinfoArray = new JSONArray(); 
												int custom_i=0;
												while(test_with_measure.hasMoreTokens())
												{
													//JSONObject innerdbinfoObject = new JSONObject();
													//String test_with_measure2 = (String)keys.nextElement();
													String test_with_measure2 = test_with_measure.nextToken();
													String test_name="";
													String meas_name="";
													if(test_with_measure2!=null && test_with_measure2.indexOf(":")>0)
													{
														test_name=test_with_measure2.substring(0,test_with_measure2.indexOf(":"));
														meas_name=test_with_measure2.substring(test_with_measure2.indexOf(":")+1);
													}
													
													measures=new Vector();
													for(int kk=0; kk<strVarArr.length; kk++)
													{
														if(strVarArr[kk].startsWith(test_name))
														{
															String meas = strVarArr[kk].substring(strVarArr[kk].indexOf(":")+1,strVarArr[kk].length());
															if(meas!=null && !measures.contains(meas))
															{
																measures.add(meas);
															}
														}
													}
													
													for(int d=0; d<dummyTestArr.length; d++)
													{
														if(dummyTestArr[d].startsWith(test_name))
														{
															String meas = dummyTestArr[d].substring(dummyTestArr[d].indexOf(":")+1,dummyTestArr[d].length());
															if(meas!=null && !measures.contains(meas))
															{
																measures.add(meas);
															}
														}
													}

													String real_db_info=db_info;
													String meas_value=temp_str[j++];
													if(meas_value!=null && meas_value.indexOf("^")>-1)
													{
														real_db_info=meas_value.substring(0,meas_value.lastIndexOf("^"));
														meas_value=meas_value.substring(meas_value.lastIndexOf("^")+1);
													}
													
													if(meas_value!=null && !meas_value.equalsIgnoreCase("Not Available")&&  !meas_value.equalsIgnoreCase("Unknown") && !meas_value.equalsIgnoreCase("UnLimited") && !meas_value.equalsIgnoreCase("Not Applicable") && !meas_value.equalsIgnoreCase("-"))
													{
														int round=4;
														if (meas_value.indexOf(".")==6)
															round=3;
														else if (meas_value.indexOf(".")==7)
															round=2;
														else if (meas_value.indexOf(".")==8)
															round=1;
														else if (meas_value.indexOf(".")>8 || meas_value.indexOf(".")==-1)
															round=0;
														meas_value=erUtils.round(Float.parseFloat(meas_value),round);
													}
													if(meas_value!=null && (meas_value.equalsIgnoreCase("Not Available") || meas_value.equalsIgnoreCase("Not Applicable")))
													{
														meas_value="-";
													}
													if(meas_value==null || meas_value.trim().length()<=0 || meas_value.trim().equalsIgnoreCase("null"))
														meas_value="-";

													String unit=tablesInfo.getUnitForMeasure(test_name,meas_name);
													int width_for_td=100;
													if(unit!=null && unit.equals("%"))
													{
														if(meas_value!=null && meas_value.trim().length()>0 && !meas_value.equals("-"))
														{
															int columnWidth = 100;
															Long temp_measure_value=new Long(Math.round(Double.parseDouble(meas_value)));
															long fillColorValue=temp_measure_value.longValue();
															long value1 = (fillColorValue*100)/columnWidth;
															width_for_td=40;
															dbinfoObject.put(custom_i+"width",value1);

														}

														if(!meas_value.equalsIgnoreCase("-") && measures.contains(meas_name) && (isAgentlessServer || specsInfo.isTestExternal(test_name) || DDEnabledTestList.contains(compType+":"+test_name) || DDEnabledList.contains(compType)))
														{
															String windowName = session.getId() + "DIAGNOSIS";
															String port_no=(String)for_port.get(test_with_measure2);
															String msmt_host=(String)for_msmtHost.get(test_with_measure2);
															String commTestDD = trans. getStrValue("COMMON_DDTEST_MAPPING", test_name+":"+meas_name);
															if(commTestDD!=null && commTestDD.length() > 0)
															{
																test_name = commTestDD.substring(0,commTestDD.indexOf(":"));
																meas_name = commTestDD.substring(commTestDD.indexOf(":")+1);
															}
															if(real_db_info!=null && real_db_info.equals("NONE"))
																real_db_info="+";
															if(real_db_info!=null)
															{
																int indexInfo = real_db_info.indexOf("*");
																if(indexInfo  >  -1)
																{
																	StringBuffer sb = new StringBuffer(real_db_info);
																	sb.setCharAt(indexInfo, '+');
																	real_db_info = sb.toString();
																}
															}

															String tempInfoForDD=real_db_info;
															boolean isPortRelForTest = specsInfo.isPortRelevantForTest(test_name);
															if(!isPortRelForTest && real_db_info!=null && real_db_info.trim().length()>0 && real_db_info .indexOf("+")>-1 && !real_db_info.startsWith("+"))
															{
																tempInfoForDD=real_db_info.substring(real_db_info .indexOf("+"));
															}
												
															if(siteName!=null&&siteName.equals("null"))
																siteName="NULL";
															boolean showDDIcon = dd.ShowDDData(siteName,hostName,test_name,meas_name,"+"+tempInfoForDD,msmt_host);
															if(showDDIcon)
															{
																
																//JSONObject innerdbinfoObject = new JSONObject();
																String ddQs="/final/monitor/EgDiagnosis.jsp?site=NULL&comptype="+EgURLEncoder.encode(compType,"UTF-8")+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&port="+port_no+"&test="+test_name+"&info=*"+EgURLEncoder.encode(real_db_info,"UTF-8")+"&msmt_host="+EgURLEncoder.encode(msmt_host,"UTF-8")+"&from=0&measure="+meas_name+"&firsttime=true&flag=0&fromPage=alarm&newWindow=true";

																dbinfoObject.put(custom_i+"measValue",dbInfo.formatValue(meas_value));
																dbinfoObject.put("URL",ddQs);
																dbinfoObject.put("windowName",windowName);
																dbinfoObject.put("ImageURL","/final/monitor/eg_images/Diagnosis-o.gif");
																dbinfoObject.put("title",mappingInfo.getTextDescription("monitor.common.DIAGNOSIS"));

															}
															else
															{
																//JSONObject innerdbinfoObject = new JSONObject();
																dbinfoObject.put(custom_i+"measValue",dbInfo.formatValue(meas_value));
																

															}
														}
														else
														{
															if(!meas_value.equalsIgnoreCase("-"))
															{
																dbinfoObject.put(custom_i+"measValue",dbInfo.formatValue(meas_value));
																					//out.println(dbInfo.formatValue(meas_value));
															}
															else
															{
																dbinfoObject.put(custom_i+"measValue",meas_value);
																					//out.println(meas_value);
															}
														}

													}
													else
													{
														if(meas_value!=null && !meas_value.equalsIgnoreCase("-"))
														{
															try
															{
																if(unit!=null && unit.equals("MB") && is_convert_MB_to_GB)
																{
																	double fillColorValue=Double.parseDouble(meas_value);
																	fillColorValue=fillColorValue/1024.0;
																	meas_value=String.valueOf(fillColorValue);
																}
															}
															catch(Exception e)
															{
																meas_value=meas_value;
															}

															try
															{
																meas_value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(meas_value),2));
															}
															catch(Exception ee)
															{
																meas_value=meas_value;
															}
														}

														if(!meas_value.equalsIgnoreCase("-") && measures.contains(meas_name) && (isAgentlessServer || specsInfo.isTestExternal(test_name) || DDEnabledTestList.contains(compType+":"+test_name) || DDEnabledList.contains(compType)))
														{
															String windowName = session.getId() + "DIAGNOSIS";
															String port_no=(String)for_port.get(test_with_measure2);
															String msmt_host=(String)for_msmtHost.get(test_with_measure2);
															String commTestDD = trans. getStrValue("COMMON_DDTEST_MAPPING", test_name+":"+meas_name);
															if(commTestDD!=null && commTestDD.length() > 0)
															{
																test_name = commTestDD.substring(0,commTestDD.indexOf(":"));
																meas_name = commTestDD.substring(commTestDD.indexOf(":")+1);
															}
															if(real_db_info!=null && real_db_info.equals("NONE"))
																real_db_info="+";
															if(real_db_info!=null)
															{
																int indexInfo = real_db_info.indexOf("*");
																if(indexInfo  >  -1)
																{
																	StringBuffer sb = new StringBuffer(real_db_info);
																	sb.setCharAt(indexInfo, '+');
																	real_db_info = sb.toString();
																}
															}

															String tempInfoForDD=real_db_info;
															boolean isPortRelForTest = specsInfo.isPortRelevantForTest(test_name);
															if(!isPortRelForTest && real_db_info!=null && real_db_info.trim().length()>0 && real_db_info .indexOf("+")>-1 && !real_db_info.startsWith("+"))
															{
																tempInfoForDD=real_db_info.substring(real_db_info .indexOf("+"));
															}
												
															if(siteName!=null&&siteName.equals("null"))
																siteName="NULL";
															boolean showDDIcon = dd.ShowDDData(siteName,hostName,test_name,meas_name,"+"+tempInfoForDD,msmt_host);
															if(showDDIcon)
															{
																String ddQs="/final/monitor/EgDiagnosis.jsp?site=NULL&comptype="+EgURLEncoder.encode(compType,"UTF-8")+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&port="+port_no+"&test="+test_name+"&info=*"+EgURLEncoder.encode(real_db_info,"UTF-8")+"&msmt_host="+EgURLEncoder.encode(msmt_host,"UTF-8")+"&from=0&measure="+meas_name+"&firsttime=true&flag=0&fromPage=alarm&newWindow=true";
																
																dbinfoObject.put(custom_i+"measValue",dbInfo.formatValue(meas_value));
																dbinfoObject.put("URL",ddQs);
																dbinfoObject.put("windowName",windowName);
																dbinfoObject.put("imageURL","/final/monitor/eg_images/Diagnosis-o.gif");
																dbinfoObject.put("title",mappingInfo.getTextDescription("monitor.common.DIAGNOSIS"));
																

															}
															else
															{
																dbinfoObject.put(custom_i+"measValue",dbInfo.formatValue(meas_value));

															}
														}
														else
														{
															dbinfoObject.put(custom_i+"measValue",meas_value);
																				//	out.println(meas_value);
														}

													}
													custom_i++;
													//innerdbinfoArray.add(innerdbinfoObject);
												}// ends here while(test_with_measure.hasMoreTokens())
												//DbInfoArray.add(innerdbinfoArray);
												//dbinfoObject.put("values",innerdbinfoArray);
											}
											
											DbInfoArray.add(dbinfoObject);
										}//for ends
										vmdetailsTable.put("tableInfoArray",DbInfoArray);
									}
									else
									{
										vmdetailsTable.put("nodataFound",mappingInfo.getTextDescription("monitor.VirtualDashboard.No Data found"));
										vmdetailsTable.put("imageURL","../monitor/eg_images/"+monitor_Skin+"/icon_exclamation.png");

									}

								}//starts at 3229
								
								else
								{
									vmdetailsTable.put("nodataFound",mappingInfo.getTextDescription("monitor.VirtualDashboard.No Data found"));
									vmdetailsTable.put("imageURL","../monitor/eg_images/"+monitor_Skin+"/icon_exclamation.png");

								}
								//virtualMiddlePanel.put("tablesInfo",vmdetailsTable);
								json.put("tablesInfo",vmdetailsTable);
							}//starts at 3004
						}//starts at 2989
						allGraphdataArray.add(virtualMiddlePanel);
					}//starts at 2986

					numColums++;
					
					if(flage && (i+1==totalGraph))
					{
						JSONObject virtualMiddlePanel = new JSONObject();
						String analysisData=iniObj.getValue(analysis_Subject,compType+"_DATA");
						EgTesterInfo tt = new EgTesterInfo("manager");
						EgAgentInfo agentInfo = new EgAgentInfo("manager");
						ArrayList DDEnabledList=tt.DefaultDDEnabledTypes();
						ArrayList DDEnabledTestList=tt.DefaultDDEnabledTests(); 
						boolean isAgentlessServer=agentInfo.isAgentlessServer(hostName,compType);
						
						Hashtable analysis_data_hash=new Hashtable();
						int hash_count=0;
						int count=0;
						Vector sortedkeys=new Vector();
						String sortByMeasure=request.getParameter("sortbyMeasure");
						sortByMeasure=(sortByMeasure==null)?"":sortByMeasure;
						int sortByMeasure_width=0;
						if(analysisData!=null && analysisData.trim().length()>0)
						{
							JSONObject vmtableDetails = new JSONObject();
							
							StringTokenizer test_with_measure=new StringTokenizer(analysisData,",");
							int total_count=test_with_measure.countTokens();
							ArrayList all_info_list=new ArrayList();
							Hashtable for_port=new Hashtable();
							Hashtable for_msmtHost=new Hashtable();
							while(test_with_measure.hasMoreTokens())
							{
								String token=test_with_measure.nextToken();
								if(token!=null && token.indexOf(":")!=-1)
								{
									if(sortByMeasure!=null && sortByMeasure.trim().length()==0)
									{
										sortByMeasure=token;
									}
									String test_only=token.substring(0,token.indexOf(":"));
									String measure_only=token.substring(token.indexOf(":")+1);
									String measureForDB=dbInfo.getColumnForMeasure(test_only,measure_only);
									String msmtHost="";

									String display_name_for_length=mappingInfo.getMeasureDescription(test_only,measure_only);
									int temp_length=0;
									if(display_name_for_length!=null)
										temp_length=display_name_for_length.trim().length();
									if(sortByMeasure_width==0)
										sortByMeasure_width=temp_length;
									else
									{
										if(display_name_for_length!=null && temp_length>0 && sortByMeasure_width<temp_length)
										{
											sortByMeasure_width=temp_length;
										}
									}

									boolean portReleventForTest = false;
									boolean siteReleventForTest = false;
									boolean infoReleventForTest = false;
									boolean isTestRelevantForServer = false;
									
									if(test_only!=null)
									{
										portReleventForTest = specsInfo.isPortRelevantForTest(test_only);
										isTestRelevantForServer = specsInfo.isTestRelevantForServer(compType,test_only);
									}

									if(!portReleventForTest)
									{
										portNo="NULL";
									}
									List agents=egExternalInfo.getAgentsFor(test_only,compType,hostName);
									if(agents!=null && agents.size()>0)
										msmtHost=(String)agents.get(0);
									else
										msmtHost=hostName;
									
									for_port.put(token,portNo);
									for_msmtHost.put(token,msmtHost);

									Vector allInfos=new Vector();
									if(allInfoForAllTest!=null && allInfoForAllTest.size()>0)
										allInfos=(Vector)allInfoForAllTest.get(test_only);
									String info_for_timeout="";
									StringBuffer temp_bef=new StringBuffer();
									if(allInfos!=null && allInfos.size()>0)
									{
										if(allInfos.size()==1)
										{
											String infoFormeasure=(String)allInfos.get(0);
											if(infoFormeasure!=null && infoFormeasure.trim().length()>0)
											{
												temp_bef.append(",");
												temp_bef.append(infoFormeasure);
												temp_bef.append("");
											}
										}
										else
										{
											for(int infoCount=0;infoCount<allInfos.size();infoCount++)
											{
												String infoFormeasure=(String)allInfos.get(infoCount);
												if(infoFormeasure!=null && infoFormeasure.trim().length()>0)
												{
													temp_bef.append(",'");
													temp_bef.append(infoFormeasure);
													temp_bef.append("'");
												}
											}
										}
									}
									info_for_timeout=temp_bef.toString();

									if(info_for_timeout!=null && info_for_timeout.startsWith(","))
									{
										info_for_timeout=info_for_timeout.substring(1);
									}

									if(subsystem!=null && subsystem.equalsIgnoreCase("OutsideView"))
									{
										info_for_timeout="+"+s_info;
									}
									if(sid!=null && !sid.equals(""))
									{
										info_for_timeout=com.egurkha.util.StringUtils.replace(info_for_timeout,"+","");
										info_for_timeout=sid+"*"+info_for_timeout;
									}
									else
										info_for_timeout=com.egurkha.util.StringUtils.replace(info_for_timeout,"+","|plus|");

									String lastRuntime=null;
									if(measureLastTimeForAllTest!=null && measureLastTimeForAllTest.size()>0)
										lastRuntime=(String)measureLastTimeForAllTest.get(test_only+"^"+hostName);
									boolean isTimeout=false;
									//Added by Chandrasekhar toget Cut of Factor value from eg_services.ini...
									String cut_off_factor_value = null;
									if(test_only!=null)
										cut_off_factor_value = trans_services_ini.getStrValue("CUT_OFF_FACTOR", test_only);
									if(cut_off_factor_value==null || cut_off_factor_value.trim().length()==0)
									{
										cut_off_factor_value = trans_services_ini.getStrValue("CUT_OFF_FACTOR", "Default");
									}
									//ended here....
									System.out.println("lastRuntime====================>"+lastRuntime);
									if(cut_off_factor_value!=null && !cut_off_factor_value.trim().equals("-1") && lastRuntime!=null && lastRuntime.trim().length()>0 &&  cut_off_factor_value.trim().length()>0)
									{
										String compName_for_timeout=compName;
										if(!portReleventForTest)
										{
											if (compName!=null && compName.indexOf(":")>-1)
											{
												compName_for_timeout=compName.substring(0,compName.indexOf(":"));
											}
										}
										isTimeout=MeasuresDao.isTimeOut(lastRuntime,test_only+"#"+msmtHost,compName_for_timeout,compType);
									}
									Hashtable analysis_data_1=new Hashtable();
									if(isTestRelevantForServer && !isTimeout)
									{
										if(subsystem!=null && subsystem.equalsIgnoreCase("OutsideView"))
										{
											analysis_data_1=dashboardDAO.getCurrentAnalysisStatus (compName,compType,portNo,null,test_only,measureForDB,msmtHost,null,null,null,null,null,null,null,true,s_info);
										}
										else
										{
											analysis_data_1=dashboardDAO.getCurrentAnalysisStatus (compName,compType,portNo,null,test_only,measureForDB,msmtHost,null,null,null,null,null,null,null,true);
										}
									}
									
									if(analysis_data_1!=null && analysis_data_1.size()>0)
									{
										if(sortByMeasure!=null && sortByMeasure.equalsIgnoreCase(token))
										{
											EgDashBoardModel dashboardsort=new EgDashBoardModel();
											sortedkeys=dashboardsort.getSortedKeys(analysis_data_1);
										}
										analysis_data_hash.put(test_only+":"+measure_only,analysis_data_1);
										Set temp_set=analysis_data_1.keySet();
										Iterator temp=temp_set.iterator();
										while(temp.hasNext())
										{
											String info_value=(String)temp.next();
											if(data_summary_or_total_infos_flage)
											{
												if(info_value!=null && (info_value.equalsIgnoreCase("+Summary") || info_value.equalsIgnoreCase("+Total") || info_value.toLowerCase().endsWith(":summary") || info_value.toLowerCase().endsWith(":total")))
												{
													if(!all_info_list.contains(info_value))
													{
														all_info_list.add(info_value);
													}
												}
											}
											else
											{
												if(!all_info_list.contains(info_value))
												{
													all_info_list.add(info_value);
												}
											}
										}
									}
									else
									{
										analysis_data_hash.put(test_only+":"+measure_only,new Hashtable());
									}
								}
							}

							if(subsystem!=null && subsystem.equalsIgnoreCase("OutsideView") && all_info_list!=null && all_info_list.size()>0)
							{
								ArrayList remove_list=new ArrayList();
								for(int k=0;k<all_info_list.size();k++)
								{
									String db_info=(String)all_info_list.get(k);
									if(db_info!=null && db_info.indexOf(":")>-1)
									{
										String info_substring=db_info.substring(0,db_info.indexOf(":"));

										if(info_substring!=null && s_info!=null && !s_info.equalsIgnoreCase(info_substring))
										{
											remove_list.add(db_info);
										}
									}
									else
									{
										if(db_info!=null && s_info!=null && !s_info.equalsIgnoreCase(db_info))
										{
											remove_list.add(db_info);
										}
									}
								}

								if(remove_list!=null && remove_list.size()>0)
								{
									all_info_list.removeAll(remove_list);
									sortedkeys.removeAll(remove_list);
								}
							}

							if((numColums%3)==2)
							{

							}
							vmtableDetails.put("Title",mappingInfo.getTextDescription("monitor.dashboard.Details of VMs"));

							if(all_info_list!=null && all_info_list.size()>0)
							{
								ArrayList all_info_list_temp=new ArrayList();
								if(analysis_data_hash!=null && analysis_data_hash.size()>0)
								{
									if(sortedkeys!=null && sortedkeys.size()>0)
									{
										all_info_list_temp.addAll(sortedkeys);
									}

									for(int k=0;k<all_info_list.size();k++)
									{
										String db_info=(String)all_info_list.get(k);
										if(!all_info_list_temp.contains(db_info))
											all_info_list_temp.add(db_info);
									}
								}
								if(all_info_list_temp!=null && all_info_list_temp.size()>0)
								{
									all_info_list=new ArrayList();
									all_info_list.addAll(all_info_list_temp);
								}
								JSONObject firstColumn =new JSONObject();
								firstColumn.put("measure",mappingInfo.getTextDescription("monitor.dashboard.Virtual Machines"));
								firstColumn.put("dataIndex","info");
								
								test_with_measure=new StringTokenizer(analysisData,",");
								total_count=test_with_measure.countTokens();
								
								JSONArray tableColumnArray = new JSONArray();
								tableColumnArray.add(firstColumn);
								int customcolumn_i=0;
								while(test_with_measure.hasMoreTokens())
								{
									JSONObject tableColumns = new JSONObject();
									String token=test_with_measure.nextToken();
									String test_only="";
									String measure_only="";
									if(token!=null && token.indexOf(":")!=-1)
									{
										test_only=token.substring(0,token.indexOf(":"));
										measure_only=token.substring(token.indexOf(":")+1);
									}

									String unit_for_measure=tablesInfo.getUnitForMeasure(test_only,measure_only);
									if(unit_for_measure!=null && unit_for_measure.equals("MB") && is_convert_MB_to_GB)
									{
										unit_for_measure="GB";
									}

									if(sortByMeasure!=null && sortByMeasure.equalsIgnoreCase(test_only+":"+measure_only))
									{
										String imgurl="/final/monitor/eg_images/arrow_down_black_small.gif";
										String measuretest= test_only+":"+measure_only;
										
										tableColumns.put("subsystem",subsystem);
										tableColumns.put("tab",tab);
										tableColumns.put("measure",mappingInfo.getMeasureDescription(test_only,measure_only));
										tableColumns.put("unitForMeasure",unit_for_measure);
										tableColumns.put("imageURL",imgurl);
										tableColumns.put("dataIndex",customcolumn_i+"measValue");

									}
									else
									{
										String measuretest= test_only+":"+measure_only;
										tableColumns.put("subsystem",subsystem);
										tableColumns.put("tab",tab);
										tableColumns.put("measure",mappingInfo.getMeasureDescription(test_only,measure_only));
										tableColumns.put("unitForMeasure",unit_for_measure);
										tableColumns.put("dataIndex",customcolumn_i+"measValue");
										
									}
									tableColumnArray.add(tableColumns);
									customcolumn_i++;
								}
								vmtableDetails.put("tableColumns",tableColumnArray);

								if(all_info_list!=null && all_info_list.size()>0)
								{
									JSONArray dbinfoArray = new JSONArray();
									for(int k=0;k<all_info_list.size();k++)
									{
										String db_info=(String)all_info_list.get(k);

										String temp_str[]=null;
										if(analysis_data_hash!=null && analysis_data_hash.size()>0)
										{
											temp_str=new String[analysis_data_hash.size()];
											Enumeration keys=analysis_data_hash.keys();
											test_with_measure=new StringTokenizer(analysisData,",");
											int cnt=0;
											//while(keys.hasMoreElements())
											while(test_with_measure.hasMoreTokens())
											{
												//String test_with_measure2 = (String)keys.nextElement();
												String test_with_measure2 =test_with_measure.nextToken();
												try
												{
													Hashtable temp_hash=(Hashtable)analysis_data_hash.get(test_with_measure2);
													String info_value=(String)temp_hash.get(db_info);
													if(info_value!=null && info_value.trim().length()>0)
														temp_str[cnt]=info_value;
													else temp_str[cnt]="-";
												}
												catch(Exception e)
												{
													temp_str[cnt]="-";
												}
												finally
												{
													cnt++;
												}
											}
										}
										String comp_name=compName+":"+compType;
										String url_db_info=db_info;
										if(db_info!=null && db_info.indexOf(":")>-1)
										{
											url_db_info=db_info.substring(0,db_info.indexOf(":"));
										}
										String insideViewURL=response.encodeURL("../monitor/egInsideviewDashboard.jsp?")+"getFor=measure&comp="+EgURLEncoder.encode(compName,"UTF-8")+"&comptype="+compType+"&Layer="+insideview_layer+"&info="+EgURLEncoder.encode(url_db_info,"UTF-8")+"&compName="+EgURLEncoder.encode(comp_name,"UTF-8");
										
										JSONObject dbInfoObject = new JSONObject();
										dbInfoObject.put("info",db_info);

										if(analysis_data_hash!=null && analysis_data_hash.size()>0)
										{
											Enumeration keys=analysis_data_hash.keys();
											test_with_measure=new StringTokenizer(analysisData,",");
											int j=0;
											//while(keys.hasMoreElements())
											JSONArray innerdbinfoArray = new JSONArray();
											int custom_i=0;
											while(test_with_measure.hasMoreTokens())
											{
												JSONObject innerdbinfoObject = new JSONObject();
												//String test_with_measure2 = (String)keys.nextElement();
												String test_with_measure2 =test_with_measure.nextToken();
												String test_name="";
												String meas_name="";
												if(test_with_measure2!=null && test_with_measure2.indexOf(":")>0)
												{
													test_name=test_with_measure2.substring(0,test_with_measure2.indexOf(":"));
													meas_name=test_with_measure2.substring(test_with_measure2.indexOf(":")+1);
												}
												String real_db_info=db_info;
												String meas_value=temp_str[j++];
												if(meas_value!=null && meas_value.indexOf("^")>-1)
												{
													real_db_info=meas_value.substring(0,meas_value.lastIndexOf("^"));
													meas_value=meas_value.substring(meas_value.lastIndexOf("^")+1);
												}
												
												if(meas_value!=null && !meas_value.equalsIgnoreCase("Not Available")&&  !meas_value.equalsIgnoreCase("Unknown") && !meas_value.equalsIgnoreCase("UnLimited") && !meas_value.equalsIgnoreCase("Not Applicable") && !meas_value.equalsIgnoreCase("-"))
												{
													int round=4;
													if (meas_value.indexOf(".")==6)
														round=3;
													else if (meas_value.indexOf(".")==7)
														round=2;
													else if (meas_value.indexOf(".")==8)
														round=1;
													else if (meas_value.indexOf(".")>8 || meas_value.indexOf(".")==-1)
														round=0;
													meas_value=erUtils.round(Float.parseFloat(meas_value),round);
												}
												if(meas_value!=null && (meas_value.equalsIgnoreCase("Not Available") || meas_value.equalsIgnoreCase("Not Applicable")))
												{
													meas_value="-";
												}
												if(meas_value==null || meas_value.trim().length()<=0 || meas_value.trim().equalsIgnoreCase("null"))
													meas_value="-";

												measures=new Vector();
												for(int kk=0; kk<strVarArr.length; kk++)
												{
													if(strVarArr[kk].startsWith(test_name))
													{
														String meas = strVarArr[kk].substring(strVarArr[kk].indexOf(":")+1,strVarArr[kk].length());
														if(meas!=null && !measures.contains(meas))
														{
															measures.add(meas);
														}
													}
												}
												
												for(int d=0; d<dummyTestArr.length; d++)
												{
													if(dummyTestArr[d].startsWith(test_name))
													{
														String meas = dummyTestArr[d].substring(dummyTestArr[d].indexOf(":")+1,dummyTestArr[d].length());
														if(meas!=null && !measures.contains(meas))
														{
															measures.add(meas);
														}
													}
												}
												String unit=tablesInfo.getUnitForMeasure(test_name,meas_name);
												int width_for_td=100;
												if(unit!=null && unit.equals("%"))
												{
													if(meas_value!=null && meas_value.trim().length()>0 && !meas_value.equals("-"))
													{
														int columnWidth = 100;
														Long temp_measure_value=new Long(Math.round(Double.parseDouble(meas_value)));
														long fillColorValue=temp_measure_value.longValue();
														long value1 = (fillColorValue*100)/columnWidth;
														width_for_td=40;
														dbInfoObject.put(custom_i+"width",value1);

													}

													if(!meas_value.equalsIgnoreCase("-") && measures.contains(meas_name) && (isAgentlessServer || specsInfo.isTestExternal(test_name) || DDEnabledTestList.contains(compType+":"+test_name) || DDEnabledList.contains(compType)))
													{
														String windowName = session.getId() + "DIAGNOSIS";
														String port_no=(String)for_port.get(test_with_measure2);
														String msmt_host=(String)for_msmtHost.get(test_with_measure2);
														String commTestDD = trans. getStrValue("COMMON_DDTEST_MAPPING", test_name+":"+meas_name);
														if(commTestDD!=null && commTestDD.length() > 0)
														{
															test_name = commTestDD.substring(0,commTestDD.indexOf(":"));
															meas_name = commTestDD.substring(commTestDD.indexOf(":")+1);
														}
														if(real_db_info!=null && real_db_info.equals("NONE"))
															real_db_info="+";
														if(real_db_info!=null)
														{
															int indexInfo = real_db_info.indexOf("*");
															if(indexInfo  >  -1)
															{
																StringBuffer sb = new StringBuffer(real_db_info);
																sb.setCharAt(indexInfo, '+');
																real_db_info = sb.toString();
															}
														}

														String tempInfoForDD=real_db_info;
														boolean isPortRelForTest = specsInfo.isPortRelevantForTest(test_name);
														if(!isPortRelForTest && real_db_info!=null && real_db_info.trim().length()>0 && real_db_info .indexOf("+")>-1 && !real_db_info.startsWith("+"))
														{
															tempInfoForDD=real_db_info.substring(real_db_info .indexOf("+"));
														}
											
														if(siteName!=null&&siteName.equals("null"))
															siteName="NULL";
														boolean showDDIcon = dd.ShowDDData(siteName,hostName,test_name,meas_name,"+"+tempInfoForDD,msmt_host);
														if(showDDIcon)
														{
															String ddQs="/final/monitor/EgDiagnosis.jsp?site=NULL&comptype="+EgURLEncoder.encode(compType,"UTF-8")+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&port="+port_no+"&test="+test_name+"&info=*"+EgURLEncoder.encode(real_db_info,"UTF-8")+"&msmt_host="+EgURLEncoder.encode(msmt_host,"UTF-8")+"&from=0&measure="+meas_name+"&firsttime=true&flag=0&fromPage=alarm&newWindow=true";
															dbInfoObject.put(custom_i+"measValue",dbInfo.formatValue(meas_value));
															dbInfoObject.put("URL",ddQs);
															dbInfoObject.put("windowName",windowName);
															dbInfoObject.put("ImageURL","/final/monitor/eg_images/Diagnosis-o.gif");
															dbInfoObject.put("title",mappingInfo.getTextDescription("monitor.common.DIAGNOSIS"));

														}
														else
														{
															dbInfoObject.put(custom_i+"measValue",dbInfo.formatValue(meas_value));

														}
													}
													else
													{
														dbInfoObject.put(custom_i+"measValue",meas_value);
																				//out.println(meas_value);
													}

												}
												else
												{
													if(meas_value!=null && !meas_value.equalsIgnoreCase("-"))
													{
														try
														{
															if(unit!=null && unit.equals("MB") && is_convert_MB_to_GB)
															{
																double fillColorValue=Double.parseDouble(meas_value);
																fillColorValue=fillColorValue/1024.0;
																meas_value=String.valueOf(fillColorValue);
															}
														}
														catch(Exception e)
														{
															meas_value=meas_value;
														}

														try
														{
															meas_value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(meas_value),2));
														}
														catch(Exception ee)
														{
															meas_value=meas_value;
														}
													}

													if(!meas_value.equalsIgnoreCase("-") && measures.contains(meas_name) && (isAgentlessServer || specsInfo.isTestExternal(test_name) || DDEnabledTestList.contains(compType+":"+test_name) || DDEnabledList.contains(compType)))
													{
														String windowName = session.getId() + "DIAGNOSIS";
														String port_no=(String)for_port.get(test_with_measure2);
														String msmt_host=(String)for_msmtHost.get(test_with_measure2);
														String commTestDD = trans. getStrValue("COMMON_DDTEST_MAPPING", test_name+":"+meas_name);
														if(commTestDD!=null && commTestDD.length() > 0)
														{
															test_name = commTestDD.substring(0,commTestDD.indexOf(":"));
															meas_name = commTestDD.substring(commTestDD.indexOf(":")+1);
														}
														if(real_db_info!=null && real_db_info.equals("NONE"))
															real_db_info="+";
														if(real_db_info!=null)
														{
															int indexInfo = real_db_info.indexOf("*");
															if(indexInfo  >  -1)
															{
																StringBuffer sb = new StringBuffer(real_db_info);
																sb.setCharAt(indexInfo, '+');
																real_db_info = sb.toString();
															}
														}

														String tempInfoForDD=real_db_info;
														boolean isPortRelForTest = specsInfo.isPortRelevantForTest(test_name);
														if(!isPortRelForTest && real_db_info!=null && real_db_info.trim().length()>0 && real_db_info .indexOf("+")>-1 && !real_db_info.startsWith("+"))
														{
															tempInfoForDD=real_db_info.substring(real_db_info .indexOf("+"));
														}
											
														if(siteName!=null&&siteName.equals("null"))
															siteName="NULL";
														boolean showDDIcon = dd.ShowDDData(siteName,hostName,test_name,meas_name,"+"+tempInfoForDD,msmt_host);
														if(showDDIcon)
														{
															String ddQs="/final/monitor/EgDiagnosis.jsp?site=NULL&comptype="+EgURLEncoder.encode(compType,"UTF-8")+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&port="+port_no+"&test="+test_name+"&info=*"+EgURLEncoder.encode(real_db_info,"UTF-8")+"&msmt_host="+EgURLEncoder.encode(msmt_host,"UTF-8")+"&from=0&measure="+meas_name+"&firsttime=true&flag=0&fromPage=alarm&newWindow=true";
															dbInfoObject.put(custom_i+"measValue",dbInfo.formatValue(meas_value));
															dbInfoObject.put("URL",ddQs);
															dbInfoObject.put("windowName",windowName);
															dbInfoObject.put("ImageURL","/final/monitor/eg_images/Diagnosis-o.gif");
															dbInfoObject.put("title",mappingInfo.getTextDescription("monitor.common.DIAGNOSIS"));

														}
														else
														{
															dbInfoObject.put(custom_i+"measValue",dbInfo.formatValue(meas_value));

														}
													}
													else
													{
														dbInfoObject.put(custom_i+"measValue",meas_value);
																					//out.println(meas_value);
													}

												}
												
												//innerdbinfoArray.add(innerdbinfoObject);
												custom_i++;
											}//while ends
											//dbinfoArray.add(innerdbinfoArray);
											//dbInfoObject.put("values",innerdbinfoArray);
											dbinfoArray.add(dbInfoObject);
										}//if ends
										
									}//for
									vmtableDetails.put("tableInfoArray",dbinfoArray);
								}//if() starts at 3938
								else
								{
									vmtableDetails.put("nodataFound",mappingInfo.getTextDescription("monitor.VirtualDashboard.No Data found"));
									vmtableDetails.put("imageURL","../monitor/eg_images/"+monitor_Skin+"/icon_exclamation.png");
									

								}
							}//if() starts at 3877
							else
							{
								vmtableDetails.put("nodataFound",mappingInfo.getTextDescription("monitor.VirtualDashboard.No Data found"));
								vmtableDetails.put("imageURL","../monitor/eg_images/"+monitor_Skin+"/icon_exclamation.png");
							}
							//virtualMiddlePanel.put("tablesInfo",vmtableDetails);
							json.put("tablesInfo",vmtableDetails);
						}// starts at 3641
						allGraphdataArray.add(virtualMiddlePanel);
					}//starts at 3627
				}//for(int i=0;i<totalGraph;i++) starts at 1876
				json.put("graphInfoRoot",allGraphdataArray);
			}//starts at 1875
			else
			{
				JSONObject noData = new JSONObject();
				noData.put("imageURL","/final/monitor/eg_images/"+monitor_Skin+"/icon_exclamation.png");

				if(subsystem!=null && subsystem.equalsIgnoreCase("InsideView"))
				{
					noData.put("errorMessage",mappingInfo.getTextDescription("monitor.vmmeasures.No Measures found for the current selection"));

				}
				else
				{
					noData.put("errorMessage",mappingInfo.getTextDescription("monitor.dashboard.No measures available for configured metrics"));

				}
				json.put("NoDataAvailable",noData);
			}

			if(!isBarOrMeasureView)
			{

				if(request.getQueryString()!=null)
				{
					if(session!=null)
					{
						session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&"+request.getQueryString()+"&comptype="+request.getParameter("compType")+"&host="+EgURLEncoder.encode(request.getParameter("hostName"),"UTF-8")+"&tab=Virtual&toDashBoardLayer=true");
						session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
					}
				}
				else
				{
					if(session!=null)
					{
						session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&tab=Virtual&toDashBoardLayer=true");
						session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
					}
				}
			}
		}//second top most 384
	}//top most 294
	else
	{
		JSONObject noData = new JSONObject();
		noData.put("imageURL","/final/monitor/eg_images/"+monitor_Skin+"/icon_exclamation.png");
		noData.put("errorMessage",mappingInfo.getTextDescription("monitor.dashboard.No Metrics Configured"));
		json.put("NoDataAvailable",noData);
	}
	
	if(showLegStr == null || showLegStr.equals(""))
		showLegStr = egUi.getValue("CHART_TYPE","showLegendsInCharts");

	json.put("LegendInChart",showLegStr.toLowerCase());

	json.put("screenLabels",screenLabels);
	json.put("hiddenFields",hiddenFields);
	response.getWriter().write(json.toString());
}
catch(Throwable ex)
{
	System.out.println("---------Exception in egSystemAnalysis.jsp---");
	ex.printStackTrace();
}
%>
