<!DOCTYPE html>
<%
	/********************************************************************************************
	*
	*
	*
	* Page Description : This is the Parent page for egInsideviewDashboard. According to the tab selection the eg board, egInsideviewDashboard or other child pages will be loaded.
	*				20/12/2011 Sri Devi G User - VM Changes 
	*********************************************************************************************/
%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ include file = "EgLoginTracker.jsp"%>
<%@ page errorPage = "EgProbsM.jsp"%>
<%@ page import = "java.util.*"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.egurkha.monitor.*"%>
<%@ page import="egurkha.reporter.ErUtils"%>
<%@ page import="com.egurkha.monitor.*"%>
<%@ page import="com.egurkha.User"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.eg.EgURLEncoder"%>
<%@ page import="com.eg.EgLastMeasureThread"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	String ua = request.getHeader( "User-Agent" );
	boolean isFirefox = ( ua != null && ua.indexOf( "Firefox/" ) != -1 );
	boolean isMSIE = ( ua != null && ua.indexOf( "MSIE" ) != -1 );
	boolean isIE6=( ua != null && ua.indexOf("MSIE 6.0") != -1 );
%>

<%
try
{
	UserRegistry registry    = UserRegistry.getInstance();
	User user                = registry.getUser(session.getId());
	EgUserRole userRole = EgUserRole.getRoleObject(user.getLoginType());
	ErUtils erUtils=new  ErUtils();
	EgMappingInfo egMappingInfo=new EgMappingInfo(trackerLanguage);
	EgDashBoardDAO  egDAO=new  EgDashBoardDAO();
	EgDashBoardModel  egDashboard=new  EgDashBoardModel();
	egDashboard.setUser(u_ser);
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";

	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	String HostandClusterValue=egUI.getValue("VMDashboard_Display","Hosts&Clusters");
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	String dashboardIni = "eg_dashboard.ini";
	IniFile inifile = new IniFile(s_iniFile_dir + dashboardIni);

	long refreshFrequency = 60 * 1000L;
	String refFreq = u_ser.getRefreshFrequency();

	if(refFreq!=null && refFreq.length()>0)
	{
		refreshFrequency =  Long.valueOf(refFreq).longValue() * 1000L;
	}

	String Qstring="";
	String queryString=request.getQueryString();
	String userSearchParams = queryString; 
	if(queryString!=null)
	{
		StringTokenizer strtok = new StringTokenizer(queryString,"&");
		while(strtok.hasMoreTokens())
		{
			String param = strtok.nextToken();
			int ind = param.indexOf("=");
			if (ind < 0)
				continue;
			String reqparam =param.substring(0,ind);
			String value = param.substring(ind+1);
			if(reqparam.equals("info"))
			{
				value=request.getParameter(reqparam);
				if(value!=null)
				{
					value=com.egurkha.util.StringUtils.replace(value,"\\\\","\\");
					value = EgURLEncoder.encode(value,"UTF-8");
				}
			}
			else if(reqparam.equals("comp"))
			{
				value=request.getParameter(reqparam);
				if(value!=null)
					value = EgURLEncoder.encode(value,"UTF-8");
			}
			else if(reqparam.equals("comptype"))
			{
				value=request.getParameter(reqparam);
				if(value!=null)
					value = EgURLEncoder.encode(value,"UTF-8");
			}
			else if(reqparam.equals("compName"))
			{
				value=request.getParameter(reqparam);
				if(value!=null)
					value = EgURLEncoder.encode(value,"UTF-8");
			}
			else if(reqparam.equals("Layer"))
			{
				value=request.getParameter(reqparam);
				if(value!=null)
					value = EgURLEncoder.encode(value,"UTF-8");
			}
			else if(reqparam.equals("from"))
			{
				value=request.getParameter(reqparam);
			}
			else if(reqparam.equals("isVM"))
			{
				value=request.getParameter(reqparam);
			}
			else if(reqparam.equals("servername"))
			{
				value=request.getParameter(reqparam);
				if(value!=null)
					value = EgURLEncoder.encode(value,"UTF-8");
			}
			else if(reqparam.equals("stateName"))
			{
				value=request.getParameter(reqparam);
			}
			else
			{
				value=request.getParameter(reqparam);
			}
			Qstring=Qstring+reqparam+"="+value+"&";
		}
	}
	String defaultTabUrl=response.encodeURL("../servlet/com.eg.EgMeasureController?")+Qstring+"&resultpage=VmMeasures";

	Vector Tabs=new Vector();
	String defaultTab =request.getParameter("defaultSelectedTab");
	String defaultTabs_in_ini=inifile.getValue("Insideview_Dashboard","defaultTab");
	String tabs_in_ini=inifile.getValue("Insideview_Dashboard","Tabs");
	defaultTab=(defaultTab==null)?defaultTabs_in_ini:defaultTab;
	int index_of_tab=0;
	if(tabs_in_ini!=null && tabs_in_ini.trim().length()>0)
	{
		StringTokenizer tabs_token=new StringTokenizer(tabs_in_ini,",");
		int v=0;
		while(tabs_token.hasMoreTokens())
		{
			String tab_name=tabs_token.nextToken();
			if(tab_name!=null && tab_name.trim().length()>0)
			{
				Tabs.add(tab_name);
				if(tab_name.equalsIgnoreCase(defaultTab))
					index_of_tab=v;
				v++;
			}
		}
	}
	else
	{
		Tabs.add("Measures");
	}

	String comp=request.getParameter("comp");
	if(comp==null)
		comp=request.getParameter("hostName");

	String comptype=request.getParameter("comptype");
	if(comptype==null)
		comptype=request.getParameter("compType");

	String subsystem=request.getParameter("subsystem");
	if(subsystem==null)
		subsystem="Overview";

	String check=request.getParameter("check");
	if(check==null)
		check="";

	String from = request.getParameter("from");
	if(from==null)
		from="";

	String stateName = request.getParameter("stateName");
	if(stateName==null)
		stateName="";

	String componentName=request.getParameter("componentName");
	String info=request.getParameter("info");
	info = com.egurkha.util.StringUtils.replace(info,"\\\\","\\");
	String fromVmSearch = request.getParameter("fromVmSearch");
	String fromThinClients = request.getParameter("fromThinClients");
	String all_comps=null;

	String source = request.getParameter("source");
	String selectedUserView = request.getParameter("userName");//yet to use this if inside view of selected user is requested on admin side.
	boolean isVM = false;
	String s_isVM = request.getParameter("isVM");
	isVM = (new Boolean(s_isVM)).booleanValue();
	String servername = request.getParameter("servername");
	boolean isfromSuper = session.getAttribute("fromSuper") != null &&
	session.getAttribute("fromSuper").toString().equalsIgnoreCase("yes");
	
	List compsForUser = new LinkedList();
	compsForUser = user.getServers(false);
	List userVMs = new LinkedList();
	List userVMServers = new LinkedList();
	boolean onlyVMAssigned = false;
	if(u_ser!=null)
	{
		if(!userRole.hasAllComponentAccess())
		{
			userVMs=u_ser.getOnlyVMs();
			onlyVMAssigned = u_ser.isOnlyVMAssigned();
			if(onlyVMAssigned)
			{
				userVMs=u_ser.getOnlyVMs();
			}
			userVMServers = u_ser.getOnlyVMServers();
		}
	}
	// its no need here, because the info have more then one comp then its handle in JAVA.
	//Vector componentList = egDAO.getComponentsForVM(info);
	//---end----
	Vector componentList =  null;
	all_comps = "";
	if(componentList!=null && componentList.size()>0)
	{
		for(int ii=0; ii<componentList.size(); ii++)
		{
			String host_name = (String) componentList.get(ii);
			host_name = host_name.substring(host_name.indexOf(":")+1);
			if(compsForUser!=null && compsForUser.size()>0)
			{
				for (int j=0;j<compsForUser.size();j++)
				{
					String temp_comp = (String)compsForUser.get(j);
					String temp_compType = temp_comp.substring(0,temp_comp.indexOf(":"));
					String temp_compName  = temp_comp.substring(temp_comp.indexOf(":")+1,temp_comp.lastIndexOf(":"));

					if(host_name.equals(temp_compName) && comptype.equals(temp_compType))
						all_comps = all_comps + host_name + ",";
				}
			}
		}
	}
	if(all_comps!=null && all_comps!="")
	{
		all_comps = all_comps.substring(0,all_comps.length()-1);
	}
	String layer_name=request.getParameter("Layer");
	String comp_name=comp+":"+comptype;
	
	Vector aList_info=new Vector();
	Vector aList_infoState=new Vector();
	Hashtable ht_infosearch=new Hashtable();
	VMDesktopBean vm = null;
	Hashtable hash_ivms = null;
	Hashtable hash_vms = null;
	Hashtable hash_vmServers = null;
	if(userRole.hasAllComponentAccess())
	{
		if(comp.indexOf(":")<0)
		{
			comp = comp+":NULL";
		}
		vm=new VMDesktopBean(comptype,comp,layer_name);
		if(vm!=null)
			ht_infosearch=vm.getInfoForTest();
	}
	else
	{
		if(source!=null && (source.equals("MainDashboard") || source.equalsIgnoreCase("fromAlarms") || source.equalsIgnoreCase("systemDash") || source.equalsIgnoreCase("netDash")))
		{
			IniFile extIni = new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_external.ini");
			if(source.equalsIgnoreCase("systemDash") || source.equalsIgnoreCase("netDash"))
			{
				//Click of history of alarms from system dashboard.
				if(comp.indexOf(":")<0)
				{
					comp = comp+":NULL";
				}
			}
			hash_ivms = new Hashtable();
			hash_vms = new Hashtable();
			hash_vmServers = new Hashtable();
			String insideViewLayer = "";
			String outsideViewLayer = "";
			
			if(userVMServers!=null && userVMServers.size() > 0)
			{
				String v_info = "";
				String v_state = "";
				for(int uv=0; uv < userVMServers.size(); uv++)
				{
					String vmComp = (String)userVMServers.get(uv);
					String vmType = vmComp.substring(0,vmComp.indexOf(":"));
					String vmHost = vmComp.substring(vmComp.indexOf(":")+1);
					insideViewLayer = extIni.getValue("VMSearch_InsideviewLayer",vmType);
					outsideViewLayer = egUI.getValue("Layer_for_ComponentType",vmType);
					String s_host = vmType + "@" + vmHost +"@"+ insideViewLayer;
					VMDesktopBean vmObj=new VMDesktopBean(vmType,vmHost,outsideViewLayer,"DashboardModel",false);
					if(vmObj!=null)
						hash_ivms.putAll(vmObj.getAllVmInfos());
					//Has all the vms for display.
					if(vmObj!=null)
						ht_infosearch=vmObj.getInfoForTest();
					vmObj = new VMDesktopBean(vmType,vmHost,insideViewLayer,false);
					//Has only the inside view vms.
					if(vmObj!=null)
						hash_vms.putAll(vmObj.getInfoForTest());
					
					if(hash_ivms!=null && hash_ivms.size() > 0)
					{
						
						for(Enumeration e=hash_ivms.keys();e.hasMoreElements();)
						{

							v_info = (String)e.nextElement();
							v_state = (String)hash_ivms.get(v_info);
							String checkInfo = "";
							//if(v_info.indexOf("[")>-1)
							//{
								//continue;
							//}
							if(!userVMs.contains(v_info))
							{
								
									continue;
							}
							if(hash_vms!=null && hash_vms.size() > 0)
							{
								if(hash_vms.containsKey(v_info))
								{
									v_state = (String)hash_vms.get(v_info);

								}
								else
								{
									v_state = "";
								}
							}
							else
							{
								v_state = "";
							}
							v_state=(v_state==null || v_state.trim().length()==0 || v_state.trim().equals("null"))?"GOOD":v_state;
							if(v_state!=null && v_state.length() > 0)
							{
								if(!hash_vms.containsKey(v_info))
								{
									hash_vms.put(v_info,v_state);
								}
								if(!hash_vmServers.containsKey(v_info))
									hash_vmServers.put(v_info,s_host);
								
							}
						}
					}
					else
					{
						if(hash_vms!=null && hash_vms.size() > 0)
						{
							for(Enumeration e1=hash_vms.keys();e1.hasMoreElements();)
							{
								v_info = (String)e1.nextElement();
								v_state = (String)hash_vms.get(v_info);
								v_state=(v_state==null || v_state.trim().length()==0 || v_state.trim().equals("null"))?"GOOD":v_state;
								if(v_state!=null && v_state.length() > 0)
								{
									if(!hash_vms.containsKey(v_info))
										hash_vms.put(v_info,v_state);
									if(!hash_vmServers.containsKey(v_info))
										hash_vmServers.put(v_info,s_host);
								}
							}
						}
					}
				}
			
				if(userVMs!=null && userVMs.size() > 0)
				{
					
					String s_host = "";
					for(int a = 0; a < userVMs.size() ; a++)
					{
						
						String vmName = (String)userVMs.get(a);
						boolean vmFound = false;
						if(hash_vms!=null && hash_vms.size() > 0)
						{
							if(hash_vms.containsKey(vmName))
							{
								v_state = (String)hash_vms.get(vmName);
								if(hash_vmServers!=null && hash_vmServers.size() > 0)
								{
									s_host = (String)hash_vmServers.get(vmName);
								}
							}

						}
						else
						{
							v_state="UNKNOWN";
						
						}
						v_state=(v_state==null || v_state.trim().length()==0 || v_state.trim().equals("null"))?"GOOD":v_state;
						if(!hash_vms.containsKey(vmName))
								hash_vms.put(vmName,v_state);
						
					}
				}

			}
			if(!isVM)
			{
				vm=new VMDesktopBean(comptype,comp,layer_name);
				if(vm!=null)
					ht_infosearch=vm.getInfoForTest();
			}
		}
		else
		{
			vm=new VMDesktopBean(comptype,comp,layer_name);
			if(vm!=null)
				ht_infosearch=vm.getInfoForTest();
		}
	}
	
	/*if(vm!=null)
		ht_infosearch=vm.getInfoForTest();*/
	String state="GOOD";
	boolean insideViewReq = false;
	if(source!=null && (source.equals("MainDashboard") || source.equalsIgnoreCase("fromAlarms") || source.equalsIgnoreCase("systemDash") || source.equalsIgnoreCase("netDash")))
	{
		if(!isVM)
		{
			insideViewReq = false;
		}
		else
		{
			insideViewReq = true;
		}
	}

	if(!insideViewReq)
	{
		if(ht_infosearch!=null && ht_infosearch.size()>0)
		{
			Iterator itr=ht_infosearch.keySet().iterator();
			while(itr!=null && itr.hasNext())
			{
				String key=(String)itr.next();

				// when info may come caps or small , now its matched and select correct info.
				if(key!=null && key.trim().length()>0 && info!=null && info.trim().length()>0 && key.equalsIgnoreCase(info))
				{
					info=key;
				}
				//--end--

				if(key!=null && !aList_info.contains(key))
				{
					if(userRole.hasAllComponentAccess())
					{
						aList_info.add(key);
						aList_infoState.add((String)ht_infosearch.get(key));
					}
					else
					{
						String vmState  = "";
						if(source!=null && (source.equals("MainDashboard") || source.equalsIgnoreCase("fromAlarms")))
						{
							String tempkey = "";
							if(key.indexOf(":") >-1)
							{
								tempkey = key.substring(0, key.indexOf(":"));
							}
							else if(key.indexOf("[")>-1)
							{
								tempkey = key.substring(0, key.indexOf("["));
							}

							if(userVMs!=null && userVMs.size() > 0 && userVMs.contains(tempkey))
							{
								if(hash_vms!=null)
									vmState = (String)hash_vms.get(key);
								vmState=(vmState==null || vmState.trim().length()==0 || vmState.trim().equals("null"))?"GOOD":vmState;
								if(!aList_info.contains(tempkey))
								{
									aList_info.add(tempkey);
									aList_infoState.add(vmState);
								}
							}
							//Collect the server vms here along with vms.
							if(!isVM)
							{
								aList_info.add(key);
								aList_infoState.add((String)ht_infosearch.get(key));
							}
						}
						else if(HostandClusterValue!=null && HostandClusterValue.equalsIgnoreCase("no"))
						{
							if(userVMs!=null && userVMs.size() > 0 && userVMs.contains(key))
							{
								aList_info.add(key);
								if(hash_vms!=null)
									vmState = (String)hash_vms.get(key);
								vmState=(vmState==null || vmState.trim().length()==0 || vmState.trim().equals("null"))?"GOOD":vmState;
								aList_infoState.add(vmState);
							}
						}
						else
						{
							if(onlyVMAssigned)
							{
								if(userVMs!=null && userVMs.size() > 0 && userVMs.contains(key))
								{
									aList_info.add(key);
									if(hash_vms!=null)
										vmState = (String)hash_vms.get(key);
									vmState=(vmState==null || vmState.trim().length()==0 || vmState.trim().equals("null"))?"GOOD":vmState;
									aList_infoState.add(vmState);
								}
							}
							else
							{
								aList_info.add(key);
								aList_infoState.add((String)ht_infosearch.get(key));
							}
						}

					}
				}
			}
			if(info!=null && info.trim().length()>0)
			{
				if(userRole.hasAllComponentAccess())
				{
					state=(String)ht_infosearch.get(info);
				}
				else
				{
					state = "";
					if(source!=null && (source.equals("MainDashboard") || source.equals("fromAlarms")))
					{
						if(userVMs!=null && userVMs.size() > 0 && userVMs.contains(info))
						{
							if(hash_vms!=null && hash_vms.containsKey(info))
							{
								state=(String)hash_vms.get(info);
							}
							else
							{
								//For outside view vms we show good state
								//since only inside view metrics are showed when user has vms.
								state="GOOD";
							}
							state=(state==null || state.trim().length()==0 || state.trim().equals("null"))?"GOOD":state;
						}
						else
						{
							if(!isVM)
							{
								state=(String)ht_infosearch.get(info);
							}
						}
					}
					else if(HostandClusterValue!=null && HostandClusterValue.equalsIgnoreCase("no"))
					{
						if(userVMs!=null && userVMs.size() > 0 && userVMs.contains(info))
						{
							if(hash_vms!=null)
								state=(String)hash_vms.get(info);
							
						}
						state=(state==null || state.trim().length()==0 || state.trim().equals("null"))?"GOOD":state;
					}
					else
					{
						state = (String)ht_infosearch.get(info);
					}
				}
			}
		}
	}
	else
	{
		//Collect the inside view vms.
		String vmState  = "";
		if(source!=null && (source.equals("MainDashboard") || source.equalsIgnoreCase("fromAlarms")))
		{
			if(info!=null && info.trim().length()>0)
			{
				//if(info.indexOf("[") >-1)
				//{
					//info = info.substring(0,info.indexOf("["));
				//}
				if(userVMs!=null && userVMs.size() > 0 && userVMs.contains(info))
				{
					aList_info.add(info);
					if(hash_vms!=null)
					{
						if(hash_vms.containsKey(info))
						{
							vmState = (String)hash_vms.get(info);
						}
						else
						{
							if(hash_ivms.containsKey(info))
								vmState = "GOOD";
							else
								vmState = "UNKNOWN";
						}
					}
					vmState=(vmState==null || vmState.trim().length()==0 || vmState.trim().equals("null"))?"GOOD":vmState;
					aList_infoState.add(vmState);
					state = vmState;
					for(int uv =0; uv < userVMs.size(); uv++)
					{
						String vmInfo = (String)userVMs.get(uv);
						if(!aList_info.contains(vmInfo))
							aList_info.add(vmInfo);
						if(hash_vms!=null)
						{
							if(hash_vms.containsKey(vmInfo))
							{
								vmState = (String)hash_vms.get(vmInfo);
							}
							else
							{
								if(hash_ivms.containsKey(vmInfo))
									vmState = "GOOD";
								else
									vmState = "UNKNOWN";
							}
						}
						vmState=(vmState==null || vmState.trim().length()==0 || vmState.trim().equals("null"))?"GOOD":vmState;
						aList_infoState.add(vmState);
					}
				}
			}
		}
		else if(HostandClusterValue!=null && HostandClusterValue.equalsIgnoreCase("no"))
		{
			//if(info!=null && info.trim().length()>0)
			//{
				//if(info.indexOf("[") >-1)
				//{
					//info = info.substring(0,info.indexOf("["));
				//}
			//}
			if(userVMs!=null && userVMs.size() > 0 && userVMs.contains(info))
			{
				aList_info.add(info);
				if(hash_vms!=null)
				{
					if(hash_vms.containsKey(info))
						vmState = (String)hash_vms.get(info);
					else
					{
						if(hash_ivms.containsKey(info))
							vmState = "GOOD";
						else
							vmState = "UNKNOWN";
					}
				}
				vmState=(vmState==null || vmState.trim().length()==0 || vmState.trim().equals("null"))?"GOOD":vmState;
				aList_infoState.add(vmState);
				state = vmState;
				for(int uv =0; uv < userVMs.size(); uv++)
				{
					String vmInfo = (String)userVMs.get(uv);
					if(!aList_info.contains(vmInfo))
						aList_info.add(vmInfo);
					if(hash_vms.containsKey(vmInfo))
						vmState = (String)hash_vms.get(vmInfo);
					else
					{
						if(hash_ivms.containsKey(vmInfo))
							vmState = "GOOD";
						else
							vmState = "UNKNOWN";
					}
					vmState=(vmState==null || vmState.trim().length()==0 || vmState.trim().equals("null"))?"GOOD":vmState;
					aList_infoState.add(vmState);
				}
			}
		}
		else
		{
			//if(info!=null && info.trim().length()>0)
			//{
				//if(info.indexOf("[") >-1)
				//{
					//info = info.substring(0,info.indexOf("["));
				//}
			//}
			if(onlyVMAssigned)
			{
				if(userVMs!=null && userVMs.size() > 0 && userVMs.contains(info))
				{
					aList_info.add(info);
					if(hash_vms!=null)
					{
						if(hash_vms.containsKey(info))
							vmState = (String)hash_vms.get(info);
						else
						{
							if(hash_ivms.containsKey(info))
							{
								vmState = "GOOD";
							}
							else
								vmState = "UNKNOWN";	
						}
					}
					vmState=(vmState==null || vmState.trim().length()==0 || vmState.trim().equals("null"))?"GOOD":vmState;
					aList_infoState.add(vmState);
					state = vmState;
					for(int uv =0; uv < userVMs.size(); uv++)
					{
						String vmInfo = (String)userVMs.get(uv);
						if(!aList_info.contains(vmInfo))
							aList_info.add(vmInfo);
						if(hash_vms!=null)
						{
							if(hash_vms.containsKey(vmInfo))
								vmState = (String)hash_vms.get(vmInfo);
							else
							{
								if(hash_ivms.containsKey(vmInfo))
								{
									vmState = "GOOD";
								}
								else
									vmState = "UNKNOWN";
							}
						}
						vmState=(vmState==null || vmState.trim().length()==0 || vmState.trim().equals("null"))?"GOOD":vmState;
						aList_infoState.add(vmState);
					}
				}
			}
		}
	}
	String defaultMGraphDuration=inifile.getValue("Default_MeasureGraph_Duration","duration");
	String defaultSGraphDuration=inifile.getValue("Default_SummaryGraph_Duration","duration");
	String defaultTGraphDuration=inifile.getValue("Default_TrendGraph_Duration","duration");
	String defaultDDDuration=inifile.getValue("Default_DD_Duration","duration");
	String timelineForMeasure=egDashboard.convertDurtionIntoTimeline(defaultMGraphDuration,false);
	String timelineForSummary=egDashboard.convertDurtionIntoTimeline(defaultSGraphDuration,false);
	String timelineForTrend=egDashboard.convertDurtionIntoTimeline(defaultTGraphDuration,false);
	String timelineForDD=egDashboard.convertDurtionIntoTimeline(defaultDDDuration,false);
	String descript=egMappingInfo.getTextDescription("monitor.dashboard.Description");
	String s_time=egMappingInfo.getTextDescription("monitor.dashboard.Start time");
	boolean isFusion=HighChartTimeline.isFusion();
%>
<HTML class="content-frame">
	<HEAD>
		<script>
			var comp="<%=comp%>";
			var comptype="<%=comptype%>";
			var layer_name="<%=layer_name%>";
			var monitor_Skin="<%=monitor_Skin%>";
			var checkVal="<%=check%>";
			var stateNameVal="<%=stateName%>";
			var fromVal="<%=from%>";
			var isVM=<%=isVM%>;
			var isFusionChart =<%=isFusion%>;
			var selectComp ="";
			var requestParams=new Object();
			var vmsCombo=new Array();
			var componentCombo=new Array();
			var infoArray = new Array();
			var compArray = new Array();
			var infoStateArray = new Array();
			var selectedInfoState = "";
			var testStatusInfoTitle="<egui:intnl text='monitor.dashboard.Test Status Details'/>";
			var testStatusInfoT1="<egui:intnl text='monitor.common.Measure'/>";
			var testStatusInfoT2="<egui:intnl text='monitor.common.Max/Min'/>";
			var testStatusInfoT3="<egui:intnl text='monitor.common.Critical'/>";
			var testStatusInfoT4="<egui:intnl text='monitor.common.Major'/>";
			var testStatusInfoT5="<egui:intnl text='monitor.common.Minor'/>";
			var testStatusInfoT6="<egui:intnl text='monitor.common.Alarm policy'/>";
			var testStatusInfoT7="<egui:intnl text='monitor.common.Measures without Thresholds'/>";

			
			var remoteURL="../servlet/com.eg.EgMonRemoteScriptingServlet";
			var noMeasures = '<egui:intnl text="monitor.vmmeasures.No measures available" />!';
			var newWindow = false;
			var win = null;
			var main_commonUrl=null;
			var refreshFrequency=<%=refreshFrequency%>;
			var userSearchParams = '<%=queryString%>';
			//thresholds labels
			var testInfoGlobalURL = '';
			var threshTypeVar = '';
			var pageName = 'Configure thresholds';
			var staticMinCriticalErrMsg1 = '<egui:intnl text="admin.threshold.Invalid threshold entry : Critical - Static minimum threshold"/>';
			var staticMaxCriticalErrMsg1 = '<egui:intnl text="admin.threshold.Invalid threshold entry : Critical - Static maximum threshold"/>';
			var staticMinMajorErrMsg1 = '<egui:intnl text="admin.threshold.Invalid threshold entry : Major - Static minimum threshold"/>';
			var staticMaxMajorErrMsg1 = '<egui:intnl text="admin.threshold.Invalid threshold entry : Major - Static maximum threshold"/>';
			var staticMinMinorErrMsg1 = '<egui:intnl text="admin.threshold.Invalid threshold entry : Minor - Static minimum threshold"/>';
			var staticMaxMinorErrMsg1 = '<egui:intnl text="admin.threshold.Invalid threshold entry : Minor - Static maximum threshold"/>';
			var errMsg1 = '<egui:intnl text="admin.threshold.Possible reasons could be"/>';
			var errMsg2 = '<egui:intnl text="admin.threshold.Threshold is set with a negative values"/>';
			var errMsg3 = '<egui:intnl text="admin.threshold.The integer part contains more than 6 digits"/>';
			var errMsg4 = '<egui:intnl text="admin.threshold.The fractional part contains more than 2 digits"/>';
			var errMsg5 = '<egui:intnl text="admin.threshold.Static minimum threshold"/> <egui:intnl text="admin.threshold.for"/>';
			var errMsg6 = '<egui:intnl text="admin.threshold.should not contain negative values"/>.';
			var errMsg7 = '<egui:intnl text="admin.threshold.Static minimum threshold values representing Critical/Major/Minor should be in ascending order"/>.';
			var errMsg8 = '<egui:intnl text="admin.threshold.Automatic minimum threshold values representing Critical/Major/Minor should be in ascending order"/>';
			var errMsg9 = '<egui:intnl text="admin.threshold.Static maximum threshold values representing Critical/Major/Minor should be in descending order"/>';
			var errMsg10 = '<egui:intnl text="admin.threshold.Automatic maximum threshold values representing Critical/Major/Minor should be in descending order"/>';
			var errMsg11 = '<egui:intnl text="admin.threshold.Static maximum threshold"/> <egui:intnl text="admin.threshold.for"/>';
			var deleteConfirmMsg = '<egui:intnl text="admin.threshold.Are you sure you want to delete specific thresholds for this descriptor"/>?';
			var deleteSpecTestConfirmMsg = '<egui:intnl text="admin.threshold.Are you sure you want to delete specific thresholds for this test"/>?';
			var selectTestAlert = '<egui:intnl text="admin.threshold.Please select a group thresholds test"/>.';
			var selectSpecificTestAlert = '<egui:intnl text="admin.threshold.Please select a specific thresholds test"/>.';
			var selectDefaultTestAlert = '<egui:intnl text="admin.threshold.Please select a default thresholds test"/>.';
			var applyOtherCompAlert = '<egui:intnl text="admin.test.Please specify component(s) for configuration"/>';
			var successAlert = '<egui:intnl text="admin.threshold.Thresholds have been applied successfully"/>'+'.';
			var tabMsg1 = '<egui:intnl text="admin.threshold.Descriptors with specific threshold settings"/>';
			var tabMsg2 = '<egui:intnl text="admin.threshold.Descriptors with component threshold settings"/>';
			var successAlert1 = '<egui:intnl text="admin.threshold.Threshold updated successfully"/>'+'.';

			var label1 = '<egui:intnl text="admin.threshold.Component type"/>';
			var label2 = '<egui:intnl text="admin.threshold.Test name"/>';
			var label3 = '<egui:intnl text="admin.threshold.Descriptor name"/>';
			var label4 = '<egui:intnl text="admin.threshold.Configure thresholds for multiple servers"/>';
			var label5 = '<egui:intnl text="admin.threshold.Component name"/>';
			var label6 = '<egui:intnl text="admin.threshold.TESTS WITH GLOBAL THRESHOLD"/>';
			var label7 = '<egui:intnl text="admin.threshold.TESTS WITH SPECIFIC THRESHOLD"/>';
			var label8 = '<egui:intnl text="admin.threshold.TESTS WITH GROUP THRESHOLD"/>';
			var label9 = '<egui:intnl text="admin.threshold.TESTS WITH DEFAULT THRESHOLD"/>';
			var searchEmptyTxt = '<egui:intnl text="admin.threshold.No decriptors available for this Search"/>';
			var label10 = '<egui:intnl text="admin.threshold.Apply to other components"/>';
			var label11 = '<egui:intnl text="admin.threshold.View By"/>';
			var label12 = '<egui:intnl text="admin.threshold.Add to existing components"/>';
			var label13 = '<egui:intnl text="admin.threshold.Remove from existing components"/>';
			var label14 = '<egui:intnl text="admin.threshold.Components to be configured"/>';
			var label15 = '<egui:intnl text="admin.threshold.Existing components"/>';

			var titleGrid1 = '<egui:intnl text="admin.threshold.Measures with thresholds"/>';
			var titleGrid2 = '<egui:intnl text="admin.threshold.Measures without thresholds"/>';
			var alarmPolText = '<egui:intnl text="admin.threshold.Alarm Policy"/>';
			var btnText1 = '<egui:intnl text="admin.common.Back"/>';
			var btnText2 = '<egui:intnl text="admin.common.Update"/>';
			var btnText3 = '<egui:intnl text="admin.common.Configure thresholds for descriptors"/>';
			var btnText4 = '<egui:intnl text="admin.common.Modify"/>';
			var btnText5 = '<egui:intnl text="admin.common.Descriptors"/>';
			var btnText6 = '<egui:intnl text="admin.common.Apply"/>';
			var delText = '<egui:intnl text="admin.common.Delete"/>';
			var minThreshText = '<egui:intnl text="admin.threshold.Minimum Threshold"/>';
			var maxThreshText = '<egui:intnl text="admin.threshold.Maximum Threshold"/>';
			var minRegExpText = '<egui:intnl text="admin.threshold.Alphabets or special characters are not allowed"/>';
			var minThreshTipText = '*&nbsp;'+'<egui:intnl text="admin.threshold.Specify minimum threshold values (Critical, Major, and Minor) in ascending order"/>';
			var maxThreshTipText = '*&nbsp;'+'<egui:intnl text="admin.thresholds.Specify maximum threshold values (Critical, Major, and Minor) in descending order"/>';
			var hostTestMsg = '*&nbsp;'+'<egui:intnl text="admin.thresholds.Changes made to specific thresholds will be applied to all components with the same nick name"/>';
			var measureText = '<egui:intnl text="admin.threshold.Measure"/>';
			var thresholdText = '<egui:intnl text="admin.threshold.Threshold"/>';
			var criticalText = '<egui:intnl text="admin.threshold.Critical"/>';
			var majorText = '<egui:intnl text="admin.threshold.Major"/>';
			var minorText = '<egui:intnl text="admin.threshold.Minor"/>';
			var maxminText = '<egui:intnl text="admin.threshold.Min/Max"/>';
			var staticText = '<egui:intnl text="admin.threshold.Static"/>';
			var autoText = '<egui:intnl text="admin.threshold.Automatic"/>';
			var descText = '<egui:intnl text="admin.threshold.Description"/>';
			var polText = '<egui:intnl text="admin.threshold.Policy"/>';
			var allMeasureText = '<egui:intnl text="admin.threshold.Apply to other measures"/>';
			var autoCriText = '<egui:intnl text="admin.threshold.Critical (% Tolerance)"/>';
			var autoMajorText = '<egui:intnl text="admin.threshold.Major (% Tolerance)"/>';
			var autoMinorText = '<egui:intnl text="admin.threshold.Minor (% Tolerance)"/>';
			var systemRefreshData = "";
		</script>
		<egui:skin ui="monitor"/>
		<egui:loadApp baseDir="/final/monitor/eg_scripts" appName="insideViewDashboard" appFile="app.js"/>
		
		<script language="JavaScript1.2" src="/final/scripts/jquery-1.8.2.min.js"></script>
		<script language="JavaScript1.2" src="/final/monitor/eg_scripts/eg_validate.js"></script>
		<script language="JavaScript1.2" src="/final/monitor/eg_scripts/eg_date.js"></script>
		<script language="JavaScript1.2" src="/final/monitor/eg_scripts/ajaxutils.js"></script>
		<!-- <script language="JavaScript1.2" src="/final/monitor/eg_scripts/overview.js"></script> -->
		<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
		<script type="text/javascript" src="/final/FusionCharts/scripts/FusionCharts.js"></script>

		
		<script src="/final/scripts/utilities/ScrollPanel.js"></script>
		<script src="/final/scripts/utilities/ScrollableUtils.js"></script>	
		<script src="/final/scripts/utilities/ZoomGraphPanel.js"></script>

		
<!-- fancy Scroll-->

<!--  <script src="/final/jquery/jquery.min.js"></script>   -->

		<script src="/final/styles/jscrollpane/jquery.jscrollpane.js" ></script>
		<script src="/final/styles/jscrollpane/jquery.mousewheel.js" ></script>
		<script src="/final/styles/jscrollpane/mwheelIntent.js" ></script>

		<link rel="stylesheet" href="/final/styles/jscrollpane/jquery.jscrollpane.css"/>
		<script language="JavaScript1.2" src="/final/Highcharts/js/highstock.js"></script>
		 <script src="../monitor/eg_scripts/EgHighChart.js"></script>

		  <script src="/final/Highcharts/js/highcharts-more.js"></script>
		 <script src="/final/Highcharts/js/solid-gauge.src.js"></script>	
		<script type="text/javascript" src="/final/monitor/eg_scripts/jsrsClient.js"></script>
		<script src="/final/scripts/eg_DateUtil.js"></script>
		<script>
		var mgr_dateFormat= getExtjsDateFormat('<%=dateFormatForDatePicker%>');
			var mgr_disp_dateFormat= getExtjsDateFormat('<%=currentDateFormat%>');
			var mgr_curr_dateFormat= '<%=dateFormatForDatePicker%>';
			var currentDateFormat_js= '<%=currentDateFormat%>';

		function parseScript(_source)
		{
			var source = _source;
			var scripts = new Array();
			
			// Strip out tags
			while(source.indexOf("<script") > -1 || source.indexOf("</script") > -1) {

				var s = source.indexOf("<script");
				var s_e = source.indexOf(">", s);
				var e = source.indexOf("</script", s);
				var e_e = source.indexOf(">", e);
				// Add to scripts array
				scripts.push(source.substring(s_e+1, e));
				// Strip from source
				source = source.substring(0, s) + source.substring(e_e+1);
			}
			// Loop through every script collected and eval it
			for(var i=0; i<scripts.length; i++) {
				try {
					eval(scripts[i]);
				}
				catch(ex) {
					return;
				}
			}
			// Return the cleaned source
			return source;
		}
		Ext.onReady(function(){
			 Ext.Ajax.on('requestexception', function (conn, response, options) {
				var errorStr = response.responseText;
				parseScript(errorStr);
				if (errorStr != undefined && errorStr != 'undefined' && errorStr.indexOf("customerror") != -1)
				{
					if (errorStr.indexOf("user-session-invalid") != -1)
					{
						callWindow(1);
					}
					else if (errorStr.indexOf("user-deleted") != -1)
					{
						callWindow(2);
					}
					else if (errorStr.indexOf("user-timedout") != -1)
					{
						callWindow(3);
					}
				}
			});
			initLdgMask = new Ext.LoadMask(Ext.getBody(),{msg : "Loading ..."});
		});
	
		documentView ={
				getObject: function()
				{
					if(typeof( window.innerWidth) == 'number')
					{//Firefox
						this.height = window.innerHeight;
						this.width = window.innerWidth;
						this.fireFox = true;
					}
					else if( document.documentElement && ( document.documentElement.clientWidth
						|| document.documentElement.clientHeight ))
					{//IE 6 + in 'standards compliant mode'
						this.height = document.documentElement.clientHeight;
						this.width = document.documentElement.clientWidth;
						this.ie = true;
					}
					else if(document.body && document.body.clientHeight)
					{ //IE 4 compatible
						this.height = document.body.clientHeight;
						this.width = document.body.clientWidth;
						this.ie = true;
					}
					return this;
				},
				getHeight: function()
				{
					return this.getObject().height;
				},
				getWidth: function()
				{
					return this.getObject().width;
				},
				isIE: function()
				{
					return this.getObject().ie;
				},
				isFireFox: function()
				{
					return this.getObject().fireFox;
				}
			};
	
		// for Measures Tab
		function openHelpWin( link )
		{
			Ext.onReady(function(){
				var tmpURL = link;
				var URL = '';
				var params = '';
				var genQstr = '';
				if ( !Ext.isEmpty( tmpURL ) )
				{
					if ( tmpURL.indexOf('?') > -1 )
					{
						URL = tmpURL.substring(0, tmpURL.indexOf('?'));
						params = tmpURL.substring( tmpURL.indexOf('?') + 1 );
					}
					else
					{
						URL = tmpURL;
					}
				}
				if ( !Ext.isEmpty( params ) )
				{
					var split = params.split('&');
					for ( var i = 0; i < split.length ; i++ )
					{
						var text = split[i].replace('=', '|equal|');
						if ( i == split.length - 1 )
						{
							genQstr += text;
						}
						else
						{
							genQstr += text+'|amp|';
						}
					}
				}
				Ext.widget('window', {
					title: 'Help',
					resizable:false,
					width:1000,
					frame:false,
					constrain:true,
					height:550,
					scroll:false,
					autoScroll:false,
					border:false,
					layout:'fit',
					padding:'0 0 0 0',
					margin:'0 10 0 0',
					html:'<iframe width="100%" height="100%" scrolling="no" frameborder="0" src="/final/eghelp/EgHelpApp.jsp?forwardPage='+URL+'&params='+genQstr+'"></iframe>'
				}).show()
			});
		}
		function openInfoLink( link )
		{
			/*Ext.widget('window', {
							title: 'Test Measure Status Info',
							resizable:false,
							width:1000,
							frame:false,
							constrain:true,
							height:550,
							scroll:false,
							autoScroll:false,
							border:false,
							layout:'fit',
							padding:'0 0 0 0',
							margin:'0 10 0 0',
							html:'<iframe width="100%" height="100%" scrolling="no" frameborder="0" src="'+link+'"></iframe>'
						}).show();*/
			Ext.onReady(function(){
				insideViewDashboard.app.getController('Main').openTestInfoWindow(link);
				testInfoGlobalURL = link;
			});
		}
		function chekWindow(QueryString,windowName)
		{
			Ext.onReady(function(){
				newWindow = true;
				var isNewWindow = newWindow;
				if(isNewWindow && QueryString!=null && QueryString.indexOf("/final/monitor/EgSiteInfraView.jsp")>-1)
				{
					isNewWindow=null;
				}
				QueryString = QueryString+"&newWindow="+isNewWindow+"&fromPage=measures";//modified on 17/10/07
				if(windowName=="TESTSTATUSINFOWINDOW" || windowName=="HelpWindow")
				{
					if(windowName=="TESTSTATUSINFOWINDOW")
					{
						windowName = 'Test Measure Status Info';
					}
					if(win==null)
					{
					  win = window.openWindow(QueryString,windowName,'toolbar=no,menubar=no,location=no,status=no,width=980,height=603,left=0,top=105,screenx=0,screeny=0,scrollbars=yes,resizable=no');
						win.focus();
						/*Ext.widget('window', {
							title: windowName,
							resizable:false,
							width:1000,
							frame:false,
							constrain:true,
							height:550,
							scroll:false,
							autoScroll:false,
							border:false,
							layout:'fit',
							padding:'0 0 0 0',
							margin:'0 10 0 0',
							html:'<iframe width="100%" height="100%" scrolling="no" frameborder="0" src="'+QueryString+'"></iframe>'
						}).show();*/
					}
					else if(win!=null)
					{
						win.close();
						win=null;
						win = window.openWindow(QueryString,windowName,'toolbar=no,menubar=no,location=no,status=no,width=980,height=603,left=0,top=105,screenx=0,screeny=0,scrollbars=yes,resizable=no');
						win.focus(); 
						/*Ext.widget('window', {
							title: windowName,
							resizable:false,
							width:1000,
							frame:false,
							constrain:true,
							height:550,
							scroll:false,
							autoScroll:false,
							border:false,
							layout:'fit',
							padding:'0 0 0 0',
							margin:'0 10 0 0',
							html:'<iframe width="100%" height="100%" scrolling="no" frameborder="0" src="'+QueryString+'"></iframe>'
						}).show();*/
					}
				}
				else
				{
					if(isNewWindow!=null && isNewWindow!='undefined' && isNewWindow)
					{
						if(win==null)
						{
							win = window.openWindow(QueryString,windowName,'toolbar=no,menubar=no,location=no,status=no,width=980,height=603,left=0,top=105,screenx=0,screeny=0,scrollbars=no,resizable=no');
							win.focus();
							/*Ext.widget('window', {
								title: windowName,
								resizable:false,
								width:1000,
								frame:false,
								constrain:true,
								height:550,
								scroll:false,
								autoScroll:false,
								border:false,
								layout:'fit',
								padding:'0 0 0 0',
								margin:'0 10 0 0',
								html:'<iframe width="100%" height="100%" scrolling="no" frameborder="0" src="'+QueryString+'"></iframe>'
							}).show();*/
						}
						else if(win!=null)
						{
							win.close();
							win=null;
							win = window.openWindow(QueryString,windowName,'toolbar=no,menubar=no,location=no,status=no,width=980,height=603,left=0,top=105,screenx=0,screeny=0,scrollbars=no,resizable=no');
							win.focus();
							/*Ext.widget('window', {
								title: windowName,
								resizable:false,
								width:1000,
								frame:false,
								constrain:true,
								height:550,
								scroll:false,
								autoScroll:false,
								border:false,
								layout:'fit',
								padding:'0 0 0 0',
								margin:'0 10 0 0',
								html:'<iframe width="100%" height="100%" scrolling="no" frameborder="0" src="'+QueryString+'"></iframe>'
							}).show();*/
						}
					}
					else
					{
						window.location.href=QueryString;
					}
				}
			});
		}
		var selectedTab="Measures";
		<%			
			String temp_Info = com.egurkha.util.StringUtils.replace(info,"\\","\\\\");
		%>
		//var selectedInfo = '<%=info%>';
		var selectedInfo = '<%=temp_Info%>';
		var selectedComp = '<%=componentName%>';
		
		var lmUrl="&fromDashBrd=true&fromLink=true&from_page=insideviewDashboard&Layer=<%=layer_name%>&hostName="+encodeURI("<%=comp%>")+"&compType=<%=comptype%>";
		/*function goToLayerModel(qstr)
		{
			Ext.onReady(function(){
				qstr=qstr+"&defaultSelectedTab="+selectedTab;
				if(selectedInfo!=null && selectedInfo!='' && selectedInfo.indexOf("\\")>-1)
				{
					selectedInfo=selectedInfo.replace("\\","\\\\");
					qstr=qstr.replace("\\","\\\\");
				}
				qstr=encodeURI(qstr)+"&fromDashBrd=true&fromLink=true&from_page=insideviewDashboard&info="+escape(selectedInfo)+"&Layer=<%=layer_name%>&hostName="+encodeURI("<%=comp%>")+"&compType=<%=comptype%>";

				window.location.href=qstr;
			});
		}*/
		//---end---
		
		function showMeasures(){
			requestParams.activeTab='Measures';
			requestParams.activeTabInx=0;
			selectedTab = 'Measures';
			requestParams.pageUrl = '<%=response.encodeURL("../servlet/com.eg.EgMeasureController?")%>'+"getFor=measure&comp="+encodeURI("<%=comp%>")+"&comptype=<%=comptype%>&Layer=<%=layer_name%>&compName=<%=EgURLEncoder.encode(comp_name,"UTF-8")%>&from_page=insideviewDashboard&allComps=<%=all_comps%>&isVM=<%=isVM%>&source=<%=source%>&resultpage=VmMeasures";
			return true;
		}
		function showSystem(){
			selectedTab = 'System';
			requestParams.activeTab='System';
			requestParams.activeTabInx=1;
			requestParams.subSystem='<%=subsystem%>';
			requestParams.pageUrl = '<%=response.encodeURL("/final/monitor/egSystemDashBoard.jsp?")%>'+"tab=system&hostName="+encodeURI("<%=comp%>")+"&compType=<%=comptype%>&from_page=insideviewDashboard&Layer=<%=layer_name%>&allComps=<%=all_comps%>&isVM=<%=isVM%>&source=<%=source%>";
			return true;
		}
		function showNetwork(){
			selectedTab = 'Network';
			requestParams.activeTab='Network';
			requestParams.activeTabInx=2;
			requestParams.subSystem='<%=subsystem%>';
			requestParams.pageUrl = '<%=response.encodeURL("/final/monitor/egNetworkDashBoard.jsp?")%>'+"tab=network&hostName="+encodeURI("<%=comp%>")+"&compType=<%=comptype%>&from_page=insideviewDashboard&Layer=<%=layer_name%>&allComps=<%=all_comps%>&isVM=<%=isVM%>&source=<%=source%>";
			return true;
		}
		function setSelectedInfo(s_info)
		{
			selectedInfo = s_info;
		}

		requestParams.pageUrl='<%=defaultTabUrl%>';
		requestParams.defaultUrl='<%=defaultTabUrl%>';
		requestParams.activeTab='<%=defaultTab%>';
		requestParams.activeTabInx=<%=index_of_tab%>;
		requestParams.subSystem='<%=subsystem%>';

		if(requestParams.activeTab =='System' || requestParams.activeTab =='system')
		{
			requestParams.pageUrl = '<%=response.encodeURL("/final/monitor/egSystemDashBoard.jsp?")%>'+"tab=system&hostName="+encodeURI("<%=comp%>")+"&compType=<%=comptype%>&from_page=insideviewDashboard&Layer=<%=layer_name%>&allComps=<%=all_comps%>&isVM=<%=isVM%>&source=<%=source%>";
		}
		else if(requestParams.activeTab =='Network' || requestParams.activeTab =='network')
		{
			requestParams.pageUrl = '<%=response.encodeURL("/final/monitor/egNetworkDashBoard.jsp?")%>'+"tab=network&hostName="+encodeURI("<%=comp%>")+"&compType=<%=comptype%>&from_page=insideviewDashboard&Layer=<%=layer_name%>&allComps=<%=all_comps%>&isVM=<%=isVM%>&source=<%=source%>";
		}
		else if(requestParams.activeTab =='Measures' || requestParams.activeTab =='measures')
		{
			requestParams.pageUrl = '<%=response.encodeURL("../servlet/com.eg.EgMeasureController?")%>'+"getFor=measure&comp="+encodeURI("<%=comp%>")+"&comptype=<%=comptype%>&Layer=<%=layer_name%>&compName=<%=EgURLEncoder.encode(comp_name,"UTF-8")%>&from_page=insideviewDashboard&allComps=<%=all_comps%>&isVM=<%=isVM%>&source=<%=source%>&resultpage=VmMeasures";
		}

		
	
		<%			
			info = com.egurkha.util.StringUtils.replace(info,"\\","\\\\");
			
		%>
	
		
		requestParams.measuresUrl='<%=response.encodeURL("../servlet/com.eg.EgMeasureController?")%>'+"getFor=measure&comp="+encodeURI("<%=comp%>")+"&comptype=<%=comptype%>&Layer=<%=layer_name%>&compName=<%=EgURLEncoder.encode(comp_name,"UTF-8")%>&from_page=insideviewDashboard&allComps=<%=all_comps%>&isVM=<%=isVM%>&source=<%=source%>&resultpage=VmMeasures&info=<%=info%>";

		requestParams.systemUrl='<%=response.encodeURL("/final/monitor/egSystemDashBoard.jsp?")%>'+"tab=System&hostName="+encodeURI("<%=comp%>")+"&compType=<%=comptype%>&subsystem=<%=subsystem%>&from_page=insideviewDashboard&Layer=<%=layer_name%>&allComps=<%=all_comps%>&isVM=<%=isVM%>&source=<%=source%>&info=<%=info%>";

		requestParams.networkUrl='<%=response.encodeURL("/final/monitor/egNetworkDashBoard.jsp?")%>'+"tab=Network&hostName="+encodeURI("<%=comp%>")+"&compType=<%=comptype%>&subsystem=<%=subsystem%>&from_page=insideviewDashboard&Layer=<%=layer_name%>&allComps=<%=all_comps%>&isVM=<%=isVM%>&source=<%=source%>&info=<%=info%>";


		<%
			info = com.egurkha.util.StringUtils.replace(info,"\\\\","\\");
		%>
<%
		String tmp_info=info;
		String real_info=info;
		if(tmp_info!=null && tmp_info.trim().length()>0)
		{
			tmp_info=com.egurkha.util.StringUtils.replace(tmp_info,"|plus|","+");
			tmp_info=com.egurkha.util.StringUtils.replace(tmp_info,"|amp|","&");
			tmp_info=com.egurkha.util.StringUtils.replace(tmp_info,"|pct|","%");
			tmp_info=com.egurkha.util.StringUtils.replace(tmp_info,"|hash|","#");

			real_info=com.egurkha.util.StringUtils.replace(real_info,"|plus|","+");
			real_info=com.egurkha.util.StringUtils.replace(real_info,"|amp|","&");
			real_info=com.egurkha.util.StringUtils.replace(real_info,"|pct|","%");
			real_info=com.egurkha.util.StringUtils.replace(real_info,"|hash|","#");

			tmp_info = com.egurkha.util.StringUtils.replace(tmp_info,"\\\\","\\");
		}

		if((fromVmSearch!=null && fromVmSearch.equalsIgnoreCase("yes")) || (fromThinClients!=null && fromThinClients.equalsIgnoreCase("yes")))
		{
			Vector component_list = egDAO.getComponentsForVM(tmp_info);
			if(component_list!=null && component_list.size()>0)
			{
				for(int h=0;h<component_list.size();h++)
				{
					if(componentName!=null && componentName.equals(component_list.get(h)))
					{
%>
						var temp=new Object();
						temp.name='<%=component_list.get(h)%>';
						temp.value='<%=component_list.get(h)%>';
						selectedComp ='<%=componentName%>';
						compArray.push(temp);
<%
					}
					else
					{
%>
						var temp=new Object();
						temp.name='<%=component_list.get(h)%>';
						temp.value='<%=component_list.get(h)%>';
						compArray.push(temp);
<%
					}
				}
			}
%>
			componentCombo.push({
				label:'<%=egMappingInfo.getTextDescription("monitor.common.Select a component")%>',
				name: "componentName" ,
				value: compArray,
				selected:'<%=componentName%>'
			});

			requestParams.componentCombo=componentCombo; 
<%
		}
		else
		{
			if(aList_info!=null && aList_info.size()>0)
			{
				for(int h=0;h<aList_info.size();h++)
				{
					String temp_vm_name=(String)aList_info.get(h);
					String temp_vm_state=(String)aList_infoState.get(h);
					String display_vm_name = temp_vm_name;
					String value_vm_name = temp_vm_name;
					display_vm_name=com.egurkha.util.StringUtils.replace(display_vm_name,"\\","\\\\");
					if(display_vm_name!=null && display_vm_name.trim().length()>0)
					{
						display_vm_name=com.egurkha.util.StringUtils.replace(display_vm_name,"|plus|","+");
						display_vm_name=com.egurkha.util.StringUtils.replace(display_vm_name,"|amp|","&");
						display_vm_name=com.egurkha.util.StringUtils.replace(display_vm_name,"|pct|","%");
						display_vm_name=com.egurkha.util.StringUtils.replace(display_vm_name,"|hash|","#");
					}

					if(value_vm_name!=null && value_vm_name.trim().length()>0)
					{
						value_vm_name=com.egurkha.util.StringUtils.replace(value_vm_name,"+","|plus|");
						value_vm_name=com.egurkha.util.StringUtils.replace(value_vm_name,"&","|amp|");
						value_vm_name=com.egurkha.util.StringUtils.replace(value_vm_name,"%","|pct|");
						value_vm_name=com.egurkha.util.StringUtils.replace(value_vm_name,"#","|hash|");
						value_vm_name=com.egurkha.util.StringUtils.replace(value_vm_name,"\\","\\\\");
					}
					if(tmp_info!=null && tmp_info.equals(temp_vm_name))
					{
%>
						var temp=new Object();
						temp.name='<%=display_vm_name%>';
						temp.value='<%=value_vm_name%>';
						temp.state='<%=temp_vm_state%>';
						selectedInfoState ='<%=temp_vm_state%>';
						infoArray.push(temp);
<%
					}
					else
					{
%>
						var temp=new Object();
						temp.name='<%=display_vm_name%>';
						temp.value='<%=value_vm_name%>';
						temp.state='<%=temp_vm_state%>';
						infoArray.push(temp);
<%
					}
				}
			}

			if(aList_infoState!=null && aList_infoState.size()>0)
			{
				for(int h=0;h<aList_info.size();h++)
				{
					String tempStateName=com.egurkha.util.StringUtils.replace((String)aList_info.get(h),"\\","\\\\");
					
%>
					var tempState=new Object();
					//tempState.name='<%=aList_info.get(h)%>';
					tempState.name='<%=tempStateName%>';
					tempState.value='<%=aList_infoState.get(h)%>';
					infoStateArray.push(tempState);
<%
				}
			}
%>
			if(selectedInfoState==null || selectedInfoState=="")
				selectedInfoState="GOOD";


			<%
				if(real_info!=null && real_info.trim().length()>0)
				{
					real_info=com.egurkha.util.StringUtils.replace(real_info,"+","|plus|");
					real_info=com.egurkha.util.StringUtils.replace(real_info,"&","|amp|");
					real_info=com.egurkha.util.StringUtils.replace(real_info,"%","|pct|");
					real_info=com.egurkha.util.StringUtils.replace(real_info,"#","|hash|");
					real_info = com.egurkha.util.StringUtils.replace(real_info,"\\","\\\\");
				}
				
				
			%>
			
			vmsCombo.push({
				label:'<%=egMappingInfo.getTextDescription("monitor.common.Select a VM")%>',
				name: "info" ,
				value: infoArray,
				selected:'<%=real_info%>',
				selectedState:selectedInfoState
			});

			requestParams.vmsCombo=vmsCombo; 
<%
		}
%>
		var backURL="";
		requestParams.backText='<%=egMappingInfo.getTextDescription("monitor.common.Back")%>';
<%
		if(servername!=null && servername.length() > 0)
		{
			if(source!=null && (source.equals("MainDashboard") || source.equals("userView")))
			{
%>
				requestParams.backURL="<%=Qstring%>";
<%
			}
			else
			{
%>
				requestParams.backURL="history.back()";
<%
			}
		}
		else
		{
%>
			requestParams.backURL="history.back()";
<%
		}
%>
		function refreshPage()
		{
			//removeAlert();
			//if(!layermodeltab)
			{
				//alert('isMaximizedView '+isMaximizedView);
				//if(isMaximizedView)
					//showMaximizedView(lastURL,'event','pageResize');
				//else
					//loadPage(refpagurl);
				
			}
		}
		//setInterval("refreshPage();",<%=refreshFrequency%>);
function loadMaximizedView(bigGrpUrl)
{

	showBigHighChart(bigGrpUrl);
}
function closeMaximizedView()
{
	closeBigHighchart();
}
function bigHighChart(url,divId,height,width,maxURL,timelabel,leg,title)
{
	Ext.onReady(function() 
	{
		var isAxisTimeReq = false;
		var legendPos = "bottom";
		var showTitle = false;
		maxURL = ( !Ext.isEmpty(maxURL) && (maxURL.indexOf("hasTitle") > -1) )?maxURL.substring(0,maxURL.indexOf("^eg^")):maxURL;
		if(maxURL == "close")
		{
			isAxisTimeReq = true;
			legendPos = "right";
			showTitle = true;
		}
		var containerId = divId;
		var containerObj=Ext.getCmp(containerId);
		//var errMsg = "<table border='0' height='100%' width='100%'><tr><td align='center'><img src='/final/monitor/eg_images/gray/graph_error_message.gif'></td></tr></table>";
		//var errMsg='<div style="margin:auto;padding:3px;display:inline-block;"><div style="text-align:center;font-size:12px;font-weight:bold">'+title+'</div></div>';
		var errMsg= '<center><div style="margin:12% 0 auto 0"><img class="iconExclamation" src="/final/images/spacer.gif"/><div >No measures available</div></div></center>';
		if(!Ext.isEmpty(url))
		{
			Ext.Ajax.request(
			{
				url : url,
				scope:this,
				success: function(response) 
				{
					if(response.status == 200 && !Ext.isEmpty(response))
					{
						var jsonText = response.responseText;
						if(!Ext.isEmpty(jsonText))
						{
							if(jsonText.indexOf("<HTML>") > -1 || jsonText.indexOf(".png") > -1 )
							{
								Ext.get(containerId).update(errMsg);
							}
							else
							{
								var chartData=Ext.decode(jsonText);
								try
								{
									if(!Ext.isEmpty(chartData))
									{
										chartData['enableTitle'] = showTitle;
										if( !showTitle )
											chartData['smallGraph'] = true;
										var lineChart = {};
										lineChart = jQuery.extend(true, {}, getHighCharts(containerId,height,width,maxURL), lineChart);
										lineChart.setData(chartData,'<%=dateFormatForDatePicker%>',maxURL,isAxisTimeReq,legendPos);
										lineChart.drawChart();
									}
									else
									{
										
										if(Ext.isEmpty(Ext.getCmp(containerId)))
											document.getElementById(containerId).innerHTML=errMsg;
										else
											Ext.get(containerId).update(errMsg);


									}
								
								}
								catch (e)
								{
									//Ext.getCmp(containerId).update(errMsg);
									alert("e:2:"+e);
								}
							}
						}
						else
							Ext.get(containerId).update(errMsg);
					}
					else
						Ext.get(containerId).update(errMsg);
				}
			});
		}
		else
		{
			Ext.get(containerId).update(errMsg);
		}
	});
}

		</script>
</HEAD>
<BODY class="content-frame" style="overflow:hidden" scroll="no" leftmargin="0" topmargin="0" marginheight="0" marginwidth="0" >
<div id="loadmask" class="x-mask-msg x-layer x-mask-msg-default" style="z-index: 19001;left:45%;top:35%;">
	<div class="x-mask-loading" style="position:relative">
		Loading...
	</div>
</div>
</BODY>
</HTML>
<%
}
catch(Exception e)
{
	System.out.println("e--->"+e);
	e.printStackTrace();
}
%>