<%
/********************************************************************************
FileName	:egDashboardSettings.jsp
Purpose		:This is to create a template for Monitor Dashboard
Created by	:Sathish.P
Created on	:11/03/2009
**********************************************************************************/
%>

<%@ include file = "EgLoginTracker.jsp"%>
<%@ page errorPage = "EgProbsM.jsp"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.*"%>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgDiscInfo"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.monitor.*"%>
<%@ page import = "egurkha.reporter.ErInfo"%>
<%@ page import = "egurkha.reporter.ErUtils"%>
<%@ page import = "com.egurkha.monitor.EgServerDashBoardDAO" %>
<%@ page import="com.eg.EgServicesInfo"%>
<%@ page import="com.egurkha.admin.AuditLogThread"%>
<%@ page import="com.eg.EgConfigFilesSync"%>
<%@ page import = "com.eg.supermanager.*"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%!
	EgServicesInfo egServicesInfo = new EgServicesInfo("manager");
%>
<%
try
{
	if(com.eg.EgInstallInfo.isSuperManager)
	{
		ArrayList managerIds=null;
		String hostname = request.getParameter("compName");
		if(hostname != null && hostname.trim().length()>0)
		{
			if(hostname.indexOf(":")>-1)
			{
				hostname = hostname.substring(0,hostname.indexOf(":"));
			}
			managerIds = EgElementInfo.getInstance().getManagerIDs("component",hostname);
		}
		if(managerIds != null && !managerIds.isEmpty())
		{
			SmSessionData smsData = new SmSessionData(session.getId(),managerIds);
			EgThreadLocal egtl = new EgThreadLocal();
			egtl.set(smsData);
		}
	}
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	ErInfo erInfo = new ErInfo();
	ErUtils erutils=new ErUtils();
	HealthDAO healthDAO=new HealthDAO();
	EgSpecsInfo specsInfo=new EgSpecsInfo("manager");
	EgTablesInfo tablesInfo=new EgTablesInfo("manager");
	MonitorDAOFactory monitorDaoFactory = MonitorDAOFactory.getInstance();
	EgServerDashBoardDAO dashboardDAO=monitorDaoFactory.getServerDashBoardDAO();

	String compType=request.getParameter("compType");

	String dashboardIni = "eg_serverdashboard.ini";

	EgServerDashboardModel egDashboard=null;
	if(compType!=null && compType.startsWith("Agg_"))
	{
		egDashboard=new  EgServerDashboardModel(true);
		dashboardIni = "eg_aggregateserverdashboard.ini";
	}
	else
	{
		egDashboard=new  EgServerDashboardModel();
	}
	boolean isAuditLogEnabled = egServicesInfo.isAuditlogEnabled();
	AuditLogThread auditLogThread = null;
	if(isAuditLogEnabled)
	{
		auditLogThread=new AuditLogThread();
		auditLogThread.setValue("Category","Monitor");
		auditLogThread.setValue("User_id",u_ser.getLoginID());
		auditLogThread.setValue("Host_ip",u_ser.getUserIP(session.getId()));
		auditLogThread.setValue("Session_id",session.getId());
		auditLogThread.setValue("Module","Dashboard Settings");
		auditLogThread.setValue("Activity","Configure Dashboard Settings");
		auditLogThread.setValue("Description","Dashboard Settings has been changed");
	}
	//IniFile iniobj = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_serverdashboard.ini", true);
	IniFile iniobj = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/"+dashboardIni);
	String default_type = request.getParameter("defaultTab");
	String compName=request.getParameter("compName");
	String chartType=request.getParameter("chartType");
	String graphType=request.getParameter("graphType");
	String moduleType=request.getParameter("moduleType");
	String submoduleType=request.getParameter("submoduleType");
	String testName=request.getParameter("testName");
	String measureName=request.getParameter("measureName");
	String duration=request.getParameter("duration");
	String checkbox = request.getParameter("checkbx");
	String readIni = request.getParameter("readIni");
	String from = request.getParameter("from");
	String systemTab = request.getParameter("systemTab");
	String networkTab = request.getParameter("networkTab");
	String appTab = request.getParameter("appTab");
	String customTab=request.getParameter("customTab");
	String threshold = request.getParameter("threshold");
	String disabledBlock = request.getParameter("disabledBlock");
	String sessionVal = (String)session.getAttribute("monitorLastSession");
	String blockedTables = request.getParameter("blockedTables");
	String tableName = request.getParameter("tableName");
	String modifiedValue = request.getParameter("modifiedValue");
	String tableInfo = request.getParameter("tableInfo");
	String queryString = request.getQueryString();
	String hasSeparateSection = iniobj.getValue("CommonDashboardConfiguration",compType);
	String currentValue = request.getParameter("currentValue");
	String dialChartFlag=request.getParameter("isDialChart");
	boolean isDialChart=Boolean.parseBoolean(dialChartFlag);// changed due to java 1.3
	String DialChartFlag="";
	boolean isfromSuper = session.getAttribute("fromSuper") != null &&
								session.getAttribute("fromSuper").toString().equalsIgnoreCase("yes");
	if(isfromSuper)
	{
		if(sessionVal != null && sessionVal.indexOf("?") > -1)
		{
			String url = sessionVal.substring(0,sessionVal.indexOf("?")+1);
			sessionVal = response.encodeURL(url)+sessionVal.substring(sessionVal.indexOf("?")+1);
		}
	}

	boolean issystemTab=false;
	boolean isnetworkTab=false;
	boolean isappTab=false;
	boolean isCustomTab=false;
	String[] subs = iniobj.getSubjects();
	ArrayList specificServerList = new ArrayList();
	String specificServers[] = iniobj.getVariables("CommonDashboardConfiguration");
	for(int i=0;i<specificServers.length;i++)
	{
		specificServerList.add(specificServers[i]);
	}
	if(readIni!=null && readIni.equalsIgnoreCase("true"))
	{
		if(graphType!=null && graphType.equalsIgnoreCase("Event Distribution"))
			duration = iniobj.getValue("Default_HistoricalEvents_Duration","duration");
		else if(graphType!=null && graphType.equalsIgnoreCase("Comparison Graph"))
			duration = iniobj.getValue("Default_DD_Duration","duration");
		else if(graphType!=null && graphType.equalsIgnoreCase("History Graph"))
			duration = iniobj.getValue("Default_MeasureGraph_Duration","duration");
		else if(graphType!=null && graphType.equalsIgnoreCase("Summary Graph"))
			duration = iniobj.getValue("Default_SummaryGraph_Duration","duration");
		else if(graphType!=null && graphType.equalsIgnoreCase("Trend Graph"))
			duration = iniobj.getValue("Default_TrendGraph_Duration","duration");
		else if(graphType!=null && graphType.equalsIgnoreCase("Uptime/Downtime Summary"))
			duration = iniobj.getValue("Default_UpTimeSummary_Duration","duration");
	}
	String dispName = request.getParameter("dispName");
	if(dispName== null)
		dispName="";
	String measure = request.getParameter("measureList");
	String selectedItem=request.getParameter("selectedItem");

	String mod_Submod="";
	if(moduleType!=null && !moduleType.equals("-1") && submoduleType!=null && !submoduleType.equals("-1"))
	{
		mod_Submod=moduleType+"_"+submoduleType;
	}
	String avail_block = iniobj.getValue("Enabled_blocks",mod_Submod);
	Vector availableBlocks = new Vector();
	StringTokenizer stk = new StringTokenizer(avail_block,",");
	while(stk.hasMoreTokens())
	{
		availableBlocks.add(stk.nextToken());
	}

	String disabled_block = iniobj.getValue("Disabled_blocks",mod_Submod);
	Vector disabledBlocks = new Vector();
	int disabledBlocksSize = disabledBlocks.size();
	StringTokenizer strtk = new StringTokenizer(disabled_block,",");
	while(strtk.hasMoreTokens())
	{
		disabledBlocks.add(strtk.nextToken());
	}
	EgMemCheck memCheck = new EgMemCheck();
	boolean hasConfig=memCheck.isCMEnabled();
	if(hasConfig)
		disabledBlocks.remove("Layerhealth");

	Vector measures = new Vector();
	if(testName!=null && testName.length()>0 &&!chartType.equals("DialGraphs") )
	{
		measures = erInfo.getMeasuresForTest(1,testName);
	}
	Vector measuresFilder=new Vector();
	if(testName!=null && testName.length()>0&&chartType.equals("DialGraphs") )
	{
		measuresFilder=erInfo.getMeasuresForTest(1,testName);
		if(measuresFilder!=null &&measuresFilder.size()>0)
		{
			for(int i=0;i<measuresFilder.size();i++)
			{
				String tempMeasure=(String)measuresFilder.get(i);
				String unit=tablesInfo.getUnitForMeasure(testName,tempMeasure);
				if(unit!=null&& unit.equalsIgnoreCase("percent") || unit.equalsIgnoreCase("percentage") || unit.equals("%"))
				{
						measures.addElement(tempMeasure);
				}
			}
		}
	}

	String userLanguage = u_ser.getLanguage();
	if(default_type== null || default_type=="")
	{
		default_type=iniobj.getValue("Dashboard_Settings","TabPriority");
		default_type=(default_type==null)?"":default_type;
	}
	IniUI  iniUI = IniUI.getInstance();
	if (userLanguage == null)
	{
		userLanguage = iniUI.getDefaultLanguage();
	}
	EgMappingInfo _mapping = new EgMappingInfo(userLanguage);
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	Vector layersForCompType=new Vector();
	layersForCompType=dashboardDAO.getLayerForCompType(compType);
	String excludedServersForDashBoard[]=iniobj.getVariables("Dashboard_Excluded_servers");
	List excludedServers=new ArrayList();
	if(excludedServersForDashBoard!=null && excludedServersForDashBoard.length>0)
	{
		for(int i=0;i<excludedServersForDashBoard.length;i++)
		{
			String value=iniobj.getValue("Dashboard_Excluded_servers",excludedServersForDashBoard[i]);
			if(value!=null && value.equalsIgnoreCase("Yes"))
			{
				excludedServers.add(excludedServersForDashBoard[i]);
			}
		}
	}
	
	String s_specificsubject=iniobj.getValue("CommonDashboardConfiguration",compType);
	boolean isSpecificSubject=(s_specificsubject!=null && s_specificsubject.equalsIgnoreCase("yes"));
	String key="";
	String subSystems="";
	if(s_specificsubject!=null && s_specificsubject.equalsIgnoreCase("yes")) 
	{
		key=moduleType+"_subsystems";
		subSystems = iniobj.getValue(compType,key);
	}
	else
	{
		key=moduleType+"_subsystems";
		subSystems = iniobj.getValue(moduleType+"_Dashboard_Metrics",key);
	}

	if(moduleType!=null && moduleType.equalsIgnoreCase("Application"))
	{
		subSystems = iniobj.getValue(compType,key);
	}
	Vector subSystemList = new Vector();
	StringTokenizer strTok = new StringTokenizer(subSystems,":");
	if(moduleType!=null && !moduleType.equalsIgnoreCase("Network"))
	{
		while(strTok.hasMoreTokens())
		{
			subSystemList.add(strTok.nextToken());
		}
	}
	if(moduleType!=null && moduleType.equalsIgnoreCase("Network"))
	{
		Vector componentLayers=egDashboard.getLayerForCompType(compType);
		if(isSpecificSubject)
		{
			while(strTok.hasMoreTokens())
			{
				subSystemList.add(strTok.nextToken());
			}
		}
		else
		{
			while(strTok.hasMoreTokens())
			{
				String token=strTok.nextToken();
				String testmeasures=iniobj.getValue(moduleType+"_Dashboard_Metrics","Network_"+token);
				StringTokenizer stkSubSystemTestMeasures=new StringTokenizer(testmeasures,",");
				while(stkSubSystemTestMeasures.hasMoreTokens())
				{
					String subSystemTestMeasures=stkSubSystemTestMeasures.nextToken();
					String subSystemTest=subSystemTestMeasures.substring(0,subSystemTestMeasures.indexOf(":"));
					if(specsInfo.isTestRelevantForServer(compType,subSystemTest))
					{
						subSystemList.add(token);
						break;
					}
				}
			}
		}
	}
	if(chartType!=null && chartType.equalsIgnoreCase("PerformanceIndicators"))
	{
		subSystemList = new Vector();
		subSystemList.add("Overview");
	}
	String[] options;
	options=new String[] {"1 hour","3 hours","6 hours","9 hours","12 hours","15 hours","18 hours","21 hours","24 hours","2 days","3 days","4 days","5 days","6 days","1 week","2 weeks","3 weeks","4 weeks","1 month","2 months"};

	String mode=request.getParameter("mode");
	issystemTab = (systemTab!=null && systemTab.equalsIgnoreCase("true"))?true:false;
	isnetworkTab = (networkTab!=null && networkTab.equalsIgnoreCase("true"))?true:false;
	isappTab = (appTab!=null && appTab.equalsIgnoreCase("true"))?true:false;
	isCustomTab = (customTab!=null && customTab.equalsIgnoreCase("true"))?true:false;

	if(mode!=null && mode.equalsIgnoreCase("save"))
	{
		if(isAuditLogEnabled)
		{
			String previousPriority=iniobj.getValue("Dashboard_Settings","TabPriority");
			if(previousPriority!=null && !previousPriority.equalsIgnoreCase(default_type))
			{
				auditLogThread.setPreviousValue("Default Tab Priority",previousPriority);
				auditLogThread.setCurrentValue("Default Tab Priority",default_type);
			}
		}
		iniobj.setValue("Dashboard_Settings","TabPriority",default_type);
		if(issystemTab)
		{
			if(isAuditLogEnabled)
			{
				String previousTabSettings=iniobj.getValue("System_Dashboard",compType);
				if(previousTabSettings!=null && !previousTabSettings.equalsIgnoreCase("yes"))
				{
					auditLogThread.setPreviousValue("System Dashboard Enabled",previousTabSettings);
					auditLogThread.setCurrentValue("System Dashboard Enabled","Yes");
				}
			}
			iniobj.setValue("System_Dashboard",compType,"Yes");
		}
		else
		{
			if(isAuditLogEnabled)
			{
				String previousTabSettings=iniobj.getValue("System_Dashboard",compType);
				if(previousTabSettings!=null && !previousTabSettings.equalsIgnoreCase("no"))
				{
					auditLogThread.setPreviousValue("System Dashboard Enabled",previousTabSettings);
					auditLogThread.setCurrentValue("System Dashboard Enabled","No");
				}
			}
			iniobj.setValue("System_Dashboard",compType,"No");
		}
		if(isnetworkTab)
		{
			if(isAuditLogEnabled)
			{
				String previousTabSettings=iniobj.getValue("Network_Dashboard",compType);
				if(previousTabSettings!=null && !previousTabSettings.equalsIgnoreCase("yes"))
				{
					auditLogThread.setPreviousValue("Network Dashboard Enabled",previousTabSettings);
					auditLogThread.setCurrentValue("Network Dashboard Enabled","Yes");
				}
			}
			iniobj.setValue("Network_Dashboard",compType,"Yes");
		}
		else
		{
			if(isAuditLogEnabled)
			{
				String previousTabSettings=iniobj.getValue("Network_Dashboard",compType);
				if(previousTabSettings!=null && !previousTabSettings.equalsIgnoreCase("no"))
				{
					auditLogThread.setPreviousValue("Network Dashboard Enabled",previousTabSettings);
					auditLogThread.setCurrentValue("Network Dashboard Enabled","No");
				}
			}
			iniobj.setValue("Network_Dashboard",compType,"No");
		}
		if(isappTab)
		{
			if(isAuditLogEnabled)
			{
				String previousTabSettings=iniobj.getValue("Application_Dashboard",compType);
				if(previousTabSettings!=null && !previousTabSettings.equalsIgnoreCase("yes"))
				{
					auditLogThread.setPreviousValue("Application Dashboard Enabled",previousTabSettings);
					auditLogThread.setCurrentValue("Application Dashboard Enabled","Yes");
				}
			}
			iniobj.setValue("Application_Dashboard",compType,"Yes");
		}
		else
		{
			if(isAuditLogEnabled)
			{
				String previousTabSettings=iniobj.getValue("Application_Dashboard",compType);
				if(previousTabSettings!=null && !previousTabSettings.equalsIgnoreCase("no"))
				{
					auditLogThread.setPreviousValue("Application Dashboard Enabled",previousTabSettings);
					auditLogThread.setCurrentValue("Application Dashboard Enabled","No");
				}
			}
			iniobj.setValue("Application_Dashboard",compType,"No");
		}

		if(isCustomTab)
		{
			if(isAuditLogEnabled)
			{
				String previousTabSettings=iniobj.getValue("Custom_Dashboard",compType);
				if(previousTabSettings!=null && !previousTabSettings.equalsIgnoreCase("yes"))
				{
					auditLogThread.setPreviousValue("Custom Dashboard Enabled",previousTabSettings);
					auditLogThread.setCurrentValue("Custom Dashboard Enabled","Yes");
				}
			}
			iniobj.setValue("Custom_Dashboard",compType,"Yes");
		}
		else
		{
			if(isAuditLogEnabled)
			{
				String previousTabSettings=iniobj.getValue("Custom_Dashboard",compType);
				if(previousTabSettings!=null && !previousTabSettings.equalsIgnoreCase("no"))
				{
					auditLogThread.setPreviousValue("Custom Dashboard Enabled",previousTabSettings);
					auditLogThread.setCurrentValue("Custom Dashboard Enabled","No");
				}
			}
			iniobj.setValue("Custom_Dashboard",compType,"No");
		}

		if(graphType!=null && graphType.equalsIgnoreCase("Event Distribution"))
		{
			if(isAuditLogEnabled)
			{
				String previousDuration=iniobj.getValue("Default_HistoricalEvents_Duration","duration");
				if(previousDuration!=null && !previousDuration.equalsIgnoreCase(duration))
				{
					auditLogThread.setPreviousValue("Default Event History Duration",previousDuration);
					auditLogThread.setCurrentValue("Default Event History Duration",duration);
				}
			}
			iniobj.setValue("Default_HistoricalEvents_Duration","duration",duration);
		}
		else if(graphType!=null && graphType.equalsIgnoreCase("Comparison Graph"))
		{
			if(isAuditLogEnabled)
			{
				String previousDuration=iniobj.getValue("Default_DD_Duration","duration");
				if(previousDuration!=null && !previousDuration.equalsIgnoreCase(duration))
				{
					auditLogThread.setPreviousValue("Default Comparison Graph Duration",previousDuration);
					auditLogThread.setCurrentValue("Default Comparison Graph Duration",duration);
				}
			}
			iniobj.setValue("Default_DD_Duration","duration",duration);
		}
		else if(graphType!=null && graphType.equalsIgnoreCase("History Graph"))
		{
			if(isAuditLogEnabled)
			{
				String previousDuration=iniobj.getValue("Default_MeasureGraph_Duration","duration");
				if(previousDuration!=null && !previousDuration.equalsIgnoreCase(duration))
				{
					auditLogThread.setPreviousValue("Default History Graph Duration",previousDuration);
					auditLogThread.setCurrentValue("Default History Graph Duration",duration);
				}
			}
			iniobj.setValue("Default_MeasureGraph_Duration","duration",duration);
		}
		else if(graphType!=null && graphType.equalsIgnoreCase("Summary Graph"))
		{
			if(isAuditLogEnabled)
			{
				String previousDuration=iniobj.getValue("Default_SummaryGraph_Duration","duration");
				if(previousDuration!=null && !previousDuration.equalsIgnoreCase(duration))
				{
					auditLogThread.setPreviousValue("Default Summary Graph Duration",previousDuration);
					auditLogThread.setCurrentValue("Default Summary Graph Duration",duration);
				}
			}
			iniobj.setValue("Default_SummaryGraph_Duration","duration",duration);
		}
		else if(graphType!=null && graphType.equalsIgnoreCase("Trend Graph"))
		{
			if(isAuditLogEnabled)
			{
				String previousDuration=iniobj.getValue("Default_TrendGraph_Duration","duration");
				if(previousDuration!=null && !previousDuration.equalsIgnoreCase(duration))
				{
					auditLogThread.setPreviousValue("Default Trend Graph Duration",previousDuration);
					auditLogThread.setCurrentValue("Default Trend Graph Duration",duration);
				}
			}
			iniobj.setValue("Default_TrendGraph_Duration","duration",duration);
		}
		else if(graphType!=null && graphType.equalsIgnoreCase("Uptime/Downtime Summary"))
		{
			if(isAuditLogEnabled)
			{
				String previousDuration=iniobj.getValue("Default_UpTimeSummary_Duration","duration");
				if(previousDuration!=null && !previousDuration.equalsIgnoreCase(duration))
				{
					auditLogThread.setPreviousValue("Default Uptime Summary Duration",previousDuration);
					auditLogThread.setCurrentValue("Default Uptime Summary Duration",duration);
				}
			}
			iniobj.setValue("Default_UpTimeSummary_Duration","duration",duration);
		}
		if(isDialChart)
			DialChartFlag="Yes";
		else
			DialChartFlag="No";
		if(DialChartFlag!=null)
		{
			if(isAuditLogEnabled)
			{
				String previousDialChartFlag=iniobj.getValue("Dashboard_Settings","UseDial");
				if(previousDialChartFlag!=null && !previousDialChartFlag.equalsIgnoreCase(DialChartFlag))
				{
					auditLogThread.setPreviousValue("Dial Chart Enabled",previousDialChartFlag);
					auditLogThread.setCurrentValue("Dial Chart Enabled",DialChartFlag);
				}
			}
			iniobj.setValue("Dashboard_Settings","UseDial",DialChartFlag);
		}
		if(threshold!=null && threshold.equalsIgnoreCase("true"))
			threshold="Yes";
		else
			threshold="No";
		if(threshold!=null)
		{
			if(isAuditLogEnabled)
			{
				String previousThresholdFlag=iniobj.getValue("Dashboard_Settings","ApplyThreshold");
				if(previousThresholdFlag!=null && !previousThresholdFlag.equalsIgnoreCase(threshold))
				{
					auditLogThread.setPreviousValue("Apply Threshold",previousThresholdFlag);
					auditLogThread.setCurrentValue("Apply Threshold",threshold);
				}
			}
			iniobj.setValue("Dashboard_Settings","ApplyThreshold",threshold);
		}

		if(moduleType!=null && submoduleType!=null)
		{
			String hiddenBlocks = iniobj.getValue("Disabled_blocks",mod_Submod);
			Vector disableBlock = new Vector();
			disableBlock = egDashboard.getTokensAsVector(hiddenBlocks,",");
			StringTokenizer tok = new StringTokenizer(blockedTables,",");
			while(tok.hasMoreTokens())
			{
				String val = tok.nextToken();
				if(disableBlock.contains(val))
					disableBlock.remove(val);
			}
			String iniValue = "";
			StringBuffer disbaledBlockBuf=new StringBuffer();
			StringBuffer sbDisabledBlocks=new StringBuffer();
			for(int q=0;q<disableBlock.size();q++)
			{
				String tempVal1=(String)disableBlock.get(q);
				disbaledBlockBuf.append(tempVal1 + ",");
				String tmpMapping=iniobj.getValue("Dashboard_Comparison_TableTitle",tempVal1);
				if(tmpMapping.equals(""))
					tmpMapping = tempVal1;
				sbDisabledBlocks.append(tmpMapping+",");
			}
			iniValue=disbaledBlockBuf.toString();
			String disabledBlocksForAuditlog=sbDisabledBlocks.toString();
			if(disabledBlocksForAuditlog!=null && disabledBlocksForAuditlog.endsWith(","))
			{
				disabledBlocksForAuditlog=disabledBlocksForAuditlog.substring(0,(disabledBlocksForAuditlog.length()-1));
			}
			if(iniValue.endsWith(","))
				iniValue = iniValue.substring(0,iniValue.length()-1);
			if(blockedTables!=null)
			{
				String previousDisabledBlocks=iniobj.getValue("Disabled_blocks",mod_Submod);
				if(previousDisabledBlocks!=null && !previousDisabledBlocks.equals(""))
				{
					StringBuffer sbPrevDisabledBlocks=new StringBuffer();
					StringTokenizer stkPrevDisabledBlocks=new StringTokenizer(previousDisabledBlocks,",");
					while(stkPrevDisabledBlocks.hasMoreTokens())
					{
						String prevDisabledBlock=stkPrevDisabledBlocks.nextToken();
						String tmpMapping=iniobj.getValue("Dashboard_Comparison_TableTitle",prevDisabledBlock);
						if(tmpMapping.equals(""))
							tmpMapping = prevDisabledBlock;
						sbPrevDisabledBlocks.append(tmpMapping+",");
					}
					previousDisabledBlocks=sbPrevDisabledBlocks.toString();
					if(previousDisabledBlocks!=null && previousDisabledBlocks.endsWith(","))
					{
						previousDisabledBlocks=previousDisabledBlocks.substring(0,(previousDisabledBlocks.length()-1));
					}
				}
				if(isAuditLogEnabled)
				{
					if(previousDisabledBlocks!=null && !previousDisabledBlocks.equalsIgnoreCase(disabledBlocksForAuditlog))
					{
						auditLogThread.setPreviousValue("Disabled blocks",previousDisabledBlocks);
						auditLogThread.setCurrentValue("Disabled blocks",disabledBlocksForAuditlog);
					}
				}
				iniobj.setValue("Disabled_blocks",mod_Submod,iniValue);
				iniobj.saveFile(true);
			}
		}

		String tmpKey = moduleType+"_"+submoduleType+"_"+chartType;
		String keyForAuditlog=chartType+" for "+moduleType+" Tab "+submoduleType+" subsystem";
		if(chartType!=null && chartType.equalsIgnoreCase("HistoryGraph"))
		{
			tmpKey = moduleType+"_"+submoduleType;
			keyForAuditlog="History Graphs for "+moduleType+" Tab "+submoduleType+" subsystem";
		}
		else if(chartType!=null && chartType.equalsIgnoreCase("PerformanceIndicators"))
		{
			tmpKey = moduleType+"_"+chartType;
			keyForAuditlog="Key Performance Indicators for "+moduleType+" Tab "+submoduleType+" subsystem";
		}
		else if(chartType!=null && chartType.equalsIgnoreCase("comparisonGraph"))
		{
			tmpKey = moduleType+"_DD_"+submoduleType;
			keyForAuditlog="Comparison Graphs for "+moduleType+" Tab "+submoduleType+" subsystem";
		}
		else if(chartType!=null && chartType.equalsIgnoreCase("configtable"))
		{
			tmpKey = moduleType+"_config";
			keyForAuditlog=moduleType+" Configuration Details for "+moduleType+" Tab "+submoduleType+" subsystem";
		}

		String comparVal="";
		String tmpTst="";
		String tmpMsr="";
		String tmpDisp="";
		String tmpexistingValues="";
		String valu="";
		StringBuffer sbVal=new StringBuffer();
		StringTokenizer stTk2 = new StringTokenizer(selectedItem,",");
		while(stTk2.hasMoreTokens())
		{
			tmpexistingValues = stTk2.nextToken();
			tmpTst = tmpexistingValues.substring(0,tmpexistingValues.indexOf(":"));
			if(tmpexistingValues.indexOf("|") >0)
			{
				tmpMsr = tmpexistingValues.substring(tmpexistingValues.indexOf(":")+1,tmpexistingValues.indexOf("|"));
				tmpDisp = tmpexistingValues.substring(tmpexistingValues.indexOf("|")+1,tmpexistingValues.length());
				String measureMap = _mapping.getMeasureDescription(tmpTst,tmpMsr);
				if(!measureMap.equals(tmpDisp))
				{
					String testMeasure=tmpTst+":"+tmpMsr;
					if(chartType!=null && chartType.equalsIgnoreCase("comparisongraph"))
					{
						if(isAuditLogEnabled)
						{
							String previousMapping=iniobj.getValue("Dashboard_ComparisonGraph_Mapping",testMeasure);
							if(previousMapping!=null && (previousMapping.equals("") || previousMapping.equalsIgnoreCase("null")))
								previousMapping=measureMap;
							if(previousMapping!=null && !previousMapping.equalsIgnoreCase(tmpDisp))
							{
								auditLogThread.setPreviousValue("Comparison Graph Title",previousMapping);
								auditLogThread.setCurrentValue("Comparison Graph Title",tmpDisp);
							}
						}
						iniobj.setValue("Dashboard_ComparisonGraph_Mapping",testMeasure,tmpDisp);
					}
					else if(chartType!=null && chartType.equalsIgnoreCase("DialGraphs"))
					{
						if(isAuditLogEnabled)
						{
							String previousMapping=iniobj.getValue("Dashboard_Dial_mapping",testMeasure);
							if(previousMapping!=null && (previousMapping.equals("") || previousMapping.equalsIgnoreCase("null")))
								previousMapping=measureMap;
							if(previousMapping!=null && !previousMapping.equalsIgnoreCase(tmpDisp))
							{
								auditLogThread.setPreviousValue("Dial Chart Title",previousMapping);
								auditLogThread.setCurrentValue("Dial Chart Title",tmpDisp);
							}
						}
						iniobj.setValue("Dashboard_Dial_mapping",testMeasure,tmpDisp);
					}
					else if(chartType!=null && chartType.equalsIgnoreCase("DigitalGraphs"))
					{
						if(isAuditLogEnabled)
						{
							String previousMapping=iniobj.getValue("Dashboard_Digital_mapping",testMeasure);
							if(previousMapping!=null && (previousMapping.equals("") || previousMapping.equalsIgnoreCase("null")))
								previousMapping=measureMap;
							if(previousMapping!=null && !previousMapping.equalsIgnoreCase(tmpDisp))
							{
								auditLogThread.setPreviousValue("Digital Chart Title",previousMapping);
								auditLogThread.setCurrentValue("Digital Chart Title",tmpDisp);
							}
						}
						iniobj.setValue("Dashboard_Digital_mapping",testMeasure,tmpDisp);
					}
					else if(chartType!=null && chartType.equalsIgnoreCase("PerformanceIndicators"))
					{
						if(isAuditLogEnabled)
						{
							String previousMapping=iniobj.getValue("Dashboard_KPI_mapping",testMeasure);
							if(previousMapping!=null && (previousMapping.equals("") || previousMapping.equalsIgnoreCase("null")))
								previousMapping=measureMap;
							if(previousMapping!=null && !previousMapping.equalsIgnoreCase(tmpDisp))
							{
								auditLogThread.setPreviousValue("Key Performance Indicators Measures Mapping",previousMapping);
								auditLogThread.setCurrentValue("Key Performance Indicators Measures Mapping",tmpDisp);
							}
						}
						iniobj.setValue("Dashboard_KPI_mapping",testMeasure,tmpDisp);
					}
					else
					{
						if(isAuditLogEnabled)
						{
							String previousMapping=iniobj.getValue("Dashboard_measures_mapping",testMeasure);
							if(previousMapping!=null && (previousMapping.equals("") || previousMapping.equalsIgnoreCase("null")))
								previousMapping=measureMap;
							if(previousMapping!=null && !previousMapping.equalsIgnoreCase(tmpDisp))
							{
								auditLogThread.setPreviousValue("History Graph Title",previousMapping);
								auditLogThread.setCurrentValue("History Graph Title",tmpDisp);
							}
						}
						iniobj.setValue("Dashboard_measures_mapping",testMeasure,tmpDisp);
					}
				}
			}
			else
			{
				tmpMsr = tmpexistingValues.substring(tmpexistingValues.indexOf(":")+1,tmpexistingValues.length());
			}
			sbVal.append(tmpTst+":"+tmpMsr+",");
		}
		valu=sbVal.toString();
		if(valu.endsWith(","))
			valu =valu.substring(0,valu.length()-1);
		comparVal= valu;

		if(chartType!=null && chartType.equalsIgnoreCase("comparisonGraph"))
		{
			String section="";
			String tmpStr="";
			if((moduleType!=null && moduleType.equalsIgnoreCase("Application")) || (hasSeparateSection!=null && hasSeparateSection.equalsIgnoreCase("Yes")))
				section = compType;
			else
				section = moduleType+"_Dashboard_Metrics";
			String graphValues = iniobj.getValue(section,tmpKey);
			Vector cmpGraph = new Vector();
			StringTokenizer tok = new StringTokenizer(graphValues,",");
			while(tok.hasMoreTokens())
			{
				String val = tok.nextToken();
				if(val.indexOf("#Format")>0)
					cmpGraph.add(val);
			}
			StringBuffer cmpGrphVals=new StringBuffer();
			for(int k=0;k<cmpGraph.size();k++)
			{
				String tmpStr1=(String)cmpGraph.get(k)+",";
				cmpGrphVals.append(tmpStr1);
			}
			tmpStr=cmpGrphVals.toString();
			if(tmpStr.endsWith(","))
				tmpStr=tmpStr.substring(0,tmpStr.length()-1);
			comparVal= tmpStr + "," + comparVal;
		}

// Code for Deletion
		String previousValueForAuditlog="";
		StringBuffer sbPreviousTextValueForAuditlog=new StringBuffer();
		String existingValue = iniobj.getValue(moduleType+"_Dashboard_Metrics",tmpKey);
		if(moduleType!=null && moduleType.equalsIgnoreCase("Application"))
			existingValue = iniobj.getValue(compType,tmpKey);
		Vector availableValues = new Vector();
		Vector currentValues = new Vector();
		Vector removeMapping = new Vector();
		StringTokenizer strToken = new StringTokenizer(existingValue,",");
		while(strToken.hasMoreTokens())
		{
			String tokens = strToken.nextToken();
			if(tokens!=null && (tokens.indexOf(":")>0 && tokens.indexOf("#")==-1))
			{
				String testNameForALog=tokens.substring(0,tokens.indexOf(":"));
				String measNameForALog=tokens.substring(tokens.indexOf(":")+1,tokens.length());	sbPreviousTextValueForAuditlog.append(_mapping.getMeasureDescription(testNameForALog,measNameForALog)+",");
			}
			if(tokens.indexOf("#")>0)
				tokens=tokens.substring(0,tokens.indexOf("#"));
			availableValues.add(tokens);
		}
		previousValueForAuditlog=sbPreviousTextValueForAuditlog.toString();
		if(previousValueForAuditlog!=null && previousValueForAuditlog.endsWith(","))
			previousValueForAuditlog=previousValueForAuditlog.substring(0,(previousValueForAuditlog.length()-1));
		StringBuffer sbTextValueForAuditlog=new StringBuffer();
		String mappedTextValueForAudtilog="";
		StringTokenizer currentToken = new StringTokenizer(comparVal,",");
		while(currentToken.hasMoreTokens())
		{
			String currentVal=currentToken.nextToken();
			if(currentVal!=null && (currentVal.indexOf(":")>0 && currentVal.indexOf("#")==-1))
			{
				String testNameForALog=currentVal.substring(0,currentVal.indexOf(":"));
				String measNameForALog=currentVal.substring(currentVal.indexOf(":")+1,currentVal.length());			sbTextValueForAuditlog.append(_mapping.getMeasureDescription(testNameForALog,measNameForALog)+",");
			}
			currentValues.add(currentVal);
		}
		mappedTextValueForAudtilog=sbTextValueForAuditlog.toString();
		if(mappedTextValueForAudtilog!=null && mappedTextValueForAudtilog.endsWith(","))
			mappedTextValueForAudtilog=mappedTextValueForAudtilog.substring(0,(mappedTextValueForAudtilog.length()-1));
		for(int j=0;j<availableValues.size();j++)
		{
			if(!currentValues.contains(availableValues.get(j)))
				removeMapping.add(availableValues.get(j));
		}
		if(removeMapping!=null && removeMapping.size()>0)
		{
			String sectionName="";
			if(chartType!=null && chartType.equalsIgnoreCase("DialGraphs"))
				sectionName="Dashboard_Dial_mapping";
			else if(chartType!=null && chartType.equalsIgnoreCase("DigitalGraphs"))
				sectionName="Dashboard_Digital_mapping";
			else if(chartType!=null && chartType.equalsIgnoreCase("HistoryGraph"))
				sectionName="Dashboard_measures_mapping";
			else if(chartType!=null && chartType.equalsIgnoreCase("PerformanceIndicators"))
				sectionName="Dashboard_KPI_mapping";
			else if(chartType!=null && chartType.equalsIgnoreCase("comparisongraph"))
				sectionName="Dashboard_ComparisonGraph_Mapping";
			for(int k=0;k<removeMapping.size();k++)
			{
				iniobj.deleteValue(sectionName,(String)removeMapping.get(k));
				//iniobj.saveFile();
			}
		}
//Ends
		if(tmpKey.indexOf("-1")<0)
		{
			if((moduleType!=null && moduleType.equalsIgnoreCase("Application")) || (hasSeparateSection!=null && hasSeparateSection.equalsIgnoreCase("yes")))
			{
				if(isAuditLogEnabled)
				{
					if(previousValueForAuditlog!=null && !previousValueForAuditlog.equalsIgnoreCase(mappedTextValueForAudtilog))
					{
						auditLogThread.setPreviousValue(keyForAuditlog,previousValueForAuditlog);
						auditLogThread.setCurrentValue(keyForAuditlog,mappedTextValueForAudtilog);
					}
				}
				iniobj.setValue(compType,tmpKey,comparVal);
			}
			else
			{
				if(isAuditLogEnabled)
				{
					if(previousValueForAuditlog!=null && !previousValueForAuditlog.equalsIgnoreCase(mappedTextValueForAudtilog))
					{
						auditLogThread.setPreviousValue(keyForAuditlog,previousValueForAuditlog);
						auditLogThread.setCurrentValue(keyForAuditlog,mappedTextValueForAudtilog);
					}
				}
				iniobj.setValue(moduleType+"_Dashboard_Metrics",tmpKey,comparVal);
			}
		}

		if(modifiedValue!=null && modifiedValue.length()>0)
		{
			String modTestMeasure = modifiedValue.substring(0,modifiedValue.lastIndexOf("|"));
			String displayName = modifiedValue.substring(modifiedValue.lastIndexOf("|")+1,modifiedValue.length());
			if(chartType!=null && chartType.equalsIgnoreCase("comparisongraph"))
			{
				if(isAuditLogEnabled)
				{
					String previousMapping=iniobj.getValue("Dashboard_ComparisonGraph_Mapping",modTestMeasure);
					if(previousMapping!=null && (previousMapping.equals("") || previousMapping.equalsIgnoreCase("null")))
					{
						if(modTestMeasure!=null && modTestMeasure.indexOf(":")>0)
						{
							String testForMap=modTestMeasure.substring(0,modTestMeasure.indexOf(":"));
							String measureForMap=modTestMeasure.substring(modTestMeasure.indexOf(":")+1,modTestMeasure.length());
							previousMapping=_mapping.getMeasureDescription(testForMap,measureForMap);
						}
					}
					if(previousMapping!=null && !previousMapping.equalsIgnoreCase(displayName))
					{
						auditLogThread.setPreviousValue("Comparison Graph Title",previousMapping);
						auditLogThread.setCurrentValue("Comparison Graph Title",displayName);
					}
				}
				iniobj.setValue("Dashboard_ComparisonGraph_Mapping",modTestMeasure,displayName);
			}
			else if(chartType!=null && chartType.equalsIgnoreCase("DialGraphs"))
			{
				String previousMapping=iniobj.getValue("Dashboard_Dial_mapping",modTestMeasure);
				if(isAuditLogEnabled)
				{
					if(previousMapping!=null && (previousMapping.equals("") || previousMapping.equalsIgnoreCase("null")))
					{
						if(modTestMeasure!=null && modTestMeasure.indexOf(":")>0)
						{
							String testForMap=modTestMeasure.substring(0,modTestMeasure.indexOf(":"));
							String measureForMap=modTestMeasure.substring(modTestMeasure.indexOf(":")+1,modTestMeasure.length());
							previousMapping=_mapping.getMeasureDescription(testForMap,measureForMap);
						}
					}
					if(previousMapping!=null && !previousMapping.equalsIgnoreCase(displayName))
					{
						auditLogThread.setPreviousValue("Dial Chart Title",previousMapping);
						auditLogThread.setCurrentValue("Dial Chart Title",displayName);
					}
				}
				iniobj.setValue("Dashboard_Dial_mapping",modTestMeasure,displayName);
			}
			else if(chartType!=null && chartType.equalsIgnoreCase("DigitalGraphs"))
			{
				String previousMapping=iniobj.getValue("Dashboard_Digital_mapping",modTestMeasure);
				if(isAuditLogEnabled)
				{
					if(previousMapping!=null && (previousMapping.equals("") || previousMapping.equalsIgnoreCase("null")))
					{
						if(modTestMeasure!=null && modTestMeasure.indexOf(":")>0)
						{
							String testForMap=modTestMeasure.substring(0,modTestMeasure.indexOf(":"));
							String measureForMap=modTestMeasure.substring(modTestMeasure.indexOf(":")+1,modTestMeasure.length());
							previousMapping=_mapping.getMeasureDescription(testForMap,measureForMap);
						}
					}
					if(previousMapping!=null && !previousMapping.equalsIgnoreCase(displayName))
					{
						auditLogThread.setPreviousValue("Digital Chart Title",previousMapping);
						auditLogThread.setCurrentValue("Digital Chart Title",displayName);
					}
				}
				iniobj.setValue("Dashboard_Digital_mapping",modTestMeasure,displayName);
			}
			else if(chartType!=null && chartType.equalsIgnoreCase("PerformanceIndicators"))
			{
				if(isAuditLogEnabled)
				{
					String previousMapping=iniobj.getValue("Dashboard_KPI_mapping",modTestMeasure);
					if(previousMapping!=null && (previousMapping.equals("") || previousMapping.equalsIgnoreCase("null")))
					{
						if(modTestMeasure!=null && modTestMeasure.indexOf(":")>0)
						{
							String testForMap=modTestMeasure.substring(0,modTestMeasure.indexOf(":"));
							String measureForMap=modTestMeasure.substring(modTestMeasure.indexOf(":")+1,modTestMeasure.length());
							previousMapping=_mapping.getMeasureDescription(testForMap,measureForMap);
						}
					}
					if(previousMapping!=null && !previousMapping.equalsIgnoreCase(displayName))
					{
						auditLogThread.setPreviousValue("Key Performance Indicators Measure Mapping",previousMapping);
						auditLogThread.setCurrentValue("Key Performance Indicators Measure Mapping",displayName);
					}
				}
				iniobj.setValue("Dashboard_KPI_mapping",modTestMeasure,displayName);
			}
			else
			{
				if(isAuditLogEnabled)
				{
					String previousMapping=iniobj.getValue("Dashboard_measures_mapping",modTestMeasure);
					if(previousMapping!=null && (previousMapping.equals("") || previousMapping.equalsIgnoreCase("null")))
					{
						if(modTestMeasure!=null && modTestMeasure.indexOf(":")>0)
						{
							String testForMap=modTestMeasure.substring(0,modTestMeasure.indexOf(":"));
							String measureForMap=modTestMeasure.substring(modTestMeasure.indexOf(":")+1,modTestMeasure.length());
							previousMapping=_mapping.getMeasureDescription(testForMap,measureForMap);
						}
					}
					if(previousMapping!=null && !previousMapping.equalsIgnoreCase(displayName))
					{
						auditLogThread.setPreviousValue("History Graph Title",previousMapping);
						auditLogThread.setCurrentValue("History Graph Title",displayName);
					}
				}
				iniobj.setValue("Dashboard_measures_mapping",modTestMeasure,displayName);
			}
		}
		if(tableInfo !=null && tableInfo.length()>0)
			iniobj.setValue("Dashboard_Info_Mapping",testName,tableInfo);

		iniobj.saveFile();
		if(isAuditLogEnabled)
			auditLogThread.sendItToDB();
	}
	boolean isICComponent=compType!=null && compType.endsWith("_ex");
	boolean isExcludedServer=(excludedServers!=null && excludedServers.contains(compType));
	String isSystemDashboard = iniobj.getValue("System_Dashboard",compType);
	String isNetworkDashboard = iniobj.getValue("Network_Dashboard",compType);
	String isApplicationDashboard = iniobj.getValue("Application_Dashboard",compType);
	String isCustomDashboard=iniobj.getValue("Custom_Dashboard",compType);

	boolean isSystemDashboardEnabled = (isSystemDashboard!=null && isSystemDashboard.equalsIgnoreCase("No"))?false:true;
	boolean isNetworkDashboardEnabled = (isNetworkDashboard!=null && isNetworkDashboard.equalsIgnoreCase("No"))?false:true;
	boolean isApplicationDashboardEnabled = (isApplicationDashboard!=null && isApplicationDashboard.equalsIgnoreCase("No"))?false:true;

	boolean isCustomDashEnabled = (isCustomDashboard!=null && isCustomDashboard.equalsIgnoreCase("No"))?false:true;

	boolean isAppFound=false;
	List subjects=Arrays.asList(iniobj.getSubjects());
	
	if(subjects.contains(compType))
		isAppFound=true;

	if(from!=null && from.equalsIgnoreCase("dashboard"))
	{
		issystemTab=isSystemDashboardEnabled;
		isnetworkTab=isNetworkDashboardEnabled;
		isappTab=isApplicationDashboardEnabled;
		isCustomTab=isCustomDashEnabled;
		threshold = iniobj.getValue("Dashboard_Settings","ApplyThreshold");
		DialChartFlag = iniobj.getValue("Dashboard_Settings","UseDial");
		if(DialChartFlag!=null && DialChartFlag.equalsIgnoreCase("Yes"))
		{
			isDialChart=true;
		}
		if(DialChartFlag!=null && DialChartFlag.equalsIgnoreCase("No"))
		{
			isDialChart=false;
		}
	}
	Vector layer = new Vector();
	if(layersForCompType!=null && layersForCompType.contains("HOST") && isSystemDashboardEnabled && !isExcludedServer)
	{
		layer.add("System");
	}
	if(layersForCompType!=null && (layersForCompType.contains("NETWORK") || layersForCompType.contains("TCP") || layersForCompType.contains("UDP")) && isNetworkDashboardEnabled && !isExcludedServer)
	{
		layer.add("Network");
	}
	Vector applicationLayers=healthDAO.selectApplicationLayers(compType);
	String applicationSubsystems=iniobj.getValue(compType,"Application_subsystems");

	if(isApplicationDashboardEnabled && (applicationLayers!=null && !applicationLayers.isEmpty()) && !isExcludedServer && isAppFound && applicationSubsystems!=null && !applicationSubsystems.trim().equals(""))
	{
		layer.add("Application");
	}
	layer.add("Layers");
	layer.add("Custom");

	EgDiscInfo discInfo = new EgDiscInfo("manager");
	List nwDevices = discInfo.getAllNetworkDevices();
	boolean isNetworkComponent = false;
	if(nwDevices.contains(compType+":"+compName))
	{
		isNetworkComponent=true;
	}
%>
<HTML>
<script language="javascript1.2">

function callonLoad()
{
	var trIdToHide=document.getElementById("showThresholdTr");
	var thisForm = document.dashboardSettings;
	var mode='<%=mode%>';
	var isDialChart='<%=isDialChart%>';
	if(isDialChart=="true")
	{
		if (isIE())
		{
			trIdToHide.style.display="block";
		}
		else
		{
			trIdToHide.style.display="table-row";
		}
	}
	if(isDialChart=="false")
	{
		trIdToHide.style.display="none";
	}
	if(mode == "savemetric")
		thisForm.dispName.value="";

	if(mode == "save")
	{
		var measureName=thisForm.measureList.options[thisForm.measureList.options.selectedIndex].value;
		var graphType=thisForm.defaultTimeline.options[thisForm.defaultTimeline.options.selectedIndex].value;
		var url='<%=sessionVal%>'+"&display=block"+"&submodType="+'<%=submoduleType%>'+"&modType="+'<%=moduleType%>'+"&crtType="+'<%=chartType%>'+"&testName="+'<%=testName%>'+"&measureName="+measureName+"&grpType="+graphType+"&duration="+'<%=duration%>'+"&fromDashboardSettings=true";
		window.parent.location.href=url;
	}
}

function isIE()
{
	var ver = navigator.appVersion;
	ver = ver.toLowerCase();
	if (ver.indexOf("msie ") > 0 || document.all)
		return true;
	else
		return false;
}

function isFireFox()
{
	if (isIE())
		return false;
	else
		return true;
}

function defaultTabonChange()
{
	var thisForm = document.dashboardSettings;
	var trIdToHide=document.getElementById("showThresholdTr");
	var isDialChart=thisForm.applyDial[0].checked;
	var defaultTab = thisForm.defaultTab;
	var defaultTabType=thisForm.defaultTab.options[thisForm.defaultTab.options.selectedIndex].value;
	var systemTab = thisForm.systemTab;
	var networkTab = thisForm.networkTab;
	var appTab = thisForm.appTab;
	var systemTabvalue = false;
	var networkTabvalue = false;
	var appTabvalue = false;
	var customTabvalue=false

	if(systemTab !=null && thisForm.systemTab.checked== true)
		systemTabvalue = "true";
	if(networkTab !=null && thisForm.networkTab.checked== true)
		networkTabvalue = "true";
	if(appTab !=null && thisForm.appTab.checked== true)
		appTabvalue = "true";
	if(thisForm.customTab !=null && thisForm.customTab.checked== true)
		customTabvalue = "true";

	var threshold = thisForm.applythreshold[0].checked;
	var url = '<%=response.encodeURL("../monitor/egDashboardSettings.jsp?")%>'+"compType=<%=compType%>&compName=<%=compName%>&defaultTab="+defaultTabType+"&systemTab="+systemTabvalue+"&networkTab="+networkTabvalue+"&appTab="+appTabvalue+"&threshold="+threshold+"&isDialChart="+isDialChart+"&customTab="+customTabvalue;
	window.location.href=url;
}

function defaultTimelineonChange()
{
	var thisForm = document.dashboardSettings;
	var trIdToHide=document.getElementById("showThresholdTr");
	var isDialChart=thisForm.applyDial[0].checked;
	var graph_type = thisForm.defaultTimeline;
	var graph=thisForm.defaultTimeline.options[thisForm.defaultTimeline.options.selectedIndex].value;
	var systemTab = thisForm.systemTab;
	var networkTab = thisForm.networkTab;
	var appTab = thisForm.appTab;
	var systemTabvalue = false;
	var networkTabvalue = false;
	var appTabvalue = false;
	var customTabvalue=false;

	
	if(thisForm.customTab !=null && thisForm.customTab.checked== true)
		customTabvalue = "true";

	if(systemTab !=null && thisForm.systemTab.checked== true)
		systemTabvalue = "true";
	if(networkTab !=null && thisForm.networkTab.checked== true)
		networkTabvalue = "true";
	if(appTab !=null && thisForm.appTab.checked== true)
		appTabvalue = "true";
	var threshold = thisForm.applythreshold[0].checked;
	var url = '<%=response.encodeURL("../monitor/egDashboardSettings.jsp?")%>'+"compType=<%=compType%>&compName=<%=compName%>&defaultTab=<%=default_type%>&systemTab="+systemTabvalue+"&networkTab="+networkTabvalue+"&appTab="+appTabvalue+"&graphType="+graph+"&readIni=true"+"&threshold="+threshold+"&isDialChart="+isDialChart+"&customTab="+customTabvalue;
	window.location.href=url;
}

function timelineonChange()
{
	var thisForm = document.dashboardSettings;
	var trIdToHide=document.getElementById("showThresholdTr");
	var isDialChart=thisForm.applyDial[0].checked;
	var graphType=thisForm.defaultTimeline.options[thisForm.defaultTimeline.options.selectedIndex].value;
	
	if(graphType == '-1')
	{
		alert("Please choose graph type");
		return false;
	}
	var time_line = thisForm.duration;
	for(var i = 0 ; i < time_line.options.length ; i++)
	{
		if(time_line.options[i].selected == true)
		{
			var time = time_line.options[i].value;
		}
	}
	var threshold = thisForm.applythreshold[0].checked;

	var systemTab = thisForm.systemTab;
	var networkTab = thisForm.networkTab;
	var appTab = thisForm.appTab;
	var systemTabvalue = false;
	var networkTabvalue = false;
	var appTabvalue = false;
	var customTabvalue=false;

	if(thisForm.customTab !=null && thisForm.customTab.checked== true)
		customTabvalue = "true";

	if(systemTab !=null && thisForm.systemTab.checked== true)
		systemTabvalue = "true";
	if(networkTab !=null && thisForm.networkTab.checked== true)
		networkTabvalue = "true";
	if(appTab !=null && thisForm.appTab.checked== true)
		appTabvalue = "true";
	var url = '<%=response.encodeURL("../monitor/egDashboardSettings.jsp?")%>'+"compType=<%=compType%>&compName=<%=compName%>&defaultTab=<%=default_type%>&customTab="+customTabvalue+"&systemTab="+systemTabvalue+"&networkTab="+networkTabvalue+"&appTab="+appTabvalue+"&graphType=<%=graphType%>&duration="+time+"&threshold="+threshold+"&isDialChart="+isDialChart;
	window.location.href=url;
}

function chartTypeonChange()
{
	var thisForm = document.dashboardSettings;
	var trIdToHide=document.getElementById("showThresholdTr");
	var isDialChart=thisForm.applyDial[0].checked;
	var systemTab = thisForm.systemTab;
	var networkTab = thisForm.networkTab;
	var appTab = thisForm.appTab;
	var module = thisForm.module;
	var subModule = thisForm.subModule;
	var chart_type = thisForm.chartType;
	var chartType=thisForm.chartType.options[thisForm.chartType.options.selectedIndex].value;
	var systemTabvalue = false;
	var networkTabvalue = false;
	var appTabvalue = false;
	var customTabvalue=false
	
	if(thisForm.customTab !=null && thisForm.customTab.checked== true)
		customTabvalue = "true";

	if(systemTab !=null && thisForm.systemTab.checked== true)
		systemTabvalue = "true";
	if(networkTab !=null && thisForm.networkTab.checked== true)
		networkTabvalue = "true";
	if(appTab !=null && thisForm.appTab.checked== true)
		appTabvalue = "true";
	var moduleType=thisForm.module.options[thisForm.module.options.selectedIndex].value;
	var submoduleType=thisForm.subModule.options[thisForm.subModule.options.selectedIndex].value;
	var threshold = thisForm.applythreshold[0].checked;

	var url = '<%=response.encodeURL("../monitor/egDashboardSettings.jsp?")%>'+"compType=<%=compType%>&compName=<%=compName%>&defaultTab=<%=default_type%>&systemTab="+systemTabvalue+"&networkTab="+networkTabvalue+"&appTab="+appTabvalue+"&graphType=<%=graphType%>&duration=<%=duration%>&chartType="+chartType+"&moduleType="+moduleType+"&submoduleType="+submoduleType+"&threshold="+threshold+"&isDialChart="+isDialChart+"&customTab="+customTabvalue;
	window.location.href=url;
}

function moduleonChange()
{
	var thisForm = document.dashboardSettings;
	var trIdToHide=document.getElementById("showThresholdTr");
	var chartType=thisForm.chartType.options[thisForm.chartType.options.selectedIndex].value;
	var module = thisForm.module;
	var moduleType=thisForm.module.options[thisForm.module.options.selectedIndex].value;
	var threshold = thisForm.applythreshold[0].checked;
	var isDialChart=thisForm.applyDial[0].checked;
	var systemTab = thisForm.systemTab;
	var networkTab = thisForm.networkTab;
	var appTab = thisForm.appTab;
	var systemTabvalue = false;
	var networkTabvalue = false;
	var appTabvalue = false;
	var customTabvalue=false;

	if(thisForm.customTab !=null && thisForm.customTab.checked== true)
		customTabvalue = "true";

	if(systemTab !=null && thisForm.systemTab.checked== true)
		systemTabvalue = "true";
	if(networkTab !=null && thisForm.networkTab.checked== true)
		networkTabvalue = "true";
	if(appTab !=null && thisForm.appTab.checked== true)
		appTabvalue = "true";
	var url = '<%=response.encodeURL("../monitor/egDashboardSettings.jsp?")%>'+"compType=<%=compType%>&compName=<%=compName%>&defaultTab=<%=default_type%>&systemTab="+systemTabvalue+"&networkTab="+networkTabvalue+"&appTab="+appTabvalue+"&graphType=<%=graphType%>&duration=<%=duration%>&moduleType="+moduleType+"&threshold="+threshold+"&isDialChart="+isDialChart+"&customTab="+customTabvalue;
	window.location.href= url;
}

function subModuleonChange()
{
	var thisForm = document.dashboardSettings;
	var trIdToHide=document.getElementById("showThresholdTr");
	var chartType=thisForm.chartType.options[thisForm.chartType.options.selectedIndex].value;
	var module=thisForm.module.options[thisForm.module.options.selectedIndex].value;
	var subModule = thisForm.subModule;
	var submoduleType=thisForm.subModule.options[thisForm.subModule.options.selectedIndex].value;
	var threshold = thisForm.applythreshold[0].checked;
	var isDialChart=thisForm.applyDial[0].checked;
	var systemTab = thisForm.systemTab;
	var networkTab = thisForm.networkTab;
	var appTab = thisForm.appTab;
	var systemTabvalue = false;
	var networkTabvalue = false;
	var appTabvalue = false;
	if(systemTab !=null && thisForm.systemTab.checked== true)
		systemTabvalue = "true";
	if(networkTab !=null && thisForm.networkTab.checked== true)
		networkTabvalue = "true";
	if(appTab !=null && thisForm.appTab.checked== true)
		appTabvalue = "true";
	var customTabvalue=false;
	
	if(thisForm.customTab !=null && thisForm.customTab.checked== true)
		customTabvalue = "true";

	var url = '<%=response.encodeURL("../monitor/egDashboardSettings.jsp?")%>'+"compType=<%=compType%>&compName="+'<%=compName%>'+"&defaultTab="+'<%=default_type%>'+"&systemTab="+systemTabvalue+"&networkTab="+networkTabvalue+"&appTab="+appTabvalue+"&graphType="+'<%=graphType%>'+"&duration="+'<%=duration%>'+"&moduleType="+'<%=moduleType%>'+"&submoduleType="+submoduleType+"&threshold="+threshold+"&isDialChart="+isDialChart+"&customTab="+customTabvalue;
	window.location.href= url;
}

function testListonChange()
{
	var thisForm = document.dashboardSettings;
	var trIdToHide=document.getElementById("showThresholdTr");
	var testList = thisForm.testList;
	var testName=thisForm.testList.options[thisForm.testList.options.selectedIndex].value;
	var chartType=thisForm.chartType.options[thisForm.chartType.options.selectedIndex].value;
	var subModule = thisForm.subModule;
	var submoduleType=thisForm.subModule.options[thisForm.subModule.options.selectedIndex].value;
	var threshold = thisForm.applythreshold[0].checked;
	var isDialChart=thisForm.applyDial[0].checked;
	var systemTab = thisForm.systemTab;
	var networkTab = thisForm.networkTab;
	var appTab = thisForm.appTab;
	var systemTabvalue = false;
	var networkTabvalue = false;
	var appTabvalue = false;
	if(systemTab !=null && thisForm.systemTab.checked== true)
		systemTabvalue = "true";
	if(networkTab !=null && thisForm.networkTab.checked== true)
		networkTabvalue = "true";
	if(appTab !=null && thisForm.appTab.checked== true)
		appTabvalue = "true";

	var customTabvalue=false;
	if(thisForm.customTab !=null && thisForm.customTab.checked== true)
		customTabvalue = "true";
	var availElements = thisForm.availElements;
	var selectedElements ="";
	for(var i=0 ; i < availElements.options.length ; i++)
	{
		selectedElements += availElements.options[i].value +",";
	}
	selectedElements=selectedElements.substring(0,selectedElements.length-1);

	var url = '<%=response.encodeURL("../monitor/egDashboardSettings.jsp?")%>'+"compType=<%=compType%>&compName="+'<%=compName%>'+"&defaultTab="+'<%=default_type%>'+"&systemTab="+systemTabvalue+"&networkTab="+networkTabvalue+"&appTab="+appTabvalue+"&graphType="+'<%=graphType%>'+"&duration="+'<%=duration%>'+"&chartType="+chartType+"&moduleType="+'<%=moduleType%>'+"&submoduleType="+submoduleType+"&testName="+testName+"&threshold="+threshold+"&isDialChart="+isDialChart+"&currentValue="+selectedElements+"&customTab="+customTabvalue;
	window.location.href= url;
}

function measuresonChange()
{
	var thisForm = document.dashboardSettings;
	var trIdToHide=document.getElementById("showThresholdTr");
	var dispName = thisForm.dispName;
	var measureList = thisForm.measureList;
	var tmpdispName=thisForm.measureList.options[thisForm.measureList.options.selectedIndex].value;
	var threshold = thisForm.applythreshold[0].checked;
	var isDialChart=thisForm.applyDial[0].checked;
	dispName.value = tmpdispName;

	var systemTab = thisForm.systemTab;
	var networkTab = thisForm.networkTab;
	var appTab = thisForm.appTab;
	var systemTabvalue = false;
	var networkTabvalue = false;
	var appTabvalue = false;

	if(systemTab !=null && thisForm.systemTab.checked== true)
		systemTabvalue = "true";
	if(networkTab !=null && thisForm.networkTab.checked== true)
		networkTabvalue = "true";
	if(appTab !=null && thisForm.appTab.checked== true)
		appTabvalue = "true";
	var customTabvalue=false;

	if(thisForm.customTab !=null && thisForm.customTab.checked== true)
		customTabvalue = "true";
	var availElements = thisForm.availElements;
	var selectedElements ="";
	for(var i=0 ; i < availElements.options.length ; i++)
	{
		selectedElements += availElements.options[i].value +",";
	}
	selectedElements=selectedElements.substring(0,selectedElements.length-1);

	var url = '<%=response.encodeURL("../monitor/egDashboardSettings.jsp?")%>'+"compType=<%=compType%>&compName="+'<%=compName%>'+"&defaultTab="+'<%=default_type%>'+"&systemTab="+systemTabvalue+"&networkTab="+networkTabvalue+"&appTab="+appTabvalue+"&graphType="+'<%=graphType%>'+"&duration="+'<%=duration%>'+"&chartType="+'<%=chartType%>'+"&moduleType="+'<%=moduleType%>'+"&submoduleType="+'<%=submoduleType%>'+"&testName="+'<%=testName%>'+"&measureName="+tmpdispName+"&threshold="+threshold+"&isDialChart="+isDialChart+"&currentValue="+selectedElements+"&customTab="+customTabvalue;
	window.location.href= url;
}

function addMoreElement()
{
	var thisForm = document.dashboardSettings;
	var measureList = thisForm.measureList;
	var selecteddMeasure ="";
	var measure="";
	var selectedElements ="";
	var availElements = thisForm.availElements;
	var update = true;
	var testList = thisForm.testList;
	var moduleType=thisForm.module.options[thisForm.module.options.selectedIndex].value;
	var submoduleType=thisForm.subModule.options[thisForm.subModule.options.selectedIndex].value;
	var chartType=thisForm.chartType.options[thisForm.chartType.options.selectedIndex].value;
	var testName=thisForm.testList.options[thisForm.testList.options.selectedIndex].value;
	var measureName=thisForm.measureList.options[thisForm.measureList.options.selectedIndex].value;
	var threshold = thisForm.applythreshold[0].checked;
	var systemTab = thisForm.systemTab;
	var networkTab = thisForm.networkTab;
	var appTab = thisForm.appTab;
	var systemTabvalue = false;
	var networkTabvalue = false;
	var appTabvalue = false;

	var customTabvalue=false
	
	if(thisForm.customTab !=null && thisForm.customTab.checked== true)
		customTabvalue = "true";

	if(systemTab !=null && thisForm.systemTab.checked== true)
		systemTabvalue = "true";
	if(networkTab !=null && thisForm.networkTab.checked== true)
		networkTabvalue = "true";
	if(appTab !=null && thisForm.appTab.checked== true)
		appTabvalue = "true";
	for(var i = 0 ; i < testList.options.length ; i++)
	{
		if(testList.options[i].selected == true)
		{
			var selectedTest = testList.options[i].value;
			var selectedTestText= testList.options[i].text;
		}
	}
	if(moduleType == "-1" || moduleType == "")
	{
		alert("Please select a Module");
		update=false;
		return;
	}
	if(submoduleType == "-1" || submoduleType == "")
	{
		alert("Please select a Sub-Module");
		update=false;
		return;
	}
	var dispName = thisForm.dispName.value;
	if(dispName.length<=0)
	{
		alert("Please enter display name");
		return;
	}
	for(var i = 0 ; i < measureList.options.length ; i++)
	{
		if(measureList.options[i].selected == true)
		{
			var testMeasure = selectedTest + ":" + measureList.options[i].value +"|"+dispName;
			var tmptestMeasure = selectedTest + ":" + measureList.options[i].value;
			if(selectedTest == "-1" || selectedTest=="")
			{
				alert("Please select a Test");
				update=false;
				return;
			}
			else if(measureList.options[i].value == "-1")
			{
				alert("Please select a Measure");
				update=false;
				return;
			}
			else
			{
				for(var j = 0 ; j < measureList.options.length ; j++)
				{
					if(measureList.options[j].selected == true)
					{
						var testMeasure = selectedTest + ":" + measureList.options[i].value + "|" + dispName;
						var tmpTestMeasure = selectedTest + ":" + measureList.options[i].value;
						testMeasureText = dispName;
						var isAlreadyExist=false;
						for(var k = 0 ; k < availElements.options.length ; k++)
						{
							var exVal = availElements.options[k].value;
							var measureMappingName=availElements.options[k].text;
							if(exVal.indexOf("|")>0)
								exVal = exVal.substring(0,exVal.indexOf("|"));
							if(exVal == tmpTestMeasure)
							{
									alert("Value already exist");
									isAlreadyExist=true;
									break;
							}
							else if(measureMappingName!=null && measureMappingName==dispName)
							{
								alert("Display name already exists");
								isAlreadyExist=true;
								break;
							}
						}
						if(!isAlreadyExist)
						{
							var option=new Option(testMeasureText ,testMeasure);
							availElements.options[availElements.options.length]=option;
						}
					}
				}
			}
		}
	}
	for(var i=0 ; i < availElements.options.length ; i++)
	{
		if(availElements.options[i].value != "#")
			selectedElements += availElements.options[i].value +",";
	}
	selectedElements=selectedElements.substring(0,selectedElements.length-1);
}

function deleteElement()
{
	var thisForm = document.dashboardSettings;
	var availElements = thisForm.availElements;
	var selectedElements ="";
	for(var i = availElements.options.length; i > 0 ; i--)
	{
		if(availElements.options[i-1].selected == true)
			availElements.options[i-1] = null;
	}
	for(var i=0 ; i < availElements.options.length ; i++)
	{
		selectedElements += availElements.options[i].value +",";
	}
	selectedElements=selectedElements.substring(0,selectedElements.length-1);

	var dispName = thisForm.dispName.value;
	var threshold = thisForm.applythreshold[0].checked;
	var systemTab = thisForm.systemTab;
	var networkTab = thisForm.networkTab;
	var appTab = thisForm.appTab;
	var systemTabvalue = false;
	var networkTabvalue = false;
	var appTabvalue = false;
	if(systemTab !=null && thisForm.systemTab.checked== true)
		systemTabvalue = "true";
	if(networkTab !=null && thisForm.networkTab.checked== true)
		networkTabvalue = "true";
	if(appTab !=null && thisForm.appTab.checked== true)
		appTabvalue = "true";

	if(dispName!=null)
		thisForm.dispName.value="";
}

function savetoFile()
{
	var trIdToHide=document.getElementById("showThresholdTr");
	var thisForm = document.dashboardSettings;
	var systemTab = thisForm.systemTab;
	var networkTab = thisForm.networkTab;
	var appTab = thisForm.appTab;
	var systemTabvalue = false;
	var networkTabvalue = false;
	var appTabvalue = false;

	var customTabvalue=false
	
	if(thisForm.customTab !=null && thisForm.customTab.checked== true)
		customTabvalue = "true";

	if(systemTab !=null && thisForm.systemTab.checked== true)
		systemTabvalue = "true";
	if(networkTab !=null && thisForm.networkTab.checked== true)
		networkTabvalue = "true";
	if(appTab !=null && thisForm.appTab.checked== true)
		appTabvalue = "true";
	var defaultTabType=thisForm.defaultTab.options[thisForm.defaultTab.options.selectedIndex].value;
	var graph=thisForm.defaultTimeline.options[thisForm.defaultTimeline.options.selectedIndex].value;
	var selectedduration=thisForm.duration.options[thisForm.duration.options.selectedIndex].value;
	var chartType=thisForm.chartType.options[thisForm.chartType.options.selectedIndex].value;
	var moduleType=thisForm.module.options[thisForm.module.options.selectedIndex].value;
	var submoduleType=thisForm.subModule.options[thisForm.subModule.options.selectedIndex].value;
	var testName=thisForm.testList.options[thisForm.testList.options.selectedIndex].value;
	var selectedMeasure=thisForm.measureList.options[thisForm.measureList.options.selectedIndex].value;
	var availElements = thisForm.availElements;
	var selectedElements ="";
	var dispName = thisForm.dispName.value;
	var isTestSelected=(testName!=null && testName!="-1");
	var isMeasureSelected=(selectedMeasure!=null && selectedMeasure!="-1");
	for(var i=0 ; i < availElements.options.length ; i++)
	{
		var measureMapping=availElements.options[i].text;		
		if((!isTestSelected && !isMeasureSelected) && (measureMapping!=null && measureMapping==dispName))
		{
			alert("Display name already exists");
			return;
		}
		selectedElements += availElements.options[i].value +",";
	}
	selectedElements=selectedElements.substring(0,selectedElements.length-1);

	var blockedItems = thisForm.blockedItems;
	var blockedElements ="";
	if(blockedItems != null && blockedItems != 'undefined')
	{
		for(var i=0 ; i < blockedItems.options.length ; i++)
		{
			if(blockedItems.options[i].selected == true)
			{
				blockedElements += blockedItems.options[i].value +",";
			}
		}
		blockedElements=blockedElements.substring(0,blockedElements.length-1);
	}
	
	if(selectedduration != null && selectedduration == '-1' && graph !=null && !graph=='-1')
	{
		alert("Please choose the timeline for the chosen graph");
		return false;
	}
	var threshold = thisForm.applythreshold[0].checked;
	var isDialChart=thisForm.applyDial[0].checked;
	var modifiedName = thisForm.dispName.value;
	var availElementsValue="";
	var modifiedValue="";
	if(thisForm.availElements.options.selectedIndex >-1)
		availElementsValue=thisForm.availElements.options[thisForm.availElements.options.selectedIndex].value;
	if(availElementsValue!="")
		modifiedValue = availElementsValue+"|"+modifiedName;
	if (isDialChart=="true")
	{
		if (isIE())
		{
			trIdToHide.style.display="block";
		}
		else
		{
			trIdToHide.style.display="table-row";
		}
	}
	else if(isDialChart=="false")
	{
		trIdToHide.style.display="none";
	}
	var url = '<%=response.encodeURL("../monitor/egDashboardSettings.jsp?")%>'+"compType=<%=compType%>&compName="+'<%=compName%>'+"&defaultTab="+defaultTabType+"&systemTab="+systemTabvalue+"&networkTab="+networkTabvalue+"&appTab="+appTabvalue+"&graphType="+graph+"&duration="+selectedduration+"&chartType="+chartType+"&moduleType="+moduleType+"&submoduleType="+submoduleType+"&testName="+testName+"&measureName="+selectedMeasure+"&measureList="+selectedMeasure+"&selectedItem="+encodeURIComponent(selectedElements)+"&dispName="+dispName+"&threshold="+threshold+"&isDialChart="+isDialChart+"&blockedTables="+blockedElements+"&modifiedValue="+modifiedValue+"&mode=save&customTab="+customTabvalue;
	window.location.href= url;
}

function existingValueonChange()
{
	var thisForm = document.dashboardSettings;
	var trIdToHide=document.getElementById("showThresholdTr");
	var DialChart=thisForm.applyDial[0].checked;
	var dispName = thisForm.dispName;
	var availElementsValue =thisForm.availElements.options[thisForm.availElements.options.selectedIndex].value;
	var availElementsText  =thisForm.availElements.options[thisForm.availElements.options.selectedIndex].text;
	var testName=thisForm.testList.options[thisForm.testList.options.selectedIndex].value;
	var tmpdispName=thisForm.measureList.options[thisForm.measureList.options.selectedIndex].value;
	if((testName!=null && testName!="-1" && testName!="" && testName.toLowerCase()!="null") && (tmpdispName!=null && tmpdispName!="-1" && tmpdispName!="" && tmpdispName.toLowerCase()!="null"))
	{
		if(availElementsValue!=null && (availElementsValue==testName+":"+tmpdispName || availElementsValue.indexOf(testName+":"+tmpdispName)!=-1))
		{
				dispName.value = availElementsText;
		}
	}
	else
	{
		dispName.value = availElementsText;
	}

}
function enableTr(specificvalue)
{
	var trIdToHide=document.getElementById("showThresholdTr");
	var applyDial=document.getElementById("applyDial");
	if(specificvalue=="yes" && specificvalue!="undefined")
	{
		if (isIE())
		{
			trIdToHide.style.display="block";
		}
		else
		{
			trIdToHide.style.display="table-row";
		}
	}
}
function disableTr(specificvalue)
{
	var trIdToHide=document.getElementById("showThresholdTr");
	if(specificvalue=="no")
	{
		trIdToHide.style.display="none";
	}
}

</script>

<HEAD>
<TITLE> Dashboard Configuration Page </TITLE>
<egui:skin ui="monitor"/>
</HEAD>
<BODY onload="callonLoad();" leftmargin="0" topmargin="0" marginheight="0" marginwidth="0" class="eg_lightlight ">
<form name="dashboardSettings" method="post"  style="margin:0px;padding:0px">
<table border="0" bordercolor="red" align="center" width="100%" cellpadding="0" cellspacing="0">
	<tr>
		<td >
			<table border="0" width="100%" cellpadding="4" cellspacing="0"><col width="200px"><col width="10px"><col width="60%">
				<tr>
					<td colspan="3" height="10px" class="eg_blankspace">&nbsp;</td>
				</tr>
				<tr>
					<td><egui:intnl text="monitor.dashboard.Default Tab"/></td>
					<td>:</td>
					<td>
						<select name="defaultTab" style="width:200px"  onChange='javascript:defaultTabonChange()'>

<%
	for(int i=0;i<layer.size();i++)
	{
		String defaultTab=(String)layer.get(i);
		if(defaultTab!=null)
		{
			if(default_type!=null && default_type.equals(defaultTab))
			{
%>
				<option value="<%=defaultTab%>" selected><egui:intnl type="<%=defaultTab%>"/></option>
<%
			}
			else
			{
%>
				<option value="<%=defaultTab%>"><egui:intnl type="<%=defaultTab%>"/></option>
<%
			}
		}
	}
%>
						</select>
					</td>
				</tr>
				<tr>
					<td>Enable/Disable Tab</td>
					<td>:</td>
					<td>
					<%
						boolean isSysDisplay = iniobj.getValue("SystemDashboard_Excluded_servers",compType).equalsIgnoreCase("No")?false:true;
					%>
<%
						if(layersForCompType!=null && layersForCompType.contains("HOST") && !isNetworkComponent && isSysDisplay)
						{
%>
							<input type = "checkbox" id = "systemTab" name = "systemTab" value = "" class = "eg_input"  valign="center" <%=issystemTab?"checked":""%>><egui:intnl text="monitor.dashboard.System"/>
<%
						}
						if(layersForCompType!=null && (layersForCompType.contains("NETWORK") || layersForCompType.contains("TCP") || layersForCompType.contains("UDP")))
						{
%>
							<input type = "checkbox" id = "networkTab" name = "networkTab" value = "" class = "eg_input" valign="center" <%=isnetworkTab?"checked":""%>><egui:intnl text="monitor.dashboard.Network"/>
<%
						}
						if((applicationLayers!=null && !applicationLayers.isEmpty()) && !isExcludedServer && isAppFound && applicationSubsystems!=null && !applicationSubsystems.trim().equals(""))
						{
%>
							<input type = "checkbox" id = "appTab" name = "appTab" value = "" class = "eg_input" valign="center" <%=isappTab?"checked":""%>><egui:intnl text="monitor.dashboard.Application"/>
<%
						}
%>

						<input type = "checkbox" id = "customTab" name = "customTab" value = "" class = "eg_input" valign="center" <%=isCustomTab?"checked":""%>><egui:intnl text="monitor.dashboard.Custom"/>

					</td>
				</tr>

				<tr>
					<td><egui:intnl text="monitor.dashboard.Show Dial"/></td>
					<td>:</td>
					<td>
						<input type ="radio"class="eg_input" name="applyDial" id="applyDial" value="Yes" 
						 onclick="enableTr('yes')" <%=(isDialChart) ? "checked":""%>>
						Yes
						<input type ="radio" class="eg_input" name="applyDial" id="applyDial" value="No" 
						onclick="disableTr('no')" <%=(!isDialChart) ? "checked":""%>>
						No

					</td>
				</tr>

				<tr id="showThresholdTr">
					<td><egui:intnl text="monitor.dashboard.Show Threshold in Dial Chart"/></td>
					<td>:</td>
					<td>
						<input type ="radio"class="eg_input" name="applythreshold" id="applythreshold" value="Yes" <%=(threshold.equalsIgnoreCase("true") || threshold.equalsIgnoreCase("Yes")) ? "checked":""%>>
						Yes
						<input type ="radio" class="eg_input" name="applythreshold" id="applythreshold" value="No" <%=(threshold.equalsIgnoreCase("false") || threshold.equalsIgnoreCase("No")) ? "checked":""%>>
						No
					</td>
				</tr>


<%
	Vector graphTypes = new Vector();
	graphTypes.add("Event Distribution");
	graphTypes.add("Comparison Graph");
	graphTypes.add("History Graph");
	graphTypes.add("Summary Graph");
	graphTypes.add("Trend Graph");
	graphTypes.add("Uptime/Downtime Summary");
%>
				<tr>
					<td>Default timeline for</td>
					<td> : </td>
					<td>
						<select name="defaultTimeline" style="width:200px" onChange='javascript:defaultTimelineonChange()'>
						<option value="-1">Choose a Option</option>
<%
	for(int i=0;i<graphTypes.size();i++)
	{
		String graphName=(String)graphTypes.get(i);
		if(graphName!=null)
		{
			if(graphName.equals(graphType))
			{
%>
						<option value="<%=graphName%>" selected ><%=graphName%></option>
<%
			}
			else
			{
%>
						<option value="<%=graphName%>"><egui:intnl type="<%=graphName%>"/></option>
<%
			}
		}
	}
%>
						</select>
					</td>
				</tr>
				<tr>
					<td><egui:intnl text="monitor.dashboard.Timeline"/></td>
					<td> : </td>
					<td>
						<select name="duration" style="width:200px" onChange='javascript:timelineonChange()'>
						<option value="-1">Choose a Timeline</option>

<%
	for(int j=0; j < options.length;j++)
	{	
		String option = options[j];
		if(option != null)
		{
			if(option.equals(duration))
			{
%>						<option value="<%=option%>" selected ><%=option%></option>
<%			}
			else
			{
%>						 <option value="<%=option%>" ><%=option%></option>
<%			}
		}
	}
%>
						</select>
					</td>
				</tr>
<%
	Vector chartTypes = new Vector();
	Vector dispchartTypes = new Vector();
	chartTypes.add("DialGraphs");
	chartTypes.add("DigitalGraphs");
	chartTypes.add("HistoryGraph");
	chartTypes.add("PerformanceIndicators");
	chartTypes.add("comparisonGraph");
	dispchartTypes.add(_mapping.getTextDescription("admin.dashboard.Dial Graph"));
	dispchartTypes.add(_mapping.getTextDescription("admin.dashboard.Digital Graph"));
	dispchartTypes.add(_mapping.getTextDescription("admin.dashboard.History Graph"));
	dispchartTypes.add(_mapping.getTextDescription("admin.dashboard.Performance Indicator"));
	dispchartTypes.add(_mapping.getTextDescription("admin.dashboard.Comparison Graph"));
	if(hasConfig)
	{
		if(moduleType!=null && submoduleType!=null && moduleType.equalsIgnoreCase("System") && submoduleType.equalsIgnoreCase("Overview"))
		{
			chartTypes.add("configtable");
			dispchartTypes.add(_mapping.getTextDescription("admin.dashboard.System Configuration"));
		}
		else if(moduleType!=null && submoduleType!=null && moduleType.equalsIgnoreCase("Network") && submoduleType.equalsIgnoreCase("Overview"))
		{
			chartTypes.add("configtable");
			dispchartTypes.add(_mapping.getTextDescription("admin.dashboard.Network Configuration"));
		}
		else if(moduleType!=null && submoduleType!=null && moduleType.equalsIgnoreCase("Application") && submoduleType.equalsIgnoreCase("Overview"))
		{
			chartTypes.add("configtable");
			dispchartTypes.add(_mapping.getTextDescription("admin.dashboard.Application Configuration"));
		}
	}
%>


				<tr>
					<td><egui:intnl text="monitor.dashboard.Module"/></td>
					<td>:</td>
					<td>
					<select name="module" style="width:200px" onChange='javascript:moduleonChange()'>
					<option value="-1">Choose a Module</option>
<%
	Vector moduleList = new Vector();
	moduleList.addAll(layer);
	if(moduleList!=null && moduleList.contains("Layers"))
		moduleList.remove("Layers");

	if(moduleList!=null && moduleList.contains("Custom"))
		moduleList.remove("Custom");
	if(moduleList!=null)
	{
		for(int i=0;i<moduleList.size();i++)
		{
			String moduleName=(String)moduleList.get(i);
			if(moduleName!=null)
			{
				if(moduleName.equals(moduleType))
				{
%>
									<option value="<%=moduleName%>" selected ><%=moduleName%></option>
<%
				}
				else
				{
%>
									<option value="<%=moduleName%>"><egui:intnl type="<%=moduleName%>"/></option>
<%
				}
			}
		}
	}
%>
						</select>
					</td>
				</tr>
				<tr>
					<td style="padding-left:20px"><egui:intnl text="monitor.dashboard.Sub-System"/></td>
					<td>:</td>
					<td>
						<select name="subModule" style="width:200px" onChange='subModuleonChange()'>
							<option value="-1">Choose a Sub-system</option>

<%
	if(subSystemList!=null)
	{
		for(int i=0;i<subSystemList.size();i++)
		{
			String subSysName=(String)subSystemList.get(i);
			if(subSysName!=null)
			{
				if(subSysName.equals(submoduleType))
				{
%>
							<option value="<%=subSysName%>" selected ><%=subSysName%></option>
<%
				}
				else
				{
%>
							<option value="<%=subSysName%>"><egui:intnl type="<%=subSysName%>"/></option>
<%
				}
			}
		}
	}
%>
						</select>
					</td>
				</tr>

<%
	if(disabledBlocks!=null && disabledBlocks.size()>0)
	{
%>
				<tr>
					<td style="padding-left:40px"><egui:intnl text="monitor.dashboard.Add To Dashboard"/></td>
					<td>:</td>
					<td>
					<select name="blockedItems" size="3" style="width:200px" multiple>
<%
		for(int i=0;i<disabledBlocks.size();i++)
		{
			String disabled = (String)disabledBlocks.get(i);
			String tmpMapping = iniobj.getValue("Dashboard_Comparison_TableTitle",disabled);
			if(tmpMapping.equals(""))
				tmpMapping = disabled;
%>
						<option value="<%=disabled%>" selected><%=tmpMapping%></option>
<%
		}
%>
					</select>
					</td>
				</tr>
<%
	}
%>
				<tr>
					<td style="padding-left:20px"><egui:intnl text="monitor.dashboard.Add/Delete Measures for"/></td>
					<td>:</td>
					<td>
						<select name="chartType" style="width:200px" onChange='javascript:chartTypeonChange()'>
						<option value="-1">Choose a Type</option>
<%
	for(int k=0;k<chartTypes.size();k++)
	{
			String chart = (String)chartTypes.get(k);
			String dispchartType = (String)dispchartTypes.get(k);
			if(chart.equals(chartType))
			{
%>						<option value="<%=chart%>" selected ><%=dispchartType%></option>
<%			}
			else
			{
%>						<option value="<%=chart%>"><%=dispchartType%></option>

<%			}
	}
%>
						</select>
					</td>
				</tr>
<%
	Vector runningTests = new Vector();
	ArrayList testNames=new ArrayList();
	if(compType!=null && compType.length()>0 && moduleType!=null)
	{
		StringBuffer sb_layer=new StringBuffer();
		Vector layers=egDashboard.getLayersForModule(compType,moduleType);
		if(layers!=null && layers.size()>0)
		{
			for(int  i=0;i<layers.size();i++)
			{
				String tmp_layer=(String)layers.get(i);
				sb_layer.append("'");
				sb_layer.append(tmp_layer);
				sb_layer.append("'");
				if(i!=layers.size()-1)
				{
					sb_layer.append(",");
				}
			}
		}

		Hashtable allTestInfos = new Hashtable();
		Vector allInfos= new Vector();
		String  layerList=sb_layer.toString();
		if(chartType!=null && chartType.equalsIgnoreCase("comparisonGraph"))
		{
			Vector testList=egDashboard.getTestsForLayer(compName,compType,layerList);
			allTestInfos=dashboardDAO.getDescriptorsForAllTest(compName,compType,moduleType);
			runningTests = new Vector();
			for(int i=0;i<testList.size();i++)
			{
					String tmpTest = (String)testList.get(i);
					allInfos=(Vector)allTestInfos.get(tmpTest);
					if(allInfos!=null && allInfos.contains("+"))
						allInfos.remove("+");
					if(allInfos!=null && allInfos.size()>0)
						runningTests.add(tmpTest);
			}
		}
		else if(chartType!=null && chartType.equalsIgnoreCase("configtable"))
		{
			ArrayList configTest = new ArrayList();
			configTest = specsInfo.getEnabledTests(compType,true);
			for(int k=0;k<configTest.size();k++)
			{
				runningTests.add(configTest.get(k));
			}
		}
		else
		{
			if(layerList!=null && layerList.length()>0)
			runningTests=egDashboard.getTestsForLayer(compName,compType,layerList);
		}
		testNames=sorter.getSortedTestList(runningTests);
	}
%>
				<tr>
					<td style="padding-left:40px"><egui:intnl text="monitor.dashboard.Test"/></td>
					<td>:</td>
					<td><select name="testList" style="width:200px" onChange='testListonChange()'>
						<option value="-1">Choose a Test</option>
<%
	for(int i=0; i<testNames.size(); i++)
	{
		EgName nameObj = (EgName)testNames.get(i);
		String tmpVal = nameObj.getActualName();
		String tmpDis = nameObj.getLocalName();
		if(tmpVal.equals(testName))
		{
%>
						<option value="<%=tmpVal%>" selected ><%=tmpDis%></option>
<%
		}
		else
		{
%>
						<option value="<%=tmpVal%>"><%=tmpDis%></option>
<%
		}
	}
%>
						</select>
					</td>
				</tr>

<%
	Hashtable mappedMeasures=new Hashtable();
	Vector dispMeasures=new Vector();
	if(testName!=null && measures!=null)
	{
		for(int i=0;i<measures.size();i++)
		{
			String dispMeasureName=(String)measures.get(i);
			mappedMeasures.put(_mapping.getMeasureDescription(testName,dispMeasureName),dispMeasureName);
		}
		dispMeasures.addAll(mappedMeasures.keySet());
		Collections.sort(dispMeasures,String.CASE_INSENSITIVE_ORDER);
	}
%>
				<tr>
					<td style="padding-left:40px"><egui:intnl text="monitor.dashboard.Measures"/></td>
					<td>:</td>
					<td><select name="measureList"  style="width:200px" onChange='measuresonChange()'>
						<option value="-1">Choose a Measure</option>
<%
		for(int i=0; i<dispMeasures.size(); i++)
		{
			String tmpDis = (String)dispMeasures.get(i);	
			String tmpVal = (String)mappedMeasures.get(tmpDis);
			if(tmpVal.equals(measureName))
			{
%>
						<option value="<%=tmpVal%>" selected ><%=tmpDis%></option>
<%
			}
			else
			{
%>
						<option value="<%=tmpVal%>"><%=tmpDis%></option>
<%
			}
		}
%>
						</select>
					</td>
				</tr>

<%
	String test_measure = testName+":"+measureName;
	String measure_Mapping="";

	if(chartType!=null && chartType.equalsIgnoreCase("comparisonGraph"))
		measure_Mapping=iniobj.getValue("Dashboard_ComparisonGraph_Mapping",test_measure);
	else if(chartType!=null && chartType.equalsIgnoreCase("DialGraphs"))
		measure_Mapping=iniobj.getValue("Dashboard_Dial_mapping",test_measure);
	else if(chartType!=null && chartType.equalsIgnoreCase("DigitalGraphs"))
		measure_Mapping=iniobj.getValue("Dashboard_Digital_mapping",test_measure);
	else if(chartType!=null && chartType.equalsIgnoreCase("PerformanceIndicators"))
		measure_Mapping=iniobj.getValue("Dashboard_KPI_mapping",test_measure);
	else
		measure_Mapping=iniobj.getValue("Dashboard_measures_mapping",test_measure);

	if(testName!=null && measureName!=null)
	{
		if(measure_Mapping==null || measure_Mapping.equals(""))
			measure_Mapping=_mapping.getMeasureDescription(testName,measureName);
	}
%>
				<tr>
					<td style="padding-left:40px">Display</td>
					<td>:</td>
					<td valign="top" >
						<table border="0" width="100%" cellpadding="0" cellspacing="0">
							<tr>
								<td valign="top">
<%
		if(measure_Mapping.equalsIgnoreCase("null") || measure_Mapping.equalsIgnoreCase("-1"))
			measure_Mapping="";
%>
									<input type="text" style="width: 200px;" name="dispName" id="dispName" value="<%=measure_Mapping%>">
								</td>
								<td valign="top" style="padding-right:10px" align="center"> <input type="button" class="button_bg" name="Add" value='Add' style="width: 60px;" onClick="addMoreElement()" >
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td style="padding-left:40px" valign="top"><egui:intnl text="monitor.dashboard.Existing Value(s)"/></td>
					<td valign="top">:</td>
					<td valign="top" >
						<table border="0" width="100%" cellpadding="0" cellspacing="0">
							<tr>
								<td valign="top" >
									<select name="availElements" size="4" style="width:200px" multiple onChange='existingValueonChange()'>

<%
	Vector existVal = new Vector();
	String seltest="";

	if(compType!=null && compType.length()>0)
	{
		String keys="";
		keys = moduleType+"_"+submoduleType+"_"+chartType;

		if(chartType!=null && chartType.equalsIgnoreCase("HistoryGraph"))
			keys = moduleType+"_"+submoduleType;
		else if(chartType!=null && chartType.equalsIgnoreCase("PerformanceIndicators"))
			keys = moduleType+"_"+chartType;
		else if(chartType!=null && chartType.equalsIgnoreCase("comparisonGraph"))
			keys = moduleType+"_DD_"+submoduleType;
		else if(chartType!=null && chartType.equalsIgnoreCase("configtable"))
			keys = moduleType+"_config";


			String existingValues = "";
			if((moduleType!=null && moduleType.equalsIgnoreCase("Application")) || (hasSeparateSection!=null && hasSeparateSection.equalsIgnoreCase("yes")))
			{
				existingValues = iniobj.getValue(compType,keys);
			}
			else
			{
				existingValues = iniobj.getValue(moduleType+"_"+"Dashboard_Metrics",keys);
			}
			if(chartType!=null && chartType.equalsIgnoreCase("comparisonGraph"))
			{
					if(currentValue!=null && currentValue.length()>0)
						existingValues = currentValue;
					StringTokenizer st = new StringTokenizer(existingValues,",");
					while(st.hasMoreTokens())
					{
						String option = st.nextToken();
						String measureMapping="";
						if(option.indexOf("|")>0)
						{
							measureMapping = option.substring(option.indexOf("|")+1,option.length());
						}
						else
						{
							measureMapping=iniobj.getValue("Dashboard_ComparisonGraph_Mapping",option);
							String s_test=option.substring(0,option.indexOf(":"));
							String s_measure=option.substring(option.indexOf(":")+1,option.length());
							if(measureMapping==null || measureMapping.equals(""))
								measureMapping=_mapping.getMeasureDescription(s_test,s_measure);
						}

						if(!(option.indexOf("#Format")>0))
						{
		%>
							<option value="<%=option%>"><%=measureMapping%></option>
		<%
						}
					}
			}
			else
			{
				String tmpexistingValues="";
				if(currentValue!=null && currentValue.length()>0)
				{
					existingValues = currentValue;
				}
				StringTokenizer hashTokens = new StringTokenizer(existingValues,"#");
				while(hashTokens.hasMoreTokens())
				{
					tmpexistingValues = hashTokens.nextToken();
					StringTokenizer st = new StringTokenizer(tmpexistingValues,",");
					while(st.hasMoreTokens())
					{
						String option = st.nextToken();
						String exVal = option;
						String measureMapping="";
						String s_test="";
						String s_measure="";
						if(exVal.indexOf("|")>0)
						{
							s_test=option.substring(0,option.indexOf(":"));
							measureMapping = exVal.substring(exVal.indexOf("|")+1,exVal.length());
						}
						else
						{
							if(chartType!=null && chartType.equalsIgnoreCase("comparisonGraph"))
								measureMapping=iniobj.getValue("Dashboard_ComparisonGraph_Mapping",option);
							else if(chartType!=null && chartType.equalsIgnoreCase("DialGraphs"))
								measureMapping=iniobj.getValue("Dashboard_Dial_mapping",option);
							else if(chartType!=null && chartType.equalsIgnoreCase("DigitalGraphs"))
								measureMapping=iniobj.getValue("Dashboard_Digital_mapping",option);
							else if(chartType!=null && chartType.equalsIgnoreCase("PerformanceIndicators"))
								measureMapping=iniobj.getValue("Dashboard_KPI_mapping",option);
							else
								measureMapping=iniobj.getValue("Dashboard_measures_mapping",option);

							s_test=option.substring(0,option.indexOf(":"));
							s_measure=option.substring(option.indexOf(":")+1,option.length());
							if(measureMapping==null || measureMapping.equals(""))
								measureMapping=_mapping.getMeasureDescription(s_test,s_measure);
						}
%>
								<option value="<%=option%>"><%=measureMapping%></option>
<%
					}
				}
			}
	}
%>
									</select>
								</td>
								<td valign="middle" style="padding-right:10px" align="center"> <input type="button" name="Delete" value='Delete' class="button_bg" style="width: 60px;" onClick="deleteElement()">
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td colspan="3" height="10px" class="eg_blankspace">&nbsp;</td>
				</tr>	
				<tr>
					<td colspan="2">&nbsp;</td>
					<td align="left" valign="top" style="padding-left:15px"> <input type="button" name="Update" value='Update' class="button_bg" style="width: 70px;" onClick="savetoFile()"> </td>
				</tr>
			</table>
		</td>
	</tr>
</table>
</BODY>
</HTML>
<%
	EgConfigFilesSync.releaseInstance(iniobj);
%>
<%
}
catch(Exception ex)
{
	ex.printStackTrace();
}
%>


