<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ include file = "EgServerDashboardTracker.jsp"%>
<%@ page errorPage = "EgProbsM.jsp"%>
<%@ page import="com.egurkha.monitor.*"%>
<%@ page import="com.eg.*"%>
<%@ page import="java.text.*"%>
<%@ page import="com.egurkha.util.DateTimeTokenizer"%>
<%@ page import="com.egurkha.util.*" %>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import="egurkha.reporter.ErUtils"%>
<%@ page import="egurkha.*"%>
<%@ page import = "com.egurkha.EgUserPermission"%>
<%@ page import="com.eg.EgAgentInfo" %>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import="com.eg.supermanager.*"%>
<%@ page import="com.egurkha.util.MathUtils"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>
<%
try
{
	String ua = request.getHeader( "User-Agent" );
	boolean isFirefox = ( ua != null && ua.indexOf( "Firefox/" ) != -1 );
	boolean isMSIE = ( ua != null && ua.indexOf( "MSIE" ) != -1 );
	boolean isIE6=( ua != null && ua.indexOf("MSIE 6.0") != -1 );

	String compType=request.getParameter("compType");
	if (EgInstallInfo.isSuperManager)
	{
		String s_comp = compType+":"+request.getParameter("hostName");// gen_26:NULL:Generic_server
		String currentSession = session.getId();
		if(s_comp != null && s_comp.indexOf(":")>0)
		{
			ArrayList managerIDs = EgElementInfo.getInstance().getManagerIDs("component",s_comp);
			if(managerIDs != null && !managerIDs.isEmpty())
			{
				EgThreadLocal.clear();
				SmSessionData smsData = new SmSessionData(currentSession,managerIDs);
				EgThreadLocal egtl = new EgThreadLocal();
				egtl.set(smsData);
				new SMDateTimeConverter(managerIDs);				
			}
		}
	}

	String s_iniFile_dir=EgInstallInfo.getInstallDir()+"/manager/config/";
	EgUserRole userRole = u_ser.getUserRole();
	long perm = EgUserPermission.ADMIN;
	boolean adminPermission = userRole.hasAdminRole(perm);
	EgTablesInfo tablesInfo=new EgTablesInfo("manager");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgDbInfo dbInfo=new EgDbInfo("manager");
	EgTesterInfo testerInfo=new EgTesterInfo("manager");
	EgAgentInfo agentInfo = new EgAgentInfo("manager");

	EgMappingInfo mappingInfo=new EgMappingInfo(trackerLanguage);
	EgMeasureGraphExt measureGraphInfo = new EgMeasureGraphExt();
	DateTimeTokenizer dtd = new DateTimeTokenizer();
	Hashtable  list = null;
	String lastmsmtTime = "";
	int lastmsmtTimeIndex =0;

	String dashboardIni = "eg_serverdashboard.ini";

	EgServerDashboardModel  egDashboard=null;
	if(compType!=null && compType.startsWith("Agg_"))
	{
		egDashboard=new  EgServerDashboardModel(true);
		dashboardIni = "eg_aggregateserverdashboard.ini";
	}
	else
	{
		egDashboard=new  EgServerDashboardModel();
	}
	IniFile iniObj=new IniFile(s_iniFile_dir+dashboardIni);
	IniFile uiIni=new IniFile(s_iniFile_dir+"eg_ui.ini");
	EgServerDashboardMGraphModel measureGraph=new EgServerDashboardMGraphModel();
	EgFusionChartUtil fusionChart=new EgFusionChartUtil(trackerLanguage);

	MonitorDAOFactory monitorDaoFactory = MonitorDAOFactory.getInstance();
	EgServerDashBoardDAO dashboardDAO=monitorDaoFactory.getServerDashBoardDAO();

	ErUtils  erutils=new  ErUtils();
	SimpleDateFormat testDateFormat= new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	SimpleDateFormat timeOutDateFormat= new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
	String subject=request.getParameter("subject");
	String tab=request.getParameter("tab");
	String screenWidth=request.getParameter("screenWidth");
	String screenHeight=request.getParameter("screenHeight");
	double screenWidthInDouble=1024.0;
	double screenHeightInDouble=768.0;
	if(screenWidth!=null && !screenWidth.equals(""))
	{
		screenWidthInDouble=Double.parseDouble(screenWidth);
	}
	if(screenHeight!=null && !screenHeight.equals(""))
	{
		screenHeightInDouble=Double.parseDouble(screenHeight);
	}
	Hashtable measureLastData = dashboardDAO.getMeasureLast();

	if(tab==null)
		tab="System";

	String compName=request.getParameter("hostName");
	

	boolean isfromSuper = session.getAttribute("fromSuper") != null &&
						session.getAttribute("fromSuper").toString().equalsIgnoreCase("yes");

	String hostName="";
	String portNo="";
	String sid="";
	String startTime="";
	String endTime="";
	String startHour="";
	String endHour="";
	String startDateTime="";
	String endDateTime="";
	String state="";
	String info="";
	String msmtHost="";
	String test="";
	String measure="";
	String site=request.getParameter("site");

	if(site==null || site.trim().length()==0)
		site="NULL";

	int emptyTDCount=0;
	int digitalChartCount=0;
	int digitalChartNoMeasuresCount=0;
	int dialChartNoMeasuresCount=0;
	boolean isTRNeedInDigitalChart=false;
	boolean isTRNeedInDialChart=false;
	boolean isEjbGroupingRequired = false;
	int tempDialGraphCount=0;
	int tempDigitalGraphCount=0;
	if(compName!=null && !compName.equals(""))
	{
		StringTokenizer st=new StringTokenizer(compName,":");
		if(st.hasMoreTokens())
			hostName=st.nextToken();

		if(st.hasMoreTokens())
			portNo=st.nextToken();

		if(st.hasMoreTokens())
			sid=st.nextToken();
	}
	boolean isOracleServer=false;
	String cnameDAO = compName;
	if(compType.equalsIgnoreCase("Oracle_server") && compName.indexOf(":")!=compName.lastIndexOf(":"))
	{
		isOracleServer=true;
		cnameDAO = compName.substring(0,compName.lastIndexOf(":"));
	}
	boolean isWeblogicServer=false;
	if(compType!=null && (compType.equals("WebLogic_server") || compType.equalsIgnoreCase("weblogic6x_server")))
		isWeblogicServer=true;
	Hashtable allMsmtHosts=dashboardDAO.getMsmtHostForAllTest(compName,compType,tab);
	Hashtable allTestInfos=dashboardDAO.getDescriptorsForAllTest(compName,compType,tab);
	ArrayList enabledTests=specsInfo.getEnabledTests(compType,false);
	ArrayList enabledConfigTests=specsInfo.getEnabledTests(compType,true);

	boolean isSystemTab=(tab!=null && tab.equalsIgnoreCase("System"));
	boolean isNetworkTab=(tab!=null && tab.equalsIgnoreCase("Network"));
	boolean isApplicationTab=(tab!=null && tab.equalsIgnoreCase("Application"));
		list =(Hashtable) measureLastData.get(cnameDAO);

	int divCount=0;
	if(isSystemTab)
	{
		subject="System_Dashboard_Metrics";
	}
	else if(isNetworkTab)
	{
		subject="Network_Dashboard_Metrics";
	}
	else
	{
		subject=compType;
	}

	String s_specificsubject=iniObj.getValue("CommonDashboardConfiguration",compType);

	String isThresholdNeed=iniObj.getValue("Dashboard_Settings","ApplyThreshold");
	String DialChartNeed=iniObj.getValue("Dashboard_Settings","UseDial");
	String UseCutOffFactor=iniObj.getValue("Dashboard_Settings","UseCutOffFactor");
	if(DialChartNeed==null || DialChartNeed.equals(""))
		DialChartNeed="Yes";

	if((isSystemTab || isNetworkTab) && s_specificsubject!=null && s_specificsubject.equalsIgnoreCase("yes"))
	{
		subject=compType;
	}

	egDashboard.setSubject(subject);

	Hashtable currentStatus=egDashboard.getCurrentStatusForServer(compName,compType,tab);
	Hashtable performanceIndicators=egDashboard.getPerformanceIndicators(compName,compType,tab,site);
	String defaultSparklineDuration=iniObj.getValue("Default_SparkLineGraph_Duration","duration");
	if(defaultSparklineDuration==null || (defaultSparklineDuration!=null && defaultSparklineDuration.equals("")))
		defaultSparklineDuration="1 hour";
	String sparkLineStartTime="";
	String sparkLineEndTime="";
	String sparkLineStartHour="";
	String sparkLineEndHour="";
	Vector sparkLineTimes=egDashboard.getStartEndDateTimeForMeasure(defaultSparklineDuration);
	if(sparkLineTimes!=null && sparkLineTimes.size()>=4)
	{
		sparkLineStartTime=(String)sparkLineTimes.get(0);
		sparkLineEndTime=(String)sparkLineTimes.get(1);
		sparkLineStartHour=(String)sparkLineTimes.get(2);
		sparkLineEndHour=(String)sparkLineTimes.get(3);
	}

	boolean isFullViewForKPI=false;
	boolean isFullViewForConfig=false;
	String lastFullViewURL=(String)session.getAttribute("lastFullViewURLForDashboard");
	String fullViewGraphType="";

	if(lastFullViewURL!=null && (!lastFullViewURL.equals("") && !lastFullViewURL.equalsIgnoreCase("null")))
	{
		String tempLastFullViewURL=lastFullViewURL.substring((lastFullViewURL.indexOf("?")+1));
		StringTokenizer stkParams=new StringTokenizer(tempLastFullViewURL,"&");
		while(stkParams.hasMoreTokens())
		{
			String paramWithValue=stkParams.nextToken();
			if(paramWithValue!=null && paramWithValue.indexOf("=")>0)
			{
				String param=paramWithValue.substring(0,paramWithValue.indexOf("="));
				if(param!=null && param.equals("isFullView"))
				{
					String value=paramWithValue.substring(paramWithValue.indexOf("=")+1,paramWithValue.length());
					if(value!=null && value.equalsIgnoreCase("true"))
					{
						isFullViewForKPI=true;
					}
					
				}
				else if(param!=null && param.equals("isFullViewForConfig"))
				{
					String value=paramWithValue.substring(paramWithValue.indexOf("=")+1,paramWithValue.length());
					if(value!=null && value.equalsIgnoreCase("true"))
					{
						isFullViewForConfig=true;
						break;
					}
					
				}
				else if(param!=null && param.equals("graphType"))
				{
					fullViewGraphType=paramWithValue.substring(paramWithValue.indexOf("=")+1,paramWithValue.length());
					if(fullViewGraphType!=null && (!fullViewGraphType.equals("") && !fullViewGraphType.equalsIgnoreCase("null")))
					{
						if(isFullViewForKPI)
							break;
					}

				}
			}
		}
	}
	EgMemCheck memCheck = new EgMemCheck();
	boolean hasConfig=memCheck.isCMEnabled();
	Vector configData=new Vector();

	if(hasConfig)
	{
		if(isSystemTab)
			configData=egDashboard.getSystemConfig(compName,compType);
		else if(isNetworkTab)
			configData=egDashboard.getNetworkConfig(compName,compType);
		else
			configData=egDashboard.getApplicationConfig(compName,compType);
	}
	if(hasConfig)
		hasConfig=userRole.hasAnyConfigRole(EgUserPermission.CONFIG);

	String overviewDialGraphs=iniObj.getValue(subject,tab+"_Overview_DialGraphs");
	String digitalGraphs=iniObj.getValue(subject,tab+"_Overview_DigitalGraphs");

	int graphCount=0;

	Vector runningtests=dashboardDAO.getRunningTestsForServer(compName,compType,tab);
	runningtests.retainAll(enabledTests);

	String defaultMGraphDuration=iniObj.getValue("Default_MeasureGraph_Duration","duration");
	state=egDashboard.getServerState(hostName,compType,site);

	String s_disabledBlocks=iniObj.getValue("Disabled_blocks",tab+"_Overview");
	Vector disabledBlocks=egDashboard.getTokensAsVector(s_disabledBlocks,",");
	Vector times=egDashboard.getStartEndDateTimeForMeasure(defaultMGraphDuration);

	if(times!=null && times.size()>=4)
	{
		startTime=(String)times.get(0);
		endTime=(String)times.get(1);
		startHour=(String)times.get(2);
		endHour=(String)times.get(3);
	}

	java.util.Date endDate=new java.util.Date();
	java.util.Date startDate=new java.util.Date(endDate.getTime()-(60*60*1000));

	String healthTitle=tab;
	if(healthTitle.equalsIgnoreCase("System"))
	{
		healthTitle="OS";
	}
	double defaultPieGraphWidth=191; // default pie graph width for calculation
	double defaultPieGraphHeight=115;  // default pie graph height for calculation
	double defaultPieRadius=40;  // default pie graph radius for calculation
	double pieGraphWidth=191;
	double pieGraphHeight=115;
	String pieRadius="40"; //default radius for 190 width
	double pieGraphWidthTo1024PxInPercent=defaultPieGraphWidth/1024;
	pieGraphWidth=screenWidthInDouble*pieGraphWidthTo1024PxInPercent;
	pieGraphWidth=MathUtils.round(pieGraphWidth,0);
	double pieGraphHeightToDefaultWidthInPercent=defaultPieGraphHeight/defaultPieGraphWidth;
	pieGraphHeight=pieGraphWidth*pieGraphHeightToDefaultWidthInPercent;
	pieGraphHeight=MathUtils.round(pieGraphHeight,0);
	double pieRadiusToDefaultWidthInPercent=defaultPieRadius/defaultPieGraphWidth;
	double pieRadiusInDouble=pieGraphWidth*pieRadiusToDefaultWidthInPercent;
	pieRadius=erutils.round(pieRadiusInDouble,0);
	int count=0;
	Vector healthChartAttributes=new Vector();
	healthChartAttributes.add("palette='2'");
	healthChartAttributes.add("decimals='2'");
	healthChartAttributes.add("enableRotation='1'");
	healthChartAttributes.add("bgColor='99CCFF,FFFFFF'");
	healthChartAttributes.add("bgAlpha='0,0'");
	healthChartAttributes.add("bgRatio='0,100'");
	healthChartAttributes.add("bgAngle='360'");
	healthChartAttributes.add("showBorder='0'");
	healthChartAttributes.add("startingAngle='80'");
	//healthChartAttributes.add("baseFontColor ='545454'");//this one add in java for check the condition
	healthChartAttributes.add("chartLeftMargin ='0'");
	healthChartAttributes.add("chartTopMargin ='0'");
	healthChartAttributes.add("chartBottomMargin ='0'");
	healthChartAttributes.add("chartRightMargin ='0'");
	healthChartAttributes.add("showToolTipShadow ='1'");
	healthChartAttributes.add("pieSliceDepth='7'");
	healthChartAttributes.add("numberSuffix='%'");
	//healthChartAttributes.add("showToolTipShadow ='1'");
	healthChartAttributes.add("pieOuterFaceAlpha  ='75'");
	healthChartAttributes.add("pieInnerFaceAlpha  ='100'");
	healthChartAttributes.add("pieYScale  ='60'");
	healthChartAttributes.add("smartLineColor  ='000000'");
	healthChartAttributes.add("smartLabelClearance  ='2'");
	healthChartAttributes.add("captionPadding  ='0'");
	healthChartAttributes.add("bgSWFAlpha  ='0'");
	healthChartAttributes.add("enableSmartLabels='1'");
	healthChartAttributes.add("pieRadius='"+pieRadius+"'");
	healthChartAttributes.add("labelDistance='6'");
	healthChartAttributes.add("isSmartLineSlanted='1'");
	healthChartAttributes.add("exportEnabled='0'");
	healthChartAttributes.add("exportAction='download'");
	healthChartAttributes.add("exportAtClient='0'");
	healthChartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");

	String xmlData=fusionChart.getXMLtoHealth(compName,compType,tab,healthChartAttributes);
%>

<div align="left" style="width:100%;border:0px solid #ff0000" id="div<%=++divCount%>">
	<div style="float:left;width:<%=pieGraphWidth%>;height:<%=(pieGraphHeight+20)%>;border:0px green solid;">
<%

	if(xmlData!=null && !xmlData.trim().equals(""))
	{
%>

				<table  border="0" cellpadding="0" cellspacing="0" class="vm border" >
					<tr>
						<td class="eg_75bold jvm_he  ader" height="16px" >&nbsp;<egui:intnl text='<%="monitor.dashboard.Current "+healthTitle+" Health"%>'/> </td>
					</tr>
					<tr>
						<td>
							<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="<%=pieGraphWidth%>" height="<%=pieGraphHeight%>" id="StackedColumn3D" flashVars="&dataXML=<chart><set value='1'/><set value='2'/></chart>" >
								<param name="FlashVars" value="&dataXML=<%=xmlData%>&chartWidth=<%=pieGraphWidth%>&chartHeight=<%=pieGraphHeight%>">
								<param name="quality" value="high" />
								<param name="movie" value="/final/FusionCharts/swf/Pie3D.swf" />
								<param name="WMode" value="Transparent">
								<embed wmode="transparent" src="/final/FusionCharts/swf/Pie3D.swf" flashVars="&dataXML=<%=xmlData%>" quality="high" width="<%=pieGraphWidth%>" height="<%=pieGraphHeight%>" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
							</object> -->
							<div id="chartPieContainer"  style="height:100%;"></div>
							<script type="text/javascript">
								if  ( FusionCharts( "myPieChartId" ) )
										FusionCharts( "myPieChartId" ).dispose();
								var myChart = new FusionCharts( "/final/FusionCharts/swf/Pie3D.swf","myPieChartId", "<%=pieGraphWidth%>", "<%=pieGraphHeight%>","0","1");
								myChart.setXMLData("<%=xmlData%>");
								myChart.setTransparent(true);
								myChart.render("chartPieContainer");
							</script>
						</td>
					</tr>
				</table>
<%
	}
	else
	{
%>
				<table  border="0" cellpadding="0" cellspacing="0" class="vm border">
					<tr>
						<td class="eg_75bold jvm_he  ader" height="16px" >&nbsp;<egui:intnl text='<%="monitor.dashboard.Current "+healthTitle+" Health"%>'/> </td>
					</tr>
					<tr>
						<td>
							<table cellpadding="1" cellspacing="0" border="0">
								<tr>
									<td align="center" colspan="2" height="80px" style="width:210px" class="eg_errorsmall"  valign="middle"><img src="/final/monitor/eg_images/exclamation-icon.gif"><br ><egui:intnl text="monitor.common.No Measures Available"/>!</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
<%
	}
%>

			</div>
<%
	if(isApplicationTab && isWeblogicServer)
	{
		Vector runingTestList=egDashboard.getRunningTest(compName,compType,tab);
%>
			<div style="float:left;width:<%=pieGraphWidth%>;height:<%=(pieGraphHeight+20)%>;border:0px green solid;">
				<table cellpadding="0" cellspacing="0" border="0" bordercolor="yellow">
					<tr>
						<td class="eg_75bold" height="20px" valign="top" align="center">
							<egui:intnl text='monitor.dashboard.Weblogic Heap Usage'/>
						</td>
					</tr>
<%
		if(runingTestList!=null && runingTestList.contains("WebLogicTest"))
		{
			HashMap MeasureValues=new HashMap();
			Vector jvmHeapAttributes=new Vector();
			double freeHeapSizeMeasure=0.0;
			double totalHeapSizeMeasure=0.0;
			boolean isTestHas_CutOffFactor=false;
			msmtHost=(String)allMsmtHosts.get("WebLogicTest");
			String totalHeapSizeDBColumn=dbInfo.getColumnForMeasure("WebLogicTest","Total_heap_size");
			String freeHeapSizeDBColumn=dbInfo.getColumnForMeasure("WebLogicTest","Free_heap_size");
			String totalHeapSize=dashboardDAO.getCurrentMeasure(hostName,portNo,"+","WebLogicTest",totalHeapSizeDBColumn,msmtHost);
			String freeHeapSize=dashboardDAO.getCurrentMeasure(hostName,portNo,"+","WebLogicTest",freeHeapSizeDBColumn,msmtHost);
			if((totalHeapSize!=null && !totalHeapSize.equals("") && !totalHeapSize.equalsIgnoreCase("null")) && (freeHeapSize!=null && !freeHeapSize.equals("") && !freeHeapSize.equalsIgnoreCase("null")))
			{
				totalHeapSizeMeasure=Double.parseDouble(totalHeapSize);
				freeHeapSizeMeasure=Double.parseDouble(freeHeapSize);
				double usedHeapSizeMeasure=totalHeapSizeMeasure-freeHeapSizeMeasure;
				usedHeapSizeMeasure=((usedHeapSizeMeasure/totalHeapSizeMeasure)*100);
				freeHeapSizeMeasure=((freeHeapSizeMeasure/totalHeapSizeMeasure)*100);
				String usedHeapSize=erutils.round(usedHeapSizeMeasure,2);
				freeHeapSize=erutils.round(freeHeapSizeMeasure,2);
				if((usedHeapSize!=null && !usedHeapSize.equals("") && !usedHeapSize.equalsIgnoreCase("null")))
				{
					MeasureValues.put("Used_heap",usedHeapSize);
					MeasureValues.put("Free_heap",freeHeapSize);
				}
			}
			if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
			{
				if(egDashboard.isTestHasCutOffFactor("WebLogicTest"))
				{
					boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,"WebLogicTest",msmtHost,"+");
					if(isTestExceededCutOffFactor)
					{
						isTestHas_CutOffFactor=true;
					}
				}
			}
			jvmHeapAttributes.add("palette='2'");
			jvmHeapAttributes.add("decimals='2'");
			jvmHeapAttributes.add("enableRotation='1'");
			jvmHeapAttributes.add("bgColor='99CCFF,FFFFFF'");
			jvmHeapAttributes.add("bgAlpha='0,0'");
			jvmHeapAttributes.add("bgRatio='0,100'");
			jvmHeapAttributes.add("bgAngle='360'");
			jvmHeapAttributes.add("showBorder='0'");
			jvmHeapAttributes.add("startingAngle='80'");
			jvmHeapAttributes.add("chartLeftMargin ='20'");
			jvmHeapAttributes.add("chartTopMargin ='10'");
			jvmHeapAttributes.add("chartBottomMargin ='10'");
			jvmHeapAttributes.add("chartRightMargin ='10'");
			jvmHeapAttributes.add("showToolTipShadow ='1'");
			jvmHeapAttributes.add("pieSliceDepth='7'");
			jvmHeapAttributes.add("numberSuffix='%'");
			//jvmHeapAttributes.add("showToolTipShadow ='1'");
			jvmHeapAttributes.add("pieOuterFaceAlpha  ='75'");
			jvmHeapAttributes.add("pieInnerFaceAlpha  ='100'");
			jvmHeapAttributes.add("pieYScale  ='60'");
			jvmHeapAttributes.add("smartLineColor  ='000000'");
			jvmHeapAttributes.add("smartLabelClearance  ='2'");
			jvmHeapAttributes.add("captionPadding  ='0'");
			jvmHeapAttributes.add("bgSWFAlpha  ='0'");
			jvmHeapAttributes.add("enableSmartLabels='1'");
			jvmHeapAttributes.add("pieRadius='"+pieRadius+"'");
			jvmHeapAttributes.add("labelDistance='6'");
			jvmHeapAttributes.add("isSmartLineSlanted='1'");
			jvmHeapAttributes.add("exportEnabled='0'");
			jvmHeapAttributes.add("exportAction='download'");
			jvmHeapAttributes.add("exportAtClient='0'");
			jvmHeapAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
			String xmlDataForJVMHeap="";
			if(MeasureValues!=null && !MeasureValues.isEmpty())
				xmlDataForJVMHeap=fusionChart.getXMLForHeap(MeasureValues,jvmHeapAttributes,"Overview");
			if(xmlDataForJVMHeap!=null && !xmlDataForJVMHeap.equals("") && !isTestHas_CutOffFactor)
			{
%>
					<tr>
						<td align="left" valign="middle">
							<div id="chartJVMPieContainer"  style="height:100%;"></div>
							<script type="text/javascript">
								if  ( FusionCharts( "myJVMPieChartId" ) )
										FusionCharts( "myJVMPieChartId" ).dispose();
								var myChart = new FusionCharts( "/final/FusionCharts/swf/Pie3D.swf","myJVMPieChartId", "<%=pieGraphWidth%>", "<%=pieGraphHeight%>","0","1");
								myChart.setXMLData("<%=xmlDataForJVMHeap%>");
								myChart.setTransparent(true);
								myChart.render("chartJVMPieContainer");
							</script>
						</td>
					</tr>
<%
			}
			else
			{
%>
					<tr>
						<td align="center" valign="middle" height="125px">
							<img class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_exclamation.png"><br> <egui:intnl text="monitor.dashboard.No Measures Available"/>!
						</td>
					</tr>
<%
			}
		}
		else
		{
%>
					<tr>
						<td align="center" valign="middle" height="125px">
							<img class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_exclamation.png"><br> <egui:intnl text="monitor.dashboard.No Measures Available"/>!
						</td>
					</tr>
<%
		}
%>
				</table>
			</div>
<%
	}
	boolean isHopDelayNeed=true;
	if(isNetworkTab)
	{
		int dialcount=0;
		boolean isNetworkTests=false;
		String tempDialGraphtest="";
		StringTokenizer stkSubSystemTestMeasures=new StringTokenizer(overviewDialGraphs,",");
		while(stkSubSystemTestMeasures.hasMoreTokens())
		{
			String subSystemTestMeasures=stkSubSystemTestMeasures.nextToken();
			String subSystemTest=subSystemTestMeasures.substring(0,subSystemTestMeasures.indexOf(":"));
			boolean isRelevent=specsInfo.isTestRelevantForServer(compType,subSystemTest);
			if(subSystemTestMeasures.trim().equals("NetworkTest:Availability")) {
				isNetworkTests=true;
				
			}
			else if(subSystemTestMeasures.trim().equals("NetworkTest:Pkt_loss_pct")) {
				isNetworkTests=true;
			}
			if(specsInfo.isTestRelevantForServer(compType,subSystemTest) && (runningtests.contains(subSystemTest) || isNetworkTests))
			{
				tempDialGraphtest+=subSystemTestMeasures+",";
				dialcount++;
			}
		}

		if(dialcount>2)
			isHopDelayNeed=false;

		if(tempDialGraphtest!=null && tempDialGraphtest.indexOf(",")!=-1)
			tempDialGraphtest=tempDialGraphtest.substring(0,tempDialGraphtest.length()-1);

		overviewDialGraphs=tempDialGraphtest;
	}

	Vector dialGraphtests=egDashboard.getTokensAsVector(overviewDialGraphs,",");
	int dialChartCount=0;
	ArrayList dialmeasuresNAList = new ArrayList();
	double defaultDialGraphWidth=191;  // default dial graph width for calculation
	double defaultDialGraphHeight=115;  // default dial graph height for calculation
	double dialGraphWidth=191;  
	double dialGraphHeight=115;
	double dialGraphWidthTo1024PxInPercent=defaultDialGraphWidth/1024;
	double dialGraphHeightToDefaultWidthInPercent=defaultDialGraphHeight/defaultDialGraphWidth;
	double defaultGauageOuterRadius=65; // default dial graph width for calculation
	double defaultGaugeXPos=90; // default dial graph Gauge X position for calculation
	double defaultGaugeYPos=93; // default dial graph Gauge Y position for calculation 
	String gauageOuterRadius="62";
	String gaugeXPos="90";
	String gaugeYPos="93";
	if(dialGraphtests.size()>0)
	{
		dialGraphWidth=screenWidthInDouble*dialGraphWidthTo1024PxInPercent;
		dialGraphWidth=MathUtils.round(dialGraphWidth,0);
		dialGraphHeight=dialGraphWidth*dialGraphHeightToDefaultWidthInPercent;
		dialGraphHeight=MathUtils.round(dialGraphHeight,0);
		double gauageOutRadiusToDefaultWidthInPercent=defaultGauageOuterRadius/defaultDialGraphWidth;
		double gauageOuterRadiusInDouble=dialGraphWidth*gauageOutRadiusToDefaultWidthInPercent;
		gauageOuterRadius=erutils.round(gauageOuterRadiusInDouble,0);
		double gauageXPosToDefaultWidthInPercent=defaultGaugeXPos/defaultDialGraphWidth;
		double gauageYPosToDefaultHeightInPercent=defaultGaugeYPos/defaultDialGraphHeight;
		double gaugeXPosInDouble=dialGraphWidth*gauageXPosToDefaultWidthInPercent;
		gaugeXPos=erutils.round(gaugeXPosInDouble,0);
		double gaugeYPosInDouble=dialGraphHeight*gauageYPosToDefaultHeightInPercent;
		gaugeYPos=erutils.round(gaugeYPosInDouble,0);
	}
	double defaultLedGraphWidth=140;  // default led graph width for calculation
	double defaultLedGraphHeight=85;  // default led graph height for calculation
	double ledGraphWidth=140;  
	double ledGraphHeight=95;
	double ledGraphWidthTo1024PxInPercent=defaultLedGraphWidth/1024;
	double ledGraphHeightToDefaultWidthInPercent=defaultLedGraphHeight/defaultLedGraphWidth;
	double defaultLedGap=1; // default led graph gap for calculation
	double defaultLedSize=1; // default led graph size for calculation
	String ledGap="1";
	String ledSize="1";
	ledGraphWidth=screenWidthInDouble*ledGraphWidthTo1024PxInPercent;
	ledGraphWidth=MathUtils.round(ledGraphWidth,0);
	ledGraphHeight=dialGraphWidth*ledGraphHeightToDefaultWidthInPercent;
	ledGraphHeight=MathUtils.round(ledGraphHeight,0);
	double ledGapToDefaultWidthInPercent=defaultLedGap/defaultLedGraphWidth;
	double ledGapInDouble=ledGraphWidth*ledGapToDefaultWidthInPercent;
	ledGap=erutils.round(ledGapInDouble,0);
	double ledSizeToDefaultWidthInPercent=defaultLedSize/defaultLedGraphWidth;
	double ledSizeInDouble=ledGraphWidth*ledSizeToDefaultWidthInPercent;
	ledSize=erutils.round(ledSizeInDouble,0);
	double defaultChartLeftMargin=42;
	double defaultChartRightMargin=25;
	String chartLeftMargin="42";
	String chartRightMargin="25";
	double chartLeftMarginToDefaultWidthInPercent=defaultChartLeftMargin/defaultLedGraphWidth;
	double ledLeftMarginInDouble=ledGraphWidth*chartLeftMarginToDefaultWidthInPercent;
	chartLeftMargin=erutils.round(ledLeftMarginInDouble,0);
	double chartRightMarginToDefaultWidthInPercent=defaultChartRightMargin/defaultLedGraphWidth;
	double ledRightMarginInDouble=ledGraphWidth*chartRightMarginToDefaultWidthInPercent;
	chartRightMargin=erutils.round(ledRightMarginInDouble,0);

	boolean isAllDialGraphHasNoMeasures=false;
	for(int i= 0; i < dialGraphtests.size();i++ )
	{
		String testmeasure=(String)dialGraphtests.get(i);
		test=testmeasure.substring(0,testmeasure.indexOf(":"));
		measure=testmeasure.substring(testmeasure.indexOf(":")+1);
		if(enabledTests!=null && !enabledTests.contains(test))
			continue;
		msmtHost=(String)allMsmtHosts.get(test);

		String measureValue="";
		String measureForDB=dbInfo.getColumnForMeasure(test,measure);

		String dial_measureMapping=iniObj.getValue("Dashboard_Dial_mapping",testmeasure);


		if(dial_measureMapping==null || dial_measureMapping.trim().equals(""))
			dial_measureMapping=mappingInfo.getMeasureDescription(test,measure);

		String tooltip=dial_measureMapping;

		if(dial_measureMapping!=null && !dial_measureMapping.equals("") && dial_measureMapping.length()>24)
			dial_measureMapping=dial_measureMapping.substring(0,21)+"...";

		msmtHost=(String)allMsmtHosts.get(test);
		String unit=tablesInfo.getUnitForMeasure(test,measure);
		if((unit!=null) && !(unit.equalsIgnoreCase("percent") || unit.equalsIgnoreCase("percentage") || unit.equals("%")))
			continue;
		if((unit!=null) && (unit.equalsIgnoreCase("percent") || unit.equalsIgnoreCase("percentage")))
			unit="%";

		Vector testInfos=dashboardDAO.getDescriptorsForTest(compName,compType,test,tab);
		String oneMsmtTime=dashboardDAO.lastMeasurementTimeForTest(compName,compType,test,tab);
		if(msmtHost==null)
			msmtHost="";
		boolean isFullView=false;
		Vector infos=(Vector)allTestInfos.get(test);
		Vector infosForCutOffFactor = new Vector();
		boolean isTestHas_CutOffFactor=true;
		if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
		{
			
			if(egDashboard.isTestHasCutOffFactor(test))
			{
				if(infos!=null && !infos.isEmpty())
				{
					for(int d=0;d<infos.size();d++)
					{
						boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,test,msmtHost,(String)infos.get(d));
						if(isTestExceededCutOffFactor)
						{
							infosForCutOffFactor.add(infos.get(d));
						}
						else
						{
							isTestHas_CutOffFactor=false;
						}
					}
				}
				/*if(infosForCutOffFactor!=null && !infosForCutOffFactor.isEmpty())
				{
					infos=infosForCutOffFactor;
				}*/				
			}
		}
		if(infos!=null && !infos.isEmpty() && infos.size()>1)
		{
			isFullView=true;
		}
		info=fusionChart.getInfoForDial(test,measure,compType,hostName,portNo,msmtHost,"NULL",sid,isThresholdNeed);

		if(info!=null && info.indexOf("+")!=-1)
			info=info.substring(info.indexOf("+")+1);

		info=com.egurkha.util.StringUtils.replace(info, "+", "|plus|");

		Vector dialChartAttributes=new Vector();
		String dialXMLData="";
		if(!isTestHas_CutOffFactor)
		{
			dialChartAttributes.add("clickURL='javascript:dialOnclick(&apos;dialUrl"+dialChartCount+"&apos;)'");  // To avoid drilldown url problem in Doublebyte. We have to create one HIDDEN element and the url to be stored there
			//dialChartAttributes.add("unescapeLinks='1'");
			dialChartAttributes.add("fillAngle='60'");
			dialChartAttributes.add("majorTMNumber='6'");
			dialChartAttributes.add("majorTMHeight='8'");
			dialChartAttributes.add("majorTMColor='e5e5e5'");
			dialChartAttributes.add("minorTMColor='e5e5e5'");
			dialChartAttributes.add("minorTMHeight='4'");
			dialChartAttributes.add("minorTMNumber='6'");
			dialChartAttributes.add("majorTMThickness='1'");
			dialChartAttributes.add("markerRadius='30'");
			dialChartAttributes.add("showGaugeBorder='0'");
			dialChartAttributes.add("gaugeOuterRadius='"+gauageOuterRadius+"'");
			dialChartAttributes.add("gaugeOriginX='"+gaugeXPos+"'");
			dialChartAttributes.add("gaugeOriginY='"+gaugeYPos+"'");
			dialChartAttributes.add("gaugeInnerRadius='0'");
			dialChartAttributes.add("formatNumberScale='0'");
			dialChartAttributes.add("displayValueDistance='0'");
			dialChartAttributes.add("decimalPrecision='2'");
			dialChartAttributes.add("tickMarkDecimalPrecision='2'");
			dialChartAttributes.add("tickValueDistance='14'");
			dialChartAttributes.add("pivotRadius='6'");
			dialChartAttributes.add("showPivotBorder='1'");
			dialChartAttributes.add("pivotBorderColor='000000'");
			dialChartAttributes.add("pivotBorderThickness='5'");
			dialChartAttributes.add("pivotFillMix='FFFFFF,000000'");
			dialChartAttributes.add("paletteThemeColor='ffffff'");
			dialChartAttributes.add("pivotFillType='linear'");
			dialChartAttributes.add("showToolTip='1'");
			dialChartAttributes.add("chartLeftMargin='0'");
			dialChartAttributes.add("chartRightMargin='0'");
			dialChartAttributes.add("chartBottomMargin='0'");
			dialChartAttributes.add("chartTopMargin='0'");
			dialChartAttributes.add("baseFontColor='000000'");
			dialChartAttributes.add("adjustTM='0'");

			dialChartAttributes.add("borderAlpha='0'");
			dialChartAttributes.add("bgAlpha='_alpha'");

			dialChartAttributes.add("showToolTipShadow='1'");
			dialChartAttributes.add("toolTipBgColor='ffffff'");
			dialChartAttributes.add("toolTipBorderColor='555555'");
			dialChartAttributes.add("exportEnabled='0'");
			dialChartAttributes.add("exportAction='download'");
			dialChartAttributes.add("exportAtClient='0'");
			dialChartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
			if(DialChartNeed!=null && DialChartNeed.equalsIgnoreCase("Yes"))
			{
				 dialXMLData=fusionChart.getXMLDataForDial(test,measure,compType,hostName,portNo,msmtHost,"NULL",sid,isThresholdNeed,dialChartAttributes,"000000",true,dialGraphWidth,dialGraphHeight,defaultDialGraphWidth,defaultDialGraphHeight);
			}
			else if(DialChartNeed!=null && DialChartNeed.equalsIgnoreCase("No"))
			{	
					
					Vector jvmChartAttributes=new Vector();
					jvmChartAttributes.add("clickURL='javascript:dialOnclick(&apos;dialUrl"+dialChartCount+"&apos;)'");
					jvmChartAttributes.add("upperLimit='100'");
					jvmChartAttributes.add("bgColor='99CCFF,FFFFFF'");
					jvmChartAttributes.add("bgAlpha='0,0'");
					jvmChartAttributes.add("showBorder='0'");
					jvmChartAttributes.add("adjustTM='0'");
					jvmChartAttributes.add("lowerLimit='0'");
					jvmChartAttributes.add("decimals='2'");
					jvmChartAttributes.add("showValue='0'");
					jvmChartAttributes.add("majorTMNumber='5'");
					//jvmChartAttributes.add("baseFontSize='8'");
					jvmChartAttributes.add("majorTMColor='000000'");
					jvmChartAttributes.add("majorTMHeight='5'");
					jvmChartAttributes.add("minorTMNumber='2'");
					jvmChartAttributes.add("minorTMColor='000000'");
					jvmChartAttributes.add("minorTMHeight='2'");
					jvmChartAttributes.add("majorTMThickness='1'");
					jvmChartAttributes.add("decimalPrecision='0'");
					jvmChartAttributes.add("ledGap='"+ledGap+"'");
					jvmChartAttributes.add("ledSize='"+ledSize+"'");
					jvmChartAttributes.add("tickValueDistance='2'");
					jvmChartAttributes.add("tickMarkDistance='1'");
					jvmChartAttributes.add("tickValueStep='1'");
					jvmChartAttributes.add("tickValueDecimals='8'");
					jvmChartAttributes.add("chartLeftMargin='"+chartLeftMargin+"'");
					jvmChartAttributes.add("chartRightMargin='"+chartRightMargin+"'");
					jvmChartAttributes.add("chartTopMargin='21'");
					jvmChartAttributes.add("chartBottomMargin='20'");
					jvmChartAttributes.add("baseFontSize ='9'");
					jvmChartAttributes.add("showToolTip='1'");
					jvmChartAttributes.add("baseFontColor  ='000000'");
					jvmChartAttributes.add("annRenderDelay='1.7'");
					jvmChartAttributes.add("exportEnabled='0'");
					jvmChartAttributes.add("exportAction='download'");
					jvmChartAttributes.add("exportAtClient='0'");
					jvmChartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
					dialXMLData=fusionChart.getXMLDataForDial(test,measure,compType,hostName,portNo,msmtHost,"NULL",sid,isThresholdNeed,jvmChartAttributes,"000000",true,ledGraphWidth,ledGraphHeight,defaultLedGraphWidth,defaultLedGraphHeight);
			}
			if(dialXMLData !=null && !dialXMLData.equals(""))
			{
				String layerName=dashboardDAO.getLayerForTest(compType,test,measure);

				String compTypeForAlarm=compType;
				if(layerName!=null && (layerName.equalsIgnoreCase("HOST") || layerName.equalsIgnoreCase("NETWORK") || layerName.equalsIgnoreCase("TCP")))
					compTypeForAlarm="Host_system";

				String measureState=egDashboard.getTestMeasureState(compName,compTypeForAlarm,layerName,test+"-"+info,measure);

				String layerPageUrl=response.encodeURL("/final/monitor/egDashBoardLayers.jsp?")+"qctr=2&fromPage=componentList&host="+EgURLEncoder.encode(compName,"UTF-8")+"&comptype="+compType+"&layer="+layerName+"&site="+site+"&test="+test+"-"+info+"&tstate="+measureState+"&msmt_host=";

				String moreDescriptorUrl=response.encodeURL("/final/monitor/EgMoreInfosDial.jsp?")+"hostName="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&test="+test+"&measure="+measure+"&msmtHost="+msmtHost+"&tab="+tab;

	%>
				<div style="float:left;width:<%=dialGraphWidth%>;height:<%=(dialGraphHeight+20)%>;border:0px blue solid;" align="center">
					<table border="0" cellspacing="0" cellpadding="0px" class="vm  border" >
						<tr>
							<td align="center" height="16px" class="eg_75bold jvm_he  ader" valign="top" title="<%=tooltip%>(<%=unit%>)"><%=dial_measureMapping%>(<%=unit%>)
	<%
				if(isFullView)//sarav info based test image in dial chart 
				{
	%>
								<a class="mouse eg_monlink" onclick="javascript:showMaximizedView('<%=moreDescriptorUrl%>',event,'loadPageForDial');" title="More" ><img  border="0" src="/final/monitor/eg_images/icon-newwindow_o.gif"/></a>
	<%
				}
	%>
							</td>
						</tr>
						<tr>
							<td align="center">
	<%
							if(DialChartNeed!=null && DialChartNeed.equalsIgnoreCase("Yes"))
							{
	%>
								<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="<%=dialGraphWidth%>" height="<%=dialGraphHeight%>" id="StackedColumn3D" >
								<param name="movie" value="/final/FusionCharts/swf/AngularGauge.swf" />
								<param name="FlashVars" value="&dataXML=<%=dialXMLData%>&chartWidth=<%=dialGraphWidth%>&chartHeight=<%=dialGraphHeight%>">
								<param name="quality" value="high" />
								<param name="WMode" value="Transparent">
								<embed wmode="transparent" src="/final/FusionCharts/swf/AngularGauge.swf" flashVars="&dataXML=<%=dialXMLData%>" quality="high" width="<%=dialGraphWidth%>" height="<%=dialGraphHeight%>" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
								</object> -->
								<div id="chartGaugeContainer<%=i%>"  style="height:100%;"></div>
								<script type="text/javascript">
									if  ( FusionCharts( "myGaugeChartId<%=i%>" ) )
											FusionCharts( "myGaugeChartId<%=i%>" ).dispose();
									var myChart = new FusionCharts("/final/FusionCharts/swf/AngularGauge.swf","myGaugeChartId<%=i%>", "<%=dialGraphWidth%>", "<%=dialGraphHeight%>","0","1");
									myChart.setXMLData("<%=dialXMLData%>");
									myChart.setTransparent(true);
									myChart.render("chartGaugeContainer<%=i%>");
								</script> 
	<%	
							} 
							else if(DialChartNeed!=null && DialChartNeed.equalsIgnoreCase("No"))
							{
	%>
								<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="<%=ledGraphWidth%>" height="<%=ledGraphHeight%>" id="StackedColumn3D" >
								<param name="movie" value="/final/FusionCharts/swf/VLED.swf" />
								<param name="FlashVars" value="&dataXML=<%=dialXMLData%>&chartWidth=<%=ledGraphWidth%>&chartHeight=<%=ledGraphHeight%>">
								<param name="quality" value="high" />
								<param name="WMode" value="transparent" />
								<embed wmode="transparent" src="/final/FusionCharts/swf/VLED.swf" flashVars="&dataXML=<%=dialXMLData%>" quality="high" width="<%=ledGraphWidth%>" height="<%=ledGraphHeight%>" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
								</object> -->
								<div id="chartVLEDContainer<%=i%>"  style="height:100%;"></div>
								<script type="text/javascript">
									if  ( FusionCharts( "myVLEDChartId<%=i%>" ) )
											FusionCharts( "myVLEDChartId<%=i%>" ).dispose();
									var myChart = new FusionCharts( "/final/FusionCharts/swf/VLED.swf","myVLEDChartId<%=i%>", "<%=ledGraphWidth%>", "<%=ledGraphHeight%>","0","1");
									myChart.setXMLData("<%=dialXMLData%>");
									myChart.setTransparent(true);
									myChart.render("chartVLEDContainer<%=i%>");
								</script>
	<%
							}
	%>
							</td>
						</tr>
					</table>
				<input type="hidden" id="dialUrl<%=dialChartCount%>" value="<%=layerPageUrl%>"/>
				</div>
	<%
				dialChartCount++;
				count++;
			}
		}
		if(dialXMLData ==null || dialXMLData.equals("") || isTestHas_CutOffFactor)
		{
				dialmeasuresNAList.add(dial_measureMapping+"#"+unit+"$"+tooltip);
		}
	}

	if((dialmeasuresNAList!=null && dialGraphtests!=null) && (dialmeasuresNAList.size()==dialGraphtests.size()))
	{
		isAllDialGraphHasNoMeasures=true;
	}
	else
	{

	/*for (int na=1;na < dialmeasuresNAList.size()+1;na++)
		{
			String NAlistdata = (String)dialmeasuresNAList.get(na-1);
			String dial_measureMapping = NAlistdata.substring(0,NAlistdata.indexOf("#"));
			String unit = NAlistdata.substring(NAlistdata.indexOf("#")+1,NAlistdata.indexOf("$"));
			String tooltip = NAlistdata.substring(NAlistdata.indexOf("$")+1);
			int temCount=(++dialChartCount)%5;
			dialChartCount--; */
%>
			<!--<div style="float:left;width:< % = dialGraphWidth % >;border:0px green solid;padding:2px">
				<table border="0" cellspacing="0" cellpadding="0" class="vm  border">
					<tr>
						<td align="center" height="16px"  class="eg_75bold" valign="top" >&nbsp;
						</td>
					</tr>
					<tr>
						<td align="center" valign="middle" style="width:208px" height="115"><span class="eg_75bold" title=" < % = ooltip % >(< % = unit % >)">< % = dial_measureMapping % >(< % = unit % >)</span><br><br>
							<img src="/final/monitor/eg_images/< % = monitor_Skin % >/exclamation-icon.gif"> <br> <egui:intnl text="monitor.dashboard.No Measures Available"/>!
						</td>
					</tr>
				</table>
			</div>-->
<%
			/*dialChartNoMeasuresCount++;
			int tempCount=(++dialChartCount)%5;
			dialChartCount--;
		}*/
	}

	String ddtest="";
	String ddmeasure="";
	String unit="";
	String ddformat="";

	boolean isDDTestRelevantForServer=false;
	if(isNetworkTab && isHopDelayNeed)
	{
		String s_singleDDtestmeasure=iniObj.getValue(subject,"Network_HopDelays");

		if(s_singleDDtestmeasure!=null && s_singleDDtestmeasure.indexOf(":")>0)
		{
			ddtest=s_singleDDtestmeasure.substring(0,s_singleDDtestmeasure.indexOf(":"));
			ddmeasure=s_singleDDtestmeasure.substring(s_singleDDtestmeasure.indexOf(":")+1,s_singleDDtestmeasure.indexOf("#"));
			ddformat=s_singleDDtestmeasure.substring(s_singleDDtestmeasure.indexOf("#")+1,s_singleDDtestmeasure.length());
			isDDTestRelevantForServer=specsInfo.isTestRelevantForServer(compType,ddtest);
			unit=tablesInfo.getUnitForMeasure(ddtest,ddmeasure);
		}
	}

	if(isDDTestRelevantForServer)
	{
		EgDDOverview  ddoverview=new  EgDDOverview();
		String vRouterMH = (String)allMsmtHosts.get(ddtest);
		Hashtable analysisData=ddoverview.getDDAnalysisData(compName,compType,ddtest,ddmeasure,ddformat,"Network","","","","","","","",vRouterMH);

		Hashtable graphParams=new Hashtable();
		if(enabledTests!=null && enabledTests.contains(ddtest) && analysisData!=null && analysisData.size()>0)
		{
			int   topcnt=0;
%>
			<div style="float:left;border:0px red solid;padding:0px;width:<%=dialGraphWidth*2%>;height:<%=(dialGraphHeight+20)%>;">
			<br><br>
				<table cellspacing="0" cellpadding="2px" border="0" >
					<tr>
						<td class="gradient_header eg_75bold">Routers by HopDelay(ms)</td>
					</tr>
					<tr>
						<td class="vmborder" style="padding:0px">
							<table width="100%"  class="tableborder_jvm"cellpadding="3" cellspacing="0" border="0">
								<tr>
									<td class="eg_75bold tdborder2_jvm" align="center"><egui:intnl text="monitor.dashboard.Router"/> </td>
									<td class="eg_75bold tdborder2_jvm" align="center"><egui:intnl text="monitor.common.Hop Delay"/></td>
								</tr>
<%
			Vector top=ddoverview.getTopValues();
			for(int j=0;j <top.size();j++)
			{
				String key=(String)top.get(j);
				Vector  analysis=(Vector)analysisData.get(key);
				Vector graphValues=(Vector)analysis.get(0);
				Vector graphData=(Vector)analysis.get(1);
				graphParams.put(key,graphValues);
				if(topcnt==10)
				break;
%>
								<tr>
									<td class="tdborder_jvm" > <%=key%></td>
									<td class="tdborder_jvm" style="width:300px;padding:0px; height:24px" align="center" >
										<table  cellpadding="1" cellpadding="0" border="0" style="table-layout:fixed;width:150px;height:20px" class="hop">
											<tr>
												<td align="center"> <%=(String)graphData.get(0)%> </td>
												<td align="center"> <%=(String)graphData.get(1)%> </td>
												<td align="center"> <%=(String)graphData.get(2)%> </td>
											</tr>
										</table>
									</td>
								</tr>
<%
				topcnt++;
			}
%>
							</table>
						</td>
					</tr>
				</table>
			</div>
<%		}
		else
		{
%>
				<div style="float:left;border:0px red solid;width:<%=dialGraphWidth*2%>;height:<%=(dialGraphHeight+20)%>">
				<table cellspacing="0" cellpadding="2px" border="0" bordercolor="red">
					<tr>
						<td class="eg_75bold" style="padding-left:4px" align="center">Routers by HopDelay(ms)</td>
					</tr>
					<tr>
						<td>
							<table width="100%" cellpadding="3" cellspacing="0" border="0">
								<tr>
									<td align="center"  height="80px" style="width:175px" class="eg_errorsmall"  valign="middle"><img src="/final/monitor/eg_images/exclamation-icon.gif"><br ><egui:intnl text="monitor.common.No Measures Available"/>!</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</div>
<%
		}
	}
	else if(!isAllDialGraphHasNoMeasures)
	{
%>

	<div style="clear:both;height:2px;border:0px solid red" class="eg_blankspace"> &nbsp;</div>

<%
	}
	Vector digitalGraphTests=egDashboard.getTokensAsVector(digitalGraphs,",");
	ArrayList digitalmeasuresNAList = new ArrayList();
	int digitalChartWidth=100;
	int rowCount=0;
	boolean isAllDigitalGraphsHasNoMeasures=false;
	for(int k=0 ; k < digitalGraphTests.size();k++ )
	{
		String testMeasure=(String)digitalGraphTests.get(k);
		test=testMeasure.substring(0,testMeasure.indexOf(":"));
		measure=testMeasure.substring(testMeasure.indexOf(":")+1);

		if(enabledTests!=null && !enabledTests.contains(test))
			continue;

		if(isNetworkTab && !specsInfo.isTestRelevantForServer(compType,test))
			continue;
		msmtHost=(String)allMsmtHosts.get(test);
		if(msmtHost==null)
			msmtHost="";

		String measureForDB=dbInfo.getColumnForMeasure(test,measure);

		Vector topInfoWithMeasure=dashboardDAO.getCurrentForTop(hostName,portNo,test,measureForDB,msmtHost,true,1,true);
		String toolTipmeasureValue="";
		String measureValue="";
		String measureMapping="";	
		boolean isTestHas_CutOffFactor=false;
		boolean isMeasureAvailable=false;
		if(topInfoWithMeasure!=null && topInfoWithMeasure.size()>1)
		{
			info=(String)topInfoWithMeasure.get(0);
			toolTipmeasureValue=(String)topInfoWithMeasure.get(1);
			if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
			{
				if(egDashboard.isTestHasCutOffFactor(test))
				{
					boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,test,msmtHost,info);
					if(isTestExceededCutOffFactor)
					{
						isTestHas_CutOffFactor=true;
					}
				}
			}
		}
		if(info!=null && info.indexOf("+")!=-1)
			info=info.substring(info.indexOf("+")+1);

		info=com.egurkha.util.StringUtils.replace(info, "+", "|plus|");

		if(toolTipmeasureValue!=null && !toolTipmeasureValue.equals(""))
			measureValue=erutils.round(Double.parseDouble(toolTipmeasureValue),2);
		msmtHost=(String)allMsmtHosts.get(test);
		if(msmtHost==null)
			msmtHost="";
		double defaultDigitalGraphWidth=100;  // default dial graph width for calculation
		double defaultDigitalGraphHeight=42;  // default dial graph height for calculation
		double digitalGraphWidth=100;  
		double digitalGraphHeight=42;
		String digitalGraphWidthStr="100";
		String digitalGraphHeightStr="42";
		double digitalGraphWidthTo1024PxInPercent=defaultDigitalGraphWidth/1024;
		double digitalGraphHeightToDefaultWidthInPercent=defaultDigitalGraphHeight/defaultDigitalGraphWidth;
		digitalGraphWidth=screenWidthInDouble*digitalGraphWidthTo1024PxInPercent;
		if(measureValue!=null && measureValue.length()>0)
			digitalChartWidth=(measureValue.length()>4)?(measureValue.length()*18):100;
		digitalGraphHeight=digitalGraphWidth*digitalGraphHeightToDefaultWidthInPercent;
		digitalGraphHeightStr=erutils.round(digitalGraphHeight,0);
		digitalGraphWidthStr=erutils.round(digitalGraphWidth,0);
		
		isMeasureAvailable=(measureValue!=null && !measureValue.trim().equals("") && ((!measureValue.trim().equals("-5") && !measureValue.trim().equals("-1") && !testerInfo.getAllowNegativeValues(test,measure)) || (testerInfo.getAllowNegativeValues(test,measure))));	
		if(testerInfo.getAllowNegativeValues(test,measure) && isMeasureAvailable)
		{
			measureValue=com.egurkha.util.StringUtils.replace(measureValue,"+","");
		}
		measureMapping=iniObj.getValue("Dashboard_Digital_mapping",testMeasure);

		if(measureMapping==null || measureMapping.trim().equals(""))
			measureMapping=mappingInfo.getMeasureDescription(test,measure);

		String layerName=dashboardDAO.getLayerForTest(compType,test,measure);

		String compTypeForAlarm=compType;
		if(layerName!=null && (layerName.equalsIgnoreCase("HOST") || layerName.equalsIgnoreCase("NETWORK") || layerName.equalsIgnoreCase("TCP")))
			compTypeForAlarm="Host_system";

		String measureState=egDashboard.getTestMeasureState(compName,compTypeForAlarm,layerName,test+"-"+info,measure);

		String layerPageUrl=response.encodeURL("/final/monitor/egDashBoardLayers.jsp?")+"qctr=2&fromPage=componentList&host="+EgURLEncoder.encode(compName,"UTF-8")+"&comptype="+compType+"&layer="+layerName+"&site="+site+"&test="+test+"-"+info+"&tstate="+measureState+"&msmt_host=";
		if(isMeasureAvailable && !isTestHas_CutOffFactor)
		{
	%>
								<div style="float:left;border:0px green solid;padding:2px;">
									<table border="0" cellspacing="0" cellpadding="0" >
										<tr>
											<td align="center"  height="131px" valign="top" width="<%=dialGraphWidth%>px">
												<table border="0" cellspacing="0" cellpadding="4">
													<tr>
														<td align="center" height="20px"  valign="top">
														</td>
													</tr>
													<tr>
														<td align="center" valign="middle" height="110px"><b class="eg_75bold"> <%=measureMapping%></b><br><br>
														<a class="eg_monlink" href ='javascript:clickForLayerModel("digitalGraphID<%=digitalChartCount%>");'><img border="0" src="../servlet/com.egurkha.monitor.egDigitalChart?width=<%=digitalGraphWidthStr%>&height=<%=digitalGraphHeightStr%>&value=<%=measureValue%>&forecolor=00FF00&background=999999&background1=999999" title="<%=com.egurkha.util.StringUtils.replace(info,"+","")+"("+toolTipmeasureValue+")"%>" /></a><br><span class="eg_75bold"> (<%=tablesInfo.getUnitForMeasure(test,measure)%>)</span>
														</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
									<input type="hidden" id="digitalGraphID<%=digitalChartCount%>" value="<%=layerPageUrl%>"/>
								</div>
	<%
				digitalChartCount++;
				rowCount++;
		}
		else
		{
			digitalmeasuresNAList.add(measureMapping+"#"+(tablesInfo.getUnitForMeasure(test,measure)));
		}
	}

	if((digitalmeasuresNAList!=null && digitalGraphTests!=null) && (digitalmeasuresNAList.size()==digitalGraphTests.size()))
	{
		isAllDigitalGraphsHasNoMeasures=true;
	}
	else
	{
	/*	for(int na1=1 ; na1<digitalmeasuresNAList.size()+1;na1++)
		{
				String listdata = (String)digitalmeasuresNAList.get(na1-1);
				String measureMapping = listdata.substring(0,listdata.indexOf("#"));
				String digitalunit = listdata.substring(listdata.indexOf("#")+1);
				if((5-(digitalChartCount%5)==na1-1)||((digitalChartNoMeasuresCount-tempDigitalGraphCount)%5==0&&na1>=2))
				{
					isTRNeedInDigitalChart=false;
					tempDigitalGraphCount=na1-1;
				}*/
%>
							<!--div style="float:left;border:0px green solid;padding:2px">
								<table border="0" cellspacing="0" cellpadding="0" >
									<tr>
										<td align="center"  height="131px" valign="top" width="< % = dialGraphWidth % >">
											<table border="0" cellspacing="0" cellpadding="4">

												<tr>
													<td align="center" height="20px"  valign="top">
													</td>
												</tr>
												<tr>
													<td align="center" valign="middle" height="110px"><b class="eg_75bold"> < % = measureMapping % ></b> <br><br>
														<img src="/final/monitor/eg_images/< % = monitor_Skin % >/exclamation-icon.gif"> <br> <egui:intnl text="monitor.dashboard.No Measures Available"/>!
													</td>
												</tr>
												
											</table>
										</td>
									</tr>
								</table>
							</div-->
<%
	/*		digitalChartNoMeasuresCount++;
			if((5-(digitalChartCount%5)==na1)||((digitalChartNoMeasuresCount-tempDigitalGraphCount)%5==0))
			{
				isTRNeedInDigitalChart=true;
			}
		}*/
	}
	if(isAllDigitalGraphsHasNoMeasures && isAllDialGraphHasNoMeasures)
	{
		double noMeasuresImageWidth=(screenWidthInDouble-pieGraphWidth)-120;
		String noMeasuresImageWidthStr=erutils.round(noMeasuresImageWidth,0);
%>

			<div style='float:left;border:0px green solid;padding:2px;width:<%=noMeasuresImageWidthStr%>'>
				<table border="0" cellspacing="0" cellpadding="0" align="center" >
					<tr>
						<td align="center"  height="131px" valign="top" width="<%=dialGraphWidth%>">
							<table border="0" cellspacing="0" cellpadding="4">
								<tr>
									<td align="center" valign="middle" height="110px"><b class="eg_75bold"> <egui:intnl text="monitor.dashboard.Dial and Digital Graphs"/> </b> <br><br>
										<img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"> <br> <egui:intnl text="monitor.dashboard.No Measures Available"/>!
									</td>
								</tr>
								
							</table>
						</td>
					</tr>
				</table>
			</div>
<%
	}
	if(isTRNeedInDigitalChart)
	{
%>
<%
	}
	int totalCount=digitalChartCount+digitalChartNoMeasuresCount;

	if(totalCount%5>0)
		emptyTDCount=5-(totalCount%5);
	else
		emptyTDCount=0;
%>

	</div>
	<div style="clear:both;height:2px;border:0px solid red" class="eg_blankspace"> &nbsp;</div>
<%
	String tmpVar = tab+" Config";
	String configDivCount="img"+divCount;
	String configTitleStr="";

	if(hasConfig && !disabledBlocks.contains(tmpVar))
	{
		configTitleStr=mappingInfo.getTextDescription("monitor.dashboard."+tab+" Configuration");
%>
	<div style="margin-left:5px;margin-top:5px;float:left;height:152px;border:0px solid #ff0000" id="div<%=++divCount%>" >
		<table border="0" cellpadding="0"  cellspacing="0" height="100%" valign="top">
			<tr>
				<td valign="top" class="gradient_header" height="20px">
					<table border="0" cellpadding="2"  cellspacing="0" width="100%"><col width="95%"><col width="15px"><col width="15px">
						<tr>
							<td class="eg_75bold" style="padding-left:4px" height="20px" width="100%"><%=configTitleStr%></td>
<%
		if(adminPermission==true)
		{
%>
							<td class="eg_75bold" style="padding-right:4px" valign="middle" align="right" onclick="javascript:showMaximizedTable('event','ConfigDataDiv','','img<%=divCount%>','<%=configTitleStr%>');"> <img class="png" id="img<%=divCount%>" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_maximize_div.png"/> </td>
							<td align="right" valign="middle" class="eg_75bold" style="padding-right:4px"> <img class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_close_div.png" onclick="javascript:closeDiv(<%=divCount%>,'<%=tab+"_Overview"%>','<%=tab+" Config"%>');" onload="javascript:divonload('<%=divCount%>','<%=tab+"_Overview_Config"%>');"/> </td>
<%
		}
		else
		{
%>
							<td class="eg_75bold" style="padding-right:4px" valign="middle" align="right" >&nbsp;</td>
							<td class="eg_75bold" style="padding-right:4px" valign="middle" align="right" onclick="javascript:showMaximizedTable('event','ConfigDataDiv','','img<%=divCount%>','<%=configTitleStr%>');"> <img class="png" id="img<%=divCount%>" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_maximize_div.png"/> </td>
<%
		
		}
%>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td width="100%" valign="top" class="vmborder">
				<div id="ConfigDataDiv" class="div_scroll" style="border:0px solid blue;width:460px;height:130px">
<%
		if(configData!=null && configData.size()>0)
		{
%>
					<table border="0" width="100%"  class="tableborder_jvm" cellpadding="3" cellspacing="0" valign="top" >
<%
			for(int c=0;c<configData.size();c=c+2)
			{
				String testMeasure=(String)configData.get(c);
				String configration=(String)configData.get(c+1);
				if(testMeasure!=null && testMeasure.equalsIgnoreCase("selected_info"))
				{
					String testNameForConfig=configration.substring(0,configration.indexOf("|"));
					configration=configration.substring(configration.indexOf("|")+1,configration.length());
					configration=com.egurkha.util.StringUtils.replace(configration,"+","");
%>
					<tr>
						<td colspan="2" class="eg_75bold tdborder2_jvm" style="padding-left:4px;border-right-width:0px" height="25px"><egui:intnl test="<%=testNameForConfig%>" />&nbsp; - &nbsp;<%=configration%></td>
					</tr>

<%				}
				else if(testMeasure!=null && testMeasure.equalsIgnoreCase("selected_test"))
				{
%>
					<tr>
						<td colspan="2" class="eg_75bold tdborder2_jvm" style="padding-left:4px;border-right-width:0px" height="25px"><egui:intnl test="<%=configration%>" /></td>
					</tr>
<%				}
				else if(testMeasure!=null && testMeasure.equalsIgnoreCase("empty_row"))
				{
%>
					<tr>
						<td colspan="2" class="tdborder_jvm" style="padding-left:4px;border-right-width:0px" height="25px"></td>
					</tr>

<%				}
				else
				{
					String measureNameMapping=iniObj.getValue("Dashboard_measures_mapping",testMeasure);
					String testName = testMeasure.substring(0,testMeasure.indexOf(":"));
					String measureName = testMeasure.substring(testMeasure.indexOf(":")+1,testMeasure.length());

					if(measureNameMapping==null || measureNameMapping.trim().equals(""))
						measureNameMapping=mappingInfo.getMeasureDescription(testName,measureName);
%>
						<tr>
							<td class="tdborder_jvm" nowrap><%=measureNameMapping%></td>
							<td class="tdborder_jvm" wrap><%=configration%></td>
						</tr>
<%
				}
			}
%>
					</table>
<%
		}
		else
		{
%>
					<table border="0" width="100%" cellpadding="3" cellspacing="0" valign="top" >
						<tr>
							<td align="center"  height="100%" valign="middle" width="100%">
								<table border="0" cellpadding="0" cellspacing="0" width="100%" height="120">
									<tr>
									<td align="center" height="100%" valign="middle"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"> <br > <egui:intnl text="monitor.dashboard.Configuration details are not available"/>!</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
<%
		}
%>
				</div>
				</td>
			</tr>
		</table>
	</div>
<%
	}
	if(!disabledBlocks.contains("Layerhealth") && !hasConfig)
	{
		String healthGraphURL=healthGraphURL="../servlet/com.egurkha.monitor.EgEventChart?hostName="+compName+"&compType="+compType+"&module="+tab+"&monitorSkin="+monitor_Skin+"&fromHealth=true&width=350&height=110&imgdate="+new java.util.Date();

		Vector chartAttributes=new Vector();
		chartAttributes.add("showLegend='0'");
		chartAttributes.add("palette='2'");
		chartAttributes.add("useRoundEdges='1'");
		chartAttributes.add("showValues='0'");
		chartAttributes.add("clickURL='javascript:showBigGraph(&apos;"+EgURLEncoder.encode(healthGraphURL,"UTF-8")+"&apos;,this.event,1,&apos;LayerwiseHealth&apos;)'");
		chartAttributes.add("bgAlpha='0,0'");
		chartAttributes.add("bgColor='ffffff,ffffff'");
		chartAttributes.add("showToolTipShadow='1'");
		chartAttributes.add("canvasLeftMargin='5'");
		chartAttributes.add("canvasRightMargin='5'");
		chartAttributes.add("canvasTopMargin='5'");
		chartAttributes.add("canvasBottomMargin='5'");
		chartAttributes.add("baseFontColor ='000000'");
		chartAttributes.add("baseFontSize ='9'");
		chartAttributes.add("baseFont  ='verdana'");
		chartAttributes.add("showBorder  ='0'");
		chartAttributes.add("showPlotBorder  ='0'");
		chartAttributes.add("plotSpacePercent='40'");
		chartAttributes.add("adjustDiv='0'");
		chartAttributes.add("yAxisMaxValue='100.001'");
		chartAttributes.add("decimals='2'");
		chartAttributes.add("exportEnabled='0'");
		chartAttributes.add("exportAction='download'");
		chartAttributes.add("exportAtClient='0'");
		chartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");

		String layerHealthXML=fusionChart.getXMLForLayerHealth(compName,compType,tab,false,chartAttributes);
String layerHealthURL=response.encodeURL("/final/monitor/egDashTimeline.jsp")+"?"+"hostName="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&graphType=LayerwiseHealth&module="+tab;
%>
	<div id="ConfigDataDiv" style="margin-left:5px;margin-top:5px;float:left;height:152px;border:0px solid #2B7F82" id="div<%=++divCount%>" >
		<table border="0" cellpadding="0" cellspacing="0" height="100%" valign="top" width="100%">
			<tr>
				<td valign="top" class="gradient_header" width="100%">
					<table border="0" cellpadding="2"  cellspacing="0" width="100%"><col width="95%"><col width="15px"><col width="15px">
			<tr>
							<td class="eg_75bold" style="padding-left:4px" height="20px" width="100%"><egui:intnl text="monitor.dashboard.Current Layerwise Health" /></td>
				
<%
		if(adminPermission==true)
		{

%>
							<td class="eg_75bold" style="padding-right:4px;" valign="middle" align="right" onclick="javascript:showMaximizedView('<%=layerHealthURL%>','event','layerHealth');"> <img id="img<%=divCount%>"  class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_maximize_div.png"/> </td>
							<td align="right" valign="middle" class="eg_75bold" style="padding-right:4px;"> <img class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_close_div.png" onclick="javascript:closeDiv(<%=divCount%>,'<%=tab+"_Overview"%>','Layerhealth');" onload="javascript:divonload('<%=divCount%>','<%=tab+"_Overview_Layerhealth"%>');"/> </td>
<%
		}
		else
		{
%>
							<td class="eg_75bold" style="padding-right:4px;" valign="middle" align="right" >&nbsp;</td>
							<td class="eg_75bold" style="padding-right:4px;" valign="middle" align="right" onclick="maximizeDiv(<%=divCount%>,'<%=tab+"_Overview_Layerhealth"%>','dashboardoverview')"> <img id="img<%=divCount%>"  class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_maximize_div.png"/> </td>
<%
		}
%>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td width="100%" align="center" class="vmborder" height="100%">
					<table border="0" width="100%" cellpadding="0" cellspacing="0" height="100%" class="table brder_jvm">
						<tr>
							<td width="100%" height="100%" align="center"
							valign="middle" class="tdborder_jvm">
								<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="400" height="110" id="StackedColumn3D" >
									<param name="movie" value="/final/FusionCharts/swf/StackedBar2D.swf" />
									<param name="FlashVars" value="&dataXML=<%=layerHealthXML%>&chartWidth=400&chartHeight=110">
									<param name="quality" value="high" />
									<param name="WMode" value="Transparent">
									<embed wmode="transparent" src= "/final/FusionCharts/swf/StackedBar2D.swf" flashVars = "&dataXML=<%=layerHealthXML%>" quality="high" width="400" height="110" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
								</object> -->
								<div id="chartSbarContainer"  style="height:100%;"></div>
								<script type="text/javascript">
									if  ( FusionCharts( "mySBarChartId" ) )
											FusionCharts( "mySBarChartId" ).dispose();
									var myChart = new FusionCharts( "/final/FusionCharts/swf/StackedBar2D.swf","mySBarChartId", "400", "110","0","1");
									myChart.setXMLData("<%=layerHealthXML%>");
									myChart.setTransparent(true);
									myChart.render("chartSbarContainer");
								</script>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</div>
<%
	}
	if(!disabledBlocks.contains("KPI"))
	{
		String kpiFullViewURL=response.encodeURL("/final/monitor/egCustomDashboardp.jsp")+"?"+"compName="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&subject="+EgURLEncoder.encode(subject,"UTF-8")+"&site="+site+"&tab="+tab+"&defaultMGraphDuration="+defaultMGraphDuration+"&defaultSparklineDuration="+defaultSparklineDuration+"&divCount="+divCount+"&state="+state+"&blockType=KPI";
%>
	<div style="margin-left:5px;margin-top:5px;float:left;height:152px;border:0px solid #2B7F82" id="div<%=++divCount%>" >
		<table border="0" cellpadding="0"  cellspacing="0" height="100%" valign="top">
			<tr>
				<td valign="top" class="gradient_header">
					<table border="0" cellpadding="2"  cellspacing="0" width="100%"><col width="95%"><col width="15px"><col width="15px">
						<tr>
							<td class="eg_75bold" style="padding-left:4px;border-right-width:0px;" height="20px" width="100%"><egui:intnl text="monitor.dashboard.Key Performance Indicators" /></td>
				
<%
		if(adminPermission==true)
		{
%>
							<td class="eg_75bold" valign="middle" style="padding-right:4px;border-right-width:0px;border-left-width:0px" align="right" onclick="javascript:showMaximizedView('<%=kpiFullViewURL%>','event','KPI');"> <img class="png" id="img<%=divCount%>" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_maximize_div.png"/> </td>
							<td valign="middle" class="eg_75bold" align="right" style="padding-right:4px;border-left-width:0px"> <img class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_close_div.png" onclick="javascript:closeDiv(<%=divCount%>,'<%=tab+"_Overview"%>','KPI');" onload="javascript:divonload('<%=divCount%>','<%=tab+"_Overview_KPI"%>');"/> </td>
<%
		}
		else
		{
%>
							<td class="eg_75bold" valign="middle" style="padding-right:4px;border-right-width:0px;border-left-width:0px" align="right" >&nbsp;</td>
							<td class="eg_75bold" valign="middle" style="padding-right:4px;border-left-width:0px" align="right" onclick="javascript:showMaximizedView('<%=kpiFullViewURL%>','event','KPI');"> <img class="png" id="img<%=divCount%>" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_maximize_div.png"/> </td>
<%
		}
%>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td valign="top" width="100%" style="padding:0px" class="vmborder">
				<div class="div_scroll" id="kpiDiv" style="border:0px solid #ff0000; height:130px;width: ">
					<table border="0"   cellpadding="2" cellspacing="0" width="100%">
<%
	Vector states=new Vector();
	states.add("HIGH");
	states.add("INTERMEDIATE");
	states.add("LOW");
	states.add("UNKNOWN");
	states.add("GOOD");

	boolean isPerformanceIndicatorsAvailable=egDashboard.getPerformanceIndicatorsAvailable();

	if(performanceIndicators!=null && performanceIndicators.size()>0 && isPerformanceIndicatorsAvailable)
	{
		int i_indicatorCount=0;
		Iterator ptr=states.iterator();
		boolean isKPIAvailable=false;
		while(ptr.hasNext())
		{
			String  keyState = (String)ptr.next();
			Vector indicators=(Vector)performanceIndicators.get(keyState);

			if(indicators!=null && indicators.size()>0)
			{
				for(int  i=0;i<indicators.size();i++)
				{
					String perfIndicatorValue=(String)indicators.get(i);
					String tstmeasure ="";
					String desc="";
					String  indicURL="";

					if(perfIndicatorValue.indexOf("{")!=-1)
					{
						tstmeasure = perfIndicatorValue.substring(0,perfIndicatorValue.indexOf("{"));
						desc = perfIndicatorValue.substring(perfIndicatorValue.indexOf("{")+1,perfIndicatorValue.indexOf("@")-1);
					}
					else if(perfIndicatorValue.indexOf("@")!=-1)
					{
						tstmeasure = perfIndicatorValue.substring(0,perfIndicatorValue.indexOf("@"));
					}

					if(perfIndicatorValue.indexOf("@")!=-1)
						indicURL=perfIndicatorValue.substring(perfIndicatorValue.indexOf("@")+1,perfIndicatorValue.length());

					String cur_Measure = "";
					String dispInfo="";

					if(desc!=null && !desc.equals("+") && !desc.equals("") && !desc.equals("Summary"))
					{
						dispInfo=" {"+desc+"}";
					}
					String testname="",testmeasure="";
					if(tstmeasure!=null && tstmeasure.indexOf(":")>0)
					{
						testname=tstmeasure.substring(0,tstmeasure.indexOf(":"));
						testmeasure=tstmeasure.substring(tstmeasure.indexOf(":")+1);
					}

					if(enabledTests!=null && !enabledTests.contains(testname))
						continue;

					String kpimeasureForDB=dbInfo.getColumnForMeasure(testname,testmeasure);

					String infoForSparkline="+"+desc;
					String sidForSparkline=sid;

					if(isOracleServer && (tab.equalsIgnoreCase("System") || tab.equalsIgnoreCase("Network")))
						sidForSparkline=null;

					String graph_values=dashboardDAO.getGraphValuesForSpark(hostName,infoForSparkline,sidForSparkline,testname,kpimeasureForDB,sparkLineStartTime+" "+sparkLineStartHour+":"+endDate.getMinutes()+":00",sparkLineEndTime+" "+sparkLineEndHour+":"+endDate.getMinutes()+":00");

					msmtHost=(String)allMsmtHosts.get(testname);
					if(msmtHost==null)
						msmtHost="";

					if(infoForSparkline!=null && infoForSparkline.indexOf("*")==-1)
						infoForSparkline="*"+infoForSparkline;
					String  excludedInfos = egDashboard.convertTokensAsString(dashboardDAO.getExcludedInfo(testname,testmeasure,compType,true,false),",");
					dashboardDAO.setOmittedInfo(excludedInfos);
					Vector topInfoWithMeasure=dashboardDAO.getCurrentForTop(hostName,portNo,testname,kpimeasureForDB,msmtHost,true,1,true);

					if(topInfoWithMeasure!=null && topInfoWithMeasure.size()>=2)
					{
						infoForSparkline=(String)topInfoWithMeasure.get(0);
						cur_Measure=(String)topInfoWithMeasure.get(1);
						if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
						{
							if(egDashboard.isTestHasCutOffFactor(testname))
							{
								boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,testname,msmtHost,infoForSparkline);
								if(isTestExceededCutOffFactor)
									continue;
							}
						}
					}

					if(cur_Measure==null || cur_Measure.trim().equals("") || cur_Measure.trim().equals("-5") || cur_Measure.trim().equals("-1") && !testerInfo.getAllowNegativeValues(testname,testmeasure))
						cur_Measure="-";
					String unitValue = tablesInfo.getUnitForMeasure(testname,testmeasure);

					if(cur_Measure!=null && !cur_Measure.equals("-") && unitValue!=null && unitValue.equalsIgnoreCase("MB"))
					{
						double floatVal=(Double.parseDouble(cur_Measure))/1024;
						floatVal=MathUtils.round(floatVal,2);
						cur_Measure=floatVal+"";
						unitValue="GB";
					}

					if(unitValue.equalsIgnoreCase("boolean"))
					{
						if(cur_Measure.equals("0"))
							cur_Measure="No";
						else if(cur_Measure.equals("1"))
							cur_Measure="Yes";
					}

					if((unitValue!=null) && (unitValue.equalsIgnoreCase("percent") || unitValue.equalsIgnoreCase("percentage")))
						unitValue="%";

					String kpiMeasureMapping=iniObj.getValue("Dashboard_KPI_mapping",tstmeasure);
					if(kpiMeasureMapping==null || kpiMeasureMapping.trim().equals(""))
					{
						String kpiTest = "";
						String kpiMeasure = "";
						kpiTest = tstmeasure.substring(0,tstmeasure.indexOf(":"));
						kpiMeasure = tstmeasure.substring(tstmeasure.indexOf(":")+1,tstmeasure.length());
						kpiMeasureMapping=mappingInfo.getMeasureDescription(kpiTest,kpiMeasure);
					}
					String sidformax = "";
					if(isOracleServer && sid!=null && !sid.equals(""))
					{
						sidformax = "sid="+sid+"&";
					}
					if(isfromSuper)
					{
						if(indicURL.indexOf("?") > -1)
						{
							String url = indicURL.substring(0,indicURL.indexOf("?")+1);
							indicURL = response.encodeURL(url)+indicURL.substring(indicURL.indexOf("?")+1);
						}
					}
					if(!isKPIAvailable)
						isKPIAvailable=true;
%>
						<tr>
							<td style="width:14px;"><img src ="/final/monitor/eg_images/bullet_<%=keyState%>.gif">
							</td>
							<td >
							<a class = "eg_monlink" href ='javascript:clickForLayerModel("kpiID<%=i_indicatorCount%>");'>
							<%=kpiMeasureMapping%> (<%=unitValue%>) <%=dispInfo%> 
							</a></td>
							<input type="hidden" id="kpiID<%=i_indicatorCount%>" value="<%=indicURL%>"/>
<%
					Vector infos=dashboardDAO.getInfosbyMeasure(testname,hostName,portNo,kpimeasureForDB,site,sparkLineStartTime+" "+sparkLineStartHour+":"+endDate.getMinutes()+":00",sparkLineEndTime+" "+sparkLineEndHour+":"+endDate.getMinutes()+":00",tab);
					if(infos.indexOf("+")>=0)
					{
						infos.remove(infos.indexOf("+"));
					}
					String overviewinfo="";
					String infoForTable="";
					boolean infoRelevant=false;
					for(int j=0;j<infos.size();j++)
					{
						overviewinfo += com.egurkha.util.StringUtils.replace((String)infos.get(j),"+","*")+",";
						infoForTable +=com.egurkha.util.StringUtils.replace((String)infos.get(j),"+","$")+",";
					}
					if((overviewinfo.equalsIgnoreCase("*,") || overviewinfo.equalsIgnoreCase("+*,") || overviewinfo.equalsIgnoreCase("+,") || overviewinfo.equalsIgnoreCase("$,")))
					{
						overviewinfo="";
						infoForTable="";
					}
					if(infos!=null && infos.size()>1)
					{
						infoRelevant=true;
					}
					String urlForMaximize="/final/servlet/com.egurkha.monitor.EgDashboardTimelineMeasures?"+sidformax+"measure="+kpimeasureForDB+"&state="+state+"&starttime="+startTime+"&port="+portNo+"&comptype="+compType+"&mode=3D&site="+site+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&monitorSkin="+monitor_Skin+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&gtype=1&starthr="+startHour+"&test="+testname+"&info="+overviewinfo+"&layer=HOST&endtime="+endTime+"&endhr="+endHour+"&showRange=Range&gformat=graph&fromDashboard=true&timeline_compare="+defaultMGraphDuration+"&width=880&height=320&threshold=no&title=true&minmaxavgRequired=true&priority=TOP+-+10&isInfoReleventGraph="+infoRelevant+"&module="+tab+"&infoForTable="+infoForTable+"&fromKPI=true";
					if(graph_values.length()>1700)
						graph_values = graph_values.substring(0,1700);
					Vector spartLineAttributes=new Vector();
					spartLineAttributes.add("palette='2'");
					spartLineAttributes.add("setAdaptiveYMin='1'");
					spartLineAttributes.add("bgAlpha='0,0'");
					spartLineAttributes.add("lineColor='"+iniObj.getValue("Dashboard_Graph_colors","Sparkline")+"'");
					spartLineAttributes.add("showHighAnchor ='0'");
					spartLineAttributes.add("showLowAnchor ='0'");
					spartLineAttributes.add("showOpenValue ='0'");
					spartLineAttributes.add("showCloseValue ='0'");
					spartLineAttributes.add("showHighLowValue ='0'");
					spartLineAttributes.add("showOpenAnchor ='0'");
					spartLineAttributes.add("showCloseAnchor ='0'");
					spartLineAttributes.add("clickURL='javascript:sparklineOnclick(&apos;kpisparkurl"+i_indicatorCount+"&apos;)'");
					spartLineAttributes.add("exportEnabled='0'");
					spartLineAttributes.add("exportAction='download'");
					spartLineAttributes.add("exportAtClient='0'");
					spartLineAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");

					Vector sparkValues=egDashboard.getTokensAsVector(graph_values,",");
					String sparkXML=fusionChart.getXMLForSpark(sparkValues,spartLineAttributes);
%>
							<td align="right" >
<%
					if(graph_values!=null  && graph_values.length()>0 && (sparkValues!=null && sparkValues.size()>1))
					{
%>
								<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="100" height="20" id="StackedColumn3D" >
									<param name="movie" value="/final/FusionCharts/swf/SparkLine.swf" />
									<param name="FlashVars" value="&dataXML=<%=sparkXML%>&chartWidth=100&chartHeight=20">
									<param name="quality" value="high" />
									<param name="WMode" value="Transparent">
									<embed wmode="transparent" src="/final/FusionCharts/swf/SparkLine.swf" flashVars="&dataXML=<%=sparkXML%>" quality="high" width="100" height="20" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
								</object> -->
								<div id="chartSparkContainer<%=i_indicatorCount%>"  style="height:100%;"></div>
								<script type="text/javascript">
									if  ( FusionCharts( "mySparkChartId<%=i_indicatorCount%>" ) )
											FusionCharts( "mySparkChartId<%=i_indicatorCount%>" ).dispose();
									var myChart = new FusionCharts( "/final/FusionCharts/swf/SparkLine.swf","mySparkChartId<%=i_indicatorCount%>", "100", "20","0","1");
									myChart.setXMLData("<%=sparkXML%>");
									myChart.setTransparent(true);
									myChart.render("chartSparkContainer<%=i_indicatorCount%>");
								</script>
<%
					}
					else
					{
%>
							&nbsp;
<%
					}
%>
							</td>
							<td align="right" > <%=cur_Measure%> </td>
							<input type="hidden" id="kpisparkurl<%=i_indicatorCount%>"  value="<%=urlForMaximize%>"/>
						</tr>
<%
					i_indicatorCount++;
				}
			}
		}
		if(!isKPIAvailable)
		{
%>
						<tr>
							<td align="center" valign="middle" height="125px">
								<img class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_exclamation.png"><br> <egui:intnl text="monitor.dashboard.No Measures Available"/>!</td>
						</tr>
<%
		}
	}
	else
	{
%>
						<tr>
							<td align="center" valign="middle" height="125px">
								<img class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_exclamation.png"><br> <egui:intnl text="monitor.dashboard.No Measures Available"/>!</td>
						</tr>
<%
	}
%>
					</table>
				</div>
				</td>
			</tr>
		</table>
	</div>
<%
	}
	if(isApplicationTab && isWeblogicServer)
	{
		Vector runingTestList=egDashboard.getRunningTest(compName,compType,tab);
		Vector measureData = new Vector();
		Vector unitObj=new Vector();
		ArrayList measureMappingData = new ArrayList();
		ddtest="HttpTest";
		if(runingTestList!=null && runingTestList.contains(ddtest))
		{
		String testMeasures =iniObj.getValue(subject,tab+"_Overview_HttpTest"); 
		Vector allMeasures=egDashboard.getTokensAsVector(testMeasures,",");
		String measuresForDB="";
			for(int i=0;i<allMeasures.size();i++)
			{
				String tempStr=(String)allMeasures.get(i);
				if(tempStr!=null && tempStr.indexOf(":")!=-1)
				{
					String testName=tempStr.substring(0,tempStr.indexOf(":"));
					String tempMeasure=tempStr.substring(tempStr.indexOf(":")+1);
					measureMappingData.add(mappingInfo.getMeasureDescription(testName,tempMeasure));
						String unitVal= tablesInfo.getUnitForMeasure(testName,tempMeasure);
						unitObj.add(unitVal);
					measuresForDB+=dbInfo.getColumnForMeasure(testName,tempMeasure);
					if(allMeasures.size()>i+1)
						measuresForDB+=",";
				}
			}
			msmtHost = (String)allMsmtHosts.get(ddtest);
			measureData=dashboardDAO.getCurrentForAllInfos(hostName,portNo,ddtest,measuresForDB,msmtHost);
			//System.out.println("measureData"+measureData);
			measureData.remove("+");
			Vector temp_infos=dashboardDAO.getDescriptorsForTest(hostName+":"+portNo,compType,ddtest,tab);
			String info_for_cutofffactor="";
			if(temp_infos!=null && !temp_infos.isEmpty())
				info_for_cutofffactor=(String)temp_infos.get(0);
			boolean isTestHas_cutOffFactor=false;
			if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
			{
				if(egDashboard.isTestHasCutOffFactor(ddtest))
				{
					
					boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,ddtest,msmtHost,info_for_cutofffactor);
					if(isTestExceededCutOffFactor)
					{
						isTestHas_cutOffFactor=true;
					}
				}
			}
%>
			<div id="weblogicServerDetailsDiv" style="margin-left:5px;margin-top:5px;float:left;height:70px;border:0px solid #2B7F82">
					<table border="0" cellspacing="0" cellpadding="0" width="100%" height="100%" class="vmbo rder">
						<tr>
							<td class="eg_75bold gradient_header" height="20px" style="padding-left:4px;">
							<egui:intnl text='monitor.dashboard.Weblogic server Details'/>
							</td>
						</tr>
						<tr>
							<td valign="top" class="vmborder" style="padding:0px">
								<div class="div_scroll" style="border:0px solid #ff0000;" >
<%
			if(!isTestHas_cutOffFactor)
			{
%>
									<table border="0" cellpadding="2" cellspacing="0" width="100%" class="tableborder_jvm"><col width="40%">
										<tr>
											<td class="tdborder_jvm">
											<%=measureMappingData.get(0)%>
											</td>
<%
												if(measureData!=null && measureData.size()>0)
												{
												if(measureData.get(1).equals("100"))
												{
%>
											<td align="center" class="tdborder_jvm" style="padding-top:0px;padding-bottom:0px;border-right-width:3px"">
												<img class="png" src="/final/monitor/eg_images/icon_availability_up.png" title=" is Up" />
											</td>
<%
												}
												else
												{
%>
													<td align="center" class="tdborder_jvm" style="border-right-width:3px">
													<img class="png" src="/final/monitor/eg_images/icon_availability_down.png" title=" is Down" />
													</td>
<%
												}
												}
%>
											<td class="tdborder_jvm">
											<%=measureMappingData.get(1) %>(<%=unitObj.get(1)%>)
											</td>
											<td class="tdborder_jvm" style="border-right-width:3px">
<%
											if(measureData!=null && measureData.size()>0)
											{
											if(measureData.get(2).toString().contains("-"))
												{
%>
											<%="-"%>
<%
												}
												else
												{
%>
											<%=measureData.get(2)%>
<%
												}
											}
%>
											</td>
										</tr>
										<tr>
											<td>
											<%=measureMappingData.get(2) %>(<%=unitObj.get(2)%>)
											</td>
											<td class="tdborder_jvm" style="border-right-width:3px">
<%
											if(measureData!=null && measureData.size()>0)
											{
											if(measureData.get(3).toString().contains("-"))
											{
%>
											<%="-"%>
<%
											}
											else
											{
%>
											<%=measureData.get(3)%>
<%
											}
											}
%>
											</td>
											<td>
											<%=measureMappingData.get(3) %>(<%=unitObj.get(3)%>)
											</td>
											<td class="tdborder_jvm">
<%
											if(measureData!=null && measureData.size()>0)
											{
											if(measureData.get(4).toString().contains("-"))
											{
%>
														<%="-"%>
<%
											}
											else
											{
%>
											<%=measureData.get(4)%>
<%
											}
											}
%>
											</td>
										</tr>
									</table>
<%
			}
			else
			{
%>
					<table border="0" cellpadding="2" cellspacing="0" width="100%">	
					<tr>
						<td class="linebottom_light" align="center"><img class="png" src="/final/monitor/eg_images/gray/icon_exclamation.png"/><br> <egui:intnl text="monitor.dashboard.No Measures available"/></td>
					</tr>
					</table>
<%
			}
%>
								</td>
							</tr>
					</table>
			</div>
<%
		}
	}
	else if(isApplicationTab && isOracleServer)
	{
		Vector runingTestList=egDashboard.getRunningTest(compName,compType,tab);
		Vector measureData = new Vector();
		Vector unitObj=new Vector();
		ArrayList measureMappingData = new ArrayList();
		ddtest="OraSqlNetTest";
		if(runingTestList!=null && runingTestList.contains(ddtest))
		{
		String testMeasures =iniObj.getValue(subject,tab+"_Overview_OraSqlNetTest"); 
		Vector allMeasures=egDashboard.getTokensAsVector(testMeasures,",");
		String measuresForDB="";
			for(int i=0;i<allMeasures.size();i++)
			{
				String tempStr=(String)allMeasures.get(i);
				if(tempStr!=null && tempStr.indexOf(":")!=-1)
				{
					String testName=tempStr.substring(0,tempStr.indexOf(":"));
					String tempMeasure=tempStr.substring(tempStr.indexOf(":")+1);
					measureMappingData.add(mappingInfo.getMeasureDescription(testName,tempMeasure));
						String unitVal= tablesInfo.getUnitForMeasure(testName,tempMeasure);
						unitObj.add(unitVal);
						//System.out.println("unitVal"+unitVal);

					measuresForDB+=dbInfo.getColumnForMeasure(testName,tempMeasure);
					if(allMeasures.size()>i+1)
						measuresForDB+=",";
				}
			}
			msmtHost = (String)allMsmtHosts.get(ddtest);
			if(list!=null && list.containsKey(ddtest))
			{
			/*lastmsmtTimeIndex = list.indexOf(ddtest)+3;
			lastmsmtTime = list.get(lastmsmtTimeIndex).toString();
			tempDate =testDateFormat.parse(lastmsmtTime);
			lastmsmtTime=timeFormat.format(tempDate);*/
				measureData=dashboardDAO.getCurrentForAllInfos(hostName,portNo,ddtest,measuresForDB,msmtHost);
			}
			measureData.remove("+");
			if(isOracleServer && sid!=null && !sid.equals(""))
				measureData.remove(sid+"+");
			Vector temp_infos=dashboardDAO.getDescriptorsForTest(hostName+":"+portNo,compType,ddtest,tab);
			String info_for_cutofffactor="";
			if(temp_infos!=null && !temp_infos.isEmpty())
				info_for_cutofffactor=(String)temp_infos.get(0);
			boolean isTestHas_cutOffFactor=false;
			if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
				{
					if(egDashboard.isTestHasCutOffFactor(ddtest))
					{
						
						boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,ddtest,msmtHost,info_for_cutofffactor);
						if(isTestExceededCutOffFactor)
						{
							isTestHas_cutOffFactor=true;
						}
					}
				}
%>
	<div  style="margin-left:5px;margin-top:5px;float:left;width:;height:70px;border:0px solid #2B7F82">
		<table border="0" cellspacing="0" cellpadding="0" height="100%" class="vmbo rder">
			<tr>
				<td class="eg_75bold gradient_header" height="20px" style="padding-left:4px;">
				<egui:intnl text='monitor.dashboard.Oracle Availability'/>
				</td>
			</tr>
			<tr>
				<td valign="top" class="vmborder" style="padding:0px">
					<div id="oracleAvailabilityDiv" class="div_scroll" style="border:0px solid #ff0000;" >
<%
			if(!isTestHas_cutOffFactor)
			{
%>						<table border="0" cellpadding="2" cellspacing="0" width="100%" class="tableborder_jvm"><col width="40%">
							<tr>
								<td class="tdborder_jvm"> <%=measureMappingData.get(0)%> </td>
<%
				if(measureData!=null && measureData.size()>0)
				{
					if(measureData.get(0).equals("100"))
					{
%>
								<td class="tdborder_jvm" style="padding-top:0px;padding-bottom:0px;border-right-width:3px"> <img class="png" src="/final/monitor/eg_images/db_up.png" title=" is Up"/> </td>
<%
					}
					else
					{
%>
								<td class="tdborder_jvm" style="border-right-width:3px"> <img class="png" src="/final/monitor/eg_images/db_down.png" title=" is Down" /> </td>
<%
					}
				}
%>
								<td class="tdborder_jvm"><%=measureMappingData.get(1) %>(<%=unitObj.get(1)%>) </td>
								<td class="tdborder_jvm">
<%
				if(measureData!=null && measureData.size()>0)
				{
					if(measureData.get(1).toString().contains("-"))
					{
%>
					<%="-"%>
<%
					}
					else
					{
%>
					<%=measureData.get(1)%>
<%
					}
				}
%>
								</td>
							</tr>
							<tr>
								<td><%=measureMappingData.get(2) %>(<%=unitObj.get(2)%>) </td>
								<td class="tdborder_jvm" style="border-right-width:3px">
<%
				if(measureData!=null && measureData.size()>0)
				{
					if(measureData.get(2).toString().contains("-"))
					{
%>
					<%="-"%>
<%
					}
					else
					{
%>
					<%=measureData.get(2)%>
<%
					}
				}
%>
								</td>
								<td><%=measureMappingData.get(3) %>(<%=unitObj.get(3)%>) </td>
								<td class="tdborder_jvm">
<%
				if(measureData!=null && measureData.size()>0)
				{
					if(measureData.get(3).toString().contains("-"))
					{
%>
					<%="-"%>
<%
					}
					else
					{
%>
					<%=measureData.get(3)%>
<%
					}
				}
%>
								</td>
							</tr>
						</table>
<%
			}	
			else
			{
%>
					<table border="0" cellpadding="2" cellspacing="0" width="100%">	
					<tr>
						<td class="linebottom_light" align="center"><img class="png" src="/final/monitor/eg_images/gray/icon_exclamation.png"/><br> <egui:intnl text="monitor.dashboard.No Measures available"/></td>
					</tr>
					</table>
<%
			}
%>
					</div>
				</td>
			</tr>
		</table>
	</div>
<%
		}
	}
	String s_comparisiontable=iniObj.getValue(subject,tab+"_Overview_comparisiontable");
	boolean isNetworkNode=(compType!=null && compType.equalsIgnoreCase("Network_node"));

	if(s_comparisiontable!=null && !s_comparisiontable.trim().equals(""))
	{
		int tablescount=0;
		int imgcnt=0;
		int stColPos=1;
		int endColPos=0;
		String DefaultFullViewComparisonTable=iniObj.getValue("Default_ComparisonTable_FullTableView","FullViewComparisonTables");
		Vector fullViewComparisonTablesVector=egDashboard.getTokensAsVector(DefaultFullViewComparisonTable,",");
		Vector comparisionVector=egDashboard.getTokensAsVector(s_comparisiontable,"#");

		Iterator comparionTableItr=comparisionVector.iterator();
		while(comparionTableItr.hasNext())
		{
			String s_alltestmeasure=(String)comparionTableItr.next();
			String colspan="1";
			String tableWidth="50%";

			info="+";

			Vector allMeasures=egDashboard.getTokensAsVector(s_alltestmeasure,",");
			Iterator allMeasuresItr=allMeasures.iterator();

			String tempTestName="";
			if(allMeasures.size()>0)
			{
				tempTestName=(String)allMeasures.get(0);
				if(tempTestName!=null && tempTestName.indexOf(":")!=-1)
					tempTestName=tempTestName.substring(0,tempTestName.indexOf(":"));
			}
			String tableTitle=iniObj.getValue("Dashboard_Comparison_TableTitle",tempTestName);
			String show_esx_ds_summary = iniObj.getValue("Dashboard_Settings","SHOW_ESX_DS_SUMMARY");
			boolean isDBSummaryNeeded =  true;
			if ( show_esx_ds_summary != null && show_esx_ds_summary.equalsIgnoreCase("No") )
			{
				isDBSummaryNeeded = ( tempTestName != null && !tempTestName.equalsIgnoreCase("EsxDiskUsageTest") && !tempTestName.equalsIgnoreCase("XenHostDiskSpaceTest") ) ? true:false;
			}
			if(tableTitle!=null && tableTitle.equals(""))
			{
				tableTitle=mappingInfo.getTestDescription(tempTestName);
			}

			Vector allInfos=(Vector)allTestInfos.get(tempTestName);

			boolean hasInfos=(allInfos!=null && allInfos.size()>0 && !(allInfos.size()==1 && allInfos.contains("+")));
			int colCountForFullTable=5;
			if(tempTestName!=null && tempTestName.equalsIgnoreCase("MsSqlConnsTest"))
			{
				colCountForFullTable=6;
			}
			else if(tempTestName!=null && tempTestName.equalsIgnoreCase("MsSqlSpaceTest"))
			{
				colCountForFullTable=3;
			}

			if(allMeasures!=null && allMeasures.size()>=colCountForFullTable && hasInfos)
			{
				tableWidth="100%";
				colspan="2";
			}
			String comparisonTableFullViewURL=response.encodeURL("/final/monitor/egCustomDashboardp.jsp")+"?"+"compName="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&subject="+EgURLEncoder.encode(subject,"UTF-8")+"&site="+site+"&tab="+tab+"&defaultMGraphDuration="+defaultMGraphDuration+"&defaultSparklineDuration="+defaultSparklineDuration+"&divCount="+divCount+"&state="+state+"&blockType=comparisontable&tableIdx="+tablescount;
			if(hasInfos && enabledTests.contains(tempTestName))
			{
				if(s_alltestmeasure!=null && (s_alltestmeasure.trim().equals("SystemTest:Cpu_util") || s_alltestmeasure.trim().equals("HvProcessorTest:Cpu_utilization") || s_alltestmeasure.trim().equals("EsxCpuTest:Usage")))
				{
					test=s_alltestmeasure.substring(0,s_alltestmeasure.indexOf(":"));
					String tempMeasure = s_alltestmeasure.substring(s_alltestmeasure.indexOf(":")+1);
					msmtHost=(String)allMsmtHosts.get(test);
					if(msmtHost==null)
						msmtHost="";
					String  excludedInfosForSpark = egDashboard.convertTokensAsString(dashboardDAO.getExcludedInfo(test,tempMeasure,compType,true,false),",");
					dashboardDAO.setOmittedInfo(excludedInfosForSpark);
					Vector topInfoWithMeasure=dashboardDAO.getCurrentForTop(hostName,portNo,test,dbInfo.getColumnForMeasure(test,tempMeasure),msmtHost,true,10,true);
					String  excludedInfos=iniObj.getValue("INFOS_TO_BE_OMITTED",s_alltestmeasure);
					StringTokenizer infos=new StringTokenizer(excludedInfos,",");
					Vector excluded_infos=new Vector();
					while(infos.hasMoreTokens())
					{
							excluded_infos.add("+"+infos.nextToken());
					}
					String checkVal="";
					Vector filtered_infos=new Vector();
					if(topInfoWithMeasure!=null && topInfoWithMeasure.size()>0)
					{
						for(int i=0;i<topInfoWithMeasure.size();i+=2)
						{
							 String ex_info=(String)topInfoWithMeasure.get(i);
							 String value=(String)topInfoWithMeasure.get(i+1);
							 if(!excluded_infos.contains(ex_info))
							{
									filtered_infos.add(ex_info);
									filtered_infos.add(value);

							}
						}
					}
					for(int i=0;i<filtered_infos.size();i+=2)
					{
						 checkVal=(String)filtered_infos.get(i+1);
					}
					if(checkVal!=null && !checkVal.equals("-") && !checkVal.equals("-5") && !checkVal.trim().equals(""))
					{
					String rsTableName="rsTable"+(tablescount+1);
					endColPos+=2;
					if(!disabledBlocks.contains(test))
					{
%>
	<div style="margin-left:5px;margin-top:5px;float:left;height:152px;border:0px solid #2B7F82" id="div<%=++divCount%>" >
		<table border="0" cellpadding="0"  cellspacing="0" height="100%" valign="top">
			<tr>
				<td valign="top" class="gradient_header">
					<table border="0" cellpadding="2"  cellspacing="0" width="100%"><col width="95%"><col width="15px"><col width="15px">
						<tr>
							<td class="eg_75bold" height="20px" style="padding-left:4px;border-right-width:0px" width="100%"><%=tableTitle%></td>
<%
							if(adminPermission==true)
							{
%>
							<td class="eg_75bold" valign="middle" style="padding-right:4px;border-right-width:0px;border-left-width:0px" align="right" onclick="javascript:showMaximizedView('<%=comparisonTableFullViewURL%>','event','ComparisonTable');"> <img id="img<%=divCount%>" class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_maximize_div.png"/> </td>
							<td class="eg_75bold" valign="middle" align="right" style="padding-right:4px;border-left-width:0px"> <img class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_close_div.png" onclick="javascript:closeDiv(<%=divCount%>,'<%=tab+"_Overview"%>','<%=test%>');" onload="javascript:divonload('<%=divCount%>','<%=tab+"_Overview_"+test%>');"/> </td>
<%
							}
							else
							{
%>
							<td class="eg_75bold" valign="middle" style="padding-right:4px;border-right-width:0px;border-left-width:0px" align="right" >&nbsp;</td>
							<td class="eg_75bold" valign="middle" style="padding-right:4px;border-left-width:0px" align="right" onclick="javascript:showMaximizedView('<%=comparisonTableFullViewURL%>','event','ComparisonTable');"> <img id="img<%=divCount%>" class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_maximize_div.png"/> </td>
<%
							}
%>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td valign="top" class="vmborder" style="padding:0px">
				<div id="overViewCompTableInnerDiv<%=divCount%>" class="div_scroll" style="height:130px;border:0px solid #ff0000;" >
					<table border="0" cellpadding="2" cellspacing="0" width="100%" class="tableborder_jvm" valign="top" height="100%"><col width="30%"><col width="70%">

<%
					String col_mapping=iniObj.getValue("Dashboard_TableColumn_mapping","SystemTest:Cpu_util");
					if(col_mapping==null || col_mapping.trim().equals(""))
						col_mapping=mappingInfo.getMeasureDescription("SystemTest","Cpu_util");
					String info_mapping=iniObj.getValue("Dashboard_Info_Mapping","SystemTest");
					boolean isTestHas_CutOffFactor=false;
						if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
						{
							if(egDashboard.isTestHasCutOffFactor(test))
							{
								if(filtered_infos!=null && !filtered_infos.isEmpty())
								{
									for(int d=0;d<filtered_infos.size();d++)
									{
										boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,test,msmtHost,(String)filtered_infos.get(d));
										if(isTestExceededCutOffFactor)
										{
											isTestHas_CutOffFactor=true;
										}
									}
								}			
							}
						}
						if(!isTestHas_CutOffFactor)
						{


							for(int i=0;i<filtered_infos.size();i+=2)
							{
								String infoForDisp=(String)filtered_infos.get(i);
								String val=(String)filtered_infos.get(i+1);
	%>
							<tr>
								<td valign="middle" align="right"> <%=com.egurkha.util.StringUtils.replace(infoForDisp,"+","")%></td>
	<%
									Vector chartAttributes=new Vector();
									chartAttributes.add("bgColor='FFFFFF'");
									chartAttributes.add("bgAlpha='0'");
									chartAttributes.add("showBorder='0'");
									chartAttributes.add("upperLimit='100'");
									chartAttributes.add("lowerLimit='0'");
									chartAttributes.add("ticksBelowGauge='1'");
									chartAttributes.add("placeValuesInside='0'");
									chartAttributes.add("showGaugeLabels='0'");
									chartAttributes.add("valueAbovePointer='0'");
									chartAttributes.add("pointerOnTop='1'");
									chartAttributes.add("pointerRadius='6'");
									chartAttributes.add("chartTopMargin='5'");
									chartAttributes.add("chartBottomMargin='5'");
									chartAttributes.add("chartLeftMargin='25'");
									chartAttributes.add("chartRightMargin='25'");
									chartAttributes.add("majorTMColor='D73027'");
									chartAttributes.add("plotFillPercent='60'");
									chartAttributes.add("plotFillColor='000000'");
									chartAttributes.add("baseFontSize='8'");
									chartAttributes.add("baseFontColor='000000'");
									chartAttributes.add("pointerBgColor='000000'");
									chartAttributes.add("placeTicksInside='0'");
									chartAttributes.add("gaugeFillMix='{light-60},{light-40},{light-20},{dark-5},{D95F02},{light-30},{light-50},{dark-10}'");
									chartAttributes.add("gaugeFillRatio='20,30,20'");
									chartAttributes.add("gaugeRoundRadius='3'");
									chartAttributes.add("exportEnabled='0'");
									chartAttributes.add("exportAction='download'");
									chartAttributes.add("exportAtClient='0'");
									chartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");

									String linearGaugeXML=fusionChart.getXmlForLinearGauge(val,chartAttributes);
	%>
								<td align="left">
									<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="280" height="60" id="StackedColumn3D" >
										<param name="movie" value="/final/FusionCharts/swf/HLinearGauge.swf" />
										<param name="FlashVars" value="&dataXML=<%=linearGaugeXML%>&chartWidth=280&chartHeight=60">
										<param name="quality" value="high" />
										<param name="WMode" value="Transparent">
										<embed wmode="transparent" src="/final/FusionCharts/swf/HLinearGauge.swf" flashVars="&dataXML=<%=linearGaugeXML%>" quality="high" width="280" height="60" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
									</object> -->
									<div id="chartHLinearContainer<%=i%>"  style="height:100%;"></div>
									<script type="text/javascript">
										if  ( FusionCharts( "myHLinearChartId<%=i%>" ) )
												FusionCharts( "myHLinearChartId<%=i%>" ).dispose();
										var myChart = new FusionCharts( "/final/FusionCharts/swf/HLinearGauge.swf","myHLinearChartId<%=i%>", "280", "60","0","1");
										myChart.setXMLData("<%=linearGaugeXML%>");
										myChart.setTransparent(true);
										myChart.render("chartHLinearContainer<%=i%>");
									</script>
								</td>

							</tr>
	<%
							}
						}
						else
						{
%>
									<tr>
										<td align="center" valign="middle"  width="100%" height="100%" colspan="2">
											<img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"> <br> <egui:intnl text="monitor.dashboard.No Measures Available"/>!
										</td>
									</tr>
<%
						}
%>
					</table>
					<img src="/final/monitor/eg_images/spacer.gif" height="0px" width="0px" border="0px" onload="this.blur();return sortTable('<%=rsTableName%>',0,<%=stColPos%>,<%=endColPos%>,<%=imgcnt+1%>);" style="visibility:hidden;display:none;">
				</td>
			</tr>
		</table>
	</div>
<%
						imgcnt+=2;
							stColPos=imgcnt+1;
					}
					}
					else
					{
%>
					<div style="margin-left:5px;margin-top:5px;float:left;height:152px;border:0px solid #2B7F82" id="div<%=++divCount%>" >
						<table border="0" cellspacing="0" cellpadding="0" width="100%" height="100%" class="vmborder"><col width="95%"><col width="15px"><col width="15px">
							<tr>
								<td class="eg_75bold gradient_header" height="20px" style="padding-left:4px" width="100%"><%=tableTitle%></td>
<%
								if(adminPermission==true)
								{
%>
								<td class="eg_75bold gradient_header" valign="middle" style="padding-right:4px" align="right" onclick="javascript:showMaximizedView('<%=comparisonTableFullViewURL%>','event','ComparisonTable');"> <img id="img<%=divCount%>" class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_maximize_div.png"/> </td>
								<td class="eg_75bold jvm_header" valign="middle" align="right" style="padding-right:4px"> <img class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_close_div.png" onclick="javascript:closeDiv(<%=divCount%>,'<%=tab+"_Overview"%>','<%=test%>');" onload="javascript:divonload('<%=divCount%>','<%=tab+"_Overview_"+test%>');"/> </td>
<%
								}
								else
								{
%>
								<td class="eg_75bold gradient_header" style="padding-right:4px;border-left-width:0px;border-right-width:0px" valign="middle" align="right" >&nbsp;</td>
								<td class="eg_75bold gradient_header" valign="middle" style="padding-right:4px" align="right" onclick="javascript:showMaximizedView('<%=comparisonTableFullViewURL%>','event','ComparisonTable');"> <img id="img<%=divCount%>" class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_maximize_div.png"/> </td>
<%
								}
%>
							</tr>
							<tr>
								<td>
									<table border="0" cellpadding="0" cellspacing="0" width="100%" height="130">
										<tr>
											<td align="center" height="100%" valign="middle"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"> <br > <egui:intnl text="monitor.dashboard.No measures available"/>!</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</div>
<%
					}
				}
				else
				{
					Vector measures=new Vector();
					String measuresForDB="";
					String testName="";

					for(int i=0;i<allMeasures.size();i++)
					{
						String tempStr=(String)allMeasures.get(i);
						if(tempStr!=null && tempStr.indexOf(":")!=-1)
						{
							testName=tempStr.substring(0,tempStr.indexOf(":"));
							String tempMeasure=tempStr.substring(tempStr.indexOf(":")+1);
							measures.add(tempMeasure);
							measuresForDB+=dbInfo.getColumnForMeasure(testName,tempMeasure);
							if(allMeasures.size()>i+1)
								measuresForDB+=",";
						}
					}

					msmtHost=(String)allMsmtHosts.get(testName);
					if(msmtHost==null)
						msmtHost="";
					String s_infomapping=iniObj.getValue("Dashboard_Info_Mapping",testName);
					if(testName.equals("WLEJBPoolsTest") || testName.equals("WLEJBTransTest") || testName.equals("WLServletTest"))
					{
						String groupingRequired=agentInfo.getParamValue(testName,msmtHost,portNo,info, msmtHost,"autoDiscovery");
						//System.out.println("groupingRequired---->"+groupingRequired);
						if(groupingRequired!=null && groupingRequired.equals("true"))
						{
							if(testName.equals("WLServletTest"))
								s_infomapping="Servlet name";
							else
								s_infomapping="Bean name";
						}
						else
						{
							s_infomapping="Group name";
						}
						//System.out.println("tableTitle---->"+tableTitle);
					}
					if(s_infomapping==null || s_infomapping.trim().length()==0)
					{
						s_infomapping="Info";
					}
					String rsTableName="rsTable"+(tablescount+1);
					int totalMeasureCols=measures.size();
					boolean isNetworkInterfaceTest=(isNetworkNode && (testName!=null && testName.equalsIgnoreCase("NetworkInterfaceTest")));
					boolean isEsxNetworkInterfaceTest=(testName!=null && testName.equalsIgnoreCase("EsxNetworkTest"));
					
					boolean isEsxDiskUsageTest=(testName!=null && testName.equalsIgnoreCase("EsxDiskUsageTest"));
				
					Vector allValuesForInfo=new Vector();
					if(isNetworkInterfaceTest)
					{
						allValuesForInfo=dashboardDAO.getCurrentForAllInfos(hostName,portNo,testName,measuresForDB,msmtHost,dbInfo.getColumnForMeasure(testName,"Pct_bandwidth_used"),true,"10");
						endColPos+=(totalMeasureCols);
					}
					else
					{
						allValuesForInfo=dashboardDAO.getCurrentForAllInfos(hostName,portNo,testName,measuresForDB,msmtHost);
						endColPos+=(totalMeasureCols+1);
					}
					boolean isValuesAvailableForInfo=(allValuesForInfo!=null && !allValuesForInfo.isEmpty());
					if(!disabledBlocks.contains(testName) && isValuesAvailableForInfo && isDBSummaryNeeded )
					{
						boolean isFullTable=false;
						if(allMeasures.size()>5 || (fullViewComparisonTablesVector.contains(tempTestName)))
							isFullTable=true;
%>
	<div style="margin-left:5px;margin-top:5px;float:left;width:<%=isFullTable?"":""%>;height:152px;border:0px solid #2B7F82" id="div<%=++divCount%>" >
		
		<table border="0" cellpadding="0"  cellspacing="0" height="100%" valign="top">
			<tr>
				<td valign="top" class="gradient_header">
					<table border="0" cellpadding="2"  cellspacing="0" width="100%"><col width="95%"><col width="15px"><col width="15px">
						<tr>
							<td class="eg_75bold" height="20px" style="padding-left:4px;border-right-width:0px" width="100%"><%=tableTitle%></td>
<%
	if(adminPermission==true)
	{
%>
							<td class="eg_75bold" style="padding-right:4px;border-right-width:0px;border-left-width:0px" valign="middle" align="right" onclick="javascript:showMaximizedView('<%=comparisonTableFullViewURL%>','event','ComparisonTable');"> <img id="img<%=divCount%>" class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_maximize_div.png"/> </td>
							<td class="eg_75bold" valign="middle" align="right" style="padding-right:4px;border-left-width:0px"> <img class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_close_div.png" onclick="javascript:closeDiv(<%=divCount%>,'<%=tab+"_Overview"%>','<%=testName%>');" onload="javascript:divonload('<%=divCount%>','<%=tab+"_Overview_"+testName%>');"/> </td>
<%
	}
	else
	{
%>
							<td class="eg_75bold" style="padding-right:4px;border-right-width:0px;border-left-width:0px" valign="middle" align="right" >&nbsp;</td>
							<td class="eg_75bold" style="padding-right:4px;border-left-width:0px" valign="middle" align="right" onclick="javascript:showMaximizedView('<%=comparisonTableFullViewURL%>','event','ComparisonTable');"> <img id="img<%=divCount%>" class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_maximize_div.png"/> </td>
<%
	}
	String innerComptableDivID="overViewCompTableInnerDiv"+divCount;
	if(isFullTable)
		innerComptableDivID="overViewCompTableFullInnerDiv"+divCount;
%>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td class="vmborder" style="padding:0px">
				<div id="<%=innerComptableDivID%>" class="div_scroll" style="height:130px;border:0px solid #ff0000;">
<%
				Vector  excludedInfosForTest = dashboardDAO.getExcludedInfo(testName,"",compType,false,false);
				boolean isTestHas_CutOffFactor=true;
				if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
				{
					if(egDashboard.isTestHasCutOffFactor(testName))
					{
						if(allValuesForInfo!=null && !allValuesForInfo.isEmpty())
						{
							for(int d=0;d<allValuesForInfo.size();d+=measures.size()+1)
							{
								boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,testName,msmtHost,(String)allValuesForInfo.get(d));
								String omitedInfo = (String)allValuesForInfo.get(d);
								if ( excludedInfosForTest.contains(omitedInfo))
									continue;
								if(!isTestExceededCutOffFactor)
									isTestHas_CutOffFactor=false;
							}
						}			
					}
				}
				if(!isTestHas_CutOffFactor)
				{
%>
					<table cellspacing="0" cellpadding="2" class="tableborder_jvm"  border="0" width="100%">
<%
					//if(isNetworkInterfaceTest)
					//{
%>
						
<%
					//}
%>
						<thead>
						<tr>
							<td class="eg_75bold tdborder2_jvm" style="padding-top:0px;padding-bottom:0px">
								<table cellspacing="0" cellpadding="0"   border="0" width="100%">
									<tr>
										<td ><a class="eg_monlink" href="" onclick="this.blur();return sortTable('<%=rsTableName%>','0',<%=stColPos%>,<%=endColPos%>,'<%=(imgcnt+1)%>');"><span class="eg_75bold">
										<%
											if(isOracleServer && isApplicationTab)
											{
											%>
											<%=iniObj.getValue("Dashboard_TableColumn_mapping",testName)%>
											<%
											}
											else
											{
										%>
										<egui:intnl text ='<%="monitor.dashboard."+s_infomapping%>'/>
										<%
											}
										%>
										</a></span></td>
										<td style="width:15px" ><img id="imgdd<%=(imgcnt+1)%>" src="/final/monitor/eg_images/arrow_down_black_small.gif" onclick="this.blur();return sortTable('<%=rsTableName%>',0,<%=stColPos%>,<%=endColPos%>,'<%=(imgcnt+1)%>');" style="display:none"/></td>
									</tr>
								</table>
							</td>
<%
					imgcnt=imgcnt+1;
					String  excludedInfos=iniObj.getValue("INFOS_TO_BE_OMITTED",testName);
					Vector excluded_infos=new Vector();
					if(!StringUtils.isNull(excludedInfos))
					{
						StringTokenizer infos=new StringTokenizer(excludedInfos,",");
						while(infos.hasMoreTokens())
						{
							excluded_infos.add("+"+infos.nextToken());
						}
					}
					for(int i=0;i<totalMeasureCols&&measures.size()>i;i++)
					{
						measure=(String)measures.get(i);

						String tableHeader=iniObj.getValue("Dashboard_TableColumn_mapping",testName+":"+measure);
						if(tableHeader!=null && tableHeader.equals(""))
						{
							tableHeader=mappingInfo.getMeasureDescription(testName,measure);
						}

						excludedInfos=iniObj.getValue("INFOS_TO_BE_OMITTED",testName+":"+measure);

						if(!StringUtils.isNull(excludedInfos))
						{
							StringTokenizer infos=new StringTokenizer(excludedInfos,",");
							while(infos.hasMoreTokens())
							{
								String exclude_info="+"+infos.nextToken();
								if(excluded_infos!=null && !excluded_infos.contains(exclude_info))
									excluded_infos.add(exclude_info);
							}
						}
						String units = tablesInfo.getUnitForMeasure(testName,measure);

						if(units!=null && units.equalsIgnoreCase("MB"))
							units="GB";

						if(!(isNetworkInterfaceTest && (tableHeader!=null && tableHeader.equalsIgnoreCase("Status"))))
						{
%>
							<td class="eg_75bold tdborder2_jvm" >
								<table cellspacing="0" cellpadding="0"   border="0" width="100%">
									<tr>
										<td ><a class="eg_monlink" href="" onclick="this.blur();return sortTable('<%=rsTableName%>',<%=(i+1)%>,<%=stColPos%>,<%=endColPos%>,<%=(imgcnt+1)%>);">
<%
							if(isEsxDiskUsageTest && tableHeader.equalsIgnoreCase("Availability"))
							{
%>
											<span class="eg_75bold"><%=tableHeader%><br></span></a></td>
<%
							}
							else
							{
%>
											<span class="eg_75bold"><%=tableHeader%><br>(<%=units%>)</span></a></td>
<%
							}
%>
										
										<td style="width:15px" ><img id="imgdd<%=(imgcnt+1)%>" src="/final/monitor/eg_images/arrow_up_black_small.gif" onclick="this.blur();return sortTable('<%=rsTableName%>',<%=(i+1)%>,<%=stColPos%>,<%=endColPos%>,<%=(imgcnt+1)%>);" style="display:none"/></td>
									</tr>
								</table>
							</td>
<%						imgcnt++;
						}
						else
						{
%>
							<td class="eg_75bold tdborder2_jvm">
								<%=tableHeader%>
							</td>
<%
						}
					}
%>
						</tr>
						</thead>
						<tbody name="<%=rsTableName%>" id="<%=rsTableName%>">
<%
					for(int i=0;i<allValuesForInfo.size();i+=measures.size()+1)
					{
						info=(String)allValuesForInfo.get(i);
						info=com.egurkha.util.StringUtils.replace(info,sid+"+","");
						if(excluded_infos!=null && excluded_infos.contains("+"+info))
							continue;
						info=com.egurkha.util.StringUtils.replace(info,"+","");
						if(isNetworkNode && info!=null && info.equalsIgnoreCase("Total"))
						{
							continue;
						}
%>
						<tr>
<%
						if (info.length() < 60)
						{
%>
							<td valign="top"  align="left" class="tdborder_jvm" style="border-left-width:1px;border-right-width:0px;" wrap>
								<table border="0" cellspacing="0" cellpadding="0">
									<tr>
<%
							if(isEsxDiskUsageTest)
							{
%>
										<td align="left" style="padding-right:4px"><img size="7" src="/final/monitor/eg_images/storage.png"  /></td>
<%
							}
%>
										<td align="left">
											<%=info.trim()%>
										</td>
									</tr>
								</table>
							</td>
<%
						}
						else
						{
								info=info.trim();
%>
							<td valign="top"  align="left" class="tdborder_jvm" style="border-left-width:1px;border-right-width:0px;">
								<table border="0" cellspacing="0" cellpadding="0">
									<tr>
<%							if(isEsxDiskUsageTest)
							{
%>
										<td align="left" style="padding-right:4px"><img size="7" src="/final/monitor/eg_images/storage.png"  /></td>
<%
							}
%>
										<td>
											<table border="0" cellspacing="0" cellpadding="0" width="100%">
<%
							int idx = info.length()/60;
							int index = 0;
							for (int j=0; j<idx; j++)
							{
%>
												<tr>
													<td nowrap>
														<%=info.substring(index,index+60)%>
													</td>
												</tr>
<%
								index = index+60;
							}
%>
												<tr>
													<td nowrap>
														<%=info.substring(index)%>
													</td>
												</tr>
											</table>
										</td>
									</tr>
								</table>
							</td>
<%
						}
						for(int j=1;j<=measures.size();j++)
						{
							measure=(String)measures.get(j-1);
							String value=(String)allValuesForInfo.get(j+i);
							String units = tablesInfo.getUnitForMeasure(testName,measure);

							if(!testerInfo.getAllowNegativeValues(testName,measure) && (value!=null) && (value.startsWith("-") || value.trim().equals("")))
							{
								value = "-";
							}

							if((value!=null && !value.equals("-")) && (units!=null && units.equalsIgnoreCase("MB")))
							{
								double floatVal=(Double.parseDouble(value))/1024;
								floatVal=MathUtils.round(floatVal,2);
								value=floatVal+"";
							}
							else if((value!=null && !value.equals("-")) && (units!=null && units.equalsIgnoreCase("boolean")))
							{
								if(value.equals("0"))
									value="No";
								else if(value.equals("1"))
									value="Yes";
							}

							if(isNetworkInterfaceTest && (measure!=null && measure.equalsIgnoreCase("Availability")))
							{
								if(value!=null && value.equals("100"))
								{
%>
							<td class="tdborder_jvm" align="center" valign="middle"><img class="png" src="/final/monitor/eg_images/icon_network_interface_up
.png" title="<%=info%> is Up" /></td> 
<%
								}
								else
								{
%>
							<td class="tdborder_jvm" valign="middle" align="center"><img src="/final/monitor/eg_images/icon_network_interface_down.png" title="<%=info%> is Down"/></td>
<%								}
							}
							else
							{
								if(isEsxDiskUsageTest && (measure!=null && measure.equalsIgnoreCase("Availability")))
								{
									String img="";
%>
							<td class="tdborder_jvm" valign="top" width="105" align="center" >
<%
									if ( value != null && !value.trim().equals("-") )
									{
										if(value.equals("100"))
										{
											img="icon_availability_up.png";
										}
										else
										{
											img="icon_availability_down.png";
										}
%>
										<img size="7" src="/final/monitor/eg_images/<%=img%>"/>
<%
									}
									else
									{
										out.println("-");
									}
%>
							</td>
<%
								}
								else
								{
									if ( isEsxNetworkInterfaceTest && measure.equalsIgnoreCase("availability") )
									{
										String img = "";
%>
							<td class="tdborder_jvm" valign="top">
<%
										if ( value != null && !value.trim().equals("-") )
										{
											if ( value.trim().equals("100") )
											{
												img = "up-arrow.png";
											}
											else if ( value.trim().equals("0") )
											{
												img = "down-arrow.png";
											}
%>
											<img size="7" src="/final/monitor/eg_images/<%=img%>"/>
<%
										}
										else
										{
											out.println("-");
										}
%>
							</td>
<%
									}
									else
									{
%>
							<td class="tdborder_jvm" valign="top"><%=value%></td>
<%
									}
								}
							}

						}
%>
						</tr>
<%					
					}
%>
						</tbody>
					</table>
<%
					}
					else
					{
%>
					<table cellspacing="0" cellpadding="2" border="0" width="100%"  height="100%">
						<tr>
							<td align="center" valign="middle"  width="100%" height="100%">
								<img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"> <br> <egui:intnl text="monitor.dashboard.No Measures Available"/>!
							</td>
						</tr>
					</table>
<%
					}
					int defaultColumnSortIndex=0;
					int defaultColumnSortImageIndex=stColPos;
					if(isNetworkInterfaceTest)
					{
						defaultColumnSortIndex=4;
						defaultColumnSortImageIndex=4;
					}
					else if(testName!=null && (testName.equals("XenCpuTest") || testName.equals("XenHostDiskSpaceTest")))
					{
						defaultColumnSortIndex=1;
						defaultColumnSortImageIndex=defaultColumnSortImageIndex+1;
					}
%>
					<img src="/final/monitor/eg_images/spacer.gif" height="0px" width="0px" border="0px" onload="this.blur();return sortTable('<%=rsTableName%>',<%=defaultColumnSortIndex%>,<%=stColPos%>,<%=endColPos%>,<%=defaultColumnSortImageIndex%>);" style="visibility:hidden;display:none;">
				</div>
				</td>
			</tr>
		</table>
	</div>
<%
						stColPos=imgcnt+1;
					}
					else if(isValuesAvailableForInfo && isDBSummaryNeeded )
					{
%>
	<div style="margin-left:5px;margin-top:5px;float:left;width:<%=(allMeasures.size()>5 || fullViewComparisonTablesVector.contains(tempTestName))?" ":" "%>;height:152px;border:0px solid #2B7F82" id="div<%=++divCount%>" >
		<table border="0" cellspacing="0" cellpadding="2" width="100%">
			<tr>
				<td width="100%">
					<div id="overViewCompTableInnerDiv<%=divCount%>" class="div_scroll" style="height:130px;border:0px solid #ff0000;" >
					<table border="0" cellpadding="0" cellspacing="0" width="100%" height="120">
						<tr>
							<td align="center" height="100%" valign="middle"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"> <br > <egui:intnl text="monitor.dashboard.No measures available"/>!</td>
						</tr>
					</table>
					</div>
				</td>
			</tr>
		</table>
	</div>

<%					}
				}
				
			}
			else if(enabledTests.contains(tempTestName))
			{
				if(s_alltestmeasure!=null && s_alltestmeasure.trim().equals("SystemTest:Cpu_util"))
				{
					Vector measures=new Vector();
					Vector testMapping = new Vector();
					String measuresForDB="";
					String testName="";
					String tempMeasures[] ={"SystemTest:Cpu_util","SystemTest:System_cpu_util"};
					for(int i=0;i<tempMeasures.length;i++)
					{
						String tempStr=tempMeasures[i];
						if(tempStr!=null && tempStr.indexOf(":")!=-1)
						{
							testName=tempStr.substring(0,tempStr.indexOf(":"));
							String tempMeasure=tempStr.substring(tempStr.indexOf(":")+1);
							measures.add(tempMeasure);
							testMapping.add(mappingInfo.getMeasureDescription(testName,tempMeasure));
							measuresForDB+=dbInfo.getColumnForMeasure(testName,tempMeasure);
							if(tempMeasures.length >i+1)
								measuresForDB+=",";
						}
					}

					msmtHost=(String)allMsmtHosts.get(testName);
					if(msmtHost==null)
						msmtHost="";

					Vector allValuesForInfo=dashboardDAO.getCurrentForAllInfos(hostName,portNo,testName,measuresForDB,msmtHost);
					allValuesForInfo.remove("+");

					
					if(!disabledBlocks.contains(testName))
					{
%>
	<div style="margin-left:5px;margin-top:5px;float:left;height:152px;border:0px solid #2B7F82" id="div<%=++divCount%>" >
		<table border="0" cellpadding="0"  cellspacing="0" height="100%" valign="top">
			<tr>
				<td width="100%" valign="top" class="gradient_header">
					<table border="0" cellpadding="2"  cellspacing="0" width="100%"><col width="95%"><col width="15px"><col width="15px">
						<tr>
							<td class="eg_75bold" height="20px" style="padding-left:4px;border-right-width:0px" width="100%"><egui:intnl text='monitor.dashboard.CPU Usage Summary'/></td>
<%
						if(adminPermission==true)
						{
%>
							<td class="eg_75bold" style="padding-right:4px;border-left-width:0px;border-right-width:0px" valign="middle" align="right" onclick="javascript:showMaximizedView('<%=comparisonTableFullViewURL%>','event','ComparisonTable');"> <img  id="img<%=divCount%>"  class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_maximize_div.png"/> </td>
							<td class="eg_75bold" valign="middle" align="right" style="padding-right:4px;border-left-width:0px"> <img class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_close_div.png" onclick="javascript:closeDiv(<%=divCount%>,'<%=tab+"_Overview"%>','<%=testName%>');" onload="javascript:divonload('<%=divCount%>','<%=tab+"_Overview_"+testName%>');"/> </td>
<%
						}
						else
						{
%>
							<td class="eg_75bold" style="padding-right:4px;border-left-width:0px;border-right-width:0px" valign="middle" align="right" >&nbsp;</td>
							<td class="eg_75bold" style="padding-right:4px;border-left-width:0px;" valign="middle" align="right" onclick="javascript:showMaximizedView('<%=comparisonTableFullViewURL%>','event','ComparisonTable');"> <img  id="img<%=divCount%>"  class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_maximize_div.png"/> </td>
<%
						}
%>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td valign="top" class="vmborder" style="padding:0px">
					<div id="overViewCompTableInnerDiv<%=divCount%>" class="div_scroll" style="height:130px;border:0px solid #ff0000;" >
					<table border="0" cellpadding="2" cellspacing="0" width="100%" class="tableborder_jvm" valign="top"><col width="35%"><col width="65%">
<%
					if(allValuesForInfo!=null && !allValuesForInfo.isEmpty())
					{
%>
						<tr>
							<td class="eg_75bold tdborder2_jvm" align="center"><span class="eg_75bold"><egui:intnl text='monitor.dashboard.Measure'/></span></td> 
							<td class="eg_75bold tdborder2_jvm" align="center" nowrap><egui:intnl text='monitor.dashboard.Used'/> (%)</td>
						</tr>
<%
						for(int k=0;k<allValuesForInfo.size();k++)
						{
							String val=(String)allValuesForInfo.get(k);
								Vector chartAttributes=new Vector();
								chartAttributes.add("bgColor='FFFFFF'");
								chartAttributes.add("bgAlpha='0'");
								chartAttributes.add("showBorder='0'");
								chartAttributes.add("upperLimit='100'");
								chartAttributes.add("lowerLimit='0'");
								chartAttributes.add("ticksBelowGauge='1'");
								chartAttributes.add("placeValuesInside='0'");
								chartAttributes.add("showGaugeLabels='0'");
								chartAttributes.add("valueAbovePointer='0'");
								chartAttributes.add("pointerOnTop='1'");
								chartAttributes.add("pointerRadius='6'");
								chartAttributes.add("chartTopMargin='5'");
								chartAttributes.add("chartBottomMargin='5'");
								chartAttributes.add("chartLeftMargin='25'");
								chartAttributes.add("chartRightMargin='25'");
								chartAttributes.add("majorTMColor='D73027'");
								chartAttributes.add("plotFillPercent='60'");
								chartAttributes.add("plotFillColor='000000'");
								chartAttributes.add("baseFontSize='8'");
								chartAttributes.add("baseFontColor='000000'");
								chartAttributes.add("pointerBgColor='000000'");
								chartAttributes.add("placeTicksInside='0'");
								chartAttributes.add("gaugeFillMix='{light-60},{light-40},{light-20},{dark-5},{D95F02},{light-30},{light-50},{dark-10}'");
								chartAttributes.add("gaugeFillRatio='20,30,20'");
								chartAttributes.add("gaugeRoundRadius='3'");
								chartAttributes.add("exportEnabled='0'");
								chartAttributes.add("exportAction='download'");
								chartAttributes.add("exportAtClient='0'");
								chartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");

								String linearGaugeXML=fusionChart.getXmlForLinearGauge(val,chartAttributes);
%>
						<tr>
							<td valign="middle" align="center"> <%=testMapping.get(k)%></td>
							<td align="right">
								<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="280" height="60" id="StackedColumn3D" >
									<param name="movie" value="/final/FusionCharts/swf/HLinearGauge.swf" />
									<param name="FlashVars" value="&dataXML=<%=linearGaugeXML%>&chartWidth=280&chartHeight=60">
									<param name="quality" value="high" />
									<param name="WMode" value="Transparent">
									<embed wmode="transparent" src="/final/FusionCharts/swf/HLinearGauge.swf" flashVars="&dataXML=<%=linearGaugeXML%>" quality="high" width="280" height="60" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
								</object> -->
								<div id="chartHLinear2Container<%=k%>"  style="height:100%;"></div>
								<script type="text/javascript">
									if  ( FusionCharts( "myHLinear2ChartId<%=k%>" ) )
											FusionCharts( "myHLinear2ChartId<%=k%>" ).dispose();
									var myChart = new FusionCharts( "/final/FusionCharts/swf/HLinearGauge.swf","myHLinear2ChartId<%=k%>", "280", "60","0","1");
									myChart.setXMLData("<%=linearGaugeXML%>");
									myChart.setTransparent(true);
									myChart.render("chartHLinear2Container<%=k%>");
								</script>
							</td>
						</tr>
<%
						}
					}
					else
					{
%>
						<tr>
							<td width="100%">
								<div id="overViewCompTableInnerDiv<%=divCount%>" class="div_scroll" style="height:130px;border:0px solid #ff0000;" >
								<table border="0" cellpadding="0" cellspacing="0" width="100%" height="107">
									<tr>
										<td align="center" height="100%" valign="middle"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"> <br > <egui:intnl text="monitor.dashboard.No measures available"/>!</td>
									</tr>
								</table>
								</div>
							</td>
						</tr>
<%
						}
%>
					</table>
					</div>
				</td>
			</tr>
		</table>
	</div>
<%
					}
				}
				else
				{
				Vector measures=new Vector();
				String measuresForDB="";
				String testName="";

				for(int i=0;i<allMeasures.size();i++)
				{
					String tempStr=(String)allMeasures.get(i);
					if(tempStr!=null && tempStr.indexOf(":")!=-1)
					{
						testName=tempStr.substring(0,tempStr.indexOf(":"));
						String tempMeasure=tempStr.substring(tempStr.indexOf(":")+1);
						Vector excludedInfos = dashboardDAO.getExcludedInfo(testName,tempMeasure,compType,false,false);
						measures.add(tempMeasure);
						measuresForDB+=dbInfo.getColumnForMeasure(testName,tempMeasure);
						if(allMeasures.size()>i+1)
							measuresForDB+=",";
					}
				}

				msmtHost=(String)allMsmtHosts.get(testName);
				if(msmtHost==null)
					msmtHost="";

				Vector allValuesForInfo=dashboardDAO.getCurrentForAllInfos(hostName,portNo,testName,measuresForDB,msmtHost);
				allValuesForInfo.remove("+");
				if(isOracleServer && sid!=null && !sid.equals(""))
					allValuesForInfo.remove(sid+"+");				
					if(!disabledBlocks.contains(testName) && isDBSummaryNeeded)
					{
%>
	<div style="margin-left:5px;margin-top:5px;float:left;height:152px;height:152px;border:0px solid #2B7F82" id="div<%=++divCount%>" >
		<table border="0" cellpadding="0"  cellspacing="0" height="100%"  valign="top">
			<tr>
				<td valign="top" class="gradient_header">
					<table border="0" cellpadding="2"  cellspacing="0" width="100%"><col width="95%"><col width="15px"><col width="15px">
						<tr>
							<td class="eg_75bold" height="20px" style="padding-left:4px;border-right-width:0px"><%=tableTitle%></td>
				
<%
						if(adminPermission==true)
						{
%>
							<td class="eg_75bold" style="padding-right:4px;border-right-width:0px;border-left-width:0px" valign="middle" align="right" onclick="javascript:showMaximizedView('<%=comparisonTableFullViewURL%>','event','ComparisonTable');"> <img id="img<%=divCount%>" class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_maximize_div.png"/> </td>
							<td class="eg_75bold" valign="middle" align="right" style="padding-right:4px;border-left-width:0px"> <img class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_close_div.png" onclick="javascript:closeDiv(<%=divCount%>,'<%=tab+"_Overview"%>','<%=testName%>');" onload="javascript:divonload('<%=divCount%>','<%=tab+"_Overview_"+testName%>');"/> </td>
<%
						}
						else
						{
%>
							<td class="eg_75bold" style="padding-right:4px;border-right-width:0px;border-left-width:0px" valign="middle" align="right">&nbsp;</td>
							<td class="eg_75bold" style="padding-right:4px;border-left-width:0px" valign="middle" align="right" onclick="javascript:showMaximizedView('<%=comparisonTableFullViewURL%>','event','ComparisonTable');"> <img id="img<%=divCount%>" class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_maximize_div.png"/> </td>
<%
						}
%>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td class="vmborder" style="padding:0px">
					<div id="overViewCompTableInnerDiv<%=divCount%>" class="div_scroll" style="height:130px;border:0px solid #ff0000;" >
					<table border="0" cellpadding="2" cellspacing="0" width="100%" ><col width="40%"><col width="30%"><col width="30%">
<%
						boolean isMeasureAvaliable=false;
						if(allValuesForInfo!=null && !allValuesForInfo.isEmpty())
						{
							for(int i=0;i<allValuesForInfo.size()&&measures.size()>i;i++)
							{
								if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
								{
									if(egDashboard.isTestHasCutOffFactor(testName))
									{
											boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,testName,msmtHost,(String)allValuesForInfo.get(i));
											if(isTestExceededCutOffFactor)
												continue;
									}
								}
								if(!isMeasureAvaliable)
									isMeasureAvaliable=true;
								measure=(String)measures.get(i);
								String measureForDB=dbInfo.getColumnForMeasure(testName,measure);
								String graph_values=dashboardDAO.getGraphValuesForSpark(hostName,"+",sid,testName,measureForDB,sparkLineStartTime+" "+sparkLineStartHour+":"+endDate.getMinutes()+":00",sparkLineEndTime+" "+sparkLineEndHour+":"+endDate.getMinutes()+":00");
								String sidForGph = "";
								if (sid !=null && !sid.equalsIgnoreCase(""))
									sidForGph = sid;
								String urlForMaximize="/final/servlet/com.egurkha.monitor.EgDashboardTimelineMeasures?sid="+sidForGph+"&measure="+measureForDB+"&state="+state+"&starttime="+startTime+"&port="+portNo+"&comptype="+compType+"&mode=3D&site="+site+"&host="+hostName+"&monitorSkin="+monitor_Skin+"&msmt_host="+msmtHost+"&gtype=1&starthr="+startHour+"&test="+testName+"&info=*&layer=HOST&endtime="+endTime+"&endhr="+endHour+"&showRange=Range&gformat=graph&fromDashboard=true&timeline_compare="+defaultMGraphDuration+"&width=880&height=320&threshold=no&title=true&minmaxavgRequired=true&priority=TOP+-+10&module="+tab;

								String urlForSummary="/final/monitor/egSummary.jsp?hostName="+compName+"&compType="+compType+"&subsystem=JVM Thread&ddmeasure="+measure+"&fullview=true&subject="+subject;

								String summaryTitle="Thread Details";

								if(compType!=null && compType.equalsIgnoreCase("MS_sql_server"))
								{
									String layerName=dashboardDAO.getLayerForTest(compType,test,measure);
									String testMeasureState=egDashboard.getTestMeasureState(compName,compType,layerName,test,measure);

									urlForSummary="/final/monitor/egDashDDData.jsp?fromPage=current&site="+site+"&comptype=Host_system"+"&host="+hostName+"&port="+portNo+"&layer=HOST&test="+testName+"&stest="+testName+"-*&info=*&msmt_host="+msmtHost+"&time=Any&timeline=Any&measure="+measure+"&from=0&firsttime=true&flag=1&fromDDGraphs=false&newWindow=false&comeFrom=null&ddTitle="+EgURLEncoder.encode("MSSQL Processes","UTF-8")+"&starttime="+startTime+"&starthr="+startDate.getHours()+"&endtime="+EgURLEncoder.encode(endTime,"UTF-8")+"&endhr="+endDate.getHours()+"&startmin="+startDate.getMinutes()+"&endmin="+endDate.getMinutes()+"&fromDashboardOverview=true";
									summaryTitle="SQL "+mappingInfo.getMeasureDescription(testName,measure)+" Summary";
								}

								String value=(String)allValuesForInfo.get(i);
								if(!testerInfo.getAllowNegativeValues(test,measure) && (value!=null) && (value.startsWith("-") || value.trim().equals("")))
								{
									value = "-";
								}

								Vector spartLineAttributes=new Vector();
								spartLineAttributes.add("palette='2'");
								spartLineAttributes.add("setAdaptiveYMin='0'");
								spartLineAttributes.add("bgAlpha='0,0'");
								spartLineAttributes.add("showHighAnchor ='0'");
								spartLineAttributes.add("showLowAnchor ='0'");
								spartLineAttributes.add("showOpenValue ='0'");
								spartLineAttributes.add("showCloseValue ='0'");
								spartLineAttributes.add("showHighLowValue ='0'");
								spartLineAttributes.add("showOpenAnchor ='0'");
								spartLineAttributes.add("showCloseAnchor ='0'");
								spartLineAttributes.add("lineColor='"+iniObj.getValue("Dashboard_Graph_colors","Sparkline")+"'");
								spartLineAttributes.add("clickURL='javascript:sparklineOnclick(&apos;comparesparkurl"+i+"&apos;)'");

								Vector sparkValues=egDashboard.getTokensAsVector(graph_values,",");

								String sparkXML=fusionChart.getXMLForSpark(sparkValues,spartLineAttributes);
%>
						<tr>
							<td width="40%">
						<%
								if(value!=null && !value.equals("-"))
								{
						%>
									<a class="<%=(testName.equals("JvmThreadTest"))?"mouse eg_monlink":"eg_monlink"%>" onclick="javascript:<%=(testName.equals("JvmThreadTest"))?"loadPageinFrame('"+urlForSummary+"',event,'"+summaryTitle+"');":"void(0);"%>"><egui:intnl measure = '<%=testName+":"+measure%>'/></a>
						<%
								}
								else
								{
						%>
									<p><egui:intnl measure = '<%=testName+":"+measure%>'/></p>
						<%
								}
						%>
							</td>
							<td width="30%">
<%
								if(graph_values!=null  && graph_values.length()>0)
								{
%>
								<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="100" height="20" id="StackedColumn3D" >
									<param name="movie" value="/final/FusionCharts/swf/SparkLine.swf" />
									<param name="FlashVars" value="&dataXML=<%=sparkXML%>&chartWidth=100&chartHeight=20">
									<param name="quality" value="high" />
									<param name="WMode" value="Transparent">
									<embed wmode="transparent" src="/final/FusionCharts/swf/SparkLine.swf" flashVars="&dataXML=<%=sparkXML%>" quality="high" width="100" height="20" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
								</object> -->
								<div id="chartSparkLine2Container<%=i%>"  style="height:100%;"></div>
								<script type="text/javascript">
									if  ( FusionCharts( "mySparkLine2ChartId<%=i%>" ) )
											FusionCharts( "mySparkLine2ChartId<%=i%>" ).dispose();
									var myChart = new FusionCharts( "/final/FusionCharts/swf/SparkLine.swf","mySparkLine2ChartId<%=i%>", "100", "20","0","1");
									myChart.setXMLData("<%=sparkXML%>");
									myChart.setTransparent(true);
									myChart.render("chartSparkLine2Container<%=i%>");
								</script>
								<input type="hidden" id="comparesparkurl<%=i%>"  value="<%=urlForMaximize%>"/>
<%
								}
								else
								{
%>
								&nbsp;
<%
								}
%>
							</td>
							<td width="30%"><%=value%></td>
						</tr>
<%
							}
						}
						if(!isMeasureAvaliable) 
						{
%>
						<tr>
							<td width="100%">
								<table border="0" cellpadding="0" cellspacing="0" width="100%" height="120">
									<tr>
										<td align="center" height="100%" valign="middle"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"> <br > <egui:intnl text="monitor.dashboard.No measures available"/>!</td>
									</tr>
								</table>
							</td>
						</tr>
<%
						}
%>
					</table>
					</div>
				</td>
			</tr>
		</table>
	</div>
<%
					}
				}
			}
			else
			{
%>
	<div style="margin-left:5px;margin-top:5px;float:left;height:152px;border:0px solid #2B7F82" id="div<%=++divCount%>" >
		<table border="0" cellpadding="0"  cellspacing="0" height="100%"  valign="top">
			<tr>
				<td width="100%" valign="top" class="gradient_header">
					<table border="0" cellpadding="2"  cellspacing="0" width="100%"><col width="95%"><col width="15px"><col width="15px">
						<tr>
							<td class="eg_75bold" height="20px" style="padding-left:4px;border-right-width:0px"><%=tableTitle%></td>
				
<%
				if(adminPermission==true)
				{
%>
							<td class="eg_75bold" valign="middle" style="padding-right:4px;border-right-width:0px;border-left-width:0px" align="right" onclick="javascript:showMaximizedView('<%=comparisonTableFullViewURL%>','event','ComparisonTable');"> <img id="img<%=divCount%>" class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_maximize_div.png"/> </td>
							<td class="eg_75bold" valign="middle" align="right" style="padding-right:4px;border-left-width:0px"> <img class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_close_div.png" onclick="javascript:closeDiv(<%=divCount%>,'<%=tab+"_Overview"%>','<%=test%>');" onload="javascript:divonload('<%=divCount%>','<%=tab+"_Overview_"+test%>');"/> </td>
<%
				}
				else
				{
%>
							<td class="eg_75bold" valign="middle" style="padding-right:4px;border-right-width:0px;border-left-width:0px" align="right">&nbsp;</td>
							<td class="eg_75bold" valign="middle" style="padding-right:4px;border-left-width:0px" align="right" onclick="javascript:showMaximizedView('<%=comparisonTableFullViewURL%>','event','ComparisonTable');"> <img id="img<%=divCount%>" class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_maximize_div.png"/> </td>
<%
				}
%>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td style="padding:0px" class="vmborder">
					<div id="overViewCompTableInnerDiv<%=divCount%>" class="div_scroll" style="height:130px;border:0px solid #ff0000;" >
					<table border="0" cellpadding="0" cellspacing="0" width="100%" height="120">
						<tr>
							<td align="center" height="100%" valign="middle"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"> <br > <egui:intnl text="monitor.dashboard.No measures available"/>!</td>
						</tr>
					</table>
					</div>
				</td>
			</tr>
		</table>
	</div>
<%
			}
			tablescount++;
		}
	}
	if(isFullViewForKPI)
	{
%>
	<input type="hidden" id="recentFullViewURL" value='<%=lastFullViewURL%>'>
	<img src="/final/monitor/eg_images/spacer.gif" height="0px" width="0px" border="0px" onload="this.blur();return reloadFullView('none');" style="visibility:hidden;display:none;">
<%
	}
	else if(isFullViewForConfig)
	{
%>
	<input type="hidden" id="recentFullViewURL" value='<%=lastFullViewURL%>'>
	<img src="/final/monitor/eg_images/spacer.gif" height="0px" width="0px" border="0px" onload="this.blur();return showMaximizedTable('event','ConfigDataDiv','','<%=configDivCount%>','<%=configTitleStr%>');" style="visibility:hidden;display:none;">
<%

	}
%>
<input id="graphType" type="hidden" value="SummaryAtGlance"/>
<!--   This div added for table end space  --------jaiwin -->
<div style="border:0px solid #ff0000;margin:1px;padding:0px;height:2px;width:700px" ><span class="eg_blankspace">&nbsp;</span></div>
<%
if(request.getQueryString()!=null)
	{
		if(session!=null)
		{
			session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&"+request.getQueryString()+"&comptype="+request.getParameter("compType")+"&tab="+tab+"&graphType=SummaryAtGlance&toDashBoardLayer=true");
			session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
		}
	}
	else
	{
		if(session!=null)
		{
			session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&tab="+tab+"&toDashBoardLayer=true");
			session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
		}
	}
}
catch(Exception ex)
{
	ex.printStackTrace();
}
%>

