<%
/*******************************************************************************
*	File name		: egDashTimeline.jsp
*	Purpose			: To display Fullview Graph in monitor Dashboard.
*	Version			: eG 5.0
*	Creation Date	: 20/03/2009
*	Authtor			: Simeon.D
********************************************************************************/
%>
<%@ include file = "EgServerDashboardTracker.jsp"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.EgTablesInfo"%>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import= "com.egurkha.monitor.*"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.egurkha.EgMeasureGraphExt"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "java.text.SimpleDateFormat"%>
<%@ page import = "com.egurkha.util.DateTimeTokenizer"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import = "egurkha.reporter.ErUtils" %>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import="com.egurkha.util.MathUtils"%>
<%@ page import = "com.egurkha.monitor.EgServerDashBoardDAO" %>
<%@ page import="net.sf.json.*"%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>
<%
try
{
	JSONObject rootJSON = new JSONObject();
	JSONObject hiddens = new JSONObject();
	String currentBrowser = request.getHeader("User-Agent");

	boolean isFirefox = ( currentBrowser != null && currentBrowser.indexOf( "Firefox/" ) != -1 );
	boolean isMSIE6 = ( currentBrowser != null && currentBrowser.indexOf( "MSIE 6.0" ) != -1 );
	boolean isMSIE7 = ( currentBrowser != null && currentBrowser.indexOf( "MSIE 7.0" ) != -1 );
	boolean isChrome = ( currentBrowser != null && currentBrowser.indexOf( "Chrome/" ) != -1 );

	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgTablesInfo tablesInfo=new EgTablesInfo("manager");
	EgDbInfo dbInfo=new EgDbInfo("manager");

	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());

	MonitorDAOFactory	monitorDaoFactory = MonitorDAOFactory.getInstance();
	EgServerDashBoardDAO dashboardDAO=monitorDaoFactory.getServerDashBoardDAO();
	String compType=request.getParameter("comptype");
	String dashboardIni = "eg_serverdashboard.ini";
	EgServerDashboardModel  egDashboard=null;
	if(compType!=null && compType.startsWith("Agg_"))
	{
		egDashboard=new  EgServerDashboardModel(true);
		dashboardIni = "eg_aggregateserverdashboard.ini";
	}
	else
	{
		egDashboard=new  EgServerDashboardModel();
	}
	EgServerDashboardMGraphModel measureGraph=new EgServerDashboardMGraphModel();
	EgFusionChartUtil fusionChart=new EgFusionChartUtil(trackerLanguage);
	EgGraphsUtil graphUtil=new EgGraphsUtil(trackerLanguage);
	ErUtils erUtils = new ErUtils();	

	EgMeasureGraphExt measureGraphInfo = new EgMeasureGraphExt();
	IniUI iniUI = IniUI.getInstance();
	EgMappingInfo egMappingInfo=new EgMappingInfo(trackerLanguage);

	String fontForLanguage="verdana";
	String fontSize="11";
	boolean isNonEnglishLanguage=((EgDbInfo.doubleByteEnabled && !trackerLanguage.equals("en_US")) || !trackerLanguage.equals("en_US"));
	if(isNonEnglishLanguage)
	{
		fontForLanguage=iniUI.getFontName();
		fontSize="12";
	}
	String s_iniFile_dir=EgInstallInfo.getInstallDir()+"/manager/config/";
	IniFile iniObj=new IniFile(s_iniFile_dir+dashboardIni);
	Vector v_color = new Vector();

	String s_colors=iniObj.getValue("Dashboard_Graph_colors","LineGraph");
	String UseCutOffFactor=iniObj.getValue("Dashboard_Settings","UseCutOffFactor");
	StringTokenizer colorTokens=new StringTokenizer(s_colors,",");

	while(colorTokens.hasMoreTokens())
	{
		String token=colorTokens.nextToken();
		if(token!=null && token.indexOf("#")!=0)
			token="#"+token;

		v_color.add(token);
	}

	Vector v_priority=new Vector();
	v_priority.add(egMappingInfo.getTextDescription("monitor.descComparisonGraph.TOP")+" - 10");
	v_priority.add(egMappingInfo.getTextDescription("monitor.descComparisonGraph.TOP")+" - 5");
	v_priority.add(egMappingInfo.getTextDescription("monitor.descComparisonGraph.TOP")+" - 2");
	v_priority.add(egMappingInfo.getTextDescription("monitor.descComparisonGraph.TOP")+" - 1");
	v_priority.add(egMappingInfo.getTextDescription("monitor.descComparisonGraph.ALL"));
	v_priority.add(egMappingInfo.getTextDescription("monitor.descComparisonGraph.LAST")+" - 1");
	v_priority.add(egMappingInfo.getTextDescription("monitor.descComparisonGraph.LAST")+" - 2");
	v_priority.add(egMappingInfo.getTextDescription("monitor.descComparisonGraph.LAST")+" - 5");
	v_priority.add(egMappingInfo.getTextDescription("monitor.descComparisonGraph.LAST")+" - 10");

	String comFormat = null;
	String startDateTime = null;
	String endDateTime = null;

	String startDate = "";
	String endDate = "";

	String dispDate = null;
	String defaultDateFormat = null;
	String disable = "disabled";

	String s_starttime=request.getParameter("starttime");
	String s_endtime=request.getParameter("endtime");
	String s_starthr=request.getParameter("starthr");	
	String s_endhr=request.getParameter("endhr");

	String s_stmin=request.getParameter("startMin");
	String s_endmin=request.getParameter("endMin");
	if (s_stmin == null)
	{
		s_stmin = "00";
	}
	if (s_endmin == null)
	{
		s_endmin = "00";
	}
	
	String measure=request.getParameter("measure");
	String s_measure=request.getParameter("s_measure");
	String portNo=request.getParameter("port");
	String site=request.getParameter("site");
	String msmtHost=request.getParameter("msmt_host");
	String test=request.getParameter("test");
	String info=request.getParameter("info");
	String priority=request.getParameter("priority");
	String real_measure=request.getParameter("real_measure");
	String displayName=request.getParameter("displayName");
	String s_layerName=request.getParameter("layer");
	String isTimeLineChange=request.getParameter("isTimeLineChange");
	if(s_layerName==null || (s_layerName!=null && s_layerName.equals("")))
		s_layerName="HOST";
	String blockType=request.getParameter("blockType");

	String timeline = request.getParameter("timeline_compare");
	String timelineChangedForCompGraph = request.getParameter("timelineChangedForCompGraph");

	String currentDateFormat = iniUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	boolean loadCurrentValue=false;

	// for Insideview Dashboard
	String time_line = "";
	if(timeline==null)
	{
		time_line = request.getParameter("time_line");
	}
	if(timeline!=null)
		loadCurrentValue=true;

	//--end---
	String hostName= request.getParameter("host");
	String compName="";
	String sid=request.getParameter("sid");
	String module=request.getParameter("module");

	if(compType==null)
		compType=request.getParameter("compType");
	if(hostName!=null && !hostName.equals(""))
	{
		StringTokenizer st=new StringTokenizer(hostName,":");
		if(st.hasMoreTokens())
			compName=st.nextToken();

		if(st.hasMoreTokens())
			portNo=st.nextToken();

		if(st.hasMoreTokens())
			sid=st.nextToken();
	}

/* Hostname is regrouped to get the portno and sid through request */
	hostName=compName+":"+portNo;

	if(sid!=null && sid.trim().length()>0)
		hostName+=":"+sid;
	Hashtable allMsmtHosts=dashboardDAO.getMsmtHostForAllTest(hostName,compType,module);
	Hashtable allTestInfos=dashboardDAO.getDescriptorsForAllTest(hostName,compType,module);
	Vector runningtests=dashboardDAO.getRunningTestsForServer(hostName,compType,module);
	ArrayList compsForVirtualNetworkLayer=tablesInfo.getServersForLayer("VIRTUAL_NETWORK");
	if(compsForVirtualNetworkLayer!=null && compsForVirtualNetworkLayer.contains(compType))
		runningtests=dashboardDAO.getRunningTestsForServer(hostName,compType,"custom");
	String duration=request.getParameter("duration");
	String trendType=request.getParameter("trendType");
	String graphType=request.getParameter("graphType");
	String display=request.getParameter("display");
	String subsystem=request.getParameter("subsystem");
	boolean isTimelineRequired = (display!=null && display.equals("false"));
	if(isTimelineRequired)
		display="none";
	else
		display="block";
	String format=request.getParameter("format");
	String ddformat=request.getParameter("ddformat");
	boolean LayerwiseHealth=graphType!=null && graphType.equalsIgnoreCase("LayerwiseHealth");
	String isInfoReleventGraph=request.getParameter("isInfoReleventGraph");
	boolean isShowTopAnalysisRequired=(isInfoReleventGraph!=null && isInfoReleventGraph.equalsIgnoreCase("true") );
	if ((!isShowTopAnalysisRequired) && (graphType!=null && graphType.equalsIgnoreCase("Measuregraph")) )
		priority= "TOP+-+3";

	if(format!=null && format.indexOf("|pct|")!=-1)
		format=com.egurkha.util.StringUtils.replace(format,"|pct|","%");

	String mode=request.getParameter("mode");
	String minmaxavgRequired=request.getParameter("minmaxavgRequired");
	String graphTitle=request.getParameter("graphTitle");
	String durationChanged=request.getParameter("durationChanged");
	String minMaxAvgDisplay="none";
	String from_page=request.getParameter("from_page");
	String AggregateGraphs=request.getParameter("AggregateGraphs");

	if(minmaxavgRequired!=null && minmaxavgRequired.equalsIgnoreCase("true"))
	{
		if (graphType != null && graphType.equalsIgnoreCase("Measuregraph"))
		{
			minmaxavgRequired="true";
			minMaxAvgDisplay="block";
		}
		else
		{
			if(test!=null && runningtests.contains(test))
			{
				minmaxavgRequired="true";
				minMaxAvgDisplay="block";
			}
			else
			{
				minmaxavgRequired="false";
				minMaxAvgDisplay="none";
			}
		}
	}
	// for graph zoom ,from vmwareDashboard start
	String come_from=request.getParameter("come_from");
	boolean come_from_vmware=false;
	come_from_vmware=(come_from!=null) && (come_from.equalsIgnoreCase("vmwareDashboard"));
	if(come_from_vmware)
		minMaxAvgDisplay="block";
	String fromHist = request.getParameter("fromHist");

	String Qstring="";
	String queryString = request.getQueryString();
	if(queryString!=null)
	{
		StringTokenizer strtok = new StringTokenizer(queryString,"&");
		while(strtok.hasMoreTokens())
		{
			String param = strtok.nextToken();
			int ind = param.indexOf("=");
			if (ind < 0)
				continue;
			String reqparam =param.substring(0,ind);
			String value = param.substring(ind+1);
			if(reqparam.equals("info"))
			{
				value=request.getParameter(reqparam);
			}
			else if(reqparam.equals("host"))
			{
				value=request.getParameter(reqparam);
			}
			else if(reqparam.equals("comptype"))
			{
				value=request.getParameter(reqparam);
			}
			else if(reqparam.equals("test"))
			{
				if(request.getParameter(reqparam)!=null)
				{
					value=com.eg.EgURLEncoder.encode(request.getParameter(reqparam), "UTF-8");
				}
				else
				{
					value=request.getParameter(reqparam);
				}
			}
			else if(reqparam.equals("layer"))
			{
				value=request.getParameter(reqparam);
			}
			Qstring=Qstring+reqparam+"="+value+"&";
		}
	}

	String encodedFormat=format;
	if(format!=null && (!format.equals("") && !format.equalsIgnoreCase("null")))
	{
		encodedFormat=com.egurkha.util.StringUtils.replace(format,"%","|pct|");
	}

	SimpleDateFormat  dateFormatWithTime=new SimpleDateFormat("dd/MM/yyyy HH:mm");
	SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm");
	SimpleDateFormat dateFormat=new SimpleDateFormat("MM/dd/yyyy");
	SimpleDateFormat testTableDateFmt=new SimpleDateFormat("yyyy-MM-dd HH:mm");
	SimpleDateFormat dfForParse=new SimpleDateFormat(currentDateFormat);
	SimpleDateFormat dateFormatDDMM=new SimpleDateFormat("dd/MM/yyyy");

	String screenWidth=request.getParameter("screenWidth");
	String screenHeight=request.getParameter("screenHeight");
	int graphWidth=1024;
	int graphHeight=768;
	if(screenWidth!=null && !screenWidth.equals(""))
	{
		graphWidth=Integer.parseInt(screenWidth);
		graphWidth=graphWidth-60;
	}
	if(screenHeight!=null && !screenHeight.equals(""))
	{
		graphHeight=Integer.parseInt(screenHeight);
		graphHeight=graphHeight-60;
	}
	String popup_topright=(!isMSIE6)?"popup_topright":"popup_topright_noshade";
	String popup_rightbg =(!isMSIE6)?"popup_rightbg":"popup_rightbg_noshade";
	String popup_bottomleft =(!isMSIE6)?"popup_bottomleft":"popup_bottomleft_noshade";
	String popup_bottombg =(!isMSIE6)?"popup_bottombg":"popup_bottombg_noshade";
	String popup_bottomright =(!isMSIE6)?"popup_bottomright":"popup_bottomright_noshade";
	/* This is to show alert details in popup other wise graphs will be loaded */
	if(LayerwiseHealth)
	{
		JSONObject LayerwiseHealthJson  = new JSONObject(); 
		JSONObject LayerwiseHealthObject  = new JSONObject(); 
		String healthCompName=request.getParameter("hostName");
		compType=request.getParameter("compType");

		Vector chartAttributes=new Vector();
		chartAttributes.add("showLegend='0'");
		chartAttributes.add("useRoundEdges='1'");
		chartAttributes.add("showValues='0'");
		chartAttributes.add("clickURL='javascript:bigGraphOnClick()'");
		chartAttributes.add("yAxisMaxValue='100'");
		chartAttributes.add("bgAlpha='0,0'");
		chartAttributes.add("bgColor='ffffff,ffffff'");
		chartAttributes.add("canvasLeftMargin='5'");
		chartAttributes.add("canvasRightMargin='5'");
		chartAttributes.add("canvasTopMargin='5'");
		chartAttributes.add("canvasBottomMargin='5'");
		chartAttributes.add("baseFontColor ='000000'");
		chartAttributes.add("baseFontSize ='9'");
		chartAttributes.add("baseFont  ='verdana'");
		chartAttributes.add("showBorder  ='0'");
		chartAttributes.add("showPlotBorder  ='0'");
		chartAttributes.add("plotSpacePercent='40'");
		chartAttributes.add("adjustDiv='0'");
		chartAttributes.add("decimals='2'");
		chartAttributes.add("exportEnabled='0'");
		chartAttributes.add("exportAction='download'");
		chartAttributes.add("exportAtClient='0'");
		chartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");

		String layerHealthXML=fusionChart.getXMLForLayerHealth(healthCompName,compType,module,true,chartAttributes);
		LayerwiseHealthJson.put("minimizeIconSrc","/final/monitor/eg_images/"+monitor_Skin+"/icon_minimize_div.png");
		LayerwiseHealthJson.put("METHOD","zoomClose|true");

		if(layerHealthXML!=null && layerHealthXML.trim().length()>0)
		{
			LayerwiseHealthObject.put("chartData","true");
			LayerwiseHealthObject.put("chartWidth",graphWidth);
			LayerwiseHealthObject.put("chartHeight",graphHeight);
			LayerwiseHealthObject.put("SWF_PATH","/final/FusionCharts/swf/StackedBar2D.swf");
			LayerwiseHealthObject.put("DATAXML",layerHealthXML);
		}
		else
		{
			LayerwiseHealthObject.put("chartData","false");
			LayerwiseHealthObject.put("NoMeasures",egMappingInfo.getTextDescription("monitor.summary.No measures available!"));
		}
		LayerwiseHealthJson.put("LayerwiseHealthObject",LayerwiseHealthObject);
		rootJSON.put("LayerwiseHealth",LayerwiseHealthJson);
	}
	else
	{
		JSONArray graphFilters = new JSONArray();
		JSONObject graphObj = new JSONObject();
		//------end----
		if(mode==null)
			mode="2D";

		if(duration==null)
			duration="H";

		if(StringUtils.isNull(timeline))
			timeline = "1 hour";

		if(graphTitle==null || graphTitle.trim().equals(""))
			graphTitle="Graph";

		int startHour = 0;
		int endHour = 23;
		int startMin=0;
		int endMin=0;
		int[] hours = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23};

		String[] options;
		if(durationChanged!=null && durationChanged.equalsIgnoreCase("true"))
		{
			if(duration!=null && duration.equalsIgnoreCase("D"))
			{
				timeline="1 week";
			}
			else if(duration!=null && duration.equalsIgnoreCase("M"))
			{
				timeline="3 months";
			}
			else
			{
				timeline="24 hours";
			}
		}

		if(duration!=null && duration.equalsIgnoreCase("D"))
		{
			options =new String[] {"Any","2 days","3 days","4 days","5 days","6 days","1 week","2 weeks","3 weeks","4 weeks","1 month","2 months"};
		}
		else if(duration!=null && duration.equalsIgnoreCase("M"))
		{
			options =new String[] {"Any","1 month","3 months","6 months","9 months","12 months"};
		}
		else
		{
			options =new String[] {"Any","1 hour","3 hours","6 hours","9 hours","12 hours","15 hours","18 hours","21 hours","24 hours","2 days","3 days","4 days","5 days","6 days","1 week","2 weeks","3 weeks","4 weeks","1 month","2 months"};
		}
		String unit ="";
		int value=0;
		int timeValue=0;

		EgDateInfo edi = new EgDateInfo();
		Date today = edi.egetRealDate();
		Date start = edi.egetRealDate();
		if(timeline != null && !timeline.equals("Any") && !timeline.equalsIgnoreCase("Fixed"))
		{
			int blankSpaceIndex = timeline.indexOf(DateTimeTokenizer.BLANK_SPACE);
			if (blankSpaceIndex > 0)
			{
				value = Integer.parseInt(timeline.substring(0, blankSpaceIndex));
				timeValue=Integer.parseInt(timeline.substring(0, blankSpaceIndex));
				unit = timeline.substring(blankSpaceIndex+1).toLowerCase();
				if (unit.startsWith("h"))
				{//hours
					value *= 3600;
				}
				else if (unit.startsWith("d"))
				{//days
					value *= (24 * 3600);
				}
				else if (unit.startsWith("w"))
				{//weeks
					value *= (7 * 24 * 3600);
				}
				else if (unit.startsWith("mo"))
				{//months
					value *= (30 * 24 * 3600);
				}
				long longValue=value;
				if((graphType!=null) && (graphType.equalsIgnoreCase("Summarygraph") || graphType.equalsIgnoreCase("Trendgraph")))
				{
					if (unit.startsWith("h"))
					{
						start.setDate(start.getDate()-1);
					}
					else
					{
						start.setTime(today.getTime() - (longValue * 1000));
					}
				}
				else
				{
					start.setTime(today.getTime() - (longValue * 1000));
				}

				endDateTime = sdf.format(today);
				startDateTime = sdf.format(start);

				startMin=today.getMinutes();
				endMin=start.getMinutes();
			}

			if((startDateTime != null) && (endDateTime != null))
			{
				int shr = Integer.parseInt(startDateTime.substring(startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, startDateTime.indexOf(":")));
				int en_hr = Integer.parseInt(endDateTime.substring(endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, endDateTime.indexOf(":")));

				endDate=endDateTime.substring(0, endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
				startDate=startDateTime.substring(0, startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));

				if((graphType!=null) && (graphType.equalsIgnoreCase("Summarygraph") || graphType.equalsIgnoreCase("Trendgraph")))
				{
					if(unit.startsWith("h"))
					{
						startHour = 24-timeValue;
						endHour = 0;
					}
					else
					{
						startHour = 0;
						endHour = 0;
					}
				}
				else
				{
					startHour = shr;
					endHour = en_hr;
				}
			}	
		}
		else if(timeline!=null && timeline.equalsIgnoreCase("Fixed"))
		{
			try
			{
				String startDateStr=request.getParameter("starttime_compare");
				if(startDateStr==null)
				{
					startDateStr=request.getParameter("starttime");
				}
				startDate = startDateStr;

				String endDateStr=request.getParameter("endtime_compare");
				if(endDateStr==null)
				{
					endDateStr=request.getParameter("endtime");
				}
				endDate=endDateStr;
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}

			try
			{
				String starthr=request.getParameter("starthr_compare");
				if(starthr==null)
				{
					starthr=request.getParameter("starthr");
				}
				startHour = Integer.parseInt(starthr);
			}
			catch(Exception e)
			{
				startHour = 0;
			}

			try
			{
				String endhr=request.getParameter("endhr_compare");
				if(endhr==null)
				{
					endhr=request.getParameter("endhr");
				}
				endHour = Integer.parseInt(endhr);
			}
			catch(Exception e)
			{
				endHour = 23;
			}
		}
		else
		{
			disable="false";
			Date startDateFrmReq=new Date();
			Date endDateFrmReq=new Date();

			try
			{
				String startDateStr=request.getParameter("starttime_compare");				
				if(startDateStr==null)
				{
					startDateStr=request.getParameter("starttime");
				}
				if(graphType!=null && (graphType.equalsIgnoreCase("Trendgraph")|| graphType.equalsIgnoreCase("Summarygraph") ))
				{
					startDateStr=DateUtil.changeDateFormat(startDateStr,"MM/dd/yyyy",currentDateFormat);
				}
				
				startDateFrmReq=dfForParse.parse(startDateStr);
				startDate = dateFormat.format(startDateFrmReq);
				
				String endDateStr=request.getParameter("endtime_compare");
				if(endDateStr==null)
				{
					endDateStr=request.getParameter("endtime");
				}
				if(graphType!=null && (graphType.equalsIgnoreCase("Trendgraph")|| graphType.equalsIgnoreCase("Summarygraph") ))
				{
					endDateStr=DateUtil.changeDateFormat(endDateStr,"MM/dd/yyyy",currentDateFormat);
				}
				endDateFrmReq=dfForParse.parse(endDateStr);
				endDate =dateFormat.format(endDateFrmReq);
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}

			try
			{
				String starthr=request.getParameter("starthr_compare");
				if(starthr==null)
				{
					starthr=request.getParameter("starthr");
				}
				startHour = Integer.parseInt(starthr);
			}
			catch(Exception e)
			{
				startHour = 0;
			}

			try
			{
				String endhr=request.getParameter("endhr_compare");
				if(endhr==null)
				{
					endhr=request.getParameter("endhr");
				}
				endHour = Integer.parseInt(endhr);
			}
			catch(Exception e)
			{
				endHour = 23;
			}

			startDateTime =dateFormatDDMM.format(startDateFrmReq)+" "+startHour+":00";
			endDateTime =dateFormatDDMM.format(endDateFrmReq)+" "+endHour+":00";
		}
		String UserFormat = (String)user.getUserDateFormat();
		if(UserFormat == null && UserFormat.isEmpty() && UserFormat.equalsIgnoreCase("default"))
		{
			UserFormat = currentDateFormat;
		}

		//timeZone convertion
		String startDateInMgrDateFormat=s_starttime;
		String endDateInMgrDateFormat=s_endtime;
		
		int startHrInMgrDate = startHour;
		int endHourInMgrDate= endHour;
		String startMinInMgrDate=s_stmin;
		String endMinInMgrDate=s_endmin;

		JSONArray dateArrayValues = new JSONArray();		
		dateArrayValues.add(startDateInMgrDateFormat);
		dateArrayValues.add(endDateInMgrDateFormat);
		dateArrayValues.add(String.valueOf(startHrInMgrDate));
		dateArrayValues.add(String.valueOf(endHourInMgrDate));
		dateArrayValues.add(startMinInMgrDate);
		dateArrayValues.add(endMinInMgrDate);


		EgTimeZoneConverter timeZoneConverterStart = null;
		EgTimeZoneConverter timeZoneConverterStartinUserFormat = null;
		EgTimeZoneConverter timeZoneConverterEnd = null;
		EgTimeZoneConverter timeZoneConverterEndinUserFormat = null;
		if(s_starttime!=null && !s_starttime.equals(""))
		{
			if(DateUtil.isDate(s_starttime,"MM/dd/yyyy"))
			{
				comFormat = "MM/dd/yyyy";
			}
			else
			{
				comFormat = currentDateFormat;
			}
			String startTimeIncurrentFormat = DateUtil.changeDateFormat(s_starttime,comFormat,currentDateFormat);
			String startTimeIncurrentUserFormat = DateUtil.changeDateFormat(s_starttime,comFormat,UserFormat);
			timeZoneConverterStart = new EgTimeZoneConverter(startTimeIncurrentFormat+" "+startHour+":"+s_stmin+":00",user);
			timeZoneConverterStartinUserFormat = new EgTimeZoneConverter(startTimeIncurrentUserFormat+" "+startHour+":"+s_stmin+":00",user);
			String startDateForDisplay = (String) timeZoneConverterStart.getDate(false);
			String startDateForDisplayinUserFormat = (String) timeZoneConverterStartinUserFormat.getDate(false);
			String startHourForDisplay = timeZoneConverterStart.getHour();
			String startHourForDisplayinUserFormat = timeZoneConverterStartinUserFormat.getHour();
			String startMinForDisplay = timeZoneConverterStart.getMinute();
			String startMinForDisplayinUserFormat = timeZoneConverterStartinUserFormat.getMinute();
			dateArrayValues.add(startTimeIncurrentUserFormat);
			if((graphType!=null) && (graphType.equalsIgnoreCase("Trendgraph") || graphType.equalsIgnoreCase("Summarygraph")))
			{
				startHourForDisplayinUserFormat = "0";
				startMinForDisplayinUserFormat = "00";
				dateArrayValues.add(startHourForDisplayinUserFormat);
				dateArrayValues.add(startMinForDisplayinUserFormat);
			}
			else
			{
				dateArrayValues.add(startHourForDisplayinUserFormat);
				dateArrayValues.add(startMinForDisplayinUserFormat);
			}
		}
		if(s_endtime!=null && !s_endtime.equals(""))
		{
			if(DateUtil.isDate(s_endtime,"MM/dd/yyyy"))
			{
				comFormat = "MM/dd/yyyy";
			}
			else
			{
				comFormat = currentDateFormat;
			}
			String endTimeIncurrentFormat = DateUtil.changeDateFormat(s_endtime,comFormat,currentDateFormat);
			String endTimeIncurrentFormatUserFormat = DateUtil.changeDateFormat(s_endtime,comFormat,UserFormat);	
			timeZoneConverterEnd = new EgTimeZoneConverter(endTimeIncurrentFormat+" "+endHour+":"+s_endmin+":"+"00",user);
			timeZoneConverterEndinUserFormat = new EgTimeZoneConverter(endTimeIncurrentFormatUserFormat+" "+endHour+":"+s_endmin+":"+"00",user);
			String endDateForDisplay = (String) timeZoneConverterEnd.getDate(false);
			String endDateForDisplayinUserFormat = (String) timeZoneConverterEndinUserFormat.getDate(false);
			String endHourForDisplay = timeZoneConverterEnd.getHour();
			String endHourForDisplayinUserFormat = timeZoneConverterEndinUserFormat.getHour();
			String endMinForDisplay = timeZoneConverterEnd.getMinute();
			String endMinForDisplayinUserFormat = timeZoneConverterEndinUserFormat.getMinute();
			dateArrayValues.add(endTimeIncurrentFormatUserFormat);
			if((graphType!=null) && (graphType.equalsIgnoreCase("Trendgraph") || graphType.equalsIgnoreCase("Summarygraph")))
			{
				endHourForDisplayinUserFormat = "0";
				endMinForDisplayinUserFormat = "00";
				dateArrayValues.add(endHourForDisplayinUserFormat);
				dateArrayValues.add(endMinForDisplayinUserFormat);
			}
			else
			{
				dateArrayValues.add(endHourForDisplayinUserFormat);
				dateArrayValues.add(endMinForDisplayinUserFormat);
			}
		}
		rootJSON.put("dateArrayValues",dateArrayValues);

		if(info!=null && info.equals(""))
			info="*";
		if(!come_from_vmware)
		{
			if(fromHist!=null && fromHist.equalsIgnoreCase("true") && (graphType!=null &&   graphType.equalsIgnoreCase("ddGraph")))
			{
				String desc="*";
				if(allTestInfos!=null && allTestInfos.contains(test))
				{
					Vector allInfos=(Vector)allTestInfos.get(test);
					if(allInfos!=null && allInfos.size()>0)
					{
						if(allInfos.contains("+Summary"))
						{
								desc="+Summary";
						}
						else
						{
							desc=(String)allInfos.get(0);
						}
					}
				}

				msmtHost=(String)allMsmtHosts.get(test);
				String s_lastMsmtTime=measureGraph.getLastRuntimeForDDTest(test,measure,compName,portNo,"NULL",desc,msmtHost);

				if(s_lastMsmtTime!=null && s_lastMsmtTime.trim().length()>0)
				{
					java.util.Date lastMsmtTime=testTableDateFmt.parse(s_lastMsmtTime);
					startDate=dateFormat.format(lastMsmtTime);
					endDate=dateFormat.format(lastMsmtTime);
					String s_timeonly=s_lastMsmtTime.substring(s_lastMsmtTime.indexOf(" ")+1);
					Vector vec_times=egDashboard.getTokensAsVector(s_timeonly,":");
					startHour=Integer.parseInt((String)vec_times.get(0));
					endHour=Integer.parseInt((String)vec_times.get(0));
					startMin=Integer.parseInt((String)vec_times.get(1));
					endMin=Integer.parseInt((String)vec_times.get(1));
					if(endMin>=59)
					{
						endMin=0;
						endHour++;
					}
					else
					{
						endMin++;
					}
				}
			}
		}

		if(blockType!=null && (blockType.equals("KPI") || blockType.equals("comparisontable")))
		{
			JSONObject kPiObj = new JSONObject();
			String subject=request.getParameter("subject");
			String defaultMGraphDuration=request.getParameter("defaultMGraphDuration");
			String defaultSparklineDuration=request.getParameter("defaultSparklineDuration");
			String divCount=request.getParameter("divCount");
			String tab=request.getParameter("tab");
			String tableIdx=request.getParameter("tableIdx");
			String kpiFullViewURL=response.encodeURL("/final/monitor/egCustomDashboardp.jsp")+"?"+"compName="+EgURLEncoder.encode(hostName,"UTF-8")+"&compType="+compType+"&subject="+EgURLEncoder.encode(subject,"UTF-8")+"&site="+site+"&tab="+tab+"&defaultMGraphDuration="+defaultMGraphDuration+"&defaultSparklineDuration="+defaultSparklineDuration+"&divCount="+divCount+"&blockType="+blockType+"&tableIdx="+tableIdx;
			String backBlockTypeDisplayStr=egMappingInfo.getTextDescription("monitor.dashboard.Back To "+blockType);
			if(blockType!=null && blockType.equals("comparisontable"))
			{
				backBlockTypeDisplayStr=egMappingInfo.getTextDescription("monitor.dashboard.Back To ComparisonTable");
			}
			kPiObj.put("METHOD","showMaximizedView|event");
			kPiObj.put("fullViewUrl",kpiFullViewURL);
			kPiObj.put("displayString",backBlockTypeDisplayStr);
			kPiObj.put("img_src","/final/monitor/eg_images/back-arrow.gif");
			rootJSON.put("kPiObj",kPiObj);
		}
		else
		{

		}
		graphObj.put("minimizeIcon","/final/monitor/eg_images/"+monitor_Skin+"/icon_minimize_div.png");
		graphObj.put("method_name","zoomClose|true");
		graphObj.put("customTopRightIcon","/final/monitor/eg_images/"+monitor_Skin+"/custom_topright_bg.gif");

		if(graphType!=null && !graphType.equalsIgnoreCase("areaChart"))
		{

		}
		else if(graphType!=null && graphType.equalsIgnoreCase("areaChart"))
		{
			graphHeight = graphHeight + 30;
		}
		if((graphType!=null) && (graphType.equalsIgnoreCase("comparisionBargraph") || graphType.equalsIgnoreCase("ddGraph")))
		{
			JSONObject barGraphObj = new JSONObject();
			JSONArray barGraphArray = new JSONArray();
			barGraphObj.put("monitor.common.Show",egMappingInfo.getTextDescription("monitor.common.Show"));
			for( int i=0;i<v_priority.size();i++)
			{
				String pri_value = (String)v_priority.get(i);
				JSONObject showCombo = new JSONObject();
				showCombo.put("displayField",egMappingInfo.getTextDescription("monitor.common."+pri_value));
				showCombo.put("valueField",pri_value);
				barGraphArray.add(showCombo);
			}
			barGraphObj.put("selectedShowCombo",priority);
			barGraphObj.put("barGraphShowCombo",barGraphArray);

			//mode combo
			JSONObject modeComboObj = new JSONObject();
			JSONArray modeComboArr = new JSONArray();			
			//if(mode!=null && mode.equalsIgnoreCase("3d"))
			//{				
			//	barGraphObj.put("selectedMode","3D");
			//}
			//else
			//{				
				barGraphObj.put("selectedMode","2D");
			//}
			modeComboObj.put("displayField",egMappingInfo.getTextDescription("monitor.common.2D"));
			modeComboObj.put("valueField","2D");
			modeComboArr.add(modeComboObj);
			modeComboObj.put("displayField",egMappingInfo.getTextDescription("monitor.common.3D"));
			modeComboObj.put("valueField","3D");
			modeComboArr.add(modeComboObj);

			barGraphObj.put("barModeCombo",modeComboArr);
			barGraphObj.put("monitor.measure.History",egMappingInfo.getTextDescription("monitor.measure.History"));
			rootJSON.put("BARGRAPH",barGraphObj);
		}
		else
		{

		}
		if((graphType!=null) && (graphType.equalsIgnoreCase("Trendgraph") || graphType.equalsIgnoreCase("Summarygraph")))
		{
			JSONObject trendGrpDuration = new JSONObject();
			JSONArray trendGrpDurationArr = new JSONArray();
			JSONObject durationCombo = new JSONObject();
			trendGrpDuration.put("monitor.dashboard.Duration",egMappingInfo.getTextDescription("monitor.dashboard.Duration"));
			
			String hourly="";
			String daily="";
			String monthly="";

			if(duration!=null && duration.equalsIgnoreCase("H"))
				hourly="selected";

			if(duration!=null && duration.equalsIgnoreCase("D"))
				daily="selected";

			if(duration!=null && duration.equalsIgnoreCase("M"))
				monthly="selected";

			durationCombo.put("displayField",egMappingInfo.getTextDescription("monitor.common.Hourly"));
			durationCombo.put("valueField","H");
			trendGrpDurationArr.add(durationCombo);

			durationCombo.put("displayField",egMappingInfo.getTextDescription("monitor.common.Daily"));
			durationCombo.put("valueField","D");
			trendGrpDurationArr.add(durationCombo);

			durationCombo.put("displayField",egMappingInfo.getTextDescription("monitor.common.Monthly"));
			durationCombo.put("valueField","M");
			trendGrpDurationArr.add(durationCombo);

			trendGrpDuration.put("selectedDuration",duration);
			trendGrpDuration.put("trendGrpDurationArr",trendGrpDurationArr);
			rootJSON.put("trendGrpDuration",trendGrpDuration);
			//graphFilters.add(trendGrpDuration);
		}
		//timeline
		JSONObject timelineObj = new JSONObject();
		JSONArray timelineArray = new JSONArray();
		timelineObj.put("monitor.dashboard.TimeLine",egMappingInfo.getTextDescription("monitor.dashboard.TimeLine"));
		timelineObj.put("method","timelineOnchange");
		String DefaultTimeDuration=iniObj.getValue("Default_DashboardGraph_Duration", "duration");
		for(int e_ctr=0; e_ctr < options.length;e_ctr++)
		{
			JSONObject timelineCombo = new JSONObject();
			if(timeline!=null&&timeline.equals((String)options[e_ctr]))
			{
				String tempOptions="";
				String tempOptions2="";

				if(timeline.indexOf(" ")>-1)
				{
					tempOptions2=timeline.substring(0,timeline.indexOf(" "))+" ";
					tempOptions=timeline.substring(timeline.indexOf(" ")+1);
				}
				else
				{
					tempOptions=timeline;
				}
				timelineCombo.put("displayField",tempOptions2+egMappingInfo.getTextDescription("monitor.common."+tempOptions));
				timelineCombo.put("valueField",timeline);
				timelineObj.put("selectedTimelineCombo",timeline);
				timelineArray.add(timelineCombo);
				if(options[e_ctr].equalsIgnoreCase(DefaultTimeDuration) && graphType!=null && graphType.equalsIgnoreCase("Measuregraph"))
				{
					break;
				}
				
			}
			else
			{
				String tempOptions="";
				String tempOptions2="";

				if(options[e_ctr].indexOf(" ")>-1)
				{
					tempOptions2=options[e_ctr].substring(0,options[e_ctr].indexOf(" "))+" "; tempOptions=options[e_ctr].substring(options[e_ctr].indexOf(" ")+1);
				}
				else
				{
					tempOptions=options[e_ctr];
				}
				timelineCombo.put("displayField",tempOptions2+egMappingInfo.getTextDescription("monitor.common."+tempOptions));
				timelineCombo.put("valueField",options[e_ctr]);
				//timelineObj.put("selectedTimelineCombo",tempOptions2);
				timelineArray.add(timelineCombo);
				if(options[e_ctr].equalsIgnoreCase(DefaultTimeDuration) && graphType!=null && graphType.equalsIgnoreCase("Measuregraph") )
				{
					break;
				}
			}
			
		}
		timelineObj.put("timelineCombo",timelineArray);
		rootJSON.put("timelineCombo",timelineObj);
		
		JSONObject fromObj = new JSONObject();
		fromObj.put("monitor.VirtualDashboard.From",egMappingInfo.getTextDescription("monitor.VirtualDashboard.From"));
		fromObj.put("calenderImg_src","/final/monitor/eg_images/calendar.gif");
		if(timeline!=null && timeline.equalsIgnoreCase("any"))
		{
			fromObj.put("from","enabled");
		}
		else
		{
			fromObj.put("from","disabled");
		}		
		try
		{
			if(startDate!=null && !startDate.equals(""))
			{
				if(DateUtil.isDate(startDate,"MM/dd/yyyy"))
				{
					comFormat = "MM/dd/yyyy";
				}
				else
				{
					comFormat = currentDateFormat;
				}
				dispDate = DateUtil.changeDateFormat(startDate,comFormat,currentDateFormat);
			}
			else
			{
				dispDate = "";
			}
		}
		catch(Exception ex)
		{
			out.println("ex..."+ex);
		}
		//from text Field	
		fromObj.put("type","textField");
		fromObj.put("value",dispDate);
		fromObj.put("readonly",disable);
		fromObj.put("hidden",startDate);
		rootJSON.put("fromValues",fromObj);

		//start hr combo
		JSONObject startHrObj = new JSONObject();
		JSONArray startHrArray = new JSONArray();
		startHrObj.put("monitor.VirtualDashboard.Hr",egMappingInfo.getTextDescription("monitor.VirtualDashboard.Hr"));
		startHrObj.put("isStartHrEnabled",disable);

		for(int s_ctr = 0; s_ctr < 24; s_ctr++)
		{
			JSONObject startHrcombo = new JSONObject();
			startHrcombo.put("displayField",s_ctr);
			startHrcombo.put("valueField",s_ctr);
			if(s_ctr == startHour)
			{
				startHrObj.put("selectedStartHr",s_ctr);
			}
			startHrArray.add(startHrcombo);
		}
		startHrObj.put("startHrArray",startHrArray);
		rootJSON.put("startHr",startHrObj);

		//to combo
		JSONObject toObj = new JSONObject();
		toObj.put("toDatePickerSrc","/final/monitor/eg_images/calendar.gif");
		toObj.put("monitor.VirtualDashboard.To",egMappingInfo.getTextDescription("monitor.VirtualDashboard.To"));
		if(timeline!=null && timeline.equalsIgnoreCase("any"))
		{
			toObj.put("to","enabled");			
		}
		else
		{
			toObj.put("to","disabled");	
		}
		try
		{
			if(endDate!=null && !endDate.equals(""))
			{
				if(DateUtil.isDate(endDate,"MM/dd/yyyy"))
				{
					comFormat = "MM/dd/yyyy";
				}
				else
				{
					comFormat = currentDateFormat;
				}				
				dispDate = DateUtil.changeDateFormat(endDate,comFormat,currentDateFormat);
			}
			else
			{
				dispDate = "";
			}
		}
		catch(Exception ex)
		{
			out.println("exception......"+ex);
		}
		//to text field		
		toObj.put("type","textField");
		toObj.put("value",dispDate);
		toObj.put("readonly",disable);
		toObj.put("hidden",endDate);
		rootJSON.put("toValues",toObj);
		
		//end hr combo
		JSONObject endHrObj = new JSONObject();
		JSONArray endHrArray = new JSONArray();
		endHrObj.put("monitor.VirtualDashboard.Hr",egMappingInfo.getTextDescription("monitor.VirtualDashboard.Hr"));
		endHrObj.put("isEndHrEnabled",disable);

		for(int e_ctr = 0; e_ctr < 24; e_ctr++)
		{
			JSONObject endHrCombo = new JSONObject();
			endHrCombo.put("displayField",e_ctr);
			endHrCombo.put("valueField",e_ctr);
			if(e_ctr == endHour)
			{
				endHrObj.put("selectedEndHr",e_ctr);
			}
			endHrArray.add(endHrCombo);
		}
		endHrObj.put("endHrArray",endHrArray);
		rootJSON.put("endHr",endHrObj);

		//Image if  timeline is any
		JSONObject anyImage = new JSONObject();
		if(timeline != null && timeline.equals("Any"))
		{
			anyImage.put("type","image");
			anyImage.put("imageSrc","/final/admin/eg_images/"+monitor_Skin+"/arrow_1.gif");
			rootJSON.put("anyImage",anyImage);
		}
		if(graphType!=null && !(graphType.equalsIgnoreCase("comparisionBargraph") || graphType.equalsIgnoreCase("ddGraph")))
		{
			JSONObject comparisonBarModeCombo = new JSONObject();
			JSONObject comparisonBarModeObj = new JSONObject();
			JSONArray comparisonBarModeArr = new JSONArray();

			comparisonBarModeCombo.put("displayField",egMappingInfo.getTextDescription("monitor.common.2D"));
			comparisonBarModeCombo.put("valueField","2D");
			comparisonBarModeArr.add(comparisonBarModeCombo);
			comparisonBarModeCombo.put("displayField",egMappingInfo.getTextDescription("monitor.common.3D"));
			comparisonBarModeCombo.put("valueField","3D");
			comparisonBarModeArr.add(comparisonBarModeCombo);

			//if(mode!=null && mode.equalsIgnoreCase("3d"))
			//{
			//	comparisonBarModeObj.put("selectedMode","3D");
			//}
			//else
			//{
				comparisonBarModeObj.put("selectedMode","2D");
			//}
			comparisonBarModeObj.put("comparisonBarModeArr",comparisonBarModeArr);
			//graphFilters.add(comparisonBarModeObj);
			rootJSON.put("ModeCombo",comparisonBarModeObj);
		}
		if(graphType!=null && graphType.equalsIgnoreCase("Measuregraph") && isShowTopAnalysisRequired)
		{
			JSONObject measureGraphObj = new JSONObject();
			JSONArray measureGraphArr = new JSONArray();
			measureGraphObj.put("monitor.common.Show",egMappingInfo.getTextDescription("monitor.common.Show"));
			for( int j=0;j<v_priority.size();j++)
			{
				JSONObject measureCmbo = new JSONObject();
				String p_val = (String)v_priority.get(j);
				measureCmbo.put("displayField",egMappingInfo.getTextDescription("monitor.common."+p_val));
				measureCmbo.put("valueField",p_val);
				measureGraphArr.add(measureCmbo);
			}
			measureGraphObj.put("selectedMeasureGrpCombo",priority);
			measureGraphObj.put("measureGraphCombo",measureGraphArr);
			//graphFilters.add(measureGraphObj);
			rootJSON.put("measureGraphObj",measureGraphObj);
		}
		else if(graphType!=null && graphType.equalsIgnoreCase("DDOverviewGraph"))
		{
			JSONObject ddOverviewObj = new JSONObject();
			JSONArray ddOverviewArray = new JSONArray();
			ddOverviewObj.put("monitor.common.Show",egMappingInfo.getTextDescription("monitor.common.Show"));

			for( int k=0;k<v_priority.size();k++)
			{
				JSONObject ddOverviewCombo = new JSONObject();
				String p_val = (String)v_priority.get(k);
				ddOverviewCombo.put("displayField",egMappingInfo.getTextDescription("monitor.common."+p_val));
				ddOverviewCombo.put("valueField",p_val);
				ddOverviewArray.add(ddOverviewCombo);
			}
			ddOverviewObj.put("selectedDDOverviewCmbo",priority);
			ddOverviewObj.put("DDOverviewGraph",ddOverviewArray);
			//graphFilters.add(ddOverviewObj);
			rootJSON.put("ddOverviewObj",ddOverviewObj);
		}
		if((graphType!=null) && (graphType.equalsIgnoreCase("ddGraph") ||  graphType.equalsIgnoreCase("DDOverviewGraph")))
		{
			JSONObject ddGraphObj = new JSONObject();
			String ddTooltip=egMappingInfo.getTextDescription("monitor.common.DIAGNOSIS");
			ddGraphObj.put("DetailsLink","true");
			ddGraphObj.put("DetailsLabel",egMappingInfo.getTextDescription("monitor.common.Details"));
			ddGraphObj.put("METHOD","DDDataOnClick");
			//graphFilters.add(ddGraphObj);
			rootJSON.put("ddGraphObj",ddGraphObj);
		}
		if(graphType!=null && graphType.equalsIgnoreCase("Trendgraph"))
		{
			JSONObject trendObj = new JSONObject();
			JSONArray trendArr = new JSONArray();
			JSONObject graphCmbo = new JSONObject();
			trendObj.put("monitor.dashboard.Graph",egMappingInfo.getTextDescription("monitor.dashboard.Graph"));
			String minmax="";
			String avg="";
			String sum="";
			String selectedGraph = "";
			if(trendType!=null && trendType.equalsIgnoreCase("avg"))
			{
				avg="selected";
				selectedGraph = "avg";
			}
			else if(trendType!=null && trendType.equalsIgnoreCase("sum"))
			{
				sum="selected";
				selectedGraph = "sum";
			}
			else
			{
				minmax="selected";
				selectedGraph = "min/max";
			}

			graphCmbo.put("displayField",egMappingInfo.getTextDescription("monitor.dashboard.Min")+"/"+egMappingInfo.getTextDescription("monitor.dashboard.Max"));
			graphCmbo.put("valueField","min/max");
			trendArr.add(graphCmbo);

			graphCmbo.put("displayField",egMappingInfo.getTextDescription("monitor.dashboard.Avg"));
			graphCmbo.put("valueField","avg");
			trendArr.add(graphCmbo);

			graphCmbo.put("displayField",egMappingInfo.getTextDescription("monitor.dashboard.Sum"));
			graphCmbo.put("valueField","sum");
			trendArr.add(graphCmbo);

			trendObj.put("selectedGraph",selectedGraph);
			trendObj.put("trendGraph",trendArr);
			//graphFilters.add(trendObj);
			rootJSON.put("GraphCombo",trendObj);
		}
		
		

		String fullviewGraphUrl="";
		String fullviewDataUrl="";
		if(come_from_vmware && graphType!=null && graphType.equalsIgnoreCase("Measuregraph"))
		{
			String layer_name=request.getParameter("layer");
			if(info!=null && (info.equalsIgnoreCase("*") || info.equalsIgnoreCase("+*") || info.equalsIgnoreCase("+")))
				info="";
			fullviewGraphUrl=response.encodeURL("/final/servlet/com.egurkha.VmwareTimelineMeasures?")+"endtime="+endDate+"&port="+portNo+"&site="+site+"&sid=&starttime="+startDate+"&host="+EgURLEncoder.encode(compName,"UTF-8")+"&measure="+measure+"&newWindow=true&test="+test+"&layer="+layer_name+"&comptype="+compType+"&from=MonitorDashboard&endhr="+endHour+"&gtype=1&mode="+mode+"&starthr="+startHour+"&msmt_host="+msmtHost+"&gformat=graph&monitorSkin="+monitor_Skin+"&scrW=880&scrH=320&legends=true&fromDashboard=true&title=true&priority="+priority+"&threshold=no&minmaxavgRequired=true&info="+info+"&from_page="+from_page+Qstring;
			fullviewDataUrl="EgMeasureGraphData.jsp?endtime="+endDate+"&port="+portNo+"&site="+site+"&sid=&starttime="+startDate+"&host="+EgURLEncoder.encode(compName,"UTF-8")+"&measure="+measure+"&newWindow=true&test="+test+"&layer="+layer_name+"&comptype="+compType+"&from=MonitorDashboard&endhr="+endHour+"&gtype=1&mode="+mode+"&starthr="+startHour+"&msmt_host="+msmtHost+"&gformat=graph&monitorSkin="+monitor_Skin+"&width="+graphWidth+"&height="+(graphHeight-40)+"&legends=true&fromDashboard=true&title=true&priority="+priority+"&threshold=no&minmaxavgRequired=true&info="+info+"&from_page="+from_page+Qstring;
		}
		else
		{
			if(allTestInfos!=null && allTestInfos.containsKey(test))
			{
				Vector allInfos=(Vector)allTestInfos.get(test);
				if(priority!=null && priority.equalsIgnoreCase("all") && allInfos!=null && allInfos.size()>0)
					priority="ALL";
				//else if(priority!=null && priority.equalsIgnoreCase("all") && allInfos!=null && allInfos.size()>0)
					//priority="TOP+-+"+allInfos.size();
			}
			fullviewGraphUrl=response.encodeURL("/final/servlet/com.egurkha.monitor.EgDashboardTimelineMeasures?")+"endtime="+endDate+"&port="+portNo+"&site="+site+"&sid="+sid+"&starttime="+startDate+"&host="+EgURLEncoder.encode(compName,"UTF-8")+"&measure="+measure+"&newWindow=true&test="+test+"&layer="+s_layerName+"&comptype="+compType+"&from=MonitorDashboard&endhr="+endHour+"&gtype=1&mode="+mode+"&starthr="+startHour+"&gformat=graph&monitorSkin="+monitor_Skin+"&width="+graphWidth+"&height="+(graphHeight-40)+"&legends=false&fromDashboard=true&title=true&priority="+priority+"&threshold=no&minmaxavgRequired=true&from_page="+from_page+"&isInfoReleventGraph=false&fullView=true&timeLine="+timeline;
			String qStrForSession="/final/monitor/egDashTimelineJSON.jsp?isFullView=true&endtime="+s_endtime+"&port="+portNo+"&site=NULL&sid="+sid+"&starttime="+s_starttime+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&measure="+measure+"&newWindow=true&test="+test+"&layer="+s_layerName+"&comptype="+compType+"&from=MonitorDashboard&endhr="+s_endhr+"&gtype=1&mode=2D&starthr="+s_starthr+"&gformat=graph&monitorSkin="+monitor_Skin+"&width=880&height=320&legends=false&fromDashboard=true&timeline_compare="+timeline+"&title=true&priority="+priority+"&threshold=no&minmaxavgRequired=true&isInfoReleventGraph=false&fullView=true&module="+module+"&graphType="+graphType+"&timeLine="+timeline;
			if(msmtHost!=null)
			{
				fullviewGraphUrl=fullviewGraphUrl+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8");
				qStrForSession=qStrForSession+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8");
			}
			if(!StringUtils.isNull(info))//added by jamesthomas
			{
				fullviewGraphUrl += "&info="+EgURLEncoder.encode(info,"UTF-8");
				qStrForSession=qStrForSession+"&info="+EgURLEncoder.encode(info,"UTF-8");
			}

			if(session!=null)
				session.setAttribute("lastFullViewURLForDashboard",qStrForSession);

		}
		if(graphType!=null && graphType.equalsIgnoreCase("analysisMeasuregraph"))
		{
			fullviewGraphUrl=response.encodeURL("/final/servlet/com.egurkha.monitor.EgDashboardTimelineMeasures?")+"endtime="+endDate+"&port=NULL&site="+site+"&sid="+sid+"&starttime="+startDate+"&host="+EgURLEncoder.encode(compName,"UTF-8")+"&measure="+measure+"&newWindow=true&test="+test+"&layer="+s_layerName+"&comptype="+compType+"&from=MonitorDashboard&endhr="+endHour+"&gtype=1&mode="+mode+"&starthr="+startHour+"&msmt_host="+msmtHost+"&gformat=graph&monitorSkin="+monitor_Skin+"&width="+graphWidth+"&height="+(graphHeight-40)+"&legends=false&fromDashboard=true&title=true&priority="+priority+"&threshold=no&minmaxavgRequired=true&info="+info+"&from_page="+from_page+"&isInfoReleventGraph=false&fullView=true";
		}
		else if(graphType!=null && graphType.equalsIgnoreCase("analysisBargraph"))
		{
			fullviewGraphUrl=response.encodeURL("/final/servlet/com.egurkha.monitor.EgDDTopview?")+"host="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&test="+test+"&measure="+measure+"&module="+module+"&width="+graphWidth+"&height="+(graphHeight-40)+"&from=fullview&mode="+mode+"&monitorSkin="+monitor_Skin+"&graphdisplay=defaultView&fullview=true&msmt_host="+msmtHost+"&port="+request.getParameter("port")+"&isFromAnalysis=true&layer="+request.getParameter("layer")+"&starttime="+startDate+"&starthr="+startHour+"&startmin="+today.getMinutes()+"&endtime="+endDate+"&endhr="+endHour+"&priority=4&endmin="+today.getMinutes()+"&timeline="+timeline+"&displayName="+displayName+"&real_measure="+real_measure+"&info="+info+"&isInfoSelected="+request.getParameter("isInfoSelected")+"&priority="+priority;
		}
		else if(graphType!=null && graphType.equalsIgnoreCase("comparisionBargraph"))
		{
			String samplevalues=request.getParameter("samplevalues");
			String samplelabels=request.getParameter("samplelabels");
			String testmeasure=request.getParameter("testmeasure");
			String tempMeasure="";
			String portFormsmtHost=portNo;
			String msmt_Host="";
			boolean isTestHas_CutOffFactor=true;
			if(testmeasure!=null && testmeasure.indexOf(":")!=-1)
			{
				test=testmeasure.substring(0,testmeasure.indexOf(":"));
				tempMeasure=testmeasure.substring(testmeasure.indexOf(":")+1);
			}

			if(timeline==null || !timeline.equalsIgnoreCase("any"))
			{
				endDateTime = dateFormatWithTime.format(today);
				startDateTime = dateFormatWithTime.format(start);
			}
			if(sid!=null && !sid.equals(""))
			{
				portFormsmtHost=portNo+":"+sid;
			}
			else
				sid="";
			String measureMapping=iniObj.getValue("Dashboard_ComparisonGraph_Mapping",testmeasure);
			String temp_port=portNo+":"+sid;
			String host=hostName.substring(0,hostName.indexOf(":"));
			if(measureMapping==null || measureMapping.equals(""))
				measureMapping=egMappingInfo.getMeasureDescription(test,tempMeasure);
			Vector msmt_for_cutOffFactor=dashboardDAO.getMsmtHost(host,compType,test,portFormsmtHost);
			if(msmt_for_cutOffFactor!=null && !msmt_for_cutOffFactor.isEmpty())
				msmt_Host=(String)msmt_for_cutOffFactor.get(0);
			Vector infos_for_cutOffFactor=dashboardDAO.getDescriptorsForTest(hostName,compType,test,module);
			unit=tablesInfo.getUnitForMeasure(test,tempMeasure);
			if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
			{
				if(egDashboard.isTestHasCutOffFactor(test))
				{
					if(infos_for_cutOffFactor!=null && !infos_for_cutOffFactor.isEmpty())
					{
						for(int d=0;d<infos_for_cutOffFactor.size();d++)
						{
							boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,host,portNo,sid,test,msmt_Host,(String)infos_for_cutOffFactor.get(d));
							if(!isTestExceededCutOffFactor)
								isTestHas_CutOffFactor=false;

						}
					}
				}
			}
			if(isTimeLineChange!=null && isTimeLineChange.equalsIgnoreCase("Yes"))
				isTestHas_CutOffFactor=false;
			Vector comparionChartAttribute=new Vector();
			//comparionChartAttribute.add("caption='"+EgURLEncoder.encode(measureMapping+"("+unit+")","UTF-8")+"'");
			comparionChartAttribute.add("caption='"+measureMapping+"("+unit+")'");
			comparionChartAttribute.add("palette='2'");
			comparionChartAttribute.add("showValues='1'");
			comparionChartAttribute.add("showLabels='1'");
			comparionChartAttribute.add("showYAxisValues='0'");
			if((compType!=null && compType.equals("Java_virtual_machine"))&& (subsystem!=null && subsystem.equals("JVM Memory")))
			{
				comparionChartAttribute.add("decimals='2'");
			}
			else
			{
				comparionChartAttribute.add("decimals='4'");
			}
			comparionChartAttribute.add("formatNumberScale='0'");
			comparionChartAttribute.add("useRoundEdges='1'");
		//	comparionChartAttribute.add("clickURL='javascript:bigGraphOnClick()'");
			comparionChartAttribute.add("numDivLines='4'");
			comparionChartAttribute.add("bgColor='ffffff'");
			comparionChartAttribute.add("showToolTipShadow='1'");	
			comparionChartAttribute.add("chartLeftMargin='8'");
			comparionChartAttribute.add("chartRightMargin='8'");
			comparionChartAttribute.add("chartTopMargin='8'");
			comparionChartAttribute.add("chartBottomMargin='8'");
			comparionChartAttribute.add("exportEnabled='0'");
			comparionChartAttribute.add("exportAction='download'");
			comparionChartAttribute.add("exportAtClient='0'");
			comparionChartAttribute.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
			if(!isNonEnglishLanguage)
			{
				comparionChartAttribute.add("outCnvBaseFontSize ='"+fontSize+"'");
				comparionChartAttribute.add("outCnvBaseFontColor ='000000'");
			}
			comparionChartAttribute.add("showBorder ='0'");
			comparionChartAttribute.add("canvasBorderColor  ='000000'");
			comparionChartAttribute.add("plotSpacePercent  ='40'");
			comparionChartAttribute.add("baseFont  ='"+fontForLanguage+"'");
			comparionChartAttribute.add("adjustDiv='0'");
			comparionChartAttribute.add("yAxisValueDecimals='2'");

			String xmlData="";
			String port_no=portNo;	
			if(compType!=null && compType.equals("Oracle_server"))
			{
				if(specsInfo.isPortRelevantForTest(test))
				{
					if(sid!=null && !sid.equals(""))
					{
							port_no=portNo+":"+sid;
					}
				}
			}
			String qStrForSession="/final/monitor/egDashTimelineJSON.jsp?isFullView=true&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&compType="+compType+"&width=301&height=183&monitorSkin="+monitor_Skin+"&mode=2D&graphdisplay=defaultView&test="+test+"&testmeasure="+testmeasure+"&minmaxavgRequired=false&timeline_compare="+timeline+"&priority="+priority+"&isInfoRelevantMeasureGraph=true&starttime="+s_starttime+"&endtime="+s_endtime+"&starthr="+s_starthr+"&endhr="+s_endhr+"&subsystem="+subsystem+"&graphType="+graphType+"&display=false&fromHist=true&module="+module+"&isTimeLineChange="+isTimeLineChange;

			if(isTimeLineChange!=null && isTimeLineChange.equalsIgnoreCase("yes"))
			{
				qStrForSession=qStrForSession+"&timelineChangedForCompGraph=true";
			}

			if(session!=null)
				session.setAttribute("lastFullViewURLForDashboard",qStrForSession);

			if(fromHist!=null && fromHist.equalsIgnoreCase("true")) 
			{
				xmlData=graphUtil.getXMLForComparision(compType,compName,port_no,testmeasure,"","",priority,true,comparionChartAttribute,measureMapping+"("+unit+")",true);
			}
			else
			{
				xmlData=graphUtil.getXMLForComparision(compType,compName,port_no,testmeasure,startDateTime,endDateTime,priority,false,comparionChartAttribute,measureMapping+"("+unit+")",true);
			}
			JSONObject comparisionBargraphObj = new JSONObject();
			if(xmlData!=null && !xmlData.trim().equals("") && !isTestHas_CutOffFactor)
			{
				comparisionBargraphObj.put("DATA","true");
				comparisionBargraphObj.put("SWF_PATH","/final/FusionCharts/swf/Bar2D.swf");
				comparisionBargraphObj.put("WIDTH",graphWidth);
				comparisionBargraphObj.put("HEIGHT",graphHeight);
				comparisionBargraphObj.put("XMLDATA",xmlData);			
			}
			else
			{
				comparisionBargraphObj.put("DATA","false");
				comparisionBargraphObj.put("MSG",egMappingInfo.getTextDescription("monitor.common.No detailed measures available")+"!");
				comparisionBargraphObj.put("METHOD","bigGraphOnClick");
			}
			//graphFilters.add(comparisionBargraphObj);
			rootJSON.put("FullViewXmlData",comparisionBargraphObj);
		}
		else if(graphType!=null && graphType.equalsIgnoreCase("ddGraph"))
		{
			JSONObject ddGraphXmlObj = new JSONObject();
			String ddTitle=iniObj.getValue("Dashboard_ComparisonGraph_Mapping",test+":"+measure+"#"+format);
			if(isTimeLineChange==null || isTimeLineChange.equals(""))
				ddTitle="Current "+ddTitle;
			Vector ddChartAttribute=new Vector();
			//ddChartAttribute.add("caption='"+EgURLEncoder.encode(ddTitle,"UTF-8")+"'");
			ddChartAttribute.add("caption='"+ddTitle+"'");
			ddChartAttribute.add("palette='2'");
			ddChartAttribute.add("showValues='1'");
			ddChartAttribute.add("showLabels='1'");
			ddChartAttribute.add("showYAxisValues='0'");
			ddChartAttribute.add("decimals='4'");
			ddChartAttribute.add("formatNumberScale='0'");
			ddChartAttribute.add("useRoundEdges='1'");
			ddChartAttribute.add("exportEnabled='0'");
			ddChartAttribute.add("showExportDialog='1'");
			ddChartAttribute.add("exportAction='save'");
			ddChartAttribute.add("exportTargetWindow='1'");
		//	ddChartAttribute.add("clickURL='javascript:bigGraphOnClick()'");
			ddChartAttribute.add("yAxisValueDecimals='2'");
			ddChartAttribute.add("numDivLines='4'");
			ddChartAttribute.add("bgColor='ffffff'");
			ddChartAttribute.add("showToolTipShadow='1'");	
			ddChartAttribute.add("chartLeftMargin='8'");
			ddChartAttribute.add("chartRightMargin='8'");
			ddChartAttribute.add("chartTopMargin='8'");
			ddChartAttribute.add("chartBottomMargin='8'");
			ddChartAttribute.add("exportAtClient='0'");
			ddChartAttribute.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
			ddChartAttribute.add("showBorder ='0'");
			ddChartAttribute.add("canvasBorderColor  ='000000'");
			ddChartAttribute.add("plotSpacePercent  ='40'");
			ddChartAttribute.add("baseFont='"+fontForLanguage+"'");
			ddChartAttribute.add("adjustDiv='0'");
			if(!isNonEnglishLanguage)
			{
				ddChartAttribute.add("outCnvBaseFontSize ='"+fontSize+"'");
				ddChartAttribute.add("outCnvBaseFontColor ='000000'");
			}

			String qStrForSession="/final/monitor/egDashTimelineJSON.jsp?isFullView=true&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&compType="+compType+"&test="+test+"&measure="+measure+"&format="+encodedFormat+"&module="+module+"&width=880&height=320&from=fullview&endtime="+s_endtime+"&starthr="+s_starthr+"&endhr="+s_endhr+"&starttime="+s_starttime+"&mode=2D&timeline_compare="+timeline+"&monitorSkin="+monitor_Skin+"&showDDData=true&fullview=true&priority="+priority+"&isInfoRelevantMeasureGraph=true&display=false&fromHist=true&isTimeLineChange="+isTimeLineChange+"&graphType="+graphType;

			if(isTimeLineChange!=null && isTimeLineChange.equalsIgnoreCase("yes"))
			{
				qStrForSession=qStrForSession+"&timelineChangedForCompGraph=true";
			}

			if(session!=null)
				session.setAttribute("lastFullViewURLForDashboard",qStrForSession);
			String ddXMLData=graphUtil.getXMLforDD(module,hostName,compType,test,measure,startDate,startHour+"",startMin+"",endDate,endHour+"",endMin+"",format,null,true,priority,ddChartAttribute,ddTitle);
			//ddXMLData=com.egurkha.util.StringUtils.replace(ddXMLData,"\"","");
				if(ddXMLData!=null && !ddXMLData.trim().equals(""))
			{
				ddGraphXmlObj.put("DATA","true");
				ddGraphXmlObj.put("SWF_PATH","/final/FusionCharts/swf/Bar2D.swf");
				ddGraphXmlObj.put("WIDTH",graphWidth);
				ddGraphXmlObj.put("HEIGHT",graphHeight);
				ddGraphXmlObj.put("XMLDATA",ddXMLData);
			}
			else
			{
				ddGraphXmlObj.put("DATA","false");
				ddGraphXmlObj.put("MSG",egMappingInfo.getTextDescription("monitor.common.No detailed measures available")+"!");
				ddGraphXmlObj.put("METHOD","bigGraphOnClick");
				ddGraphXmlObj.put("ddTitle",ddTitle);
			}
			//graphFilters.add(ddGraphXmlObj);
			rootJSON.put("FullViewXmlData",ddGraphXmlObj);
		}
		else if(graphType!=null && graphType.equalsIgnoreCase("Summarygraph"))
		{
			JSONObject summaryGraphXmlObj = new JSONObject();
			String qStrForSession="/final/monitor/egDashTimelineJSON.jsp?isFullView=true&endtime="+s_endtime+"&port="+portNo+"&site=NULL&starttime="+s_starttime+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&measure="+measure+"&test="+test+"&state=GOOD&layer="+s_layerName+"&comptype="+compType+"&period=H&endhr="+s_endhr+"&gtype=1&mode=2D&info="+info+"&starthr="+s_starthr+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&monitorSkin="+monitor_Skin+"&period=H&width="+graphWidth+"&height="+graphHeight+"&timeline_compare="+timeline+"&fullview=true&isInfoReleventGraph=false&userLanguage="+trackerLanguage+"&module="+module+"&graphType=Summarygraph";

			if(session!=null)
				session.setAttribute("lastFullViewURLForDashboard",qStrForSession);

			Vector chartAttribute=new Vector();
			chartAttribute.add("palette='2'");
			chartAttribute.add("showValues='0'");
			chartAttribute.add("useRoundEdges='1'");
			chartAttribute.add("exportEnabled='0'");
			chartAttribute.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
			chartAttribute.add("showExportDialog='1'");
			chartAttribute.add("exportAction='download'");
			chartAttribute.add("exportTargetWindow='1'");
			chartAttribute.add("showShadow='1'");
			chartAttribute.add("showLegend='1'");
			//chartAttribute.add("showFCMenuItem='0'");
			chartAttribute.add("showToolTipShadow='1'");
			chartAttribute.add("chartLeftMargin='2'");
			chartAttribute.add("chartRightMargin='7'");
			chartAttribute.add("chartTopMargin='10'");
			chartAttribute.add("chartBottomMargin='3'");
			chartAttribute.add("yAxisValuesPadding='1'");
			chartAttribute.add("xAxisNamePadding='1'");
			chartAttribute.add("labelPadding='1'");
			chartAttribute.add("canvasPadding='10'");
			chartAttribute.add("showFCMenuItem='0'");
			chartAttribute.add("labelStep='2'");
			//chartAttribute.add("baseFontColor ='000000'");
			chartAttribute.add("canvasLeftMargin='5'");
			chartAttribute.add("canvasRightMargin='3'");
			chartAttribute.add("canvasTopMargin='5'");
			chartAttribute.add("canvasBottomMargin='3'");
			chartAttribute.add("showBorder='0'");
			//chartAttribute.add("baseFont='"+fontForLanguage+"'"); 
			chartAttribute.add("showAboutMenuItem='1' aboutMenuItemLabel='About eG Innovations' aboutMenuItemLink='n-http://www.eginnovations.com'");
		//	chartAttribute.add("clickURL='javascript:bigGraphOnClick()'");

			EgSummaryChartUtil summaryChart=new EgSummaryChartUtil();

			String flashFile="";
			if(mode!=null && mode.equalsIgnoreCase("2D"))
			{ 
				flashFile="StackedColumn2D.swf";
			}
			else
			{
				flashFile="StackedColumn3D.swf";
			}
			String qStr="endtime="+endDate+"&port="+portNo+"&site="+site+"&starttime="+startDate+"&host="+compName+"&measure="+measure+"&test="+test+"&state=GOOD&layer=HOST&comptype="+compType+"&period="+duration+"&endhr="+endHour+"&gtype=1&mode="+mode+"&info="+info+"&starthr="+startHour+"&msmt_host="+msmtHost+"&monitorSkin="+monitor_Skin+"&width=301&height=180&timeLine="+timeline+"&fullview=true&userLanguage="+trackerLanguage+"&dbstarttime="+request.getParameter("dbstarttime")+"&dbendtime="+request.getParameter("dbendtime");
			String xmldata=summaryChart.getXMLForSummary(qStr,chartAttribute);
			if(xmldata!=null && xmldata.trim().length()>0)
			{
				summaryGraphXmlObj.put("DATA","true");
				summaryGraphXmlObj.put("SWF_PATH","/final/FusionCharts/swf/"+flashFile);
				summaryGraphXmlObj.put("WIDTH",graphWidth);
				summaryGraphXmlObj.put("HEIGHT",graphHeight);
				summaryGraphXmlObj.put("XMLDATA",xmldata);
			}
			else
			{
				summaryGraphXmlObj.put("DATA","false");
				summaryGraphXmlObj.put("MSG",egMappingInfo.getTextDescription("monitor.common.No detailed measures available")+"!");
				summaryGraphXmlObj.put("METHOD","bigGraphOnClick");
			}
			//graphFilters.add(summaryGraphXmlObj);
			rootJSON.put("FullViewXmlData",summaryGraphXmlObj);
		}
		else if(graphType!=null && graphType.equalsIgnoreCase("DDOverviewGraph"))
		{
			fullviewGraphUrl=response.encodeURL("/final/servlet/com.egurkha.monitor.EgDDOverviewLineChart?")+"host="+EgURLEncoder.encode(hostName,"UTF-8")+"&comptype="+compType+"&test="+test+"&measure="+measure+"&ddformat="+ddformat+"&module="+module+"&starttime="+startDate+"&starthr="+startHour+"&endtime="+endDate+"&endhr="+endHour+"&width="+graphWidth+"&height="+(graphHeight-40)+"&startMin="+today.getMinutes()+"&endMin="+today.getMinutes()+"&monitorSkin="+monitor_Skin+"&mode="+mode+"&AggregateGraphs="+AggregateGraphs+"&info="+info+"&from_page="+from_page+"&graphType=DDOverviewGraph&priority="+priority;


			String qStrForSession="/final/monitor/egDashTimelineJSON.jsp?isFullView=true&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&comptype="+compType+"&test="+EgURLEncoder.encode(test,"UTF-8")+"&measure="+EgURLEncoder.encode(measure,"UTF-8")+"&ddformat="+EgURLEncoder.encode(ddformat,"UTF-8")+"&module="+module+"&starttime="+s_starttime+"&starthr="+s_starthr+"&timeline_compare="+EgURLEncoder.encode(timeline,"UTF-8")+"&endtime="+s_endtime+"&endhr="+s_endhr+"&width=880&height=320&startMin="+s_stmin+"&endMin="+s_endmin+"&monitorSkin="+monitor_Skin+"&fullview=true&mode=3D&showDDData=true&graphTitle="+EgURLEncoder.encode(graphTitle,"UTF-8")+"&isInfoRelevantMeasureGraph=true&graphType=DDOverviewGraph&priority="+EgURLEncoder.encode(priority,"UTF-8");

			if(session!=null)
				session.setAttribute("lastFullViewURLForDashboard",qStrForSession);

		}
		else if(graphType!=null && graphType.equalsIgnoreCase("Trendgraph"))
		{
			JSONObject TrendgraphXmlObj = new JSONObject();
			EgMonFusionChart egMon = new EgMonFusionChart();
			AvgTrendFusionChart avgTrend = new AvgTrendFusionChart();

			Hashtable hTable = new Hashtable();
			hTable.put("site","-1"); hTable.put("host",compName); hTable.put("layer","HOST");
			hTable.put("test",test); hTable.put("port",portNo); hTable.put("info",com.egurkha.util.StringUtils.replace(info,"|plus|",""));
			hTable.put("gtype","0"); hTable.put("draw","1"); hTable.put("starttime",startDate);
			hTable.put("endtime",endDate); hTable.put("starthr",startHour+"");
			hTable.put("endhr",endHour+""); hTable.put("comptype",compType); hTable.put("measure",measure);hTable.put("mode",mode);
			hTable.put("period","H"); hTable.put("msmt_host",msmtHost);
			if(trendType !=null)
				hTable.put("graphmode",trendType);
			else
				hTable.put("graphmode","minmax");
			hTable.put("fromPage","fullViewGraph");

			if(trendType!=null && trendType.equalsIgnoreCase("Avg"))
			{
				hTable.put("requestFrom","Avg");
			}
			else if(trendType!=null && trendType.equalsIgnoreCase("Sum"))
			{
				hTable.put("requestFrom","Sum");
			}

			String qStrForSession="/final/monitor/egDashTimelineJSON.jsp?isFullView=true&site=-1&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&layer="+s_layerName+"&test="+test+"&port="+portNo+"&info="+com.egurkha.util.StringUtils.replace(info,"|plus|","")+"&gtype=0&draw=1&starttime="+s_starttime+"&mode=2D&timeline_compare="+timeline+"&endtime="+s_endtime+"&starthr="+s_starthr+"&endhr="+s_endhr+"&comptype="+compType+"&measure="+measure+"&monitorSkin="+monitor_Skin+"&period=H&qctr=5&search=&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&comp="+compType+":"+compName+":"+portNo+"&graphmode=minmax&fromDashboard=true&width="+graphWidth+"&height="+graphHeight+"&fullview=true&isInfoReleventGraph=false&module="+module+"&graphType=Trendgraph";

			if(session!=null)
				session.setAttribute("lastFullViewURLForDashboard",qStrForSession);

			Vector TrendChartAttribute=new Vector();
			TrendChartAttribute.add("showValues='0'");
			TrendChartAttribute.add("showLabels='1'");
			TrendChartAttribute.add("labelDisplay='Rotate' slantLabels='1'");
			TrendChartAttribute.add("formatNumberScale='0'");

			TrendChartAttribute.add("palette='1'");
			TrendChartAttribute.add("divLineColor='d8d8d8'");
			//TrendChartAttribute.add("numDivLines='11'");
			TrendChartAttribute.add("showAlternateHGridColor='0'");
			TrendChartAttribute.add("shadowAlpha='99'");
			TrendChartAttribute.add("anchorAlpha='1'");
			TrendChartAttribute.add("chartLeftMargin='5'");
			//TrendChartAttribute.add("chartRightMargin='2'");
			TrendChartAttribute.add("chartTopMargin='2'");
			TrendChartAttribute.add("bgColor='FFFFFF,FFFFFF'");
			TrendChartAttribute.add("bgAngle='270'");
			TrendChartAttribute.add("bgAlpha='10,10'");
			TrendChartAttribute.add("canvasBgColor='f7f7f7'");
			TrendChartAttribute.add("showToolTipShadow ='1'");
			TrendChartAttribute.add("toolTipBgColor ='ffffff'");
			TrendChartAttribute.add("toolTipBorderColor ='555555'");
			TrendChartAttribute.add("allowRotation ='0'");
			TrendChartAttribute.add("zgapplot='0'");
			TrendChartAttribute.add("zdepth='200'");
			TrendChartAttribute.add("exeTime='0'");
			TrendChartAttribute.add("dynamicShading='1'");
			TrendChartAttribute.add("YZWallDepth='0'");
			TrendChartAttribute.add("ZXWallDepth='0'");
			TrendChartAttribute.add("XYWallDepth='0'");
			TrendChartAttribute.add("startAngX='0'");
			TrendChartAttribute.add("startAngY='0'");
			TrendChartAttribute.add("endAngX='5'");
			TrendChartAttribute.add("endAngY='-5'");
			TrendChartAttribute.add("showBorder='0'");

			if(mode!=null && mode.equalsIgnoreCase("2D"))
			{
				TrendChartAttribute.add("is2D='1'");
			}
			else
			{
				TrendChartAttribute.add("is2D='0'");
			}
			TrendChartAttribute.add("exportEnabled='0'");
			TrendChartAttribute.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
			TrendChartAttribute.add("exportAtClient='0'");
			TrendChartAttribute.add("exportAction='download'");
			TrendChartAttribute.add("exportFileName='MinMaxTrendChart'");
			TrendChartAttribute.add("showAboutMenuItem='1' aboutMenuItemLabel='About eG Innovations' aboutMenuItemLink='n-http://www.eginnovations.com'");
			//TrendChartAttribute.add("clickURL='javascript:bigGraphOnClick()'");

			String xmlData = "";

			if((trendType!=null) && (trendType.equalsIgnoreCase("Avg")|| trendType.equalsIgnoreCase("sum")))
			{
				xmlData = (String)avgTrend.FusionGraph(user,hTable,TrendChartAttribute);
			}
			else
			{
				xmlData = (String)egMon.FusionGraph(user,hTable,TrendChartAttribute);
			}

			String flashFile="MSCombi3D";
			if(xmlData!=null && xmlData.trim().length()>0)
			{
				TrendgraphXmlObj.put("DATA","true");
				TrendgraphXmlObj.put("SWF_PATH","/final/FusionCharts/swf/"+flashFile+".swf");
				TrendgraphXmlObj.put("WIDTH",graphWidth);
				TrendgraphXmlObj.put("HEIGHT",graphHeight);
				TrendgraphXmlObj.put("XMLDATA",xmlData.toString());
				TrendgraphXmlObj.put("fullview","true");
			}
			else
			{
				TrendgraphXmlObj.put("DATA","false");
				TrendgraphXmlObj.put("MSG",egMappingInfo.getTextDescription("monitor.common.No  measures available")+"!");
				TrendgraphXmlObj.put("METHOD","bigGraphOnClick");
			}
			//graphFilters.add(TrendgraphXmlObj);
			rootJSON.put("FullViewXmlData",TrendgraphXmlObj);
		}
		else if(graphType!=null && graphType.equalsIgnoreCase("areaChart"))
		{
			//-----------------fusionChart------------starts---------------------------------
			JSONObject areaChartXmlObj = new JSONObject();
			String timeSelect=request.getParameter("timeSelect");
			hostName=hostName.substring(0,hostName.indexOf(":"));
			String mappingName=request.getParameter("mappingName");
			String infosToArea=request.getParameter("infosToArea");
			String chartUnit=request.getParameter("unit");
			String isInterface=request.getParameter("fromInterface");

			double screenWidthInDouble=1024.0;
			double screenHeightInDouble=768.0;
			if(screenWidth!=null && !screenWidth.equals(""))
			{
				screenWidthInDouble=Double.parseDouble(screenWidth);
			}
			if(screenHeight!=null && !screenHeight.equals(""))
			{
				screenHeightInDouble=Double.parseDouble(screenHeight);
			}

			double defaultTableWidth=940;
			double tableWidth=910;
			double tableWidth1024PxInPercent=defaultTableWidth/1024;
			tableWidth=screenWidthInDouble*tableWidth1024PxInPercent;
			tableWidth=MathUtils.round(tableWidth,0);
			String tblWidth=Double.toString(tableWidth);


			boolean isFullView=true;
			int legendInfoCount=Integer.parseInt(request.getParameter("legendInfoCount"));
			
			Vector chartAttributes=new Vector();
			if(chartUnit!=null && !chartUnit.equals(""))
				chartAttributes.add("caption='"+mappingName+" ("+chartUnit+")'");
			else
				chartAttributes.add("caption='"+mappingName+"'");

			if(legendInfoCount!=0 && legendInfoCount<=10)
				chartAttributes.add("legendPosition='BOTTOM'");
			else
				chartAttributes.add("legendPosition='RIGHT'");

	//		chartAttributes.add("xAxisName='Time in  HH : mm'");
			chartAttributes.add("showValues='0'");
			chartAttributes.add("palette='0'");
			chartAttributes.add("bgColor='#FFFFFF'");
			chartAttributes.add("showBorder='0'");
			chartAttributes.add("staggerLines='3'");
			chartAttributes.add("numVDivLines='10'");
			chartAttributes.add("plotGradientColor=''");
			chartAttributes.add("numDivLines='10'");
			chartAttributes.add("adjustDiv='1'");
			chartAttributes.add("vDivLineIsDashed='1'");
			chartAttributes.add("legendShadow='1'");
			chartAttributes.add("vDivLineDashGap='10px'");
			chartAttributes.add("dashed='1'");
			chartAttributes.add("divLineIsDashed='1'");

			if(infosToArea!=null && infosToArea.length()>0 && infosToArea.contains("plus"))
				infosToArea= infosToArea.replace("plus ","+");

			String chartXMLData="";
			if(isInterface!=null && isInterface.equalsIgnoreCase("true"))
			{
				chartXMLData=fusionChart.getXMLDataForAreaChart(timeSelect,test,measure,mappingName,hostName,msmtHost,chartAttributes,"",infosToArea,isFullView);
			}
			else
			{
				String defaultInterface=request.getParameter("defaultInterface");
				if(defaultInterface!=null && defaultInterface.length()>0 && defaultInterface.contains("plus"))
					defaultInterface= defaultInterface.replace("plus ","+");

				chartXMLData=fusionChart.getXMLDataForAreaChart("24 hour",test,measure,mappingName,hostName,msmtHost,chartAttributes,defaultInterface,"10","");

			}
			if(chartXMLData!=null && !chartXMLData.trim().equals(""))
			{
				areaChartXmlObj.put("DATA","true");
				areaChartXmlObj.put("SWF_PATH","/final/FusionCharts/swf/MSArea.swf");
				areaChartXmlObj.put("tableWidth",tableWidth);
				areaChartXmlObj.put("XML_DATA",chartXMLData);
			}
			//graphFilters.add(areaChartXmlObj);
			rootJSON.put("FullViewXmlData",areaChartXmlObj);		
		}
		boolean isHighChart=false;
		if(graphType!=null && !graphType.equalsIgnoreCase("comparisionBargraph") && !graphType.equalsIgnoreCase("ddGraph") &&!graphType.equalsIgnoreCase("Trendgraph") &&!graphType.equalsIgnoreCase("Summarygraph") &&!graphType.equalsIgnoreCase("areaChart"))
		{
			String chartOptionForTimeline="";
			if ( !StringUtils.isNull(s_starttime) && !StringUtils.isNull(s_endtime) )
			{
				String tempStDate = s_starttime; //dateFormatMMDD.format(startDateFrmReq1);
				String tempEndDate = s_endtime; //dateFormatDDMM.format(endDateFrmReq1);
				tempStDate=DateUtil.changeDateFormat(tempStDate,currentDateFormat,"MM/dd/yyyy");
				tempEndDate=DateUtil.changeDateFormat(tempEndDate,currentDateFormat,"MM/dd/yyyy");
				if(!StringUtils.isNull(tempStDate) && tempStDate.lastIndexOf(" ")>0)
				{
					tempStDate=tempStDate.substring(0,tempStDate.lastIndexOf(" "));
				}
				if(!StringUtils.isNull(tempEndDate) && tempEndDate.lastIndexOf(" ")>0)
				{
					tempEndDate=tempEndDate.substring(0,tempEndDate.lastIndexOf(" "));
				}
				String timeDuration = iniObj.getValue("Default_MeasureGraph_Duration","duration");
				chartOptionForTimeline = HighChartTimeline.getChartOption(timeline,currentDateFormat,tempStDate,tempEndDate);
			}
			else
			{
				String timeDuration = iniObj.getValue("Default_MeasureGraph_Duration","duration");
				String measuretimeline=egDashboard.convertDurtionIntoTimeline(timeDuration,true);

				if(timeDuration!=null && !timeDuration.equals(""))
				{
					Vector times=egDashboard.getStartEndDateTimeForMeasure(timeDuration);
					if(times!=null && times.size()>=4)
					{
						String tempStDate=(String)times.get(0);
						String tempEndDate=(String)times.get(1);
						chartOptionForTimeline = HighChartTimeline.getChartOption(timeDuration,currentDateFormat,tempStDate,tempEndDate);
					}			
				}
			}
			JSONObject MeasureGraphImage = new JSONObject();
			if(graphType!=null && (minMaxAvgDisplay!=null && !minMaxAvgDisplay.equalsIgnoreCase("none") && graphType.equalsIgnoreCase("Measuregraph")) || (graphType!=null && !graphType.equalsIgnoreCase("Measuregraph") ))
			{
				MeasureGraphImage.put("DATA","true");
				MeasureGraphImage.put("iframeSrc",fullviewGraphUrl);
				MeasureGraphImage.put("Method","bigGraphOnClick");
			}
			else
			{
				MeasureGraphImage.put("Method","bigGraphOnClick");
				MeasureGraphImage.put("DATA","false");
				MeasureGraphImage.put("Msg",egMappingInfo.getTextDescription("monitor.common.No measures available")+"!");
			}
			if(test.equalsIgnoreCase("JvmThreadTest") || test.equalsIgnoreCase("CtxSessionTest") )
			{
				MeasureGraphImage.put("TITLE",egMappingInfo.getTestDescription(test)+"/"+egMappingInfo.getMeasureDescription(test, measure)+"("+tablesInfo.getUnitForMeasure(test,measure)+")");
			}
			else
			{
				MeasureGraphImage.put("TITLE",egMappingInfo.getTestDescription(test)+"/"+egMappingInfo.getMeasureDescription(test, measure)+"("+tablesInfo.getUnitForMeasure(test,measure)+")");
			}
			MeasureGraphImage.put("HIGH_CHART",chartOptionForTimeline);
			if(chartOptionForTimeline!=null && chartOptionForTimeline.equalsIgnoreCase("highcharts"))
				isHighChart=true;

			rootJSON.put("MeasureGraphImage",MeasureGraphImage);
		}
		if(!isHighChart && (!come_from_vmware && minmaxavgRequired!=null && minmaxavgRequired.equalsIgnoreCase("true")))
		{
			ArrayList excludedInfosList=new ArrayList();
			boolean isExcludedInfosAvailableForTest=false;
			if(priority!=null && !priority.equalsIgnoreCase("all"))
			{
				String  excludedInfosForTest=iniObj.getValue("INFOS_TO_BE_OMITTED",test);
				String  excludedInfosForTestMeasure=iniObj.getValue("INFOS_TO_BE_OMITTED",test+":"+measure);
				if(!StringUtils.isNull(excludedInfosForTest))
				{
					StringTokenizer stkExcludedInfos=new StringTokenizer(excludedInfosForTest,",");
					while(stkExcludedInfos.hasMoreTokens())
					{
						String infoToExcluded=stkExcludedInfos.nextToken();
						infoToExcluded=infoToExcluded.toLowerCase();
						if(excludedInfosList!=null && !excludedInfosList.contains(infoToExcluded))
							excludedInfosList.add(infoToExcluded);
					}
				}

				if(!StringUtils.isNull(excludedInfosForTestMeasure))
				{
					StringTokenizer stkExcludedInfos=new StringTokenizer(excludedInfosForTestMeasure,",");
					while(stkExcludedInfos.hasMoreTokens())
					{
						String infoToExcluded=stkExcludedInfos.nextToken();
						infoToExcluded=infoToExcluded.toLowerCase();
						if(excludedInfosList!=null && !excludedInfosList.contains(infoToExcluded))
							excludedInfosList.add(infoToExcluded);
					}
				}

				if(excludedInfosList!=null && !excludedInfosList.isEmpty())
					isExcludedInfosAvailableForTest=true;
			}

			String tableInfo=request.getParameter("infoForTable");
			String fromKPIOverview=request.getParameter("fromKPI");

			Hashtable allAvgMinMax=new Hashtable();
			TreeMap treeMap = new TreeMap();

			String measureForDisp=dbInfo.getMeasureForColumn(test,measure);
			String measureForDB=dbInfo.getColumnForMeasure(test,measureForDisp);
			String s_layer=dashboardDAO.getLayerForTest(compType,test,measureForDisp);

			Vector tempVec=new Vector();
			String commonInfo="";
			if(fromKPIOverview!=null && fromKPIOverview.equalsIgnoreCase("true"))
			{
				commonInfo=tableInfo;
			}
			else
			{
				commonInfo=info;
			}
			StringTokenizer commaTokenizer = new StringTokenizer(commonInfo,",");
			StringBuffer sbInfosNeeded=new StringBuffer(128);
			while(commaTokenizer.hasMoreTokens())
			{
				String infoVal =commaTokenizer.nextToken();
				if(fromKPIOverview!=null && fromKPIOverview.equalsIgnoreCase("true"))
					infoVal=com.egurkha.util.StringUtils.replace(infoVal,"$","+");
				else
					infoVal=com.egurkha.util.StringUtils.replace(infoVal,"*","+");

				
				if(isExcludedInfosAvailableForTest)
				{
					String tempInfoVal=infoVal;
					tempInfoVal=tempInfoVal.substring(1,tempInfoVal.length());
					tempInfoVal=tempInfoVal.toLowerCase();
					if(excludedInfosList.contains(tempInfoVal))
					{
						continue;
					}
				}
				sbInfosNeeded.append(","+infoVal);

				Vector measureNames=egDashboard.getMeasurenamesFromInfo(compName,portNo,site,s_layer,test,infoVal,msmtHost);
				if(measureNames!=null && measureNames.contains(measureForDB))
					tempVec.add(infoVal);

			}
			String infosNeeded=commonInfo;
			if(priority!=null && !priority.equalsIgnoreCase("all"))
			{
				if(sbInfosNeeded!=null)
				{
					infosNeeded=sbInfosNeeded.toString();
					if(infosNeeded!=null && infosNeeded.indexOf(",")==0)
						infosNeeded=infosNeeded.substring(1,infosNeeded.length());
				}
			}
			Vector infos=dashboardDAO.getInfosbyUsage(priority,test,compName,portNo,infosNeeded,site,
			startDate+" "+startHour+":"+today.getMinutes()+":00",
			endDate+" "+endHour+":"+today.getMinutes()+":00",measure,msmtHost,tempVec);
			if(infos.size()==1 && (((String)infos.get(0)).equals("+Summary")))
			{
				commonInfo="";
			}
			if(infos==null || infos.size()==0) {
				infos=new Vector();
				infos.add("+");
			}

			HashMap colorMap=new HashMap();
			int colorIndex=0;
			for(int k=0;k<infos.size();k++)
			{
				if(colorIndex>v_color.size()-1)
					colorIndex=0;
				colorMap.put((String)infos.get(k),v_color.get(colorIndex));
				colorIndex++;
			}

			if(infos!=null && infos.size()>0)
			{
				for(int m=0;m<infos.size();m++)
				{
					String infoStr = (String)infos.get(m);
					
					String infoStrParam=com.egurkha.util.StringUtils.replace(infoStr,"|plus|","+");
					Hashtable avgMinMaxData=measureGraphInfo.getAvgMaxMinData(measure,test,compName,portNo,site,test,infoStrParam,startDate,endDate,msmtHost,compType,timeline,startHour+"",endHour+"","","",u_ser);
					Iterator itr=avgMinMaxData.keySet().iterator();
					while(itr.hasNext())
					{
						String key=(String)itr.next();

						ArrayList data=(ArrayList)avgMinMaxData.get(key);
						Float temp_data = new Float(Float.parseFloat((String)data.get(1)));

						if(data!=null && data.size()>=3)
						{
							//infoStr=com.egurkha.util.StringUtils.replace(infoStr,"|plus|","");
							//infoStr=com.egurkha.util.StringUtils.replace(infoStr,"+","");
							//infoStr=com.egurkha.util.StringUtils.replace(infoStr,"*","");
							String dispMeasure="";
							String avgValue =(String)data.get(0);
							String maxValue =(String)data.get(1);
							String minValue =(String)data.get(2);
							if(avgValue.equals("-")&&minValue.equals("-"))
							{
								maxValue="-";
							}
							if(infoStr==null || infoStr.trim().equals("") || infoStr.trim().equals("*") 
								|| infoStr.trim().equals("+") || infoStr.trim().equals(sid+"+"))
							{
								String measureForDisplay=dbInfo.getMeasureForColumn(test,measure);
								dispMeasure=test+"&"+measureForDisplay;
								colorMap.put(dispMeasure,v_color.get(0));
							}
							else
							{
								dispMeasure =infoStr;
							}
							if(treeMap.size() >= 1)
							{
								if(treeMap.containsKey(temp_data))
								{
									String val=(String)treeMap.get(temp_data);
									val=val+"#"+dispMeasure+"|"+avgValue+"|"+maxValue+"|"+minValue;
									treeMap.put(temp_data,val);
								}
								else
								{
									treeMap.put(temp_data,dispMeasure+"|"+avgValue+"|"+maxValue+"|"+minValue);
								}
							}
							else
							{
								treeMap.put(temp_data,dispMeasure+"|"+avgValue+"|"+maxValue+"|"+minValue);
							}
						}
					}
				}
			}
			JSONObject minMaxTable = new JSONObject();
			JSONArray minMaxTableHeadersArray = new JSONArray();
			if(treeMap!=null && !treeMap.isEmpty())
			{
				JSONObject minMaxTextHeaderObject = new JSONObject();
				if(commonInfo!=null && commonInfo.endsWith(","))
					commonInfo=commonInfo.substring(0,commonInfo.length()-1);

				if(commonInfo==null || commonInfo.trim().equals("") || commonInfo.trim().equals("*") || commonInfo.trim().equals("+") || commonInfo.trim().equals(sid) || commonInfo.trim().equals(sid+"*"))
				{
					minMaxTextHeaderObject.put("name",egMappingInfo.getTextDescription("monitor.measure.Measurement Name"));
					if(treeMap.size()>1)
					{
						minMaxTextHeaderObject.put("imageUrl","/final/monitor/eg_images/arrow_down_black.gif");
						minMaxTextHeaderObject.put("Method","sortValues");
					}
					else
					{
					}
				}
				else
				{	
					minMaxTextHeaderObject.put("name",egMappingInfo.getTextDescription("monitor.common.Descriptor"));
					if(treeMap.size()>1)
					{
						minMaxTextHeaderObject.put("imageUrl","/final/monitor/eg_images/arrow_down_black_small.gif");
						minMaxTextHeaderObject.put("Method","sortValues");
					}
					else
					{
					}
				}
				JSONObject avgHeader = new JSONObject();
				avgHeader.put("name",egMappingInfo.getTextDescription("monitor.common.Avg"));

				JSONObject maxHeader = new JSONObject();
				maxHeader.put("name",egMappingInfo.getTextDescription("monitor.common.Max"));

				JSONObject minHeader = new JSONObject();
				minHeader.put("name",egMappingInfo.getTextDescription("monitor.common.Min"));
				
				minMaxTableHeadersArray.add(minMaxTextHeaderObject);
				minMaxTableHeadersArray.add(avgHeader);
				minMaxTableHeadersArray.add(maxHeader);
				minMaxTableHeadersArray.add(minHeader);
				
				minMaxTable.put("minMaxTableHeadersArray",minMaxTableHeadersArray);

				Iterator ite = treeMap.keySet().iterator();

				JSONArray minMaxTableDataArray = new JSONArray();
				while(ite.hasNext())
				{
					float key = ((Float)ite.next()).floatValue();
					String values = (String)treeMap.get(new Float(key));
					StringTokenizer st = new StringTokenizer(values,"#");
					while(st.hasMoreTokens())
					{
						String val = (String)st.nextToken();
						StringTokenizer st1 = new StringTokenizer(val,"|");
						{
							while(st1.hasMoreTokens())
							{
								JSONObject minMaxTableDataObject = new JSONObject();

								String descriptor=(String)st1.nextToken();
								String colorValue =(String)colorMap.get(descriptor);
								if(descriptor.indexOf("&")>-1)
								{
									String testVal=descriptor.substring(0,descriptor.indexOf("&"));
									String measureVal=descriptor.substring(descriptor.indexOf("&")+1,descriptor.length());
									
									String unit1 = tablesInfo.getUnitForMeasure(testVal,measureVal);
									minMaxTableDataObject.put("value0","");
									minMaxTableDataObject.put("value1",testVal+":"+measureVal+"("+unit1+")");
								}
								else
								{
									descriptor=com.egurkha.util.StringUtils.replace(descriptor,sid+"+","");
									descriptor=com.egurkha.util.StringUtils.replace(descriptor,"+","");

									minMaxTableDataObject.put("value0",colorValue);
									minMaxTableDataObject.put("value1",descriptor);
								}
								minMaxTableDataObject.put("value2",st1.nextToken());
								minMaxTableDataObject.put("value3",st1.nextToken());
								minMaxTableDataObject.put("value4",st1.nextToken());

								minMaxTableDataArray.add(minMaxTableDataObject);
							}
						}
					}
				}
				minMaxTable.put("minMaxTableDataArray",minMaxTableDataArray);
				rootJSON.put("minMaxTable",minMaxTable);

				if(isFirefox || isChrome)
				{
				}
				else
				{
				}
				Set set = treeMap.keySet();
				ArrayList al = new ArrayList(set);

				JSONObject measuresTable = new JSONObject();
				JSONArray measuresTableDataArray = new JSONArray();

				for(int j=treeMap.size()-1; j >= 0; j--)
				{
					float key = ((Float)al.get(j)).floatValue();
					String values = (String)treeMap.get(new Float(key));
					StringTokenizer st = new StringTokenizer(values,"#");
					while(st.hasMoreTokens())
					{
						String val = (String)st.nextToken();
						StringTokenizer st1 = new StringTokenizer(val,"|");
						while(st1.hasMoreTokens())
						{
							JSONObject measuresTableDataObject = new JSONObject();

							String descriptor=(String)st1.nextToken();
							String colorValue =(String)colorMap.get(descriptor);
							if(descriptor.indexOf("&")>-1)
							{
								String testVal=descriptor.substring(0,descriptor.indexOf("&"));
								String measureVal=descriptor.substring(descriptor.indexOf("&")+1,descriptor.length());
								String units = tablesInfo.getUnitForMeasure(testVal,measureVal);
								measuresTableDataObject.put("value0",colorValue);
								measuresTableDataObject.put("value1",testVal+":"+measureVal+"("+units+")");
							}
							else
							{
								descriptor=com.egurkha.util.StringUtils.replace(descriptor,sid+"+","");
								descriptor=com.egurkha.util.StringUtils.replace(descriptor,"+","");
								measuresTableDataObject.put("value0",colorValue);
								measuresTableDataObject.put("value1",descriptor);
							}
							measuresTableDataObject.put("value2",st1.nextToken());
							measuresTableDataObject.put("value3",st1.nextToken());
							measuresTableDataObject.put("value4",st1.nextToken());
							measuresTableDataArray.add(measuresTableDataObject);
						}
					}
				}
				measuresTable.put("measuresTableDataArray",measuresTableDataArray);
				rootJSON.put("measuresTable",measuresTable);
			}
		}
		else
		{
			JSONObject dbTimelineDiv = new JSONObject();
			dbTimelineDiv.put("fullviewDataUrl",fullviewDataUrl);
			rootJSON.put("dbTimelineDiv",dbTimelineDiv);
		}
		hiddens.put("startDate",startDate);
		hiddens.put("endDate",endDate);
		hiddens.put("startMin",startMin);
		hiddens.put("endMin",endMin);
%>
<%
		if(timelineChangedForCompGraph!=null && timelineChangedForCompGraph.equals("true"))
		{
%>
		<img src="/final/monitor/eg_images/spacer.gif" style="display:none" onload="javascript:showComparison();javascript:timelineOnchange(false);">
<%
		}
		graphFilters.add(graphObj);
		rootJSON.put("hiddens",hiddens);
		rootJSON.put("graphFilters",graphFilters);
		
	}	
	out.println(rootJSON.toString());
}
catch(Exception ex)
{
	ex.printStackTrace();
}
%>

