<%
/********************************************************************************
FileName	:egCustomDashboard.jsp
Purpose		:User can create their own dashboad and this page will show the builded dashboard. One user's dashboard will not be available to the others. 
Created by	:Simeon.D
Created on	:22/11/2009
GUI Changed by	:Vijay\Jaiwin
**********************************************************************************/
%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>
<%@ include file="EgLoginTracker.jsp"%>
<%@ page errorPage="EgProbsM.jsp"%>

<%@ page import="com.eg.*"%>
<%@ page import="com.egurkha.monitor.*"%>
<%@ page import="egurkha.reporter.ErUtils"%>
<%@ page import="java.util.*"%>
<%@ page import="java.text.*"%>

<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires",-1);
%>
<script type="text/javascript" src="/final/FusionCharts/scripts/FusionCharts.js"></script>
<%
try
{
	String ua = request.getHeader( "User-Agent" );
	boolean isFirefox2 = ( ua != null && ua.indexOf( "Firefox2/" ) != -1 );
	boolean isFirefox3 = ( ua != null && ua.indexOf( "Firefox3/" ) != -1 );
	boolean isFirefox = ( ua != null && ua.indexOf( "Firefox3/" ) != -1 );
	boolean isMSIE = ( ua != null && ua.indexOf( "MSIE" ) != -1 );
	boolean isIE6=( ua != null && ua.indexOf("MSIE 6.0") != -1 );
	boolean isChrome = ( ua != null && ua.indexOf( "Chrome/" ) != -1 );
	IniUI iniUI = IniUI.getInstance();
	String currentDateFormat = iniUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	EgMappingInfo mappingInfo=new EgMappingInfo(trackerLanguage);

	EgTablesInfo tablesInfo=new EgTablesInfo("manager");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgDbInfo dbInfo=new EgDbInfo("manager");
	EgTesterInfo testerInfo=new EgTesterInfo("manager");
	EgTopoInfo topoInfo=new EgTopoInfo("manager");

	ErUtils  erutils=new  ErUtils();

	EgCustomDashboardModel custormDashboardModel=new EgCustomDashboardModel();
	
	String compType=request.getParameter("compType");

	MonitorDAOFactory	monitorDaoFactory = MonitorDAOFactory.getInstance();
	EgServerDashBoardDAO dashboardDAO=monitorDaoFactory.getServerDashBoardDAO();
	EgServerDashboardMGraphModel measureGraph=new EgServerDashboardMGraphModel();
	
	EgFusionChartUtil fusionChart=new EgFusionChartUtil(session.getId(),trackerLanguage);
	String s_iniFile = EgInstallInfo.getInstallDir()+ "/manager/config/eg_customdashboard.ini";
	String s_iniFile_Title = EgInstallInfo.getInstallDir()+ "/manager/config/eg_customdashboardTitleMapping.ini";
	String serverDashBrdIniFile = EgInstallInfo.getInstallDir()+ "/manager/config/eg_serverdashboard.ini";
	
	IniFile iniObj = new IniFile(s_iniFile );
	IniFile iniObjTitle= new IniFile(s_iniFile_Title);
	IniFile serverDashBrdIni= new IniFile(serverDashBrdIniFile);
	

	EgMemCheck memCheck = new EgMemCheck();
	boolean hasConfig=memCheck.isCMEnabled();
	String UseCutOffFactor=serverDashBrdIni.getValue("Dashboard_Settings","UseCutOffFactor");
	EgServerDashboardModel  egDashboard=null;
	if(compType!=null && compType.startsWith("Agg_"))
	{
		egDashboard=new  EgServerDashboardModel(true);
		String aggDashBrdIniFile = EgInstallInfo.getInstallDir()+ "/manager/config/eg_aggregateserverdashboard.ini";
		serverDashBrdIni= new IniFile(aggDashBrdIniFile);
		UseCutOffFactor=serverDashBrdIni.getValue("Dashboard_Settings","UseCutOffFactor");
	}
	else
	{
		egDashboard=new  EgServerDashboardModel();
	}
	egDashboard.setUser(u_ser);
	dashboardDAO.setDashboardType("custom");
	String profileName=request.getParameter("profileName");
	String compName=request.getParameter("compName");
	String site=request.getParameter("site");
	boolean isModifyReq=true;
	boolean isfromSuper = session.getAttribute("fromSuper") != null &&
								session.getAttribute("fromSuper").toString().equalsIgnoreCase("yes");

	String eventCriticalPageUrl ="";
	String eventMajorPageUrl ="";
	String eventMinorPageUrl ="";
	String temp_userId=u_ser.getLoginID();
	String temp_profileName=profileName;
	ArrayList sitesForComponent=topoInfo.getSitesForComponent(compType+":"+compName);

	if(site==null || site.trim().equals(""))
		site="NULL";

	if(sitesForComponent!=null && sitesForComponent.size()>0)
		site=(String)sitesForComponent.get(0);

	boolean isFullViewForKPI=false;
	boolean isFullViewForConfig=false;
	String lastFullViewURL=(String)session.getAttribute("lastFullViewURLForDashboard");
	String fullViewGraphType="";
	boolean  hasCustomDashboard=false;
	Vector template_with_user=custormDashboardModel.getTemplates(u_ser.getLoginID(),compType);
	Vector dashboards=new Vector();//custormDashboardModel.getTemplates(u_ser.getLoginID(),compType);
	if(template_with_user!=null && !template_with_user.isEmpty())
	{
		for(int i=0;i<template_with_user.size();i++)
		{
			String user_template=(String)template_with_user.get(i);
			String user=user_template.substring(0,user_template.indexOf(":"));
			String template=user_template.substring(user_template.indexOf(":")+1);
			if(user!=null && !user.equals(u_ser.getLoginID()))
				template=template+"("+user+")";
			dashboards.add(template);
		}
	}
	if(profileName!=null && profileName.indexOf("(")>-1)
	{
		isModifyReq=false;
		temp_profileName=profileName.substring(0,profileName.indexOf("("));
		temp_userId=profileName.substring(profileName.indexOf("(")+1,profileName.indexOf(")"));
	}
	if(dashboards!=null && !dashboards.isEmpty())
		Collections.sort(dashboards,String.CASE_INSENSITIVE_ORDER);
	if(dashboards!=null && dashboards.size()>0)
	{
			hasCustomDashboard=true;
	}
	String tab="";
	String configDivCount="";
	String configTitleStr=mappingInfo.getTextDescription("monitor.dashboard.Configuration");
	String refreshTime = u_ser.getRefreshFrequency();
	StringBuffer metaRefreshUrl = new StringBuffer(64);

	metaRefreshUrl.append(request.getRequestURI());
	String queryString = request.getQueryString();
	if (queryString != null && !queryString.equals("null"))
	{
		metaRefreshUrl.append("?");
		metaRefreshUrl.append(queryString);
	}
	String metaRefreshUrlStr=metaRefreshUrl.toString();
	String fontColor="";
	String tooltipBgColor="";
	boolean isDarkTheme=false;
	if(!StringUtils.isNull(monitor_Skin))
	{
		if(monitor_Skin!=null && monitor_Skin.equalsIgnoreCase("light"))
		{
			fontColor="#333333";
		}
		else if(monitor_Skin!=null && monitor_Skin.equalsIgnoreCase("dark"))
		{
			isDarkTheme=true;
			fontColor="C6C6C6";
			tooltipBgColor="323232";
		}
	}
%>
<html>
<head>
<!-- meta http-equiv = "refresh" content = "< % = refreshTime.trim() % >;url = < % = metaRefreshUrlStr % >" -->
<egui:skin ui="monitor"/>
<%
	if(hasCustomDashboard)
	{
	
		if(lastFullViewURL!=null && (!lastFullViewURL.equals("") && !lastFullViewURL.equalsIgnoreCase("null")))
		{
			String tempLastFullViewURL=lastFullViewURL.substring((lastFullViewURL.indexOf("?")+1));
			StringTokenizer stkParams=new StringTokenizer(tempLastFullViewURL,"&");
			while(stkParams.hasMoreTokens())
			{
				String paramWithValue=stkParams.nextToken();
				if(paramWithValue!=null && paramWithValue.indexOf("=")>0)
				{
					String param=paramWithValue.substring(0,paramWithValue.indexOf("="));
					if(param!=null && param.equals("isFullView"))
					{
						String value=paramWithValue.substring(paramWithValue.indexOf("=")+1,paramWithValue.length());
						if(value!=null && value.equalsIgnoreCase("true"))
						{
							isFullViewForKPI=true;
						}
					}
					else if(param!=null && param.equals("isFullViewForConfig"))
					{
						String value=paramWithValue.substring(paramWithValue.indexOf("=")+1,paramWithValue.length());
						if(value!=null && value.equalsIgnoreCase("true"))
						{
							isFullViewForConfig=true;
							break;
						}
					}
					else if(param!=null && param.equals("graphType"))
					{
						fullViewGraphType=paramWithValue.substring(paramWithValue.indexOf("=")+1,paramWithValue.length());
						if(fullViewGraphType!=null && (!fullViewGraphType.equals("") && !fullViewGraphType.equalsIgnoreCase("null")))
						{
							if(isFullViewForKPI)
								break;
						}

					}
				}
			}
		}
		if(profileName==null || profileName.trim().equals(""))
		{
			if(dashboards!=null && dashboards.size()>0)
			{
				profileName=(String)dashboards.get(0);
				temp_profileName=profileName;
				if(profileName!=null && profileName.indexOf("(")>-1)
				{
					isModifyReq=false;
					temp_profileName=profileName.substring(0,profileName.indexOf("("));
					temp_userId=profileName.substring(profileName.indexOf("(")+1,profileName.indexOf(")"));
				}
			}
		}
		String subject=temp_userId+"_"+compType+"_"+temp_profileName;

		String graphTimeline="";
		String startTime="";
		String endTime="";
		String startHour="";
		String endHour="";
		String startMin="";
		String endMin="";
		String startSec="";
		String endSec="";

		String priority="TOP+-+3";
		String FullViewPriority="TOP+-+10";
		

		SimpleDateFormat dateFormatDDMM=new SimpleDateFormat("dd/MM/yyyy");
		SimpleDateFormat dateFormatMMDD=new SimpleDateFormat("MM/dd/yyyy");
		SimpleDateFormat testTableDateFmt=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		SimpleDateFormat dateFormatWithTime=new SimpleDateFormat("dd/MM/yyyy HH:mm");
		SimpleDateFormat dfForParse=new SimpleDateFormat(currentDateFormat);

		String startDateTime="";
		String endDateTime="";

		Date endDate=new Date();
		Date startDate=new Date(endDate.getTime()-(60*60*1000));

		String hostName="";
		String portNo="";
		String sid="";

		if(compName!=null && !compName.equals(""))
		{
			StringTokenizer st=new StringTokenizer(compName,":");
			if(st.hasMoreTokens())
				hostName=st.nextToken();

			if(st.hasMoreTokens())
				portNo=st.nextToken();

			if(st.hasMoreTokens())
				sid=st.nextToken();
		}
		String msmtHost="";

		Vector runningtests=dashboardDAO.getRunningTestsForServer(compName,compType,"custom");
		Hashtable allMsmtHosts=dashboardDAO.getMsmtHostForAllTest(compName,compType,"custom");
		Hashtable allTestInfos=dashboardDAO.getDescriptorsForAllTest(compName,compType,"custom");
		

		int divCount=0;

		String defaultMGraphDuration=iniObjTitle.getValue(subject+"_MeasureGraph_Duration","duration");
		String defaultHealthDuration=iniObjTitle.getValue(subject+"_Health_Duration","duration");

		if(defaultMGraphDuration==null || defaultMGraphDuration.trim().equals(""))
			defaultMGraphDuration="1 hour";

		String s_systemBlocks=iniObj.getValue(subject,"enabled_block");

		String configIniVal=iniObj.getValue(subject,"config");
		String s_allIndicators=iniObj.getValue(subject,"Indicators");
		String s_allDials=iniObj.getValue(subject,"dial");
		String s_allDigital=iniObj.getValue(subject,"digital");
		String s_ddinivalue=iniObj.getValue(subject,"comparision");
		String s_Historyinivalue=iniObj.getValue(subject,"history");
		String s_AllComparisionTable=iniObj.getValue(subject,"tables");
		String ddComparisionTables=iniObj.getValue(subject,"DDComparisonTables");

		Vector times=egDashboard.getStartEndDateTimeForMeasure(defaultMGraphDuration);
		Vector sysblock=egDashboard.getTokensAsVector(s_systemBlocks,",");
		Vector dials=egDashboard.getTokensAsVector(s_allDials,",");
		Vector digital=egDashboard.getTokensAsVector(s_allDigital,",");
		Vector cograph=egDashboard.getTokensAsVector(s_ddinivalue,",");
		Vector hisgraph=egDashboard.getTokensAsVector(s_Historyinivalue,",");
		Vector cotable=egDashboard.getTokensAsVector(s_AllComparisionTable,",");
		Vector ddCompTableVec=egDashboard.getTokensAsVector(ddComparisionTables,"#");
		
		if(times!=null && times.size()>=4)
		{
			startTime=(String)times.get(0);
			endTime=(String)times.get(1);
			startHour=(String)times.get(2);
			endHour=(String)times.get(3);
		}
		String defaultSparklineDuration=iniObj.getValue("Default_SparkLineGraph_Duration","duration");
		if(defaultSparklineDuration==null || (defaultSparklineDuration!=null && defaultSparklineDuration.equals("")))
			defaultSparklineDuration="1 hour";
		String sparkLineStartTime="";
		String sparkLineEndTime="";
		String sparkLineStartHour="";
		String sparkLineEndHour="";
		Vector sparkLineTimes=egDashboard.getStartEndDateTimeForMeasure(defaultSparklineDuration);
		if(sparkLineTimes!=null && sparkLineTimes.size()>=4)
		{
			sparkLineStartTime=(String)sparkLineTimes.get(0);
			sparkLineEndTime=(String)sparkLineTimes.get(1);
			sparkLineStartHour=(String)sparkLineTimes.get(2);
			sparkLineEndHour=(String)sparkLineTimes.get(3);
		}
		String componentTree = request.getParameter("ComponentTree");
		String selectedTreeNode = request.getParameter("selected");
		long refreshFrequency = 30 * 1000L;

		if(refreshTime!=null && refreshTime.length()>0)
		{
		//	refreshFrequency =  Long.valueOf(refreshTime).longValue() * 1000L;
		}
		
%>

<script src="/final/scripts/jquery-1.8.2.min.js"></script>
<script>
var customDashboardEncodedURL='<%=response.encodeURL("/final/monitor/egCustomDashboard.jsp?")%>';
var customDashboardpEncodedURL='<%=response.encodeURL("/final/monitor/egCustomDashboardp.jsp")%>';
var hostNameEncoded='<%=EgURLEncoder.encode(compName,"UTF-8")%>';
var hostTypeEncoded='<%=EgURLEncoder.encode(compType,"UTF-8")%>';
var dashTimelineEncodedURL='<%=response.encodeURL("/final/monitor/egCustomDashTimeline.jsp?")%>';
var calendarEncodedURL='<%= response.encodeURL("../monitor/EgCalendar.jsp?")%>';
var componentName = '<%=hostName%>';
var componentType = '<%=compType%>';
var isFromSuperMGR=eval('<%=isfromSuper%>');
documentView ={
		getObject: function()
		{
			if(typeof( window.innerWidth) == 'number')
			{//Firefox
				this.height = window.innerHeight;
				this.width = window.innerWidth;
				this.fireFox = true;
			}
			else if( document.documentElement && ( document.documentElement.clientWidth
				|| document.documentElement.clientHeight ))
			{//IE 6 + in 'standards compliant mode'
				this.height = document.documentElement.clientHeight;
				this.width = document.documentElement.clientWidth;
				this.ie = true;
			}
			else if(document.body && document.body.clientHeight)
			{ //IE 4 compatible
				this.height = document.body.clientHeight;
				this.width = document.body.clientWidth;
				this.ie = true;
			}
			return this;
		},
		getHeight: function()
		{
			return this.getObject().height;
		},
		getWidth: function()
		{
			return this.getObject().width;
		},
		isIE: function()
		{
			return this.getObject().ie;
		},
		isFireFox: function()
		{
			return this.getObject().fireFox;
		}
	};
	var isChrome='<%=isChrome%>';

var systemPublicJSON = '';
var systemController = '';
var sysCurrentTabId = '';
var netCurrentTabId = '';
var appCurrentTabId = '';
var sysLastLoadedURL = '';
var netLastLoadedURL = '';
var appLastLoadedURL = '';
var appSQLLastLoadedURL = '';
var interfaceLastLoadedURL = '';
var ciscoLastLoadedURL ='';
var jsonAreaChartData='';
var applicationPublicJSON = '';
var appInnerPublicJSON = '';
var applicationController = '';
var isNetworkTabSelected = false;

var networkPublicJSON = '';
var netInnerPublicJSON = '';
var networkController = '';
var publicJSON = '';
var monitorLastSession = '';
var lastSession = new Array();
var timelineVals = new Array();
var appLastGraphTypeLoaded = '';
var sysLastGraphTypeLoaded = '';
var netLastGraphTypeLoaded = '';

// Added by Anthoni Lawrance ENDS


// for Measures Tab
var interfacePublicJson = '';
var subsystem_change='';
var Vm_val="";
var sub_systemTab='Overview';//sarav to maintain sybystem in systemTab
var sub_netwokTab='Overview';//sarav to maintain sybystem in NetworkTab
var refreshPageFreq='<%=refreshFrequency%>';
var newDateOnTabOrSubsystem=new Date();
var defTab='';//sarav var for tab selected during refresh
var lastRefreshDate=new Date(newDateOnTabOrSubsystem.getTime()-refreshPageFreq);
		
//---end---
var grptyp='';//sarav var to main VM
var graphtp='';//sarav var to main VM
var subsystemUrl='';//to maintain the susystem ulr during refresh
var xmlHttp;
var isImageLoaded=false;
var refpagurl="";
var isGraphFullViewEnabled=false;
var componentDetailsQryStr="";
var currentComponentState = "";
var layermodeltab=false;
var intervalId;
var valHeight=0;
var valwidth=0;
var zoomStartX=0;
var zoomStartY=0;
var previousTab="";

var isTabORSubsystemChanged=false;
var lastLoadedGraphTab="";
var lastLoadedInfos="";
var exprofile="";
var profilex="";
var loadPageForDialUrl="";
var currentSubSystem="";
var currentTab="";
var aggregateTab="";
var openNode="";
var treeFlag="";
var fromHomepage="";
var zoneName="";
var requestParams=new Object();
	requestParams.tabsInfo='';
	 requestParams.ComponentTree="<%=componentTree%>";
	 requestParams.selectedTreeNode="<%=selectedTreeNode%>";
	 requestParams.backButtonFunction='';
	 requestParams.treeSession='';
	 requestParams.backText='';
	 requestParams.site='';
	 requestParams.tstate='';
	 requestParams.hostName='';
	 requestParams.originalhostName='';
	 requestParams.compType='';
	 requestParams.doubleSelectBox = '';
	 requestParams.componentDetailsIcon='';
	 requestParams.compname='';

	 requestParams.zoneName='';
	 requestParams.currentTab='';
	 requestParams.aggregateTab='';
	 requestParams.openNode='';
	 requestParams.treeFlag='';
	 requestParams.fromHomepage='';
	 requestParams.comeFrom='';
	 requestParams.Vmhost='';
	 requestParams.vmcomp_type='';
	 requestParams.vmstate='';
	 requestParams.vmport='';
	 requestParams.monCmdFrom='';
	 requestParams.pageComesfrom='';
	 requestParams.monCmdComeFrom='';
	 requestParams.topologyType='';
	 requestParams.isFromMenu='';
	 requestParams.PagesComesfrom='';
	 requestParams.actionFrom='';
	 requestParams.componenttype='';
	 requestParams.isAggregate='';
	 requestParams.isServiceBusiDash='';
	 requestParams.isServiceBusiDetails='';
	 requestParams.action='';
	 requestParams.treeAction='';
	 requestParams.treeFlag_SBD='';
	 requestParams.outsideService_SBD='';
	 requestParams.titleText_SBD='';
	 requestParams.selectNode_SBD='';
	 requestParams.isEmulTrans_SBD='';
	 requestParams.serviceState_SBD='';
	 requestParams.serviceName='';
	 requestParams.serviceState='';
	 requestParams.compState='';
	 requestParams.treeComeFrom='';
	 requestParams.fromUserView='';
	 requestParams.egQuickLaunch='';

	 requestParams.fromPages='';
	 requestParams.from='';
	 requestParams.showAlarms='';
	 requestParams.arrangeAlarms='';
	 requestParams.selectedSubFilterOption='';
	 requestParams.FromDashBoard=true;
	 requestParams.fromPage='';
	 requestParams.compType="<%=compType%>";
	 requestParams.toDashBoardLayer='';

	 requestParams.configChangeIcon='';
	 requestParams.configChangeLink='';
	 requestParams.dashBoardComponentName='';
	 requestParams.isCustomDashboard = true;
	 requestParams.buildDashboardText = '';
	 requestParams.dashboardConfigQry ='';
	 requestParams.customDashboardText = '';
var $j = jQuery.noConflict();
var serverdashboard_skin='<%=monitor_Skin%>';

</script>

<!-- 
<link rel="stylesheet" href="/final/monitor/eg_styles/monstyle_gray.css" />
-->
		<script src="/final/monitor/eg_scripts/eg_date.js"></script>
		<script language="javascript" src="/final/monitor/eg_scripts/eg_validate.js"></script>
<script type="text/javascript" src="../styles/jscrollpane/jquery.mousewheel.js"></script>
<script type="text/javascript" src="../styles/jscrollpane/mwheelIntent.js"></script>
<script type="text/javascript" src="../styles/jscrollpane/jquery.jscrollpane.js"></script>
<script type="text/javascript" src="/final/FusionCharts/scripts/FusionCharts.js"></script>
 <script language="JavaScript1.2" src="/final/monitor/eg_scripts/eg_serverdashboard.js"></script>
 <script>
var refrshTask = setInterval("refreshCustomDashboard()",refreshPageFreq);
 var mgrCurrentDateFormat='<%=currentDateFormat%>';
function refreshCustomDashboard(){
	
	if(isMaximizedView)
	{
		showMaximizedView(imgUrl1,'event','maxiMizedViewRefresh');
	}
	else
	{
		window.clearInterval(refrshTask);
		document.location='<%=metaRefreshUrlStr%>';
	}
}
// This script added by Jaiwin For PNG image gradient effect 
function LoadPng()
{
	var rslt = navigator.appVersion.match(/MSIE (\d+\.\d+)/, '');
	var itsAllGood = (rslt != null && Number(rslt[1]) >= 5.5);

	for (var i = document.images.length - 1, img = null; (img = document.images[i]); i--)
	{
		if (itsAllGood && img.src.match(/\.png$/i) != null)
		{
			var src = img.src;
			img.style.width = img.width + "px";
			img.style.height = img.height + "px";
			img.style.filter = "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='" + src + "', sizingMethod='scale')"
		}
		img.style.visibility = "visible";
	}
}
// End Script for png image
 </script>
 </head>
<body class="istam_eg_whitebg" style="overflow:hidden">
<div  class="istam_layer_headbg" id="dashboardDiv" >
	<table border="0" width="100%" class="padding4" cellspacing="0" cellpadding="0">
		<tr>
			<td align="left" nowrap><div class="font_bold10" style="float:left;padding:4px"><egui:intnl text="monitor.dashboard.Templates"/></div>
				<div class="font_bold10" style="float:left">
					<select id="profileSelect" name="profileSelect" class="egInputSelect"  onchange="javascript:changeProfile();" style="width:150px">
<%
		for(int i=0;i<dashboards.size();i++)
		{
					String s_tempprofile=(String)dashboards.get(i);
					boolean isSelected=false;
					if(s_tempprofile!=null && s_tempprofile.equals(profileName))
						isSelected=true;
%>
							<option value="<%=s_tempprofile%>" <%=(isSelected)?"selected":""%>><%=s_tempprofile%></option>
<%
		}
%>
					</select>
				</div>
<%
		if(isModifyReq)
		{
%>
				<div class="font_bold10 mouse" style="float:left;padding:4px 4px 4px 20px"><a class="font_bold10" href="javascript:window.parent.location.href='<%=response.encodeURL("/final/monitor/egDesignDashboard.jsp?")%>compType=<%=compType%>&compName=<%=EgURLEncoder.encode(compName,"UTF-8")%>&profileName=<%=EgURLEncoder.encode(profileName,"UTF-8")%>'"><egui:intnl text="monitor.dashboard.Modify"/></a></div>
<%
		}
		
%>
			</td>
		</tr>
	</table>
</div>
<%
		if(sysblock!=null && sysblock.size()>0 || dials!=null && dials.size()>0 || digital!=null && digital.size()>0 || cograph!=null && cograph.size()>0 || hisgraph!=null && hisgraph.size()>0 || cotable!=null && cotable.size()>0 || (ddCompTableVec!=null && !ddCompTableVec.isEmpty()))
		{
%>

<div id="customDashboardDiv" class="istam_div_scroll" style="margin-left:0px;margin-top:0px;float:left;width:100%;height:500px;border:0px solid red;">
<%
		Vector systemBlocks=egDashboard.getTokensAsVector(s_systemBlocks,",");
		if(systemBlocks!=null && systemBlocks.contains("currentAlerts"))
		{
			Hashtable alarmCount=egDashboard.getAlarmCount(compName,compType,"Custom");

			egDashboard.setAllAlarmDetails();
			session.setAttribute("DashboardModelObject",egDashboard);

			Hashtable alarmDetails=egDashboard.getAlarmDetails();
%>
<div style="margin-left:10px;margin-top:10px;float:left;width:24%;height:180px;border:0px solid blue;">
	<table border="0" width="100%" cellpadding="2" cellspacing="0" height="100%" class="istam_vmborder">
		<tr>
			<td height="25" width="100%" class="istam_data_headbg1" style="border-right-width:0px"><egui:intnl text="monitor.dashboard.Current Alerts"/></td>
		</tr>
		<tr>
			<td height="100%" valign="middle" height="165" class="linetop">
				<table  border="0" cellpadding="2" cellspacing="0" align="center">

<%
			int openproblems=0;
			Integer   critical=(Integer)alarmCount.get("HIGH");
			Integer   major=(Integer)alarmCount.get("INTERMEDIATE");
			Integer   minor=(Integer)alarmCount.get("LOW");
			if(alarmCount!=null && alarmCount.size()>0 && (critical.intValue()+major.intValue()+minor.intValue())>0)
			{
				String criticalDesc=(String)alarmDetails.get("HIGH");
				String majorDesc=(String)alarmDetails.get("INTERMEDIATE");
				String minorDesc=(String)alarmDetails.get("LOW"); openproblems=critical.intValue()+major.intValue()+minor.intValue();
%>
					<tr>
						<td style="padding-top:0px">
							<table border="0" cellpadding="0" cellspacing="0" style="margin-top:3px">
								<tr>
									<td width="5"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_left.png" width="5" height="20"></td>
									<td width="90" class="font_normal11" background="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_bg.png" width="75%" ><egui:intnl text="monitor.dashboard.Open Alerts"/></td>
									<td class="istamBarFont font_normal11" width="60" background="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_bgdark.png" align="center" valign="middle" >  <%=openproblems%> </td>
									<td width="5"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_bgdarkright.png" width="5" height="20"></td>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td>
							<table border="0" cellpadding="0" cellspacing="0" style="margin-top:3px;">
								<tr>
									<td width="5"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_left.png" width="5" height="20"></td>
									<td width="90" class="font_normal11" background="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_bg.png" width="75%" ><egui:intnl text="monitor.dashboard.Distribution"/></td>

									<td width="22" valign="middle" align="center" class="bar12_high istamBarFont font_normal11"> <%=critical.intValue()%></td>

									<td width="22" valign="middle" align="center" class="bar12_intermediate istamBarFont font_normal11"> <%=major.intValue()%></td>

									<td width="22" valign="middle" align="center" class="bar12_low istamBarFont font_normal11"><%=minor.intValue()%></td>

								</tr>
							</table>
						</td>
					</tr>
<%
			}
			else
			{
%>
					<tr>
						<td align="center" height="100%" valign="middle" style="padding-top:0px;width:250px">
							<table border="0" cellpadding="0" cellspacing="0" width="100%">
								<tr>
									<td align="center"  height="100%" width="100%" valign="middle" class="istam_ExclamationText">
										<img src="/final/images/clear.png" class="iconExclamation"> <br> <egui:intnl text="monitor.dashboard.No alarms found"/>!
									</td>
								</tr>
							</table>
						</td>
					</tr>
<%
			}
%>
				</table>
			</tr>
		</td>
	</table>
</div>
<%
		}

		if(systemBlocks!=null && systemBlocks.contains("eventHistory"))
		{
			String EventAnalysistimeline=iniObjTitle.getValue(subject+"_HistoricalEvents_Duration","duration");

			if(EventAnalysistimeline==null || EventAnalysistimeline.trim().equals(""))
				EventAnalysistimeline="24 hours";
			String actualTimeline=EventAnalysistimeline;
			if(EventAnalysistimeline!=null && EventAnalysistimeline.indexOf(" ")!=-1)
			{
				String eventTimeDuration=EventAnalysistimeline.substring(0,EventAnalysistimeline.indexOf(" "));
				String eventTimePeriod=EventAnalysistimeline.substring(EventAnalysistimeline.indexOf(" ")+1,EventAnalysistimeline.length());			eventTimePeriod=eventTimePeriod.substring(0,1).toUpperCase()+eventTimePeriod.substring(1,eventTimePeriod.length());
				EventAnalysistimeline=eventTimeDuration+" "+eventTimePeriod;
			}
			Hashtable events=egDashboard.getEventsForServer(compName,compType,"Custom",actualTimeline);

			int eventsCount=0;

			if(events!=null)
			{
				Integer countObj=(Integer)events.get("Count");
				if(countObj!=null)
					eventsCount=countObj.intValue();
			}
%>
<div style="margin-left:10px;margin-top:10px;float:left;width:48.5%;height:180px;border:0px solid green;">
	<table border="0" cellpadding="2" cellspacing="0" class="istam_vmborder" width="100%" height="100%"><col width="50%"><col width="50%">
		<tr>
			<td height="25" width="100%" class="istam_data_headbg1"  style="border-right-width:0px" colspan="2"><egui:intnl text="monitor.dashboard.History of Events During the Last"/> &nbsp;<egui:intnl text='<%="monitor.common."+EventAnalysistimeline%>'/></td>
		</tr>
<%
			if(eventsCount!=0)
			{
				ErUtils erUtils=new ErUtils();
				double criticalEvtCount=0.0;
				double majorEvtCount=0.0;
				double minorEvtCount=0.0;
				Integer   criticalEvents=null;
				Integer majorEvents=null;
				Integer  minorEvents=null;
				ArrayList al=new ArrayList();
				criticalEvents=(Integer)events.get("HIGH");
				majorEvents=(Integer)events.get("INTERMEDIATE");
				minorEvents=(Integer)events.get("LOW");
				al.add(criticalEvents.toString());
				al.add(majorEvents.toString());
				al.add(minorEvents.toString());
				criticalEvtCount=criticalEvents.doubleValue();
				majorEvtCount=majorEvents.doubleValue();
				minorEvtCount=minorEvents.doubleValue();
				String max=erUtils.getMaximum(al);
				double[] Hsevalues=new double[]{criticalEvtCount,majorEvtCount,minorEvtCount};

				eventCriticalPageUrl = response.encodeURL("/final/monitor/EgAlarmHistoryView.jsp?")+"newAlarms=true&compTypeList="+compType+"&compNameList="+EgURLEncoder.encode(compName,"UTF-8")+"&glduration=0&duration=0&timeselect=seconds&eg_timeline="+actualTimeline+"&eventsPerPage=All&arrangeAlarms=-1&fromDashBoard=true&selectedLayer=All&tab="+"Custom"+"&dashboardcomptype="+compType+"&dashboardcompname="+EgURLEncoder.encode(compName,"UTF-8")+"&state=HIGH&profileName="+EgURLEncoder.encode(profileName,"UTF-8");
				eventMajorPageUrl = response.encodeURL("/final/monitor/EgAlarmHistoryView.jsp?")+"newAlarms=true&compTypeList="+compType+"&compNameList="+EgURLEncoder.encode(compName,"UTF-8")+"&glduration=0&duration=0&timeselect=seconds&eg_timeline="+actualTimeline+"&eventsPerPage=All&arrangeAlarms=-1&fromDashBoard=true&selectedLayer=All&tab="+"Custom"+"&dashboardcomptype="+compType+"&dashboardcompname="+EgURLEncoder.encode(compName,"UTF-8")+"&state=INTERMEDIATE&profileName="+EgURLEncoder.encode(profileName,"UTF-8");
				eventMinorPageUrl = response.encodeURL("/final/monitor/EgAlarmHistoryView.jsp?")+"newAlarms=true&compTypeList="+compType+"&compNameList="+EgURLEncoder.encode(compName,"UTF-8")+"&glduration=0&duration=0&timeselect=seconds&eg_timeline="+actualTimeline+"&eventsPerPage=All&arrangeAlarms=-1&fromDashBoard=true&selectedLayer=All&tab="+"Custom"+"&dashboardcomptype="+compType+"&dashboardcompname="+EgURLEncoder.encode(compName,"UTF-8")+"&state=LOW&profileName="+EgURLEncoder.encode(profileName,"UTF-8");
				Vector eventChartAttribute=new Vector();

				eventChartAttribute.add("majorTMNumber='6'");
				eventChartAttribute.add("majorTMHeight='10'");
				eventChartAttribute.add("majorTMColor='ffffff'");
				eventChartAttribute.add("minorTMColor='D5D5D5'");
				eventChartAttribute.add("minorTMHeight='5'");
				eventChartAttribute.add("minorTMNumber='5'");
				eventChartAttribute.add("majorTMThickness='2'");
				eventChartAttribute.add("palette='2'");
				eventChartAttribute.add("showValues='1'");
				eventChartAttribute.add("showYAxisValues='0'");
				eventChartAttribute.add("decimals='0'");
				eventChartAttribute.add("formatNumberScale='0'");
				eventChartAttribute.add("useRoundEdges='1'");
				eventChartAttribute.add("exportEnabled='0'");
				eventChartAttribute.add("showExportDialog='1'");
				eventChartAttribute.add("exportAction='save'");
				eventChartAttribute.add("exportTargetWindow='1'");
				eventChartAttribute.add("showShadow='1'");
				eventChartAttribute.add("showToolTipShadow='1'");
				eventChartAttribute.add("chartLeftMargin='8'");
				eventChartAttribute.add("chartRightMargin='20'");
				eventChartAttribute.add("chartTopMargin='3'");
				eventChartAttribute.add("chartBottomMargin='8'");
				eventChartAttribute.add("bgColor='99CCFF,FFFFFF'");
				eventChartAttribute.add("bgAlpha='0,0'");
				eventChartAttribute.add("outCnvBaseFontColor='"+fontColor+"'");
				eventChartAttribute.add("canvasLeftMargin='17'");
				eventChartAttribute.add("canvasRightMargin='7'");
				eventChartAttribute.add("canvasTopMargin='5'");
				eventChartAttribute.add("canvasBottomMargin='7'");
				eventChartAttribute.add("showBorder='0'");
				if(isDarkTheme)
				{
					eventChartAttribute.add("showAlternateVGridColor='1'");
					eventChartAttribute.add("alternateVGridColor='393939'");
					eventChartAttribute.add("canvasBgColor='444444'");
					eventChartAttribute.add("canvasbgalpha='100'");
					eventChartAttribute.add("alternateVGridAlpha='100'");
					eventChartAttribute.add("baseFontColor ='"+fontColor+"'");
				}

				String smUrl = null;
				if(isfromSuper)
				{
					smUrl = (String)session.getAttribute("Super_Manager_Url");
				}
				String timeline=iniObj.getValue("Default_HistoricalEvents_Duration","duration");
				if(timeline==null || timeline.trim().equals(""))
					timeline="24 hours";
				String historyXMLData=fusionChart.getXMLforEventHistory(compName,compType,"Custom",actualTimeline,"",eventChartAttribute,isfromSuper,smUrl,"eventUrl1","eventUrl2","eventUrl3");
%>
		<tr>
			<td id="HistoricalEventsBarChart" width="240" height="145" align="center" valign="middle" class="linetop"> 
				<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="250" height="100" id="StackedColumn3D" flashVars="&dataXML=<chart><set value='1'/><set value='2'/></chart>" >
				<param name="FlashVars" value="&dataXML=<%=historyXMLData%>&chartWidth=250&chartHeight=100">
				<param name="quality" value="high" />
				<param name="movie" value="/final/FusionCharts/swf/Bar2D.swf" />
				<embed wmode="transparent" src="/final/FusionCharts/swf/Bar2D.swf" flashVars="&dataXML=<%=historyXMLData%>" quality="high" width="250" height="100" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
				<param name="WMode" value="Transparent">
				</object> -->
				<div id="HistoricalEventsBarChartContainer"></div>
				<script type="text/javascript">
					if  ( FusionCharts( "myHEBChartId" ) )
							FusionCharts( "myHEBChartId" ).dispose();
					var myChart = new FusionCharts( "/final/FusionCharts/swf/Bar2D.swf","myHEBChartId", "250", "100","0","1");
					myChart.setXMLData("<%=historyXMLData%>");
					myChart.setTransparent(true);
					myChart.render("HistoricalEventsBarChartContainer");
				</script>
			</td>
			<td valign="middle" align="center" class="linetop">
				<table border="0" cellpadding="0" cellspacing="0" style="margin-top:3px">
					<tr>
						<td width="5"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_left.png" width="5" height="20"></td>
						<td width="90" class="font_normal11" background="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_bg.png" width="75%" >
						<egui:intnl text="monitor.dashboard.Total Events"/></td>
						<td class="istamBarFont font_normal11" width="60" background="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_bgdark.png" align="center" valign="middle" >  <%=(Integer)events.get("Count")%> </td>
						<td width="5"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_bgdarkright.png" width="5" height="20"></td>
					</tr>
				</table>
				<table border="0" cellpadding="0" cellspacing="0" style="margin-top:3px">
					<tr>
						<td width="5"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_left.png" width="5" height="20"></td>
						<td width="90" class="font_normal11" background="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_bg.png" width="75%" ><egui:intnl text="monitor.dashboard.Avg Duration"/></td>
						<td class="istamBarFont font_normal11" width="60" background="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_bgdark.png" align="center" valign="middle" >  <%=(String)events.get("AvgDuration")%> </td>												
						<td width="5"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_bgdarkright.png" width="5" height="20"></td>
					</tr>
				</table>
				<table border="0" cellpadding="0" cellspacing="0" style="margin-top:3px">
					<tr>
						 <td width="5"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_left.png" width="5" height="20"></td>
						<td width="90" class="font_normal11" background="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_bg.png" width="75%" ><egui:intnl text="monitor.dashboard.Max Duration"/></td>
						<td class="istamBarFont font_normal11" width="60" background="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_bgdark.png" align="center" valign="middle" > <%=(String)events.get("MaxDuration")%> </td>												
						<td width="5"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_bgdarkright.png" width="5" height="20"></td>
					</tr>
				</table>
			</td>
		</tr>
<%
			}
			else
			{
%>
		<tr>
			<td align="center"  width="100%" valign="middle" class="istam_ExclamationText" height="155" colspan="2">
				<img src="/final/images/clear.png" class="iconExclamation"> <br> <egui:intnl text="monitor.dashboard.No events found"/>! 
			</td>
		</tr>
<%
			}
%>

	</table>
				<input type="hidden" id="eventUrl1" value="<%=eventCriticalPageUrl%>"/>
				<input type="hidden" id="eventUrl2" value="<%=eventMajorPageUrl%>"/>
				<input type="hidden" id="eventUrl3" value="<%=eventMinorPageUrl%>"/>
</div>
<%
		}

		if(systemBlocks!=null && systemBlocks.contains("health"))
		{
%>
<div style="margin-left:10px;margin-top:10px;float:left;width:25%;height:180px;border:0px solid red;">
	<table  border="0" width="100%" class="istam_vmborder" cellspacing="0" cellpadding="4" height="100%">
		<tr>
			<td height="25" width="100%" class="istam_data_headbg1"  style="border-right-width:0px"><egui:intnl text="monitor.dashboard.Server Health"/></td>
		</tr>
<%
			Vector healthChartAttributes=new Vector();
			healthChartAttributes.add("palette='2'");
			healthChartAttributes.add("decimals='2'");
			healthChartAttributes.add("enableRotation='0'");
			healthChartAttributes.add("bgColor='99CCFF,FFFFFF'");
			healthChartAttributes.add("bgAlpha='0,0'");
			healthChartAttributes.add("bgRatio='0,100'");
			healthChartAttributes.add("bgAngle='360'");
			healthChartAttributes.add("showBorder='0'");
			healthChartAttributes.add("startingAngle='70'");
			healthChartAttributes.add("baseFontColor ='545454'");
			healthChartAttributes.add("chartLeftMargin ='0'");
			healthChartAttributes.add("chartTopMargin ='0'");
			healthChartAttributes.add("chartBottomMargin ='0'");
			healthChartAttributes.add("chartRightMargin ='0'");
			healthChartAttributes.add("showToolTipShadow ='1'");
			healthChartAttributes.add("pieSliceDepth='7'");
			healthChartAttributes.add("numberSuffix='%'");
			healthChartAttributes.add("showToolTipShadow ='1'");
			healthChartAttributes.add("pieOuterFaceAlpha  ='75'");
			healthChartAttributes.add("pieYScale  ='60'");
			healthChartAttributes.add("smartLineColor  ='000000'");
			healthChartAttributes.add("smartLabelClearance  ='10'");
			healthChartAttributes.add("captionPadding  ='0'");
			healthChartAttributes.add("bgSWFAlpha  ='0'");
			healthChartAttributes.add("enableSmartLabels='1'");
			healthChartAttributes.add("pieRadius='45'");

			String xmlData=fusionChart.getXMLtoHealth(compName,compType,"Custom",healthChartAttributes);
%>
		<tr>
			<td height="145" width="100%" align="center" valign="middle" class="linetop">
				<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="230" height="110" id="StackedColumn3D" flashVars="&dataXML=<chart><set value='1'/><set value='2'/></chart>" >
					<param name="FlashVars" value="&dataXML=<%=xmlData%>&chartWidth=230&chartHeight=110">
					<param name="quality" value="high" />
					<param name="movie" value="/final/FusionCharts/swf/Pie3D.swf" />
					<param name="WMode" value="Transparent">
					<embed wmode="transparent" src="/final/FusionCharts/swf/Pie3D.swf" flashVars="&dataXML=<%=xmlData%>" quality="high" width="230" height="110" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
				</object> -->
				<div id="HistoricalEventsPieChartContainer"  style="height:100%;"></div>
				<script type="text/javascript">
					if  ( FusionCharts( "myHEPChartId" ) )
							FusionCharts( "myHEPChartId" ).dispose();
					var myChart = new FusionCharts( "/final/FusionCharts/swf/Pie3D.swf","myHEPChartId", "230", "110","0","1");
					myChart.setXMLData("<%=xmlData%>");
					myChart.setTransparent(true);
					myChart.render("HistoricalEventsPieChartContainer");
				</script>
			</td>
		</tr>
	</table>
</div>
<%
		}

		Vector allDials=egDashboard.getTokensAsVector(s_allDials,",");
		Vector allDigitals=egDashboard.getTokensAsVector(s_allDigital,",");

		String isThresholdNeed=iniObj.getValue("DIAL_GRAPH_THRESHOLD_VIEW","ApplyThreshold");
		String DialChartNeed=serverDashBrdIni.getValue("Dashboard_Settings","UseDial");
		if(DialChartNeed==null || DialChartNeed.equals(""))
			DialChartNeed="Yes";

		boolean isDialChartNeeded=false;
		if(DialChartNeed!=null && DialChartNeed.equalsIgnoreCase("yes"))
			isDialChartNeeded=true;

		for(int i=0;i<allDials.size();i++)
		{
			String s_testMeasure=(String)allDials.get(i);
			String test=s_testMeasure.substring(0,s_testMeasure.indexOf(":"));
			String measure=s_testMeasure.substring(s_testMeasure.indexOf(":")+1);

			String dial_measureMapping=iniObjTitle.getValue(subject+"_measures_mapping",s_testMeasure);

			if(dial_measureMapping==null || dial_measureMapping.trim().equals(""))
				dial_measureMapping=mappingInfo.getMeasureDescription(test,measure);

			msmtHost=(String)allMsmtHosts.get(test);
			if(msmtHost==null)
				msmtHost="";


			String unit=tablesInfo.getUnitForMeasure(test,measure);
			if(unit!=null && unit.equals("percent"))
				unit="%";

			boolean isFullView=false;
			Vector infos=(Vector)allTestInfos.get(test);
			if(infos!=null && !infos.isEmpty() && infos.size()>1)
			{
				isFullView=true;
			}

			String moreDescriptorUrl = response.encodeURL("/final/monitor/EgCustomMoreInfosDial.jsp?")+"hostName="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&test="+test+"&measure="+measure+"&msmtHost="+msmtHost+"&tab=custom";

%>

<%
			if(specsInfo.isTestRelevantForServer(compType,test) && runningtests.contains(test))
			{
				msmtHost=(String)allMsmtHosts.get(test);

				String measureValue="";
				String measureForDB=dbInfo.getColumnForMeasure(test,measure);
				Vector allInfos=(Vector)allTestInfos.get(test);
				String info="+";

				Vector topInfoWithMeasure=dashboardDAO.getCurrentForTop(hostName,portNo,test,measureForDB,msmtHost,true,1,true);

				if(topInfoWithMeasure!=null && topInfoWithMeasure.size()>1)
				{
					info=(String)topInfoWithMeasure.get(0);
				}

				msmtHost=(String)allMsmtHosts.get(test);

				info=fusionChart.getInfoForDial(test,measure,compType,hostName,portNo,msmtHost,"NULL",sid,isThresholdNeed);

				if(info!=null && info.indexOf("+")!=-1)
					info=info.substring(info.indexOf("+")+1);

				info=StringUtils.replace(info, "+", "|plus|");
				String layerName=dashboardDAO.getLayerForTest(compType,test,measure);

				String compTypeForAlarm=compType;
				if(layerName!=null && (layerName.equalsIgnoreCase("HOST") || layerName.equalsIgnoreCase("NETWORK") || layerName.equalsIgnoreCase("TCP")))
					compTypeForAlarm="Host_system";

				if(StringUtils.isNull(site))
					site="";

				String measureState=egDashboard.getTestMeasureState(compName,compTypeForAlarm,layerName,test+"-"+info,measure);
				String layerPageUrl ="/final/servlet/com.eg.EgDashboardController?from=list&tab=LayerModel&toDashBoardLayer=true&qctr=2&fromPage=componentList&fromalarm=null&host="+EgURLEncoder.encode(compName,"UTF-8")+"&comptype="+EgURLEncoder.encode(compType,"UTF-8")+"&layer="+EgURLEncoder.encode(layerName,"UTF-8")+"&site="+site+"&test="+EgURLEncoder.encode((test+"-"+info),"UTF-8")+"&tstate="+measureState+"&msmt_host=";
			//	String layerPageUrl=response.encodeURL("/final/monitor/egDashBoardLayers.jsp?")+"qctr=2&fromPage=componentList&host="+EgURLEncoder.encode(compName,"UTF-8")+"&comptype="+compType+"&layer="+layerName+"&site="+site+"&test="+test+"-"+EgURLEncoder.encode(info,"UTF-8")+"&tstate="+measureState+"&msmt_host=";
				boolean isTestHas_CutOffFactor=false;
				if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
				{
					if(egDashboard.isTestHasCutOffFactor(test))
					{
						boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,test,msmtHost,"+"+info);
						if(isTestExceededCutOffFactor)
							isTestHas_CutOffFactor=true;
					}
				}
				Vector chartAttributes=new Vector();
				String dialXMLData="";
				if(isDialChartNeeded)
				{
					chartAttributes.add("fillAngle='60'");
					chartAttributes.add("majorTMNumber='6'");
					chartAttributes.add("majorTMHeight='8'");
					chartAttributes.add("majorTMColor='e5e5e5'");
					chartAttributes.add("minorTMColor='e5e5e5'");
					chartAttributes.add("minorTMHeight='4'");
					chartAttributes.add("minorTMNumber='6'");
					chartAttributes.add("majorTMThickness='1'");
					chartAttributes.add("markerRadius='30'");
					chartAttributes.add("showGaugeBorder='0'");
					chartAttributes.add("gaugeOuterRadius='65'");
					chartAttributes.add("gaugeOriginX='90'");
					chartAttributes.add("gaugeOriginY='80'");
					chartAttributes.add("gaugeInnerRadius='0'");
					chartAttributes.add("formatNumberScale='0'");
					chartAttributes.add("displayValueDistance='0'");
					chartAttributes.add("decimalPrecision='2'");
					chartAttributes.add("tickMarkDecimalPrecision='2'");
					chartAttributes.add("tickValueDistance='14'");
					chartAttributes.add("pivotRadius='6'");
					chartAttributes.add("showPivotBorder='1'");
					chartAttributes.add("pivotBorderColor='000000'");
					chartAttributes.add("pivotBorderThickness='5'");
					chartAttributes.add("pivotFillMix='FFFFFF,000000'");
					chartAttributes.add("paletteThemeColor='ffffff'");
					chartAttributes.add("pivotFillType='linear'");
					chartAttributes.add("showToolTip='1'");
					chartAttributes.add("chartLeftMargin='0'");
					chartAttributes.add("chartRightMargin='0'");
					chartAttributes.add("chartBottomMargin='0'");
					chartAttributes.add("chartTopMargin='0'");
					chartAttributes.add("baseFontColor='"+fontColor+"'");
					chartAttributes.add("adjustTM='0'");
					chartAttributes.add("borderAlpha='0'");
					chartAttributes.add("bgAlpha='0,0'");
					chartAttributes.add("bgColor='99CCFF,FFFFFF'");
					chartAttributes.add("showToolTipShadow='1'");
					chartAttributes.add("toolTipBgColor='"+tooltipBgColor+"'");
					chartAttributes.add("toolTipBorderColor='555555'");
					chartAttributes.add("exportEnabled='0'");
					chartAttributes.add("exportAction='download'");
					chartAttributes.add("exportAtClient='0'");
					chartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");		chartAttributes.add("clickURL='javascript:dialOnclick(&apos;dialUrl"+i+"&apos;)'");
					dialXMLData=fusionChart.getXMLDataForDial(test,measure,compType,hostName,portNo,msmtHost,"NULL",sid,isThresholdNeed,chartAttributes,fontColor);
				}
				else
				{
					chartAttributes.add("clickURL='javascript:dialOnclick(&apos;dialUrl"+i+"&apos;)'");
					chartAttributes.add("upperLimit='100'");
					chartAttributes.add("bgColor='99CCFF,FFFFFF'");
					chartAttributes.add("bgAlpha='0,0'");
					chartAttributes.add("showBorder='0'");
					chartAttributes.add("adjustTM='0'");
					chartAttributes.add("lowerLimit='0'");
					chartAttributes.add("decimals='2'");
					chartAttributes.add("showValue='0'");
					chartAttributes.add("majorTMNumber='5'");
					chartAttributes.add("majorTMColor='000000'");
					chartAttributes.add("majorTMHeight='5'");
					chartAttributes.add("minorTMNumber='2'");
					chartAttributes.add("minorTMColor='000000'");
					chartAttributes.add("minorTMHeight='2'");
					chartAttributes.add("majorTMThickness='1'");
					chartAttributes.add("decimalPrecision='0'");
					chartAttributes.add("ledGap='1'");
					chartAttributes.add("ledSize='1'");
					chartAttributes.add("tickValueDistance='2'");
					chartAttributes.add("tickMarkDistance='1'");
					chartAttributes.add("tickValueStep='1'");
					chartAttributes.add("tickValueDecimals='8'");
					chartAttributes.add("chartLeftMargin='45'");
					chartAttributes.add("chartRightMargin='25'");
					chartAttributes.add("chartTopMargin='21'");
					chartAttributes.add("chartBottomMargin='30'");
					chartAttributes.add("baseFontSize ='9'");
					chartAttributes.add("showToolTip='1'");
					chartAttributes.add("baseFontColor='"+fontColor+"'");
					chartAttributes.add("annRenderDelay='1.7'");
					chartAttributes.add("exportEnabled='0'");
					chartAttributes.add("exportAction='download'");
					chartAttributes.add("exportAtClient='0'");
					chartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
					dialXMLData=fusionChart.getXMLDataForDial(test,measure,compType,hostName,portNo,msmtHost,"NULL",sid,isThresholdNeed,chartAttributes,fontColor,true);
				}


				if(dialXMLData!=null && dialXMLData.trim().length()>0 && !isTestHas_CutOffFactor)
				{
%>
<div style="float:left;margin-left:10px;margin-top:10px;width:24%;height:180px;border:0px solid blue;">
	<table border="0" cellspacing="0" cellpadding="2" class="istam_vmborder" width="100%" height="100%">
		<tr>
			<td height="25"  class="istam_data_headbg1" width="100%" style="border-right-width:0px"> <%=dial_measureMapping%>(<%=unit%>)
<%
					if(isFullView)
					{
%>
				<a class="mouse eg_monlink" onclick="javascript:showMaximizedView('<%=moreDescriptorUrl%>',event,'loadPageForDial');" title="More" ><img  border="0" src="/final/monitor/eg_images/<%=monitor_Skin%>/iconNewWindow.png"/></a>
<%
					}
%>
			</td>
		</tr>
		<tr>
			<td align="center"  width="100%"  class="linetop" height="145" valign="middle">
				<%
						if(isDialChartNeeded)
						{
%>
							<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="180" height="115" id="StackedColumn3D" >
							<param name="movie" value="/final/FusionCharts/swf/AngularGauge.swf" />
							<param name="FlashVars" value="&dataXML=<%=dialXMLData%>&chartWidth=180&chartHeight=115">
							<param name="quality" value="high" />
							<param name="WMode" value="Transparent">
							<embed wmode="transparent" src="/final/FusionCharts/swf/AngularGauge.swf" flashVars="&dataXML=<%=dialXMLData%>" quality="high" width="180" height="115" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
							</object> -->
							<div id="AngularGaugeChartContainer<%=i%>"></div>
							<script type="text/javascript">
								if  ( FusionCharts( "myAGChartId<%=i%>" ) )
										FusionCharts( "myAGChartId<%=i%>" ).dispose();
								var myChart = new FusionCharts( "/final/FusionCharts/swf/AngularGauge.swf","myAGChartId<%=i%>", "180", "115","0","1");
								myChart.setXMLData("<%=dialXMLData%>");
								myChart.setTransparent(true);
								myChart.render("AngularGaugeChartContainer<%=i%>");
							</script>
<%	
						} 
						else
						{
%>
							<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="140" height="130" id="StackedColumn3D" >
							<param name="movie" value="/final/FusionCharts/swf/VLED.swf" />
							<param name="FlashVars" value="&dataXML=<%=dialXMLData%>&chartWidth=140&chartHeight=132">
							<param name="quality" value="high" />
							<param name="WMode" value="transparent" />
							<embed wmode="transparent" src="/final/FusionCharts/swf/VLED.swf" flashVars="&dataXML=<%=dialXMLData%>" quality="high" width="140" height="130" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
							</object> -->
							<div id="VLEDChartContainer<%=i%>"></div>
							<script type="text/javascript">
								if  ( FusionCharts( "myVLEDChartId<%=i%>" ) )
										FusionCharts( "myVLEDChartId<%=i%>" ).dispose();
								var myChart = new FusionCharts( "/final/FusionCharts/swf/VLED.swf","myVLEDChartId<%=i%>", "140", "130","0","1");
								myChart.setXMLData("<%=dialXMLData%>");
								myChart.setTransparent(true);
								myChart.render("VLEDChartContainer<%=i%>");
							</script>
<%	
						}
%>
				<input type="hidden" id="dialUrl<%=i%>" value="<%=layerPageUrl%>"/>
			</td>
<%
				}
				else
				{
%>
<div style="float:left;margin-left:10px;margin-top:10px;width:24%;height:180px;border:0px solid blue;">
	<table border="0" cellspacing="0" cellpadding="2" class="istam_vmborder" width="100%" height="100%">
		<tr>
			<td height="25"  class="istam_data_headbg1" width="100%" style="border-right-width:0px"> <%=dial_measureMapping%>(<%=unit%>)
			</td>
		</tr>
		<tr>
			<td align="center"  width="100%" valign="middle" class="linetop istam_ExclamationText" height="155" >
				<img src="/final/images/clear.png" class="iconExclamation"> <br> <egui:intnl text="monitor.dashboard.No measures available"/>! 
			</td>
<%
				}
			}
			else
			{
%>
<div style="float:left;margin-left:10px;margin-top:10px;width:24%;height:180px;border:0px solid blue;">
	<table border="0" cellspacing="0" cellpadding="2" class="istam_vmborder" width="100%" height="100%">
		<tr>
			<td height="25"  class="istam_data_headbg1" width="100%" style="border-right-width:0px"> <%=dial_measureMapping%>(<%=unit%>)
			</td>
		</tr>
		<tr>
			<td align="center"  width="100%" valign="middle" class="linetop istam_ExclamationText" height="155">
				<img src="/final/images/clear.png" class="iconExclamation"> <br> <egui:intnl text="monitor.dashboard.No measures available"/>!
			</td>
<%
			}
%>
		</tr>
	</table>
</div>
<%
		}


		for(int i=0;i<allDigitals.size();i++)
		{
			String s_testMeasure=(String)allDigitals.get(i);

			String test=s_testMeasure.substring(0,s_testMeasure.indexOf(":"));
			String measure=s_testMeasure.substring(s_testMeasure.indexOf(":")+1);

			String digital_measureMapping=iniObjTitle.getValue(subject+"_measures_mapping",s_testMeasure);

			if(digital_measureMapping==null || digital_measureMapping.trim().equals(""))
				digital_measureMapping=mappingInfo.getMeasureDescription(test,measure);

			msmtHost=(String)allMsmtHosts.get(test);

			String unit=tablesInfo.getUnitForMeasure(test,measure);
			if(unit!=null && unit.equals("percent"))
				unit="%";
%>
<div style="float:left;margin-left:10px;margin-top:10px;width:24%;height:180px;border:0px solid blue;">
	<table border="0" cellspacing="0" cellpadding="2" class="istam_vmborder"  width="100%" height="100%">
		<tr>
			<td height="25"  class="istam_data_headbg1" width="100%" style="border-right-width:0px" ><%=digital_measureMapping%>(<%=unit%>)
			</td>
		</tr>
		<tr>
<%
			if(specsInfo.isTestRelevantForServer(compType,test) && runningtests.contains(test))
			{
				msmtHost=(String)allMsmtHosts.get(test);

				String measureValue="";
				String toolTipmeasureValue="";
				String measureForDB=dbInfo.getColumnForMeasure(test,measure);
				Vector allInfos=(Vector)allTestInfos.get(test);
				String info="+";

				Vector topInfoWithMeasure=dashboardDAO.getCurrentForTop(hostName,portNo,test,measureForDB,msmtHost,true,1,true);

				if(topInfoWithMeasure!=null && topInfoWithMeasure.size()>1)
				{
					info=(String)topInfoWithMeasure.get(0);
					toolTipmeasureValue=(String)topInfoWithMeasure.get(1);
				}

				if(toolTipmeasureValue!=null && !toolTipmeasureValue.equals(""))
					measureValue=erutils.round(Double.parseDouble(toolTipmeasureValue),2);

					int digitalChartWidth=100;

					if(measureValue!=null && (measureValue.length()*17)>100)
						digitalChartWidth=(measureValue.length()*17);

				String layerName=dashboardDAO.getLayerForTest(compType,test,measure);

				String compTypeForAlarm=compType;
				if(layerName!=null && (layerName.equalsIgnoreCase("HOST") || layerName.equalsIgnoreCase("NETWORK") || layerName.equalsIgnoreCase("TCP")))
					compTypeForAlarm="Host_system";

				if(info!=null && info.indexOf("+")!=-1)
					info=info.substring(info.indexOf("+")+1);
				info=StringUtils.replace(info, "+", "|plus|");

				String measureState=egDashboard.getTestMeasureState(compName,compTypeForAlarm,layerName,test+"-"+info,measure);

				String layerPageUrl ="/final/servlet/com.eg.EgDashboardController?from=list&tab=LayerModel&toDashBoardLayer=true&qctr=2&fromPage=componentList&fromalarm=null&host="+compName+"&comptype="+compType+"&layer="+layerName+"&site="+site+"&test="+(test+"-"+info)+"&tstate="+measureState+"&msmt_host=";

				//String layerPageUrl=response.encodeURL("/final/monitor/egDashBoardLayers.jsp?")+"qctr=2&fromPage=componentList&host="+compName+"&comptype="+compType+"&layer="+layerName+"&site="+site+"&test="+test+"-"+info+"&tstate="+measureState+"&msmt_host=";
				boolean isTestHas_CutOffFactor=true;
				if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
				{
					if(egDashboard.isTestHasCutOffFactor(test))
					{
						boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,test,msmtHost,"+"+info);
						if(!isTestExceededCutOffFactor)
							isTestHas_CutOffFactor=false;
					}
				}
				if(!isTestHas_CutOffFactor && (measureValue!=null && (!measureValue.trim().equals("") && !measureValue.trim().equals("-5") && !measureValue.trim().equals("-1")) && !testerInfo.getAllowNegativeValues(test,measure)) || (testerInfo.getAllowNegativeValues(test,measure)))
				{
					if(testerInfo.getAllowNegativeValues(test,measure))
					{
						measureValue=StringUtils.replace(measureValue,"+","");
					}
%>
			<td align="center" width="100%" valign="middle" height="155" class="linetop">
				<a class="eg_monlink" href='javascript:DrillDownTolayerModel("<%=layerPageUrl%>");'><img border="0" src="../servlet/com.egurkha.monitor.egDigitalChart?width=<%=digitalChartWidth%>&height=40&value=<%=measureValue%>&forecolor=00FF00&background=999999&background1=999999"
				title="<%=StringUtils.replace(info,"+","")+"("+toolTipmeasureValue+")"%>"/></a>
			</td>
<%
				}
				else
				{
%>
			<td align="center"  width="100%" valign="middle" height="155" class="linetop istam_ExclamationText">
				<img src="/final/images/clear.png" class="iconExclamation"> <br> <egui:intnl text="monitor.dashboard.No measures available"/>!
			</td>
<%
				}
			}
			else
			{
%>
			<td align="center"  width="100%" valign="middle" class="linetop istam_ExclamationText" height="155">
				<img src="/final/images/clear.png" class="iconExclamation"> <br> <egui:intnl text="monitor.dashboard.No measures available"/>!
			</td>
<%
			}
%>
		</tr>
	</table>
</div>
<%
		}


		if(systemBlocks!=null && systemBlocks.contains("config"))
		{
			Vector configData=egDashboard.getConfig(compName,compType,configIniVal);
%>
<div style="margin-left:10px;margin-top:10px;float:left;width:463px;height:180px;border:0x solid magenta;" id="div<%=++divCount%>" >
	<table border="0" cellpadding="0"  cellspacing="0" height="100%" width="100%" class="istam_vmborder" valign="top"><col width="95%"><col width="5%">
		<tr>
			<td class="istam_data_headbg1" height="25" onmousedown="startDragBox(<%=divCount%>,event)"><egui:intnl text='<%="monitor.dashboard."+tab+" Configuration"%>'/></td>
			<td class="istam_data_headbg1" valign="middle" align="right" height="25px" onclick="javascript:showMaximizedTable('event','ConfigDataDiv','','img<%=divCount%>','<%=configTitleStr%>');"><img id="img<%=divCount%>" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_maximize_div.png" class="mouse" /></td>
		</tr>
		<tr>
			<td width="100%" valign="top" colspan="2" height="155">
			<div id="ConfigDataDiv" class="istam_div_scroll" style="border:0px solid #ff0000;width:100%;height:155px">
<%
			configDivCount=""+divCount;
			if(configData!=null && configData.size()>0)
			{
%>
				<table border="0" width="100%"  class="tableborder_jvm" cellpadding="3" cellspacing="0" valign="top" style="border-top-width:0px">
<%
				for(int c=0;c<configData.size();c=c+2)
				{
					String testMeasure=(String)configData.get(c);
					String configration=(String)configData.get(c+1);
					if(testMeasure!=null && testMeasure.equalsIgnoreCase("selected_info"))
					{
						String testNameForConfig=configration.substring(0,configration.indexOf("|"));
						configration=configration.substring(configration.indexOf("|")+1,configration.length());
						configration=StringUtils.replace(configration,"+","");
%>
					<tr>
						<td colspan="2" class="font_bold11 tdborder2_jvm" height="25px" style="border-top-width:0px"><egui:intnl test="<%=testNameForConfig%>" />&nbsp; - &nbsp;<%=configration%></td>
					</tr>

<%					}
					else if(testMeasure!=null && testMeasure.equalsIgnoreCase("selected_test"))
					{
%>
					<tr>
						<td colspan="2" class="font_bold11 tdborder2_jvm" height="25px" style="border-top-width:0px"><egui:intnl test="<%=configration%>" /></td>
					</tr>
<%					}
					else if(testMeasure!=null && testMeasure.equalsIgnoreCase("empty_row"))
					{
%>
					<tr>
						<td colspan="2" class="tdborder_jvm font_bold11" style="border-top-width:0px" height="25px"></td>
					</tr>

<%					}
					else
					{
						String measureNameMapping=iniObjTitle.getValue(subject+"_measures_mapping",testMeasure);
						String testName = testMeasure.substring(0,testMeasure.indexOf(":"));
						String measureName = testMeasure.substring(testMeasure.indexOf(":")+1,testMeasure.length());
						if(measureNameMapping==null || measureNameMapping.trim().equals(""))
							measureNameMapping=mappingInfo.getMeasureDescription(testName,measureName);

						
							if(measureNameMapping.equalsIgnoreCase("Installed"))
									configration="Yes";
%>
					<tr>
						<td class="tdborder_jvm font_bold11" wrap><%=measureNameMapping%></td>
						<td class="tdborder_jvm font_normal11" wrap><%=configration%></td>
					</tr>
<%

					}
				}
%>
				</table>
<%
			}
			else
			{
%>
				<table border="0" width="100%"  cellpadding="3" cellspacing="0" valign="top">
					<tr>
						<td align="center" colspan="2" height="155" valign="middle" width="100%">
							<table border="0" cellpadding="0" cellspacing="0" width="100%" height="145">
								<tr>
									<td align="center" height="100%" valign="middle" class="istam_ExclamationText"><img src="/final/images/clear.png" class="iconExclamation"> <br > <egui:intnl text="monitor.dashboard.Configuration details are not available"/>! </td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
<%
			}
%>
			</div>
			</td>
		</tr>
	</table>
</div>
<%
		}

		if(systemBlocks!=null && systemBlocks.contains("Indicators"))
		{
			Vector allIndicators=egDashboard.getTokensAsVector(s_allIndicators,",");
			Hashtable sortedIndicators=egDashboard.getPerformanceIndicators(compName,compType,allIndicators,site,"custom");
			String kpiFullViewURL=response.encodeURL("/final/monitor/egCustomDashboardp.jsp")+"?"+"compName="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&subject="+EgURLEncoder.encode(subject,"UTF-8")+"&site="+site+"&tab=custom&defaultMGraphDuration="+defaultMGraphDuration+"&defaultSparklineDuration="+EgURLEncoder.encode(defaultSparklineDuration,"UTF-8")+"&divCount="+divCount+"&state=&blockType=KPI&tab=custom";
%>
<div style="margin-left:10px;margin-top:10px;float:left;width:45%;height:180px;border:0px solid red" id="div<%=++divCount%>" >
	<table border="0" cellpadding="0" cellspacing="0"  width="100%" class="istam_vmborder"><col width="95%"><col width="5%">
		<tr>
			<td class="istam_data_headbg1" height="25" onmousedown="startDragBox(<%=divCount%>,event)"><egui:intnl text="monitor.dashboard.Key Performance Indicators" /> </td>
			<td class="istam_data_headbg1" valign="middle" align="right" height="25px" onclick="javascript:showMaximizedView('<%=kpiFullViewURL%>','event','DDComparisonTablefullView');"><img  id="img<%=divCount%>" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_maximize_div.png" class="mouse"/></td>
		</tr>
		<tr>
			<td width="100%" valign="top" colspan="2"  height="155">
			<div class="istam_div_scroll istamViewTable" style="border:0px solid #ff0000;height:155px;">
				<table border="0" width="100%" cellpadding="3" cellspacing="0" valign="top">
<%
			Vector states=new Vector();
			states.add("HIGH");
			states.add("INTERMEDIATE");
			states.add("LOW");
			states.add("UNKNOWN");
			states.add("GOOD");

			boolean showNoMeasure=true;
			int kpiSparkCount=0;
			if(sortedIndicators!=null && sortedIndicators.size()>0)
			{
				Iterator ptr=states.iterator();
				while(ptr.hasNext())
				{
					String  keyState = (String)ptr.next();
					Vector indicators=(Vector)sortedIndicators.get(keyState);

					if(indicators!=null && indicators.size()>0)
					{
						for(int  indicatorCount=0;indicatorCount<indicators.size();indicatorCount++)
						{
							String perfIndicatorValue=(String)indicators.get(indicatorCount);
							String tstmeasure ="";
							String desc="";
							String  indicURL="";

							if(perfIndicatorValue.indexOf("{")!=-1)
							{
								tstmeasure = perfIndicatorValue.substring(0,perfIndicatorValue.indexOf("{"));
								desc = perfIndicatorValue.substring(perfIndicatorValue.indexOf("{")+1,perfIndicatorValue.indexOf("}"));
							}
							else if(perfIndicatorValue.indexOf("@")!=-1)
							{
								tstmeasure = perfIndicatorValue.substring(0,perfIndicatorValue.indexOf("@"));
							}

							if(perfIndicatorValue.indexOf("@")!=-1)
								indicURL=perfIndicatorValue.substring(perfIndicatorValue.indexOf("@")+1,perfIndicatorValue.length());

							String cur_Measure = "";
							String dispInfo="";

							if(desc!=null && !desc.equals("+") && !desc.equals("") && !desc.equals("Summary"))
							{
								dispInfo=" {"+desc+"}";
							}
							String testname="",testmeasure="";
							if(tstmeasure!=null && tstmeasure.indexOf(":")>0)
							{
								testname=tstmeasure.substring(0,tstmeasure.indexOf(":"));
								testmeasure=tstmeasure.substring(tstmeasure.indexOf(":")+1);
							}

							String kpimeasureForDB=dbInfo.getColumnForMeasure(testname,testmeasure);
							String infoForSparkline="+"+desc;

							msmtHost=(String)allMsmtHosts.get(testname);

							if(infoForSparkline!=null && infoForSparkline.indexOf("*")==-1)
								infoForSparkline="*"+infoForSparkline;

							Vector topInfoWithMeasure=dashboardDAO.getCurrentForTop(hostName,portNo,testname,kpimeasureForDB,msmtHost,true,1,true);

							if(topInfoWithMeasure!=null && topInfoWithMeasure.size()>=2)
							{
								infoForSparkline=(String)topInfoWithMeasure.get(0);
								cur_Measure=(String)topInfoWithMeasure.get(1);
							}

							String sidForSparkline=sid;
							String layerName="";
							if(compType.equalsIgnoreCase("Oracle_server"))
							{
							layerName=dashboardDAO.getLayerForTest(compType,testname,testmeasure);
							if(layerName!=null && !layerName.equals("") && (!layerName.equalsIgnoreCase("HOST") || !layerName.equalsIgnoreCase("NETWORK") || !layerName.equalsIgnoreCase("TCP")))
								sidForSparkline=null;
							}
							if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
							{
								if(egDashboard.isTestHasCutOffFactor(testname))
								{
									boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,testname,msmtHost,infoForSparkline);
									if(isTestExceededCutOffFactor)
										continue;
								}
							}
							showNoMeasure=false;
							String graph_values=dashboardDAO.getGraphValuesForSpark(hostName,infoForSparkline,sidForSparkline,testname,kpimeasureForDB,sparkLineStartTime+" "+sparkLineStartHour+":"+endDate.getMinutes()+":00",sparkLineEndTime+" "+sparkLineEndHour+":"+endDate.getMinutes()+":00");

							boolean allowNegativeValues = false;
							StringTokenizer commaTokenizer = new StringTokenizer(graph_values,",");
							while(commaTokenizer.hasMoreTokens())
							{
								String split_mes=(String)commaTokenizer.nextToken();
								if(split_mes!=null && split_mes.trim().length()>0)
								allowNegativeValues=testerInfo.getAllowNegativeValues(testname,split_mes);

								if(allowNegativeValues)
									break;
							}

							if(cur_Measure==null || cur_Measure.trim().equals("") || cur_Measure.trim().equals("-5") || cur_Measure.trim().equals("-1") && !testerInfo.getAllowNegativeValues(testname,testmeasure))
								cur_Measure="-";
							String unitValue = tablesInfo.getUnitForMeasure(testname,testmeasure);
							if(unitValue.equals("boolean"))
							{
								if(cur_Measure.equals("0"))
									cur_Measure="No";
								else if(cur_Measure.equals("1"))
									cur_Measure="Yes";
							}

							String kpiMeasureMapping=iniObjTitle.getValue(subject+"_measures_mapping",tstmeasure);
							if(kpiMeasureMapping==null || kpiMeasureMapping.trim().equals(""))
								kpiMeasureMapping=mappingInfo.getMeasureDescription(testname,testmeasure);

							Vector infos=dashboardDAO.getInfosbyMeasure(testname,hostName,portNo,kpimeasureForDB,site,sparkLineStartTime+" "+sparkLineStartHour+":"+endDate.getMinutes()+":00",sparkLineEndTime+" "+sparkLineEndHour+":"+endDate.getMinutes()+":00","custom");
							if(infos.indexOf("+")>=0)
							{
								infos.remove(infos.indexOf("+"));
							}
							String overviewinfo="";
							boolean infoRelevant=false;
							for(int j=0;j<infos.size();j++)
							{
								overviewinfo += StringUtils.replace((String)infos.get(j),"+","*")+",";
							}

							if((overviewinfo.equalsIgnoreCase("*,") || overviewinfo.equalsIgnoreCase("+*,") || overviewinfo.equalsIgnoreCase("+,")))
							{
								overviewinfo="";	
							}
							if(infos!=null && infos.size()>1)
							{
								infoRelevant=true;
							}
							String siteForKPI=site;
							if(specsInfo.isSiteRelevantForTest(testname))
							{
								siteForKPI=site;
							}
							else
							{
								siteForKPI="NULL";
							}
							String urlForMaximize=response.encodeURL("/final/servlet/com.egurkha.monitor.EgCustomDashboardTimelineChart?")+"sid="+sid+"&measure="+kpimeasureForDB+"&starttime="+startTime+"&port="+portNo+"&comptype="+compType+"&mode=3D&site="+siteForKPI+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&monitorSkin="+monitor_Skin+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&gtype=1&starthr="+startHour+"&test="+testname+"&info="+overviewinfo+"&layer=HOST&endtime="+endTime+"&endhr="+endHour+"&showRange=Range&gformat=graph&fromDashboard=true&timeline_compare="+defaultMGraphDuration+"&width=880&height=320&threshold=no&title=true&minmaxavgRequired=true&priority=TOP+-+10&isInfoReleventGraph="+infoRelevant+"&module=custom";

							if(graph_values.length()>1700)
								graph_values = graph_values.substring(0,1700);
							Vector spartLineAttributes=new Vector();
							spartLineAttributes.add("palette='2'");
							spartLineAttributes.add("setAdaptiveYMin='1'");
							spartLineAttributes.add("bgAlpha='0,0'");
							spartLineAttributes.add("lineColor='"+iniObj.getValue("Dashboard_Graph_colors","Sparkline")+"'");
							spartLineAttributes.add("showHighAnchor ='0'");
							spartLineAttributes.add("showLowAnchor ='0'");
							spartLineAttributes.add("showOpenValue ='0'");
							spartLineAttributes.add("showCloseValue ='0'");
							spartLineAttributes.add("showHighLowValue ='0'");
							spartLineAttributes.add("showOpenAnchor ='0'");
							spartLineAttributes.add("showCloseAnchor ='0'");
							spartLineAttributes.add("clickURL='javascript:sparklineOnclick(&apos;kpisparkurl"+kpiSparkCount+"&apos;)'");

							Vector sparkValues=egDashboard.getTokensAsVector(graph_values,",");
							String sparkXML=fusionChart.getXMLForSpark(sparkValues,spartLineAttributes);

							if(isfromSuper)
							{
								if(indicURL.indexOf("?") > -1)
								{
									String url = indicURL.substring(0,indicURL.indexOf("?")+1);
									indicURL = response.encodeURL(url)+indicURL.substring(indicURL.indexOf("?")+1);
								}
							}
%>
					<tr>
						<td style="width:14px;"><img src ="/final/monitor/eg_images/<%=monitor_Skin%>/bullet_<%=keyState%>.png"> </td>
						<td> <a class = "eg_monlink" href ='javascript:kpiOnClick("kpilayerModelURL<%=kpiSparkCount%>");'> <%=kpiMeasureMapping%> (<%=unitValue%>) <%=dispInfo%> </a></td>
						<td align="right" >
<%
						if(sparkValues!=null && sparkValues.size()>0)
						{
%>
							<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="100" height="20" id="StackedColumn3D" >
								<param name="movie" value="/final/FusionCharts/swf/SparkLine.swf" />
								<param name="FlashVars" value="&dataXML=<%=sparkXML%>&chartWidth=100&chartHeight=20">
								<param name="quality" value="high" />
								<param name="WMode" value="Transparent">
								<embed wmode="transparent" src="/final/FusionCharts/swf/SparkLine.swf" flashVars="&dataXML=<%=sparkXML%>" quality="high" width="100" height="20" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
							</object> -->
							<div id="SparkLineChartContainer<%=kpiSparkCount%>"  style="height:100%;"></div>
							<script type="text/javascript">
								if  ( FusionCharts( "mySparkLineChartId<%=kpiSparkCount%>" ) )
										FusionCharts( "mySparkLineChartId<%=kpiSparkCount%>" ).dispose();
								var myChart = new FusionCharts( "/final/FusionCharts/swf/SparkLine.swf","mySparkLineChartId<%=kpiSparkCount%>", "100", "20","0","1");
								myChart.setXMLData("<%=sparkXML%>");
								myChart.setTransparent(true);
								myChart.render("SparkLineChartContainer<%=kpiSparkCount%>");
							</script>
							<input type="hidden" id="kpisparkurl<%=kpiSparkCount%>"  value="<%=urlForMaximize%>"/>
							
							
<%
						}
						else
						{
%>
							&nbsp;
<%
						}
%>
						<input type="hidden" id="kpilayerModelURL<%=kpiSparkCount%>"  value="<%=indicURL%>"/>
						</td>
						<td align="right" > <%=cur_Measure%> </td>
					</tr>
<%
							kpiSparkCount++;
						}
					}
				}
			}

			if(showNoMeasure)
			{
%>
					<tr>
						<td align="center" valign="middle" height="154" class="istam_ExclamationText">
							<img src="/final/images/clear.png" class="iconExclamation"><br > <egui:intnl text="monitor.dashboard.No measures available"/>!
						</td>
					</tr>
<%
			}
%>
				</table>
			</div>
			</td>
		</tr>
	</table>
</div>
<%
		}


		if(s_AllComparisionTable!=null && !s_AllComparisionTable.equals(""))
		{
			Vector compareTableData=egDashboard.getTokensAsVector(s_AllComparisionTable,"#");

			int tablescount=0;
			int imgcnt=0;
			int stColPos=1;
			int endColPos=0;

			String test="";
			String measure="";

			for(int i=0;i<compareTableData.size();i++)
			{
				String s_alltestmeasure=(String)compareTableData.get(i);

				String info="+";

				Vector allMeasures=egDashboard.getTokensAsVector(s_alltestmeasure,",");

				String tempTestName="";
				if(allMeasures.size()>0)
				{
					tempTestName=(String)allMeasures.get(0);
					if(tempTestName!=null && tempTestName.indexOf(":")!=-1)
						tempTestName=tempTestName.substring(0,tempTestName.indexOf(":"));
				}

				String tableTitle=iniObjTitle.getValue(subject+"_TableTitle",tempTestName);
				if(tableTitle!=null && tableTitle.equals(""))
				{
					tableTitle=mappingInfo.getTestDescription(tempTestName);
				}

				Vector allInfos=(Vector)allTestInfos.get(tempTestName);
				//here we have removed the sid from all infos
				if(allInfos!=null && allInfos.size()>0)
					allInfos.remove(sid+"+");

				boolean hasInfos=(allInfos!=null && allInfos.size()>0 && !(allInfos.size()==1 && allInfos.contains("+")));

				String comparisonTableFullViewURL=response.encodeURL("/final/monitor/egCustomDashboardp.jsp")+"?"+"compName="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&subject="+EgURLEncoder.encode(subject,"UTF-8")+"&site="+site+"&defaultMGraphDuration="+defaultMGraphDuration+"&defaultSparklineDuration="+EgURLEncoder.encode(defaultSparklineDuration,"UTF-8")+"&divCount="+divCount+"&blockType=comparisontable&tableIdx="+tablescount+"&tab=custom";
				if(hasInfos)
				{
					if(s_alltestmeasure!=null && (s_alltestmeasure.trim().equals("SystemTest:Cpu_util") || s_alltestmeasure.trim().equals("EsxCpuTest:Usage")))
					{
						test=s_alltestmeasure.substring(0,s_alltestmeasure.indexOf(":"));
						String tempMeasure = s_alltestmeasure.substring(s_alltestmeasure.indexOf(":")+1);
						msmtHost=(String)allMsmtHosts.get(test);
						Vector topInfoWithMeasure=dashboardDAO.getCurrentForTop(hostName,portNo,test,dbInfo.getColumnForMeasure(test,tempMeasure),msmtHost,true,10,true);
						String rsTableName="rsTable"+(tablescount++);
						endColPos+=2;
						String divWidth="99";
						if(allMeasures!=null && allMeasures.size()<=3)
							divWidth="49";
%>
<div class="istam_div_scroll" style="margin-left:10px;margin-top:10px;float:left;width:<%=divWidth%>%;height:180px;border:0px solid orange" id="div<%=++divCount%>" >
	<table border="0" cellspacing="0" cellpadding="0" width="100%" height="100%" class="istam_vmborder"><col width="95%"><col width="5%">
		<tr>
			<td class="istam_data_headbg1" height="25px" style="padding-left:4px" onmousedown="startDragBox(<%=divCount%>,event)"><%=tableTitle%></td>
			<td class="istam_data_headbg1" valign="middle" align="right" style="padding-right:4px" onclick="javascript:showMaximizedView('<%=comparisonTableFullViewURL%>','event','DDComparisonTablefullView');"><img id="img<%=divCount%>" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_maximize_div.png" class="mouse"/></td>
		</tr>
		<tr>
			<td width="100%" valign="top" colspan="2" class="linetop" height="155">
			<div id="comptable<%=i%>" class="istam_div_scroll" style="height:155px;border:0px solid #ff0000;" >
				<table border="0" cellpadding="2" cellspacing="0" width="100%" class="tableborder_jvm" valign="top">
					<tr>
						<td class="font_bold11 tdborder2_jvm" >
							<table cellspacing="0" cellpadding="0"   border="0" width="100%">
								<tr>
									<td class="font_bold11"><a class="eg_monlink" href="" onclick="this.blur();return sortTable('<%=rsTableName%>',0,<%=stColPos%>,<%=endColPos%>,'<%=(imgcnt+1)%>');"><span class="font_bold11"><egui:intnl text='monitor.dashboard.Processor'/>
									</span></a></td>
									<td style="width:15px" class="font_bold11"><img id="imgdd<%=(imgcnt+1)%>" class="mouse" src="/final/monitor/eg_images/<%=monitor_Skin%>/arrow_down_black_small.png" onclick="this.blur();return sortTable('<%=rsTableName%>',0,<%=stColPos%>,<%=endColPos%>,'<%=(imgcnt+1)%>');" style="display:none"/></td>
								</tr>
							</table>
						</td>
						<td class="font_bold11 tdborder2_jvm" >
							<table cellspacing="0" cellpadding="0"   border="0" width="100%">
								<tr>
									<td class="font_bold11"><a class="eg_monlink" href="" onclick="this.blur();return sortTable('<%=rsTableName%>',1,<%=stColPos%>,<%=endColPos%>,'<%=(imgcnt+2)%>');"><span class="font_bold11"><egui:intnl text='monitor.dashboard.CPU Usage'/> (%)</span></a></td>
									<td style="width:15px" class="font_bold11"><img id="imgdd<%=(imgcnt+2)%>" class="mouse" src="/final/monitor/eg_images/<%=monitor_Skin%>/arrow_down_black_small.png" onclick="this.blur();return sortTable('<%=rsTableName%>',1,<%=stColPos%>,<%=endColPos%>,'<%=(imgcnt+2)%>');" style="display:none"/></td>
								</tr>
							</table>
						</td>
						<td class="font_bold11 tdborder2_jvm">
							<table cellspacing="0" cellpadding="0"  border="0" >
								<tr>
									<td>
										<table cellspacing="0" cellpadding="0"  border="0"  width="10px" style="height:10px" class="linesquare">
											<tr>
												<td align="left" style="width:100%" class="cpu_usuage"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/spacer.gif"></td>
											</tr>
										</table>
									</td>
									<td class="font_bold11">&nbsp;<egui:intnl text='monitor.dashboard.Distribution'/></td>
								</tr>
							</table>
						</td>
					</tr>
					<tbody name="<%=rsTableName%>" id="<%=rsTableName%>">
<%
						for(int j=0;j<topInfoWithMeasure.size();j+=2)
						{
							String infoForDisp=(String)topInfoWithMeasure.get(j);
							String val=(String)topInfoWithMeasure.get(j+1);
%>
					<tr>
						<td  class="tdborder_jvm"><%=StringUtils.replace(infoForDisp,"+","")%> </td>
<%
							if(val!=null && !val.equals("-") && !val.equals("-5"))
							{
%>
						<td  class="tdborder_jvm"><%=val%></td>
<%
							}
							else
							{
%>
						<td  class="tdborder_jvm">-</td>
<%
							}
%>
						<td  class="tdborder_jvm">
							<table cellspacing="0" cellpadding="0"  border="0" width="100%">
								<tr>
									<td align="left" width="100%">
										<table width="100" cellpadding="0" cellspacing="0" border="0"  height="8" class="prog_border">
											<tr>
												<td align="left" width="100%" height="8" class="cpu_free">
<%
							if(val!=null && !val.equals("-"))
							{
%>
													<table width="<%=val%>%" height="8"  cellpadding="0" cellspacing="0" border="0">
														<tr>
															<td class="cpu_usuage" width="100%"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/spacer.gif"></td>
														</tr>
													</table>
<%
							}
							else
							{
								out.println("-");
							}
%>
												</td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>
<%
						}
%>
					</tbody>
				</table>
				<img src="/final/monitor/eg_images/<%=monitor_Skin%>/spacer.gif" height="0px" width="0px" border="0px" onload="this.blur();return sortTable('<%=rsTableName%>',0,<%=stColPos%>,<%=endColPos%>,<%=imgcnt+1%>);" style="visibility:hidden;display:none;">
			</td>
		</tr>
	</table>
</div>
<%
					}
					else
					{
						Vector measures=new Vector();
						String measuresForDB="";
						String testName="";
						int measureCount=0;

						for(measureCount=0;measureCount<allMeasures.size();measureCount++)
						{
							String tempStr=(String)allMeasures.get(measureCount);
							if(tempStr!=null && tempStr.indexOf(":")!=-1)
							{
								testName=tempStr.substring(0,tempStr.indexOf(":"));
								String tempMeasure=tempStr.substring(tempStr.indexOf(":")+1);
								measures.add(tempMeasure);
								measuresForDB+=dbInfo.getColumnForMeasure(testName,tempMeasure);
								if(allMeasures.size()>measureCount+1)
									measuresForDB+=",";
							}
						}

						msmtHost=(String)allMsmtHosts.get(testName);
						String s_infomapping=iniObjTitle.getValue(subject+"_info_mapping",tempTestName);
						if(s_infomapping==null || s_infomapping.trim().equals(""))
							s_infomapping="Info";

						String rsTableName="rsTable"+(tablescount++);
						int totalMeasureCols=measures.size();

						Vector allValuesForInfo=new Vector();

						allValuesForInfo=dashboardDAO.getCurrentForAllInfos(hostName,portNo,testName,measuresForDB,msmtHost);
						endColPos+=(totalMeasureCols+1);
						Vector  excludedInfos = dashboardDAO.getExcludedInfo(testName,"",compType,false,false);
						boolean isTestHas_CutOffFactor=true;
						if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
						{
							if(egDashboard.isTestHasCutOffFactor(testName))
							{
								if(allValuesForInfo!=null && !allValuesForInfo.isEmpty())
								{
									for(int d=0;d<allValuesForInfo.size();d+=measures.size()+1)
									{
										String info_for_cutOffFactor=(String)allValuesForInfo.get(d);
										if (excludedInfos!=null &&  excludedInfos.contains(info_for_cutOffFactor))
											continue;
										boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,testName,msmtHost,info_for_cutOffFactor);
										if(!isTestExceededCutOffFactor)
											isTestHas_CutOffFactor=false;
									}
								}	
							}
						}
%>
<div style="margin-left:10px;margin-top:10px;float:left;width:<%=(measureCount>3)?"99%":"49%"%>;height:180px;border:0px solid yellow" id="div<%=++divCount%>" >
	<table border="0" cellspacing="0" cellpadding="0" width="100%" class="istam_vmborder"><col width="95%"><col width="5%">
		<tr>
			<td class="istam_data_headbg1" height="25" style="padding-left:4px;border-right-width:0px" onmousedown="startDragBox(<%=divCount%>,event)"><%=tableTitle%></td>
			<td class="istam_data_headbg1" valign="middle" align="right" style="padding-right:4px;border-right-width:0px" onclick="javascript:showMaximizedView('<%=comparisonTableFullViewURL%>','event','DDComparisonTablefullView');"><img id="img<%=divCount%>" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_maximize_div.png" class="mouse"/></td>
		</tr>
		<tr>
			<td width="100%" valign="top" colspan="2" height="155">
			<div id="comptable<%=i%>" class="istam_div_scroll" style="height:155px;">
<% if(!isTestHas_CutOffFactor)
	{
%>
				<table cellspacing="0" cellpadding="0" class="tableborder_jvm"  border="0" width="100%"  style="border-top-width:0px">
					<tr>
						<td class="font_bold11 tdborder2_jvm" style="border-top-width:0px">
							<div style="float:left"><a class="eg_monlink" href="" onclick="this.blur();return sortTable('<%=rsTableName%>','0',<%=stColPos%>,<%=endColPos%>,'<%=(imgcnt+1)%>');"><span class="font_bold11"><egui:intnl text ='<%="monitor.dashboard."+s_infomapping%>'/></a></span></div>
							<div style="float:right;width:15px"><img id="imgdd<%=(imgcnt+1)%>" class="mouse" src="/final/monitor/eg_images/<%=monitor_Skin%>/arrow_down_black_small.png" onclick="this.blur();return sortTable('<%=rsTableName%>',0,<%=stColPos%>,<%=endColPos%>,'<%=(imgcnt+1)%>');" style="display:none"/></div>
						</td>
<%
						imgcnt=imgcnt+1;

						for(int columCount=0;columCount<totalMeasureCols;columCount++)
						{
							measure=(String)measures.get(columCount);

							String tableHeader=iniObjTitle.getValue(subject+"_tableheader_mapping",testName+":"+measure);
							if(tableHeader!=null && tableHeader.equals(""))
							{
								tableHeader=mappingInfo.getMeasureDescription(testName,measure);
								tableHeader+="("+tablesInfo.getUnitForMeasure(testName,measure)+")";
							}
%>
						<td class="font_bold11 tdborder2_jvm"  style="border-top-width:0px">
							<div style="float:left"><a class="eg_monlink" href="" onclick="this.blur();return sortTable('<%=rsTableName%>',<%=(columCount+1)%>,<%=stColPos%>,<%=endColPos%>,<%=(imgcnt+1)%>);"> <span class="font_bold11"><%=tableHeader%></span></a></div>
							<div style="float:right;width:15px"><img id="imgdd<%=(imgcnt+1)%>" class="mouse" src="/final/monitor/eg_images/<%=monitor_Skin%>/arrow_up_black_small.png" onclick="this.blur();return sortTable('<%=rsTableName%>',<%=(i+1)%>,<%=stColPos%>,<%=endColPos%>,<%=(imgcnt+1)%>);" style="display:none"/></div>
						</td>
<%
							imgcnt++;
						}
%>
					</tr>
					<tbody name="<%=rsTableName%>" id="<%=rsTableName%>">
<%
						for(int infoCount=0;infoCount<allValuesForInfo.size();infoCount+=measures.size()+1)
						{
							info=(String)allValuesForInfo.get(infoCount);
							info=StringUtils.replace(info,sid+"+","");
							info=StringUtils.replace(info,"+","");
							if (excludedInfos!=null &&  excludedInfos.contains("+"+info))
								continue;
%>
					<tr>
						<td class="font_normal11 tdborder_jvm" valign="top"><%=info%></td>
<%
							for(int j=1;j<=measures.size();j++)
							{
								measure=(String)measures.get(j-1);
								String value=(String)allValuesForInfo.get(j+infoCount);
								if(!testerInfo.getAllowNegativeValues(testName,measure) && (value!=null) && (value.startsWith("-") || value.trim().equals("")))
								{
									value = "-";
								}
%>
						<td class="font_normal11 tdborder_jvm" valign="top"><%=value%></td>
<%
							}
%>
					</tr>
<%
						}

%>
					</tbody>
				</table>
<%
	}
	else
	{
%>
				<table cellspacing="0" cellpadding="2" border="0" width="100%"  height="100%">
					<tr>
						<td align="center" width="100%" valign="middle" class="istam_ExclamationText" height="100%" >
							<img src="/final/images/clear.png" class="iconExclamation"> <br> <egui:intnl text="monitor.dashboard.No measures available"/>!
						</td>
					</tr>
				</table>
<%
	}
	int defaultColumnSortIndex=0;
	int defaultColumnSortImageIndex=stColPos;
%>
				<img src="/final/monitor/eg_images/<%=monitor_Skin%>/spacer.gif" height="0px" width="0px" border="0px" onload="this.blur();return sortTable('<%=rsTableName%>',<%=defaultColumnSortIndex%>,<%=stColPos%>,<%=endColPos%>,<%=defaultColumnSortImageIndex%>);" style="visibility:hidden;display:none;">
			</div>
			</td>
		</tr>
	</table>
</div>
<%
						stColPos=imgcnt+1;
					}
				}
				else
				{
					Vector measures=new Vector();
					String measuresForDB="";
					String testName="";

					for(int measureCount=0;measureCount<allMeasures.size();measureCount++)
					{
						String tempStr=(String)allMeasures.get(measureCount);
						if(tempStr!=null && tempStr.indexOf(":")!=-1)
						{
							testName=tempStr.substring(0,tempStr.indexOf(":"));
							String tempMeasure=tempStr.substring(tempStr.indexOf(":")+1);
							measures.add(tempMeasure);
							measuresForDB+=dbInfo.getColumnForMeasure(testName,tempMeasure);
							if(allMeasures.size()>measureCount+1)
								measuresForDB+=",";
						}
					}

					msmtHost=(String)allMsmtHosts.get(testName);

					Vector allValuesForInfo=dashboardDAO.getCurrentForAllInfos(hostName,portNo,testName,measuresForDB,msmtHost);

					allValuesForInfo.remove(sid+"+");
					allValuesForInfo.remove("+");
%>
<div style="margin-left:10px;margin-top:10px;float:left;width:49%;height:180px;border:0px solid #2B7F82" id="div<%=++divCount%>" >
	<table border="0" cellspacing="0" cellpadding="0" width="100%" height="100%" class="istam_vmborder"><col width="95%"><col width="5%">
		<tr>
			<td class="istam_data_headbg1" height="25" style="padding-left:4px;border-right-width:0px" onmousedown="startDragBox(<%=divCount%>,event)"><%=tableTitle%></td>
			<td class="istam_data_headbg1" valign="middle" align="right" style="padding-right:4px;border-right-width:0px" onclick="javascript:showMaximizedView('<%=comparisonTableFullViewURL%>','event','DDComparisonTablefullView');"><img id="img<%=divCount%>" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_maximize_div.png" class="mouse"/></td>
		</tr>
		<tr>
			<td width="100%" valign="top" colspan="2" class="linetop" height="155">
				<div id="comptable<%=i%>" class="istam_div_scroll" style="width:463px;height:155px;border:0px solid #ff0000;" >
				<table border="0" cellpadding="2" cellspacing="0" width="100%" ><col width="40%"><col width="30%"><col width="30%">

<%
					if(allValuesForInfo!=null && allValuesForInfo.size()>0)
					{
						for(int infoCount=0;infoCount<allValuesForInfo.size();infoCount++)
						{
							measure=(String)measures.get(infoCount);
							String measureForDB=dbInfo.getColumnForMeasure(testName,measure);
							String graph_values=dashboardDAO.getGraphValuesForSpark(hostName,"+",sid,testName,measureForDB,sparkLineStartTime+" "+sparkLineStartHour+":"+endDate.getMinutes()+":00",sparkLineEndTime+" "+sparkLineEndHour+":"+endDate.getMinutes()+":00");

							String urlForMaximize=response.encodeURL("/final/servlet/com.egurkha.monitor.EgCustomDashboardTimelineChart?")+"sid="+sid+"&measure="+measureForDB+"&starttime="+startTime+"&port="+portNo+"&comptype="+compType+"&mode=3D&site="+site+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&monitorSkin="+monitor_Skin+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&gtype=1&starthr="+startHour+"&test="+testName+"&info=*&layer=HOST&endtime="+endTime+"&endhr="+endHour+"&showRange=Range&gformat=graph&fromDashboard=true&timeline_compare="+defaultMGraphDuration+"&width=880&height=320&threshold=no&title=true&minmaxavgRequired=true&priority=ALL&module=custom";

							String urlForSummary=response.encodeURL("/final/monitor/egSummary.jsp?")+"hostName="+compName+"&compType="+compType+"&subsystem=JVM Thread&ddmeasure="+measure+"&fullview=true&subject="+compType+"&module=custom";

							String summaryTitle="Thread Details";

							if(compType!=null && compType.equalsIgnoreCase("MS_sql_server"))
							{
								String layerName=dashboardDAO.getLayerForTest(compType,test,measure);
								String testMeasureState=egDashboard.getTestMeasureState(compName,compType,layerName,test,measure);

								urlForSummary=response.encodeURL("/final/monitor/egDashDDData.jsp?")+"fromPage=current&site="+site+"&comptype=Host_system"+"&host="+hostName+"&port="+portNo+"&layer=HOST&test="+testName+"&stest="+testName+"-*&info=*&msmt_host="+msmtHost+"&time=Any&timeline=Any&measure="+measure+"&from=0&firsttime=true&flag=1&fromDDGraphs=false&newWindow=false&comeFrom=null&ddTitle="+EgURLEncoder.encode("MSSQL Processes","UTF-8")+"&starttime="+startTime+"&starthr="+startDate.getHours()+"&endtime="+EgURLEncoder.encode(endTime,"UTF-8")+"&endhr="+endDate.getHours()+"&startmin="+startDate.getMinutes()+"&endmin="+endDate.getMinutes()+"&fromDashboardOverview=true";
								summaryTitle="SQL "+mappingInfo.getMeasureDescription(testName,measure)+" Summary";
							}
							Vector spartLineAttributes=new Vector();
							spartLineAttributes.add("palette='2'");
							spartLineAttributes.add("setAdaptiveYMin='0'");
							spartLineAttributes.add("bgAlpha='0,0'");
							spartLineAttributes.add("showHighAnchor ='0'");
							spartLineAttributes.add("showLowAnchor ='0'");
							spartLineAttributes.add("showOpenValue ='0'");
							spartLineAttributes.add("showCloseValue ='0'");
							spartLineAttributes.add("showHighLowValue ='0'");
							spartLineAttributes.add("showOpenAnchor ='0'");
							spartLineAttributes.add("showCloseAnchor ='0'");
							spartLineAttributes.add("lineColor='"+iniObj.getValue("Dashboard_Graph_colors","Sparkline")+"'");
							spartLineAttributes.add("clickURL='javascript:sparklineOnclick(&apos;comparesparkurl"+infoCount+"&apos;)'");

							Vector sparkValues=egDashboard.getTokensAsVector(graph_values,",");

							String sparkXML=fusionChart.getXMLForSpark(sparkValues,spartLineAttributes);

							String value=(String)allValuesForInfo.get(infoCount);
							if(!testerInfo.getAllowNegativeValues(test,measure) && (value!=null) && (value.startsWith("-") || value.trim().equals("")))
							{
								value = "-";
							}

							String tableHeader=iniObjTitle.getValue(subject+"_tableheader_mapping",testName+":"+measure);
							if(tableHeader!=null && tableHeader.equals(""))
							{
								tableHeader=mappingInfo.getMeasureDescription(testName,measure);
							}
							tableHeader+="("+tablesInfo.getUnitForMeasure(testName,measure)+")";
%>
					<tr>
						<td width="35%" class="font_normal11 padding4"><a class="<%=(testName.equals("JvmThreadTest"))?"mouse eg_monlink":"eg_monlink"%>" onclick="javascript:<%=(testName.equals("JvmThreadTest"))?"loadPageinFrame('"+urlForSummary+"',event,'"+summaryTitle+"');":"void(0);"%>"><%=tableHeader%></a></td>
						<td width="35%" class="font_normal11 padding4">
<%
						if(sparkValues!=null && sparkValues.size()>0)
						{
%>
							<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="100" height="20" id="StackedColumn3D" >
								<param name="movie" value="/final/FusionCharts/swf/SparkLine.swf" />
								<param name="FlashVars" value="&dataXML=<%=sparkXML%>&chartWidth=100&chartHeight=20">
								<param name="quality" value="high" />
								<param name="WMode" value="Transparent">
								<embed wmode="transparent" src="/final/FusionCharts/swf/SparkLine.swf" flashVars="&dataXML=<%=sparkXML%>" quality="high" width="100" height="20" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
							</object> -->
							<div id="comparesparkurlContainer<%=infoCount%>"  style="height:100%;"></div>
							<script type="text/javascript">
								if  ( FusionCharts( "mySPLChartId<%=infoCount%>" ) )
										FusionCharts( "mySPLChartId<%=infoCount%>" ).dispose();
								var myChart = new FusionCharts( "/final/FusionCharts/swf/SparkLine.swf","mySPLChartId<%=infoCount%>", "100", "20","0","1");
								myChart.setXMLData("<%=sparkXML%>");
								myChart.setTransparent(true);
								myChart.render("comparesparkurlContainer<%=infoCount%>");
							</script>
							<input type="hidden" id="comparesparkurl<%=infoCount%>"  value="<%=urlForMaximize%>"/>
<%
						}
						else
						{
%>
						&nbsp;
<%
						}
%>
						</td>
						<td width="30%" class="font_normal11 padding4"><%=value%></td>
					</tr>
<%
						}
					}
					else
					{
						for(int measureCount=0;measureCount<measures.size();measureCount++)
						{
								measure=(String)measures.get(measureCount);
%>
					<tr>
						<td width="35%" class="font_normal11 padding4"><egui:intnl measure='<%=testName+":"+measure%>'/></td>
						<td width="35%" class="font_normal11 padding4">-</td>
						<td width="30%" class="font_normal11 padding4">-</td>
					</tr>
<%
						}
					}
%>
				</table>
				</div>
			</td>
		</tr>
	</table>
</div>
<%
				}
			}
		}

		if(ddCompTableVec!=null && !ddCompTableVec.isEmpty())
		{
			EgTestInfo tokInfo = new EgTestInfo("manager");
			EgTesterInfo testInfo = new EgTesterInfo("manager");
			EgDiagnosisBean dd=new EgDiagnosisBean();
			String oldColSeparator = EgConstants.SEMICOLON;
			String colSeparator = testInfo.getDDSeparator1(); // default is ";"
			if (StringUtils.isNull(colSeparator))
			{
				colSeparator = oldColSeparator;
			}
			boolean proceed = false;
			SimpleDateFormat sf=new SimpleDateFormat("MM/dd/yyyy");
			Iterator itrddCompTable=ddCompTableVec.iterator();
			int ddDivCnt=0;
			while(itrddCompTable.hasNext())
			{
				String ddCompTable=(String)itrddCompTable.next();
				String testMeas=ddCompTable.substring(0,ddCompTable.indexOf("|"));
				String test=testMeas.substring(0,testMeas.indexOf(":"));
				String meas=testMeas.substring(testMeas.indexOf(":")+1,testMeas.length());
				String ddColumns=ddCompTable.substring(ddCompTable.indexOf("|")+1);
				StringTokenizer stDDcols=new StringTokenizer(ddColumns,",");
				msmtHost=(String)allMsmtHosts.get(test);
				int divWidthSize=99;
				int ddColsCnt=stDDcols.countTokens();
				if(ddColsCnt<=4)
					divWidthSize=49;
				String urlForDDCompTable=response.encodeURL("egCustomDashboardp.jsp?")+"blockType=ddcomparisontable&compName="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&test="+test+"&measure="+meas+"&ddColumns="+EgURLEncoder.encode(ddColumns,"UTF-8")+"&subject="+EgURLEncoder.encode(subject,"UTF-8")+"&ddDivCnt="+ddDivCnt+"&from=smallView&tab=custom";
				if(msmtHost!=null && !msmtHost.equals(""))
					urlForDDCompTable=urlForDDCompTable+"&msmtHost="+EgURLEncoder.encode(msmtHost,"UTF-8");
%>
<div style="margin-left:10px;margin-top:10px;float:left;width:<%=divWidthSize%>%;height:180px;" id="div<%=++divCount%>">
<%
	urlForDDCompTable=urlForDDCompTable+"&divCount="+divCount;
%>
	<jsp:include page="<%=urlForDDCompTable%>"/>
</div>
<%
				ddDivCnt++;
			}
		}
		if(s_ddinivalue!=null && !s_ddinivalue.trim().equals(""))
		{
			boolean ddEnabled=true;
			boolean isDDFromFirstMsmt=false;

			SimpleDateFormat sf=new SimpleDateFormat("MM/dd/yyyy");

			String ddtimeline="1 hour";

			if(graphTimeline!=null && !graphTimeline.trim().equals(""))
			{
				ddtimeline=graphTimeline;
			}

			String startenddates="";

			if(ddtimeline==null || !ddtimeline.equalsIgnoreCase("any"))
			{
				startenddates=egDashboard.getStartEndDatesForTimelines(ddtimeline,"");
			}

			if(ddtimeline!=null && ddtimeline.equalsIgnoreCase("any"))
			{
				try
				{
					Date startDateFrmReq=dfForParse.parse(startTime);
					Date endDateFrmReq=dfForParse.parse(endTime);

					startTime=dateFormatMMDD.format(startDateFrmReq);
					endTime=dateFormatMMDD.format(endDateFrmReq);
				}
				catch(Exception ex)
				{
					ex.printStackTrace();
				}
			}

			String  ddTitle="";
			Vector vec_ddtestmeasure=new Vector();

			vec_ddtestmeasure=egDashboard.getTokensAsVector(s_ddinivalue,",");

			if(startenddates!=null && !startenddates.equals("") && startenddates.indexOf("|")>0)
			{
				String start_Date=startenddates.substring(0,startenddates.indexOf("|"));
				String end_Date=startenddates.substring(startenddates.indexOf("|")+1);
				startDate=new java.util.Date(start_Date);
				endDate=new java.util.Date(end_Date);
				startTime=sf.format(startDate);
				endTime=sf.format(endDate);
			}

			int i=0;
			for(i=0;i<vec_ddtestmeasure.size();i++)
			{
				String info="";
				String s_singleDDtestmeasure=(String)vec_ddtestmeasure.get(i);

				if(s_singleDDtestmeasure!=null && s_singleDDtestmeasure.indexOf("Format:")!=-1)
				{
					endDate=new java.util.Date();

					String s_test=s_singleDDtestmeasure.substring(0,s_singleDDtestmeasure.indexOf(":"));
					String s_measure=s_singleDDtestmeasure.substring(s_singleDDtestmeasure.indexOf(":")+1,s_singleDDtestmeasure.indexOf("#"));
					String unit_for_measure=tablesInfo.getUnitForMeasure(s_test,s_measure);
					String format=s_singleDDtestmeasure.substring(s_singleDDtestmeasure.indexOf("#")+1,s_singleDDtestmeasure.length());

					msmtHost=(String)allMsmtHosts.get(s_test);

					Vector allInfos=(Vector)allTestInfos.get(s_test);
					String desc="*";
					if(allInfos!=null && allInfos.size()>0)
					{
						if(allInfos.contains("+Summary"))
						{
								desc="+Summary";
						}
						else
						{
							desc=(String)allInfos.get(0);
						}
					}

					String s_lastMsmtTime=measureGraph.getLastRuntimeForDDTest(s_test,s_measure,hostName,portNo,"NULL",desc,msmtHost);

					java.util.Date lastMsmtTime=new java.util.Date();
					if(s_lastMsmtTime!=null && !s_lastMsmtTime.trim().equals(""))
						lastMsmtTime=testTableDateFmt.parse(s_lastMsmtTime);
					else
						s_lastMsmtTime=testTableDateFmt.format(lastMsmtTime);

					startTime=sf.format(lastMsmtTime);
					endTime=sf.format(lastMsmtTime);

					String s_timeonly=s_lastMsmtTime.substring(s_lastMsmtTime.indexOf(" ")+1);
					Vector vec_times=egDashboard.getTokensAsVector(s_timeonly,":");

					startHour=(String)vec_times.get(0);
					endHour=(String)vec_times.get(0);
					startMin=(String)vec_times.get(1);
					endMin=(String)vec_times.get(1);

					int i_endMin=Integer.parseInt(endMin)+1;
					endMin=i_endMin+"";

					startSec=(String)vec_times.get(2);
					endSec=(String)vec_times.get(2);


					ddTitle=iniObjTitle.getValue(subject+"_ComparisonGraph_mapping",s_singleDDtestmeasure);
					Vector Infos=(Vector)allTestInfos.get(s_test);


					String ddinfo="";
					if(Infos!=null && Infos.size()>0)
					{
						if(s_test.equals("SystemTest") && Infos.contains("+Summary"))
						{
							ddinfo="+Summary";
						}
						else
						{
							ddinfo=(String)Infos.get(0);
						}
					}

					ddinfo=StringUtils.replace(ddinfo,"+","");

					String ddGraphUrlLarge="";
					String ddGraphUrl="";
					String dddataurl="";

					String s_layer=dashboardDAO.getLayerForTest(compType,s_test,s_measure);

					dddataurl=response.encodeURL("/final/monitor/egDashBoardDDData.jsp?")+"fromPage=current&site="+site+"&comptype=Host_system"+"&host="+hostName+"&port="+portNo+"&layer=HOST&test="+s_test+"&stest="+s_test+"-*"+ddinfo+"&info=*"+EgURLEncoder.encode(ddinfo,"UTF-8")+"&msmt_host="+msmtHost+"&time=Any&timeline=Any&measure="+s_measure+"&from=0&firsttime=true&flag=1&fromDDGraphs=true&newWindow=false&comeFrom=null&ddTitle="+EgURLEncoder.encode(ddTitle,"UTF-8")+"&starttime="+startTime+"&starthr="+startDate.getHours()+"&endtime="+EgURLEncoder.encode(endTime,"UTF-8")+"&endhr="+endDate.getHours()+"&startmin="+startDate.getMinutes()+"&endmin="+endDate.getMinutes()+"&module=custom";

					ddGraphUrl=response.encodeURL("/final/servlet/com.egurkha.monitor.EgDDTopview?")+"host="+compName+"&compType="+compType+"&test="+s_test+"&measure="+s_measure+"&format="+EgURLEncoder.encode(format,"UTF-8")+"&module=custom&width=301&height=183&endtime="+EgURLEncoder.encode(endTime,"UTF-8")+"&starthr="+startHour+"&endhr="+endHour+"&starttime="+startTime+"&monitorSkin="+monitor_Skin+"&mode=3D&startmin="+startMin+"&endmin="+endMin+"&startsec="+startSec+"&endsec="+endSec+"&timeline_compare="+ddtimeline+"&priority="+priority;

					ddGraphUrlLarge=response.encodeURL("/final/servlet/com.egurkha.monitor.EgDDTopview?")+"host="+compName+"&compType="+compType+"&test="+s_test+"&measure="+s_measure+"&format="+EgURLEncoder.encode(format,"UTF-8")+"&width=880&height=320&from=fullview&endtime="+EgURLEncoder.encode(endTime,"UTF-8")+"&starthr="+startHour+"&endhr="+endHour+"&starttime="+startTime+"&mode=3D&graphTitle="+EgURLEncoder.encode(ddTitle,"UTF-8")+"&timeline_compare="+ddtimeline+"&monitorSkin="+monitor_Skin+"&showDDData=true&fullview=true&priority="+FullViewPriority+"&isInfoRelevantMeasureGraph=true&display=false&fromHist=true&module=custom";

				Vector ddChartAttribute=new Vector();
				ddChartAttribute.add("caption='"+ddTitle+"'");
				ddChartAttribute.add("palette='2'");
				ddChartAttribute.add("showValues='1'");
				ddChartAttribute.add("showLabels='1'");
				ddChartAttribute.add("showYAxisValues='0'");
				ddChartAttribute.add("decimals='2'");
				ddChartAttribute.add("formatNumberScale='0'");
				ddChartAttribute.add("useRoundEdges='1'");
				ddChartAttribute.add("exportTargetWindow='1'");
				ddChartAttribute.add("clickURL='javascript:ddOnclick(&apos;ddBar"+i+"&apos;);setDDDataURL(&apos;"+EgURLEncoder.encode(dddataurl,"UTF-8")+"&apos;)'");
				ddChartAttribute.add("exportEnabled='0'");
				ddChartAttribute.add("exportAction='download'");
				ddChartAttribute.add("exportAtClient='0'");
				ddChartAttribute.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
				ddChartAttribute.add("bgColor='ffffff'");
				ddChartAttribute.add("borderAlpha='100'");
				ddChartAttribute.add("showToolTipShadow='1'");
				ddChartAttribute.add("chartLeftMargin='8'");
				ddChartAttribute.add("chartRightMargin='8'");
				ddChartAttribute.add("chartTopMargin='8'");
				ddChartAttribute.add("chartBottomMargin='8'");
				ddChartAttribute.add("canvasBorderColor='000000'");
				ddChartAttribute.add("canvasBorderThickness='5'");
				ddChartAttribute.add("plotSpacePercent='40'");
				ddChartAttribute.add("baseFont='verdana'");
				ddChartAttribute.add("outCnvBaseFontSize ='9'");
				ddChartAttribute.add("outCnvBaseFontColor ='000000'");
				ddChartAttribute.add("showBorder ='0'");
				ddChartAttribute.add("adjustDiv='1'");
				ddChartAttribute.add("yAxisValueDecimals='2'");
				ddChartAttribute.add("placeValuesInside='0'");

				String ddXMLData=fusionChart.getXMLforDD(tab,compName,compType,s_test,s_measure,startTime,startHour,startMin,endTime,endHour,endMin,format,null,false,priority,ddChartAttribute);

				ddXMLData=StringUtils.replace(ddXMLData,"\"","");
%>
<div style="margin-left:10px;margin-top:10px;float:left;width:303px;height:180px;border:0px solid gray">
	<table border="0" bordercolor="red"  cellpadding="0" cellspacing="0" width="100%" class="istam_vmborder">
		<tr>
<%
				if(ddEnabled && ddXMLData!=null && ddXMLData.trim().length()>0)
				{
%>
			<td width="100%" height="182px" align="center" valign="middle">
				<table border="0" bordercolor="black"  cellpadding="0" cellspacing="0" width="100%" height="100%" align="center">
					<tr>
						<td width="301px" height="100%" align="center">
							<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="300" height="182" id="StackedColumn3D" flashVars="&dataXML=<chart><set value='1'/><set value='2'/></chart>" >
								<param name="FlashVars" value="&dataXML=<%=ddXMLData%>&chartWidth=300&chartHeight=182">
								<param name="quality" value="high" />
								<param name="WMode" value="Transparent">
								<param name="movie" value="/final/FusionCharts/swf/Bar2D.swf" />
								<embed wmode="transparent" src="/final/FusionCharts/swf/Bar2D.swf" flashVars="&dataXML=<%=ddXMLData%>" quality="high" width="300" height="182" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
							</object> -->
							<div id="Bar2DContainer<%=i%>"  style="height:100%;"></div>
							<script type="text/javascript">
								if  ( FusionCharts( "myBar2DChartId<%=i%>" ) )
										FusionCharts( "myBar2DChartId<%=i%>" ).dispose();
								var myChart = new FusionCharts( "/final/FusionCharts/swf/Bar2D.swf","myBar2DChartId<%=i%>", "300", "182","0","1");
								myChart.setXMLData("<%=ddXMLData%>");
								myChart.setTransparent(true);
								myChart.render("Bar2DContainer<%=i%>");
							</script>
						</td>
						<img src="/final/monitor/eg_images/<%=monitor_Skin%>/spacer.gif" height="0px" width="0px" border="0px"   onload="javascript:setDDDataURL('<%=dddataurl%>');" style="visibility:hidden;display:none;" />
					</tr>
				</table>
			</td>
<%
				}
				else
				{
%>
			<td align="center" height="182px"  width="100%" valign="middle">
				<table  border="0" bordercolor="black"  cellpadding="10" cellspacing="0" width="100%" height="100%">
					<tr>
						<td class="font_bold11" align="center" style="height:20px" width="100%" ><%=ddTitle%></td>
					</tr>
					<tr>
						<td height="160" width="100%" align="center" valign="middle" class="linetop istam_ExclamationText">
							<img src="/final/images/clear.png" class="iconExclamation"><br><egui:intnl text="monitor.common.No detailed measures available"/>! 
						</td>
					</tr>
				</table>
			</td>
<%
				}
%>
		<input type="Hidden" id="ddBar<%=i%>" value="<%=ddGraphUrlLarge%>"/>
		</tr>
	</table>
</div>
<%
				}
				else
				{
					boolean isTestHas_CutOffFactor=true;
					String s_test=s_singleDDtestmeasure.substring(0,s_singleDDtestmeasure.indexOf(":"));
					String s_measure=s_singleDDtestmeasure.substring(s_singleDDtestmeasure.indexOf(":")+1);
					msmtHost=(String)allMsmtHosts.get(s_test);
					Vector infos=dashboardDAO.getDescriptorsForTest(compName,compType,s_test,tab);
					if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
					{
						if(egDashboard.isTestHasCutOffFactor(s_test))
						{
							if(infos!=null && !infos.isEmpty())
							{
								for(int d=0;d<infos.size();d++)
								{
									boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,s_test,msmtHost,(String)infos.get(d));
									if(!isTestExceededCutOffFactor)
										isTestHas_CutOffFactor=false;
								}
							}
						}
					}
					Vector allBarGraphData=new Vector();

					if(!ddtimeline.equalsIgnoreCase("any"))
					{
						startDateTime=dateFormatWithTime.format(startDate);
						endDateTime=dateFormatWithTime.format(endDate);
					}

					String ddMeasureUnit=tablesInfo.getUnitForMeasure(s_test,s_measure);

					String ddGraphUrlLarge=response.encodeURL("/final/servlet/com.egurkha.monitor.EgDashboardBarchart?")+"host="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&width=301&height=183&monitorSkin="+monitor_Skin+"&mode=3D&graphdisplay=defaultView&test="+s_test+"&testmeasure="+s_singleDDtestmeasure+"&minmaxavgRequired=false&timeline_compare="+ddtimeline+"&priority="+FullViewPriority+"&isInfoRelevantMeasureGraph=true&starttime="+startTime+"&endtime="+endTime+"&starthr="+startHour+"&endhr="+endHour+"&display=false&fromHist=true&module=custom";

					String measureMapping=iniObjTitle.getValue(subject+"_ComparisonGraph_mapping",s_singleDDtestmeasure);

					if(measureMapping==null || measureMapping.equals(""))
						measureMapping=mappingInfo.getMeasureDescription(s_test,s_measure);

					String unit=tablesInfo.getUnitForMeasure(s_test,s_measure);
					Vector comparionChartAttribute=new Vector();
					comparionChartAttribute.add("caption='"+measureMapping+"("+unit+")"+"'");
					comparionChartAttribute.add("palette='2'");
					comparionChartAttribute.add("showValues='1'");
					comparionChartAttribute.add("showLabels='1'");
					comparionChartAttribute.add("showYAxisValues='0'");
					comparionChartAttribute.add("formatNumberScale='0'");
					comparionChartAttribute.add("useRoundEdges='1'");
					comparionChartAttribute.add("clickURL='javascript:comparisionBarOnclick("+i+")'");
				//	comparionChartAttribute.add("bgColor='ffffff'");

					comparionChartAttribute.add("bgAlpha='0,0'");
					comparionChartAttribute.add("showToolTipShadow='0'");
					comparionChartAttribute.add("chartLeftMargin='8'");
					comparionChartAttribute.add("chartRightMargin='8'");
					comparionChartAttribute.add("chartTopMargin='8'");
					comparionChartAttribute.add("chartBottomMargin='8'");
					comparionChartAttribute.add("exportEnabled='0'");
					comparionChartAttribute.add("exportAction='download'");
					comparionChartAttribute.add("exportAtClient='0'");
					comparionChartAttribute.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
					comparionChartAttribute.add("outCnvBaseFontSize ='9'");
					
					comparionChartAttribute.add("showBorder ='0'");
				//	comparionChartAttribute.add("canvasBorderColor  ='000000'");
					comparionChartAttribute.add("plotSpacePercent  ='40'");
					//comparionChartAttribute.add("baseFont  ='verdana'");
					comparionChartAttribute.add("adjustDiv='1'");
					comparionChartAttribute.add("yAxisValueDecimals='2'");
					comparionChartAttribute.add("decimals='2'");
					comparionChartAttribute.add("placeValuesInside='0'");
					comparionChartAttribute.add("showShadow='0'");
			//		comparionChartAttribute.add("bgColor='444444,393939'");
					if(isDarkTheme)
					{
						comparionChartAttribute.add("showAlternateVGridColor='1'");
						comparionChartAttribute.add("alternateVGridColor='393939'");
						comparionChartAttribute.add("canvasBgColor='444444'");
						comparionChartAttribute.add("canvasbgalpha='100'");
						comparionChartAttribute.add("alternateVGridAlpha='100'");
						comparionChartAttribute.add("baseFontColor ='"+fontColor+"'");
					}
					else
					{
						comparionChartAttribute.add("outCnvBaseFontColor ='"+fontColor+"'");
					}
					comparionChartAttribute.add("tooltipBgColor='"+tooltipBgColor+"'");
				//	comparionChartAttribute.add("showBorder='0'");
					String port_no=portNo;	
					if(compType!=null && compType.equals("Oracle_server"))
					{
						if(specsInfo.isPortRelevantForTest(s_test))
						{
							if(sid!=null && !sid.equals(""))
							{
									port_no=portNo+":"+sid;
									
							}
						}
					}

					String xmlData=fusionChart.getXMLForComparision(compType,hostName,port_no,s_singleDDtestmeasure,"TOP+-+10",true,comparionChartAttribute,true);
%>
<div style="margin-left:10px;margin-top:10px;float:left;width:32%;height:180px;border:0px solid green">
	<table border="0" bordercolor="red" cellpadding="0" cellspacing="0" width="100%" class="istam_vmborder">
		<tr>
<%
					if(xmlData!=null && xmlData.trim().length()>0 && !isTestHas_CutOffFactor)
					{
%>
			<td align="center" style="height:180px" class="istam_ExclamationText" width="100%" valign="middle">
				<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="300" height="180" id="StackedColumn3D">
					<param name="FlashVars" value="&dataXML=<%=xmlData%>&chartWidth=300&chartHeight=182">
					<param name="quality" value="high" />
					<param name="WMode" value="Transparent">
					<param name="movie" value="/final/FusionCharts/swf/Bar2D.swf" />
					<embed wmode="transparent" src="/final/FusionCharts/swf/Bar2D.swf" flashVars="&dataXML=<%=xmlData%>" quality="high" width="300" height="182" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
				</object> -->
				<div id='Bar2DsecContainer<%=i%>'  style="height:100%;" class="istam_vmborder"></div>
				<script type="text/javascript">
					if  ( FusionCharts( 'myBar2DsecChartId<%=i%>' ) )
							FusionCharts( 'myBar2DsecChartId<%=i%>' ).dispose();
					var myChart = new FusionCharts( '/final/FusionCharts/swf/Bar2D.swf','myBar2DsecChartId<%=i%>', '300', '182','0','1');
					myChart.setXMLData("<%=xmlData%>");
					myChart.setTransparent(true);
					myChart.render('Bar2DsecContainer<%=i%>');
				</script>
			</td>
<%
					}
					else
					{
%>
			<td align="center" style="height:182px"  width="100%" valign="top">
				<table  border="0" bordercolor="black"  cellpadding="10" cellspacing="0" width="100%">
					<tr>
						<td class="istam_data_headbg1" align="left" style="height:25px" width="100%" ><%=measureMapping%>(<%=unit%>)</td>
					</tr>
					<tr>
						<td height="148" width="100%" align="center" valign="middle" class="linetop istam_ExclamationText">
							<img src="/final/images/clear.png" class="iconExclamation"><br><egui:intnl text="monitor.common.No detailed measures available"/>! 
						</td>
					</tr>
				</table>
			</td>
<%
					}
%>
		<input type="Hidden" id="comparisionBar<%=i%>" value="<%=ddGraphUrlLarge%>"/>
		</tr>
	</table>
</div>
<%
				}
			}
		}

		if(s_Historyinivalue!=null && !s_Historyinivalue.trim().equals(""))
		{
			Vector vec_timelineGraphTestMeasure=egDashboard.getTokensAsVector(s_Historyinivalue,",");
			String historyGraphTimeLine=iniObj.getValue("DEFAULT_TIMELINE_HISTORY_GRAPH","duration");
			if(historyGraphTimeLine==null || (historyGraphTimeLine!=null && historyGraphTimeLine.trim().equals("")))
				historyGraphTimeLine="1 hour";
			Vector historyGraphTimes=egDashboard.getStartEndDateTimeForMeasure(historyGraphTimeLine);

			if(historyGraphTimes!=null && historyGraphTimes.size()>=4)
			{
				startTime=(String)historyGraphTimes.get(0);
				endTime=(String)historyGraphTimes.get(1);
				startHour=(String)historyGraphTimes.get(2);
				endHour=(String)historyGraphTimes.get(3);
			}

			for(int i=0;i<vec_timelineGraphTestMeasure.size();i++)
			{
				String info="";
				String s_testmeasure=(String)vec_timelineGraphTestMeasure.get(i);
				String s_test="";
				String s_measure="";
				String s_layer="";

				if(s_testmeasure!=null && s_testmeasure.indexOf(":")!=-1)
				{
					s_test=s_testmeasure.substring(0,s_testmeasure.indexOf(":"));
					s_measure=s_testmeasure.substring(s_testmeasure.indexOf(":")+1);
				}
				
				s_layer=dashboardDAO.getLayerForTest(compType,s_test,s_measure);

				Vector allInfos=(Vector)allTestInfos.get(s_test);

				String measureForDB=dbInfo.getColumnForMeasure(s_test,s_measure);
				msmtHost=(String)allMsmtHosts.get(s_test);

				if(msmtHost==null)
					msmtHost="";

				boolean portReleventForTest = false;
				boolean siteReleventForTest = false;
				boolean infoReleventForTest = false;

				if(s_test!=null)
				{
					portReleventForTest = specsInfo.isPortRelevantForTest(s_test);
					siteReleventForTest = specsInfo.isSiteRelevantForTest(s_test);
					infoReleventForTest = specsInfo.isInfoRelevantForTest(s_test,compType);
				}

				if(!portReleventForTest)
				{
					portNo="NULL";
				}

				Vector tempInfo=new Vector();

				if(allInfos!=null)
				{
					for(int infoCount=0;infoCount<allInfos.size();infoCount++)
					{
						String infoFormeasure=(String)allInfos.get(infoCount);
						if(sid!=null && !sid.equals("") && portReleventForTest)
						{
							infoFormeasure=sid+infoFormeasure;
						}
						Vector measureNames=egDashboard.getMeasurenamesFromInfo(hostName,portNo,site,s_layer,s_test,infoFormeasure,msmtHost);

						if(measureNames!=null && measureNames.contains(measureForDB))
							tempInfo.add(infoFormeasure);
					}
				}
				allInfos=tempInfo;

				String gTitle="";
				String dispMeasureTitle=iniObjTitle.getValue(subject+"_measures_mapping",s_test+":"+s_measure);

				String dateDiff="";
				if(s_measure!=null && s_measure.equalsIgnoreCase("Uptime"))
				{
					info="+";
					String currentValue=dashboardDAO.getCurrentMeasure(hostName,portNo,StringUtils.replace(info,"|plus|","+"),s_test,measureForDB,msmtHost);

					if(currentValue==null || currentValue.trim().equals(""))
						currentValue="0";
					long secounds=0;
					if(currentValue!=null && currentValue.indexOf(".")>0)
					{
						secounds=Long.parseLong(currentValue.substring(0,currentValue.indexOf(".")));
					}
					else
					{
						secounds=Long.parseLong(currentValue);
					}

					dateDiff=egDashboard.getDateDifferenceString(secounds);
					dateDiff=StringUtils.replace(dateDiff,"Day","Day(s)");
					dateDiff=StringUtils.replace(dateDiff,"Hrs","Hour(s)");
					dateDiff=StringUtils.replace(dateDiff,"Min","Min(s)");
					dateDiff=StringUtils.replace(dateDiff,"Sec","Sec(s)");
				}
%>
<div style="margin-left:10px;margin-top:10px;float:left;width:32%;height:180px;border:0px solid gray;">
	<table border="0" bordercolor="green"  cellpadding="0" cellspacing="0" width="100%" style="width:300px" class="istam_vmborder">
		<tr>
			<td width="100%">
				<table border="0" bordercolor="green" cellpadding="0" cellspacing="0" width="100%">
					<tr>
						<td height="27" width="100%" class="istam_data_headbg1" style="border-right-width:0px">
<%
				if(dispMeasureTitle==null || dispMeasureTitle.equals(""))
				{
%>
												<egui:intnl measure='<%=s_test+":"+s_measure%>'/>
<%
					if(s_measure!=null && s_measure.equalsIgnoreCase("Uptime"))
					{
%>
												<%=": "+dateDiff%>
<%
					}
					else
					{
%>
												(<%=tablesInfo.getUnitForMeasure(s_test,s_measure)%>)
<%
					}
				}
				else
				{
%>
												<%=dispMeasureTitle%>
<%
					if(s_measure!=null && s_measure.equalsIgnoreCase("Uptime"))
					{
%>
												<%=": "+dateDiff%>
<%
					}
					else
					{
%>
												(<%=tablesInfo.getUnitForMeasure(s_test,s_measure)%>)
<%
					}
				}

				if(allInfos!=null && allInfos.size()==1)
				{
					String infoFromVector=(String)allInfos.get(0);
					infoFromVector=StringUtils.replace(infoFromVector,"+","");
					if((sid!=null && !sid.equals("")) && (infoFromVector!=null && !infoFromVector.equals("")))
					{
						infoFromVector=sid+"*"+infoFromVector;
					}
				}
%>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
<%
				if(sid!=null && !sid.equals(""))
				{
					info=StringUtils.replace(info,"+","");
					info=sid+"*"+info;
				}
				else
					info=StringUtils.replace(info,"+","|plus|");

				if(graphTimeline==null || (graphTimeline!=null && !graphTimeline.equalsIgnoreCase("any")))
				{
					String measuretimeline=egDashboard.convertDurtionIntoTimeline(defaultMGraphDuration,true);
				}
				String s_tempinfo="";
				for(int infocount=0;infocount<allInfos.size();infocount++)
				{
					String infoFromVector=(String)allInfos.get(infocount);
					infoFromVector=StringUtils.replace(infoFromVector,"+","*");
					infoFromVector=StringUtils.replace(infoFromVector,"|plus|","*");
					s_tempinfo+=infoFromVector;

					if(infocount<allInfos.size()-1)
						s_tempinfo+=",";
				}

				String infoTkn[] = StringUtils.getTokens(s_tempinfo, ",");

				boolean hasDescsAllStar = true;
				if ( infoTkn != null && infoTkn.length > 0 )
				{
					for ( int ii = 0; ii < infoTkn.length; ii++ )
					{
						String tmpInfo = infoTkn[ii];
						if ( !tmpInfo.equals("*") )
						{
							hasDescsAllStar = false;
						}

					}
				}
				if ( hasDescsAllStar )
				{
					s_tempinfo = "*";
				}

				if(!s_tempinfo.trim().equals(""))
					info=s_tempinfo;
				boolean isInfoRelevantMeasureGraph=(info!=null && !info.equals("") && !info.equals("+") && !info.equals("*") && !info.equalsIgnoreCase("null") && !info.equalsIgnoreCase("*Summary") &&  !info.equalsIgnoreCase("+Summary"));
				
				String siteForMeasureGraph="NULL";
				if(s_layer!=null && (s_layer.equalsIgnoreCase("WEBSITE") || s_layer.equalsIgnoreCase("WEB_TRANSACTIONS")))
				{
					siteForMeasureGraph=site;					
				}
				String measureGraphUrl=response.encodeURL("/final/servlet/com.egurkha.monitor.EgCustomDashboardTimelineChart?")+"sid="+sid+"&endtime="+endTime+"&port="+portNo+"&site="+siteForMeasureGraph+"&starttime="+startTime+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&measure="+measureForDB+"&newWindow=true&test="+s_test+"&layer="+s_layer+"&comptype="+compType+"&from=MonitorDashboard&endhr="+endHour+"&gtype=1&mode=2D&starthr="+startHour+"&msmt_host="+msmtHost+"&gformat=graph&monitorSkin="+monitor_Skin+"&width=300&height=155&legends=true&fromDashboard=true&title=false&priority=TOP+-+3&threshold=no&minmaxavgRequired=true&info="+EgURLEncoder.encode(info,"UTF-8")+"&module=custom";

				String urlForMaximize=response.encodeURL("/final/servlet/com.egurkha.monitor.EgCustomDashboardTimelineChart?")+"endtime="+endTime+"&port="+portNo+"&site="+siteForMeasureGraph+"&sid="+sid+"&starttime="+startTime+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&measure="+measureForDB+"&newWindow=true&test="+s_test+"&layer=HOST&comptype="+compType+"&from=MonitorDashboard&endhr="+endHour+"&gtype=1&mode=3D&starthr="+startHour+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&gformat=graph&monitorSkin="+monitor_Skin+"&width=880&height=320&legends=false&fromDashboard=true&timeline_compare="+historyGraphTimeLine+"&title=true&priority="+FullViewPriority+"&threshold=no&minmaxavgRequired=true&info="+EgURLEncoder.encode(info,"UTF-8")+"&isInfoReleventGraph="+isInfoRelevantMeasureGraph+"&fullView=true&module=custom";
				
%>
			<td align="center" style="height:155" class="istam_ExclamationText" width="100%" valign="middle">
				<img id="<%="graphImg"+i%>" class="mouse" align="center"  onclick="javascript:showBigGraph('<%=urlForMaximize%>',event,'<%=i%>','Measuregraph');"  src="<%=measureGraphUrl%>"/>
				<input type="hidden" id="fullViewImg<%=i%>" value="<%=urlForMaximize%>"/>
			</td>
		</tr>
	</table>
</div>
<%
			}
		}
%>
</div>
<%
	}
	else
	{
%>
<div id="customDashboardDiv" class="istam_div_scroll" style="margin-left:0px;margin-top:0px;float:left;width:100%;height:500px;border:0px solid red;">
	<table width="100%" height="100%" cellpadding="0" cellspacing="0" border="0" bordercolor="blue">
		<tr>
			<td align="center"  width="100%" valign="middle" class="istam_ExclamationText">
				<img src="/final/images/clear.png" class="iconExclamation"> <br> <egui:intnl text="monitor.dashboard.No blocks configured "/>!
			</td>
		</tr>
	</table>
</div>
<%
	}
	}
	else
	{
%>
 <body class="TabBgStatic">
<div id="customDashboardDiv" class="istam_div_scroll" style="margin-left:0px;margin-top:0px;float:left;width:100%;height:500px;border:0px solid red;">
	<table width="100%" height="100%" cellpadding="0" cellspacing="0" border="0" bordercolor="blue">
		<tr>
			<td align="center"  width="100%" valign="middle" class="linetop istam_ExclamationText">
				<img src="/final/images/clear.png" class="iconExclamation"> <br> <egui:intnl text="monitor.dashboard.No templates configured"/>! 
			</td>
		</tr>
	</table>
</div>
<%
	}
	if(isFullViewForKPI)
	{
%>
	<input type="hidden" id="recentFullViewURL" value='<%=lastFullViewURL%>'>
	<img src="/final/monitor/eg_images/<%=monitor_Skin%>/spacer.gif" height="0px" width="0px" border="0px" onload="this.blur();return reloadFullView('<%=fullViewGraphType%>');" style="visibility:hidden;display:none;">
<%
	}
	else if(isFullViewForConfig)
	{
%>
	<input type="hidden" id="recentFullViewURL" value='<%=lastFullViewURL%>'>
	<img src="/final/monitor/eg_images/<%=monitor_Skin%>/spacer.gif" height="0px" width="0px" border="0px" onload="this.blur();return showMaximizedTable('event','ConfigDataDiv','','img<%=configDivCount%>','<%=configTitleStr%>');" style="visibility:hidden;display:none;">
<%

	}

	if(request.getQueryString()!=null)
	{
		session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&comptype="+compType+"&backtoDashBoard=true&tab=Custom&profileName="+profileName+"&host="+EgURLEncoder.encode(compName,"UTF-8"));
	//session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&"+request.getQueryString()+"&comptype="+compType+"&host="+EgURLEncoder.encode(compName,"UTF-8")+"&tab=Custom&profileName="+EgURLEncoder.encode(profileName,"UTF-8")+"&graphType=&toDashBoardLayer=true");
		session.setAttribute("monitorDashBrdLastCompName",compName);
	}
	else
	{
		session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&tab=Custom&toDashBoardLayer=true");
		session.setAttribute("monitorDashBrdLastCompName",compName);
	}
%>
<div id="zoomViewDiv" style="border:0px solid red;padding:10px;display:none;width:100%;height:100%;">
	<table  border="0" bordercolor="red" cellspacing="0" cellpadding="0" width="100%" height="100%">
		<tr>
			<td height="100%">
				<div style="text-align:center;width:100%;position:relative;height:100%;padding:0px;" class="istam_fullviewDiv istam_div_scroll" id="fullViewDiv">
				</div>
			</td>
		</tr>
	</table>
</div>
<div id="tableZoomViewDiv" style="border:0px solid blue;padding:10px;display:none;width:100%;height:100%;">
	<table border="0" cellspacing="0" cellpadding="0" width="100%" height="100%">
		<tr>
			<td>
				<div style="overflow-x:hidden;display:block;text-align:center;width:100%;padding:0px;position:relative;height:580px;border:0px solid blue;" class="istam_div_scroll istam_fullviewDiv" id="tableFullViewDiv">
					Graph Zoom View
				</div>
			</td>
		</tr>
	</table>
</div>
<!--  This div used for bottom side space for all dashboard pages  -  added by jaiwin -->
<div style="clear:both;height:5px;border:0px solid #ff0000;width:100%;margin:0px;padding:0px" class="eg_blankspace">&nbsp;</div>
</body>
</html>
<%

}
catch(Exception ex)
{
	out.println("exception....."+ex);
	ex.printStackTrace();
}
%>
