<%
/**
 *	File name		: eGJTMTrace.jsp
 *	Purpose			: This is shows the Trace of the web request in HTML Table Tree view
 *	Version			: eG 5.5
 *	Creation Date	: 10-03-2012
 *	Author			: Mr.R
 *	Design Help 	: Mr.Jaiwin
 */
%>
<%@ include file = "EgLoginTracker.jsp" %>
<%@ page errorPage = "EgProbsM.jsp" %>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.egurkha.monitor.EgJTMHelper"%>
<%@ page import = "java.util.*" %>
<%@ page import = "java.text.*" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<egui:skin ui="monitor"/>
<%!
	private String nodeDelim = "%*%";
	private String nodeDetailsDelim = "#=#";
	private DecimalFormat df = new DecimalFormat("#.####");
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

try
{
	String key = request.getParameter("key");
	String methodName= request.getParameter("mname");
	if(methodName == null)
		methodName ="";
	String measureName = request.getParameter("s_measure");
	String infoName = request.getParameter("info");
	Hashtable jtmDetails = (Hashtable) session.getAttribute("JtmTree");
	ArrayList resultList = (ArrayList) jtmDetails.get(key);
	//out.println("resultList :"+resultList);
	if(resultList!=null && resultList.size() == 5)	// Should be 5
	{
		String requestedTime = (String)resultList.get(0);
		String requestedURI = (String)resultList.get(1);
		String requestedHost = (String)resultList.get(2);
		String responseTime = (String)resultList.get(3);
		String subCompDetails = (String)resultList.get(4);
		//String thisNodeDetails = (String)resultList.get(5);

		String thisNodeDetails = new String();
		Hashtable nodeInfo = (Hashtable) session.getAttribute("NodeInfo");
		if(nodeInfo.containsKey(resultList.toString())){
			thisNodeDetails = (String) nodeInfo.get(resultList.toString());
		}
		else{
			IniFile UIni =  new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini", false);
			String currentDateFormat = UIni.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
			String resultDateTime  = DateUtil.changeDateFormat(requestedTime , currentDateFormat+ " HH:mm:ss", "MM/dd/yyyy HH:mm:ss");

			EgJTMHelper jtmHelper = new EgJTMHelper();
			thisNodeDetails = jtmHelper.getNodeDetails(requestedURI , resultDateTime , requestedHost , responseTime , subCompDetails , measureName, infoName);
			nodeInfo.put(resultList.toString() , thisNodeDetails);
			session.setAttribute("NodeInfo" , nodeInfo);
		}
		String grayImage = "/final/monitor/eg_images/cpu_usuage.gif";

		double totalResponseTime = 0.0D;
		totalResponseTime = Double.parseDouble(responseTime);

		ArrayList nodeTokenList = StringUtils.egTokenizer(thisNodeDetails,nodeDelim,false,false,true);
		ArrayList idexList = new ArrayList();

		for(int k=0;k<nodeTokenList.size();k++)
		{
			String nodeToken = (String)nodeTokenList.get(k);
			ArrayList nodeDetailsList = StringUtils.egTokenizer(nodeToken, nodeDetailsDelim, false,false,true);
			int countTokens = nodeDetailsList.size();
			//out.println("countTokens :"+countTokens);
			if(countTokens == 10)
			{
				String idxStr = (String)nodeDetailsList.get(0);
				int idexLength = idxStr.length();
				if(idexLength > 1)
				{
					String subidexStr = idxStr.substring(0, idxStr.lastIndexOf("."));
					idexList.add(subidexStr);
				}
			}
		}
		double rootStartTime = 0L;
		//double rootEndTime = 0L;
%>

<div id="traceDiv" style="overflow:auto;height:100%;width:100%">
<div >
<table width="100%" border="0" cellpadding="4" cellspacing="0" name="mainTable" id="mainTable" class="x-grid-table x-grid-table-resizer x-table-outer-border" style="border-top:0px;table-layout:auto">
	<thead>
	<tr name="headName" class="x-grid-row  x-grid-row-alt">
		<td class="jtm_tableHeader" align="center" colspan="2" style="padding:3px"><egui:intnl text='monitor.layermodel.Request Processing'/></td> 
		<!--<td class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first" align="center" style="padding:3px"><egui:intnl text='monitor.layermodel.% of Execution time'/></td> -->
		<td class="jtm_tableHeader" wrap align="center" style="padding:3px"><egui:intnl text='monitor.layermodel.Total Execution Time (Secs)'/></td> 
		<td class="jtm_tableHeader" wrap align="center" style="padding:3px"><egui:intnl text='monitor.layermodel.Method Execution Time (Secs)'/></td>
		<td class="jtm_tableHeader" align="left" style="padding:3px 3px 3px 20px"><egui:intnl text='monitor.layermodel.Trace Details of '/>&nbsp; - &nbsp;<span style="text-transform:none"><%=requestedURI%></span></td> 
	</tr>
	</thead>
	<tbody>
<%
	for(int k=0;k<nodeTokenList.size();k++)
	{
		String nodeToken = (String)nodeTokenList.get(k);
		ArrayList nodeDetailsList = StringUtils.egTokenizer(nodeToken, nodeDetailsDelim, false,false,true);
		
		int countTokens = nodeDetailsList.size();
		if(countTokens == 10)
		{
			String idxStr = (String)nodeDetailsList.get(0);
			String pctExecTimeStr = (String)nodeDetailsList.get(1);
			String execTimeStr = (String)nodeDetailsList.get(2);
			String exclTimeStr = (String)nodeDetailsList.get(3);
			String nodeLabel = (String)nodeDetailsList.get(4);
			String nodeDetails = (String)nodeDetailsList.get(5);
			String nodeMethod = (String)nodeDetailsList.get(6);
			String subCompType = (String)nodeDetailsList.get(7);
			subCompType = subCompType.toLowerCase();
			if(subCompType.equals("http") || subCompType.equals("webservice")){
				//System.out.println(" nodeDetailsList :"+nodeDetailsList);
			}

			// StartTime & endTime both are in nano seconds
			String startTime = (String)nodeDetailsList.get(8);
			//String endTime = (String)nodeDetailsList.get(9);
			if(k==0)
			{
				rootStartTime = Double.parseDouble(startTime);
			}
			double thisStartTime = Double.parseDouble(startTime);
			//double thisEndTime = Double.parseDouble(endTime);

			// Gray bar Calculation
			double tot_response_time = Double.parseDouble(responseTime);
			double imgLeft = ((thisStartTime - rootStartTime) / (tot_response_time * 1000000000)) * 100;
			//Formatting of Double Values
			double exec_time = Double.parseDouble(execTimeStr);
			double excl_time = Double.parseDouble(exclTimeStr);

			double res_value = (exec_time/totalResponseTime) * 100.0D;
			String grayImgWidth = Math.round(res_value)+"%";
			String grayImgLeft = Math.round(imgLeft) +"px";

			String imgName = "/final/images/icon_jtm_"+subCompType+".png";
			String rowName = "r"+(k+1);
			String dispIdx = idxStr + ".";
			StringTokenizer mytokenizer = new StringTokenizer(idxStr, ".");
			int countTok = mytokenizer.countTokens();
			int tierClass = countTok - 1;
			int margin_left  = tierClass * 1 * 20;

			String aClass = "folder";
			if(idexList.contains(idxStr))
				aClass = "folder";
			else
				aClass = "doc";
%>
	<tr id="<%=dispIdx%>" name="<%=rowName%>" title="<%=nodeMethod%>" onmouseover="javascript:selectRow(this, '<%=nodeMethod.equals(methodName)?methodName:""%>');" onmouseout="javascript:selectRow(this, '<%=methodName%>');">
		<td class="jtm_tableCell" align="left" wrap style="padding:3px">
<%
			if(subCompType.equals("sql") || subCompType.equals("exception"))
			{
				
				if(nodeLabel.indexOf("\"") != -1)
					nodeLabel=com.egurkha.util.StringUtils.replace(nodeLabel,"\"","");

				if(nodeLabel.indexOf("\'") != -1)
					nodeLabel=com.egurkha.util.StringUtils.replace(nodeLabel,"\'","");
%>
				<a href="javascript:void(0);" class="qin_link" onclick="javascript:showQueryDiv('<%=nodeLabel%>' , '<%=idxStr%>', '<%=subCompType%>','<%=measureName%>' ,'<%=infoName%>');"><div style="width:20px;height:20px" class="icon_jtm_<%=subCompType%>"></div></a>
<%
			}
			else if(subCompType.equals("http") || subCompType.equals("webservice"))
			{
%>
				<a href="javascript:void(0);" class="qin_link" onclick="javascript:showExtCallDiv('<%=nodeLabel%>' , '<%=nodeDetails%>' , '<%=subCompType%>', '<%=df.format(excl_time)%>');">
				<div style="width:20px;height:20px" class="icon_jtm_<%=subCompType%>"></div></a>
<%
			}
			else
			{
%>
				<div style="width:20px;height:20px" class="icon_jtm_<%=subCompType%>"></div>
<%
			}
%>

		</td>
		<td class="jtm_tableCell" align="left" wrap style="padding:3px">
			<!--<div style="height:10px;width:100px;border:0px solid #000000;padding:0px;margin:0px;background-color:#e2e2e2">
				<img src = "<%=grayImage%>" width="<%=grayImgWidth%>" height="10px" style="margin-left:<%=grayImgLeft%>">
			</div>-->
			<div style="height:16px;width:100px;border:0px solid #000000;padding:0px;margin:0px;" class="btmGraphBg"><div class="btmGraph" align="left" style="padding-top:2px;float:left;width:<%=grayImgWidth%>;height:14px;margin-left:0px;border:0px solid red;" ><lable style="margin-left:55px;"><%=pctExecTimeStr%>%</lable></div>
		</td>
		<!--<td class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first" align="left" wrap>&nbsp;%</td>
		<td class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first" align="left" wrap >&nbsp;</td>-->
		<td class="jtm_tableCell" align="left" wrap style="padding:3px"><%=df.format(exec_time)%></td>
		<td class="jtm_tableCell" align="left" wrap style="padding:3px"><%=df.format(excl_time)%></td>
		<td class="jtm_tableCell" align="left" nowrap width="100%" style="padding:3px;">
			<div style="display:inline-block;border:0px solid red;background:none !important;">
				<div style='background:none !important;margin-left:<%=margin_left+"px"%>;display:inline-block;border:0px solid green;white-space: nowrap;' nowrap>
					<div style="background:none !important;border:0px solid red;margin-right:20px;white-space:nowrap">
						<table width="100%" border="0" cellpadding="2" cellspacing="0" style="font-size:12px;">
<%
			if(aClass.equals("folder"))
			{
%>
							<tr style="background:none !important">
								<td width="100%" class="jtm_tableCell" style="white-space:nowrap;border-bottom:0px !important">
					<a href="javascript:void(0);" onclick="toggleRows(event, this, '<%=dispIdx%>');" onmousedown="storeMouseXY(event); return false;" class="<%=aClass%>"> </a><span style="border:0px solid blue;"> <%=nodeMethod%></span>
								</td>
							</tr>
<%
			}
			else
			{
%>
							<tr style="background:none !important">
								<td width="100%" style="white-space:nowrap;border-bottom:0px !important" class="jtm_tableCell">
									<a href="javascript:void(0);" class="<%//=aClass%>" style="text-decoration:none"></a><span style="border:0px solid blue;margin-left:20px;"> <%=nodeMethod%></span>
								</td>
							</tr>
<%
			}
%>
						</table>
					</div>
				</div>
			</div>
		</td>
	</tr>
<%
		}
	}
%>
	</tbody>
</table>
</div>
<%
	}
	else
	{
%>
<div class="clr" style="border:0px solid red;height:100%;">
	<table align="left" cellspacing="0" cellpadding="6" height="100%" width="100%" >
		<tr>
			<td>
				<table align="left" cellspacing="0" cellpadding="0" height="100%" width="100%" border="0" class="linesquare eg_lightlight">
					<tr>
						<td align="center" valign="middle" class="commonErrorMsgText"> 
							<img class="iconExclamation" src="/final/images/clear.png" align="center" border="0"/><br>
							<egui:intnl text='monitor.layermodel.No Java Transaction Trace Details ! '/>
						</td>
					</tr>
				</table>
			</td>
		</tr>
	</table>
</div>
</div>
<%
	}
}
catch(Exception e)
{
	System.out.println("Exception in eGJTMTrace.jsp Page....");
	e.printStackTrace();
}
%>
