<%
/**
 *	File name		: eGJTMDetails.jsp
 *	Purpose			: This page shows the Summary Details of particular web Request
 *	Version			: eG 5.5
 *	Creation Date	: 10-03-2012
 *	Author			: Mr.R
 *	Design Help 	: Mr.Jaiwin
 */
%>
<%@ include file = "EgLoginTracker.jsp" %>
<%@ page errorPage = "EgProbsM.jsp" %>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.egurkha.monitor.EgJTMHelper"%>
<%@ page import = "java.util.*" %>
<%@ page import = "java.text.*" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<egui:skin ui="monitor"/>
<%!
	private DecimalFormat df = new DecimalFormat("#.####");
%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	try
	{
		String key = request.getParameter("key");
		String measureName = request.getParameter("s_measure");
		String infoName =  request.getParameter("info");

		Hashtable jtmDetails = (Hashtable) session.getAttribute("JtmTree");
		ArrayList resultList = (ArrayList) jtmDetails.get(key);
		if(infoName!= null && infoName.startsWith("*"))
			infoName = infoName.substring(1);

		if(resultList!=null && resultList.size() == 5)	// Should be 5
		{
			String requestedTime = (String)resultList.get(0);
			String requestedURI = (String)resultList.get(1);
			String requestedHost = (String)resultList.get(2);
			String responseTime = (String)resultList.get(3);
			String subCompDetails = (String)resultList.get(4);
			//String nodeDetails = (String)resultList.get(5);

			Hashtable timeTable = new Hashtable();
			Hashtable countTable = new Hashtable();

			double totalResponseTime = 0.0D;
			totalResponseTime = Double.parseDouble(responseTime);
			IniFile UIni =  new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini", false);
			String currentDateFormat = UIni.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
			String resultDateTime  = DateUtil.changeDateFormat(requestedTime , currentDateFormat+ " HH:mm:ss", "MM/dd/yyyy HH:mm:ss");

			EgJTMHelper jtmHelper = new EgJTMHelper();
			Hashtable nodeInfo = (Hashtable) session.getAttribute("NodeInfo");
			String nodeDetails = new String();
			if(nodeInfo.containsKey(resultList.toString())){
				nodeDetails = (String) nodeInfo.get(resultList.toString());
			}
			else{
				nodeDetails = jtmHelper.getNodeDetails(requestedURI , resultDateTime , requestedHost , responseTime , subCompDetails , measureName ,infoName);
				nodeInfo.put(resultList.toString() , nodeDetails);
				session.setAttribute("NodeInfo" , nodeInfo);
			}
			Hashtable allDataTable = jtmHelper.parseNodeData(nodeDetails);
			//System.out.println(" allDataTable :"+allDataTable);
			ArrayList methodSummaryList = jtmHelper.getMethodSummary(allDataTable , totalResponseTime);
			ArrayList subCompSummaryList = jtmHelper.getSubCompSummary(subCompDetails , totalResponseTime);

			//..............Method Summary Chart Details ................
			Hashtable xmlResultTable = jtmHelper.getXmlString(methodSummaryList , 0);
			String xmlString = (String) xmlResultTable.get("XML");
			String swfpath = "/final/FusionCharts/swf/StackedBar2D.swf";

			//..............Sub-Comp Summary Chart Details ................
			Hashtable subCompXmlTable = jtmHelper.getXmlString(subCompSummaryList , 1);
			String subCompXmlString = (String) subCompXmlTable.get("XML");

			//.................SQL-Summary Details ....................
			boolean isQuery = false;
			ArrayList querySummaryList = new ArrayList();
			if(subCompXmlTable.containsKey("SQL"))
			{
				isQuery = true;
				querySummaryList = jtmHelper.getQuerySummary(allDataTable ,totalResponseTime);
			}
%>

<div style="margin:10px;width:100%;display:inline;height:300px;"  class="jtm_Table">
	<div style="float:left;display:inline;width:100%;height:20px" class="jtm_DatapanelHeader"><egui:intnl text='monitor.layermodel.Breakup of Response Time(%)'/>
	</div>

	<div style="border:0px solid red;display:inline" class="jtm_DatapanelBody">
		<table align="left" cellspacing="0" cellpadding="4" width="100%" border="0" class="jtm_Table">
			<tr>
				<td>
					<table align="left" cellspacing="0" cellpadding="4" width="100%" border="0" class="jtm_Table jtm_DatapanelBody"><colgroup width="120px">
						<tr class="jtm_bottomBorder">
							<td align="left" class="jtm_InnerHeader"><egui:intnl text='monitor.layermodel.URL'/></td>
							<td align="left" ><div class="urlWidth" style="word-wrap: break-word;white-space:wrap;width:478px"><%=requestedURI%></div></td>
						</tr>
						<tr class="jtm_bottomBorder">
							<td align="left" class="jtm_InnerHeader" nowrap><egui:intnl text='monitor.layermodel.Response Time'/></td>
							<td align="left" ><%=responseTime%>&nbsp;<egui:intnl text='monitor.layermodel.Secs'/></td>
						</tr>
						<tr class="jtm_bottomBorder">
							<td align="left" class="jtm_InnerHeader" nowrap><egui:intnl text='monitor.layermodel.Requested Time'/></td>
							<td align="left" ><%=requestedTime%></td>
						</tr>
						<tr class="jtm_bottomBorder">
							<td align="left" nowrap class="jtm_InnerHeader"><egui:intnl text='monitor.layermodel.Remote Host'/></td>
							<td align="left" ><%=requestedHost%></td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td width="100%">
					<table align="left" cellspacing="0" cellpadding="0" width="100%" border="0" class="jtm_DatapanelBody jtm_Table">
						<tr>
							<td class="jtm_InnerHeader" align="center"><egui:intnl text='monitor.layermodel.Method Level Breakup'/> </td>
						</tr>
						<tr>
							<td width="100%">
									<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="590" height="40" id="BasicChart" >
									<param name="movie" value="<%=swfpath%>" />
									<param name="FlashVars" value="&dataXML=<%=xmlString%>&debugMode=0&chartWidth=590&chartHeight=40">
									<param name="quality" value="high" /> 
									<param name="WMode" value="Transparent">
									<embed wmode="transparent" src="<%=swfpath%>" flashVars="&dataXML=<%=xmlString%>&debugMode=0"  quality="high" width="590" height="40" name="BasicChart" type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/go/getflashplayer" />
									</object> -->

									<div id="chartStackedBar2DContainer"  style="text-align:center;height:100%;"></div>
									<script type="text/javascript">
										if  ( FusionCharts( "myStackedBar2DChartId" ) )
												FusionCharts( "myStackedBar2DChartId" ).dispose();
										var myChart = new FusionCharts( "<%=swfpath%>","myStackedBar2DChartId", "590", "40","0","1");
										myChart.setXMLData("<%=xmlString%>");
										myChart.setTransparent(true);
										myChart.render("chartStackedBar2DContainer");
									</script>
								</p>
							</td>
						</tr>
						<tr>
							<td width="100%">
								<div class="x-table" ><table align="left" cellspacing="0" cellpadding="4" width="100%" border="0" class="x-grid-table x-grid-table-resizer x-table-outer-border"><col width="20"><col width="25"><col width="auto"><col width="50"><col width="70"><col width="70">
									<thead>
										<tr class="x-grid-row  x-grid-row-alt">
											<!-- <td class="eg_75bold tdborder2_jvm" align="center">&nbsp;</td>
											<td class="eg_75bold tdborder2_jvm" align="center">&nbsp;</td> -->
											<td colspan = "3" class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first" align="center"><egui:intnl text='monitor.layermodel.Method Details'/></td> 
											<td class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first" align="center"><egui:intnl text='monitor.layermodel.Count'/></td> 
											<td class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first" wrap align="center"><egui:intnl text='monitor.layermodel.Duration (Secs)'/></td> 
											<td class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first" align="center"><egui:intnl text='monitor.layermodel.% of time'/></td> 
										</tr>
									</thead>
									<tbody>
<%
			double total_time = 0.0D;
			double total_per = 0.0D;
			for(int k=0;k<methodSummaryList.size() ; k++)
			{
				ArrayList innerArrList = (ArrayList) methodSummaryList.get(k);
				if(innerArrList!=null && innerArrList.size() == 4)
				{
					String methodName = (String) innerArrList.get(0);
					String displayName = methodName;
					String subCompName="";
					if(methodName.indexOf("#") > 0)
					{
						subCompName = methodName.substring(0, methodName.indexOf("#"));
						displayName = methodName.substring(methodName.indexOf("#")+1);
					}

					String methodCount = (String) innerArrList.get(1);
					String methodTime = (String) innerArrList.get(2);
					double method_time_double = Double.parseDouble(methodTime);
					if(method_time_double == 0D)
						continue;
					String methodPercentage = (String) innerArrList.get(3);
					String thisColor = (String) xmlResultTable.get(methodName);
					total_time = total_time + Double.parseDouble(methodTime);
					total_per = total_per + Double.parseDouble(methodPercentage);


					String imgName = "/final/images/icon_jtm_"+subCompName.toLowerCase()+".png";
%>
										<tr class="x-grid-row  x-grid-row-alt mouse" onclick="javascript:showTrace('trace', '<%=displayName%>');">
											<td class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first" align="center" ><div style="height:10px;width:10px;padding:0px;margin-top:6px;background-color:<%=thisColor%>"> </div></td>
											<td class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first" align="center"><div style="width:20px;" class="icon_jtm_<%=subCompName.toLowerCase()%>"></div></td>
											<td class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first" title="<%=displayName%>"><div align="left" class="methodWidth" style="word-wrap: break-word;white-space:wrap;width:370px"><%=displayName%></div></td>
											<td class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first" align="right"><%=methodCount%></td>
											<td class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first" align="right"><%=methodTime%></td>
											<td class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first" align="right"><%=methodPercentage%></td>
										</tr>
<%
				}
			}
%>
										<tr>
											<td  colspan="4" align="right" class="jtm_Total"><egui:intnl text='monitor.layermodel.Total'/></td>
											<td align="right" class="jtm_Total"><%=df.format(total_time)%></td>
											<td align="right" class="jtm_Total"><%=df.format(Math.round(total_per))%></td>
										</tr>
									</tbody>
								</table>
							</div>
							</td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td>
					<table align="left" cellspacing="0" cellpadding="0" width="100%" border="0" class="jtm_DatapanelBody">
						<tr>
							<td class="jtm_InnerHeader" align="center"><egui:intnl text='monitor.layermodel.Component Level Breakup'/> </td>
						</tr>
						<tr>
							<td width="100%" >
									<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="590" height="40" id="BasicChart1" >
									<param name="movie" value="<%=swfpath%>" />
									<param name="FlashVars" value="&dataXML=<%=subCompXmlString%>&debugMode=0&chartWidth=590&chartHeight=40">
									<param name="quality" value="high" /> 
									<param name="WMode" value="Transparent">
									<embed wmode="transparent" src="<%=swfpath%>" flashVars="&dataXML=<%=subCompXmlString%>&debugMode=0"  quality="high" width="590" height="40" name="BasicChart1" type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/go/getflashplayer" />
								</object> -->

								<div id="chart2StackedBar2DContainer"  style="text-align:center;height:100%;"></div>
								<script type="text/javascript">
									if  ( FusionCharts( "my2StackedBar2DChartId" ) )
											FusionCharts( "my2StackedBar2DChartId" ).dispose();
									var myChart = new FusionCharts( "<%=swfpath%>","my2StackedBar2DChartId", "590", "40","0","1");
									myChart.setXMLData("<%=subCompXmlString%>");
									myChart.setTransparent(true);
									myChart.render("chart2StackedBar2DContainer");
								</script>
							</td>
						</tr>
						<tr>
							<td width="100%" style="border-width:0px;">
								<div class="x-table" ><table align="left" cellspacing="0" cellpadding="4" width="100%" border="0" class="x-grid-table x-grid-table-resizer x-table-outer-border"><col width="20"><col width="auto"><col width="50"><col width="70"><col width="70">
									<thead>
										<tr class="x-grid-row  x-grid-row-alt">
											<!-- <td class="eg_75bold tdborder2_jvm" align="center">&nbsp;</td> -->
											<td colspan="2" class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first" align="center"><egui:intnl text='monitor.layermodel.Sub Component Details'/></td> 
											<td class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first" align="center"><egui:intnl text='monitor.layermodel.Count'/></td> 
											<td class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first" wrap align="center"><egui:intnl text='monitor.layermodel.Duration (Secs)'/></td> 
											<td class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first" align="center"><egui:intnl text='monitor.layermodel.% of time'/></td> 
										</tr>
									</thead>
<%
			double subcomp_total_time = 0.0D;
			double subcomp_total_per = 0.0D;
			Hashtable compNameTable = new Hashtable();
			compNameTable.put("POJO", "Plain Old Java Objects");
			compNameTable.put("HTTPSERVLET", "HTTP Servlets");
			compNameTable.put("GENERICSERVLET", "Generic Servlets");
			compNameTable.put("JSP", "Java Server Pages");
			compNameTable.put("JDBC", "JDBC Access");
			compNameTable.put("FILTER", "Servlet Filters");
			compNameTable.put("EMAIL", "Java Mail");
			compNameTable.put("EXCEPTION", "Exceptions");
			compNameTable.put("STRUTS", "Struts Framework");
			compNameTable.put("SQL", "SQL Statments");
			compNameTable.put("HTTP", "HTTP Calls");
			compNameTable.put("WEBSERVICE", "WebService Calls");
			/*compNameTable.put("RMI", "Remote Method Invocations");
			compNameTable.put("NATIVE", "Native Calls");
			compNameTable.put("JNDI", "Java Naming and Directory Interface");
			compNameTable.put("JAXM", "Java XML Messaging");
			compNameTable.put("JXTA", "Peer to Peer Connections");
			compNameTable.put("EJB", "Enterprise Java Beans");*/

			for(int k=0;k<subCompSummaryList.size() ; k++)
			{
				ArrayList innerArrList = (ArrayList) subCompSummaryList.get(k);
				if(innerArrList!=null && innerArrList.size() == 4)
				{
					String subCompName = (String) innerArrList.get(0);
					String subCompCount = (String) innerArrList.get(1);
					String subCompTime = (String) innerArrList.get(2);

					double subcomp_time_double = Double.parseDouble(subCompTime) ;
					//if(subcomp_time_double == 0D)
					//	continue;

					String subCompPercentage = (String) innerArrList.get(3);
					String thisColor = (String) subCompXmlTable.get(subCompName);
					subcomp_total_time = subcomp_total_time + Double.parseDouble(subCompTime);
					subcomp_total_per = subcomp_total_per + Double.parseDouble(subCompPercentage);

					String imgName = "/final/images/icon_jtm_"+subCompName.toLowerCase()+".png";
					String compName = (String) compNameTable.get(subCompName);
%>
									<tbody><tr class="x-grid-row  x-grid-row-alt mouse" onclick="javascript:showTrace('trace',null);">
										<td class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first" align="center"><div style="height:10px;width:10px;padding:0px;margin-top:6px;background-color:<%=thisColor%>"> </div></td>

										<td class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first" align="left"><div class="methodWidth" style="word-wrap: break-word;white-space:wrap;width:380px"><div style="float:left;width:20px;text-decoration:none" border="0px" title="<%=subCompName%>" class="icon_jtm_<%=subCompName.toLowerCase()%>" ></div><div style="float:left;border:0px solid red;"> - <%=compName%></div></div></td>

										<td class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first" align="right"><%=subCompCount%></td>
										<td class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first" align="right"><%=subCompTime%></td>
										<td class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first" align="right"><%=subCompPercentage%></td>
									</tr>
<%
				}
			}
%>
									<tr>
										<td  colspan="3" class="jtm_Total" align="right"><egui:intnl text='monitor.layermodel.Total'/></td>
										<td class="jtm_Total" align="right"><%=df.format(subcomp_total_time)%></td>
										<td class="jtm_Total" align="right"><%=df.format(Math.round(subcomp_total_per))%></td>
									</tr>
									</tbody>
								</table>
								</div>
							</td>
						</tr>
					</table>
				</td>
			</tr>
<%
		if(isQuery)
		{
%>
			<tr>
				<td>
					<table align="left" cellspacing="0" cellpadding="0" width="100%" border="0" style="background:#fff;" >
						<tr>
							<td>
								<div class="x-table" ><table align="left" cellspacing="0" cellpadding="4" width="100%" border="0" class="x-grid-table x-grid-table-resizer x-table-outer-border"><col width="30"><col width="auto"><col width="50"><col width="70"><col width="70">
									<thead>
										<tr class="x-grid-row  x-grid-row-alt mouse" onclick="javascript:showSQL('sql');">
											<!-- <td class="eg_75bold tdborder2_jvm" align="center" >&nbsp;</td> -->
											<td colspan="2" class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first" align="center"><egui:intnl text='monitor.layermodel.Query Details'/></td> 
											<td class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first" align="center"><egui:intnl text='monitor.layermodel.Count'/></td> 
											<td class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first" wrap align="center"><egui:intnl text='monitor.layermodel.Duration (Secs)'/></td> 
											<td class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first" align="center" ><egui:intnl text='monitor.layermodel.% of time'/></td> 
										</tr>
									</thead>
									<tbody>
<%
			double query_total_time = 0.0D;
			double query_total_per = 0.0D;
			for(int k=0;k<querySummaryList.size();k++)
			{
				ArrayList queryArrList = (ArrayList) querySummaryList.get(k);
				if(queryArrList!=null && queryArrList.size() == 4)
				{
					String queryName = (String) queryArrList.get(0);
					String queryCount = (String) queryArrList.get(1);
					String queryTime = (String) queryArrList.get(2);
					String queryPercentage = (String) queryArrList.get(3);
					query_total_time = query_total_time + Double.parseDouble(queryTime);
					query_total_per = query_total_per + Double.parseDouble(queryPercentage);
%>
										<tr class="x-grid-row  x-grid-row-alt mouse" onclick="javascript:showQueryDiv('<%=queryName%>',null,null,null,'<%=infoName%>');">
											<td class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first" align="center"><div style="width:20px;height:20px" class="icon_jtm_sql"></div></td>
											<td class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first" align="left"><div class="methodWidth" style="word-wrap: break-word;white-space:wrap;width:380px"><%=queryName%></div></td>
											<td class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first" align="right"><%=queryCount%></td>
											<td class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first" align="right"><%=queryTime%></td>
											<td class="x-grid-cell x-grid-cell-gridcolumn x-grid-cell-first" align="right"><%=queryPercentage%></td>
										</tr>
<%
				}
			}
%>
										<tr>
											<td colspan="3" class="jtm_Total" align="right"><egui:intnl text='monitor.layermodel.Total'/></td>
											<td class="jtm_Total" align="right"><%=df.format(query_total_time)%></td>
											<td class="jtm_Total" align="right"><%=df.format(query_total_per)%></td>
										</tr>
									</tbody>
								</table>
								</div>
							</td>
						</tr>
					</table>
				</td>
			</tr>
<%
		}
%>
		</table>
	</div>
</div>
<%
		}
		else
		{
%>
<div class="clr" style="border:0px solid red;height:100%;">
	<table align="left" cellspacing="0" cellpadding="6" height="100%" width="100%" >
		<tr>
			<td>
				<table align="left" cellspacing="0" cellpadding="0" height="100%" width="100%" border="0" class="jtm_DatapanelBody eg_lightlight">
					<tr>
						<td align="center" valign="middle" class="commonErrorMsgText"> 
							<img src="/final/images/clear.png" align="center" border="0" class="iconExclamation"/><br>
							<egui:intnl text='monitor.layermodel.No Java Transaction Details ! '/>
						</td>
					</tr>
				</table>
			</td>
		</tr>
	</table>
</div>
<%
		}
	}
	catch(Exception e)
	{
		out.println("Exception-eGJTMDetails.jsp");
		e.printStackTrace();
	}
%>
