<%
/**
 *	File name		: eGJTMBase.jsp
 *	Purpose			: This is the Base Page for All JTM related Jsp(s)
 *	Version			: eG 5.5
 *	Creation Date	: 10-03-2012
 *	Author			: Mr.R
 *	Design Help 	: Mr.Jaiwin
 */
%>
<%@ include file = "EgLoginTracker.jsp" %>
<%@ page errorPage = "EgProbsM.jsp" %>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.monitor.EgJTMHelper"%>
<%@ page import = "java.util.*" %>
<%@ page session = "true" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>

<style media="all" rel="Stylesheet" type="text/css">
/*.folder { background: url(../images/jtm_arrow_down.png)  no-repeat; float: left; height: 15px; width: 15px; padding-right: 3px; margin-left: 0px; ! important}
.doc {border:1px solid green; height: 15px; width: 15px; padding-right: 3px; margin-left: 0px; ! important;}
.folder { background:url('/final/images/Dark/eG_Icons.png') no-repeat top left; padding-right: 3px; margin-left: 0px; !important; background-position:0 -1340px;width:16px;height:16px;display:block;float:left}

.doc {background:url('/final/images/Dark/eG_Icons.png') no-repeat top left; background-position:0 -1360px;width:16px;height:16px;border:0px solid green; padding-right: 3px; margin-left: 0px; ! important;}*/

.folder { background: url(../images/Light/jtm_arrow_down.png)  no-repeat; float: left; height: 15px; width: 15px; padding-right: 3px; margin-left: 0px; ! important}
.doc {border:1px solid green; height: 15px; width: 15px; padding-right: 3px; margin-left: 0px; ! important;}




/* Targetting Webkit browsers only. FF will show the dropdown arrow with so much padding. */
@media screen and (-webkit-min-device-pixel-ratio:0) {
    select {padding-right:18px}
}

label {position:relative;padding:2px}
label:after {
    content:'<>';
    font:11px "LucidaGrandeRegular";
    color:#aaa;
    -webkit-transform:rotate(90deg);
    -moz-transform:rotate(90deg);
    -ms-transform:rotate(90deg);
    transform:rotate(90deg);
    right:8px; top:2px;
    padding:0 0 2px;
    border-bottom:1px solid #ddd;
    position:absolute;
    pointer-events:none;
}
label:before {
    content:'';
    right:6px; top:0px;
    width:20px; height:20px;
    background:#f8f8f8;
	padding:2px 0 0,
    position:absolute;
    pointer-events:none;
    display:block;
}
select::-ms-expand {
    display: none; /* hide default arrow in IE10 */
}

.option{

	padding:2px;
	height:20px;
	background:green

}
option[selected="selected"] {
    /*css style here*/
	padding:2px;
	height:20px;
	background:red
}
</style>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	String ua = request.getHeader( "User-Agent" );
	boolean isFirefox = ( ua != null && ua.indexOf( "Firefox/" ) != -1 );
	boolean isMSIE6 = ( ua != null && ua.indexOf( "MSIE 6.0" ) != -1 );
	
%>
	<jsp:useBean id="trans" scope="page" class="egurkha.TransactionBean" />
<%
try
{
%>
<!DOCTYPE html>
<html lang="en">
<head>
<title>URL Trees</title>
<meta charset="utf-8">
<egui:skin ui="monitor"/>
<script  src="/final/jquery/jquery.js"></script >
<script  src="/final/jquery/ui/jquery.ui.core.js"></script>
<script  src="/final/jquery/ui/jquery.ui.widget.js"></script> 
<script  src="/final/jquery/ui/jquery.ui.mouse.js"></script>
<script  src="/final/jquery/ui/jquery.ui.draggable.js"></script>
<script type="text/javascript" src="/final/monitor/eg_scripts/eg_aggregate.js"></script>
<script language = "JavaScript1.2"  type="text/javascript" src="/final/FusionCharts/scripts/FusionCharts.js"></script>
<script type="text/javascript">

var $j = jQuery.noConflict();

function reloadUrl(measure, info, a_results_sessKey) 
{
	$j("#ExtCallDiv").hide('slow');
	var mesTime = document.getElementById("time");
	var sort =  document.getElementById("sortname");
	var tab = "summary";
	var url="/final/monitor/eGJTMBase.jsp?lastMeasTime=" + encodeURIComponent(mesTime.value) + "&sortby="+encodeURIComponent(sort.value)+"&tab=summary"+"&s_measure="+encodeURIComponent(measure)+"&info="+encodeURIComponent(info);
	if(a_results_sessKey != "" && typeof a_results_sessKey !== "undefined" && a_results_sessKey != null && a_results_sessKey !== "null"){
		url += "&fromPage=mydashboard&a_results_sessKey=" + a_results_sessKey;
	} 
	window.location.href=url;
}

function showDetails(value,measure, info)
{
	$j("#ExtCallDiv").hide('slow');
	var glance_class = $j('#glance').attr('class');
	var sql_class = $j('#sql').attr('class');
	var trace_class = $j('#trace').attr('class');

	if(glance_class == 'current')
	{
		showSummary('glance', measure, info);
	}
	else if(sql_class == 'current')
	{
		showSQL('sql', measure, info);
	}
	else if(trace_class == 'current')
	{
		showTrace('trace',null , measure , info);
	}
	hideDivs('QueryDiv');
}

function showSQL(tabname, measure, info)
{
	$j("#ExtCallDiv").hide('slow');
	changeClass(tabname);
	var urlSelectObj = document.getElementById("urlname");
	if(urlSelectObj!=null)
	{
		var urlValue = urlSelectObj.options[urlSelectObj.selectedIndex].value;
		fillTabs('urlDetailsDiv','<%=response.encodeURL("../monitor/eGJTMQuery.jsp?")%>'+"&label=all&only=-1&key="+encodeURIComponent(urlValue)+'&s_measure='+encodeURIComponent(measure)+"&info="+encodeURIComponent(info));
	}
	var t=setTimeout("divResize()",100);
}

function showSummary(tabname, measure , info )
{
	$j("#ExtCallDiv").hide('slow');
	changeClass(tabname);
	var urlSelectObj = document.getElementById("urlname");
	if(urlSelectObj!=null)
	{
		var urlValue = urlSelectObj.options[urlSelectObj.selectedIndex].value;
		//fillTabs('urlDetailsDiv','<%=response.encodeURL("../monitor/eGJTMDetails.jsp?key=")%>'+encodeURIComponent(urlValue));
		var encode_url='<%=response.encodeURL("../monitor/eGJTMDetails.jsp?")%>'+"&key="+encodeURIComponent(urlValue)+'&s_measure='+encodeURIComponent(measure)+'&info='+encodeURIComponent(info);
		$j.ajax({
			method: "POST",
			url: encode_url,
			cache: false,
			dataType: "html",
			success: function(strHTML, textStatus, jqXHR)
			{
				$j("#urlDetailsDiv").html( strHTML );
			},
			error: function(jqXHR, textStatus, errorThrown) 
			{
			}
		});
	}
	var t=setTimeout("divResize()",100);
}

function showTrace(tabname, methodname,measure , info)
{
	$j("#ExtCallDiv").hide('slow');
	changeClass(tabname);
	showLoadingDiv();
	var urlSelectObj = document.getElementById("urlname");
	if(urlSelectObj!=null)
	{
		var urlValue = urlSelectObj.options[urlSelectObj.selectedIndex].value;
		if(methodname!=null)
		{
			fillTabs('urlDetailsDiv','<%=response.encodeURL("../monitor/eGJTMTrace.jsp?")%>'+"&key="+encodeURIComponent(urlValue)+'&mname='+encodeURIComponent(methodname)+'&s_measure='+encodeURIComponent(measure)+'&info='+encodeURIComponent(info));
		}
		else
		{
			fillTabs('urlDetailsDiv','<%=response.encodeURL("../monitor/eGJTMTrace.jsp?")%>'+"&key="+encodeURIComponent(urlValue)+'&s_measure='+encodeURIComponent(measure)+'&info='+encodeURIComponent(info));
		}
		var t=setTimeout("openAllRows('"+methodname+"')",500);
	}
	var t=setTimeout("divResize()",100);
}

function showExtCallDiv(nodeLabel , nodeDetails , type, responsetime){
	//alert('nodeLabel :'+nodeLabel +'   nodeDetails : ' + nodeDetails+'    '+type);
	var extDiv = document.getElementById('ExtCallDiv');
	var extInnerDiv = document.getElementById("extInnerDiv");
	var divObj='extInnerDiv';
	if(extDiv!=null){
		//extInnerDiv.innerHTML = "<table width='100%' border='0' bgcolor='white' height='250px'><tr><td align=center valign=center><img src=/final/monitor/eg_images/indicator_medium.gif></td></tr></table>";
		fillTabs(divObj,'<%=response.encodeURL("../monitor/eGJTMExtCall.jsp?")%>'+"&nodeLabel="+encodeURIComponent(nodeLabel)+'&nodeDetails='+encodeURIComponent(nodeDetails)+'&subcompType='+encodeURIComponent(type)+'&resTime='+encodeURIComponent(responsetime));
		$j("#ExtCallDiv").css({"display":"block" , "position":"absolute" });
		var maxInd = maxIndex();
		$j("#ExtCallDiv").css({"z-index":maxInd+1});
		$j("#ExtCallDiv").show('slow');
	}
}

function showQueryDiv(value, sqlIndex, only, measure, info)
{
	$j("#ExtCallDiv").hide('slow');
	var show_div = document.getElementById('QueryDiv');
	var urlSelectObj = document.getElementById("urlname");
	if(sqlIndex == null) sqlIndex = '-1';
	if(only == null) only = '-1';
	if(show_div!=null)
	{
		var innerDiv = document.getElementById("innerDiv");
		var urlValue = urlSelectObj.options[urlSelectObj.selectedIndex].value;
		fillTabs('innerDiv','<%=response.encodeURL("../monitor/eGJTMQuery.jsp?")%>'+"&label="+encodeURIComponent(value)+'&key='+encodeURIComponent(urlValue)+'&index='+encodeURIComponent(sqlIndex) + '&only='+encodeURIComponent(only)+'&s_measure='+encodeURIComponent(measure)+'&info='+encodeURIComponent(info));
		$j("#QueryDiv").css({"display":"block" , "position":"absolute" });
		var maxInd = maxIndex();
		$j("#QueryDiv").css({"z-index":maxInd+1});
		$j("#QueryDiv").show('slow');
	}
}

function maxIndex()
{
	var index_highest = 0;
	$j('div').each(function(){
		var index_current = parseInt($j(this).css("z-index"), 10);
		if(index_current > index_highest) {
			index_highest = index_current;
		}
	});
	return index_highest.toString();
}

function hideDivs(divId)
{
	$j("#"+divId).hide("slow");
}

function changeClass(tabname)
{
	$j("#ExtCallDiv").hide('slow');
	if(tabname == 'glance')
	{
		$j('#trace').removeClass("current");
		$j('#sql').removeClass("current");
		$j('#glance').removeClass("jtm_Tab");
		$j('#glance').addClass("current");
		$j('#trace').addClass("jtm_Tab");
		$j('#sql').addClass("jtm_Tab");
	}
	else if( tabname == 'trace')
	{
		$j('#glance').removeClass("current");
		$j('#sql').removeClass("current");
		$j('#trace').removeClass("jtm_Tab");
		$j('#trace').addClass("current");
		$j('#glance').addClass("jtm_Tab");
		$j('#sql').addClass("jtm_Tab");
	}
	else if(tabname == 'sql')
	{
		$j('#glance').removeClass("current");
		$j('#trace').removeClass("current");
		$j('#sql').removeClass("jtm_Tab");
		$j('#sql').addClass("current");
		$j('#glance').addClass("jtm_Tab");
		$j('#trace').addClass("jtm_Tab");
	}
}

$j(document).ready(function(){
	$j("#dividerImgChange").click(function(){
			
			$j(".selectDiv").toggle();
			divResize();
	});

	divResize();

	/*   JQuery Drag & Drop Functionality  (Begin)   */
	$j.globalVars = {
		//originalTop: 0,
		//originalLeft: 0,
		maxHeight: $j(window).height(),
		maxWidth:  $j(window).width()
	};

	$j( "#QueryDiv" ).draggable({ 
		cancel: "tr.ui-widget-header-temp",
		cursor: "move",
		scroll: false,
		//iframeFix: false,
		//snapMode: "both", 
		//opacity: 0.35,
		containment: [-parseInt($j.globalVars.maxWidth),0, parseInt($j.globalVars.maxWidth), parseInt($j.globalVars.maxHeight)]
		//containment: "parent",
		//stop: handleDragStop
	});
	/*   JQuery Drag & Drop Functionality  (End)   */

	$j( "#ExtCallDiv" ).draggable({
		cancel: "tr.ui-widget-header-temp",
		cursor: "move",
		scroll: false,
		containment: [-parseInt($j.globalVars.maxWidth),0, parseInt($j.globalVars.maxWidth), parseInt($j.globalVars.maxHeight)]
	});
});

/*function handleDragStop( event, ui )
{
	var offsetXPos = parseInt( ui.offset.left );
	var offsetYPos = parseInt( ui.offset.top );
	//alert( "Drag stopped!\n\nOffset: (" + offsetXPos + ", " + offsetYPos + " )\n");
}*/

function showLoadingDiv()
{
	$j("#loading_image").css({"display":"block" , "position":"absolute" });
	var maxInd = maxIndex();
	$j("#loading_image").css({"z-index":maxInd+1});
	$j("#loading_image").show('slow');
	var dataDivWidth = $j(".dataDiv").innerWidth();
	var mainDivWidth = $j(window).width();
	var left_pos = parseInt(mainDivWidth) - parseInt(dataDivWidth) + parseInt(dataDivWidth) / 2;
	$j("#loading_image").css('left',left_pos);
}

function divResize()
{
	var mainDivWidth = $j(window).width();
	var mainDivHeight = $j(window).height();

	$j(".topDiv").width(mainDivWidth-40);
	//$j(".dataDiv").width(mainDivWidth-248);
	//$j(".dataDiv").width(mainDivWidth-268);
	$j(".dataDiv").height(mainDivHeight-136);

	var selectDivObj=$j(".selectDiv").css("display");
	var dataDivObj=$j(".dataDiv").css("display");
	if (dataDivObj!=null && dataDivObj=='block' && selectDivObj!=null && selectDivObj=='block')
	{
		//$j(".dataDiv").innerWidth(mainDivWidth-248);
		$j(".dataDiv").innerWidth(mainDivWidth-275);
		$j(".dataDiv").height(mainDivHeight-136);
		$j(".urlWidth").width(mainDivWidth-410);
		$j(".methodWidth").width(mainDivWidth-505);
		$j("#dividerImgChange").removeClass('dividerRight').addClass('dividerLeft');
	}
	else if (dataDivObj!=null && dataDivObj=='block' && selectDivObj!=null && selectDivObj=='none')
	{
		$j(".dataDiv").width(mainDivWidth-40);
		$j(".dataDiv").height(mainDivHeight-136);
		$j(".urlWidth").width(mainDivWidth-175);
		$j(".methodWidth").width(mainDivWidth-285);
		$j("#dividerImgChange").removeClass('dividerLeft').addClass('dividerRight');
		if (document.getElementById("mainDataDiv"))
		{
			document.getElementById("mainDataDiv").style.width = (window.innerWidth-40)+"px";
			document.getElementById("mainDataDiv").style.height = (window.innerHeight-140)+"px";
		}
	}
}

/*********** JTM Tree-Table Scripts (Begins) ****************************/ 
function array_contains(obj)
{
	for (var i = 0; i < this.length; i++){
		if (this[i] == obj) return i;
	}
	return -1;
}
Array.prototype.contains = array_contains;

function array_remove(obj)
{
	var index = this.contains(obj);
	if(index > -1)
		this.splice(index, 1);
}
Array.prototype.remove = array_remove;

// using this function ensure that you won't add an element which already exists in the array
function array_add(obj)
{
	var index = this.contains(obj);
	if(index == -1)
		this.push(obj);
}
Array.prototype.add = array_add;

function array_to_string()
{
	var result = '';
	for (var i = 0; i < this.length; i++)
	{
		result += this[i] + " ; ";
	}
	return result;
}
Array.prototype.to_string = array_to_string;

var open_nodes = new Array();
var FOLDER_CLSD_PIC = "/final/images/Light/jtm_arrow_forward.png";
var FOLDER_OPEN_PIC = "/final/images/Light/jtm_arrow_down.png";
//var DOC_PIC = "/final/images/icon_doc_sml.gif";
var normalColor = 'eg_whitebg';
var highlightColor = 'eg_lightlight';
var RE_PATH = "[0-9]+"; 
var TREE_PATH_SEP  = '.';

// This method should be called when a click occurs on the folder icon (or something equivalent!)
// e is the event and elm is the element on which the event occured
function toggleRows(e, elm, rowid)
{
	// first we check if we moved the mouse during the click as it signifies that it is a dnd and not a click
	if(mouseMoved(e))
		return;
	var id = rowid; // the id of the row we are toggling (it contains the path)
	var toggledRow = document.getElementById(rowid);
	if(toggledRow == null)
		return;
	var name = toggledRow.getAttribute('name');
	var parentTable = document.getElementById("mainTable");
	var rows = parentTable.rows;
	// regular expression representing the id of the children of toggledRow
	var idToggledRE = id.slice(0, id.length) + RE_PATH;
	if(open_nodes.contains(name) > -1) // the element was opened -> closing
	{
		elm.style.backgroundImage = "url("+FOLDER_CLSD_PIC+")";
		for (var i = 0; i < rows.length; i++)
		{
			var currentRow = rows[i];
			if (matchStart(currentRow.id, idToggledRE, false)) // if currentRow is a child of toggledRow
			{
				currentRow.style.display = "none";
			}
		}
		open_nodes.remove(name);
	}
	else // opening
	{
		// trick to avoid a problem of display after a restore when a folder become a doc as he is empty
		if(elm.getAttribute("class") !=null && elm.getAttribute("class") != 'folder'){
			open_nodes.remove(name);
			return;
		}
		elm.style.backgroundImage = "url("+FOLDER_OPEN_PIC+")";
		for (var i = 0; i < rows.length; i++)
		{
			var currentRow = rows[i];
			var currentIconLink = currentRow.getElementsByTagName("A")[0];
			if (matchStart(currentRow.id, idToggledRE, true)) // if currentRow is a child of toggledRow
			{
				//if (document.all)
				currentRow.style.display = "block"; //IE4+ specific code
				//else
				currentRow.style.display = "table-row";

				// this is just to be sure that we have the right icon (maybe not necessary)
				//if(currentIconLink.getAttribute("class") != 'folder')
				//currentIconLink.style.backgroundImage = "url("+DOC_PIC+")";

				// reopen the rows which where already opened 
				if (open_nodes.contains(currentRow.getAttribute('name')) > -1)
				{
					open_nodes.remove(currentRow.getAttribute('name'));
					toggleRows(null, currentIconLink , currentRow.id);
				}
			}
		}
		open_nodes.add(name);
	}
	// ignore the selectRow event as it was a toggling event
	ignoreSelectRowEvt = true;
}

// pattern is a string containing a regular expression without the '/' at the beginning and the end
// returns true if target begin with pattern, false else. Moreover if matchDirectChildrenOnly=true
// we return false if the target is not a direct child.
function matchStart(target, pattern, matchDirectChildrenOnly)
{
	var patternObj = eval("/^"+pattern+"/");
	if (!target.match(patternObj)) return false;
	if (!matchDirectChildrenOnly) return true;
	var extendedPattern = eval("/^"+pattern+"["+TREE_PATH_SEP+"]"+RE_PATH+"/");
	if (target.match(extendedPattern)) return false;
	return true;
}

function collapseAllRows()
{
	var rows = document.getElementsByTagName("TR");
	var pattern = eval("/^[0-9]+["+TREE_PATH_SEP+"]"+RE_PATH+"/");
	var patternFirstLevel = eval("/^"+RE_PATH+"["+TREE_PATH_SEP+"]$/");
	for (var j = 0; j < rows.length; j++)
	{
		var r = rows[j];
		if (r.id.match(pattern))
		{
			r.style.display = "none";
			if(r.getElementsByTagName("A")[0].getAttribute('class')=='folder')
				r.getElementsByTagName("A")[0].style.backgroundImage = "url("+FOLDER_CLSD_PIC+")";
			//else 
				//r.getElementsByTagName("A")[0].style.backgroundImage = "url("+DOC_PIC+")";
		}
		else if (r.id.match(patternFirstLevel))
		{
			r.getElementsByTagName("A")[0].style.backgroundImage = "url("+FOLDER_CLSD_PIC+")";
		}
	}
	open_nodes = new Array();
}


function highLightRows(methodname)
{
	var divObj = document.getElementById("urlDetailsDiv");
	var rows = divObj.getElementsByTagName("TR");
	if(methodname!=null)
	{
		var first = 0;
		for (var i = 0; i < rows.length; i++)
		{
			var r = rows[i];
			var title = r.title;
			if(title == methodname)
			{
				r.className = 'trhover';
				if(first == 0)
				{
					var rowName = $j(rows[i]).attr('name');
					var rowno = parseInt(rowName.substring(1));
					var topvalue = rowno * r.offsetHeight; 
					//alert("topvalue :"+topvalue + ' rowno :'+rowno);
					$j(".dataDiv").scrollTop(topvalue);
					first = 1;
				}
			}
		}
	}
	hideDivs('loading_image');
}

function openAllRows(methodname)
{
	var divObj = document.getElementById("urlDetailsDiv");
	var rows = divObj.getElementsByTagName("TR");
	var pattern = eval("/^"+RE_PATH+"["+TREE_PATH_SEP+"]/");
	var patternFirstLevel = eval("/^"+RE_PATH+"["+TREE_PATH_SEP+"]$/");
	var firstLevelRows = new Array();
	open_nodes = new Array();
	//alert('rows.length :'+rows.length);
	for (var i = 0; i < rows.length; i++)
	{
		var r = rows[i];
		//alert('r.id :'+r.id + ' M1: ' +r.id.match(patternFirstLevel) + 'M2:'+r.id.match(pattern));
		if (r.id.match(patternFirstLevel))
		{
			firstLevelRows.push(r);
		}
		else if (r.id.match(pattern))
		{
			open_nodes.add(r.getAttribute('name'));
		}
	}

	for (var j = 0; j < firstLevelRows.length; j++)
		toggleRows(null,firstLevelRows[j].getElementsByTagName("A")[0], firstLevelRows.id);
	//alert('This is openAllRows....'+open_nodes.length);
	highLightRows(methodname);
}

// restore the state of the tree depending on open_nodes
// take all the nodes of first level and for each reopen or close it depending on 
// the open_nodes list. Moreover we call toggleRows to restore the state of the children nodes.
function restore()
{
	var rows = document.getElementsByTagName("TR");
	var pattern = eval("/^"+RE_PATH+"["+TREE_PATH_SEP+"]$/");
	for (var j = 0; j < rows.length; j++)
	{
		var r = rows[j];
		if (r.id.match(pattern)) // first level 
		{
			// as toggleRows() will check open_nodes to know wheter it has to open or close the node, 
			// we have to do the opposite before because we just want to restore the state and not to really toggle it
			if (open_nodes.contains(r.getAttribute('name')) > -1)
				open_nodes.remove(r.getAttribute('name'));
			else
				open_nodes.add(r.getAttribute('name'));
			toggleRows(null, r.getElementsByTagName("A")[0]);
		}
	}
}

// This method should be used with an onclick event for your tables rows (TR)
// in order to have them visually selected
var selectedRow;
var ignoreSelectRowEvt = false; // set this variable to true if you want to ignore the next selectRow event
function selectRow(row , method)
{
	if(ignoreSelectRowEvt)
	{
		ignoreSelectRowEvt = false;
		return;
	}
	if(selectedRow)
		selectedRow.className = normalColor;
	// if we are deselecting
	if(selectedRow && selectedRow.id == row.id)
	{
		selectedRow = null;
	}
	else
	{
		selectedRow = row;
		row.className = highlightColor;
	}
	if(row.title == method)
		row.className = 'trhover';
}

var clicX = 0;
var clicY = 0;
function storeMouseXY(e)
{
	if (!e) var e = window.event; 
	if (e.pageX || e.pageY)
	{
		clicX = e.pageX;
		clicY = e.pageY;
	}
	else if (e.clientX || e.clientY)
	{
		clicX = e.clientX + document.body.scrollLeft;
		clicY = e.clientY + document.body.scrollTop;
	}
}

// return true if the mouse moved more than 3 pixels in one direction between the beginning
// of the event and the end of the envent
// WARNING : in order to use this method you should use onmousedown="storeMouseXY(event); in the 
// element where is called mouseMoved...
function mouseMoved(e)
{
	if(e)
	{
		var oldx = clicX, oldy = clicY;
		storeMouseXY(e);
		if(Math.abs(clicX-oldx) > 3 || Math.abs(clicY-oldy) > 3)
			return true;
	}
	return false;
}
/*********** JTM Tree-Table Scripts (Begins) ****************************/ 
function myFunction() {
    var w = window.outerWidth;
    var h = window.outerHeight;
    var txt = "Window size: width=" + w + ", height=" + h;
	//alert(txt);
	//alert(txt);
   //document.getElementById("urlDetailsDiv").width = w;
	//alert(document.getElementById("callGraphDetails"));
	//alert(document.getElementById("topDiv"));
	//alert(document.getElementById("selectDiv"));
	var selectDivObj=$j(".selectDiv").css("display");
	var dataDivObj=$j(".dataDiv").css("display");
	if (dataDivObj!=null && dataDivObj=='block' && selectDivObj!=null && selectDivObj=='none')
	{
		//alert("select hidden");
		//alert(document.getElementById("mainDataDiv").style.width);
		if (document.getElementById("mainDataDiv"))
		{
			document.getElementById("mainDataDiv").style.width = (window.innerWidth-40)+"px";
			document.getElementById("mainDataDiv").style.height = (window.innerHeight-140)+"px";
		}

	}
	else
	{
		//alert("select show");
	if (document.getElementById("mainDataDiv"))
	{
		document.getElementById("mainDataDiv").style.width = (window.innerWidth-280)+"px";
		document.getElementById("mainDataDiv").style.height = (window.innerHeight-140)+"px";
	}

	}
	
	if (document.getElementById("teste"))
		document.getElementById("teste").style.height = (window.innerHeight-115)+"px";
	
	if (document.getElementById("topDiv"))
		document.getElementById("topDiv").style.width = (window.innerWidth-40)+"px";

	if (document.getElementById("traceDiv"))
	{
		document.getElementById("traceDiv").style.width = (window.innerWidth-280)+"px";
		document.getElementById("traceDiv").style.height = (window.innerHeight-138)+"px";
	}

	if (document.getElementById("urlname"))
		document.getElementById("urlname").style.height=(window.innerHeight-125)+"px";
//$j(".topDiv").width(mainDivWidth-50);

}
</script>
</head>
<%
	String popup_topright = isMSIE6?"popup_topright_noshade":"popup_topright";
	String popup_rightbg = isMSIE6?"popup_rightbg_noshade":"popup_rightbg";
	String popup_bottomleft = isMSIE6?"popup_bottomleft_noshade":"popup_bottomleft";
	String popup_bottombg = isMSIE6?"popup_bottombg_noshade":"popup_bottombg";
	String popup_bottomright = isMSIE6?"popup_bottomright_noshade":"popup_bottomright";
%>
<body leftmargin="0" topmargin="0" marginheight="0" marginwidth="0" scroll="no" style="overflow:hidden" onload="myFunction()" onresize="myFunction()">
<!-- Full Query Details Div -->
<div id="QueryDiv" name="QueryDiv" class="ui-widget-content" style="display:none;left:10px;top:50px;width:650px;height:290px;border:1px solid #cdcdcd; background:#fff;position:absolute;-webkit-box-shadow:0 10px 10px 0 rgba(100,100,100,0.45);-moz-box-shadow:0 10px 10px 0 rgba(100,100,100,0.45);box-shadow:0 10px 10px 0 rgba(100,100,100,0.45)">
<table border="0" bordercolor="blue" cellpadding="0" cellspacing="0">
	<tr>
		<td colspan="3" width="100%">
			<table border="0"  cellpadding="0" cellspacing="0" width="98.8%" class="jtm_InnerHeader">
				<tr>
					<td width="10" height="27" class="popup_topleft"><img src="/final/monitor/eg_images/spacer.gif" width="10" height="27" border="0"></td>
					<td id="GraphTitle" class="popup_topbg eg_75bold whitefont"  height="27px"><egui:intnl text='monitor.layermodel.Query/Error Details'/></td>
					<td align="right" class="popup_topbg" style="padding-right:3px"><img class="iconClose3" src="/final/images/clear.png" border="0" class="mouse" title="close" vspace="2" onclick="javascript:hideDivs('QueryDiv');"> </td>
				</tr>
			</table>
		</td>
	</tr>
	<tr class="ui-widget-header-temp">
		<td class="popup_leftbg"  width="7px"><img src="/final/monitor/eg_images/spacer.gif" width="7"></td>
		<td align="center" valign="top" >
		<!-- <div class="div_scroll"> -->
				<table border="0" bordercolor="green" cellpadding="0" cellspacing="0" width="100%" height="100%">
					<tr>
						<td class="white_bg">
							 <!-- //<iframe src="'+url+'" width="635" height="250" frameborder="0" leftmargin="0" marginwidth="0" marginheight="0" rightmargin="0"> </iframe> -->
							<div class="jtm_DatapanelBody" id="innerDiv"  name="innerDiv" style="margin-top:8px;overflow:auto;left:0px;top:0px;width:635px;height:250px;"> </div>
						</td>
					</tr>
				</table>
			<!-- </div> -->
		</td>
		<td class="<%=popup_rightbg%>" width="14px"><img src="/final/monitor/eg_images/spacer.gif" width="14"></td>
	</tr>
	<tr class="ui-widget-header-temp">
		<td class="<%=popup_bottomleft%>"><img src="/final/monitor/eg_images/spacer.gif" width="7" height="16"></td>
		<td  class="<%=popup_bottombg%>" height="16"><img src="/final/monitor/eg_images/spacer.gif"></td>
		<td class="<%=popup_bottomright%>"><img src="/final/monitor/eg_images/spacer.gif" width="14" height="16"></td>
	</tr>
</table>
</div>



<div id="ExtCallDiv" name="ExtCallDiv" class="ui-widget-content" style="display:none;left:10px;top:50px;width:650px;height:150px;border:0px solid #ff0000; background:#fff;position:absolute;-webkit-box-shadow:0 10px 10px 0 rgba(100,100,100,0.45);-moz-box-shadow:0 10px 10px 0 rgba(100,100,100,0.45);box-shadow:0 10px 10px 0 rgba(100,100,100,0.45)">
<table border="0" bordercolor="blue" cellpadding="0" cellspacing="0">
	<tr>
		<td colspan="3" width="100%">
			<table border="0"  cellpadding="0" cellspacing="0"  width="98.8%" class="jtm_InnerHeader">
				<tr>
					<td width="10" height="27" class="popup_topleft"><img src="/final/monitor/eg_images/spacer.gif" width="10" height="27" border="0"></td>
					<td id="ExCallTitle" class="popup_topbg eg_75bold whitefont"  height="27px"><egui:intnl text='monitor.layermodel.External Call Details'/></td>
					<td align="right" class="popup_topbg" style="padding-right:3px"><img class="iconClose3" src="/final/images/clear.png" border="0" class="mouse" title="close" vspace="2" onclick="javascript:hideDivs('ExtCallDiv');"> </td>
				</tr>
			</table>
		</td>
	</tr>
	<tr class="ui-widget-header-temp">
		<td class="popup_leftbg"  width="7px"><img src="/final/monitor/eg_images/spacer.gif" width="7"></td>
		<td align="center" valign="top" >
			<table border="0" bordercolor="green" cellpadding="0" cellspacing="0" width="100%" height="100%">
				<tr>
					<td class="white_bg">
						<div class="jtm_DatapanelBody" id="extInnerDiv"  name="extInnerDiv" style="left:0px;top:0px;width:635px;height:120px;border:0px solid #ffff00;"> </div>
					</td>
				</tr>
			</table>
		</td>
		<td class="<%=popup_rightbg%>" width="14px"><img src="/final/monitor/eg_images/spacer.gif" width="14"></td>
	</tr>
	<tr class="ui-widget-header-temp">
		<td class="<%=popup_bottomleft%>"><img src="/final/monitor/eg_images/spacer.gif" width="7" height="16"></td>
		<td  class="<%=popup_bottombg%>" height="16"><img src="/final/monitor/eg_images/spacer.gif"></td>
		<td class="<%=popup_bottomright%>"><img src="/final/monitor/eg_images/spacer.gif" width="14" height="16"></td>
	</tr>
</table>
</div>


<!--<div id ="loading_image" style = "position:absolute;top:200px;left:450px;visibility:visible;display:block;border:0px solid #ff0000;"> 
	<table height="100%">
		<tr>
			<td height="100%" valign="middle"> 
				<img src='/final/admin/eg_images/indicator_medium.gif'>
			</td>
		</tr>
	</table>
</div>-->

<%
	String lastMeasTime = request.getParameter("lastMeasTime");
	String s_date=request.getParameter("sdate");
	String sortOrder=request.getParameter("sortby");
	String measureName=request.getParameter("s_measure");
	String infoName=request.getParameter("info");
	String a_results_sessKey = request.getParameter("a_results_sessKey");
	String fromPage = request.getParameter("fromPage");
	if(infoName!=null && infoName.length() > 2 && infoName.indexOf("*")==0){
		infoName = infoName.substring(1);
	}

	String tab = request.getParameter("tab");
	if(tab == null || tab =="")
		tab = "summary";

	String dummylastMeasTime = lastMeasTime;
	String isTable= isFirefox ? "Auto" : "Fixed";
	ArrayList a_results = null;
	if(fromPage != null && a_results_sessKey != null && fromPage.equalsIgnoreCase("mydashboard")) {
		a_results = (ArrayList)session.getAttribute(a_results_sessKey);
	} else {
		a_results = (ArrayList)session.getAttribute("a_results");
	}
	
	if(StringUtils.isNull(sortOrder))
	{
		sortOrder = "4";
	}
	int sortColumn = Integer.parseInt(sortOrder);

	if(StringUtils.isNull(lastMeasTime)) 
	{
		if(s_date!=null && s_date.length()>0) 
		{
			lastMeasTime= s_date;
		}
		else 
		{
			lastMeasTime=(String) a_results.get(0);
		}

		if ((lastMeasTime == null) || (lastMeasTime.length() == 0)) 
		{
			lastMeasTime = "Not Available";
		}
	}

	ArrayList valList = new ArrayList();
	ArrayList measureTimeList = new ArrayList();
	ArrayList UrlNameList = new ArrayList();
	
	for(int k=0;k<a_results.size();k=k+2) 
	{
		String mesTime = (String) a_results.get(k);
		measureTimeList.add(mesTime);
		if(lastMeasTime.equals(mesTime))
		{
			ArrayList val = (ArrayList) a_results.get(k+1);
			Set valSet = new HashSet(val);
			List listVal = new ArrayList(valSet);
			for(int j=0;j<listVal.size();j++)
			{
				ArrayList tmpArrList = (ArrayList) listVal.get(j);
				valList.add(tmpArrList);
			}
		}
	}
	Set tmpSet = new HashSet();
	tmpSet = new HashSet(valList);
	valList = new ArrayList(tmpSet);

	//Sorting of coloumns
	EgJTMHelper jtmHelper = new EgJTMHelper();
	ArrayList sortedList = jtmHelper.arrayListSort(valList,sortColumn,5);
	Hashtable resultTable = new Hashtable();
	for(int k=0;k<sortedList.size();k++)
	{
		ArrayList thisList = (ArrayList) sortedList.get(k);
		if(thisList!=null && thisList.size() == 5)
		{
			String reqestedTime = (String) thisList.get(0);
			String requestedURI = (String) thisList.get(1);
			//String requsestedHost = (String) thisList.get(2);
			String keyString = Integer.toString(k) + "@" +requestedURI +" @ " +reqestedTime ;
			UrlNameList.add(keyString);
			resultTable.put(keyString, thisList);
		}
	}
	//System.out.println("[JTMTree ] "+resultTable + "  Size :"+resultTable.size());
	session.setAttribute("JtmTree",resultTable);
	Hashtable nodeInfoTable = new Hashtable();
	session.setAttribute("NodeInfo",nodeInfoTable);

	//To remove duplicate measurement times, if any
	TreeSet ts = new TreeSet(measureTimeList);
	measureTimeList = new ArrayList(ts);

	trans.createFile("eg_format.ini");
	String strValue=trans. getStrValue("DDD_TESTS", "JavaTransactionsTest");
	ArrayList header = StringUtils.egTokenizer(strValue,",");

	if(!lastMeasTime.equals("Not Available")||(s_date!=null) && a_results.size()>0) 
	{
%>
		<div style="width:100%;height:100%;" class="mainDiv eg_morelight">
			<div id="topDiv" class="jtm_formouter topDiv" style="padding:10px;display:inline-block;border:0px solid red;width:900px">
				<div style="float:left;display:inline;" class="eg_75bold">
					<div style="padding:2px;font-weight:bold"> <egui:intnl text='monitor.layermodel.Measurement Time '/></div>
					<div >
						<select class="jtmDropdown" name ="time" id="time" style="width:180px" onChange="javaScript:reloadUrl('<%=measureName%>' , '<%=infoName%>','<%=a_results_sessKey%>');">
<%
	for(int i=measureTimeList.size()-1;i>=0;i--) 
	{
		String tmp = (String)measureTimeList.get(i);
		String selected="";
		if (tmp.equals(lastMeasTime))
			selected ="selected";
		else
			selected="";
%>
						<option class="optionTxt" value="<%=tmp%>" <%=selected%>> <%=tmp%> </option>
<%
	}
%>
						</select>
					</div>
				</div>

				<div style="float:left;display:inline;width:10px" class="eg_75bold">&nbsp;</div>

				<div style="float:left;display:inline" class="eg_75bold">
					<div style="padding:2px;font-weight:bold"> <egui:intnl text='monitor.layermodel.Sort By '/></div>
					<div >
						<select class="jtmDropdown" name="sortname" id="sortname"  style="width:180px" onChange="javaScript:reloadUrl('<%=measureName%>', '<%=infoName%>','<%=a_results_sessKey%>');">
<%
											int index=0;
											for(int y=0;y<header.size()-2;y++)
											{
												String tmpheader = (String)header.get(y);
												index++;
												String selected="";
												if(index==sortColumn)
													selected="selected";
												else
													selected="";
%>
												<option class="optionTxt" value="<%=index%>" <%=selected%>><egui:intnl text='<%="monitor.detaileddiagnosis."+tmpheader%>'/></option>

<%
											}
%>
						</select>
					</div>
				</div>

				<div style="float:left;display:inline" class="eg_75bold">
					<div style="padding:3px">&nbsp;</div>
					<div style="padding-left:6px">
						<!-- <img src="/final/images/filter.jpg"> -->
					</div>
				</div>
				<div style="float:left;display:inline;width:150px" class="eg_75bold">&nbsp;</div>

<%
		int tabcount=0;
		boolean highLightSummary = false;
		boolean highLightSQL = false;
		boolean highLightTrace = false;
		if(tab.equals("summary"))
			highLightSummary=true;
		else if(tab.equals("sql"))
			highLightSQL = true;
		else if(tab.equals("trace"))
			highLightTrace = true;
%>
				
			</div>
		<table style="margin:5px 2px 10px 10px;width:98.2%" class="jtm_datapanel" height="80%"> <tr><td valign="top">
        <table width="100%" cellpadding="0" cellspacing="0" border="0">
        <tr>
        	<td valign="top" style="border-width:0px "><div style="height:350px;margin:5px 0px 5px 5px;width:232px;" class="selectDiv" id="selectDiv">

					<div id='teste' name="teste" class="jtm_DatapanelBody" style="border:0px solid red;height:355px;overflow-x:scroll; width:232px; overflow: -moz-scrollbars-horizontal;overflow-y:scroll;">
						<select style="overflow:hidden;height:345px !important;border:none;width:auto;background:none !important" name="urlname" class="jtm_Select1" id="urlname" size="28" onChange="javaScript:showDetails(this.value, '<%=measureName%>' , '<%=infoName%>')" title="<%=UrlNameList.size()%>">
<%
						for(int k=0;k<UrlNameList.size();k++)
						{
							String optionValue= (String)UrlNameList.get(k);
							String displayURIName = optionValue.substring(optionValue.indexOf("@")+1);
							String selected="";
							selected = (k==0)?"selected":"";
%>
						<option style="padding:2px" value="<%=optionValue%>" <%=selected%>> <%=displayURIName%></option>
<%
						}
%>
						</select>
						<!--div style='font-size: 2px' style="border:0px solid"  div -->
					</div>
				</div></td>
            <td id="dividerTD" valign="top" style="border-width:0px "><div class="dividerBar" style="border:0px solid blue;width:6px;" >
					<div style="float:left;width:6px;height:350px;text-align:middle;border:0px solid green">
						<div id="dividerImgChange" class="dividerLeft" style="width:6px;height:50px;position:relative;top:40%;"> </div>
					</div>
                    <div style="clear:both"> </div>
				</div></td>
            <td valign="top" style="border-width:0px "><div style="padding:4px;border:0px solid blue;width: auto;">
		
					<div style="height:25px;margin-top:0px">
						<ul id="listTabMenu" style="padding:0px;margin:0px">
							<li id="glance" style="float:left" class="<%=(highLightSummary)?"current":""%>"> <a href="javascript:void(0);" onclick="javascript:showSummary('glance', '<%=measureName%>','<%=infoName%>')"><egui:intnl text='monitor.dashboard.At-A-Glance'/> </a></li>

							<li id="trace" style="float:left" class="<%=(highLightTrace)?"current":""%>"> <a href="javascript:void(0);" onclick="javascript:showTrace('trace',null,'<%=measureName%>', '<%=infoName%>')"><egui:intnl text='monitor.dashboard.Trace'/></a></li>

							<li id="sql" style="float:left" class="<%=(highLightSQL)?"current":""%>"> <a href="javascript:void(0);" onclick="javascript:showSQL('sql','<%=measureName%>', '<%=infoName%>')"><egui:intnl text='monitor.dashboard.SQL/Error'/> </a></li>
						</ul>
					</div>
				
				

			

				<div style="height:356px;overflow-x:auto;overflow-y:auto;width:auto" id='mainDataDiv' class="dataDiv linesquare">
					<form name="UrlForm" style="margin:0px;padding:0px" id="UrlForm">
						<div id="urlDetailsDiv" name="urlDetailsDiv" style="border:0px solid blue;" ></div>
					</form>
				</div>
			</div></td>
        </tr>
        </table>
       
		</td></tr></table>
		</div>
<script type='text/javascript'>
	var divid = 'teste';
		//alert("divid");
	//if (document.getElementById(divid).getElementsByTagName('div')[0] != null)
	if (document.getElementById(divid).getElementsByTagName('div')[0] != null)
	{
		//alert("2222----");
		
		/*document.getElementById(divid).getElementsByTagName('div')[0].style.width = document.getElementById(divid).getElementsByTagName('select')[0].offsetWidth+'px';
		document.getElementById(divid).getElementsByTagName('select')[0].style.width = document.getElementById(divid).offsetWidth+'px';
		document.getElementById(divid).onscroll = function scrollEvent() { 
			alert("Height-----------------"+this.getElementsByTagName('select')[0].style.height);
			this.getElementsByTagName('select')[0].style.width = parseInt(this.offsetWidth+this.scrollLeft)+'px'; 
			this.getElementsByTagName('select')[0].style.height = parseInt(this.offsetHeight+this.scrollTop)+'px'; 
		}*/
		//alert("document.getElementById(divid).style.height---"+document.getElementById(divid).style.height);
		//alert("document.getElementsById()-----"+document.getElementById("urlname").style.height);
		document.getElementById(divid).getElementsByTagName('div')[0].style.width = document.getElementById(divid).getElementsByTagName('select')[0].offsetWidth+'px';
		document.getElementById(divid).getElementsByTagName('select')[0].style.width = document.getElementById(divid).offsetWidth+'px';
		document.getElementById(divid).onscroll = function scrollEvent() { 
			//alert("Height-----------------"+this.getElementsByTagName('select')[0].style.height);
			this.getElementsByTagName('select')[0].style.width = parseInt(this.offsetWidth+this.scrollLeft)+'px'; 
			//this.getElementsByTagName('select')[0].style.height = parseInt(this.offsetHeight+this.scrollTop)+'px'; 
			document.getElementById("urlname").style.height =  parseInt(this.offsetHeight+this.scrollTop)+'px'; 
		}
	}
</script>
<%
		if(UrlNameList.size() >0 && UrlNameList != null)
		{
			String firstKey = (String)UrlNameList.get(0);
%>
					<script type="text/javascript">
						var t=setTimeout("showDetails('<%=firstKey%>','<%=measureName%>' , '<%=infoName%>')",0)
					</script>
<%
		}
	}
	else
	{
			String msg = "monitor.layermodel.No Data available";
%>
			<table height="100%" width="100%" border="0" class="data_border" style="table-layout:<%=isTable%>;border-top-width:0px" id="eg_morelight" >
				<tr>
					<td align="center" valign="middle" class="commonErrorMsgText" > 
						<img class="iconExclamation" src="/final/images/clear.png" align="center" border="0"/><br>
						<egui:intnl text="<%=msg%>"/>
					</td>
				</tr>
			</table>
<%
	}
}
catch(Exception e)
{
	System.out.println("Exception in eGJTMBase.jsp");
	e.printStackTrace();
}
%>
