<%
   /*******************************************************************************
   *	File name		: EgDiagnosis.jsp
   *	Purpose			: To display detailed measures 
   *	Version			: eG 3.0
   *	Creation Date		: 29/08/2002
   *	Last Modified		: 05/07/2004 - S.Solomon - Minutes is added in timeline selection
   *				  04-09-2003	John Williams	eG 3.0 Modifications
   *				  06-10-2003	John Williams	Fixing DD bug
   *				  21/06/2004	Arun			Uses older DD separators if new 
   *				   				DD separators are not found
   *	Authtor			: Sandhya Kollath
   ******************************************************************************/
%>

<%@ include file = "EgLoginTracker.jsp"%>
<%@ page errorPage = "EgProbsM.jsp"%>
<%@ taglib prefix = "egui" uri = "../WEB-INF/eg-taglib.tld"%>

<%@ page import = "java.sql.*"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.EgTesterInfo"%>
<%@ page import = "com.eg.EgTestInfo"%>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.egurkha.util.DateUtil" %>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.EgConstants"%>
<%@ page import = "com.egurkha.ini.*"%>
<%@ page import = "com.egurkha.monitor.alarms.*"%>

<%@ page session = "true"%>

<% response.setHeader("Cache-Control", "no-store");

   response.setHeader("Pragma", "no-cache");
   response.setDateHeader("Expires", -1); %>

<jsp:useBean id = "trans" scope = "page" class = "egurkha.TransactionBean"/>

<jsp:useBean id = "dd" scope = "page" class = "com.egurkha.monitor.EgDiagnosisBean"/>

<%!
  public String findAndReplaceString(String s, String s_search, String s_replace)
  {
	  StringBuffer sb_tmp = new StringBuffer();

	  while (s.indexOf(s_search) > -1)
	  {
		  sb_tmp.append(s.substring(0, s.indexOf(s_search)) + s_replace);
		  s = s.substring(s.indexOf(s_search) + s_search.length(), s.length());
	  }

	  if (s.length() > 0)
	  {
		  sb_tmp.append(s);
	  }

	  return sb_tmp.toString();
  }
%>

<% int tokCount = 0;
   String s_status = "";
   String s_format = "";
   String s_desc = "";
   String s_strTok = "";
   String s_site, s_host, s_port, s_test, s_info, s_msmt_host, s_mes, s_st_time, s_st_hr, s_en_time, s_en_hr,
			  s_st_min, s_end_min, s_first_time, s_from, s_flag;

   String s_detl_meas = "";
   String s_measure = "";
   String s_firstInfo = "";
   String s_secondInfo = "";
   boolean proceed = false;
   Vector v_measures = new Vector();
   ArrayList a_results = new ArrayList();
   ArrayList a_temp = new ArrayList();
   ArrayList ar_det_measures = new ArrayList();
   ArrayList al_cols = new ArrayList();
   ArrayList al_header = new ArrayList();
   ArrayList al = new ArrayList();
   StringTokenizer st = null;
   ResultSet rs = null;

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	String dispDate = null;
	String comFormat = null;
   
   
   IniUI ui     = (IniUI)com.egurkha.ini.IniUI.getInstance();

   EgTesterInfo testInfo = new EgTesterInfo("manager");
   EgTestInfo tokInfo = new EgTestInfo("manager");
   EgDbInfo dbInfo = new EgDbInfo("manager");

   String oldColSeparator = EgConstants.SEMICOLON;
   String colSeparator = testInfo.getDDSeparator1(); // default is ";"

   if (StringUtils.isNull(colSeparator))
   {
	   colSeparator = oldColSeparator;
   }

   String separateCols = null;
   String separateRows = null;

   s_site = request.getParameter("site");
   s_host = request.getParameter("host");
   s_port = request.getParameter("port");
   s_test = request.getParameter("test");
   s_info = ui.getReverseLookedupString(request.getParameter("info"));
   s_msmt_host = request.getParameter("msmt_host");
  
   s_mes = request.getParameter("measure");
   s_st_time = request.getParameter("starttime");
   s_en_time = request.getParameter("endtime");
   s_st_hr = request.getParameter("starthr");
   s_en_hr = request.getParameter("endhr");
   s_st_min = request.getParameter("startmin");
   s_end_min = request.getParameter("endmin");
   s_first_time = request.getParameter("firsttime");
   s_from = request.getParameter("from");
   s_flag = request.getParameter("flag");

   if (s_st_time == null || s_en_time == null)
   {
	   s_st_time = "";
	   s_en_time = "";
   }

   if (s_st_hr == null || s_en_hr == null)
   {
	   s_st_hr = "0";
	   s_en_hr = "0";
   }

   if (s_st_min == null || s_st_min.equals(""))
	   s_st_min = "0";

   if (s_end_min == null || s_end_min.equals(""))
	   s_end_min = "0";

   trans.createFile("eg_format.ini");
   String strValue    = trans.getStrValue("DDD_TESTS", s_test);

   String [] colNames = dbInfo.getColumnNamesForTest(s_test + "_DDD");
   String colNamesForQuery = "";

   if (!strValue.equals(""))
   {
	   if (colNames != null && colNames.length > 0)
	   {
		   for (int r = 0; r < colNames.length; r++)
		   {
			   colNamesForQuery += colNames[r] + ",";
		   }

		   if (colNamesForQuery.endsWith(","))
		   {
			   colNamesForQuery = colNamesForQuery.substring(0, (colNamesForQuery.length() - 1));
		   }
	   }
   }

   String temp    = "";
   boolean fake   = true;
   String dummyTest = "";
   String dummyMeas = "";

   String [] Desc = dd.getDescription(s_test, s_mes);
   s_format = Desc[0];
   s_desc = Desc[1];

   //	displayMode = "V";

   EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
   boolean portRelevantForTest = true;

   if (s_test != null && !s_test.equals(""))
   {
	   portRelevantForTest = specsInfo.isPortRelevantForTest(s_test);
   }

   //Populate v_measures only once
   if (s_first_time != null && !s_first_time.equals("") && s_first_time.equals("true"))
   {
	   s_first_time = "false";

	   if (s_info.length() == 1)
	   {
		   s_info = "NONE";
	   }

	   if (s_test != null && !s_test.equals(""))
	   {
		   v_measures = dd.populateMeasures(s_test);

		   if (v_measures != null)
			   session.putValue("measures", v_measures);
	   } //CLOSING IF
   }

   a_results = dd.getDiagnosisData(s_host, s_port, s_site, s_test, s_mes, s_info, s_st_time, s_en_time,
									   s_st_hr, s_en_hr, s_st_min, s_end_min, s_flag, colNamesForQuery,s_msmt_host);
   //out.println(a_results);
   s_msmt_host = dd.s_msmt_host;
  %>

<html>
	<head>
		<title>&nbsp;Detailed Diagnosis for <%= s_mes %> &nbsp; - &nbsp; eG Manager &nbsp; &nbsp; &nbsp;
		&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</title>

		<% if (s_st_time.equals(""))
		{%>

			<META HTTP-EQUIV = "refresh" CONTENT = "100;url=dispCompDiagnosis.jsp?<%= request.getQueryString() %>">
		<% }%>

		<meta name = "Author" content = "John Williams"/>

		<egui:skin ui = "monitor"/>

		<script src = "eg_scripts/eg_date.js">
		</script>

		<script language = "JavaScript1.2" src = "eg_scripts/eg_validate.js">
		</script>
			
		<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>


		<script language = "javascript1.2">
			function display()
			{
				var thisForm = document.dd;
				var measures = thisForm.measurelist;
				var s_mes = "";
				var qrstring = "";
				var flag = "";

				if (measures.options.length <= 0)
				{
					alert('<egui:intnl text="No detailed measures available"/>');
					return;
				}

				if (thisForm.starttime.value == "" && thisForm.endtime.value == "")
				{
					var s_hr = thisForm.starthr.options[thisForm.starthr.selectedIndex].value;
					var e_hr = thisForm.endhr.options[thisForm.endhr.selectedIndex].value;

					if (s_hr != '0' || e_hr != '0')
					{
						alert('<egui:intnl text="Please choose Start Date and End Date before choosing Time!"/>');
						return;
					}
					else
					{
						//No start date and end date
						flag = "0";
					}
				}
				else if (thisForm.starttime.value == "")
				{
					alert('<egui:intnl text="Please choose a Start Date!"/>');
					return;
					flag = "0";
				}
				else if (thisForm.endtime.value == "")
				{
					alert('<egui:intnl text="Please choose an End Date!"/>');
					return;
					flag = "0";
				}
				else
				{
					flag = "1";
				}

				for (var i = 0; i < measures.options.length; i++)
				{
					if (measures.options[i].selected == true)
					{
						if (s_mes.length == 0)
						{
							s_mes = measures.options[i].value;
						}
					}
				}

				var timstart = thisForm.starttime;
				var timend = thisForm.endtime;
				var startHr = thisForm.starthr.options[thisForm.starthr.selectedIndex];
				var endHr = thisForm.endhr.options[thisForm.endhr.selectedIndex];
				var startMin = thisForm.startmin.options[thisForm.startmin.selectedIndex];
				var endMin = thisForm.endmin.options[thisForm.endmin.selectedIndex];
				var ssdate = formatDate(new Date(getDateFromFormat(timstart.value,'<%=currentDateFormat%>')),"MM/dd/yyyy");
				var eedate = formatDate(new Date(getDateFromFormat(timend.value,'<%=currentDateFormat%>')),"MM/dd/yyyy");
				if (! checkTime(ssdate, eedate, startHr, endHr, startMin, endMin) && flag == "1")
				{
					alert('<egui:intnl text="Start date should be lesser than end date"/>');
					return;
				}
				else
				{
					qrstring += "site=" + thisForm.site.value;
					qrstring += "&host=" + thisForm.host.value;
					qrstring += "&port=" + thisForm.port.value;
					qrstring += "&test=" + thisForm.test.value;
					qrstring += "&info=" + thisForm.info.value;
					qrstring += "&msmt_host=" + thisForm.msmt_host.value;

					qrstring += "&starttime=" + timstart.value;
					qrstring += "&endtime=" + timend.value + "&starthr=" + startHr.value;
					qrstring += "&endhr=" + endHr.value;
					qrstring += "&startmin=" + startMin.value + "&endmin=" + endMin.value;
					qrstring += "&from=0&flag=" + flag + "&measure=" + s_mes;

					qrstring = "EgDiagnosis.jsp?" + qrstring;
					window.location.href = qrstring;
				}
			}
		</script>
	</head>

	<body leftmargin = "0" topmargin = "0" marginheight = "0" marginwidth = "0" id="inner_bg" style="overflow:auto;overflow-y:hidden">
		<table align = "center" cellspacing = "0" cellpadding = "0" width = "100%" border = "0" id="space10">
		<tr>
				<td width = "100%" valign = "bottom" align = "left">
					<table align = "left" cellspacing = "0" cellpadding = "0" width = "100%" border = "0">
						<tr>
							<td width = "50%" valign = "top" align = "center" height="100%">
								<form name = "dd" action = "EgDiagnosis.jsp">
									<table align = "center" cellspacing = "0" cellpadding = "5" width = "100%"
										   border = "0" id = "data_border" >
										<tr>
											<td id = "eg_cellbglights" nowrap>
												<b> &nbsp; <egui:intnl text="Measurement"/></b>
											</td>

											<th id = "eg_cellbglights" width = "10" align = "center" nowrap
												height = "22">
												:
											</th>

											<td id = "eg_cellbglights" nowrap class = "eg_11" colspan = "5">
												<select name = "measurelist" width = "150"
														style = "width:150px;">
													<% v_measures = (Vector)session.getValue("measures");

													for (int i = 0; i < v_measures.size(); i++)
													{
														s_measure = (String)v_measures.get(i);

														if (s_measure.equals(s_mes))
														{
															out.println("<option value='" + s_measure
																			+ "' selected >" + s_measure
																			+ "</option>");
														}
														else
														{
															out.println("<option value='" + s_measure + "' >"
																			+ s_measure + "</option>");
														}
													}%>
												</select>

												&nbsp;
											</td>
										</tr>

										<tr>
											<td id = "eg_cellbglights" nowrap>
												<b>&nbsp;<a href = "javascript: void 0"
													onClick = "checkwindow(document.dd.starttime)"
													id = "eg_darktextbold"><egui:intnl text="Start Date"/></a></b>
											</td>

											<th id = "eg_cellbglights" width = "10" align = "center" nowrap
												height = "22">
												:
											</th>
											<%
											if(s_st_time!=null && !s_st_time.equals(""))
											{
												if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
												{
													comFormat ="MM/dd/yyyy";
												}
												else
												{
													comFormat = currentDateFormat;
												}
												dispDate = DateUtil.changeDateFormat(s_st_time,comFormat,currentDateFormat);
											}
											else
											{
												dispDate = "";
											}
											%>
											<td id = "eg_cellbglights" nowrap class = "eg_11">
												<input type = "text"
													   name = "starttime"
													   onfocus = "this.blur()"
													   width = "76"
													   style = "width: 78px; text-align: center;"
													   maxlength = "12"
													   size = "12"
													   value = "<%=dispDate%>"
													   class = "eg_cellbglights">
											</td>

											<td id = "eg_cellbglights" nowrap>
												<b>&nbsp;<egui:intnl text="Hr"/>&nbsp;:&nbsp;</b>
											</td>

											<td id = "eg_cellbglights" nowrap class = "eg_11">
												<select name = "starthr" width = "10" style = "width:40px;"
														class = "eg_cellbglights">
													<% int i_tmp = Integer.parseInt(s_st_hr);

													for (int ctr = 0; ctr < 24; ctr++)
													{
														out.println("<option value='" + ctr + "'" + ((ctr
																										  == i_tmp)
																										 ? " selected "
																										 : "")
																		+ ">" + ctr + "</option>");
													}%>
												</select>
											</td>

											<td id = "eg_cellbglights" nowrap>
												<b>&nbsp;<egui:intnl text="Min"/>&nbsp;:&nbsp;</b>
											</td>

											<td id = "eg_cellbglights" nowrap class = "eg_11">
												<select name = "startmin" width = "10" style = "width:40px;"
														class = "eg_cellbglights">
													<% i_tmp = Integer.parseInt(s_st_min);

													for (int ctr = 0; ctr < 60; ctr++)
													{
														out.println("<option value='" + ctr + "'" + ((ctr
																										  == i_tmp)
																										 ? " selected "
																										 : "")
																		+ ">" + ctr + "</option>");
													}%>
												</select>
											</td>
										</tr>

										<tr>
											<td id = "eg_cellbglights" nowrap>
												<b>&nbsp;<a href = "javascript: void 0"
													onClick = "callcalendar(document.dd.endtime)"
													id = "eg_darktextbold"><egui:intnl text="End Date"/></a></b>
											</td>

											<th id = "eg_cellbglights" width = "10" align = "center" nowrap
												height = "22">
												:
											</th>
											<%
											if(s_en_time!=null && !s_en_time.equals(""))
											{
												if(DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
												{
													comFormat = "MM/dd/yyyy";
												}
												else
												{
													comFormat = currentDateFormat;
												}
											}
											else
											{
												dispDate = "";
											}
											%>
											<td id = "eg_cellbglights" nowrap class = "eg_11">
												<input type = "text"
													   name = "endtime"
													   onfocus = "this.blur()"
													   width = "76"
													   style = "width: 78px; text-align: center;"
													   maxlength = "12"
													   size = "12"
													   value = "<%=dispDate%>"
													   class = "eg_cellbglights">
											</td>

											<td id = "eg_cellbglights" nowrap>
												<b>&nbsp;<egui:intnl text="Hr"/>&nbsp;:&nbsp;</b>
											</td>

											<td id = "eg_cellbglights" nowrap class = "eg_11">
												<select name = "endhr" width = "10" style = "width:40px;"
														class = "eg_cellbglights">
													<% i_tmp = Integer.parseInt(s_en_hr);

													for (int ctr = 0; ctr < 24; ctr++)
													{
														out.println("<option value='" + ctr + "'" + ((ctr
																										  == i_tmp)
																										 ? " selected "
																										 : "")
																		+ ">" + ctr + "</option>");
													}%>
												</select>
											</td>

											<td id = "eg_cellbglights" nowrap>
												<b>&nbsp;<egui:intnl text="Min"/>&nbsp;:&nbsp;</b>
											</td>

											<td id = "eg_cellbglights" nowrap class = "eg_11">
												<select name = "endmin" width = "10" style = "width:40px;"
														class = "eg_cellbglights">
													<% i_tmp = Integer.parseInt(s_end_min);

													for (int ctr = 0; ctr < 60; ctr++)
													{
														out.println("<option value='" + ctr + "'" + ((ctr
																										  == i_tmp)
																										 ? " selected "
																										 : "")
																		+ ">" + ctr + "</option>");
													}%>
												</select>
											</td>
										</tr>

										<tr>
											<td width = "60%" align = "center" colspan = "7">
												&nbsp;<input name = "Go" onMouseDown = "display()"
													type = "button" value ='<egui:intnl text="SUBMIT"/>' id= "eg_darkbutton"
													style = "width: 65px;">
												<input type = "hidden"
													name = "site" value = "<%= s_site %>">
												<input type = "hidden" name = "host"
													value = "<%= s_host %>">
												<input type = "hidden" name = "port"
													value = "<%= s_port %>">
												<input type = "hidden" name = "test"
													value = "<%= s_test %>">
												<input type = "hidden" name = "info"
													value = "<%= s_info %>">
												<input type = "hidden" name = "msmt_host"
													value = "<%= s_msmt_host %>">
											</td>
										</tr>
									</table>
								</form>

								<% boolean show = false;

								if (a_results.size() > 0 && s_from.equals("0"))
								{
									show = true;
								}

								if (show)
								{%>
							</td>
							<td id="eg_blankspace" width="10">&nbsp;
							</td>
							<td height="100%">
								<table align = "center" cellspacing = "0" cellpadding = "3" width = "100%"
									   border = "0" id = "data_border" height="100%">
									<tr>
										<td id = "eg_cellbglights" nowrap>
											<b> &nbsp; <egui:intnl text="Components"/></b>
										</td>

										<th id = "eg_cellbglights" width = "20" align = "center" nowrap
											height = "22">
											:
										</th>

										<td id = "eg_cellbglights" class = "eg_11" width = "50%">
										<% if (!portRelevantForTest)
											{
												out.println(s_host);

												if (!s_info.equals("NONE"))
												{
													s_firstInfo = s_info.substring(0, s_info.indexOf("*"));
													s_secondInfo = s_info.substring(s_info.indexOf("*")
																						+ 1, s_info.length());

													if (s_firstInfo.equals("")) //No sid
													{
														s_info = s_secondInfo;
													}
													else //For Oracle tests
													{
														if (s_secondInfo.equals(""))
														{
															s_info = "NONE";
														}
														else
														{
															s_info = s_secondInfo;
														}
													}
												}
											}
											else
											{
												if (!s_info.equals("NONE"))
												{
													s_firstInfo = s_info.substring(0, s_info.indexOf("*"));
													s_secondInfo = s_info.substring(s_info.indexOf("*")
																						+ 1, s_info.length());

													if (s_firstInfo.equals("")) //No sid
													{
														s_info = s_secondInfo;
														out.println(s_host + ":" + s_port);
													}
													else //For Oracle tests
													{
														if (s_secondInfo.equals(""))
														{
															s_info = "NONE";
														}
														else
														{
															s_info = s_secondInfo;
														}

														out.println(s_host + ":" + s_port + ":"
																		+ s_firstInfo);
													}
												}
												else
												{
													out.println(s_host + ":" + s_port);
												}
											}%>
										</td>

										<td id = "eg_blankspace" width = "10" nowrap>
											&nbsp;
										</td>

										<td id = "eg_cellbglights" nowrap>
											<b> &nbsp; <egui:intnl text="Measurement Host"/></b>
										</td>

										<th id = "eg_cellbglights" width = "20" align = "center" nowrap
											height = "22">
											:
										</th>

										<td id = "eg_cellbglights" class = "eg_11" width = "50%">
											<%= s_msmt_host %>
										</td>
									</tr>

									<tr>
										<td id = "eg_blankspace" colspan = "7" height = "10">
											&nbsp;
										</td>
									</tr>

									<tr>
										<td id = "eg_cellbglights" nowrap>
											<b> &nbsp; <egui:intnl text="Service"/></b>
										</td>

										<th id = "eg_cellbglights" width = "20" align = "center" nowrap
											height = "22">
											:
										</th>

										<td id = "eg_cellbglights" class = "eg_11" width = "50%">
										<% if (s_site.equals("NULL"))
											{
												s_site = "NONE";
											}

											out.println(s_site); %>
										</td>

										<td id = "eg_blankspace" width = "10" nowrap>
											&nbsp;
										</td>

										<td id = "eg_cellbglights" nowrap>
											<b> &nbsp; <egui:intnl text="Test"/></b>
										</td>

										<th id = "eg_cellbglights" width = "20" align = "center" nowrap
											height = "22">
											:
										</th>

										<td id = "eg_cellbglights" class = "eg_11" width = "50%">
											<egui:intnl test="<%=s_test%>"/>
										</td>
									</tr>

									<tr>
										<td id = "eg_blankspace" colspan = "7" height = "10">
											&nbsp;
										</td>
									</tr>

									<tr>
										<td id = "eg_cellbglights" nowrap>
											<b> &nbsp; <egui:intnl text="Measure"/></b>
										</td>

										<th id = "eg_cellbglights" width = "20" align = "center" nowrap
											height = "22">
											:
										</th>

										<td id = "eg_cellbglights" class = "eg_11" width = "50%">
											<egui:intnl measure='<%=s_test+":"+request.getParameter("measure")%>'/>
										</td>

										<td id = "eg_blankspace" width = "10" nowrap>
											&nbsp;
										</td>

										<td id = "eg_cellbglights" nowrap>
											<b> &nbsp; <egui:intnl text="Description"/></b>
										</td>

										<th id = "eg_cellbglights" width = "20" align = "center" nowrap
											height = "22">
											:
										</th>

										<td id = "eg_cellbglights" class = "eg_11" width = "50%">
										<% s_info = s_info.replace('*', ' ');
											out.println(s_info); %>
										</td>
									</tr>

									<tr>
										<td id = "eg_blankspace" colspan = "7" height = "10">
											&nbsp;
										</td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
								<td colspan="3" id="eg_blankspace" height="10"></td>
						</tr>
						<tr>
							<td colspan = "3">
								<!-- Measure table -->
								<table align = "center" cellspacing = "0" cellpadding = "0" width = "100%"
									   border = "0" id = "data_border">
									<tr id = "data_headbg">
										<th nowrap height = "28" align = "left" id = "inner_subhead">
											&nbsp;<%= s_desc %>
										</th>
									</tr>

									<tr>
										<td align = "center" rowspan = "2" valign = "top" id = "eg_whitebg"
											height = "360">
											<div id="div_scroll" style="900px;height:375px">
										<% s_format = s_format.substring(s_format.indexOf(":") + 1);
											st = new StringTokenizer(s_format);
											tokCount = st.countTokens();
											
											for (int a = 0; a < a_results.size(); a = a + 2)
											{
												dispDate = (String)a_results.get(a);
												dispDate = DateUtil.changeDateFormat(dispDate,"MM/dd/yyyy h:mm:ss",currentDateFormat + " hh:mm:ss");
												%>
										
												<table cellspacing = "0" cellpadding = "0" align = "center"
													   border = "0" >
													<tr>
														<td id = "eg_blankspace" height = "6">
															&nbsp;
														</td>
													</tr>

													<tr>
														<td align = "left" id = "eg_11" height = "18">
															&nbsp;<%=dispDate%>
														</td>
													</tr>

													<tr>
														<td id = "eg_cellbgmedium">
															<div style = "overflow-x: auto; overflow-y: auto; width: 930px; padding:0px; margin: 0px" >
																<table align = "center"  cellspacing = "0"
																	   cellpadding = "3" width = "100%"
																	   border = "0" id = "data_border">
															<% a_temp = null;
																	a_temp = (ArrayList)a_results.get(a + 1);
																	//out.println(a_temp);
																	al_header = tokInfo.egTokenizer(s_format,
																										" ");
																	int cellwidth = 100 / (int)
																							  al_header.size();

																	out.println("	<tr>");

																	for (int k = 0; k < al_header.size(); k++)
																	{
																		%>
																		<td valign="top" align="left" id="table_header" width="<%=cellwidth%>%">
																		<b ><%=al_header.get(k)%></b></td>
																		<%
																	}

																	out.println("</tr>");

																	int rows  = 0;
																	int rows1 = 0;
																	String s_strTemp = "";
																	StringTokenizer str;

																	if (strValue == null
																			|| strValue.equals("")
																			|| strValue.equals("null"))
																	{
																		for (int p = 0;
																			p < a_temp.size(); p++)
																		{
																			s_strTok = (String)a_temp.get(p);

																			separateCols = colSeparator;

																			if (s_strTok.indexOf(separateCols)
																					== -1)
																			{
																				/*
																				 * Row does not contain the new Separator for columns. So use the old one
																				 */
																				separateCols
																					= oldColSeparator;
																			}

																			if (s_strTok.indexOf(separateCols)
																					> -1)
																			{
																				al_cols
																					= tokInfo.egTokenizer(s_strTok,
																										  separateCols);
																				proceed = false;

																				// Code written to avoid confusion created by seperators  - Starts ....

																				if (al_header.size()
																						!= al_cols.size())
																				{
																					for (int zz = 0; zz
																										 < al_cols.size();
																						zz++)
																					{
																						s_strTemp = (String)
																										al_cols.get(zz);
																						rows
																							= s_strTemp.lastIndexOf("(");
																						rows1
																							= s_strTemp.lastIndexOf(")");

																						if ((rows > rows1)
																								&& (zz
																										!= al_cols.size()
																											   - 1))
																						{
																							al_cols.set(zz,
																											(String)
																												al_cols.get(zz)
																												+ " " + (String)al_cols.get(zz + 1));
																							al_cols.remove(zz
																											   + 1);
																							zz = zz - 1;
																							continue;
																						}

																						al
																							= tokInfo.egTokenizer(s_strTemp,
																												  "'");

																						if (al != null)
																							rows = al.size()
																									   - 1;
																						else
																							rows = 0;

																						if (rows == 1)
																							rows = 3;

																						if (((rows % 2) != 0
																								 && rows
																										!= 0)
																								&& (zz
																										!= al_cols.size()
																											   - 1))
																						{
																							al_cols.set(zz,
																											(String)
																												al_cols.get(zz)
																												+ " " + (String)al_cols.get(zz + 1));
																							al_cols.remove(zz
																											   + 1);
																							zz = zz - 1;
																						}
																					}
																				}
																			// Code written to avoid confusion created by seperators  - ....Ends
																			}
																			else
																			{
																				proceed = true;
																			}

																			out.println("<tr>");

																			if (!proceed)
																			{
																				for (int len = 0; len
																									  < al_cols.size();
																					len++)
																				{
																					String val1 = (String)
																									  al_cols.get(len);

																					if (val1 != null
																							&& val1.trim().equals("-5.0000"))
																					{
																						val1 = "N/A";
																					}

																					//out.println(val1);
																					%>

																					<td valign="top" id="cell_border2">
																					<%=val1%></td>
																					<%
																				}
																			}
																			else
																			{%>

																				<td valign = "top"
																					id = "eg_whitebg"
																					class = "eg_11">
																<% out.println(s_strTok); %>
																				</td>

															<% }

																			out.println("</tr>");
																		}
																	}
																	else
																	{

																		//al_cols=(ArrayList)a_results.get(a+1);
																		for (int m = 0;
																			m < a_temp.size(); m++)
																		{
																			al_cols = (ArrayList)
																						  a_temp.get(m);

																			//out.println(al_cols);
																			for (int len = 0; len
																								  < al_cols.size();
																				len++)
																			{
																				String val1 = (String)
																								  al_cols.get(len);

																				if (val1 != null
																						&& val1.trim().equals("-5.0000"))
																				{
																					val1 = "N/A";
																				}

																				//out.println(val1);
																				out.println("<td valign=\"top\" id=\"eg_whitebg\" class=\"eg_11\">"
																								+ val1
																								+ "</td>");
																			}

																			out.println("<tr>");
																		}
																	}%>
																</table>
															</div>
														</td>
													</tr>
													<tr>
														<td id="eg_blankspace" height="4">&nbsp;</td>
													</tr>
												</table>

										<%
											//}

											}%>
											</div>
										</td>
									</tr>
								</table>

								<% }
								else
								{%>

									<table align = "center" width = "100%" cellspacing = "0" cellpadding = "0"
										   border = "0" id="data_border">
									<tr>
														<td width = "890"        height = "390"   nowrap
												align = "center" id = "eg_errorsmall"
												valign = "middle">
												<table cellspacing = "0" cellpadding = "2" width = "100%"
													   align = "center"  border = "0">
													<tr>
														<td align = "center">
															<img src = "eg_images/eg_layout/eg_error.gif"
																 align = "center">
														</td>
													</tr>

													<tr>
														<td align = "center" id = "eg_errorsmall">
														<% if (s_flag.equals("0"))
															{
																String displayTime = ui.getDDDisplayTime();
																double dTime = 1.0;

																try
																{
																	dTime = Double.parseDouble(displayTime);
																}
																catch (Exception e)
																{
																	dTime = 1.0;
																}

																if (testInfo.isFrequencySet())
																{
																	out.println("No detailed measures available for the last "
																					+ dTime + " hour(s)");
																}
																else
																{
																	out.println("Normal samples/Bad samples are not configured for detailed diagnosis");
																}
															}
															else
															{
																out.println("No detailed measures available for this combination of parameters");
															}%>
														</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>

								<% }%>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
		<% a_temp.clear();
		a_results.clear(); %>
	</body>
</html>
