<!DOCTYPE html>
<%
/*
	Author			:	Saravanan.A
	Creation Date	:	17-7-2015
	Purpose			:	To display Components At-A-Glance or Infrastructure health of all components
	Design Changes	:	Vijay
*/
%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %> 
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="EgLoginTracker.jsp" %>
<%@ page errorPage="EgProbsM.jsp" %>
<%@ page import="com.egurkha.ini.IniUI" %>
<%@ page import="com.egurkha.monitor.*" %>
<%@ page import="java.util.ArrayList" %>
<%@ page import="com.eg.EgStateManager" %>
<%@ page import="com.egurkha.monitor.DashboardData"%>
<%@ page import="com.egurkha.monitor.DashboardResult"%>
<%

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	DashboardData data = (DashboardData) request.getAttribute("data");
	DashboardResult result = (DashboardResult) request.getAttribute("result");
	

	session.setAttribute("dashboardData",data);
	session.setAttribute("dashboardResult",result);
	
	/* 
		For Expanded view in Components At-A-Glance page 
		by Saravanan.A on 10/May/2012
	*/
	String refreshFrom = request.getParameter("refreshFrom");
	if(refreshFrom!=null && refreshFrom.equalsIgnoreCase("serverTypes"))
	{
%>
		<jsp:forward page = "serverTypes.jsp?isShow=fullview"/>
<%
	}

	long refreshFrequency = 1L;
	String refFreq = u_ser.getRefreshFrequency();

	if(refFreq!=null && refFreq.length()>0)
	{
		refreshFrequency =  Long.valueOf(refFreq).longValue() * 1000L;
	}
%>
<html class="content-frame">
<head>
<title>DASHBOARD</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<meta http-equiv="X-UA-Compatible" content="IE=edge"> 
<egui:skin ui="monitor"/>
<egui:loadApp baseDir="/final/monitor/eg_scripts" appName="InfrastructureHealth" appFile="app.js"/>

<link rel="stylesheet" href="/final/styles/jscrollpane/jquery.jscrollpane.css"/>

<script src="/final/scripts/jquery-1.8.2.min.js"></script>
<script src="/final/styles/jscrollpane/jquery.jscrollpane.js" ></script>
<script src="/final/styles/jscrollpane/jquery.mousewheel.js" ></script>
<script src="/final/styles/jscrollpane/mwheelIntent.js" ></script>

<script src="../scripts/utilities/CustomGrid.js"></script>
<script src="../scripts/utilities/ErrorPanel.js"></script>
<script src="../scripts/utilities/ScrollPanel.js"></script>
<script src="/final/FusionCharts/scripts/FusionCharts.js"></script>

<script language="javascript">
function parseScript(_source)
{
	var source = _source;
	var scripts = new Array();
	
	// Strip out tags
	while(source.indexOf("<script") > -1 || source.indexOf("</script") > -1) {

		var s = source.indexOf("<script");
		var s_e = source.indexOf(">", s);
		var e = source.indexOf("</script", s);
		var e_e = source.indexOf(">", e);			
		// Add to scripts array
		scripts.push(source.substring(s_e+1, e));
		// Strip from source
		source = source.substring(0, s) + source.substring(e_e+1);
	}
	// Loop through every script collected and eval it
	for(var i=0; i<scripts.length; i++) {
		try {
			eval(scripts[i]);
		}
		catch(ex) {
			return;
		}
	}
	// Return the cleaned source
	return source;
}
Ext.onReady(function(){
	 Ext.Ajax.on('requestexception', function (conn, response, options) {
		var errorStr = response.responseText;
		parseScript(errorStr);
		if (!Ext.isEmpty(errorStr) && errorStr.indexOf("customerror") != -1)
		{
			if (errorStr.indexOf("user-session-invalid") != -1)
			{
				callWindow(1);
			}
			else if (errorStr.indexOf("user-deleted") != -1)
			{
				callWindow(2);
			}
			else if (errorStr.indexOf("user-timedout") != -1)
			{
				callWindow(3);
			}
		}
	});
	initLdgMask = new Ext.LoadMask(Ext.getBody(),{msg : "Loading ..."});
});
function loadURL(myURL)
{
	window.location.href=myURL;
}

var monitorRefreshFrequency=<%=refreshFrequency%>;
var lastProbsDuration = '';
var lasInfrastructureMenuSelection = '';
var linkMoreEvents = '<egui:intnl text="monitor.home.Click here for more events"/>';
var dheight = 250;
var gheight = dheight - 1;
var dwidth=screen.width;

window.parent.document.onclick = function(e){
    e = e || window.parent.event || window.event;
    var t = e.target || e.srcElement;
    if(t.nodeName=='A'){
		var hidLastClickedURLObj=document.getElementById("lastClickedURL");
		if(hidLastClickedURLObj!=null && hidLastClickedURLObj!=undefined)
		{
			hidLastClickedURLObj.value=t.href;
		}
	}
}
</script>
</head>
<body leftmargin="0" topmargin="0" marginheight="0" marginwidth="0" style="overflow:hidden" class="content-frame">

<!-- <div id="loadmask" class="x-mask-msg x-layer x-mask-msg-default" style="z-index: 19001;left:45%;top:35%;"></div> -->

<div id="loadmask" class="x-mask-msg x-layer x-mask-msg-default" style="z-index: 19001;left:45%;top:35%;">
	<div class="x-mask-loading" style="position:relative">
		Loading...
	</div>
</div>

<input type="hidden" name="lastClickedURL" id="lastClickedURL" value=""/>
<%
	session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgMonitorController?monCmd=dashboard&healthView=yes");
%>
</body>
</html>
