<%@ include file="EgMonitorTracker.jsp" %>
<%@ page import="com.eg.*"%>
<%@ page import="com.egurkha.util.*"%>
<%@ page import="com.egurkha.monitor.*"%>
<%@ page import="java.text.*"%>
<%@ page import="java.util.*"%>
<%@ page import="net.sf.json.*"%>
<%@ page import="com.egurkha.util.*"%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
	response.setContentType("application/json");
	request.setCharacterEncoding("UTF-8");
%>
	<jsp:useBean id="teststatus" class="egurkha.TestStatusInfo"/>
<%
	EgTablesInfo tablesInfo = new EgTablesInfo("manager");
	EgMappingInfo mapObj= EgMappingInfo.getEgMappingInfo();
	EgCompositeInfo compInfo = new EgCompositeInfo("manager");
	User user = UserRegistry.getInstance().getUser(session.getId());
	EgTimeZoneConverter converterStart=null;
	EgTimeZoneConverter converterEnd = null;

	String siteName = request.getParameter("site");
	String compType = request.getParameter("type");
	String hostName = request.getParameter("host");
	if(hostName != null) {
		hostName = EgURLDecoder.decode(hostName,"UTF-8");
	}
	String portNo = request.getParameter("port");
	String testName = request.getParameter("test");
	String msmtTime = request.getParameter("msmttime");
	String layerName = request.getParameter("layer");
	String measureName = request.getParameter("measure");
	String sid = request.getParameter("sid");

	String thisserver = compType + ":" + hostName+":"+portNo;
	if(compType.equals("Oracle_server"))
	{
		thisserver += ":"+sid;
	}

	String measureUnit = "%";
	String info = request.getParameter("info");
	if(info != null) {
		info = info.trim();
		if(info.length()>0 && !info.equalsIgnoreCase("null")) {
			info = "+"+EgURLDecoder.decode(info,"UTF-8");
		}
	}
	if(info == null || info.length()==0 || info.equalsIgnoreCase("null")) {
		info="+";
	}

//	boolean isSIDBasedInfo = false;
	ArrayList al = tablesInfo.getLayersForComponent("Host_system");
//	String layers_str = tablesInfo.getLayerForTest(testName);
//	if(layers_str != null)
//	{
//		String Layer_name[] = StringUtils.getTokens(layers_str,",");
//		boolean isHostSystem=false;
//		if (al == null) al = new ArrayList();
//		for(int k=0; k<Layer_name.length ; k++)
//		{
//			if(al.contains(Layer_name[k]))
//			{
//				isHostSystem=true;
//			}
//		}
//		if(compType.equals("Oracle_server") && !isHostSystem && !info.equals("+"))
//		{
//			//info = sid+info;
//			isSIDBasedInfo=true;
//		}
//	}

	boolean infobasedCompositeTest = compInfo.isDescriptorBasedTest(testName);
	String masterInfosTest = compInfo.getMasterInfosTest(testName);
	if(masterInfosTest != null && masterInfosTest.equals("-1"))
	{
		masterInfosTest=null;
	}
	if(infobasedCompositeTest && masterInfosTest==null)
	{
		infobasedCompositeTest=false;
	}
	//if(infobasedCompositeTest && info.equals("+"))
	if(infobasedCompositeTest && (info.equals("+") || (sid != null && info.equals(sid+"+"))))
	{
		infobasedCompositeTest=false;
	}
	boolean infobasedCompTest = info.length()>1;
//	ArrayList excludeDescOfTestconfigpage = new ArrayList();
//	String testConfigExInfo = compInfo.getParameterValue(testName, compType+":"+hostName+":NULL", "excludeDescriptor");
//	if(testConfigExInfo !=null && (testConfigExInfo=testConfigExInfo.trim()).length()>0 && !testConfigExInfo.equalsIgnoreCase("null") && !testConfigExInfo.equalsIgnoreCase("none"))
//	{
//		//these descriptors have been configured through test configuration page
//		String descriptors[] = StringUtils.getTokens(testConfigExInfo,",");
//		for(int i=0;i<descriptors.length;i++) {
//			String descriptor = descriptors[i];
//			if(descriptor.startsWith("+")) {
//				excludeDescOfTestconfigpage.add(descriptor);
//			}
//			else {
//				excludeDescOfTestconfigpage.add("+"+descriptor);
//			}
//		}
//	}
	IniFile agentsIniSync = new IniFile(EgConfigInfo.egMgrConfigDir + "eg_agents.ini");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgExternalInfo externalInfo = new EgExternalInfo("manager");
	String min_max_values = null;
	boolean min_max_values_found=false;
	String testKey = specsInfo.findTest(testName, compType);
	testKey = StringUtils.replace(testKey, "$hostName", hostName);
	testKey = StringUtils.replace(testKey, "$portNo", portNo);
	if(sid != null)
	{
		testKey = StringUtils.replace(testKey, "$sid", sid);
	}
	List agentNames = externalInfo.getAgentsFor(testName, compType, hostName);
	for(int idx=0;idx<agentNames.size();idx++)
	{
		if(min_max_values_found)
			break;
		String testParams = null;
		String agentName = (String) agentNames.get(idx);
		String variables[] = agentsIniSync.getVariables(agentName);
		for(int k=0; k<variables.length; k++)
		{
			String tempKey = variables[k];
			if(tempKey.equals(testKey))
			{
				testParams = agentsIniSync.getValue(agentName, tempKey);
				String paramValues[] = StringUtils.getTokens(testParams," ");
				for(int i=0;i<paramValues.length;i++)
				{
					if(paramValues[i].equals("-min_max_values"))
					{
						min_max_values = paramValues[i+1].trim();
						if(!min_max_values.equalsIgnoreCase("none"))
						{
							min_max_values_found=true;
						}
						break;
					}
				}
			}
			if(min_max_values_found)
				break;
		}
	}
	ArrayList canRemoveTest = new ArrayList();
	Hashtable testInfoHt = null;
	String thisKey = hostName+":NULL";
	if(portNo != null && !portNo.equalsIgnoreCase("NULL"))
	{
		thisKey=hostName+":"+portNo;
	}
	List testConfigIncludeExcludeInfo = compInfo.getComponentsInfo(testName, thisKey);

	if(testConfigIncludeExcludeInfo != null && !testConfigIncludeExcludeInfo.isEmpty())
	{
		testInfoHt = new Hashtable();
		Iterator itr = testConfigIncludeExcludeInfo.iterator();
		while(itr.hasNext())
		{
			String s = (String)itr.next();
			String atest = s.substring(0,s.indexOf(":"));
			String ainfo = null;
			if(sid==null || sid.trim().length()==0 || sid.trim().equalsIgnoreCase("null"))
			{
				ainfo = s.substring(s.lastIndexOf(":")+1);
			}
			else
			{
				String s_idkey = ":"+sid+"+";
				if(s.indexOf(s_idkey)>-1)
				{
					ainfo = s.substring(s.lastIndexOf(s_idkey)+1);
				}
			}
			if(ainfo.equals("+") && !canRemoveTest.contains(atest))
			{
				canRemoveTest.add(atest);
			}
			if(testInfoHt.containsKey(atest))
			{
				ArrayList alist = (ArrayList)testInfoHt.get(atest);
				alist.add(ainfo);
			}
			else
			{
				ArrayList alist = new ArrayList();
				alist.add(ainfo);
				testInfoHt.put(atest,alist);
			}
		}
	}
	String compTestFrequency = teststatus.frequencyOfTest(compType,hostName + ":" + portNo,testName);
	IniFile UIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini", false);
	String currentDateFormat = UIni.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	String usermsmtTime = "";
	String s_from="";
	String s_to="";
	long measure_factor = 1;
	long retainMsmtTime = 0;
	SimpleDateFormat targetFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
	try {
		if(msmtTime!=null && msmtTime.length()>0) {
			msmtTime = StringUtils.replace(msmtTime,"*"," ");
			SimpleDateFormat format= new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
			Date sourceDate = format.parse(msmtTime);
			long last_msmt_time = sourceDate.getTime();
			retainMsmtTime = last_msmt_time;
			//long measure_factor = 1;
			long measure_period = Long.parseLong(compTestFrequency)* 1000;
			long x = Math.round(0.1 * measure_period);
			long from1 = last_msmt_time - (measure_factor * measure_period);

			//SimpleDateFormat targetFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
			//s_from = targetFormat.format(new Date(from1 - x));
			//s_to = targetFormat.format(new Date(last_msmt_time));
			msmtTime = DateUtil.changeDateFormat(msmtTime,"MM/dd/yyyy HH:mm:ss",currentDateFormat + " HH:mm:ss");
			converterStart = new EgTimeZoneConverter(msmtTime,user);
			usermsmtTime = converterStart.getDateTime();
		}
		else {
			msmtTime ="Not Available";
			usermsmtTime = "Not Available";
		}
	}
	catch(Exception eee) {
		//...... msmt time cann't be parsed
	}
	String dispCompType = mapObj.getComponentTypeDescription(compType);
	String dispTestName = mapObj.getTestDescription(testName);
	String dispCompMeasure = mapObj.getMeasureDescription(testName,measureName);

	StringBuffer compositeTable = new StringBuffer();
	JSONObject json = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	JSONObject error = new JSONObject();

	screenLabels.put("measurementTime",mapObj.getTextDescription("monitor.aggregates.Measurement Time"));
	screenLabels.put("componentType",mapObj.getTextDescription("monitor.aggregates.Component Type"));
	screenLabels.put("componentName",mapObj.getTextDescription("monitor.aggregates.Component Name"));
	screenLabels.put("test",mapObj.getTextDescription("monitor.aggregates.Test Name"));
	screenLabels.put("measure",mapObj.getTextDescription("monitor.aggregates.Measure Name"));

	screenLabels.put("descriptor",mapObj.getTextDescription("monitor.aggregates.Descriptor"));
	screenLabels.put("measurevalue",mapObj.getTextDescription("monitor.aggregates.Measure Value"));

	json.put("measurementTime",usermsmtTime);
	json.put("componentType",dispCompType);
	json.put("componentName",hostName);
	json.put("test",dispTestName);
	json.put("measure",(dispCompMeasure+" ("+measureUnit+")"));
	json.put("descriptor",info.equals("+")?"-":info.substring(1));
	json.put("measurevalue",request.getParameter("measure_value"));

	String weightageType = compInfo.getWeightageType(testName);
	if(weightageType.equalsIgnoreCase("SystemDefined")) {
		json.put("weightageType",mapObj.getTextDescription("monitor.common.System Defined"));
	}
	else {
		json.put("weightageType",mapObj.getTextDescription("monitor.common.Custom Defined"));
	}
	json.put("rawWeightageType",weightageType);
	boolean rangeTableNotAdded = true;
	boolean keyMinorCheckNeeded=false;
	boolean keyMajorCheckNeeded=false;
	boolean supportMinorCheckNeeded=false;
	boolean supportMajorCheckNeeded=false;
	Hashtable weightageInfo = compInfo.getWeightageInfo(testName);
	if(weightageInfo != null && weightageInfo.containsKey("keyNormal") && weightageInfo.containsKey("supportNormal"))
	{
		String keyNormalStr = (String)weightageInfo.get("keyNormal");
		String keyMinorStr = (String)weightageInfo.get("keyMinor");
		String keyMajorStr = (String)weightageInfo.get("keyMajor");
		String keyCriticalStr = (String)weightageInfo.get("keyCritical");
		String supportNormalStr = (String)weightageInfo.get("supportNormal");
		String supportMinorStr = (String)weightageInfo.get("supportMinor");
		String supportMajorStr = (String)weightageInfo.get("supportMajor");
		String supportCriticalStr = (String)weightageInfo.get("supportCritical");

		json.put("keyNormal",keyNormalStr);
		json.put("keyMinor",keyMinorStr);
		json.put("keyMajor",keyMajorStr);
		json.put("keyCritical",keyCriticalStr);
		json.put("supportNormal",supportNormalStr);
		json.put("supportMinor",supportMinorStr);
		json.put("supportMajor",supportMajorStr);
		json.put("supportCritical",supportCriticalStr);

		if(keyMinorStr != null && !keyMinorStr.trim().equalsIgnoreCase("none"))
			keyMinorCheckNeeded=true;
		if(keyMajorStr != null && !keyMajorStr.trim().equalsIgnoreCase("none"))
			keyMajorCheckNeeded=true;
		if(supportMinorStr != null && !supportMinorStr.trim().equalsIgnoreCase("none"))
			supportMinorCheckNeeded=true;
		if(supportMajorStr != null && !supportMajorStr.trim().equalsIgnoreCase("none"))
			supportMajorCheckNeeded=true;
	}
	Hashtable thresholdsForEverySingleMeasure=null;
	Hashtable thresholdsForCompMeasures = compInfo.getThresholdsForMeasures(testName);
	if(min_max_values_found)
	{
		String arrayOut[] = StringUtils.getTokens(min_max_values,"~~");
		for(int i=0;i<arrayOut.length;i++)
		{
			String str1 = arrayOut[i].trim();
			String array[] = StringUtils.getTokens(str1,"~");
			if(array != null && array.length==5)
			{
				String prm = array[0].trim();
				String t = array[1].trim();
				String m = array[2].trim();
				String min = array[3].trim();
				String max = array[4].trim();
				if(thresholdsForCompMeasures.containsKey(prm))
				{
					Hashtable ht1 = (Hashtable)thresholdsForCompMeasures.get(prm);
					ht1.put((t+":"+m),min+":"+max);
				}
			}
		}
	}
	if(thresholdsForCompMeasures != null && thresholdsForCompMeasures.containsKey(measureName)) {
		thresholdsForEverySingleMeasure = (Hashtable)thresholdsForCompMeasures.get(measureName);
	}
	if(info.equals("+")) {
		json.put("infoLine1",mapObj.getTextDescription("monitor.aggregates.The performance rating test measure")+" <b>"+dispCompMeasure+"</b> "+mapObj.getTextDescription("monitor.aggregates.was computed to be")+" <b>"+request.getParameter("measure_value")+".");

		json.put("infoLine2",mapObj.getTextDescription("monitor.aggregates.This value has been derived from the following individual metrics")+".");
	}
	else {
		String shownInfo = info;
		json.put("infoLine1",mapObj.getTextDescription("monitor.aggregates.The performance rating test measure")+" <b>"+dispCompMeasure+"</b> "+mapObj.getTextDescription("monitor.aggregates.was computed for the descriptor")+" <b>"+shownInfo.substring(1)+"</b> "+mapObj.getTextDescription("monitor.aggregates.to be")+" <b>"+request.getParameter("measure_value"));

		json.put("infoLine2",mapObj.getTextDescription("monitor.aggregates.This value has been derived from the following individual metrics"));
	}
	JSONArray keyMeasuresArray = new JSONArray();
	JSONArray testDisplayNames = new JSONArray();
	JSONArray rowDataArrayGlobal = new JSONArray(); // this is for array or table rows for every table
	JSONArray columnDataArrayGlobal = new JSONArray();// this is for array of array

	Hashtable tmdc = new Hashtable();
	if(msmtTime!=null && msmtTime.length()>0) {
		String keyMeasureLabel = mapObj.getTextDescription("monitor.aggregates.Key measure");
		//EgCompositeInfo compInfo = new EgCompositeInfo("manager");
		EgDbInfo dbInfo = new EgDbInfo("manager");
		Hashtable MEASUREMENT_DB_MAPPING = new Hashtable();
		Vector associatedTestMeasures = compInfo.getAssociatedTestMeasures(testName);
		for(int i=0;i<associatedTestMeasures.size();i++) {
			String tm = (String)associatedTestMeasures.get(i);
			int index = tm.indexOf(":");
			if(index>-1) {
				String tname = tm.substring(0,index);
				String mname = tm.substring(index+1);
				String COLUMN = dbInfo.getColumnForMeasure (tname,mname,false);
				if(COLUMN != null && (COLUMN=COLUMN.trim()).length()>0) {
					MEASUREMENT_DB_MAPPING.put(tm,COLUMN);
					if(tmdc.containsKey(tname)) {
						Hashtable temp = (Hashtable)tmdc.get(tname);
						temp.put(COLUMN,tm);
					}
					else {
						Hashtable temp = new Hashtable();
						temp.put(COLUMN,tm);
						tmdc.put(tname,temp);
					}
				}
			}
		}
		if(!MEASUREMENT_DB_MAPPING.isEmpty()) {
			Hashtable includeInfosPerMeasure = compInfo.getIncludeInfosPerMeasure(testName);
			Hashtable excludeInfosPerMeasure = compInfo.getExcludeInfosPerMeasure(testName);
			String compTestMeasure = testName+":"+measureName;
			Hashtable includeInfosPerTest = null;
			if(includeInfosPerMeasure != null && includeInfosPerMeasure.containsKey(compTestMeasure)) {
				includeInfosPerTest = (Hashtable)includeInfosPerMeasure.get(compTestMeasure);
			}
			Hashtable excludeInfosPerTest = null;
			if(excludeInfosPerMeasure != null && excludeInfosPerMeasure.containsKey(compTestMeasure)) {
				excludeInfosPerTest = (Hashtable)excludeInfosPerMeasure.get(compTestMeasure);
			}
			Vector testMeasures1 = compInfo.getTestMeasuresOfUxMeasure(testName,measureName);
			EgThresholdInfo threshConfig = new EgThresholdInfo("manager");
			ArrayList added = new ArrayList();
			Vector testMeasures = new Vector();
			for(int j=0;j<testMeasures1.size();j++) {
				String testMeasure = (String)testMeasures1.get(j);
				String s_atest = testMeasure.substring(0,testMeasure.indexOf(":"));
				if(!added.contains(s_atest))
				{
					added.add(s_atest);
					String measures[] = threshConfig.getMeasurementsForTest(s_atest);
					for(int v2=0;v2<measures.length;v2++) {
						String t_m = s_atest+":"+measures[v2];
						if(testMeasures1.contains(t_m))
						{
							testMeasures.add(t_m);
						}
					}
				}
			}
			Hashtable DB_COLUMNS_PER_TEST = new Hashtable();
			for(int j=0;j<testMeasures.size();j++) {
				String testMeasure = (String)testMeasures.get(j);
				if(MEASUREMENT_DB_MAPPING.containsKey(testMeasure)) {
					String DB_COLUMN = (String)MEASUREMENT_DB_MAPPING.get(testMeasure);
					String associatedTestName = testMeasure.substring(0,testMeasure.indexOf(":"));
					if(DB_COLUMNS_PER_TEST.containsKey(associatedTestName)) {
						ArrayList DB_COLUMNS = (ArrayList)DB_COLUMNS_PER_TEST.get(associatedTestName);
						DB_COLUMNS.add(DB_COLUMN);
					}
					else {
						ArrayList DB_COLUMNS = new ArrayList();
						DB_COLUMNS.add(DB_COLUMN);
						DB_COLUMNS_PER_TEST.put(associatedTestName,DB_COLUMNS);
					}
				}
			}

			String compositeKey = testName+":"+measureName;
			ArrayList keyMeasuresHt = null;
			Hashtable testKeySupportMap = compInfo.getAllTestMeasuresOfUxMeasures(testName,true);
			if(testKeySupportMap != null && testKeySupportMap.containsKey(compositeKey)) {
				Hashtable keySupportPerCm = (Hashtable)testKeySupportMap.get(compositeKey);
				if(keySupportPerCm != null) {
					if(keySupportPerCm.containsKey("KeyMeasuresHt")) {
						keyMeasuresHt = (ArrayList)keySupportPerCm.get("KeyMeasuresHt");
					}
				}
			}

			ArrayList tlist = new ArrayList();
			Iterator titr = DB_COLUMNS_PER_TEST.keySet().iterator();
			while(titr.hasNext()) {
				tlist.add(titr.next());
			}

			Hashtable testPeriod = getTestPeriods(thisserver, tlist, specsInfo, externalInfo);
			Collections.sort(tlist,String.CASE_INSENSITIVE_ORDER);
			if(infobasedCompositeTest && tlist.size()>0 && tlist.contains(masterInfosTest))
			{
				tlist.remove(masterInfosTest);
				tlist.add(0,masterInfosTest);
			}
			if(!canRemoveTest.isEmpty())
			{
				tlist.removeAll(canRemoveTest);//these tests are removed from test config page
			}
			ArrayList masterTestInfos = null;
			Iterator itr2 = tlist.iterator();
			while(itr2.hasNext()) {
				String associatedTestName = (String)itr2.next();
				boolean addSidToInfo = false;
				if(compType.equals("Oracle_server"))
				{
					String associatedTestLayer = tablesInfo.getLayerForTest(associatedTestName);
					if(associatedTestLayer != null)
					{
						boolean isHostSystemTest = false;
						String Layer_name[] = StringUtils.getTokens(associatedTestLayer,",");
						for(int k=0; k<Layer_name.length ; k++)
						{
							if(al.contains(Layer_name[k]))
							{
								isHostSystemTest=true;
								break;
							}
						}
						if(!isHostSystemTest)
						{
							addSidToInfo=true;
						}
					}
				}

				ArrayList lst = (ArrayList)DB_COLUMNS_PER_TEST.get(associatedTestName);
				ArrayList unique = new ArrayList();
				String s_measures = "";
				for(int j=0;j<lst.size();j++) {
					String measure = (String) lst.get(j);
					if(!unique.contains(measure)) {
						s_measures += measure+",";
						unique.add(measure);
					}
				}
				unique.clear();
				if(s_measures.indexOf(",") > -1) {
					s_measures = s_measures.substring(0,(s_measures.length()-1));
				}
				ArrayList forbiddenList = new ArrayList();
//				if(excludeDescOfTestconfigpage != null && !excludeDescOfTestconfigpage.isEmpty())
//				{
//					forbiddenList.addAll(excludeDescOfTestconfigpage);
//				}
				if(testInfoHt != null && testInfoHt.containsKey(associatedTestName))
				{
					ArrayList infoList = (ArrayList)testInfoHt.get(associatedTestName);
					forbiddenList.addAll(infoList);
				}
				long measure_period = 600000;// this is also used in EgCompositeTest.java of agent
				if(testPeriod.containsKey(associatedTestName))
				{
					measure_period = ((Long)testPeriod.get(associatedTestName)).longValue();
				}
				long x_test = Math.round(0.1 * measure_period);
				long from_test = retainMsmtTime - (measure_factor * measure_period);
				s_from = targetFormat.format(new Date(from_test - x_test));
				s_to = targetFormat.format(new Date(retainMsmtTime));

				StringBuffer sb = new StringBuffer();
				sb.append("select info,msmt_time,");
				sb.append(s_measures);
				sb.append(" from ");
				sb.append(associatedTestName);

				if(EgDbInfo.checkDBType().equals("EgMsSqlAdapter")) {
					sb.append(" where msmt_time between CONVERT (datetime, '");
					sb.append(s_from);
					sb.append("', 103) and CONVERT (datetime, '");
					sb.append(s_to);
					sb.append("', 103) and trgt_host in (");
				}
				else {
					sb.append(" where MSMT_TIME BETWEEN TO_DATE('");
					sb.append(s_from);
					sb.append("','DD/MM/YYYY HH24:MI:SS') AND TO_DATE('");
					sb.append(s_to);
					sb.append("','DD/MM/YYYY HH24:MI:SS') and trgt_host in (");
				}
				sb.append("'");
				sb.append(hostName);
				sb.append("'");
				sb.append(")");
//				if(infobasedCompTest && associatedTestName.equals(masterInfosTest))
//				{
//					if(sid == null || sid.length()==0 || sid.equalsIgnoreCase("null"))
//					{
//						sb.append(" and info ='");
//						sb.append(info);
//						sb.append("'");
//					}
//					else
//					{
//						sb.append(" and info in('");
//						sb.append(info);
//						sb.append("','");
//						sb.append(sid+""+info);
//						sb.append("')");
//					}
//				}
//				else
//				{
					int size = 0;
					if(forbiddenList != null) {
						if((size = forbiddenList.size())>0) {
							--size;
							sb.append(" and info not in('");
							while(size>=0) {
								sb.append(forbiddenList.get(size).toString()+"'");
								--size;
								if(size>=0) {
									sb.append(",'");
								}
								else {
									sb.append(") ");
									break;
								}
							}
						}
					}
				//}
				sb.append(" order by msmt_time,info");
				MonitorDAOFactory monitorDaoFactory = MonitorDAOFactory.getInstance();
				AggregateDAO aggDAO = monitorDaoFactory.getAggregateDAO();
				ArrayList resultList = aggDAO.getQueryResult(sb.toString());
				boolean dataDisplayed = false;
				if(resultList != null) {
					int index=0;
					if(resultList.indexOf("#####")>0) {
						index = resultList.indexOf("#####")+1;
					}
					if(index == resultList.size()) {
						continue;
					}
					else
					{
						ArrayList allowedTestInfos = null;
						if(infobasedCompositeTest)
						{
							boolean sidBasedMasterInfoTest = false;
							if(associatedTestName.equals(masterInfosTest))
							{
								for(int jk=index;jk<resultList.size();jk++)
								{
									String tmp = (String)resultList.get(jk);
									if(!tmp.startsWith("+") && ((sid == null || sid != null && !tmp.startsWith(sid+"+"))))
										continue;
									String tmp_info = tmp.substring(0,tmp.indexOf("~"));
									if(!tmp_info.equals("+"))
									{
										tmp_info = tmp_info.substring(tmp_info.indexOf("+"));
									}
									if(tmp_info.equals("+"))
										continue;
									if(masterTestInfos==null)
										masterTestInfos = new ArrayList();
									if(!masterTestInfos.contains(tmp_info))
										masterTestInfos.add(tmp_info);
								}
								allowedTestInfos = new ArrayList();
								allowedTestInfos.add(info);
							}
							else if(masterTestInfos != null)
							{
								boolean anyMasterTestInfoFound = false;
								ArrayList thisTestInfos = null;
								for(int jk=index;jk<resultList.size();jk++)
								{
									String tmp = (String)resultList.get(jk);
									if(tmp.indexOf("+")==-1)
										continue;
									String tmp_info = tmp.substring(0,tmp.indexOf("~"));
									if(!tmp_info.equals("+"))
									{
										tmp_info = tmp_info.substring(tmp_info.indexOf("+"));
									}
									if(tmp_info.equals("+"))
										continue;
									if(thisTestInfos==null)
										thisTestInfos = new ArrayList();
									if(!thisTestInfos.contains(tmp_info))
										thisTestInfos.add(tmp_info);
									if(!anyMasterTestInfoFound && masterTestInfos.contains(tmp_info))
										anyMasterTestInfoFound=true;
								}
								if(thisTestInfos != null)
								{
									if(anyMasterTestInfoFound)
									{
										allowedTestInfos = new ArrayList();
										allowedTestInfos.add(info);
									}
								}
							}
						}
						JSONArray kma = new JSONArray();
						JSONArray columnArray = new JSONArray();
						JSONObject rowData = new JSONObject();
						JSONArray rowDataArray = new JSONArray();

						if(rangeTableNotAdded)
						{
							JSONArray kmarange = new JSONArray();
							JSONArray columnArrayrange = new JSONArray();
							JSONObject rowDatarange = new JSONObject();
							JSONArray rowDataArrayrange = new JSONArray();

							columnArrayrange.add("TEST");
							columnArrayrange.add("MEASURE");
							columnArrayrange.add("MINIMUM VALUES");
							columnArrayrange.add("MAXIMUM VALUES");

							if(thresholdsForEverySingleMeasure != null && !thresholdsForEverySingleMeasure.isEmpty())
							{
								ArrayList alist = new ArrayList();
								Iterator itr = thresholdsForEverySingleMeasure.keySet().iterator();
								while(itr.hasNext()) {
									String tm = (String)itr.next();
									alist.add(tm);
								}
								ArrayList mylist = new ArrayList();
								ArrayList mytlist = new ArrayList();
//								if(infobasedCompTest)
//								{
//									mytlist.add(associatedTestName);
//								}
//								else
//								{
									mytlist.addAll(tlist);
//								}
								if(!canRemoveTest.isEmpty()) {
									mytlist.removeAll(canRemoveTest);
								}
								for(int vi=0;vi<mytlist.size();vi++) {
									String vtest = (String)mytlist.get(vi);
									String measures[] = threshConfig.getMeasurementsForTest(vtest);
									for(int vi2=0;vi2<measures.length;vi2++) {
										String jamesStr = vtest+":"+measures[vi2];
										if(alist.contains(jamesStr)) {
											mylist.add(jamesStr);
										}
									}
								}
								//String previousTest = null;
								for(int vi=0;vi<mylist.size();vi++) {
									String tm = (String)mylist.get(vi);
									int colonIndex = tm.indexOf(":");
									String t = tm.substring(0,colonIndex);
									String m = tm.substring(colonIndex+1);
									String ranges = (String)thresholdsForEverySingleMeasure.get(tm);
									int pipeIndex = ranges.indexOf(":");
									String minRange = ranges.substring(0,pipeIndex);
									String maxRange = ranges.substring(pipeIndex+1);
									if(minRange.equals("-1")) {
										minRange="None";
									}
									if(maxRange.equals("-1")) {
										maxRange="None";
									}
									//if(previousTest==null || !previousTest.equalsIgnoreCase(t)) {
										rowDatarange.put("TEST",mapObj.getTestDescription(t));
									//	previousTest = t;
									//}
									//else {
									//	rowDatarange.put("TEST","");
									//}
									rowDatarange.put("MEASURE",mapObj.getMeasureDescription(t,m)+"  ("+tablesInfo.getUnitForMeasure(t,m)+")");
									rowDatarange.put("MINIMUM VALUES",minRange);
									rowDatarange.put("MAXIMUM VALUES",maxRange);
									rowDataArrayrange.add(rowDatarange);
								}
							}
							testDisplayNames.add("ASSOCIATED TESTS AND MEASURES");
							rowDataArrayGlobal.add(rowDataArrayrange);
							columnDataArrayGlobal.add(columnArrayrange);
							keyMeasuresArray.add(kmarange);
							rangeTableNotAdded=false;
						}

						String fortesting = (String)resultList.get(index);
						boolean infobasedTest = true;
						String testinginfo = fortesting.substring(0,fortesting.indexOf("~"));
						if(testinginfo.equals("+")) {
							infobasedTest = false;
						}
						//below line is for associated test table header
						ArrayList key_measures = new ArrayList();
						if(keyMeasuresHt != null) {
							String tempStr = "";
							Hashtable mlistht = (Hashtable)keyMeasuresHt.get(0);
							if(mlistht != null && mlistht.containsKey(associatedTestName)) {
								ArrayList mlist = (ArrayList)mlistht.get(associatedTestName);
								for(int i=0;i<mlist.size();i++) {
									String cm = (String)mlist.get(i);
									key_measures.add(cm);
								}
							}
						}
						//descriptor handling starts here
						ArrayList include_infos_for_this_test = null;
						ArrayList include_infos_pattern_for_this_test = null;
						ArrayList include_infos_endsWith_for_this_test = null;
						if(includeInfosPerTest != null && includeInfosPerTest.containsKey(associatedTestName)) {
							include_infos_for_this_test = (ArrayList)includeInfosPerTest.get(associatedTestName);
							for(int x=0;x<include_infos_for_this_test.size();x++)
							{
								String kstr = (String)include_infos_for_this_test.get(x);
								if(kstr.indexOf("*")>-1)
								{
									if(include_infos_pattern_for_this_test == null)
									{
										include_infos_pattern_for_this_test = new ArrayList();
									}
									include_infos_pattern_for_this_test.add(kstr);
								}
								else if(kstr.endsWith("#endsWith"))
								{
									if(include_infos_endsWith_for_this_test == null)
									{
										include_infos_endsWith_for_this_test = new ArrayList();
									}
									include_infos_endsWith_for_this_test.add(kstr.substring(0,kstr.lastIndexOf("#")));
								}
							}
							if(include_infos_pattern_for_this_test !=null)
							{
								include_infos_for_this_test.removeAll(include_infos_pattern_for_this_test);
							}
							if(include_infos_endsWith_for_this_test !=null)
							{
								include_infos_for_this_test.removeAll(include_infos_endsWith_for_this_test);
							}
						}
						ArrayList exclude_test_infos_for_this_test = null;
						ArrayList exclude_test_infos_pattern_for_this_test = null;
						ArrayList exclude_test_infos_endsWith_for_this_test = null;
						if(excludeInfosPerTest != null && excludeInfosPerTest.containsKey(associatedTestName)) {
							exclude_test_infos_for_this_test = (ArrayList)excludeInfosPerTest.get(associatedTestName);
							for(int x=0;x<exclude_test_infos_for_this_test.size();x++)
							{
								String kstr = (String)exclude_test_infos_for_this_test.get(x);
								if(kstr.indexOf("*")>-1)
								{
									if(exclude_test_infos_pattern_for_this_test == null)
									{
										exclude_test_infos_pattern_for_this_test = new ArrayList();
									}
									exclude_test_infos_pattern_for_this_test.add(kstr);
								}
								else if(kstr.endsWith("#endsWith"))
								{
									if(exclude_test_infos_endsWith_for_this_test == null)
									{
										exclude_test_infos_endsWith_for_this_test = new ArrayList();
									}
									exclude_test_infos_endsWith_for_this_test.add(kstr.substring(0,kstr.lastIndexOf("#")));
								}
							}
							if(exclude_test_infos_pattern_for_this_test !=null)
							{
								exclude_test_infos_for_this_test.removeAll(exclude_test_infos_pattern_for_this_test);
							}
							if(exclude_test_infos_endsWith_for_this_test !=null)
							{
								exclude_test_infos_for_this_test.removeAll(exclude_test_infos_endsWith_for_this_test);
							}
						}
						//descriptor handling ends here
						ArrayList associated_actual_measures = new ArrayList();// associated test's actual measure names
						Hashtable tmpHt = (Hashtable)tmdc.get(associatedTestName);
						int column_index = 1;
						int startIndex = 0;
//						if(!infobasedTest || infobasedCompTest) {
//							startIndex = 1;
//							associated_actual_measures.add("");
//						}
						boolean validDataFound = false;
						ArrayList labelList = new ArrayList();
						for(int i=startIndex;i<index-1;i++) {
							if(i==0) {
								String label = mapObj.getTextDescription("monitor.common.Descriptor").toUpperCase();
								if(infobasedTest)
								{
									columnArray.add(label);
								}
								labelList.add(label);
								associated_actual_measures.add("");
							}
							else if(i==1) {
								String label = mapObj.getTextDescription("monitor.common.Measurement Time").toUpperCase();
								columnArray.add(label);
								labelList.add(label);
								associated_actual_measures.add("");
							}
							else {
								String tm = (String)tmpHt.get(resultList.get(i));
								int idx = tm.indexOf(":");
								String t = tm.substring(0,idx);
								String m = tm.substring(idx+1);
								String column_name = mapObj.getMeasureDescription(t,m).toUpperCase();
								associated_actual_measures.add(m);
								columnArray.add(column_name);
								labelList.add(column_name);
								if(key_measures.contains(m)) {
									kma.add(column_name);
								}
							}
						}
						boolean checkInfo = !info.equals("+");
						for(int i=index;i<resultList.size();i++) {
							JSONObject tableRow = new JSONObject();
							String row = (String)resultList.get(i);
							String array[] = StringUtils.getTokens(row,"~");
							String thisinfo = array[0];
							if(!thisinfo.equals("+"))
							{
								thisinfo = thisinfo.substring(thisinfo.indexOf("+"));
							}
							int ind = thisinfo.indexOf("+");
							if(ind < 0) {
								continue;
							}
							if(allowedTestInfos != null && (allowedTestInfos.isEmpty() || !allowedTestInfos.contains(thisinfo)))
							{
								boolean doAllow=false;
								if(!allowedTestInfos.isEmpty() && !allowedTestInfos.contains(thisinfo))
								{
									for(int pt=0;pt<allowedTestInfos.size();pt++)
									{
										String mykey = (String)allowedTestInfos.get(pt)+"_on_";
										if(thisinfo.startsWith(info) && thisinfo.startsWith(mykey))
										{
											doAllow=true;
											break;
										}
									}
								}
								if(!doAllow)
									continue;
							}
							if(thisinfo.endsWith("+") && thisinfo.length()>1)
							{
								thisinfo = thisinfo.substring(thisinfo.indexOf("+"));
							}
							else if(thisinfo.startsWith("+") && thisinfo.length()>1)
							{
								thisinfo=thisinfo.substring(thisinfo.indexOf("+"));
							}
							else
							{
								thisinfo=thisinfo.substring(thisinfo.indexOf("+"));
							}
//							if(checkInfo && !thisinfo.equals(info)) {
//								continue;
//							}
							if(thisinfo.length()>1) {
//								if(excludeDescOfTestconfigpage != null && excludeDescOfTestconfigpage.contains(thisinfo)) {
//									continue;
//								}
								//String infoTemp = thisinfo.substring(ind+1);
								String infoTemp = thisinfo.substring(thisinfo.indexOf("+")+1);
//								if(include_infos_for_this_test != null && !include_infos_for_this_test.contains(infoTemp)) {
//									continue;
//								}
//
//								if(exclude_test_infos_for_this_test != null && exclude_test_infos_for_this_test.contains(infoTemp)) {
//									continue;
//								}
								if(include_infos_for_this_test != null)
								{
									boolean pattern_matched = false;
									if(include_infos_pattern_for_this_test !=null)
									{
										for(int x=0;x<include_infos_pattern_for_this_test.size();x++)
										{
											String pattern = (String)include_infos_pattern_for_this_test.get(x);
											if(EgUtilities.isMatch(infoTemp, pattern))
											{
												pattern_matched=true;
												break;
											}
										}
									}
									boolean found_in_include_infos_list = false;
									if(!pattern_matched && !include_infos_for_this_test.isEmpty() && include_infos_for_this_test.contains(infoTemp))
									{
										found_in_include_infos_list=true;
									}
									boolean found_in_include_infos_endsWith_list = false;
									if(include_infos_endsWith_for_this_test !=null)
									{
										for(int x=0;x<include_infos_endsWith_for_this_test.size();x++)
										{
											String ends_info = (String)include_infos_endsWith_for_this_test.get(x);
											if(infoTemp.endsWith(ends_info))
											{
												found_in_include_infos_endsWith_list=true;
											}
										}
									}
									if(!pattern_matched && !found_in_include_infos_list && !found_in_include_infos_endsWith_list)
									{
										continue;
									}
								}
								if(exclude_test_infos_for_this_test != null)
								{
									boolean pattern_matched = false;
									if(exclude_test_infos_pattern_for_this_test !=null)
									{
										for(int x=0;x<exclude_test_infos_pattern_for_this_test.size();x++)
										{
											String pattern = (String)exclude_test_infos_pattern_for_this_test.get(x);
											if(EgUtilities.isMatch(infoTemp, pattern))
											{
												pattern_matched=true;
												break;
											}
										}
									}
									boolean found_in_exlude_infos_list = false;
									if(!exclude_test_infos_for_this_test.isEmpty() && exclude_test_infos_for_this_test.contains(infoTemp))
									{
										found_in_exlude_infos_list=true;
									}
									boolean found_in_exlude_infos_endsWith_list = false;
									if(exclude_test_infos_endsWith_for_this_test !=null)
									{
										for(int x=0;x<exclude_test_infos_endsWith_for_this_test.size();x++)
										{
											String ends_info = (String)exclude_test_infos_endsWith_for_this_test.get(x);
											if(infoTemp.endsWith(ends_info))
											{
												found_in_exlude_infos_endsWith_list=true;
											}
										}
									}
									if(pattern_matched || found_in_exlude_infos_list || found_in_exlude_infos_endsWith_list)
									{
										continue;
									}
								}
							}
							dataDisplayed = true;
							column_index = 0;
							for(int j=0;j<array.length;j++) {
								validDataFound=true;
								if(j==0)
								{
									//if(!infobasedTest || infobasedCompTest) {
									//	continue;
									//}
									//else {
										String display_info = thisinfo.substring(1);
										if(display_info.length()==0)
											display_info = "-";
										//rowData.put(labelList.get(column_index++).toString(),thisinfo.substring(1));
										if(infobasedTest)
										{
											rowData.put(labelList.get(column_index++).toString(),display_info);
										}
										else
										{
											column_index++;
										}
									//}
									continue;
								}
								else if(j==1) {
									String displayDate = DateUtil.changeDateFormat(array[1],"yyyy-MM-dd HH:mm:ss",currentDateFormat + " HH:mm:ss");
									rowData.put(labelList.get(column_index++).toString(),displayDate);
								}
								else
								{
									String val = array[j];
									if(val.startsWith(".")) {
										val = "0"+val;
									}
									else if(val.endsWith(".0000"))
									{
										val = val.substring(0,val.indexOf("."));
									}
									else if(val.equals("-5") || val.equals("-5.0000")) {
										val = "-";
									}
									else if(val.equals("-1") || val.equals("-1.0000")) {
										val = "-";
									}
									val=val.trim();
									if(val.startsWith("-"))
									{
										rowData.put(labelList.get(column_index++).toString(),"-");
									}
									else
									{
										String measName = (String)associated_actual_measures.get(j);
										String status = getStatus(val,associatedTestName,measName,key_measures.contains(measName),keyMinorCheckNeeded,keyMajorCheckNeeded,supportMinorCheckNeeded,supportMajorCheckNeeded,thresholdsForEverySingleMeasure);


										rowData.put(labelList.get(column_index++).toString(),"<div><div style='float:left;margin-right:5px'><img class='"+status+"' src=\"/final/images/spacer.gif\" style=\"width:16px;height:16px;\"></div><div style='float:left'>"+val+"</div></div>");
									}
								}
							}
							rowDataArray.add(rowData);
						}
						if(validDataFound)
						{
							testDisplayNames.add(mapObj.getTestDescription(associatedTestName));
							rowDataArrayGlobal.add(rowDataArray);
							columnDataArrayGlobal.add(columnArray);
							keyMeasuresArray.add(kma);
						}
					}
				}
			}
		}
	}
	json.put("screenLabels",screenLabels);
	json.put("error",error);
	json.put("testDisplayNames",testDisplayNames);
	json.put("keyMeasuresArray",keyMeasuresArray);
	json.put("columnDataArrayGlobal",columnDataArrayGlobal);
	json.put("rowDataArrayGlobal",rowDataArrayGlobal);
	response.getWriter().write(json.toString());
%>

<%!
	String getStatus(
		String value,
		String associatedTestName,
		String measName,
		boolean isKeyTestMeasure,
		boolean keyMinorCheckNeeded,
		boolean keyMajorCheckNeeded,
		boolean supportMinorCheckNeeded,
		boolean supportMajorCheckNeeded,
		Hashtable thresholdsForEverySingleMeasure)
	{
		boolean minorCheckNeeded = true;
		boolean majorCheckNeeded = true;
		if(isKeyTestMeasure)
		{
			minorCheckNeeded = keyMinorCheckNeeded;
			majorCheckNeeded = keyMajorCheckNeeded;
		}
		else
		{
			minorCheckNeeded = supportMinorCheckNeeded;
			majorCheckNeeded = supportMajorCheckNeeded;
		}

		boolean minor_threshold_check_min = false;
		boolean major_threshold_check_min = false;
		boolean critical_threshold_check_min = false;
		boolean minor_threshold_check_max = false;
		boolean major_threshold_check_max = false;
		boolean critical_threshold_check_max = false;

		double minor_threshold_level_min = 0.0;
		double major_threshold_level_min = 0.0;
		double critical_threshold_level_min = 0.0;
		double minor_threshold_level_max = 0.0;
		double major_threshold_level_max = 0.0;
		double critical_threshold_level_max = 0.0;

		boolean minimum_threshold_set=true;
		boolean maximum_threshold_set=true;
		String min_max_thresh_info = "-1:-1";
		String thisKey = associatedTestName+":"+measName;
		if(thresholdsForEverySingleMeasure !=null && thresholdsForEverySingleMeasure.containsKey(thisKey)) {
			min_max_thresh_info = (String)thresholdsForEverySingleMeasure.get(thisKey);
		}
		if(min_max_thresh_info.startsWith("-1:")) {
			minimum_threshold_set=false;
		}
		if(min_max_thresh_info.indexOf(":-1")>0) {
			maximum_threshold_set=false;
		}
		if(minimum_threshold_set) {
			String min_threshold = min_max_thresh_info.substring(0,min_max_thresh_info.indexOf(":"));
			StringTokenizer st = new StringTokenizer(min_threshold,"/");
			if(st.countTokens()==3) {
				//min_critical threshold check
				String threshold_value = st.nextToken().trim();
				if(!threshold_value.equals("-")) {
					try {
						critical_threshold_level_min = Double.parseDouble(threshold_value);
						critical_threshold_check_min = true;
					}
					catch(Exception e) {
						e.printStackTrace();
					}
				}
				//min_major threshold check
				threshold_value = st.nextToken().trim();
				if(!threshold_value.equals("-")) {
					try {
						major_threshold_level_min = Double.parseDouble(threshold_value);
						major_threshold_check_min = true;
					}
					catch(Exception e) {
						e.printStackTrace();
					}
				}
				//min_minor threshold check
				threshold_value = st.nextToken().trim();
				if(!threshold_value.equals("-")) {
					try {
						minor_threshold_level_min = Double.parseDouble(threshold_value);
						minor_threshold_check_min = true;
					}
					catch(Exception e) {
						e.printStackTrace();
					}
				}
			}
		}
		if(maximum_threshold_set) {
			String max_threshold = min_max_thresh_info.substring(min_max_thresh_info.indexOf(":")+1);
			StringTokenizer st = new StringTokenizer(max_threshold,"/");
			if(st.countTokens()==3)
			{
				//max_critical threshold check
				String threshold_value = st.nextToken().trim();
				if(!threshold_value.equals("-")) {
					try {
						critical_threshold_level_max = Double.parseDouble(threshold_value);
						critical_threshold_check_max = true;
					}
					catch(Exception e)
					{
						e.printStackTrace();
					}
				}
				//max_major threshold check
				threshold_value = st.nextToken().trim();
				if(!threshold_value.equals("-")) {
					try {
						major_threshold_level_max = Double.parseDouble(threshold_value);
						major_threshold_check_max = true;
					}
					catch(Exception e) {
						e.printStackTrace();
					}
				}
				//max_minor threshold check
				threshold_value = st.nextToken().trim();
				if(!threshold_value.equals("-")) {
					try {
						minor_threshold_level_max = Double.parseDouble(threshold_value);
						minor_threshold_check_max = true;
					}
					catch(Exception e) {
						e.printStackTrace();
					}
				}
			}
		}
		String measureValueStatus="stateSymbol_GOOD";//this is css value. dont change
		double avg_val = Double.parseDouble(value);
		boolean no_thresholds_violated = true;
		if(minimum_threshold_set) {
			if(critical_threshold_check_min && avg_val<critical_threshold_level_min)
			{
				no_thresholds_violated=false;
				measureValueStatus="stateSymbol_HIGH";//this is css value. dont change
			}
			else if(majorCheckNeeded && major_threshold_check_min && avg_val<major_threshold_level_min)
			{
				no_thresholds_violated=false;
				measureValueStatus="stateSymbol_INTERMEDIATE";//this is css value. dont change
			}
			else if(minorCheckNeeded && minor_threshold_check_min && avg_val<minor_threshold_level_min)
			{
				no_thresholds_violated=false;
				measureValueStatus="stateSymbol_LOW";//this is css value. dont change
			}
		}
		if(maximum_threshold_set && no_thresholds_violated) {
			if(critical_threshold_check_max && avg_val>critical_threshold_level_max)
			{
				measureValueStatus="stateSymbol_HIGH";//this is css value. dont change
			}
			else if(majorCheckNeeded && major_threshold_check_max && avg_val>major_threshold_level_max)
			{
				measureValueStatus="stateSymbol_INTERMEDIATE";//this is css value. dont change
			}
			else if(minorCheckNeeded && minor_threshold_check_max && avg_val>minor_threshold_level_max)
			{
				measureValueStatus="stateSymbol_LOW";//this is css value. dont change
			}
		}
		return measureValueStatus;
	}
	private Hashtable getTestPeriods(String server, ArrayList tests, EgSpecsInfo specsInfo, EgExternalInfo externalInfo)
	{
		IniFile agentsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_agents.ini");
		StringTokenizer tokenize = new StringTokenizer(server,":");
		String componentType = tokenize.nextToken();
		String hostName = tokenize.nextToken();
		String portNo = tokenize.nextToken();
		String sid = "";
		if(tokenize.hasMoreTokens())
		{
			sid=tokenize.nextToken();
		}
		Hashtable ht = null;
		if(server != null && tests != null)
		{
			ht = new Hashtable();
			for(int i=0;i<tests.size();i++)
			{
				String test = (String)tests.get(i);
			
				String testKey = specsInfo.findTest(test, componentType);
				String testKeyValue = specsInfo.getArgsForTest(testKey);
				String currentTestPeriod = testKeyValue.substring(testKeyValue.lastIndexOf(",")+1);
				testKey = replace(testKey, "$hostName", hostName);
				testKey = replace(testKey, "$portNo", portNo);
				testKey = replace(testKey, "$sid", sid);

				List agentNames = externalInfo.getAgentsFor(test, componentType, hostName);
				for(int idx=0;idx<agentNames.size();idx++)
				{
					String tp = null;
					String agentName = (String) agentNames.get(idx);
					String variables[] = agentsIni.getVariables(agentName);
					for(int k=0; k<variables.length; k++)
					{
						String tempKey = variables[k];
						if(tempKey.equals(testKey))
						{
							tp = agentsIni.getValue(agentName, tempKey);
						}
					}
					if(tp != null && tp.length() > 0)
					{
						String tpd = tp.substring(tp.lastIndexOf(EgConstants.COMMA)+1).trim();
						try
						{
							long tl = (Long.parseLong(tpd) * 1000);
							ht.put(test,new Long(tl));
						}
						catch(Exception e)
						{
						}
					}
				}
			}
		}
		return ht;
	}
	private String replace(String value,String search,String replace)
	{
 		String result;
 		int i;
		int len = search.length();
		do
		{
			i = value.indexOf(search);
			if(i >= 0)
			{
				result = value.substring(0,i);
				result = result + replace;
				result = result + value.substring(i + len);
				value = result;
			}
		}
		while(i >= 0);
		return value;
	}
%>