<%@ include file = "EgMonitorTracker.jsp" %>
<%@ page import = "com.eg.*"%>
<%@ page import = "com.egurkha.*"%>
<%@ page import = "com.egurkha.util.*"%>
<%@ page import = "com.egurkha.admin.*"%>
<%@ page import = "com.egurkha.monitor.*"%>
<%@ page import = "egurkha.reporter.ErInfo"%>
<%@ page import = "java.sql.ResultSet"%>
<%@ page import = "java.text.*"%>
<%@ page import = "java.util.*"%>
<%@ page import = "net.sf.json.*"%>
<%@ page import = "com.egurkha.ini.IniUI" %>
<%@ page import = "com.eg.supermanager.*" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
	response.setContentType("application/json");
	request.setCharacterEncoding("UTF-8");
%>
	<jsp:useBean id="teststatus" class="egurkha.TestStatusInfo"/>
<%
	EgDiscInfo discInfo = new EgDiscInfo("manager");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgAggregateInfo aggInfo = new EgAggregateInfo("manager");
	EgExternalInfo externalInfo = new EgExternalInfo("manager");
	EgMappingInfo mapObj= EgMappingInfo.getEgMappingInfo();
	EgDateInfo dateInfo = new EgDateInfo();
	EgTopoInfo topoInfo = new EgTopoInfo("manager");
	EgDbInfo dbInfo = new EgDbInfo("manager");
	EgTablesInfo tablesInfo = new EgTablesInfo("manager");
	StateDAO stateDao = new StateDAO();
	MonitorDAOFactory monitorDaoFactory = MonitorDAOFactory.getInstance();
	AggregateDAO aggDAO = monitorDaoFactory.getAggregateDAO();

	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	EgTimeZoneConverter converterStart=null;
	EgTimeZoneConverter converterEnd = null;

	StringBuffer aggregateTable = new StringBuffer();

	String siteName = request.getParameter("site");
	String compType = (request.getParameter("stype")).trim();
	String hostName = request.getParameter("sname");
	if(hostName != null)
	{
		hostName = EgURLDecoder.decode(hostName,"UTF-8");
	}
	String portNo = request.getParameter("sport");
	String testName = request.getParameter("tname");
	String msmtHost = request.getParameter("msmt_host");
	String msmtTime = request.getParameter("msmttime");
	String layerName = request.getParameter("layer");
	String measureName = request.getParameter("measurename");
	String measureUnit = tablesInfo.getUnitForMeasure(testName, measureName);
	String info = request.getParameter("sinfo");
	if(info != null)
	{
		info = EgURLDecoder.decode(info,"UTF-8");
	}
	String usermsmtTime = "";
	if(info.equals("Nil"))
		info = "+";
	IniFile UIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini", false);
	IniUI iniUi=(IniUI)IniUI.getInstance();
	String aggDescriptor = aggInfo.getParameterValue(testName, compType+":"+hostName+":NULL", "aggregateDescriptor");
	if(aggDescriptor==null || (aggDescriptor=aggDescriptor.trim()).length()==0 || aggDescriptor.equalsIgnoreCase("null"))
		aggDescriptor ="false";

	ArrayList excludedDescriptors = new ArrayList();
	String exDescStr = aggInfo.getParameterValue(testName, compType+":"+hostName+":NULL", "excludeDescriptor");
	if(exDescStr !=null && (exDescStr=exDescStr.trim()).length()>0 && !exDescStr.equalsIgnoreCase("null"))
	{
		String descriptors[] = StringUtils.getTokens(exDescStr,",");
		for(int i=0;i<descriptors.length;i++)
		{
			String descriptor = descriptors[i];
			if(descriptor.startsWith("+"))
			{
				excludedDescriptors.add(descriptor);
			}
			else
			{
				excludedDescriptors.add("+"+descriptor);
			}
		}
	}

	String name =compType+":"+hostName+":NULL";
	String compState = stateDao.getComponentPriority(siteName, hostName+":NULL", compType);
	String aggTestFrequency = teststatus.frequencyOfTest(compType,hostName + ":" + portNo,testName);
	String memberTestName = aggInfo.getTestName(testName);
	String memCompType = aggInfo.getValue("COMPONENT_TYPE_MAPPING",compType);
	String functionUsed = aggInfo.getValue("AGGREGATE_FUNCTION",testName+":"+measureName.toUpperCase());
	functionUsed = functionUsed.substring(functionUsed.indexOf(":")+1,functionUsed.lastIndexOf(":"));
	String targetOperation = null;
	String appendStr = "";
	double targetValue = 0;
	String displayTargetValue = null;
	double minorCheck = -1;
	double majorCheck = -1;
	double criticalCheck = -1;
	String trgt_components_str = null;
	double minorPercentage = -1;
	double majorPercentage = -1;
	double criticalPercentage = -1;
	String trgt_violation_by_str = null;
	boolean table_rows_found = false;
	String showViolatedDescriptors = request.getParameter("showViolatedDescriptors");
	//showViolatedDescriptors is received from final/monitor/eg_scripts/componentDashboard/view/Layers/AggregateWindow.js file
	if(showViolatedDescriptors == null)
	{
		showViolatedDescriptors = "No";
	}
	boolean isConditionBased = false;
	if(functionUsed.equalsIgnoreCase("condition") || functionUsed.equalsIgnoreCase("multi_condition"))
	{
		isConditionBased = true;
		String compareDetails = aggInfo.getValue("COMPARISON",testName+":"+measureName);
		String array[] = StringUtils.getTokens(compareDetails,"|");
		targetOperation = array[0];
		displayTargetValue = array[1];
		trgt_components_str = array[2];
		trgt_violation_by_str = array[3];
		if(displayTargetValue.indexOf("/")==-1)
		{
			targetValue = Double.parseDouble(displayTargetValue);
		}
		else
		{
			String tvs[] = StringUtils.getTokens(displayTargetValue,"/");
			if(tvs != null && tvs.length==3)
			{
				try {
					criticalCheck = Double.parseDouble(tvs[0]);
				}
				catch(Exception e){}
				try {
					majorCheck = Double.parseDouble(tvs[1]);
				}
				catch(Exception e){}
				try {
					minorCheck = Double.parseDouble(tvs[2]);
				}
				catch(Exception e){}
			}
			String tcs[] = StringUtils.getTokens(trgt_components_str,"/");
			if(tcs != null && tcs.length==3)
			{
				try {
					criticalPercentage = Double.parseDouble(tcs[0]);
				}
				catch(Exception e){}
				try {
					majorPercentage = Double.parseDouble(tcs[1]);
				}
				catch(Exception e){}
				try {
					minorPercentage = Double.parseDouble(tcs[2]);
				}
				catch(Exception e){}
			}
		}
		if(targetOperation.equalsIgnoreCase("GT"))
		{
			targetOperation = ">";
			appendStr="(Greater than)";
		}
		else if(targetOperation.equalsIgnoreCase("LT"))
		{
			targetOperation = "<";
			appendStr="(Lesser than)";
		}
		else if(targetOperation.equalsIgnoreCase("GE"))
		{
			targetOperation = ">=";
			appendStr="(Greater than or equal)";
		}
		else if(targetOperation.equalsIgnoreCase("LE"))
		{
			targetOperation = "<=";
			appendStr="(Lesser than or equal)";
		}
		else if(targetOperation.equalsIgnoreCase("EQ"))
		{
			targetOperation = "=";
			appendStr="(Equal)";
		}
	}
	String memberMeasureName = aggInfo.getValue("COLUMN_NAME_MAPPING",testName+":"+measureName);
	memberMeasureName = memberMeasureName.substring(memberMeasureName.indexOf(":")+1);
	String measureUnit_2 = tablesInfo.getUnitForMeasure(memberTestName, measureName);
	String m_desc = mappingInfo.getMeasureDescription(memberTestName,memberMeasureName)+"&nbsp;("+measureUnit_2+")";
	String desc_for_table = mappingInfo.getMeasureDescription(memberTestName,memberMeasureName);
	String displayFunctionName = aggInfo.getValue("FUNCTION_NAME-MAPPING",functionUsed);
	String displayFunctionName1 = displayFunctionName;
	if(functionUsed.equals("avg_sum"))
	{
		displayFunctionName1 = aggInfo.getValue("FUNCTION_NAME-MAPPING","avg");
	}
	String currentDateFormat = UIni.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	String s_from="";
	String s_to="";
	String s_userDateFrom = "";
	String s_userDateTo="";
	try
	{
		if(msmtTime!=null && msmtTime.length()>0)
		{
			SimpleDateFormat format= new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
			Date sourceDate = format.parse(msmtTime);
			long last_msmt_time = sourceDate.getTime();
			long measure_factor = aggInfo.getMeasureFactor();
			long measure_period = Long.parseLong(aggTestFrequency)* 1000;
			long x = Math.round(0.1 * measure_period);
			long from1 = last_msmt_time - (measure_factor * measure_period);
			SimpleDateFormat targetFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss"); 
			s_from = targetFormat.format(new Date(from1 - x));
			s_to = targetFormat.format(new Date(last_msmt_time));
			msmtTime = DateUtil.changeDateFormat(msmtTime,"MM/dd/yyyy HH:mm:ss",currentDateFormat + " HH:mm:ss");
			converterStart = new EgTimeZoneConverter(msmtTime,user);
			usermsmtTime = converterStart.getDateTime();
			/*
			out.println("<br>measure_factor " + measure_factor);
			out.println("<br>measure_period " + measure_period);
			out.println("<br>x " + x);
			out.println("<br>s_from " + s_from);
			out.println("<br>s_endt " + s_to);
			*/
		}
		else
		{
			msmtTime ="Not Available";
			usermsmtTime = "Not Available";
		}
	}
	catch(Exception eee)
	{
		//...... msmt time cann't be parsed
	}
	boolean memberStateFlag = UIni.getValue("AGGREGATE_DASHBOARD","MEMBERSTATE").equalsIgnoreCase("true")?true:false;
	String dispAggCompType = mapObj.getComponentTypeDescription(compType);
	String title_comp_type = dispAggCompType;

	String dispHostName = hostName;
	String title_host_name = dispHostName;

	String dispAggTestName = mapObj.getTestDescription(testName);
	String title_test_name = dispAggTestName;

	String dispAggMeasure = mapObj.getMeasureDescription(testName,measureName);
	String dispAggMeasureName = dispAggMeasure+" ("+measureUnit+")";
	String title_measure_unit = dispAggMeasureName;

	ArrayList associatedCompTypes = aggInfo.getAssociatedComponentTypes(name);
	boolean isMemberTestExternal = specsInfo.isTestExternal(memberTestName,memCompType);
	Hashtable setZeroMeasures = aggInfo.getZeroMeasures(testName);

	JSONObject json = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	JSONObject error = new JSONObject();

	screenLabels.put("measurementTime",mapObj.getTextDescription("monitor.aggregates.Measurement Time"));
	screenLabels.put("componentType",mapObj.getTextDescription("monitor.aggregates.Component Type"));
	screenLabels.put("componentName",mapObj.getTextDescription("monitor.aggregates.Component Name"));
	screenLabels.put("test",mapObj.getTextDescription("monitor.aggregates.Test Name"));
	screenLabels.put("measure",mapObj.getTextDescription("monitor.aggregates.Measure Name"));

	//json.put("targetOperation",targetOperation + "&nbsp;" + appendStr);
	json.put("targetOperation",targetOperation);
	if(functionUsed.equalsIgnoreCase("multi_condition"))
	{
		json.put("targetValue",displayTargetValue);
		json.put("target_components",trgt_components_str);
		json.put("target_violation_by",trgt_violation_by_str);
	}
	else if(functionUsed.equalsIgnoreCase("condition"))
	{
		json.put("targetValue",targetValue);
		json.put("target_components","Not Applicable");
		json.put("target_violation_by",trgt_violation_by_str);
	}
	json.put("isAggTestDescBased",String.valueOf(aggDescriptor.equalsIgnoreCase("false")));
	// this aggregate test is descriptor based only if aggregateInfos value is false

	json.put("measurementTime",usermsmtTime);
	json.put("componentType",dispAggCompType);
	json.put("componentName",dispHostName);
	json.put("test",dispAggTestName);
	json.put("measure",dispAggMeasureName);

	boolean isPctFunctionUsed = false;
	Hashtable dontShowCompInfo = new Hashtable();
	ArrayList resultList= new ArrayList();
	List memberList = new ArrayList();
	List newMemberList = new ArrayList();
	String memColumName = null;
	if(msmtTime!=null && msmtTime.length()>0)
	{
		memberList = aggInfo.getAssociatedComponents(name,true);
		List mangd_comp = aggInfo.getAggregateComponents(testName,hostName+":"+portNo);
		List memberCommaStr = aggInfo.getCommaSepStrings(mangd_comp);
		String memberStr = (String)memberCommaStr.get(0);
		memColumName = aggInfo.getMemberColumnName(testName,measureName);

		isPctFunctionUsed = functionUsed.equalsIgnoreCase("pct");
		if(isPctFunctionUsed)
		{
			String specialMeasuresStr = aggInfo.getValue("SPECIAL_FUNCTION",testName+":"+memColumName);
			String array[] = StringUtils.getTokens(specialMeasuresStr,",");
			String m1 = array[0];
			String m2 = array[1];
			m1 = m1.substring(0,m1.indexOf(":"));
			m2 = m2.substring(0,m2.indexOf(":"));
			memColumName = m1 + "," + m2;
		}
		if(!EgInstallInfo.isSuperManager)
		{
			StringBuffer sb = new StringBuffer();
			sb.append("select trgt_host,port_no,site_name,info,msmt_time,msmt_host,");
			sb.append(memColumName);
			sb.append(" from ");
			sb.append(memberTestName);

			if(EgDbInfo.checkDBType().equals("EgMsSqlAdapter"))
			{
				sb.append(" where msmt_time between CONVERT (datetime, '");
				sb.append(s_from);
				sb.append("', 103) and CONVERT (datetime, '");
				sb.append(s_to);
				sb.append("', 103) and trgt_host in (");
			}
			else
			{
				sb.append(" where MSMT_TIME BETWEEN TO_DATE('");
				sb.append(s_from);
				sb.append("','DD/MM/YYYY HH24:MI:SS') AND TO_DATE('");
				sb.append(s_to);
				sb.append("','DD/MM/YYYY HH24:MI:SS') and trgt_host in (");
			}

			//sb.append(memberStr);
			sb.append("eg_keyword_to_replace");
			sb.append(")");

			String variables[] = aggInfo.getVariables("AGGREGATE_TEST_INFOS_EXCLUDED");
			if(variables != null && variables.length>0)
			{
				for(int i=0;i<variables.length;i++)
				{
					String str = variables[i];
					if(str.startsWith((testName + ":" + name+"#")))
					{
						str = str.substring(str.indexOf("#")+1);
						String compNick = str.substring(0,str.indexOf(":+"));
						if(compNick.endsWith(":NULL"))
						{
							compNick = compNick.substring(0,compNick.lastIndexOf(":"));
						}
						str = str.substring(str.indexOf(":")+1);
						str = str.substring(str.indexOf(":")+1);
						str = str.substring(str.indexOf(":")+1);
						if(dontShowCompInfo.containsKey(compNick))
						{
							ArrayList alist = (ArrayList)dontShowCompInfo.get(compNick);
							alist.add(str.substring(1));
							dontShowCompInfo.put(compNick,alist);
						}
						else
						{
							ArrayList alist = new ArrayList();
							alist.add(str.substring(1));
							dontShowCompInfo.put(compNick,alist);
						}
					}
				}
			}
			int size = excludedDescriptors.size();
			if(excludedDescriptors != null && size>0)
			{
				--size;
				sb.append(" and info not in('");
				while(size>=0)
				{
					sb.append(excludedDescriptors.get(size).toString()+"'");
					--size;
					if(size>=0)
					{
						sb.append(",'");
					}
					else
					{
						sb.append(") ");
						break;
					}
				}
			}
			if(siteName != null && (testName.equals("WebSiteTransAggTest") || testName.equals("WebSiteAggTest")))
			{
				String site_name = topoInfo.getSiteForAggregateSite(siteName);
				sb.append(" and site_name = '"+site_name+"'");
			}
			if(isPctFunctionUsed)
			{
				sb.append(" order by trgt_host");
			}
			else
			{
				sb.append(" and "+memColumName+" >-1 order by trgt_host");
			}
			//System.out.println(sb.toString());
			//resultList = aggDAO.getQueryResult(sb.toString());	//resultList Contains ColumnNames+"#####"+(~)Sepeareated Records

			String orginalQuery = sb.toString();
			for(int i=0;i<memberCommaStr.size();i++)
			{
				String query = StringUtils.replace(orginalQuery, "eg_keyword_to_replace", (String) memberCommaStr.get(i));
				ArrayList tmp_rs = aggDAO.getQueryResult(query);
				if( tmp_rs != null && !tmp_rs.isEmpty())
				{
					if(resultList.isEmpty()) {
						resultList.addAll(tmp_rs);
					}
					else {
						if(tmp_rs.size()>=0) {
							if(tmp_rs.indexOf("#####")>0) {
								int index = tmp_rs.indexOf("#####")+1;
								if(tmp_rs.size()>index) {
									resultList.addAll(tmp_rs.subList(index,tmp_rs.size()));
								}
							}
						}
					}
				}
			}
		}
		else
		{
			//Oracle query starts
			StringBuffer sbOracle = new StringBuffer();
			StringBuffer sbSqlServer = new StringBuffer();
			
			sbOracle.append("select trgt_host,port_no,site_name,info,msmt_time,msmt_host,");
			sbSqlServer.append("select trgt_host,port_no,site_name,info,msmt_time,msmt_host,");

			sbOracle.append(memColumName);
			sbSqlServer.append(memColumName);

			sbOracle.append(" from ");
			sbSqlServer.append(" from ");

			sbOracle.append(memberTestName);
			sbSqlServer.append(memberTestName);

			/*if(EgDbInfo.checkDBType().equals("EgMsSqlAdapter"))
			{*/
				sbSqlServer.append(" where msmt_time between CONVERT (datetime, '");
				sbSqlServer.append(s_from);
				sbSqlServer.append("', 103) and CONVERT (datetime, '");
				sbSqlServer.append(s_to);
				sbSqlServer.append("', 103) and trgt_host in (");
			/*}
			else
			{*/
				sbOracle.append(" where MSMT_TIME BETWEEN TO_DATE('");
				sbOracle.append(s_from);
				sbOracle.append("','DD/MM/YYYY HH24:MI:SS') AND TO_DATE('");
				sbOracle.append(s_to);
				sbOracle.append("','DD/MM/YYYY HH24:MI:SS') and trgt_host in (");
			//}

			sbOracle.append("eg_keyword_to_replace");
			sbSqlServer.append("eg_keyword_to_replace");

			sbOracle.append(")");
			sbSqlServer.append(")");

			String variables[] = aggInfo.getVariables("AGGREGATE_TEST_INFOS_EXCLUDED");
			if(variables != null && variables.length>0)
			{
				for(int i=0;i<variables.length;i++)
				{
					String str = variables[i];
					if(str.startsWith((testName + ":" + name+"#")))
					{
						str = str.substring(str.indexOf("#")+1);
						String compNick = str.substring(0,str.indexOf(":+"));
						if(compNick.endsWith(":NULL"))
						{
							compNick = compNick.substring(0,compNick.lastIndexOf(":"));
						}
						str = str.substring(str.indexOf(":")+1);
						str = str.substring(str.indexOf(":")+1);
						str = str.substring(str.indexOf(":")+1);
						if(dontShowCompInfo.containsKey(compNick))
						{
							ArrayList alist = (ArrayList)dontShowCompInfo.get(compNick);
							alist.add(str.substring(1));
							dontShowCompInfo.put(compNick,alist);
						}
						else
						{
							ArrayList alist = new ArrayList();
							alist.add(str.substring(1));
							dontShowCompInfo.put(compNick,alist);
						}
					}
				}
			}
			int size = excludedDescriptors.size();
			if(excludedDescriptors != null && size>0)
			{
				--size;
				sbOracle.append(" and info not in('");
				sbSqlServer.append(" and info not in('");

				while(size>=0)
				{
					sbOracle.append(excludedDescriptors.get(size).toString()+"'");
					sbSqlServer.append(excludedDescriptors.get(size).toString()+"'");
					--size;
					if(size>=0)
					{
						sbOracle.append(",'");
						sbSqlServer.append(",'");
					}
					else
					{
						sbOracle.append(") ");
						sbSqlServer.append(") ");
						break;
					}
				}
			}
			if(siteName != null && (testName.equals("WebSiteTransAggTest") || testName.equals("WebSiteAggTest")))
			{
				String site_name = topoInfo.getSiteForAggregateSite(siteName);
				sbOracle.append(" and site_name = '"+site_name+"'");
				sbSqlServer.append(" and site_name = '"+site_name+"'");
			}
			if(isPctFunctionUsed)
			{
				sbOracle.append(" order by trgt_host");
				sbSqlServer.append(" order by trgt_host");
			}
			else
			{
				sbOracle.append(" and "+memColumName+" >-1 order by trgt_host");
				sbSqlServer.append(" and "+memColumName+" >-1 order by trgt_host");
			}

			ArrayList managerIds = EgElementInfo.getInstance().getManagerIDs("component",hostName);
			if(managerIds != null && !managerIds.isEmpty())
			{
				new SMDateTimeConverter(managerIds,"dd/MM/yyyy HH:mm:ss",s_from,s_to,"yyyy-MM-dd HH:mm:ss",new int[]{4});
			}
			else
			{
				new SMDateTimeConverter("dd/MM/yyyy HH:mm:ss",s_from,s_to,"yyyy-MM-dd HH:mm:ss",new int[]{4});
			}
			//System.out.println(sb.toString());
			String bothQueries = EgSmConfigInfo.ORACLE + sbOracle.toString() + EgSmConfigInfo.EG_DOLLAR + EgSmConfigInfo.SQL + sbSqlServer.toString();
			String orginalQuery = bothQueries;
			for(int i=0;i<memberCommaStr.size();i++)
			{
				String query = StringUtils.replace(orginalQuery, "eg_keyword_to_replace", (String) memberCommaStr.get(i));
				ArrayList tmp_rs = aggDAO.getQueryResult(query);
				if( tmp_rs != null && !tmp_rs.isEmpty())
				{
					if(resultList.isEmpty()) {
						resultList.addAll(tmp_rs);
					}
					else {
						if(tmp_rs.size()>=0) {
							if(tmp_rs.indexOf("#####")>0) {
								int index = tmp_rs.indexOf("#####")+1;
								if(tmp_rs.size()>index) {
									resultList.addAll(tmp_rs.subList(index,tmp_rs.size()));
								}
							}
						}
					}
				}
			}
		}
		s_from = DateUtil.changeDateFormat(s_from,"dd/MM/yyyy HH:mm:ss",currentDateFormat + " HH:mm:ss");
		s_to = DateUtil.changeDateFormat(s_to,"dd/MM/yyyy HH:mm:ss",currentDateFormat + " HH:mm:ss");
		if(s_from!=null && s_from.length()>0)
		{
			converterStart = new EgTimeZoneConverter(s_from,user);
			s_userDateFrom = converterStart.getDateTime();
		}
		if(s_to!=null && s_to.length()>0)
		{
			converterEnd = new EgTimeZoneConverter(s_to,user);
			s_userDateTo = converterEnd.getDateTime();
		}
	}
	int index=0;
	if(resultList.size()>=0)
	{
		if(resultList.indexOf("#####")>0)
		{
			index = resultList.indexOf("#####")+1;
		}
		if(index == resultList.size())	// means Empty Record Set
		{
			screenLabels.put("descriptor",mapObj.getTextDescription("monitor.aggregates.Descriptor"));
			json.put("functionName",displayFunctionName+" ("+measureUnit+")");
			error.put("noMeasureFound",mapObj.getTextDescription("monitor.aggregates.No measures found for this test in the database !!"));
		}
		else
		{
			ArrayList validDBTableRows = new ArrayList();
			Set infoSet = new TreeSet();
			boolean equalsCheck = false;
			boolean startsWithCheck = false;
			boolean endsWithCheck = false;
			boolean patternCheck = false;
			String equalsInfo = "";
			String startsWithInfo = "";
			String endsWithInfo = "";
			String patternInfo = "";
			String excludedInfo = aggInfo.getValue("EXCLUDE_INFOS",memberTestName);
			if(!StringUtils.isNull(excludedInfo) && (excludedInfo=excludedInfo.trim()).indexOf("#")>0)
			{
				int hashIdx = excludedInfo.lastIndexOf("#");
				String function = excludedInfo.substring(hashIdx+1);
				if(function.equalsIgnoreCase("equals"))
				{
					equalsCheck = true;
					equalsInfo = excludedInfo.substring(0,hashIdx);
				}
				else if(function.equalsIgnoreCase("startsWith"))
				{
					startsWithCheck = true;
					startsWithInfo = excludedInfo.substring(0,hashIdx);
				}
				else if(function.equalsIgnoreCase("endsWith"))
				{
					endsWithCheck = true;
					endsWithInfo = excludedInfo.substring(0,hashIdx);
				}
				else if(function.equalsIgnoreCase("pattern"))
				{
					patternCheck = true;
					patternInfo = excludedInfo.substring(0,hashIdx);
				}
			}
			else
			{
				excludedInfo="";
			}

			boolean excludeInfoCheck = excludedInfo != null && excludedInfo.length()>0;
			Hashtable memNameInfoHt = new Hashtable();
			ArrayList showExtAgentsFor = new ArrayList();
			for(int i=index;i<resultList.size();i++)
			{
				String listElement = (String)resultList.get(i);
				ArrayList arrList = StringUtils.egTokenizer(listElement,"~");
				String memberElement = (String)arrList.get(0);
				String popup_time = (String)arrList.get(4);
				if(isMemberTestExternal)
				{
					String nickName = memberElement;
					if(nickName.indexOf(":")>0)
					{
						nickName = nickName.substring(nickName.indexOf(":"));
					}
					if(!showExtAgentsFor.contains(nickName))
					{
						String external_agents[] = externalInfo.getExternalAgentsForHost(nickName);
						if(external_agents != null && external_agents.length>1)
						{
							showExtAgentsFor.add(nickName);
						}
					}
				}
				String memPort = (String) arrList.get(1);
				String infoElement = (String)arrList.get(3);
				if(excludeInfoCheck && infoElement != null && (infoElement=infoElement.trim()).length()>0)
				{
					if(equalsCheck && infoElement.equals(equalsInfo))
					{
						continue;
					}
					else if(startsWithCheck && infoElement.startsWith(startsWithInfo))
					{
						continue;
					}
					else if(endsWithCheck && infoElement.endsWith(endsWithInfo))
					{
						continue;
					}
					else if(patternCheck && EgUtilities.isMatch(infoElement, patternInfo,true))
					{
						continue;
					}
				}
				String memberMsmtHost = (String)arrList.get(5);
				String mesValue = (String)arrList.get(6);
				if(isPctFunctionUsed)
				{
					//IF NEED BE, refer EgAggregateTest.pct(String fn,boolean aggregateInfo,Hashtable hm_con_1,Hashtable hm_con_2,String fact_1,String fact_2,String measureName_1,String measureName_2,String measureName_1_function,String measureName_2_function)
					double measure_value_1 = Double.parseDouble(mesValue);
					double measure_value_2 = Double.parseDouble((String)arrList.get(7));
					double result = 0.0d;
					if(measure_value_1<0)
					{
						measure_value_1 = 0;
					}
					result = ((measure_value_2 - measure_value_1)/measure_value_2)*100;
					mesValue = String.valueOf(result);
				}
				if(setZeroMeasures != null && setZeroMeasures.containsKey(memColumName))
				{
					//some measurments of tests, for example NetworkInterfaceTest:AVAILABILITY will have some imaginary values. so we have to reset this to zero.
					try
					{
						Vector v = (Vector)setZeroMeasures.get(memColumName);
						String tobereplaced = (String)v.get(0);
						String replaceValue = (String)v.get(1);
						double iVal = Double.parseDouble(tobereplaced);
						double incomingValue = Double.parseDouble(mesValue);
						if(iVal>incomingValue)
						{
							mesValue = replaceValue;
						}
					}
					catch(Exception e)
					{
					}
				}
				if(infoElement.endsWith("+")&&infoElement.length()>1)
				{
					memberElement = memberElement +":"+memPort+":"+infoElement.substring(0,infoElement.indexOf("+"));
					infoElement = infoElement.substring(infoElement.indexOf("+"));
				}
				else if(infoElement.startsWith("+"))
				{
					if(infoElement.length()>1)
						infoElement=infoElement.substring(infoElement.indexOf("+")+1);
						memberElement = memberElement+":"+memPort;
				}
				else
				{
					memberElement = memberElement +":"+memPort+":"+infoElement.substring(0,infoElement.indexOf("+"));
					infoElement=infoElement.substring(infoElement.indexOf("+")+1);
				}
				String rightMemberElement = memberElement;
				if(!specsInfo.isPortRelevantForTest(memberTestName))
				{
					String rightServer = null;
					ArrayList allServersOfCurrentNick = discInfo.getServersForHost((String)arrList.get(0),true);
					if(allServersOfCurrentNick != null && allServersOfCurrentNick.size()>0)
					{
						if(associatedCompTypes.size()==1)
						{
							for(int j=0;j<allServersOfCurrentNick.size();j++)
							{
								String server = (String) allServersOfCurrentNick.get(j);
								if(server.startsWith((memCompType+":")) && memberList.contains(server))
								{
									rightServer = server;
									rightMemberElement = rightServer;
									break;
								}
							}
						}
						else
						{
							for(int j=0;j<allServersOfCurrentNick.size();j++)
							{
								String server = (String) allServersOfCurrentNick.get(j);
								String temp_server_type = server.substring(0,server.indexOf(":"));
								if(associatedCompTypes.contains(temp_server_type) && memberList.contains(server))
								{
									rightServer = server;
									rightMemberElement = rightServer;
									break;
								}
							}
						}
					}
				}
				else
				{
					rightMemberElement = memCompType+":"+memberElement;
				}
				if(!memberList.contains(rightMemberElement))
					continue;

				if(dontShowCompInfo.containsKey(memberElement))
				{
					ArrayList alist = (ArrayList) dontShowCompInfo.get(memberElement);
					if(alist.contains(infoElement))
					{
						//this descriptor is excluded from this aggregate component for the member component (memName)
						//through INCLUDED/EXCLUDE DESCRIPTORS page
						continue;
					}
				}
				if(aggDescriptor.equals("false") && !info.equals("+") && !infoElement.equalsIgnoreCase(info))
				{
					continue;
				}
				mesValue = mesValue +"|" + popup_time;
				String memAndMsmtHostName = memberElement+"~"+memberMsmtHost;//+"~"+infoElement;
				if(memNameInfoHt.containsKey(memAndMsmtHostName))
				{
					AuditLogHashtable infoMeasureHt = (AuditLogHashtable)memNameInfoHt.get(memAndMsmtHostName);
					if(infoMeasureHt.containsKey(infoElement))
					{
						ArrayList mvlist = (ArrayList)infoMeasureHt.get(infoElement);
						mvlist.add(mesValue);
					}
					else
					{
						ArrayList mvlist = new ArrayList();
						mvlist.add(mesValue);
						infoMeasureHt.put(infoElement,mvlist);
					}
				}
				else
				{
					ArrayList mvlist = new ArrayList();
					mvlist.add(mesValue);
					AuditLogHashtable infoMeasureHt = new AuditLogHashtable();
					infoMeasureHt.put(infoElement,mvlist);
					memNameInfoHt.put(memAndMsmtHostName,infoMeasureHt);
				}
				infoSet.add(infoElement);
				validDBTableRows.add(listElement);
			}
			boolean isMainTestDescBased = !infoSet.contains("+")?true:false;
			boolean showInfoColumn = !infoSet.contains("+")?true:false;
			int colSpan = showInfoColumn?0:1;
			String title = dispAggMeasure;
			String tooltip = null;
			if(functionUsed.equalsIgnoreCase("avg"))
			{
				tooltip = "Average of all measures";
			}
			else if(functionUsed.equalsIgnoreCase("avg_sum"))
			{
				tooltip = mapObj.getTextDescription("monitor.aggregates.Averages the number of measures for the test frequency and sums with the other component");
			}
			else if(functionUsed.equalsIgnoreCase("max"))
			{
				tooltip = mapObj.getTextDescription("monitor.aggregates.Maximum of all measures");
			}
			else if(functionUsed.equalsIgnoreCase("min"))
			{
				tooltip = mapObj.getTextDescription("monitor.aggregates.Minimum of all measures");
			}
			else if(functionUsed.equalsIgnoreCase("sum"))
			{
				tooltip = mapObj.getTextDescription("monitor.aggregates.Sum of all measures");
			}
			else if(functionUsed.equalsIgnoreCase("condition"))
			{
				tooltip = mapObj.getTextDescription("monitor.aggregates.Metrics calculation is based on single condition");
			}
			else if(functionUsed.equalsIgnoreCase("multi_condition"))
			{
				tooltip = mapObj.getTextDescription("monitor.aggregates.Metrics calculation is based on multiple conditions");
			}
			if(showInfoColumn && info!=null && info.equalsIgnoreCase("+"))
			{
				json.put("show_info_details","true");
				json.put("showViolatedDescriptors",showViolatedDescriptors);
			}
			else
			{
				json.put("show_info_details","false");
			}
			json.put("isMainTestDescBased",String.valueOf(isMainTestDescBased));
			if(info.equals("+"))
			{
				json.put("infoLine1",mapObj.getTextDescription("monitor.aggregates.The Aggregate Measure")+" <b>"+dispAggMeasure+"</b> "+mapObj.getTextDescription("monitor.aggregates.was computed to be")+" <b>"+request.getParameter("measure_value")+"</b> "+mapObj.getTextDescription("monitor.aggregates.using the aggregate function")+" <b>"+displayFunctionName+"</b> "+"<img src='/final/images/spacer.gif' width='32px' height='16px' class='sym_"+functionUsed+"_bracket' title='"+tooltip+"'>.");

				json.put("infoLine2","<br>"+mapObj.getTextDescription("monitor.aggregates.This value has been derived from the following individual metrics"));
			}
			else
			{
				String shownInfo = info;
				json.put("infoLine1",mapObj.getTextDescription("monitor.aggregates.The Aggregate Measure")+" <b>"+dispAggMeasure+"</b> "+mapObj.getTextDescription("monitor.aggregates.was computed for the descriptor")+" <b>"+shownInfo+"</b> "+mapObj.getTextDescription("monitor.aggregates.to be")+" <b>"+request.getParameter("measure_value")+"</b> "+mapObj.getTextDescription("monitor.aggregates.using the aggregate function")+" <b>"+displayFunctionName+"</b> "+"<img src='/final/images/spacer.gif' width='32px' height='16px' class='sym_"+functionUsed+"_bracket' title='"+tooltip+"'>.");

				json.put("infoLine2","<br>"+mapObj.getTextDescription("monitor.aggregates.This value has been derived from the following individual metrics"));
			}

			if(functionUsed.toLowerCase().equals("condition"))
			{
				json.put("condition","true");
				json.put("multi_condition","false");
			}
			else if(functionUsed.toLowerCase().equals("multi_condition"))
			{
				json.put("condition","false");
				json.put("multi_condition","true");
			}
			aggregateTable.append("<div class='plainTable'><table width='100%' cellspacing='0' cellpadding='0' border='0' >");
			aggregateTable.append("<thead><tr>");

			int sortingIndex = -1;
			aggregateTable.append("<th align='center' style='width:250px' height='20px'>"+mapObj.getTextDescription("monitor.aggregates.Component Name")+"</th>");
			if(showInfoColumn)
			{
				++sortingIndex;
				if(info!=null && info.equalsIgnoreCase("+"))
				{
					aggregateTable.append("<th align='center' style='width:170px'>"+mapObj.getTextDescription("monitor.aggregates.Descriptor")+"</th>");
				}
			}
			if(info!=null && info.equalsIgnoreCase("+"))
			{
				if(functionUsed.toLowerCase().indexOf("condition")==-1)
				{
					aggregateTable.append("<th height='20px' align='center'>"+displayFunctionName1 + "&nbsp;of&nbsp;"+desc_for_table+"</th>");
				}
				else
				{
					if(functionUsed.toLowerCase().equals("multi_condition"))
					{
						aggregateTable.append("<th height='20px' align='center'>Average&nbsp;of&nbsp;"+desc_for_table+"</th><th align='center'>Violated</th><th align='center'>Violation Type</th>");
					}
					else
					{
						aggregateTable.append("<th height='20px' align='center'>Average&nbsp;of&nbsp;"+desc_for_table+"</th><th align='center'>Violated</th>");
					}
				}
			}
			else
			{
				if(functionUsed.toLowerCase().indexOf("condition")==-1)
				{
					aggregateTable.append("<th height='20px' align='center'>"+displayFunctionName1 + "&nbsp;of&nbsp;"+desc_for_table+"</th>");
				}
				else
				{
					if(functionUsed.toLowerCase().equals("multi_condition"))
					{
						aggregateTable.append("<th height='20px' align='center'>Average&nbsp;of&nbsp;"+desc_for_table+"</th><th align='center'>Violated</th><th align='center'>Violation Type</th>");
					}
					else
					{
						aggregateTable.append("<th height='20px' align='center'>Average&nbsp;of&nbsp;"+desc_for_table+"</th><th align='center'>Violated</th>");
					}
				}
			}
			aggregateTable.append("</tr></thead>");
			aggregateTable.append("<tbody id='rsTable'>");
			String only_table_heading = aggregateTable.toString();
			Hashtable associated_compHt = new Hashtable();
			for(int k=0;k<memberList.size();k++)
			{
				String comp = (String) memberList.get(k);
				String arr[] = StringUtils.getTokens(comp,":");
				ArrayList alist = new ArrayList(Arrays.asList(arr));
				associated_compHt.put((arr[0]+":"+arr[1]),alist);
			}

			ArrayList tmpList = new ArrayList();
			tmpList.addAll(memNameInfoHt.keySet());
			Collections.sort(tmpList,String.CASE_INSENSITIVE_ORDER);
			Iterator displayItr = tmpList.iterator();
			while(displayItr.hasNext())
			{
				String str = (String)displayItr.next();
				String memName = str.substring(0,str.indexOf("~"));
				String memName_copy = memName;
				String memberPort = StringUtils.getTokens(memName,":")[1];
				String infoName = str.substring(str.lastIndexOf("~")+1);
				String memMeasureHost = str.substring(str.indexOf("~")+1);
				String memberState = stateDao.getComponentPriority(siteName, memName.substring(0,memName.indexOf(":"))+":NULL", memCompType);

				double trgt_violated_val = -1;
				boolean nextCompRowsNotStarted = true;
				AuditLogHashtable htinfo = (AuditLogHashtable)memNameInfoHt.get(str);
				int thisCompRows = htinfo.size();
				int displayedRows = 0;
				Iterator infoItr = htinfo.iterator();
				while(infoItr.hasNext())
				{
					String mvinfo = (String)infoItr.next();
					infoName = mvinfo;
					ArrayList s_mvlist = new ArrayList();
					ArrayList mvlist = (ArrayList)htinfo.get(mvinfo);
					StringBuffer mesValBuffer = new StringBuffer();
					double function = 0.0;
					int divideCount =0;
					double max_value = 0.0;
					double min_value = -1;
					for(int i=0;i<mvlist.size();i++)
					{
						String valStr = (String)mvlist.get(i);
						int idx = valStr.indexOf("|");
						String time = valStr.substring(idx+1);
						valStr = valStr.substring(0,idx);
						double value = Double.parseDouble(valStr);
						if(value>=0)
						{
							s_mvlist.add(valStr);
							mesValBuffer.append(EgDbInfo.formatValue(value));
							if(time.indexOf(".0")>-1)
							{
								time = time.substring(0,time.indexOf("."));
							}
							time = DateUtil.changeDateFormat(time,"yyyy-MM-dd HH:mm:ss",currentDateFormat + " HH:mm:ss");
							time = StringUtils.replace(time,",","#");
							mesValBuffer.append("-");
							mesValBuffer.append(time);
							mesValBuffer.append(",");
							if(functionUsed.equalsIgnoreCase("max"))
							{
								if(max_value<value)
									max_value = value;
							}
							else if(functionUsed.equalsIgnoreCase("min"))
							{
								if(min_value == -1 || min_value>value)
									min_value = value;
							}
							function = function + value;
							divideCount++;
						}
					}
					String displayMesValue="-";
					if(divideCount==0)
					{
						divideCount = 1;
					}
					double average = 0.0;
					if(functionUsed.equalsIgnoreCase("max"))
					{
						average = max_value;
					}
					else if(functionUsed.equalsIgnoreCase("min"))
					{
						if(min_value == -1)
							min_value = 0.0;
						average = min_value;
					}
					else if(functionUsed.equals("sum"))
					{
						average = function;
					}
					else
					{
						average = function / divideCount;
					}
					if(!isConditionBased && measureUnit.equalsIgnoreCase("Number") && average>0)
					{
						// We should show only integer when measure unit is Number
						average = Math.ceil(average);
					}
					String targetViolated = "No";
					String violationType = "Normal";
					if(isConditionBased)
					{
						if(displayTargetValue.indexOf("/")>0)
						{
							if(targetOperation.equalsIgnoreCase(">"))
							{
								if(criticalCheck>-1 && average>criticalCheck)
								{
									targetViolated = "Yes";
									violationType = "Critical";
								}
								else if(majorCheck>-1 && average>majorCheck)
								{
									targetViolated = "Yes";
									violationType = "Major";
								}
								else if(minorCheck>-1 && average>minorCheck)
								{
									targetViolated = "Yes";
									violationType = "Minor";
								}
							}
							else if(targetOperation.equalsIgnoreCase("<"))
							{
								if(criticalCheck>-1 && average<criticalCheck)
								{
									targetViolated = "Yes";
									violationType = "Critical";
								}
								else if(majorCheck>-1 && average<majorCheck)
								{
									targetViolated = "Yes";
									violationType = "Major";
								}
								else if(minorCheck>-1 && average<minorCheck)
								{
									targetViolated = "Yes";
									violationType = "Minor";
								}
							}
							else if(targetOperation.equalsIgnoreCase(">="))
							{
								if(criticalCheck>-1 && average>=criticalCheck)
								{
									targetViolated = "Yes";
									violationType = "Critical";
								}
								else if(majorCheck>-1 && average>=majorCheck)
								{
									targetViolated = "Yes";
									violationType = "Major";
								}
								else if(minorCheck>-1 && average>=minorCheck)
								{
									targetViolated = "Yes";
									violationType = "Minor";
								}
							}
							else if(targetOperation.equalsIgnoreCase("<="))
							{
								if(criticalCheck>-1 && average<=criticalCheck)
								{
									targetViolated = "Yes";
									violationType = "Critical";
								}
								else if(majorCheck>-1 && average<=majorCheck)
								{
									targetViolated = "Yes";
									violationType = "Major";
								}
								else if(minorCheck>-1 && average<=minorCheck)
								{
									targetViolated = "Yes";
									violationType = "Minor";
								}
							}
							else if(targetOperation.equalsIgnoreCase("="))
							{
								if(criticalCheck>-1 && average==criticalCheck)
								{
									targetViolated = "Yes";
									violationType = "Critical";
								}
								else if(majorCheck>-1 && average==majorCheck)
								{
									targetViolated = "Yes";
									violationType = "Major";
								}
								else if(minorCheck>-1 && average==minorCheck)
								{
									targetViolated = "Yes";
									violationType = "Minor";
								}
							}
						}
						else
						{
							if(targetOperation.equalsIgnoreCase(">") && (average>targetValue))
							{
								targetViolated = "Yes";
							}
							else if(targetOperation.equalsIgnoreCase("<") && (average<targetValue))
							{
								targetViolated = "Yes";
							}
							else if(targetOperation.equalsIgnoreCase(">=") && (average>=targetValue))
							{
								targetViolated = "Yes";
							}
							else if(targetOperation.equalsIgnoreCase("<=") && (average<=targetValue))
							{
								targetViolated = "Yes";
							}
							else if(targetOperation.equalsIgnoreCase("=") && (average==targetValue))
							{
								targetViolated = "Yes";
							}
						}
					}
					if(showViolatedDescriptors.equalsIgnoreCase("Yes") && targetViolated.equalsIgnoreCase("No"))
					{
						continue;
					}
					String avgStr = EgDbInfo.formatValue(average);
					if(mesValBuffer.length()>0)
					{
						displayMesValue = mesValBuffer.substring(0,mesValBuffer.length()-1);
					}
					else
					{
						avgStr="-";
					}

					aggregateTable.append("<tr>");

					if((displayedRows+1) == thisCompRows)
					{
						aggregateTable.append("<td colspan='"+colSpan+"' style='width:200px;padding:0px'>");
					}
					else
					{
						aggregateTable.append("<td colspan='"+colSpan+"' style='width:200px;padding:0px'>");
					}
					displayedRows++;
					if(nextCompRowsNotStarted)
					{
						nextCompRowsNotStarted = false;
						String hostName_lm = memName;
						ArrayList compDetail = (ArrayList)associated_compHt.get(memCompType+":"+memName);
						if(compDetail != null && compDetail.size()>0)
						{
							if(memCompType.startsWith("Oracle_server"))
							{
								hostName_lm = (String)compDetail.get(1)+":"+(String)compDetail.get(2) + ":"+ (String) compDetail.get(3);
							}
							else
							{
								hostName_lm = (String)compDetail.get(1)+":"+(String)compDetail.get(2);
							}
						}
						String shownMemberName = memName;
						if(memName.endsWith(":NULL"))
						{
							shownMemberName = memName.substring(0,memName.indexOf(":"));
						}
						if(showExtAgentsFor != null && showExtAgentsFor.contains(memName.substring(0,memName.indexOf(":"))))
						{
							shownMemberName = shownMemberName + " (" + memMeasureHost +")";
						}
						String displayMemberName = shownMemberName;
						if(showInfoColumn)
						{
							if(displayMemberName.length() >30)
							{
								displayMemberName = displayMemberName.toUpperCase().substring(0,30)+"...";
							}
						}
						else
						{
							if(displayMemberName.length() >40)
							{
								displayMemberName = displayMemberName.toUpperCase().substring(0,40)+"...";
							}
						}

						//aggregateTable.append("<div style='float:left;padding:4px 4px 0px 10px;width:30px'><img src= 'data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==' class='state_"+memberState+"' border='0' title='"+iniUi.getStateDisplayLabel(memberState)+"'></div> ");
						
						//aggregateTable.append("<div style='float:left;padding:4px 4px 0px 4px'><a class='eg_monlink' href='javascript:void(0)' onclick='component_layer_model_page(\""+siteName+"\",\""+memCompType+"\",\""+hostName_lm+"\")'>"+displayMemberName+"</a></div");

						aggregateTable.append("<div style='float:left;padding:4px 4px 0px 10px'><a class='eg_monlink' href='javascript:void(0)' onclick='component_layer_model_page(\""+siteName+"\",\""+memCompType+"\",\""+hostName_lm+"\")'>"+displayMemberName+"</a></div");
					}
					else
					{
						aggregateTable.append("&nbsp;");
					}
					aggregateTable.append("</td>");

					if(showInfoColumn)
					{
						String shownInfo = infoName;
						if(shownInfo.length() >24)
						{
							shownInfo = shownInfo.substring(0,21)+"...";
						}
						if(info!=null && info.equalsIgnoreCase("+"))
						{
							table_rows_found=true;
							aggregateTable.append("<td style='width:120px;' title='"+infoName+"'>");
							aggregateTable.append(shownInfo);
							aggregateTable.append("</td>");
						}
						String selectedDesc = request.getParameter("sinfo");
						String selectedDescMeasure = request.getParameter("measure_value");
						if(info!=null && info.equalsIgnoreCase("+"))
						{
							if(functionUsed.toLowerCase().indexOf("condition")==-1)
							{
								aggregateTable.append("<td style='width:120px;'><a class='mouse' onmouseover='javascript:showAlert(event,\""+displayMesValue+"From :"+s_from+"To :"+s_to+"\",\""+m_desc+"\")' onmouseout='javascript:removeAlert()'>"+avgStr+"</a></td>");
							}
							else
							{
								if(functionUsed.toLowerCase().equals("multi_condition"))
								{
									aggregateTable.append("<td style='width:120px;' ><a class='mouse' onmouseover='javascript:showAlert(event,\""+displayMesValue+"From :"+s_from+"To :"+s_to+"\",\""+m_desc+"\")' onmouseout='javascript:removeAlert()'>"+avgStr+"</a></td><td style='width:120px;'>"+targetViolated+"</td><td style='width:120px;'>"+violationType+"</td>");
								}
								else
								{
									aggregateTable.append("<td style='width:120px;' ><a class='mouse' onmouseover='javascript:showAlert(event,\""+displayMesValue+"From :"+s_from+"To :"+s_to+"\",\""+m_desc+"\")' onmouseout='javascript:removeAlert()'>"+avgStr+"</a></td><td style='width:120px;'>"+targetViolated+"</td>");
								}
							}
						}
						else
						{
							if(functionUsed.toLowerCase().indexOf("condition")==-1)
							{
								aggregateTable.append("<td style='width:120px;'><a class='mouse' onmouseover='javascript:showAlert(event,\""+displayMesValue+"From :"+s_from+"To :"+s_to+"\",\""+m_desc+"\")' onmouseout='javascript:removeAlert()'>"+avgStr+"</a></td>");
							}
							else
							{
								if(functionUsed.toLowerCase().equals("multi_condition"))
								{
									aggregateTable.append("<td style='width:120px;'><a class='mouse' onmouseover='javascript:showAlert(event,\""+displayMesValue+"From :"+s_from+"To :"+s_to+"\",\""+m_desc+"\")' onmouseout='javascript:removeAlert()'>"+avgStr+"</a></td><td style='width:120px;'>"+targetViolated+"</td><td style='width:120px;'>"+violationType+"</td>");
								}
								else
								{
									aggregateTable.append("<td style='width:120px;'><a class='mouse' onmouseover='javascript:showAlert(event,\""+displayMesValue+"From :"+s_from+"To :"+s_to+"\",\""+m_desc+"\")' onmouseout='javascript:removeAlert()'>"+avgStr+"</a></td><td style='width:120px;'>"+targetViolated+"</td>");
								}
							}
							break;
						}
					}
					else
					{
						if(functionUsed.toLowerCase().indexOf("condition")==-1)
						{
							aggregateTable.append("<td style='width:120px;'><a class='mouse' onmouseover='javascript:showAlert(event,\""+displayMesValue+"From :"+s_from+"To :"+s_to+"\",\""+m_desc+"\")' onmouseout='javascript:removeAlert()'>"+avgStr+"</a></td>");
						}
						else
						{
							if(functionUsed.toLowerCase().equals("multi_condition"))
							{
								aggregateTable.append("<td style='width:120px;' ><a class='mouse' onmouseover='javascript:showAlert(event,\""+displayMesValue+"From :"+s_from+"To :"+s_to+"\",\""+m_desc+"\")' onmouseout='javascript:removeAlert()'>"+avgStr+"</a></td><td style='width:120px;'>"+targetViolated+"</td><td style='width:120px;'>"+violationType+"</td>");
							}
							else
							{
								aggregateTable.append("<td style='width:120px;' ><a class='mouse' onmouseover='javascript:showAlert(event,\""+displayMesValue+"From :"+s_from+"To :"+s_to+"\",\""+m_desc+"\")' onmouseout='javascript:removeAlert()'>"+avgStr+"</a></td><td style='width:120px;'>"+targetViolated+"</td>");
							}
						}
					}
					aggregateTable.append("</tr>");
				}
			}
			if(!table_rows_found && showViolatedDescriptors.equalsIgnoreCase("Yes") && (functionUsed.equalsIgnoreCase("condition") || functionUsed.equalsIgnoreCase("multi_condition")))
			{
				aggregateTable.setLength(0);
				aggregateTable.append(only_table_heading);
				aggregateTable.append("<tr>");
				if(functionUsed.equalsIgnoreCase("multi_condition"))
				{
					//colspan is 5
					aggregateTable.append("<td colspan='5' style='width:400px;height:100px' align='center' valign='middle' class='font_bold11'><div class='iconExclamation'></div>No violated descriptors found.</td></tr>");
				}
				else
				{
					 //colspan is 4
					aggregateTable.append("<td colspan='4' style='width:400px;height:100px' align='center' valign='middle' class='font_bold11'><div class='iconExclamation'></div>No violated descriptors found.</td></tr>");
				}
			}
			aggregateTable.append("</tbody>");
			aggregateTable.append("</table></div>");
		}
	}

	json.put("screenLabels",screenLabels);
	json.put("error",error);
	json.put("aggregateTable",aggregateTable.toString());
	response.getWriter().write(json.toString());
%>