<%
/********************************************************************************
		Name				:	TransitionDistribution.jsp
 *		Version				:	5.0
 *		CreationDate		:	9/03/2010
 *		Author				:	Nehru.C
**********************************************************************************/
%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page import="java.util.*"%>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import="egurkha.reporter.ErUtils"%>
<%@ page import="com.egurkha.monitor.EgFusionChartUtil"%>
<%@ page import="net.sf.json.*"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.egurkha.UserRegistry" %>
<%@ page import = "com.egurkha.User"%>
<%@ page import="com.egurkha.ini.*" %>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setContentType("application/json");
	response.setDateHeader("Expires", -1);
try
{
	
	JSONObject json  = new JSONObject();
	
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	String thisLanguage="";
	try
	{
		com.egurkha.ini.IniUI ui = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
		thisLanguage = ui.getDefaultLanguage();
		if (user!=null)
		{
			String userLang = user.getLanguage();
			if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
			{
				thisLanguage=userLang;
			}
		}
	}
	catch(Exception e)
	{
		System.out.println(e);
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	
	String split = request.getParameter("split");
	ArrayList transitionList = new ArrayList();
	//EgFusionChartUtil fusionChart=new EgFusionChartUtil(trackerLanguage);
	ErUtils  erutils=new  ErUtils();
	if(split != null && !split.equals(""))
	{
		StringTokenizer st = new StringTokenizer(split,",");
		while(st.hasMoreTokens())
		{
			transitionList.add(st.nextToken());
		}

		Double critical=new Double(Double.parseDouble((String)transitionList.get(1)));
		Double major=new Double(Double.parseDouble((String)transitionList.get(2)));
		Double minor=new Double(Double.parseDouble((String)transitionList.get(3)));
		
		Double total = new Double(critical.doubleValue()+major.doubleValue()+minor.doubleValue());
		Double criticalPct= new Double((critical.doubleValue()/total.doubleValue())*100);
		Double majorPct = new Double((major.doubleValue()/total.doubleValue())*100);
		Double minorPct = new Double((minor.doubleValue()/total.doubleValue())*100);
		String roundCritical = erutils.round(criticalPct.doubleValue(),2);
		String roundMajor	=	erutils.round(majorPct.doubleValue(),2);
		String roundMinor	=	erutils.round(minorPct.doubleValue(),2);
		
		Vector pieChartAttributes=new Vector();
		pieChartAttributes.add("palette='3'");
		pieChartAttributes.add("decimals='2'");
		pieChartAttributes.add("enableRotation='0'");
		pieChartAttributes.add("bgColor='99CCFF,FFFFFF'");
		pieChartAttributes.add("bgAlpha='0,0'");
		pieChartAttributes.add("bgRatio='0,100'");
		pieChartAttributes.add("bgAngle='360'");
		pieChartAttributes.add("showBorder='0'");
		pieChartAttributes.add("startingAngle='70'");
		pieChartAttributes.add("baseFontColor ='545454'");
		pieChartAttributes.add("chartLeftMargin ='0'");
		pieChartAttributes.add("chartTopMargin ='0'");
		pieChartAttributes.add("chartBottomMargin ='0'");
		pieChartAttributes.add("chartRightMargin ='0'");
		pieChartAttributes.add("showToolTipShadow ='1'");
		pieChartAttributes.add("pieSliceDepth='7'");
		//pieChartAttributes.add("numberSuffix='%25'");
		pieChartAttributes.add("numberSuffix='%'");
		//pieChartAttributes.add("showToolTipShadow ='1'");
		pieChartAttributes.add("pieOuterFaceAlpha  ='75'");
		pieChartAttributes.add("pieYScale  ='60'");
		pieChartAttributes.add("smartLineColor  ='000000'");
		pieChartAttributes.add("smartLabelClearance  ='2'");
		pieChartAttributes.add("captionPadding  ='0'");
		pieChartAttributes.add("bgSWFAlpha  ='0'");
		pieChartAttributes.add("enableSmartLabels='1'");
		pieChartAttributes.add("pieRadius='45'");
		pieChartAttributes.add("labelDistance='8'");
		pieChartAttributes.add("isSmartLineSlanted='1'");
		pieChartAttributes.add("exportEnabled='0'");
		pieChartAttributes.add("exportAction='download'");
		pieChartAttributes.add("exportAtClient='0'");
		pieChartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");

		StringBuffer xmlData=new StringBuffer("<chart");

		if(pieChartAttributes!=null && pieChartAttributes.size()>0)
		{
			Iterator itr=pieChartAttributes.iterator();
			while(itr.hasNext())
			{
				xmlData.append(" ");
				xmlData.append((String)itr.next());
			}
		}
		xmlData.append(">");
		if(criticalPct.doubleValue()>0.0)
			xmlData.append("<set value='"+roundCritical+"' toolText='Critical("+roundCritical+")' color='cd0f0f'/>");
		if(majorPct.doubleValue()>0.0)
			xmlData.append("<set value='"+roundMajor+"' toolText='Major("+roundMajor+")' color='fa9d1c'/>");
		if(minorPct.doubleValue()>0.0)
			xmlData.append("<set value='"+roundMinor+"' toolText='Minor("+roundMinor+")' color='ccc100'/>");
	
		xmlData.append("</chart>");

		JSONObject labelObj= new JSONObject();
		labelObj.put("monitor.home.Transitions distribution",mappingInfo.getTextDescription("monitor.home.Transitions distribution"));
		
		json.put("screenLabels",labelObj);
		
		
		if(criticalPct.doubleValue()>0 || majorPct.doubleValue()>0 || minorPct.doubleValue()>0)
		{
			json.put("chartXml",xmlData.toString());
		}
		else
		{
			json.put("error",mappingInfo.getTextDescription("monitor.dashboard.No closed transitions available!"));
		}
		response.getWriter().write(json.toString());
}
	
}
catch(Exception x)
{
	x.printStackTrace();
}


%>