<%
/*******************************************************************************
*	File name		: MsSqlSysProcesses.jsp
*	Purpose			: To show the Sql & Sybase sysprocesses along with its details
*	Version			: eG 5.3.
*	Creation Date	: 15/03/2011
*	Modifed			: 15/07/2011	- Support Sybase sysprocess
*	Modifed			: 10/08/2011	- To Provide Support for Oracle Sessions & Oracle User connections
******************************************************************************/
%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ include file = "EgLoginTracker.jsp" %>
<%@ page errorPage = "EgProbsM.jsp" %>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.util.EgSorter" %>
<%@ page import = "com.egurkha.ini.IniUI" %>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.egurkha.util.DateTimeTokenizer" %>
<%@ page import = "java.text.SimpleDateFormat"%>
<%@ page import = "com.eg.EgDbInfo" %>
<%@ page import = "java.util.*" %>
<%@ page session = "true" %>
<%@ page import = "com.eg.EgSpecsInfo" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	public ArrayList arrayListSort(ArrayList arrList, int cols, int totalCols , String testName )
	{
		ArrayList result = new ArrayList();
		if (arrList==null || arrList.size()==0)
			return result;

		ArrayList dataTypeList = new ArrayList();
		dataTypeList.add("ZERO");
		if(testName.equals("SybSysProcessTest"))
		{
			dataTypeList.add("Long#asc");		//spid
			for(int k=0;k<5;k++){
				dataTypeList.add("String#asc"); //status , user , db , hostname , program_name
			}
			for(int k=0;k<5;k++){
				dataTypeList.add("Long#asc");	//blocking_spid , time_blocked, cpu(ticks) , physical_io, memusage
			}
			dataTypeList.add("String#asc");		//command
		}
		else if(testName.equals("MsSqlSysProcsTest") || testName.equals("MsSqlConnsTest"))
		{
			dataTypeList.add("Long#asc");		//SPID
			int times = 6;
			if(totalCols == 14) times = 5; 
			for(int k=0;k<times;k++){
				dataTypeList.add("String#asc");	//[User],DB,HOST,Program_Name,Login_Name,Last Execution
			}
			dataTypeList.add("Long#desc");		//Waittime
			dataTypeList.add("String#asc");		//Waittype
			dataTypeList.add("Long#asc");		//SPID Blocking
			for(int k=0;k<4;k++){
				dataTypeList.add("Long#desc");	//Trans, Physical_io, Mem_usage, Sleeptime
			}
			dataTypeList.add("String#asc");		//Last command
		}
		else if(testName.equals("OraSessionTest") || testName.equals("OraConnectionsTest"))
		{
			dataTypeList.add("Long#asc");
			dataTypeList.add("Long#asc");
			int times = 6;
			if(testName.equals("OraConnectionsTest"))
				times = 5;
			for(int k=0;k<times;k++){
				dataTypeList.add("String#asc");
			}
			dataTypeList.add("Long#asc");
			dataTypeList.add("String#asc");
			dataTypeList.add("String#asc");
		}

		if(dataTypeList.size() == 1)
			return result;

		String requiredType = (String) dataTypeList.get(cols);
		String colType = requiredType.substring(0,requiredType.indexOf("#"));
		String order =requiredType.substring(requiredType.indexOf("#")+1);

		EgSorter egSort = new EgSorter(arrList,totalCols);
		ArrayList sortList = (ArrayList)egSort.sort(cols,colType,order);
		return sortList;
	}
%>
<html>
<head>
<title>MsSql Sys Processes</title>
<egui:skin ui="monitor"/>
<style>
select {
    padding:3px;
    margin: 0;
    -webkit-border-radius:0px;
    -moz-border-radius:0px;
    border-radius:0px;
    /*-webkit-box-shadow: 0 3px 0 #ccc, 0 -1px #fff inset;
    -moz-box-shadow: 0 3px 0 #ccc, 0 -1px #fff inset;
    box-shadow: 0 3px 0 #ccc, 0 -1px #fff inset;*/
    background: #fff;
	background:url("/final/images/Light/form_input_buttons.png") no-repeat scroll 165px 1px #fff !important;
    color:#000;
    border-color:#abb2bd;
	border-style:solid;
	border-width:1px 1px 1px 1px;
    display: inline-block;
    -webkit-appearance:none;
    -moz-appearance:none;
    appearance:none;
    cursor:pointer;
	position: relative; 

	&:focus {
    z-index: 3;
    width: 100%;
    color: red;
    outline: 2px solid #49aff2;
    outline: 2px solid -webkit-focus-ring-color;
    outline-offset: -2px;
  }
	> option {
    margin: 3px;
    padding: 6px 8px;
    text-shadow: none;
    background: red;
    border-radius: 3px;
    cursor: pointer;
  }
}

/* Targetting Webkit browsers only. FF will show the dropdown arrow with so much padding. */
@media screen and (-webkit-min-device-pixel-ratio:0) {
    select {padding-right:18px}
}

label {position:relative;padding:2px}
label:after {
    content:'<>';
    font:11px "LucidaGrandeRegular";
    color:#aaa;
    -webkit-transform:rotate(90deg);
    -moz-transform:rotate(90deg);
    -ms-transform:rotate(90deg);
    transform:rotate(90deg);
    right:8px; top:2px;
    padding:0 0 2px;
    border-bottom:1px solid #ddd;
    position:absolute;
    pointer-events:none;
}
label:before {
    content:'';
    right:6px; top:0px;
    width:20px; height:20px;
    background:#f8f8f8;
	padding:2px 0 0,
    position:absolute;
    pointer-events:none;
    display:block;
}
select::-ms-expand {
    display: none; /* hide default arrow in IE10 */
}

.option{

	padding:2px;
	height:20px;
	background:green

}
option[selected="selected"] {
    /*css style here*/
	padding:2px;
	height:20px;
	background:red
}
	.jtm_DatapanelBody .jtm_Table td div{display:table-row;word-wrap:break-word !important;width:auto !important}
</style>
<script type="text/javascript" src="/final/monitor/eg_scripts/eg_aggregate.js"></script>
</head>
<script type="text/javascript">

	function showDetails(value)
	{
		var measureTime=document.getElementById("time").value;
		var testname=document.getElementById("testname").value;
		if(value == "None")
		{
			fillTabs('div_scroll','<%=response.encodeURL("../monitor/sqlProcess.jsp?")%>'+"details=None");
		}
		else
		{
			var mesValue = document.getElementById("measurename").value;
			fillTabs('div_scroll','<%=response.encodeURL("../monitor/sqlProcess.jsp?")%>'+"&details="+encodeURIComponent(value)+"&time="+encodeURIComponent(measureTime)+"&measure="+encodeURIComponent(mesValue)+"&test="+encodeURIComponent(testname));
		}
		hideDivs('linkDiv');
	}

	function reloadUrl(url,mesValue,sortValue,measureTime)
	{
		var fdate=ThreadForm.fdate.value;
		if(mesValue==null)
			mesValue = document.getElementById("measurename").value;
		if(sortValue==null)
			sortValue = document.getElementById("sortname").value;
		if(measureTime==null)
			measureTime=document.getElementById("time").value;

		url=url+"&s_measure="+mesValue+"&sortby="+sortValue+"&time="+measureTime;
		if(fdate!=null)
			url = url + "&filterdate="+fdate;
		window.location.href=url;
	}

	function hideDivs(divId)
	{
		var show_div = document.getElementById(divId);
		if(show_div!=null)
		{
			show_div.style.display="none";
		}
	}

	function showThreadDetails(details,measuretime,measurename,testname)
	{
		var divId = "linkDiv";
		var linkDiv = document.getElementById(divId);
		var title = "Blocking process details";
		var popup_topright= (navigator.appVersion.toLowerCase().indexOf("msie 6.0"))==-1?"popup_topright":"popup_topright_noshade";
		var popup_rightbg = (navigator.appVersion.toLowerCase().indexOf("msie 6.0"))==-1?"popup_rightbg":"popup_rightbg_noshade";
		var popup_bottomleft = (navigator.appVersion.toLowerCase().indexOf("msie 6.0"))==-1?"popup_bottomleft":"popup_bottomleft_noshade";
		var popup_bottombg = (navigator.appVersion.toLowerCase().indexOf("msie 6.0"))==-1?"popup_bottombg":"popup_bottombg_noshade";
		var popup_bottomright = (navigator.appVersion.toLowerCase().indexOf("msie 6.0"))==-1?"popup_bottomright":"popup_bottomright_noshade";

		if(linkDiv!=null)
		{
			var str='<table border="0" bordercolor="blue" cellpadding="0" cellspacing="0" >';
					str+='<tr>';
						str+='<td colspan="3" width="100%" onmousedown="dragOBJ(linkDiv,event); return false;">';
							str+='<table border="0"  cellpadding="0" cellspacing="0" width="98%"  class="jtm_InnerHeader">';
								str+='<tr>';
									//str+='<td width="10" height="27" class="popup_topleft"><img src="/final/monitor/eg_images/spacer.gif" width="10" height="27" border="0"></td>';
									str+='<td id="GraphTitle" style="padding-left:10px" height="27px">'+title+'</td>';
									str+='<td align="right" style="padding-right:10px"><img class="iconClose3" src="/final/images/clear.png" border="0" class="mouse" title="close" vspace="2" onclick="javascript:hideDivs(\''+divId+'\');"> </td>';
									//str+='<td width="17" height="27" class="'+popup_topright+'"><img src="/final/monitor/eg_images/spacer.gif" width="17" height="27" border="0"></td>';
								str+='</tr>';
							str+='</table>';
						str+='</td>';
					str+='</tr>';
					str+='<tr>';
						str+='<td class="popup_leftbg"  width="7px"><img src="/final/monitor/eg_images/spacer.gif" width="7"></td>';
						str+='<td align="center" valign="top" >';
							//str+='<div  class="div_scroll">';
								str+='<table border="0" bordercolor="green" cellpadding="0" cellspacing="0" width="100%" height="100%">';
									str+='<tr>';
										str+='<td class="white_bg">';
											 //str+='<iframe src="'+url+'" width="635" height="250" frameborder="0" leftmargin="0" marginwidth="0" marginheight="0" rightmargin="0"> </iframe>';
											str+='<div class="div_scroll" id="innerDiv"  name="innerDiv" style="left:0px;top:0px;width:660px;overflow-x:hidden;overflow-y:auto;height:270px;border:0px solid #ff0000;padding:4px;"> </div>';
										str+='</td>';
									str+='</tr>';
								str+='</table>';
							//str+='</div>';
						str+='</td>';
						str+='<td class="'+popup_rightbg+'" width="14px"><img src="/final/monitor/eg_images/spacer.gif" width="14"></td>';
					str+='</tr>';
					str+='<tr>';
						str+='<td class="'+popup_bottomleft+'"><img src="/final/monitor/eg_images/spacer.gif" width="7" height="16"></td>';
						str+='<td  class="'+popup_bottombg+'" height="16"><img src="/final/monitor/eg_images/spacer.gif"></td>';
						str+='<td class="'+popup_bottomright+'"><img src="/final/monitor/eg_images/spacer.gif" width="14" height="16"></td>';
					str+='</tr>';
				str+='</table>';
			linkDiv.innerHTML=str;
			showDivs('linkDiv');
			fillTabs('innerDiv','<%=response.encodeURL("../monitor/sqlProcess.jsp?")%>'+"&details="+encodeURIComponent(details)+"&time="+encodeURIComponent(measuretime)+"&measure="+encodeURIComponent(measurename)+"&test="+encodeURIComponent(testname));
		}
	}

	function showDivs(divId)
	{
		var show_div = document.getElementById(divId);
		if(show_div!=null)
		{
			show_div.style.display = 'block';
			show_div.style.position = 'absolute';
			bringToFront(show_div);
		}
	}

	// <-- Dragging the Div -->
	function $(v) 
	{ 
		return(document.getElementById(v)); 
	}

	function agent(v) 
	{ 
		return(Math.max(navigator.userAgent.toLowerCase().indexOf(v),0)); 
	}

	function xy(e,v) 
	{ 
		return(v?(agent('msie')?event.clientY+document.body.scrollTop:e.pageY):(agent('msie')?event.clientX+document.body.scrollTop:e.pageX)); 
	}

	function dragOBJ(d,e) 
	{
		var divId = d.id;
		function drag(e) 
		{ 
			if(!stop) 
			{ 
				tX = xy(e,1)+oY-eY; 
				tY = xy(e)+oX-eX; 
				d.style.top= ((tX <= windowHeight)? tX : windowHeight)+'px';
				d.style.left=((tY <=windowWidth) ? tY : windowWidth)+'px';
			}
		}

		var oX=parseInt(d.style.left),oY=parseInt(d.style.top),eX=xy(e),eY=xy(e,1),tX,tY,stop;
		var windowWidth = document.body.clientWidth;
		var	windowHeight = document.body.clientHeight;

		document.onmousemove=drag; 
		document.onmouseup=function()
		{ 
			stop=1; 
			document.onmousemove=''; 
			document.onmouseup=''; 
			bringToFront(d);
		};
	}
</script>
<body leftmargin="0" topmargin="0" marginheight="0" marginwidth="0" scroll="no" style="overflow:hidden">
<div id="linkDiv" name="linkDiv" class="linesquare" style="display:none;left:125px;top:90px;width:677px;height:306px; position:absolute;background:#fff;overflow-x:hidden;overflow-y:hidden;position:absolute;-webkit-box-shadow:0 10px 10px 0 rgba(100,100,100,0.45);-moz-box-shadow:0 10px 10px 0 rgba(100,100,100,0.45);box-shadow:0 10px 10px 0 rgba(100,100,100,0.45)"></div>

<%
	String ua = request.getHeader( "User-Agent" );
	boolean isFirefox = ( ua != null && ua.indexOf( "Firefox/" ) != -1 );
	boolean isFirefox2 = ( ua != null && ua.indexOf( "Firefox/2" ) != -1 );
	boolean isMSIE6 = ( ua != null && ua.indexOf( "MSIE 6.0" ) != -1 );
	boolean isMSIE7 = ( ua != null && ua.indexOf( "MSIE 7.0" ) != -1 );
	boolean isChrome = ( ua != null && ua.indexOf( "Chrome/" ) != -1 );

try
{
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>
	<jsp:useBean id="trans" scope="page" class="egurkha.TransactionBean" />
	<jsp:useBean id="dd" scope="page" class="com.egurkha.monitor.EgDiagnosisBean" />
<%
	String isTable="";
	isTable = isFirefox ? "Auto" : "Fixed";
	String s_mes = null;
	String s_st_time = "";
	String s_st_hr = "0";
	String s_en_time = "";
	String s_en_hr = "0";
	String s_st_min = "0";
	String s_end_min = "0";
	String s_info=request.getParameter("info");
	String s_first_time = request.getParameter("firsttime");
	String s_flag = request.getParameter("flag");
	String s_site=request.getParameter("site");
	String s_host=request.getParameter("host");
	String s_port=request.getParameter("port");
	String s_test=request.getParameter("test");
	String s_date=request.getParameter("sdate");
	String s_measure=request.getParameter("s_measure");
	String s_msmt_host=request.getParameter("msmt_host");
	String sortOrder=request.getParameter("sortby");
	String filterdate = request.getParameter("filterdate");

	boolean isSqlConnTest = false; 
	boolean isSybaseTest = false;
	boolean isOraSessionTest = false;
	boolean isOraConnectionsTest = false;
	boolean isSqlSysProcessTest = false;
	if(s_test!=null)
	{
		if(s_test.equalsIgnoreCase("MsSqlConnsTest"))
			isSqlConnTest = true;
		else if(s_test.equalsIgnoreCase("SybSysProcessTest"))
			isSybaseTest = true;
		else if(s_test.equalsIgnoreCase("OraSessionTest"))
			isOraSessionTest = true;
		else if(s_test.equalsIgnoreCase("OraConnectionsTest"))
			isOraConnectionsTest = true;
		else
			isSqlSysProcessTest = true;
	}
	if(s_info == null)
		s_info = "NONE";
	
	EgDbInfo dbInfo = new EgDbInfo("manager");
	trans.createFile("eg_format.ini");
	String strValue=trans.getStrValue("DDD_TESTS", s_test);
	String [] colNames = dbInfo.getColumnNamesForTest(s_test+"_DDD");

	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());

	if(s_date!=null && s_date.length() > 0)
	{
		s_st_time=request.getParameter("s_st_time");
		s_en_time=request.getParameter("s_en_time");
		s_st_hr=request.getParameter("s_st_hr");
		s_en_hr=request.getParameter("s_en_hr");
		s_st_min=request.getParameter("s_st_min");
		s_end_min=request.getParameter("s_end_min"); 
	}

	Vector v_measures = new Vector();
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	String comFormat = null;
	String endDateTime ="";
	String startDateTime ="";
	String colNamesForQuery = "";
	String lastMesTime = request.getParameter("time");
	String dummylastMesTime = lastMesTime;
	String s_st_sec="00";

	// Table and cell Width for Browser Compatability
	String wd = "";
	String wdtd = "";
	String divHeight = "";

	ArrayList a_results = new ArrayList();
	if((s_st_time!=null && s_st_time.equals("")) || (s_en_time!=null && s_en_time.equals("")))
	{
		String tempp = currentDateFormat +" HH:mm";

		SimpleDateFormat sdf = new SimpleDateFormat(tempp);
		java.util.Date tmpday = new java.util.Date();
		endDateTime = sdf.format(tmpday);
		java.util.Date startDate2 = new java.util.Date();
		startDate2.setTime(tmpday.getTime() - (3600 * 1000));
		startDateTime = sdf.format(startDate2);

		s_st_time = startDateTime.substring(0,startDateTime.lastIndexOf(" "));
		s_en_time = endDateTime.substring(0,endDateTime.lastIndexOf(" "));

		s_st_hr = startDateTime.substring(startDateTime.lastIndexOf(" ")+1,startDateTime.indexOf(":"));
		s_en_hr = endDateTime.substring(endDateTime.lastIndexOf(" ")+1,endDateTime.indexOf(":"));

		s_st_min = startDateTime.substring(startDateTime.indexOf(":")+1);
		s_end_min = endDateTime.substring(endDateTime.indexOf(":")+1);
	}

	boolean filterDateFlag = false;
	String fdate="";
	if(filterdate!=null && filterdate.length()>4)
	{
		String tmpDate="";
		if(filterdate.indexOf(":")>-1)
		{
			fdate=filterdate.substring(0, filterdate.lastIndexOf(DateTimeTokenizer.BLANK_SPACE));
		}

		int shr = Integer.parseInt(filterdate.substring(filterdate.lastIndexOf(DateTimeTokenizer.BLANK_SPACE)+1, filterdate.indexOf(":")));
		int st_min=Integer.parseInt(filterdate.substring(filterdate.indexOf(":")+1,filterdate.lastIndexOf(":")));
		int st_sec=Integer.parseInt(filterdate.substring(filterdate.lastIndexOf(":")+1));
		s_st_time=filterdate.substring(0, filterdate.indexOf(DateTimeTokenizer.BLANK_SPACE));
		s_st_hr = String.valueOf(shr);
		s_st_min = String.valueOf(st_min);
		s_en_hr=String.valueOf(shr);
		s_st_sec=String.valueOf(st_sec);

		if(!DateUtil.isDate(fdate,"MM/dd/yyyy"))
		{
			fdate = DateUtil.changeDateFormat(fdate,currentDateFormat,"MM/dd/yyyy");
		}
		filterDateFlag=true;
	}

	EgTimeZoneConverter startConverter = new EgTimeZoneConverter(s_st_time+" "+s_st_hr+":"+s_st_min+":00",user,true);
	String ss_st_time = (String)startConverter.getDate(false);
	String ss_st_hr = startConverter.getHour();
	String ss_st_min = startConverter.getMinute();

	EgTimeZoneConverter endConverter = new EgTimeZoneConverter(s_en_time+" "+s_en_hr+":"+s_end_min+":00",user,true);
	String se_en_time = (String)endConverter.getDate(false);
	String ss_en_hr = endConverter.getHour();
	String ss_end_min = endConverter.getMinute();

	if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
		comFormat = "MM/dd/yyyy";
	else
		comFormat = currentDateFormat;

	//String ss_st_time = s_st_time;

	if(!DateUtil.isDate(ss_st_time,"MM/dd/yyyy"))
		ss_st_time = DateUtil.changeDateFormat(ss_st_time,comFormat,"MM/dd/yyyy");
	
	if(DateUtil.isDate(se_en_time,"MM/dd/yyyy"))
		comFormat = "MM/dd/yyyy";
	else
		comFormat = currentDateFormat;

	//String se_en_time = s_en_time;

	if(!DateUtil.isDate(se_en_time,"MM/dd/yyyy"))
		se_en_time = DateUtil.changeDateFormat(se_en_time,comFormat,"MM/dd/yyyy");

	if (!strValue.equals(""))
	{
		if(colNames != null && colNames.length > 0)
		{
			for(int r=0; r<colNames.length; r++)
			{
				colNamesForQuery +=colNames[r] + ",";
			}
			if(colNamesForQuery.endsWith(","))
			{
				colNamesForQuery = colNamesForQuery.substring(0, (colNamesForQuery.length()-1));
			}
		}
	}

	if(s_first_time != null && !s_first_time.equals("") && s_first_time.equals("true"))
	{
		if(s_test != null && !s_test.equals(""))
			v_measures=dd.populateMeasures(s_test);
	}

	s_mes = (String) v_measures.get(0);
	String[] Desc = dd.getDescription(s_test,s_mes);

	if(s_measure!=null && s_measure.length()>0)
	{
		if(filterDateFlag)
		{
			ArrayList al = dd.getDiagnosisDataForDate(s_host, s_port,s_site, s_test, s_measure, s_info, ss_st_time, se_en_time, ss_st_hr, ss_en_hr,ss_st_min,ss_end_min,s_st_sec,s_flag,colNamesForQuery,s_msmt_host,fdate);
			if(al != null && al.size() > 0)
				a_results.addAll(al);
		}
		else
		{
			ArrayList al = dd.getDiagnosisData(s_host, s_port,s_site, s_test, s_measure, s_info, ss_st_time, se_en_time, ss_st_hr, ss_en_hr,ss_st_min+":"+s_st_sec,ss_end_min+":59",s_flag,colNamesForQuery,s_msmt_host);
			if(al != null && al.size() > 0)
				a_results.addAll(al);
		}
	}
	
	Hashtable mappingTable = new Hashtable();
	ArrayList columnList = new ArrayList();

	if(Desc!=null && s_measure!=null)
	{
		String colStr = Desc[0].substring(Desc[0].indexOf(":")+1);
		StringTokenizer st = new StringTokenizer(colStr);
		int count = st.countTokens();
		String[] col = new String[15];
		if(isSqlConnTest)
			col = new String[14];
		else if(isSybaseTest)
			col = new String[12];
		else if(isOraSessionTest)
			col = new String[11];
		else if(isOraConnectionsTest)
			col = new String[10];
		for(int j=0;j<count;j++)
		{
			col[j] = st.nextToken();
			columnList.add(col[j]);
			mappingTable.put(col[j],new Integer(j+1));
		}
	}

	String [] test_array=trans.getVariables("OS_DEPENDENT_DD_TEST");
	ArrayList osDepTestList = new ArrayList();
	if(test_array!=null && test_array.length>0)
		osDepTestList = new ArrayList(Arrays.asList(test_array));

	String s_ct=request.getParameter("comptype");
	String os_name="";
	boolean isOSDepTest=false;
	if(osDepTestList!=null && s_test!=null && osDepTestList.contains(s_test))
	{
		os_name=(String)Server.getOSName(s_ct,s_host);
		if(os_name!=null && os_name.trim().length()>0)
		{
			os_name=os_name.toLowerCase();
			isOSDepTest = true;
		}
	}

	String osDepColumn  = null;
	if(isOSDepTest)
	{
		if(os_name!=null && os_name.startsWith("win"))
			osDepColumn  = 	trans.getStrValue("DDD_EmptyColumns_List",s_test+"_DDD:"+s_measure+":Windows");
		else if(os_name!=null && os_name.startsWith("lin"))
			osDepColumn  = 	trans.getStrValue("DDD_EmptyColumns_List",s_test+"_DDD:"+s_measure+":Linux");
		else if(os_name!=null && os_name.startsWith("sol"))
			osDepColumn  = 	trans.getStrValue("DDD_EmptyColumns_List",s_test+"_DDD:"+s_measure+":Solaris");
	}

	String emptyColumn = trans.getStrValue("DDD_EmptyColumns_List",s_test+"_DDD:"+s_measure);

	if(osDepColumn!=null && osDepColumn.trim().length()>0)
	{
		emptyColumn=(emptyColumn==null)?"":emptyColumn;
		if(emptyColumn!=null && emptyColumn.trim().length()>0)
			emptyColumn=emptyColumn+","+osDepColumn;
		else
			emptyColumn=osDepColumn;
	}

	ArrayList emptyColumnsList = new ArrayList();
	if(emptyColumn!=null && emptyColumn.indexOf(",") > -1)
	{
		emptyColumnsList = com.egurkha.util.StringUtils.egTokenizer(emptyColumn,",",true,false,true);
	}
	ArrayList valList = new ArrayList();
	ArrayList measureTimeList = new ArrayList();

	if(a_results.size()>0)
	{
		if(StringUtils.isNull(lastMesTime))
		{
			if(s_date!=null && s_date.length()>0)
			{
				lastMesTime= s_date;
			}
			else
				lastMesTime=(String) a_results.get(0);
		}

		for(int k=0;k<a_results.size();k=k+2)
		{
			String mesTime = (String) a_results.get(k);
			EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(mesTime, user);
			mesTime = timeZoneConverter.getDateTime();
			measureTimeList.add(mesTime);
			if(lastMesTime.equals(mesTime))
			{
				ArrayList val = (ArrayList) a_results.get(k+1);
				Set valSet = new HashSet(val);
				List listVal = new ArrayList(valSet);
				for(int j=0;j<listVal.size();j++)
				{
					ArrayList tmpArrList = (ArrayList) listVal.get(j);
					if(tmpArrList!=null && tmpArrList.size() > 0){
						valList.add(tmpArrList);
					}
				}
			}
		}
	}
	int totCols = 0;

	if(isSybaseTest)	// For Sybase System process
	{
		if(StringUtils.isNull(sortOrder)) sortOrder = "1";
		if(s_measure!=null)
		{
			totCols = 12;
		}
	}
	else if(isOraSessionTest)
	{
		if(StringUtils.isNull(sortOrder)) sortOrder = "1";
		totCols = 11;
	}
	else if(isOraConnectionsTest)
	{
		if(StringUtils.isNull(sortOrder)) sortOrder = "1";
		totCols = 10;
	}
	else	// For Ms-SQL System process
	{
		totCols = isSqlConnTest ? 14:15 ;
		if(s_measure!=null && StringUtils.isNull(sortOrder))
		{
			if(s_measure.equalsIgnoreCase("Sleeping_processes"))
				sortOrder = isSqlConnTest ? "13" : "14" ;
			else 
				sortOrder = isSqlConnTest ? "11" : "12" ;
		}
	}
	int sortColumn = Integer.parseInt(sortOrder);
	ArrayList tmpList = arrayListSort(valList,sortColumn,totCols ,s_test);

	ArrayList spidList = new ArrayList();
	Hashtable resultTable = new Hashtable();

	for(int k=0;k<tmpList.size();k++)
	{
		ArrayList arrList =  (ArrayList) tmpList.get(k);
		if(arrList!=null && arrList.size() > 0)
		{
			String spid = (String)arrList.get(0);
			spidList.add(spid);
			StringBuffer sb = new StringBuffer();
			int size = arrList.size();
			for(int y=0;y<size;y++)
			{
				String line = (String) arrList.get(y);
				if(y==(size-1))
				{
					while(line.indexOf(">")>=0)
						line = line.replaceAll(">","&gt;");
					while(line.indexOf("<")>=0)
						line = line.replaceAll("<","&lt;");
					while(line.indexOf("\"")>=0)
						line = line.replaceAll("\"","&quot");
				}
				while(line.indexOf("\\")>=0)
				{
					String before = line.substring(0,line.indexOf("\\"));
					String after = line.substring(line.indexOf("\\")+1);
					line = before +"&#092;" + after;
				}
				sb.append(line + "#~#");
			}
			String res  = (sb.toString()).substring(0,sb.length()-3);
			resultTable.put(spid,res);
		}
	}

	if(spidList.size()==0)
	{
		spidList.add("None*:*None");
		measureTimeList.add(dummylastMesTime);
		resultTable.put("None*:*None","None");
	}

	//To avoid duplicate measurement time
	TreeSet ts = new TreeSet(measureTimeList);
	measureTimeList = new ArrayList(ts);

	if (isFirefox)
	{
		wd = "672px";
		wdtd = "683px";
		divHeight = "354px";
	}	
	else if (isChrome)
	{
		wd = "672px";
		wdtd = "683px";
		divHeight = "380px";
	}
	else
	{
		wd = "672px";
		wdtd = "683px";
		divHeight = "358px";
	}

	if(StringUtils.isNull(lastMesTime))
		lastMesTime = "Not Available";

	if(!lastMesTime.equals("Not Available")||(s_date!=null) && spidList.size()>=0 && a_results.size()>0)
	{
%>
			<table align="left" cellspacing="0" cellpadding="4" border="0" class="data_border" style="table-layout:<%=isTable%>;border-top-width:0px;height:100%" ><col width="150"><col width="6px"><col width="80%">
					<tr>
						<td colspan="3" style="font-size:8pt;border-top-width:0px;border-bottom-width:0px" >
<%
		String Url="";
		if(s_date==null || s_date.length()==0)
		{
			Url = "../monitor/MsSqlSysProcesses.jsp?site=" + EgURLEncoder.encode("NULL","UTF-8") + "&host=" +com.eg.EgURLEncoder.encode(s_host,"UTF-8") +"&port=" + s_port + "&test="+s_test+"&msmt_host="+com.eg.EgURLEncoder.encode(s_msmt_host,"UTF-8")+ "&from=0&flag=1&firsttime=true"+"&info="+com.eg.EgURLEncoder.encode(s_info,"UTF-8");
		}
		else
		{
			Url = "../monitor/MsSqlSysProcesses.jsp?site=" + EgURLEncoder.encode("NULL","UTF-8") + "&host=" +com.eg.EgURLEncoder.encode(s_host,"UTF-8") +"&port=" + s_port + "&test="+s_test+"&msmt_host="+com.eg.EgURLEncoder.encode(s_msmt_host,"UTF-8")+ "&from=0&flag=1&firsttime=true&sdate="+com.eg.EgURLEncoder.encode(s_date,"UTF-8")+"&s_st_time="+com.eg.EgURLEncoder.encode(s_st_time,"UTF-8")+"&s_en_time="+com.eg.EgURLEncoder.encode(s_en_time,"UTF-8")+"&s_st_hr="+com.eg.EgURLEncoder.encode(s_st_hr,"UTF-8")+"&s_en_hr="+com.eg.EgURLEncoder.encode(s_en_hr,"UTF-8")+"&s_st_min="+com.eg.EgURLEncoder.encode(s_st_min,"UTF-8")+"&s_end_min="+com.eg.EgURLEncoder.encode(s_end_min,"UTF-8")+"&info="+com.eg.EgURLEncoder.encode(s_info,"UTF-8");
		}
%>
							<div class="jtm_formouter" style="height:40px;padding:10px;display:inline-block;width:97%"><table class="jtm_Table" align="left" cellspacing="0" cellpadding="4" border="0">
								<tr>
									<td ><div style="padding:2px;font-weight:bold"> <egui:intnl text='monitor.layermodel.Measurement Time '/></div>
										<div><select name ="time" id="time" class="jtm_Select" style="width:180px" onChange="javaScript:reloadUrl('<%=response.encodeURL(Url)%>',null,null,this.value)">
<%
		for(int i=measureTimeList.size()-1;i>=0;i--)
		{
			String tmp = (String)measureTimeList.get(i);
			EgTimeZoneConverter egTimeZoneConverter = new EgTimeZoneConverter(tmp,user);
			String displayDateTime = egTimeZoneConverter.getDateTime();
			String selected="";
			if (tmp.equals(lastMesTime))
				selected ="selected";
			else
				selected="";
%>
											<option value="<%=tmp%>" <%=selected%>> <%=displayDateTime%> </option>
<%
		}
%>
										</select></div>
									</td>
									<td ><div style="padding:2px;font-weight:bold"> <egui:intnl text='monitor.layermodel.Measurement'/></div>
										<div><select name="measurename" id="measurename" class="jtm_Select" style="width:180px" onChange="javaScript:reloadUrl('<%=response.encodeURL(Url)%>',this.value,null,null)">
<%
		for(int k=0;k<v_measures.size();k++)
		{
			String tmp = (String) v_measures.get(k);
			String selected="";
			if(tmp.equals(s_measure))
				selected="selected";
			else
				selected="";
%>
											<option value ="<%=tmp%>" <%=selected%>><egui:intnl measure='<%=s_test+":"+tmp%>'/></option>
<%
		}
%>
										</select></div>
									</td>
<%
		if(columnList!=null && columnList.size() > 0)
		{
%>
									<td ><div style="padding:2px;font-weight:bold"> <egui:intnl text='monitor.layermodel.Sort By'/></div>
										<div><select name="sortname" id="sortname"  class="jtm_Select"  style="width:180px" onChange="javaScript:reloadUrl('<%=response.encodeURL(Url)%>',null,this.value,null)">
<%
			for(int k=0;k<columnList.size();k++)
			{
				String tmp = (String) columnList.get(k);
				if(emptyColumnsList.contains(tmp))
					continue;
				Integer indexObj = (Integer)mappingTable.get(tmp);
				String selected="";
				if(sortOrder.equals(indexObj.toString()))
					selected="selected";
				else
					selected="";
%>
											<option value ="<%=indexObj.toString()%>" <%=selected%>><egui:intnl measure='<%=s_test+":"+tmp%>'/></option>
<%
			}
%>
										</select></div>
									</td>
<%
		}
		else
		{
%>
									<td align="right" class="eg_75bold">&nbsp;</td>
<%
		}
%>
								</tr>
						</table>
						</div>
					</td>
				</tr>
				<tr>
					<td colspan="3" valign="top" width="100%" style="padding:8px">
						<table align="left" cellspacing="0" cellpadding="4" border="0" class="jtm_datapanel" style="table-layout:auto;"  width="100%">
							<tr>
								<td height="100%" valign="top"  style="width:220px;padding:0px">
									<table align="left" cellspacing="0" cellpadding="0" border="0" width="100%" class="jtm_table">
										<tr>
											<td height="100%" >
											<div class="jtm_DatapanelHeader" style="padding:3px;margin:8px 0 8px 8px"> <egui:intnl text="Process ID"/></div>
												<div style="height:410px;width:220px;position:relative;">
<%
		if(monitor_Skin.equalsIgnoreCase("Dark") || monitor_Skin.equalsIgnoreCase("dark"))
		{ 
%>
												<select NAME="threadname" id="threadname" size="10" style="top:0;bottom:0;width:220px;border:0px;position:absolute;height:inherit;background:#515151 !important;color:#c6c6c6!important;" onChange="javaScript:showDetails(this.value)">
<%
		}
		else
		{
%>
												<select NAME="threadname" id="threadname" size="10" style="top:0;bottom:0;width:220px;border:0px;position:absolute;height:inherit;background:#fff !important;color:#000!important;" onChange="javaScript:showDetails(this.value)">
<%
		}
%>

												
<%
		int count =spidList.size();
		if(count==1) 
		{
			if(spidList.contains("None*:*None"))
				count=0;
		}
		for(int k=0;k<spidList.size();k++)
		{
			String spid = (String) spidList.get(k);
			String optionValue = (String) resultTable.get(spid);
			if(spid.indexOf("*:*") > 0)
			{
				spid = spid.substring(0,spid.indexOf("*:*"));
			}
			String selected="";
			selected = (k==0)?"selected":"";
%>
												<option VALUE="<%=optionValue%>" <%=selected%> title='<egui:intnl text="No of Processes="/><%=count%>'><%=spid%></option>
<%
		}
%>
												</select>
												</div>
											</td>
										</tr>
									</table>
								</td>
								<td style="padding:3px" style="width:6px"><img src = "/final/images/spacer.gif" width="6px"></td>
								<td valign="top" class="jtm_datapanel" width="100%"  style="height:100%;padding:14px 14px 0 14px" >
									<form name="ThreadForm" style="margin:0px;padding:0px" id="ThreadForm">
										<div id="div_scroll" style="overflow-x:hidden;overflow-y:auto;border:0px solid blue;height:427px;width:100%"></div>
										<input type="hidden" name="fdate" id="fdate" value="<%=filterdate%>">
									</form>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
			<input type="hidden" name="testname" id="testname" value='<%=s_test%>'>
<%
		if(spidList.size() >0 && spidList != null)
		{
			String firstKey = (String)spidList.get(0);
			String firstOptionValue = (String)resultTable.get(firstKey);
%>
			<script type="text/javascript">
				var t=setTimeout("showDetails('<%=firstOptionValue%>')",0)
			</script>
<%
		}
	}
	else
	{
		String msg = "monitor.layermodel.Details not available";
%>
			<table height="100%" width="100%" border="0" class="data_border" style="table-layout:<%=isTable%>;border-top-width:0px" >
				<tr>
					<td align="center" valign="middle" class="commonErrorMsgText" > 
						<img src="/final/images/clear.png" class="iconExclamation" align="center" border="0" /><br>
						<egui:intnl text="<%=msg%>"/>
					</td>
				</tr>
			</table>
<%
	}
}
catch(Exception ex)
{
	System.out.println("Exception in MsSqlSysProcesses.jsp");
	ex.printStackTrace();
}
%>
</body>
</html>
