<%
/*************************************************************
Name			:KBSearch.jsp
Purpose			:This jsp deals with showing  Problem 
				 and fix History  for all measures based on 
				 selection or entering search string.
Creation Date	:17-12-2010.
**************************************************************/
%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ include file="EgMonitorTracker.jsp" %>
<%@ page errorPage = "EgProbsM.jsp" %>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import = "com.eg.EgDbAdapterTypeUI" %>
<%@ page import = "com.eg.EgDbInfo" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.egurkha.*" %>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "egurkha.EgDbAdapterUI" %>
<%@ page import = "java.util.*" %>
<%@ page import = "java.util.Date" %>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = " java.text.*"%>
<%@ page import = "com.eg.LangInfo"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "java.sql.*"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "egurkha.reporter.*" %>
<%@ page import ="com.eg.EgTopoInfo"%>
<%@ page import ="com.eg.EgTablesInfo"%>
<%@ page import ="com.eg.EgGroupInfo"%>
<%@ page import ="com.egurkha.util.DateTimeTokenizer"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.eg.EgDiscInfo" %>
<%@ page import = "com.eg.EgDiscInfoHelper"%>
<%@ page import = "com.eg.supermanager.*"%>
<%@ page import="net.sf.json.*"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import = "java.text.SimpleDateFormat"%>
<%@ page import = "com.egurkha.util.DateTimeTokenizer" %>
<%@ page import = "egurkha.reporter.ErUtils" %>

<%
	response.setContentType("application/json");
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setHeader( "Vary", "User-Agent" );
%>

<%
try
{
	if(EgInstallInfo.isSuperManager)
	{
		String currentSession = session.getId();
		String isSubmitted = request.getParameter("isSubmitted");
		if(isSubmitted != null && isSubmitted.equalsIgnoreCase("true"))
		{
			String eventName= request.getParameter("v_event");
			String subEvent = request.getParameter("subevent");
			String s_comp = request.getParameter("compNameList");
			String current_thread_name = Thread.currentThread().getName();
			ArrayList managerIDs = null;
			if(eventName.equalsIgnoreCase("zone") || eventName.equalsIgnoreCase("service") || eventName.equalsIgnoreCase("segment"))
			{
				managerIDs = EgElementInfo.getInstance().getManagerIDs(eventName,subEvent);
			}
			else if(s_comp != null && !s_comp.equalsIgnoreCase("all"))
			{
				String array[] = StringUtils.getTokens(s_comp,":");
				if(array != null && array.length==2)
				{
					s_comp = s_comp +":NULL";
				}
				managerIDs = EgElementInfo.getInstance().getManagerIDs("component",s_comp);
			}
			else
			{
				Hashtable managersInfo = EgManagersInfo.getInstance().getReportingManagers();
				if(managersInfo != null && !managersInfo.isEmpty())
				{
					managerIDs = new ArrayList();
					managerIDs.addAll(managersInfo.keySet());
				}
			}
			if(managerIDs != null && !managerIDs.isEmpty())
			{
				Hashtable paramHt = new Hashtable();
				paramHt.put("managerIds",managerIDs);
				EgSMDBHelper.paramsOfJSP.put(currentSession,paramHt);
				SmSessionData smsData = new SmSessionData(currentSession,managerIDs);
				EgThreadLocal egtl = new EgThreadLocal();
				egtl.set(smsData);
			}
		}
	}
	String newWindow = request.getParameter("newWindow");
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	String userDateFormat = user.getUserDateFormat();
	if (userDateFormat != null && userDateFormat.equalsIgnoreCase("Default"))
	{
		userDateFormat = currentDateFormat;
	}
	String loginid = user.getLoginID();
	LangInfo langinfo = new LangInfo(loginid);
	com.egurkha.ini.IniUI uiObj = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	String thisLanguage = uiObj.getDefaultLanguage();
	EgTimeZoneConverter timeZoneConverter = null;

	if (user!=null)
	{
		String userLang = user.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}

	EgDbInfo dbinfo=new EgDbInfo("manager");
	EgTablesInfo tab=new EgTablesInfo("manager");
	EgDiscInfo discInfo = new EgDiscInfo("manager");
	EgDiscInfoHelper discInfoHelper = new EgDiscInfoHelper();
	//EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	ErUserData erdata = new ErUserData(loginid,false);
	EgDateInfo edi = new EgDateInfo();

	EgUserRole userRole = EgUserRole.getRoleObject(user.getLoginType());
	boolean hasAllComponentAccess=userRole.hasAllComponentAccess();
	List userCompList=new LinkedList();
	if(!hasAllComponentAccess)
	{
		userCompList=user.getServers(false);
		if(userCompList!=null && userCompList.size()>0)
		{
			List userCompList_host=new LinkedList();
			for(int r=0; r<userCompList.size(); r++)
			{
				String s = (String) userCompList.get(r);
				if(s!=null && !s.endsWith(":NULL"))
				{
					StringTokenizer st=new StringTokenizer(s,":");
					String ctype=st.nextToken();
					String cname=st.nextToken();
					if(ctype!=null && cname!=null && ctype.trim().length()>0 && cname.trim().length()>0)
						userCompList_host.add(ctype+":"+cname+":NULL");
				}
			}
			if(userCompList_host!=null && userCompList_host.size()>0)
				userCompList.addAll(userCompList_host);
		}
	}

	Vector v_zone=new Vector();
	Vector v_site=new Vector();
	Vector v_segment=new Vector();
	v_zone.addAll(user.getZones());
	v_segment=erdata.getSegments();
	v_site=erdata.getSites();
	ArrayList event_for=new ArrayList();

	if(v_zone!=null && v_zone.size()>0)
	{
		event_for.add("Zone");
	}
	if(v_site!=null && v_site.size()>0)
	{
		event_for.add("Service");
	}
	if(v_segment!=null && v_segment.size()>0)
	{
		event_for.add("Segment");
	}
	event_for.add ("Component");
	Collections.sort(event_for);

	boolean isDouble=EgDbInfo.doubleByteEnabled;
%>

<%!
	//this method is used to wrap characters having no space in display
	public String getWrapValues(String val,String lang,int limit)
	{
		String value="";
		StringBuffer  sb=new StringBuffer();
		int a=0;
		String thisLanguage=lang;
		String tmp="";
		String tmp1="";
		if(limit==25 || limit==16)
		{
			if(thisLanguage!=null && thisLanguage.equalsIgnoreCase("en_US"))
			{
				a=25;
			}
			else
			{
				a=16;
			}
		}
		else
		{
			if(thisLanguage!=null && thisLanguage.equalsIgnoreCase("en_US"))
			{
				a=90;
			}
			else
			{
				a=60;
			}
		}
		do
		{
			if(val.length()>=a)
			{
				tmp=val.substring(0,a);
				sb.append(tmp);
			}
			sb.append(" ");
			if(val.length()>0)
			{
				if(val.length()<=a)
				{
					sb.append(val);
					break;
				}
				tmp1=val.substring(a+1,val.length());
			}
			val=tmp1;
			if(val.length()<=a)
			{
				sb.append(val);
				sb.append(" ");
			}
		}while(val.length()>=0);
		value=sb.toString();
		return value;
	}
%>
<%
	//for csv
	List listData = new LinkedList();
	listData.add(mappingInfo.getTextDescription("monitor.csv.Knowledge Base Search"));
	listData.add(" ");
	Vector v_tempTitle=new Vector();
	v_tempTitle.add("\n");
	int dataSize=0;
	//end csv

	boolean subzone=false;
	String eventfor =request.getParameter("eventfor");
	String event_select = request.getParameter("event_select");
	String s_event = request.getParameter("v_event");
	String sub_event = request.getParameter("subevent");
	String ctype_event = request.getParameter("ct_event");
	String includesubzone = request.getParameter("selectedsubzone");
	String search = request.getParameter("search");
	if(includesubzone==null)
		includesubzone = request.getParameter("includeSubZone");
	includesubzone=(includesubzone==null || includesubzone.equals(""))?"yes":includesubzone;
	if(includesubzone!=null && includesubzone.equalsIgnoreCase("yes"))
	{
		subzone=true;
	}
	if((s_event!=null && s_event.equals("Component"))&& sub_event==null)
	{
		v_tempTitle.add(mappingInfo.getTextDescription("monitor.csv.Component")+"="+s_event);
	}
	if((s_event!=null && s_event.equals("Service"))&& sub_event==null)
	{
		sub_event="ALL";
		v_tempTitle.add(mappingInfo.getTextDescription("monitor.csv.Service")+"="+s_event);
	}
	if((s_event!=null && s_event.equals("Zone"))&& sub_event==null)
	{
		sub_event="ALL";
		v_tempTitle.add(mappingInfo.getTextDescription("monitor.csv.Zone")+"="+s_event);
	}
	if((s_event!=null && s_event.equals("Segment"))&& sub_event==null)
	{
		sub_event="ALL";
		v_tempTitle.add(mappingInfo.getTextDescription("monitor.csv.Segment")+"="+s_event);
	}

	String selName = request.getParameter("compNameList");
	String layName=request.getParameter("layerList");
	String site=request.getParameter("site");
	String test=request.getParameter("test");
	String meas=request.getParameter("meas");
	String	selectedCompName = request.getParameter("compNameList"),
	selectedCompType = request.getParameter("compTypeList");
	String qry=(String)request.getParameter("all");
	String serv=(String)request.getParameter("serv");
	String seg=(String)request.getParameter("seg");
	String zon=(String)request.getParameter("zon");
	String timeline=request.getParameter("time_line");
	String strttime=request.getParameter("start_time");
	String endtime=request.getParameter("end_time");
	String strthr=request.getParameter("start_hr");
	String endhr=request.getParameter("end_hr");
	String strtmin=request.getParameter("start_min");
	strtmin=(strtmin==null || strtmin.trim().length()==0)?"00":strtmin;
	String endmin=request.getParameter("end_min");
	endmin=(endmin==null || endmin.trim().length()==0)?"00":endmin;
	String dbstrtdate=request.getParameter("dbstrtdate");
	String dbenddate=request.getParameter("dbenddate");
	String complayer=request.getParameter("complayer");
	String spectest=request.getParameter("spectest");
	String strtDateTime="";
	String endDateTime="";
	String userStMin = request.getParameter("usermin");
	String userEndMin = request.getParameter("userendmin");
	
	//modify start
	String modifyDiv=request.getParameter("modifyDiv");
	String modify_compType=request.getParameter("compType");
	String modify_comp=request.getParameter("componemt");
	String modify_test=request.getParameter("test");
	String modify_measure=request.getParameter("measure");
	String modify_info=request.getParameter("info");
	if(modify_info!=null)
	{
		modify_info=com.egurkha.util.StringUtils.replace(modify_info,"|plus|","+");
		modify_info=com.egurkha.util.StringUtils.replace(modify_info,"|amp|","&");
		modify_info=com.egurkha.util.StringUtils.replace(modify_info,"|pct|","%");
		modify_info=com.egurkha.util.StringUtils.replace(modify_info,"|hash|","#");
	}

	if(modify_comp!=null)
		modify_comp=modify_comp.trim();
	
	if(modify_test!=null)
		modify_test=modify_test.trim();

	if(modify_measure!=null)
		modify_measure=modify_measure.trim();
	
	if(modify_info!=null)
		modify_info=modify_info.trim();

	String modify_probtime=request.getParameter("msmttime");
	String modify_probhr=request.getParameter("msmthr");
	String modify_probmin=request.getParameter("msmtmin");

	String modify_fixtime=request.getParameter("fixtime");
	String modify_fixhr=request.getParameter("fixhr");
	String modify_fixmin=request.getParameter("fixmin");

	String modify_probreason=request.getParameter("prob_reason");
	if(modify_probreason!=null)
	{
		modify_probreason=com.egurkha.util.StringUtils.replace(modify_probreason,"\\n", "<br>");
	}
	if(modify_probreason!=null)
		modify_probreason=modify_probreason.trim();
	String modify_probfix=request.getParameter("fix_reason");
	if(modify_probfix!=null)
	{
		modify_probfix=com.egurkha.util.StringUtils.replace(modify_probfix,"\\n", "<br>");
	}
	if(modify_probfix!=null)
		modify_probfix=modify_probfix.trim();
	String modify_fixby=request.getParameter("fixby");
	
	if(modify_probreason!=null && !modify_probreason.equals(""))
	{
		modify_probreason=modify_probreason.replace("|plus|","+");
		modify_probreason=modify_probreason.replace("|amp|","&");
		modify_probreason=modify_probreason.replace("|pct|","%");
	}
	if(modify_probfix!=null && !modify_probfix.equals(""))
	{
		modify_probfix=modify_probfix.replace("|plus|","+");
		modify_probfix=modify_probfix.replace("|amp|","&");
		modify_probfix=modify_probfix.replace("|pct|","%");
	}

	String def_probDate=request.getParameter("def_probDate");
	String def_probhr=request.getParameter("def_probhr");
	String def_probmin=request.getParameter("def_probmin");

	String def_fixDate=request.getParameter("def_fixDate");
	String def_fixhr=request.getParameter("def_fixhr");
	String def_fixmin=request.getParameter("def_fixmin");

	ArrayList ModifyComponent=new ArrayList();
	//modify end

	//for csv
	if(s_event!=null && s_event.equalsIgnoreCase("Service"))
	{
		v_tempTitle.add(mappingInfo.getTextDescription("monitor.csv.Service"));
		v_tempTitle.add("\n");
		if(sub_event!=null)
		{
			v_tempTitle.add(mappingInfo.getTextDescription("monitor.csv.Service")+"="+sub_event);
			v_tempTitle.add("\n");
		}
	}
	else if(s_event!=null && s_event.equalsIgnoreCase("Segment"))
	{
		v_tempTitle.add(mappingInfo.getTextDescription("monitor.csv.Segment"));
		v_tempTitle.add("\n");
		if(sub_event!=null)
		{
			v_tempTitle.add(mappingInfo.getTextDescription("monitor.csv.Segment")+"="+sub_event);
			v_tempTitle.add("\n");
		}
	}
	else if(s_event!=null && s_event.equalsIgnoreCase("Zone"))
	{
		v_tempTitle.add(mappingInfo.getTextDescription("monitor.csv.Zone"));
		v_tempTitle.add("\n");
		if(sub_event!=null)
		{
			v_tempTitle.add(mappingInfo.getTextDescription("monitor.csv.Zone")+"="+sub_event);
			v_tempTitle.add("\n");
		}
	}
	if(selName!=null && layName!=null && test!=null && meas!=null && timeline!=null && strttime!=null && endtime!=null)
	{
		v_tempTitle.add(mappingInfo.getTextDescription("monitor.csv.Component")+"="+selName);
		v_tempTitle.add("\n");
		v_tempTitle.add(mappingInfo.getTextDescription("monitor.csv.Layer")+"="+layName);
		v_tempTitle.add("\n");
		v_tempTitle.add(mappingInfo.getTextDescription("monitor.csv.Test")+"="+test);
		v_tempTitle.add("\n");
		v_tempTitle.add(mappingInfo.getTextDescription("monitor.csv.Measure")+"="+meas);
		v_tempTitle.add("\n");
		strttime=DateUtil.changeDateFormat(strttime,currentDateFormat,userDateFormat);

		
		v_tempTitle.add("\""+mappingInfo.getTextDescription("monitor.csv.Start Time")+"="+strttime+" "+strthr+":"+userStMin+"\"");
		v_tempTitle.add("\n");
		endtime=DateUtil.changeDateFormat(endtime,currentDateFormat,userDateFormat);
		v_tempTitle.add("\""+mappingInfo.getTextDescription("monitor.csv.End Time")+"="+endtime+" "+endhr+":"+userEndMin+"\"");
		v_tempTitle.add("\n");
	}
	//csv end

	if(timeline!=null && timeline.equals("Any"))
	{

		String userMin = request.getParameter("usermin");
		strtmin = userMin;
		endmin = userMin;

		strthr=strthr+":"+strtmin+":"+"00";
		endhr=endhr+":"+endmin+":"+"00";

		EgTimeZoneConverter start_timeZoneConverter = new EgTimeZoneConverter(strttime+" "+strthr,user,true);
		strttime = (String)start_timeZoneConverter.getDate(false);
		EgTimeZoneConverter end_timeZoneConverter = new EgTimeZoneConverter(endtime+" "+endhr,user,true);
		endtime = (String)end_timeZoneConverter.getDate(false);

		//strttime=DateUtil.changeDateFormat(strttime,currentDateFormat,"yyyy-MM-dd HH:mm:ss");
		strttime=DateUtil.changeDateFormat(strttime,userDateFormat,"yyyy-MM-dd");
		//endtime=DateUtil.changeDateFormat(endtime,currentDateFormat,"yyyy-MM-dd HH:mm:ss");
		endtime=DateUtil.changeDateFormat(endtime,userDateFormat,"yyyy-MM-dd");
		//strtDateTime=strttime.replaceAll("00:00:00",strthr);

		strtDateTime=strttime+" "+start_timeZoneConverter.getHour()+":"+start_timeZoneConverter.getMinute();
		//endDateTime=endtime.replaceAll("00:00:00",endhr);
		endDateTime=endtime+" "+end_timeZoneConverter.getHour()+":"+end_timeZoneConverter.getMinute();
		
	}
	if(timeline!=null && !timeline.equals("Any"))
	{
		//strtDateTime=DateUtil.changeDateFormat(dbstrtdate,"MM/dd/yyyy HH:mm","yyyy-MM-dd HH:mm");
		//endDateTime=DateUtil.changeDateFormat(dbenddate,"MM/dd/yyyy HH:mm","yyyy-MM-dd HH:mm");
		
		int blankSpaceIndex = timeline.indexOf(DateTimeTokenizer.BLANK_SPACE);
		if (blankSpaceIndex > 0)
		{
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
			java.util.Date tmpday = edi.egetRealDate();
			endDateTime = sdf.format(tmpday);
			int value = Integer.parseInt(timeline.substring(0, blankSpaceIndex));
			//long value = Integer.parseInt(timeLine.substring(0, blankSpaceIndex));

			String unit = timeline.substring(blankSpaceIndex+1).toLowerCase();
			if (unit.startsWith("h"))
			{//hours
				value *= 3600;
			}
			else if (unit.startsWith("d"))
			{//days
				value *= (24 * 3600);
			}
			else if (unit.startsWith("w"))
			{//weeks
				value *= (7 * 24 * 3600);
			}
			else if (unit.startsWith("mo"))
			{//months
				//value *= (30 * 24 * 3600);
				value *=((ErUtils.getMaxDaysInMonth()) * 24 * 3600);
			}
			long valueToLong=value;
			java.util.Date start = edi.egetRealDate();
			start.setTime(tmpday.getTime() - (valueToLong * 1000));
			strtDateTime = sdf.format(start);
			
		}

	}

	//csv starts
	String selectString=request.getParameter("selectString");
	if(selectString!=null)
	{
		v_tempTitle.add(mappingInfo.getTextDescription("monitor.csv.Search String")+"="+selectString);
	}
	v_tempTitle.add("\n");
	v_tempTitle.add(" ");
	Hashtable t=new Hashtable();
	List l=new LinkedList();
	l.add(" ");
	t.put(v_tempTitle,l);
	Hashtable k33=new Hashtable();
	Vector vec_Tabletitle = new Vector();
	vec_Tabletitle.add(" ");
	k33.put(" ",t);
	listData.add(k33);
	//csv ends

	if(selectString!=null && selectString.equalsIgnoreCase("|and|"))
	{
		selectString="&";
	}
	String searchValue="";
	if(selectString!=null)
		searchValue=selectString;
	String reason=request.getParameter("reason");
	String fixed=request.getParameter("fixed");
	String searchAll=request.getParameter("searchAll");
	String check="";
	String check1="";
	String check2="";
	if(fixed!=null && fixed.equalsIgnoreCase("fixed"))
	{
		check="checked";
	}
	else if(reason!=null && reason.equalsIgnoreCase("reason"))
	{
		check1="checked";
	}
	else if(searchAll!=null && searchAll.equalsIgnoreCase("searchAll"))
	{
		check2="checked";
	}
	else
		check2="checked";
	
	String zoneComp=null;
	boolean allComps=false;

	ArrayList zonelist=new ArrayList();
	ArrayList innersubZone=new ArrayList();
	ArrayList testlayer=new ArrayList();
	ArrayList segList=new ArrayList();
	List getServers=new LinkedList();
	List innersubZoneComps=new LinkedList();
	List getSegmentComp=new LinkedList();
	Vector service_dis=new Vector();
	Vector v_segComp = new Vector();
	Vector layer_list=new Vector();
	Vector siteKeys=new Vector();
	Vector testdeatils=new Vector();
	Vector tempSeg=new Vector();
	Vector all_test=new Vector();
	Vector allSites=new Vector();
	
	EgTopoInfo topoInfo = new EgTopoInfo("manager");
	EgGroupInfo groupInfo = new EgGroupInfo();

	if(s_event!=null && s_event.trim().length()>0 && s_event.equals("Service"))
	{
		if((sub_event!=null && sub_event.length()>0)||(sub_event!=null && sub_event.equals("ALL")))
		{
			if(sub_event!=null)
			{
				if(sub_event!=null &&  sub_event.equals("ALL"))
				{
					for(int i=0;i<v_site.size();i++)
					{
						String su_event=(String)v_site.get(i);
						allSites=topoInfo.getComponentsForSite(su_event);
						siteKeys.add(allSites);
					}
				}
				else
				{
					allSites=topoInfo.getComponentsForSite(sub_event);
				}
			}
		}
	}
	if(s_event!=null && s_event.trim().length()>0 && s_event.equals("Segment"))
	{
		if((sub_event!=null && sub_event.length()>0)||(sub_event!=null && sub_event.equals("ALL")))
		{
			if(sub_event!=null)
			{
				if(sub_event!=null && sub_event.equals("ALL"))
				{
					for(int i=0;i<v_segment.size();i++)
					{
						String segName=(String)v_segment.get(i);
						v_segComp = topoInfo.getComponentsForSegment(segName);
						segList.add(v_segComp);	
					}
				}
				else
				{
					v_segComp = topoInfo.getComponentsForSegment(sub_event);
				}
			}
		}
	}
	if(s_event!=null && s_event.trim().length()>0 && s_event.equals("Zone"))
	{
		if((sub_event!=null && sub_event.length()>0)||(sub_event!=null && sub_event.equals("ALL")))
		{
			if((sub_event!=null && sub_event.equals("ALL")))
			{
				for(int i=0;i<v_zone.size();i++)
				{
					String zonename=(String)v_zone.get(i);
					if(includesubzone!=null && includesubzone.equalsIgnoreCase("No"))
					{
						innersubZone=groupInfo.getAllComponentsUnderZone(zonename,false);
						innersubZoneComps=(List)innersubZone;
						zonelist.add(innersubZoneComps);
					}
					else
					{
						innersubZone = groupInfo.getAllComponentsUnderZone(zonename,subzone);
						innersubZoneComps=(List)innersubZone;
						zonelist.add(innersubZoneComps);
					}
				}
			}
			else
			{
				if(includesubzone!=null && includesubzone.equalsIgnoreCase("No"))
				{
					allComps=true;
					innersubZone = groupInfo.getAllComponentsUnderZone(sub_event,false);
					innersubZoneComps =(List)innersubZone;
				}
				else
				{
					allComps=true;
					innersubZone = groupInfo.getAllComponentsUnderZone(sub_event,subzone);
					innersubZoneComps =(List)innersubZone;
				}
				
			}
			
		}
	}
	EgDbAdapterUI egDb; 
	List serverCompTypeList = new ArrayList();
	List servers = new LinkedList();
	ArrayList tempList=new ArrayList();
	List sNames=null;
	List nameTypes=null;
	List serverNames=null;
	servers.addAll(user.getServers(false));
	boolean checkComp=false;
	if(servers!=null && servers.size()>0)
	{
		checkComp=true;
	}
	Vector tempSites=new Vector();
	Vector test_layer=new Vector();
	Vector meas_list=new Vector();
	int k =0;
	for(int i=0;i<allSites.size();i++)
	{
		String compTypes = (String)allSites.get(i);
		String comp_type=null;
		String comp_name=null;
		if(compTypes!=null && compTypes.trim().length()>0)
		{
			comp_name = compTypes.substring(0,compTypes.lastIndexOf(":"));
			comp_type = compTypes.substring(compTypes.lastIndexOf(":")+1);
			getServers.add(comp_type+":"+comp_name);
		}
	}
	if(v_segComp.size()>0 && !sub_event.equals("ALL"))
	{
		for(int i=0;i<v_segComp.size();i++)
		{
			String compTypes = (String)v_segComp.get(i);
			String comp_type=null;
			String comp_name=null;
			if(compTypes!=null && compTypes.trim().length()>0)
			{
				comp_name = compTypes.substring(0,compTypes.lastIndexOf(":"));
				comp_type = compTypes.substring(compTypes.lastIndexOf(":")+1);
				getSegmentComp.add(comp_type+":"+comp_name);
			}
		}
	}
	if(s_event == null || s_event.trim().length()==0 || s_event.equals("Component") )
	{
		s_event="Component";
		sNames = new LinkedList();
		nameTypes = new LinkedList();
		serverNames = new LinkedList();
		for(k = 0; k < servers.size(); k++)
		{
			String server = (String)servers.get(k);
			StringTokenizer st_server = new StringTokenizer(server,":");
			String type = "";
			String comp = "";
			String port = "";
			String sid = "";
			String toAdd = "";
			int cntTokens = st_server.countTokens();
			if(st_server.hasMoreTokens())
			{
				type = st_server.nextToken();
				comp = st_server.nextToken();
				port = st_server.nextToken();
				if(cntTokens == 4)
					sid = st_server.nextToken();
			}
				if(port!=null && !port.equals("NULL"))
				{
					if(!sid.equals(""))
						toAdd = type+":"+comp + ":" + port + ":" + sid;
					else
						toAdd = type+":"+comp + ":" + port;
				}
				else
					toAdd = type+":"+comp;
				if (!sNames.contains(toAdd))
					sNames.add(toAdd);
			
				if(!serverCompTypeList.contains(type))
					serverCompTypeList.add(type);
		}
		servers = sNames;
		Collections.sort(servers);
		if(servers.size() > 0)
		serverNames.addAll(servers);

		//if(serverNames == null || serverNames.size() == 0)
		{
			String query = "";
			String strConn = "";
			boolean db_state = false;
			boolean db_report = false;
			ResultSet rs_fixctype = null;
			List fixCType = new LinkedList();
			if(EgDbInfo.isSqlAdapter)
			{
				query = "SELECT COMP_NAME,COMP_TYPE FROM fixtable WITH (NOLOCK)";
			}
			else
			{
				query = "SELECT COMP_NAME,COMP_TYPE FROM fixtable";
			}
			egDb = EgDbAdapterTypeUI.getObject();
				try
				{
					strConn=egDb.setConnection();
					rs_fixctype=egDb.SelectExec(query);
					while(rs_fixctype.next())
					{
						String cName = rs_fixctype.getString(1);
						String cType = rs_fixctype.getString(2);
						if(cType != null && cType.equals("Host_system"))
						{
							continue;
						}
						if(cName != null && cName.endsWith(":NULL"))
						{
							cName = cName.substring(0,cName.lastIndexOf(":NULL"));
						}
						String strCompFullName = cType+":"+cName;
						if(!fixCType.contains(strCompFullName))
						{
							//code added by murugan
							if (fixCType.contains(serverNames))
							{
								fixCType.add(strCompFullName);
							}
							//code added by murugan
						}
					}
					rs_fixctype.close();
					egDb.releaseConnection(false);
					EgDbAdapterTypeUI.releaseObject(egDb);
				}
				catch(Exception ex)
				{
					String s_errmsg = "";
					if (!strConn.equals("CONNECTED"))
					{
						s_errmsg = "Connection could not be established";
					}
					else if (!db_state == true)
					{
						s_errmsg = "Error in sql query while retrieving records pertaining to the User!	";
					}
					else if (!db_report == true)
					{
						s_errmsg = "Error in sql query s_query(fixreport) ";
					}
					else
					{
						s_errmsg = ex.toString();
					}
					if (rs_fixctype != null)
					{
						try
						{
							rs_fixctype.close();
						}
						catch (Exception bug123)
						{
						}
					}
					if (rs_fixctype != null)
					{
						try
						{
							rs_fixctype.close();
						}
						catch (Exception bug123)
						{
						}
					}
					try
					{
						egDb.releaseConnection(true);
						EgDbAdapterTypeUI.releaseObject(egDb);
					}
					catch (Exception e2)
					{
						s_errmsg = "/final/monitor/EgProbsM.jsp?msg=" + s_errmsg;
					//Forwarding to the errorhandler
%>
						<jsp:forward page = "<%= s_errmsg %>"/>
<%
						return;
					}
				}
			if(fixCType.size() > 0)
			{
				for(int i=0;i<fixCType.size();i++)
				{
					String fixCtypeData = (String) fixCType.get(i);
					if(!serverNames.contains(fixCtypeData))
					{
						serverNames.add(fixCtypeData);
					}
				}
			}
		}
	}
	if((s_event!=null && s_event.trim().length()>0 && s_event.equals("Segment") && sub_event!=null && sub_event.trim().length()>0)||(s_event!=null && s_event.trim().length()>0 && s_event.equals("Segment") && sub_event!=null && sub_event.equals("ALL")))
	{
		sNames = new LinkedList();
		nameTypes = new LinkedList();
		serverNames = new LinkedList();
		if(sub_event!=null && sub_event.equals("ALL") && segList.size()>0)
		{
			for(int a=0;a<segList.size();a++)
			{
				tempSeg= (Vector)segList.get(a);
				for(int b=0;b<tempSeg.size();b++)
				{
					String server = (String)tempSeg.get(b);
					StringTokenizer st_server = new StringTokenizer(server,":");
					String type = "";
					String comp = "";
					String port = "";
					String sid = "";
					String toAdd = "";
					int cntTokens = st_server.countTokens();
					if(st_server.hasMoreTokens())
					{
						comp = st_server.nextToken();
						port = st_server.nextToken();
						type = st_server.nextToken();
						if(cntTokens == 4)
							sid = st_server.nextToken();
					}
					if(port!=null && !port.equals("NULL"))
					{
						if(!sid.equals(""))
							toAdd = type+":"+comp + ":" + port + ":" + sid;
						else
							toAdd = type+":"+comp + ":" + port;
					}
					else
						toAdd = type+":"+comp;
					if (!sNames.contains(toAdd))
						sNames.add(toAdd);
					if(!serverCompTypeList.contains(type))
						serverCompTypeList.add(type);
				}
			}
		}
		else
		{
			for(k = 0; k <getSegmentComp.size(); k++)
			{
				String server = (String)getSegmentComp.get(k);
				StringTokenizer st_server = new StringTokenizer(server,":");
				String type = "";
				String comp = "";
				String port = "";
				String sid = "";
				String toAdd = "";
				int cntTokens = st_server.countTokens();
				if(st_server.hasMoreTokens())
				{
					type = st_server.nextToken();
					comp = st_server.nextToken();
					port = st_server.nextToken();
					if(cntTokens == 4)
						sid = st_server.nextToken();
				}
				if(port!=null && !port.equals("NULL"))
				{
					if(!sid.equals(""))
						toAdd = type+":"+comp + ":" + port + ":" + sid;
					else
						toAdd = type+":"+comp + ":" + port;
				}
				else
					toAdd = type+":"+comp;
				if (!sNames.contains(toAdd))
					sNames.add(toAdd);
				if(!serverCompTypeList.contains(type))
					serverCompTypeList.add(type);
			}
		}
		getSegmentComp = sNames;
		Collections.sort(getSegmentComp);
		if(getSegmentComp.size() > 0)
		serverNames.addAll(getSegmentComp);
	}
	if((s_event!=null && s_event.trim().length()>0 && s_event.equals("Service") && sub_event!=null && sub_event.trim().length()>0)||(s_event!=null && s_event.trim().length()>0 && s_event.equals("Service") && sub_event!=null && sub_event.equals("ALL")))
	{
		sNames = new LinkedList();
		nameTypes = new LinkedList();
		serverNames = new LinkedList();

		for(k = 0; k <getServers.size(); k++)
		{
			String server = (String)getServers.get(k);
			StringTokenizer st_server = new StringTokenizer(server,":");
			String type = "";
			String comp = "";
			String port = "";
			String sid = "";
			String toAdd = "";
			int cntTokens = st_server.countTokens();
			if(st_server.hasMoreTokens())
			{
				type = st_server.nextToken();
				comp = st_server.nextToken();
				port = st_server.nextToken();
				if(cntTokens == 4)
					sid = st_server.nextToken();
			}
			if(port!=null && !port.equals("NULL"))
			{
				if(!sid.equals(""))
					toAdd = type+":"+comp + ":" + port + ":" + sid;
				else
					toAdd = type+":"+comp + ":" + port;
			}
			else
				toAdd = type+":"+comp;
			if (!sNames.contains(toAdd))
				sNames.add(toAdd);
					if(!serverCompTypeList.contains(type))
						serverCompTypeList.add(type);
		}
		if(sub_event!=null && sub_event.equals("ALL"))
		{
			for(int a=0;a<siteKeys.size();a++)
			{
				tempSites=(Vector)siteKeys.get(a);
				for(int b=0;b<tempSites.size();b++)
				{
					String server = (String)tempSites.get(b);
					StringTokenizer st_server = new StringTokenizer(server,":");
					String type = "";
					String comp = "";
					String port = "";
					String sid = "";
					String toAdd = "";
					int cntTokens = st_server.countTokens();
					if(st_server.hasMoreTokens())
					{
						comp = st_server.nextToken();
						port = st_server.nextToken();
						type = st_server.nextToken();
						if(cntTokens == 4)
							sid = st_server.nextToken();
					}
					if(port!=null && !port.equals("NULL"))
					{
						if(!sid.equals(""))
							toAdd = type+":"+comp + ":" + port + ":" + sid;
						else
							toAdd = type+":"+comp + ":" + port;
					}
					else
						toAdd = type+":"+comp;
					if (!sNames.contains(toAdd))
						sNames.add(toAdd);
					if(!serverCompTypeList.contains(type))
						serverCompTypeList.add(type);

				}
			}
		}
		getServers = sNames;
		Collections.sort(getServers);
		if(getServers.size() > 0)
		serverNames.addAll(getServers);	
	}
	if((s_event!=null && s_event.trim().length()>0 && s_event.equals("Zone") && sub_event!=null && sub_event.trim().length()>0)||(s_event!=null && s_event.trim().length()>0 && s_event.equals("Zone") && sub_event!=null && sub_event.equals("ALL")))
	{
		sNames = new LinkedList();
		nameTypes = new LinkedList();
		serverNames = new LinkedList();
		if(sub_event!=null && sub_event.equals("ALL"))
		{
			for(int i=0;i<zonelist.size();i++)
			{
				tempList=(ArrayList)zonelist.get(i);
				for(int j=0;j<tempList.size();j++)
				{
					String server = (String)tempList.get(j);
					StringTokenizer st_server = new StringTokenizer(server,":");
					String type = "";
					String comp = "";
					String port = "";
					String sid = "";
					String toAdd = "";
					int cntTokens = st_server.countTokens();
					if(st_server.hasMoreTokens())
					{
						type = st_server.nextToken();
						comp = st_server.nextToken();
						port = st_server.nextToken();
						if(cntTokens == 4)
							sid = st_server.nextToken();
					}
					if(port!=null && !port.equals("NULL"))
					{
						if(!sid.equals(""))
							toAdd = type+":"+comp + ":" + port + ":" + sid;
						else
							toAdd = type+":"+comp + ":" + port;
					}
					else
						toAdd = type+":"+comp;
					if (!sNames.contains(toAdd))
						sNames.add(toAdd);
					if(!serverCompTypeList.contains(type))
						serverCompTypeList.add(type);

				}
				
			}
		}
		else
		{
			for(k = 0; k <innersubZoneComps.size(); k++)
			{
			String server = (String)innersubZoneComps.get(k);
			StringTokenizer st_server = new StringTokenizer(server,":");
			String type = "";
			String comp = "";
			String port = "";
			String sid = "";
			String toAdd = "";
			int cntTokens = st_server.countTokens();
			if(st_server.hasMoreTokens())
			{
				type = st_server.nextToken();
				comp = st_server.nextToken();
				port = st_server.nextToken();
				if(cntTokens == 4)
					sid = st_server.nextToken();
			}
				if(port!=null && !port.equals("NULL"))
				{
					if(!sid.equals(""))
						toAdd = type+":"+comp + ":" + port + ":" + sid;
					else
						toAdd = type+":"+comp + ":" + port;
				}
				else
					toAdd = type+":"+comp;
				if (!sNames.contains(toAdd))
					sNames.add(toAdd);
					if(!serverCompTypeList.contains(type))
						serverCompTypeList.add(type);

			}
		}
		innersubZoneComps = sNames;
		Collections.sort(innersubZoneComps);
		if(innersubZoneComps.size() > 0)
		serverNames.addAll(innersubZoneComps);
	}
	if((s_event!=null && s_event.equals("Service"))&&sub_event!=null )
	{
		if(serverNames!=null && !serverNames.isEmpty() && serverNames.size()<2)
		{
			selName=(String)serverNames.get(0);
		}
	}
	if((s_event!=null && s_event.equals("Zone"))&& sub_event!=null)
	{
		if(serverNames!=null && serverNames.size()<2 && serverNames.size()>0)
		{
			selName=(String)serverNames.get(0);
		}
	}
	if((s_event!=null && s_event.equals("Segment"))&& sub_event!=null)
	{
		if(serverNames!=null && !serverNames.isEmpty() && serverNames.size()<2)
		{
			
			selName=(String)serverNames.get(0);
		}
	}
	if((s_event!=null && s_event.equals("Component"))&& sub_event!=null)
	{
		if(serverNames!=null && !serverNames.isEmpty() && serverNames.size()<2)
		{
			selName=(String)serverNames.get(0);
		}
	}

	String tem_name="";
	String type_comp="";
	String name_comp="";
	String str_conn="";
	String s_site=null;
	String [] str_mes_list=null;
	boolean b_state=false;
	boolean c_state=false;
	boolean b_fixreport= false;
	boolean c_fixreport=false;
	boolean	b_state1=false;
	Vector v_fixreport = new Vector();
	Vector p_fixreport=new Vector();
	Vector sh_fixreport=new Vector();
	Vector layer=new Vector();
	Vector la_fixreport=new Vector();
	Vector alltest_fixreport=new Vector();
	Vector allCompVec = new Vector();

	//get fix history details for all components or services or segments or zones
	if((qry!=null && qry.equals("ALL")||(zon!=null&& zon.equals("zon"))||(serv!=null && serv.equals("Serv"))||(seg!=null && seg.equals("Seg")))&&(selectString==null || selectString.trim().equals("")))
	{
		ResultSet rs_fixreport = null;
		String cmp_type=null;
		String cmp_name=null;
		String cmp_all="";
		Vector allComponent=new Vector();
		Vector split_list=new Vector();
		Vector temp_list=new Vector();
		if(s_event.equals("Component"))
		{
			if(serverNames!=null && serverNames.size()>0 && ctype_event !=null && !ctype_event.equals("ALL"))
			{
				for(int m=0;m<serverNames.size();m++)
				{
					String snames = (String)serverNames.get(m);
					if(snames != null && selName != null && snames.startsWith(ctype_event))
					{
						if(!allComponent.contains(snames))
							allComponent.add(snames);
					}
				}
			}
			else if(serverNames!=null && serverNames.size()>0 && ctype_event !=null && ctype_event.equals("ALL"))
			{
				allComponent.addAll(serverNames);
			}
		}
		else if(s_event.equals("Service")||s_event.equals("Zone")||s_event.equals("Segment"))
		{
			if(serverNames!=null && serverNames.size()>0 && ctype_event !=null && !ctype_event.equals("ALL"))
			{
				for(int m=0;m<serverNames.size();m++)
				{
					String snames = (String)serverNames.get(m);
					if(snames != null && selName != null && snames.startsWith(ctype_event))
					{
						if(!allComponent.contains(snames))
							allComponent.add(snames);
					}
				}
			}
			else if(serverNames!=null && serverNames.size()>0 && ctype_event!=null && ctype_event.equals("ALL"))
			{
				allComponent.addAll(serverNames);
			}
		}
		if(allComponent!=null && allComponent.size()>0)
		{
			egDb = EgDbAdapterTypeUI.getObject();
			String cname="";
			String ctype="";
			Vector compTypes = new Vector();
			compTypes.add("Host_system");
			for(int n=0;n<allComponent.size();n++)
			{
				String applyName=(String)allComponent.get(n);
				cmp_type=applyName.substring(0,applyName.indexOf(":"));		
				cmp_name=applyName.substring(applyName.indexOf(":")+1,applyName.length());
				if(cmp_name!=null && !cmp_name.contains(":"))
				{
					if(!cmp_name.equals("-"))
					{
						cmp_name=cmp_name+":"+"NULL";
						cname=cname+",'"+cmp_name+"'";
					}
				}
				else
				{
					cname=cname+",'"+cmp_name+"'";	
					String hostComp=cmp_name.substring(0,cmp_name.indexOf(":"))+":NULL";
					cname=cname+",'"+hostComp+"'";
				}
				if(ctype_event !=null && ctype_event.equals("ALL"))
				{
					if(!compTypes.contains(cmp_type))
						compTypes.add(cmp_type);
				}
				else
				{
					if(!compTypes.contains(ctype_event))
						compTypes.add(ctype_event);
				}
			}
			StringTokenizer st=new StringTokenizer(cname,",");
			while(st.hasMoreTokens())
			{
				String toAdd=(String)st.nextToken();
				split_list.add(toAdd);
			}
			if(split_list!=null && split_list.size()<250)
			{
				temp_list.addAll(split_list);
				if(temp_list!=null && temp_list.size()>0)
				{
					for(int i=0;i<temp_list.size();i++)
					{
						String cName=(String)temp_list.get(i);
						cmp_all=cmp_all+","+cName;
					}
				}
				for(int n=0;n<compTypes.size();n++)
				{
					String comp_type=(String)compTypes.get(n);
					ctype=ctype+",'"+comp_type+"'";
				}
				if(cmp_all!=null&&cmp_all.length()>0&&cmp_all.startsWith(","))
					cmp_all=cmp_all.substring(1);
				if(ctype!=null&&ctype.length()>0&&ctype.startsWith(","))
					ctype=ctype.substring(1);

				if(cmp_all!=null && cmp_all.length()>0)
				{
					cmp_all=cmp_all+",'-'";
				}
				else
				{
					cmp_all="'-:NULL','-'";
				}
				try
				{
					str_conn=egDb.setConnection();
					rs_fixreport=egDb.SelectFixHistory(strtDateTime,endDateTime,ctype,cmp_all);
					while(rs_fixreport.next())
					{
						v_fixreport.addElement(rs_fixreport.getString("site_name"));
						v_fixreport.addElement(rs_fixreport.getString("comp_name"));
						v_fixreport.addElement(rs_fixreport.getString("comp_type"));
						if(EgInstallInfo.isSuperManager)
						{
							String msmt_time_str = rs_fixreport.getString("msmt_time");//2013-01-18 12:07:00.0
							int space = msmt_time_str.indexOf(" ");
							int dot = msmt_time_str.lastIndexOf(".");
							String msmt_time_is = null;
							if(dot>-1)
							{
								msmt_time_is = msmt_time_str.substring(space+1,dot);
							}
							else
							{
								msmt_time_is = msmt_time_str.substring(space+1);
								msmt_time_str = msmt_time_str + ".0";
							}
							Timestamp timestamp = Timestamp.valueOf(msmt_time_str);
							Time myTime = Time.valueOf(msmt_time_is);
							v_fixreport.addElement(new java.sql.Date(timestamp.getTime()));
							v_fixreport.addElement(myTime);

							String fix_date_str = rs_fixreport.getString("fix_date");//2013-01-18 12:07:00.0
							space = fix_date_str.indexOf(" ");
							dot = fix_date_str.lastIndexOf(".");
							String fix_date_is = null;
							if(dot>-1)
							{
								fix_date_is = fix_date_str.substring(space+1,dot);
							}
							else
							{
								fix_date_is = fix_date_str.substring(space+1);
								fix_date_str = fix_date_str + ".0";
							}
							Timestamp fix_timestamp = Timestamp.valueOf(fix_date_str);
							Time fix_myTime = Time.valueOf(fix_date_is);
							v_fixreport.addElement(new java.sql.Date(fix_timestamp.getTime()));
							v_fixreport.addElement(fix_myTime);
						}
						else
						{
							v_fixreport.addElement(rs_fixreport.getDate("msmt_time"));
							v_fixreport.addElement(rs_fixreport.getTime("msmt_time"));
							v_fixreport.addElement(rs_fixreport.getDate("fix_date"));
							v_fixreport.addElement(rs_fixreport.getTime("fix_date"));
						}
						//v_fixreport.addElement(StringUtils.replaceURLsWithHyperlink(rs_fixreport.getString("prob_reason")));
						//v_fixreport.addElement(StringUtils.replaceURLsWithHyperlink(rs_fixreport.getString("prob_fix")));
						v_fixreport.addElement(rs_fixreport.getString("prob_reason"));
						v_fixreport.addElement(rs_fixreport.getString("prob_fix"));
						v_fixreport.addElement(rs_fixreport.getString("prob_fixed_by"));
						v_fixreport.addElement(rs_fixreport.getString("info"));
						v_fixreport.addElement(rs_fixreport.getString("test_name"));//11
						v_fixreport.addElement(rs_fixreport.getString("measure"));//12
					}
					rs_fixreport.close();
					egDb.releaseConnection(false);
					EgDbAdapterTypeUI.releaseObject(egDb);
				}
				catch(Exception ex)
				{
					String s_errmsg = "";
					if (!str_conn.equals("CONNECTED"))
					{
						s_errmsg = "Connection could not be established";
					}
					else if (!b_state == true)
					{
						s_errmsg = "Error in sql query while retrieving records pertaining to the User!	";
					}
					else if (!b_fixreport == true)
					{
						s_errmsg = "Error in sql query s_query(fixreport) ";
					}
					else
					{
						s_errmsg = ex.toString();
					}
					if (rs_fixreport != null)
					{
						try
						{
							rs_fixreport.close();
						}
						catch (Exception bug123)
						{
						}
					}
					if (rs_fixreport != null)
					{
						try
						{
							rs_fixreport.close();
						}
						catch (Exception bug123)
						{
						}
					}
					try
					{
						egDb.releaseConnection(true);
						EgDbAdapterTypeUI.releaseObject(egDb);
					}
					catch (Exception e2)
					{
						s_errmsg = "/final/monitor/EgProbsM.jsp?msg=" + s_errmsg;
					//Forwarding to the errorhandler
%>
						<jsp:forward page = "<%= s_errmsg %>"/>
<%
						return;
					}
				}
			}
			else if(split_list!=null && split_list.size()>=250)
			{
				do
				{
					Vector split_cmp=new Vector();
					for(int i=0;i<=249;i++)
					{
						String c_name=(String)split_list.get(i);
						split_cmp.add(c_name);
					}
					temp_list.add((Vector)split_cmp);
					Vector temp_cmp_list=new Vector();
					for(int i=0;i<split_list.size();i++)
					{
						String c_guest=(String)split_list.get(i);
						if(!split_cmp.contains(c_guest))
						{
							temp_cmp_list.add(c_guest);
						}
					}
					split_list.clear();
					if(temp_cmp_list!=null && temp_cmp_list.size()>0)
					{
						split_list.addAll(temp_cmp_list);
					}
				}
				while(split_list.size()>=250);
				if(split_list!=null && split_list.size()>0 && split_list.size()<=250)
				{
					Vector split_cmp=new Vector();
					for(int i=0;i<split_list.size();i++)
					{
						String c_name=(String)split_list.get(i);
						split_cmp.add(c_name);
					}
					temp_list.add((Vector)split_cmp);
				}
				if(temp_list!=null && temp_list.size()>0)
				{
					String c_type="";
					for(int i=0;i<temp_list.size();i++)
					{
						String c_all="";
						//String c_type="";
						Vector newList=(Vector)temp_list.get(i);
						for(int j=0;j<newList.size();j++)
						{
							String cName=(String)newList.get(j);
							c_all=c_all+","+cName;
						}
						for(int n=0;n<compTypes.size();n++)
						{
							String comp_type=(String)compTypes.get(n);
							c_type=c_type+",'"+comp_type+"'";
						}
						if(c_all!=null&&c_all.length()>0&&c_all.startsWith(","))
							c_all=c_all.substring(1);
						if(c_type!=null&&c_type.length()>0&&c_type.startsWith(","))
							c_type=c_type.substring(1);
						if(!allCompVec.contains(c_all))
							allCompVec.add(c_all);
					}
					c_type = "";
					for(int n=0;n<compTypes.size();n++)
					{
						String comp_type=(String)compTypes.get(n);
						c_type=c_type+",'"+comp_type+"'";
					}
					if(c_type!=null&&c_type.length()>0&&c_type.startsWith(","))
						c_type=c_type.substring(1);
						try
						{
							str_conn=egDb.setConnection();
						rs_fixreport=egDb.SelectFixHistoryAll(strtDateTime,endDateTime,c_type,allCompVec);
							while(rs_fixreport.next())
							{
								v_fixreport.addElement(rs_fixreport.getString("site_name"));
								v_fixreport.addElement(rs_fixreport.getString("comp_name"));
								v_fixreport.addElement(rs_fixreport.getString("comp_type"));
								if(EgInstallInfo.isSuperManager)
								{
									String msmt_time_str = rs_fixreport.getString("msmt_time");//2013-01-18 12:07:00.0
									int space = msmt_time_str.indexOf(" ");
									int dot = msmt_time_str.lastIndexOf(".");
									String msmt_time_is = null;
									if(dot>-1)
									{
										msmt_time_is = msmt_time_str.substring(space+1,dot);
									}
									else
									{
										msmt_time_is = msmt_time_str.substring(space+1);
										msmt_time_str = msmt_time_str + ".0";
									}
									Timestamp timestamp = Timestamp.valueOf(msmt_time_str);
									Time myTime = Time.valueOf(msmt_time_is);
									v_fixreport.addElement(new java.sql.Date(timestamp.getTime()));
									v_fixreport.addElement(myTime);

									String fix_date_str = rs_fixreport.getString("fix_date");//2013-01-18 12:07:00.0
									space = fix_date_str.indexOf(" ");
									dot = fix_date_str.lastIndexOf(".");
									String fix_date_is = null;
									if(dot>-1)
									{
										fix_date_is = fix_date_str.substring(space+1,dot);
									}
									else
									{
										fix_date_is = fix_date_str.substring(space+1);
										fix_date_str = fix_date_str + ".0";
									}
									Timestamp fix_timestamp = Timestamp.valueOf(fix_date_str);
									Time fix_myTime = Time.valueOf(fix_date_is);
									v_fixreport.addElement(new java.sql.Date(fix_timestamp.getTime()));
									v_fixreport.addElement(fix_myTime);
								}
								else
								{
										v_fixreport.addElement(rs_fixreport.getDate("msmt_time"));
										v_fixreport.addElement(rs_fixreport.getTime("msmt_time"));
										v_fixreport.addElement(rs_fixreport.getDate("fix_date"));
										v_fixreport.addElement(rs_fixreport.getTime("fix_date"));
								}								
								//v_fixreport.addElement(StringUtils.replaceURLsWithHyperlink(rs_fixreport.getString("prob_reason")));
								//v_fixreport.addElement(StringUtils.replaceURLsWithHyperlink(rs_fixreport.getString("prob_fix")));
								v_fixreport.addElement(rs_fixreport.getString("prob_reason"));
								v_fixreport.addElement(rs_fixreport.getString("prob_fix"));
								v_fixreport.addElement(rs_fixreport.getString("prob_fixed_by"));
								v_fixreport.addElement(rs_fixreport.getString("info"));
								v_fixreport.addElement(rs_fixreport.getString("test_name"));//11
								v_fixreport.addElement(rs_fixreport.getString("measure"));//12
							}
							rs_fixreport.close();
							egDb.releaseConnection(false);
							EgDbAdapterTypeUI.releaseObject(egDb);
						}
						catch(Exception ex)
						{
							String s_errmsg = "";
							if (!str_conn.equals("CONNECTED"))
							{
								s_errmsg = "Connection could not be established";
							}
							else if (!b_state == true)
							{
								s_errmsg = "Error in sql query while retrieving records pertaining to the User!	";
							}
							else if (!b_fixreport == true)
							{
								s_errmsg = "Error in sql query s_query(fixreport) ";
							}
							else
							{
								s_errmsg = ex.toString();
							}
							if (rs_fixreport != null)
							{
								try
								{
									rs_fixreport.close();
								}
								catch (Exception bug123)
								{
								}
							}
							if (rs_fixreport != null)
							{
								try
								{
									rs_fixreport.close();
								}
								catch (Exception bug123)
								{
								}
							}
							try
							{
								egDb.releaseConnection(true);
								EgDbAdapterTypeUI.releaseObject(egDb);
							}
							catch (Exception e2)
							{
								s_errmsg = "/final/monitor/EgProbsM.jsp?msg=" + s_errmsg;
						//Forwarding to the errorhandler
%>
								<jsp:forward page = "<%= s_errmsg %>"/>
<%
								return;
							}
						}
					}
				}
			}
	}
	else if(qry!=null && qry.equals("spec")&&(selectString==null || selectString.trim().equals("")))
	{
		//get fix history details for specific test measures.
		ResultSet ps_fixreport=null;
		String tmp_test=null;
		String cmp_type=null;
		String cmp_name=null;
		String site_name=null;
		String site_all=null;
		StringBuffer st=new StringBuffer();
		Vector commonName=new Vector();
		if(site==null && site.equalsIgnoreCase("ALL"))
		{
			site_name="";
		}
		if(site_name!=null && site_name.equalsIgnoreCase("ALL"))
		{
			for(int i=0;i<v_site.size();i++)
			{
				site_all=(String)v_site.get(i);
				st.append("'"+site_all+"',");
			}
			site_name=st.toString();
			site_name=site_name.substring(1,site_name.length()-2);
		}
		if(selName!=null&&!selName.equals("ALL"))
		{
			commonName.add(selName);
		}
		else if(selName!=null&&selName.equals("ALL"))
		{
			if(s_event.equals("Service"))
			{
				if(serverNames!=null && serverNames.size()>0)
				{
					commonName.addAll(serverNames);
				}
			}
			else if(s_event.equals("Zone"))
			{
				if(serverNames!=null && serverNames.size()>0)
				{
					commonName.addAll(serverNames);
				}
			}
			else if(s_event.equals("Segment"))
			{
				if(serverNames!=null && serverNames.size()>0)
				{
					commonName.addAll(serverNames);
				}
			}
		}
		if(commonName.size()>0)
		{
			egDb = EgDbAdapterTypeUI.getObject();
			str_conn = egDb.setConnection();
			String cname="";
			String ctype="";
			Vector compTypes = new Vector();
			compTypes.add("Host_system");

			if(commonName!=null&&commonName.size()==1)
			{
				String applyName=(String)commonName.get(0);
				cmp_type=applyName.substring(0,applyName.indexOf(":"));		
				cmp_name=applyName.substring(applyName.indexOf(":")+1,applyName.length());
				if(cmp_name!=null && !cmp_name.contains(":"))
				{
					cmp_name=cmp_name+":"+"NULL";
					cname=cmp_name;
				}
				else
				{
					cname=cname+",'"+cmp_name+"'";
					String hostComp=cmp_name.substring(0,cmp_name.indexOf(":"))+":NULL";
					cname=cname+",'"+hostComp+"'";
				}
				if(ctype_event != null && ctype_event.equals("ALL"))
				{
					if(serverCompTypeList != null && serverCompTypeList.size() > 0)
					{
						for(int p=0;p<serverCompTypeList.size();p++)
						{
							String tmp_ser = (String)serverCompTypeList.get(p);
							if(tmp_ser != null && !compTypes.contains(tmp_ser))
								compTypes.add(tmp_ser);
							//if(!compTypes.contains(cmp_type))
						}
					}
				}
				else
				{
					compTypes.add(cmp_type);
				}
			}
			else
			{
				for(int n=0;n<commonName.size();n++)
				{
					String applyName=(String)commonName.get(n);
					if(applyName != null && ctype_event !=null && !ctype_event.equals("ALL"))
					{
						if(applyName.startsWith(ctype_event))
						{
					cmp_type=applyName.substring(0,applyName.indexOf(":"));		
					cmp_name=applyName.substring(applyName.indexOf(":")+1,applyName.length());
					if(cmp_name!=null && !cmp_name.contains(":"))
					{
						cmp_name=cmp_name+":"+"NULL";
						cname=cname+",'"+cmp_name+"'";
					}
					else
					{
						cname=cname+",'"+cmp_name+"'";
						String hostComp=cmp_name.substring(0,cmp_name.indexOf(":"))+":NULL";
						cname=cname+",'"+hostComp+"'";
					}
						}
					}
					else if( ctype_event !=null && ctype_event.equals("ALL"))
					{
						cmp_type=applyName.substring(0,applyName.indexOf(":"));		
						cmp_name=applyName.substring(applyName.indexOf(":")+1,applyName.length());
						if(cmp_name!=null && !cmp_name.contains(":"))
						{

							cmp_name=cmp_name+":"+"NULL";
							cname=cname+",'"+cmp_name+"'";
						}
						else
						{
							cname=cname+",'"+cmp_name+"'";
							String hostComp=cmp_name.substring(0,cmp_name.indexOf(":"))+":NULL";
							cname=cname+",'"+hostComp+"'";
						}
					}
					if(ctype_event != null && ctype_event.equals("ALL"))
					{
						if(serverCompTypeList != null && serverCompTypeList.size() > 0)
						{
							for(int p=0;p<serverCompTypeList.size();p++)
							{
								String tmp_ser = (String)serverCompTypeList.get(p);
								if(tmp_ser != null && !compTypes.contains(tmp_ser))
									compTypes.add(tmp_ser);
								//if(!compTypes.contains(cmp_type))
							}
						}
					}
					else
					{
						if(!compTypes.contains(cmp_type))
							compTypes.add(cmp_type);
						//compTypes.add(cmp_type);
					}
					
				}
			}
			for(int n=0;n<compTypes.size();n++)
			{
				String comp_type=(String)compTypes.get(n);
				ctype=ctype+",'"+comp_type+"'";
			}
			if(cname!=null&&cname.length()>0&&cname.startsWith(","))
				cname=cname.substring(1);
			if(ctype!=null&&ctype.length()>0&&ctype.startsWith(","))
				ctype=ctype.substring(1);

				try
				{
					if (cname.indexOf(",") == -1)
					{
						cname = "'"+cname+"','-'";
					}
					else
					{
						cname = cname+",'-'";   //for export/import function 
					}
					ps_fixreport = egDb.SelectFixHistory_4(cname, ctype, site_name, test, meas, strtDateTime,endDateTime,false);
					c_state = egDb.getState();
					while (ps_fixreport.next())
					{
						p_fixreport.addElement(ps_fixreport.getString("site_name"));
					
						p_fixreport.addElement(ps_fixreport.getString("comp_name"));
						p_fixreport.addElement(ps_fixreport.getString("comp_type"));
						if(EgInstallInfo.isSuperManager)
						{
							String msmt_time_str = ps_fixreport.getString("msmt_time");//2013-01-18 12:07:00.0
							int space = msmt_time_str.indexOf(" ");
							int dot = msmt_time_str.lastIndexOf(".");
							String msmt_time_is = null;
							if(dot>-1)
							{
								msmt_time_is = msmt_time_str.substring(space+1,dot);
							}
							else
							{
								msmt_time_is = msmt_time_str.substring(space+1);
								msmt_time_str = msmt_time_str + ".0";
							}
							Timestamp timestamp = Timestamp.valueOf(msmt_time_str);
							Time myTime = Time.valueOf(msmt_time_is);
							p_fixreport.addElement(new java.sql.Date(timestamp.getTime()));
							p_fixreport.addElement(myTime);

							String fix_date_str = ps_fixreport.getString("fix_date");//2013-01-18 12:07:00.0
							space = fix_date_str.indexOf(" ");
							dot = fix_date_str.lastIndexOf(".");
							String fix_date_is = null;
							if(dot>-1)
							{
								fix_date_is = fix_date_str.substring(space+1,dot);
							}
							else
							{
								fix_date_is = fix_date_str.substring(space+1);
								fix_date_str = fix_date_str + ".0";
							}
							Timestamp fix_timestamp = Timestamp.valueOf(fix_date_str);
							Time fix_myTime = Time.valueOf(fix_date_is);
							p_fixreport.addElement(new java.sql.Date(fix_timestamp.getTime()));
							p_fixreport.addElement(fix_myTime);
						}
						else
						{
							p_fixreport.addElement(ps_fixreport.getDate("msmt_time"));
							p_fixreport.addElement(ps_fixreport.getTime("msmt_time"));
							p_fixreport.addElement(ps_fixreport.getDate("fix_date"));
							p_fixreport.addElement(ps_fixreport.getTime("fix_date"));
						}
						//p_fixreport.addElement(StringUtils.replaceURLsWithHyperlink(ps_fixreport.getString("prob_reason")));
						//p_fixreport.addElement(StringUtils.replaceURLsWithHyperlink(ps_fixreport.getString("prob_fix")));
						p_fixreport.addElement(ps_fixreport.getString("prob_reason"));
						p_fixreport.addElement(ps_fixreport.getString("prob_fix"));
						p_fixreport.addElement(ps_fixreport.getString("prob_fixed_by"));
						p_fixreport.addElement(ps_fixreport.getString("info"));
						p_fixreport.addElement(ps_fixreport.getString("test_name"));//11
						p_fixreport.addElement(ps_fixreport.getString("measure"));//12
					}
				}
				catch (Exception e)
				{
					String s_errmsg = "";
					if (!str_conn.equals("CONNECTED"))
					{
						s_errmsg = "Connection could not be established";
					}
					else if (!c_state == true)
					{
						s_errmsg = "Error in sql query while retrieving records pertaining to the User!	";
					}
					else if (!c_fixreport == true)
					{
						s_errmsg = "Error in sql query s_query(fixreport) ";
					}
					else
					{
						s_errmsg = e.toString();
					}
					if (ps_fixreport != null)
					{
						try
						{
							ps_fixreport.close();
						}
						catch (Exception bug123)
						{
						}
					}
					if (ps_fixreport != null)
					{
						try
						{
							ps_fixreport.close();
						}
						catch (Exception bug123)
						{
						}
					}
					try
					{
						egDb.releaseConnection(true);
						EgDbAdapterTypeUI.releaseObject(egDb);
					}
					catch (Exception e2)
					{
						s_errmsg = "/final/monitor/EgProbsM.jsp?msg=" + s_errmsg;
						//Forwarding to the errorhandler
%>

						<jsp:forward page = "<%= s_errmsg %>"/>

<% 
						return;
					}
				}
			try
			{
				ps_fixreport.close();
				egDb.releaseConnection(false);
				EgDbAdapterTypeUI.releaseObject(egDb);
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
	}
		
		String problem="";
		if(search == null)
			search = "";
%>



<%
	for(int g=0;g<event_for.size();g++)
	{
		String select_event = (String)event_for.get(g);
		if(select_event!=null && select_event.trim().length()>0 && select_event.equals(s_event))
		{

		}
		else
		{

		}
	}


	if(s_event!=null && s_event.length()>0 && (s_event.equals("Zone") || s_event.equals("Segment") || s_event.equals("Service")))
	{

		if((s_event!=null  && s_event.equals("Service")&& v_site.size()>1)||(s_event == null || s_event.equals("Component") && serverNames.size()>1) ||(s_event!=null && s_event.equals("Zone") &&  v_zone.size()>1)|| (s_event!=null && s_event.equals("Segment") && v_segment.size()>1))
		{

		}
		if(s_event != null && s_event.length()>0 && s_event.equalsIgnoreCase("Service"))
		{
			Collections.sort(v_site);
			if(v_site!=null && !v_site.isEmpty())
			{
					
				for(int m=0;m<v_site.size();m++)
				{
					String v_service=(String)v_site.get(m);
						
					if(v_service!=null && v_service.trim().length()>0 && v_service.equals(sub_event))
					{

					}
					else
					{

					}
				}
			}
		}
		else if(s_event != null && s_event.length()>0 && s_event.equalsIgnoreCase("Segment"))
		{
			if(v_segment!=null && !v_segment.isEmpty())
			{
				Collections.sort(v_segment);

				for(int m=0; m<v_segment.size();m++ )
				{
					String v_seg=(String)v_segment.get(m);
						
					if(v_seg!=null && v_seg.trim().length()>0 && v_seg.equals(sub_event))
					{

					}
					else
					{

					}
				}
			}
		}
		else if(s_event!=null && s_event.length()>0 && s_event.equalsIgnoreCase("Zone"))
		{
			if(v_zone!=null && !v_zone.isEmpty())
			{
				Collections.sort(v_zone);

				for(int z=0;z<v_zone.size(); z++)
				{
					String getZone=(String)v_zone.get(z);
					if(getZone!=null && getZone.trim().length()>0 && getZone.equals(sub_event))
					{

					}
					else
					{

					}
				}
			}
		}

		if(s_event!=null && s_event.length()>0 && (s_event.equals("Zone")))
		{

			if(includesubzone!=null && includesubzone.trim().length()>0 && includesubzone.equalsIgnoreCase("yes"))
			{

			}
			else
			{

			}

		}
		else
		{

		}
	}
	else
	{

	}

											if(serverCompTypeList !=null && serverCompTypeList.size() > 0)
											{
												
												for(int i=0;i<serverCompTypeList.size();i++)
												{
													String selected = "";
													String temp_server = (String)serverCompTypeList.get(i);
													if(temp_server!=null && ctype_event != null && temp_server.equals(ctype_event) )
													{
														selected="selected";
													}
													
													//if(temp_server!=null && temp_server.trim().length()>0 )
													
													//{

													//}
												}
											}

		if(search != null && !search.equals(""))
		{
			StringTokenizer tok = new StringTokenizer(search);
			int noOfsearchs = tok.countTokens();

			ArrayList searchTokens = new ArrayList();
			ArrayList searchedComponets = new ArrayList();
			while(tok.hasMoreTokens())
			{
				searchTokens.add(tok.nextToken());
			}
			for(int i=0;i < serverNames.size();i++)
			{
				String compt =(String)serverNames.get(i);
				// fro removing display name of the component type
				String tcomponent=compt.substring(0,compt.lastIndexOf(":"));
				String searchName = null;
				int y=0;
				for(int x=0;x<searchTokens.size();x++)
				{
					searchName = (String) searchTokens.get(x);
					//if(compt.toUpperCase().indexOf(searchName.toUpperCase())!=-1)
					String tmp_search_name = ":"+searchName;
					if(compt.toUpperCase().indexOf(tmp_search_name.toUpperCase())!=-1)
					{
						y++;
					}
				}
				if(y==noOfsearchs)
				{
					searchedComponets.add(compt);
				}
			}
			serverNames = searchedComponets;
		}
		if(ctype_event != null && ctype_event.trim().length() > 0 && !ctype_event.equals(""))
		{
			List temp_serverNames =  new LinkedList();
			List temp_serverNames2 =  new LinkedList();
			temp_serverNames = serverNames;
			//serverNames.clear();
			if(temp_serverNames != null && !temp_serverNames.isEmpty())
			{
				for(int i=0;i<temp_serverNames.size();i++)
				{
					String temp_names=(String)temp_serverNames.get(i);
					if(temp_names!= null && temp_names.startsWith(ctype_event))
					{
						temp_serverNames2.add(temp_names);
					}
				}
			}
			if(temp_serverNames2 != null && temp_serverNames2.size() > 0)
			{
				serverNames.clear();
				serverNames = temp_serverNames2;
			}
		}
		if((s_event!=null  && s_event.equals("Service")&& serverNames.size()>1)||(s_event == null || s_event.equals("Component") && serverNames.size()>1) ||(s_event!=null && s_event.equals("Zone") && serverNames.size()>1)|| (s_event!=null && s_event.equals("Segment") && serverNames.size()>1))
		{

	}
	else if((s_event!=null && s_event.equals("Zone") && serverNames.size()==0))
	{

	}
	if(s_event == null ||s_event.trim().length()==0 || s_event.equals("Component"))
	{
		Collections.sort(serverNames);
		String names="";
		String cmptype="";
		String dispName="";
		for(int i=0;i<serverNames.size();i++)
		{
			names=(String)serverNames.get(i);
			if(names!=null && names.contains(":"))
			{
				cmptype=names.substring(0,names.indexOf(":"));
				dispName=names.substring(names.indexOf(":")+1,names.length());
				
			}
			if (dispName != null && dispName.equals("-"))
			{
				continue;
			}
			String selected="";
			if(names!=null && names.equals(selName))
			{
				selected="selected";
			}
				else if(names != null && ctype_event != null && serverNames.size() == 1)
				{
					selected="selected";
				}

		}
	}
	else if(s_event!=null && s_event.trim().length()>0 && s_event.equals("Service"))
	{
		if((sub_event!=null && sub_event.trim().length()>0)||(sub_event!=null && sub_event.equals("ALL")))
		{
			Collections.sort(serverNames);
			for(int i=0;i<serverNames.size();i++)
			{
				String com_service=(String)serverNames.get(i);
				service_dis.add(com_service);
			}
			String names="";
			String cmptype="";
			String dispName="";
			for(int i=0;i<serverNames.size();i++)
			{
				names=(String)serverNames.get(i);
				if(names!=null && names.contains(":"))
				{
					cmptype=names.substring(0,names.indexOf(":"));
					dispName=names.substring(names.indexOf(":")+1,names.length());
				}
				String selected="";
				if(names!=null && names.equals(selName))
				{
					selected="selected";
				}
					else if(names != null && ctype_event != null && serverNames.size() == 1)
					{
						selected="selected";
					}

			}
		}
		else 
		{

		}
	}
	else if(s_event!=null && s_event.trim().length()>0 && s_event.equals("Segment"))
	{
		if((sub_event!=null && sub_event.trim().length()>0)||(sub_event!=null && sub_event.equals("ALL")))
		{
			Collections.sort(serverNames);
			for(int i=0;i<serverNames.size();i++)
			{
				String com_service=(String)serverNames.get(i);
				service_dis.add(com_service);
			}
			String names="";
			String cmptype="";
			String dispName="";

			for(int i=0;i<serverNames.size();i++)
			{
				names=(String)serverNames.get(i);
				if(names!=null && names.contains(":"))
				{
					cmptype=names.substring(0,names.indexOf(":"));
					dispName=names.substring(names.indexOf(":")+1,names.length());
				}
				String selected="";
				if(names!=null && names.equals(selName))
				{
					selected="selected";
				}
					else if(names != null && ctype_event != null && serverNames.size() == 1)
					{
						selected="selected";
					}

			}
		}
		else
		{

		}
	}
	else if(s_event!=null && s_event.trim().length()>0 && s_event.equals("Zone"))
	{
		if((sub_event!=null && sub_event.trim().length()>0)||(sub_event!=null && sub_event.equals("ALL")))
		{
			Collections.sort(serverNames);
			for(int i=0;i<serverNames.size();i++)
			{
				String com_service=(String)serverNames.get(i);
				service_dis.add(com_service);
			}
			String names="";
			String cmptype="";
			String dispName="";
				
			for(int i=0;i<serverNames.size();i++)
			{
				names=(String)serverNames.get(i);
				if(names!=null && names.contains(":"))
				{
					cmptype=names.substring(0,names.indexOf(":"));
					dispName=names.substring(names.indexOf(":")+1,names.length());
						
				}
				String selected="";
				if(names!=null && names.equals(selName))
				{
					selected="selected";
				}
					else if(names != null && ctype_event != null && serverNames.size() == 1)
					{
						selected="selected";
					}

			}
		}
	}
	else
	{


	
		for(int i=0;i<servers.size();i++)
		{
			String serName=(String)servers.get(i);
			serName=serName.substring(serName.indexOf(":")+1,serName.length());


		}
	}




	if((selName!=null)&&(!selName.equals("ALL")))
	{
		ResultSet ls_report=null;
		//egDb = EgDbAdapterTypeUI.getObject();
		try
		{
			if(selName!=null)
			{
				tem_name=selName.substring(0,selName.indexOf(":"));
			}

			//str_conn=egDb.setConnection();
			//ls_report=egDb.SelectEgGraphGen_1(tem_name);
			ArrayList layerList=tab.getSortedLayersForComponent(tem_name,"desc");
			if(layerList!=null)
				layer_list.addAll(layerList);
			/*while(ls_report.next())
			{
				layer_list.addElement(ls_report.getString("layer_name"));
			}*/
			test_layer.addAll(layer_list);
			String dispLay="";
			for(int i=0;i<layer_list.size();i++)
			{
				dispLay=(String)layer_list.get(i);
				String selected="";
				if(layName!=null && layName.equals(dispLay))
				{
					selected="selected";
				}
				String sortLayer=mappingInfo.getLayerDescription(dispLay);

			}
			//ls_report.close();
			//egDb.releaseConnection(false);
			//EgDbAdapterTypeUI.releaseObject(egDb);
		}
		catch(Exception ex)
		{
			String s_errmsg = "";
			if (!str_conn.equals("CONNECTED"))
			{
				s_errmsg = "Connection could not be established";
			}
			else if (!b_state == true)
			{
				s_errmsg = "Error in sql query while retrieving records pertaining to the User!	";
			}
			else if (!b_fixreport == true)
			{
				s_errmsg = "Error in sql query s_query(fixreport) ";
			}
			else
			{
				s_errmsg = ex.toString();
			}

			/*if (ls_report != null)
			{
				try
				{
					ls_report.close();
				}
				catch (Exception bug123)
				{
				}
			}

			if (ls_report != null)
			{
				try
				{
					ls_report.close();
				}
				catch (Exception bug123)
				{
				}
			}*/

			try
			{
				//egDb.releaseConnection(true);
				//EgDbAdapterTypeUI.releaseObject(egDb);
			}
			catch (Exception e2)
			{
				s_errmsg = "/final/monitor/EgProbsM.jsp?msg=" + s_errmsg;
					//Forwarding to the errorhandler
%>

					<jsp:forward page = "<%= s_errmsg %>"/>

<% 
					return;
			}
		}
	}
	else if((selName!=null && selName.equals("ALL") || s_event!=null && s_event.equals("Component"))||(selName!=null && selName.equals("ALL") && s_event!=null && s_event.equals("Service"))||(selName!=null && selName.equals("ALL") || s_event!=null && s_event.equals("Zone"))|| (s_event!=null && s_event.equals("Service"))||(s_event!=null && s_event.equals("Segment")))
	{
		ResultSet fs_report=null;
		ArrayList com_type=new ArrayList();
		Vector list_layer=new Vector();
		String cmptypelist=null;
		String temp1=null;
		if(s_event.equals("Component"))
		{
			for(int i=0;i<servers.size();i++)
			{
				String temp=(String)servers.get(i);
				cmptypelist=temp.substring(0,temp.indexOf(":"));
				com_type.add(cmptypelist);
			}
		}
		else
		{
			for(int i=0;i<serverNames.size();i++)
			{
				String temp=(String)serverNames.get(i);
				cmptypelist=temp.substring(0,temp.indexOf(":"));
				com_type.add(cmptypelist);
			}
		}
		if(com_type!=null&&com_type.size()>0)
		{
			//egDb = EgDbAdapterTypeUI.getObject();
			try
			{
				//str_conn=egDb.setConnection();
				String ctype="";
				if(com_type.size()==1)
				{
					ctype=(String)com_type.get(0);
				}
				else
				{
					for(int g=0;g<com_type.size();g++)
					{
						ctype=ctype+",'"+(String)com_type.get(g)+"'";
					}
				}
				if(ctype!=null&&ctype.startsWith(","))
					ctype=ctype.substring(1);
				//fs_report=egDb.SelectEgGraphGen_1(ctype);
				ArrayList layerList=tab.getSortedLayersForComponent(ctype,"desc");
				if(layerList!=null)
				{
					//while(fs_report.next())
					for(int kk=0;kk<layerList.size();kk++)
					{
						//String tmp=(String)fs_report.getString("layer_name");
						String tmp =(String)layerList.get(kk);
						if(list_layer!=null && list_layer.size()>0)
						{
							if(!list_layer.contains(tmp))
							{
								list_layer.addElement(tmp);
							}
						}
						else
						{
							list_layer.addElement(tmp);
						}
					}
				}
				Collections.sort(list_layer);
				test_layer.addAll(list_layer);
				String dispLay="";
				for(int i=0;i<list_layer.size();i++)
				{
					dispLay=(String)list_layer.get(i);
					String selected="";
					if(layName!=null && layName.equals(dispLay))
					{
						selected="selected";
					}
%>
												<option value="<%=dispLay%>" <%=selected%>><egui:intnl layer="<%=dispLay%>"/></option>
<%
				}
				//fs_report.close();
				//egDb.releaseConnection(false);
				//EgDbAdapterTypeUI.releaseObject(egDb);
				}
			catch(Exception ex)
			{
				String s_errmsg = "";
				if (!str_conn.equals("CONNECTED"))
				{
					s_errmsg = "Connection could not be established";
				}
				else if (!b_state == true)
				{
					s_errmsg = "Error in sql query while retrieving records pertaining to the User!	";
				}
				else if (!b_fixreport == true)
				{
					s_errmsg = "Error in sql query s_query(fixreport) ";
				}
				else
				{
					s_errmsg = ex.toString();
				}
				/*if (fs_report != null)
				{
					try
					{
						fs_report.close();
					}
					catch (Exception bug123)
					{
					}
				}
				if (fs_report != null)
				{
					try
					{
						fs_report.close();
					}
					catch (Exception bug123)
					{
					}
				}*/
				try
				{
					//egDb.releaseConnection(true);
					//EgDbAdapterTypeUI.releaseObject(egDb);
				}
				catch (Exception e2)
				{
					s_errmsg = "/final/monitor/EgProbsM.jsp?msg=" + s_errmsg;
					//Forwarding to the errorhandler
%>
					<jsp:forward page = "<%= s_errmsg %>"/>
<% 
					return;
				}
			}
		}
	}

	if((layName!=null && !layName.equals("ALL") && selName!=null) && !selName.equals("ALL"))
	{
		ResultSet ts_report=null;
		egDb = EgDbAdapterTypeUI.getObject();
		try
		{
			if(selName!=null)
				type_comp=selName.substring(0,selName.indexOf(":"));
				name_comp=selName.substring(selName.indexOf(":")+1,selName.length());
			if(name_comp!=null && name_comp.indexOf(":")<0)
			{
				name_comp=name_comp+":"+"NULL";
			}
			str_conn=egDb.setConnection();
			ts_report=egDb.SelectEgGraphGen_2(site,name_comp,layName,type_comp);
			b_state1=egDb.getState();
			while(ts_report.next())
			{
				String stest = (String)ts_report.getString("test_name");
				if(testdeatils!=null && testdeatils.size()>0)
				{
					if(!testdeatils.contains(stest))
					{
						testdeatils.add(stest);	
					}
				}
				else
				{
					testdeatils.add(stest);
				}
			}
			all_test.addAll(testdeatils);
			Collections.sort(testdeatils);
			for(int i=0;i<testdeatils.size();i++)
			{
				String  disptest=(String)testdeatils.get(i);
				String selected="";
				if(test!=null && test.equals(disptest))
				{
					selected="selected";
				}

			}
			ts_report.close();
			egDb.releaseConnection(false);
			EgDbAdapterTypeUI.releaseObject(egDb);
		}
		catch(Exception ex)
		{
			String s_errmsg = "";
			if (!str_conn.equals("CONNECTED"))
			{
				s_errmsg = "Connection could not be established";
			}
			else if (!b_state == true)
			{
				s_errmsg = "Error in sql query while retrieving records pertaining to the User!	";
			}
			else if (!b_fixreport == true)
			{
				s_errmsg = "Error in sql query s_query(fixreport) ";
			}
			else
			{
				s_errmsg = ex.toString();
			}
			if (ts_report != null)
			{
				try
				{
					ts_report.close();
				}
				catch (Exception bug123)
				{
				}
			}
			if (ts_report != null)
			{
				try
				{
					ts_report.close();
				}
				catch (Exception bug123)
				{
				}
			}
			try
			{
				egDb.releaseConnection(true);
				EgDbAdapterTypeUI.releaseObject(egDb);
			}
			catch (Exception e2)
			{
				s_errmsg = "/final/monitor/EgProbsM.jsp?msg=" + s_errmsg;
					//Forwarding to the errorhandler
%>
					<jsp:forward page = "<%= s_errmsg %>"/>
<% 
					return;
			}
		}
	}
	else if(selName!=null && selName.equals("ALL"))
	{
		String dis_test=null;
		if(layName!=null )
		{
			testlayer=tab.getTestsForLayer(layName);
		}
		all_test.addAll(testlayer);
		Collections.sort(testlayer);
		if(testlayer.size()>0)
		{
			for(int i=0;i<testlayer.size();i++)
			{
				dis_test=(String)testlayer.get(i);
				String selected="";
				if(test!=null && test.equals(dis_test))
					selected="selected";

			}
		}
	}

	if((layName!=null)&&(test!=null))
	{
		if(!test.equals("ALL"))
		{
			str_mes_list = dbinfo.getColumnNamesForTest(test,layName);
			if(str_mes_list!=null && str_mes_list.length>0)
			{
				for(int i=0;i < str_mes_list.length ;i = i+2)
				{
					String temp=dbinfo.getMeasureForColumn(test,str_mes_list[i]);
					String display = test + ":" + temp;
						String selected="";
						if(meas!=null && meas.equalsIgnoreCase(temp))
							selected="selected";
							meas_list.add(temp);

				}
			}
		}
	}


	//for csv
	vec_Tabletitle.add(mappingInfo.getTextDescription("monitor.csv.Comp Type"));
	vec_Tabletitle.add(mappingInfo.getTextDescription("monitor.csv.Component Name"));
	vec_Tabletitle.add(mappingInfo.getTextDescription("monitor.csv.Test"));
	vec_Tabletitle.add(mappingInfo.getTextDescription("monitor.csv.Descriptor"));
	vec_Tabletitle.add(mappingInfo.getTextDescription("monitor.csv.Measure"));
	vec_Tabletitle.add(mappingInfo.getTextDescription("monitor.csv.Problem"));
	vec_Tabletitle.add(mappingInfo.getTextDescription("monitor.csv.Fix"));
	vec_Tabletitle.add(mappingInfo.getTextDescription("monitor.csv.Problem Time"));
	vec_Tabletitle.add(mappingInfo.getTextDescription("monitor.csv.Fix Time"));
	vec_Tabletitle.add("\n");
	vec_Tabletitle.add("\n");
	//csv ends

	ArrayList comp_details = new ArrayList();
	Hashtable allComps_hash = new Hashtable();
	Hashtable selComps_hash = new Hashtable();
	String tmpDate = "";

	if((qry!=null && qry.equals("ALL")||(zon!=null&& zon.equals("zon"))||(serv!=null && serv.equals("Serv"))||(seg!=null && seg.equals("Seg")))&&(selectString==null || selectString.trim().equals("")))
	{
		//To Display all fix history details for components or services or segments or zones
		dataSize=v_fixreport.size();
		if(v_fixreport.size() != 0)
		{
			int count = 0;
			for (int i = 0; i < (v_fixreport.size()); i = i + 13, count = count + 13)
			{
				java.sql.Date msmtdate = (java.sql.Date)v_fixreport.elementAt(i + 3);
				String str_msmtdate = msmtdate.toString();
				String str_msmtday = str_msmtdate.substring(str_msmtdate.lastIndexOf("-") + 1, str_msmtdate.length());
				String str_msmtmonth = str_msmtdate.substring(str_msmtdate.indexOf("-") + 1,
															  str_msmtdate.lastIndexOf("-"));
				String str_msmtyear = str_msmtdate.substring(0, str_msmtdate.indexOf("-"));
				java.sql.Time msmttime = (java.sql.Time)v_fixreport.elementAt(i + 4);
				String str_msmttime = msmttime.toString();
				String probDate = str_msmtmonth + "/" + str_msmtday + "/" + str_msmtyear;
				String s_edit_msmttime = probDate + "*" + str_msmttime;
				java.sql.Date fixdate = (java.sql.Date)v_fixreport.elementAt(i + 5);
				String str_fixdate = fixdate.toString();
				String str_fixday = str_fixdate.substring(str_fixdate.lastIndexOf("-") + 1, str_fixdate.length());
				String str_fixmonth = str_fixdate.substring(str_fixdate.indexOf("-") + 1, str_fixdate.lastIndexOf("-"));
				String str_fixyear = str_fixdate.substring(0, str_fixdate.indexOf("-"));
				java.sql.Time fixtime = (java.sql.Time)v_fixreport.elementAt(i + 6);
				String str_fixtime = fixtime.toString();
				String fixDate = str_fixmonth + "/" + str_fixday + "/" + str_fixyear;
				String s_edit_fixtime = fixDate + "*" + str_fixtime;
				fixDate = DateUtil.changeDateFormat(fixDate,"MM/dd/yyyy",currentDateFormat);
				s_edit_fixtime  = fixDate +" "+ str_fixtime;
				probDate = DateUtil.changeDateFormat(probDate,"MM/dd/yyyy",currentDateFormat);
				s_edit_msmttime = probDate +" "+ str_msmttime;
				String s_dispInfo = (String)v_fixreport.elementAt(i + 10);
				String dispCompType = (String)v_fixreport.elementAt(i+2);
				String disp_component = (String)v_fixreport.elementAt(i + 1);
				if(disp_component!=null && disp_component.endsWith(":NULL"))
				{
					disp_component=disp_component.substring(0,disp_component.indexOf(":"));
				}
				ArrayList temp_details = new ArrayList();
				if(s_dispInfo!=null &&s_edit_msmttime!=null && s_edit_fixtime!=null && dispCompType!=null)
				{
					temp_details.add(disp_component);
					temp_details.add(dispCompType);
					temp_details.add(s_dispInfo);
					temp_details.add(v_fixreport.elementAt(i + 3));
					temp_details.add(v_fixreport.elementAt(i + 4));
					temp_details.add(s_edit_msmttime);
					temp_details.add(s_edit_fixtime);
					temp_details.add(v_fixreport.elementAt(i + 7));
					temp_details.add(v_fixreport.elementAt(i + 8));
					temp_details.add(v_fixreport.elementAt(i + 9));
					temp_details.add(v_fixreport.elementAt(i + 11));
					temp_details.add(v_fixreport.elementAt(i + 12));
					
				}
				if(temp_details!=null && temp_details.size()>0)
				{
					if(disp_component.equalsIgnoreCase(selName))
					{
						if(selComps_hash.containsKey(disp_component))
						{
							comp_details = (ArrayList)selComps_hash.get(disp_component);
							comp_details.add(temp_details);
							selComps_hash.put(disp_component,comp_details);
						}
						else
						{
							comp_details.add(temp_details);
							selComps_hash.put(disp_component,comp_details);
						}
					}
					else
					{
						if(allComps_hash.containsKey(disp_component))
						{
							comp_details = (ArrayList)allComps_hash.get(disp_component);
							comp_details.add(temp_details);
							allComps_hash.put(disp_component,comp_details);
						}
						else
						{
							comp_details.add(temp_details);
							allComps_hash.put(disp_component,comp_details);
						}
					}
				}
			}
		}
	}
	else if(qry!=null && qry.equals("spec")||(qry!=null && qry.equals("spec") && s_event.equals("Service")&& sub_event!=null && sub_event.equals("ALL"))&&(selectString==null && selectString.trim().equals("")))
	{
		dataSize=p_fixreport.size();
		if (p_fixreport.size() != 0)
		{
			int count = 0;
			for (int i = 0; i < (p_fixreport.size()); i = i + 13, count = count + 13)
			{
				java.sql.Date msmtdate = (java.sql.Date)p_fixreport.elementAt(i + 3);
				String str_msmtdate = msmtdate.toString();
				String str_msmtday = str_msmtdate.substring(str_msmtdate.lastIndexOf("-") + 1, str_msmtdate.length());
				String str_msmtmonth = str_msmtdate.substring(str_msmtdate.indexOf("-") + 1,
															  str_msmtdate.lastIndexOf("-"));
				String str_msmtyear = str_msmtdate.substring(0, str_msmtdate.indexOf("-"));
				java.sql.Time msmttime = (java.sql.Time)p_fixreport.elementAt(i + 4);
				String str_msmttime = msmttime.toString();
				String probDate = str_msmtmonth + "/" + str_msmtday + "/" + str_msmtyear;
				String s_edit_msmttime = probDate + "*" + str_msmttime;
				java.sql.Date fixdate = (java.sql.Date)p_fixreport.elementAt(i + 5);
				String str_fixdate = fixdate.toString();
				String str_fixday = str_fixdate.substring(str_fixdate.lastIndexOf("-") + 1, str_fixdate.length());
				String str_fixmonth = str_fixdate.substring(str_fixdate.indexOf("-") + 1, str_fixdate.lastIndexOf("-"));
				String str_fixyear = str_fixdate.substring(0, str_fixdate.indexOf("-"));
				java.sql.Time fixtime = (java.sql.Time)p_fixreport.elementAt(i + 6);
				String str_fixtime = fixtime.toString();
				String fixDate = str_fixmonth + "/" + str_fixday + "/" + str_fixyear;
				String s_edit_fixtime = fixDate + "*" + str_fixtime;
				fixDate = DateUtil.changeDateFormat(fixDate,"MM/dd/yyyy",currentDateFormat);
				s_edit_fixtime  = fixDate +" "+ str_fixtime;
				probDate = DateUtil.changeDateFormat(probDate,"MM/dd/yyyy",currentDateFormat);
				s_edit_msmttime = probDate +" "+ str_msmttime;
				String s_dispInfo = (String)p_fixreport.elementAt(i + 10);
				String dispCompType = (String)p_fixreport.elementAt(i+2);
				String disp_component = (String)p_fixreport.elementAt(i + 1);
				if(disp_component!=null && disp_component.endsWith(":NULL"))
				{
					disp_component=disp_component.substring(0,disp_component.indexOf(":"));
				}
				ArrayList temp_details = new ArrayList();
				if(s_dispInfo!=null &&s_edit_msmttime!=null && s_edit_fixtime!=null && dispCompType!=null)
				{
					temp_details.add(disp_component);
					temp_details.add(dispCompType);
					temp_details.add(s_dispInfo);
					temp_details.add(p_fixreport.elementAt(i + 3));
					temp_details.add(p_fixreport.elementAt(i + 4));
					temp_details.add(s_edit_msmttime);
					temp_details.add(s_edit_fixtime);
					temp_details.add(p_fixreport.elementAt(i + 7));
					temp_details.add(p_fixreport.elementAt(i + 8));
					temp_details.add(p_fixreport.elementAt(i + 9));
					temp_details.add(p_fixreport.elementAt(i + 11));
					temp_details.add(p_fixreport.elementAt(i + 12));
				}
				if(temp_details!=null && temp_details.size()>0)
				{
					if(disp_component.equalsIgnoreCase(selName))
					{
						if(selComps_hash.containsKey(disp_component))
						{
							comp_details = (ArrayList)selComps_hash.get(disp_component);
							comp_details.add(temp_details);
							selComps_hash.put(disp_component,comp_details);
						}
						else
						{
							comp_details.add(temp_details);
							selComps_hash.put(disp_component,comp_details);
						}
					}
					else
					{
						if(allComps_hash.containsKey(disp_component))
						{
							comp_details = (ArrayList)allComps_hash.get(disp_component);
							comp_details.add(temp_details);
							allComps_hash.put(disp_component,comp_details);
						}
						else
						{
							comp_details.add(temp_details);
							allComps_hash.put(disp_component,comp_details);
						}
					}
				}
			}
		}
	}
	else if(qry!=null && qry.equals("Layspec")&&(selectString==null || selectString.trim().equals("")))
	{
		ResultSet layer_fixreport=null;
		ResultSet test_fixreport=null;
		if(complayer!=null && complayer.equals("complayer"))
		{
			String cmp_name="";
			String cmp_type="";
			String com_name="";
			String com_type="";
			String all_name="";
			String host_name="";
			String host_type="";
			String cname="";
			String ctype="";
			StringBuffer sb1=new StringBuffer();
			StringBuffer sb2=new StringBuffer();
			Vector host_list=new Vector();
			Vector commonName=new Vector();
			Vector compTypes=new Vector();
			if(selName!=null && !selName.equals("ALL"))
			{
				commonName.add(selName);
			}
			else if(selName!=null&&selName.equals("ALL"))
			{
				if(s_event.equals("Component"))
				{
					if(serverNames!=null && serverNames.size()>0)
					{
						commonName.addAll(serverNames);
					}
				}
				else if(s_event.equals("Service"))
				{
					if(serverNames!=null && serverNames.size()>0)
					{
						commonName.addAll(serverNames);
					}
				}
				else if(s_event.equals("Zone"))
				{
					if(serverNames!=null && serverNames.size()>0)
					{
						commonName.addAll(serverNames);
					}
				}
				else if(s_event.equals("Segment"))
				{
					if(serverNames!=null && serverNames.size()>0)
					{
						commonName.addAll(serverNames);
					}
				}
			}
			if(commonName!=null&&commonName.size()==1)
			{
				String applyName=(String)commonName.get(0);
				cmp_type=applyName.substring(0,applyName.indexOf(":"));		
				cmp_name=applyName.substring(applyName.indexOf(":")+1,applyName.length());
				compTypes.add("Host_system");
				if(cmp_name!=null && !cmp_name.contains(":"))
				{
					cmp_name=cmp_name+":"+"NULL";
					cname=cmp_name;
				}
				else
				{
					cname=cname+",'"+cmp_name+"'";
					String hostComp=cmp_name.substring(0,cmp_name.indexOf(":"))+":NULL";
					cname=cname+",'"+hostComp+"'";
				}
				if(!compTypes.contains(cmp_type))
					compTypes.add(cmp_type);
			}
			else if(commonName!=null && commonName.size()>0)
			{
				compTypes.add("Host_system");
				for(int n=0;n<commonName.size();n++)
				{
					String applyName=(String)commonName.get(n);
					cmp_type=applyName.substring(0,applyName.indexOf(":"));		
					cmp_name=applyName.substring(applyName.indexOf(":")+1,applyName.length());
					if(cmp_name!=null && !cmp_name.contains(":"))
					{
						cmp_name=cmp_name+":"+"NULL";
						cname=cname+",'"+cmp_name+"'";	
					}
					else
					{
						cname=cname+",'"+cmp_name+"'";	
						String hostComp=cmp_name.substring(0,cmp_name.indexOf(":"))+":NULL";
						cname=cname+",'"+hostComp+"'";
					}
					if(!compTypes.contains(cmp_type))
						compTypes.add(cmp_type);
				}
			}
			for(int n=0;n<compTypes.size();n++)
			{
				String comp_type=(String)compTypes.get(n);
				ctype=ctype+",'"+comp_type+"'";
			}
			if(cname!=null&&cname.length()>0&&cname.startsWith(","))
				cname=cname.substring(1);
			if(ctype!=null&&ctype.length()>0&&ctype.startsWith(","))
				ctype=ctype.substring(1);
				StringBuffer sb=new StringBuffer();
				String test_all="";
				if(testlayer!=null&&testlayer.size()>0 && (selName!=null&&selName.equals("ALL")))
				{
					Iterator itr2=testlayer.iterator();
					while(itr2.hasNext())
					{
						String key = (String)itr2.next();
						sb.append("'"+key+"',");
					}
						test_all=sb.toString();
						test_all=test_all.substring(1,test_all.length()-2);
				}
				else if(all_test!=null && all_test.size()>0)
				{
					Iterator itr2=all_test.iterator();
					while(itr2.hasNext())
					{
						String key = (String)itr2.next();
						sb.append("'"+key+"',");
					}
					test_all=sb.toString();
					test_all=test_all.substring(1,test_all.length()-2);
				}
				if(all_test.size()==0 && testlayer.size()==0)
				{
					test_all="ALL";
				}
					egDb = EgDbAdapterTypeUI.getObject();
					try
					{
						if (cname.indexOf(",") == -1)
						{
							cname = "'"+cname+"','-'";
						}
						else
						{
							cname = cname+",'-'";   //for export/import function 
						}
						str_conn=egDb.setConnection();
						test_fixreport=egDb.SelectFixHistoryTest(strtDateTime,endDateTime,test_all,ctype,cname);
						while(test_fixreport.next())
						{
							alltest_fixreport.addElement(test_fixreport.getString("site_name"));
							alltest_fixreport.addElement(test_fixreport.getString("comp_name"));
							alltest_fixreport.addElement(test_fixreport.getString("comp_type"));
							if(EgInstallInfo.isSuperManager)
							{
								String msmt_time_str = test_fixreport.getString("msmt_time");//2013-01-18 12:07:00.0
								int space = msmt_time_str.indexOf(" ");
								int dot = msmt_time_str.lastIndexOf(".");
								String msmt_time_is = null;
								if(dot>-1)
								{
									msmt_time_is = msmt_time_str.substring(space+1,dot);
								}
								else
								{
									msmt_time_is = msmt_time_str.substring(space+1);
									msmt_time_str = msmt_time_str + ".0";
								}
								Timestamp timestamp = Timestamp.valueOf(msmt_time_str);
								Time myTime = Time.valueOf(msmt_time_is);
								alltest_fixreport.addElement(new java.sql.Date(timestamp.getTime()));
								alltest_fixreport.addElement(myTime);

								String fix_date_str = test_fixreport.getString("fix_date");//2013-01-18 12:07:00.0
								space = fix_date_str.indexOf(" ");
								dot = fix_date_str.lastIndexOf(".");
								String fix_date_is = null;
								if(dot>-1)
								{
									fix_date_is = fix_date_str.substring(space+1,dot);
								}
								else
								{
									fix_date_is = fix_date_str.substring(space+1);
									fix_date_str = fix_date_str + ".0";
								}
								Timestamp fix_timestamp = Timestamp.valueOf(fix_date_str);
								Time fix_myTime = Time.valueOf(fix_date_is);
								alltest_fixreport.addElement(new java.sql.Date(fix_timestamp.getTime()));
								alltest_fixreport.addElement(fix_myTime);
							}
							else
							{
								alltest_fixreport.addElement(test_fixreport.getDate("msmt_time"));
								alltest_fixreport.addElement(test_fixreport.getTime("msmt_time"));
								alltest_fixreport.addElement(test_fixreport.getDate("fix_date"));
								alltest_fixreport.addElement(test_fixreport.getTime("fix_date"));
							}
							//alltest_fixreport.addElement(StringUtils.replaceURLsWithHyperlink(test_fixreport.getString("prob_reason")));
							//alltest_fixreport.addElement(StringUtils.replaceURLsWithHyperlink(test_fixreport.getString("prob_fix")));
							alltest_fixreport.addElement(test_fixreport.getString("prob_reason"));
							alltest_fixreport.addElement(test_fixreport.getString("prob_fix"));
							alltest_fixreport.addElement(test_fixreport.getString("prob_fixed_by"));
							alltest_fixreport.addElement(test_fixreport.getString("info"));
							alltest_fixreport.addElement(test_fixreport.getString("test_name"));//11
							alltest_fixreport.addElement(test_fixreport.getString("measure"));//12
						}
						test_fixreport.close();
						egDb.releaseConnection(false);
						EgDbAdapterTypeUI.releaseObject(egDb);
					}
					catch(Exception ex)
					{
						String s_errmsg = "";
						if (!str_conn.equals("CONNECTED"))
						{
							s_errmsg = "Connection could not be established";
						}
						else if (!b_state == true)
						{
							s_errmsg = "Error in sql query while retrieving records pertaining to the User!	";
						}
						else if (!b_fixreport == true)
						{
							s_errmsg = "Error in sql query s_query(fixreport) ";
						}
						else
						{
							s_errmsg = ex.toString();
						}
						if (test_fixreport != null)
						{
							try
							{
								test_fixreport.close();
							}
							catch (Exception bug123)
							{
							}
						}
						if (test_fixreport != null)
						{
							try
							{
								test_fixreport.close();
							}
							catch (Exception bug123)
							{
							}
						}
						try
						{
							egDb.releaseConnection(true);
							EgDbAdapterTypeUI.releaseObject(egDb);
						}
						catch (Exception e2)
						{
							s_errmsg = "/final/monitor/EgProbsM.jsp?msg=" + s_errmsg;
							//Forwarding to the errorhandler
%>

							<jsp:forward page = "<%= s_errmsg %>"/>

<%
						return;
					}
				}
				dataSize=alltest_fixreport.size();
				if (alltest_fixreport.size() != 0)
				{
					int count = 0;
					for (int i = 0; i < (alltest_fixreport.size()); i = i + 13, count = count + 13)
					{
						java.sql.Date msmtdate = (java.sql.Date)alltest_fixreport.elementAt(i + 3);
						String str_msmtdate = msmtdate.toString();
						String str_msmtday = str_msmtdate.substring(str_msmtdate.lastIndexOf("-") + 1, str_msmtdate.length());
						String str_msmtmonth = str_msmtdate.substring(str_msmtdate.indexOf("-") + 1,
															  str_msmtdate.lastIndexOf("-"));
						String str_msmtyear = str_msmtdate.substring(0, str_msmtdate.indexOf("-"));

						java.sql.Time msmttime = (java.sql.Time)alltest_fixreport.elementAt(i + 4);

						String str_msmttime = msmttime.toString();

						String probDate = str_msmtmonth + "/" + str_msmtday + "/" + str_msmtyear;

						String s_edit_msmttime = probDate + "*" + str_msmttime;


						java.sql.Date fixdate = (java.sql.Date)alltest_fixreport.elementAt(i + 5);
						String str_fixdate = fixdate.toString();
						String str_fixday = str_fixdate.substring(str_fixdate.lastIndexOf("-") + 1, str_fixdate.length());
						String str_fixmonth = str_fixdate.substring(str_fixdate.indexOf("-") + 1, str_fixdate.lastIndexOf("-"));
						String str_fixyear = str_fixdate.substring(0, str_fixdate.indexOf("-"));

						java.sql.Time fixtime = (java.sql.Time)alltest_fixreport.elementAt(i + 6);
	
						String str_fixtime = fixtime.toString();
						
						String fixDate = str_fixmonth + "/" + str_fixday + "/" + str_fixyear;
						String s_edit_fixtime = fixDate + "*" + str_fixtime;


						fixDate = DateUtil.changeDateFormat(fixDate,"MM/dd/yyyy",currentDateFormat);
						s_edit_fixtime  = fixDate +" "+ str_fixtime;
						probDate = DateUtil.changeDateFormat(probDate,"MM/dd/yyyy",currentDateFormat);
						s_edit_msmttime = probDate +" "+ str_msmttime;

						String s_dispInfo = (String)alltest_fixreport.elementAt(i + 10);
						String dispCompType = (String)alltest_fixreport.elementAt(i+2);
						String disp_component = (String)alltest_fixreport.elementAt(i + 1);
						if(disp_component!=null && disp_component.endsWith(":NULL"))
						{
							disp_component=disp_component.substring(0,disp_component.indexOf(":"));
						}
						ArrayList temp_details = new ArrayList();
						if(s_dispInfo!=null &&s_edit_msmttime!=null && s_edit_fixtime!=null && dispCompType!=null)
						{
							temp_details.add(disp_component);
							temp_details.add(dispCompType);
							temp_details.add(s_dispInfo);
							temp_details.add(alltest_fixreport.elementAt(i + 3));
							temp_details.add(alltest_fixreport.elementAt(i + 4));
							temp_details.add(s_edit_msmttime);
							temp_details.add(s_edit_fixtime);
							temp_details.add(alltest_fixreport.elementAt(i + 7));
							temp_details.add(alltest_fixreport.elementAt(i + 8));
							temp_details.add(alltest_fixreport.elementAt(i + 9));
							temp_details.add(alltest_fixreport.elementAt(i + 11));
							temp_details.add(alltest_fixreport.elementAt(i + 12));
						}
						if(temp_details!=null && temp_details.size()>0)
						{
							if(disp_component.equalsIgnoreCase(selName))
							{
								if(selComps_hash.containsKey(disp_component))
								{
									comp_details = (ArrayList)selComps_hash.get(disp_component);
									comp_details.add(temp_details);
									selComps_hash.put(disp_component,comp_details);
								}
								else
								{
									comp_details.add(temp_details);
									selComps_hash.put(disp_component,comp_details);
								}
							}
							else
							{
								if(allComps_hash.containsKey(disp_component))
								{
									comp_details = (ArrayList)allComps_hash.get(disp_component);
									comp_details.add(temp_details);
									allComps_hash.put(disp_component,comp_details);
								}
								else
								{
									comp_details.add(temp_details);
									allComps_hash.put(disp_component,comp_details);
								}
							}
						}
					}
				}
		}
		else if(spectest!=null && spectest.equals("spectest"))
		{
			Iterator itr2=meas_list.iterator();
			StringBuffer sb=new StringBuffer();
			String meas_all="";
			if(meas_list!=null && meas_list.size()>0)
			{
				while(itr2.hasNext())
				{
					String key = (String)itr2.next();
					sb.append("'"+key+"',");
				}
					meas_all=sb.toString();
					meas_all=meas_all.substring(1,meas_all.length()-2);
			}
			egDb = EgDbAdapterTypeUI.getObject();
			try
			{
				str_conn=egDb.setConnection();
				layer_fixreport = egDb.SelectFixHistory_6(strtDateTime,endDateTime,test,meas_all);
				while(layer_fixreport.next())
				{
					alltest_fixreport.addElement(layer_fixreport.getString("site_name"));
					alltest_fixreport.addElement(layer_fixreport.getString("comp_name"));
					alltest_fixreport.addElement(layer_fixreport.getString("comp_type"));
					if(EgInstallInfo.isSuperManager)
					{
						String msmt_time_str = layer_fixreport.getString("msmt_time");//2013-01-18 12:07:00.0
						int space = msmt_time_str.indexOf(" ");
						int dot = msmt_time_str.lastIndexOf(".");
						String msmt_time_is = null;
						if(dot>-1)
						{
							msmt_time_is = msmt_time_str.substring(space+1,dot);
						}
						else
						{
							msmt_time_is = msmt_time_str.substring(space+1);
							msmt_time_str = msmt_time_str + ".0";
						}
						Timestamp timestamp = Timestamp.valueOf(msmt_time_str);
						Time myTime = Time.valueOf(msmt_time_is);
						alltest_fixreport.addElement(new java.sql.Date(timestamp.getTime()));
						alltest_fixreport.addElement(myTime);

						String fix_date_str = layer_fixreport.getString("fix_date");//2013-01-18 12:07:00.0
						space = fix_date_str.indexOf(" ");
						dot = fix_date_str.lastIndexOf(".");
						String fix_date_is = null;
						if(dot>-1)
						{
							fix_date_is = fix_date_str.substring(space+1,dot);
						}
						else
						{
							fix_date_is = fix_date_str.substring(space+1);
							fix_date_str = fix_date_str + ".0";
						}
						Timestamp fix_timestamp = Timestamp.valueOf(fix_date_str);
						Time fix_myTime = Time.valueOf(fix_date_is);
						alltest_fixreport.addElement(new java.sql.Date(fix_timestamp.getTime()));
						alltest_fixreport.addElement(fix_myTime);
					}
					else
					{
						alltest_fixreport.addElement(layer_fixreport.getDate("msmt_time"));
						alltest_fixreport.addElement(layer_fixreport.getTime("msmt_time"));
						alltest_fixreport.addElement(layer_fixreport.getDate("fix_date"));
						alltest_fixreport.addElement(layer_fixreport.getTime("fix_date"));
					}					
					//alltest_fixreport.addElement(StringUtils.replaceURLsWithHyperlink(layer_fixreport.getString("prob_reason")));
					//alltest_fixreport.addElement(StringUtils.replaceURLsWithHyperlink(layer_fixreport.getString("prob_fix")));
					alltest_fixreport.addElement(layer_fixreport.getString("prob_reason"));
					alltest_fixreport.addElement(layer_fixreport.getString("prob_fix"));
					alltest_fixreport.addElement(layer_fixreport.getString("prob_fixed_by"));
					alltest_fixreport.addElement(layer_fixreport.getString("info"));
					alltest_fixreport.addElement(layer_fixreport.getString("test_name"));//11
					alltest_fixreport.addElement(layer_fixreport.getString("measure"));//12
				}
				layer_fixreport.close();
				egDb.releaseConnection(false);
				EgDbAdapterTypeUI.releaseObject(egDb);
			}
			catch(Exception ex)
			{
				String s_errmsg = "";
				if (!str_conn.equals("CONNECTED"))
				{
					s_errmsg = "Connection could not be established";
				}
				else if (!b_state == true)
				{
					s_errmsg = "Error in sql query while retrieving records pertaining to the User!	";
				}
				else if (!b_fixreport == true)
				{
					s_errmsg = "Error in sql query s_query(fixreport) ";
				}
				else
				{
					s_errmsg = ex.toString();
				}
				if (layer_fixreport != null)
				{
					try
					{
						layer_fixreport.close();
					}
					catch (Exception bug123)
					{
					}
				}
				if (layer_fixreport != null)
				{
					try
					{
						layer_fixreport.close();
					}
					catch (Exception bug123)
					{
					}
				}
				try
				{
					egDb.releaseConnection(true);
					EgDbAdapterTypeUI.releaseObject(egDb);
				}
				catch (Exception e2)
				{
					s_errmsg = "/final/monitor/EgProbsM.jsp?msg=" + s_errmsg;
					//Forwarding to the errorhandler
%>

					<jsp:forward page = "<%= s_errmsg %>"/>

<%
					return;
				}
			}
			dataSize=alltest_fixreport.size();
			if (alltest_fixreport.size() != 0)
			{
				int count = 0;
				for (int i = 0; i < (alltest_fixreport.size()); i = i + 13, count = count + 13)
				{
					java.sql.Date msmtdate = (java.sql.Date)alltest_fixreport.elementAt(i + 3);
					String str_msmtdate = msmtdate.toString();
					String str_msmtday = str_msmtdate.substring(str_msmtdate.lastIndexOf("-") + 1, str_msmtdate.length());
					String str_msmtmonth = str_msmtdate.substring(str_msmtdate.indexOf("-") + 1,
															  str_msmtdate.lastIndexOf("-"));
					String str_msmtyear = str_msmtdate.substring(0, str_msmtdate.indexOf("-"));

					java.sql.Time msmttime = (java.sql.Time)alltest_fixreport.elementAt(i + 4);

					String str_msmttime = msmttime.toString();

					String probDate = str_msmtmonth + "/" + str_msmtday + "/" + str_msmtyear;

					String s_edit_msmttime = probDate + "*" + str_msmttime;


					java.sql.Date fixdate = (java.sql.Date)alltest_fixreport.elementAt(i + 5);
					String str_fixdate = fixdate.toString();
					String str_fixday = str_fixdate.substring(str_fixdate.lastIndexOf("-") + 1, str_fixdate.length());
					String str_fixmonth = str_fixdate.substring(str_fixdate.indexOf("-") + 1, str_fixdate.lastIndexOf("-"));
					String str_fixyear = str_fixdate.substring(0, str_fixdate.indexOf("-"));

					java.sql.Time fixtime = (java.sql.Time)alltest_fixreport.elementAt(i + 6);
	
					String str_fixtime = fixtime.toString();
					String fixDate = str_fixmonth + "/" + str_fixday + "/" + str_fixyear;
					String s_edit_fixtime = fixDate + "*" + str_fixtime;
					fixDate = DateUtil.changeDateFormat(fixDate,"MM/dd/yyyy",currentDateFormat);
					s_edit_fixtime  = fixDate +" "+ str_fixtime;
					probDate = DateUtil.changeDateFormat(probDate,"MM/dd/yyyy",currentDateFormat);
					s_edit_msmttime = probDate +" "+ str_msmttime;
					String s_dispInfo = (String)alltest_fixreport.elementAt(i + 10);
					String dispCompType = (String)alltest_fixreport.elementAt(i+2);
					String disp_component = (String)alltest_fixreport.elementAt(i + 1);
					if(disp_component!=null && disp_component.endsWith(":NULL"))
					{
						disp_component=disp_component.substring(0,disp_component.indexOf(":"));
					}
					ArrayList temp_details = new ArrayList();
					if(s_dispInfo!=null &&s_edit_msmttime!=null && s_edit_fixtime!=null && dispCompType!=null)
					{
						temp_details.add(disp_component);
						temp_details.add(dispCompType);
						temp_details.add(s_dispInfo);
						temp_details.add(alltest_fixreport.elementAt(i + 3));
						temp_details.add(alltest_fixreport.elementAt(i + 4));
						temp_details.add(s_edit_msmttime);
						temp_details.add(s_edit_fixtime);
						temp_details.add(alltest_fixreport.elementAt(i + 7));
						temp_details.add(alltest_fixreport.elementAt(i + 8));
						temp_details.add(alltest_fixreport.elementAt(i + 9));
						temp_details.add(alltest_fixreport.elementAt(i + 11));
						temp_details.add(alltest_fixreport.elementAt(i + 12));
					}
					if(temp_details!=null && temp_details.size()>0)
					{
						if(disp_component.equalsIgnoreCase(selName))
						{
							if(selComps_hash.containsKey(disp_component))
							{
								comp_details = (ArrayList)selComps_hash.get(disp_component);
								comp_details.add(temp_details);
								selComps_hash.put(disp_component,comp_details);
							}
							else
							{
								comp_details.add(temp_details);
								selComps_hash.put(disp_component,comp_details);
							}
						}
						else
						{
							if(allComps_hash.containsKey(disp_component))
							{
								comp_details = (ArrayList)allComps_hash.get(disp_component);
								comp_details.add(temp_details);
								allComps_hash.put(disp_component,comp_details);
							}
							else
							{
								comp_details.add(temp_details);
								allComps_hash.put(disp_component,comp_details);
							}
						}
					}
				}
			}
		}
		else 
		{
			egDb = EgDbAdapterTypeUI.getObject();
			try
			{
				str_conn = egDb.setConnection();
				layer_fixreport = egDb.SelectFixHistory_6(strtDateTime,endDateTime,test,meas);
				c_state = egDb.getState();
				while (layer_fixreport.next())
				{
					la_fixreport.addElement(layer_fixreport.getString("site_name"));
					la_fixreport.addElement(layer_fixreport.getString("comp_name"));
					la_fixreport.addElement(layer_fixreport.getString("comp_type"));
					if(EgInstallInfo.isSuperManager)
					{
						String msmt_time_str = layer_fixreport.getString("msmt_time");//2013-01-18 12:07:00.0
						int space = msmt_time_str.indexOf(" ");
						int dot = msmt_time_str.lastIndexOf(".");
						String msmt_time_is = null;
						if(dot>-1)
						{
							msmt_time_is = msmt_time_str.substring(space+1,dot);
						}
						else
						{
							msmt_time_is = msmt_time_str.substring(space+1);
							msmt_time_str = msmt_time_str + ".0";
						}
						Timestamp timestamp = Timestamp.valueOf(msmt_time_str);
						Time myTime = Time.valueOf(msmt_time_is);
						la_fixreport.addElement(new java.sql.Date(timestamp.getTime()));
						la_fixreport.addElement(myTime);

						String fix_date_str = layer_fixreport.getString("fix_date");//2013-01-18 12:07:00.0
						space = fix_date_str.indexOf(" ");
						dot = fix_date_str.lastIndexOf(".");
						String fix_date_is = null;
						if(dot>-1)
						{
							fix_date_is = fix_date_str.substring(space+1,dot);
						}
						else
						{
							fix_date_is = fix_date_str.substring(space+1);
							fix_date_str = fix_date_str + ".0";
						}
						Timestamp fix_timestamp = Timestamp.valueOf(fix_date_str);
						Time fix_myTime = Time.valueOf(fix_date_is);
						la_fixreport.addElement(new java.sql.Date(fix_timestamp.getTime()));
						la_fixreport.addElement(fix_myTime);
					}
					else
					{
						la_fixreport.addElement(layer_fixreport.getDate("msmt_time"));
						la_fixreport.addElement(layer_fixreport.getTime("msmt_time"));
						la_fixreport.addElement(layer_fixreport.getDate("fix_date"));
						la_fixreport.addElement(layer_fixreport.getTime("fix_date"));
					}
					//la_fixreport.addElement(StringUtils.replaceURLsWithHyperlink(layer_fixreport.getString("prob_reason")));
					//la_fixreport.addElement(StringUtils.replaceURLsWithHyperlink(layer_fixreport.getString("prob_fix")));
					la_fixreport.addElement(layer_fixreport.getString("prob_reason"));
					la_fixreport.addElement(layer_fixreport.getString("prob_fix"));
					la_fixreport.addElement(layer_fixreport.getString("prob_fixed_by"));
					la_fixreport.addElement(layer_fixreport.getString("info"));
					la_fixreport.addElement(layer_fixreport.getString("test_name"));//11
					la_fixreport.addElement(layer_fixreport.getString("measure"));//12
				}
				layer_fixreport.close();
				egDb.releaseConnection(false);
				EgDbAdapterTypeUI.releaseObject(egDb);
			}
			catch (Exception e)
			{
				String s_errmsg = "";
				if (!str_conn.equals("CONNECTED"))
				{
					s_errmsg = "Connection could not be established";
				}
				else if (!c_state == true)
				{
					s_errmsg = "Error in sql query while retrieving records pertaining to the User!	";
				}
				else if (!c_fixreport == true)
				{
					s_errmsg = "Error in sql query s_query(fixreport) ";
				}
				else
				{
					s_errmsg = e.toString();
				}
				if (layer_fixreport != null)
				{
					try
					{
						layer_fixreport.close();
					}
					catch (Exception bug123)
					{
					}
				}
				if (layer_fixreport != null)
				{
					try
					{
						layer_fixreport.close();
					}
					catch (Exception bug123)
					{
					}
				}
				try
				{
					egDb.releaseConnection(true);
					EgDbAdapterTypeUI.releaseObject(egDb);
				}
				catch (Exception e2)
				{
					s_errmsg = "/final/monitor/EgProbsM.jsp?msg=" + s_errmsg;
					//Forwarding to the errorhandler
%>
					<jsp:forward page = "<%= s_errmsg %>"/>
<% 
					return;
				}
			}
			dataSize=la_fixreport.size();
			if (la_fixreport.size() != 0)
			{
				int count = 0;
				for (int i = 0; i < (la_fixreport.size()); i = i + 13, count = count + 13)
				{
					java.sql.Date msmtdate = (java.sql.Date)la_fixreport.elementAt(i + 3);
					String str_msmtdate = msmtdate.toString();
					String str_msmtday = str_msmtdate.substring(str_msmtdate.lastIndexOf("-") + 1, str_msmtdate.length());
					String str_msmtmonth = str_msmtdate.substring(str_msmtdate.indexOf("-") + 1,
															  str_msmtdate.lastIndexOf("-"));
					String str_msmtyear = str_msmtdate.substring(0, str_msmtdate.indexOf("-"));
					java.sql.Time msmttime = (java.sql.Time)la_fixreport.elementAt(i + 4);
					String str_msmttime = msmttime.toString();
					String probDate = str_msmtmonth + "/" + str_msmtday + "/" + str_msmtyear;
					String s_edit_msmttime = probDate + "*" + str_msmttime;
					java.sql.Date fixdate = (java.sql.Date)la_fixreport.elementAt(i + 5);
					String str_fixdate = fixdate.toString();
					String str_fixday = str_fixdate.substring(str_fixdate.lastIndexOf("-") + 1, str_fixdate.length());
					String str_fixmonth = str_fixdate.substring(str_fixdate.indexOf("-") + 1, str_fixdate.lastIndexOf("-"));
					String str_fixyear = str_fixdate.substring(0, str_fixdate.indexOf("-"));
					java.sql.Time fixtime = (java.sql.Time)la_fixreport.elementAt(i + 6);
					String str_fixtime = fixtime.toString();
					String fixDate = str_fixmonth + "/" + str_fixday + "/" + str_fixyear;
					String s_edit_fixtime = fixDate + "*" + str_fixtime;
					fixDate = DateUtil.changeDateFormat(fixDate,"MM/dd/yyyy",currentDateFormat);
					s_edit_fixtime  = fixDate +" "+ str_fixtime;
					probDate = DateUtil.changeDateFormat(probDate,"MM/dd/yyyy",currentDateFormat);
					s_edit_msmttime = probDate +" "+ str_msmttime;
					String s_dispInfo = (String)la_fixreport.elementAt(i + 10);
					String dispCompType = (String)la_fixreport.elementAt(i+2);
					String disp_component = (String)la_fixreport.elementAt(i + 1);
					if(disp_component!=null && disp_component.endsWith(":NULL"))
					{
						disp_component=disp_component.substring(0,disp_component.indexOf(":"));
					}
					ArrayList temp_details = new ArrayList();
					if(s_dispInfo!=null &&s_edit_msmttime!=null && s_edit_fixtime!=null && dispCompType!=null)
					{
						temp_details.add(disp_component);
						temp_details.add(dispCompType);
						temp_details.add(s_dispInfo);
						temp_details.add(la_fixreport.elementAt(i + 3));
						temp_details.add(la_fixreport.elementAt(i + 4));
						temp_details.add(s_edit_msmttime);
						temp_details.add(s_edit_fixtime);
						temp_details.add(la_fixreport.elementAt(i + 7));
						temp_details.add(la_fixreport.elementAt(i + 8));
						temp_details.add(la_fixreport.elementAt(i + 9));
						temp_details.add(la_fixreport.elementAt(i + 11));
						temp_details.add(la_fixreport.elementAt(i + 12));
					}
					if(temp_details!=null && temp_details.size()>0)
					{
						if(disp_component.equalsIgnoreCase(selName))
						{
							if(selComps_hash.containsKey(disp_component))
							{
								comp_details = (ArrayList)selComps_hash.get(disp_component);
								comp_details.add(temp_details);
								selComps_hash.put(disp_component,comp_details);
							}
							else
							{
								comp_details.add(temp_details);
								selComps_hash.put(disp_component,comp_details);
							}
						}
						else
						{
							if(allComps_hash.containsKey(disp_component))
							{
								comp_details = (ArrayList)allComps_hash.get(disp_component);
								comp_details.add(temp_details);
								allComps_hash.put(disp_component,comp_details);
							}
							else
							{
								comp_details.add(temp_details);
								allComps_hash.put(disp_component,comp_details);
							}
						}
					}
				}
			}
		}
	}
	else if(selectString!=null && !selectString.equals(""))
	{
		ResultSet search_fixreport=null;
		ArrayList v_reason = new ArrayList();
		ArrayList v_fixed=new ArrayList();
		Vector info_select=new Vector();
		String type="";
		String cmp_name="";
		String cmpType="";
		String site_name="";
		Vector commonName=new Vector();
		if(reason!=null && reason.equals("reason"))
		{
			type="reason";
			selectString = selectString.toLowerCase();
		}
		else if(fixed!=null && fixed.equals("fixed"))
		{
			type="fixed";
			selectString = selectString.toLowerCase();
		}
		else if(searchAll!=null && searchAll.equals("searchAll"))
		{
			type="searchAll";
			selectString=selectString.toLowerCase();
		}
		String cmp_type=null;
		if(selName!=null&&!selName.equals("ALL"))
		{
			commonName.add(selName);
		}
		if(selName!=null&&selName.equals("ALL"))
		{
			if(s_event.equals("Component"))
			{
				if(serverNames!=null && serverNames.size()>0)
				{
					commonName.addAll(serverNames);
				}
			}
			if(s_event.equals("Service"))
			{
				if(serverNames!=null && serverNames.size()>0)
				{
					commonName.addAll(serverNames);
				}
			}
			else if(s_event.equals("Zone"))
			{
				if(serverNames!=null && serverNames.size()>0)
				{
					commonName.addAll(serverNames);
				}
			}
			else if(s_event.equals("Segment"))
			{
				if(serverNames!=null && serverNames.size()>0)
				{
					commonName.addAll(serverNames);
				}
			}
		}
		if(commonName.size()>0)
		{
			egDb = EgDbAdapterTypeUI.getObject();
			str_conn = egDb.setConnection();
			String cname="";
			String ctype="";
			Vector compTypes = new Vector();
			compTypes.add("Host_system");
			if(commonName!=null&&commonName.size()==1)
			{
				String applyName=(String)commonName.get(0);
				cmp_type=applyName.substring(0,applyName.indexOf(":"));		
				cmp_name=applyName.substring(applyName.indexOf(":")+1,applyName.length());
				if(cmp_name!=null && !cmp_name.contains(":"))
				{
					cmp_name=cmp_name+":"+"NULL";
					cname=cmp_name;
				}
				else
				{
					cname=cname+",'"+cmp_name+"'";
					String hostComp=cmp_name.substring(0,cmp_name.indexOf(":"))+":NULL";
					cname=cname+",'"+hostComp+"'";
				}
				if(!compTypes.contains(cmp_type))
					compTypes.add(cmp_type);
			}
			else
			{
				for(int n=0;n<commonName.size();n++)
				{
					String applyName=(String)commonName.get(n);
					cmp_type=applyName.substring(0,applyName.indexOf(":"));		
					cmp_name=applyName.substring(applyName.indexOf(":")+1,applyName.length());
					if(cmp_name!=null && !cmp_name.contains(":"))
					{
						cmp_name=cmp_name+":"+"NULL";
						cname=cname+",'"+cmp_name+"'";
					}
					else
					{
						cname=cname+",'"+cmp_name+"'";
						String hostComp=cmp_name.substring(0,cmp_name.indexOf(":"))+":NULL";
						cname=cname+",'"+hostComp+"'";
					}
					if(!compTypes.contains(cmp_type))
						compTypes.add(cmp_type);
				}
			}
			for(int n=0;n<compTypes.size();n++)
			{
				String comp_type=(String)compTypes.get(n);
				ctype=ctype+",'"+comp_type+"'";
			}
			if(cname!=null&&cname.length()>0&&cname.startsWith(","))
				cname=cname.substring(1);
			if(ctype!=null&&ctype.length()>0&&ctype.startsWith(","))
				ctype=ctype.substring(1);

			StringBuffer sb=new StringBuffer();
			String test_all="";
			if(testlayer!=null&&testlayer.size()>0 && (selName!=null&&selName.equals("ALL")))
			{
				Iterator itr2=testlayer.iterator();
				while(itr2.hasNext())
				{
					String key = (String)itr2.next();
					sb.append("'"+key+"',");
				}
				test_all=sb.toString();
				test_all=test_all.substring(1,test_all.length()-2);
			}
			else if(all_test!=null && all_test.size()>0)
			{
				Iterator itr2=all_test.iterator();
				while(itr2.hasNext())
				{
					String key = (String)itr2.next();
					sb.append("'"+key+"',");
				}
				test_all=sb.toString();
				test_all=test_all.substring(1,test_all.length()-2);
			}
				try
				{
					if (cname.indexOf(",") == -1)
					{
						cname = "'"+cname+"','-'";
					}
					else
					{
						cname = cname+",'-'";   //for export/import function 
					}
					search_fixreport=egDb.SelectFixHistory_5(selectString,type,strtDateTime,endDateTime,cname,ctype,test_all);
					while(search_fixreport.next())
					{
						sh_fixreport.addElement(search_fixreport.getString("site_name"));
						sh_fixreport.addElement(search_fixreport.getString("comp_name"));
						sh_fixreport.addElement(search_fixreport.getString("comp_type"));
						if(EgInstallInfo.isSuperManager)
						{
							String msmt_time_str = search_fixreport.getString("msmt_time");//2013-01-18 12:07:00.0
							int space = msmt_time_str.indexOf(" ");
							int dot = msmt_time_str.lastIndexOf(".");
							String msmt_time_is = null;
							if(dot>-1)
							{
								msmt_time_is = msmt_time_str.substring(space+1,dot);
							}
							else
							{
								msmt_time_is = msmt_time_str.substring(space+1);
								msmt_time_str = msmt_time_str + ".0";
							}
							Timestamp timestamp = Timestamp.valueOf(msmt_time_str);
							Time myTime = Time.valueOf(msmt_time_is);
							sh_fixreport.addElement(new java.sql.Date(timestamp.getTime()));
							sh_fixreport.addElement(myTime);

							String fix_date_str = search_fixreport.getString("fix_date");//2013-01-18 12:07:00.0
							space = fix_date_str.indexOf(" ");
							dot = fix_date_str.lastIndexOf(".");
							String fix_date_is = null;
							if(dot>-1)
							{
								fix_date_is = fix_date_str.substring(space+1,dot);
							}
							else
							{
								fix_date_is = fix_date_str.substring(space+1);
								fix_date_str = fix_date_str + ".0";
							}

							Timestamp fix_timestamp = Timestamp.valueOf(fix_date_str);
							Time fix_myTime = Time.valueOf(fix_date_is);
							sh_fixreport.addElement(new java.sql.Date(fix_timestamp.getTime()));
							sh_fixreport.addElement(fix_myTime);
						}
						else
						{
							sh_fixreport.addElement(search_fixreport.getDate("msmt_time"));
							sh_fixreport.addElement(search_fixreport.getTime("msmt_time"));
							sh_fixreport.addElement(search_fixreport.getDate("fix_date"));
							sh_fixreport.addElement(search_fixreport.getTime("fix_date"));
						}
						//sh_fixreport.addElement(StringUtils.replaceURLsWithHyperlink(search_fixreport.getString("prob_reason")));
						//sh_fixreport.addElement(StringUtils.replaceURLsWithHyperlink(search_fixreport.getString("prob_fix")));
						sh_fixreport.addElement(search_fixreport.getString("prob_reason"));
						sh_fixreport.addElement(search_fixreport.getString("prob_fix"));
						sh_fixreport.addElement(search_fixreport.getString("prob_fixed_by"));
						sh_fixreport.addElement(search_fixreport.getString("info"));
						sh_fixreport.addElement(search_fixreport.getString("test_name"));//11
						sh_fixreport.addElement(search_fixreport.getString("measure"));//12
					}
					search_fixreport.close();
					egDb.releaseConnection(false);
					EgDbAdapterTypeUI.releaseObject(egDb);	
				}
				catch(Exception ex)
				{
					String s_errmsg = "";
					if (!str_conn.equals("CONNECTED"))
					{
						s_errmsg = "Connection could not be established";
					}
					else if (!b_state == true)
					{
						s_errmsg = "Error in sql query while retrieving records pertaining to the User!	";
					}
					else if (!b_fixreport == true)
					{
						s_errmsg = "Error in sql query s_query(fixreport) ";
					}
					else
					{
						s_errmsg = ex.toString();
					}
					if (search_fixreport != null)
					{
						try
						{
							search_fixreport.close();
						}
						catch (Exception bug123)
						{
						}
					}

					if (search_fixreport != null)
					{
						try
						{
							search_fixreport.close();
						}
						catch (Exception bug123)
						{
						}
					}

					try
					{
						egDb.releaseConnection(true);
						EgDbAdapterTypeUI.releaseObject(egDb);
					}
					catch (Exception e2)
					{
						s_errmsg = "/final/monitor/EgProbsM.jsp?msg=" + s_errmsg;
						//Forwarding to the errorhandler
%>

						<jsp:forward page = "<%= s_errmsg %>"/>
	
<% 
						return;
					}
				}
		}
		dataSize=sh_fixreport.size();
		if (sh_fixreport.size() != 0)
		{
			int count = 0;
			for (int i = 0; i < (sh_fixreport.size()); i = i + 13, count = count + 13)
			{
				java.sql.Date msmtdate = (java.sql.Date)sh_fixreport.elementAt(i + 3);
				String str_msmtdate = msmtdate.toString();
				String str_msmtday = str_msmtdate.substring(str_msmtdate.lastIndexOf("-") + 1, str_msmtdate.length());
				String str_msmtmonth = str_msmtdate.substring(str_msmtdate.indexOf("-") + 1,
															  str_msmtdate.lastIndexOf("-"));
				String str_msmtyear = str_msmtdate.substring(0, str_msmtdate.indexOf("-"));
				java.sql.Time msmttime = (java.sql.Time)sh_fixreport.elementAt(i + 4);
				String str_msmttime = msmttime.toString();
				String probDate = str_msmtmonth + "/" + str_msmtday + "/" + str_msmtyear;
				String s_edit_msmttime = probDate + "*" + str_msmttime;
				java.sql.Date fixdate = (java.sql.Date)sh_fixreport.elementAt(i + 5);
				String str_fixdate = fixdate.toString();
				String str_fixday = str_fixdate.substring(str_fixdate.lastIndexOf("-") + 1, str_fixdate.length());
				String str_fixmonth = str_fixdate.substring(str_fixdate.indexOf("-") + 1, str_fixdate.lastIndexOf("-"));
				String str_fixyear = str_fixdate.substring(0, str_fixdate.indexOf("-"));
				java.sql.Time fixtime = (java.sql.Time)sh_fixreport.elementAt(i + 6);
				String str_fixtime = fixtime.toString();
				String fixDate = str_fixmonth + "/" + str_fixday + "/" + str_fixyear;
				String s_edit_fixtime = fixDate + "*" + str_fixtime;
				fixDate = DateUtil.changeDateFormat(fixDate,"MM/dd/yyyy",currentDateFormat);
				s_edit_fixtime  = fixDate +" "+ str_fixtime;
				probDate = DateUtil.changeDateFormat(probDate,"MM/dd/yyyy",currentDateFormat);
				s_edit_msmttime = probDate +" "+ str_msmttime;
				String s_dispInfo = (String)sh_fixreport.elementAt(i + 10);
				String dispCompType = (String)sh_fixreport.elementAt(i+2);
				String disp_component = (String)sh_fixreport.elementAt(i + 1);
				String reason_temp=(String)sh_fixreport.elementAt(i + 8);
				String fix_temp=(String)sh_fixreport.elementAt(i + 9);
				ArrayList temp_details = new ArrayList();
				if(disp_component!=null && disp_component.endsWith(":NULL"))
				{
					disp_component=disp_component.substring(0,disp_component.indexOf(":"));
				}
				if(s_dispInfo!=null &&s_edit_msmttime!=null && s_edit_fixtime!=null && dispCompType!=null)
				{
					temp_details.add(disp_component);
					temp_details.add(dispCompType);
					temp_details.add(s_dispInfo);
					temp_details.add(sh_fixreport.elementAt(i + 3));
					temp_details.add(sh_fixreport.elementAt(i + 4));
					temp_details.add(s_edit_msmttime);
					temp_details.add(s_edit_fixtime);
					temp_details.add(sh_fixreport.elementAt(i + 7));
					temp_details.add(sh_fixreport.elementAt(i + 8));
					temp_details.add(sh_fixreport.elementAt(i + 9));
					temp_details.add(sh_fixreport.elementAt(i + 11));
					temp_details.add(sh_fixreport.elementAt(i + 12));
				}
				if(temp_details!=null && temp_details.size()>0)
				{
					if(disp_component.equalsIgnoreCase(selName))
					{
						if(selComps_hash.containsKey(disp_component))
						{
							comp_details = (ArrayList)selComps_hash.get(disp_component);
							comp_details.add(temp_details);
							selComps_hash.put(disp_component,comp_details);
						}
						else
						{
							comp_details.add(temp_details);
							selComps_hash.put(disp_component,comp_details);
						}
					}
					else
					{
						if(allComps_hash.containsKey(disp_component))
						{
							comp_details = (ArrayList)allComps_hash.get(disp_component);
							comp_details.add(temp_details);
							allComps_hash.put(disp_component,comp_details);
						}
						else
						{
							comp_details.add(temp_details);
							allComps_hash.put(disp_component,comp_details);
						}
					}
				}
			}
		}
	}
	JSONObject json = new JSONObject();
	StringBuffer sbData = new StringBuffer();
	//sbData.append("<script>alert('vijay');</script>");
	//sbData.append("<td width='100%' class='data_border' id='downTableTd' valign='top'>");
	/*<col width='18%'> <col width='18%'><col width='16%'> <col width='22%'><col width='22%'><col width='6%'> */
	if(allComps_hash!=null && allComps_hash.size()>0)
	{
			sbData.append("<table align='center' width='100%' cellspacing='0' cellpadding='0' border='0'><tr><td align='center' ><div class='x-table' style='float:left;width:100%;padding-bottom:0px'><table align='center' cellspacing='0' cellpadding='0' border='0' style='table-layout:auto' width='100%' class='x-grid-table kbserchbottom_zero'><thead><tr class='x-grid-row'><td nowrap='nowrap' class='x-grid-cell' style='border-top: 0px !important;width:15%'><div class='x-grid-cell-inner'>Comp Type</div></td> <td nowrap='nowrap' style='width:18%;border-top-width:0px;border-left-width:0px;border-top: 0px !important;' class='x-grid-cell'><div class='x-grid-cell-inner'>Comp Name</div></td> <td nowrap='nowrap' class='x-grid-cell' style='width:16%;border-top: 0px !important;'><div class='x-grid-cell-inner'>Test</div></td> <td nowrap class='x-grid-cell' style='width:20%;border-top: 0px !important;'><div class='x-grid-cell-inner'>Descriptor</div></td> <td height='20' nowrap='nowrap'  class='x-grid-cell' style='border-top: 0px !important;width:30%'><div class='x-grid-cell-inner'>Measure</div></td> </tr></thead>");
			ArrayList allComponentdetails = new ArrayList();
			ArrayList allcomp_details = new ArrayList();
			Enumeration keys = allComps_hash.keys();

			while(keys.hasMoreElements())
			{
				String key = (String)keys.nextElement();
				if(key!=null && key.trim().length()>0)
					allComponentdetails = (ArrayList)allComps_hash.get(key);
			}
			ModifyComponent.addAll(allComponentdetails);
			if(allComponentdetails!=null && allComponentdetails.size()>0)
			{
				//JSONArray resultArray = new JSONArray();
				for(int jj=0; jj<allComponentdetails.size();jj++)
				{
					//JSONObject headerNames = new JSONObject();
					//JSONObject headerValues = new JSONObject();
					//JSONObject nameAndValues = new JSONObject();
					allcomp_details = (ArrayList)allComponentdetails.get(jj);
					String db_comp_type=(String)allcomp_details.get(1);
					String db_comp_name=(String)allcomp_details.get(0);
					String org_comp_type="";
					if(db_comp_type!=null && db_comp_type.trim().length()>0)
					{
						org_comp_type=discInfoHelper.getCompTypeForHostSystem(db_comp_type,db_comp_name,(String)allcomp_details.get(10), hasAllComponentAccess,mappingInfo,userCompList);
					}
					if(org_comp_type==null || org_comp_type.trim().length()==0)
					{
						String component_nick=Server.getServerNameWithoutPort(db_comp_name,false);
						List compTypeList=(List)discInfo.getServerTypesForNick(component_nick);
						if(compTypeList!=null && compTypeList.size()>0)
						{
							org_comp_type=(String)compTypeList.get(0);
						}

						if(org_comp_type!=null && org_comp_type.trim().length()>0)
						{
							org_comp_type=mappingInfo.getComponentTypeDescription(org_comp_type);
						}
					}
					
					
					
					
					sbData.append("<tbody><tr><td  colspan='5' class='kbTD'><table align='center' width='100%' cellspacing='0' cellpadding='0' border='1' class='kbTABLE'><tr class='x-grid-row border_alt'><td wrap='wrap' align='left' class='kbsearchtdbg x-grid-cell' valign='top' style='padding:3px 3px 3px 20px;border-left:0px;width:15%'>"+org_comp_type+"</td> <td wrap='wrap' align='left' valign='top' class='kbsearchtdbg x-grid-cell' style='padding:3px 3px 3px 20px;border-left:0px;width:20%'>"+(String)allcomp_details.get(0)+"</td> <td class='kbsearchtdbg x-grid-cell' wrap='wrap' align='left' valign='top' style='padding:3px 3px 3px 20px;border-left:0px;width:20%'>"+mappingInfo.getTestDescription((String)allcomp_details.get(10))+"</td>");

					//headerNames.put("compType",org_comp_type);
					//headerNames.put("compName",(String)allcomp_details.get(0));
					//headerNames.put("test",(String)allcomp_details.get(10));
					

					String desc=(String)allcomp_details.get(2);

					if(desc!=null && desc.trim().length()>0 && desc.indexOf("*")>0)
						desc = desc.substring(desc.indexOf("*")+1);	
					if(desc!=null && desc.trim().length()>0 && desc.indexOf("+")>0)
						desc = desc.substring(desc.indexOf("+")+1);	
					
				
					desc=desc.replace("+","");
					String tempDesc = desc;
					if(tempDesc!=null && tempDesc.trim().length()==0)
						tempDesc = "-";
					sbData.append("<td wrap='wrap' align='left' style='width:22%' valign='top' class='kbsearchtdbg x-grid-cell'>"+tempDesc+" &nbsp;</td>");

					//headerNames.put("descriptor",desc);
					

					String tst=(String)allcomp_details.get(10);
					String mes=(String)allcomp_details.get(11);		//
					String measureDisplayName = mappingInfo.getMeasureDescription(tst,mes);
					//<input type='button' name='modify' id='button_bgdark' value='Modify' onclick='kbsearchWindow("+//jj+")'>
					
					if(EgInstallInfo.isSuperManager)
					{
						// MODIFY button has been removed as we are not supporting update query in supermanager
						sbData.append("<td wrap='wrap' align='left' class='kbsearchtdbg x-grid-cell' valign='top' style='width:30%'>"+measureDisplayName+"</td> <td wrap='wrap' align='center' class='kbsearchtdbg x-grid-cell' valign='top'><div id='modifybt"+jj+"' style='border:0px solid red;width:100px;height:20px;margin-top:2px' style='width:30%'><img src='/final/monitor/eg_images/spacer.gif'></div></td> </tr> <tr> <td colspan='6' style='padding:0px 10px 10px' class='KBinside x-grid-cell'><div style='padding:0px;'><table align = 'center' cellspacing = '0' cellpadding = '0' width = '100%' border = '0' class='border_alt'> <tr> <td width = '100%' > <table align = 'center' cellspacing = '0' cellpadding = '2' width = '100%' border = '0' style='font-size:12px'> <tbody><tr class='borderbottom_alt'> <td class='x-grid-cell' width = '20%' align='left' valign='top' style='padding:4px'><b>Problem</b></td>");
					}
					else
					{
						sbData.append("<td wrap='wrap' align='left' class='kbsearchtdbg x-grid-cell' valign='top' style='width:30%'>"+measureDisplayName+"</td> <td wrap='wrap' align='center' class='kbsearchtdbg x-grid-cell' valign='top'><div id='modifybt"+jj+"' style='border:0px solid red;width:100px;height:20px;margin-top:2px' style='width:30%'><img src='/final/monitor/eg_images/spacer.gif' onload='createButton(modifybt"+jj+","+jj+")'></div></td> </tr> <tr> <td colspan='6' style='padding:0px 10px 10px' class='KBinside x-grid-cell'><div style='padding:0px;'><table align = 'center' cellspacing = '0' cellpadding = '0' width = '100%' border = '0' class='border_alt'> <tr> <td width = '100%' > <table align = 'center' cellspacing = '0' cellpadding = '2' width = '100%' border = '0' style='font-size:12px'> <tbody><tr class='borderbottom_alt'> <td class='x-grid-cell' width = '20%' align='left' valign='top' style='padding:4px'><b>Problem</b></td>");
					}
					//headerNames.put("measure",mes);
					//nameAndValues.put("headerNames",headerNames);

					//headerValues.put("problem","Problem");

					String prob=(String)allcomp_details.get(7);
					int siz=prob.length();
					int z=0;
					String lang=thisLanguage;
					if(lang!=null && lang.equalsIgnoreCase("en_US"))
					{
						z=90;
					}
					else
					{
						z=60;
					}
					if(prob.indexOf(" ")<0&&(siz>z))
					{
						if(siz>z)
						{
							if(prob.indexOf("~")>0)
							{
								prob=prob.replace("~","<br>");
							}
							prob=getWrapValues(prob,thisLanguage,z);
							sbData.append("<td class='x-grid-cell' width = '80%' align='left' valign='top' style='padding:4px'>"+prob+"</td>");
							//headerValues.put("problemValue",prob);
						}
					}
					else
					{
						
						if(prob.indexOf("~")>0)
						{
							prob=prob.replace("~","<br>");
						}
						sbData.append("<td class='x-grid-cell' width = '80%' align='left' valign='top' style='padding:4px'>"+prob+"</td>");
						//headerValues.put("problemValue",prob);		
					}
					sbData.append("</tr><tr class='borderbottom_alt'>");
					String fixby=(String)allcomp_details.get(9);
					int len=fixby.length();
					int limit=0;
					String lang2=thisLanguage;
					if(lang2!=null && lang2.equalsIgnoreCase("en_US"))
					{
						limit=25;
					}
					else
					{
						limit=16;
					}
					if(fixby.indexOf(" ")<0&&(len>limit))
					{
						if(len>limit)
						{
							fixby=getWrapValues(fixby,thisLanguage,limit);
							sbData.append("<td class='x-grid-cell' width = '20%' align='left' valign='top' style='padding:4px'>Fix("+fixby+")</td>");
							//headerValues.put("fix","Fix");
							//headerValues.put("fixValue",fixby);
						}
					}
					else
					{
						sbData.append("<td class='x-grid-cell' width = '20%' align='left' valign='top' style='padding:4px'>Fix("+(String)allcomp_details.get(9)+")</td>");
						//headerValues.put("fix","Fix");
						//headerValues.put("fixValue",(String)allcomp_details.get(9));
					}
					String fix=(String)allcomp_details.get(8);
					int size=fix.length();
					int y=0;
					String lang1=thisLanguage;
					if(lang1!=null && lang1.equalsIgnoreCase("en_US"))
					{
						y=90;
					}
					else
					{
						y=60;
					}
					if(fix.indexOf(" ")<0&&(size>y))
					{
						if(size>y)
						{
							if(fix.indexOf("~")>0)
							{
								fix=fix.replace("~","<br>");
							}
							fix=getWrapValues(fix,thisLanguage,y);
							sbData.append("<td class='x-grid-cell' width = '80%' align='left' valign='top' style='padding:4px'>"+fix+"</td>");
							//headerValues.put("fixValue",fix);
						}
					}
					else
					{
						if(fix.indexOf("~")>0)
						{
							fix=fix.replace("~","<br>");
						}
						sbData.append("<td class='x-grid-cell' width = '80%' align='left' valign='top' style='padding:4px'>"+fix+"</td>");
						//headerValues.put("fixValue",fix);
					}
					sbData.append("</tr> <tr class='borderbottom_alt'> <td class='x-grid-cell' width = '20%' height = '18' align='left' valign='top' style='padding:4px'><b>Problem Time</b></td>");
					//headerValues.put("problemTime","Problem Time");

					tmpDate =(String)allcomp_details.get(5);
					if (tmpDate.indexOf("*") > -1)
						tmpDate = tmpDate.replace('*',' ');
					timeZoneConverter = new EgTimeZoneConverter(tmpDate , u_ser);
					tmpDate = timeZoneConverter.getDateTime();
					sbData.append("<td class='x-grid-cell' width = '80%' align='left' valign='top' style='padding:4px'>"+tmpDate+"</td> </tr> <tr> <td class='x-grid-cell' width = '20%' height = '18' align='left' valign='top' style='padding:4px'><b>Fix Time<b></td>");
					//headerValues.put("problemTimeValue",tmpDate);
					//headerValues.put("fixTime","Fix Time");

				tmpDate = (String)allcomp_details.get(6);
				if (tmpDate.indexOf("*")>-1)
						tmpDate = tmpDate.replace('*',' ');
				timeZoneConverter = new EgTimeZoneConverter(tmpDate , u_ser);
				tmpDate = timeZoneConverter.getDateTime();
				sbData.append("<td class='x-grid-cell' width = '80%' align='left' valign='top' style='padding:4px'>"+tmpDate+"</td> </tr> </table> </td> </tr> </table> </td> </tr></table></td></tr></tbody>");
				//headerValues.put("fixTimeValue",tmpDate);
				//nameAndValues.put("headerValues",headerValues);
				//for csv starts
				//vec_Tabletitle.add(mappingInfo.getComponentTypeDescription((String)allcomp_details.get(1)));
				vec_Tabletitle.add(org_comp_type);
				vec_Tabletitle.add((String)allcomp_details.get(0));
				vec_Tabletitle.add(mappingInfo.getTestDescription((String)allcomp_details.get(10)));
				vec_Tabletitle.add(desc);
				vec_Tabletitle.add(mappingInfo.getMeasureDescription(tst,mes));

				String reason1=(String)allcomp_details.get(7);
				StringBuffer bs=new StringBuffer();
				bs.append("\"");
				bs.append(reason1);
				bs.append("\"");
				reason1=bs.toString();
				vec_Tabletitle.add(reason1);

				String fix1=(String)allcomp_details.get(8);
				StringBuffer bs2=new StringBuffer();
				bs2.append("\"");
				bs2.append(fix1);
				bs2.append("\"");
				fix1=bs2.toString();
				vec_Tabletitle.add(fix1);

				String pro_date=(String)allcomp_details.get(5);
				timeZoneConverter = new EgTimeZoneConverter(pro_date , u_ser);
				pro_date = timeZoneConverter.getDateTime();
				StringBuffer bs3=new StringBuffer();
				bs3.append("\"");
				bs3.append(pro_date);
				bs3.append("\"");
				pro_date=bs3.toString();
				vec_Tabletitle.add(pro_date);

				String fix_date=(String)allcomp_details.get(6);
				timeZoneConverter = new EgTimeZoneConverter(fix_date , u_ser);
				fix_date = timeZoneConverter.getDateTime();
				StringBuffer bs4=new StringBuffer();
				bs4.append("\"");
				bs4.append(fix_date);
				bs4.append("\"");
				fix_date=bs4.toString();
				vec_Tabletitle.add(fix_date);
				vec_Tabletitle.add("\n");
				//csv ends
				//resultArray.add(nameAndValues);
			}
			//json.put("resultArray",resultArray);
		}
		sbData.append("</td></tr></table></tbody></table></div></div></td> </tr> </table></div>");
	}
	else if(modifyDiv==null || !modifyDiv.equalsIgnoreCase("modifyDiv"))
	{
		sbData.append("<div style='margin:13% 0 auto 0'><div class='iconExclamation' style='margin:0 auto'></div><div style='margin:0 0 auto 46%' class='rcontrol-load errorpanelText'>No data Available</div></div>");
	}
	else if(modifyDiv!=null || modifyDiv.equalsIgnoreCase("modifyDiv"))
	{
		sbData.append("<table cellspacing='0' cellpadding='2' width='100%' align='center' border='0' height='100%' style='margin:50% 0 auto 0'> <tr> <td align='center' valign='middle' height='100%' width='100%' class='eg_75bold'><br><img src='eg_images/load_round.gif' align='center'></td> </tr> </table>");
	}
	//sbData.append("</td>");

	json.put("tableData",sbData.toString());
	json.put("dataSize",dataSize);
	response.getWriter().write(json.toString());

	//modify block starts
	if(modifyDiv!=null && modifyDiv.equalsIgnoreCase("modifyDiv"))
	{
		String modifyQuery="";

		String prevProbDate=request.getParameter("prevProbDate");
		String prevFixDate=request.getParameter("prevFixDate");
		prevProbDate=DateUtil.changeDateFormat(prevProbDate,currentDateFormat+ " HH:mm:ss","yyyy-MM-dd H:m:ss");
		prevFixDate=DateUtil.changeDateFormat(prevFixDate,currentDateFormat+ " HH:mm:ss","yyyy-MM-dd H:m:ss");

		String prevProbReason=request.getParameter("prevProbReason");
		String prevProbFix=request.getParameter("prevProbFix");

		EgTimeZoneConverter mstart_timeZoneConverter = new EgTimeZoneConverter(modify_probtime+" "+modify_probhr+":"+modify_probmin+":00",user,true);

		modify_probtime = (String)mstart_timeZoneConverter.getDate(false);
		modify_probhr = (String)mstart_timeZoneConverter.getHour();
		modify_probmin = (String)mstart_timeZoneConverter.getMinute();

		EgTimeZoneConverter mend_timeZoneConverter = new EgTimeZoneConverter(modify_fixtime+" "+modify_fixhr+":"+modify_fixmin+":00",user,true);

		modify_fixtime = (String)mend_timeZoneConverter.getDate(false);
		modify_fixhr = (String)mend_timeZoneConverter.getHour();
		modify_fixmin = (String)mend_timeZoneConverter.getMinute();

		String tmp_date=DateUtil.changeDateFormat(modify_probtime,userDateFormat,"yyyy-MM-dd");
		String tmp_date1=DateUtil.changeDateFormat(modify_fixtime,userDateFormat,"yyyy-MM-dd");
		String msmtdate="";
		String fixdate="";
		String msmtdatetime="";
		String fixdatetime="";
		if(modify_probtime!=null && modify_fixtime!=null)
		{
			msmtdate=modify_probhr+":"+modify_probmin+":"+"00";
			fixdate=modify_fixhr+":"+modify_fixmin+":"+"00";
		}
		StringBuffer buf=new StringBuffer();
		buf.append(tmp_date);
		buf.append(" ");
		buf.append(msmtdate);
		StringBuffer buffer=new StringBuffer();
		buffer.append(tmp_date1);
		buffer.append(" ");
		buffer.append(fixdate);
		msmtdatetime=buf.toString();
		fixdatetime=buffer.toString();

		String tmp_date2=DateUtil.changeDateFormat(def_probDate,currentDateFormat,"yyyy-MM-dd");
		String tmp_date3=DateUtil.changeDateFormat(def_fixDate,currentDateFormat,"yyyy-MM-dd");
		String def_msmtdate="";
		String def_fixdate="";
		String def_msmtdatetime="";
		String def_fixdatetime="";

		if(def_probDate!=null && def_fixDate!=null)
		{
			def_msmtdate=def_probhr+":"+def_probmin+":"+"00";
			def_fixdate=def_fixhr+":"+def_fixmin+":"+"00";
		}

		StringBuffer sb1=new StringBuffer();
		sb1.append(tmp_date2);
		sb1.append(" ");
		sb1.append(def_msmtdate);
		StringBuffer sb2=new StringBuffer();
		sb2.append(tmp_date3);
		sb2.append(" ");
		sb2.append(def_fixdate);
		def_msmtdatetime=sb1.toString();
		def_fixdatetime=sb2.toString();
		modify_info="+"+modify_info;
		if(modify_comp!=null && modify_comp.indexOf(":")<0 && !modify_comp.equals("-"))
		{
			modify_comp=modify_comp+":NULL";
		}
		egDb = EgDbAdapterTypeUI.getObject();
		try
		{
			
			//Added by Chandrasekhar.P to convert date into standard db format(Ui may be nay but db format is yyyy-MM-dd  HH:mm:ss)


			
			
			//msmtdatetime = DateUtil.changeDateFormat(msmtdatetime,userDateFormat+" HH:mm:ss","yyyy-MM-dd  HH:mm:ss");
			//fixdatetime = DateUtil.changeDateFormat(fixdatetime,userDateFormat+" HH:mm:ss","yyyy-MM-dd  HH:mm:ss");
			
			//def_msmtdatetime = DateUtil.changeDateFormat(def_msmtdatetime,currentDateFormat+" HH:mm:ss","yyyy-MM-dd  HH:mm:ss");
			//def_fixdatetime = DateUtil.changeDateFormat(def_fixdatetime,currentDateFormat+" HH:mm:ss","yyyy-MM-dd  HH:mm:ss");


			str_conn=egDb.setConnection();
			modifyQuery=egDb.modifyKBSearch(modify_comp,modify_test,modify_measure,modify_info,msmtdatetime,fixdatetime,modify_probreason,modify_probfix,modify_fixby,def_msmtdatetime,def_fixdatetime);
			
			boolean update=egDb.UpdateToDb(modifyQuery);
			boolean release=egDb.releaseConnection(false);

			if(update)
			{
				AuditLogThread auditLogThread = new AuditLogThread();
				auditLogThread.setValue("User_id",u_ser.getLoginID());
				auditLogThread.setValue("Host_ip",u_ser.getUserIP(session.getId()));
				auditLogThread.setValue("Session_id",session.getId());
				auditLogThread.setValue("Category","Monitor");
				auditLogThread.setValue("Module","Knowledge Base Search");
				auditLogThread.setValue("Activity","Modify Feedback");
				auditLogThread.setCurrentValue("Site","NONE");
				auditLogThread.setCurrentValue("Component Name",modify_comp);
				auditLogThread.setCurrentValue("Component Type","$ctype$:"+modify_compType);
				auditLogThread.setCurrentValue("Info", "$measureAlert$:"+modify_test+":"+modify_measure+"{"+modify_info+"}");
				auditLogThread.setCurrentValue("Test","$test$:"+modify_test);
				auditLogThread.setCurrentValue("Measure","$measure$:"+modify_test+":"+modify_measure);
				auditLogThread.setCurrentValue("Measure Time","$time$:"+msmtdatetime);
				auditLogThread.setCurrentValue("Fix Time","$time$:"+fixdatetime);
				auditLogThread.setCurrentValue("Problem Reason",modify_probreason);
				auditLogThread.setCurrentValue("Problem Fix",modify_probfix);
				auditLogThread.setCurrentValue("Problem Fixed by",modify_fixby);
				auditLogThread.setValue("Description","Feedback about the Problem");
				auditLogThread.sendItToDB();
			}
		}
		catch(Exception e)
		{
			String s_errmsg = "";
			if (!str_conn.equals("CONNECTED"))
			{
				s_errmsg = "Connection could not be established";
			}
			try
			{
				egDb.releaseConnection(true);
			}
			catch(Exception e1){}
		}
		try
		{
			if(egDb != null)
				EgDbAdapterTypeUI.releaseObject(egDb);
		}
		catch(Exception qq)
		{
		}
	}
	//modify block ends
%>
<%
	listData.add(vec_Tabletitle);
	session.setAttribute("list",listData);
	session.setAttribute("modify",ModifyComponent);
}
catch(Exception ex)
{
	ex.printStackTrace();
}
if(request.getParameter("newWindow")==null || (request.getParameter("newWindow")!=null && !request.getParameter("newWindow").equals("true")))
{
	if(request.getQueryString()!=null)
	{
		session.setAttribute("monitorLastSession","/final/monitor/KBSearch.jsp?"+request.getQueryString());
	}
	else session.setAttribute("monitorLastSession","/final/monitor/KBSearch.jsp");
}
%>


