<!DOCTYPE html>

<%
/*****************************************************************************************************
*	Name		:	EgSegmentTopologyJS.jsp
*	Purpose		:	To display the segment topology using Java Script & Raphael JS Library
******************************************************************************************************/
%>
<%@ include file = "EgLoginTracker.jsp" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import = "egurkha.EgCrawler" %>
<%@ page import = "com.egurkha.EgConstants" %>
<%@ page import = "com.egurkha.monitor.alarms.AlarmPriorities" %>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "com.egurkha.ini.IniUI" %>
<%@ page import = "com.egurkha.EgNewTopology" %>
<%@ page import = "com.eg.TopoRhsComp" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.eGComponentCategory" %>
<%@ page import = "com.eg.EgConfigFilesSync" %>
<%@ page import = "com.egurkha.monitor.VMDesktopBean" %>
<%@ page import = "com.egurkha.supermanager.*" %>
<%@ page import = "java.util.*" %>
<%@ taglib prefix = "egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"  autoFlush="true"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
	eGComponentCategory egCompCategory = eGComponentCategory.getInstance();
	IniFile udTests	=	new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_udtests.ini");

	String ua = request.getHeader( "User-Agent" );
	boolean isFirefox = ( ua != null && ua.indexOf( "Firefox/" ) != -1 );
	boolean isMSIE = ( ua != null && ua.indexOf( "MSIE" ) != -1 );

	String topologySkin=u_ser.getMonitorSkin();
	String bgColor = "";
	String animationLineColor="";
	String animationObjColor="";
	String compNameColor="";
	String fontFamily="LucidaGrandeRegular";
	String fontFamilyBold="LucidaGrandeBold";
	String mouseOverLineColor = "";
	String mouseOverTextColor="";
	IniFile egUi = new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_ui.ini");
	//String iniValue=egUi.getValue("TOPOLOGY_OPTIONS","Background");
	if(topologySkin!=null && topologySkin.equalsIgnoreCase("Dark"))
	{
		bgColor=egUi.getValue("TOPOLOGY_DARK_BACKGROUND","BgColor");
		animationLineColor=egUi.getValue("TOPOLOGY_DARK_BACKGROUND","AnimationLineColor");
		animationObjColor=egUi.getValue("TOPOLOGY_DARK_BACKGROUND","AnimationObjColor");
		compNameColor=egUi.getValue("TOPOLOGY_DARK_BACKGROUND","ComponentNameColor");
		mouseOverLineColor = "";
		mouseOverTextColor=egUi.getValue("TOPOLOGY_DARK_BACKGROUND","MouseOverTextColor");
	}
	else
	{
		bgColor=egUi.getValue("TOPOLOGY_LIGHT_BACKGROUND","BgColor");
		animationLineColor=egUi.getValue("TOPOLOGY_LIGHT_BACKGROUND","AnimationLineColor");
		animationObjColor=egUi.getValue("TOPOLOGY_LIGHT_BACKGROUND","AnimationObjColor");
		compNameColor=egUi.getValue("TOPOLOGY_LIGHT_BACKGROUND","ComponentNameColor");
		mouseOverLineColor = "";
		mouseOverTextColor=egUi.getValue("TOPOLOGY_LIGHT_BACKGROUND","MouseOverTextColor");
	}
	String animationValue=egUi.getValue("TOPOLOGY_OPTIONS","Animation");
	if(animationValue==null || animationValue.length()==0)
		animationValue="no";
	animationValue = animationValue.toLowerCase();
	
	String segmentName = request.getParameter("segment");
	String segmentState = request.getParameter("segmentState");
	String fromHomepage = request.getParameter("fromHomepage");
	if(EgInstallInfo.isSuperManager)
	{
		String currentSession = session.getId();
		if(segmentName != null)
		{
			ArrayList managerIDs = EgElementInfo.getInstance().getManagerIDs("segment",segmentName);
			if(managerIDs != null && !managerIDs.isEmpty())
			{
				SmSessionData smsData = new SmSessionData(currentSession,managerIDs);
				EgThreadLocal egtl = new EgThreadLocal();
				egtl.set(smsData);
				new SMDateTimeConverter(managerIDs);				
			}
		}
	}
	if(segmentName!=null)
		segmentName = segmentName.trim();
	String zoomLevel = request.getParameter("zoom");
		if(zoomLevel==null) zoomLevel = "100";
	String view = request.getParameter("view");

	boolean isFull = false;
	if(view!=null && view.equals("full"))
		isFull = true;

	String color = "A0A0A0";
	String dark = "150517";

	String site = request.getParameter("site");
	if(site == null)
		site ="";
	String phyTopology = request.getParameter("physical_topology");
	String service = request.getParameter("service");
	if(service == null)
		service ="";
	String topoType = request.getParameter("type");
	if(topoType == null)
		topoType ="";

	// topoType = segment ==>	SEGMENT_TOPOLOGY
	// topoType = virtual ==>	VIRTUAL_TOPOLOGY
	// topoType = monitor ==>	SERVICE_TOPOLOGY

	String vmhost = request.getParameter("Vmhost");
	String vmware = request.getParameter("vmware");
	String treeFlag=request.getParameter("treeFlag");
	String isFromZone = request.getParameter("isFromZone");
	String iszoneName = request.getParameter("iszoneName")!=null?request.getParameter("iszoneName"):"";
	String parentZone = request.getParameter("parentZone");
	if(vmware==null)
		vmware = "";
	String finalTopoStr = getTopologyString(segmentName , site , phyTopology, vmhost , request);
	//System.out.println("finalTopoStr :"+finalTopoStr);
	String conPath = request.getContextPath();
	String contextPath = request.getContextPath()+"/images/"+monitor_Skin+"/component_icons/";
	String contextSkinPath = request.getContextPath()+"/images/"+monitor_Skin+"/";
	String serverImagePath = contextPath ;
	String userImagePath = request.getContextPath()+"/images/"+monitor_Skin+"/component_icons/";
	//String groupImagePath = request.getContextPath()+"/images/"+monitor_Skin+"/component_icons/";
	String groupImagePath = request.getContextPath()+"/images/component_icons/";
	String ICImagePath=request.getContextPath()+"/images/"+monitor_Skin+"/ic_images/";

	//Get row & column spacing from eg_ui.ini .... (Begin)
	IniUI iniUI = IniUI.getInstance();
	String rs =	iniUI.getValue("TOPOLOGY_OPTIONS","Row_space");
	String cs = iniUI.getValue("TOPOLOGY_OPTIONS","Column_space");
	iniUI =  null;
	int rowspace = 50;
	int colspace = 50;
	try
	{
		if(rs!=null) rowspace = Integer.parseInt(rs);
	}
	catch(Exception e){
	}

	try
	{
		if(cs!=null) colspace = Integer.parseInt(cs);
	}
	catch(Exception e){
	}
	//Get row & column spacing from eg_ui.ini .... (End)

	EgNewTopology egNewTopo= new EgNewTopology(finalTopoStr,rowspace,colspace);
	ArrayList postionArrList = egNewTopo.getOutputValues();

	int divHeight = egNewTopo.getHeight()+50;
	int divWidth  = egNewTopo.getWidth()-50;

	String cursorType ="pointer";

	StringBuffer outPutBuffer = new StringBuffer();
	if(postionArrList!=null)
	{
		outPutBuffer.append(postionArrList.toString().substring(1,postionArrList.toString().indexOf("]")));
	}

	%>

	<script>
		var postionArrListArray = new Array();
		var comCatagoryArray = new Array();
		var icCatagoryArray = new Array();
	<%		
				if(postionArrList!=null && postionArrList.size()>0){
					for(int k=0;k<postionArrList.size();k++){
						String compTypeNamePort = (String)postionArrList.get(k);
						if(compTypeNamePort!=null && !compTypeNamePort.startsWith(":"))
						{
							StringTokenizer st = new StringTokenizer(compTypeNamePort,":");
							String compTypeOriName = st.nextToken();
							String compTypeDispName = trackerMappingInfo.getComponentTypeDescription(compTypeOriName);
							String comCatogary = egCompCategory.getCategoryforCompType(compTypeOriName);
							if(compTypeOriName.endsWith("_ex"))
							{
								String name =udTests.getValue("COMP_DISPLAYIMAGE_NICK",compTypeOriName);

	%>
							icCatagoryArray.push({
							name:'<%=compTypeOriName%>',
							value:'<%=name%>'
							});

	<%
							}else
							{
	%>
							comCatagoryArray.push({
							name:'<%=compTypeOriName%>',
							value:'<%=comCatogary%>'
							});
<%
							}
%>							
						
							postionArrListArray.push({
							name:'<%=compTypeOriName%>',
							value:'<%=compTypeDispName%>'
						});

						

	<%					}
					}
				}
	%>

	


	</script>

	<%	
	String fromSuper = request.getParameter("fromSuper");
	String sessionID = request.getParameter("sessionId");

	boolean isfromSuper = false;
	if(fromSuper!=null && fromSuper.equals("yes"))
	{
		isfromSuper = true;
	}

	String iniFileName = EgInstallInfo.getInstallDir()+"/manager/config/js_topology.ini";
	IniFile jsTopoIniObj  = EgConfigFilesSync.getInstance(iniFileName);
	String subjectName = segmentName;
	if(segmentName!=null && segmentName.equals("Independent_servers"))
	{
		subjectName = site+ "~|#|~"+segmentName;
	}
	String[] allLines = jsTopoIniObj.getLinesUnderSubject(subjectName);
	String iniZoom = jsTopoIniObj.getValue(subjectName,"zoom");
	if(iniZoom != null && iniZoom.length() > 0 )
	{
		zoomLevel = iniZoom;
	}
	EgConfigFilesSync.releaseInstance(jsTopoIniObj);

	boolean isPosition = false;
	StringBuffer positionBuffer = new StringBuffer();
	if(allLines!=null)
	{
		List positionList = Arrays.asList(allLines);
		positionBuffer.append(positionList.toString().substring(1,positionList.toString().indexOf("]")));
		isPosition = true;
	}
//getting data from eg_lang_US.ini file
	ArrayList tokeList = new ArrayList();
	for(int i=0;i<postionArrList.size();i++)
	{
		String key =(String)postionArrList.get(i);
		
		StringTokenizer tokenizer = new StringTokenizer(key,",");
		String tokenVal=tokenizer.nextToken();
		tokeList.add(tokenVal);
	}
	ArrayList keyList= new ArrayList();
	for(int i=0;i<tokeList.size();i++)
	{
		String t_key=(String)tokeList.get(i);
		String key = t_key.substring(0,t_key.indexOf("="));
		keyList.add(key);
		
	}
	StringBuffer pnameBuffer = new StringBuffer();
	ArrayList valueList = new ArrayList();
	boolean isName = true;
	String delim="";
	String val="";
	for(int i=1;i<keyList.size();i++)
	{
		delim="=";
		String key1=(String)keyList.get(i);
		String keyValue=key1.substring(0,key1.indexOf(":"));
		String keyinValue="";
		if(keyValue.indexOf("Agg_")==0)
		{
			keyinValue=keyValue.substring(4);
			
		}
		else
		{
			keyinValue=keyValue;
		}
		String value=trackerMappingInfo.getComponentTypeDescription(keyinValue);
		val+=(keyinValue+":"+value+""+delim);
	}
	
	valueList.add(val);
	
	if(valueList.size()>0)
	{
		
		pnameBuffer.append(valueList.toString().substring(1,valueList.toString().indexOf("]")));
		
		isName=true;
	}
	
	
//end
	
%>
<html>
<head>
	<meta charset="utf-8" http-equiv="X-UA-Compatible" content="IE=8,9,10" >
	<egui:skin ui="monitor"/>

<title><%=segmentName%></title>
<%
	
	String refFrequency = u_ser.getRefreshFrequency();
	StringBuffer metaRefreshUrl = new StringBuffer(64);

	metaRefreshUrl.append(request.getRequestURI());
	String queryString = request.getQueryString();
	if (queryString != null && !queryString.equals("null"))
	{
		metaRefreshUrl.append("?");
		metaRefreshUrl.append(queryString);
	}
	if(isFull)
	{
%>
		<meta http-equiv = "refresh" content = "<%= refFrequency.trim() %>;url=<%=metaRefreshUrl.toString()%>">
<%
	}
%>
<egui:skin ui="monitor"/>


<script src="/final/scripts/map.js" type="text/javascript" charset="utf-8"></script>
<script src="/final/scripts/raphael.js" type="text/javascript" charset="utf-8"></script>
<script src="/final/scripts/raphael.zoom.js" type="text/javascript" charset="utf-8"></script>


<script language="JavaScript1.2" src="/final/jquery/jquery.js"></script>
<script type="text/javascript" src="/final/extjs/ext-all.js"></script>

<script>
function bringToFront(obj)
{
	if (!document.getElementsByTagName)
		return;
	var divs = getAbsoluteDivs();  
	var max_index = 0;  
	var cur_index;  
	for (i = 0; i < divs.length; i++)
	{
		var item = divs[i];
		if (item == obj || item.style.zIndex == '')
			continue;
		cur_index = parseInt(item.style.zIndex);
		if (max_index < cur_index)
		{
			max_index = cur_index;
		}
	}
		obj.style.zIndex = max_index + 1;
}

function getAbsoluteDivs()  
{
	var arr = new Array();
	var all_divs = document.body.getElementsByTagName("DIV");
	var j = 0;
	for (i = 0; i < all_divs.length; i++)
		if (all_divs.item(i).style.position=='absolute')
		{
			arr[j] = all_divs.item(i);
			j++;
	}
	return arr;
}

function hideLoadImage ()
{
	var loading_image = parent.document.getElementById("loading_image");
	if (loading_image != null)
	{
		loading_image.style.visibility = "hidden";
		loading_image.style.display = "none";
	}
}
var $j = jQuery.noConflict();

Ext.onReady(function(){

	setSlider();

});

function setSlider()
{
	Ext.define('AlwaysVisibleTip', {
		extend: 'Ext.slider.Tip',
		id:'mytip',
		cls: 'yellowTip',
		init: function(slider) {
			var me = this;

			me.callParent(arguments);
			slider.removeListener('dragend', me.hide);
			slider.on({
				scope: me,
				change: me.onSlide,
				afterrender: {
					fn: function() {
						me.onSlide(slider, null, slider.thumbs[0]);
						tip_hide_task.delay(2000);


					},
					delay: 100
				}
			});
		}
	});

	var tip_hide_task = new Ext.util.DelayedTask(function(){
		if (Ext.getCmp('mytip') != undefined)
		{
		  Ext.getCmp('mytip').hide();
		}
	});

	Ext.create("Ext.form.Panel", {
	width:88,
	renderTo: Ext.getBody(),
	baseCls:'emptyCls',
	height:210,
	border:0,
	plain:true,
	bodyStyle:{'background':'transparent'},
	style:{'position':'absolute','top':'80px','left':'25px','background':'transparent'},
	items: [
		{
			xtype: 'container',
			items: [{
				xtype: 'button',
				cls:'zoomInbt',
				width:18,
				height:18,
			  handler: function() {
				var sliderValue=Ext.getCmp('sliderSingle').getValue();
				sliderValue=parseInt(sliderValue);
				if(sliderValue<150)
				{
					sliderValue=sliderValue+10;
				}
				if(sliderValue>150)
				{
					sliderValue=150;
				}
				Ext.getCmp('sliderSingle').setValue(sliderValue);
				tip_hide_task.delay(2000);
				setZoomLevel(sliderValue);
			  }
			   
			},
        Ext.create('Ext.slider.Single', {
        hideLabel: true,
		id:'sliderSingle',
        useTips: false,
		animate: false,
		plugins: [Ext.create('AlwaysVisibleTip')],
        height: 98,
		value: '<%=zoomLevel%>',
        vertical: true,
        minValue: 10,
        maxValue: 150,
		listeners : {
			
			'changecomplete' : function( slider, e, eOpts )
			{
				var sliderValue=Ext.getCmp('sliderSingle').getValue();
				setZoomLevel(sliderValue);
				
			}
		}
    }), 
			{
				xtype: 'button',
				width:18,
				height:18,
				style:{'margin-top':'-6px'},
				cls:'zoomOutbt',
			  handler: function() {
					var sliderValue=Ext.getCmp('sliderSingle').getValue();
					sliderValue=parseInt(sliderValue);
					if(sliderValue>10)
					{
						sliderValue=sliderValue-10;
					}
					if(sliderValue<10)
					{
						sliderValue=10;
					}
				  Ext.getCmp('sliderSingle').setValue(sliderValue);
				  tip_hide_task.delay(2000);
				  setZoomLevel(sliderValue);
			  }
			}
        ]
    }]
   });
}

function openBigDiv()
{
	var mySegment = '<%=segmentName%>';
	var site = '<%=site%>';
	var phytopology = '<%=phyTopology%>';
	var service = '<%=service%>';
	var type = '<%=topoType%>';
	var isFrm = '<%=isfromSuper%>';

	var myUrl = "/final/monitor/EgSegmentTopologyJS.jsp?physical_topology="+phytopology;

	if(type == 'segment')		//Segment Topology
	{
		myUrl = myUrl + "&type=segment";
	}
	else if(type == 'virtual')	// Virtual Topology
	{
		var vmhost = '<%=vmhost%>';
		myUrl = myUrl + "&type=virtual&vmware=true&Vmhost="+encodeURI(vmhost);
	}
	else if(type == 'monitor')	//Monitor Topology
	{
		myUrl = myUrl + "&type=monitor";
	}


	if(service!="" && service.length > 0)
	{
		myUrl = myUrl + "&service="+encodeURIComponent(service)+"&site="+encodeURIComponent(site);
	}

	if(isFrm == 'true')
	{
		var sm = '<%=fromSuper%>';
		var sessid = '<%=sessionID%>';
		myUrl = myUrl + "&fromSuper="+sm+"&sessionId="+sessid;
	}
	myUrl = myUrl + "&segment="+encodeURIComponent(mySegment);

	newwindow=window.open(myUrl+"&view=full",'Topology','width='+screen.width+',height='+screen.height+', status=yes,scrollbars=no,resizable=yes');
	if (window.focus) {newwindow.focus()}
		return false;
}

</script>
</head>
<body leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" bgcolor="<%//=bgColor%>" style="background:transparent" >
<form name="topologyForm" id="topologyForm" style="margin:0px;padding:0px;">
<table style="margin:15px 10px 0px 27px;">
	<tr>
		<td style="padding-bottom:10px" class="font_normal13"><egui:intnl text="monitor.topology.Segment"/>:</td>
	</tr>
	<tr>
		<td><div style="float:left;margin-right:5px;" class="<%=segmentState%>"></div><div style="float:left;margin-top:0px;" class="font_bold13"><%=segmentName%></div><div style="clear:both"></div></td>
	</tr>
</table>
<div id="ZoomDiv" name="ZoomDiv" style="display: none;left:20px;top:6px;width:110px;border:0px solid #ff0000;position:absolute;z-Index:100" >

<table border="0" bordercolor="green" cellpadding="0" cellspacing="0" >
	<tr>
		<td class="attach_left_curve"><img src="/final/monitor/eg_images/spacer.gif" width="4px" border="0px"></td>
		<td height="24px" class="attach_bg" align="left" valign="middle">
			<table  border="0" cellspacing="0" cellpadding="3">
				<tr>
					<td><a href="javascript:void(0);" class="topo_zoomOutImg" title="Zoom out" onclick="javascript:setZoomLevel('1');"><img src="/final/admin/eg_images/spacer.gif" width="21" height="19" border="0"></a></td>


						<td valign="top" style="padding:0px;margin:0px"><input type="text" name="zoomTxt" id="zoomTxt" value="100%" size="5" class="linesquare" readonly="readonly" disabled="disabled" style="margin-top:3px"></td>

					<td><a href="javascript:void(0);" class="topo_zoomInImg" title="Zoom in" onclick="javascript:setZoomLevel('-1');"><img src="/final/admin/eg_images/spacer.gif" width="21" height="19" border="0"></a></td>

					<td class="topo_divide" ><img src="/final/admin/eg_images/spacer.gif" width="2" height="19" border="0"></td>
<%
	if(isFull)
	{
%>
					<td><a href="javascript:void(0);" class="topo_newwindowImg" name='maxImage' id='maxImage'  onclick="javascript:self.close();" title="Close"><img src="/final/admin/eg_images/spacer.gif" width="21" height="19" border="0"></a></td>
<%
	}
	else
	{
%>
					<td><a href="javascript:void(0);" class="topo_newwindowImg" name='maxImage' id='maxImage' onclick="javascript:openBigDiv();" title="New window"><img src="/final/admin/eg_images/spacer.gif" width="21" height="19" border="0"></a></td>
<%
	}
%>
				</tr>
			</table>
		</td>
		<td class="attach_right_curve"><img src="/final/monitor/eg_images/spacer.gif" width="4px"  border="0px"></td>
	</tr>
</table>
</div>
<div  class="div_scroll" style="width:50%;height:auto;border:0px solid black;visibility:hidden;display:none" id="alarmsListDiv">
</div>

<%
	if(isFull)
	{
		String full_style = "width:100%;height:100%;border:0px solid #ff0000";
		if(isMSIE)
		{
			full_style = "width:100%;height:100%;border:0px solid #ff0000";
		}
		cursorType = "default";
%>
	<div id="container" class ="div_scroll" style="<%=full_style%>">
<%
	}
	else
	{
%>
	<div id="container"  style="margin-top:-40px;width:100%;">
<%
	}
%>
	<!--<table id="mytable" border="0" width="100%" height="100%" cellspacing="0" cellpadding="0">
		<tr>
			<td>-->
				<div id="paper"  name="paper" style="width:'100%';height:'100%';border:0px solid red;"></div>
			<!--</td>
		</tr>
	</table>-->
	</div>

<!-- Zoom DIV  -->


<script type="text/javascript">

function closeDiv(){
	var divId = document.getElementById("alarmsListDiv");
	divId.style.visibility='hidden';
}

function showDiv(){

	var divId = document.getElementById("alarmsListDiv");
	divId.style.visibility='block';
}

var zom = parseInt('<%=zoomLevel%>')/100;
var fullView = '<%=isFull%>';
var width = 916;
var height = 500;
var gifWidth = 48*zom;
var gifHeight = 48*zom;
var sPngWidth = 20*zom;
var sPngHeight = 20*zom;
var userWidth = 48*zom;
var userHeight = 48*zom;

var el;
var componentStateMap = new Map; 
var compPosition = new Map;
var compAttrMap = new Map;
var mainComponent = new Array();
var connectionArr = new Array();
var arr = new Array();
var allCompNames = new Array();
var maintenanceArr = new Array();
var mainPathArr = new Array();
var mainCircleArr = new Array();

var compIndexMap = new Map();
var topostring ='<%=finalTopoStr%>';
var positionString ='<%=outPutBuffer%>';
var websitename;
var iniMaxW = 0;
var iniMaxH = 0;
// addding

var egtop_iniMap = new Map();
var alltpNames = new Array();
//end
r = Raphael("paper", width, height);
//r.initZoom();

// Zoom supports from 10% to 150%

function loadPopup(qUrl)
{	
	if(!Ext.isEmpty(qUrl))
	{
		var tmpUrl = qUrl.substring(qUrl.indexOf("?")+1);
		tmpUrl = "componentMeasureTabSet.jsp?"+tmpUrl;
		//window.open(tmpUrl,'GRAPHS','toolbar=no,menubar=no,location=no,status=no,width=1014,height=603,left=0,top=80,screenx=0,screeny=0,resizable=yes,scrollbars=yes');
		parent.openWindow(tmpUrl,'GRAPHS','toolbar=no,menubar=no,location=no,status=no,width=1014,height=603,left=0,top=80,screenx=0,screeny=0,resizable=yes,scrollbars=yes');
	}
}

function OpenLayerModel(url){
	if(!Ext.isEmpty(url))
	{
		parent.location.href=url;
	}
}

r.customAttributes.ToolTip = function (tip) {
	return {ToolTip : tip};
};

function setZoomLevel(zoomHidden)
{
	
	var zInt = parseInt(zoomHidden);
	zInt = zInt.toFixed();
	document.getElementById("zoom").value = zInt;
	
	setZoom(zInt / 100);
	savePositions("zoom");
}

var xmlhttp;
function savePositions(str)
{
	var segmentname ='<%=segmentName%>';
	if(segmentname == 'Independent_servers')
	{
		var siteName = '<%=site%>';
		segmentname = siteName+"~|#|~"+segmentname;
	}
	var url = "/final/servlet/com.eg.SegmentPositionServlet";
	var zoomHidden = document.getElementById("zoom").value;
	var params;
	if (str == 'zoom')
	{
		params = "action="+str+"&segment="+segmentname+"&zoom="+zoomHidden;
	}

	xmlhttp = new getXMLObject();
	if(xmlhttp)
	{
		xmlhttp.open("POST",url,true);
		xmlhttp.onreadystatechange  = function()
		{
			if (xmlhttp.readyState == 4) 
			{
				if(xmlhttp.status != 200) 
				{
					//alert("Error occured while saving. Please try again ...."+xmlhttp.status);
				}
				else
				{
					window.location.href = '<%=metaRefreshUrl.toString()%>';
					for(var i=0; i<mainCircleArr.length;i++)
					{
						//mainCircleArr[i].show();
					}
				}
			}
		}
		xmlhttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
		xmlhttp.send(params);
	}
}

function getXMLObject()  //XML OBJECT
{
	var xmlHttp = false;
	try 
	{
		xmlHttp = new ActiveXObject("Msxml2.XMLHTTP");
	}
	catch (e) 
	{
		try 
		{
			xmlHttp = new ActiveXObject("Microsoft.XMLHTTP");
		}
		catch (e2) 
		{
			xmlHttp = false;
		}
	}
	if (!xmlHttp && typeof XMLHttpRequest != 'undefined') 
	{
		xmlHttp = new XMLHttpRequest();
	}
	return xmlHttp;
}

function setZoom(zoom) 
{
	var holderDiv = document.getElementById("paper");
	var holderH = document.getElementById("paper").clientHeight-5;
	var holderW = document.getElementById("paper").clientWidth-15;
	//holderDiv.style.width = holderW;
	//holderDiv.style.height = holderH;
	zom = zoom;
	var regW = holderW>iniMaxW?holderW:iniMaxW;
	var regH = holderH>iniMaxH?holderH:iniMaxH;
//	r.setSize(1.2*regW*zoom,regH*zoom);
	r.setSize(regW*zoom,regH*zoom);
	r.setZoom(zoom);
	if(width <= 916) width = 916;
	if(height <= 500) height = 500;
	if(parent.document.getElementById("zoom")!=null)
		parent.document.getElementById("zoom").value= (zom * 100).toFixed();
}

setZoom(zom);

function resizePaperDiv(w, h)
{
	var intW = w;
	var intH = h;
	var resize = "false";
	
	if(intW > 916)
		resize = "true";
	else
		intW = 916;

	if(intH > 520)
		resize ="true";
	else
		intH = 520;
	
	if(resize == "true")
	{
		r.setSize(intW*zom,intH*zom);
	}
}

function getMapDetails(posString)
{
	
	var changeHeight = '<%=divHeight%>';
	var changeWidth = '<%=divWidth%>';
	
	var intW = parseInt(changeWidth);
	var intH = parseInt(changeHeight);

	resizePaperDiv(2*intW, intH);

	// Get Positions from ini File (Begin) , if it is already saved.
	var position = '<%=isPosition%>';
	var iniPositionArr = new Array();
	var iniMap = new Map();
	if(position == 'true')
	{
		var allvec = '<%=positionBuffer.toString()%>';
		iniPositionArr = allvec.split(", ");
	}

	for(var i=0; i<iniPositionArr.length;i++)
	{
		var arrElement =  iniPositionArr[i];
		var iniMapKey =  arrElement.substring(0,arrElement.indexOf("="));
		var iniMapValue = arrElement.substring(arrElement.indexOf("=")+1);
		iniMap.put(iniMapKey,iniMapValue);
	}
	// Get Positions from ini File (End)  
	//adding Data
		
	var isname = '<%=isName%>';
	var inidataArr = new Array();
	if(isname=='true')
	{
		var positionName = '<%=pnameBuffer.toString()%>';
		inidataArr=positionName.split("=");
	}
	for(var i=0;i<inidataArr.length;i++)
	{
		var arrElement =  inidataArr[i];
		
		var iniMapKey =  arrElement.substring(0,arrElement.indexOf(":"));
		var iniMapValue = arrElement.substring(arrElement.indexOf(":")+1);
		
		egtop_iniMap.put(iniMapKey,iniMapValue);
		
		
	}
	//end
	var tokens = posString.split(", ");
	var compInd = 0;
	var resize = "false";
	iniMaxW = intW;
	iniMaxH = intH;

	var zoomHiddVal=document.getElementById("zoom").value;

	for(var i=0; i<tokens.length;i++)
	{
		var tokvalue = tokens[i];
		var key = tokvalue.substring(0,tokvalue.indexOf("="));
		var rhs = tokvalue.substring(tokvalue.indexOf("=")+1);

		if(key.indexOf(":")==0)
		{
			key = 'egurkha.physical.topology';
		}

		if(iniMap.contains(key)) // Load Position from INI File......
		{
			var iniXY  = iniMap.get(key);
			var iniX = parseInt(iniXY.substring(0,iniXY.indexOf("#")));
			var iniY = parseInt(iniXY.substring(iniXY.indexOf("#")+1));

			if(zoomHiddVal!=null && zoomHiddVal!=undefined && zoomHiddVal<=10)
			{
				iniX = iniX+350;
			}
			else if(zoomHiddVal!=null && zoomHiddVal!=undefined && (zoomHiddVal>10 && zoomHiddVal<=15))
			{
				iniX = iniX+300;
			}
			else if(zoomHiddVal!=null && zoomHiddVal!=undefined && (zoomHiddVal>15 && zoomHiddVal<=30))
			{
				iniX = iniX+250;
			}
			else if(zoomHiddVal!=null && zoomHiddVal!=undefined && (zoomHiddVal>30 && zoomHiddVal<=40))
			{
				iniX = iniX+200;
			}
			else if(zoomHiddVal!=null && zoomHiddVal!=undefined && (zoomHiddVal>40 && zoomHiddVal<=50))
			{
				iniX = iniX+150;
			}
			else if(zoomHiddVal!=null && zoomHiddVal!=undefined && (zoomHiddVal>50 && zoomHiddVal<=60))
			{
				iniX = iniX+100;
			}
			else if(zoomHiddVal!=null && zoomHiddVal!=undefined && (zoomHiddVal>60 && zoomHiddVal<=70))
			{
				iniX = iniX+50;
			}
			else if(zoomHiddVal!=null && zoomHiddVal!=undefined && (zoomHiddVal>70 && zoomHiddVal<=80))
			{
				iniX = iniX+20;
			}

			//If Componenet is Position with non-default Resize is required...
			if(iniX >= iniMaxW)
			{
				resize = "true";
				iniMaxW = iniX + 200;
			}

			if(iniY >=iniMaxH)
			{
				resize = "true";
				iniMaxH = iniY + 100;
			}

			if(key == 'egurkha.physical.topology' ) // User Image
			{
				arr.push(r.image('<%=userImagePath%>'+'user_image.png', iniX*zom, iniY*zom , userWidth , userHeight).attr({"ToolTip" :"User",title :"User"}));
				compPosition.put(key,iniY*zom+"#"+iniY*zom);
			}
			else	// Other components....
			{
				var comptype = key.substring(0,key.indexOf(":")); 
				var compTypeDisplayname;
				for(x=0;x<postionArrListArray.length;x++){
					if(postionArrListArray[x].name==comptype){
						compTypeDisplayname = postionArrListArray[x].value;
						break;
					}
				}
				var comptip = key.substring(key.indexOf(":")+1);
				if(comptip.indexOf(":NULL")>0)
					comptip = comptip.substring(0,comptip.indexOf(":NULL"));
				var compImage="";
				var tooltip = compTypeDisplayname+":"+comptip;
				if(comptype!=null && (comptype.match("_ex$")=="_ex" || comptype.indexOf("Agg_")==0 || comptype.indexOf("Group")==0))
				{
					
					var gcomptype=comptype;
					if(comptype.indexOf("Group")>-1)
						gcomptype="group";
					
					if(comptype.indexOf("Agg_")==0)
					{
						compImage = r.image('<%=serverImagePath%>'+"AGGREGATES"+'.png', iniX*zom, iniY*zom , gifWidth , gifHeight).attr({ "ToolTip" : tooltip, path : comptype});
					}
					else if(comptype.match("_ex$") == "_ex")
					{
						
						var icImageName = "";
						for(x = 0;x<icCatagoryArray.length;x++)
						{
							if(icCatagoryArray[x].name == comptype)
							{
								icImageName = icCatagoryArray[x].value;
								break;
							}
						}
						compImage = r.image('<%=ICImagePath%>'+icImageName+'.png', iniX*zom, iniY*zom , gifWidth , gifHeight).attr({ "ToolTip" : tooltip, title : tooltip , path : comptype});
					}
					else
					{
						compImage = r.image('<%=groupImagePath%>'+gcomptype+'.png', iniX*zom, iniY*zom , gifWidth , gifHeight).attr({ "ToolTip" : tooltip, path : comptype});
					}
				}
				else
				{
					var comCateName = "";
					for(x=0;x<comCatagoryArray.length;x++)
					{
						if(comCatagoryArray[x].name == comptype)
						{
							comCateName = comCatagoryArray[x].value;
							break;
						}
					}
					compImage = r.image('<%=serverImagePath%>'+comCateName+'.png', iniX*zom, iniY*zom , gifWidth , gifHeight).attr({ "ToolTip" : tooltip, path : comptype});
				}
				arr.push(compImage);
				compPosition.put(key, iniX*zom+"#"+iniY*zom);
				compAttrMap.put(key, comptype+"#"+tooltip);
				//Save the States
				var state = rhs.substring(rhs.lastIndexOf("#")+1);
				state= state.toLowerCase();
				componentStateMap.put(key,state);
			}
		}
		else
		{
			if(key == 'egurkha.physical.topology' ) //User
			{
				var xy = rhs;
				var xPos = parseInt(xy.substring(0,xy.indexOf("#")));
				var yPos = parseInt(xy.substring(xy.indexOf("#")+1));
				arr.push(r.image('<%=userImagePath%>'+'user_image.png', xPos*zom, yPos*zom , userWidth , userHeight).attr({ "ToolTip" :"User",title :"User"}));
				compPosition.put(key, xPos*zom+"#"+yPos*zom);
			}
			else
			{
				var xy = rhs;
				var xPos = parseInt(xy.substring(0,xy.indexOf("#")));
				var ystate = xy.substring(xy.indexOf("#")+1);
				var yPos = parseInt(ystate.substring(0,ystate.indexOf("#")));
				var state = xy.substring(xy.lastIndexOf("#")+1);
				state= state.toLowerCase();

				var comptype = key.substring(0,key.indexOf(":"));
				var compTypeDisplayname;
				for(x=0;x<postionArrListArray.length;x++){
					if(postionArrListArray[x].name==comptype){
						compTypeDisplayname = postionArrListArray[x].value;
						break;
					}
				}
				var comptip = key.substring(key.indexOf(":")+1);
				if(comptip.indexOf(":NULL")>0)
					comptip = comptip.substring(0,comptip.indexOf(":NULL"));
				var compImage="";
				var tooltip = compTypeDisplayname+":"+comptip;
				if(comptype!=null && (comptype.match("_ex$")=="_ex" || comptype.indexOf("Agg_")==0 || comptype.indexOf("Group")==0))
				{
				
					var gcomptype = comptype;
					if(comptype.indexOf("Group")>-1)
						gcomptype="group";
					if(comptype.indexOf("Agg_")==0)
					{
						compImage = r.image('<%=serverImagePath%>AGGREGATES.png', xPos*zom, yPos*zom , gifWidth , gifHeight).attr({ "ToolTip" : tooltip, path : comptype});
					}
					else if(comptype.match("_ex$")=="_ex")
					{
						var icImageName="";
						for(x = 0;x<icCatagoryArray.length;x++)
						{
							if(icCatagoryArray[x].name == comptype)
							{
								icImageName = icCatagoryArray[x].value;
								break;
							}
						}
						compImage = r.image('<%=ICImagePath%>'+icImageName+'.png', xPos*zom, yPos*zom , gifWidth , gifHeight).attr({ "ToolTip" : tooltip, title : tooltip , path : comptype});
					}
					else
					{
						compImage = r.image('<%=groupImagePath%>'+gcomptype+'.png', xPos*zom, yPos*zom , gifWidth , gifHeight).attr({ "ToolTip" : tooltip, path : comptype});
					}
				}
				else
				{

					//compImage = r.image('<%=serverImagePath%>'+ comptype+'.png', xPos*zom, yPos*zom  , //gifWidth , gifHeight).attr({ "ToolTip" : tooltip, href : comptype});
					
					var comCateName="";
					for(x = 0;x<comCatagoryArray.length;x++)
					{
						if(comCatagoryArray[x].name == comptype)
						{
							comCateName = comCatagoryArray[x].value;
							break;
						}
					}

					compImage = r.image('<%=serverImagePath%>'+comCateName+'.png', xPos*zom, yPos*zom  , gifWidth , gifHeight).attr({ "ToolTip" : tooltip, path : comptype});
				}
				arr.push(compImage);
				compPosition.put(key, xPos*zom+"#"+yPos*zom);
				compAttrMap.put(key, comptype+"#"+tooltip);
				//Save the States
				componentStateMap.put(key,state);
			}
		}
		compIndexMap.put(key,compInd);
		compInd = compInd + 1;
	}

	if(resize == "true")
	{
		resizePaperDiv(iniMaxW, iniMaxH);
	}

	// Creating connections between components.......
	createConnections(topostring);
}

function createConnections(topostr)
{
	var tokens = topostr.split("|");
	for(var i = 0;i<tokens.length;i++)
	{
		var tokvalue = tokens[i];
		var lhs = tokvalue.substring(0,tokvalue.indexOf("="));
		var rhs = tokvalue.substring(tokvalue.indexOf("=")+1);

		var key = lhs;
		if(i==0)
		{
			if(lhs == 'Web_site:egurkha.physical.topology')
			{
				key = "egurkha.physical.topology";
				websitename = key;
			}
			else
			{
				//key = lhs.substring(lhs.indexOf(":"));
				key = "egurkha.physical.topology";
				websitename = lhs.substring(lhs.indexOf(":")+1);
			}
		}

		var lhsInd = compIndexMap.get(key);
		if(rhs != 'null')
		{
			var rhsArr = rhs.split(",");
			for(var j=0;j<rhsArr.length;j++)
			{
				var element = rhsArr[j];
				element = element.substring(0,element.lastIndexOf(":"));
				var LorN = element.substring(element.lastIndexOf(":")+1);
				element = element.substring(0,element.lastIndexOf(":"));
				var elementInd = compIndexMap.get(element);
				connectionArr.push(lhsInd+":"+LorN+">"+elementInd);
			}
		}
	}
}

function newDrawMethod()
{
	return this.arr;
}

var topostring ='<%=finalTopoStr%>';

window.onload = mainFunction;

function mainFunction () 
{
	getMapDetails(positionString);
	var key;
	var thisIndex;
	var statesrc;
/*
	var dragger = function () {
								//alert(this.attr("src")+"   "+this.attr("title"));
								var src = this.attr("src");
								var title = this.attr("title");
								if(title.indexOf(":") < 0)
								{
									title = title+":NULL";
								}
								src = src.substring(src.lastIndexOf("/")+1,src.indexOf(".gif"));
								if(src == 'imguser')
									key ="ROOT"
								else
									key = src+":"+title;
								thisIndex = compIndexMap.get(key);

								if(this.type == "image")
								{
									this.ox = this.attr("x");
									this.oy = this.attr("y");
								}
								if(thisIndex >0)
								{
									statesrc = stateCircle[thisIndex].attr('src');
									stateCircle[thisIndex].remove();
									compNames[thisIndex].remove();
								}
	},
	move = function (dx, dy) {
								if(this.type == "image")
								{
									var att =  {x: this.ox + dx, y: this.oy + dy};
									this.attr(att);
								}
								for (var i = connections.length; i--;) {
									r.connection(connections[i]);
								}
								r.safari();
	},
	up = function () {
						compPosition.put(key,this.attr("x")+"#"+this.attr("y"));
						if(key!="ROOT")
						{
							stateCircle[thisIndex] = r.image(statesrc,this.attr("x"),this.attr("y"),gifWidth*zom,gifHeight*zom);
							stateCircle[thisIndex].toBack();
							var textstr = this.attr("title");
							if(textstr.length > 15)
							{
								var mid = textstr.length / 2;
								textstr = textstr.substring(0,mid)+"\n"+textstr.substring(mid+1);
							}
							compNames[thisIndex] = r.text(this.attr("x")+20*zom ,this.attr("y") + 60*zom , textstr).attr({"font-size" : 10*zom});
						}
						beatFunction(shapes, compNames , thisIndex,connections);
	};
*/
	var connections = [],
	shapes = newDrawMethod(),
	stateCircle = drawStateCircles(),
	maintenance = drawMaintenanceIcon(),
	compNames = drawCompNames();

	for(var k=0;k<stateCircle.length;k++)
	{
		if(k==0)continue;
		
		var state = stateCircle[k].attrs.state;
	
		if(state!="GOOD" && state!="UNKNOWN")
			stateCircle[k].attr({cursor: "<%=cursorType%>"});

		stateCircle[k].click(function(event){
			
			var title = this.attrs.title;
			var compType = this.attrs.compType;
			
			if(!Ext.isEmpty(title) && title!="User"){
				var titleObj = title.split(":");
				if(titleObj.length<=2)
					title = title+":NULL";

				var restValues = title.substring(title.indexOf(":")+1);

				var original = compType+":"+restValues;

				showAlarmListOnHover(original,event);			
			}
		});
	}

	for (var i = 0, ii = shapes.length; i < ii; i++) 
	{
		if(i!=0)
			shapes[i].attr({cursor: "<%=cursorType%>"});
		//shapes[i].drag(move, dragger, up);
		beatFunction(shapes, compNames, i, connections);

		//             Link for the components.....
		if(i>0)
		{
			shapes[i].click(function (event) {
				var src = this.attr('src');
				var title = this.attr("ToolTip");
				var ct_org = this.attr("path");
				var key;
				var titleObj = title.split(":");
			
				if(titleObj.length<=2)
					title = title+":NULL";
				if(src!=null && src.indexOf(".gif")>-1)
				{
					src = src.substring(src.lastIndexOf("/")+1,src.indexOf(".gif"));
				}
				else if(src!=null && src.indexOf(".png")>-1)
				{
					src = src.substring(src.lastIndexOf("/")+1,src.indexOf(".png"));
				}

				if(src == 'imguser_72')
					key ="egurkha.physical.topology";
				else
				{					
					if(title!=null && title!=undefined && title.indexOf(":")>-1 && (title.split(":").length>2))
					{
						var restValues = title.substring(title.indexOf(":")+1);
						var original = "";
						if(ct_org!=null && ct_org!=undefined && ct_org!="")
							original = ct_org+":"+restValues;
						else
							original = src+":"+restValues;
						key = original;
						//key = title;
					}
					else
					{
						var restValues = title.substring(title.indexOf(":")+1);
						var original = "";
						if(ct_org!=null && ct_org!=undefined && ct_org!="")
							original = ct_org+":"+restValues;
						else
							original = src+":"+restValues;
						key = original;
						//key = src+":"+title;
					}				
				}

				if(fullView == 'false')
				{
					var urlString = getUrlForShape(key);
					if(window.parent.document.getElementById("segmentTopoIframeId")!=null && window.parent.document.getElementById("segmentTopoIframeId")!=undefined)
					{
						window.parent.document.getElementById("segmentTopoIframeId").style.display = "none";
					}
					window.parent.location = urlString;
				}
			});
		}
	}

	var circleArr1 = new Array();
	var circleArr2 = new Array();
	var pathArr = new Array();
	var startPathArr = new Array();
	for(var k=0;k<connectionArr.length;k++)
	{
		var link = connectionArr[k];
		var lorn = link.substring(link.indexOf(":")+1, link.indexOf(">"));
		var ind1 = link.substring(0,link.indexOf(":"));
		var ind2 = link.substring(link.indexOf(">")+1);
		//connections.push(r.connection('#<%=color%>',shapes[ind1], shapes[ind2], "#<%=color%>","#<%=color%>|1",lorn)); 

		var conObj = '';
		conObj = r.connection1('<%=animationLineColor%>',shapes[ind1], shapes[ind2], "<%=animationLineColor%>","<%=animationLineColor%>|1",lorn,false);
		connections.push(conObj); 	
		
		var pathStr = connections[k].path;
		var animated = connections[k].animatedPath;
		var mainPath = r.path(pathStr);		
		mainPath.attr({'stroke': '<%=animationLineColor%>', 'stroke-width':1.1 ,
						'stroke-dasharray': "- "}).animate({path : animated},1);
		mainPath.toBack();
		mainPathArr.push(mainPath);
		
		if('<%=animationValue%>'=='yes')
		{
			if(lorn=='L')
			{
				var mypath = r.path(connections[k].animatedPath);
				pathArr.push(mypath);
				mypath.hide();		
				var startPosition = connections[k].startPosition;
				startPathArr.push(startPosition);
				
				var coord = mypath.getPointAtLength(0);	
				var cox = parseInt(coord.x);
				var coy = parseInt(coord.y);
				var cir1 = r.circle(cox, coy, 3*zom,3*zom).attr({
						stroke: '<%=animationObjColor%>',
						fill: '<%=animationObjColor%>'
				});
				var Obj1 = cir1;		
				circleArr1.push(Obj1);		
				Obj1.hide();
				mainCircleArr.push(Obj1);
				
			}
		}
	}
	if('<%=animationValue%>'=='yes')
	{
		callAnimation(circleArr1,pathArr,startPathArr);	
	}
	hideLoadImage();
}

function callAnimation(circleArr,pathArr,startPathArr)
{	
	for(var c=0;c<circleArr.length;c++)
	{
		var circleObj = circleArr[c];
		var pathObj = pathArr[c];
		var startObj = startPathArr[c];		
		animatePath(pathObj,circleObj,c,startObj);		
	}
}

function animatePath(mypath,Obj,k,startPath)
{
	Obj.show();
	mypath.hide();	
	Obj.animateAlong(mypath, 3000, true, function () {			
		setTimeout(function(){
				
				mypath.hide();
				Obj.hide();
				Obj.animateAlong(startPath, 100, true, function () 
				{
					setTimeout(function(){animatePath(mypath,Obj,k,startPath)}, 5000);	
				});
		},500);	
	});	
}

function getUrlForShape(name)
{
	if(name!=null && name.length > 0)
	{
		var comptype = name.substring(0,name.indexOf(":"));
		var compname = name.substring(name.indexOf(":")+1);
		var site = '<%=site%>';
		var url;
		if(!(compname == websitename && comptype == "Web_site"))
		{
			if(comptype == "Group" || comptype=='group')
			{
				if(compname.indexOf(":NULL")>0)
				{
					compname = compname.substring(0,compname.indexOf(":"));
				}
				url = '<%=conPath%>'+'/monitor/EgDisplayGroups.jsp?ptype=group&showsitesegments=false&group='+encodeURI(compname)+"&serverType="+comptype+"&site="+websitename+"&segmentName="+'<%=segmentName%>'+"&fromHomepage="+'<%=fromHomepage%>';
			}
			else
			{
				var topologyType = '<%=topoType%>';

				if(topologyType == 'monitor')	// SERVICE_TOPOLOGY
				{
					/*var isAggregate = (comptype != null && comptype.indexOf("Agg_") == 0);
					if(isAggregate)
						url = '<%=conPath%>'+'/monitor/aggDashboard.jsp?site=';
					else*/
						url = '<%=conPath%>'+'/monitor/EgDispLayers.jsp?site=';
					url = url+encodeURI(websitename)+'&qctr=0&host='+encodeURI(compname) +'&comptype='+comptype +'&comeFrom=topology&To=layerModel&treeFlag=<%=treeFlag%>';
				}
				else if(topologyType == 'segment')	// SEGMENT_TOPOLOGY
				{
					/*var isAggregate = (comptype != null && comptype.indexOf("Agg_") == 0);
					if(isAggregate)
						url = '<%=conPath%>'+'/monitor/aggDashboard.jsp?site=';
					else*/
						url = '<%=conPath%>'+'/monitor/EgDispLayers.jsp?site=';
					url = url+websitename +'&qctr=0&host='+encodeURI(compname) +'&comptype='+comptype +'&comeFrom=topology&To=layerModel'+'&isFromZone=<%=isFromZone%>'+'&iszoneName=<%=iszoneName%>'+'&parentZone=<%=parentZone%>&segmentOrgName=<%=segmentName%>';
				}
				else	// VIRTUAL TOPOLOGY
				{
					url = '<%=conPath%>'+'/servlet/com.eg.EgDashboardController?from=list&site='+encodeURI(site)+'&qctr=0&host='+encodeURI(compname)+'&comptype='+comptype+'&comeFrom=topology';
				}
			}

			if(comptype!=null && (comptype != "Group" && comptype!='group'))
			{
				url = url+"&tab=LayerModel&toDashBoardLayer=true";
			}

			if(<%=isfromSuper%>)
			{
				var qry = url.substring(url.indexOf("?")+1);
				var urlStr = url.substring(0,url.indexOf("?"));
				url = urlStr+";jsessionid="+'<%=sessionID%>'+"?"+qry;
			}
		}
	}
	return url;
}

function beatFunction(shapesObj,compNamesObj, index, connectionObj)
{
	shapesObj[index].mouseover (function (event) {
		//shapesObj[index].attr({cursor: "pointer"});
		var title = this.attr("ToolTip");
		var src = this.attr("src");
		var ct_org = this.attr('path');
		for(var k=0;k<connectionArr.length;k++)
		{
			var link = connectionArr[k];
			var lorn = link.substring(link.indexOf(":")+1, link.indexOf(">"));
			var ind1 = link.substring(0,link.indexOf(":"));
			var ind2 = link.substring(link.indexOf(">")+1);

			if(ind1 == index || ind2 == index)
			{
				if(connectionObj[k]!=null)
				{
					connectionObj[k].line.show();
					connectionObj[k].line.toBack();
					//connectionObj[k].tri.toFront();
					connectionObj[k].line.animate({'stroke' : '<%=animationLineColor%>', 'stroke-width' : 2*zom},500);
					//connectionObj[k].tri.animate({'stroke' : '#<%=dark%>','fill' : '#<%=dark%>', 'stroke-width' : 2*zom},500);
				}
			}
		}
		/*if(!Ext.isEmpty(title) && title!="User"){
			var titleObj = title.split(":");
			if(titleObj.length<=2)
				title = title+":NULL";
			if(src!=null && src.indexOf(".gif")>-1)
			{
				src = src.substring(src.lastIndexOf("/")+1,src.indexOf(".gif"));
			}
			else if(src!=null && src.indexOf(".png")>-1)
			{
				src = src.substring(src.lastIndexOf("/")+1,src.indexOf(".png"));
			}
			var restValues = title.substring(title.indexOf(":")+1);
			var original = "";
			if(ct_org!=null && ct_org!=undefined && ct_org!="")
				original = ct_org+":"+restValues;
			else
				original = src+":"+restValues;
			showAlarmListOnHover(original,event);			
		}*/
	});

	shapesObj[index].mouseout (function (event){
		for(var k=0;k<connectionArr.length;k++)
		{
			var link = connectionArr[k];
			var lorn = link.substring(link.indexOf(":")+1, link.indexOf(">"));
			var ind1 = link.substring(0,link.indexOf(":"));
			var ind2 = link.substring(link.indexOf(">")+1);

			if(ind1 == index || ind2 == index)
			{
				if(connectionObj[k]!=null)
				{
					connectionObj[k].line.hide();
					//connectionObj[k].line.toBack();
					//connectionObj[k].tri.toBack();
					connectionObj[k].line.animate({'stroke' : '<%=animationLineColor%>', 'stroke-width' : 1*zom},500);
					//connectionObj[k].tri.animate({'stroke' : '#<%=color%>','fill' : '#<%=color%>', 'stroke-width' : 1*zom},500);
				}
			}
		}
		//closeDiv();
	});
}

function showAlarmListOnHover(title,e){

	var url_value = "/final/monitor/alarmsList.jsp?compName="+encodeURI(title)+'&site=encodeURI(<%=segmentName%>)';

	Ext.Ajax.request({
		url:url_value,
		success:function(respons)
		{
		
			var response = respons.responseText;
			
			var jsonData = Ext.decode(response);
			var gridData = jsonData.tableData;
			var divId = document.getElementById("alarmsListDiv");
			if(gridData!="NO_DATA"){							
				divId.innerHTML = gridData;
				divId.style.visibility='visible';
				divId.style.display='block';
				divId.style.position="fixed";
				var scrWidth=screen.width/4;
				var scrHeight=screen.height/4;
				divId.style.left=(scrWidth) + "px";
				divId.style.top=(scrHeight) + "px";
			}else{				
				divId.style.visibility='hidden';
				divId.style.display='none';
			}
		}
	});
}

function drawCompNames ()
{
	return allCompNames;
}


function drawMaintenanceIcon()
{
	return maintenanceArr;
}

function drawStateCircles()
{
	var cirArr = new Array();
	var keys = compPosition.listKeys();
	for(var k=0;k<keys.length;k++)
	{
		if(k==0)
		{
			cirArr.push("egurkha.physical.topology");
			allCompNames.push("egurkha.physical.topology");
			maintenanceArr.push("egurkha.physical.topology");
			continue;
		}
		var key = keys[k];
		var val = compPosition.get(key);
		var xpoint = parseInt(val.substring(0,val.indexOf("#")));
		var ypoint = parseInt(val.substring(val.indexOf("#")+1));
		var stateString = componentStateMap.get(key);

		var comTypTip = compAttrMap.get(key);
		var comTyp = comTypTip.substring(0,comTypTip.indexOf("#"));
		var tip = comTypTip.substring(comTypTip.indexOf("#")+1);

		// To Draw maintenance image .. (Begin)
		var isMaintenance = new Boolean(false);
		var maintenanceImg = stateString;
		if(stateString == 'maintenance')
		{
			stateString = "good";
			//maintenanceImg = r.image('<%=contextPath%>'+'maintenance_trans.gif',xpoint+10,ypoint-4,18*zom,16*zom);
			maintenanceImg = r.image('<%=contextSkinPath%>'+'iconMaintenanceTopology.png',xpoint+40*zom,ypoint-4*zom,18*zom,16*zom);
		}
		maintenanceArr.push(maintenanceImg);
		// To Draw maintenance image .. (End)

		//var scir = r.image('<%//=contextPath%>'+'server_'+stateString+'.png',xpoint,ypoint,gifWidth,gifHeight);
		var scir = r.image('<%=contextSkinPath%>'+'state20_'+stateString.toUpperCase()+'.png',xpoint+28*zom,ypoint+28*zom,sPngWidth,sPngHeight);
		//scir.toBack(); --need to command, then only state icon display front.
		scir.attrs.compType=comTyp;
		scir.attrs.title=tip;
		scir.attrs.state=stateString.toUpperCase();

		cirArr.push(scir);
		//added img name
	
		var textMsg;
		var msg=key.substring(0,key.indexOf(":"));
		if(msg.indexOf('Agg_') == 0) {
			msg=msg.substring(4);
			var textMsg=egtop_iniMap.get(msg);
			textMsg=textMsg+" "+"Aggregate";
		}
		else
		{
			 textMsg=egtop_iniMap.get(msg);
		}
		var compTypeDisplayname=textMsg;
		var compTextName=textMsg;
		var typeFlag=false;
		if(textMsg.length > 22)
		{
			
			//  new code added for word wrap text issue - start here - Jaiwin


			if(textMsg.indexOf(' '))
			{
				var ary = textMsg.split(' ');
				if(ary.length>2)
				{
					var tempStr =  ary[0]+ary[1]+ary[2];
					if(tempStr.length>20)
					{
						compTextName = ary[0]+' '+ary[1]+'\n';
						for(var i=2;i<ary.length;i++)
						{
							compTextName+=ary[i]+' ';
						}
					}
					else
					{
						compTextName = ary[0]+' '+ary[1]+' '+ary[2];
						if(ary.length>3)
						{
							compTextName+='\n';
							for(var i=3;i<ary.length;i++)
							{
								compTextName+=ary[i]+' ';
							}
						}
					}
				}
				else
				{
					compTextName = ary[0]+'\n'+ary[1];
				}
			}
			//  new code added for word wrap text issue - end here - Jaiwin
			else
			{
				var remval = textMsg.length % 2;
				var midval;
				if(remval == 0)
					midval = textMsg.length / 2;
				else
					midval = (textMsg.length + 1) / 2;
					
				compTextName = textMsg.substring(0,midval)+"\n"+textMsg.substring(midval);
			}
			typeFlag=true;
		}
		
		
		//end
		var compName = key.substring(key.indexOf(":")+1);
		if(compName.indexOf(":NULL") > 0)
			compName = compName.substring(0,compName.indexOf(":NULL"));
		var textstr = compName;
		var compFlag=false;
		if(compName.length > 22)
		{
			var rem = compName.length % 2;
			var mid;
			if(rem == 0)
				mid = compName.length / 2;
			else
				mid = (compName.length + 1) / 2;

			textstr = compName.substring(0,mid)+"\n"+compName.substring(mid);
			compFlag=true;
		}
		//adding component name
		var tooltip = compTypeDisplayname+":"+compName;
		/*if((textMsg.length > 19) || (compName.length > 19))
		{
			alltpNames.push(r.text(xpoint+25*zom,ypoint+56*zom,compTextName).attr({"font-size" : 10*zom,"fill": "<%=compNameColor%>","font-family":"<%=fontFamilyBold%>",title:tooltip}));
		}
		else
		{
			alltpNames.push(r.text(xpoint+25*zom,ypoint+50*zom,compTextName).attr({"font-size" : 10*zom,"fill": "<%=compNameColor%>","font-family":"<%=fontFamilyBold%>",title:tooltip}));
		}
		if((compName.length > 19) || (textMsg.length > 19))
		{
			allCompNames.push(r.text(xpoint+25*zom,ypoint+82*zom,textstr).attr({"font-size" : 10*zom , "fill": "<%=compNameColor%>", "font-family":"<%=fontFamily%>",title:tooltip}));
		}
		else
		{
			allCompNames.push(r.text(xpoint+25*zom,ypoint+63*zom,textstr).attr({"font-size" : 10*zom , "fill": "<%=compNameColor%>", "font-family":"<%=fontFamily%>",title:tooltip}));
		}*/
		//end

		if(!typeFlag && !compFlag ) //1 1
		{
			alltpNames.push(r.text(xpoint+23*zom,ypoint+55*zom,compTextName).attr({"font-size" : 10*zom,"fill": "<%=compNameColor%>","font-family":"<%=fontFamilyBold%>",title:tooltip}));

			allCompNames.push(r.text(xpoint+23*zom,ypoint+67*zom,textstr).attr({"font-size" : 10*zom , "fill": "<%=compNameColor%>", "font-family":"<%=fontFamily%>",title:tooltip}));
		}
		else if(!typeFlag && compFlag) // 1 2
		{
			alltpNames.push(r.text(xpoint+23*zom,ypoint+55*zom,compTextName).attr({"font-size" : 10*zom,"fill": "<%=compNameColor%>","font-family":"<%=fontFamilyBold%>",title:tooltip}));

			allCompNames.push(r.text(xpoint+23*zom,ypoint+75*zom,textstr).attr({"font-size" : 10*zom , "fill": "<%=compNameColor%>", "font-family":"<%=fontFamily%>",title:tooltip}));
		}
		else if(typeFlag && !compFlag) // 2 1
		{
			alltpNames.push(r.text(xpoint+23*zom,ypoint+60*zom,compTextName).attr({"font-size" : 10*zom,"fill": "<%=compNameColor%>","font-family":"<%=fontFamilyBold%>",title:tooltip}));

			allCompNames.push(r.text(xpoint+23*zom,ypoint+80*zom,textstr).attr({"font-size" : 10*zom , "fill": "<%=compNameColor%>", "font-family":"<%=fontFamily%>",title:tooltip}));
		}
		else if(typeFlag && compFlag) // 2 2
		{
			alltpNames.push(r.text(xpoint+23*zom,ypoint+60*zom,compTextName).attr({"font-size" : 10*zom,"fill": "<%=compNameColor%>","font-family":"<%=fontFamilyBold%>",title:tooltip}));

			allCompNames.push(r.text(xpoint+23*zom,ypoint+85*zom,textstr).attr({"font-size" : 10*zom , "fill": "<%=compNameColor%>", "font-family":"<%=fontFamily%>",title:tooltip}));
		}
	}
	return cirArr;
}
</script>
<input type="hidden" name="zoom" id="zoom" value='<%=zoomLevel%>'>
</form>
</body>
</html>

<%!
	private String getTopologyString(String segmentName, String site , String phyTopology , String vmHost , HttpServletRequest httpRequest)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_topology.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		EgCrawler strBean = new EgCrawler(iniFile);

		String str = null;

		if (phyTopology.equals("1"))
		{
			str = strBean.getPhysicalTopology(segmentName);
		}
		//This check is to topology graph view for Vmware guests components
		else if (phyTopology.equals("2"))
		{
			if(vmHost!=null || (!vmHost.equals("null")))
			{
				VMDesktopBean vmdbean = new VMDesktopBean(httpRequest);
				str = vmdbean.getVmhostString(vmHost,site);
			}
		}
		else
		{
			if (segmentName!=null && segmentName.equals("Independent_servers"))
			{
				str = strBean.getSiteString(site, site + "_INDEPENDENT");
			}
			else
			{
				str = strBean.getSiteString(site, segmentName);
			}
		}

		AlarmPriorities ap = AlarmPriorities.getInstance();
		String newString = null;
		if (StringUtils.isNull(str))
		{
			newString = EgConstants.BLANK_SPACE;
		}
		else
		{
			newString = ap.getTopologyPriority(str, site);
		}
		newString = sortTopoString(newString);
		return newString;
	}

	/*
	To sort the topology string so that the new topology applet will understand
	*/
	public String sortTopoString(String topoStr) 
	{
		if(topoStr==null)
			return null;
		Hashtable h = new Hashtable();

		String [] topoToks = StringUtils.getTokens(topoStr, "|");

		ArrayList finalLhs = new ArrayList();
		ArrayList finalRhs = new ArrayList();
		ArrayList leftOver = new ArrayList();
		boolean changesOccured = false;
		while (!changesOccured)	 //loop until sorted properly changesOccured becomes true
		{
			changesOccured = true;	
			for (int i=0;i<topoToks.length ;i++ )
			{
				String [] relation = StringUtils.getTokens(topoToks[i], "=");
				String thisLhs ="";
				String thisRhs ="";
				if(relation!=null && relation.length==2)
				{
				 thisLhs = relation[0];
				 thisRhs = relation[1];	//Network_node:Core_Switch_1:NULL:N:GOOD,Network_node:Core_Switch_2:NULL:N:GOOD
				}
				else if(relation!=null && relation.length==1)
				{
					thisLhs = relation[0];
				}
				
				if (i==0)
				{
					//add first component
					if (finalLhs.indexOf(thisLhs)==-1)	 //if lhs is already added, skip
					{
						finalLhs.add(thisLhs);
						finalRhs.add(getRhsList(thisRhs, thisLhs, h));
					}
				}else
				{
					Object rhsObj = h.get(thisLhs);
					/*
						if rhsObj is null, it means that we get a wrong entry, i.e. the component comes in improper order. 
						a component which havnt come in rhs, has been given as lhs. so dont add it right now. wait until the 
						necessary rhs is getting added.
					*/
					if (rhsObj!=null && finalLhs.indexOf(thisLhs)==-1)
					{
						finalLhs.add(thisLhs);
						finalRhs.add(getRhsList(thisRhs, thisLhs, h));
					}else
					{
						if (rhsObj==null)				//if rhsObj is null, it means that some component is not yet added
							changesOccured = false;
					}
				}
			}
		}

		StringBuffer sb = new StringBuffer();
		for (int i=0;i<finalLhs.size() ;i++ )
		{
			String thisStr = (String)finalLhs.get(i);
			ArrayList rhsList = (ArrayList) finalRhs.get(i);
			Iterator myIter = rhsList.iterator();
			StringBuffer sb2 = new StringBuffer();
			while (myIter.hasNext())
			{
				TopoRhsComp thisRhsComp = (TopoRhsComp) myIter.next();
				sb2.append(thisRhsComp.getComponent());
				if (myIter.hasNext())
					sb2.append(",");
			}
			sb.append(finalLhs.get(i));
			sb.append("=");
			sb.append(sb2.toString());
			sb.append("|");
		}
		String result = sb.toString();
		if (result.endsWith("|"))
		{
			result = result.substring(0, result.lastIndexOf("|"));
		}
		return result;
	}

	public ArrayList getRhsList(String thisRhs, String thisLhs, Hashtable h)
	{
		ArrayList result = new ArrayList();
		if(thisRhs!=null && !thisRhs.equals(""))
		{
		String [] toks = StringUtils.getTokens(thisRhs, ",");
		for (int i=0;i<toks.length ;i++ )
		{
			String thisStr = toks[i];
			TopoRhsComp rhsCmp = new TopoRhsComp(thisStr);
			result.add(rhsCmp);
			
			if (!rhsCmp.toString().equals("null"))
			{
				h.put(rhsCmp.toString(), thisLhs);
				}
			}
		}
		return result;
	}
%>