<%

/**

 *	Displays the current status of the servers being monitored

 *

 *	@author		Arun Jayaprakash

 *	@version	3.0

 *

 *	@modified

 *		17/10/2003	Arun	Set default % for good measures to zero

 *		28/10/2003	Arun	Uses IniUI for headings

 *		03/10/2003	Arun	Fixed bug where badMeasures would take the count of the last BAD state measure

 *							available in the database instead of all BAD state (H/I/L) measures

 *		04/10/2003	Arun	<meta> tag uses eg_ui.ini for refresh time

 *		05/11/2003	Arun	Fixed negative percentages for GOOD and 100+ percentages for UNKNOWN measures

 *							Known issue : Disabled tests might increase the count of measures while 

 *							querying MetaTest table initially

 *		13/05/2004	Arun	Clubbing of multiple components into a single alarm will not show up in 

 *							Unresolved problems

 */

%>

<%@ include file="EgLoginTracker.jsp" %>

 <%@ page errorPage="EgErrorSmall.jsp" %>

<%@ page import="com.eg.EgConfigInfo" %>

<%@ page import="com.eg.EgDateInfo" %>

<%@ page import="com.eg.EgDbAdapterTypeUI" %>

<%@ page import="egurkha.*" %>

<%@ page import="com.egurkha.*" %>

<%@ page import="com.egurkha.ini.*" %>

<%@ page import="com.egurkha.util.*" %>

<%@ page import="java.sql.*" %>

<%@ page import="java.util.*" %>

<%@ page import="java.io.*" %>

<%@ page import="com.eg.EgInstallInfo" %>



<%

	response.setHeader("Cache-Control","no-store");

	response.setHeader("Pragma","no-cache");

	response.setDateHeader ("Expires", -1);



	IniUI ui = (IniUI)IniUI.getInstance();

	String refreshTime = ui.getRefreshTime("EgDashboard");


	UserRegistry registry = UserRegistry.getInstance();

	User user = registry.getUser(session.getId());
	EgUserRole userRole = user.getUserRole();
	boolean allComp = userRole.hasAllComponentAccess();
	ArrayList al_components=null;

	int badMeasures = 0;

	int unknownMeasures = 0;

	int measureCount = 0;

	int alarmCount = 0;



	double gMeasurePct = 0.0d; //Set by default to 0, so that zero measures will show 0% health

	double bMeasurePct = 0.0d;

	double uMeasurePct = 0.0d;



	List alarms = null;

	String servers = null;

	String sites = null;

	//String tests = null;

	DateTimeTokenizer dtt = new DateTimeTokenizer();

	java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	EgDateInfo egDate = new EgDateInfo();

	java.util.Date now = new java.util.Date(egDate.egetDateUS());

	long totalDuration;

	long maxDuration;

	List userServers = user.getServers(false);

	if (userServers!=null & userServers.size() > 0)

	{

		measureCount = user.getMeasuresCount();

		Map testNames = user.getTests();



		List serversWithHost = Server.getServersWithHostSystem(userServers, true, false);

		List list = new LinkedList();

		list.addAll(user.getSites());

		list.addAll(user.getServices());

		list.add("NULL");

		EgDbAdapterUI egDb=EgDbAdapterTypeUI.getObject();
		egDb.setConnection();
		ResultSet rs = null;
		try
		{
			rs = egDb.getAllAlarms(user.getServerTypes());

			alarms = egDb.getResultSetAsList(rs);

			rs.close();

			egDb.releaseConnection(false);

		}

		catch(SQLException se)

		{
			se.printStackTrace();

			if (rs != null)

			{

				rs.close();

			}



			egDb.releaseConnection(true);

			if (alarms == null)

			{

				alarms = new LinkedList();

			}

		}

		EgDbAdapterTypeUI.releaseObject(egDb);



		if (!allComp) // !user.isSuperMonitor())

		{
			/*

			 * Filter out components that this user does not monitor

			 */

			List remove = new LinkedList();

			//List serversWithoutType = Server.getServersWithHostSystem(userServers, true, true);

			List serversWithType = Server.getServersWithHostSystem(userServers, true, false);

			for (Iterator i=alarms.iterator(); i.hasNext(); )

			{

				String[] row = (String[])i.next();

				String[] compNames = StringUtils.getTokens(row[0], "/");

				String compType = row[1];

				boolean found = false;

				for (int a=0; a<compNames.length; a++)

				{

					//if (serversWithoutType.indexOf(compNames[a]) > -1)

					if (serversWithType.indexOf(compType+":"+compNames[a]) > -1)

					{

						found = true;

						break;

					}

				}



				if (!found)

				{

					remove.add(row);

				}

			}



			if (remove.size() > 0)

			{

				alarms.removeAll(remove);

			}

	
			// new change to check if test is something we care about

			alarmCount = 0;

			for (int x=0; x<alarms.size(); x++)

			{

				String[] s = (String[]) alarms.get(x);

				if (s == null || s.length < 4)

					continue;

				String desc = s[3];

				StringTokenizer st = new StringTokenizer (desc,EgConstants.COMMA);

				int c = st.countTokens();

				boolean found = false;

				for (int r=0; r<c; r++)

				{

					String ndesc = st.nextToken();

					StringTokenizer st2 = new StringTokenizer (ndesc,"|");

					if (st2.countTokens() < 3)

						continue;

					st2.nextToken(); // ignore site

					st2.nextToken(); // ignore info

					String t = st2.nextToken();

					if (testNames != null && testNames.containsKey(t))

					{

						found = true;

						break;

					}

				}

				if (found) 

					alarmCount ++;

			}

		}

		else

			alarmCount = alarms.size();
	/*
		if (measureCount > 0)

		{

			double factor = 100.0d/measureCount;

			gMeasurePct = MathUtils.round((measureCount - unknownMeasures - badMeasures) * factor, 2);

			uMeasurePct = MathUtils.round(unknownMeasures * factor, 2);

			bMeasurePct = MathUtils.round(badMeasures * factor, 2);

		}
		*/
	}else

	{

		EgUserRole myrole = user.getUserRole();

		%>

		<jsp:forward page="EgEmpty.jsp" >

			<jsp:param name="reason" value="<%=((myrole.hasAllComponentAccess())?"No components have been enabled for monitoring":"No components have been associated for this user. <BR>Please contact your administrator.")%>"/>

		</jsp:forward>

<%

	}

%>



<%!
int badCount = 0;
int unknownCount =0;
	private int[] getStateCounts(ResultSet rs, ArrayList servers, ArrayList sites)
	{
		//Hashtable ht = new Hashtable();
		int [] count = new int[2];
		boolean found = false;
		try
		{
			if(rs != null)
			{
				while(rs.next())
				{
					// site cname ctype state
					String site = rs.getString(1);
					String ctype = rs.getString(2);
					String cname = rs.getString(3);
					String state = rs.getString(4);
					String s = "'"+ctype+':'+cname+"'";

					if (servers.size()>0 && !servers.contains(s))
						continue;
					if (sites.size()>0 && !sites.contains("'"+site+"'"))
						continue;
					found = true;					

					if (EgConfigInfo.isBad(state))
						badCount ++;	
					else
						unknownCount ++;
				}

			}

			if(!found) // ht == null || ht.size() == 0)
			{
				count[0] = 0;
				count[1] = 0;
				return count;
			}
			count[0] = badCount;
			count[1] = unknownCount;
			return count;
		}
		catch(Exception e)
		{
			return null;
		}
	}
%>
<html>
<head>
<title>&nbsp;MEASUREMENTS<%//=ui.getDashboardHeading(IniUI.CURRENT_STATUS)%></title>
<link rel="stylesheet" href="eg_styles/eg_monitorstyle.css" />
<style>
	#table_border{border-width:1 1px 1px 1;border-color:#999999; border-style:solid};
	#table_right_border{border-width:0 1px 0px 0;border-color:#999999; border-style:solid}
	#table_right_grey_border{border-width:0 1px 0px 0;border-color:#999999; border-style:solid}
</style>
</head>
<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0" bgcolor="#F6F6F6">
<%
	Vector v_user_comp = new Vector();
	v_user_comp.addAll(user.getServers(false));
	TreeMap problemMap = new TreeMap();
	TreeMap timeMap = new TreeMap();
	TreeMap maxTimeMap = new TreeMap();
	TreeSet sortedSet = new TreeSet();
	Statement st=null;
	ResultSet rs=null;

	//EgDbAdapterUI egDb=EgDbAdapterTypeUI.getObject();

	dtt.setDateFormat(DateTimeTokenizer._YMD);
	dtt.setDateSeparator(DateTimeTokenizer.HYPHEN_SEPARATOR);
	dtt.setTimeFormat(DateTimeTokenizer.HMS);
	sdf.setTimeZone(egDate.getRealTimeZone());
	dtt.setEndDateTime(sdf.format(now));
	totalDuration = 0l;
	maxDuration = dtt.getDateDifference();
	problemMap.clear();
	for (Iterator i=alarms.iterator(); i.hasNext(); )
	{
		String[] row = (String[])i.next();
		//out.println("<br><br>"+Arrays.asList(row));
		dtt.setStartDateTime(row[5]);

		long difference = dtt.getDateDifference();
		if (difference<0 && difference!=-1)
			difference = Math.abs(difference);

		maxDuration = Math.max(maxDuration, difference);
		if (maxDuration <0 && maxDuration !=-1)
			maxDuration  = Math.abs(maxDuration );

		totalDuration += difference;

		String thisLayer = row[2];
		Integer count = (Integer)problemMap.get(thisLayer);
		if (count == null)
		{
			problemMap.put(thisLayer, new Integer(1));
			sortedSet.add("01#"+thisLayer);
		}else
		{
			int myVal = count.intValue();
			sortedSet.remove(myVal+"#"+thisLayer);
			sortedSet.remove("0"+myVal+"#"+thisLayer);
			myVal++;
			problemMap.put(thisLayer, new Integer(myVal));
			sortedSet.add(((myVal<10)?"0":"")+myVal+"#"+thisLayer);
		}
		Long layerTimeCount = (Long)timeMap.get(thisLayer);
		if (layerTimeCount == null)
		{
			timeMap.put(thisLayer, new Long(difference));
		}else
		{
			long myVal = layerTimeCount.longValue();
			myVal+=difference;
			timeMap.put(thisLayer, new Long(myVal));
		}

		//maxTimeMap
		Long maxDiff = (Long)maxTimeMap.get(thisLayer);
		if (maxDiff == null)
		{
			maxTimeMap.put(thisLayer, new Long(difference));
		}else
		{
			long myVal = maxDiff.longValue();
			myVal = Math.max(myVal, difference);
			maxTimeMap.put(thisLayer, new Long(myVal));
		}
	}



	Iterator keyiter = sortedSet.iterator();

	boolean lColor = true;

	int maxVal = 5;

	int c=0;

	if (sortedSet.size()>0)

	{

	%>

<table width="100%" border="0	" cellpadding="0" cellspacing="0">

	<tr height="25" >

		<td width="250" id="table_header">&nbsp;Layer

		</td>

		<td width="100" align="center" id="table_header"   >&nbsp;<%=ui.getDashboardHeading(IniUI.OPEN_ALARMS)%>

		</td>

		<td width="100" align="center" id="table_header">&nbsp;<%=ui.getDashboardHeading(IniUI.AVERAGE_DURATION)%>

		</td>

		<td width="100" align="center"id="table_header" >&nbsp;<%=ui.getDashboardHeading(IniUI.MAXIMUM_DURATION)%>

		</td>

	</tr>

	<tr height="25">

		<td width="250" class="cell_border" style="padding:2px"><span  style="width:100%;height:100%;border-width:1 1px 1px 1;border-style:solid;border-color:#818181;background-color:#CCCCCC;padding-top:3px">&nbsp;SUMMARY</span>

		</td>

		<td width="100" align="right" class="cell_border" style="padding:2px" ><span  style="width:100%;height:100%;border-width:1 1px 1px 1;border-style:solid;border-color:#818181;background-color:#CCCCCC;padding-top:3px">&nbsp;<%=alarmCount%>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>

		</td>

		<td width="100" align="left" class="cell_border" style="padding:2px" ><span  style="width:100%;height:100%;border-width:1 1px 1px 1;border-style:solid;border-color:#818181;background-color:#CCCCCC;padding-top:3px">&nbsp;&nbsp;&nbsp;<%=DateTimeTokenizer.getTimeDifference(totalDuration/alarmCount)%></span>

		</td>

		<td width="100" align="left" class="cell_border" style="padding:2px" ><span  style="width:100%;height:100%;border-width:1 1px 1px 1;border-style:solid;border-color:#818181;background-color:#CCCCCC;padding-top:3px">&nbsp;&nbsp;&nbsp;<%=DateTimeTokenizer.getTimeDifference(maxDuration)%></span>

		</td>

	</tr>

<%

		//while(sortedSet.size()>0)

		boolean overflow = maxVal<=sortedSet.size();

		for (int i=0; i<maxVal; i++)

		{

			if (sortedSet.size()==0)

			{

				//add empty space to keep summary at the bottom

%>

					<tr><td align="right" height="25">&nbsp;</td></tr>

					<%=(i==(maxVal-1))?"<td></td><td></td><td></td><td>&nbsp;</td>":""%>

<%

			}else

			{

			lColor=!lColor;

			String thisKey = (String)sortedSet.last();

			sortedSet.remove(thisKey);

			thisKey = thisKey.substring(thisKey.indexOf("#")+1);

			Integer thisVal = (Integer)problemMap.get(thisKey);

			if (thisVal==null)

				continue;

			int myCount = thisVal.intValue();

			Long timeVal = (Long)timeMap.get(thisKey);

			Long maxTimeVal = (Long)maxTimeMap.get(thisKey);

%>

<tr <%//=lColor?"bgcolor=\"#FFEE99\"":"bgcolor=\"#FFFFEE\""%> height="21">

	<td class="cell_border" bgcolor="#E7E7E7">&nbsp;<%=thisKey%>

	</td>

	<td class="cell_border" id="table_border2"  align="right"> &nbsp;<%=myCount%>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

	</td>

	<td class="cell_border" bgcolor="#E7E7E7" align="left"> &nbsp;&nbsp;&nbsp;<%=DateTimeTokenizer.getTimeDifference(timeVal.longValue()/myCount)%>

	</td>

	<td class="cell_border" id="table_border2"  align="left"> &nbsp;&nbsp;&nbsp;<%=DateTimeTokenizer.getTimeDifference(maxTimeVal.longValue())%>

	</td>

</tr>

<%

			}

		}

			if (overflow)

			{

%>

					<div class="mouse" ><td align="right" colspan="4">&nbsp;<a href ="EgSiteInfraView.jsp?disphist=yes" target="_parent" style="text-decoration=none;" class="eg_navlink_text">Click here for more events >></a>&nbsp;</td></div>

<%

			}

%>





</table>

<%

	}

	else

	{

			%>

			<jsp:forward page="EgEmpty.jsp?reason=No events available"/>

			<%

	}

%>

</body>

</html>
