<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page errorPage="EgProbsM.jsp" %>
<%@ include file="EgLoginTracker.jsp" %>
<%@ taglib uri="../WEB-INF/eg-taglib.tld" prefix="egui" %>

<%@ page import="com.egurkha.monitor.EgServerDashboardModel" %>
<%@ page import="com.egurkha.monitor.EgServerDashBoardDAO" %>
<%@ page import="com.egurkha.monitor.MonitorDAOFactory" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.eg.IniFile" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import="com.eg.EgDbInfo" %>
<%@ page import="com.eg.EgTablesInfo" %>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="egurkha.reporter.ErUtils"%>
<%@ page import="com.egurkha.monitor.EgFusionChartUtil" %>
<%@ page import="java.text.SimpleDateFormat" %>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import="com.egurkha.util.MathUtils"%>
<%@ page import="com.eg.EgTablesInfo"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-Cache");
	response.setDateHeader("Expires",-1);
%>

<%
try
{
	String compType=request.getParameter("compType");
	String compName=request.getParameter("hostName");
	String tab=request.getParameter("tab");
	EgUserRole userRole = u_ser.getUserRole();
	long perm = EgUserPermission.ADMIN;
	boolean adminPermission = userRole.hasAdminRole(perm);
	String hostName="";
	String portNo="";
	String sid="";
	String site="";
	if(compName!=null && !compName.equals(""))
	{
		StringTokenizer st=new StringTokenizer(compName,":");
		if(st.hasMoreTokens())
			hostName=st.nextToken();

		if(st.hasMoreTokens())
		{
			portNo=st.nextToken();
		}

		if(st.hasMoreTokens())
			sid=st.nextToken();
	}
	String s_iniFile_dir=EgInstallInfo.getInstallDir()+"/manager/config/";
	IniFile iniobj=new IniFile(s_iniFile_dir+"eg_serverdashboard.ini");
	
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgServerDashboardModel model=new EgServerDashboardModel();
	MonitorDAOFactory monitorfactory=MonitorDAOFactory.getInstance();
	EgServerDashBoardDAO dashboardDAO=monitorfactory.getServerDashBoardDAO();
	ErUtils  erutils=new  ErUtils();

	EgDbInfo dbInfo=new EgDbInfo("manager");
	EgTablesInfo tablesInfo=new EgTablesInfo("manager");
	EgFusionChartUtil fusionChart=new EgFusionChartUtil(trackerLanguage);
	EgMappingInfo mappingInfo=new EgMappingInfo(trackerLanguage);
	
	Hashtable allMsmtHosts=dashboardDAO.getMsmtHostForAllTest(compName,compType,tab);
	Hashtable allTestInfos=dashboardDAO.getDescriptorsForAllTest(compName,compType,tab);
	ArrayList enabledTests=specsInfo.getEnabledTests(compType,false);
	Vector runingTestList=model.getRunningTest(compName,compType,tab);

%>

<%
	String screenWidth=request.getParameter("screenWidth");
	String screenHeight=request.getParameter("screenHeight");

	double screenWidthInDouble=1024.0;
	double screenHeightInDouble=768.0;
	if(screenWidth!=null && !screenWidth.equals(""))
	{
		screenWidthInDouble=Double.parseDouble(screenWidth);
	}
	if(screenHeight!=null && !screenHeight.equals(""))
	{
		screenHeightInDouble=Double.parseDouble(screenHeight);
	}

		String test="DeviceUptimeTest";
		boolean isRuningTest=false;

	String overviewDialGraphs=iniobj.getValue(compType,"Network_Overview_DialGraphs");
	String iniEntries = iniobj.getValue(compType,"Network_NetworkInterfaces_DialGraphs");
//-------------------------------for jvm chart------------------------------------------------------------------
	Vector dialGraphtests=model.getTokensAsVector(overviewDialGraphs,",");
	double defaultDialGraphWidth=191;  // default dial graph width for calculation
	double defaultDialGraphHeight=115;  // default dial graph height for calculation
	double dialGraphWidth=191;  
	double dialGraphHeight=115;
	double dialGraphWidthTo1024PxInPercent=defaultDialGraphWidth/1024;
	double dialGraphHeightToDefaultWidthInPercent=defaultDialGraphHeight/defaultDialGraphWidth;
	double defaultGauageOuterRadius=65; // default dial graph width for calculation
	double defaultGaugeXPos=90; // default dial graph Gauge X position for calculation
	double defaultGaugeYPos=93; // default dial graph Gauge Y position for calculation 
	String gauageOuterRadius="62";
	String gaugeXPos="90";
	String gaugeYPos="93";
	if(dialGraphtests.size()>0)
	{
		dialGraphWidth=screenWidthInDouble*dialGraphWidthTo1024PxInPercent;
		dialGraphWidth=MathUtils.round(dialGraphWidth,0);
		dialGraphHeight=dialGraphWidth*dialGraphHeightToDefaultWidthInPercent;
		dialGraphHeight=MathUtils.round(dialGraphHeight,0);
		double gauageOutRadiusToDefaultWidthInPercent=defaultGauageOuterRadius/defaultDialGraphWidth;
		double gauageOuterRadiusInDouble=dialGraphWidth*gauageOutRadiusToDefaultWidthInPercent;
		gauageOuterRadius=erutils.round(gauageOuterRadiusInDouble,0);
		double gauageXPosToDefaultWidthInPercent=defaultGaugeXPos/defaultDialGraphWidth;
		double gauageYPosToDefaultHeightInPercent=defaultGaugeYPos/defaultDialGraphHeight;
		double gaugeXPosInDouble=dialGraphWidth*gauageXPosToDefaultWidthInPercent;
		gaugeXPos=erutils.round(gaugeXPosInDouble,0);
		double gaugeYPosInDouble=dialGraphHeight*gauageYPosToDefaultHeightInPercent;
		gaugeYPos=erutils.round(gaugeYPosInDouble,0);
	}
	double defaultLedGraphWidth=140;  // default led graph width for calculation
	double defaultLedGraphHeight=85;  // default led graph height for calculation
	double ledGraphWidth=140;  
	double ledGraphHeight=95;
	double ledGraphWidthTo1024PxInPercent=defaultLedGraphWidth/1024;
	double ledGraphHeightToDefaultWidthInPercent=defaultLedGraphHeight/defaultLedGraphWidth;
	double defaultLedGap=1; // default led graph gap for calculation
	double defaultLedSize=1; // default led graph size for calculation
	String ledGap="1";
	String ledSize="1";
	ledGraphWidth=screenWidthInDouble*ledGraphWidthTo1024PxInPercent;
	ledGraphWidth=MathUtils.round(ledGraphWidth,0);
	ledGraphHeight=dialGraphWidth*ledGraphHeightToDefaultWidthInPercent;
	ledGraphHeight=MathUtils.round(ledGraphHeight,0);
	double ledGapToDefaultWidthInPercent=defaultLedGap/defaultLedGraphWidth;
	double ledGapInDouble=ledGraphWidth*ledGapToDefaultWidthInPercent;
	ledGap=erutils.round(ledGapInDouble,0);
	double ledSizeToDefaultWidthInPercent=defaultLedSize/defaultLedGraphWidth;
	double ledSizeInDouble=ledGraphWidth*ledSizeToDefaultWidthInPercent;
	ledSize=erutils.round(ledSizeInDouble,0);
	double defaultChartLeftMargin=42;
	double defaultChartRightMargin=25;
	String chartLeftMargin="42";
	String chartRightMargin="25";
	double chartLeftMarginToDefaultWidthInPercent=defaultChartLeftMargin/defaultLedGraphWidth;
	double ledLeftMarginInDouble=ledGraphWidth*chartLeftMarginToDefaultWidthInPercent;
	chartLeftMargin=erutils.round(ledLeftMarginInDouble,0);
	double chartRightMarginToDefaultWidthInPercent=defaultChartRightMargin/defaultLedGraphWidth;
	double ledRightMarginInDouble=ledGraphWidth*chartRightMarginToDefaultWidthInPercent;
	chartRightMargin=erutils.round(ledRightMarginInDouble,0);
	double pieChartDivHeight = dialGraphHeight+30;
%>

<img src="/final/monitor/eg_images/spacer.gif" border="0" style="display:none" onload="javascript:loadInterfaceDivs()"/>

<div class="InnerBodyBg" style="display:block;padding:0px;margin:0px;width:100%;border:0px solid red;">
	
	<div class="linesquare white_bg" style="margin:0px;padding:0px;visibility:visible:display:block;valign:top;" >
		<div id="innerDiv" class="pieChartDiv" style="overflow-x:auto;width:100%;height:<%=pieChartDivHeight%>;border:0px solid black;display:block;">

		<div id="dialDiv" style="visibility:visible;display-inline:block;border:0px solid red;valign:top;padding-top:0px;">
<%
//-------------------------------for jvm chart------------------------------------------------------------------

	if(iniEntries != null && iniEntries.length() > 0)
	{
		String isDialNeeded=iniobj.getValue("Dashboard_Settings","UseDial");
		String isThresholdNeeded=iniobj.getValue("Dashboard_Settings","ApplyThreshold");
		StringTokenizer st=new StringTokenizer(iniEntries,",");
		int dialChartCount=0;
		int i=0;
		ArrayList dialmeasuresNAList = new ArrayList();
		while(st.hasMoreTokens())
		{
			String testWithMeasure=st.nextToken();
			String d_test=testWithMeasure.substring(0,testWithMeasure.indexOf(":"));
			String d_measure=testWithMeasure.substring(testWithMeasure.indexOf(":")+1);
			if(enabledTests!=null && !enabledTests.contains(d_test))
				continue;

			String msmtHost=(String)allMsmtHosts.get(d_test);
			String measureValue="";
			String measureForDB=dbInfo.getColumnForMeasure(d_test,d_measure);
			String dial_measureMapping=iniobj.getValue("Dashboard_Dial_mapping",testWithMeasure);

			if(dial_measureMapping==null || dial_measureMapping.trim().equals(""))
				dial_measureMapping=mappingInfo.getMeasureDescription(d_test,d_measure);

			String tooltip=dial_measureMapping;
			String unit=tablesInfo.getUnitForMeasure(d_test,d_measure);
			if((unit!=null) && !(unit.equalsIgnoreCase("percent") || unit.equalsIgnoreCase("percentage") || unit.equals("%")))
				continue;
			if((unit!=null) && (unit.equalsIgnoreCase("percent") || unit.equalsIgnoreCase("percentage")))
				unit="%";
			long stime=System.currentTimeMillis();
			Vector testInfos=dashboardDAO.getDescriptorsForTest(compName,compType,d_test,tab);
			long ltime=System.currentTimeMillis();
			String key=compName+":"+portNo+":"+d_test+":"+msmtHost;
			String oneMsmtTime=dashboardDAO.getMeasureLastMsmtTime(key);
			
			if(msmtHost==null)
				msmtHost="";

			boolean isFullView=false;
			Vector infos=(Vector)allTestInfos.get(d_test);
			Vector infosForCutOffFactor = new Vector();
			if(model.isTestHasCutOffFactor(d_test))
			{
				if(infos!=null && !infos.isEmpty())
				{
					for(int d=0;d<infos.size();d++)
					{
						String infoForDial=(String)infos.get(d);
						boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,d_test,msmtHost,infoForDial);
						if(!isTestExceededCutOffFactor)
						{
							if(infosForCutOffFactor!=null && !infosForCutOffFactor.contains(infoForDial))
							{
								infosForCutOffFactor.add(infoForDial);
							}
						}
					}
				}
				if(infosForCutOffFactor!=null && !infosForCutOffFactor.isEmpty())
				{
					infos=infosForCutOffFactor;
				}
			}
			if(infos!=null && !infos.isEmpty() && infos.size()>1)
			{
				isFullView=true;
			}
			String info=fusionChart.getInfoForDial(d_test,d_measure,compType,hostName,portNo,msmtHost,"NULL",sid,isThresholdNeeded);
			if(info!=null && info.indexOf("+")!=-1)
				info=info.substring(info.indexOf("+")+1);
			info=com.egurkha.util.StringUtils.replace(info, "+", "|plus|");

			Vector dialChartAttributes=new Vector();
			dialChartAttributes.add("clickURL='javascript:dialOnclick(&apos;dialUrl"+dialChartCount+"&apos;)'");  // To avoid drilldown url problem in Doublebyte. We have to create one HIDDEN element and the url to be stored there
			dialChartAttributes.add("fillAngle='60'");
			dialChartAttributes.add("majorTMNumber='6'");
			dialChartAttributes.add("majorTMHeight='8'");
			dialChartAttributes.add("majorTMColor='e5e5e5'");
			dialChartAttributes.add("minorTMColor='e5e5e5'");
			dialChartAttributes.add("minorTMHeight='4'");
			dialChartAttributes.add("minorTMNumber='6'");
			dialChartAttributes.add("majorTMThickness='1'");
			dialChartAttributes.add("markerRadius='30'");
			dialChartAttributes.add("showGaugeBorder='0'");
			dialChartAttributes.add("gaugeOuterRadius='"+gauageOuterRadius+"'");
			dialChartAttributes.add("gaugeOriginX='"+gaugeXPos+"'");
			dialChartAttributes.add("gaugeOriginY='"+gaugeYPos+"'");
			dialChartAttributes.add("gaugeInnerRadius='0'");
			dialChartAttributes.add("formatNumberScale='0'");
			dialChartAttributes.add("displayValueDistance='0'");
			dialChartAttributes.add("decimalPrecision='2'");
			dialChartAttributes.add("tickMarkDecimalPrecision='2'");
			dialChartAttributes.add("tickValueDistance='14'");
			dialChartAttributes.add("pivotRadius='6'");
			dialChartAttributes.add("showPivotBorder='1'");
			dialChartAttributes.add("pivotBorderColor='000000'");
			dialChartAttributes.add("pivotBorderThickness='5'");
			dialChartAttributes.add("pivotFillMix='FFFFFF,000000'");
			dialChartAttributes.add("paletteThemeColor='ffffff'");
			dialChartAttributes.add("pivotFillType='linear'");
			dialChartAttributes.add("showToolTip='1'");
			dialChartAttributes.add("chartLeftMargin='0'");
			dialChartAttributes.add("chartRightMargin='0'");
			dialChartAttributes.add("chartBottomMargin='0'");
			dialChartAttributes.add("chartTopMargin='0'");
			dialChartAttributes.add("baseFontColor='000000'");
			dialChartAttributes.add("adjustTM='0'");
			dialChartAttributes.add("borderAlpha='0'");
			dialChartAttributes.add("bgAlpha='_alpha'");
			dialChartAttributes.add("showToolTipShadow='1'");
			dialChartAttributes.add("toolTipBgColor='ffffff'");
			dialChartAttributes.add("toolTipBorderColor='555555'");
			dialChartAttributes.add("exportEnabled='0'");
			dialChartAttributes.add("exportAction='download'");
			dialChartAttributes.add("exportAtClient='0'");
			dialChartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
			String dialXMLData="";
			if(isDialNeeded!=null && isDialNeeded.equalsIgnoreCase("Yes"))
			{
					dialXMLData=fusionChart.getXMLDataForDial(d_test,d_measure,compType,hostName,portNo,msmtHost,"NULL",sid,isThresholdNeeded,dialChartAttributes,"000000",true);
			}
			else if(isDialNeeded!=null && isDialNeeded.equalsIgnoreCase("No"))
			{
				Vector jvmChartAttributes=new Vector();
				jvmChartAttributes.add("clickURL='javascript:dialOnclick(&apos;dialUrl"+dialChartCount+"&apos;)'");
				jvmChartAttributes.add("upperLimit='100'");
				jvmChartAttributes.add("bgColor='99CCFF,FFFFFF'");
				jvmChartAttributes.add("bgAlpha='0,0'");
				jvmChartAttributes.add("showBorder='0'");
				jvmChartAttributes.add("adjustTM='0'");
				jvmChartAttributes.add("lowerLimit='0'");
				jvmChartAttributes.add("decimals='2'");
				jvmChartAttributes.add("showValue='0'");
				jvmChartAttributes.add("majorTMNumber='5'");
				//jvmChartAttributes.add("baseFontSize='8'");
				jvmChartAttributes.add("majorTMColor='000000'");
				jvmChartAttributes.add("majorTMHeight='5'");
				jvmChartAttributes.add("minorTMNumber='2'");
				jvmChartAttributes.add("minorTMColor='000000'");
				jvmChartAttributes.add("minorTMHeight='2'");
				jvmChartAttributes.add("majorTMThickness='1'");
				jvmChartAttributes.add("decimalPrecision='0'");
				jvmChartAttributes.add("ledGap='"+ledGap+"'");
				jvmChartAttributes.add("ledSize='"+ledSize+"'");
				jvmChartAttributes.add("tickValueDistance='2'");
				jvmChartAttributes.add("tickMarkDistance='1'");
				jvmChartAttributes.add("tickValueStep='1'");
				jvmChartAttributes.add("tickValueDecimals='8'");
				jvmChartAttributes.add("chartLeftMargin='"+chartLeftMargin+"'");
				jvmChartAttributes.add("chartRightMargin='"+chartRightMargin+"'");
				jvmChartAttributes.add("chartTopMargin='21'");
				jvmChartAttributes.add("chartBottomMargin='20'");
				jvmChartAttributes.add("baseFontSize ='9'");
				jvmChartAttributes.add("showToolTip='1'");
				jvmChartAttributes.add("baseFontColor  ='000000'");
				jvmChartAttributes.add("annRenderDelay='1.7'");
				jvmChartAttributes.add("exportEnabled='0'");
				jvmChartAttributes.add("exportAction='download'");
				jvmChartAttributes.add("exportAtClient='0'");
				jvmChartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
				dialXMLData=fusionChart.getXMLDataForDial(d_test,d_measure,compType,hostName,portNo,msmtHost,"NULL",sid,isThresholdNeeded,jvmChartAttributes,"000000",true,ledGraphWidth,ledGraphHeight,defaultLedGraphWidth,defaultLedGraphHeight);
			}
			if(dialXMLData !=null && !dialXMLData.equals(""))
			{
				String layerName=dashboardDAO.getLayerForTest(compType,d_test,d_measure);
				String compTypeForAlarm=compType;
				if(layerName!=null && (layerName.equalsIgnoreCase("HOST") || layerName.equalsIgnoreCase("NETWORK") || layerName.equalsIgnoreCase("TCP")))
					compTypeForAlarm="Host_system";

				String measureState=model.getTestMeasureState(compName,compTypeForAlarm,layerName,d_test+"-"+info,d_measure);

				String layerPageUrl=response.encodeURL("/final/monitor/egDashBoardLayers.jsp?")+"qctr=2&fromPage=componentList&host="+EgURLEncoder.encode(compName,"UTF-8")+"&comptype="+compType+"&layer="+layerName+"&site="+site+"&test="+d_test+"-"+info+"&tstate="+measureState+"&msmt_host=";

				String moreDescriptorUrl=response.encodeURL("/final/monitor/EgMoreInfosDial.jsp?")+"hostName="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&test="+d_test+"&measure="+d_measure+"&msmtHost="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&tab="+tab;
%>
			<div style="float:left;border:0px blue solid;padding:0px;" align="center">
				<table border="0" cellspacing="0" cellpadding="4" class="vm  border">
					<tr>
						<td align="center" height="16px" class="eg_75bold jvm_he ader" valign="top" title="<%=tooltip%>(<%=unit%>)"><%=dial_measureMapping%>(<%=unit%>)
<%
				if(isFullView)
				{
%>
							<a class="mouse eg_monlink" onclick="javascript:showMaximizedView('<%=moreDescriptorUrl%>',event,'loadPageForDial');" title="More" ><img  border="0" src="/final/monitor/eg_images/icon-newwindow_o.gif"/></a>
<%
				}
%>
						</td>
					</tr>
					<tr>
						<td align="center">
<%
				if(isDialNeeded!=null && isDialNeeded.equalsIgnoreCase("Yes"))
				{
%>
							<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="<%=dialGraphWidth%>" height="<%=dialGraphHeight%>" id="StackedColumn3D" >
							<param name="movie" value="/final/FusionCharts/swf/AngularGauge.swf" />
							<param name="FlashVars" value="&dataXML=<%=dialXMLData%>&chartWidth=<%=dialGraphWidth%>&chartHeight=<%=dialGraphHeight%>">
							<param name="quality" value="high" />
							<param name="WMode" value="Transparent">
							<embed wmode="transparent" src="/final/FusionCharts/swf/AngularGauge.swf" flashVars="&dataXML=<%=dialXMLData%>" quality="high" width="<%=dialGraphWidth%>" height="<%=dialGraphHeight%>" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
							</object> -->

							<div id="chartAngularGaugeContainer<%=i%>"  style="height:100%;"></div>
							<script type="text/javascript">
								if  ( FusionCharts( "myAngularGaugeChartId<%=i%>" ) )
										FusionCharts( "myAngularGaugeChartId<%=i%>" ).dispose();
								var myChart = new FusionCharts( "/final/FusionCharts/swf/AngularGauge.swf","myAngularGaugeChartId<%=i%>", "<%=dialGraphWidth%>", "<%=dialGraphHeight%>","0","1");
								myChart.setXMLData("<%=dialXMLData%>");
								myChart.setTransparent(true);
								myChart.render("chartAngularGaugeContainer<%=i%>");
							</script>
<%
				} 
				else if(isDialNeeded!=null && isDialNeeded.equalsIgnoreCase("No"))
				{
%>
							<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="<%=ledGraphWidth%>" height="<%=ledGraphHeight%>" id="StackedColumn3D" >
							<param name="movie" value="/final/FusionCharts/swf/VLED.swf" />
							<param name="FlashVars" value="&dataXML=<%=dialXMLData%>&chartWidth=<%=ledGraphWidth%>&chartHeight=<%=ledGraphHeight%>">
							<param name="quality" value="high" />
							<param name="WMode" value="transparent" />
							<embed wmode="transparent" src="/final/FusionCharts/swf/VLED.swf" flashVars="&dataXML=<%=dialXMLData%>" quality="high" width="<%=ledGraphWidth%>" height="<%=ledGraphHeight%>" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
							</object> -->

							<div id="chartVLEDContainer<%=i%>"  style="height:100%;"></div>
							<script type="text/javascript">
								if  ( FusionCharts( "myVLEDChartId<%=i%>" ) )
										FusionCharts( "myVLEDChartId<%=i%>" ).dispose();
								var myChart = new FusionCharts( "/final/FusionCharts/swf/VLED.swf","myVLEDChartId<%=i%>", "<%=ledGraphWidth%>", "<%=ledGraphHeight%>","0","1");
								myChart.setXMLData("<%=dialXMLData%>");
								myChart.setTransparent(true);
								myChart.render("chartVLEDContainer<%=i%>");
							</script>
<%
				}
%>
						</td>
					</tr>
				</table>
				<input type="hidden" id="dialUrl<%=dialChartCount%>" value="<%=layerPageUrl%>"/>
			</div>
<%
				dialChartCount++;
				
			}
			else
			{
				dialmeasuresNAList.add(dial_measureMapping+"#"+unit+"$"+tooltip);
			}
			i++;
		}
		if(dialmeasuresNAList.size()>0)
		{
			if(dialmeasuresNAList.size()==i)
			{
%>	

			<div style="float:left;width:<%=dialGraphWidth%>;border:0px green solid;padding:2px">
				<table border="0" cellspacing="0" cellpadding="0" class="vm  border">
					<tr>
						<td align="center" height="16px"  class="eg_75bold" valign="top" >&nbsp;
						</td>
					</tr>
					<tr>
						<td align="center" valign="middle" style="width:208px" height="115"><span class="eg_75bold" title=""><egui:intnl text="monitor.dashboard.Dial Graph"/></span><br><br>
							<img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"> <br> <egui:intnl text="monitor.dashboard.No Measures Available"/>!
						</td>
					</tr>
				</table>
			</div>
<%
			}
		}
	}
%>
		</div>
	</div>
</div>
<div class="clr" style="height:10px">&nbsp;</div>
<%
	double divHeight=0;
	String areaChartEntries = iniobj.getValue(compType,"Network_NetworkInterfaces_AreaCharts");
	if(areaChartEntries!=null && areaChartEntries.length() > 0)
	{
		StringTokenizer stoken=new StringTokenizer(areaChartEntries,",");
		int chartCount=stoken.countTokens();
		divHeight=250+((chartCount-1)*250);
	}
		double defaultTableWidth=950;
		double tableWidth=920;
		double tableWidth1024PxInPercent=defaultTableWidth/1024;
		tableWidth=screenWidthInDouble*tableWidth1024PxInPercent;
		tableWidth=MathUtils.round(tableWidth,0);
		String tblWidth=Double.toString(tableWidth);


%>
	<div id="secondDiv" style="overflow:hidden;width:100%;border:0px solid orange;display:block;" >
		<div>
 <%
	String interfaceEntries = iniobj.getValue(compType,"Network_NetworkInterfaces");
	if(interfaceEntries!=null && interfaceEntries.length() > 0)
	{
		StringTokenizer stoken=new StringTokenizer(interfaceEntries,",");
		int tokenCount=stoken.countTokens();
		StringBuffer infosToAreaChart=new StringBuffer();
		Map mapData=new HashMap();
		ArrayList units=new ArrayList();
		units.add("-");
		String comparisonTableFullViewURL=response.encodeURL("/final/monitor/egCustomDashboardp.jsp")+"?"+"compName="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&blockType=CiscoComparisionTable&tab=Network";
		StringBuffer measureColumn=new StringBuffer();

		int imgcnt=0;
		int stColPos=1;
		int endColPos=5;
		List headers=new ArrayList();
		headers.add("Interfaces");
		String interface_test="";
		String msmthost="";
		String measuresForDB= "";
		String interfaces_Count=interfaces_Count=iniobj.getValue("Interfaces","MaxInterfaces");
		int defaultCol_Sort=0;
		Vector excluded_infos=new Vector();
		int imgPos=0;
		Vector filtered_infos=new Vector();
		while(stoken.hasMoreTokens())
		{
			String testMeasure=stoken.nextToken();
			interface_test=testMeasure.substring(0,testMeasure.indexOf(":"));
			String interface_measure=testMeasure.substring(testMeasure.indexOf(":")+1);
			String measureForDB=dbInfo.getColumnForMeasure(interface_test,interface_measure);
			msmthost=(String)allMsmtHosts.get(interface_test);
			String excludedInfos=iniobj.getValue("INFOS_TO_BE_OMITTED",testMeasure);
			String iniheader=iniobj.getValue(compType,testMeasure);
			headers.add(iniheader);
			measureColumn.append(measureForDB);
			if(stoken.hasMoreTokens())
				measureColumn.append(",");

			StringTokenizer infos=new StringTokenizer(excludedInfos,",");
			excluded_infos=new Vector();
			if(enabledTests!=null && !enabledTests.contains(interface_test))
				continue;

			while(infos.hasMoreTokens())
			{
				excluded_infos.add("+"+infos.nextToken());
			}

			Vector currentValues=(Vector)dashboardDAO.getCurrentForAllInfos(hostName,portNo,interface_test,measureForDB,msmthost,dbInfo.getColumnForMeasure(interface_test,"Pct_bandwidth_used"),true,interfaces_Count);//newly added
			String tableName = iniobj.getValue("Dashboard_GraphTitle_Mapping",testMeasure);
			String defaultInfo="";
			String unit=tablesInfo.getUnitForMeasure(interface_test,interface_measure);
			units.add(unit);

			if(dbInfo.getColumnForMeasure(interface_test,"Pct_bandwidth_used")!=null && dbInfo.getColumnForMeasure(interface_test,"Pct_bandwidth_used")==measureForDB){
				defaultCol_Sort=imgPos+1;
			}

			if(currentValues!=null && currentValues.size()>0)
			{
				for(int i=0;i<currentValues.size();i=i+2)
				{
					String interfaceInfo=(String)currentValues.get(i);
					String value=(String)currentValues.get(i+1);
					if(!excluded_infos.contains(interfaceInfo))
					{
						filtered_infos.add(interfaceInfo);
						filtered_infos.add(value);
					}
				}
			}
			imgPos++;
		}
		if(filtered_infos!=null && filtered_infos.size()>0)
		{
			for(int i=0;i<filtered_infos.size();i=i+2)
			{
				String interfaceInfo=(String)filtered_infos.get(i);
				String value=(String)filtered_infos.get(i+1);
				if(mapData!=null && mapData.containsKey(interfaceInfo))
				{
					ArrayList existingList=(ArrayList)mapData.get(interfaceInfo);
					existingList.add(value);
					mapData.put(interfaceInfo,existingList);
				}
				else
				{
					ArrayList valueList=new ArrayList();
					valueList.add(value);
					mapData.put(interfaceInfo,valueList);
				}
			}
		}
		comparisonTableFullViewURL+="&test="+interface_test+"&measure="+measureColumn+"&msmtHost="+msmthost+"&interfaces_Count="+interfaces_Count+"&headerList="+headers+"&inilookup=Network_NetworkInterfaces";

%>
			<div class="interfaceTableDiv linesquare" style="margin:0px;padding:0px;valign:top;display:none;" >
				<div class="eg_medium" style="display:block;visibility:visible;height:20px;width:100%;border-top:0px;border-right:0px;border-left:0px;">
					<div class="eg_8bold" style="float:left;padding:2px"><egui:intnl text="monitor.title.Top Interfaces"/></div>

					<div style="text-align:center;padding:2px 10px 2px 4px;float:right"><img src="/final/images/<%=monitor_Skin%>/icon_areachart.png" class="mouse minimize6" title="Graphical View"></div>

					<div style="text-align:center;padding:2px 10px 2px 4px;float:right">
<%
		if(adminPermission==true)
		{
%>
					<a class="close" href="javascript:void(0);" onclick="javascript:showMaximizedView('<%=comparisonTableFullViewURL%>','event','ComparisonTable');"><img src="/final/monitor/eg_images/gray/icon_maximize_div.png" border="0"></a>
<%
		}
		else
		{
%>
					<a class="close" href="javascript:void(0);" onclick="javascript:showMaximizedView('<%=comparisonTableFullViewURL%>','event','ComparisonTable');"><img src="/final/monitor/eg_images/gray/icon_maximize_div.png" border="0"></a>

<%
		}
%>
					</div>
				</div>

				<div class="dataTableDiv div_scroll" style="clear:both;height:120px;">
<%
		if(mapData!=null && !mapData.isEmpty())
		{
%>
					<table cellpadding="4" cellspacing="0" class="" border="0" width="100%" id="InterfaceMouseEvent">
						<thead>
							<tr>
<%
		endColPos=headers.size();
		for(int j=0;j<headers.size();j++)
		{
			String columnTitle=(String)headers.get(j);
			String h_unit=(String)units.get(j);
			if(h_unit.equals("-"))
				h_unit="";
%>
								<th class="layer_headbg" style='<%= ((j==0))?"border-bottom-width:0px;border-right-width:0px;border-left-width:0px;":"border-bottom-width:0px;border-right-width:0px;"%>'>
									<table width="100%" cellpadding="0" cellspacing="0" border="0">
										<tr>
											<td align="center">
<%
			if(columnTitle!=null && columnTitle.equalsIgnoreCase("Interfaces") )
			{
%>
												<a class="eg_monlink" href="" onclick="this.blur();return sortInterfaceTable('rsTable0',<%=j%>,<%=stColPos%>,<%=endColPos%>,'<%=(imgcnt+1)%>','InterfaceMouseEvent'); "><span class="eg_75bold"><egui:intnl text="<%=columnTitle%>"/>  </span></a>
<%
			}
			else
			{
%>
												<a class="eg_monlink" href="" onclick="this.blur();return sortInterfaceTable('rsTable0',<%=j%>,<%=stColPos%>,<%=endColPos%>,'<%=(imgcnt+1)%>','InterfaceMouseEvent'); "><span class="eg_75bold"><egui:intnl text="<%=columnTitle%>"/> (<egui:intnl text="<%=h_unit%>"/>)
												</span></a>
<%
			}
%>
											</td>
											<td align="right" valign="top" style="width:10px;padding-top:2px">
											<img id="imgdd<%=(imgcnt+1)%>" src="/final/monitor/eg_images/arrow_up_black_small.gif" onclick="this.blur();return sortInterfaceTable('rsTable0',<%=j%>,<%=stColPos%>,<%=endColPos%>,'<%=(imgcnt+1)%>','InterfaceMouseEvent'); " style="display:none"/></td>
										</tr>
									</table>
								</th>
<%
			imgcnt++;
		}
%>
							</tr>
						</thead>
						<tbody name="rsTable0" id="rsTable0">
<%
			Iterator itr=mapData.keySet().iterator();
			endColPos=5;
			int j=0;
			while(itr.hasNext())
			{
				String info=(String)itr.next();
				infosToAreaChart.append(info);
				if(itr.hasNext())
					infosToAreaChart.append(",");
				String position="odd";
				if(j%2==0)
				{
					position="even";
				}
				if(j==0)
				{
%>
							<tr  id="selected<%=j%>" >
<%
				}
				else
				{
%>
							<tr id="selected<%=j%>">
<%
				}
%>
								<td valign="top"  align="left" class="" style=""><egui:intnl text="<%=com.egurkha.util.StringUtils.replace(info, "+", "")%>"/></td>
<%
				ArrayList values=(ArrayList)mapData.get(info);
				if(values!=null && values.size()>0)
				{
					for(int i=0;i<values.size();i++)
					{
						String val=(String)values.get(i);
						if(val.startsWith("-"))
							val="-";
						if(i==0)
						{
							String measVal = dbInfo.formatValue(val);
							String img="";
							if(measVal.equals("100"))
							{
								img = "mes_GOOD.gif";
							}
							else
							{
								img="mes_HIGH.gif";
							}
%>
								<td valign="top" align="left" class="" style="">
								<img src="/final/monitor/eg_images/<%=img%>">
								</td>
<%

						}
						else
						{
%>
								<td valign="top" align="left" class="" style=""><%=val%> </td>
<%
						}
					}
				}
%>
							</tr>
						
<%
				j++;
				}
%>
							</tbody>
					</table>

<%

		}
		else
		{
%>
					<table border="0" cellpadding="4" cellspacing="0" width="100%" height="100%" class="eg_whitebg">
						<tr>
							<td align="center" valign="middle" >
								<img src="/final/monitor/eg_images/exclamation-icon.gif"><br><egui:intnl text="monitor.common.No Measures Available" />!
							</td>
						</tr>
					</table>
<%
		}
		String url="/final/monitor/EgInterfaceHelper.jsp?hostName="+compName+"&compType="+compType+"&tab="+tab+"&mappingName=abc&blockType=areaChart&infosToArea="+infosToAreaChart;

%>

				</div>
				<img src="/final/monitor/eg_images/spacer.gif" height="0px" width="0px" border="0px" onload="this.blur();return sortInterfaceTable('rsTable0',<%=defaultCol_Sort%>,<%=stColPos%>,<%=endColPos%>,'<%=defaultCol_Sort+1%>','InterfaceMouseEvent');" style="visibility:hidden;display:none;">


			</div>

			<!-- <div class="clr" style="height:10px">&nbsp;</div> -->

			<div class="bayStackGraphTableDiv linesquare white_bg" style="margin:0px;padding:0px;valign:top;display:block" >
				<div class="eg_medium" style="display:block;visibility:visible;height:20px;width:100%;">
					<div class="eg_8bold" style="float:left;padding:2px"><egui:intnl text="monitor.title.Top Interfaces"/></div>

					<div style="text-align:center;padding:2px 10px 2px 4px;float:right"><img src="/final/images/<%=monitor_Skin%>/icon_table.png" class="mouse minimize7" title="Tabular View"></div>

					<div style="text-align:center;padding:2px 10px 2px 4px;float:right">
						<table cellpadding="0" cellspacing="0"  border="0" width="100%">
							<tr>
								<td class="eg_8bold" align="right" width="89%"><egui:intnl text="monitor.common.TimeLine"/>&nbsp;:&nbsp;</td>
								<td align="left" width="11%">
									<select width="100%" id="timeSelect" name="timeSelect" onchange="javascript:infoOnclick('<%=url%>');">
<%
		String[] dateChoice={"1 hour","3 hours","6 hours","9 hours","12 hours","15 hours","18 hours","24 hours","2 days","3 days","4 days","5 days","6 days","1 week","2 weeks","3 weeks ","4 weeks","1 month"};
		List datelist=Arrays.asList(dateChoice);
		for(int i=0;i<datelist.size();i++)
		{
			String element=(String)datelist.get(i);
			String selected="";
			if(element.equals("1 hour"))
				selected="selected";
%>
										<option value="<%=element%>" <%=selected%>><%=element%></option>
<%
		}
%>
									</select>
								</td>
							</tr>
						</table>
					</div>
				</div>

				<div style="clear:both;display:block;height:180px;valign:top;border:0px solid red" class="bayStackGraphDiv div_scroll white_bg;">
					<div id="graphDivAreaChart">
						<jsp:include page="<%="EgInterfaceHelper.jsp?hostName="+compName+"&compType="+compType+"&tab="+tab+"&blockType=areaChart&screenWidth="+screenWidth+"&screenHeight="+screenHeight+"&infosToArea="+infosToAreaChart%>" />
					</div>
				</div>
			</div>
<%
	}
	if(request.getQueryString()!=null)
	{
		if(session!=null)
		{
			session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&comptype="+request.getParameter("compType")+"&host="+request.getParameter("hostName")+"&tab=Interfaces&graphType=&toDashBoardLayer=true");
			session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
		}
	}
	else
	{
		if(session!=null)
		{
			session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&tab=Interfaces&toDashBoardLayer=true");
			session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
		}
	}
%>
	</div>
</div>
<%
}
catch(Exception e)
{
	e.printStackTrace();
}
%>